# -*- coding: utf-8 -*-
# Generated by Django 1.11 on 2017-10-25 17:46
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="ReferencePaymentBatch",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("filename", models.CharField(db_index=True, max_length=64, verbose_name="filename")),
                ("record_date", models.DateTimeField(db_index=True, verbose_name="record date")),
                ("institution_identifier", models.CharField(max_length=2, verbose_name="institution identifier")),
                ("service_identifier", models.CharField(max_length=9, verbose_name="service identifier")),
                (
                    "currency_identifier",
                    models.CharField(choices=[("1", "EUR")], max_length=3, verbose_name="currency identifier"),
                ),
            ],
            options={
                "verbose_name_plural": "reference payment batches",
                "verbose_name": "reference payment batch",
            },
        ),
        migrations.CreateModel(
            name="ReferencePaymentRecord",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("record_type", models.CharField(max_length=1, verbose_name="record type")),
                ("account_number", models.CharField(db_index=True, max_length=32, verbose_name="account number")),
                ("record_date", models.DateField(db_index=True, verbose_name="record date")),
                (
                    "paid_date",
                    models.DateField(blank=True, db_index=True, default=None, null=True, verbose_name="paid date"),
                ),
                (
                    "archive_identifier",
                    models.CharField(blank=True, db_index=True, default="", max_length=32, verbose_name="archive identifier"),
                ),
                ("remittance_info", models.CharField(db_index=True, max_length=32, verbose_name="remittance info")),
                ("payer_name", models.CharField(db_index=True, max_length=12, verbose_name="payer name")),
                (
                    "currency_identifier",
                    models.CharField(choices=[("1", "EUR")], max_length=1, verbose_name="currency identifier"),
                ),
                (
                    "name_source",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("", "Not Set"),
                            ("A", "From Customer"),
                            ("K", "From Bank Clerk"),
                            ("J", "From Bank System"),
                        ],
                        max_length=1,
                        verbose_name="name source",
                    ),
                ),
                ("amount", models.DecimalField(db_index=True, decimal_places=2, max_digits=10, verbose_name="amount")),
                (
                    "correction_identifier",
                    models.CharField(
                        choices=[("0", "Regular Entry"), ("1", "Correction Entry")],
                        max_length=1,
                        verbose_name="correction identifier",
                    ),
                ),
                (
                    "delivery_method",
                    models.CharField(
                        choices=[("A", "From Customer"), ("K", "From Bank Clerk"), ("J", "From Bank System")],
                        db_index=True,
                        max_length=1,
                        verbose_name="delivery method",
                    ),
                ),
                (
                    "receipt_code",
                    models.CharField(
                        blank=True,
                        choices=[("", ""), ("E", "Separate"), ("P", "Separate/Paper")],
                        db_index=True,
                        max_length=1,
                        verbose_name="receipt code",
                    ),
                ),
                (
                    "batch",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="record_set",
                        to="jbank.ReferencePaymentBatch",
                        verbose_name="batch",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "reference payment records",
                "verbose_name": "reference payment records",
            },
        ),
        migrations.CreateModel(
            name="Statement",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("filename", models.CharField(db_index=True, max_length=64, verbose_name="filename")),
                ("account_number", models.CharField(db_index=True, max_length=32, verbose_name="account number")),
                ("statement_number", models.SmallIntegerField(verbose_name="statement number")),
                ("begin_date", models.DateField(db_index=True, verbose_name="begin date")),
                ("end_date", models.DateField(db_index=True, verbose_name="end date")),
                ("record_date", models.DateTimeField(db_index=True, verbose_name="record date")),
                ("customer_identifier", models.CharField(max_length=32, verbose_name="customer identifier")),
                ("begin_balance_date", models.DateField(verbose_name="begin balance date")),
                ("begin_balance", models.DecimalField(decimal_places=2, max_digits=10, verbose_name="begin balance")),
                ("record_count", models.IntegerField(default=None, null=True, verbose_name="record count")),
                ("currency_code", models.CharField(max_length=3, verbose_name="currency code")),
                ("account_name", models.CharField(blank=True, default="", max_length=32, verbose_name="account name")),
                (
                    "account_limit",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        default=None,
                        max_digits=10,
                        null=True,
                        verbose_name="account limit",
                    ),
                ),
                ("owner_name", models.CharField(max_length=64, verbose_name="owner name")),
                ("contact_info_1", models.CharField(max_length=64, verbose_name="contact info (1)")),
                (
                    "contact_info_2",
                    models.CharField(blank=True, default="", max_length=64, verbose_name="contact info (2)"),
                ),
                (
                    "bank_specific_info_1",
                    models.CharField(blank=True, default="", max_length=32, verbose_name="bank specific info (1)"),
                ),
                ("iban", models.CharField(db_index=True, max_length=32, verbose_name="IBAN")),
                ("bic", models.CharField(db_index=True, max_length=8, verbose_name="BIC")),
            ],
            options={
                "verbose_name_plural": "statements",
                "verbose_name": "statement",
            },
        ),
        migrations.CreateModel(
            name="StatementRecord",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("record_number", models.IntegerField(verbose_name="record number")),
                (
                    "archive_identifier",
                    models.CharField(blank=True, db_index=True, default="", max_length=32, verbose_name="archive identifier"),
                ),
                ("record_date", models.DateField(db_index=True, verbose_name="record date")),
                (
                    "value_date",
                    models.DateField(blank=True, db_index=True, default=None, null=True, verbose_name="value date"),
                ),
                (
                    "paid_date",
                    models.DateField(blank=True, db_index=True, default=None, null=True, verbose_name="paid date"),
                ),
                (
                    "entry_type",
                    models.CharField(
                        choices=[
                            ("1", "Deposit"),
                            ("2", "Withdrawal"),
                            ("3", "Deposit Correction"),
                            ("4", "Withdrawal Correction"),
                        ],
                        db_index=True,
                        max_length=1,
                        verbose_name="entry type",
                    ),
                ),
                (
                    "record_code",
                    models.CharField(
                        choices=[
                            ("700", "Money Transfer (In/Out)"),
                            ("701", "Recurring Payment (In/Out)"),
                            ("702", "Bill Payment (Out)"),
                            ("703", "Payment Terminal Deposit (In)"),
                            ("704", "Bank Draft (In/Out)"),
                            ("705", "Reference Payments (In)"),
                            ("706", "Payment Service (Out)"),
                            ("710", "Deposit (In)"),
                            ("720", "Withdrawal (Out)"),
                            ("721", "Card Payment (Out)"),
                            ("722", "Check (Out)"),
                            ("730", "Bank Fees (Out)"),
                            ("740", "Interests Charged (Out)"),
                            ("750", "Interests Credited (In)"),
                            ("760", "Loan (Out)"),
                            ("761", "Loan Payment (Out)"),
                            ("770", "Foreign Transfer (In/Out)"),
                            ("780", "Zero Balancing (In/Out)"),
                            ("781", "Sweeping (In/Out)"),
                            ("782", "Topping (In/Out)"),
                        ],
                        db_index=True,
                        max_length=3,
                        verbose_name="record type",
                    ),
                ),
                ("record_description", models.CharField(max_length=64, verbose_name="record description")),
                ("amount", models.DecimalField(db_index=True, decimal_places=2, max_digits=10, verbose_name="amount")),
                (
                    "receipt_code",
                    models.CharField(
                        blank=True,
                        choices=[("", ""), ("E", "Separate"), ("P", "Separate/Paper")],
                        db_index=True,
                        max_length=1,
                        verbose_name="receipt code",
                    ),
                ),
                (
                    "delivery_method",
                    models.CharField(
                        choices=[("A", "From Customer"), ("K", "From Bank Clerk"), ("J", "From Bank System")],
                        db_index=True,
                        max_length=1,
                        verbose_name="delivery method",
                    ),
                ),
                ("name", models.CharField(blank=True, db_index=True, max_length=64, verbose_name="name")),
                (
                    "name_source",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("", "Not Set"),
                            ("A", "From Customer"),
                            ("K", "From Bank Clerk"),
                            ("J", "From Bank System"),
                        ],
                        max_length=1,
                        verbose_name="name source",
                    ),
                ),
                (
                    "recipient_account_number",
                    models.CharField(blank=True, db_index=True, max_length=32, verbose_name="recipient account number"),
                ),
                (
                    "recipient_account_number_changed",
                    models.CharField(blank=True, max_length=1, verbose_name="recipient account number changed"),
                ),
                ("remittance_info", models.CharField(db_index=True, max_length=32, verbose_name="remittance info")),
                ("messages", models.TextField(blank=True, default="", verbose_name="messages")),
                ("client_messages", models.TextField(blank=True, default="", verbose_name="client messages")),
                ("bank_messages", models.TextField(blank=True, default="", verbose_name="bank messages")),
                (
                    "statement",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="record_set",
                        to="jbank.Statement",
                        verbose_name="statement",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "statement records",
                "verbose_name": "statement record",
            },
        ),
        migrations.CreateModel(
            name="StatementRecordSepaInfo",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("reference", models.CharField(blank=True, max_length=35, verbose_name="reference")),
                ("iban_account_number", models.CharField(blank=True, max_length=35, verbose_name="IBAN")),
                ("bic_code", models.CharField(blank=True, max_length=35, verbose_name="BIC")),
                (
                    "recipient_name_detail",
                    models.CharField(blank=True, max_length=70, verbose_name="recipient name detail"),
                ),
                ("payer_name_detail", models.CharField(blank=True, max_length=70, verbose_name="payer name detail")),
                ("identifier", models.CharField(blank=True, max_length=35, verbose_name="identifier")),
                ("archive_identifier", models.CharField(blank=True, max_length=35, verbose_name="archive identifier")),
                (
                    "record",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="sepa_info",
                        to="jbank.StatementRecord",
                        verbose_name="record",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "SEPA",
                "verbose_name": "SEPA",
            },
        ),
    ]
