# Generated by Django 3.0.8 on 2020-08-17 22:17

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import jutil.modelfields
import jutil.validators


class Migration(migrations.Migration):

    replaces = [
        ("jbank", "0001_initial"),
        ("jbank", "0002_auto_20171031_0356"),
        ("jbank", "0003_statement_account"),
        ("jbank", "0004_statementfile"),
        ("jbank", "0005_statementfile_created"),
        ("jbank", "0006_auto_20171102_2341"),
        ("jbank", "0007_auto_20171102_2351"),
        ("jbank", "0008_auto_20171103_0007"),
        ("jbank", "0009_auto_20171107_1847"),
        ("jbank", "0010_auto_20171226_1013"),
        ("jbank", "0011_auto_20180126_0851"),
        ("jbank", "0012_auto_20180126_0858"),
        ("jbank", "0013_auto_20180126_0909"),
        ("jbank", "0014_payout_payoutstatus"),
        ("jbank", "0015_auto_20180208_0643"),
        ("jbank", "0016_auto_20180208_0724"),
        ("jbank", "0017_payoutparty_payouts_account"),
        ("jbank", "0018_auto_20180208_1130"),
        ("jbank", "0019_auto_20180209_0437"),
        ("jbank", "0020_payout_due_date"),
        ("jbank", "0021_auto_20180209_0935"),
        ("jbank", "0022_auto_20180411_1814"),
        ("jbank", "0023_auto_20180419_1316"),
        ("jbank", "0024_auto_20180425_1704"),
        ("jbank", "0025_auto_20181101_1430"),
        ("jbank", "0026_auto_20181205_0034"),
        ("jbank", "0027_auto_20190304_1913"),
        ("jbank", "0028_auto_20190327_1830"),
        ("jbank", "0029_auto_20190727_1352"),
        ("jbank", "0030_auto_20190727_1633"),
        ("jbank", "0031_auto_20190727_1639"),
        ("jbank", "0032_auto_20190727_1655"),
        ("jbank", "0033_auto_20190801_2121"),
        ("jbank", "0034_auto_20190815_2059"),
        ("jbank", "0035_auto_20190815_2137"),
        ("jbank", "0036_wsediconnection"),
        ("jbank", "0037_auto_20191127_0132"),
        ("jbank", "0038_auto_20191127_0145"),
        ("jbank", "0039_auto_20191127_0156"),
        ("jbank", "0040_wsediconnection_signing_key_file"),
        ("jbank", "0041_auto_20191127_0559"),
        ("jbank", "0042_wsediconnection_bank_encryption_cert_file"),
        ("jbank", "0043_wsedisoapcall"),
        ("jbank", "0044_auto_20191128_2231"),
        ("jbank", "0045_wsediconnection_receiver_identifier"),
        ("jbank", "0046_auto_20191128_2242"),
        ("jbank", "0047_wsedisoapcall_error"),
        ("jbank", "0048_wsediconnection_soap_endpoint"),
        ("jbank", "0049_wsediconnection_sender_identifier"),
        ("jbank", "0050_remove_wsedisoapcall_payout"),
        ("jbank", "0051_payout_connection"),
        ("jbank", "0052_auto_20191130_1927"),
        ("jbank", "0053_wsediconnection_target_identifier"),
        ("jbank", "0054_wsediconnection_environment"),
        ("jbank", "0055_auto_20191130_2011"),
        ("jbank", "0056_wsediconnection_debug_commands"),
        ("jbank", "0057_wsediconnection_enabled"),
        ("jbank", "0058_auto_20200316_1949"),
        ("jbank", "0059_auto_20200324_0234"),
        ("jbank", "0060_auto_20200325_1906"),
        ("jbank", "0061_auto_20200325_2204"),
        ("jbank", "0062_auto_20200415_2300"),
        ("jbank", "0063_auto_20200608_1827"),
        ("jbank", "0064_auto_20200629_0344"),
        ("jbank", "0065_wsediconnection_bank_root_cert_file"),
        ("jbank", "0066_wsediconnection_pin"),
        ("jbank", "0067_wsediconnection_pki_endpoint"),
        ("jbank", "0068_auto_20200717_2327"),
        ("jbank", "0069_auto_20200717_2333"),
        ("jbank", "0070_wsediconnection_bank_signing_cert_file"),
        ("jbank", "0071_wsediconnection_ca_cert_file"),
    ]

    initial = True

    dependencies = [
        ("jacc", "0005_auto_20171030_1958"),
        ("jacc", "0008_auto_20180121_1705"),
        ("jacc", "0010_auto_20180201_0734"),
        ("jacc", "0006_account_name"),
    ]

    operations = [
        migrations.CreateModel(
            name="ReferencePaymentBatch",
            fields=[
                ("record_date", models.DateTimeField(db_index=True, verbose_name="record date")),
                ("institution_identifier", models.CharField(max_length=2, verbose_name="institution identifier")),
                ("service_identifier", models.CharField(max_length=9, verbose_name="service identifier")),
                (
                    "currency_identifier",
                    models.CharField(choices=[("1", "EUR")], max_length=3, verbose_name="currency identifier"),
                ),
                (
                    "accountentrysourcefile_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        default=None,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="jacc.AccountEntrySourceFile",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "reference payment batches",
                "verbose_name": "reference payment batch",
            },
        ),
        migrations.CreateModel(
            name="Statement",
            fields=[
                ("account_number", models.CharField(db_index=True, max_length=32, verbose_name="account number")),
                ("statement_number", models.SmallIntegerField(verbose_name="statement number")),
                ("begin_date", models.DateField(db_index=True, verbose_name="begin date")),
                ("end_date", models.DateField(db_index=True, verbose_name="end date")),
                ("record_date", models.DateTimeField(db_index=True, verbose_name="record date")),
                ("customer_identifier", models.CharField(max_length=32, verbose_name="customer identifier")),
                ("begin_balance_date", models.DateField(verbose_name="begin balance date")),
                ("begin_balance", models.DecimalField(decimal_places=2, max_digits=10, verbose_name="begin balance")),
                ("record_count", models.IntegerField(default=None, null=True, verbose_name="record count")),
                ("currency_code", models.CharField(max_length=3, verbose_name="currency code")),
                ("account_name", models.CharField(blank=True, default="", max_length=32, verbose_name="account name")),
                (
                    "account_limit",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        default=None,
                        max_digits=10,
                        null=True,
                        verbose_name="account limit",
                    ),
                ),
                ("owner_name", models.CharField(max_length=64, verbose_name="owner name")),
                ("contact_info_1", models.CharField(max_length=64, verbose_name="contact info (1)")),
                (
                    "contact_info_2",
                    models.CharField(blank=True, default="", max_length=64, verbose_name="contact info (2)"),
                ),
                (
                    "bank_specific_info_1",
                    models.CharField(blank=True, default="", max_length=32, verbose_name="bank specific info (1)"),
                ),
                ("iban", models.CharField(db_index=True, max_length=32, verbose_name="IBAN")),
                ("bic", models.CharField(db_index=True, max_length=8, verbose_name="BIC")),
                (
                    "accountentrysourcefile_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        default=None,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="jacc.AccountEntrySourceFile",
                    ),
                ),
                (
                    "account",
                    models.ForeignKey(default=None, on_delete=django.db.models.deletion.CASCADE, related_name="+", to="jacc.Account"),
                ),
            ],
            options={
                "verbose_name_plural": "statements",
                "verbose_name": "statement",
            },
        ),
        migrations.CreateModel(
            name="StatementRecord",
            fields=[
                (
                    "record_number",
                    models.IntegerField(blank=True, default=None, null=True, verbose_name="record number"),
                ),
                (
                    "archive_identifier",
                    jutil.modelfields.SafeCharField(blank=True, db_index=True, default="", max_length=64, verbose_name="archive identifier"),
                ),
                ("record_date", models.DateField(db_index=True, verbose_name="record date")),
                (
                    "value_date",
                    models.DateField(blank=True, db_index=True, default=None, null=True, verbose_name="value date"),
                ),
                (
                    "paid_date",
                    models.DateField(blank=True, db_index=True, default=None, null=True, verbose_name="paid date"),
                ),
                (
                    "entry_type",
                    jutil.modelfields.SafeCharField(
                        choices=[
                            ("1", "Deposit"),
                            ("2", "Withdrawal"),
                            ("3", "Deposit Correction"),
                            ("4", "Withdrawal Correction"),
                        ],
                        db_index=True,
                        max_length=1,
                        verbose_name="entry type",
                    ),
                ),
                (
                    "record_code",
                    jutil.modelfields.SafeCharField(
                        blank=True,
                        choices=[
                            ("700", "Money Transfer (In/Out)"),
                            ("701", "Recurring Payment (In/Out)"),
                            ("702", "Bill Payment (Out)"),
                            ("703", "Payment Terminal Deposit (In)"),
                            ("704", "Bank Draft (In/Out)"),
                            ("705", "Reference Payments (In)"),
                            ("706", "Payment Service (Out)"),
                            ("710", "Deposit (In)"),
                            ("720", "Withdrawal (Out)"),
                            ("721", "Card Payment (Out)"),
                            ("722", "Check (Out)"),
                            ("730", "Bank Fees (Out)"),
                            ("740", "Interests Charged (Out)"),
                            ("750", "Interests Credited (In)"),
                            ("760", "Loan (Out)"),
                            ("761", "Loan Payment (Out)"),
                            ("770", "Foreign Transfer (In/Out)"),
                            ("780", "Zero Balancing (In/Out)"),
                            ("781", "Sweeping (In/Out)"),
                            ("782", "Topping (In/Out)"),
                        ],
                        db_index=True,
                        max_length=4,
                        verbose_name="record type",
                    ),
                ),
                (
                    "record_description",
                    jutil.modelfields.SafeCharField(blank=True, default="", max_length=128, verbose_name="record description"),
                ),
                (
                    "receipt_code",
                    jutil.modelfields.SafeCharField(
                        blank=True,
                        choices=[("", ""), ("E", "Separate"), ("P", "Separate/Paper")],
                        db_index=True,
                        max_length=1,
                        verbose_name="receipt code",
                    ),
                ),
                (
                    "delivery_method",
                    jutil.modelfields.SafeCharField(
                        choices=[("A", "From Customer"), ("K", "From Bank Clerk"), ("J", "From Bank System")],
                        db_index=True,
                        max_length=1,
                        verbose_name="delivery method",
                    ),
                ),
                (
                    "name",
                    jutil.modelfields.SafeCharField(blank=True, db_index=True, max_length=64, verbose_name="name"),
                ),
                (
                    "name_source",
                    jutil.modelfields.SafeCharField(
                        blank=True,
                        choices=[
                            ("", "Not Set"),
                            ("A", "From Customer"),
                            ("K", "From Bank Clerk"),
                            ("J", "From Bank System"),
                        ],
                        max_length=1,
                        verbose_name="name source",
                    ),
                ),
                (
                    "recipient_account_number",
                    jutil.modelfields.SafeCharField(blank=True, db_index=True, max_length=32, verbose_name="recipient account number"),
                ),
                (
                    "recipient_account_number_changed",
                    jutil.modelfields.SafeCharField(blank=True, max_length=1, verbose_name="recipient account number changed"),
                ),
                (
                    "remittance_info",
                    jutil.modelfields.SafeCharField(blank=True, db_index=True, max_length=35, verbose_name="remittance info"),
                ),
                ("messages", jutil.modelfields.SafeTextField(blank=True, default="", verbose_name="messages")),
                (
                    "client_messages",
                    jutil.modelfields.SafeTextField(blank=True, default="", verbose_name="client messages"),
                ),
                (
                    "bank_messages",
                    jutil.modelfields.SafeTextField(blank=True, default="", verbose_name="bank messages"),
                ),
                (
                    "statement",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="record_set",
                        to="jbank.Statement",
                        verbose_name="statement",
                    ),
                ),
                (
                    "accountentry_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        default=None,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="jacc.AccountEntry",
                    ),
                ),
                (
                    "line_number",
                    models.SmallIntegerField(blank=True, default=None, null=True, verbose_name="line number"),
                ),
                (
                    "manually_settled",
                    models.BooleanField(blank=True, db_index=True, default=False, verbose_name="manually settled"),
                ),
                (
                    "family_code",
                    jutil.modelfields.SafeCharField(blank=True, db_index=True, default="", max_length=4, verbose_name="family code"),
                ),
                (
                    "record_domain",
                    jutil.modelfields.SafeCharField(
                        blank=True,
                        choices=[
                            ("PMNT", "Money Transfer (In/Out)"),
                            ("LDAS", "Loan Payment (Out)"),
                            ("CAMT", "Cash Management"),
                            ("ACMT", "Account Management"),
                            ("XTND", "Entended Domain"),
                            ("SECU", "Securities"),
                            ("FORX", "Foreign Exchange"),
                            ("XTND", "Entended Domain"),
                            ("NTAV", "Not Available"),
                        ],
                        db_index=True,
                        max_length=4,
                        verbose_name="record domain",
                    ),
                ),
                (
                    "sub_family_code",
                    jutil.modelfields.SafeCharField(blank=True, db_index=True, default="", max_length=4, verbose_name="sub family code"),
                ),
            ],
            options={
                "verbose_name_plural": "statement records",
                "verbose_name": "statement record",
            },
        ),
        migrations.CreateModel(
            name="StatementRecordSepaInfo",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("reference", jutil.modelfields.SafeCharField(blank=True, max_length=35, verbose_name="reference")),
                (
                    "iban_account_number",
                    jutil.modelfields.SafeCharField(blank=True, max_length=35, verbose_name="IBAN"),
                ),
                ("bic_code", jutil.modelfields.SafeCharField(blank=True, max_length=35, verbose_name="BIC")),
                (
                    "recipient_name_detail",
                    jutil.modelfields.SafeCharField(blank=True, max_length=70, verbose_name="recipient name detail"),
                ),
                (
                    "payer_name_detail",
                    jutil.modelfields.SafeCharField(blank=True, max_length=70, verbose_name="payer name detail"),
                ),
                ("identifier", jutil.modelfields.SafeCharField(blank=True, max_length=35, verbose_name="identifier")),
                (
                    "archive_identifier",
                    jutil.modelfields.SafeCharField(blank=True, max_length=64, verbose_name="archive identifier"),
                ),
                (
                    "record",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="sepa_info",
                        to="jbank.StatementRecord",
                        verbose_name="record",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "SEPA",
                "verbose_name": "SEPA",
            },
        ),
        migrations.CreateModel(
            name="ReferencePaymentRecord",
            fields=[
                ("record_type", jutil.modelfields.SafeCharField(max_length=1, verbose_name="record type")),
                (
                    "account_number",
                    jutil.modelfields.SafeCharField(db_index=True, max_length=32, verbose_name="account number"),
                ),
                ("record_date", models.DateField(db_index=True, verbose_name="record date")),
                (
                    "paid_date",
                    models.DateField(blank=True, db_index=True, default=None, null=True, verbose_name="paid date"),
                ),
                (
                    "archive_identifier",
                    jutil.modelfields.SafeCharField(blank=True, db_index=True, default="", max_length=32, verbose_name="archive identifier"),
                ),
                (
                    "remittance_info",
                    jutil.modelfields.SafeCharField(db_index=True, max_length=32, verbose_name="remittance info"),
                ),
                (
                    "payer_name",
                    jutil.modelfields.SafeCharField(db_index=True, max_length=12, verbose_name="payer name"),
                ),
                (
                    "currency_identifier",
                    jutil.modelfields.SafeCharField(choices=[("1", "EUR")], max_length=1, verbose_name="currency identifier"),
                ),
                (
                    "name_source",
                    jutil.modelfields.SafeCharField(
                        blank=True,
                        choices=[
                            ("", "Not Set"),
                            ("A", "From Customer"),
                            ("K", "From Bank Clerk"),
                            ("J", "From Bank System"),
                        ],
                        max_length=1,
                        verbose_name="name source",
                    ),
                ),
                (
                    "correction_identifier",
                    jutil.modelfields.SafeCharField(
                        choices=[("0", "Regular Entry"), ("1", "Correction Entry")],
                        max_length=1,
                        verbose_name="correction identifier",
                    ),
                ),
                (
                    "delivery_method",
                    jutil.modelfields.SafeCharField(
                        choices=[("A", "From Customer"), ("K", "From Bank Clerk"), ("J", "From Bank System")],
                        db_index=True,
                        max_length=1,
                        verbose_name="delivery method",
                    ),
                ),
                (
                    "receipt_code",
                    jutil.modelfields.SafeCharField(
                        blank=True,
                        choices=[("", ""), ("E", "Separate"), ("P", "Separate/Paper")],
                        db_index=True,
                        max_length=1,
                        verbose_name="receipt code",
                    ),
                ),
                (
                    "batch",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="record_set",
                        to="jbank.ReferencePaymentBatch",
                        verbose_name="batch",
                    ),
                ),
                (
                    "accountentry_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        default=None,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="jacc.AccountEntry",
                    ),
                ),
                ("line_number", models.SmallIntegerField(blank=True, default=0, verbose_name="line number")),
                (
                    "manually_settled",
                    models.BooleanField(blank=True, db_index=True, default=False, verbose_name="manually settled"),
                ),
            ],
            options={
                "verbose_name_plural": "reference payment records",
                "verbose_name": "reference payment records",
            },
        ),
        migrations.CreateModel(
            name="StatementFile",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("file", models.FileField(upload_to="uploads", verbose_name="file")),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "errors",
                    jutil.modelfields.SafeTextField(blank=True, default="", max_length=4086, verbose_name="errors"),
                ),
                (
                    "original_filename",
                    jutil.modelfields.SafeCharField(blank=True, default="", max_length=256, verbose_name="original filename"),
                ),
                (
                    "tag",
                    jutil.modelfields.SafeCharField(blank=True, db_index=True, default="", max_length=64, verbose_name="tag"),
                ),
            ],
            options={
                "verbose_name": "account statement file",
                "verbose_name_plural": "account statement files",
            },
        ),
        migrations.CreateModel(
            name="ReferencePaymentBatchFile",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                ("file", models.FileField(upload_to="uploads", verbose_name="file")),
                (
                    "errors",
                    jutil.modelfields.SafeTextField(blank=True, default="", max_length=4086, verbose_name="errors"),
                ),
                (
                    "original_filename",
                    jutil.modelfields.SafeCharField(blank=True, default="", max_length=256, verbose_name="original filename"),
                ),
                (
                    "tag",
                    jutil.modelfields.SafeCharField(blank=True, db_index=True, default="", max_length=64, verbose_name="tag"),
                ),
            ],
            options={
                "verbose_name": "reference payment batch file",
                "verbose_name_plural": "reference payment batch files",
            },
        ),
        migrations.AddField(
            model_name="statement",
            name="file",
            field=models.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="jbank.StatementFile",
            ),
        ),
        migrations.AddField(
            model_name="referencepaymentbatch",
            name="file",
            field=models.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="jbank.ReferencePaymentBatchFile",
            ),
        ),
        migrations.AlterField(
            model_name="statement",
            name="account",
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name="+", to="jacc.Account"),
        ),
        migrations.CreateModel(
            name="Payout",
            fields=[
                (
                    "accountentry_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="jacc.AccountEntry",
                    ),
                ),
                ("messages", models.TextField(blank=True, verbose_name="recipient messages")),
                (
                    "msg_id",
                    models.CharField(blank=True, db_index=True, editable=False, max_length=64, verbose_name="message id"),
                ),
                (
                    "file_name",
                    models.CharField(blank=True, db_index=True, editable=False, max_length=255, verbose_name="file name"),
                ),
                (
                    "paid_date",
                    models.DateTimeField(blank=True, db_index=True, default=None, null=True, verbose_name="paid date"),
                ),
                (
                    "state",
                    models.CharField(
                        blank=True,
                        choices=[("W", "waiting"), ("P", "paid"), ("C", "canceled"), ("E", "error")],
                        db_index=True,
                        default="W",
                        max_length=1,
                        verbose_name="state",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "payouts",
                "verbose_name": "payout",
            },
            bases=("jacc.accountentry",),
        ),
        migrations.CreateModel(
            name="Refund",
            fields=[
                (
                    "payout_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="jbank.Payout",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "refunds",
                "verbose_name": "refund",
            },
            bases=("jbank.payout",),
        ),
        migrations.CreateModel(
            name="PayoutParty",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", jutil.modelfields.SafeCharField(db_index=True, max_length=128, verbose_name="name")),
                (
                    "account_number",
                    jutil.modelfields.SafeCharField(
                        db_index=True,
                        max_length=35,
                        validators=[jutil.validators.iban_validator],
                        verbose_name="account number",
                    ),
                ),
                ("bic", jutil.modelfields.SafeCharField(blank=True, db_index=True, max_length=16, verbose_name="BIC")),
                (
                    "org_id",
                    jutil.modelfields.SafeCharField(blank=True, db_index=True, default="", max_length=32, verbose_name="organization id"),
                ),
                ("address", jutil.modelfields.SafeTextField(blank=True, default="", verbose_name="address")),
                (
                    "country_code",
                    jutil.modelfields.SafeCharField(blank=True, db_index=True, default="FI", max_length=2, verbose_name="country code"),
                ),
                (
                    "payouts_account",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="jacc.Account",
                        verbose_name="payouts account",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "payout parties",
                "verbose_name": "payout party",
            },
        ),
        migrations.AddField(
            model_name="payout",
            name="payer",
            field=models.ForeignKey(
                default=None,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="jbank.PayoutParty",
                verbose_name="payer",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="payout",
            name="recipient",
            field=models.ForeignKey(
                default=None,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="jbank.PayoutParty",
                verbose_name="recipient",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="payout",
            name="file_reference",
            field=jutil.modelfields.SafeCharField(blank=True, db_index=True, editable=False, max_length=255, verbose_name="file reference"),
        ),
        migrations.AddField(
            model_name="payout",
            name="due_date",
            field=models.DateField(blank=True, db_index=True, default=None, null=True, verbose_name="due date"),
        ),
        migrations.AlterField(
            model_name="referencepaymentbatch",
            name="service_identifier",
            field=models.CharField(blank=True, max_length=9, verbose_name="service identifier"),
        ),
        migrations.AlterField(
            model_name="payout",
            name="messages",
            field=models.TextField(verbose_name="recipient messages"),
        ),
        migrations.AddField(
            model_name="payout",
            name="full_path",
            field=jutil.modelfields.SafeTextField(blank=True, editable=False, verbose_name="full path"),
        ),
        migrations.AlterField(
            model_name="payout",
            name="state",
            field=models.CharField(
                blank=True,
                choices=[
                    ("W", "waiting processing"),
                    ("U", "waiting upload"),
                    ("D", "uploaded"),
                    ("P", "paid"),
                    ("C", "canceled"),
                    ("E", "error"),
                ],
                db_index=True,
                default="W",
                max_length=1,
                verbose_name="state",
            ),
        ),
        migrations.AddField(
            model_name="payout",
            name="reference",
            field=jutil.modelfields.SafeCharField(blank=True, default="", max_length=32, verbose_name="recipient reference"),
        ),
        migrations.AlterField(
            model_name="payout",
            name="messages",
            field=models.TextField(blank=True, default="", verbose_name="recipient messages"),
        ),
        migrations.AlterField(
            model_name="referencepaymentbatch",
            name="institution_identifier",
            field=models.CharField(blank=True, max_length=2, verbose_name="institution identifier"),
        ),
        migrations.CreateModel(
            name="CurrencyExchange",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("record_date", models.DateField(db_index=True, verbose_name="record date")),
                ("source_currency", models.CharField(blank=True, max_length=3, verbose_name="source currency")),
                ("target_currency", models.CharField(blank=True, max_length=3, verbose_name="target currency")),
                ("unit_currency", models.CharField(blank=True, max_length=3, verbose_name="unit currency")),
                (
                    "exchange_rate",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        default=None,
                        max_digits=12,
                        null=True,
                        verbose_name="exchange rate",
                    ),
                ),
            ],
            options={
                "verbose_name": "currency exchange",
                "verbose_name_plural": "currency exchanges",
            },
        ),
        migrations.CreateModel(
            name="StatementRecordDetail",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "batch_identifier",
                    jutil.modelfields.SafeCharField(blank=True, db_index=True, default="", max_length=64, verbose_name="batch message id"),
                ),
                (
                    "amount",
                    models.DecimalField(
                        blank=True,
                        db_index=True,
                        decimal_places=2,
                        default=None,
                        max_digits=10,
                        null=True,
                        verbose_name="amount",
                    ),
                ),
                ("currency_code", jutil.modelfields.SafeCharField(max_length=3, verbose_name="currency code")),
                (
                    "instructed_amount",
                    models.DecimalField(
                        blank=True,
                        db_index=True,
                        decimal_places=2,
                        default=None,
                        max_digits=10,
                        null=True,
                        verbose_name="instructed amount",
                    ),
                ),
                (
                    "archive_identifier",
                    jutil.modelfields.SafeCharField(blank=True, max_length=64, verbose_name="archive identifier"),
                ),
                (
                    "end_to_end_identifier",
                    jutil.modelfields.SafeCharField(blank=True, max_length=64, verbose_name="end-to-end identifier"),
                ),
                (
                    "creditor_name",
                    jutil.modelfields.SafeCharField(blank=True, max_length=128, verbose_name="creditor name"),
                ),
                (
                    "creditor_account",
                    jutil.modelfields.SafeCharField(blank=True, max_length=35, verbose_name="creditor account"),
                ),
                (
                    "debtor_name",
                    jutil.modelfields.SafeCharField(blank=True, max_length=128, verbose_name="debtor name"),
                ),
                (
                    "ultimate_debtor_name",
                    jutil.modelfields.SafeCharField(blank=True, max_length=128, verbose_name="ultimate debtor name"),
                ),
                (
                    "unstructured_remittance_info",
                    jutil.modelfields.SafeCharField(blank=True, max_length=2048, verbose_name="unstructured remittance info"),
                ),
                (
                    "paid_date",
                    models.DateTimeField(blank=True, db_index=True, default=None, null=True, verbose_name="paid date"),
                ),
                (
                    "exchange",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="recorddetail_set",
                        to="jbank.CurrencyExchange",
                        verbose_name="currency exchange",
                    ),
                ),
                (
                    "record",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="detail_set",
                        to="jbank.StatementRecord",
                        verbose_name="record",
                    ),
                ),
            ],
        ),
        migrations.AlterField(
            model_name="statement",
            name="bank_specific_info_1",
            field=models.CharField(blank=True, default="", max_length=1024, verbose_name="bank specific info (1)"),
        ),
        migrations.AlterField(
            model_name="statement",
            name="contact_info_1",
            field=models.CharField(blank=True, default="", max_length=64, verbose_name="contact info (1)"),
        ),
        migrations.AlterField(
            model_name="statement",
            name="customer_identifier",
            field=models.CharField(blank=True, default="", max_length=64, verbose_name="customer identifier"),
        ),
        migrations.AlterField(
            model_name="statement",
            name="statement_number",
            field=models.SmallIntegerField(db_index=True, verbose_name="statement number"),
        ),
        migrations.CreateModel(
            name="CurrencyExchangeSource",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", jutil.modelfields.SafeCharField(max_length=64, verbose_name="name")),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
            ],
            options={
                "verbose_name": "currency exchange source",
                "verbose_name_plural": "currency exchange sources",
            },
        ),
        migrations.AddField(
            model_name="currencyexchange",
            name="source",
            field=models.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="jbank.CurrencyExchangeSource",
                verbose_name="currency exchange source",
            ),
        ),
        migrations.AlterField(
            model_name="currencyexchange",
            name="exchange_rate",
            field=models.DecimalField(blank=True, decimal_places=6, default=None, max_digits=12, null=True, verbose_name="exchange rate"),
        ),
        migrations.CreateModel(
            name="WsEdiConnection",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "signing_cert_file",
                    models.FileField(blank=True, upload_to="certs", verbose_name="signing certificate file"),
                ),
                ("signing_key_file", models.FileField(blank=True, upload_to="certs", verbose_name="signing key file")),
                (
                    "encryption_cert_file",
                    models.FileField(blank=True, upload_to="certs", verbose_name="encryption certificate file"),
                ),
                (
                    "encryption_key_file",
                    models.FileField(blank=True, upload_to="certs", verbose_name="encryption key file"),
                ),
                (
                    "bank_encryption_cert_file",
                    models.FileField(blank=True, upload_to="certs", verbose_name="bank encryption cert file"),
                ),
                (
                    "receiver_identifier",
                    jutil.modelfields.SafeCharField(max_length=32, verbose_name="receiver identifier"),
                ),
                ("soap_endpoint", models.URLField(verbose_name="EDI endpoint")),
                ("sender_identifier", jutil.modelfields.SafeCharField(max_length=32, verbose_name="sender identifier")),
                ("target_identifier", jutil.modelfields.SafeCharField(max_length=32, verbose_name="target identifier")),
                (
                    "environment",
                    jutil.modelfields.SafeCharField(default="PRODUCTION", max_length=32, verbose_name="environment"),
                ),
                ("name", jutil.modelfields.SafeCharField(max_length=64, verbose_name="name")),
                (
                    "debug_commands",
                    jutil.modelfields.SafeTextField(blank=True, help_text="wsedi.connection.debug.commands.help.text", verbose_name="debug commands"),
                ),
                ("enabled", models.BooleanField(blank=True, default=True, verbose_name="enabled")),
                (
                    "bank_root_cert_file",
                    models.FileField(blank=True, upload_to="certs", verbose_name="bank root certificate file"),
                ),
                ("pin", jutil.modelfields.SafeCharField(blank=True, default="", max_length=64, verbose_name="PIN")),
                ("pki_endpoint", models.URLField(blank=True, default="", verbose_name="PKI endpoint")),
                (
                    "bank_signing_cert_file",
                    models.FileField(blank=True, upload_to="certs", verbose_name="bank signing cert file"),
                ),
                ("ca_cert_file", models.FileField(blank=True, upload_to="certs", verbose_name="CA certificate file")),
            ],
            options={
                "verbose_name": "WS-EDI connection",
                "verbose_name_plural": "WS-EDI connections",
            },
        ),
        migrations.AddField(
            model_name="payout",
            name="connection",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to="jbank.WsEdiConnection",
                verbose_name="WS-EDI connection",
            ),
        ),
        migrations.AlterField(
            model_name="statement",
            name="bic",
            field=models.CharField(db_index=True, max_length=11, verbose_name="BIC"),
        ),
        migrations.AlterField(
            model_name="statement",
            name="begin_balance_date",
            field=models.DateField(blank=True, default=None, null=True, verbose_name="begin balance date"),
        ),
        migrations.AlterField(
            model_name="currencyexchange",
            name="source_currency",
            field=jutil.modelfields.SafeCharField(blank=True, max_length=3, verbose_name="source currency"),
        ),
        migrations.AlterField(
            model_name="currencyexchange",
            name="target_currency",
            field=jutil.modelfields.SafeCharField(blank=True, max_length=3, verbose_name="target currency"),
        ),
        migrations.AlterField(
            model_name="currencyexchange",
            name="unit_currency",
            field=jutil.modelfields.SafeCharField(blank=True, max_length=3, verbose_name="unit currency"),
        ),
        migrations.AlterField(
            model_name="payout",
            name="file_name",
            field=jutil.modelfields.SafeCharField(blank=True, db_index=True, editable=False, max_length=255, verbose_name="file name"),
        ),
        migrations.AlterField(
            model_name="payout",
            name="messages",
            field=jutil.modelfields.SafeTextField(blank=True, default="", verbose_name="recipient messages"),
        ),
        migrations.AlterField(
            model_name="payout",
            name="msg_id",
            field=jutil.modelfields.SafeCharField(blank=True, db_index=True, editable=False, max_length=64, verbose_name="message id"),
        ),
        migrations.AlterField(
            model_name="payout",
            name="state",
            field=jutil.modelfields.SafeCharField(
                blank=True,
                choices=[
                    ("W", "waiting processing"),
                    ("U", "waiting upload"),
                    ("D", "uploaded"),
                    ("P", "paid"),
                    ("C", "canceled"),
                    ("E", "error"),
                ],
                db_index=True,
                default="W",
                max_length=1,
                verbose_name="state",
            ),
        ),
        migrations.CreateModel(
            name="PayoutStatus",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "file_name",
                    jutil.modelfields.SafeCharField(blank=True, db_index=True, editable=False, max_length=128, verbose_name="file name"),
                ),
                (
                    "msg_id",
                    jutil.modelfields.SafeCharField(blank=True, db_index=True, max_length=64, verbose_name="message id"),
                ),
                (
                    "original_msg_id",
                    jutil.modelfields.SafeCharField(blank=True, db_index=True, max_length=64, verbose_name="original message id"),
                ),
                (
                    "group_status",
                    jutil.modelfields.SafeCharField(blank=True, db_index=True, max_length=8, verbose_name="group status"),
                ),
                (
                    "status_reason",
                    jutil.modelfields.SafeCharField(blank=True, max_length=255, verbose_name="status reason"),
                ),
                (
                    "payout",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="payoutstatus_set",
                        to="jbank.Payout",
                        verbose_name="payout",
                    ),
                ),
                (
                    "response_code",
                    jutil.modelfields.SafeCharField(blank=True, db_index=True, max_length=4, verbose_name="response code"),
                ),
                (
                    "response_text",
                    jutil.modelfields.SafeCharField(blank=True, max_length=128, verbose_name="response text"),
                ),
                (
                    "file_path",
                    jutil.modelfields.SafeCharField(blank=True, db_index=True, editable=False, max_length=255, verbose_name="file path"),
                ),
            ],
            options={
                "verbose_name": "payout status",
                "verbose_name_plural": "payout statuses",
            },
        ),
        migrations.AlterField(
            model_name="referencepaymentbatch",
            name="currency_identifier",
            field=jutil.modelfields.SafeCharField(choices=[("1", "EUR")], max_length=3, verbose_name="currency identifier"),
        ),
        migrations.AlterField(
            model_name="referencepaymentbatch",
            name="institution_identifier",
            field=jutil.modelfields.SafeCharField(blank=True, max_length=2, verbose_name="institution identifier"),
        ),
        migrations.AlterField(
            model_name="referencepaymentbatch",
            name="service_identifier",
            field=jutil.modelfields.SafeCharField(blank=True, max_length=9, verbose_name="service identifier"),
        ),
        migrations.AlterField(
            model_name="statement",
            name="account_name",
            field=jutil.modelfields.SafeCharField(blank=True, default="", max_length=32, verbose_name="account name"),
        ),
        migrations.AlterField(
            model_name="statement",
            name="account_number",
            field=jutil.modelfields.SafeCharField(db_index=True, max_length=32, verbose_name="account number"),
        ),
        migrations.AlterField(
            model_name="statement",
            name="bank_specific_info_1",
            field=jutil.modelfields.SafeCharField(blank=True, default="", max_length=1024, verbose_name="bank specific info (1)"),
        ),
        migrations.AlterField(
            model_name="statement",
            name="bic",
            field=jutil.modelfields.SafeCharField(db_index=True, max_length=11, verbose_name="BIC"),
        ),
        migrations.AlterField(
            model_name="statement",
            name="contact_info_1",
            field=jutil.modelfields.SafeCharField(blank=True, default="", max_length=64, verbose_name="contact info (1)"),
        ),
        migrations.AlterField(
            model_name="statement",
            name="contact_info_2",
            field=jutil.modelfields.SafeCharField(blank=True, default="", max_length=64, verbose_name="contact info (2)"),
        ),
        migrations.AlterField(
            model_name="statement",
            name="currency_code",
            field=jutil.modelfields.SafeCharField(max_length=3, verbose_name="currency code"),
        ),
        migrations.AlterField(
            model_name="statement",
            name="customer_identifier",
            field=jutil.modelfields.SafeCharField(blank=True, default="", max_length=64, verbose_name="customer identifier"),
        ),
        migrations.AlterField(
            model_name="statement",
            name="iban",
            field=jutil.modelfields.SafeCharField(db_index=True, max_length=32, verbose_name="IBAN"),
        ),
        migrations.AlterField(
            model_name="statement",
            name="owner_name",
            field=jutil.modelfields.SafeCharField(max_length=64, verbose_name="owner name"),
        ),
        migrations.AddField(
            model_name="statement",
            name="statement_identifier",
            field=jutil.modelfields.SafeCharField(blank=True, db_index=True, default="", max_length=48, verbose_name="statement identifier"),
        ),
        migrations.CreateModel(
            name="StatementRecordRemittanceInfo",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "additional_info",
                    jutil.modelfields.SafeCharField(blank=True, db_index=True, max_length=256, verbose_name="additional remittance info"),
                ),
                (
                    "amount",
                    models.DecimalField(blank=True, decimal_places=2, default=None, max_digits=10, null=True, verbose_name="amount"),
                ),
                (
                    "currency_code",
                    jutil.modelfields.SafeCharField(blank=True, max_length=3, verbose_name="currency code"),
                ),
                (
                    "reference",
                    jutil.modelfields.SafeCharField(blank=True, db_index=True, max_length=35, verbose_name="reference"),
                ),
                (
                    "detail",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="remittanceinfo_set",
                        to="jbank.StatementRecordDetail",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="WsEdiSoapCall",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "command",
                    jutil.modelfields.SafeCharField(blank=True, db_index=True, max_length=64, verbose_name="command"),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "executed",
                    models.DateTimeField(blank=True, db_index=True, default=None, editable=False, null=True, verbose_name="executed"),
                ),
                (
                    "connection",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="jbank.WsEdiConnection",
                        verbose_name="WS-EDI connection",
                    ),
                ),
                ("error", jutil.modelfields.SafeTextField(blank=True, verbose_name="error")),
            ],
            options={
                "verbose_name": "WS-EDI SOAP call",
                "verbose_name_plural": "WS-EDI SOAP calls",
            },
        ),
    ]
