# Contributing

## New Features

Contributions are what make the open source community such an amazing place to
learn, inspire, and create. Any contributions you make are greatly appreciated.

If you have a suggestion that would make this better, please fork the repo and
create a pull request. You can also simply open an issue with the tag "enhancement".
Don't forget to give the project a star! Thanks again!

1. Fork the repository
2. Create your Feature Branch (``git checkout -b feature/AmazingFeature``)
3. Commit your Changes (``git commit -m 'Add some AmazingFeature'``)
4. Push to the Branch (``git push origin feature/AmazingFeature``)
5. Open a Pull Request

## Bug Reports

1. Create an issue with the tag "bug" with a descriptive title stating the issue succinctly.
2. Fill out the issue template with the information requested.

If you have any proposed changes related to a bug, if an Issue has not been created please
complete the above instructions.
The next steps are similar to the steps needed to create a feature pull request.

### Submitting a Fix

1. Fork the repository
2. Create your Bugfix Branch (``git checkout -b bugfix/Issue#``)
3. Commit your Changes (``git commit -m '🐛: Fix Issue#'``)
4. Push to the Branch (``git push origin bugfix/Issue#``)
5. Open a Pull Request

## Commit Signing

To submit your commits to the OZI repository you must sign off that you have the right to
do so with your submission. For OZI this means you agree to the following:
```
Developer Certificate of Origin
Version 1.1

Copyright (C) 2004, 2006 The Linux Foundation and its contributors.

Everyone is permitted to copy and distribute verbatim copies of this
license document, but changing it is not allowed.


Developer's Certificate of Origin 1.1

By making a contribution to this project, I certify that:

(a) The contribution was created in whole or in part by me and I
    have the right to submit it under the open source license
    indicated in the file; or

(b) The contribution is based upon previous work that, to the best
    of my knowledge, is covered under an appropriate open source
    license and I have the right under that license to submit that
    work with modifications, whether created in whole or in part
    by me, under the same open source license (unless I am
    permitted to submit under a different license), as indicated
    in the file; or

(c) The contribution was provided directly to me by some other
    person who certified (a), (b) or (c) and I have not modified
    it.

(d) I understand and agree that this project and the contribution
    are public and that a record of the contribution (including all
    personal information I submit with it, including my sign-off) is
    maintained indefinitely and may be redistributed consistent with
    this project or the open source license(s) involved.
```
