# Datasets

To use `ROMS-Tools`, the user is required to download the following datasets:


| **Dataset** | **Supported Versions** | **Required Fields** | **Field Description**                                                      | **Available at**                                                                 | **Required For**    |
|-------------|------------------------|---------------------|---------------------------------------------------------------------------|----------------------------------------------------------------------------------|---------------------|
| SRTM15        | V2.6   | `lat`             | Latitude (degrees north)                                     | [USCD SRTM15+ Product](https://topex.ucsd.edu/WWW_html/srtm15_plus.html)                             | Grid (Topography)       |
|         |    | `lon`             | Longitude (degrees east)                                     |                              |        |
|         |    | `z`             | Topography                                     |                              |        |
|-------------|------------------------|---------------------|---------------------------------------------------------------------------|----------------------------------------------------------------------------------|---------------------|
| TPXO        | TPXO9v5a (1/6 degree)  | `lat_z`             | Latitude of z nodes (degrees north)                                     | [OSU TPXO Tide Models](https://www.tpxo.net/global)                             | Tidal Forcing       |
|             | TPXO10v2 (1/6 degree)  | `lon_z`             | Longitude of z nodes (degrees east)                                     |                                                                                  |                     |
|             | TPXO10v2a (1/6 degree) | `lat_u`             | Latitude of u nodes (degrees north)                                     |                                                                                  |                     |
|             |                        | `lon_u`             | Longitude of u nodes (degrees east)                                     |                                                                                  |                     |
|             |                        | `lat_v`             | Latitude of v nodes (degrees north)                                     |                                                                                  |                     |
|             |                        | `lon_v`             | Longitude of v nodes (degrees east)                                     |                                                                                  |                     |
|             |                        | `mz`                | Water/land mask for z nodes                                             |                                                                                  |                     |
|             |                        | `mu`                | Water/land mask for u nodes                                             |                                                                                  |                     |
|             |                        | `mv`                | Water/land mask for v nodes                                             |                                                                                  |                     |
|             |                        | `hRe`               | Tidal elevation, real part (m)                                              |                                                                                  |                     |
|             |                        | `hIm`               | Tidal elevation, imaginary part (m)                                         |                                                                                  |                     |
|             |                        | `URe`               | Tidal transport WE, real part (m²/s)                                       |                                                                                  |                     |
|             |                        | `UIm`               | Tidal transport WE, imaginary part (m²/s)                                  |                                                                                  |                     |
|             |                        | `VRe`               | Tidal transport SN, real part (m²/s)                                       |                                                                                  |                     |
|             |                        | `VIm`               | Tidal transport SN, imaginary part (m²/s)                                  |                                                                                  |                     |
|-------------|------------------------|---------------------|---------------------------------------------------------------------------|----------------------------------------------------------------------------------|---------------------|
| ERA5        | -                      | `time`              | Time                                                                      | [Climate Data Store](https://cds.climate.copernicus.eu/datasets/reanalysis-era5-single-levels) | Surface Forcing     |
|             |                        | `latitude`          | Latitude (degrees north)                                                  |                                                                                  |                     |
|             |                        | `longitude`         | Longitude (degrees east)                                                  |                                                                                  |                     |
|             |                        | `u10`               | 10m U wind component (m/s)                                                 |                                                                                  |                     |
|             |                        | `v10`               | 10m V wind component (m/s)                                                 |                                                                                  |                     |
|             |                        | `ssr`               | Surface net short-wave (solar) radiation (W/m²)                            |                                                                                  |                     |
|             |                        | `strd`              | Surface long-wave (thermal) radiation downwards (W/m²)                     |                                                                                  |                     |
|             |                        | `t2m`               | 2m temperature (K)                                                        |                                                                                  |                     |
|             |                        | `d2m`               | 2m dewpoint temperature (K)                                               |                                                                                  |                     |
|             |                        | `tp`                | Total precipitation (m) (converted to mm for use in model)                 |                                                                                  |                     |
|             |                        | `sst`               | Sea surface temperature (K) — used for land masking                        |                                                                                  |                     |
|-------------|------------------------|---------------------|---------------------------------------------------------------------------|----------------------------------------------------------------------------------|---------------------|
| GLORYS      | -                      | `time`              | Time                                                                      | [Mercator Ocean](https://data.marine.copernicus.eu/product/GLOBAL_MULTIYEAR_PHY_001_030/description) | Initial Conditions, Boundary Forcing     |
|             |                        | `latitude`          | Latitude (degrees north)                                                  |                                                                                  |                     |
|             |                        | `longitude`         | Longitude (degrees east)                                                  |                                                                                  |                     |
|             |                        | `depth`         | Depth (m)                                                  |                                                                                  |                     |
|             |                        | `zos`               | Sea surface height (m)                                                    |                                                                                  |                     |
|             |                        | `thetao`            | Temperature (degrees C)                                                   |                                                                                  |                     |
|             |                        | `so`                | Salinity (psu)                                                            |                                                                                  |                     |
|             |                        | `uo`                | Eastward velocity (m/s)                                                   |                                                                                  |                     |
|             |                        | `vo`                | Northward velocity (m/s)                                                  |                                                                                  |                     |
|-------------|------------------------|---------------------|---------------------------------------------------------------------------|----------------------------------------------------------------------------------|---------------------|
| Dai and Trenberth (coastal station volume, monthly series); **Note: downloaded internally**      | 2019                      | `station`              | Station index                                                                      | [NCAR Research Data Archive](https://rda.ucar.edu/datasets/d551000/dataaccess/#) | River Forcing     |
|   |                       | `time`              | Time                                                                      | |      |
|  | -                      | `lat_mou`              | River mouth latitude                                                  |  |      |
|  | -                      | `lon_mou`              | River mouth longitude                                                  |  |      |
|  | -                      | `FLOW`              | Monthly mean volume at station                                                  |  |      |
|  | -                      | `ratio_m2s`              | Ratio of volume between river mouth and station                                                  |  |      |
|  | -                      | `riv_name`              | River name                                                  |  |      |
|  | -                      | `vol_stn` (optional)             | Annual volume at station                                                  |  |      |
