import numpy as np

import pyclesperanto as cle


def test_smooth_labels_2d():

    gpu_input = cle.push(
        np.asarray(
            [
                [1, 1, 1, 1, 2, 2, 2, 2],
                [1, 1, 1, 1, 2, 2, 2, 2],
                [1, 1, 1, 1, 2, 2, 2, 2],
                [1, 1, 1, 2, 2, 2, 2, 2],
                [1, 1, 1, 1, 2, 2, 2, 2],
                [1, 1, 1, 1, 2, 2, 2, 2],
                [1, 1, 1, 1, 1, 2, 2, 2],
                [1, 1, 1, 1, 2, 2, 2, 2],
                [1, 1, 1, 1, 2, 2, 2, 2],
            ]
        )
    )

    gpu_reference = cle.push(
        np.asarray(
            [
                [1, 1, 1, 1, 2, 2, 2, 2],
                [1, 1, 1, 1, 2, 2, 2, 2],
                [1, 1, 1, 1, 2, 2, 2, 2],
                [1, 1, 1, 1, 2, 2, 2, 2],
                [1, 1, 1, 1, 2, 2, 2, 2],
                [1, 1, 1, 1, 2, 2, 2, 2],
                [1, 1, 1, 1, 2, 2, 2, 2],
                [1, 1, 1, 1, 2, 2, 2, 2],
                [1, 1, 1, 1, 2, 2, 2, 2],
            ]
        )
    )

    gpu_output = cle.smooth_labels(gpu_input, radius=3)

    a = cle.pull(gpu_output)
    b = cle.pull(gpu_reference)

    print(a)
    print(b)

    assert np.array_equal(a, b)
