# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetUserGroupResult',
    'AwaitableGetUserGroupResult',
    'get_user_group',
    'get_user_group_output',
]

@pulumi.output_type
class GetUserGroupResult:
    """
    A collection of values returned by getUserGroup.
    """
    def __init__(__self__, description=None, id=None, name=None, roles=None, users=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if roles and not isinstance(roles, list):
            raise TypeError("Expected argument 'roles' to be a list")
        pulumi.set(__self__, "roles", roles)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Human-readable description of the group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the group in Wavefront.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the group in Wavefront.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Sequence[_builtins.str]:
        """
        The list of roles associated with the group.
        """
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter
    def users(self) -> Sequence[_builtins.str]:
        """
        The list of users assigned to the group.
        """
        return pulumi.get(self, "users")


class AwaitableGetUserGroupResult(GetUserGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserGroupResult(
            description=self.description,
            id=self.id,
            name=self.name,
            roles=self.roles,
            users=self.users)


def get_user_group(id: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserGroupResult:
    """
    Use this data source to get information about a Wavefront user group by its ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_wavefront as wavefront

    # Get the information about the user group.
    example = wavefront.get_user_group(id="user-group-id")
    ```


    :param _builtins.str id: The ID associated with the user group data to be fetched.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('wavefront:index/getUserGroup:getUserGroup', __args__, opts=opts, typ=GetUserGroupResult).value

    return AwaitableGetUserGroupResult(
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        roles=pulumi.get(__ret__, 'roles'),
        users=pulumi.get(__ret__, 'users'))
def get_user_group_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserGroupResult]:
    """
    Use this data source to get information about a Wavefront user group by its ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_wavefront as wavefront

    # Get the information about the user group.
    example = wavefront.get_user_group(id="user-group-id")
    ```


    :param _builtins.str id: The ID associated with the user group data to be fetched.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('wavefront:index/getUserGroup:getUserGroup', __args__, opts=opts, typ=GetUserGroupResult)
    return __ret__.apply(lambda __response__: GetUserGroupResult(
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        roles=pulumi.get(__response__, 'roles'),
        users=pulumi.get(__response__, 'users')))
