import os
import hashlib
import base64

images = {
    "logo": {
        "filename": "logo.png",
        "md5": "4aec30bd0224b2e40c43a6ad809aeec7",
        "data": "iVBORw0KGgoAAAANSUhEUgAAAIAAAACACAYAAADDPmHLAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAHbkSURBVHhe7b0FgJzV1T7+jM/OzPpmLbubrMTdCO5upZQCVVpatFCcUmjR0kKxIoUCbfmKu0twCyQkhAhJiGw8626zO/57nvvOZCdLgnz17/8/yd155cq555x75L73vS/+f/j/NtiSv//nwLfLiTkB20CZLdSf70Ci2u60+RNRjEtEovaoI5ZIIAGb3YZEPM7cJAOv2BwuuwP22kQs0u52e6PRaHxFRyS6qT8a78Wad/qtmv9vwf8JASiZ+u0CW6J/bBDRUXaH6yBfzF7tsCXKbK7YMDsSLqfdDqeTGRNKYrTdlNOpQESQQMRjcd22zvgbjccTTO2xWKydorI+Au/qUNy1IBSPLgl5fJvji57sUe7/ZvgvFYCDXJkTnbM9zthBLptjP6fNNsplixc7HTa4nG64XC5rdLN3TiePbTZ2VMwlV3ks7g4y2hKD1K/A5GeKJVSGKU6hoaaIRWOIMoUi8ehALFEfjSbmw2GbE0PivbZlr61LFv+vgv8eARh3srswo2U2EpETXHHs63baR2d4nC6nxwFwRDs4yh3sjo3MApkfN8xOltV1ScNXhG2CYmTFMhWgAFGkeIEmI25HlNqCNgKRSAThcGyA5wsjsdgzMThebln+xmqrpv98+OpU+TdB3ozDaxzRgZNccB7ndTvHMsHt4ZkZ5Q444lEzQmXV42IaBcEmBm4nADsA3jZ/bDQS5gJBxfhP+sIcqQ6CGG+PUhNIM7DNBAXOkg/dtyNO7RCNhDEw0I+BUJQKAgt487FuV9ZTvQufbjSV/IfCf6YA7H6ao7h/0xFIxE60O5xHZbgdgYDXTaY7ibD1LwVS0duAXBFLpL5TICYqxRMxMkq/limwEu/b3MxFhvKvzZaAw0FmU4j0zwGXVZ+5R0WfLGeBdSfBepndlJEwqf5IJIr+/gH0hmPt0QQestntdzd9/PIKq9x/FvxHCYB31nF+f6z/KFcifoHfiZn+DA9cbg+dNnpwNjI6SXzyyfoVw41qt7pB9tJxi1IlSy2HaatjoK2G1+1CXpYPmX6mzADcbgqT0xgMo9ilPejoGZXe092L9p5edAc5ooOALAwFED5TxtIulkmw2pdpGERIiTVSEIRNLMo6QiZFe8P2xwZiuLn70zmfmLz/IWD15D8Acmcc/k0vEr/1Oe1j/VTxHo+Xw8pFzzxMWpKoHGHitTXuqP55JOUdj0XJqAj6e2Ow+ewoKs1FyfAyFJWUorikGMOL8jAsNwfZZHzA56MweCBnUT6DRm1MJkRahMykf4fgQBjBviB6errR2dWBxqY2bG1owpYtW7FxcyO2tHYDoTjyfW7QBzHCEBdeFAK6iawrCicFwMgC5UAaIs6KaRrQ20/BjMWeDttst7Uvef1d0/F/M/zbBSBv2sGHuGyuazJc9lmZXjKeozUdzChLql7ZXiMEITK8PyRvHKVlxRg9YQwqx9dgdEUFRhQWITcnBxkZXgQoSF4H3TIxxuGGndJjl5PIc9VrT45kSZXqj0uFJ0li10hOSIvYEIra0El10NnZjebGFtRu3IhPlq3A/OXrsKW+C4XUJtkBL6So4jQVEiZLOcg8WdpBwiZfITQwgK6BEHrCsUfCNtdlfUvmbDAZ/k2QpMC/HrKmHjnc67Bf7bWHTs4kszI8fjOqqTjFb8OgVBIoRu8JDaCNI3R8TRV2mTkdEyZMRHlVBSoKslHodTIE5MjT6I5HyGyVpX2PkyEc4fTdyFxTMeu36kzVLZAAqH1LGvif98Q+O4VC45mWnSPayaqYizd6KYANLR34bMN6zPt4IeZ+9CmWrmtCZZYbXmoHOQauRMrBlABL6JKCEIugjz4CzUxXOO64vNk2/C4s/kvEZP0Xw79FAIZNP/QUlw2/zfa6CzIyfGSOw6hPmVIhJIJLpUq9xqg6u7qCyMzJwh57zMDs3XbF6NHVKM7LRG4G3TSnkyNcHIuyPBlNJkUN8+XE8bLhZ5KJrDMmJnAkpjqeEgLj3OlYettcYErlZb3Cj9LF66xLRZhXP1L/fdRIje1dWLx8Bd569wO89PZ8RgRxlOXlwqWIQQKAqDE36qSDbdhYF8NG9NDc0Flc1A/nBV2fvPQvNwvqw78MArOOqshKxP/ocyaO9HPUu+hYKYSzRh9pa2bobJCvH6Pz1N7djfKachxw0AHYdfpM1Iwcjly/B3566mJuikv6KxIbjaFjXSCIn4PHzJc6ScKOrn0RmPqZzBwDk+pX47omIabuQkd/EGvXb8a7732Ix59/E6vrOjA6PwcuRjCwyd+gEKiYmmU5Kizjd3SHEjQ1id82xX1XYfFjdHz+NaAu/EugaOaxJ2U4Ytf5XYniDF8GBxPHLZlvYnaCUY38J++9KziAcWNrcBAZv/v0GagoK4I/wwY6iXBxRFJXGOKJ8CkwQpS8Jlsr0HGKwam8X4fhO4KhdabaFSQ4wtkNKgkXIuzb5rp6vP72+/jb06/QVLRhdGG2cT5l5mSQBC6ea5IqzGill9ogGA59GLbZz2tcNGeByfBPhn+6AHgrjnAVFYZudTjcZ2Rm+AGGVHaqVDUspqfUvmbW2ro6MW7UCBzxjaMwa9ZMVBQWIJv5vXaLYHLSzGQMaSeipxiQzgT97kgABKk86df+Hkg5dgJTt0yPToSPVAOFXON9a0M9XnrjLdzzwJNo7hhAWX42zUgSd5Ndcw/UIjwO9fdTG4TjfXD/rHnBi39Sdf9MsCjyTwL/xAOrspzuB7Iy3Lv7fS52UrZeXRZDLS/cQUK0dfUgNzsLxx33Tey11+6oLC82jHdTUEQi+QNy6gzbZICNJ28xwBAxydB0hg9lfgpSQiDQ/S8SivQ6vqitQVCfJBTSUayX/5XHQdMWZs/Xrt+CJ55+AX945EUUUwtm+/ymb8yVLK1ZbWqDCE1Cb5BawfXXzRH/2Vj6aNBk+CfAIDX+wVA87ch9vPbIA36fu9zt9cPJjunRqyEa4zERKhyNoqkvhG8fsi+OOOIITBpViWyvAwyvjWkQn5VPoHJDmZViwtDfL4JUHSmwxqA5+EJIb9tisjXyh8LOcHBIOzBK6Q0FsXDZKvz1gSfw4HufYlpRNpxGCFS/flP12hHs6UO4v2duSyLj2M6lr7Qkb/xD4Z8iAKVTDj7K4bI/xtg4w+dy0yuXWyf7KPtHRpGnnexceUkRfvDDE7HrLjNQnJsJP6/Tv7OISMxEjnRipjNBoHMlMWNHhE+/NvR4KOhe6vrQeoZCevkvyysKG20gs6W+s2ycnWzt6sULL7+Bq/5wH/x0hrMDGaxLA8QaJA4HNWbUxnCxD90D4VWhaOgbjcveWpOs9R8GljP9D4SiKQed6nE5Hs4MBFwZHjdjXo4YhXkKyygAsv/tVPmHHnYwTj3tZOwzYzIKMzPgEaFETNl5kcoQbhB2xMB0RuwIdN+U04kmAky9hg0mqS0zX6BjxXO6Z5LCNNU9yNxUXaa+ryAgymPVkQQpMkm+Ek2E3+vFlIkTsPeuk7F243rMW1uHQkZGsOkhlwSLYSMLuTIyqCGiBbFI6NuO0vFL+xvWrrcq/MfAP1QAhk084Oc+V+KPmVlZcHuIOJmthyN2hXc0AZHwgPEBzjjjVBz/rW9gTFk+Ml1yCkU0El3qXjQTL6wqt0E6MXd2nA4pBpjRxF8GlqZOB9Utr5K0TFK9IjYRUHIkIjxlMMcYXUKgEG2o0H1VcFDoh4Kq0AMnSxr0N4HSkkLsttsu8LPdx95fgmE+DzVlqi3hCDipIewOd8ARbPm2N79sYW/L1n/Y2oOv16svgMJJh/zcn+G6NStTEzvWXL2JjEVj9ry3rx/lFYX4yZmnYPa0aSiisLuk7hj1WyQW6GjwLAUp4u9o5KUzJp1ZOrQIzvY5+vvDEQpg2OQZ9Nw1QcSMphxVM48dNFk+jURdI378Y+7tDLZv0zpOwY6ufQ4MfiB+Mbz0+ru4+Hd3wkd89dyCsZGpw2qfWrS/E+19/f2MEo5pXf7eayr+98LOe/Y1oHDKoT/3u523ZmUFjLoXKRWrSb26iHh7Zy9m7TUJP/rpSZg6ciQCbnr/sYjIbZgwSKidEyudmDsjtmDwujx2MdCBJcs+JXHfxrr1G83cwwAFIdVxTd5YJ5rMcaFqZDkO3mdP7DprOrwcebqdoCrQiiCTK9n20PY+3/5g3p2Bua/+U91LM0VtbsxdsASXXnMT2toHkJVpaURSy8wVxG1OhAd60NfT2t8Rdx3TvuStv1sIUnT4X0PJtMO/k2GPPRzIzYfLECpkEYMdcybsaO3oxRHH7IOTvnsCqkqLkEGdpkaVR2lnMftQSL+fOh56LQXmWiKGYCiMx55+Caf+6AbaJweyC/zGHChJzZryym+ITGFguVY6p1i/DtdcfzFOP+UU5GRm02njKI1ZM3iCz7VFMA4uj1PngnT8UpC6pt/t7+s4xrYcWL5mPX7zm5uweG0jhuUwVKSYUkyY38o3EIog2NXZn4jbjq5d8tobpvj/Ev4uHyB/0sEHe53RB7KzAh7ZqYQewhBdjWoXU0tnF759/EE4+eQfYBQ9fh/D/yhbVKz7VSBFpHRCbU+0nYODIde7cz/ECcdeg+GzSlGU40GGyw6fx8VfhZoOeLf92pmc5np+wIOC8hI8cd9rqBpdjGlTprBN9ulL2kzHT+mrQKqMhEdFzPMPas+SggLMnDEFa9asxKraNmT5SDTeF10FNoeXZiLuCkWiB0cLxj0fal7Tbm78L+B/LQB5Uw8Znem0zQlkZ2U76fAlqNL1UMZJB0pP0Jp6e3HiCUfgRz/8Lsrzcswz8igZb6dWsGzrl8OOCPlViKs8nV3duPLaG7Cao6rEZdn97oEItvb0MwrpRHdfEG09AxjoGEBjdwJtzB9wDsDjzkDc7kReaQ5ee28eDj9wHxQW5Ihbydq/HHYkBF8Fb2lNG6MROyOn3PwcTJsxAVvX1WLV+nr6JRxgxEFPMklJJFwZ5J4tgNjAkSib9EKoflVHspavBV8Bqx3A9CMDxQi9nuPL2NXv95kJHoGcLbl/9T2dOOFbh+K0H/6AzM8i8aJEelDWvsoIHgoi4I7KpQibfs9JNTpvwQLsvtuPMXKXUQiS6XvvMRFnn3kmzRTQFQ0jHLMzQnFgwBGBh5rLY/dgZV0f/nrfk+irXwYPR9la+gzXX30BzjzpOPgYycRlK4zRsGBHbacghW/qN31Ca0f5Bco7WCdpygGzuaENV1OQ3/54NbVYgK1bdaagP9iHjv7Qh1vb4/ti/etf+5GyhdXXhAJb/J6Ax71rhpcjXw90iJA66KKT0tjTg2OP2Ac/+cF3UJ6bBWdUzuDnO5/qbCrtCIZeN3n1mzxOXbOcPQvMOX9bmlvYoJlSRDQRhifgR37pcJRW16CkagyKK2tQzOPqkWNQXTMa0WGlmNeRiQHvMPjjnaaujCw/6tp60dor+6+2rb5aeFiM3Rkz06+ncN1Z3hSk7utXGitGwSwrHYbLfnEuZk+sREdfL+tSrGLlE80DGT6G0vbdywrct5qLXxO+tgBkTTvi+36n/TvZHPkmiCKy6qCQ6eztx4G7T8Xp3/s+RuTmkET0saXxeW9HnTeE0WVzy2KtZeesY10XoQ2kiMMy8pwFuqOFnnq2rsxyLRR/q17aR16TF08BtMXMo/yWcBxLGvvw9oY+vL95AB9u6cHC+n48vyaE61/agMWtCbi9PvTFM+CI9sFOj9tNXyISpRPGeh16u4T1mdm6JFrbgcFNNwZTqtcaKIN9JTBfKgJKhxSdtPpYC1q0wKiqYjguvexcDC/OBC0XO209b4jRMY3ZXMgMZCHDFjujbMbRJ5jCXwO+lg+QM+OoKZn22FO5Aa9HxJAkJmTXyeDQQAyVZZTWi89G9Ygy2C0NZnXU/Fgd1W/6scauJuGUzyQdsqDooOspehkWk4vyh5VPpNWjJVlEMV2LPbSWr7Z2A15642089uzL6HNx5DMy6YlEMGnUCEyZvSc6wy6sCTKcirsQognYQj/gucVNaB3wIYv1xFrWItyw0jzA0XxAe3MjutrazFBRnzW76XZbmsVy2iwmGsxZJnnFpJQwGL7zONUfjWIdJKgxrb7sGKzSBBKjIDcPo8eOZt/eNSGhHFPRSGNBbzqpqVg0tJu/qOb57obar+wUfnUBmHS0J8cZeT4vwznS7faYjghMH2lP+/t7ccM1v8SEcaNMzKxp36EgQqU0RgpEMuXVZKGiAwmNeUqYTNY5JV45WVa1aoWOKGhGCUWivqERr731Hm695z6c9ps78Nxf3kVbjHG0Xxoggb5IDONGj8TU2XuQ6U60h23Isg2grieC11d2Ihz2IEAEGBAg1rQG4brlcDMqcDic6OjqwYvvL8L9976A9z6aizYKg4cRT25OHjwuLRuXuhYniKi0Dc818aVTg7/pV7J/vGj6y7/qY4KCoJlS8nKHkKKTtIccw5LSYgwvLcBdT7+KYT6vuW8Wy6pOLUhMxLLi0fDYzob1D5qCXwG+sgAUVFTemOm2fdNPdcP2rMaJnxY0rKfz9NvLTsGB++4JpzxUST3ziHnbVFqyMwIdi6mxWBxNTa1oaGhGS0s7mtuUOtDC1KrEa+1tXWjtIJOiUao6PVUkkZkkCrV00h5+8hlccs2NuP2el7GUDhNCUYyZWEJ1mW8WWKitIMuOrqk0AhCl+mwkQbc092PuynZE4h74iZoWgZKKiDeuRrh+JYXBSeYkMLKsBCV0ZLf29KKPUcSr81fiLw+/hNa69XC53ChgyObLoMkwo9DB6CKMLY0NaGhpRVt7F5pb201/2lrZr5Y2NLNP9e2daO+WeXEzLPWSIjuWANFIoD7EqclcjGhGllWgKODGX+d8gNJsn9GWKXAR52g0Xu0uHlPfW7/mKy0/Hyz9BTBsxiF7uZ2O9/IyMyW7DOlkVy3pa2rvxU9POJAe9qkIaC7AMFzV8lfSrXzqgIkUktc5nhtJiKeefh5/e/plLN7UbIhPiltJnWIZMzR0HE1gj+oynPLdb+DoIw9DNBbG8y+/iuvuehC1m7pRkOdC70AIe8+chr0OOgCTpk7HumXLcMGvr0V1+TB09PbhiEMOxOnn/RyN8OBpRkzzVgxwBGbQRFBbESepaDsZGF/8NPoXPQqHy4/a5jZceeHPsMee+2DVilVY9NFHeP+9hWjv66Z7Qe2wpQvfPW4P/PTHP8CsGZOwcuVK3H3fY3jh/QVoGaAPQrwNqNtGdSnxDx0jRSPH7zoJJ33veOy12yyaFS/kwlPstg2adJDPodfeZO46e4L45ZXXYc68ZSjKpiNuKifQHuhdhI7OrvVbI95dIste4Ij4YvhSDWCfcbzHb4s+kJnhKZfE2omcVJuY2h+ibR1Xjl+c9zMU+DMt3vK64Z2SObXUfgqkDpubWnDRZdfixt/OgTvXgWF+D/Jpb/MY6+YyDfNnIM9nXSugqlNq6w7ibw+9zRHWjieeJfNvewYej4MjOIoD998Hp55xJo4+/jhMmToRNWUF6GzahKfumYP88my0RuKYOroC0/fcBfPWduLhFT3wOTlqnWEjzFLJ5sEPHapQ4zpqgc/IXwcZPYDdZ0/HzJkzMXNSDWbsMhPTd5+N/Pw81Nc3ogNhrGdf7n1mDrq2bsFtf7ofry1bhUJqqmwv8fe6rH6YlGH10evmsY/HbqzYsAV/uuFhTJhSTdM5ln6THkQlCTUEzOUkLTN8ToysHom33phLzaixY/HDOMguHscSuYxuS3ua1jxjCn8BfKkA5JXVXOB32k7O8vmNY6dXrZNOOFro9d9w+fkYX1lpHJw4BcNa6pQUgCTC6SBN8Je/PYibbpyD0TPzOcijJHQIfeEIpTeKKL33kB7c8Dislz54HmYKuF0YVpiJD5fXYlMrTQKZf+Du03H++efgoGOOwyhqiJF5HpTS7ud5nejq7MB9f34BucMDZup0/LiR6MwZjRuXJVDmzoTbnoCXGkYrFeSwCVdPPAzUL0N/0zrjPLZwpB1+0H4YO3oURuR4kR3wmLBs2pSJFIyZKMnPxerV61FA9T9/5UYzFS5h7iVX2qUB6HtEYzFE+Btif0K8HgqHeVm+QhxZFILskhzc+/z7OHzfWTRbhUkqfTHo+UUhhXBYfiZue+YNlGbpwREFWEvP+evkQI2GByYHikcu6G5YX2tu7gR2Im8W5E49PJfMX5bj95aZFzbIS5klhS8rm4K48rSjcPpPTqJS5S0JhphOhhum69iqxgiECsvxWbthM/Y89mRkUOV5qPRkVkbTQ1c80BOx/AIxQ+ZD1sDDMnqT57ONW82EjptxUVswiJ+d/TPseuCRLO8kw+0o9jjhpTqXeZFzuJXq+6QzLsRntVvMQ53M/GyEckdSAF3m+aPsqx5DU6+yBP+ZuX6agM56RLpbDDNrm7tx941XYZ89d0dVrpeEZz5eVzNhRhBtfRHUrl6Dm2+4GYtXb0YmfU5p/fHjqhHgqNc6xxh9DqOhKfiaDtPzBhf7FAn24NONPciMd2F5YxCXnfIN/Orin8NFzaN3DwwdRcMhg8jQxvTRhk5qqN9cdwuefOMjM0lklk7yujTBQH8/Orv7Ptyy5PU9TMGdQIpHO4TC6Yf/LtvjvCRAJ0eOl2b61P4A4+mC3GzcfdtVGDm8xHjB1koei/nbI0x01RMyVI7Sq2/PxeEHnomaWeWo6+jFqd8/Hmed+VMyNoKmiBsR1cMUo5B5ExFjo5dv6sL1dzyA/k9fRsKXh7V0sO6+4Vrss+/eKPLFEWDPnXZ6wUyhSBirGQq++vqbeISmoqt7gO06WS+d0/CAwdGsO0iCjaPGSKgQ1a/eIGK4p77qfUGtTzzisANx4B57oqZqJIWJY5d21jzFYx69HPLdH59FR7iDQp1AL2nx0F//iJrKUvQw2uiPKnphG5Jm4yDH0U+hePLlhXjsjhtpDqLoCIUxc/pk3Pi7a1BZkA0HBcfgY1BSue3BoM/7Cok/W12L75x+ISMTL4i5CcsF5AJaOzvRG8QJLZ/Oedxc3AEMUmII+GccPdztsJ3q83pZqRifysqRQe/2nLN+gBHDiy3njkgKX3M3dZAEi7aW169kTRtbnXLwpp02sYsE6SD63XSOgrzWx3shEqqHjJjXHMbvF/Wi25ljvZehsjQJGzdvgc8RQ45TTqkTQar5BYuX4aprb8KUo3+Ci296EOtausiYLrT1hDjq7fQZfHB7GEm4PEx629gDu9sHO6/Zec/GY7Cv8m30DmBj5wCWfbYR511+Mw488TTcettdWEkT1E8pFT8VgPX39WL11iaGjdYEVIbHg764Gz0xN3+BTgp+H0O4IO9FiGuX3YVXlzTjgQ0J5Lpp9uwe600mqu3mfo5clnEoIjGsGaSl6k7RNkpNpZdfNCuiVdQ///EJWNXYS2xUbjCvnh9kuHBx7swf7tTU71QAfNH+s7xOW57eiNXoFenVfAfVzvcOmIm96BzRaJtrVDpGEHYkrRYobJMwpLRDsmOsV8qhh6NkRXMI79dFMLfehg/qo5jfHMFjn3biyjcbOGLAUR5BP8hA2umAVJ3Ljh6GfCFWsGrdBlx/462Y/c2z8btH3kAhcZawHb33nvjjrdfgkEP2RW1LD9asasSa5XVYu6qJsT/riFPdRuOo3dyE2jX1WLe1HesbuzF54hjcet1VuPyCc7DLrruwrQJjdi657QHM+NZP8ftb78TKtRuoztmOiG3pajjZN/kV4YQTGzvteH9zBG9vieDdujDm1kXx2pYYbnuzCX9Y48EonxxYN02EVD7NF8tr4PfTT5B2ETOlOYbS1DBXv0x6XY4WCUcecgj2HzeCJlSE4XXDC5pPagWvKzHDlmj7lrmxA6De/Dw4Jh9R5nZETvVTgqzXMCymCamWYD9O/PYx9HLpaFAGFZpI62hkpnAVktsjLoQkhKlr8hc4ImQ6+KtnBQlqANXnJ4MjHPm1rb10rDpo1/UyBctpoiMWgc0pJ8uOXL8L3R1tuP3Rl3Djnx9CUw/DVdld6o6jvnEo9jnoCKrsSjpuLkyZOQVHHHEU2lubjXPppr169aUX8eGSlRhfXYozzzkTdmoENoKc3FyUjhgOv6KamA27H7QXfnTiRrz15tt47KU30MNw8+q/PI2/PP48LjntexgzajTyAj7zGrr+OZ1xuFzyKqioEi64pKhdNA0xJxZ91kFBtKMyg8wPaxaQY5g+jV5XkwDFFAWQJnqdldThJQqHaEtapmhqjmVSDNCnYP7iwnz85IfH4dhf/h6zSnJVwJg5B9mrF2T7QpGL4Tz6KUSfTxXcBjtUDbklVadleV1Ha4JDIClX0uj/0Tf2x4nfOtpSUJRUMwKSKR3Sz0UY+do60hO2Rx6cg7zSTHRRmHaZNQ3jp8xEL9VqW1gEjGEDHcyX14TYUQ99AIv3tsa1CG1dwfCMo4XM93CkzXn5Ddz16BtIUCj8ZOAJRx+I0845G3sffAjKS4vpILroI9hRmOWHN5CFwuHlGF5Zg4KyCqxdsRzzFn2CKZPG4tvf/xHKq0ajuGIk8goLzFRvnPbfTy0zuigL46sYQs6cYUJCP8Osj2s3U8M48czbC/HW3A9NyKiJJI08rX88kMJm92ahIcjInswIRmz4aHULatucoIya/tiDDCJXfACNi2gkhJEVwzFjj71RyCjG7ybjqR0Hza4lBDsG8YA+GYVgw/JPUd/cnnzDWppCs5v0WcIDpfasvrnBlk2fW1D6eRMw/duZbof99AxKTgrES0ni1mAIhx1yIHwiEIuKxduz3UL0c8iaTPIDqCY130pBEOhdgRhHjpxIOTbUhPhkay/m1PYhk7Lpo34za+Zp4/WjejT/7mV8/eFHy7B4xSYS1IlvHLgXbr7td/ju6Wdh7LiJGJ7pRU22HRV+O7KYP8DKKwu8KKbD6E8EqXHIGPkiTlbI35g8z0icKjzGyCSOHPoBIxlajSnwIZvnLtrokmw39tt1Ci658Cw8esuVOJjH4t6ANBerkUsmGmlEyumVl26jALXT1HzAkb+x3UHG9LNXeomVnaX6trSrIY6B1FFq7GjgfDlIc0SRl+PH9799NFa29ljl1D+EEXM44KaG8voc51n5t4fPCUAWQkd4nY4qvcEqT0eEV8za3j+Akw7aDRPHjaLtoxQbFUPVTWZrPnuoD5A6trSDibStY9OidU+jyCU7xvr7GfosXNuKjzfGyDQvTTwJaqc9ZH45izFDVAqe1CLLdlMVTx9XiTv+cBVOO+9cjCPj87OcqMkBmcdO6xU04ccyNpoQKgKU5/oxvjiASWRsjlbZBBl8kukS5iyGkqOKMjCmKIBRw3woy/LAS18ioRlKTfOyVQ9HWllOBg7fbzdcc/kv8T+3XIHxI0oxQAHSgyp1LkpcoyRahMLc3tuNdz+rR3NvCD4nTQ/bMXnkVEvU7NRy4pNFHdLM4rz1eFu0HaRjOoiOqWlirWy221zGjO4+azoOm1JDJ1XxAREgZVWvh9qRLu9BBdOPnGQKpYFVSxpk2KMnZ9Dz1+4cAjUmIjYEB3ACVX/A5yXR0pDioRoZChbjt4lykuUp7WDdS4Q5Akj4ZjY1Z3kTFjU76Zn7EOU5/SOOUC0dZhTC0CwsR4PEc5JIrd1BHHfUQbjoyiswaeZuyKdJGJljw8hMB7LoLNpoS+0xq2vmYQnbVKv6FeEyqMb12jZoOmzULtIqHgpcHgUlyxY1zxv0oMaqwOqDEWLhTOb4qUGqC7Nw7OH74dJzT+PgiJLxJDiFmK2ZPm1q78bry7pp+wPUBAH6m/SnkslG2sqHF4aaVRUYhpq2WF5dTVI1RcNttExCSjBM35ikRfPycnDckQdiU2u/EWxTgvccFDi3x+NkFcebQmmwnQD4Zx0zJsOR2EcbLVihH6tgBT2hGL41eyqmTBhjHDFdE4is5h/PlXcokunnllRLYtWkdZzpdaCVfsWr76zFByvqURzaAn+fUgP8vQ3I7OVx92Z4OjfDG+ykQ0V9agujs6OHjt0u8OXlosBjQw1HawFNi5MedUyPWKWdiFOKONuDtFqSOBwlceYN00mL0hlLyCEjQ8xSdTGUMEhgS8NJEKLUChqsmTQh4+gwFng16UMNwD56aTprV2/Cc6+tQJiCmtXbggD7k9m7FZk9m9mfTQh0bYSzu4HEl9aQ/iOTiP/gE1QJ2iDeKTqmflM4DQWFj3vvMRtji/IpkGkamcU8DE9pkY5njGw5dkkgBoPgLR15cq7Lc6i2YtO8ldb3yZYta+zABSd9C7OmTjImwaBhKt+e8UOR0nlKVVEpGuaHGeje+dwryAlQxfq9WF+7BSs+nAfX5o8RXvMBwmvno3/1PAys+gADqz/g8YfoX/U+oi21RlyjVHWleVk44pvfRlFBPqpyqDWSOBi7a3AREz9PIIFuy4S9+8F8zP1wFapGFWL3ffZhTB5ALu2EcbxIvNSkVjqk+mlWGpm+x+Ckw9Xe1ISX56+hJqLvzihj3jtz0bF6MeK16sd7GGC/+tbORS/707eG/flsLoIbF0lODc5b2jtw7DcOQ834SeZZgV9PiuRTmMYsUNvCZxsOBNPnZBIY7RTIRGtzE95bvByZGdJwvM970kwD4Wi+J9z7Zl/zxo2mACElcsBBpzh8NnzPSS87QSJrckUlpVqml+Zi9qyZZL5Qsiq02tyxJKaDhbQ8VZdBcOTICvzyp9/A+tY+U48rHkRmogmegXo4+5pg762Du78Bzv4WJIItDIzbYI90Mq9ekqAAEZ+iYQXI9GWAER5tn6ZFyTgjaJL6lOq2fnYGWuFjflnO2rEjqeJZv2CnzCcIFwmJ/CxNABUOywZCvZYfwLvSVM5QC2zBetjDrbANtBqv39nfZZI91A17PGTq0rOBA2ZNxK577mfsuFvmRxMCO+iAwS8NLx2nUupcg3e/PWejThEIQfzTdS0aUXTgsicOMDeSsE0Asjs2jMqwxcfJJlEhWeqJ0NjVh28dti8qhhcb9a955kGJMz/bEDDSlkYogUFQ/WHnqEipIu34/onHYdTwYQhHrb37bHY3b9Po0z7CQeeIwqJ35BwmaQsY85wbGxjiqNHlGxrwwH33INbXZtSmmG7aSeJj8NiZBAzSj9SRA5XMlypMSPUj1ZehfdJcnC5FwnE8/fTLuPD2v9EnyEDd5ha0d1MQWJWddt5p5wjUSwWa7LGxjzaPSWb3M9oQaYtgJILKyir4fHnMazebWolSpArbGWz38zjsAGi2wYhgwqgqHDGJzmA4SvqSxhokFHBtl0ff51uoOVyLEAxsEwBHwnWYw+F0O+k9ywlSJ2Uh6oJx7LLrTHqSslU0CUlCpRNIYDHASumgPGK8klSnCN7V2YK1LT1wkzAuOphbWnqxZlM3ahkCrtvajXXNdGLot9o0TcpR1dzVi8LCIvzi56dj6rgxcFBwHnr5Tdxx8y1oaOJISwqASKcuWSh8nonmmEnENSOdtl8qWOTWv+3yEVTnNhOW7Jd+RQM96Hn0yWfw3ZOuQZkvE4FsPy69+kIcduDB9EU8jAD6TYirtqRVG7tD7FsX1jX0sJ+dZIwNJcOKkJvhw0uvfog1tbXIzaQGkKNocNjGGgOp9tPxE6SOrV9rYignN4D99tkV9Ry8wl91yXGXb0fNN7rYF6QzZ4Hl6RAcCdv+2n5VD2ziDCPYDCIsNLMsGyNHVIh9bIWVmdwWMl8dUsjbzaPep194mZfCKKwox09/fi5VHoUt3MdreuAk8wM8/uhj+GRZLTr7+nDFr87DuOmzkZGbh8l77I/eW26G5+PVuP2p+QhGb8blv7gQFSUFsMVkN4Wh0iCO6QQTqG9WJJPm3JkynwdzL1lex8Kvl4PigQcfxFk/vwXVE8tIFgfOuOACjJ08EzP3OhBH/6gDaxcsxDU33Gb2NDr64AOw98GHMdS1/CCJXCA7GyGG1ldfcSUaWnuxYv4bOHafiYZGFj6CwX6k4zEUdF3J1KxwmTycOW0S2gfuR1UyD4sb3rrcbrstktifl5bquiVmu5+YneFwTNMatxgJok7qXwdj7d2njEJJfp6pQEgoCVLHloR9HrGdXVu3bj1ufOpNtpzAnnvtiarqKtSMHoNRE6aiZtJMjCERZRcXLfsUzd1dOOm7x2L6XgfAl5lFIQ1j+thyXHTxzzFu9mjz7P0vL3+ES666Dhu21CfbtIghuhlceZjCxZwn8TcM538ze0eiqx8pSPVR5VL9FOg3GAziL//zAM4643eoHF8ED0fVJVddinGTd0E4lEBxlhtTy4dh9733xkG7zSAaNsz/6GN4GYuPnjwF1ePGo3rMeAwrLkXpiErsvffuCDhjePW1t9Fcz8iAGikFOk7hLkjhksJHkH5s6TJe49GYkcNx0LgKs/YgeVMdoh9AzYq4BMCA6XVOeGCiw5YYrhO90CkQHpt6w5g6fYpZeaOG0gmZajgdgXRIv2+ERMdUTws+Xgx0xlCW6cHE6bMwjGFcVY4L2WyDQohOPeq9689IRNj22AoccMwxiLuc8LGOCbluVGbYMXtsFc667DzsuttEVBHpR977GL+68jfYvKWO5ktMjZnHygaSv8LdMNScEH+FM+y+NIGSur2tX0rKa0Yrk7w96sBgKIS77vkzzj/7JoycUgavNwMXXfNrjJo6zWz5VuwHxuZnoCbHj8kjC/HTH56AptYgOts78cLTjyDW30eTRz/IHafqB2ryffjWwfuhl2H2ynVdmPvRoiTeMYPjjiBdINIhhbtMrJ645ubmYBfyrj2oR9Cqjn95XWsdHQ7HlJwZR2WqnBEAFyJj5RSrcnOBIAINo92fOIlqiVXon8AgoMqSsI1oSdgRgrotjaJFmu/NXwRXrtc8/y4tG05v3oVC2r5RBQ5U5wKfvP0CPlqzAX3hGH50yqnILyxgiBbF+GIv8ulAqnZ5/7tRc5x9wRmo2nsSSulYPTd/FS64/GrUbtrKTsq3sNr+PBBfQ1wlSyCMACSvpEA4W2ZCs24udPX24Y4778bFF96DyinlZk+jS669CpWTZljMD8TpCHpow1knhVWLVA7Ycwauu/hkbO6M4G9Pz0H9px9j6rAAJhf4MS7Xh4pMJ2ZMGI2DZ40Dcj14870P0dbTSzudnKHkgBFt02k6lL6p83Q+6Ff7IWuF9pa+MC+QGLxlVhczv9vlLPE6EiOV15DJY48cJFW2zf4wUz9Vx4yqApQXDTPCaMKsZNtWM58HlUshocw6N0lnLC+H7YX5K0RSTJw6w8wFBLTfLkesi5mWLlqIS2+9D9kZGTjxO8djNPN4EhFqCC8ybPRojXZiJ+gr5PBw2qhKnH/eWZi5y3gEKNlPf1KLcy+9Bms3bDEdSyfO4ESO8LEYLzVn4WiyDf4SV01/60meoK27B7fc9if86oo/o2piIQI+N869/CpUTZhsNpgeHnCihgz0yBk1vdVgo53PcDHi+SbDvGrY8nNw2133oLFpC+0wHVZHFAPUBtm5WTh0n9lA7wBeXLAcm+ubiYAWqomhSfVNSJla9UNg4W21lfoVqI+mnzwePbIcrmjI9JXoWMC8DAWdiAxM0KkRAF4r03RhijCqoGcgjHGjKpCTRU3BNrUYlDfMvZ2CHBBTJfPYRDwlMY7SzMtrN2xA69YgoyAnRoweDx/Vvoec1zOB1p4B/PF/HoeTztGIklwccNQxjArtKMvzwe90UDVqwbkeCjGkYRt6AJPL3z1qanDGL87CjN0mY0QkijcXUxNcJk2wxZpZI756jmCwpiTb6XvoIZT24EHUEgizMIRZhb1AxDKs5L0Ojsibb70dv7nhQVSPLYYvEMCFv7kKI8eT+QyzKgIOjMj2UFhUv9V3MU5YaglYaVE+zj31e0isbseCT5vwzDOvmmcHeovSFXUw7rdh0uRJQF8MPfWdZql7WOST+ZEdZn0K4yy6DzJakOLFUJ4IbwnK8NIi7FZVSA01eF+C5BSv4/EZ5ty3+7F5CZtrhPWShVVY0NHXjxEVww2z1LAEwEhlao48CcqfSvxjCK1ZNPkS6qQ94SbbnOxEGJ+tXW2WU0+uKqXXXox8qkmNfLX43tvv4oln5sPb14kTf3Qy8osrUOpz0EdwwBFjaMr2NSrNRyH4X8fshXnIM3tUNS76+c8wbZ9ZxqF7edk6nPPLy7Fq7XqzHExzGwqBJAh6XLpk2Uo0NXcAWTYE29pRt2YNmhrqzI7eCtlEd/WntSeIP9xxN377+4dQVl2AzFw/mX8FysdNRTgSwnCaroosqn12WotDSB3DfDGNLGDfLU2wx+6z8dNT6HdRUH5x5yNYtaqWlCF9qNX03L+qqoKOYTEz27Fh/XqEQmHe0xw++8k/5iUSCTHr0ySdIJ35OxIA4eDP9GMstWQ/60vl0T2700s+2qbo3JFdPm6YOx4+3+91elLv1Smto9o75ZhDMH50jZmUtJolbN+WAatBHcijtpDUKtiuvl70hwcogRH09nbh8SdexOLaOuy7ywTsNmMyvBQKNzva1NKOy35zI0KRAcwmsQ4//nsoonmozPTCLelVnckm0sF0RkLAKHJYQQ6Gjx1NJ7IFtevqUd/ejRXLlmHG1EnIz87EGhL2vgcexVU33osrb30YTW2tGE6PPdgZxH0PPo95c9/FxvVrkOn3o6SkBMH+IG6nM3rN7x9F+chsFA8rwAVXXoPho8ciEY1hJO13eSbDZjHAwob4mINtIKLrks/nQ2FREf5y/9PatwIFHgZeu8+iEA2gu6fTaITFi5di9ZYWlA/LxMwpEzl44ujuG9C3BuDQd5C0iCCN+EPb2g54U0NRgr+ag+D9RcuR5bfeJBJImMKhvnikatK9tsJdjtjL74i/l0Np4Vjb1sbHja14/97fYc/ZRJRSbadPMFjBDqSA4IzrZUUH5n2yBM+++ApWrtH6gwT0dFEj49PVLdS6IWT5nNAXQLS2blxVOby+DLz8/scUkiB+d9sNZm3/KDqK+ey4mRZ1UgC3VzzbQPZa4qnRNkBf4tM1G3HHHX/FQ2/Og4+e4EHTqnHgXrvguj8/jK2b+1DBEE0rgoxd04MYjTLjcAHre0JAVzf+8KvT0NvTg1/d/giZnIWRFfk489eXoaiSzA/3Y2SOG6WZ1GxisJ6XkCwa6RbxtqeNRbMEmRzHjbfeiStvewJjK/Pw4+MPwdrV67Cilj6B14PWtl6zlbw+h1NeMgwejvwgzxW7T544Did+80hMnkyH3NBeyao3BUN5Y2mxBB595hWc+utbMa6sgBcsPyIWp2nrbA51x21TbIWzDvxpwOW5N8ufBzfVkUaa6tja0YVXH7wRExmzyoabJygEVZCuTgSpc72t+uSzL+P7P7iaQ9KD4oIs3TX74Mrq6aUPY2vJzVR8qjd6NKtGEcGRxxyGb59xOkZz5BfTsdKjXwNqJ9nGjiCFk2YNQ2xrxYatuPfPD+G5N99HnH5Ec0MnKoqyOIo0DRtFX38cjQ3dQPsAUORGMcOxLAqk6Q+bWV3fTs+Ytp2jvKqsBGddfDkKqqoRIfOrchwoC3A0fQE+KdhGKyatMl6zcTN+dPrFaOzoxqaGVmQxXMzWVnrMIoabOQAm7T4ucmulkcrXdfSxsjieuf1KHHLA3uyHPI6UThYeO8ZFL4y88e77OPinv8X0Si2tS877sa0WhqY94diudnfCOVYrZg2Rk/TWZFB5fhYCmZlmZAiJ5C2rQ2lg7rGsnIsFiz+l1/sblE4oQ01pAT18h/Hy8/0eFAS0tFxIWyZGz+OVcrwuFPC+XsGWIOQy1CthFKBpYoHFlB13MAUGJ+bTChsXQ8YxNaU447QfYt/pY9DPOLiqJNP4AHF6juuWd2J0WRauveQ7+NM95+Dqs7/NaKIUa8j0bjq+QnF8eQHG5GcT9wyc/YtLkFs90jC/OtdN5tNhpDYTXimT+WVgsI+FUZCbifLiXITpPNYMz0NRZoZ5eCNtqN3EzXZ6rE7nOT5taeOAvp4ypiQH1TkBfPOnF+HTz2qpuLZN4G4D4ZGOi4yAznNy8jBM3y9IA4tc4pkj2+4kg7V9i9BMWTOps6KCXKpu7f5hLhkC7whSjQ5QXT391LNgcAs/JU9qtSc4gNrWbmxs6UZ3e59JnVR1De095p2AIGNr2Sk5bvkkzv/85Xn0bFoPygyZ+eWETQcrN/tB9ZZBQmYwzFqzbi0yOfK08FSTLV5nCA/ddx4euvc2XPCz03HaSd/HJef9DPffcytefeBGTB81HA3ESwIlSnTSJHR39sDF4ViT78Jwv4OmUNbVYlRqMKQTPh1S99U/LT6Z++FHePK5TxgeWtpmgNqvibRpoobq5G9XSw9TL2nUh5bmHnS0d3Hg06wyWslw0aGm8/bok89jIBwzKt6IFutRXalkIA2d7Owc5HGA6WJqsAo0GHk+0hliDKYtWrUezpr5smbGMiiBbrsbUTtHlfE8pcY4itLiUIUnAqne9q4uvLdgBUYUeGnnw8jO8eF3N12N0cPz0RJKoJX2PkGDK2vi5R+FeJ2RCB5/4BmseO9NuHx+INOGt96ai9mTpzLuZ+jDNlJE/DKw8GG9WmUZj+D1117HJwu3onpCiQmD/DQ79/zhasyYNY2Op7XGUIKu0ZSfk42D9t4DZSMqcc55l2Ltpnp46beE2O85r76C386eijLhx/5aTjgLC60kodNxFB6fw5n59FrYW+99BBRrY40IVrf24bZfnY3d6PSG6Lt09Efpa0mwaKNZnN4PHNSG73y0Go/88a+Aqw9VwwJ46f2FOKmhERNG6NmHHoBZGmk7MOjxH02oeSsqQD6K+eaaTCX5zSFGZ9Yj34o9E46DSEsV5+XqIwdUHcwsdSLQmzIpCUr1UQ3pknm0yTBKx7rmI8HyispRWFaBkpHVDClrmKpQUVmN0lGjkFNaho+22LCwnx1hR+OJAeQxpmul1OuRqmWVtpfu9CRhTD8X6C/P0NHdjTm0/0WjhvEe6N234pJzTsYus2bIlBoQ+iKJUeeMUoR/Vn4hTjrlx+YpmjqYR8/57QVL0NnUaIiWajc1X5/efgqfoddTSd9BqKtvRCHVMa8AwSC8pcNRNLKSNBmF4pGjUVI1CiU8rqyqZLRRhU3hXLzUnA8nw1UTUlOzeZw2rO+KozOqx8s0QUlGiLFDBU++hfZyyMsKkHfquJVHSZjSJxhPM+AYIwQF1l8KAEd5dlYmY2JGq8l7Ah0PNmJVkiqpe9bUqUZWHNo3YCDuxCdb+/Da2m68vbEP72zpwgd1HXhrQyduf20j/rrBjsyMLNgZKuqZf3/IZj7tpte79GJolExJfc5Nv+nH+mKnko7VnnWd5zxuIwOXbmgyNlTO5viJpdhnPzpPFCr3tvkOK6kXWmWkt4Ca+0KomTQRR+0zE329A5p2QlNzF7Zu2MiwkOFssk0ltZdKFl4WLikcB68P/pqdTEgjTY/ByWsRB9a1DmDupm68takP727sxtytPZjbFMKDi1rwm/daWcZH7SwXOWKIrXcH4zQJ/cRVCz9F93QepYOu6jO6GfQpRBdpPCMAPDYTTbK+w2ce+V5ehnMvPdiQYVFQ1dIdxHeO2geXX3g2tHGh9sFgye3UvwW8xuS2u7Cxvg6HHneaYZxEb2RFCS76zU0IuQNY0CZ7EzdTpb1s4ePaFizviCKXjo9z7YeIvnU7nN4Awqy+ojQX48eMopomkkJYbUiUhQPBdJjCpXlt1WmmqNlVHevQ7cpAO0O4N+Z/apaKbWScf8qRe+L3v72cAiFniAyn/k9ucMNqYxzxMbT2y6mLm1nCR/52P669436MLc7BAJk3rXo4yocXJvtttaWyGsmiSYoeuiZvn5cNuqZ+gpig0Ov9+dQmFCT5JGu31OOeu+9E9cQZWM4RvbXPTfpQgBjyrmvjQFk9QLNoR15PBzpfvAmOUCPbAn2lLFx63e8xtqKIobIiCIkp8dk2MAdBPmVnVxCnnnsZIyOaNY6AlAbr7evT5lf32IZPP/yefL/7FA89b7NyhAXbKP3fP2pf/OqCMxFjyKFXqcXUFKRrASMAzLOpvh6HHXc6492wYU5l5XBcdM0NiHoC+Lhd+pxSyzB7yYYWdjBsIoA4PXP7mo8QoQC4PV7EbF70UTXWM143NkDNRNlrTRcKBxlHXaPqMyA8GF8TQRO2maFFZw/0Q2qK9BWyqFl4ctH3DsO1V/ySDDaOD1UnBSCh9Q5xMr+fPorLPEDy0AzZHW48/tCDuPz6u1E9PMeUWUfHNbYxzFFr9cO0o7aNMeU1gQgnXHXNSy9W56mkV4ZdMVSVZlkvufDfmi2NuOfe21E9aRes6AmjrYcjm3Wtbgpi4foB+DjiI176Yt396H75WriCrex+AoU5Wbjk979H5fAiTMiVJWdISB9iR6DZxK6efpx+3q+wbF2deYdCkBKAtr6YEYC7832uU916C0iSTKJIAL5zxN644qKzKADupAAMSpmkyBBSI4FFtD3c5sYGHPat09AX1hs91ADVZbj42psQcfmxuMuJjmAYi1Y2oY6hdwbb4YCw1tyvnofI23cYW6WNm0qHZWN4WRkFKWK2hdF+BEJY0iyQLbPEVOjKhqsi4ULnxuk0o6urpxdrNmwxEz7twRD2nzoa99x+M7KyJeRSpRQ+/jRR03VExVSV44jWAOAI/p977sH1f3oYNcXZRvuMqxmJzNw8hI3qV3mrfY1+CXtqMapkw5zrPv/reYWlbqk1KBub121EKEoNwHh8zeZ63H3vHaiZshtWdPaiqdeF2qYuLNjSDy8CFP8Qwp44fMSxywhAC+kRRymjs8tuugkVRfkYn+MwS+kS1FI7AvWpmwJwGgXg0/X15guo5jqJ2UMatQXj99jKpx1yc47fe57HFyDOVkXdHKoH7jYF1191MdVXBhEm9uxYSgBMh8yxRhMHAQm4lY7SoceeagRARBhdVYbzqKpC7hx8VBfF3FV1FKy4YZLW/MnDJ2dh++x9RN++jR6vH6sY/vzy1BNx1PHftSaPyGzLuVJnrDatdnlsMCEkD0weXaeaa6I5uvSci8yiNjGitrELn7zwF0ybPJbloxigYDV1R9BNDmlLW5LR9EMraXroQP7i/EvwmXbnpHNaR3/ib3f+AeXVVVQ2jJRICtFCo5il1IIBw3Tits0p46lRFEyy/SES/KarL8fK9RqJbqze1IS7//wHjJk2C5+2xfDOqj4sr++l0DLUJL3jtPsDngSyumgCXrgGjoEOCl8cRYW5+NWNN1sCkEsctNbQOHifB8olOoj/T866BLX1rUZJymRqCXoPQ/D2/sQ9dnss3GSImgwBBUKivbPbzOcbpaH7yY4JUoKwDZLnhgb65XmEQpHwxNDU14NXVnViS8iDmCcDYS2IVEaTT6NIG5/Sjhl1qq9tWfGu3mz1ZPjhcmdYQujwmuTkPZcrmRhb66VOG5PdxVhXtpZ+RWZhESqrR6Kfcbaef1O/44nnX0RfhMxn/XXdcXTxV08E9RSUDRpB05zEwvkf4s25K8gkj3EgJ1OQcwoLibPuu9iEtolT+wyTiUMqCRdd07SukwzW3slu4u71+IxfYmOStRKVY+o4wUPR62G78zY34M3mXiRoyiKkQ5h4Jexhhst9CNMsxqPkAmkqbaj3/63H4hYN02TwcyAxldbq6qNDawQrqUbFaZlRuz1kd7o9w6WmxFSzXo2ZpHI1SaGVNVb9/Jtk2naQvLZNIIwEWPMFLls/1jZH8eiCLoQpvTm2MDzxENVbhB0nrziK9Ak4R6SfyMglo+nkmLGRwXpEWhywYXiWA8OzHSjlr1JZjpPJZaVsJ+/r3I1yJl0rzeYxY96aohwcfvh+qFvZZgRgdGEmfnfvE2aaenNbEEG7vsIh0xWjzSce1BqKmRfO/xi/v+leOrAMH4lRQ08Q++yzN/yBADJpP0dmelChdrOTOCTxSbVfbvCy8CnP8fCam3mV34linnsZGkfZb+2inuexocEdx5wlm/HemhhKSZUMmiMv1ZaSJ0afgINDn8d3kXZy9AzTSV+ZXgOiOy9JG+0QeFkRSw8FwAwEJmOqmMxq4Vh0hSO/pLKCnuuRLo7OQW/SiluPPmw/ZPkzKRS8lmSyUXVJsA6tc6E078P5+Gxri5npGqAztvizOjTWboCzfjliW5g2L0dk4xKmxUyfILxhERJblsIZ7qY0OtDW2YXvfOcEVFYUG0Jn05nSUrEspkyOjkyq5Cyvw3xvIHVufpMpy+00G0ZkkaFF+Xmo3bgSG+nAKXbWHMNfH30V9ngfhuVmIpOOpZ5aBvv7Ub91K15+4UVcf8vdNDX6BK0emJApeZn4wU9+gsycHIwkAwszXAh42bZwoj1V+4FkSuFF+WOy8A0QD+sXyGXZepqmZ5/8EJl0UCVQ9ZubsGzRWmQ0bkJi6zJEty5BmPQIbSZ9Ni0BNsxDbP08hHvrzYgNM4IYM24UdtnnQOg7y8P0Igv7YHHGgnT+aEA3NbfgL4+/TE0k+28NThs1TP9AH4KR2Au2imn7HOd1+57IyimgQrLWj8nx6ejtx8sP3YKaikrWaglGqvL0cDA1+hVXPvL4U/jBd69Eza4sEwvzv1QwtQiRtNBkefM/KWgsrxEv5mv9wZF774ofnfcLFNBZG52fMVjGQEo4LTBX0zqre/IrZFBElA46T7/81VW49/3PMIraRKuOpN0aOnuYJ4apoyuRm5uL9g76B2s3oScUxqhheYZoAj2byM/Lxq+v/DXGja5BeZbb+CHWQhdCEhULhUE6CCw6aaRaxzrTTqar123B9085T1/9oJmlm0eGGi1kk7eS6qva4I/5IweVieaFzEHtp1tx893XYcbehyA/I4rReTSL9AvkUKcz3sLFZkLaBYs+xuwfX4GppZlmyt+E0DSlXe316E44v2ePItamqUiBqlBFMgHt/WF0dXaaDqZWpKRSqrHtOs0OHHKQ3s//BmprtayJnrvXR4eCHq3Xz0RNQkePwS2vMURjeGjjr5gvO6WYvY9aJx7XDp9mfQ3rNz8Eq9102P6M1Uiy9eUNCkpfXxB33fsX3Pv6B6j029Dc3ImBsPB2oiQnF4XZudhATTV/8Ur+NqIwy4eaYTmmrxH6CWubO4wAbG1ow103Xo/eps20/1pzT8FnpnRim56n04H3rPPBfMTezOlnZ/pRUpBtlsYreTLIQNLI7iFt3FmkTQAJJ8/dmUykG2nloB+hWmq3tOFHZ56IabvswfAihIBMOJtJ+VNqcyiNBN3dXRyM1vXUXWvPImfUFrEvcwQqKjM5Yk7xe7Xu1noOoIo2dgVxzN7TUUPvlxeSRa0O7gjM8wM6QBOnTmUo3o/5K2vRuLHZaJL2tm6q9x7kkNAKQfTYeF1TJ9rbe8k4h9loSibng0WrsduUauw6eYLxEUzPt8H2nUvhkZp9NJ2nmuzqDeK2O/+My29+HOX0BQqHZeGsc05HnPW/9/EahqO0h8wvTzyDoaci0bZuxcQDaG7pwZRx1Tj/jJ8gFupDLUdsXWc/1qxciZlTJ2JYQb5FPLaVnElLJ42BdPpYR/zL0a9JrvsffAx/fOwtDC/IRBG1zbI1W0iDHrQx6mIkRu/cetZSu6UZbaKZ7hE3Wmv87CffxdHf+wEy/NlkfJgm0vKV6CawP4NtDoKuJTD3gw/x3LwVKKb/Ig0m/LQyKtQfakjEfb+zZUw7JLME0eU5OZkVDnnSycpWMXT6/QU/wE9++B06IpqNs97NE6E12oZKnLnOEaZv4q1u6sKy2ka0bN7CEIXlaFMTZMBTTzyOtRs3YcqYUTjwiKPN8+6C0mIE/H7cefMNWLlqA0oY3jz851tRWV7KEUdsDNJqwDI7gnQim82SGNTrW8Q9FLbb/ngXrrjpCVRXFcLjceGCyy+m3RyPft7buG4Tald/ita6Ony2fBUa2juQlZmBWbvNQiAzB5UjqkzeHGqJtpZG3HPnrXhr/mrzrv9eY4rxh2uvRFV1mRFa0p7klblR8Gk9Ft5GE+EsehA3Td446W8sWLwYs485nx6eDWd//xs4+KhvYPPGjehjmBcdiOGVF1/Bmi3rMWn0CBx1zHFU1XpHk30mjYrKhqOkrMxs9qDJhdIsD0YGGHnQfMQYMpotdthOCgeBKKRnOtfe9Af8zzNzMSyHmoURhvKEI/o0TsfHdQteneWINq4LZxSN/HaG11uuDQZToA2Iyuk977nHbuqe+jRYuU52AJpHEDMC1ATakiW3fASGV9egSA86Ro7Clg21mDtvIWoqy/CtH/0UFWNGIyev0Gx3nunPwmMvvIr6uk5UV+Rh+oxp20k2u5Y82h702Jk0oqrrxQ233oVrrnsRNTUF8NPSXHT5LzB64lTEI3TO6JiWFpWiZtIUTJk5Aw2bNuDNeUsxY/o4/OTc8zFhxmyUl1cwdHOZRZm5HO2Tp0xC8+ZN2FS3Cat7evDZgvnYbdYsFBYMo3AmjFmg4yHqJLGxQGd6sirbrEnMrp4Qrv79zVhH01Kdn0NVfiYqhpdiREU5ykfVIL+gAG+89Apa6hqx78GH4cBvfZf0qjQvjgwfUY2s7HyKGrnAvg73O80ewXpaKBG02rMYm84f2fqe3l7c//jz6Oihr0EaacJKgzdG8xOMRlb21NU+IG3IuNOxlibPQKqSbJ8Xq9auM0ujUte+CNSoJFQvP3ptLozM9qA4I8bjEEOaIEd7GGNGV2v/NyxZU2u2YPdTymXL5CEftv8eOP3YAxAoyMK1dz+MVatrt2maVEeHgm7pcW471eQNf/gjfstQb+TYTGRleXHxFb9G9XiZowhVfRxVBRmoyLJZH6Kml64vgWnqVpNYNr3uHVNoxFuuBEM4B0blA7uMHY5LLvo5Dth1Jux9IbxNr/3cS6/Eys/WGG1nbXw1SHj9msEhCeAfaU7h/tKbb+P+R+bBHQrhWz843ozmIgroSIaROYwc2hq3Yv7aDQi5QqjkoGAtcGnG0EbfiOpe08LDvXGzZY0WoWojLb2aTtkT6027Q3kkNNq72vHp2ibrM/1pNIzRh6B6YJgh80Fw2Z3zFfboqVVqdGvaeOnaOjS1tptcipONR5o0A0MbFGjEUhvRY9WOGwmMoDc/np7qxAI3Jud7sP/MyeR2PpqaQti8Zjmq8t0YX5yBSt4fUZyFH9Lc9PYOoKUnjAcefgRBTeRQajWaUiDiaJsYTdtKQDrpqN7wh7vw2ztfwIiSPOQw5rrgiktQOXaKWWxJDY+x2hKGQzGP98YXeDE2y2XCM2GsBauKiXNcUUwo9GBCUTbKOcJ8RjhtmDqmHOeefyGO2mMPJPqBD1ZtwvmXXmEWmUYYHYX1ORzmS8iTT0UIxFEPmfSpnHU0eb+5/c8ors7H1Mn0b3bf3Ww+letjSEmcKnIy0Fm3nt6nEyOHFVNjVqPAl8C4Qj8mMhKaOCyDx6RRng/DGObKWWbHk3zaAeN1SsHT3Yat9VjZxKjHoR3HOPqZ9C+q2dqE0+wmbigbjjuWRKUC0uysMm/oCGEDOyB1YkTKVKu0E+AQsiaVyBw6expkelNGX+fKoB9QNaIM39htPMAR/97776Onr8c8NpY3K4M/acIEXHrKsRJR3PTHJ/HhRx8ZJqcDSc1RQYVI4nf3dOHm2+/EdXe9gpH0JXKptfSqVunYieiMh5BH5k/MyjZtp0B81xZ3fpopPaSJSgBYp0cxO2NlbU1rTI/8GR55qbJ2HVuKCy44C0fusQtjZwfe3diAsy/8JdasWkfN5uXAYQfM4BhsRwQfYP0PPvoUPqtvQ3NvKw474UT48oehkFFOBoXYwdESYkj4wYfzQYnE5OkzUTCsENmehBESrWxS+K6tZeVTmKQ2zIDg7+fH4CBwwNau38IOGx3BshIAlmMd4Vh8gFcWKZuhbiQjZxXDnk3p8T2jSJTQOVu5/DNENYeZuq52k4iIOdY1K6WDeVBCBE3iuYiUE/Dj0P33pG4K4tn3lpg3eKRYDLC8n7098fhvmmghf0QR7v7rA2hpa7c6kNaGNEJHTxC33MaRf/fTGDHch6LCAC6+6koMHz0ZEcb0lT4bRnHUaHbRTgc2NVL0l7WZ9hQe6Vy9Vd1mBVIyj/koBZHTJ1nkbE0dNxwXX3gWvrkHzUHXAD5YX4eLfnU11qxex7pFWJHSkFO1M7pw4JOlK3DlXc+hjCP3h0cdjckzdkc2TUxBBtshUxXCydQ98NoixuxRTJm9GzIYGma64myfA9L0N63fSuxHqi/pNBkKmgb/eOlqlFHbWbVYvNLDLDrO6xoQMFvGGYy7P3iok+HN0ghvpirUBoa5VIUffbyUzkS3pYpNw1bjgm1ETUMqHbZdS5bTYN59l2mg4QN6w1i6aLGxu6za3NexPuzw+wtORhvNxDMvLcVb7841kmuYRIYJj56+Xtzyxz/jmtueRHFxDp27TFz46/PpVE7gCA2jJNOBmqxMjjIOcpojllID2/BJCbq6YjbEcOjhC9swGtDClblIC/7YXZQTaQJg5qgyXHjJhTj64H0Q74/jo9X1OIeaYP36jdRImrqVAFn06+jqxh1/vh+ZOX5k5GXjgG+diBwfTR1HujRejHa9j6bn9ffmUgVHMLG8mA7qNOR4OPKJrpRKOn2Hgq4NvW61zOtEvLGpkWH1p6xPPg7vsE72yCxMoQZZgE8e1+xTkjKEuM3+YYRO0bZKaUy04dFry9dj0+athkkipf6mYEdICHYmlVqzN7JyBH54+F50Mrx47Y339XEDU6NMkB532smcww85BMceQH+BUcitf3kIm+vqjbax0+Hr6enDrbffjWuufx7Dh+ehunQYzr/yGhRy5PfE6ET57BjlY8gjFJTYeT3I2QZJfBXlKJOl7tUPZU8XAKt/msCROaThoUBFMK26CBecdxaO2HsP9PXbMH9zJ87/5VVYSydOT1u1uYa2sXn9rXfx2FNzzfOP755wLCpKi8xLrnrfMKwZUtbf3NCMh56cw3DVjv0OOIDqP9+8VKqwUnMaKRyG0jj92nb3DN3JZvbrszXrsJRRh8yHemZyUcAHInQeHe7XdSqwWiH4yidQVuIn6Vs5RrVQmkW3lv4IplYUY/LEiaxE1UiOVOkgmPxpTE+320OFwUPG69pjj72O/gS90f4evPXOe3jt9bdItHfw3nsfYNEnS7CBsXo0GEZzZx/Dx9VY+elys7jzhVfm4FfXP4ryETkMF4tw3qUXoqByLAdRmOrOhpqAz6w80nyE0DXag0RIEUroyKF9iyPvg49WYtSY4dhln32R681AgV/k2B5fgcqrLlWh17s1RTxq3Hh0NGzBZ2sZInZ2o2HtSmqiYrz9zjt49Knn8MBTL8LN+gL0fxSCfbpgIT56912889ZbePv997Bk8XJ8MHc+5i1dbj47c+KPT0ZZUS5DPK8RSj2ilrYTCPehdBwKormm8FUkQlr87fHnsGlLA3xabi5+UJPZGD10BqMDQbv/sv6ty82HJrfVmrvHCb6ccOenWYFAlV4ttrMy2aneEAWgsgS33XQtcrL1NEsbxQyCEEuXwnREU4in3xcyzc2t+N4p52BtXSu2dGgzIyKoYN5JraQlZYxGynL1ORftcmVHfbAHwc4wbRU1RKkLJV4XRo8oxlm/+KVZTNnLsGYE4+OqTI818o2gqt1BfNIFQOsnrvjtjbju9qdx6GFT8POrrsLIrDyMzicORo3vGMwiTFNdhBGAvvFbj99edytemj+Pjl0m6rZ2U5URzxy78e59TpcKoWuAcXeEEQdxCNN5jSZoAhnpeOntFzjjOOiYI/Ctk0/DxEIfSgJ0TomAQ+aIbaXT7otAdNVUtRYobdmyFd845RKj5XSuiSubw41oXycaesPvN34yZ+9ksUET0PHBY0EqhzmhCBkiTZgcxZn0mJ9YuBKfrWbsy2uycelMFqTOhzI//TcFyrFhwwZ8uqEeWis3qjAbo5nG5GdiTHYAY/MDGDMsC349Xyfz9e5deYYPY0ozUcPgfEQgA+V5uWT+r5BXOYqedhijyPyRjPckLFYLClXVmtX+53FITuIon3pk0FbPdHOwD+n90THHGGlDDRh3UbVHMb6aPsFF5+IYmoPYQBhVw/0YxXBvNEe015lJZZ/BEh5kef0oZEg8nP5AVU4mxma6MKaYMT0HlN2RwbC4HgFbCMVeRgYaxcJZWA7B+8tAGkOsW7RkOZbUt5t1HSn/SQKl5w82W+IlK7cF2wRAELZn3E8vkYKkSQYtILCUfRGjgbff/9Ds6qWtSYeilc7snSEtAip10jm669770MqBLukMR/qxZsVWrF5Rh9WrGrBqfStWb+7Ams3tWLWpC6trO9DYyJFFVO2OKONgfciBKt6dyc7aUZntQYWfwsLQUDNvRGCnOKSuCw9zRJNi3gZOCruupZcdWo/OjUzwsj3m0AecMaGqiKq7AI3BCFW91ce19T1Y81Eb1i5owJraFqxmn9auY+LvmvUd5lvAIW3t7nDBG3Dj5QffwPpFC806STVg4vVkGgrp19KPjWNLJvcG+zHn7bmo1vK35EM+dS8aG8BAwt5hd/qfNReTsH0Lx9xqG7nlxcU5gcwpTq+PvpEcxQQieuLA46f+ejNGlpeynaQQ8I9wGEooIbaja0pLli7DjP1PQtWYcnrzfTh4n+k46Yffo1mJojPsRF+YZU39zK94n0TVUrJHHnsBm1d9wAAiAys3t+G6m6/GsYfthZEMm2J0q4WH1sdqAmZI00OAdZNWV153C357y9M47OgpOOeKK1CRmUsT4OS97UmSglSf9BvhIHAyn3bibmhuwpHHn4KGngiynTGzscblv74Ao8qLEIkmzEcg+hMUMgqbRqf6GWFs/sF7KzDnsSeR64+jvbsb++6/N2659jIU0Yxpiy6jaXZA23Sw7ieFmbVLABcvW4HZP/4lJlGjqicSbqWBgR50DNje2jz/+R3vE2jg2XMSDPkf1vvkUnd6u1QEc9NOLW1pxzvvzzN2xQqrLGndGYIiVAq0p4Cyqb6mtk6gk34EGaVv3hSUVKJ63FRMmjYdIyYyTZiCkROnonLiNFRNmY7AuLFYEaN9tWeDzjJsWmnpdqF5/QZ4qZFcLptemWB9VnuWGbDaT8chBbxqbKV5ikhGUG+wTyS5hO4LiJ26p1+G6eapZpi0WL9pCz5p6DCTXayJajeBYaMmYtzUGZg0fQaq2Kca9qlm4iSMnTIRldOnos9XghXBUtj8eumT9pnRVldvDza3dVEphSkAIpbaswRODNxRXyyUklEOb+u19TfeeJchfAYFjUKXLCuc+4J6VwEPm4JpYFErDeJO/8MDkXiH9rBPjnPT0qRhOXj0mZcMA1Pe6c5ADaYTU0RPnaXUrUD2Xevx6nviWFwfwrvrujF/SxAL6wewoKUPbzf04J5XN+E58wKJl4PbmhwZTR/hsUefxq033ITVa9brEkcYfRc6kNs9Hk4DYWzwEiYqoAtu6QxLUMwl86sbn4fUdf1qkWxDQwPupCk79aIrMZK+izz9BD1tr0efi3FhcVMMr67uwjvrevDhpj581NCLRY1deOTDZvzivX7Wo+VfTjJL8wdx+CgEA9S0wYj16pacx0HyD+lLGi4a+Vo2JtO4fks9Hnj+TUzM0QYQEgqrP4oKwnHb5oTL/aQpmAafE4CGhc9u5Yh4ODTQbyEhShEBbSH3Or3ed+d+aC4NstSCFFJDwVzfdmtQXQmsL2jFzDq5pn4X2uIZ6IYbHVSZpBmeXdSCz1ozUMyoRNVomlmgBznaaeumJ1/GN08+Gw898Qxau/soSwx1hhBLYB5jixgaSfqnYxEoKi2nUaI1iUJS+Fm/FmxDnGD5CwOhEJ575S2cwHbPu+RubOxlCXrZMj1Rm8ssBvXSJPWz7g29drTG3Oii1mqOuPFKbRgvrBhANR3cmMvOEenjIBgwj731xo82ug7RtCRdUyaR3hpMQ4UgBXrPSN8OitPEvPjam/iU0ZKL7Zvc6iNhgA4qvbfHGuY92WUupMHnBMBAPH7XQCgYjrETYMhCmTQ8m0wt8LdHnjGbPWlnDuFkEcxCNB0swiar5y0pDTHRFJKyJDO1R69WyOq6HCCZBTcFopfaZ9HyenR3cZTQM06YbVv4mxBpGIJRYIoKh6EqK0D72YMf/uxKXHjpVZj30UKzHYpZ9mQ1azGHDQhPMd16JMoGyXQt03XG2T+733xwUaPGoGcQtQRFOGpFbZTaZfGyZbjk8qtxzHGX0UHtRnZpNvYaM8JMAMks6gVb9sT0Va6ElmRpVs9Gs7CBfsvK9SFk6ckcz7VHQsIRNI+eha0EU2XMwOefwR4IHeEzCCla61c5td5i3cZ1uPPBlzGV2pFDi2XkyDP05OjvjyaoXFx/M4WGwA4FYMuy11eE7Z5H+ik5Ip1l80E758Q7a+rw2hvvkIW6JgQsZL4YJMHJQ5Ywfw1xJWtOqm09So5Q1vSxxgg++LQJjQMuMyqU3ZDDlGdrJLI+HHnQoUfikit/i/Fjx2oVJt6cvwx7HHsGrrruJny64jPTitbAJWLsA+2qUdH0/uR867NvDn0kkvfJNdr/IIVP3xmgI8VzOePyFPUlT+G5ta4Rt9/9P5j+7dNxx0vz4Cn0ombkMFx59YX44U9/Yj52aYBISkkJ1zgrSTDMUcTyyYYgPt4Uhc/hNXJnvrHIPPJAxHFDYV1LMdr0dRvBvgRsCMVseOrFOTSl2lsoedmUTyDIARFO2P6nYcEzK6zr2wPJsmNwjZiyxhGJ/MjrtLttUq1kuRDM93nxybLlOGjvXZGXk83ODiK6M0lVbyVEmndft3EzHrz/ReSX5Zr9A2bMmIzRdPa6eH8Zbf4HK9vQFfOZTSMVcmo4ae1+rO4zROo/IyMdRkgO3Xs2DjxgP+y2++4Ynp+N5SvXwk61+tbyNebT8V5GEAWFxfBnZ6OjuxNvvP42nnj2Bbz+zly8M3cePly4BHFNytMzaq3fhMXzP8JH8xdi4+atCAQC5uXYZvo72tb2gst/h789N89s2uCh9vnZqSfgh2eehnHjxyPCSOaJZ16Eh/6E5EZPQQ844gg4/ZnY0BHGB6u6sbE9CKdHL6FQXZNDEgB3Xwt6V79vzI92Rq2uGoFpu+2OwoALPmo8I0WGdjJbgzCUxnrRZvHyz/DDa+7A6LxcI7wSJs1zRLUkPBjiEHCc0le/uilZZDvYqQD0b/2sJbuwupqKd5pHe/wk7bYmFja39SFAHGdOn6IZRjOQhFaaLGyDFMJkIxFLoHbDJjx0/wvILc1Bd38Es2dMxOjp07B4cw8eX6q1ByQyy6gj0jJaGqVnALG6lbDVfUItkYO2YB/232M3TBpXg5qKXEyeNAkzZs6kIxjD+tpNZvvWpz/4GK+9/horieGhhx/HLy+4ndprI7VLLT5YWms8f3nu/YybF3+6Ch+urMU7i9fiuWfex/yPPjDLxe+87wFc/8cnECT+A9EBfPuIvXHOBWdj7/0PRH62H6WMtZ2RIG566HkUeGTDacKQgYOPOxQtUReenN+CrQwDvWIKGa+XX6SWRUM7BSfy2Sv0BbyI06+orK7AtF13RYmfNZCpSStu6LeNhvw1al+3dJ31dvd248bb70ZtXTdy2VBqDkFRSl9fD0NQ12MNC56701SwA2AVOwc6DjcFo7G+CG1yCqSwKvIycf0Dz2PBJ0t4wdr63IIdSIABWTgLxFiTjx3RN/bkBS9c34U75zfTKybidD5toSBs/b087oRTqb+DyNCRYVumLL1eCaVsvb6dXehzYu+Zo3HJL87E3X+4Bvvvvhscrkx0MzA4//p78Px7n2LMrmMwujQfo2gjRxVmUkg0205iEqFhudmoysvB6AJ9xnaYWZBywe/+ivnL14FGG7tNG4N777gBZ55/McaOn4B8r80sytTOpVqfX5JJH4Imw0GmO90xrG1rxUNvr0B9WxD+SC9s4X44yWSbSUEkwgrJtDhV8wnawo0UoqYz718Y4HAbMppSQmABjSLva7Lu9bfn4k8vzkOZX6uH2R/DfIfZcIqDv28gGr8iWWiHkF7rDqFil6N+43MmLgv4faw8qZapDLrYibHlufjDddegtLiQndGcviRUTpZsNhFkMlKrAvTsHY4YFixdiV2nfQfVM8uMEOQUFaPbU2C2mNGKRPMxRmbXJJDNZr2noHqj/V1w97ezjgysamjEvTddi4P22wvl+V4VYj46PTQVvaE46lo6sXDhJ/jrnx/A2tZm+Hk9Tju9YVUrEGaXM9iAZslEcC2ElWHWW8XeBKorcszGkXrfTjOVp599GqbuthsyMzMRoPNWoM+6cYSKcGJaQ2Mzfnz2pVhVu858ldTmGoDPX4WuEPvrpo03FE6RWb2RR0NhiXQg2tdt/JR1De246JyTccR3vmtWK+VmMEqgM5E+OlOj3wJG+Y441tKcHnP6JfqKDp1NKnP+J+mNFmjv6EBf1HZD3aKXL04W2iF8qQBkTTggkO11LsnN9FXrM7J6z13PzWXHNrS04+IfHoOfnXayeZtG/ROilrSmCwBvGMFImBc2zjr3l3j07SUYVZxDX2uAA5ohp7ElImxKxUnCrTq0i4e+8KFFKnofXpM3+TlZ+PlpJ+GYw/dHwOe3niGxLLMJCWyua8aPTjkX65vbYactHDtuNG3395Bli6CbQtDGmDtB58nN+rUczkZua3fUpx55Bes3raDajiLUH8PNd/4BUyeOBwe8WaXjlmEisSPsjx653nff/bjvtQ+RTRkyey0xOorFPAwZe+Bk/er6UAjZPBSeGPNTSIh3TzCMW/50C0qqqzEm14sC+hMx1pNeNiUA1i/Q19+Ha6+/BXfMWYTxeQHynsOMA1Teboj3ujv7NoVi9qmNS1/uTFaxQ9ipD5CCUMuGsLdsbIMtHv22NirSa0USTTEqh2rn/g+WYXZ1MWqqtDN9ivmDYM6THdHjSr/Ph4qKCjzz8uvo6A/DfJbeyXiYsbG+HAIbk37pC+hdfbtDv/ryhrZ+6TeLVQe6w2YXkb8+PQddDVuQm5uHgvw8swxcHeLAxIpVq3HlL/6EwpFF6OsNYvykcTjxu8dj1OgaBIrL4R9eYbavUaoYUYZAWSU+bnHiXTqh3rbVbDMD6yhEE8ZXY99dpiGPisJ6OZOCv6UOjz7+FE6/9Dd4a9kGs7FDJgdHb1eQISHDQJeYoSeTPuan/5RKjAKUpEWpSxGl1qldsgW/+M0FGDdrd3NdTwO9Yj6FyYSt25PT0q78ffL5l3HRHU9iSlEu8/AK88m3UBTS3tujZX6nNi5+yaz7+yL4UgEQ9NWvXekrrimklM3yuMkMomDUEVNRhhNvvD8fe+06EyVFw5IldgwSBkUTJTQZU6dMQltzI73uOoZ1vWjr6qfaUgqivZOpu8/sFdTeN4CO3hBHngNHf/NQ/OjMMzBqwlh8VrsePWTs/A2N+MvDz6K/tQ7akDIzMwAvhWwJQ8FHH3wDuWVZiIR7UTOqEhNmTMeGHuD9+ijWt9uwqSOC9X39WNcbwYufbMWDa8Iobm5AovUDRNjPXo7MmdMmYObUKVRIMaxetwGPPvEMzrvyFjzw4ofw0FT0dYfwo+9+Ez897QyUlZZgxdpaCk4bOpuJP51l05dO/rb38JyJGrC9J4gumrxxoysYYZyDWfsdgiiZV+KjP+KzzKxZqZxkvuiWMqsSiE+WLsMZl/0BIwoKOODJceXhfc1Z9PT0oCcc+VvTold+a258CQyRr52Df8J+2YUZ3oU5Ad8ol9nckKqZpV2MsVv6Ipg+fhRuuvpSFBfkkMXWpEb67lUp1SVplRD0ROxYuqEFDc1tCNEW6iGJTIB5bdkImMTMKqd/mVkB5JSUIsqQNEZmRNqb8O4bb+CRp+agv7ETbXTMEOzGsXtNwTe/cQxa2rpw/nX3oKo4C5097Tji4APxk3PPw9aIF6tbtbsO1bQjQg8/io/X9WJxXZCefBThpXORWPKo2cS6ubMXxx93OHafPhVLFn2MW194m+0OoCDLS7Xdz1B0Jg4/7kSMmjyJUZENfjqU6zY2oJvMRjSIAU3GqA9MTpo4q/8aN1G4qMlyi4rMmv++hAPZ9gim5GbA5bZopg29rW3tLQWqQ3n2GzZvwc8vugyr6geodTx0qukrGeaz+wMhvXfYFHM4ZzbMf2GrKfwlINy+MpTOOOqQgDM+JzM7YCTSgJhMvbOWjtfZxx6K8846BdkMkfTihMVCC7Y5hjohFZyJCBr6aKsZK1uXqO5YlxCSKlNgYRLr0TRunKGgTEgsGkG+z4byPK/ZWm3p+s1448238Npzb2MrncMILVSojXkK/cjjaNJS91ZGFscduB9+fO5F2Bh3YE1rgk6THb1sYMHaJqxt4LlZkBJBbPE7SCx62LzjL/04EIpgIwUM1C7yFeN0fo/ef3ccwlh/zMSJyAwwoqBzW57lQRZJUtfJfvWQIS7r0XkKFCmZfxJoJk2DR0i3MIXZZz6akYFcMlgPzsxgYZl05ujl1k5qxF//7g94+O1FqMql6RRdiJSc1UQsgjZqllA08p26j197NFnsS+ErmYAU9DSsWRcoGV2YiEdm6Q0agZDUtG4+/YHHFi5HodeBqRwR2gSaXDd5LNCoZn4jCLzFDvlpK/UeaMJaqWoiAE33ilipaVHzS1Wj99oCjjDKMp0oCzgZ/kWRTWdp5LA8jJk6CVP2mI1RIysYbvWjlsLoozOkL4RK2PTm78TqSszYfS90U8toLYJWDn+4ognL25wI6ONUCnrppMYaNyJRv9Q4nercAKMHfTF8SlUpjj30AJx1+k9x8DHfxIjKkcgLeFFKtV3GyMBHp05Ri59hoebiQ1HNvzNE5viQNpMuUF/0LDXKqhP6Ohg10DD2Z3SmjxqAAkGPUItLBcxqBMEcC4/wAO6892+47rG5GFeYxfvUwHKMOVhYm3knMhh33lW/8KXrTaGvCFYLXwPKZhwqZ3iuL8MzVTuJ2iix5jv2JsCPYWFDJ+675Gf4znFHUzJ5T6OenbIe0ihZjVrfAGYcTHUobaGXJ0UoIx3KYTovsyFp4TGr1wJH86CDo9qaUGGLJLqDozoUc6A9GkdjexdWf7YGr778Kua89S6dzAw0d3fjWwcfgJ9c9AvUwYsPN/bhw5UdaO0hw0hEI2jUofLuox+/htgnD8NF30bfJ9539izsdcCBKK6pRh4dTR/VbhYFK9fjRBaHnmRMy+fipEOEZkAmWT0LkfOKLA2wD+YdQjak3unrpBobenTsUj/NdUYXyT6L8WaBB3+lFbXJ430PPowzfv8gppcOs8aVGRTMwhNt99IZDM2rC2Xtg+WPKR7/yqCqvhZsXTSnL2L3nhDqD9fFqB6p7Mh86kYe2dnJXYrycO5v78SzL71KTz0iFvKf1TGrOY5y85cdZuf41xBezxl8bjvVoYOJv25bMjHGJaE40Gi3WRfpYp6hG0LJl9aTQn14IY5ilp9Yko3D990N++2xK1pq28yoC5NSYZbWP23U/OyKFrRR4jKorfTFcjFfMb2mhmN2rT6K8NiG+tYuTJ02C7vsuR/GlJehJj+A0TkeVFHd57EtrQBQ7/SZYrOFDMM+RfnSZNo4K8A+mURtqX2T/V47AkzZ7J82sfAYs8fmWIfMnhEEMtsIvejF/9F4FE888yyZfz+mleYRT9JMITMjJY3+AfpPHb19W/rg+f7XZb7gawuAYOtHz65hHHxib7A3qKdNKbsmhCTFo4uycfZvbsXzr7/HeJkOl3mXzcqTAquTSUheN4LCOizvwRotOtf9tNzbQHWIgLondaiSbvoWue4ECvR1cMbxWigSYHJ5EljDSOPxBR2IUwdbu3NbwqunfTIxDoagvMr4vMdiDMNe7Z2gp30VOS7k01ZnSNXLVxHOKbyS+KcgdU/0UDdN4vVtiReMZrQy66+5lrxijjXKZdeffPYV/ODyP2NqaQFxtaIBvRWl0T9Af6StO9Qfi9l+0LnoWfOix9cFy+D8L6Crfu1mT2F1bSwS/raWkgsx8+oS7+lYD07un/MuakqGYXR1FYms8ZskTrKjgpRQGGYaolmj4KtAel4daxQqiXg9Pf24955nkFsSoEfvRjTch3m1dVi3Zguy65chUbcCtq0rkNiiY6XlwOZVsG/5jI5mGD4KTSPt6reOPRpV5RUMzzS2iSu1jSC93XR8dS5Iv5+Cnd0bzGP1X/TTh6gee/o5Mv8eTBs+jN6+hELzAtQu1E5yhtu6eukJMd5fMue5ZAVfG/7XAiDobVy3wl9c3R+Phg7SRo9akCHJpkkkwnbket146MW3UVFUgBo6YRpJMXWQadt7boQdEevrwiATWDf/+TL92NC0GnNXNqEwy4murj4EV6+Ev20Z4o0rkWhchQTvx1uYmtci3rQG4ealSIQ7qJoZ3w/EMWNaDY745glm+3azwYIEgIJhLZUbhB3h/WV92VHfdSwtNhAO4/5Hn8JPrvgTppQXcPAogxw+DTT6KczX0dFOHyN+bf3iV242Ffwv4e8SAEF3w7oP/MWjCuORgVluzZETQXVETJCa0obLj746l7YQGDduLG29dJv5zw6pBhHUSl8EX3Y/BalcXjpr5RUV+BtVqIcOlWYJ7YpcHLSdjgwmD2xm7x0vnQsde81Wbg7aVjGgjekXvzwfpWWVjFTiKNB6/W21DwrvV8UrBUP7mn7spBPZ3dNDb/9+nHvbk5hank/mWxpBAqCnonIOO7s69IbPLfWLX/tFsuj/Gv5uARB0N9S+7C2qLolHozONOVAIZYTAUls5GS48+eY8RPt7MHbMKGRnBoyQ8L8BEcEITfI3dW1nhBKk3x96T6Ar+vbPpLHVWLpsDT5dXov2YBDtvSG098T4q+1ZI8nzENp4rtnHtsZWjJ9YhUsuvRBjp0zRQ0gUZzvhp8dvhVxqb/s2UzgPhR3ht0NceU10qm9oxI133I2rH34XuyQdPt1T0p6GekDV0dGB/lD07volr5+dLP53weex+TugbPrBf/I6EqdlZmabuX07QzxiTwqpI8Da1m4cOXsCLj77NIwZVQMbOyQPXFikHKuUIKTDUOEQpPLsjPhyHhVpdIcTDPnqsXXjOrSQwNFoMFnGMkXWilr5DXQUSeS8wgKMHDsO2bm5ZlvXAMPB8dqRw4S5atNqL9Xul+Gxs/tmPoT1xWO04oxElq9cg9/9/g68smITRuXlkHYJRPWwiA6fJnqi7E1HWyv6w/G765e+dnqymr8btqf0PwBKpx10l8/hOF1Tt1pEKTDebZLB+qq2x+vElT//KQ7Zb29kBfSEUTFvchEEO55idop4gtS1oYQX7Ij4JryEnrjF0cARr/2n7fTyGVWb1chkPzWVQjaVZd38p4hBtYbpBIYYCvo8cYZ9WQxBmV9qmLCjtlK47OieYOj9VItibF8ohtfeeR9X3ngXgmEHcvykg/CjKY0zrNb+CVrW1trRRoFM3F23+PV/GPMF/xATkA49jetf8hVWx+il7q/JIfNdHV4XDbSq10eHSqPtnmdfgysUREUlbWxmFpnDPFaQn8w/hGg7IW4KlD+VzLl1UQWRQb9Dh+FQlHF1zEwvmzCM+MQYZytpraF2Dw+T8XZnGHkBBypzMhFgOfPiSfKfVPWX4ZIOKqP/6aCxL5te19SKP//PAzj1d39DUSCHtJGjZwm+6CFvX9vWtXZ0MxzF3bT5/1DmC4ag9o+D8hmHnk6X5dZMX4ZbG1Fr5MnzNyvxSWyN0K0dAxhTVYKLzjzJPHL1uBwckeQZiSx7K4EYpPWXC4AZOalfXtNfqXhjXniN/MdAVJNPRteoFP+LGSazERYtRNXaBob81AhkvoaI6jPe/yC5hgpB6t7gdeKha4ahTFp/QIHTukht0vD+R4tw490P4a1VmzApP1sKknm1zkJPA9k2tUO4v59+CnVRwn5ZwycvfqWne18X/uEaIAV0DD/OKhk1PxoKHcz+B7RRkaQ+TuaSHYY5mbSvvTQJDz7zKnrbmjGsqAjZeblwa4m2FmlsQ0/E5980BgjSz3Ws9DnGmJb4S6rKo1YUohlHP2NSv34pdNsSr3mYR9Ozpm79qnRalak2U+2lwIrRrfbNZfNHs4V0hKO04PKL+Wf9ljrcc9+DOP26P1O1JzBcL7WKIiSSfBKtq5GwBvv60dEXbqARO7nhkxfuNo38E2CwB/8kqJh6cAWdvb94vRkHeun9O9xOM/8vqopXGoASiPruEG1uDGf/4BgcfejBKC8pIlEpMPIPxAZmNON2e/4asIieIv7nhSAFKYZ90f3UvVRewdD8Q9tInaeXMcBhrT38mAOt3e14+/15uO3PT2JBUy/G5+ubABRy81YPyzOX3jVMUFg6evrpD8TmRR0ZP2hY+NQ6U9c/Cf5pGiAFXY3rurqy9njQ6+wNhEOhXc3MvYvxOFWzWUwqyacI5FDnakOpF95diAXzPjHOz7Bh+WYTSX34IGY2sVKNJFKSzmZ0mrQ9M3YGQ+99UV7Bzu7revo9HRs9o+sGF41mJvo/bb19eP39ufjNTX/CdQ+8jlyXF6V+OqBmf2BTmIJOw0h66P0CMb83ivvqohnH9y5+qsXK9M+DL6bAPxiKph24n9vhuNXj9kzSV8XkIJoXMigABhWpAxJP06DLmrpwwKhyfPeYQ7DPnrujZHiZ8RG0mFM2XITTIDQkNwZUl3S8vTAMHdFD86QfC4beT4GupdeRAuu6RjnLEH+9wxCisLa0tWHxJ0vNOwoPzV2OcfmMJjwUfIJVPFmXMYl29PcNoC/Y3xiNJy6pW/LKDt/i+WfAYE/+RZA5/Rv+bNvAdQ6b7Ywsn8fh8eiLotbsIV0uJpkGM57MO/TLWvswuSQX3zlqXxy8314YXTkCGdranjTXa2L6FmF6N9IZmO6xp+pMUn8bpO6nIL38zoQhJQCmTh5b53Qyw2Fs3NKAt+fOx7OvvofXl27G6EI/srRRU7JZlVESbkrh8AB6gyGWxXORaOychmVzNlk5/zWwPTX+hVA64/BdnbbE9W67fW9/hg8e4ySKjEmGmSRHkGLBEdXQ3mvmwI/eezoOOGBv81XwESWF8CYXpkgLmD0KzTH/kOJyqox24LmpVczSrzmxIHUoJ1EFzTl/05mcAtZm/TKv4nTVpg8yNLa0Yelna/HmOx/g+bfmo5mjuSpP7x5obiMpoPTwrRp1xpiIWi4Y5KgPReroIp7f8Mkrjydv/0shhdO/B/Y5017ave5n9Lp/HXA7hunLZQ63R14hgcQm0SzQqOFlxu9dJNq6jnZMLM7DgXvMwuzZMzFhTA2GF+bD72N5+hciucrIgWQIz07aoBXag71NaRyLwSkPXnsEGB7rnvIqDiSovORBzNRLosG+Xqr4TqxevwkLFi7Bm+8vwAcbGlGVEzC7fkuWTDk9wDEHwkgqK2FCwIFQEL0D4Ugk4bwnbnNc3bTohWZl+3fANpL8O6Fw+jcKbbaBn3kTidP9Hnehx+c277zpww8Ci1eWCtfo03bzmsjppupc19aD/EwP9p9UgylTJpop5pqKUpQUFyCDfoa2hHdqtBpJMFy0mM9ji/mm1mQjVnsC1a/3D+i4cqT2oaGxEeu3Mm2uxxLa9k9W1mJlRz+G+zwY5tcCU8ufThE0ia0lWKo+JsZH0KcNo2K2V6I256Wti543+/X+OyGF738EZE84uMDjtl/ktsfP8LtdmX5pBAkCsdToF8Ms1TyItpZSaeDqg8pt1A7Nvf3Io82dWlmI8tJhGFVZicKCApQUDoOX9fkZVVDIKBwZprx269SLIX0c1fq+b7A/hN5ejvCWFjTRkdtaV4cNm+vw2cY21AXDKMjwID+QQcFymkkdyyxsbzJSOEqmZJa0p0BfaEBLxJ6C031Dw4IXPzKZ/wNgkJL/QZA3+ZAKL3CCx2k/hXQe5SFDnfrCiHEWDWmTOTVmLcdRQiC6a75A4aUiiTDVbbe+fMKRF+S52KX9d/XJ9iyvm3ni0NMKvcLdynzKYX1k2YZspx2ZjDp8zOuhn6GncYav8jNMO9bINmGpSvBYWJlnC/JH6BtEyPj+aKKfjH8unEjc3bL4lXdU4j8JTBf+U8E38YiMHHvkOKfd9gOa0wPICLt2KtG7e4qdhX1qIyuBmD8UjLpPA+tUTEuWMX+tGnRs5RdDxda0skRgKEgIVI+ViyaDcXxEn4OJRhGOxNfTvt9H//XRpiUv15os/4HwHy0A6ZA7cf9Jboftm0zfc9ndo7XHoJ42at7eaZbMiCFKlsMo+DzzLTNihZ0azHQSkw7g50CX0gQq5Y8YpifrUYpE4kwx8/XxcCRUz7E/J2F3PRW2ud9p+fhZvVn+Hw3/NQKQgpJdjvC5o7Ep0XjiYIcNB9D3mup02DJdVNlORQBkrvW5WQftuxaKEshHEyKK64RUyCcBsCZxLDJItSuHpd6Tal2M5rUoNY12ENGSdDFceyYSh1A8alsZjznejseiLwXD0Y87176uZcX/NfBfJwBDoXTmoeXk7nR2ZB/G/bs4ErYxbruzwHyJVOvuKQJakBrVokraf7KV2aUxLCZrqYUcSUFKABQB0DOETU8O6Vxow8V4PAIyuj0atW0cSEQ+jABzYXcubu8OrsOG91JvAPzXwX+9AAyF4TOOLmLcUBFHrDJuj46jV1bkstknuGKxEnY3jz0WZ9XvPKp/u2YSzXuIibi+Xhmirbdz1PfGEGsI2xKbqSw2JOKxtaxvbSTmWtP66X5NwKWWKvk/AP/nBGBnUDnzmGw6aC5Zbrs9Zks4nBVktJ5K8S51QQL1of5Yr8NJD8PtCW3+5Ikeq+T/ZQD+H1E+eZwir9bXAAAAAElFTkSuQmCC"        
    }
}

def create_assets(asset_dict, asset_dir):
    """ 
    hand this function a dictionary of assets (images, mp3s, whatever)
    and an absolute path to the data/asset folder. 
    The function creates the folder and files from the base64 strings
    if they don't exist. If the files exist, an md5 check is run
    instead to ensure integrity 
    From: https://stackoverflow.com/questions/36719792/how-can-i-pack-images-pygame-pyinstaller
    """
    first_run = False
    if not os.path.isdir(asset_dir):
        os.mkdir(asset_dir)
        first_run = True
    for label in asset_dict:
        asset = asset_dict[label]
        filename = os.path.join(asset_dir, asset["filename"])
        rewrite = False
        # no need to check file if we just created the data folder
        if not first_run:
            if not os.path.isfile(filename):
                # the file doesn't exist
                rewrite = True
            else:
                # file exists - make sure it's intact via md5
                with open(filename, "rb") as f:
                    if not hashlib.md5(f.read()).hexdigest() == asset["md5"]:
                        # the filename exists but the contents is wrong
                        rewrite = True
        if first_run or rewrite:
            # one of our checks failed or first run - write file
            with open(filename, "wb") as f:
                f.write(base64.b64decode(asset["data"]))