# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetApiConfigIamPolicyResult',
    'AwaitableGetApiConfigIamPolicyResult',
    'get_api_config_iam_policy',
    'get_api_config_iam_policy_output',
]

@pulumi.output_type
class GetApiConfigIamPolicyResult:
    """
    A collection of values returned by getApiConfigIamPolicy.
    """
    def __init__(__self__, api=None, api_config=None, etag=None, id=None, policy_data=None, project=None):
        if api and not isinstance(api, str):
            raise TypeError("Expected argument 'api' to be a str")
        pulumi.set(__self__, "api", api)
        if api_config and not isinstance(api_config, str):
            raise TypeError("Expected argument 'api_config' to be a str")
        pulumi.set(__self__, "api_config", api_config)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def api(self) -> _builtins.str:
        return pulumi.get(self, "api")

    @_builtins.property
    @pulumi.getter(name="apiConfig")
    def api_config(self) -> _builtins.str:
        return pulumi.get(self, "api_config")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> _builtins.str:
        """
        (Required only by `apigateway.ApiConfigIamPolicy`) The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        return pulumi.get(self, "project")


class AwaitableGetApiConfigIamPolicyResult(GetApiConfigIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiConfigIamPolicyResult(
            api=self.api,
            api_config=self.api_config,
            etag=self.etag,
            id=self.id,
            policy_data=self.policy_data,
            project=self.project)


def get_api_config_iam_policy(api: Optional[_builtins.str] = None,
                              api_config: Optional[_builtins.str] = None,
                              project: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiConfigIamPolicyResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.apigateway.get_api_config_iam_policy(api=api_cfg["api"],
        api_config=api_cfg["apiConfigId"])
    ```


    :param _builtins.str api: The API to attach the config to.
           Used to find the parent resource to bind the IAM policy to
    :param _builtins.str api_config: Used to find the parent resource to bind the IAM policy to
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    """
    __args__ = dict()
    __args__['api'] = api
    __args__['apiConfig'] = api_config
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:apigateway/getApiConfigIamPolicy:getApiConfigIamPolicy', __args__, opts=opts, typ=GetApiConfigIamPolicyResult).value

    return AwaitableGetApiConfigIamPolicyResult(
        api=pulumi.get(__ret__, 'api'),
        api_config=pulumi.get(__ret__, 'api_config'),
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        policy_data=pulumi.get(__ret__, 'policy_data'),
        project=pulumi.get(__ret__, 'project'))
def get_api_config_iam_policy_output(api: Optional[pulumi.Input[_builtins.str]] = None,
                                     api_config: Optional[pulumi.Input[_builtins.str]] = None,
                                     project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApiConfigIamPolicyResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.apigateway.get_api_config_iam_policy(api=api_cfg["api"],
        api_config=api_cfg["apiConfigId"])
    ```


    :param _builtins.str api: The API to attach the config to.
           Used to find the parent resource to bind the IAM policy to
    :param _builtins.str api_config: Used to find the parent resource to bind the IAM policy to
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    """
    __args__ = dict()
    __args__['api'] = api
    __args__['apiConfig'] = api_config
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:apigateway/getApiConfigIamPolicy:getApiConfigIamPolicy', __args__, opts=opts, typ=GetApiConfigIamPolicyResult)
    return __ret__.apply(lambda __response__: GetApiConfigIamPolicyResult(
        api=pulumi.get(__response__, 'api'),
        api_config=pulumi.get(__response__, 'api_config'),
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        policy_data=pulumi.get(__response__, 'policy_data'),
        project=pulumi.get(__response__, 'project')))
