# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EnvironmentAddonsConfigArgs', 'EnvironmentAddonsConfig']

@pulumi.input_type
class EnvironmentAddonsConfigArgs:
    def __init__(__self__, *,
                 env_id: pulumi.Input[_builtins.str],
                 analytics_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a EnvironmentAddonsConfig resource.
        :param pulumi.Input[_builtins.str] env_id: The Apigee environment group associated with the Apigee environment,
               in the format `organizations/{{org_name}}/environments/{{env_name}}`.
        :param pulumi.Input[_builtins.bool] analytics_enabled: Flag to enable/disable Analytics.
        """
        pulumi.set(__self__, "env_id", env_id)
        if analytics_enabled is not None:
            pulumi.set(__self__, "analytics_enabled", analytics_enabled)

    @_builtins.property
    @pulumi.getter(name="envId")
    def env_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Apigee environment group associated with the Apigee environment,
        in the format `organizations/{{org_name}}/environments/{{env_name}}`.
        """
        return pulumi.get(self, "env_id")

    @env_id.setter
    def env_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "env_id", value)

    @_builtins.property
    @pulumi.getter(name="analyticsEnabled")
    def analytics_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to enable/disable Analytics.
        """
        return pulumi.get(self, "analytics_enabled")

    @analytics_enabled.setter
    def analytics_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "analytics_enabled", value)


@pulumi.input_type
class _EnvironmentAddonsConfigState:
    def __init__(__self__, *,
                 analytics_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 env_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EnvironmentAddonsConfig resources.
        :param pulumi.Input[_builtins.bool] analytics_enabled: Flag to enable/disable Analytics.
        :param pulumi.Input[_builtins.str] env_id: The Apigee environment group associated with the Apigee environment,
               in the format `organizations/{{org_name}}/environments/{{env_name}}`.
        """
        if analytics_enabled is not None:
            pulumi.set(__self__, "analytics_enabled", analytics_enabled)
        if env_id is not None:
            pulumi.set(__self__, "env_id", env_id)

    @_builtins.property
    @pulumi.getter(name="analyticsEnabled")
    def analytics_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to enable/disable Analytics.
        """
        return pulumi.get(self, "analytics_enabled")

    @analytics_enabled.setter
    def analytics_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "analytics_enabled", value)

    @_builtins.property
    @pulumi.getter(name="envId")
    def env_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Apigee environment group associated with the Apigee environment,
        in the format `organizations/{{org_name}}/environments/{{env_name}}`.
        """
        return pulumi.get(self, "env_id")

    @env_id.setter
    def env_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "env_id", value)


@pulumi.type_token("gcp:apigee/environmentAddonsConfig:EnvironmentAddonsConfig")
class EnvironmentAddonsConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analytics_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 env_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Enable/Disable add-ons for an Apigee environment.

        To get more information about EnvironmentAddonsConfig, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.environments.addonsConfig/setAddonEnablement)
        * How-to Guides
            * [Enable Analytics Add-On](https://cloud.google.com/apigee/docs/api-platform/reference/manage-analytics-add-on)

        ## Example Usage

        ## Import

        EnvironmentAddonsConfig can be imported using any of these accepted formats:

        * `{{env_id}}`

        When using the `pulumi import` command, EnvironmentAddonsConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/environmentAddonsConfig:EnvironmentAddonsConfig default {{env_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] analytics_enabled: Flag to enable/disable Analytics.
        :param pulumi.Input[_builtins.str] env_id: The Apigee environment group associated with the Apigee environment,
               in the format `organizations/{{org_name}}/environments/{{env_name}}`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvironmentAddonsConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Enable/Disable add-ons for an Apigee environment.

        To get more information about EnvironmentAddonsConfig, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.environments.addonsConfig/setAddonEnablement)
        * How-to Guides
            * [Enable Analytics Add-On](https://cloud.google.com/apigee/docs/api-platform/reference/manage-analytics-add-on)

        ## Example Usage

        ## Import

        EnvironmentAddonsConfig can be imported using any of these accepted formats:

        * `{{env_id}}`

        When using the `pulumi import` command, EnvironmentAddonsConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/environmentAddonsConfig:EnvironmentAddonsConfig default {{env_id}}
        ```

        :param str resource_name: The name of the resource.
        :param EnvironmentAddonsConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentAddonsConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analytics_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 env_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentAddonsConfigArgs.__new__(EnvironmentAddonsConfigArgs)

            __props__.__dict__["analytics_enabled"] = analytics_enabled
            if env_id is None and not opts.urn:
                raise TypeError("Missing required property 'env_id'")
            __props__.__dict__["env_id"] = env_id
        super(EnvironmentAddonsConfig, __self__).__init__(
            'gcp:apigee/environmentAddonsConfig:EnvironmentAddonsConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            analytics_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            env_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'EnvironmentAddonsConfig':
        """
        Get an existing EnvironmentAddonsConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] analytics_enabled: Flag to enable/disable Analytics.
        :param pulumi.Input[_builtins.str] env_id: The Apigee environment group associated with the Apigee environment,
               in the format `organizations/{{org_name}}/environments/{{env_name}}`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnvironmentAddonsConfigState.__new__(_EnvironmentAddonsConfigState)

        __props__.__dict__["analytics_enabled"] = analytics_enabled
        __props__.__dict__["env_id"] = env_id
        return EnvironmentAddonsConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="analyticsEnabled")
    def analytics_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to enable/disable Analytics.
        """
        return pulumi.get(self, "analytics_enabled")

    @_builtins.property
    @pulumi.getter(name="envId")
    def env_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Apigee environment group associated with the Apigee environment,
        in the format `organizations/{{org_name}}/environments/{{env_name}}`.
        """
        return pulumi.get(self, "env_id")

