# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityActionArgs', 'SecurityAction']

@pulumi.input_type
class SecurityActionArgs:
    def __init__(__self__, *,
                 condition_config: pulumi.Input['SecurityActionConditionConfigArgs'],
                 env_id: pulumi.Input[_builtins.str],
                 org_id: pulumi.Input[_builtins.str],
                 security_action_id: pulumi.Input[_builtins.str],
                 state: pulumi.Input[_builtins.str],
                 allow: Optional[pulumi.Input['SecurityActionAllowArgs']] = None,
                 api_proxies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 deny: Optional[pulumi.Input['SecurityActionDenyArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_time: Optional[pulumi.Input[_builtins.str]] = None,
                 flag: Optional[pulumi.Input['SecurityActionFlagArgs']] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SecurityAction resource.
        :param pulumi.Input['SecurityActionConditionConfigArgs'] condition_config: A valid SecurityAction must contain at least one condition.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] env_id: The Apigee environment that this security action applies to.
        :param pulumi.Input[_builtins.str] org_id: The organization that this security action applies to.
        :param pulumi.Input[_builtins.str] security_action_id: The ID to use for the SecurityAction, which will become the final component of the action's resource name.
               This value should be 0-61 characters, and valid format is (^a-z?$).
        :param pulumi.Input[_builtins.str] state: Only an ENABLED SecurityAction is enforced. An ENABLED SecurityAction past its expiration time will not be enforced.
               Possible values are: `ENABLED`, `DISABLED`.
        :param pulumi.Input['SecurityActionAllowArgs'] allow: Allow a request through if it matches this SecurityAction.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] api_proxies: If unset, this would apply to all proxies in the environment.
               If set, this action is enforced only if at least one proxy in the repeated
               list is deployed at the time of enforcement. If set, several restrictions are enforced on SecurityActions.
               There can be at most 100 enabled actions with proxies set in an env.
               Several other restrictions apply on conditions and are detailed later.
        :param pulumi.Input['SecurityActionDenyArgs'] deny: Deny a request through if it matches this SecurityAction.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: An optional user provided description of the SecurityAction.
        :param pulumi.Input[_builtins.str] expire_time: The expiration for this SecurityAction.
               Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9
               fractional digits. Offsets other than "Z" are also accepted.
               Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        :param pulumi.Input['SecurityActionFlagArgs'] flag: Flag a request through if it matches this SecurityAction.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] ttl: The TTL for this SecurityAction.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        pulumi.set(__self__, "condition_config", condition_config)
        pulumi.set(__self__, "env_id", env_id)
        pulumi.set(__self__, "org_id", org_id)
        pulumi.set(__self__, "security_action_id", security_action_id)
        pulumi.set(__self__, "state", state)
        if allow is not None:
            pulumi.set(__self__, "allow", allow)
        if api_proxies is not None:
            pulumi.set(__self__, "api_proxies", api_proxies)
        if deny is not None:
            pulumi.set(__self__, "deny", deny)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if flag is not None:
            pulumi.set(__self__, "flag", flag)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter(name="conditionConfig")
    def condition_config(self) -> pulumi.Input['SecurityActionConditionConfigArgs']:
        """
        A valid SecurityAction must contain at least one condition.
        Structure is documented below.
        """
        return pulumi.get(self, "condition_config")

    @condition_config.setter
    def condition_config(self, value: pulumi.Input['SecurityActionConditionConfigArgs']):
        pulumi.set(self, "condition_config", value)

    @_builtins.property
    @pulumi.getter(name="envId")
    def env_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Apigee environment that this security action applies to.
        """
        return pulumi.get(self, "env_id")

    @env_id.setter
    def env_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "env_id", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[_builtins.str]:
        """
        The organization that this security action applies to.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="securityActionId")
    def security_action_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID to use for the SecurityAction, which will become the final component of the action's resource name.
        This value should be 0-61 characters, and valid format is (^a-z?$).
        """
        return pulumi.get(self, "security_action_id")

    @security_action_id.setter
    def security_action_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_action_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Input[_builtins.str]:
        """
        Only an ENABLED SecurityAction is enforced. An ENABLED SecurityAction past its expiration time will not be enforced.
        Possible values are: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def allow(self) -> Optional[pulumi.Input['SecurityActionAllowArgs']]:
        """
        Allow a request through if it matches this SecurityAction.
        """
        return pulumi.get(self, "allow")

    @allow.setter
    def allow(self, value: Optional[pulumi.Input['SecurityActionAllowArgs']]):
        pulumi.set(self, "allow", value)

    @_builtins.property
    @pulumi.getter(name="apiProxies")
    def api_proxies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        If unset, this would apply to all proxies in the environment.
        If set, this action is enforced only if at least one proxy in the repeated
        list is deployed at the time of enforcement. If set, several restrictions are enforced on SecurityActions.
        There can be at most 100 enabled actions with proxies set in an env.
        Several other restrictions apply on conditions and are detailed later.
        """
        return pulumi.get(self, "api_proxies")

    @api_proxies.setter
    def api_proxies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "api_proxies", value)

    @_builtins.property
    @pulumi.getter
    def deny(self) -> Optional[pulumi.Input['SecurityActionDenyArgs']]:
        """
        Deny a request through if it matches this SecurityAction.
        Structure is documented below.
        """
        return pulumi.get(self, "deny")

    @deny.setter
    def deny(self, value: Optional[pulumi.Input['SecurityActionDenyArgs']]):
        pulumi.set(self, "deny", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional user provided description of the SecurityAction.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The expiration for this SecurityAction.
        Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9
        fractional digits. Offsets other than "Z" are also accepted.
        Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expire_time", value)

    @_builtins.property
    @pulumi.getter
    def flag(self) -> Optional[pulumi.Input['SecurityActionFlagArgs']]:
        """
        Flag a request through if it matches this SecurityAction.
        Structure is documented below.
        """
        return pulumi.get(self, "flag")

    @flag.setter
    def flag(self, value: Optional[pulumi.Input['SecurityActionFlagArgs']]):
        pulumi.set(self, "flag", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The TTL for this SecurityAction.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class _SecurityActionState:
    def __init__(__self__, *,
                 allow: Optional[pulumi.Input['SecurityActionAllowArgs']] = None,
                 api_proxies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 condition_config: Optional[pulumi.Input['SecurityActionConditionConfigArgs']] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 deny: Optional[pulumi.Input['SecurityActionDenyArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 env_id: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_time: Optional[pulumi.Input[_builtins.str]] = None,
                 flag: Optional[pulumi.Input['SecurityActionFlagArgs']] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_action_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecurityAction resources.
        :param pulumi.Input['SecurityActionAllowArgs'] allow: Allow a request through if it matches this SecurityAction.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] api_proxies: If unset, this would apply to all proxies in the environment.
               If set, this action is enforced only if at least one proxy in the repeated
               list is deployed at the time of enforcement. If set, several restrictions are enforced on SecurityActions.
               There can be at most 100 enabled actions with proxies set in an env.
               Several other restrictions apply on conditions and are detailed later.
        :param pulumi.Input['SecurityActionConditionConfigArgs'] condition_config: A valid SecurityAction must contain at least one condition.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: The create time for this SecurityAction.
               Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9 fractional digits.
               Offsets other than "Z" are also accepted. Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        :param pulumi.Input['SecurityActionDenyArgs'] deny: Deny a request through if it matches this SecurityAction.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: An optional user provided description of the SecurityAction.
        :param pulumi.Input[_builtins.str] env_id: The Apigee environment that this security action applies to.
        :param pulumi.Input[_builtins.str] expire_time: The expiration for this SecurityAction.
               Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9
               fractional digits. Offsets other than "Z" are also accepted.
               Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        :param pulumi.Input['SecurityActionFlagArgs'] flag: Flag a request through if it matches this SecurityAction.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] org_id: The organization that this security action applies to.
        :param pulumi.Input[_builtins.str] security_action_id: The ID to use for the SecurityAction, which will become the final component of the action's resource name.
               This value should be 0-61 characters, and valid format is (^a-z?$).
        :param pulumi.Input[_builtins.str] state: Only an ENABLED SecurityAction is enforced. An ENABLED SecurityAction past its expiration time will not be enforced.
               Possible values are: `ENABLED`, `DISABLED`.
        :param pulumi.Input[_builtins.str] ttl: The TTL for this SecurityAction.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param pulumi.Input[_builtins.str] update_time: The update time for this SecurityAction. This reflects when this SecurityAction changed states.
               Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9 fractional digits.
               Offsets other than "Z" are also accepted. Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        """
        if allow is not None:
            pulumi.set(__self__, "allow", allow)
        if api_proxies is not None:
            pulumi.set(__self__, "api_proxies", api_proxies)
        if condition_config is not None:
            pulumi.set(__self__, "condition_config", condition_config)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if deny is not None:
            pulumi.set(__self__, "deny", deny)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if env_id is not None:
            pulumi.set(__self__, "env_id", env_id)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if flag is not None:
            pulumi.set(__self__, "flag", flag)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if security_action_id is not None:
            pulumi.set(__self__, "security_action_id", security_action_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter
    def allow(self) -> Optional[pulumi.Input['SecurityActionAllowArgs']]:
        """
        Allow a request through if it matches this SecurityAction.
        """
        return pulumi.get(self, "allow")

    @allow.setter
    def allow(self, value: Optional[pulumi.Input['SecurityActionAllowArgs']]):
        pulumi.set(self, "allow", value)

    @_builtins.property
    @pulumi.getter(name="apiProxies")
    def api_proxies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        If unset, this would apply to all proxies in the environment.
        If set, this action is enforced only if at least one proxy in the repeated
        list is deployed at the time of enforcement. If set, several restrictions are enforced on SecurityActions.
        There can be at most 100 enabled actions with proxies set in an env.
        Several other restrictions apply on conditions and are detailed later.
        """
        return pulumi.get(self, "api_proxies")

    @api_proxies.setter
    def api_proxies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "api_proxies", value)

    @_builtins.property
    @pulumi.getter(name="conditionConfig")
    def condition_config(self) -> Optional[pulumi.Input['SecurityActionConditionConfigArgs']]:
        """
        A valid SecurityAction must contain at least one condition.
        Structure is documented below.
        """
        return pulumi.get(self, "condition_config")

    @condition_config.setter
    def condition_config(self, value: Optional[pulumi.Input['SecurityActionConditionConfigArgs']]):
        pulumi.set(self, "condition_config", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The create time for this SecurityAction.
        Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9 fractional digits.
        Offsets other than "Z" are also accepted. Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def deny(self) -> Optional[pulumi.Input['SecurityActionDenyArgs']]:
        """
        Deny a request through if it matches this SecurityAction.
        Structure is documented below.
        """
        return pulumi.get(self, "deny")

    @deny.setter
    def deny(self, value: Optional[pulumi.Input['SecurityActionDenyArgs']]):
        pulumi.set(self, "deny", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional user provided description of the SecurityAction.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="envId")
    def env_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Apigee environment that this security action applies to.
        """
        return pulumi.get(self, "env_id")

    @env_id.setter
    def env_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "env_id", value)

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The expiration for this SecurityAction.
        Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9
        fractional digits. Offsets other than "Z" are also accepted.
        Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expire_time", value)

    @_builtins.property
    @pulumi.getter
    def flag(self) -> Optional[pulumi.Input['SecurityActionFlagArgs']]:
        """
        Flag a request through if it matches this SecurityAction.
        Structure is documented below.
        """
        return pulumi.get(self, "flag")

    @flag.setter
    def flag(self, value: Optional[pulumi.Input['SecurityActionFlagArgs']]):
        pulumi.set(self, "flag", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The organization that this security action applies to.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="securityActionId")
    def security_action_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID to use for the SecurityAction, which will become the final component of the action's resource name.
        This value should be 0-61 characters, and valid format is (^a-z?$).
        """
        return pulumi.get(self, "security_action_id")

    @security_action_id.setter
    def security_action_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_action_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Only an ENABLED SecurityAction is enforced. An ENABLED SecurityAction past its expiration time will not be enforced.
        Possible values are: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The TTL for this SecurityAction.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The update time for this SecurityAction. This reflects when this SecurityAction changed states.
        Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9 fractional digits.
        Offsets other than "Z" are also accepted. Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:apigee/securityAction:SecurityAction")
class SecurityAction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow: Optional[pulumi.Input[Union['SecurityActionAllowArgs', 'SecurityActionAllowArgsDict']]] = None,
                 api_proxies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 condition_config: Optional[pulumi.Input[Union['SecurityActionConditionConfigArgs', 'SecurityActionConditionConfigArgsDict']]] = None,
                 deny: Optional[pulumi.Input[Union['SecurityActionDenyArgs', 'SecurityActionDenyArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 env_id: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_time: Optional[pulumi.Input[_builtins.str]] = None,
                 flag: Optional[pulumi.Input[Union['SecurityActionFlagArgs', 'SecurityActionFlagArgsDict']]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_action_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A SecurityAction is rule that can be enforced at an environment level.
        The result is one of: - A denied API call - An explicitly allowed API call
        - A flagged API call (HTTP headers added before the target receives it)
          At least one condition is required to create a SecurityAction.

        To get more information about SecurityAction, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.environments.securityActions/create)
        * How-to Guides
            * [Creating security actions](https://cloud.google.com/apigee/docs/api-security/security-actions-api#create-security-actions)

        ## Example Usage

        ### Apigee Security Action Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="my-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="my-address",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        env = gcp.apigee.Environment("env",
            name="my-environment",
            description="Apigee Environment",
            display_name="environment-1",
            org_id=apigee_org.id)
        apigee_org_security_addons_config = gcp.apigee.AddonsConfig("apigee_org_security_addons_config",
            org=apigee_org.name,
            addons_config={
                "api_security_config": {
                    "enabled": True,
                },
            })
        apigee_security_action = gcp.apigee.SecurityAction("apigee_security_action",
            security_action_id="my-security-action",
            org_id=apigee_org.name,
            env_id=env.name,
            description="Apigee Security Action",
            state="ENABLED",
            condition_config={
                "ip_address_ranges": [
                    "100.0.220.1",
                    "200.0.0.1",
                ],
                "bot_reasons": [
                    "Flooder",
                    "Public Cloud Azure",
                    "Public Cloud AWS",
                ],
            },
            allow={},
            expire_time="2025-12-31T23:59:59Z",
            opts = pulumi.ResourceOptions(depends_on=[apigee_org_security_addons_config]))
        ```

        ## Import

        SecurityAction can be imported using any of these accepted formats:

        * `organizations/{{org_id}}/environments/{{env_id}}/securityActions/{{security_action_id}}`

        * `{{org_id}}/{{env_id}}/{{security_action_id}}`

        When using the `pulumi import` command, SecurityAction can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/securityAction:SecurityAction default organizations/{{org_id}}/environments/{{env_id}}/securityActions/{{security_action_id}}
        ```

        ```sh
        $ pulumi import gcp:apigee/securityAction:SecurityAction default {{org_id}}/{{env_id}}/{{security_action_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SecurityActionAllowArgs', 'SecurityActionAllowArgsDict']] allow: Allow a request through if it matches this SecurityAction.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] api_proxies: If unset, this would apply to all proxies in the environment.
               If set, this action is enforced only if at least one proxy in the repeated
               list is deployed at the time of enforcement. If set, several restrictions are enforced on SecurityActions.
               There can be at most 100 enabled actions with proxies set in an env.
               Several other restrictions apply on conditions and are detailed later.
        :param pulumi.Input[Union['SecurityActionConditionConfigArgs', 'SecurityActionConditionConfigArgsDict']] condition_config: A valid SecurityAction must contain at least one condition.
               Structure is documented below.
        :param pulumi.Input[Union['SecurityActionDenyArgs', 'SecurityActionDenyArgsDict']] deny: Deny a request through if it matches this SecurityAction.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: An optional user provided description of the SecurityAction.
        :param pulumi.Input[_builtins.str] env_id: The Apigee environment that this security action applies to.
        :param pulumi.Input[_builtins.str] expire_time: The expiration for this SecurityAction.
               Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9
               fractional digits. Offsets other than "Z" are also accepted.
               Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        :param pulumi.Input[Union['SecurityActionFlagArgs', 'SecurityActionFlagArgsDict']] flag: Flag a request through if it matches this SecurityAction.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] org_id: The organization that this security action applies to.
        :param pulumi.Input[_builtins.str] security_action_id: The ID to use for the SecurityAction, which will become the final component of the action's resource name.
               This value should be 0-61 characters, and valid format is (^a-z?$).
        :param pulumi.Input[_builtins.str] state: Only an ENABLED SecurityAction is enforced. An ENABLED SecurityAction past its expiration time will not be enforced.
               Possible values are: `ENABLED`, `DISABLED`.
        :param pulumi.Input[_builtins.str] ttl: The TTL for this SecurityAction.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityActionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A SecurityAction is rule that can be enforced at an environment level.
        The result is one of: - A denied API call - An explicitly allowed API call
        - A flagged API call (HTTP headers added before the target receives it)
          At least one condition is required to create a SecurityAction.

        To get more information about SecurityAction, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.environments.securityActions/create)
        * How-to Guides
            * [Creating security actions](https://cloud.google.com/apigee/docs/api-security/security-actions-api#create-security-actions)

        ## Example Usage

        ### Apigee Security Action Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="my-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="my-address",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        env = gcp.apigee.Environment("env",
            name="my-environment",
            description="Apigee Environment",
            display_name="environment-1",
            org_id=apigee_org.id)
        apigee_org_security_addons_config = gcp.apigee.AddonsConfig("apigee_org_security_addons_config",
            org=apigee_org.name,
            addons_config={
                "api_security_config": {
                    "enabled": True,
                },
            })
        apigee_security_action = gcp.apigee.SecurityAction("apigee_security_action",
            security_action_id="my-security-action",
            org_id=apigee_org.name,
            env_id=env.name,
            description="Apigee Security Action",
            state="ENABLED",
            condition_config={
                "ip_address_ranges": [
                    "100.0.220.1",
                    "200.0.0.1",
                ],
                "bot_reasons": [
                    "Flooder",
                    "Public Cloud Azure",
                    "Public Cloud AWS",
                ],
            },
            allow={},
            expire_time="2025-12-31T23:59:59Z",
            opts = pulumi.ResourceOptions(depends_on=[apigee_org_security_addons_config]))
        ```

        ## Import

        SecurityAction can be imported using any of these accepted formats:

        * `organizations/{{org_id}}/environments/{{env_id}}/securityActions/{{security_action_id}}`

        * `{{org_id}}/{{env_id}}/{{security_action_id}}`

        When using the `pulumi import` command, SecurityAction can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/securityAction:SecurityAction default organizations/{{org_id}}/environments/{{env_id}}/securityActions/{{security_action_id}}
        ```

        ```sh
        $ pulumi import gcp:apigee/securityAction:SecurityAction default {{org_id}}/{{env_id}}/{{security_action_id}}
        ```

        :param str resource_name: The name of the resource.
        :param SecurityActionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityActionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow: Optional[pulumi.Input[Union['SecurityActionAllowArgs', 'SecurityActionAllowArgsDict']]] = None,
                 api_proxies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 condition_config: Optional[pulumi.Input[Union['SecurityActionConditionConfigArgs', 'SecurityActionConditionConfigArgsDict']]] = None,
                 deny: Optional[pulumi.Input[Union['SecurityActionDenyArgs', 'SecurityActionDenyArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 env_id: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_time: Optional[pulumi.Input[_builtins.str]] = None,
                 flag: Optional[pulumi.Input[Union['SecurityActionFlagArgs', 'SecurityActionFlagArgsDict']]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_action_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityActionArgs.__new__(SecurityActionArgs)

            __props__.__dict__["allow"] = allow
            __props__.__dict__["api_proxies"] = api_proxies
            if condition_config is None and not opts.urn:
                raise TypeError("Missing required property 'condition_config'")
            __props__.__dict__["condition_config"] = condition_config
            __props__.__dict__["deny"] = deny
            __props__.__dict__["description"] = description
            if env_id is None and not opts.urn:
                raise TypeError("Missing required property 'env_id'")
            __props__.__dict__["env_id"] = env_id
            __props__.__dict__["expire_time"] = expire_time
            __props__.__dict__["flag"] = flag
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            if security_action_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_action_id'")
            __props__.__dict__["security_action_id"] = security_action_id
            if state is None and not opts.urn:
                raise TypeError("Missing required property 'state'")
            __props__.__dict__["state"] = state
            __props__.__dict__["ttl"] = ttl
            __props__.__dict__["create_time"] = None
            __props__.__dict__["update_time"] = None
        super(SecurityAction, __self__).__init__(
            'gcp:apigee/securityAction:SecurityAction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow: Optional[pulumi.Input[Union['SecurityActionAllowArgs', 'SecurityActionAllowArgsDict']]] = None,
            api_proxies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            condition_config: Optional[pulumi.Input[Union['SecurityActionConditionConfigArgs', 'SecurityActionConditionConfigArgsDict']]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            deny: Optional[pulumi.Input[Union['SecurityActionDenyArgs', 'SecurityActionDenyArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            env_id: Optional[pulumi.Input[_builtins.str]] = None,
            expire_time: Optional[pulumi.Input[_builtins.str]] = None,
            flag: Optional[pulumi.Input[Union['SecurityActionFlagArgs', 'SecurityActionFlagArgsDict']]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_action_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            ttl: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'SecurityAction':
        """
        Get an existing SecurityAction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SecurityActionAllowArgs', 'SecurityActionAllowArgsDict']] allow: Allow a request through if it matches this SecurityAction.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] api_proxies: If unset, this would apply to all proxies in the environment.
               If set, this action is enforced only if at least one proxy in the repeated
               list is deployed at the time of enforcement. If set, several restrictions are enforced on SecurityActions.
               There can be at most 100 enabled actions with proxies set in an env.
               Several other restrictions apply on conditions and are detailed later.
        :param pulumi.Input[Union['SecurityActionConditionConfigArgs', 'SecurityActionConditionConfigArgsDict']] condition_config: A valid SecurityAction must contain at least one condition.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: The create time for this SecurityAction.
               Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9 fractional digits.
               Offsets other than "Z" are also accepted. Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        :param pulumi.Input[Union['SecurityActionDenyArgs', 'SecurityActionDenyArgsDict']] deny: Deny a request through if it matches this SecurityAction.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: An optional user provided description of the SecurityAction.
        :param pulumi.Input[_builtins.str] env_id: The Apigee environment that this security action applies to.
        :param pulumi.Input[_builtins.str] expire_time: The expiration for this SecurityAction.
               Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9
               fractional digits. Offsets other than "Z" are also accepted.
               Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        :param pulumi.Input[Union['SecurityActionFlagArgs', 'SecurityActionFlagArgsDict']] flag: Flag a request through if it matches this SecurityAction.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] org_id: The organization that this security action applies to.
        :param pulumi.Input[_builtins.str] security_action_id: The ID to use for the SecurityAction, which will become the final component of the action's resource name.
               This value should be 0-61 characters, and valid format is (^a-z?$).
        :param pulumi.Input[_builtins.str] state: Only an ENABLED SecurityAction is enforced. An ENABLED SecurityAction past its expiration time will not be enforced.
               Possible values are: `ENABLED`, `DISABLED`.
        :param pulumi.Input[_builtins.str] ttl: The TTL for this SecurityAction.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param pulumi.Input[_builtins.str] update_time: The update time for this SecurityAction. This reflects when this SecurityAction changed states.
               Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9 fractional digits.
               Offsets other than "Z" are also accepted. Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityActionState.__new__(_SecurityActionState)

        __props__.__dict__["allow"] = allow
        __props__.__dict__["api_proxies"] = api_proxies
        __props__.__dict__["condition_config"] = condition_config
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["deny"] = deny
        __props__.__dict__["description"] = description
        __props__.__dict__["env_id"] = env_id
        __props__.__dict__["expire_time"] = expire_time
        __props__.__dict__["flag"] = flag
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["security_action_id"] = security_action_id
        __props__.__dict__["state"] = state
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["update_time"] = update_time
        return SecurityAction(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def allow(self) -> pulumi.Output[Optional['outputs.SecurityActionAllow']]:
        """
        Allow a request through if it matches this SecurityAction.
        """
        return pulumi.get(self, "allow")

    @_builtins.property
    @pulumi.getter(name="apiProxies")
    def api_proxies(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        If unset, this would apply to all proxies in the environment.
        If set, this action is enforced only if at least one proxy in the repeated
        list is deployed at the time of enforcement. If set, several restrictions are enforced on SecurityActions.
        There can be at most 100 enabled actions with proxies set in an env.
        Several other restrictions apply on conditions and are detailed later.
        """
        return pulumi.get(self, "api_proxies")

    @_builtins.property
    @pulumi.getter(name="conditionConfig")
    def condition_config(self) -> pulumi.Output['outputs.SecurityActionConditionConfig']:
        """
        A valid SecurityAction must contain at least one condition.
        Structure is documented below.
        """
        return pulumi.get(self, "condition_config")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The create time for this SecurityAction.
        Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9 fractional digits.
        Offsets other than "Z" are also accepted. Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def deny(self) -> pulumi.Output[Optional['outputs.SecurityActionDeny']]:
        """
        Deny a request through if it matches this SecurityAction.
        Structure is documented below.
        """
        return pulumi.get(self, "deny")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An optional user provided description of the SecurityAction.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="envId")
    def env_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Apigee environment that this security action applies to.
        """
        return pulumi.get(self, "env_id")

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The expiration for this SecurityAction.
        Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9
        fractional digits. Offsets other than "Z" are also accepted.
        Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        """
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter
    def flag(self) -> pulumi.Output[Optional['outputs.SecurityActionFlag']]:
        """
        Flag a request through if it matches this SecurityAction.
        Structure is documented below.
        """
        return pulumi.get(self, "flag")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[_builtins.str]:
        """
        The organization that this security action applies to.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="securityActionId")
    def security_action_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID to use for the SecurityAction, which will become the final component of the action's resource name.
        This value should be 0-61 characters, and valid format is (^a-z?$).
        """
        return pulumi.get(self, "security_action_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        Only an ENABLED SecurityAction is enforced. An ENABLED SecurityAction past its expiration time will not be enforced.
        Possible values are: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The TTL for this SecurityAction.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The update time for this SecurityAction. This reflects when this SecurityAction changed states.
        Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9 fractional digits.
        Offsets other than "Z" are also accepted. Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        """
        return pulumi.get(self, "update_time")

