# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplicationArgs', 'Application']

@pulumi.input_type
class ApplicationArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 scope: pulumi.Input['ApplicationScopeArgs'],
                 attributes: Optional[pulumi.Input['ApplicationAttributesArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Application resource.
        :param pulumi.Input[_builtins.str] application_id: Required. The Application identifier.
        :param pulumi.Input[_builtins.str] location: Part of `parent`. See documentation of `projectsId`.
        :param pulumi.Input['ApplicationScopeArgs'] scope: Scope of an application.
               Structure is documented below.
        :param pulumi.Input['ApplicationAttributesArgs'] attributes: Consumer provided attributes.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: Optional. User-defined description of an Application.
        :param pulumi.Input[_builtins.str] display_name: Optional. User-defined name for the Application.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "scope", scope)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[_builtins.str]:
        """
        Required. The Application identifier.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Part of `parent`. See documentation of `projectsId`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Input['ApplicationScopeArgs']:
        """
        Scope of an application.
        Structure is documented below.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: pulumi.Input['ApplicationScopeArgs']):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input['ApplicationAttributesArgs']]:
        """
        Consumer provided attributes.
        Structure is documented below.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input['ApplicationAttributesArgs']]):
        pulumi.set(self, "attributes", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. User-defined description of an Application.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. User-defined name for the Application.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _ApplicationState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 attributes: Optional[pulumi.Input['ApplicationAttributesArgs']] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input['ApplicationScopeArgs']] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Application resources.
        :param pulumi.Input[_builtins.str] application_id: Required. The Application identifier.
        :param pulumi.Input['ApplicationAttributesArgs'] attributes: Consumer provided attributes.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: Output only. Create time.
        :param pulumi.Input[_builtins.str] description: Optional. User-defined description of an Application.
        :param pulumi.Input[_builtins.str] display_name: Optional. User-defined name for the Application.
        :param pulumi.Input[_builtins.str] location: Part of `parent`. See documentation of `projectsId`.
        :param pulumi.Input[_builtins.str] name: Identifier. The resource name of an Application. Format:
               "projects/{host-project-id}/locations/{location}/applications/{application-id}"
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ApplicationScopeArgs'] scope: Scope of an application.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] state: Output only. Application state.
               Possible values:
               STATE_UNSPECIFIED
               CREATING
               ACTIVE
               DELETING
        :param pulumi.Input[_builtins.str] uid: Output only. A universally unique identifier (in UUID4 format) for the `Application`.
        :param pulumi.Input[_builtins.str] update_time: Output only. Update time.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. The Application identifier.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input['ApplicationAttributesArgs']]:
        """
        Consumer provided attributes.
        Structure is documented below.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input['ApplicationAttributesArgs']]):
        pulumi.set(self, "attributes", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Create time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. User-defined description of an Application.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. User-defined name for the Application.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Part of `parent`. See documentation of `projectsId`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. The resource name of an Application. Format:
        "projects/{host-project-id}/locations/{location}/applications/{application-id}"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input['ApplicationScopeArgs']]:
        """
        Scope of an application.
        Structure is documented below.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input['ApplicationScopeArgs']]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Application state.
        Possible values:
        STATE_UNSPECIFIED
        CREATING
        ACTIVE
        DELETING
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. A universally unique identifier (in UUID4 format) for the `Application`.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Update time.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:apphub/application:Application")
class Application(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 attributes: Optional[pulumi.Input[Union['ApplicationAttributesArgs', 'ApplicationAttributesArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[Union['ApplicationScopeArgs', 'ApplicationScopeArgsDict']]] = None,
                 __props__=None):
        """
        Application is a functional grouping of Services and Workloads that helps achieve a desired end-to-end business functionality. Services and Workloads are owned by the Application.

        ## Example Usage

        ### Apphub Application Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.apphub.Application("example",
            location="us-east1",
            application_id="example-application",
            scope={
                "type": "REGIONAL",
            })
        ```
        ### Apphub Application Global Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.apphub.Application("example",
            location="global",
            application_id="example-application",
            scope={
                "type": "GLOBAL",
            })
        ```
        ### Apphub Application Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example2 = gcp.apphub.Application("example2",
            location="us-east1",
            application_id="example-application",
            display_name="Application Full",
            scope={
                "type": "REGIONAL",
            },
            description="Application for testing",
            attributes={
                "environment": {
                    "type": "STAGING",
                },
                "criticality": {
                    "type": "MISSION_CRITICAL",
                },
                "business_owners": [{
                    "display_name": "Alice",
                    "email": "alice@google.com",
                }],
                "developer_owners": [{
                    "display_name": "Bob",
                    "email": "bob@google.com",
                }],
                "operator_owners": [{
                    "display_name": "Charlie",
                    "email": "charlie@google.com",
                }],
            })
        ```

        ## Import

        Application can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/applications/{{application_id}}`

        * `{{project}}/{{location}}/{{application_id}}`

        * `{{location}}/{{application_id}}`

        When using the `pulumi import` command, Application can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apphub/application:Application default projects/{{project}}/locations/{{location}}/applications/{{application_id}}
        ```

        ```sh
        $ pulumi import gcp:apphub/application:Application default {{project}}/{{location}}/{{application_id}}
        ```

        ```sh
        $ pulumi import gcp:apphub/application:Application default {{location}}/{{application_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_id: Required. The Application identifier.
        :param pulumi.Input[Union['ApplicationAttributesArgs', 'ApplicationAttributesArgsDict']] attributes: Consumer provided attributes.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: Optional. User-defined description of an Application.
        :param pulumi.Input[_builtins.str] display_name: Optional. User-defined name for the Application.
        :param pulumi.Input[_builtins.str] location: Part of `parent`. See documentation of `projectsId`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['ApplicationScopeArgs', 'ApplicationScopeArgsDict']] scope: Scope of an application.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Application is a functional grouping of Services and Workloads that helps achieve a desired end-to-end business functionality. Services and Workloads are owned by the Application.

        ## Example Usage

        ### Apphub Application Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.apphub.Application("example",
            location="us-east1",
            application_id="example-application",
            scope={
                "type": "REGIONAL",
            })
        ```
        ### Apphub Application Global Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.apphub.Application("example",
            location="global",
            application_id="example-application",
            scope={
                "type": "GLOBAL",
            })
        ```
        ### Apphub Application Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example2 = gcp.apphub.Application("example2",
            location="us-east1",
            application_id="example-application",
            display_name="Application Full",
            scope={
                "type": "REGIONAL",
            },
            description="Application for testing",
            attributes={
                "environment": {
                    "type": "STAGING",
                },
                "criticality": {
                    "type": "MISSION_CRITICAL",
                },
                "business_owners": [{
                    "display_name": "Alice",
                    "email": "alice@google.com",
                }],
                "developer_owners": [{
                    "display_name": "Bob",
                    "email": "bob@google.com",
                }],
                "operator_owners": [{
                    "display_name": "Charlie",
                    "email": "charlie@google.com",
                }],
            })
        ```

        ## Import

        Application can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/applications/{{application_id}}`

        * `{{project}}/{{location}}/{{application_id}}`

        * `{{location}}/{{application_id}}`

        When using the `pulumi import` command, Application can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apphub/application:Application default projects/{{project}}/locations/{{location}}/applications/{{application_id}}
        ```

        ```sh
        $ pulumi import gcp:apphub/application:Application default {{project}}/{{location}}/{{application_id}}
        ```

        ```sh
        $ pulumi import gcp:apphub/application:Application default {{location}}/{{application_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 attributes: Optional[pulumi.Input[Union['ApplicationAttributesArgs', 'ApplicationAttributesArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[Union['ApplicationScopeArgs', 'ApplicationScopeArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationArgs.__new__(ApplicationArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            if scope is None and not opts.urn:
                raise TypeError("Missing required property 'scope'")
            __props__.__dict__["scope"] = scope
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        super(Application, __self__).__init__(
            'gcp:apphub/application:Application',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[_builtins.str]] = None,
            attributes: Optional[pulumi.Input[Union['ApplicationAttributesArgs', 'ApplicationAttributesArgsDict']]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            scope: Optional[pulumi.Input[Union['ApplicationScopeArgs', 'ApplicationScopeArgsDict']]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'Application':
        """
        Get an existing Application resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_id: Required. The Application identifier.
        :param pulumi.Input[Union['ApplicationAttributesArgs', 'ApplicationAttributesArgsDict']] attributes: Consumer provided attributes.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: Output only. Create time.
        :param pulumi.Input[_builtins.str] description: Optional. User-defined description of an Application.
        :param pulumi.Input[_builtins.str] display_name: Optional. User-defined name for the Application.
        :param pulumi.Input[_builtins.str] location: Part of `parent`. See documentation of `projectsId`.
        :param pulumi.Input[_builtins.str] name: Identifier. The resource name of an Application. Format:
               "projects/{host-project-id}/locations/{location}/applications/{application-id}"
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['ApplicationScopeArgs', 'ApplicationScopeArgsDict']] scope: Scope of an application.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] state: Output only. Application state.
               Possible values:
               STATE_UNSPECIFIED
               CREATING
               ACTIVE
               DELETING
        :param pulumi.Input[_builtins.str] uid: Output only. A universally unique identifier (in UUID4 format) for the `Application`.
        :param pulumi.Input[_builtins.str] update_time: Output only. Update time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplicationState.__new__(_ApplicationState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["scope"] = scope
        __props__.__dict__["state"] = state
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return Application(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[_builtins.str]:
        """
        Required. The Application identifier.
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Optional['outputs.ApplicationAttributes']]:
        """
        Consumer provided attributes.
        Structure is documented below.
        """
        return pulumi.get(self, "attributes")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Create time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional. User-defined description of an Application.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional. User-defined name for the Application.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Part of `parent`. See documentation of `projectsId`.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. The resource name of an Application. Format:
        "projects/{host-project-id}/locations/{location}/applications/{application-id}"
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Output['outputs.ApplicationScope']:
        """
        Scope of an application.
        Structure is documented below.
        """
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Application state.
        Possible values:
        STATE_UNSPECIFIED
        CREATING
        ACTIVE
        DELETING
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. A universally unique identifier (in UUID4 format) for the `Application`.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Update time.
        """
        return pulumi.get(self, "update_time")

