# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDockerImageResult',
    'AwaitableGetDockerImageResult',
    'get_docker_image',
    'get_docker_image_output',
]

@pulumi.output_type
class GetDockerImageResult:
    """
    A collection of values returned by getDockerImage.
    """
    def __init__(__self__, build_time=None, id=None, image_name=None, image_size_bytes=None, location=None, media_type=None, name=None, project=None, repository_id=None, self_link=None, tags=None, update_time=None, upload_time=None):
        if build_time and not isinstance(build_time, str):
            raise TypeError("Expected argument 'build_time' to be a str")
        pulumi.set(__self__, "build_time", build_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_name and not isinstance(image_name, str):
            raise TypeError("Expected argument 'image_name' to be a str")
        pulumi.set(__self__, "image_name", image_name)
        if image_size_bytes and not isinstance(image_size_bytes, str):
            raise TypeError("Expected argument 'image_size_bytes' to be a str")
        pulumi.set(__self__, "image_size_bytes", image_size_bytes)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if media_type and not isinstance(media_type, str):
            raise TypeError("Expected argument 'media_type' to be a str")
        pulumi.set(__self__, "media_type", media_type)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)
        if self_link and not isinstance(self_link, str):
            raise TypeError("Expected argument 'self_link' to be a str")
        pulumi.set(__self__, "self_link", self_link)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)
        if upload_time and not isinstance(upload_time, str):
            raise TypeError("Expected argument 'upload_time' to be a str")
        pulumi.set(__self__, "upload_time", upload_time)

    @_builtins.property
    @pulumi.getter(name="buildTime")
    def build_time(self) -> _builtins.str:
        """
        The time, as a RFC 3339 string, this image was built.
        """
        return pulumi.get(self, "build_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> _builtins.str:
        return pulumi.get(self, "image_name")

    @_builtins.property
    @pulumi.getter(name="imageSizeBytes")
    def image_size_bytes(self) -> _builtins.str:
        """
        Calculated size of the image in bytes.
        """
        return pulumi.get(self, "image_size_bytes")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="mediaType")
    def media_type(self) -> _builtins.str:
        """
        Media type of this image, e.g. `application/vnd.docker.distribution.manifest.v2+json`.
        """
        return pulumi.get(self, "media_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The fully qualified name of the fetched image.  This name has the form: `projects/{{project}}/locations/{{location}}/repository/{{repository_id}}/dockerImages/{{docker_image}}`. For example, 
        ```
        projects/test-project/locations/us-west4/repositories/test-repo/dockerImages/nginx@sha256:e9954c1fc875017be1c3e36eca16be2d9e9bccc4bf072163515467d6a823c7cf
        ```
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> _builtins.str:
        return pulumi.get(self, "repository_id")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> _builtins.str:
        """
        The URI to access the image.  For example, 
        ```
        us-west4-docker.pkg.dev/test-project/test-repo/nginx@sha256:e9954c1fc875017be1c3e36eca16be2d9e9bccc4bf072163515467d6a823c7cf
        ```
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        A list of all tags associated with the image.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        The time, as a RFC 3339 string, this image was updated.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="uploadTime")
    def upload_time(self) -> _builtins.str:
        """
        The time, as a RFC 3339 string, the image was uploaded. For example, `2014-10-02T15:01:23.045123456Z`.
        """
        return pulumi.get(self, "upload_time")


class AwaitableGetDockerImageResult(GetDockerImageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDockerImageResult(
            build_time=self.build_time,
            id=self.id,
            image_name=self.image_name,
            image_size_bytes=self.image_size_bytes,
            location=self.location,
            media_type=self.media_type,
            name=self.name,
            project=self.project,
            repository_id=self.repository_id,
            self_link=self.self_link,
            tags=self.tags,
            update_time=self.update_time,
            upload_time=self.upload_time)


def get_docker_image(image_name: Optional[_builtins.str] = None,
                     location: Optional[_builtins.str] = None,
                     project: Optional[_builtins.str] = None,
                     repository_id: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDockerImageResult:
    """
    This data source fetches information from a provided Artifact Registry repository, including the fully qualified name and URI for an image, based on a the latest version of image name and optional digest or tag.

    > **Note**
    Requires one of the following OAuth scopes: `https://www.googleapis.com/auth/cloud-platform` or `https://www.googleapis.com/auth/cloud-platform.read-only`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_repo = gcp.artifactregistry.Repository("my_repo",
        location="us-west1",
        repository_id="my-repository",
        format="DOCKER")
    my_image = gcp.artifactregistry.get_docker_image_output(location=my_repo.location,
        repository_id=my_repo.repository_id,
        image_name="my-image:my-tag")
    default = gcp.cloudrunv2.Service("default", template={
        "containers": [{
            "image": my_image.self_link,
        }],
    })
    ```


    :param _builtins.str image_name: The image name to fetch. If no digest or tag is provided, then the latest modified image will be used.
    :param _builtins.str location: The location of the artifact registry.
    :param _builtins.str project: The project ID in which the resource belongs. If it is not provided, the provider project is used.
    :param _builtins.str repository_id: The last part of the repository name to fetch from.
    """
    __args__ = dict()
    __args__['imageName'] = image_name
    __args__['location'] = location
    __args__['project'] = project
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:artifactregistry/getDockerImage:getDockerImage', __args__, opts=opts, typ=GetDockerImageResult).value

    return AwaitableGetDockerImageResult(
        build_time=pulumi.get(__ret__, 'build_time'),
        id=pulumi.get(__ret__, 'id'),
        image_name=pulumi.get(__ret__, 'image_name'),
        image_size_bytes=pulumi.get(__ret__, 'image_size_bytes'),
        location=pulumi.get(__ret__, 'location'),
        media_type=pulumi.get(__ret__, 'media_type'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        repository_id=pulumi.get(__ret__, 'repository_id'),
        self_link=pulumi.get(__ret__, 'self_link'),
        tags=pulumi.get(__ret__, 'tags'),
        update_time=pulumi.get(__ret__, 'update_time'),
        upload_time=pulumi.get(__ret__, 'upload_time'))
def get_docker_image_output(image_name: Optional[pulumi.Input[_builtins.str]] = None,
                            location: Optional[pulumi.Input[_builtins.str]] = None,
                            project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDockerImageResult]:
    """
    This data source fetches information from a provided Artifact Registry repository, including the fully qualified name and URI for an image, based on a the latest version of image name and optional digest or tag.

    > **Note**
    Requires one of the following OAuth scopes: `https://www.googleapis.com/auth/cloud-platform` or `https://www.googleapis.com/auth/cloud-platform.read-only`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_repo = gcp.artifactregistry.Repository("my_repo",
        location="us-west1",
        repository_id="my-repository",
        format="DOCKER")
    my_image = gcp.artifactregistry.get_docker_image_output(location=my_repo.location,
        repository_id=my_repo.repository_id,
        image_name="my-image:my-tag")
    default = gcp.cloudrunv2.Service("default", template={
        "containers": [{
            "image": my_image.self_link,
        }],
    })
    ```


    :param _builtins.str image_name: The image name to fetch. If no digest or tag is provided, then the latest modified image will be used.
    :param _builtins.str location: The location of the artifact registry.
    :param _builtins.str project: The project ID in which the resource belongs. If it is not provided, the provider project is used.
    :param _builtins.str repository_id: The last part of the repository name to fetch from.
    """
    __args__ = dict()
    __args__['imageName'] = image_name
    __args__['location'] = location
    __args__['project'] = project
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:artifactregistry/getDockerImage:getDockerImage', __args__, opts=opts, typ=GetDockerImageResult)
    return __ret__.apply(lambda __response__: GetDockerImageResult(
        build_time=pulumi.get(__response__, 'build_time'),
        id=pulumi.get(__response__, 'id'),
        image_name=pulumi.get(__response__, 'image_name'),
        image_size_bytes=pulumi.get(__response__, 'image_size_bytes'),
        location=pulumi.get(__response__, 'location'),
        media_type=pulumi.get(__response__, 'media_type'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        repository_id=pulumi.get(__response__, 'repository_id'),
        self_link=pulumi.get(__response__, 'self_link'),
        tags=pulumi.get(__response__, 'tags'),
        update_time=pulumi.get(__response__, 'update_time'),
        upload_time=pulumi.get(__response__, 'upload_time')))
