# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DataExchangeSubscriptionArgs', 'DataExchangeSubscription']

@pulumi.input_type
class DataExchangeSubscriptionArgs:
    def __init__(__self__, *,
                 data_exchange_id: pulumi.Input[_builtins.str],
                 data_exchange_location: pulumi.Input[_builtins.str],
                 data_exchange_project: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 subscription_id: pulumi.Input[_builtins.str],
                 destination_dataset: Optional[pulumi.Input['DataExchangeSubscriptionDestinationDatasetArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 subscriber_contact: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DataExchangeSubscription resource.
        :param pulumi.Input[_builtins.str] data_exchange_id: The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input[_builtins.str] data_exchange_location: The name of the location of the Data Exchange.
        :param pulumi.Input[_builtins.str] data_exchange_project: The ID of the Google Cloud project where the Data Exchange is located.
        :param pulumi.Input[_builtins.str] location: The geographic location where the Subscription (and its linked dataset) should reside.
               This is the subscriber's desired location for the created resources.
               See https://cloud.google.com/bigquery/docs/locations for supported locations.
        :param pulumi.Input[_builtins.str] subscription_id: Name of the subscription to create.
        :param pulumi.Input['DataExchangeSubscriptionDestinationDatasetArgs'] destination_dataset: BigQuery destination dataset to create for the subscriber.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] subscriber_contact: Email of the subscriber.
        """
        pulumi.set(__self__, "data_exchange_id", data_exchange_id)
        pulumi.set(__self__, "data_exchange_location", data_exchange_location)
        pulumi.set(__self__, "data_exchange_project", data_exchange_project)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "subscription_id", subscription_id)
        if destination_dataset is not None:
            pulumi.set(__self__, "destination_dataset", destination_dataset)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if refresh_policy is not None:
            pulumi.set(__self__, "refresh_policy", refresh_policy)
        if subscriber_contact is not None:
            pulumi.set(__self__, "subscriber_contact", subscriber_contact)

    @_builtins.property
    @pulumi.getter(name="dataExchangeId")
    def data_exchange_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        """
        return pulumi.get(self, "data_exchange_id")

    @data_exchange_id.setter
    def data_exchange_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_exchange_id", value)

    @_builtins.property
    @pulumi.getter(name="dataExchangeLocation")
    def data_exchange_location(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the location of the Data Exchange.
        """
        return pulumi.get(self, "data_exchange_location")

    @data_exchange_location.setter
    def data_exchange_location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_exchange_location", value)

    @_builtins.property
    @pulumi.getter(name="dataExchangeProject")
    def data_exchange_project(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Google Cloud project where the Data Exchange is located.
        """
        return pulumi.get(self, "data_exchange_project")

    @data_exchange_project.setter
    def data_exchange_project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_exchange_project", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The geographic location where the Subscription (and its linked dataset) should reside.
        This is the subscriber's desired location for the created resources.
        See https://cloud.google.com/bigquery/docs/locations for supported locations.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the subscription to create.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subscription_id", value)

    @_builtins.property
    @pulumi.getter(name="destinationDataset")
    def destination_dataset(self) -> Optional[pulumi.Input['DataExchangeSubscriptionDestinationDatasetArgs']]:
        """
        BigQuery destination dataset to create for the subscriber.
        Structure is documented below.
        """
        return pulumi.get(self, "destination_dataset")

    @destination_dataset.setter
    def destination_dataset(self, value: Optional[pulumi.Input['DataExchangeSubscriptionDestinationDatasetArgs']]):
        pulumi.set(self, "destination_dataset", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="refreshPolicy")
    def refresh_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "refresh_policy")

    @refresh_policy.setter
    def refresh_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "refresh_policy", value)

    @_builtins.property
    @pulumi.getter(name="subscriberContact")
    def subscriber_contact(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email of the subscriber.
        """
        return pulumi.get(self, "subscriber_contact")

    @subscriber_contact.setter
    def subscriber_contact(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscriber_contact", value)


@pulumi.input_type
class _DataExchangeSubscriptionState:
    def __init__(__self__, *,
                 creation_time: Optional[pulumi.Input[_builtins.str]] = None,
                 data_exchange: Optional[pulumi.Input[_builtins.str]] = None,
                 data_exchange_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_exchange_location: Optional[pulumi.Input[_builtins.str]] = None,
                 data_exchange_project: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_dataset: Optional[pulumi.Input['DataExchangeSubscriptionDestinationDatasetArgs']] = None,
                 last_modify_time: Optional[pulumi.Input[_builtins.str]] = None,
                 linked_dataset_maps: Optional[pulumi.Input[Sequence[pulumi.Input['DataExchangeSubscriptionLinkedDatasetMapArgs']]]] = None,
                 linked_resources: Optional[pulumi.Input[Sequence[pulumi.Input['DataExchangeSubscriptionLinkedResourceArgs']]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 log_linked_dataset_query_user_email: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 subscriber_contact: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DataExchangeSubscription resources.
        :param pulumi.Input[_builtins.str] creation_time: Timestamp when the subscription was created.
        :param pulumi.Input[_builtins.str] data_exchange: Output only. Resource name of the source Data Exchange. e.g. projects/123/locations/us/dataExchanges/456
        :param pulumi.Input[_builtins.str] data_exchange_id: The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input[_builtins.str] data_exchange_location: The name of the location of the Data Exchange.
        :param pulumi.Input[_builtins.str] data_exchange_project: The ID of the Google Cloud project where the Data Exchange is located.
        :param pulumi.Input['DataExchangeSubscriptionDestinationDatasetArgs'] destination_dataset: BigQuery destination dataset to create for the subscriber.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] last_modify_time: Timestamp when the subscription was last modified.
        :param pulumi.Input[Sequence[pulumi.Input['DataExchangeSubscriptionLinkedDatasetMapArgs']]] linked_dataset_maps: Output only. Map of listing resource names to associated linked resource,
               e.g. projects/123/locations/us/dataExchanges/456/listings/789 > projects/123/datasets/my_dataset
               For Data Exchange subscriptions, this map may contain multiple entries if the Data Exchange has multiple listings.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['DataExchangeSubscriptionLinkedResourceArgs']]] linked_resources: Output only. Linked resources created in the subscription. Only contains values if state = STATE_ACTIVE.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The geographic location where the Subscription (and its linked dataset) should reside.
               This is the subscriber's desired location for the created resources.
               See https://cloud.google.com/bigquery/docs/locations for supported locations.
        :param pulumi.Input[_builtins.bool] log_linked_dataset_query_user_email: Output only. By default, false. If true, the Subscriber agreed to the email sharing mandate that is enabled for DataExchange/Listing.
        :param pulumi.Input[_builtins.str] name: The resource name of the subscription. e.g. "projects/myproject/locations/us/subscriptions/123"
        :param pulumi.Input[_builtins.str] organization_display_name: Display name of the project of this subscription.
        :param pulumi.Input[_builtins.str] organization_id: Organization of the project this subscription belongs to.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] resource_type: Listing shared asset type.
        :param pulumi.Input[_builtins.str] state: Current state of the subscription.
        :param pulumi.Input[_builtins.str] subscriber_contact: Email of the subscriber.
        :param pulumi.Input[_builtins.str] subscription_id: Name of the subscription to create.
        """
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if data_exchange is not None:
            pulumi.set(__self__, "data_exchange", data_exchange)
        if data_exchange_id is not None:
            pulumi.set(__self__, "data_exchange_id", data_exchange_id)
        if data_exchange_location is not None:
            pulumi.set(__self__, "data_exchange_location", data_exchange_location)
        if data_exchange_project is not None:
            pulumi.set(__self__, "data_exchange_project", data_exchange_project)
        if destination_dataset is not None:
            pulumi.set(__self__, "destination_dataset", destination_dataset)
        if last_modify_time is not None:
            pulumi.set(__self__, "last_modify_time", last_modify_time)
        if linked_dataset_maps is not None:
            pulumi.set(__self__, "linked_dataset_maps", linked_dataset_maps)
        if linked_resources is not None:
            pulumi.set(__self__, "linked_resources", linked_resources)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if log_linked_dataset_query_user_email is not None:
            pulumi.set(__self__, "log_linked_dataset_query_user_email", log_linked_dataset_query_user_email)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_display_name is not None:
            pulumi.set(__self__, "organization_display_name", organization_display_name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if refresh_policy is not None:
            pulumi.set(__self__, "refresh_policy", refresh_policy)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subscriber_contact is not None:
            pulumi.set(__self__, "subscriber_contact", subscriber_contact)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the subscription was created.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_time", value)

    @_builtins.property
    @pulumi.getter(name="dataExchange")
    def data_exchange(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Resource name of the source Data Exchange. e.g. projects/123/locations/us/dataExchanges/456
        """
        return pulumi.get(self, "data_exchange")

    @data_exchange.setter
    def data_exchange(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_exchange", value)

    @_builtins.property
    @pulumi.getter(name="dataExchangeId")
    def data_exchange_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        """
        return pulumi.get(self, "data_exchange_id")

    @data_exchange_id.setter
    def data_exchange_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_exchange_id", value)

    @_builtins.property
    @pulumi.getter(name="dataExchangeLocation")
    def data_exchange_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the location of the Data Exchange.
        """
        return pulumi.get(self, "data_exchange_location")

    @data_exchange_location.setter
    def data_exchange_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_exchange_location", value)

    @_builtins.property
    @pulumi.getter(name="dataExchangeProject")
    def data_exchange_project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Google Cloud project where the Data Exchange is located.
        """
        return pulumi.get(self, "data_exchange_project")

    @data_exchange_project.setter
    def data_exchange_project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_exchange_project", value)

    @_builtins.property
    @pulumi.getter(name="destinationDataset")
    def destination_dataset(self) -> Optional[pulumi.Input['DataExchangeSubscriptionDestinationDatasetArgs']]:
        """
        BigQuery destination dataset to create for the subscriber.
        Structure is documented below.
        """
        return pulumi.get(self, "destination_dataset")

    @destination_dataset.setter
    def destination_dataset(self, value: Optional[pulumi.Input['DataExchangeSubscriptionDestinationDatasetArgs']]):
        pulumi.set(self, "destination_dataset", value)

    @_builtins.property
    @pulumi.getter(name="lastModifyTime")
    def last_modify_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the subscription was last modified.
        """
        return pulumi.get(self, "last_modify_time")

    @last_modify_time.setter
    def last_modify_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_modify_time", value)

    @_builtins.property
    @pulumi.getter(name="linkedDatasetMaps")
    def linked_dataset_maps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataExchangeSubscriptionLinkedDatasetMapArgs']]]]:
        """
        Output only. Map of listing resource names to associated linked resource,
        e.g. projects/123/locations/us/dataExchanges/456/listings/789 > projects/123/datasets/my_dataset
        For Data Exchange subscriptions, this map may contain multiple entries if the Data Exchange has multiple listings.
        Structure is documented below.
        """
        return pulumi.get(self, "linked_dataset_maps")

    @linked_dataset_maps.setter
    def linked_dataset_maps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataExchangeSubscriptionLinkedDatasetMapArgs']]]]):
        pulumi.set(self, "linked_dataset_maps", value)

    @_builtins.property
    @pulumi.getter(name="linkedResources")
    def linked_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataExchangeSubscriptionLinkedResourceArgs']]]]:
        """
        Output only. Linked resources created in the subscription. Only contains values if state = STATE_ACTIVE.
        Structure is documented below.
        """
        return pulumi.get(self, "linked_resources")

    @linked_resources.setter
    def linked_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataExchangeSubscriptionLinkedResourceArgs']]]]):
        pulumi.set(self, "linked_resources", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The geographic location where the Subscription (and its linked dataset) should reside.
        This is the subscriber's desired location for the created resources.
        See https://cloud.google.com/bigquery/docs/locations for supported locations.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="logLinkedDatasetQueryUserEmail")
    def log_linked_dataset_query_user_email(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Output only. By default, false. If true, the Subscriber agreed to the email sharing mandate that is enabled for DataExchange/Listing.
        """
        return pulumi.get(self, "log_linked_dataset_query_user_email")

    @log_linked_dataset_query_user_email.setter
    def log_linked_dataset_query_user_email(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "log_linked_dataset_query_user_email", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the subscription. e.g. "projects/myproject/locations/us/subscriptions/123"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="organizationDisplayName")
    def organization_display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Display name of the project of this subscription.
        """
        return pulumi.get(self, "organization_display_name")

    @organization_display_name.setter
    def organization_display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_display_name", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Organization of the project this subscription belongs to.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="refreshPolicy")
    def refresh_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "refresh_policy")

    @refresh_policy.setter
    def refresh_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "refresh_policy", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Listing shared asset type.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Current state of the subscription.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="subscriberContact")
    def subscriber_contact(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email of the subscriber.
        """
        return pulumi.get(self, "subscriber_contact")

    @subscriber_contact.setter
    def subscriber_contact(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscriber_contact", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the subscription to create.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscription_id", value)


@pulumi.type_token("gcp:bigqueryanalyticshub/dataExchangeSubscription:DataExchangeSubscription")
class DataExchangeSubscription(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_exchange_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_exchange_location: Optional[pulumi.Input[_builtins.str]] = None,
                 data_exchange_project: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_dataset: Optional[pulumi.Input[Union['DataExchangeSubscriptionDestinationDatasetArgs', 'DataExchangeSubscriptionDestinationDatasetArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 subscriber_contact: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A Bigquery Analytics Hub Data Exchange subscription

        To get more information about DataExchangeSubscription, see:

        * [API documentation](https://cloud.google.com/bigquery/docs/reference/analytics-hub/rest/v1/projects.locations.subscriptions)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/bigquery/docs/analytics-hub-introduction)

        > **Note:** When importing the resource with `pulumi import`, provide the destination/subscriber's project and location
        in the format projects/{{subscriber_project}}/locations/{{subscriber_location}}/subscriptions/{{subscription_id}}
        ## Example Usage

        ### Bigquery Analyticshub Dataexchange Subscription Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        subscription = gcp.bigqueryanalyticshub.DataExchange("subscription",
            location="us",
            data_exchange_id="my_test_dataexchange",
            display_name="my_test_dataexchange",
            description="Test Data Exchange",
            sharing_environment_config={
                "dcr_exchange_config": {},
            })
        subscription_dataset = gcp.bigquery.Dataset("subscription",
            dataset_id="listing_src_dataset",
            friendly_name="listing_src_dataset",
            description="Dataset for Listing",
            location="us")
        subscription_table = gcp.bigquery.Table("subscription",
            deletion_protection=False,
            table_id="listing_src_table",
            dataset_id=subscription_dataset.dataset_id,
            schema=\"\"\"[
          {
            "name": "name",
            "type": "STRING",
            "mode": "NULLABLE"
          },
          {
            "name": "post_abbr",
            "type": "STRING",
            "mode": "NULLABLE"
          },
          {
            "name": "date",
            "type": "DATE",
            "mode": "NULLABLE"
          }
        ]
        \"\"\")
        subscription_listing = gcp.bigqueryanalyticshub.Listing("subscription",
            location="us",
            data_exchange_id=subscription.data_exchange_id,
            listing_id="my_test_listing",
            display_name="my_test_listing",
            description="Test Listing",
            restricted_export_config={
                "enabled": True,
            },
            bigquery_dataset={
                "dataset": subscription_dataset.id,
                "selected_resources": [{
                    "table": subscription_table.id,
                }],
            })
        subscription_data_exchange_subscription = gcp.bigqueryanalyticshub.DataExchangeSubscription("subscription",
            project=subscription_dataset.project,
            location="us",
            data_exchange_project=subscription.project,
            data_exchange_location=subscription.location,
            data_exchange_id=subscription.data_exchange_id,
            subscription_id="my_subscription_id",
            subscriber_contact="testuser@example.com",
            destination_dataset={
                "location": "us",
                "dataset_reference": {
                    "project_id": subscription_dataset.project,
                    "dataset_id": "subscribed_dest_dataset",
                },
                "friendly_name": "Subscribed Destination Dataset",
                "description": "Destination dataset for subscription",
                "labels": {
                    "environment": "development",
                    "owner": "team-a",
                },
            },
            refresh_policy="ON_READ")
        ```

        ## Import

        DataExchangeSubscription can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/subscriptions/{{subscription_id}}`

        * `{{project}}/{{location}}/{{subscription_id}}`

        * `{{location}}/{{subscription_id}}`

        When using the `pulumi import` command, DataExchangeSubscription can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigqueryanalyticshub/dataExchangeSubscription:DataExchangeSubscription default projects/{{project}}/locations/{{location}}/subscriptions/{{subscription_id}}
        ```

        ```sh
        $ pulumi import gcp:bigqueryanalyticshub/dataExchangeSubscription:DataExchangeSubscription default {{project}}/{{location}}/{{subscription_id}}
        ```

        ```sh
        $ pulumi import gcp:bigqueryanalyticshub/dataExchangeSubscription:DataExchangeSubscription default {{location}}/{{subscription_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data_exchange_id: The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input[_builtins.str] data_exchange_location: The name of the location of the Data Exchange.
        :param pulumi.Input[_builtins.str] data_exchange_project: The ID of the Google Cloud project where the Data Exchange is located.
        :param pulumi.Input[Union['DataExchangeSubscriptionDestinationDatasetArgs', 'DataExchangeSubscriptionDestinationDatasetArgsDict']] destination_dataset: BigQuery destination dataset to create for the subscriber.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The geographic location where the Subscription (and its linked dataset) should reside.
               This is the subscriber's desired location for the created resources.
               See https://cloud.google.com/bigquery/docs/locations for supported locations.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] subscriber_contact: Email of the subscriber.
        :param pulumi.Input[_builtins.str] subscription_id: Name of the subscription to create.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataExchangeSubscriptionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Bigquery Analytics Hub Data Exchange subscription

        To get more information about DataExchangeSubscription, see:

        * [API documentation](https://cloud.google.com/bigquery/docs/reference/analytics-hub/rest/v1/projects.locations.subscriptions)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/bigquery/docs/analytics-hub-introduction)

        > **Note:** When importing the resource with `pulumi import`, provide the destination/subscriber's project and location
        in the format projects/{{subscriber_project}}/locations/{{subscriber_location}}/subscriptions/{{subscription_id}}
        ## Example Usage

        ### Bigquery Analyticshub Dataexchange Subscription Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        subscription = gcp.bigqueryanalyticshub.DataExchange("subscription",
            location="us",
            data_exchange_id="my_test_dataexchange",
            display_name="my_test_dataexchange",
            description="Test Data Exchange",
            sharing_environment_config={
                "dcr_exchange_config": {},
            })
        subscription_dataset = gcp.bigquery.Dataset("subscription",
            dataset_id="listing_src_dataset",
            friendly_name="listing_src_dataset",
            description="Dataset for Listing",
            location="us")
        subscription_table = gcp.bigquery.Table("subscription",
            deletion_protection=False,
            table_id="listing_src_table",
            dataset_id=subscription_dataset.dataset_id,
            schema=\"\"\"[
          {
            "name": "name",
            "type": "STRING",
            "mode": "NULLABLE"
          },
          {
            "name": "post_abbr",
            "type": "STRING",
            "mode": "NULLABLE"
          },
          {
            "name": "date",
            "type": "DATE",
            "mode": "NULLABLE"
          }
        ]
        \"\"\")
        subscription_listing = gcp.bigqueryanalyticshub.Listing("subscription",
            location="us",
            data_exchange_id=subscription.data_exchange_id,
            listing_id="my_test_listing",
            display_name="my_test_listing",
            description="Test Listing",
            restricted_export_config={
                "enabled": True,
            },
            bigquery_dataset={
                "dataset": subscription_dataset.id,
                "selected_resources": [{
                    "table": subscription_table.id,
                }],
            })
        subscription_data_exchange_subscription = gcp.bigqueryanalyticshub.DataExchangeSubscription("subscription",
            project=subscription_dataset.project,
            location="us",
            data_exchange_project=subscription.project,
            data_exchange_location=subscription.location,
            data_exchange_id=subscription.data_exchange_id,
            subscription_id="my_subscription_id",
            subscriber_contact="testuser@example.com",
            destination_dataset={
                "location": "us",
                "dataset_reference": {
                    "project_id": subscription_dataset.project,
                    "dataset_id": "subscribed_dest_dataset",
                },
                "friendly_name": "Subscribed Destination Dataset",
                "description": "Destination dataset for subscription",
                "labels": {
                    "environment": "development",
                    "owner": "team-a",
                },
            },
            refresh_policy="ON_READ")
        ```

        ## Import

        DataExchangeSubscription can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/subscriptions/{{subscription_id}}`

        * `{{project}}/{{location}}/{{subscription_id}}`

        * `{{location}}/{{subscription_id}}`

        When using the `pulumi import` command, DataExchangeSubscription can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigqueryanalyticshub/dataExchangeSubscription:DataExchangeSubscription default projects/{{project}}/locations/{{location}}/subscriptions/{{subscription_id}}
        ```

        ```sh
        $ pulumi import gcp:bigqueryanalyticshub/dataExchangeSubscription:DataExchangeSubscription default {{project}}/{{location}}/{{subscription_id}}
        ```

        ```sh
        $ pulumi import gcp:bigqueryanalyticshub/dataExchangeSubscription:DataExchangeSubscription default {{location}}/{{subscription_id}}
        ```

        :param str resource_name: The name of the resource.
        :param DataExchangeSubscriptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataExchangeSubscriptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_exchange_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_exchange_location: Optional[pulumi.Input[_builtins.str]] = None,
                 data_exchange_project: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_dataset: Optional[pulumi.Input[Union['DataExchangeSubscriptionDestinationDatasetArgs', 'DataExchangeSubscriptionDestinationDatasetArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 subscriber_contact: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataExchangeSubscriptionArgs.__new__(DataExchangeSubscriptionArgs)

            if data_exchange_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_exchange_id'")
            __props__.__dict__["data_exchange_id"] = data_exchange_id
            if data_exchange_location is None and not opts.urn:
                raise TypeError("Missing required property 'data_exchange_location'")
            __props__.__dict__["data_exchange_location"] = data_exchange_location
            if data_exchange_project is None and not opts.urn:
                raise TypeError("Missing required property 'data_exchange_project'")
            __props__.__dict__["data_exchange_project"] = data_exchange_project
            __props__.__dict__["destination_dataset"] = destination_dataset
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["refresh_policy"] = refresh_policy
            __props__.__dict__["subscriber_contact"] = subscriber_contact
            if subscription_id is None and not opts.urn:
                raise TypeError("Missing required property 'subscription_id'")
            __props__.__dict__["subscription_id"] = subscription_id
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["data_exchange"] = None
            __props__.__dict__["last_modify_time"] = None
            __props__.__dict__["linked_dataset_maps"] = None
            __props__.__dict__["linked_resources"] = None
            __props__.__dict__["log_linked_dataset_query_user_email"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["organization_display_name"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["resource_type"] = None
            __props__.__dict__["state"] = None
        super(DataExchangeSubscription, __self__).__init__(
            'gcp:bigqueryanalyticshub/dataExchangeSubscription:DataExchangeSubscription',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creation_time: Optional[pulumi.Input[_builtins.str]] = None,
            data_exchange: Optional[pulumi.Input[_builtins.str]] = None,
            data_exchange_id: Optional[pulumi.Input[_builtins.str]] = None,
            data_exchange_location: Optional[pulumi.Input[_builtins.str]] = None,
            data_exchange_project: Optional[pulumi.Input[_builtins.str]] = None,
            destination_dataset: Optional[pulumi.Input[Union['DataExchangeSubscriptionDestinationDatasetArgs', 'DataExchangeSubscriptionDestinationDatasetArgsDict']]] = None,
            last_modify_time: Optional[pulumi.Input[_builtins.str]] = None,
            linked_dataset_maps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataExchangeSubscriptionLinkedDatasetMapArgs', 'DataExchangeSubscriptionLinkedDatasetMapArgsDict']]]]] = None,
            linked_resources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataExchangeSubscriptionLinkedResourceArgs', 'DataExchangeSubscriptionLinkedResourceArgsDict']]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            log_linked_dataset_query_user_email: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            organization_display_name: Optional[pulumi.Input[_builtins.str]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            refresh_policy: Optional[pulumi.Input[_builtins.str]] = None,
            resource_type: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            subscriber_contact: Optional[pulumi.Input[_builtins.str]] = None,
            subscription_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'DataExchangeSubscription':
        """
        Get an existing DataExchangeSubscription resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] creation_time: Timestamp when the subscription was created.
        :param pulumi.Input[_builtins.str] data_exchange: Output only. Resource name of the source Data Exchange. e.g. projects/123/locations/us/dataExchanges/456
        :param pulumi.Input[_builtins.str] data_exchange_id: The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input[_builtins.str] data_exchange_location: The name of the location of the Data Exchange.
        :param pulumi.Input[_builtins.str] data_exchange_project: The ID of the Google Cloud project where the Data Exchange is located.
        :param pulumi.Input[Union['DataExchangeSubscriptionDestinationDatasetArgs', 'DataExchangeSubscriptionDestinationDatasetArgsDict']] destination_dataset: BigQuery destination dataset to create for the subscriber.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] last_modify_time: Timestamp when the subscription was last modified.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DataExchangeSubscriptionLinkedDatasetMapArgs', 'DataExchangeSubscriptionLinkedDatasetMapArgsDict']]]] linked_dataset_maps: Output only. Map of listing resource names to associated linked resource,
               e.g. projects/123/locations/us/dataExchanges/456/listings/789 > projects/123/datasets/my_dataset
               For Data Exchange subscriptions, this map may contain multiple entries if the Data Exchange has multiple listings.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DataExchangeSubscriptionLinkedResourceArgs', 'DataExchangeSubscriptionLinkedResourceArgsDict']]]] linked_resources: Output only. Linked resources created in the subscription. Only contains values if state = STATE_ACTIVE.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The geographic location where the Subscription (and its linked dataset) should reside.
               This is the subscriber's desired location for the created resources.
               See https://cloud.google.com/bigquery/docs/locations for supported locations.
        :param pulumi.Input[_builtins.bool] log_linked_dataset_query_user_email: Output only. By default, false. If true, the Subscriber agreed to the email sharing mandate that is enabled for DataExchange/Listing.
        :param pulumi.Input[_builtins.str] name: The resource name of the subscription. e.g. "projects/myproject/locations/us/subscriptions/123"
        :param pulumi.Input[_builtins.str] organization_display_name: Display name of the project of this subscription.
        :param pulumi.Input[_builtins.str] organization_id: Organization of the project this subscription belongs to.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] resource_type: Listing shared asset type.
        :param pulumi.Input[_builtins.str] state: Current state of the subscription.
        :param pulumi.Input[_builtins.str] subscriber_contact: Email of the subscriber.
        :param pulumi.Input[_builtins.str] subscription_id: Name of the subscription to create.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataExchangeSubscriptionState.__new__(_DataExchangeSubscriptionState)

        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["data_exchange"] = data_exchange
        __props__.__dict__["data_exchange_id"] = data_exchange_id
        __props__.__dict__["data_exchange_location"] = data_exchange_location
        __props__.__dict__["data_exchange_project"] = data_exchange_project
        __props__.__dict__["destination_dataset"] = destination_dataset
        __props__.__dict__["last_modify_time"] = last_modify_time
        __props__.__dict__["linked_dataset_maps"] = linked_dataset_maps
        __props__.__dict__["linked_resources"] = linked_resources
        __props__.__dict__["location"] = location
        __props__.__dict__["log_linked_dataset_query_user_email"] = log_linked_dataset_query_user_email
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_display_name"] = organization_display_name
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["project"] = project
        __props__.__dict__["refresh_policy"] = refresh_policy
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["state"] = state
        __props__.__dict__["subscriber_contact"] = subscriber_contact
        __props__.__dict__["subscription_id"] = subscription_id
        return DataExchangeSubscription(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when the subscription was created.
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter(name="dataExchange")
    def data_exchange(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Resource name of the source Data Exchange. e.g. projects/123/locations/us/dataExchanges/456
        """
        return pulumi.get(self, "data_exchange")

    @_builtins.property
    @pulumi.getter(name="dataExchangeId")
    def data_exchange_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        """
        return pulumi.get(self, "data_exchange_id")

    @_builtins.property
    @pulumi.getter(name="dataExchangeLocation")
    def data_exchange_location(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the location of the Data Exchange.
        """
        return pulumi.get(self, "data_exchange_location")

    @_builtins.property
    @pulumi.getter(name="dataExchangeProject")
    def data_exchange_project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Google Cloud project where the Data Exchange is located.
        """
        return pulumi.get(self, "data_exchange_project")

    @_builtins.property
    @pulumi.getter(name="destinationDataset")
    def destination_dataset(self) -> pulumi.Output[Optional['outputs.DataExchangeSubscriptionDestinationDataset']]:
        """
        BigQuery destination dataset to create for the subscriber.
        Structure is documented below.
        """
        return pulumi.get(self, "destination_dataset")

    @_builtins.property
    @pulumi.getter(name="lastModifyTime")
    def last_modify_time(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when the subscription was last modified.
        """
        return pulumi.get(self, "last_modify_time")

    @_builtins.property
    @pulumi.getter(name="linkedDatasetMaps")
    def linked_dataset_maps(self) -> pulumi.Output[Sequence['outputs.DataExchangeSubscriptionLinkedDatasetMap']]:
        """
        Output only. Map of listing resource names to associated linked resource,
        e.g. projects/123/locations/us/dataExchanges/456/listings/789 > projects/123/datasets/my_dataset
        For Data Exchange subscriptions, this map may contain multiple entries if the Data Exchange has multiple listings.
        Structure is documented below.
        """
        return pulumi.get(self, "linked_dataset_maps")

    @_builtins.property
    @pulumi.getter(name="linkedResources")
    def linked_resources(self) -> pulumi.Output[Sequence['outputs.DataExchangeSubscriptionLinkedResource']]:
        """
        Output only. Linked resources created in the subscription. Only contains values if state = STATE_ACTIVE.
        Structure is documented below.
        """
        return pulumi.get(self, "linked_resources")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The geographic location where the Subscription (and its linked dataset) should reside.
        This is the subscriber's desired location for the created resources.
        See https://cloud.google.com/bigquery/docs/locations for supported locations.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="logLinkedDatasetQueryUserEmail")
    def log_linked_dataset_query_user_email(self) -> pulumi.Output[_builtins.bool]:
        """
        Output only. By default, false. If true, the Subscriber agreed to the email sharing mandate that is enabled for DataExchange/Listing.
        """
        return pulumi.get(self, "log_linked_dataset_query_user_email")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name of the subscription. e.g. "projects/myproject/locations/us/subscriptions/123"
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationDisplayName")
    def organization_display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Display name of the project of this subscription.
        """
        return pulumi.get(self, "organization_display_name")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        Organization of the project this subscription belongs to.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="refreshPolicy")
    def refresh_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "refresh_policy")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[_builtins.str]:
        """
        Listing shared asset type.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        Current state of the subscription.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subscriberContact")
    def subscriber_contact(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Email of the subscriber.
        """
        return pulumi.get(self, "subscriber_contact")

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the subscription to create.
        """
        return pulumi.get(self, "subscription_id")

