# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BlockchainNodesArgs', 'BlockchainNodes']

@pulumi.input_type
class BlockchainNodesArgs:
    def __init__(__self__, *,
                 blockchain_node_id: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 blockchain_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ethereum_details: Optional[pulumi.Input['BlockchainNodesEthereumDetailsArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BlockchainNodes resource.
        :param pulumi.Input[_builtins.str] blockchain_node_id: ID of the requesting object.
        :param pulumi.Input[_builtins.str] location: Location of Blockchain Node being created.
        :param pulumi.Input[_builtins.str] blockchain_type: User-provided key-value pairs
               Possible values are: `ETHEREUM`.
        :param pulumi.Input['BlockchainNodesEthereumDetailsArgs'] ethereum_details: User-provided key-value pairs
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-provided key-value pairs
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "blockchain_node_id", blockchain_node_id)
        pulumi.set(__self__, "location", location)
        if blockchain_type is not None:
            pulumi.set(__self__, "blockchain_type", blockchain_type)
        if ethereum_details is not None:
            pulumi.set(__self__, "ethereum_details", ethereum_details)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="blockchainNodeId")
    def blockchain_node_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the requesting object.
        """
        return pulumi.get(self, "blockchain_node_id")

    @blockchain_node_id.setter
    def blockchain_node_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "blockchain_node_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Location of Blockchain Node being created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="blockchainType")
    def blockchain_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-provided key-value pairs
        Possible values are: `ETHEREUM`.
        """
        return pulumi.get(self, "blockchain_type")

    @blockchain_type.setter
    def blockchain_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "blockchain_type", value)

    @_builtins.property
    @pulumi.getter(name="ethereumDetails")
    def ethereum_details(self) -> Optional[pulumi.Input['BlockchainNodesEthereumDetailsArgs']]:
        """
        User-provided key-value pairs
        Structure is documented below.
        """
        return pulumi.get(self, "ethereum_details")

    @ethereum_details.setter
    def ethereum_details(self, value: Optional[pulumi.Input['BlockchainNodesEthereumDetailsArgs']]):
        pulumi.set(self, "ethereum_details", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User-provided key-value pairs

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _BlockchainNodesState:
    def __init__(__self__, *,
                 blockchain_node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 blockchain_type: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_infos: Optional[pulumi.Input[Sequence[pulumi.Input['BlockchainNodesConnectionInfoArgs']]]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ethereum_details: Optional[pulumi.Input['BlockchainNodesEthereumDetailsArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BlockchainNodes resources.
        :param pulumi.Input[_builtins.str] blockchain_node_id: ID of the requesting object.
        :param pulumi.Input[_builtins.str] blockchain_type: User-provided key-value pairs
               Possible values are: `ETHEREUM`.
        :param pulumi.Input[Sequence[pulumi.Input['BlockchainNodesConnectionInfoArgs']]] connection_infos: The connection information through which to interact with a blockchain node.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: The timestamp at which the blockchain node was first created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input['BlockchainNodesEthereumDetailsArgs'] ethereum_details: User-provided key-value pairs
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-provided key-value pairs
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Location of Blockchain Node being created.
        :param pulumi.Input[_builtins.str] name: The fully qualified name of the blockchain node. e.g. projects/my-project/locations/us-central1/blockchainNodes/my-node.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] update_time: The timestamp at which the blockchain node was last updated.
        """
        if blockchain_node_id is not None:
            pulumi.set(__self__, "blockchain_node_id", blockchain_node_id)
        if blockchain_type is not None:
            pulumi.set(__self__, "blockchain_type", blockchain_type)
        if connection_infos is not None:
            pulumi.set(__self__, "connection_infos", connection_infos)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if ethereum_details is not None:
            pulumi.set(__self__, "ethereum_details", ethereum_details)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="blockchainNodeId")
    def blockchain_node_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the requesting object.
        """
        return pulumi.get(self, "blockchain_node_id")

    @blockchain_node_id.setter
    def blockchain_node_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "blockchain_node_id", value)

    @_builtins.property
    @pulumi.getter(name="blockchainType")
    def blockchain_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-provided key-value pairs
        Possible values are: `ETHEREUM`.
        """
        return pulumi.get(self, "blockchain_type")

    @blockchain_type.setter
    def blockchain_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "blockchain_type", value)

    @_builtins.property
    @pulumi.getter(name="connectionInfos")
    def connection_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BlockchainNodesConnectionInfoArgs']]]]:
        """
        The connection information through which to interact with a blockchain node.
        Structure is documented below.
        """
        return pulumi.get(self, "connection_infos")

    @connection_infos.setter
    def connection_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BlockchainNodesConnectionInfoArgs']]]]):
        pulumi.set(self, "connection_infos", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp at which the blockchain node was first created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="ethereumDetails")
    def ethereum_details(self) -> Optional[pulumi.Input['BlockchainNodesEthereumDetailsArgs']]:
        """
        User-provided key-value pairs
        Structure is documented below.
        """
        return pulumi.get(self, "ethereum_details")

    @ethereum_details.setter
    def ethereum_details(self, value: Optional[pulumi.Input['BlockchainNodesEthereumDetailsArgs']]):
        pulumi.set(self, "ethereum_details", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User-provided key-value pairs

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Location of Blockchain Node being created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the blockchain node. e.g. projects/my-project/locations/us-central1/blockchainNodes/my-node.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp at which the blockchain node was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:blockchainnodeengine/blockchainNodes:BlockchainNodes")
class BlockchainNodes(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 blockchain_node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 blockchain_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ethereum_details: Optional[pulumi.Input[Union['BlockchainNodesEthereumDetailsArgs', 'BlockchainNodesEthereumDetailsArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A representation of a blockchain node.

        To get more information about BlockchainNodes, see:

        * [API documentation](https://cloud.google.com/blockchain-node-engine/docs/reference/rest/v1/projects.locations.blockchainNodes)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/blockchain-node-engine)

        ## Example Usage

        ### Blockchain Nodes Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_node = gcp.blockchainnodeengine.BlockchainNodes("default_node",
            location="us-central1",
            blockchain_type="ETHEREUM",
            blockchain_node_id="blockchain_basic_node",
            ethereum_details={
                "api_enable_admin": True,
                "api_enable_debug": True,
                "validator_config": {
                    "mev_relay_urls": [
                        "https://mev1.example.org/",
                        "https://mev2.example.org/",
                    ],
                },
                "node_type": "ARCHIVE",
                "consensus_client": "LIGHTHOUSE",
                "execution_client": "ERIGON",
                "network": "MAINNET",
            },
            labels={
                "environment": "dev",
            })
        ```
        ### Blockchain Nodes Geth Details

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_node_geth = gcp.blockchainnodeengine.BlockchainNodes("default_node_geth",
            location="us-central1",
            blockchain_type="ETHEREUM",
            blockchain_node_id="blockchain_geth_node",
            ethereum_details={
                "api_enable_admin": True,
                "api_enable_debug": True,
                "validator_config": {
                    "mev_relay_urls": [
                        "https://mev1.example.org/",
                        "https://mev2.example.org/",
                    ],
                },
                "node_type": "FULL",
                "consensus_client": "LIGHTHOUSE",
                "execution_client": "GETH",
                "network": "MAINNET",
                "geth_details": {
                    "garbage_collection_mode": "FULL",
                },
            },
            labels={
                "environment": "dev",
            })
        ```

        ## Import

        BlockchainNodes can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/blockchainNodes/{{blockchain_node_id}}`

        * `{{project}}/{{location}}/{{blockchain_node_id}}`

        * `{{location}}/{{blockchain_node_id}}`

        When using the `pulumi import` command, BlockchainNodes can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:blockchainnodeengine/blockchainNodes:BlockchainNodes default projects/{{project}}/locations/{{location}}/blockchainNodes/{{blockchain_node_id}}
        ```

        ```sh
        $ pulumi import gcp:blockchainnodeengine/blockchainNodes:BlockchainNodes default {{project}}/{{location}}/{{blockchain_node_id}}
        ```

        ```sh
        $ pulumi import gcp:blockchainnodeengine/blockchainNodes:BlockchainNodes default {{location}}/{{blockchain_node_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] blockchain_node_id: ID of the requesting object.
        :param pulumi.Input[_builtins.str] blockchain_type: User-provided key-value pairs
               Possible values are: `ETHEREUM`.
        :param pulumi.Input[Union['BlockchainNodesEthereumDetailsArgs', 'BlockchainNodesEthereumDetailsArgsDict']] ethereum_details: User-provided key-value pairs
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-provided key-value pairs
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Location of Blockchain Node being created.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BlockchainNodesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A representation of a blockchain node.

        To get more information about BlockchainNodes, see:

        * [API documentation](https://cloud.google.com/blockchain-node-engine/docs/reference/rest/v1/projects.locations.blockchainNodes)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/blockchain-node-engine)

        ## Example Usage

        ### Blockchain Nodes Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_node = gcp.blockchainnodeengine.BlockchainNodes("default_node",
            location="us-central1",
            blockchain_type="ETHEREUM",
            blockchain_node_id="blockchain_basic_node",
            ethereum_details={
                "api_enable_admin": True,
                "api_enable_debug": True,
                "validator_config": {
                    "mev_relay_urls": [
                        "https://mev1.example.org/",
                        "https://mev2.example.org/",
                    ],
                },
                "node_type": "ARCHIVE",
                "consensus_client": "LIGHTHOUSE",
                "execution_client": "ERIGON",
                "network": "MAINNET",
            },
            labels={
                "environment": "dev",
            })
        ```
        ### Blockchain Nodes Geth Details

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_node_geth = gcp.blockchainnodeengine.BlockchainNodes("default_node_geth",
            location="us-central1",
            blockchain_type="ETHEREUM",
            blockchain_node_id="blockchain_geth_node",
            ethereum_details={
                "api_enable_admin": True,
                "api_enable_debug": True,
                "validator_config": {
                    "mev_relay_urls": [
                        "https://mev1.example.org/",
                        "https://mev2.example.org/",
                    ],
                },
                "node_type": "FULL",
                "consensus_client": "LIGHTHOUSE",
                "execution_client": "GETH",
                "network": "MAINNET",
                "geth_details": {
                    "garbage_collection_mode": "FULL",
                },
            },
            labels={
                "environment": "dev",
            })
        ```

        ## Import

        BlockchainNodes can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/blockchainNodes/{{blockchain_node_id}}`

        * `{{project}}/{{location}}/{{blockchain_node_id}}`

        * `{{location}}/{{blockchain_node_id}}`

        When using the `pulumi import` command, BlockchainNodes can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:blockchainnodeengine/blockchainNodes:BlockchainNodes default projects/{{project}}/locations/{{location}}/blockchainNodes/{{blockchain_node_id}}
        ```

        ```sh
        $ pulumi import gcp:blockchainnodeengine/blockchainNodes:BlockchainNodes default {{project}}/{{location}}/{{blockchain_node_id}}
        ```

        ```sh
        $ pulumi import gcp:blockchainnodeengine/blockchainNodes:BlockchainNodes default {{location}}/{{blockchain_node_id}}
        ```

        :param str resource_name: The name of the resource.
        :param BlockchainNodesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BlockchainNodesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 blockchain_node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 blockchain_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ethereum_details: Optional[pulumi.Input[Union['BlockchainNodesEthereumDetailsArgs', 'BlockchainNodesEthereumDetailsArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BlockchainNodesArgs.__new__(BlockchainNodesArgs)

            if blockchain_node_id is None and not opts.urn:
                raise TypeError("Missing required property 'blockchain_node_id'")
            __props__.__dict__["blockchain_node_id"] = blockchain_node_id
            __props__.__dict__["blockchain_type"] = blockchain_type
            __props__.__dict__["ethereum_details"] = ethereum_details
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["connection_infos"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(BlockchainNodes, __self__).__init__(
            'gcp:blockchainnodeengine/blockchainNodes:BlockchainNodes',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            blockchain_node_id: Optional[pulumi.Input[_builtins.str]] = None,
            blockchain_type: Optional[pulumi.Input[_builtins.str]] = None,
            connection_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BlockchainNodesConnectionInfoArgs', 'BlockchainNodesConnectionInfoArgsDict']]]]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            ethereum_details: Optional[pulumi.Input[Union['BlockchainNodesEthereumDetailsArgs', 'BlockchainNodesEthereumDetailsArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'BlockchainNodes':
        """
        Get an existing BlockchainNodes resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] blockchain_node_id: ID of the requesting object.
        :param pulumi.Input[_builtins.str] blockchain_type: User-provided key-value pairs
               Possible values are: `ETHEREUM`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BlockchainNodesConnectionInfoArgs', 'BlockchainNodesConnectionInfoArgsDict']]]] connection_infos: The connection information through which to interact with a blockchain node.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: The timestamp at which the blockchain node was first created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Union['BlockchainNodesEthereumDetailsArgs', 'BlockchainNodesEthereumDetailsArgsDict']] ethereum_details: User-provided key-value pairs
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-provided key-value pairs
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Location of Blockchain Node being created.
        :param pulumi.Input[_builtins.str] name: The fully qualified name of the blockchain node. e.g. projects/my-project/locations/us-central1/blockchainNodes/my-node.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] update_time: The timestamp at which the blockchain node was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BlockchainNodesState.__new__(_BlockchainNodesState)

        __props__.__dict__["blockchain_node_id"] = blockchain_node_id
        __props__.__dict__["blockchain_type"] = blockchain_type
        __props__.__dict__["connection_infos"] = connection_infos
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["ethereum_details"] = ethereum_details
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["update_time"] = update_time
        return BlockchainNodes(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="blockchainNodeId")
    def blockchain_node_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the requesting object.
        """
        return pulumi.get(self, "blockchain_node_id")

    @_builtins.property
    @pulumi.getter(name="blockchainType")
    def blockchain_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User-provided key-value pairs
        Possible values are: `ETHEREUM`.
        """
        return pulumi.get(self, "blockchain_type")

    @_builtins.property
    @pulumi.getter(name="connectionInfos")
    def connection_infos(self) -> pulumi.Output[Sequence['outputs.BlockchainNodesConnectionInfo']]:
        """
        The connection information through which to interact with a blockchain node.
        Structure is documented below.
        """
        return pulumi.get(self, "connection_infos")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp at which the blockchain node was first created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="ethereumDetails")
    def ethereum_details(self) -> pulumi.Output[Optional['outputs.BlockchainNodesEthereumDetails']]:
        """
        User-provided key-value pairs
        Structure is documented below.
        """
        return pulumi.get(self, "ethereum_details")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        User-provided key-value pairs

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Location of Blockchain Node being created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified name of the blockchain node. e.g. projects/my-project/locations/us-central1/blockchainNodes/my-node.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp at which the blockchain node was last updated.
        """
        return pulumi.get(self, "update_time")

