# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDnsAuthorizationResult',
    'AwaitableGetDnsAuthorizationResult',
    'get_dns_authorization',
    'get_dns_authorization_output',
]

@pulumi.output_type
class GetDnsAuthorizationResult:
    """
    A collection of values returned by getDnsAuthorization.
    """
    def __init__(__self__, description=None, dns_resource_records=None, domain=None, effective_labels=None, id=None, labels=None, location=None, name=None, project=None, pulumi_labels=None, type=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if dns_resource_records and not isinstance(dns_resource_records, list):
            raise TypeError("Expected argument 'dns_resource_records' to be a list")
        pulumi.set(__self__, "dns_resource_records", dns_resource_records)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if effective_labels and not isinstance(effective_labels, dict):
            raise TypeError("Expected argument 'effective_labels' to be a dict")
        pulumi.set(__self__, "effective_labels", effective_labels)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if pulumi_labels and not isinstance(pulumi_labels, dict):
            raise TypeError("Expected argument 'pulumi_labels' to be a dict")
        pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dnsResourceRecords")
    def dns_resource_records(self) -> Sequence['outputs.GetDnsAuthorizationDnsResourceRecordResult']:
        return pulumi.get(self, "dns_resource_records")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


class AwaitableGetDnsAuthorizationResult(GetDnsAuthorizationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDnsAuthorizationResult(
            description=self.description,
            dns_resource_records=self.dns_resource_records,
            domain=self.domain,
            effective_labels=self.effective_labels,
            id=self.id,
            labels=self.labels,
            location=self.location,
            name=self.name,
            project=self.project,
            pulumi_labels=self.pulumi_labels,
            type=self.type)


def get_dns_authorization(domain: Optional[_builtins.str] = None,
                          location: Optional[_builtins.str] = None,
                          name: Optional[_builtins.str] = None,
                          project: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDnsAuthorizationResult:
    """
    Use this data source to get information about a Certificate Manager DNS Authorization. For more details, see the [API documentation](https://cloud.google.com/certificate-manager/docs/reference/certificate-manager/rest/v1/projects.locations.dnsAuthorizations).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    default = gcp.certificatemanager.get_dns_authorization(name="my-dns-auth",
        location="global")
    ```


    :param _builtins.str domain: The name of the DNS Authorization.
    :param _builtins.str location: The Certificate Manager location. If not specified, "global" is used.
    :param _builtins.str name: The name of the DNS Authorization.
    :param _builtins.str project: The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['domain'] = domain
    __args__['location'] = location
    __args__['name'] = name
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:certificatemanager/getDnsAuthorization:getDnsAuthorization', __args__, opts=opts, typ=GetDnsAuthorizationResult).value

    return AwaitableGetDnsAuthorizationResult(
        description=pulumi.get(__ret__, 'description'),
        dns_resource_records=pulumi.get(__ret__, 'dns_resource_records'),
        domain=pulumi.get(__ret__, 'domain'),
        effective_labels=pulumi.get(__ret__, 'effective_labels'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        pulumi_labels=pulumi.get(__ret__, 'pulumi_labels'),
        type=pulumi.get(__ret__, 'type'))
def get_dns_authorization_output(domain: Optional[pulumi.Input[_builtins.str]] = None,
                                 location: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 name: Optional[pulumi.Input[_builtins.str]] = None,
                                 project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDnsAuthorizationResult]:
    """
    Use this data source to get information about a Certificate Manager DNS Authorization. For more details, see the [API documentation](https://cloud.google.com/certificate-manager/docs/reference/certificate-manager/rest/v1/projects.locations.dnsAuthorizations).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    default = gcp.certificatemanager.get_dns_authorization(name="my-dns-auth",
        location="global")
    ```


    :param _builtins.str domain: The name of the DNS Authorization.
    :param _builtins.str location: The Certificate Manager location. If not specified, "global" is used.
    :param _builtins.str name: The name of the DNS Authorization.
    :param _builtins.str project: The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['domain'] = domain
    __args__['location'] = location
    __args__['name'] = name
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:certificatemanager/getDnsAuthorization:getDnsAuthorization', __args__, opts=opts, typ=GetDnsAuthorizationResult)
    return __ret__.apply(lambda __response__: GetDnsAuthorizationResult(
        description=pulumi.get(__response__, 'description'),
        dns_resource_records=pulumi.get(__response__, 'dns_resource_records'),
        domain=pulumi.get(__response__, 'domain'),
        effective_labels=pulumi.get(__response__, 'effective_labels'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        pulumi_labels=pulumi.get(__response__, 'pulumi_labels'),
        type=pulumi.get(__response__, 'type')))
