# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'CertificateIssuanceConfigCertificateAuthorityConfig',
    'CertificateIssuanceConfigCertificateAuthorityConfigCertificateAuthorityServiceConfig',
    'CertificateManaged',
    'CertificateManagedAuthorizationAttemptInfo',
    'CertificateManagedProvisioningIssue',
    'CertificateMapGclbTarget',
    'CertificateMapGclbTargetIpConfig',
    'CertificateSelfManaged',
    'DnsAuthorizationDnsResourceRecord',
    'TrustConfigAllowlistedCertificate',
    'TrustConfigTrustStore',
    'TrustConfigTrustStoreIntermediateCa',
    'TrustConfigTrustStoreTrustAnchor',
    'GetCertificateMapGclbTargetResult',
    'GetCertificateMapGclbTargetIpConfigResult',
    'GetCertificatesCertificateResult',
    'GetCertificatesCertificateManagedResult',
    'GetCertificatesCertificateManagedAuthorizationAttemptInfoResult',
    'GetCertificatesCertificateManagedProvisioningIssueResult',
    'GetDnsAuthorizationDnsResourceRecordResult',
]

@pulumi.output_type
class CertificateIssuanceConfigCertificateAuthorityConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateAuthorityServiceConfig":
            suggest = "certificate_authority_service_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateIssuanceConfigCertificateAuthorityConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateIssuanceConfigCertificateAuthorityConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateIssuanceConfigCertificateAuthorityConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_authority_service_config: Optional['outputs.CertificateIssuanceConfigCertificateAuthorityConfigCertificateAuthorityServiceConfig'] = None):
        """
        :param 'CertificateIssuanceConfigCertificateAuthorityConfigCertificateAuthorityServiceConfigArgs' certificate_authority_service_config: Defines a CertificateAuthorityServiceConfig.
               Structure is documented below.
        """
        if certificate_authority_service_config is not None:
            pulumi.set(__self__, "certificate_authority_service_config", certificate_authority_service_config)

    @_builtins.property
    @pulumi.getter(name="certificateAuthorityServiceConfig")
    def certificate_authority_service_config(self) -> Optional['outputs.CertificateIssuanceConfigCertificateAuthorityConfigCertificateAuthorityServiceConfig']:
        """
        Defines a CertificateAuthorityServiceConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "certificate_authority_service_config")


@pulumi.output_type
class CertificateIssuanceConfigCertificateAuthorityConfigCertificateAuthorityServiceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caPool":
            suggest = "ca_pool"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateIssuanceConfigCertificateAuthorityConfigCertificateAuthorityServiceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateIssuanceConfigCertificateAuthorityConfigCertificateAuthorityServiceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateIssuanceConfigCertificateAuthorityConfigCertificateAuthorityServiceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_pool: _builtins.str):
        """
        :param _builtins.str ca_pool: A CA pool resource used to issue a certificate.
               The CA pool string has a relative resource path following the form
               "projects/{project}/locations/{location}/caPools/{caPool}".
        """
        pulumi.set(__self__, "ca_pool", ca_pool)

    @_builtins.property
    @pulumi.getter(name="caPool")
    def ca_pool(self) -> _builtins.str:
        """
        A CA pool resource used to issue a certificate.
        The CA pool string has a relative resource path following the form
        "projects/{project}/locations/{location}/caPools/{caPool}".
        """
        return pulumi.get(self, "ca_pool")


@pulumi.output_type
class CertificateManaged(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationAttemptInfos":
            suggest = "authorization_attempt_infos"
        elif key == "dnsAuthorizations":
            suggest = "dns_authorizations"
        elif key == "issuanceConfig":
            suggest = "issuance_config"
        elif key == "provisioningIssues":
            suggest = "provisioning_issues"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateManaged. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateManaged.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateManaged.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_attempt_infos: Optional[Sequence['outputs.CertificateManagedAuthorizationAttemptInfo']] = None,
                 dns_authorizations: Optional[Sequence[_builtins.str]] = None,
                 domains: Optional[Sequence[_builtins.str]] = None,
                 issuance_config: Optional[_builtins.str] = None,
                 provisioning_issues: Optional[Sequence['outputs.CertificateManagedProvisioningIssue']] = None,
                 state: Optional[_builtins.str] = None):
        """
        :param Sequence['CertificateManagedAuthorizationAttemptInfoArgs'] authorization_attempt_infos: (Output)
               Detailed state of the latest authorization attempt for each domain
               specified for this Managed Certificate.
               Structure is documented below.
               
               
               <a name="nested_managed_provisioning_issue"></a>The `provisioning_issue` block contains:
        :param Sequence[_builtins.str] dns_authorizations: Authorizations that will be used for performing domain authorization. Either issuanceConfig or dnsAuthorizations should be specificed, but not both.
        :param Sequence[_builtins.str] domains: The domains for which a managed SSL certificate will be generated.
               Wildcard domains are only supported with DNS challenge resolution
        :param _builtins.str issuance_config: The resource name for a CertificateIssuanceConfig used to configure private PKI certificates in the format projects/*/locations/*/certificateIssuanceConfigs/*.
               If this field is not set, the certificates will instead be publicly signed as documented at https://cloud.google.com/load-balancing/docs/ssl-certificates/google-managed-certs#caa.
               Either issuanceConfig or dnsAuthorizations should be specificed, but not both.
        :param Sequence['CertificateManagedProvisioningIssueArgs'] provisioning_issues: (Output)
               Information about issues with provisioning this Managed Certificate.
               Structure is documented below.
        :param _builtins.str state: (Output)
               State of the domain for managed certificate issuance.
        """
        if authorization_attempt_infos is not None:
            pulumi.set(__self__, "authorization_attempt_infos", authorization_attempt_infos)
        if dns_authorizations is not None:
            pulumi.set(__self__, "dns_authorizations", dns_authorizations)
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if issuance_config is not None:
            pulumi.set(__self__, "issuance_config", issuance_config)
        if provisioning_issues is not None:
            pulumi.set(__self__, "provisioning_issues", provisioning_issues)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="authorizationAttemptInfos")
    def authorization_attempt_infos(self) -> Optional[Sequence['outputs.CertificateManagedAuthorizationAttemptInfo']]:
        """
        (Output)
        Detailed state of the latest authorization attempt for each domain
        specified for this Managed Certificate.
        Structure is documented below.


        <a name="nested_managed_provisioning_issue"></a>The `provisioning_issue` block contains:
        """
        return pulumi.get(self, "authorization_attempt_infos")

    @_builtins.property
    @pulumi.getter(name="dnsAuthorizations")
    def dns_authorizations(self) -> Optional[Sequence[_builtins.str]]:
        """
        Authorizations that will be used for performing domain authorization. Either issuanceConfig or dnsAuthorizations should be specificed, but not both.
        """
        return pulumi.get(self, "dns_authorizations")

    @_builtins.property
    @pulumi.getter
    def domains(self) -> Optional[Sequence[_builtins.str]]:
        """
        The domains for which a managed SSL certificate will be generated.
        Wildcard domains are only supported with DNS challenge resolution
        """
        return pulumi.get(self, "domains")

    @_builtins.property
    @pulumi.getter(name="issuanceConfig")
    def issuance_config(self) -> Optional[_builtins.str]:
        """
        The resource name for a CertificateIssuanceConfig used to configure private PKI certificates in the format projects/*/locations/*/certificateIssuanceConfigs/*.
        If this field is not set, the certificates will instead be publicly signed as documented at https://cloud.google.com/load-balancing/docs/ssl-certificates/google-managed-certs#caa.
        Either issuanceConfig or dnsAuthorizations should be specificed, but not both.
        """
        return pulumi.get(self, "issuance_config")

    @_builtins.property
    @pulumi.getter(name="provisioningIssues")
    def provisioning_issues(self) -> Optional[Sequence['outputs.CertificateManagedProvisioningIssue']]:
        """
        (Output)
        Information about issues with provisioning this Managed Certificate.
        Structure is documented below.
        """
        return pulumi.get(self, "provisioning_issues")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        (Output)
        State of the domain for managed certificate issuance.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class CertificateManagedAuthorizationAttemptInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureReason":
            suggest = "failure_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateManagedAuthorizationAttemptInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateManagedAuthorizationAttemptInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateManagedAuthorizationAttemptInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 details: Optional[_builtins.str] = None,
                 domain: Optional[_builtins.str] = None,
                 failure_reason: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None):
        """
        :param _builtins.str details: Human readable explanation for reaching the state. Provided to help
               address the configuration issues.
               Not guaranteed to be stable. For programmatic access use 'failure_reason' field.
        :param _builtins.str domain: Domain name of the authorization attempt.
        :param _builtins.str failure_reason: Reason for failure of the authorization attempt for the domain.
        :param _builtins.str state: State of the domain for managed certificate issuance.
        """
        if details is not None:
            pulumi.set(__self__, "details", details)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if failure_reason is not None:
            pulumi.set(__self__, "failure_reason", failure_reason)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def details(self) -> Optional[_builtins.str]:
        """
        Human readable explanation for reaching the state. Provided to help
        address the configuration issues.
        Not guaranteed to be stable. For programmatic access use 'failure_reason' field.
        """
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[_builtins.str]:
        """
        Domain name of the authorization attempt.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="failureReason")
    def failure_reason(self) -> Optional[_builtins.str]:
        """
        Reason for failure of the authorization attempt for the domain.
        """
        return pulumi.get(self, "failure_reason")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        State of the domain for managed certificate issuance.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class CertificateManagedProvisioningIssue(dict):
    def __init__(__self__, *,
                 details: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None):
        """
        :param _builtins.str details: Human readable explanation about the issue. Provided to help address
               the configuration issues.
               Not guaranteed to be stable. For programmatic access use 'reason' field.
        :param _builtins.str reason: Reason for provisioning failures.
        """
        if details is not None:
            pulumi.set(__self__, "details", details)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @_builtins.property
    @pulumi.getter
    def details(self) -> Optional[_builtins.str]:
        """
        Human readable explanation about the issue. Provided to help address
        the configuration issues.
        Not guaranteed to be stable. For programmatic access use 'reason' field.
        """
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        Reason for provisioning failures.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class CertificateMapGclbTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipConfigs":
            suggest = "ip_configs"
        elif key == "targetHttpsProxy":
            suggest = "target_https_proxy"
        elif key == "targetSslProxy":
            suggest = "target_ssl_proxy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateMapGclbTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateMapGclbTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateMapGclbTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_configs: Optional[Sequence['outputs.CertificateMapGclbTargetIpConfig']] = None,
                 target_https_proxy: Optional[_builtins.str] = None,
                 target_ssl_proxy: Optional[_builtins.str] = None):
        """
        :param Sequence['CertificateMapGclbTargetIpConfigArgs'] ip_configs: An IP configuration where this Certificate Map is serving
               Structure is documented below.
        :param _builtins.str target_https_proxy: Proxy name must be in the format projects/*/locations/*/targetHttpsProxies/*.
               This field is part of a union field `target_proxy`: Only one of `targetHttpsProxy` or
               `targetSslProxy` may be set.
        :param _builtins.str target_ssl_proxy: Proxy name must be in the format projects/*/locations/*/targetSslProxies/*.
               This field is part of a union field `target_proxy`: Only one of `targetHttpsProxy` or
               `targetSslProxy` may be set.
        """
        if ip_configs is not None:
            pulumi.set(__self__, "ip_configs", ip_configs)
        if target_https_proxy is not None:
            pulumi.set(__self__, "target_https_proxy", target_https_proxy)
        if target_ssl_proxy is not None:
            pulumi.set(__self__, "target_ssl_proxy", target_ssl_proxy)

    @_builtins.property
    @pulumi.getter(name="ipConfigs")
    def ip_configs(self) -> Optional[Sequence['outputs.CertificateMapGclbTargetIpConfig']]:
        """
        An IP configuration where this Certificate Map is serving
        Structure is documented below.
        """
        return pulumi.get(self, "ip_configs")

    @_builtins.property
    @pulumi.getter(name="targetHttpsProxy")
    def target_https_proxy(self) -> Optional[_builtins.str]:
        """
        Proxy name must be in the format projects/*/locations/*/targetHttpsProxies/*.
        This field is part of a union field `target_proxy`: Only one of `targetHttpsProxy` or
        `targetSslProxy` may be set.
        """
        return pulumi.get(self, "target_https_proxy")

    @_builtins.property
    @pulumi.getter(name="targetSslProxy")
    def target_ssl_proxy(self) -> Optional[_builtins.str]:
        """
        Proxy name must be in the format projects/*/locations/*/targetSslProxies/*.
        This field is part of a union field `target_proxy`: Only one of `targetHttpsProxy` or
        `targetSslProxy` may be set.
        """
        return pulumi.get(self, "target_ssl_proxy")


@pulumi.output_type
class CertificateMapGclbTargetIpConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateMapGclbTargetIpConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateMapGclbTargetIpConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateMapGclbTargetIpConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: Optional[_builtins.str] = None,
                 ports: Optional[Sequence[_builtins.int]] = None):
        """
        :param _builtins.str ip_address: An external IP address
        :param Sequence[_builtins.int] ports: A list of ports
        """
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        """
        An external IP address
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Optional[Sequence[_builtins.int]]:
        """
        A list of ports
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class CertificateSelfManaged(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificatePem":
            suggest = "certificate_pem"
        elif key == "pemCertificate":
            suggest = "pem_certificate"
        elif key == "pemPrivateKey":
            suggest = "pem_private_key"
        elif key == "privateKeyPem":
            suggest = "private_key_pem"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateSelfManaged. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateSelfManaged.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateSelfManaged.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_pem: Optional[_builtins.str] = None,
                 pem_certificate: Optional[_builtins.str] = None,
                 pem_private_key: Optional[_builtins.str] = None,
                 private_key_pem: Optional[_builtins.str] = None):
        """
        :param _builtins.str certificate_pem: (Optional, Deprecated)
               The certificate chain in PEM-encoded form.
               Leaf certificate comes first, followed by intermediate ones if any.
               **Note**: This property is sensitive and will not be displayed in the plan.
               
               > **Warning:** `certificate_pem` is deprecated and will be removed in a future major release. Use `pem_certificate` instead.
        :param _builtins.str pem_certificate: The certificate chain in PEM-encoded form.
               Leaf certificate comes first, followed by intermediate ones if any.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param _builtins.str pem_private_key: The private key of the leaf certificate in PEM-encoded form.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param _builtins.str private_key_pem: (Optional, Deprecated)
               The private key of the leaf certificate in PEM-encoded form.
               **Note**: This property is sensitive and will not be displayed in the plan.
               
               > **Warning:** `private_key_pem` is deprecated and will be removed in a future major release. Use `pem_private_key` instead.
        """
        if certificate_pem is not None:
            pulumi.set(__self__, "certificate_pem", certificate_pem)
        if pem_certificate is not None:
            pulumi.set(__self__, "pem_certificate", pem_certificate)
        if pem_private_key is not None:
            pulumi.set(__self__, "pem_private_key", pem_private_key)
        if private_key_pem is not None:
            pulumi.set(__self__, "private_key_pem", private_key_pem)

    @_builtins.property
    @pulumi.getter(name="certificatePem")
    @_utilities.deprecated("""`certificate_pem` is deprecated and will be removed in a future major release. Use `pem_certificate` instead.""")
    def certificate_pem(self) -> Optional[_builtins.str]:
        """
        (Optional, Deprecated)
        The certificate chain in PEM-encoded form.
        Leaf certificate comes first, followed by intermediate ones if any.
        **Note**: This property is sensitive and will not be displayed in the plan.

        > **Warning:** `certificate_pem` is deprecated and will be removed in a future major release. Use `pem_certificate` instead.
        """
        return pulumi.get(self, "certificate_pem")

    @_builtins.property
    @pulumi.getter(name="pemCertificate")
    def pem_certificate(self) -> Optional[_builtins.str]:
        """
        The certificate chain in PEM-encoded form.
        Leaf certificate comes first, followed by intermediate ones if any.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "pem_certificate")

    @_builtins.property
    @pulumi.getter(name="pemPrivateKey")
    def pem_private_key(self) -> Optional[_builtins.str]:
        """
        The private key of the leaf certificate in PEM-encoded form.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "pem_private_key")

    @_builtins.property
    @pulumi.getter(name="privateKeyPem")
    @_utilities.deprecated("""`private_key_pem` is deprecated and will be removed in a future major release. Use `pem_private_key` instead.""")
    def private_key_pem(self) -> Optional[_builtins.str]:
        """
        (Optional, Deprecated)
        The private key of the leaf certificate in PEM-encoded form.
        **Note**: This property is sensitive and will not be displayed in the plan.

        > **Warning:** `private_key_pem` is deprecated and will be removed in a future major release. Use `pem_private_key` instead.
        """
        return pulumi.get(self, "private_key_pem")


@pulumi.output_type
class DnsAuthorizationDnsResourceRecord(dict):
    def __init__(__self__, *,
                 data: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str data: (Output)
               Data of the DNS Resource Record.
        :param _builtins.str name: Name of the resource; provided by the client when the resource is created.
               The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
               and all following characters must be a dash, underscore, letter or digit.
        :param _builtins.str type: type of DNS authorization. If unset during the resource creation, FIXED_RECORD will
               be used for global resources, and PER_PROJECT_RECORD will be used for other locations.
               FIXED_RECORD DNS authorization uses DNS-01 validation method
               PER_PROJECT_RECORD DNS authorization allows for independent management
               of Google-managed certificates with DNS authorization across multiple
               projects.
               Possible values are: `FIXED_RECORD`, `PER_PROJECT_RECORD`.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[_builtins.str]:
        """
        (Output)
        Data of the DNS Resource Record.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the resource; provided by the client when the resource is created.
        The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
        and all following characters must be a dash, underscore, letter or digit.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        type of DNS authorization. If unset during the resource creation, FIXED_RECORD will
        be used for global resources, and PER_PROJECT_RECORD will be used for other locations.
        FIXED_RECORD DNS authorization uses DNS-01 validation method
        PER_PROJECT_RECORD DNS authorization allows for independent management
        of Google-managed certificates with DNS authorization across multiple
        projects.
        Possible values are: `FIXED_RECORD`, `PER_PROJECT_RECORD`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class TrustConfigAllowlistedCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pemCertificate":
            suggest = "pem_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrustConfigAllowlistedCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrustConfigAllowlistedCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrustConfigAllowlistedCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pem_certificate: _builtins.str):
        """
        :param _builtins.str pem_certificate: PEM certificate that is allowlisted. The certificate can be up to 5k bytes, and must be a parseable X.509 certificate.
        """
        pulumi.set(__self__, "pem_certificate", pem_certificate)

    @_builtins.property
    @pulumi.getter(name="pemCertificate")
    def pem_certificate(self) -> _builtins.str:
        """
        PEM certificate that is allowlisted. The certificate can be up to 5k bytes, and must be a parseable X.509 certificate.
        """
        return pulumi.get(self, "pem_certificate")


@pulumi.output_type
class TrustConfigTrustStore(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intermediateCas":
            suggest = "intermediate_cas"
        elif key == "trustAnchors":
            suggest = "trust_anchors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrustConfigTrustStore. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrustConfigTrustStore.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrustConfigTrustStore.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 intermediate_cas: Optional[Sequence['outputs.TrustConfigTrustStoreIntermediateCa']] = None,
                 trust_anchors: Optional[Sequence['outputs.TrustConfigTrustStoreTrustAnchor']] = None):
        """
        :param Sequence['TrustConfigTrustStoreIntermediateCaArgs'] intermediate_cas: Set of intermediate CA certificates used for the path building phase of chain validation.
               The field is currently not supported if trust config is used for the workload certificate feature.
               Structure is documented below.
        :param Sequence['TrustConfigTrustStoreTrustAnchorArgs'] trust_anchors: List of Trust Anchors to be used while performing validation against a given TrustStore.
               Structure is documented below.
        """
        if intermediate_cas is not None:
            pulumi.set(__self__, "intermediate_cas", intermediate_cas)
        if trust_anchors is not None:
            pulumi.set(__self__, "trust_anchors", trust_anchors)

    @_builtins.property
    @pulumi.getter(name="intermediateCas")
    def intermediate_cas(self) -> Optional[Sequence['outputs.TrustConfigTrustStoreIntermediateCa']]:
        """
        Set of intermediate CA certificates used for the path building phase of chain validation.
        The field is currently not supported if trust config is used for the workload certificate feature.
        Structure is documented below.
        """
        return pulumi.get(self, "intermediate_cas")

    @_builtins.property
    @pulumi.getter(name="trustAnchors")
    def trust_anchors(self) -> Optional[Sequence['outputs.TrustConfigTrustStoreTrustAnchor']]:
        """
        List of Trust Anchors to be used while performing validation against a given TrustStore.
        Structure is documented below.
        """
        return pulumi.get(self, "trust_anchors")


@pulumi.output_type
class TrustConfigTrustStoreIntermediateCa(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pemCertificate":
            suggest = "pem_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrustConfigTrustStoreIntermediateCa. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrustConfigTrustStoreIntermediateCa.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrustConfigTrustStoreIntermediateCa.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pem_certificate: Optional[_builtins.str] = None):
        """
        :param _builtins.str pem_certificate: PEM intermediate certificate used for building up paths for validation.
               Each certificate provided in PEM format may occupy up to 5kB.
               **Note**: This property is sensitive and will not be displayed in the plan.
        """
        if pem_certificate is not None:
            pulumi.set(__self__, "pem_certificate", pem_certificate)

    @_builtins.property
    @pulumi.getter(name="pemCertificate")
    def pem_certificate(self) -> Optional[_builtins.str]:
        """
        PEM intermediate certificate used for building up paths for validation.
        Each certificate provided in PEM format may occupy up to 5kB.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "pem_certificate")


@pulumi.output_type
class TrustConfigTrustStoreTrustAnchor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pemCertificate":
            suggest = "pem_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrustConfigTrustStoreTrustAnchor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrustConfigTrustStoreTrustAnchor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrustConfigTrustStoreTrustAnchor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pem_certificate: Optional[_builtins.str] = None):
        """
        :param _builtins.str pem_certificate: PEM root certificate of the PKI used for validation.
               Each certificate provided in PEM format may occupy up to 5kB.
               **Note**: This property is sensitive and will not be displayed in the plan.
        """
        if pem_certificate is not None:
            pulumi.set(__self__, "pem_certificate", pem_certificate)

    @_builtins.property
    @pulumi.getter(name="pemCertificate")
    def pem_certificate(self) -> Optional[_builtins.str]:
        """
        PEM root certificate of the PKI used for validation.
        Each certificate provided in PEM format may occupy up to 5kB.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "pem_certificate")


@pulumi.output_type
class GetCertificateMapGclbTargetResult(dict):
    def __init__(__self__, *,
                 ip_configs: Sequence['outputs.GetCertificateMapGclbTargetIpConfigResult'],
                 target_https_proxy: _builtins.str,
                 target_ssl_proxy: _builtins.str):
        """
        :param Sequence['GetCertificateMapGclbTargetIpConfigArgs'] ip_configs: An IP configuration where this Certificate Map is serving
        :param _builtins.str target_https_proxy: Proxy name must be in the format projects/*/locations/*/targetHttpsProxies/*.
               This field is part of a union field 'target_proxy': Only one of 'targetHttpsProxy' or
               'targetSslProxy' may be set.
        :param _builtins.str target_ssl_proxy: Proxy name must be in the format projects/*/locations/*/targetSslProxies/*.
               This field is part of a union field 'target_proxy': Only one of 'targetHttpsProxy' or
               'targetSslProxy' may be set.
        """
        pulumi.set(__self__, "ip_configs", ip_configs)
        pulumi.set(__self__, "target_https_proxy", target_https_proxy)
        pulumi.set(__self__, "target_ssl_proxy", target_ssl_proxy)

    @_builtins.property
    @pulumi.getter(name="ipConfigs")
    def ip_configs(self) -> Sequence['outputs.GetCertificateMapGclbTargetIpConfigResult']:
        """
        An IP configuration where this Certificate Map is serving
        """
        return pulumi.get(self, "ip_configs")

    @_builtins.property
    @pulumi.getter(name="targetHttpsProxy")
    def target_https_proxy(self) -> _builtins.str:
        """
        Proxy name must be in the format projects/*/locations/*/targetHttpsProxies/*.
        This field is part of a union field 'target_proxy': Only one of 'targetHttpsProxy' or
        'targetSslProxy' may be set.
        """
        return pulumi.get(self, "target_https_proxy")

    @_builtins.property
    @pulumi.getter(name="targetSslProxy")
    def target_ssl_proxy(self) -> _builtins.str:
        """
        Proxy name must be in the format projects/*/locations/*/targetSslProxies/*.
        This field is part of a union field 'target_proxy': Only one of 'targetHttpsProxy' or
        'targetSslProxy' may be set.
        """
        return pulumi.get(self, "target_ssl_proxy")


@pulumi.output_type
class GetCertificateMapGclbTargetIpConfigResult(dict):
    def __init__(__self__, *,
                 ip_address: _builtins.str,
                 ports: Sequence[_builtins.int]):
        """
        :param _builtins.str ip_address: An external IP address
        :param Sequence[_builtins.int] ports: A list of ports
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "ports", ports)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        An external IP address
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Sequence[_builtins.int]:
        """
        A list of ports
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class GetCertificatesCertificateResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 effective_labels: Mapping[str, _builtins.str],
                 labels: Mapping[str, _builtins.str],
                 location: _builtins.str,
                 manageds: Sequence['outputs.GetCertificatesCertificateManagedResult'],
                 name: _builtins.str,
                 project: _builtins.str,
                 pulumi_labels: Mapping[str, _builtins.str],
                 san_dnsnames: Sequence[_builtins.str],
                 scope: _builtins.str):
        """
        :param _builtins.str description: A human-readable description of the resource.
        :param Mapping[str, _builtins.str] labels: Set of label tags associated with the Certificate resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param _builtins.str location: The Certificate Manager location. If not specified, "global" is used.
        :param Sequence['GetCertificatesCertificateManagedArgs'] manageds: Configuration and state of a Managed Certificate.
               Certificate Manager provisions and renews Managed Certificates
               automatically, for as long as it's authorized to do so.
        :param _builtins.str name: A user-defined name of the certificate. Certificate names must be unique
               The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
               and all following characters must be a dash, underscore, letter or digit.
        :param _builtins.str project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param Mapping[str, _builtins.str] pulumi_labels: The combination of labels configured directly on the resource
                and default labels configured on the provider.
        :param Sequence[_builtins.str] san_dnsnames: The list of Subject Alternative Names of dnsName type defined in the certificate (see RFC 5280 4.2.1.6)
        :param _builtins.str scope: The scope of the certificate.
               
               DEFAULT: Certificates with default scope are served from core Google data centers.
               If unsure, choose this option.
               
               EDGE_CACHE: Certificates with scope EDGE_CACHE are special-purposed certificates, served from Edge Points of Presence.
               See https://cloud.google.com/vpc/docs/edge-locations.
               
               ALL_REGIONS: Certificates with ALL_REGIONS scope are served from all GCP regions (You can only use ALL_REGIONS with global certs).
               See https://cloud.google.com/compute/docs/regions-zones.
               
               CLIENT_AUTH: Certificates with CLIENT_AUTH scope are used by a load balancer (TLS client) to be presented to the backend (TLS server) when backend mTLS is configured.
               See https://cloud.google.com/load-balancing/docs/backend-authenticated-tls-backend-mtls#client-certificate.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "effective_labels", effective_labels)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "manageds", manageds)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        pulumi.set(__self__, "san_dnsnames", san_dnsnames)
        pulumi.set(__self__, "scope", scope)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Set of label tags associated with the Certificate resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field 'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Certificate Manager location. If not specified, "global" is used.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def manageds(self) -> Sequence['outputs.GetCertificatesCertificateManagedResult']:
        """
        Configuration and state of a Managed Certificate.
        Certificate Manager provisions and renews Managed Certificates
        automatically, for as long as it's authorized to do so.
        """
        return pulumi.get(self, "manageds")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A user-defined name of the certificate. Certificate names must be unique
        The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
        and all following characters must be a dash, underscore, letter or digit.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Mapping[str, _builtins.str]:
        """
        The combination of labels configured directly on the resource
         and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="sanDnsnames")
    def san_dnsnames(self) -> Sequence[_builtins.str]:
        """
        The list of Subject Alternative Names of dnsName type defined in the certificate (see RFC 5280 4.2.1.6)
        """
        return pulumi.get(self, "san_dnsnames")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> _builtins.str:
        """
        The scope of the certificate.

        DEFAULT: Certificates with default scope are served from core Google data centers.
        If unsure, choose this option.

        EDGE_CACHE: Certificates with scope EDGE_CACHE are special-purposed certificates, served from Edge Points of Presence.
        See https://cloud.google.com/vpc/docs/edge-locations.

        ALL_REGIONS: Certificates with ALL_REGIONS scope are served from all GCP regions (You can only use ALL_REGIONS with global certs).
        See https://cloud.google.com/compute/docs/regions-zones.

        CLIENT_AUTH: Certificates with CLIENT_AUTH scope are used by a load balancer (TLS client) to be presented to the backend (TLS server) when backend mTLS is configured.
        See https://cloud.google.com/load-balancing/docs/backend-authenticated-tls-backend-mtls#client-certificate.
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class GetCertificatesCertificateManagedResult(dict):
    def __init__(__self__, *,
                 authorization_attempt_infos: Sequence['outputs.GetCertificatesCertificateManagedAuthorizationAttemptInfoResult'],
                 dns_authorizations: Sequence[_builtins.str],
                 domains: Sequence[_builtins.str],
                 issuance_config: _builtins.str,
                 provisioning_issues: Sequence['outputs.GetCertificatesCertificateManagedProvisioningIssueResult'],
                 state: _builtins.str):
        """
        :param Sequence['GetCertificatesCertificateManagedAuthorizationAttemptInfoArgs'] authorization_attempt_infos: Detailed state of the latest authorization attempt for each domain
               specified for this Managed Certificate.
        :param Sequence[_builtins.str] dns_authorizations: Authorizations that will be used for performing domain authorization. Either issuanceConfig or dnsAuthorizations should be specificed, but not both.
        :param Sequence[_builtins.str] domains: The domains for which a managed SSL certificate will be generated.
               Wildcard domains are only supported with DNS challenge resolution
        :param _builtins.str issuance_config: The resource name for a CertificateIssuanceConfig used to configure private PKI certificates in the format projects/*/locations/*/certificateIssuanceConfigs/*.
               If this field is not set, the certificates will instead be publicly signed as documented at https://cloud.google.com/load-balancing/docs/ssl-certificates/google-managed-certs#caa.
               Either issuanceConfig or dnsAuthorizations should be specificed, but not both.
        :param Sequence['GetCertificatesCertificateManagedProvisioningIssueArgs'] provisioning_issues: Information about issues with provisioning this Managed Certificate.
        :param _builtins.str state: A state of this Managed Certificate.
        """
        pulumi.set(__self__, "authorization_attempt_infos", authorization_attempt_infos)
        pulumi.set(__self__, "dns_authorizations", dns_authorizations)
        pulumi.set(__self__, "domains", domains)
        pulumi.set(__self__, "issuance_config", issuance_config)
        pulumi.set(__self__, "provisioning_issues", provisioning_issues)
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="authorizationAttemptInfos")
    def authorization_attempt_infos(self) -> Sequence['outputs.GetCertificatesCertificateManagedAuthorizationAttemptInfoResult']:
        """
        Detailed state of the latest authorization attempt for each domain
        specified for this Managed Certificate.
        """
        return pulumi.get(self, "authorization_attempt_infos")

    @_builtins.property
    @pulumi.getter(name="dnsAuthorizations")
    def dns_authorizations(self) -> Sequence[_builtins.str]:
        """
        Authorizations that will be used for performing domain authorization. Either issuanceConfig or dnsAuthorizations should be specificed, but not both.
        """
        return pulumi.get(self, "dns_authorizations")

    @_builtins.property
    @pulumi.getter
    def domains(self) -> Sequence[_builtins.str]:
        """
        The domains for which a managed SSL certificate will be generated.
        Wildcard domains are only supported with DNS challenge resolution
        """
        return pulumi.get(self, "domains")

    @_builtins.property
    @pulumi.getter(name="issuanceConfig")
    def issuance_config(self) -> _builtins.str:
        """
        The resource name for a CertificateIssuanceConfig used to configure private PKI certificates in the format projects/*/locations/*/certificateIssuanceConfigs/*.
        If this field is not set, the certificates will instead be publicly signed as documented at https://cloud.google.com/load-balancing/docs/ssl-certificates/google-managed-certs#caa.
        Either issuanceConfig or dnsAuthorizations should be specificed, but not both.
        """
        return pulumi.get(self, "issuance_config")

    @_builtins.property
    @pulumi.getter(name="provisioningIssues")
    def provisioning_issues(self) -> Sequence['outputs.GetCertificatesCertificateManagedProvisioningIssueResult']:
        """
        Information about issues with provisioning this Managed Certificate.
        """
        return pulumi.get(self, "provisioning_issues")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A state of this Managed Certificate.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetCertificatesCertificateManagedAuthorizationAttemptInfoResult(dict):
    def __init__(__self__, *,
                 details: _builtins.str,
                 domain: _builtins.str,
                 failure_reason: _builtins.str,
                 state: _builtins.str):
        """
        :param _builtins.str details: Human readable explanation for reaching the state. Provided to help
               address the configuration issues.
               Not guaranteed to be stable. For programmatic access use 'failure_reason' field.
        :param _builtins.str domain: Domain name of the authorization attempt.
        :param _builtins.str failure_reason: Reason for failure of the authorization attempt for the domain.
        :param _builtins.str state: State of the domain for managed certificate issuance.
        """
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "failure_reason", failure_reason)
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def details(self) -> _builtins.str:
        """
        Human readable explanation for reaching the state. Provided to help
        address the configuration issues.
        Not guaranteed to be stable. For programmatic access use 'failure_reason' field.
        """
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        Domain name of the authorization attempt.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="failureReason")
    def failure_reason(self) -> _builtins.str:
        """
        Reason for failure of the authorization attempt for the domain.
        """
        return pulumi.get(self, "failure_reason")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        State of the domain for managed certificate issuance.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetCertificatesCertificateManagedProvisioningIssueResult(dict):
    def __init__(__self__, *,
                 details: _builtins.str,
                 reason: _builtins.str):
        """
        :param _builtins.str details: Human readable explanation about the issue. Provided to help address
               the configuration issues.
               Not guaranteed to be stable. For programmatic access use 'reason' field.
        :param _builtins.str reason: Reason for provisioning failures.
        """
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "reason", reason)

    @_builtins.property
    @pulumi.getter
    def details(self) -> _builtins.str:
        """
        Human readable explanation about the issue. Provided to help address
        the configuration issues.
        Not guaranteed to be stable. For programmatic access use 'reason' field.
        """
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> _builtins.str:
        """
        Reason for provisioning failures.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class GetDnsAuthorizationDnsResourceRecordResult(dict):
    def __init__(__self__, *,
                 data: _builtins.str,
                 name: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str data: Data of the DNS Resource Record.
        :param _builtins.str name: The name of the DNS Authorization.
        :param _builtins.str type: Type of the DNS Resource Record.
        """
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def data(self) -> _builtins.str:
        """
        Data of the DNS Resource Record.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the DNS Authorization.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the DNS Resource Record.
        """
        return pulumi.get(self, "type")


