# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'BitbucketServerConfigConnectedRepository',
    'BitbucketServerConfigSecrets',
    'TriggerApprovalConfig',
    'TriggerBitbucketServerTriggerConfig',
    'TriggerBitbucketServerTriggerConfigPullRequest',
    'TriggerBitbucketServerTriggerConfigPush',
    'TriggerBuild',
    'TriggerBuildArtifacts',
    'TriggerBuildArtifactsMavenArtifact',
    'TriggerBuildArtifactsNpmPackage',
    'TriggerBuildArtifactsObjects',
    'TriggerBuildArtifactsObjectsTiming',
    'TriggerBuildArtifactsPythonPackage',
    'TriggerBuildAvailableSecrets',
    'TriggerBuildAvailableSecretsSecretManager',
    'TriggerBuildOptions',
    'TriggerBuildOptionsVolume',
    'TriggerBuildSecret',
    'TriggerBuildSource',
    'TriggerBuildSourceRepoSource',
    'TriggerBuildSourceStorageSource',
    'TriggerBuildStep',
    'TriggerBuildStepVolume',
    'TriggerDeveloperConnectEventConfig',
    'TriggerDeveloperConnectEventConfigPullRequest',
    'TriggerDeveloperConnectEventConfigPush',
    'TriggerGitFileSource',
    'TriggerGithub',
    'TriggerGithubPullRequest',
    'TriggerGithubPush',
    'TriggerPubsubConfig',
    'TriggerRepositoryEventConfig',
    'TriggerRepositoryEventConfigPullRequest',
    'TriggerRepositoryEventConfigPush',
    'TriggerSourceToBuild',
    'TriggerTriggerTemplate',
    'TriggerWebhookConfig',
    'WorkerPoolNetworkConfig',
    'WorkerPoolPrivateServiceConnect',
    'WorkerPoolWorkerConfig',
    'GetTriggerApprovalConfigResult',
    'GetTriggerBitbucketServerTriggerConfigResult',
    'GetTriggerBitbucketServerTriggerConfigPullRequestResult',
    'GetTriggerBitbucketServerTriggerConfigPushResult',
    'GetTriggerBuildResult',
    'GetTriggerBuildArtifactResult',
    'GetTriggerBuildArtifactMavenArtifactResult',
    'GetTriggerBuildArtifactNpmPackageResult',
    'GetTriggerBuildArtifactObjectResult',
    'GetTriggerBuildArtifactObjectTimingResult',
    'GetTriggerBuildArtifactPythonPackageResult',
    'GetTriggerBuildAvailableSecretResult',
    'GetTriggerBuildAvailableSecretSecretManagerResult',
    'GetTriggerBuildOptionResult',
    'GetTriggerBuildOptionVolumeResult',
    'GetTriggerBuildSecretResult',
    'GetTriggerBuildSourceResult',
    'GetTriggerBuildSourceRepoSourceResult',
    'GetTriggerBuildSourceStorageSourceResult',
    'GetTriggerBuildStepResult',
    'GetTriggerBuildStepVolumeResult',
    'GetTriggerDeveloperConnectEventConfigResult',
    'GetTriggerDeveloperConnectEventConfigPullRequestResult',
    'GetTriggerDeveloperConnectEventConfigPushResult',
    'GetTriggerGitFileSourceResult',
    'GetTriggerGithubResult',
    'GetTriggerGithubPullRequestResult',
    'GetTriggerGithubPushResult',
    'GetTriggerPubsubConfigResult',
    'GetTriggerRepositoryEventConfigResult',
    'GetTriggerRepositoryEventConfigPullRequestResult',
    'GetTriggerRepositoryEventConfigPushResult',
    'GetTriggerSourceToBuildResult',
    'GetTriggerTriggerTemplateResult',
    'GetTriggerWebhookConfigResult',
]

@pulumi.output_type
class BitbucketServerConfigConnectedRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectKey":
            suggest = "project_key"
        elif key == "repoSlug":
            suggest = "repo_slug"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BitbucketServerConfigConnectedRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BitbucketServerConfigConnectedRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BitbucketServerConfigConnectedRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project_key: _builtins.str,
                 repo_slug: _builtins.str):
        """
        :param _builtins.str project_key: Identifier for the project storing the repository.
        :param _builtins.str repo_slug: Identifier for the repository.
        """
        pulumi.set(__self__, "project_key", project_key)
        pulumi.set(__self__, "repo_slug", repo_slug)

    @_builtins.property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> _builtins.str:
        """
        Identifier for the project storing the repository.
        """
        return pulumi.get(self, "project_key")

    @_builtins.property
    @pulumi.getter(name="repoSlug")
    def repo_slug(self) -> _builtins.str:
        """
        Identifier for the repository.
        """
        return pulumi.get(self, "repo_slug")


@pulumi.output_type
class BitbucketServerConfigSecrets(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminAccessTokenVersionName":
            suggest = "admin_access_token_version_name"
        elif key == "readAccessTokenVersionName":
            suggest = "read_access_token_version_name"
        elif key == "webhookSecretVersionName":
            suggest = "webhook_secret_version_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BitbucketServerConfigSecrets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BitbucketServerConfigSecrets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BitbucketServerConfigSecrets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_access_token_version_name: _builtins.str,
                 read_access_token_version_name: _builtins.str,
                 webhook_secret_version_name: _builtins.str):
        """
        :param _builtins.str admin_access_token_version_name: The resource name for the admin access token's secret version.
        :param _builtins.str read_access_token_version_name: The resource name for the read access token's secret version.
        :param _builtins.str webhook_secret_version_name: Immutable. The resource name for the webhook secret's secret version. Once this field has been set, it cannot be changed.
               Changing this field will result in deleting/ recreating the resource.
        """
        pulumi.set(__self__, "admin_access_token_version_name", admin_access_token_version_name)
        pulumi.set(__self__, "read_access_token_version_name", read_access_token_version_name)
        pulumi.set(__self__, "webhook_secret_version_name", webhook_secret_version_name)

    @_builtins.property
    @pulumi.getter(name="adminAccessTokenVersionName")
    def admin_access_token_version_name(self) -> _builtins.str:
        """
        The resource name for the admin access token's secret version.
        """
        return pulumi.get(self, "admin_access_token_version_name")

    @_builtins.property
    @pulumi.getter(name="readAccessTokenVersionName")
    def read_access_token_version_name(self) -> _builtins.str:
        """
        The resource name for the read access token's secret version.
        """
        return pulumi.get(self, "read_access_token_version_name")

    @_builtins.property
    @pulumi.getter(name="webhookSecretVersionName")
    def webhook_secret_version_name(self) -> _builtins.str:
        """
        Immutable. The resource name for the webhook secret's secret version. Once this field has been set, it cannot be changed.
        Changing this field will result in deleting/ recreating the resource.
        """
        return pulumi.get(self, "webhook_secret_version_name")


@pulumi.output_type
class TriggerApprovalConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "approvalRequired":
            suggest = "approval_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerApprovalConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerApprovalConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerApprovalConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 approval_required: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool approval_required: Whether or not approval is needed. If this is set on a build, it will become pending when run,
               and will need to be explicitly approved to start.
        """
        if approval_required is not None:
            pulumi.set(__self__, "approval_required", approval_required)

    @_builtins.property
    @pulumi.getter(name="approvalRequired")
    def approval_required(self) -> Optional[_builtins.bool]:
        """
        Whether or not approval is needed. If this is set on a build, it will become pending when run,
        and will need to be explicitly approved to start.
        """
        return pulumi.get(self, "approval_required")


@pulumi.output_type
class TriggerBitbucketServerTriggerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bitbucketServerConfigResource":
            suggest = "bitbucket_server_config_resource"
        elif key == "projectKey":
            suggest = "project_key"
        elif key == "repoSlug":
            suggest = "repo_slug"
        elif key == "pullRequest":
            suggest = "pull_request"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerBitbucketServerTriggerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerBitbucketServerTriggerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerBitbucketServerTriggerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bitbucket_server_config_resource: _builtins.str,
                 project_key: _builtins.str,
                 repo_slug: _builtins.str,
                 pull_request: Optional['outputs.TriggerBitbucketServerTriggerConfigPullRequest'] = None,
                 push: Optional['outputs.TriggerBitbucketServerTriggerConfigPush'] = None):
        """
        :param _builtins.str bitbucket_server_config_resource: The Bitbucket server config resource that this trigger config maps to.
        :param _builtins.str project_key: Key of the project that the repo is in. For example: The key for https://mybitbucket.server/projects/TEST/repos/test-repo is "TEST".
        :param _builtins.str repo_slug: Slug of the repository. A repository slug is a URL-friendly version of a repository name, automatically generated by Bitbucket for use in the URL.
               For example, if the repository name is 'test repo', in the URL it would become 'test-repo' as in https://mybitbucket.server/projects/TEST/repos/test-repo.
        :param 'TriggerBitbucketServerTriggerConfigPullRequestArgs' pull_request: Filter to match changes in pull requests.
               Structure is documented below.
        :param 'TriggerBitbucketServerTriggerConfigPushArgs' push: Filter to match changes in refs like branches, tags.
               Structure is documented below.
        """
        pulumi.set(__self__, "bitbucket_server_config_resource", bitbucket_server_config_resource)
        pulumi.set(__self__, "project_key", project_key)
        pulumi.set(__self__, "repo_slug", repo_slug)
        if pull_request is not None:
            pulumi.set(__self__, "pull_request", pull_request)
        if push is not None:
            pulumi.set(__self__, "push", push)

    @_builtins.property
    @pulumi.getter(name="bitbucketServerConfigResource")
    def bitbucket_server_config_resource(self) -> _builtins.str:
        """
        The Bitbucket server config resource that this trigger config maps to.
        """
        return pulumi.get(self, "bitbucket_server_config_resource")

    @_builtins.property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> _builtins.str:
        """
        Key of the project that the repo is in. For example: The key for https://mybitbucket.server/projects/TEST/repos/test-repo is "TEST".
        """
        return pulumi.get(self, "project_key")

    @_builtins.property
    @pulumi.getter(name="repoSlug")
    def repo_slug(self) -> _builtins.str:
        """
        Slug of the repository. A repository slug is a URL-friendly version of a repository name, automatically generated by Bitbucket for use in the URL.
        For example, if the repository name is 'test repo', in the URL it would become 'test-repo' as in https://mybitbucket.server/projects/TEST/repos/test-repo.
        """
        return pulumi.get(self, "repo_slug")

    @_builtins.property
    @pulumi.getter(name="pullRequest")
    def pull_request(self) -> Optional['outputs.TriggerBitbucketServerTriggerConfigPullRequest']:
        """
        Filter to match changes in pull requests.
        Structure is documented below.
        """
        return pulumi.get(self, "pull_request")

    @_builtins.property
    @pulumi.getter
    def push(self) -> Optional['outputs.TriggerBitbucketServerTriggerConfigPush']:
        """
        Filter to match changes in refs like branches, tags.
        Structure is documented below.
        """
        return pulumi.get(self, "push")


@pulumi.output_type
class TriggerBitbucketServerTriggerConfigPullRequest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commentControl":
            suggest = "comment_control"
        elif key == "invertRegex":
            suggest = "invert_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerBitbucketServerTriggerConfigPullRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerBitbucketServerTriggerConfigPullRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerBitbucketServerTriggerConfigPullRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: _builtins.str,
                 comment_control: Optional[_builtins.str] = None,
                 invert_regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str branch: Regex of branches to match.
        :param _builtins.str comment_control: Configure builds to run whether a repository owner or collaborator need to comment `/gcbrun`.
               Possible values are: `COMMENTS_DISABLED`, `COMMENTS_ENABLED`, `COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY`.
        :param _builtins.bool invert_regex: If true, branches that do NOT match the git_ref will trigger a build.
        """
        pulumi.set(__self__, "branch", branch)
        if comment_control is not None:
            pulumi.set(__self__, "comment_control", comment_control)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> _builtins.str:
        """
        Regex of branches to match.
        """
        return pulumi.get(self, "branch")

    @_builtins.property
    @pulumi.getter(name="commentControl")
    def comment_control(self) -> Optional[_builtins.str]:
        """
        Configure builds to run whether a repository owner or collaborator need to comment `/gcbrun`.
        Possible values are: `COMMENTS_DISABLED`, `COMMENTS_ENABLED`, `COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY`.
        """
        return pulumi.get(self, "comment_control")

    @_builtins.property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[_builtins.bool]:
        """
        If true, branches that do NOT match the git_ref will trigger a build.
        """
        return pulumi.get(self, "invert_regex")


@pulumi.output_type
class TriggerBitbucketServerTriggerConfigPush(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "invertRegex":
            suggest = "invert_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerBitbucketServerTriggerConfigPush. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerBitbucketServerTriggerConfigPush.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerBitbucketServerTriggerConfigPush.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[_builtins.str] = None,
                 invert_regex: Optional[_builtins.bool] = None,
                 tag: Optional[_builtins.str] = None):
        """
        :param _builtins.str branch: Regex of branches to match.
        :param _builtins.bool invert_regex: If true, only trigger a build if the revision regex does NOT match the git_ref regex.
        :param _builtins.str tag: Regex of tags to match.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> Optional[_builtins.str]:
        """
        Regex of branches to match.
        """
        return pulumi.get(self, "branch")

    @_builtins.property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[_builtins.bool]:
        """
        If true, only trigger a build if the revision regex does NOT match the git_ref regex.
        """
        return pulumi.get(self, "invert_regex")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[_builtins.str]:
        """
        Regex of tags to match.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class TriggerBuild(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availableSecrets":
            suggest = "available_secrets"
        elif key == "logsBucket":
            suggest = "logs_bucket"
        elif key == "queueTtl":
            suggest = "queue_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerBuild. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerBuild.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerBuild.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 steps: Sequence['outputs.TriggerBuildStep'],
                 artifacts: Optional['outputs.TriggerBuildArtifacts'] = None,
                 available_secrets: Optional['outputs.TriggerBuildAvailableSecrets'] = None,
                 images: Optional[Sequence[_builtins.str]] = None,
                 logs_bucket: Optional[_builtins.str] = None,
                 options: Optional['outputs.TriggerBuildOptions'] = None,
                 queue_ttl: Optional[_builtins.str] = None,
                 secrets: Optional[Sequence['outputs.TriggerBuildSecret']] = None,
                 source: Optional['outputs.TriggerBuildSource'] = None,
                 substitutions: Optional[Mapping[str, _builtins.str]] = None,
                 tags: Optional[Sequence[_builtins.str]] = None,
                 timeout: Optional[_builtins.str] = None):
        """
        :param Sequence['TriggerBuildStepArgs'] steps: The operations to be performed on the workspace.
               Structure is documented below.
        :param 'TriggerBuildArtifactsArgs' artifacts: Artifacts produced by the build that should be uploaded upon successful completion of all build steps.
               Structure is documented below.
        :param 'TriggerBuildAvailableSecretsArgs' available_secrets: Secrets and secret environment variables.
               Structure is documented below.
        :param Sequence[_builtins.str] images: A list of images to be pushed upon the successful completion of all build steps.
               The images are pushed using the builder service account's credentials.
               The digests of the pushed images will be stored in the Build resource's results field.
               If any of the images fail to be pushed, the build status is marked FAILURE.
        :param _builtins.str logs_bucket: Google Cloud Storage bucket where logs should be written.
               Logs file names will be of the format ${logsBucket}/log-${build_id}.txt.
        :param 'TriggerBuildOptionsArgs' options: Special options for this build.
               Structure is documented below.
        :param _builtins.str queue_ttl: TTL in queue for this build. If provided and the build is enqueued longer than this value,
               the build will expire and the build status will be EXPIRED.
               The TTL starts ticking from createTime.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param Sequence['TriggerBuildSecretArgs'] secrets: Secrets to decrypt using Cloud Key Management Service.
               Structure is documented below.
        :param 'TriggerBuildSourceArgs' source: The location of the source files to build.
               One of `storageSource` or `repoSource` must be provided.
               Structure is documented below.
        :param Mapping[str, _builtins.str] substitutions: Substitutions data for Build resource.
        :param Sequence[_builtins.str] tags: Tags for annotation of a Build. These are not docker tags.
        :param _builtins.str timeout: Amount of time that this build should be allowed to run, to second granularity.
               If this amount of time elapses, work on the build will cease and the build status will be TIMEOUT.
               This timeout must be equal to or greater than the sum of the timeouts for build steps within the build.
               The expected format is the number of seconds followed by s.
               Default time is ten minutes (600s).
        """
        pulumi.set(__self__, "steps", steps)
        if artifacts is not None:
            pulumi.set(__self__, "artifacts", artifacts)
        if available_secrets is not None:
            pulumi.set(__self__, "available_secrets", available_secrets)
        if images is not None:
            pulumi.set(__self__, "images", images)
        if logs_bucket is not None:
            pulumi.set(__self__, "logs_bucket", logs_bucket)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if queue_ttl is not None:
            pulumi.set(__self__, "queue_ttl", queue_ttl)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if substitutions is not None:
            pulumi.set(__self__, "substitutions", substitutions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def steps(self) -> Sequence['outputs.TriggerBuildStep']:
        """
        The operations to be performed on the workspace.
        Structure is documented below.
        """
        return pulumi.get(self, "steps")

    @_builtins.property
    @pulumi.getter
    def artifacts(self) -> Optional['outputs.TriggerBuildArtifacts']:
        """
        Artifacts produced by the build that should be uploaded upon successful completion of all build steps.
        Structure is documented below.
        """
        return pulumi.get(self, "artifacts")

    @_builtins.property
    @pulumi.getter(name="availableSecrets")
    def available_secrets(self) -> Optional['outputs.TriggerBuildAvailableSecrets']:
        """
        Secrets and secret environment variables.
        Structure is documented below.
        """
        return pulumi.get(self, "available_secrets")

    @_builtins.property
    @pulumi.getter
    def images(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of images to be pushed upon the successful completion of all build steps.
        The images are pushed using the builder service account's credentials.
        The digests of the pushed images will be stored in the Build resource's results field.
        If any of the images fail to be pushed, the build status is marked FAILURE.
        """
        return pulumi.get(self, "images")

    @_builtins.property
    @pulumi.getter(name="logsBucket")
    def logs_bucket(self) -> Optional[_builtins.str]:
        """
        Google Cloud Storage bucket where logs should be written.
        Logs file names will be of the format ${logsBucket}/log-${build_id}.txt.
        """
        return pulumi.get(self, "logs_bucket")

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional['outputs.TriggerBuildOptions']:
        """
        Special options for this build.
        Structure is documented below.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter(name="queueTtl")
    def queue_ttl(self) -> Optional[_builtins.str]:
        """
        TTL in queue for this build. If provided and the build is enqueued longer than this value,
        the build will expire and the build status will be EXPIRED.
        The TTL starts ticking from createTime.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "queue_ttl")

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Optional[Sequence['outputs.TriggerBuildSecret']]:
        """
        Secrets to decrypt using Cloud Key Management Service.
        Structure is documented below.
        """
        return pulumi.get(self, "secrets")

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional['outputs.TriggerBuildSource']:
        """
        The location of the source files to build.
        One of `storageSource` or `repoSource` must be provided.
        Structure is documented below.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def substitutions(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Substitutions data for Build resource.
        """
        return pulumi.get(self, "substitutions")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        Tags for annotation of a Build. These are not docker tags.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.str]:
        """
        Amount of time that this build should be allowed to run, to second granularity.
        If this amount of time elapses, work on the build will cease and the build status will be TIMEOUT.
        This timeout must be equal to or greater than the sum of the timeouts for build steps within the build.
        The expected format is the number of seconds followed by s.
        Default time is ten minutes (600s).
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class TriggerBuildArtifacts(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mavenArtifacts":
            suggest = "maven_artifacts"
        elif key == "npmPackages":
            suggest = "npm_packages"
        elif key == "pythonPackages":
            suggest = "python_packages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerBuildArtifacts. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerBuildArtifacts.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerBuildArtifacts.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 images: Optional[Sequence[_builtins.str]] = None,
                 maven_artifacts: Optional[Sequence['outputs.TriggerBuildArtifactsMavenArtifact']] = None,
                 npm_packages: Optional[Sequence['outputs.TriggerBuildArtifactsNpmPackage']] = None,
                 objects: Optional['outputs.TriggerBuildArtifactsObjects'] = None,
                 python_packages: Optional[Sequence['outputs.TriggerBuildArtifactsPythonPackage']] = None):
        """
        :param Sequence[_builtins.str] images: A list of images to be pushed upon the successful completion of all build steps.
               The images will be pushed using the builder service account's credentials.
               The digests of the pushed images will be stored in the Build resource's results field.
               If any of the images fail to be pushed, the build is marked FAILURE.
        :param Sequence['TriggerBuildArtifactsMavenArtifactArgs'] maven_artifacts: A Maven artifact to upload to Artifact Registry upon successful completion of all build steps.
               The location and generation of the uploaded objects will be stored in the Build resource's results field.
               If any objects fail to be pushed, the build is marked FAILURE.
               Structure is documented below.
        :param Sequence['TriggerBuildArtifactsNpmPackageArgs'] npm_packages: Npm package to upload to Artifact Registry upon successful completion of all build steps.
               The location and generation of the uploaded objects will be stored in the Build resource's results field.
               If any objects fail to be pushed, the build is marked FAILURE.
               Structure is documented below.
        :param 'TriggerBuildArtifactsObjectsArgs' objects: A list of objects to be uploaded to Cloud Storage upon successful completion of all build steps.
               Files in the workspace matching specified paths globs will be uploaded to the
               Cloud Storage location using the builder service account's credentials.
               The location and generation of the uploaded objects will be stored in the Build resource's results field.
               If any objects fail to be pushed, the build is marked FAILURE.
               Structure is documented below.
        :param Sequence['TriggerBuildArtifactsPythonPackageArgs'] python_packages: Python package to upload to Artifact Registry upon successful completion of all build steps. A package can encapsulate multiple objects to be uploaded to a single repository.
               The location and generation of the uploaded objects will be stored in the Build resource's results field.
               If any objects fail to be pushed, the build is marked FAILURE.
               Structure is documented below.
        """
        if images is not None:
            pulumi.set(__self__, "images", images)
        if maven_artifacts is not None:
            pulumi.set(__self__, "maven_artifacts", maven_artifacts)
        if npm_packages is not None:
            pulumi.set(__self__, "npm_packages", npm_packages)
        if objects is not None:
            pulumi.set(__self__, "objects", objects)
        if python_packages is not None:
            pulumi.set(__self__, "python_packages", python_packages)

    @_builtins.property
    @pulumi.getter
    def images(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of images to be pushed upon the successful completion of all build steps.
        The images will be pushed using the builder service account's credentials.
        The digests of the pushed images will be stored in the Build resource's results field.
        If any of the images fail to be pushed, the build is marked FAILURE.
        """
        return pulumi.get(self, "images")

    @_builtins.property
    @pulumi.getter(name="mavenArtifacts")
    def maven_artifacts(self) -> Optional[Sequence['outputs.TriggerBuildArtifactsMavenArtifact']]:
        """
        A Maven artifact to upload to Artifact Registry upon successful completion of all build steps.
        The location and generation of the uploaded objects will be stored in the Build resource's results field.
        If any objects fail to be pushed, the build is marked FAILURE.
        Structure is documented below.
        """
        return pulumi.get(self, "maven_artifacts")

    @_builtins.property
    @pulumi.getter(name="npmPackages")
    def npm_packages(self) -> Optional[Sequence['outputs.TriggerBuildArtifactsNpmPackage']]:
        """
        Npm package to upload to Artifact Registry upon successful completion of all build steps.
        The location and generation of the uploaded objects will be stored in the Build resource's results field.
        If any objects fail to be pushed, the build is marked FAILURE.
        Structure is documented below.
        """
        return pulumi.get(self, "npm_packages")

    @_builtins.property
    @pulumi.getter
    def objects(self) -> Optional['outputs.TriggerBuildArtifactsObjects']:
        """
        A list of objects to be uploaded to Cloud Storage upon successful completion of all build steps.
        Files in the workspace matching specified paths globs will be uploaded to the
        Cloud Storage location using the builder service account's credentials.
        The location and generation of the uploaded objects will be stored in the Build resource's results field.
        If any objects fail to be pushed, the build is marked FAILURE.
        Structure is documented below.
        """
        return pulumi.get(self, "objects")

    @_builtins.property
    @pulumi.getter(name="pythonPackages")
    def python_packages(self) -> Optional[Sequence['outputs.TriggerBuildArtifactsPythonPackage']]:
        """
        Python package to upload to Artifact Registry upon successful completion of all build steps. A package can encapsulate multiple objects to be uploaded to a single repository.
        The location and generation of the uploaded objects will be stored in the Build resource's results field.
        If any objects fail to be pushed, the build is marked FAILURE.
        Structure is documented below.
        """
        return pulumi.get(self, "python_packages")


@pulumi.output_type
class TriggerBuildArtifactsMavenArtifact(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactId":
            suggest = "artifact_id"
        elif key == "groupId":
            suggest = "group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerBuildArtifactsMavenArtifact. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerBuildArtifactsMavenArtifact.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerBuildArtifactsMavenArtifact.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_id: Optional[_builtins.str] = None,
                 group_id: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 repository: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str artifact_id: Maven artifactId value used when uploading the artifact to Artifact Registry.
        :param _builtins.str group_id: Maven groupId value used when uploading the artifact to Artifact Registry.
        :param _builtins.str path: Path to an artifact in the build's workspace to be uploaded to Artifact Registry. This can be either an absolute path, e.g. /workspace/my-app/target/my-app-1.0.SNAPSHOT.jar or a relative path from /workspace, e.g. my-app/target/my-app-1.0.SNAPSHOT.jar.
        :param _builtins.str repository: Artifact Registry repository, in the form "https://$REGION-maven.pkg.dev/$PROJECT/$REPOSITORY"
               Artifact in the workspace specified by path will be uploaded to Artifact Registry with this location as a prefix.
        :param _builtins.str version: Maven version value used when uploading the artifact to Artifact Registry.
        """
        if artifact_id is not None:
            pulumi.set(__self__, "artifact_id", artifact_id)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> Optional[_builtins.str]:
        """
        Maven artifactId value used when uploading the artifact to Artifact Registry.
        """
        return pulumi.get(self, "artifact_id")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[_builtins.str]:
        """
        Maven groupId value used when uploading the artifact to Artifact Registry.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Path to an artifact in the build's workspace to be uploaded to Artifact Registry. This can be either an absolute path, e.g. /workspace/my-app/target/my-app-1.0.SNAPSHOT.jar or a relative path from /workspace, e.g. my-app/target/my-app-1.0.SNAPSHOT.jar.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> Optional[_builtins.str]:
        """
        Artifact Registry repository, in the form "https://$REGION-maven.pkg.dev/$PROJECT/$REPOSITORY"
        Artifact in the workspace specified by path will be uploaded to Artifact Registry with this location as a prefix.
        """
        return pulumi.get(self, "repository")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        Maven version value used when uploading the artifact to Artifact Registry.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class TriggerBuildArtifactsNpmPackage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "packagePath":
            suggest = "package_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerBuildArtifactsNpmPackage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerBuildArtifactsNpmPackage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerBuildArtifactsNpmPackage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 package_path: Optional[_builtins.str] = None,
                 repository: Optional[_builtins.str] = None):
        """
        :param _builtins.str package_path: Path to the package.json. e.g. workspace/path/to/package
        :param _builtins.str repository: Artifact Registry repository, in the form "https://$REGION-npm.pkg.dev/$PROJECT/$REPOSITORY"
               Npm package in the workspace specified by path will be zipped and uploaded to Artifact Registry with this location as a prefix.
        """
        if package_path is not None:
            pulumi.set(__self__, "package_path", package_path)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)

    @_builtins.property
    @pulumi.getter(name="packagePath")
    def package_path(self) -> Optional[_builtins.str]:
        """
        Path to the package.json. e.g. workspace/path/to/package
        """
        return pulumi.get(self, "package_path")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> Optional[_builtins.str]:
        """
        Artifact Registry repository, in the form "https://$REGION-npm.pkg.dev/$PROJECT/$REPOSITORY"
        Npm package in the workspace specified by path will be zipped and uploaded to Artifact Registry with this location as a prefix.
        """
        return pulumi.get(self, "repository")


@pulumi.output_type
class TriggerBuildArtifactsObjects(dict):
    def __init__(__self__, *,
                 location: Optional[_builtins.str] = None,
                 paths: Optional[Sequence[_builtins.str]] = None,
                 timings: Optional[Sequence['outputs.TriggerBuildArtifactsObjectsTiming']] = None):
        """
        :param _builtins.str location: Cloud Storage bucket and optional object path, in the form "gs://bucket/path/to/somewhere/".
               Files in the workspace matching any path pattern will be uploaded to Cloud Storage with
               this location as a prefix.
        :param Sequence[_builtins.str] paths: Path globs used to match files in the build's workspace.
        :param Sequence['TriggerBuildArtifactsObjectsTimingArgs'] timings: (Output)
               Output only. Stores timing information for pushing all artifact objects.
               Structure is documented below.
               
               
               <a name="nested_build_artifacts_objects_timing"></a>The `timing` block contains:
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if timings is not None:
            pulumi.set(__self__, "timings", timings)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[_builtins.str]:
        """
        Cloud Storage bucket and optional object path, in the form "gs://bucket/path/to/somewhere/".
        Files in the workspace matching any path pattern will be uploaded to Cloud Storage with
        this location as a prefix.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def paths(self) -> Optional[Sequence[_builtins.str]]:
        """
        Path globs used to match files in the build's workspace.
        """
        return pulumi.get(self, "paths")

    @_builtins.property
    @pulumi.getter
    def timings(self) -> Optional[Sequence['outputs.TriggerBuildArtifactsObjectsTiming']]:
        """
        (Output)
        Output only. Stores timing information for pushing all artifact objects.
        Structure is documented below.


        <a name="nested_build_artifacts_objects_timing"></a>The `timing` block contains:
        """
        return pulumi.get(self, "timings")


@pulumi.output_type
class TriggerBuildArtifactsObjectsTiming(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerBuildArtifactsObjectsTiming. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerBuildArtifactsObjectsTiming.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerBuildArtifactsObjectsTiming.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: Optional[_builtins.str] = None,
                 start_time: Optional[_builtins.str] = None):
        """
        :param _builtins.str end_time: End of time span.
               
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to
               nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param _builtins.str start_time: Start of time span.
               
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to
               nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[_builtins.str]:
        """
        End of time span.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to
        nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[_builtins.str]:
        """
        Start of time span.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to
        nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class TriggerBuildArtifactsPythonPackage(dict):
    def __init__(__self__, *,
                 paths: Optional[Sequence[_builtins.str]] = None,
                 repository: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] paths: Path globs used to match files in the build's workspace. For Python/ Twine, this is usually dist/*, and sometimes additionally an .asc file.
        :param _builtins.str repository: Artifact Registry repository, in the form "https://$REGION-python.pkg.dev/$PROJECT/$REPOSITORY"
               Files in the workspace matching any path pattern will be uploaded to Artifact Registry with this location as a prefix.
        """
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)

    @_builtins.property
    @pulumi.getter
    def paths(self) -> Optional[Sequence[_builtins.str]]:
        """
        Path globs used to match files in the build's workspace. For Python/ Twine, this is usually dist/*, and sometimes additionally an .asc file.
        """
        return pulumi.get(self, "paths")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> Optional[_builtins.str]:
        """
        Artifact Registry repository, in the form "https://$REGION-python.pkg.dev/$PROJECT/$REPOSITORY"
        Files in the workspace matching any path pattern will be uploaded to Artifact Registry with this location as a prefix.
        """
        return pulumi.get(self, "repository")


@pulumi.output_type
class TriggerBuildAvailableSecrets(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretManagers":
            suggest = "secret_managers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerBuildAvailableSecrets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerBuildAvailableSecrets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerBuildAvailableSecrets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_managers: Sequence['outputs.TriggerBuildAvailableSecretsSecretManager']):
        """
        :param Sequence['TriggerBuildAvailableSecretsSecretManagerArgs'] secret_managers: Pairs a secret environment variable with a SecretVersion in Secret Manager.
               Structure is documented below.
        """
        pulumi.set(__self__, "secret_managers", secret_managers)

    @_builtins.property
    @pulumi.getter(name="secretManagers")
    def secret_managers(self) -> Sequence['outputs.TriggerBuildAvailableSecretsSecretManager']:
        """
        Pairs a secret environment variable with a SecretVersion in Secret Manager.
        Structure is documented below.
        """
        return pulumi.get(self, "secret_managers")


@pulumi.output_type
class TriggerBuildAvailableSecretsSecretManager(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "versionName":
            suggest = "version_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerBuildAvailableSecretsSecretManager. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerBuildAvailableSecretsSecretManager.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerBuildAvailableSecretsSecretManager.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 env: _builtins.str,
                 version_name: _builtins.str):
        """
        :param _builtins.str env: Environment variable name to associate with the secret. Secret environment
               variables must be unique across all of a build's secrets, and must be used
               by at least one build step.
        :param _builtins.str version_name: Resource name of the SecretVersion. In format: projects/*/secrets/*/versions/*
        """
        pulumi.set(__self__, "env", env)
        pulumi.set(__self__, "version_name", version_name)

    @_builtins.property
    @pulumi.getter
    def env(self) -> _builtins.str:
        """
        Environment variable name to associate with the secret. Secret environment
        variables must be unique across all of a build's secrets, and must be used
        by at least one build step.
        """
        return pulumi.get(self, "env")

    @_builtins.property
    @pulumi.getter(name="versionName")
    def version_name(self) -> _builtins.str:
        """
        Resource name of the SecretVersion. In format: projects/*/secrets/*/versions/*
        """
        return pulumi.get(self, "version_name")


@pulumi.output_type
class TriggerBuildOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "dynamicSubstitutions":
            suggest = "dynamic_substitutions"
        elif key == "logStreamingOption":
            suggest = "log_streaming_option"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "requestedVerifyOption":
            suggest = "requested_verify_option"
        elif key == "secretEnvs":
            suggest = "secret_envs"
        elif key == "sourceProvenanceHashes":
            suggest = "source_provenance_hashes"
        elif key == "substitutionOption":
            suggest = "substitution_option"
        elif key == "workerPool":
            suggest = "worker_pool"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerBuildOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerBuildOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerBuildOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_size_gb: Optional[_builtins.int] = None,
                 dynamic_substitutions: Optional[_builtins.bool] = None,
                 envs: Optional[Sequence[_builtins.str]] = None,
                 log_streaming_option: Optional[_builtins.str] = None,
                 logging: Optional[_builtins.str] = None,
                 machine_type: Optional[_builtins.str] = None,
                 requested_verify_option: Optional[_builtins.str] = None,
                 secret_envs: Optional[Sequence[_builtins.str]] = None,
                 source_provenance_hashes: Optional[Sequence[_builtins.str]] = None,
                 substitution_option: Optional[_builtins.str] = None,
                 volumes: Optional[Sequence['outputs.TriggerBuildOptionsVolume']] = None,
                 worker_pool: Optional[_builtins.str] = None):
        """
        :param _builtins.int disk_size_gb: Requested disk size for the VM that runs the build. Note that this is NOT "disk free";
               some of the space will be used by the operating system and build utilities.
               Also note that this is the minimum disk size that will be allocated for the build --
               the build may run with a larger disk than requested. At present, the maximum disk size
               is 1000GB; builds that request more than the maximum are rejected with an error.
        :param _builtins.bool dynamic_substitutions: Option to specify whether or not to apply bash style string operations to the substitutions.
               NOTE this is always enabled for triggered builds and cannot be overridden in the build configuration file.
        :param Sequence[_builtins.str] envs: A list of global environment variable definitions that will exist for all build steps
               in this build. If a variable is defined in both globally and in a build step,
               the variable will use the build step value.
               The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        :param _builtins.str log_streaming_option: Option to define build log streaming behavior to Google Cloud Storage.
               Possible values are: `STREAM_DEFAULT`, `STREAM_ON`, `STREAM_OFF`.
        :param _builtins.str logging: Option to specify the logging mode, which determines if and where build logs are stored.
               Possible values are: `LOGGING_UNSPECIFIED`, `LEGACY`, `GCS_ONLY`, `STACKDRIVER_ONLY`, `CLOUD_LOGGING_ONLY`, `NONE`.
        :param _builtins.str machine_type: Compute Engine machine type on which to run the build.
        :param _builtins.str requested_verify_option: Requested verifiability options.
               Possible values are: `NOT_VERIFIED`, `VERIFIED`.
        :param Sequence[_builtins.str] secret_envs: A list of global environment variables, which are encrypted using a Cloud Key Management
               Service crypto key. These values must be specified in the build's Secret. These variables
               will be available to all build steps in this build.
        :param Sequence[_builtins.str] source_provenance_hashes: Requested hash for SourceProvenance.
               Each value may be one of: `NONE`, `SHA256`, `MD5`.
        :param _builtins.str substitution_option: Option to specify behavior when there is an error in the substitution checks.
               NOTE this is always set to ALLOW_LOOSE for triggered builds and cannot be overridden
               in the build configuration file.
               Possible values are: `MUST_MATCH`, `ALLOW_LOOSE`.
        :param Sequence['TriggerBuildOptionsVolumeArgs'] volumes: Global list of volumes to mount for ALL build steps
               Each volume is created as an empty volume prior to starting the build process.
               Upon completion of the build, volumes and their contents are discarded. Global
               volume names and paths cannot conflict with the volumes defined a build step.
               Using a global volume in a build with only one step is not valid as it is indicative
               of a build request with an incorrect configuration.
               Structure is documented below.
        :param _builtins.str worker_pool: Option to specify a WorkerPool for the build. Format projects/{project}/workerPools/{workerPool}
               This field is experimental.
        """
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if dynamic_substitutions is not None:
            pulumi.set(__self__, "dynamic_substitutions", dynamic_substitutions)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if log_streaming_option is not None:
            pulumi.set(__self__, "log_streaming_option", log_streaming_option)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if requested_verify_option is not None:
            pulumi.set(__self__, "requested_verify_option", requested_verify_option)
        if secret_envs is not None:
            pulumi.set(__self__, "secret_envs", secret_envs)
        if source_provenance_hashes is not None:
            pulumi.set(__self__, "source_provenance_hashes", source_provenance_hashes)
        if substitution_option is not None:
            pulumi.set(__self__, "substitution_option", substitution_option)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if worker_pool is not None:
            pulumi.set(__self__, "worker_pool", worker_pool)

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[_builtins.int]:
        """
        Requested disk size for the VM that runs the build. Note that this is NOT "disk free";
        some of the space will be used by the operating system and build utilities.
        Also note that this is the minimum disk size that will be allocated for the build --
        the build may run with a larger disk than requested. At present, the maximum disk size
        is 1000GB; builds that request more than the maximum are rejected with an error.
        """
        return pulumi.get(self, "disk_size_gb")

    @_builtins.property
    @pulumi.getter(name="dynamicSubstitutions")
    def dynamic_substitutions(self) -> Optional[_builtins.bool]:
        """
        Option to specify whether or not to apply bash style string operations to the substitutions.
        NOTE this is always enabled for triggered builds and cannot be overridden in the build configuration file.
        """
        return pulumi.get(self, "dynamic_substitutions")

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of global environment variable definitions that will exist for all build steps
        in this build. If a variable is defined in both globally and in a build step,
        the variable will use the build step value.
        The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        """
        return pulumi.get(self, "envs")

    @_builtins.property
    @pulumi.getter(name="logStreamingOption")
    def log_streaming_option(self) -> Optional[_builtins.str]:
        """
        Option to define build log streaming behavior to Google Cloud Storage.
        Possible values are: `STREAM_DEFAULT`, `STREAM_ON`, `STREAM_OFF`.
        """
        return pulumi.get(self, "log_streaming_option")

    @_builtins.property
    @pulumi.getter
    def logging(self) -> Optional[_builtins.str]:
        """
        Option to specify the logging mode, which determines if and where build logs are stored.
        Possible values are: `LOGGING_UNSPECIFIED`, `LEGACY`, `GCS_ONLY`, `STACKDRIVER_ONLY`, `CLOUD_LOGGING_ONLY`, `NONE`.
        """
        return pulumi.get(self, "logging")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[_builtins.str]:
        """
        Compute Engine machine type on which to run the build.
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter(name="requestedVerifyOption")
    def requested_verify_option(self) -> Optional[_builtins.str]:
        """
        Requested verifiability options.
        Possible values are: `NOT_VERIFIED`, `VERIFIED`.
        """
        return pulumi.get(self, "requested_verify_option")

    @_builtins.property
    @pulumi.getter(name="secretEnvs")
    def secret_envs(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of global environment variables, which are encrypted using a Cloud Key Management
        Service crypto key. These values must be specified in the build's Secret. These variables
        will be available to all build steps in this build.
        """
        return pulumi.get(self, "secret_envs")

    @_builtins.property
    @pulumi.getter(name="sourceProvenanceHashes")
    def source_provenance_hashes(self) -> Optional[Sequence[_builtins.str]]:
        """
        Requested hash for SourceProvenance.
        Each value may be one of: `NONE`, `SHA256`, `MD5`.
        """
        return pulumi.get(self, "source_provenance_hashes")

    @_builtins.property
    @pulumi.getter(name="substitutionOption")
    def substitution_option(self) -> Optional[_builtins.str]:
        """
        Option to specify behavior when there is an error in the substitution checks.
        NOTE this is always set to ALLOW_LOOSE for triggered builds and cannot be overridden
        in the build configuration file.
        Possible values are: `MUST_MATCH`, `ALLOW_LOOSE`.
        """
        return pulumi.get(self, "substitution_option")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.TriggerBuildOptionsVolume']]:
        """
        Global list of volumes to mount for ALL build steps
        Each volume is created as an empty volume prior to starting the build process.
        Upon completion of the build, volumes and their contents are discarded. Global
        volume names and paths cannot conflict with the volumes defined a build step.
        Using a global volume in a build with only one step is not valid as it is indicative
        of a build request with an incorrect configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "volumes")

    @_builtins.property
    @pulumi.getter(name="workerPool")
    def worker_pool(self) -> Optional[_builtins.str]:
        """
        Option to specify a WorkerPool for the build. Format projects/{project}/workerPools/{workerPool}
        This field is experimental.
        """
        return pulumi.get(self, "worker_pool")


@pulumi.output_type
class TriggerBuildOptionsVolume(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Name of the volume to mount.
               Volume names must be unique per build step and must be valid names for Docker volumes.
               Each named volume must be used by at least two build steps.
        :param _builtins.str path: Path at which to mount the volume.
               Paths must be absolute and cannot conflict with other volume paths on the same
               build step or with certain reserved volume paths.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the volume to mount.
        Volume names must be unique per build step and must be valid names for Docker volumes.
        Each named volume must be used by at least two build steps.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Path at which to mount the volume.
        Paths must be absolute and cannot conflict with other volume paths on the same
        build step or with certain reserved volume paths.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class TriggerBuildSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"
        elif key == "secretEnv":
            suggest = "secret_env"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerBuildSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerBuildSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerBuildSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: _builtins.str,
                 secret_env: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str kms_key_name: Cloud KMS key name to use to decrypt these envs.
        :param Mapping[str, _builtins.str] secret_env: Map of environment variable name to its encrypted value.
               Secret environment variables must be unique across all of a build's secrets,
               and must be used by at least one build step. Values can be at most 64 KB in size.
               There can be at most 100 secret values across all of a build's secrets.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        if secret_env is not None:
            pulumi.set(__self__, "secret_env", secret_env)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> _builtins.str:
        """
        Cloud KMS key name to use to decrypt these envs.
        """
        return pulumi.get(self, "kms_key_name")

    @_builtins.property
    @pulumi.getter(name="secretEnv")
    def secret_env(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Map of environment variable name to its encrypted value.
        Secret environment variables must be unique across all of a build's secrets,
        and must be used by at least one build step. Values can be at most 64 KB in size.
        There can be at most 100 secret values across all of a build's secrets.
        """
        return pulumi.get(self, "secret_env")


@pulumi.output_type
class TriggerBuildSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repoSource":
            suggest = "repo_source"
        elif key == "storageSource":
            suggest = "storage_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerBuildSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerBuildSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerBuildSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repo_source: Optional['outputs.TriggerBuildSourceRepoSource'] = None,
                 storage_source: Optional['outputs.TriggerBuildSourceStorageSource'] = None):
        """
        :param 'TriggerBuildSourceRepoSourceArgs' repo_source: Location of the source in a Google Cloud Source Repository.
               Structure is documented below.
        :param 'TriggerBuildSourceStorageSourceArgs' storage_source: Location of the source in an archive file in Google Cloud Storage.
               Structure is documented below.
        """
        if repo_source is not None:
            pulumi.set(__self__, "repo_source", repo_source)
        if storage_source is not None:
            pulumi.set(__self__, "storage_source", storage_source)

    @_builtins.property
    @pulumi.getter(name="repoSource")
    def repo_source(self) -> Optional['outputs.TriggerBuildSourceRepoSource']:
        """
        Location of the source in a Google Cloud Source Repository.
        Structure is documented below.
        """
        return pulumi.get(self, "repo_source")

    @_builtins.property
    @pulumi.getter(name="storageSource")
    def storage_source(self) -> Optional['outputs.TriggerBuildSourceStorageSource']:
        """
        Location of the source in an archive file in Google Cloud Storage.
        Structure is documented below.
        """
        return pulumi.get(self, "storage_source")


@pulumi.output_type
class TriggerBuildSourceRepoSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repoName":
            suggest = "repo_name"
        elif key == "branchName":
            suggest = "branch_name"
        elif key == "commitSha":
            suggest = "commit_sha"
        elif key == "invertRegex":
            suggest = "invert_regex"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "tagName":
            suggest = "tag_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerBuildSourceRepoSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerBuildSourceRepoSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerBuildSourceRepoSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repo_name: _builtins.str,
                 branch_name: Optional[_builtins.str] = None,
                 commit_sha: Optional[_builtins.str] = None,
                 dir: Optional[_builtins.str] = None,
                 invert_regex: Optional[_builtins.bool] = None,
                 project_id: Optional[_builtins.str] = None,
                 substitutions: Optional[Mapping[str, _builtins.str]] = None,
                 tag_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str repo_name: Name of the Cloud Source Repository.
        :param _builtins.str branch_name: Regex matching branches to build. Exactly one a of branch name, tag, or commit SHA must be provided.
               The syntax of the regular expressions accepted is the syntax accepted by RE2 and
               described at https://github.com/google/re2/wiki/Syntax
        :param _builtins.str commit_sha: Explicit commit SHA to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        :param _builtins.str dir: Directory, relative to the source root, in which to run the build.
               This must be a relative path. If a step's dir is specified and is an absolute path,
               this value is ignored for that step's execution.
        :param _builtins.bool invert_regex: Only trigger a build if the revision regex does NOT match the revision regex.
        :param _builtins.str project_id: ID of the project that owns the Cloud Source Repository.
               If omitted, the project ID requesting the build is assumed.
        :param Mapping[str, _builtins.str] substitutions: Substitutions to use in a triggered build. Should only be used with triggers.run
        :param _builtins.str tag_name: Regex matching tags to build. Exactly one a of branch name, tag, or commit SHA must be provided.
               The syntax of the regular expressions accepted is the syntax accepted by RE2 and
               described at https://github.com/google/re2/wiki/Syntax
        """
        pulumi.set(__self__, "repo_name", repo_name)
        if branch_name is not None:
            pulumi.set(__self__, "branch_name", branch_name)
        if commit_sha is not None:
            pulumi.set(__self__, "commit_sha", commit_sha)
        if dir is not None:
            pulumi.set(__self__, "dir", dir)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if substitutions is not None:
            pulumi.set(__self__, "substitutions", substitutions)
        if tag_name is not None:
            pulumi.set(__self__, "tag_name", tag_name)

    @_builtins.property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> _builtins.str:
        """
        Name of the Cloud Source Repository.
        """
        return pulumi.get(self, "repo_name")

    @_builtins.property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> Optional[_builtins.str]:
        """
        Regex matching branches to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and
        described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "branch_name")

    @_builtins.property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> Optional[_builtins.str]:
        """
        Explicit commit SHA to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        """
        return pulumi.get(self, "commit_sha")

    @_builtins.property
    @pulumi.getter
    def dir(self) -> Optional[_builtins.str]:
        """
        Directory, relative to the source root, in which to run the build.
        This must be a relative path. If a step's dir is specified and is an absolute path,
        this value is ignored for that step's execution.
        """
        return pulumi.get(self, "dir")

    @_builtins.property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[_builtins.bool]:
        """
        Only trigger a build if the revision regex does NOT match the revision regex.
        """
        return pulumi.get(self, "invert_regex")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        ID of the project that owns the Cloud Source Repository.
        If omitted, the project ID requesting the build is assumed.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def substitutions(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Substitutions to use in a triggered build. Should only be used with triggers.run
        """
        return pulumi.get(self, "substitutions")

    @_builtins.property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> Optional[_builtins.str]:
        """
        Regex matching tags to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and
        described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "tag_name")


@pulumi.output_type
class TriggerBuildSourceStorageSource(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 object: _builtins.str,
                 generation: Optional[_builtins.str] = None):
        """
        :param _builtins.str bucket: Google Cloud Storage bucket containing the source.
        :param _builtins.str object: Google Cloud Storage object containing the source.
               This object must be a gzipped archive file (.tar.gz) containing source to build.
        :param _builtins.str generation: Google Cloud Storage generation for the object.
               If the generation is omitted, the latest generation will be used
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "object", object)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        Google Cloud Storage bucket containing the source.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def object(self) -> _builtins.str:
        """
        Google Cloud Storage object containing the source.
        This object must be a gzipped archive file (.tar.gz) containing source to build.
        """
        return pulumi.get(self, "object")

    @_builtins.property
    @pulumi.getter
    def generation(self) -> Optional[_builtins.str]:
        """
        Google Cloud Storage generation for the object.
        If the generation is omitted, the latest generation will be used
        """
        return pulumi.get(self, "generation")


@pulumi.output_type
class TriggerBuildStep(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowExitCodes":
            suggest = "allow_exit_codes"
        elif key == "allowFailure":
            suggest = "allow_failure"
        elif key == "secretEnvs":
            suggest = "secret_envs"
        elif key == "waitFors":
            suggest = "wait_fors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerBuildStep. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerBuildStep.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerBuildStep.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 allow_exit_codes: Optional[Sequence[_builtins.int]] = None,
                 allow_failure: Optional[_builtins.bool] = None,
                 args: Optional[Sequence[_builtins.str]] = None,
                 dir: Optional[_builtins.str] = None,
                 entrypoint: Optional[_builtins.str] = None,
                 envs: Optional[Sequence[_builtins.str]] = None,
                 id: Optional[_builtins.str] = None,
                 script: Optional[_builtins.str] = None,
                 secret_envs: Optional[Sequence[_builtins.str]] = None,
                 timeout: Optional[_builtins.str] = None,
                 timing: Optional[_builtins.str] = None,
                 volumes: Optional[Sequence['outputs.TriggerBuildStepVolume']] = None,
                 wait_fors: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str name: The name of the container image that will run this particular build step.
               If the image is available in the host's Docker daemon's cache, it will be
               run directly. If not, the host will attempt to pull the image first, using
               the builder service account's credentials if necessary.
               The Docker daemon's cache will already have the latest versions of all of
               the officially supported build steps (see https://github.com/GoogleCloudPlatform/cloud-builders
               for images and examples).
               The Docker daemon will also have cached many of the layers for some popular
               images, like "ubuntu", "debian", but they will be refreshed at the time
               you attempt to use them.
               If you built an image in a previous build step, it will be stored in the
               host's Docker daemon's cache and is available to use as the name for a
               later build step.
        :param Sequence[_builtins.int] allow_exit_codes: Allow this build step to fail without failing the entire build if and
               only if the exit code is one of the specified codes.
               If `allowFailure` is also specified, this field will take precedence.
        :param _builtins.bool allow_failure: Allow this build step to fail without failing the entire build.
               If false, the entire build will fail if this step fails. Otherwise, the
               build will succeed, but this step will still have a failure status.
               Error information will be reported in the `failureDetail` field.
               `allowExitCodes` takes precedence over this field.
        :param Sequence[_builtins.str] args: A list of arguments that will be presented to the step when it is started.
               If the image used to run the step's container has an entrypoint, the args
               are used as arguments to that entrypoint. If the image does not define an
               entrypoint, the first element in args is used as the entrypoint, and the
               remainder will be used as arguments.
        :param _builtins.str dir: Working directory to use when running this step's container.
               If this value is a relative path, it is relative to the build's working
               directory. If this value is absolute, it may be outside the build's working
               directory, in which case the contents of the path may not be persisted
               across build step executions, unless a `volume` for that path is specified.
               If the build specifies a `RepoSource` with `dir` and a step with a
               `dir`,
               which specifies an absolute path, the `RepoSource` `dir` is ignored
               for the step's execution.
        :param _builtins.str entrypoint: Entrypoint to be used instead of the build step image's
               default entrypoint.
               If unset, the image's default entrypoint is used
        :param Sequence[_builtins.str] envs: A list of environment variable definitions to be used when
               running a step.
               The elements are of the form "KEY=VALUE" for the environment variable
               "KEY" being given the value "VALUE".
        :param _builtins.str id: Unique identifier for this build step, used in `wait_for` to
               reference this build step as a dependency.
        :param _builtins.str script: A shell script to be executed in the step.
               When script is provided, the user cannot specify the entrypoint or args.
        :param Sequence[_builtins.str] secret_envs: A list of environment variables which are encrypted using
               a Cloud Key
               Management Service crypto key. These values must be specified in
               the build's `Secret`.
        :param _builtins.str timeout: Time limit for executing this build step. If not defined,
               the step has no
               time limit and will be allowed to continue to run until either it
               completes or the build itself times out.
        :param _builtins.str timing: Output only. Stores timing information for executing this
               build step.
        :param Sequence['TriggerBuildStepVolumeArgs'] volumes: List of volumes to mount into the build step.
               Each volume is created as an empty volume prior to execution of the
               build step. Upon completion of the build, volumes and their contents
               are discarded.
               Using a named volume in only one step is not valid as it is
               indicative of a build request with an incorrect configuration.
               Structure is documented below.
        :param Sequence[_builtins.str] wait_fors: The ID(s) of the step(s) that this build step depends on.
               This build step will not start until all the build steps in `wait_for`
               have completed successfully. If `wait_for` is empty, this build step
               will start when all previous build steps in the `Build.Steps` list
               have completed successfully.
        """
        pulumi.set(__self__, "name", name)
        if allow_exit_codes is not None:
            pulumi.set(__self__, "allow_exit_codes", allow_exit_codes)
        if allow_failure is not None:
            pulumi.set(__self__, "allow_failure", allow_failure)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if dir is not None:
            pulumi.set(__self__, "dir", dir)
        if entrypoint is not None:
            pulumi.set(__self__, "entrypoint", entrypoint)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if secret_envs is not None:
            pulumi.set(__self__, "secret_envs", secret_envs)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if timing is not None:
            pulumi.set(__self__, "timing", timing)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if wait_fors is not None:
            pulumi.set(__self__, "wait_fors", wait_fors)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the container image that will run this particular build step.
        If the image is available in the host's Docker daemon's cache, it will be
        run directly. If not, the host will attempt to pull the image first, using
        the builder service account's credentials if necessary.
        The Docker daemon's cache will already have the latest versions of all of
        the officially supported build steps (see https://github.com/GoogleCloudPlatform/cloud-builders
        for images and examples).
        The Docker daemon will also have cached many of the layers for some popular
        images, like "ubuntu", "debian", but they will be refreshed at the time
        you attempt to use them.
        If you built an image in a previous build step, it will be stored in the
        host's Docker daemon's cache and is available to use as the name for a
        later build step.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="allowExitCodes")
    def allow_exit_codes(self) -> Optional[Sequence[_builtins.int]]:
        """
        Allow this build step to fail without failing the entire build if and
        only if the exit code is one of the specified codes.
        If `allowFailure` is also specified, this field will take precedence.
        """
        return pulumi.get(self, "allow_exit_codes")

    @_builtins.property
    @pulumi.getter(name="allowFailure")
    def allow_failure(self) -> Optional[_builtins.bool]:
        """
        Allow this build step to fail without failing the entire build.
        If false, the entire build will fail if this step fails. Otherwise, the
        build will succeed, but this step will still have a failure status.
        Error information will be reported in the `failureDetail` field.
        `allowExitCodes` takes precedence over this field.
        """
        return pulumi.get(self, "allow_failure")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of arguments that will be presented to the step when it is started.
        If the image used to run the step's container has an entrypoint, the args
        are used as arguments to that entrypoint. If the image does not define an
        entrypoint, the first element in args is used as the entrypoint, and the
        remainder will be used as arguments.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def dir(self) -> Optional[_builtins.str]:
        """
        Working directory to use when running this step's container.
        If this value is a relative path, it is relative to the build's working
        directory. If this value is absolute, it may be outside the build's working
        directory, in which case the contents of the path may not be persisted
        across build step executions, unless a `volume` for that path is specified.
        If the build specifies a `RepoSource` with `dir` and a step with a
        `dir`,
        which specifies an absolute path, the `RepoSource` `dir` is ignored
        for the step's execution.
        """
        return pulumi.get(self, "dir")

    @_builtins.property
    @pulumi.getter
    def entrypoint(self) -> Optional[_builtins.str]:
        """
        Entrypoint to be used instead of the build step image's
        default entrypoint.
        If unset, the image's default entrypoint is used
        """
        return pulumi.get(self, "entrypoint")

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of environment variable definitions to be used when
        running a step.
        The elements are of the form "KEY=VALUE" for the environment variable
        "KEY" being given the value "VALUE".
        """
        return pulumi.get(self, "envs")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Unique identifier for this build step, used in `wait_for` to
        reference this build step as a dependency.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def script(self) -> Optional[_builtins.str]:
        """
        A shell script to be executed in the step.
        When script is provided, the user cannot specify the entrypoint or args.
        """
        return pulumi.get(self, "script")

    @_builtins.property
    @pulumi.getter(name="secretEnvs")
    def secret_envs(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of environment variables which are encrypted using
        a Cloud Key
        Management Service crypto key. These values must be specified in
        the build's `Secret`.
        """
        return pulumi.get(self, "secret_envs")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.str]:
        """
        Time limit for executing this build step. If not defined,
        the step has no
        time limit and will be allowed to continue to run until either it
        completes or the build itself times out.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter
    def timing(self) -> Optional[_builtins.str]:
        """
        Output only. Stores timing information for executing this
        build step.
        """
        return pulumi.get(self, "timing")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.TriggerBuildStepVolume']]:
        """
        List of volumes to mount into the build step.
        Each volume is created as an empty volume prior to execution of the
        build step. Upon completion of the build, volumes and their contents
        are discarded.
        Using a named volume in only one step is not valid as it is
        indicative of a build request with an incorrect configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "volumes")

    @_builtins.property
    @pulumi.getter(name="waitFors")
    def wait_fors(self) -> Optional[Sequence[_builtins.str]]:
        """
        The ID(s) of the step(s) that this build step depends on.
        This build step will not start until all the build steps in `wait_for`
        have completed successfully. If `wait_for` is empty, this build step
        will start when all previous build steps in the `Build.Steps` list
        have completed successfully.
        """
        return pulumi.get(self, "wait_fors")


@pulumi.output_type
class TriggerBuildStepVolume(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 path: _builtins.str):
        """
        :param _builtins.str name: Name of the volume to mount.
               Volume names must be unique per build step and must be valid names for Docker volumes.
               Each named volume must be used by at least two build steps.
        :param _builtins.str path: Path at which to mount the volume.
               Paths must be absolute and cannot conflict with other volume paths on the same
               build step or with certain reserved volume paths.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the volume to mount.
        Volume names must be unique per build step and must be valid names for Docker volumes.
        Each named volume must be used by at least two build steps.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Path at which to mount the volume.
        Paths must be absolute and cannot conflict with other volume paths on the same
        build step or with certain reserved volume paths.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class TriggerDeveloperConnectEventConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gitRepositoryLink":
            suggest = "git_repository_link"
        elif key == "gitRepositoryLinkType":
            suggest = "git_repository_link_type"
        elif key == "pullRequest":
            suggest = "pull_request"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerDeveloperConnectEventConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerDeveloperConnectEventConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerDeveloperConnectEventConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 git_repository_link: _builtins.str,
                 git_repository_link_type: Optional[_builtins.str] = None,
                 pull_request: Optional['outputs.TriggerDeveloperConnectEventConfigPullRequest'] = None,
                 push: Optional['outputs.TriggerDeveloperConnectEventConfigPush'] = None):
        """
        :param _builtins.str git_repository_link: The Developer Connect Git repository link, formatted as `projects/*/locations/*/connections/*/gitRepositoryLink/*`.
        :param _builtins.str git_repository_link_type: (Output)
               The type of DeveloperConnect GitRepositoryLink.
        :param 'TriggerDeveloperConnectEventConfigPullRequestArgs' pull_request: Filter to match changes in pull requests.
               Structure is documented below.
        :param 'TriggerDeveloperConnectEventConfigPushArgs' push: Filter to match changes in refs like branches and tags.
               Structure is documented below.
        """
        pulumi.set(__self__, "git_repository_link", git_repository_link)
        if git_repository_link_type is not None:
            pulumi.set(__self__, "git_repository_link_type", git_repository_link_type)
        if pull_request is not None:
            pulumi.set(__self__, "pull_request", pull_request)
        if push is not None:
            pulumi.set(__self__, "push", push)

    @_builtins.property
    @pulumi.getter(name="gitRepositoryLink")
    def git_repository_link(self) -> _builtins.str:
        """
        The Developer Connect Git repository link, formatted as `projects/*/locations/*/connections/*/gitRepositoryLink/*`.
        """
        return pulumi.get(self, "git_repository_link")

    @_builtins.property
    @pulumi.getter(name="gitRepositoryLinkType")
    def git_repository_link_type(self) -> Optional[_builtins.str]:
        """
        (Output)
        The type of DeveloperConnect GitRepositoryLink.
        """
        return pulumi.get(self, "git_repository_link_type")

    @_builtins.property
    @pulumi.getter(name="pullRequest")
    def pull_request(self) -> Optional['outputs.TriggerDeveloperConnectEventConfigPullRequest']:
        """
        Filter to match changes in pull requests.
        Structure is documented below.
        """
        return pulumi.get(self, "pull_request")

    @_builtins.property
    @pulumi.getter
    def push(self) -> Optional['outputs.TriggerDeveloperConnectEventConfigPush']:
        """
        Filter to match changes in refs like branches and tags.
        Structure is documented below.
        """
        return pulumi.get(self, "push")


@pulumi.output_type
class TriggerDeveloperConnectEventConfigPullRequest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commentControl":
            suggest = "comment_control"
        elif key == "invertRegex":
            suggest = "invert_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerDeveloperConnectEventConfigPullRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerDeveloperConnectEventConfigPullRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerDeveloperConnectEventConfigPullRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[_builtins.str] = None,
                 comment_control: Optional[_builtins.str] = None,
                 invert_regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str branch: Regex of branches to match.
        :param _builtins.str comment_control: Configure builds to run whether a repository owner or collaborator need to comment `/gcbrun`.
               Possible values are: `COMMENTS_DISABLED`, `COMMENTS_ENABLED`, `COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY`.
        :param _builtins.bool invert_regex: If true, branches that do NOT match the git_ref will trigger a build.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if comment_control is not None:
            pulumi.set(__self__, "comment_control", comment_control)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> Optional[_builtins.str]:
        """
        Regex of branches to match.
        """
        return pulumi.get(self, "branch")

    @_builtins.property
    @pulumi.getter(name="commentControl")
    def comment_control(self) -> Optional[_builtins.str]:
        """
        Configure builds to run whether a repository owner or collaborator need to comment `/gcbrun`.
        Possible values are: `COMMENTS_DISABLED`, `COMMENTS_ENABLED`, `COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY`.
        """
        return pulumi.get(self, "comment_control")

    @_builtins.property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[_builtins.bool]:
        """
        If true, branches that do NOT match the git_ref will trigger a build.
        """
        return pulumi.get(self, "invert_regex")


@pulumi.output_type
class TriggerDeveloperConnectEventConfigPush(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "invertRegex":
            suggest = "invert_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerDeveloperConnectEventConfigPush. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerDeveloperConnectEventConfigPush.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerDeveloperConnectEventConfigPush.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[_builtins.str] = None,
                 invert_regex: Optional[_builtins.bool] = None,
                 tag: Optional[_builtins.str] = None):
        """
        :param _builtins.str branch: Regex of branches to match.
        :param _builtins.bool invert_regex: If true, only trigger a build if the revision regex does NOT match the git_ref regex.
        :param _builtins.str tag: Regex of tags to match.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> Optional[_builtins.str]:
        """
        Regex of branches to match.
        """
        return pulumi.get(self, "branch")

    @_builtins.property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[_builtins.bool]:
        """
        If true, only trigger a build if the revision regex does NOT match the git_ref regex.
        """
        return pulumi.get(self, "invert_regex")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[_builtins.str]:
        """
        Regex of tags to match.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class TriggerGitFileSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repoType":
            suggest = "repo_type"
        elif key == "bitbucketServerConfig":
            suggest = "bitbucket_server_config"
        elif key == "githubEnterpriseConfig":
            suggest = "github_enterprise_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerGitFileSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerGitFileSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerGitFileSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: _builtins.str,
                 repo_type: _builtins.str,
                 bitbucket_server_config: Optional[_builtins.str] = None,
                 github_enterprise_config: Optional[_builtins.str] = None,
                 repository: Optional[_builtins.str] = None,
                 revision: Optional[_builtins.str] = None,
                 uri: Optional[_builtins.str] = None):
        """
        :param _builtins.str path: The path of the file, with the repo root as the root of the path.
        :param _builtins.str repo_type: The type of the repo, since it may not be explicit from the repo field (e.g from a URL).
               Values can be UNKNOWN, CLOUD_SOURCE_REPOSITORIES, GITHUB, BITBUCKET_SERVER
               Possible values are: `UNKNOWN`, `CLOUD_SOURCE_REPOSITORIES`, `GITHUB`, `BITBUCKET_SERVER`.
        :param _builtins.str bitbucket_server_config: The full resource name of the bitbucket server config.
               Format: projects/{project}/locations/{location}/bitbucketServerConfigs/{id}.
        :param _builtins.str github_enterprise_config: The full resource name of the github enterprise config.
               Format: projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}. projects/{project}/githubEnterpriseConfigs/{id}.
        :param _builtins.str repository: The fully qualified resource name of the Repo API repository. The fully qualified resource name of the Repo API repository.
               If unspecified, the repo from which the trigger invocation originated is assumed to be the repo from which to read the specified path.
        :param _builtins.str revision: The branch, tag, arbitrary ref, or SHA version of the repo to use when resolving the
               filename (optional). This field respects the same syntax/resolution as described here: https://git-scm.com/docs/gitrevisions
               If unspecified, the revision from which the trigger invocation originated is assumed to be the revision from which to read the specified path.
        :param _builtins.str uri: The URI of the repo (optional). If unspecified, the repo from which the trigger
               invocation originated is assumed to be the repo from which to read the specified path.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "repo_type", repo_type)
        if bitbucket_server_config is not None:
            pulumi.set(__self__, "bitbucket_server_config", bitbucket_server_config)
        if github_enterprise_config is not None:
            pulumi.set(__self__, "github_enterprise_config", github_enterprise_config)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The path of the file, with the repo root as the root of the path.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="repoType")
    def repo_type(self) -> _builtins.str:
        """
        The type of the repo, since it may not be explicit from the repo field (e.g from a URL).
        Values can be UNKNOWN, CLOUD_SOURCE_REPOSITORIES, GITHUB, BITBUCKET_SERVER
        Possible values are: `UNKNOWN`, `CLOUD_SOURCE_REPOSITORIES`, `GITHUB`, `BITBUCKET_SERVER`.
        """
        return pulumi.get(self, "repo_type")

    @_builtins.property
    @pulumi.getter(name="bitbucketServerConfig")
    def bitbucket_server_config(self) -> Optional[_builtins.str]:
        """
        The full resource name of the bitbucket server config.
        Format: projects/{project}/locations/{location}/bitbucketServerConfigs/{id}.
        """
        return pulumi.get(self, "bitbucket_server_config")

    @_builtins.property
    @pulumi.getter(name="githubEnterpriseConfig")
    def github_enterprise_config(self) -> Optional[_builtins.str]:
        """
        The full resource name of the github enterprise config.
        Format: projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}. projects/{project}/githubEnterpriseConfigs/{id}.
        """
        return pulumi.get(self, "github_enterprise_config")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> Optional[_builtins.str]:
        """
        The fully qualified resource name of the Repo API repository. The fully qualified resource name of the Repo API repository.
        If unspecified, the repo from which the trigger invocation originated is assumed to be the repo from which to read the specified path.
        """
        return pulumi.get(self, "repository")

    @_builtins.property
    @pulumi.getter
    def revision(self) -> Optional[_builtins.str]:
        """
        The branch, tag, arbitrary ref, or SHA version of the repo to use when resolving the
        filename (optional). This field respects the same syntax/resolution as described here: https://git-scm.com/docs/gitrevisions
        If unspecified, the revision from which the trigger invocation originated is assumed to be the revision from which to read the specified path.
        """
        return pulumi.get(self, "revision")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[_builtins.str]:
        """
        The URI of the repo (optional). If unspecified, the repo from which the trigger
        invocation originated is assumed to be the repo from which to read the specified path.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class TriggerGithub(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enterpriseConfigResourceName":
            suggest = "enterprise_config_resource_name"
        elif key == "pullRequest":
            suggest = "pull_request"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerGithub. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerGithub.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerGithub.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enterprise_config_resource_name: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 owner: Optional[_builtins.str] = None,
                 pull_request: Optional['outputs.TriggerGithubPullRequest'] = None,
                 push: Optional['outputs.TriggerGithubPush'] = None):
        """
        :param _builtins.str enterprise_config_resource_name: The resource name of the github enterprise config that should be applied to this installation.
               For example: "projects/{$projectId}/locations/{$locationId}/githubEnterpriseConfigs/{$configId}"
        :param _builtins.str name: Name of the repository. For example: The name for
               https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".
        :param _builtins.str owner: Owner of the repository. For example: The owner for
               https://github.com/googlecloudplatform/cloud-builders is "googlecloudplatform".
        :param 'TriggerGithubPullRequestArgs' pull_request: filter to match changes in pull requests. Specify only one of `pull_request` or `push`.
               Structure is documented below.
        :param 'TriggerGithubPushArgs' push: filter to match changes in refs, like branches or tags. Specify only one of `pull_request` or `push`.
               Structure is documented below.
        """
        if enterprise_config_resource_name is not None:
            pulumi.set(__self__, "enterprise_config_resource_name", enterprise_config_resource_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if pull_request is not None:
            pulumi.set(__self__, "pull_request", pull_request)
        if push is not None:
            pulumi.set(__self__, "push", push)

    @_builtins.property
    @pulumi.getter(name="enterpriseConfigResourceName")
    def enterprise_config_resource_name(self) -> Optional[_builtins.str]:
        """
        The resource name of the github enterprise config that should be applied to this installation.
        For example: "projects/{$projectId}/locations/{$locationId}/githubEnterpriseConfigs/{$configId}"
        """
        return pulumi.get(self, "enterprise_config_resource_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the repository. For example: The name for
        https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[_builtins.str]:
        """
        Owner of the repository. For example: The owner for
        https://github.com/googlecloudplatform/cloud-builders is "googlecloudplatform".
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter(name="pullRequest")
    def pull_request(self) -> Optional['outputs.TriggerGithubPullRequest']:
        """
        filter to match changes in pull requests. Specify only one of `pull_request` or `push`.
        Structure is documented below.
        """
        return pulumi.get(self, "pull_request")

    @_builtins.property
    @pulumi.getter
    def push(self) -> Optional['outputs.TriggerGithubPush']:
        """
        filter to match changes in refs, like branches or tags. Specify only one of `pull_request` or `push`.
        Structure is documented below.
        """
        return pulumi.get(self, "push")


@pulumi.output_type
class TriggerGithubPullRequest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commentControl":
            suggest = "comment_control"
        elif key == "invertRegex":
            suggest = "invert_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerGithubPullRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerGithubPullRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerGithubPullRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: _builtins.str,
                 comment_control: Optional[_builtins.str] = None,
                 invert_regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str branch: Regex of branches to match.
        :param _builtins.str comment_control: Configure builds to run whether a repository owner or collaborator need to comment `/gcbrun`.
               Possible values are: `COMMENTS_DISABLED`, `COMMENTS_ENABLED`, `COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY`.
        :param _builtins.bool invert_regex: If true, branches that do NOT match the git_ref will trigger a build.
        """
        pulumi.set(__self__, "branch", branch)
        if comment_control is not None:
            pulumi.set(__self__, "comment_control", comment_control)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> _builtins.str:
        """
        Regex of branches to match.
        """
        return pulumi.get(self, "branch")

    @_builtins.property
    @pulumi.getter(name="commentControl")
    def comment_control(self) -> Optional[_builtins.str]:
        """
        Configure builds to run whether a repository owner or collaborator need to comment `/gcbrun`.
        Possible values are: `COMMENTS_DISABLED`, `COMMENTS_ENABLED`, `COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY`.
        """
        return pulumi.get(self, "comment_control")

    @_builtins.property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[_builtins.bool]:
        """
        If true, branches that do NOT match the git_ref will trigger a build.
        """
        return pulumi.get(self, "invert_regex")


@pulumi.output_type
class TriggerGithubPush(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "invertRegex":
            suggest = "invert_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerGithubPush. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerGithubPush.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerGithubPush.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[_builtins.str] = None,
                 invert_regex: Optional[_builtins.bool] = None,
                 tag: Optional[_builtins.str] = None):
        """
        :param _builtins.str branch: Regex of branches to match.
        :param _builtins.bool invert_regex: If true, only trigger a build if the revision regex does NOT match the git_ref regex.
        :param _builtins.str tag: Regex of tags to match.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> Optional[_builtins.str]:
        """
        Regex of branches to match.
        """
        return pulumi.get(self, "branch")

    @_builtins.property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[_builtins.bool]:
        """
        If true, only trigger a build if the revision regex does NOT match the git_ref regex.
        """
        return pulumi.get(self, "invert_regex")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[_builtins.str]:
        """
        Regex of tags to match.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class TriggerPubsubConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceAccountEmail":
            suggest = "service_account_email"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerPubsubConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerPubsubConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerPubsubConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 topic: _builtins.str,
                 service_account_email: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None,
                 subscription: Optional[_builtins.str] = None):
        """
        :param _builtins.str topic: The name of the topic from which this subscription is receiving messages.
        :param _builtins.str service_account_email: Service account that will make the push request.
        :param _builtins.str state: (Output)
               Potential issues with the underlying Pub/Sub subscription configuration.
               Only populated on get requests.
        :param _builtins.str subscription: (Output)
               Output only. Name of the subscription.
        """
        pulumi.set(__self__, "topic", topic)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subscription is not None:
            pulumi.set(__self__, "subscription", subscription)

    @_builtins.property
    @pulumi.getter
    def topic(self) -> _builtins.str:
        """
        The name of the topic from which this subscription is receiving messages.
        """
        return pulumi.get(self, "topic")

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[_builtins.str]:
        """
        Service account that will make the push request.
        """
        return pulumi.get(self, "service_account_email")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        (Output)
        Potential issues with the underlying Pub/Sub subscription configuration.
        Only populated on get requests.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def subscription(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output only. Name of the subscription.
        """
        return pulumi.get(self, "subscription")


@pulumi.output_type
class TriggerRepositoryEventConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pullRequest":
            suggest = "pull_request"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerRepositoryEventConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerRepositoryEventConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerRepositoryEventConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pull_request: Optional['outputs.TriggerRepositoryEventConfigPullRequest'] = None,
                 push: Optional['outputs.TriggerRepositoryEventConfigPush'] = None,
                 repository: Optional[_builtins.str] = None):
        """
        :param 'TriggerRepositoryEventConfigPullRequestArgs' pull_request: Contains filter properties for matching Pull Requests.
               Structure is documented below.
        :param 'TriggerRepositoryEventConfigPushArgs' push: Contains filter properties for matching git pushes.
               Structure is documented below.
        :param _builtins.str repository: The resource name of the Repo API resource.
        """
        if pull_request is not None:
            pulumi.set(__self__, "pull_request", pull_request)
        if push is not None:
            pulumi.set(__self__, "push", push)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)

    @_builtins.property
    @pulumi.getter(name="pullRequest")
    def pull_request(self) -> Optional['outputs.TriggerRepositoryEventConfigPullRequest']:
        """
        Contains filter properties for matching Pull Requests.
        Structure is documented below.
        """
        return pulumi.get(self, "pull_request")

    @_builtins.property
    @pulumi.getter
    def push(self) -> Optional['outputs.TriggerRepositoryEventConfigPush']:
        """
        Contains filter properties for matching git pushes.
        Structure is documented below.
        """
        return pulumi.get(self, "push")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> Optional[_builtins.str]:
        """
        The resource name of the Repo API resource.
        """
        return pulumi.get(self, "repository")


@pulumi.output_type
class TriggerRepositoryEventConfigPullRequest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commentControl":
            suggest = "comment_control"
        elif key == "invertRegex":
            suggest = "invert_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerRepositoryEventConfigPullRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerRepositoryEventConfigPullRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerRepositoryEventConfigPullRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[_builtins.str] = None,
                 comment_control: Optional[_builtins.str] = None,
                 invert_regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str branch: Regex of branches to match.
        :param _builtins.str comment_control: Configure builds to run whether a repository owner or collaborator need to comment `/gcbrun`.
               Possible values are: `COMMENTS_DISABLED`, `COMMENTS_ENABLED`, `COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY`.
        :param _builtins.bool invert_regex: If true, branches that do NOT match the git_ref will trigger a build.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if comment_control is not None:
            pulumi.set(__self__, "comment_control", comment_control)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> Optional[_builtins.str]:
        """
        Regex of branches to match.
        """
        return pulumi.get(self, "branch")

    @_builtins.property
    @pulumi.getter(name="commentControl")
    def comment_control(self) -> Optional[_builtins.str]:
        """
        Configure builds to run whether a repository owner or collaborator need to comment `/gcbrun`.
        Possible values are: `COMMENTS_DISABLED`, `COMMENTS_ENABLED`, `COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY`.
        """
        return pulumi.get(self, "comment_control")

    @_builtins.property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[_builtins.bool]:
        """
        If true, branches that do NOT match the git_ref will trigger a build.
        """
        return pulumi.get(self, "invert_regex")


@pulumi.output_type
class TriggerRepositoryEventConfigPush(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "invertRegex":
            suggest = "invert_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerRepositoryEventConfigPush. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerRepositoryEventConfigPush.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerRepositoryEventConfigPush.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[_builtins.str] = None,
                 invert_regex: Optional[_builtins.bool] = None,
                 tag: Optional[_builtins.str] = None):
        """
        :param _builtins.str branch: Regex of branches to match.
        :param _builtins.bool invert_regex: If true, only trigger a build if the revision regex does NOT match the git_ref regex.
        :param _builtins.str tag: Regex of tags to match.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> Optional[_builtins.str]:
        """
        Regex of branches to match.
        """
        return pulumi.get(self, "branch")

    @_builtins.property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[_builtins.bool]:
        """
        If true, only trigger a build if the revision regex does NOT match the git_ref regex.
        """
        return pulumi.get(self, "invert_regex")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[_builtins.str]:
        """
        Regex of tags to match.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class TriggerSourceToBuild(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repoType":
            suggest = "repo_type"
        elif key == "bitbucketServerConfig":
            suggest = "bitbucket_server_config"
        elif key == "githubEnterpriseConfig":
            suggest = "github_enterprise_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerSourceToBuild. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerSourceToBuild.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerSourceToBuild.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ref: _builtins.str,
                 repo_type: _builtins.str,
                 bitbucket_server_config: Optional[_builtins.str] = None,
                 github_enterprise_config: Optional[_builtins.str] = None,
                 repository: Optional[_builtins.str] = None,
                 uri: Optional[_builtins.str] = None):
        """
        :param _builtins.str ref: The branch or tag to use. Must start with "refs/" (required).
        :param _builtins.str repo_type: The type of the repo, since it may not be explicit from the repo field (e.g from a URL).
               Values can be UNKNOWN, CLOUD_SOURCE_REPOSITORIES, GITHUB, BITBUCKET_SERVER
               Possible values are: `UNKNOWN`, `CLOUD_SOURCE_REPOSITORIES`, `GITHUB`, `BITBUCKET_SERVER`.
        :param _builtins.str bitbucket_server_config: The full resource name of the bitbucket server config.
               Format: projects/{project}/locations/{location}/bitbucketServerConfigs/{id}.
        :param _builtins.str github_enterprise_config: The full resource name of the github enterprise config.
               Format: projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}. projects/{project}/githubEnterpriseConfigs/{id}.
        :param _builtins.str repository: The qualified resource name of the Repo API repository.
               Either uri or repository can be specified and is required.
        :param _builtins.str uri: The URI of the repo.
        """
        pulumi.set(__self__, "ref", ref)
        pulumi.set(__self__, "repo_type", repo_type)
        if bitbucket_server_config is not None:
            pulumi.set(__self__, "bitbucket_server_config", bitbucket_server_config)
        if github_enterprise_config is not None:
            pulumi.set(__self__, "github_enterprise_config", github_enterprise_config)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def ref(self) -> _builtins.str:
        """
        The branch or tag to use. Must start with "refs/" (required).
        """
        return pulumi.get(self, "ref")

    @_builtins.property
    @pulumi.getter(name="repoType")
    def repo_type(self) -> _builtins.str:
        """
        The type of the repo, since it may not be explicit from the repo field (e.g from a URL).
        Values can be UNKNOWN, CLOUD_SOURCE_REPOSITORIES, GITHUB, BITBUCKET_SERVER
        Possible values are: `UNKNOWN`, `CLOUD_SOURCE_REPOSITORIES`, `GITHUB`, `BITBUCKET_SERVER`.
        """
        return pulumi.get(self, "repo_type")

    @_builtins.property
    @pulumi.getter(name="bitbucketServerConfig")
    def bitbucket_server_config(self) -> Optional[_builtins.str]:
        """
        The full resource name of the bitbucket server config.
        Format: projects/{project}/locations/{location}/bitbucketServerConfigs/{id}.
        """
        return pulumi.get(self, "bitbucket_server_config")

    @_builtins.property
    @pulumi.getter(name="githubEnterpriseConfig")
    def github_enterprise_config(self) -> Optional[_builtins.str]:
        """
        The full resource name of the github enterprise config.
        Format: projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}. projects/{project}/githubEnterpriseConfigs/{id}.
        """
        return pulumi.get(self, "github_enterprise_config")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> Optional[_builtins.str]:
        """
        The qualified resource name of the Repo API repository.
        Either uri or repository can be specified and is required.
        """
        return pulumi.get(self, "repository")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[_builtins.str]:
        """
        The URI of the repo.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class TriggerTriggerTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "branchName":
            suggest = "branch_name"
        elif key == "commitSha":
            suggest = "commit_sha"
        elif key == "invertRegex":
            suggest = "invert_regex"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "repoName":
            suggest = "repo_name"
        elif key == "tagName":
            suggest = "tag_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerTriggerTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerTriggerTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerTriggerTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch_name: Optional[_builtins.str] = None,
                 commit_sha: Optional[_builtins.str] = None,
                 dir: Optional[_builtins.str] = None,
                 invert_regex: Optional[_builtins.bool] = None,
                 project_id: Optional[_builtins.str] = None,
                 repo_name: Optional[_builtins.str] = None,
                 tag_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str branch_name: Name of the branch to build. Exactly one a of branch name, tag, or commit SHA must be provided.
               This field is a regular expression.
        :param _builtins.str commit_sha: Explicit commit SHA to build. Exactly one of a branch name, tag, or commit SHA must be provided.
        :param _builtins.str dir: Directory, relative to the source root, in which to run the build.
               This must be a relative path. If a step's dir is specified and
               is an absolute path, this value is ignored for that step's
               execution.
        :param _builtins.bool invert_regex: Only trigger a build if the revision regex does NOT match the revision regex.
        :param _builtins.str project_id: ID of the project that owns the Cloud Source Repository. If
               omitted, the project ID requesting the build is assumed.
        :param _builtins.str repo_name: Name of the Cloud Source Repository. If omitted, the name "default" is assumed.
        :param _builtins.str tag_name: Name of the tag to build. Exactly one of a branch name, tag, or commit SHA must be provided.
               This field is a regular expression.
        """
        if branch_name is not None:
            pulumi.set(__self__, "branch_name", branch_name)
        if commit_sha is not None:
            pulumi.set(__self__, "commit_sha", commit_sha)
        if dir is not None:
            pulumi.set(__self__, "dir", dir)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if repo_name is not None:
            pulumi.set(__self__, "repo_name", repo_name)
        if tag_name is not None:
            pulumi.set(__self__, "tag_name", tag_name)

    @_builtins.property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> Optional[_builtins.str]:
        """
        Name of the branch to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        This field is a regular expression.
        """
        return pulumi.get(self, "branch_name")

    @_builtins.property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> Optional[_builtins.str]:
        """
        Explicit commit SHA to build. Exactly one of a branch name, tag, or commit SHA must be provided.
        """
        return pulumi.get(self, "commit_sha")

    @_builtins.property
    @pulumi.getter
    def dir(self) -> Optional[_builtins.str]:
        """
        Directory, relative to the source root, in which to run the build.
        This must be a relative path. If a step's dir is specified and
        is an absolute path, this value is ignored for that step's
        execution.
        """
        return pulumi.get(self, "dir")

    @_builtins.property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[_builtins.bool]:
        """
        Only trigger a build if the revision regex does NOT match the revision regex.
        """
        return pulumi.get(self, "invert_regex")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        ID of the project that owns the Cloud Source Repository. If
        omitted, the project ID requesting the build is assumed.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> Optional[_builtins.str]:
        """
        Name of the Cloud Source Repository. If omitted, the name "default" is assumed.
        """
        return pulumi.get(self, "repo_name")

    @_builtins.property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> Optional[_builtins.str]:
        """
        Name of the tag to build. Exactly one of a branch name, tag, or commit SHA must be provided.
        This field is a regular expression.
        """
        return pulumi.get(self, "tag_name")


@pulumi.output_type
class TriggerWebhookConfig(dict):
    def __init__(__self__, *,
                 secret: _builtins.str,
                 state: Optional[_builtins.str] = None):
        """
        :param _builtins.str secret: Resource name for the secret required as a URL parameter.
        :param _builtins.str state: (Output)
               Potential issues with the underlying Pub/Sub subscription configuration.
               Only populated on get requests.
        """
        pulumi.set(__self__, "secret", secret)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> _builtins.str:
        """
        Resource name for the secret required as a URL parameter.
        """
        return pulumi.get(self, "secret")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        (Output)
        Potential issues with the underlying Pub/Sub subscription configuration.
        Only populated on get requests.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class WorkerPoolNetworkConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "peeredNetwork":
            suggest = "peered_network"
        elif key == "peeredNetworkIpRange":
            suggest = "peered_network_ip_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkerPoolNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkerPoolNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkerPoolNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 peered_network: _builtins.str,
                 peered_network_ip_range: Optional[_builtins.str] = None):
        """
        :param _builtins.str peered_network: Immutable. The network definition that the workers are peered to. If this section is left empty, the workers will be peered to `WorkerPool.project_id` on the service producer network. Must be in the format `projects/{project}/global/networks/{network}`, where `{project}` is a project number, such as `12345`, and `{network}` is the name of a VPC network in the project. See (https://cloud.google.com/cloud-build/docs/custom-workers/set-up-custom-worker-pool-environment#understanding_the_network_configuration_options)
        :param _builtins.str peered_network_ip_range: Immutable. Subnet IP range within the peered network. This is specified in CIDR notation with a slash and the subnet prefix size. You can optionally specify an IP address before the subnet prefix value. e.g. `192.168.0.0/29` would specify an IP range starting at 192.168.0.0 with a prefix size of 29 bits. `/16` would specify a prefix size of 16 bits, with an automatically determined IP within the peered VPC. If unspecified, a value of `/24` will be used.
        """
        pulumi.set(__self__, "peered_network", peered_network)
        if peered_network_ip_range is not None:
            pulumi.set(__self__, "peered_network_ip_range", peered_network_ip_range)

    @_builtins.property
    @pulumi.getter(name="peeredNetwork")
    def peered_network(self) -> _builtins.str:
        """
        Immutable. The network definition that the workers are peered to. If this section is left empty, the workers will be peered to `WorkerPool.project_id` on the service producer network. Must be in the format `projects/{project}/global/networks/{network}`, where `{project}` is a project number, such as `12345`, and `{network}` is the name of a VPC network in the project. See (https://cloud.google.com/cloud-build/docs/custom-workers/set-up-custom-worker-pool-environment#understanding_the_network_configuration_options)
        """
        return pulumi.get(self, "peered_network")

    @_builtins.property
    @pulumi.getter(name="peeredNetworkIpRange")
    def peered_network_ip_range(self) -> Optional[_builtins.str]:
        """
        Immutable. Subnet IP range within the peered network. This is specified in CIDR notation with a slash and the subnet prefix size. You can optionally specify an IP address before the subnet prefix value. e.g. `192.168.0.0/29` would specify an IP range starting at 192.168.0.0 with a prefix size of 29 bits. `/16` would specify a prefix size of 16 bits, with an automatically determined IP within the peered VPC. If unspecified, a value of `/24` will be used.
        """
        return pulumi.get(self, "peered_network_ip_range")


@pulumi.output_type
class WorkerPoolPrivateServiceConnect(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkAttachment":
            suggest = "network_attachment"
        elif key == "routeAllTraffic":
            suggest = "route_all_traffic"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkerPoolPrivateServiceConnect. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkerPoolPrivateServiceConnect.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkerPoolPrivateServiceConnect.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_attachment: _builtins.str,
                 route_all_traffic: Optional[_builtins.bool] = None):
        """
        :param _builtins.str network_attachment: Required. Immutable. The network attachment that the worker network interface is connected to. Must be in the format `projects/{project}/regions/{region}/networkAttachments/{networkAttachment}`. The region of network attachment must be the same as the worker pool. See [Network Attachments](https://cloud.google.com/vpc/docs/about-network-attachments)
        :param _builtins.bool route_all_traffic: Immutable. Route all traffic through PSC interface. Enable this if you want full control of traffic in the private pool. Configure Cloud NAT for the subnet of network attachment if you need to access public Internet. If false, Only route private IPs, e.g. 10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16 through PSC interface.
        """
        pulumi.set(__self__, "network_attachment", network_attachment)
        if route_all_traffic is not None:
            pulumi.set(__self__, "route_all_traffic", route_all_traffic)

    @_builtins.property
    @pulumi.getter(name="networkAttachment")
    def network_attachment(self) -> _builtins.str:
        """
        Required. Immutable. The network attachment that the worker network interface is connected to. Must be in the format `projects/{project}/regions/{region}/networkAttachments/{networkAttachment}`. The region of network attachment must be the same as the worker pool. See [Network Attachments](https://cloud.google.com/vpc/docs/about-network-attachments)
        """
        return pulumi.get(self, "network_attachment")

    @_builtins.property
    @pulumi.getter(name="routeAllTraffic")
    def route_all_traffic(self) -> Optional[_builtins.bool]:
        """
        Immutable. Route all traffic through PSC interface. Enable this if you want full control of traffic in the private pool. Configure Cloud NAT for the subnet of network attachment if you need to access public Internet. If false, Only route private IPs, e.g. 10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16 through PSC interface.
        """
        return pulumi.get(self, "route_all_traffic")


@pulumi.output_type
class WorkerPoolWorkerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "enableNestedVirtualization":
            suggest = "enable_nested_virtualization"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "noExternalIp":
            suggest = "no_external_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkerPoolWorkerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkerPoolWorkerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkerPoolWorkerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_size_gb: Optional[_builtins.int] = None,
                 enable_nested_virtualization: Optional[_builtins.bool] = None,
                 machine_type: Optional[_builtins.str] = None,
                 no_external_ip: Optional[_builtins.bool] = None):
        """
        :param _builtins.int disk_size_gb: Size of the disk attached to the worker, in GB. See [diskSizeGb](https://cloud.google.com/build/docs/private-pools/private-pool-config-file-schema#disksizegb). Specify a value of up to 1000. If `0` is specified, Cloud Build will use a standard disk size.
        :param _builtins.bool enable_nested_virtualization: Enable nested virtualization on the worker, if supported by the machine type. See [Worker pool config file](https://cloud.google.com/build/docs/private-pools/worker-pool-config-file-schema). If left blank, Cloud Build will set this to false.
        :param _builtins.str machine_type: Machine type of a worker, such as `n1-standard-1`. See [machineType](https://cloud.google.com/build/docs/private-pools/private-pool-config-file-schema#machinetype). If left blank, Cloud Build will use `n1-standard-1`.
        :param _builtins.bool no_external_ip: If true, workers are created without any public address, which prevents network egress to public IPs.
        """
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if enable_nested_virtualization is not None:
            pulumi.set(__self__, "enable_nested_virtualization", enable_nested_virtualization)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if no_external_ip is not None:
            pulumi.set(__self__, "no_external_ip", no_external_ip)

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[_builtins.int]:
        """
        Size of the disk attached to the worker, in GB. See [diskSizeGb](https://cloud.google.com/build/docs/private-pools/private-pool-config-file-schema#disksizegb). Specify a value of up to 1000. If `0` is specified, Cloud Build will use a standard disk size.
        """
        return pulumi.get(self, "disk_size_gb")

    @_builtins.property
    @pulumi.getter(name="enableNestedVirtualization")
    def enable_nested_virtualization(self) -> Optional[_builtins.bool]:
        """
        Enable nested virtualization on the worker, if supported by the machine type. See [Worker pool config file](https://cloud.google.com/build/docs/private-pools/worker-pool-config-file-schema). If left blank, Cloud Build will set this to false.
        """
        return pulumi.get(self, "enable_nested_virtualization")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[_builtins.str]:
        """
        Machine type of a worker, such as `n1-standard-1`. See [machineType](https://cloud.google.com/build/docs/private-pools/private-pool-config-file-schema#machinetype). If left blank, Cloud Build will use `n1-standard-1`.
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter(name="noExternalIp")
    def no_external_ip(self) -> Optional[_builtins.bool]:
        """
        If true, workers are created without any public address, which prevents network egress to public IPs.
        """
        return pulumi.get(self, "no_external_ip")


@pulumi.output_type
class GetTriggerApprovalConfigResult(dict):
    def __init__(__self__, *,
                 approval_required: _builtins.bool):
        """
        :param _builtins.bool approval_required: Whether or not approval is needed. If this is set on a build, it will become pending when run,
               and will need to be explicitly approved to start.
        """
        pulumi.set(__self__, "approval_required", approval_required)

    @_builtins.property
    @pulumi.getter(name="approvalRequired")
    def approval_required(self) -> _builtins.bool:
        """
        Whether or not approval is needed. If this is set on a build, it will become pending when run,
        and will need to be explicitly approved to start.
        """
        return pulumi.get(self, "approval_required")


@pulumi.output_type
class GetTriggerBitbucketServerTriggerConfigResult(dict):
    def __init__(__self__, *,
                 bitbucket_server_config_resource: _builtins.str,
                 project_key: _builtins.str,
                 pull_requests: Sequence['outputs.GetTriggerBitbucketServerTriggerConfigPullRequestResult'],
                 pushes: Sequence['outputs.GetTriggerBitbucketServerTriggerConfigPushResult'],
                 repo_slug: _builtins.str):
        """
        :param _builtins.str bitbucket_server_config_resource: The Bitbucket server config resource that this trigger config maps to.
        :param _builtins.str project_key: Key of the project that the repo is in. For example: The key for https://mybitbucket.server/projects/TEST/repos/test-repo is "TEST".
        :param Sequence['GetTriggerBitbucketServerTriggerConfigPullRequestArgs'] pull_requests: Filter to match changes in pull requests.
        :param Sequence['GetTriggerBitbucketServerTriggerConfigPushArgs'] pushes: Filter to match changes in refs like branches, tags.
        :param _builtins.str repo_slug: Slug of the repository. A repository slug is a URL-friendly version of a repository name, automatically generated by Bitbucket for use in the URL.
               For example, if the repository name is 'test repo', in the URL it would become 'test-repo' as in https://mybitbucket.server/projects/TEST/repos/test-repo.
        """
        pulumi.set(__self__, "bitbucket_server_config_resource", bitbucket_server_config_resource)
        pulumi.set(__self__, "project_key", project_key)
        pulumi.set(__self__, "pull_requests", pull_requests)
        pulumi.set(__self__, "pushes", pushes)
        pulumi.set(__self__, "repo_slug", repo_slug)

    @_builtins.property
    @pulumi.getter(name="bitbucketServerConfigResource")
    def bitbucket_server_config_resource(self) -> _builtins.str:
        """
        The Bitbucket server config resource that this trigger config maps to.
        """
        return pulumi.get(self, "bitbucket_server_config_resource")

    @_builtins.property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> _builtins.str:
        """
        Key of the project that the repo is in. For example: The key for https://mybitbucket.server/projects/TEST/repos/test-repo is "TEST".
        """
        return pulumi.get(self, "project_key")

    @_builtins.property
    @pulumi.getter(name="pullRequests")
    def pull_requests(self) -> Sequence['outputs.GetTriggerBitbucketServerTriggerConfigPullRequestResult']:
        """
        Filter to match changes in pull requests.
        """
        return pulumi.get(self, "pull_requests")

    @_builtins.property
    @pulumi.getter
    def pushes(self) -> Sequence['outputs.GetTriggerBitbucketServerTriggerConfigPushResult']:
        """
        Filter to match changes in refs like branches, tags.
        """
        return pulumi.get(self, "pushes")

    @_builtins.property
    @pulumi.getter(name="repoSlug")
    def repo_slug(self) -> _builtins.str:
        """
        Slug of the repository. A repository slug is a URL-friendly version of a repository name, automatically generated by Bitbucket for use in the URL.
        For example, if the repository name is 'test repo', in the URL it would become 'test-repo' as in https://mybitbucket.server/projects/TEST/repos/test-repo.
        """
        return pulumi.get(self, "repo_slug")


@pulumi.output_type
class GetTriggerBitbucketServerTriggerConfigPullRequestResult(dict):
    def __init__(__self__, *,
                 branch: _builtins.str,
                 comment_control: _builtins.str,
                 invert_regex: _builtins.bool):
        """
        :param _builtins.str branch: Regex of branches to match.
               The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        :param _builtins.str comment_control: Configure builds to run whether a repository owner or collaborator need to comment /gcbrun. Possible values: ["COMMENTS_DISABLED", "COMMENTS_ENABLED", "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY"]
        :param _builtins.bool invert_regex: If true, branches that do NOT match the git_ref will trigger a build.
        """
        pulumi.set(__self__, "branch", branch)
        pulumi.set(__self__, "comment_control", comment_control)
        pulumi.set(__self__, "invert_regex", invert_regex)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> _builtins.str:
        """
        Regex of branches to match.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "branch")

    @_builtins.property
    @pulumi.getter(name="commentControl")
    def comment_control(self) -> _builtins.str:
        """
        Configure builds to run whether a repository owner or collaborator need to comment /gcbrun. Possible values: ["COMMENTS_DISABLED", "COMMENTS_ENABLED", "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY"]
        """
        return pulumi.get(self, "comment_control")

    @_builtins.property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> _builtins.bool:
        """
        If true, branches that do NOT match the git_ref will trigger a build.
        """
        return pulumi.get(self, "invert_regex")


@pulumi.output_type
class GetTriggerBitbucketServerTriggerConfigPushResult(dict):
    def __init__(__self__, *,
                 branch: _builtins.str,
                 invert_regex: _builtins.bool,
                 tag: _builtins.str):
        """
        :param _builtins.str branch: Regex of branches to match.  Specify only one of branch or tag.
        :param _builtins.bool invert_regex: When true, only trigger a build if the revision regex does NOT match the gitRef regex.
        :param _builtins.str tag: Regex of tags to match.  Specify only one of branch or tag.
        """
        pulumi.set(__self__, "branch", branch)
        pulumi.set(__self__, "invert_regex", invert_regex)
        pulumi.set(__self__, "tag", tag)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> _builtins.str:
        """
        Regex of branches to match.  Specify only one of branch or tag.
        """
        return pulumi.get(self, "branch")

    @_builtins.property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> _builtins.bool:
        """
        When true, only trigger a build if the revision regex does NOT match the gitRef regex.
        """
        return pulumi.get(self, "invert_regex")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> _builtins.str:
        """
        Regex of tags to match.  Specify only one of branch or tag.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class GetTriggerBuildResult(dict):
    def __init__(__self__, *,
                 artifacts: Sequence['outputs.GetTriggerBuildArtifactResult'],
                 available_secrets: Sequence['outputs.GetTriggerBuildAvailableSecretResult'],
                 images: Sequence[_builtins.str],
                 logs_bucket: _builtins.str,
                 options: Sequence['outputs.GetTriggerBuildOptionResult'],
                 queue_ttl: _builtins.str,
                 secrets: Sequence['outputs.GetTriggerBuildSecretResult'],
                 sources: Sequence['outputs.GetTriggerBuildSourceResult'],
                 steps: Sequence['outputs.GetTriggerBuildStepResult'],
                 substitutions: Mapping[str, _builtins.str],
                 tags: Sequence[_builtins.str],
                 timeout: _builtins.str):
        """
        :param Sequence['GetTriggerBuildArtifactArgs'] artifacts: Artifacts produced by the build that should be uploaded upon successful completion of all build steps.
        :param Sequence['GetTriggerBuildAvailableSecretArgs'] available_secrets: Secrets and secret environment variables.
        :param Sequence[_builtins.str] images: A list of images to be pushed upon the successful completion of all build steps.
               The images are pushed using the builder service account's credentials.
               The digests of the pushed images will be stored in the Build resource's results field.
               If any of the images fail to be pushed, the build status is marked FAILURE.
        :param _builtins.str logs_bucket: Google Cloud Storage bucket where logs should be written.
               Logs file names will be of the format ${logsBucket}/log-${build_id}.txt.
        :param Sequence['GetTriggerBuildOptionArgs'] options: Special options for this build.
        :param _builtins.str queue_ttl: TTL in queue for this build. If provided and the build is enqueued longer than this value,
               the build will expire and the build status will be EXPIRED.
               The TTL starts ticking from createTime.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param Sequence['GetTriggerBuildSecretArgs'] secrets: Secrets to decrypt using Cloud Key Management Service.
        :param Sequence['GetTriggerBuildSourceArgs'] sources: The location of the source files to build.
               
               One of 'storageSource' or 'repoSource' must be provided.
        :param Sequence['GetTriggerBuildStepArgs'] steps: The operations to be performed on the workspace.
        :param Mapping[str, _builtins.str] substitutions: Substitutions data for Build resource.
        :param Sequence[_builtins.str] tags: Tags for annotation of a Build. These are not docker tags.
        :param _builtins.str timeout: Amount of time that this build should be allowed to run, to second granularity.
               If this amount of time elapses, work on the build will cease and the build status will be TIMEOUT.
               This timeout must be equal to or greater than the sum of the timeouts for build steps within the build.
               The expected format is the number of seconds followed by s.
               Default time is ten minutes (600s).
        """
        pulumi.set(__self__, "artifacts", artifacts)
        pulumi.set(__self__, "available_secrets", available_secrets)
        pulumi.set(__self__, "images", images)
        pulumi.set(__self__, "logs_bucket", logs_bucket)
        pulumi.set(__self__, "options", options)
        pulumi.set(__self__, "queue_ttl", queue_ttl)
        pulumi.set(__self__, "secrets", secrets)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "steps", steps)
        pulumi.set(__self__, "substitutions", substitutions)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def artifacts(self) -> Sequence['outputs.GetTriggerBuildArtifactResult']:
        """
        Artifacts produced by the build that should be uploaded upon successful completion of all build steps.
        """
        return pulumi.get(self, "artifacts")

    @_builtins.property
    @pulumi.getter(name="availableSecrets")
    def available_secrets(self) -> Sequence['outputs.GetTriggerBuildAvailableSecretResult']:
        """
        Secrets and secret environment variables.
        """
        return pulumi.get(self, "available_secrets")

    @_builtins.property
    @pulumi.getter
    def images(self) -> Sequence[_builtins.str]:
        """
        A list of images to be pushed upon the successful completion of all build steps.
        The images are pushed using the builder service account's credentials.
        The digests of the pushed images will be stored in the Build resource's results field.
        If any of the images fail to be pushed, the build status is marked FAILURE.
        """
        return pulumi.get(self, "images")

    @_builtins.property
    @pulumi.getter(name="logsBucket")
    def logs_bucket(self) -> _builtins.str:
        """
        Google Cloud Storage bucket where logs should be written.
        Logs file names will be of the format ${logsBucket}/log-${build_id}.txt.
        """
        return pulumi.get(self, "logs_bucket")

    @_builtins.property
    @pulumi.getter
    def options(self) -> Sequence['outputs.GetTriggerBuildOptionResult']:
        """
        Special options for this build.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter(name="queueTtl")
    def queue_ttl(self) -> _builtins.str:
        """
        TTL in queue for this build. If provided and the build is enqueued longer than this value,
        the build will expire and the build status will be EXPIRED.
        The TTL starts ticking from createTime.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "queue_ttl")

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Sequence['outputs.GetTriggerBuildSecretResult']:
        """
        Secrets to decrypt using Cloud Key Management Service.
        """
        return pulumi.get(self, "secrets")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetTriggerBuildSourceResult']:
        """
        The location of the source files to build.

        One of 'storageSource' or 'repoSource' must be provided.
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def steps(self) -> Sequence['outputs.GetTriggerBuildStepResult']:
        """
        The operations to be performed on the workspace.
        """
        return pulumi.get(self, "steps")

    @_builtins.property
    @pulumi.getter
    def substitutions(self) -> Mapping[str, _builtins.str]:
        """
        Substitutions data for Build resource.
        """
        return pulumi.get(self, "substitutions")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Tags for annotation of a Build. These are not docker tags.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> _builtins.str:
        """
        Amount of time that this build should be allowed to run, to second granularity.
        If this amount of time elapses, work on the build will cease and the build status will be TIMEOUT.
        This timeout must be equal to or greater than the sum of the timeouts for build steps within the build.
        The expected format is the number of seconds followed by s.
        Default time is ten minutes (600s).
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class GetTriggerBuildArtifactResult(dict):
    def __init__(__self__, *,
                 images: Sequence[_builtins.str],
                 maven_artifacts: Sequence['outputs.GetTriggerBuildArtifactMavenArtifactResult'],
                 npm_packages: Sequence['outputs.GetTriggerBuildArtifactNpmPackageResult'],
                 objects: Sequence['outputs.GetTriggerBuildArtifactObjectResult'],
                 python_packages: Sequence['outputs.GetTriggerBuildArtifactPythonPackageResult']):
        """
        :param Sequence[_builtins.str] images: A list of images to be pushed upon the successful completion of all build steps.
               
               The images will be pushed using the builder service account's credentials.
               
               The digests of the pushed images will be stored in the Build resource's results field.
               
               If any of the images fail to be pushed, the build is marked FAILURE.
        :param Sequence['GetTriggerBuildArtifactMavenArtifactArgs'] maven_artifacts: A Maven artifact to upload to Artifact Registry upon successful completion of all build steps.
               
               The location and generation of the uploaded objects will be stored in the Build resource's results field.
               
               If any objects fail to be pushed, the build is marked FAILURE.
        :param Sequence['GetTriggerBuildArtifactNpmPackageArgs'] npm_packages: Npm package to upload to Artifact Registry upon successful completion of all build steps.
               
               The location and generation of the uploaded objects will be stored in the Build resource's results field.
               
               If any objects fail to be pushed, the build is marked FAILURE.
        :param Sequence['GetTriggerBuildArtifactObjectArgs'] objects: A list of objects to be uploaded to Cloud Storage upon successful completion of all build steps.
               
               Files in the workspace matching specified paths globs will be uploaded to the
               Cloud Storage location using the builder service account's credentials.
               
               The location and generation of the uploaded objects will be stored in the Build resource's results field.
               
               If any objects fail to be pushed, the build is marked FAILURE.
        :param Sequence['GetTriggerBuildArtifactPythonPackageArgs'] python_packages: Python package to upload to Artifact Registry upon successful completion of all build steps. A package can encapsulate multiple objects to be uploaded to a single repository.
               
               The location and generation of the uploaded objects will be stored in the Build resource's results field.
               
               If any objects fail to be pushed, the build is marked FAILURE.
        """
        pulumi.set(__self__, "images", images)
        pulumi.set(__self__, "maven_artifacts", maven_artifacts)
        pulumi.set(__self__, "npm_packages", npm_packages)
        pulumi.set(__self__, "objects", objects)
        pulumi.set(__self__, "python_packages", python_packages)

    @_builtins.property
    @pulumi.getter
    def images(self) -> Sequence[_builtins.str]:
        """
        A list of images to be pushed upon the successful completion of all build steps.

        The images will be pushed using the builder service account's credentials.

        The digests of the pushed images will be stored in the Build resource's results field.

        If any of the images fail to be pushed, the build is marked FAILURE.
        """
        return pulumi.get(self, "images")

    @_builtins.property
    @pulumi.getter(name="mavenArtifacts")
    def maven_artifacts(self) -> Sequence['outputs.GetTriggerBuildArtifactMavenArtifactResult']:
        """
        A Maven artifact to upload to Artifact Registry upon successful completion of all build steps.

        The location and generation of the uploaded objects will be stored in the Build resource's results field.

        If any objects fail to be pushed, the build is marked FAILURE.
        """
        return pulumi.get(self, "maven_artifacts")

    @_builtins.property
    @pulumi.getter(name="npmPackages")
    def npm_packages(self) -> Sequence['outputs.GetTriggerBuildArtifactNpmPackageResult']:
        """
        Npm package to upload to Artifact Registry upon successful completion of all build steps.

        The location and generation of the uploaded objects will be stored in the Build resource's results field.

        If any objects fail to be pushed, the build is marked FAILURE.
        """
        return pulumi.get(self, "npm_packages")

    @_builtins.property
    @pulumi.getter
    def objects(self) -> Sequence['outputs.GetTriggerBuildArtifactObjectResult']:
        """
        A list of objects to be uploaded to Cloud Storage upon successful completion of all build steps.

        Files in the workspace matching specified paths globs will be uploaded to the
        Cloud Storage location using the builder service account's credentials.

        The location and generation of the uploaded objects will be stored in the Build resource's results field.

        If any objects fail to be pushed, the build is marked FAILURE.
        """
        return pulumi.get(self, "objects")

    @_builtins.property
    @pulumi.getter(name="pythonPackages")
    def python_packages(self) -> Sequence['outputs.GetTriggerBuildArtifactPythonPackageResult']:
        """
        Python package to upload to Artifact Registry upon successful completion of all build steps. A package can encapsulate multiple objects to be uploaded to a single repository.

        The location and generation of the uploaded objects will be stored in the Build resource's results field.

        If any objects fail to be pushed, the build is marked FAILURE.
        """
        return pulumi.get(self, "python_packages")


@pulumi.output_type
class GetTriggerBuildArtifactMavenArtifactResult(dict):
    def __init__(__self__, *,
                 artifact_id: _builtins.str,
                 group_id: _builtins.str,
                 path: _builtins.str,
                 repository: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str artifact_id: Maven artifactId value used when uploading the artifact to Artifact Registry.
        :param _builtins.str group_id: Maven groupId value used when uploading the artifact to Artifact Registry.
        :param _builtins.str path: Path to an artifact in the build's workspace to be uploaded to Artifact Registry. This can be either an absolute path, e.g. /workspace/my-app/target/my-app-1.0.SNAPSHOT.jar or a relative path from /workspace, e.g. my-app/target/my-app-1.0.SNAPSHOT.jar.
        :param _builtins.str repository: Artifact Registry repository, in the form "https://$REGION-maven.pkg.dev/$PROJECT/$REPOSITORY"
               
               Artifact in the workspace specified by path will be uploaded to Artifact Registry with this location as a prefix.
        :param _builtins.str version: Maven version value used when uploading the artifact to Artifact Registry.
        """
        pulumi.set(__self__, "artifact_id", artifact_id)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "repository", repository)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> _builtins.str:
        """
        Maven artifactId value used when uploading the artifact to Artifact Registry.
        """
        return pulumi.get(self, "artifact_id")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> _builtins.str:
        """
        Maven groupId value used when uploading the artifact to Artifact Registry.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Path to an artifact in the build's workspace to be uploaded to Artifact Registry. This can be either an absolute path, e.g. /workspace/my-app/target/my-app-1.0.SNAPSHOT.jar or a relative path from /workspace, e.g. my-app/target/my-app-1.0.SNAPSHOT.jar.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> _builtins.str:
        """
        Artifact Registry repository, in the form "https://$REGION-maven.pkg.dev/$PROJECT/$REPOSITORY"

        Artifact in the workspace specified by path will be uploaded to Artifact Registry with this location as a prefix.
        """
        return pulumi.get(self, "repository")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Maven version value used when uploading the artifact to Artifact Registry.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetTriggerBuildArtifactNpmPackageResult(dict):
    def __init__(__self__, *,
                 package_path: _builtins.str,
                 repository: _builtins.str):
        """
        :param _builtins.str package_path: Path to the package.json. e.g. workspace/path/to/package
        :param _builtins.str repository: Artifact Registry repository, in the form "https://$REGION-npm.pkg.dev/$PROJECT/$REPOSITORY"
               
               Npm package in the workspace specified by path will be zipped and uploaded to Artifact Registry with this location as a prefix.
        """
        pulumi.set(__self__, "package_path", package_path)
        pulumi.set(__self__, "repository", repository)

    @_builtins.property
    @pulumi.getter(name="packagePath")
    def package_path(self) -> _builtins.str:
        """
        Path to the package.json. e.g. workspace/path/to/package
        """
        return pulumi.get(self, "package_path")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> _builtins.str:
        """
        Artifact Registry repository, in the form "https://$REGION-npm.pkg.dev/$PROJECT/$REPOSITORY"

        Npm package in the workspace specified by path will be zipped and uploaded to Artifact Registry with this location as a prefix.
        """
        return pulumi.get(self, "repository")


@pulumi.output_type
class GetTriggerBuildArtifactObjectResult(dict):
    def __init__(__self__, *,
                 location: _builtins.str,
                 paths: Sequence[_builtins.str],
                 timings: Sequence['outputs.GetTriggerBuildArtifactObjectTimingResult']):
        """
        :param _builtins.str location: The Cloud Build location for the trigger.
               
               - - -
        :param Sequence[_builtins.str] paths: Path globs used to match files in the build's workspace.
        :param Sequence['GetTriggerBuildArtifactObjectTimingArgs'] timings: Output only. Stores timing information for pushing all artifact objects.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "paths", paths)
        pulumi.set(__self__, "timings", timings)

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Cloud Build location for the trigger.

        - - -
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def paths(self) -> Sequence[_builtins.str]:
        """
        Path globs used to match files in the build's workspace.
        """
        return pulumi.get(self, "paths")

    @_builtins.property
    @pulumi.getter
    def timings(self) -> Sequence['outputs.GetTriggerBuildArtifactObjectTimingResult']:
        """
        Output only. Stores timing information for pushing all artifact objects.
        """
        return pulumi.get(self, "timings")


@pulumi.output_type
class GetTriggerBuildArtifactObjectTimingResult(dict):
    def __init__(__self__, *,
                 end_time: _builtins.str,
                 start_time: _builtins.str):
        """
        :param _builtins.str end_time: End of time span.
               
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to
               nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param _builtins.str start_time: Start of time span.
               
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to
               nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> _builtins.str:
        """
        End of time span.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to
        nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.str:
        """
        Start of time span.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to
        nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class GetTriggerBuildArtifactPythonPackageResult(dict):
    def __init__(__self__, *,
                 paths: Sequence[_builtins.str],
                 repository: _builtins.str):
        """
        :param Sequence[_builtins.str] paths: Path globs used to match files in the build's workspace. For Python/ Twine, this is usually dist/*, and sometimes additionally an .asc file.
        :param _builtins.str repository: Artifact Registry repository, in the form "https://$REGION-python.pkg.dev/$PROJECT/$REPOSITORY"
               
               Files in the workspace matching any path pattern will be uploaded to Artifact Registry with this location as a prefix.
        """
        pulumi.set(__self__, "paths", paths)
        pulumi.set(__self__, "repository", repository)

    @_builtins.property
    @pulumi.getter
    def paths(self) -> Sequence[_builtins.str]:
        """
        Path globs used to match files in the build's workspace. For Python/ Twine, this is usually dist/*, and sometimes additionally an .asc file.
        """
        return pulumi.get(self, "paths")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> _builtins.str:
        """
        Artifact Registry repository, in the form "https://$REGION-python.pkg.dev/$PROJECT/$REPOSITORY"

        Files in the workspace matching any path pattern will be uploaded to Artifact Registry with this location as a prefix.
        """
        return pulumi.get(self, "repository")


@pulumi.output_type
class GetTriggerBuildAvailableSecretResult(dict):
    def __init__(__self__, *,
                 secret_managers: Sequence['outputs.GetTriggerBuildAvailableSecretSecretManagerResult']):
        """
        :param Sequence['GetTriggerBuildAvailableSecretSecretManagerArgs'] secret_managers: Pairs a secret environment variable with a SecretVersion in Secret Manager.
        """
        pulumi.set(__self__, "secret_managers", secret_managers)

    @_builtins.property
    @pulumi.getter(name="secretManagers")
    def secret_managers(self) -> Sequence['outputs.GetTriggerBuildAvailableSecretSecretManagerResult']:
        """
        Pairs a secret environment variable with a SecretVersion in Secret Manager.
        """
        return pulumi.get(self, "secret_managers")


@pulumi.output_type
class GetTriggerBuildAvailableSecretSecretManagerResult(dict):
    def __init__(__self__, *,
                 env: _builtins.str,
                 version_name: _builtins.str):
        """
        :param _builtins.str env: Environment variable name to associate with the secret. Secret environment
               variables must be unique across all of a build's secrets, and must be used
               by at least one build step.
        :param _builtins.str version_name: Resource name of the SecretVersion. In format: projects/*/secrets/*/versions/*
        """
        pulumi.set(__self__, "env", env)
        pulumi.set(__self__, "version_name", version_name)

    @_builtins.property
    @pulumi.getter
    def env(self) -> _builtins.str:
        """
        Environment variable name to associate with the secret. Secret environment
        variables must be unique across all of a build's secrets, and must be used
        by at least one build step.
        """
        return pulumi.get(self, "env")

    @_builtins.property
    @pulumi.getter(name="versionName")
    def version_name(self) -> _builtins.str:
        """
        Resource name of the SecretVersion. In format: projects/*/secrets/*/versions/*
        """
        return pulumi.get(self, "version_name")


@pulumi.output_type
class GetTriggerBuildOptionResult(dict):
    def __init__(__self__, *,
                 disk_size_gb: _builtins.int,
                 dynamic_substitutions: _builtins.bool,
                 envs: Sequence[_builtins.str],
                 log_streaming_option: _builtins.str,
                 logging: _builtins.str,
                 machine_type: _builtins.str,
                 requested_verify_option: _builtins.str,
                 secret_envs: Sequence[_builtins.str],
                 source_provenance_hashes: Sequence[_builtins.str],
                 substitution_option: _builtins.str,
                 volumes: Sequence['outputs.GetTriggerBuildOptionVolumeResult'],
                 worker_pool: _builtins.str):
        """
        :param _builtins.int disk_size_gb: Requested disk size for the VM that runs the build. Note that this is NOT "disk free";
               some of the space will be used by the operating system and build utilities.
               Also note that this is the minimum disk size that will be allocated for the build --
               the build may run with a larger disk than requested. At present, the maximum disk size
               is 1000GB; builds that request more than the maximum are rejected with an error.
        :param _builtins.bool dynamic_substitutions: Option to specify whether or not to apply bash style string operations to the substitutions.
               
               NOTE this is always enabled for triggered builds and cannot be overridden in the build configuration file.
        :param Sequence[_builtins.str] envs: A list of global environment variable definitions that will exist for all build steps
               in this build. If a variable is defined in both globally and in a build step,
               the variable will use the build step value.
               
               The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        :param _builtins.str log_streaming_option: Option to define build log streaming behavior to Google Cloud Storage. Possible values: ["STREAM_DEFAULT", "STREAM_ON", "STREAM_OFF"]
        :param _builtins.str logging: Option to specify the logging mode, which determines if and where build logs are stored. Possible values: ["LOGGING_UNSPECIFIED", "LEGACY", "GCS_ONLY", "STACKDRIVER_ONLY", "CLOUD_LOGGING_ONLY", "NONE"]
        :param _builtins.str machine_type: Compute Engine machine type on which to run the build.
        :param _builtins.str requested_verify_option: Requested verifiability options. Possible values: ["NOT_VERIFIED", "VERIFIED"]
        :param Sequence[_builtins.str] secret_envs: A list of global environment variables, which are encrypted using a Cloud Key Management
               Service crypto key. These values must be specified in the build's Secret. These variables
               will be available to all build steps in this build.
        :param Sequence[_builtins.str] source_provenance_hashes: Requested hash for SourceProvenance. Possible values: ["NONE", "SHA256", "MD5"]
        :param _builtins.str substitution_option: Option to specify behavior when there is an error in the substitution checks.
               
               NOTE this is always set to ALLOW_LOOSE for triggered builds and cannot be overridden
               in the build configuration file. Possible values: ["MUST_MATCH", "ALLOW_LOOSE"]
        :param Sequence['GetTriggerBuildOptionVolumeArgs'] volumes: Global list of volumes to mount for ALL build steps
               
               Each volume is created as an empty volume prior to starting the build process.
               Upon completion of the build, volumes and their contents are discarded. Global
               volume names and paths cannot conflict with the volumes defined a build step.
               
               Using a global volume in a build with only one step is not valid as it is indicative
               of a build request with an incorrect configuration.
        :param _builtins.str worker_pool: Option to specify a WorkerPool for the build. Format projects/{project}/workerPools/{workerPool}
               
               This field is experimental.
        """
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "dynamic_substitutions", dynamic_substitutions)
        pulumi.set(__self__, "envs", envs)
        pulumi.set(__self__, "log_streaming_option", log_streaming_option)
        pulumi.set(__self__, "logging", logging)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "requested_verify_option", requested_verify_option)
        pulumi.set(__self__, "secret_envs", secret_envs)
        pulumi.set(__self__, "source_provenance_hashes", source_provenance_hashes)
        pulumi.set(__self__, "substitution_option", substitution_option)
        pulumi.set(__self__, "volumes", volumes)
        pulumi.set(__self__, "worker_pool", worker_pool)

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> _builtins.int:
        """
        Requested disk size for the VM that runs the build. Note that this is NOT "disk free";
        some of the space will be used by the operating system and build utilities.
        Also note that this is the minimum disk size that will be allocated for the build --
        the build may run with a larger disk than requested. At present, the maximum disk size
        is 1000GB; builds that request more than the maximum are rejected with an error.
        """
        return pulumi.get(self, "disk_size_gb")

    @_builtins.property
    @pulumi.getter(name="dynamicSubstitutions")
    def dynamic_substitutions(self) -> _builtins.bool:
        """
        Option to specify whether or not to apply bash style string operations to the substitutions.

        NOTE this is always enabled for triggered builds and cannot be overridden in the build configuration file.
        """
        return pulumi.get(self, "dynamic_substitutions")

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Sequence[_builtins.str]:
        """
        A list of global environment variable definitions that will exist for all build steps
        in this build. If a variable is defined in both globally and in a build step,
        the variable will use the build step value.

        The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        """
        return pulumi.get(self, "envs")

    @_builtins.property
    @pulumi.getter(name="logStreamingOption")
    def log_streaming_option(self) -> _builtins.str:
        """
        Option to define build log streaming behavior to Google Cloud Storage. Possible values: ["STREAM_DEFAULT", "STREAM_ON", "STREAM_OFF"]
        """
        return pulumi.get(self, "log_streaming_option")

    @_builtins.property
    @pulumi.getter
    def logging(self) -> _builtins.str:
        """
        Option to specify the logging mode, which determines if and where build logs are stored. Possible values: ["LOGGING_UNSPECIFIED", "LEGACY", "GCS_ONLY", "STACKDRIVER_ONLY", "CLOUD_LOGGING_ONLY", "NONE"]
        """
        return pulumi.get(self, "logging")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> _builtins.str:
        """
        Compute Engine machine type on which to run the build.
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter(name="requestedVerifyOption")
    def requested_verify_option(self) -> _builtins.str:
        """
        Requested verifiability options. Possible values: ["NOT_VERIFIED", "VERIFIED"]
        """
        return pulumi.get(self, "requested_verify_option")

    @_builtins.property
    @pulumi.getter(name="secretEnvs")
    def secret_envs(self) -> Sequence[_builtins.str]:
        """
        A list of global environment variables, which are encrypted using a Cloud Key Management
        Service crypto key. These values must be specified in the build's Secret. These variables
        will be available to all build steps in this build.
        """
        return pulumi.get(self, "secret_envs")

    @_builtins.property
    @pulumi.getter(name="sourceProvenanceHashes")
    def source_provenance_hashes(self) -> Sequence[_builtins.str]:
        """
        Requested hash for SourceProvenance. Possible values: ["NONE", "SHA256", "MD5"]
        """
        return pulumi.get(self, "source_provenance_hashes")

    @_builtins.property
    @pulumi.getter(name="substitutionOption")
    def substitution_option(self) -> _builtins.str:
        """
        Option to specify behavior when there is an error in the substitution checks.

        NOTE this is always set to ALLOW_LOOSE for triggered builds and cannot be overridden
        in the build configuration file. Possible values: ["MUST_MATCH", "ALLOW_LOOSE"]
        """
        return pulumi.get(self, "substitution_option")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.GetTriggerBuildOptionVolumeResult']:
        """
        Global list of volumes to mount for ALL build steps

        Each volume is created as an empty volume prior to starting the build process.
        Upon completion of the build, volumes and their contents are discarded. Global
        volume names and paths cannot conflict with the volumes defined a build step.

        Using a global volume in a build with only one step is not valid as it is indicative
        of a build request with an incorrect configuration.
        """
        return pulumi.get(self, "volumes")

    @_builtins.property
    @pulumi.getter(name="workerPool")
    def worker_pool(self) -> _builtins.str:
        """
        Option to specify a WorkerPool for the build. Format projects/{project}/workerPools/{workerPool}

        This field is experimental.
        """
        return pulumi.get(self, "worker_pool")


@pulumi.output_type
class GetTriggerBuildOptionVolumeResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 path: _builtins.str):
        """
        :param _builtins.str name: Name of the volume to mount.
               
               Volume names must be unique per build step and must be valid names for Docker volumes.
               Each named volume must be used by at least two build steps.
        :param _builtins.str path: Path at which to mount the volume.
               
               Paths must be absolute and cannot conflict with other volume paths on the same
               build step or with certain reserved volume paths.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the volume to mount.

        Volume names must be unique per build step and must be valid names for Docker volumes.
        Each named volume must be used by at least two build steps.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Path at which to mount the volume.

        Paths must be absolute and cannot conflict with other volume paths on the same
        build step or with certain reserved volume paths.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class GetTriggerBuildSecretResult(dict):
    def __init__(__self__, *,
                 kms_key_name: _builtins.str,
                 secret_env: Mapping[str, _builtins.str]):
        """
        :param _builtins.str kms_key_name: Cloud KMS key name to use to decrypt these envs.
        :param Mapping[str, _builtins.str] secret_env: Map of environment variable name to its encrypted value.
               Secret environment variables must be unique across all of a build's secrets,
               and must be used by at least one build step. Values can be at most 64 KB in size.
               There can be at most 100 secret values across all of a build's secrets.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        pulumi.set(__self__, "secret_env", secret_env)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> _builtins.str:
        """
        Cloud KMS key name to use to decrypt these envs.
        """
        return pulumi.get(self, "kms_key_name")

    @_builtins.property
    @pulumi.getter(name="secretEnv")
    def secret_env(self) -> Mapping[str, _builtins.str]:
        """
        Map of environment variable name to its encrypted value.
        Secret environment variables must be unique across all of a build's secrets,
        and must be used by at least one build step. Values can be at most 64 KB in size.
        There can be at most 100 secret values across all of a build's secrets.
        """
        return pulumi.get(self, "secret_env")


@pulumi.output_type
class GetTriggerBuildSourceResult(dict):
    def __init__(__self__, *,
                 repo_sources: Sequence['outputs.GetTriggerBuildSourceRepoSourceResult'],
                 storage_sources: Sequence['outputs.GetTriggerBuildSourceStorageSourceResult']):
        """
        :param Sequence['GetTriggerBuildSourceRepoSourceArgs'] repo_sources: Location of the source in a Google Cloud Source Repository.
        :param Sequence['GetTriggerBuildSourceStorageSourceArgs'] storage_sources: Location of the source in an archive file in Google Cloud Storage.
        """
        pulumi.set(__self__, "repo_sources", repo_sources)
        pulumi.set(__self__, "storage_sources", storage_sources)

    @_builtins.property
    @pulumi.getter(name="repoSources")
    def repo_sources(self) -> Sequence['outputs.GetTriggerBuildSourceRepoSourceResult']:
        """
        Location of the source in a Google Cloud Source Repository.
        """
        return pulumi.get(self, "repo_sources")

    @_builtins.property
    @pulumi.getter(name="storageSources")
    def storage_sources(self) -> Sequence['outputs.GetTriggerBuildSourceStorageSourceResult']:
        """
        Location of the source in an archive file in Google Cloud Storage.
        """
        return pulumi.get(self, "storage_sources")


@pulumi.output_type
class GetTriggerBuildSourceRepoSourceResult(dict):
    def __init__(__self__, *,
                 branch_name: _builtins.str,
                 commit_sha: _builtins.str,
                 dir: _builtins.str,
                 invert_regex: _builtins.bool,
                 project_id: _builtins.str,
                 repo_name: _builtins.str,
                 substitutions: Mapping[str, _builtins.str],
                 tag_name: _builtins.str):
        """
        :param _builtins.str branch_name: Regex matching branches to build. Exactly one a of branch name, tag, or commit SHA must be provided.
               The syntax of the regular expressions accepted is the syntax accepted by RE2 and
               described at https://github.com/google/re2/wiki/Syntax
        :param _builtins.str commit_sha: Explicit commit SHA to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        :param _builtins.str dir: Directory, relative to the source root, in which to run the build.
               This must be a relative path. If a step's dir is specified and is an absolute path,
               this value is ignored for that step's execution.
        :param _builtins.bool invert_regex: Only trigger a build if the revision regex does NOT match the revision regex.
        :param _builtins.str project_id: ID of the project that owns the Cloud Source Repository.
               If omitted, the project ID requesting the build is assumed.
        :param _builtins.str repo_name: Name of the Cloud Source Repository.
        :param Mapping[str, _builtins.str] substitutions: Substitutions to use in a triggered build. Should only be used with triggers.run
        :param _builtins.str tag_name: Regex matching tags to build. Exactly one a of branch name, tag, or commit SHA must be provided.
               The syntax of the regular expressions accepted is the syntax accepted by RE2 and
               described at https://github.com/google/re2/wiki/Syntax
        """
        pulumi.set(__self__, "branch_name", branch_name)
        pulumi.set(__self__, "commit_sha", commit_sha)
        pulumi.set(__self__, "dir", dir)
        pulumi.set(__self__, "invert_regex", invert_regex)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "repo_name", repo_name)
        pulumi.set(__self__, "substitutions", substitutions)
        pulumi.set(__self__, "tag_name", tag_name)

    @_builtins.property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> _builtins.str:
        """
        Regex matching branches to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and
        described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "branch_name")

    @_builtins.property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> _builtins.str:
        """
        Explicit commit SHA to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        """
        return pulumi.get(self, "commit_sha")

    @_builtins.property
    @pulumi.getter
    def dir(self) -> _builtins.str:
        """
        Directory, relative to the source root, in which to run the build.
        This must be a relative path. If a step's dir is specified and is an absolute path,
        this value is ignored for that step's execution.
        """
        return pulumi.get(self, "dir")

    @_builtins.property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> _builtins.bool:
        """
        Only trigger a build if the revision regex does NOT match the revision regex.
        """
        return pulumi.get(self, "invert_regex")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        ID of the project that owns the Cloud Source Repository.
        If omitted, the project ID requesting the build is assumed.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> _builtins.str:
        """
        Name of the Cloud Source Repository.
        """
        return pulumi.get(self, "repo_name")

    @_builtins.property
    @pulumi.getter
    def substitutions(self) -> Mapping[str, _builtins.str]:
        """
        Substitutions to use in a triggered build. Should only be used with triggers.run
        """
        return pulumi.get(self, "substitutions")

    @_builtins.property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> _builtins.str:
        """
        Regex matching tags to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and
        described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "tag_name")


@pulumi.output_type
class GetTriggerBuildSourceStorageSourceResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 generation: _builtins.str,
                 object: _builtins.str):
        """
        :param _builtins.str bucket: Google Cloud Storage bucket containing the source.
        :param _builtins.str generation: Google Cloud Storage generation for the object.
               If the generation is omitted, the latest generation will be used
        :param _builtins.str object: Google Cloud Storage object containing the source.
               This object must be a gzipped archive file (.tar.gz) containing source to build.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "object", object)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        Google Cloud Storage bucket containing the source.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def generation(self) -> _builtins.str:
        """
        Google Cloud Storage generation for the object.
        If the generation is omitted, the latest generation will be used
        """
        return pulumi.get(self, "generation")

    @_builtins.property
    @pulumi.getter
    def object(self) -> _builtins.str:
        """
        Google Cloud Storage object containing the source.
        This object must be a gzipped archive file (.tar.gz) containing source to build.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetTriggerBuildStepResult(dict):
    def __init__(__self__, *,
                 allow_exit_codes: Sequence[_builtins.int],
                 allow_failure: _builtins.bool,
                 args: Sequence[_builtins.str],
                 dir: _builtins.str,
                 entrypoint: _builtins.str,
                 envs: Sequence[_builtins.str],
                 id: _builtins.str,
                 name: _builtins.str,
                 script: _builtins.str,
                 secret_envs: Sequence[_builtins.str],
                 timeout: _builtins.str,
                 timing: _builtins.str,
                 volumes: Sequence['outputs.GetTriggerBuildStepVolumeResult'],
                 wait_fors: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.int] allow_exit_codes: Allow this build step to fail without failing the entire build if and
               only if the exit code is one of the specified codes.
               
               If 'allowFailure' is also specified, this field will take precedence.
        :param _builtins.bool allow_failure: Allow this build step to fail without failing the entire build.
               If false, the entire build will fail if this step fails. Otherwise, the
               build will succeed, but this step will still have a failure status.
               Error information will be reported in the 'failureDetail' field.
               
               'allowExitCodes' takes precedence over this field.
        :param Sequence[_builtins.str] args: A list of arguments that will be presented to the step when it is started.
               
               If the image used to run the step's container has an entrypoint, the args
               are used as arguments to that entrypoint. If the image does not define an
               entrypoint, the first element in args is used as the entrypoint, and the
               remainder will be used as arguments.
        :param _builtins.str dir: Working directory to use when running this step's container.
               
               If this value is a relative path, it is relative to the build's working
               directory. If this value is absolute, it may be outside the build's working
               directory, in which case the contents of the path may not be persisted
               across build step executions, unless a 'volume' for that path is specified.
               
               If the build specifies a 'RepoSource' with 'dir' and a step with a
               'dir',
               which specifies an absolute path, the 'RepoSource' 'dir' is ignored
               for the step's execution.
        :param _builtins.str entrypoint: Entrypoint to be used instead of the build step image's
               default entrypoint.
               If unset, the image's default entrypoint is used
        :param Sequence[_builtins.str] envs: A list of environment variable definitions to be used when
               running a step.
               
               The elements are of the form "KEY=VALUE" for the environment variable
               "KEY" being given the value "VALUE".
        :param _builtins.str id: Unique identifier for this build step, used in 'wait_for' to
               reference this build step as a dependency.
        :param _builtins.str name: The name of the container image that will run this particular build step.
               
               If the image is available in the host's Docker daemon's cache, it will be
               run directly. If not, the host will attempt to pull the image first, using
               the builder service account's credentials if necessary.
               
               The Docker daemon's cache will already have the latest versions of all of
               the officially supported build steps (see https://github.com/GoogleCloudPlatform/cloud-builders
               for images and examples).
               The Docker daemon will also have cached many of the layers for some popular
               images, like "ubuntu", "debian", but they will be refreshed at the time
               you attempt to use them.
               
               If you built an image in a previous build step, it will be stored in the
               host's Docker daemon's cache and is available to use as the name for a
               later build step.
        :param _builtins.str script: A shell script to be executed in the step.
               When script is provided, the user cannot specify the entrypoint or args.
        :param Sequence[_builtins.str] secret_envs: A list of environment variables which are encrypted using
               a Cloud Key
               Management Service crypto key. These values must be specified in
               the build's 'Secret'.
        :param _builtins.str timeout: Time limit for executing this build step. If not defined,
               the step has no
               time limit and will be allowed to continue to run until either it
               completes or the build itself times out.
        :param _builtins.str timing: Output only. Stores timing information for executing this
               build step.
        :param Sequence['GetTriggerBuildStepVolumeArgs'] volumes: List of volumes to mount into the build step.
               
               Each volume is created as an empty volume prior to execution of the
               build step. Upon completion of the build, volumes and their contents
               are discarded.
               
               Using a named volume in only one step is not valid as it is
               indicative of a build request with an incorrect configuration.
        :param Sequence[_builtins.str] wait_fors: The ID(s) of the step(s) that this build step depends on.
               
               This build step will not start until all the build steps in 'wait_for'
               have completed successfully. If 'wait_for' is empty, this build step
               will start when all previous build steps in the 'Build.Steps' list
               have completed successfully.
        """
        pulumi.set(__self__, "allow_exit_codes", allow_exit_codes)
        pulumi.set(__self__, "allow_failure", allow_failure)
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "dir", dir)
        pulumi.set(__self__, "entrypoint", entrypoint)
        pulumi.set(__self__, "envs", envs)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "script", script)
        pulumi.set(__self__, "secret_envs", secret_envs)
        pulumi.set(__self__, "timeout", timeout)
        pulumi.set(__self__, "timing", timing)
        pulumi.set(__self__, "volumes", volumes)
        pulumi.set(__self__, "wait_fors", wait_fors)

    @_builtins.property
    @pulumi.getter(name="allowExitCodes")
    def allow_exit_codes(self) -> Sequence[_builtins.int]:
        """
        Allow this build step to fail without failing the entire build if and
        only if the exit code is one of the specified codes.

        If 'allowFailure' is also specified, this field will take precedence.
        """
        return pulumi.get(self, "allow_exit_codes")

    @_builtins.property
    @pulumi.getter(name="allowFailure")
    def allow_failure(self) -> _builtins.bool:
        """
        Allow this build step to fail without failing the entire build.
        If false, the entire build will fail if this step fails. Otherwise, the
        build will succeed, but this step will still have a failure status.
        Error information will be reported in the 'failureDetail' field.

        'allowExitCodes' takes precedence over this field.
        """
        return pulumi.get(self, "allow_failure")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Sequence[_builtins.str]:
        """
        A list of arguments that will be presented to the step when it is started.

        If the image used to run the step's container has an entrypoint, the args
        are used as arguments to that entrypoint. If the image does not define an
        entrypoint, the first element in args is used as the entrypoint, and the
        remainder will be used as arguments.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def dir(self) -> _builtins.str:
        """
        Working directory to use when running this step's container.

        If this value is a relative path, it is relative to the build's working
        directory. If this value is absolute, it may be outside the build's working
        directory, in which case the contents of the path may not be persisted
        across build step executions, unless a 'volume' for that path is specified.

        If the build specifies a 'RepoSource' with 'dir' and a step with a
        'dir',
        which specifies an absolute path, the 'RepoSource' 'dir' is ignored
        for the step's execution.
        """
        return pulumi.get(self, "dir")

    @_builtins.property
    @pulumi.getter
    def entrypoint(self) -> _builtins.str:
        """
        Entrypoint to be used instead of the build step image's
        default entrypoint.
        If unset, the image's default entrypoint is used
        """
        return pulumi.get(self, "entrypoint")

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Sequence[_builtins.str]:
        """
        A list of environment variable definitions to be used when
        running a step.

        The elements are of the form "KEY=VALUE" for the environment variable
        "KEY" being given the value "VALUE".
        """
        return pulumi.get(self, "envs")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique identifier for this build step, used in 'wait_for' to
        reference this build step as a dependency.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the container image that will run this particular build step.

        If the image is available in the host's Docker daemon's cache, it will be
        run directly. If not, the host will attempt to pull the image first, using
        the builder service account's credentials if necessary.

        The Docker daemon's cache will already have the latest versions of all of
        the officially supported build steps (see https://github.com/GoogleCloudPlatform/cloud-builders
        for images and examples).
        The Docker daemon will also have cached many of the layers for some popular
        images, like "ubuntu", "debian", but they will be refreshed at the time
        you attempt to use them.

        If you built an image in a previous build step, it will be stored in the
        host's Docker daemon's cache and is available to use as the name for a
        later build step.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def script(self) -> _builtins.str:
        """
        A shell script to be executed in the step.
        When script is provided, the user cannot specify the entrypoint or args.
        """
        return pulumi.get(self, "script")

    @_builtins.property
    @pulumi.getter(name="secretEnvs")
    def secret_envs(self) -> Sequence[_builtins.str]:
        """
        A list of environment variables which are encrypted using
        a Cloud Key
        Management Service crypto key. These values must be specified in
        the build's 'Secret'.
        """
        return pulumi.get(self, "secret_envs")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> _builtins.str:
        """
        Time limit for executing this build step. If not defined,
        the step has no
        time limit and will be allowed to continue to run until either it
        completes or the build itself times out.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter
    def timing(self) -> _builtins.str:
        """
        Output only. Stores timing information for executing this
        build step.
        """
        return pulumi.get(self, "timing")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.GetTriggerBuildStepVolumeResult']:
        """
        List of volumes to mount into the build step.

        Each volume is created as an empty volume prior to execution of the
        build step. Upon completion of the build, volumes and their contents
        are discarded.

        Using a named volume in only one step is not valid as it is
        indicative of a build request with an incorrect configuration.
        """
        return pulumi.get(self, "volumes")

    @_builtins.property
    @pulumi.getter(name="waitFors")
    def wait_fors(self) -> Sequence[_builtins.str]:
        """
        The ID(s) of the step(s) that this build step depends on.

        This build step will not start until all the build steps in 'wait_for'
        have completed successfully. If 'wait_for' is empty, this build step
        will start when all previous build steps in the 'Build.Steps' list
        have completed successfully.
        """
        return pulumi.get(self, "wait_fors")


@pulumi.output_type
class GetTriggerBuildStepVolumeResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 path: _builtins.str):
        """
        :param _builtins.str name: Name of the volume to mount.
               
               Volume names must be unique per build step and must be valid names for
               Docker volumes. Each named volume must be used by at least two build steps.
        :param _builtins.str path: Path at which to mount the volume.
               
               Paths must be absolute and cannot conflict with other volume paths on
               the same build step or with certain reserved volume paths.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the volume to mount.

        Volume names must be unique per build step and must be valid names for
        Docker volumes. Each named volume must be used by at least two build steps.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Path at which to mount the volume.

        Paths must be absolute and cannot conflict with other volume paths on
        the same build step or with certain reserved volume paths.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class GetTriggerDeveloperConnectEventConfigResult(dict):
    def __init__(__self__, *,
                 git_repository_link: _builtins.str,
                 git_repository_link_type: _builtins.str,
                 pull_requests: Sequence['outputs.GetTriggerDeveloperConnectEventConfigPullRequestResult'],
                 pushes: Sequence['outputs.GetTriggerDeveloperConnectEventConfigPushResult']):
        """
        :param _builtins.str git_repository_link: The Developer Connect Git repository link, formatted as 'projects/*/locations/*/connections/*/gitRepositoryLink/*'.
        :param _builtins.str git_repository_link_type: The type of DeveloperConnect GitRepositoryLink.
        :param Sequence['GetTriggerDeveloperConnectEventConfigPullRequestArgs'] pull_requests: Filter to match changes in pull requests.
        :param Sequence['GetTriggerDeveloperConnectEventConfigPushArgs'] pushes: Filter to match changes in refs like branches and tags.
        """
        pulumi.set(__self__, "git_repository_link", git_repository_link)
        pulumi.set(__self__, "git_repository_link_type", git_repository_link_type)
        pulumi.set(__self__, "pull_requests", pull_requests)
        pulumi.set(__self__, "pushes", pushes)

    @_builtins.property
    @pulumi.getter(name="gitRepositoryLink")
    def git_repository_link(self) -> _builtins.str:
        """
        The Developer Connect Git repository link, formatted as 'projects/*/locations/*/connections/*/gitRepositoryLink/*'.
        """
        return pulumi.get(self, "git_repository_link")

    @_builtins.property
    @pulumi.getter(name="gitRepositoryLinkType")
    def git_repository_link_type(self) -> _builtins.str:
        """
        The type of DeveloperConnect GitRepositoryLink.
        """
        return pulumi.get(self, "git_repository_link_type")

    @_builtins.property
    @pulumi.getter(name="pullRequests")
    def pull_requests(self) -> Sequence['outputs.GetTriggerDeveloperConnectEventConfigPullRequestResult']:
        """
        Filter to match changes in pull requests.
        """
        return pulumi.get(self, "pull_requests")

    @_builtins.property
    @pulumi.getter
    def pushes(self) -> Sequence['outputs.GetTriggerDeveloperConnectEventConfigPushResult']:
        """
        Filter to match changes in refs like branches and tags.
        """
        return pulumi.get(self, "pushes")


@pulumi.output_type
class GetTriggerDeveloperConnectEventConfigPullRequestResult(dict):
    def __init__(__self__, *,
                 branch: _builtins.str,
                 comment_control: _builtins.str,
                 invert_regex: _builtins.bool):
        """
        :param _builtins.str branch: Regex of branches to match.
        :param _builtins.str comment_control: Configure builds to run whether a repository owner or collaborator need to comment '/gcbrun'. Possible values: ["COMMENTS_DISABLED", "COMMENTS_ENABLED", "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY"]
        :param _builtins.bool invert_regex: If true, branches that do NOT match the git_ref will trigger a build.
        """
        pulumi.set(__self__, "branch", branch)
        pulumi.set(__self__, "comment_control", comment_control)
        pulumi.set(__self__, "invert_regex", invert_regex)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> _builtins.str:
        """
        Regex of branches to match.
        """
        return pulumi.get(self, "branch")

    @_builtins.property
    @pulumi.getter(name="commentControl")
    def comment_control(self) -> _builtins.str:
        """
        Configure builds to run whether a repository owner or collaborator need to comment '/gcbrun'. Possible values: ["COMMENTS_DISABLED", "COMMENTS_ENABLED", "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY"]
        """
        return pulumi.get(self, "comment_control")

    @_builtins.property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> _builtins.bool:
        """
        If true, branches that do NOT match the git_ref will trigger a build.
        """
        return pulumi.get(self, "invert_regex")


@pulumi.output_type
class GetTriggerDeveloperConnectEventConfigPushResult(dict):
    def __init__(__self__, *,
                 branch: _builtins.str,
                 invert_regex: _builtins.bool,
                 tag: _builtins.str):
        """
        :param _builtins.str branch: Regex of branches to match.
        :param _builtins.bool invert_regex: If true, only trigger a build if the revision regex does NOT match the git_ref regex.
        :param _builtins.str tag: Regex of tags to match.
        """
        pulumi.set(__self__, "branch", branch)
        pulumi.set(__self__, "invert_regex", invert_regex)
        pulumi.set(__self__, "tag", tag)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> _builtins.str:
        """
        Regex of branches to match.
        """
        return pulumi.get(self, "branch")

    @_builtins.property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> _builtins.bool:
        """
        If true, only trigger a build if the revision regex does NOT match the git_ref regex.
        """
        return pulumi.get(self, "invert_regex")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> _builtins.str:
        """
        Regex of tags to match.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class GetTriggerGitFileSourceResult(dict):
    def __init__(__self__, *,
                 bitbucket_server_config: _builtins.str,
                 github_enterprise_config: _builtins.str,
                 path: _builtins.str,
                 repo_type: _builtins.str,
                 repository: _builtins.str,
                 revision: _builtins.str,
                 uri: _builtins.str):
        """
        :param _builtins.str bitbucket_server_config: The full resource name of the bitbucket server config.
               Format: projects/{project}/locations/{location}/bitbucketServerConfigs/{id}.
        :param _builtins.str github_enterprise_config: The full resource name of the github enterprise config.
               Format: projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}. projects/{project}/githubEnterpriseConfigs/{id}.
        :param _builtins.str path: The path of the file, with the repo root as the root of the path.
        :param _builtins.str repo_type: The type of the repo, since it may not be explicit from the repo field (e.g from a URL).
               Values can be UNKNOWN, CLOUD_SOURCE_REPOSITORIES, GITHUB, BITBUCKET_SERVER Possible values: ["UNKNOWN", "CLOUD_SOURCE_REPOSITORIES", "GITHUB", "BITBUCKET_SERVER"]
        :param _builtins.str repository: The fully qualified resource name of the Repo API repository. The fully qualified resource name of the Repo API repository.
               If unspecified, the repo from which the trigger invocation originated is assumed to be the repo from which to read the specified path.
        :param _builtins.str revision: The branch, tag, arbitrary ref, or SHA version of the repo to use when resolving the
               filename (optional). This field respects the same syntax/resolution as described here: https://git-scm.com/docs/gitrevisions
               If unspecified, the revision from which the trigger invocation originated is assumed to be the revision from which to read the specified path.
        :param _builtins.str uri: The URI of the repo (optional). If unspecified, the repo from which the trigger
               invocation originated is assumed to be the repo from which to read the specified path.
        """
        pulumi.set(__self__, "bitbucket_server_config", bitbucket_server_config)
        pulumi.set(__self__, "github_enterprise_config", github_enterprise_config)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "repo_type", repo_type)
        pulumi.set(__self__, "repository", repository)
        pulumi.set(__self__, "revision", revision)
        pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter(name="bitbucketServerConfig")
    def bitbucket_server_config(self) -> _builtins.str:
        """
        The full resource name of the bitbucket server config.
        Format: projects/{project}/locations/{location}/bitbucketServerConfigs/{id}.
        """
        return pulumi.get(self, "bitbucket_server_config")

    @_builtins.property
    @pulumi.getter(name="githubEnterpriseConfig")
    def github_enterprise_config(self) -> _builtins.str:
        """
        The full resource name of the github enterprise config.
        Format: projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}. projects/{project}/githubEnterpriseConfigs/{id}.
        """
        return pulumi.get(self, "github_enterprise_config")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The path of the file, with the repo root as the root of the path.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="repoType")
    def repo_type(self) -> _builtins.str:
        """
        The type of the repo, since it may not be explicit from the repo field (e.g from a URL).
        Values can be UNKNOWN, CLOUD_SOURCE_REPOSITORIES, GITHUB, BITBUCKET_SERVER Possible values: ["UNKNOWN", "CLOUD_SOURCE_REPOSITORIES", "GITHUB", "BITBUCKET_SERVER"]
        """
        return pulumi.get(self, "repo_type")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> _builtins.str:
        """
        The fully qualified resource name of the Repo API repository. The fully qualified resource name of the Repo API repository.
        If unspecified, the repo from which the trigger invocation originated is assumed to be the repo from which to read the specified path.
        """
        return pulumi.get(self, "repository")

    @_builtins.property
    @pulumi.getter
    def revision(self) -> _builtins.str:
        """
        The branch, tag, arbitrary ref, or SHA version of the repo to use when resolving the
        filename (optional). This field respects the same syntax/resolution as described here: https://git-scm.com/docs/gitrevisions
        If unspecified, the revision from which the trigger invocation originated is assumed to be the revision from which to read the specified path.
        """
        return pulumi.get(self, "revision")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        The URI of the repo (optional). If unspecified, the repo from which the trigger
        invocation originated is assumed to be the repo from which to read the specified path.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetTriggerGithubResult(dict):
    def __init__(__self__, *,
                 enterprise_config_resource_name: _builtins.str,
                 name: _builtins.str,
                 owner: _builtins.str,
                 pull_requests: Sequence['outputs.GetTriggerGithubPullRequestResult'],
                 pushes: Sequence['outputs.GetTriggerGithubPushResult']):
        """
        :param _builtins.str enterprise_config_resource_name: The resource name of the github enterprise config that should be applied to this installation.
               For example: "projects/{$projectId}/locations/{$locationId}/githubEnterpriseConfigs/{$configId}"
        :param _builtins.str name: Name of the repository. For example: The name for
               https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".
        :param _builtins.str owner: Owner of the repository. For example: The owner for
               https://github.com/googlecloudplatform/cloud-builders is "googlecloudplatform".
        :param Sequence['GetTriggerGithubPullRequestArgs'] pull_requests: filter to match changes in pull requests. Specify only one of 'pull_request' or 'push'.
        :param Sequence['GetTriggerGithubPushArgs'] pushes: filter to match changes in refs, like branches or tags. Specify only one of 'pull_request' or 'push'.
        """
        pulumi.set(__self__, "enterprise_config_resource_name", enterprise_config_resource_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "pull_requests", pull_requests)
        pulumi.set(__self__, "pushes", pushes)

    @_builtins.property
    @pulumi.getter(name="enterpriseConfigResourceName")
    def enterprise_config_resource_name(self) -> _builtins.str:
        """
        The resource name of the github enterprise config that should be applied to this installation.
        For example: "projects/{$projectId}/locations/{$locationId}/githubEnterpriseConfigs/{$configId}"
        """
        return pulumi.get(self, "enterprise_config_resource_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the repository. For example: The name for
        https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> _builtins.str:
        """
        Owner of the repository. For example: The owner for
        https://github.com/googlecloudplatform/cloud-builders is "googlecloudplatform".
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter(name="pullRequests")
    def pull_requests(self) -> Sequence['outputs.GetTriggerGithubPullRequestResult']:
        """
        filter to match changes in pull requests. Specify only one of 'pull_request' or 'push'.
        """
        return pulumi.get(self, "pull_requests")

    @_builtins.property
    @pulumi.getter
    def pushes(self) -> Sequence['outputs.GetTriggerGithubPushResult']:
        """
        filter to match changes in refs, like branches or tags. Specify only one of 'pull_request' or 'push'.
        """
        return pulumi.get(self, "pushes")


@pulumi.output_type
class GetTriggerGithubPullRequestResult(dict):
    def __init__(__self__, *,
                 branch: _builtins.str,
                 comment_control: _builtins.str,
                 invert_regex: _builtins.bool):
        """
        :param _builtins.str branch: Regex of branches to match.
        :param _builtins.str comment_control: Whether to block builds on a "/gcbrun" comment from a repository owner or collaborator. Possible values: ["COMMENTS_DISABLED", "COMMENTS_ENABLED", "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY"]
        :param _builtins.bool invert_regex: If true, branches that do NOT match the git_ref will trigger a build.
        """
        pulumi.set(__self__, "branch", branch)
        pulumi.set(__self__, "comment_control", comment_control)
        pulumi.set(__self__, "invert_regex", invert_regex)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> _builtins.str:
        """
        Regex of branches to match.
        """
        return pulumi.get(self, "branch")

    @_builtins.property
    @pulumi.getter(name="commentControl")
    def comment_control(self) -> _builtins.str:
        """
        Whether to block builds on a "/gcbrun" comment from a repository owner or collaborator. Possible values: ["COMMENTS_DISABLED", "COMMENTS_ENABLED", "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY"]
        """
        return pulumi.get(self, "comment_control")

    @_builtins.property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> _builtins.bool:
        """
        If true, branches that do NOT match the git_ref will trigger a build.
        """
        return pulumi.get(self, "invert_regex")


@pulumi.output_type
class GetTriggerGithubPushResult(dict):
    def __init__(__self__, *,
                 branch: _builtins.str,
                 invert_regex: _builtins.bool,
                 tag: _builtins.str):
        """
        :param _builtins.str branch: Regex of branches to match.  Specify only one of branch or tag.
        :param _builtins.bool invert_regex: When true, only trigger a build if the revision regex does NOT match the git_ref regex.
        :param _builtins.str tag: Regex of tags to match.  Specify only one of branch or tag.
        """
        pulumi.set(__self__, "branch", branch)
        pulumi.set(__self__, "invert_regex", invert_regex)
        pulumi.set(__self__, "tag", tag)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> _builtins.str:
        """
        Regex of branches to match.  Specify only one of branch or tag.
        """
        return pulumi.get(self, "branch")

    @_builtins.property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> _builtins.bool:
        """
        When true, only trigger a build if the revision regex does NOT match the git_ref regex.
        """
        return pulumi.get(self, "invert_regex")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> _builtins.str:
        """
        Regex of tags to match.  Specify only one of branch or tag.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class GetTriggerPubsubConfigResult(dict):
    def __init__(__self__, *,
                 service_account_email: _builtins.str,
                 state: _builtins.str,
                 subscription: _builtins.str,
                 topic: _builtins.str):
        """
        :param _builtins.str service_account_email: Service account that will make the push request.
        :param _builtins.str state: Potential issues with the underlying Pub/Sub subscription configuration.
               Only populated on get requests.
        :param _builtins.str subscription: Output only. Name of the subscription.
        :param _builtins.str topic: The name of the topic from which this subscription is receiving messages.
        """
        pulumi.set(__self__, "service_account_email", service_account_email)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subscription", subscription)
        pulumi.set(__self__, "topic", topic)

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> _builtins.str:
        """
        Service account that will make the push request.
        """
        return pulumi.get(self, "service_account_email")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Potential issues with the underlying Pub/Sub subscription configuration.
        Only populated on get requests.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def subscription(self) -> _builtins.str:
        """
        Output only. Name of the subscription.
        """
        return pulumi.get(self, "subscription")

    @_builtins.property
    @pulumi.getter
    def topic(self) -> _builtins.str:
        """
        The name of the topic from which this subscription is receiving messages.
        """
        return pulumi.get(self, "topic")


@pulumi.output_type
class GetTriggerRepositoryEventConfigResult(dict):
    def __init__(__self__, *,
                 pull_requests: Sequence['outputs.GetTriggerRepositoryEventConfigPullRequestResult'],
                 pushes: Sequence['outputs.GetTriggerRepositoryEventConfigPushResult'],
                 repository: _builtins.str):
        """
        :param Sequence['GetTriggerRepositoryEventConfigPullRequestArgs'] pull_requests: Contains filter properties for matching Pull Requests.
        :param Sequence['GetTriggerRepositoryEventConfigPushArgs'] pushes: Contains filter properties for matching git pushes.
        :param _builtins.str repository: The resource name of the Repo API resource.
        """
        pulumi.set(__self__, "pull_requests", pull_requests)
        pulumi.set(__self__, "pushes", pushes)
        pulumi.set(__self__, "repository", repository)

    @_builtins.property
    @pulumi.getter(name="pullRequests")
    def pull_requests(self) -> Sequence['outputs.GetTriggerRepositoryEventConfigPullRequestResult']:
        """
        Contains filter properties for matching Pull Requests.
        """
        return pulumi.get(self, "pull_requests")

    @_builtins.property
    @pulumi.getter
    def pushes(self) -> Sequence['outputs.GetTriggerRepositoryEventConfigPushResult']:
        """
        Contains filter properties for matching git pushes.
        """
        return pulumi.get(self, "pushes")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> _builtins.str:
        """
        The resource name of the Repo API resource.
        """
        return pulumi.get(self, "repository")


@pulumi.output_type
class GetTriggerRepositoryEventConfigPullRequestResult(dict):
    def __init__(__self__, *,
                 branch: _builtins.str,
                 comment_control: _builtins.str,
                 invert_regex: _builtins.bool):
        """
        :param _builtins.str branch: Regex of branches to match.
               
               The syntax of the regular expressions accepted is the syntax accepted by
               RE2 and described at https://github.com/google/re2/wiki/Syntax
        :param _builtins.str comment_control: Configure builds to run whether a repository owner or collaborator need to comment '/gcbrun'. Possible values: ["COMMENTS_DISABLED", "COMMENTS_ENABLED", "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY"]
        :param _builtins.bool invert_regex: If true, branches that do NOT match the git_ref will trigger a build.
        """
        pulumi.set(__self__, "branch", branch)
        pulumi.set(__self__, "comment_control", comment_control)
        pulumi.set(__self__, "invert_regex", invert_regex)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> _builtins.str:
        """
        Regex of branches to match.

        The syntax of the regular expressions accepted is the syntax accepted by
        RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "branch")

    @_builtins.property
    @pulumi.getter(name="commentControl")
    def comment_control(self) -> _builtins.str:
        """
        Configure builds to run whether a repository owner or collaborator need to comment '/gcbrun'. Possible values: ["COMMENTS_DISABLED", "COMMENTS_ENABLED", "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY"]
        """
        return pulumi.get(self, "comment_control")

    @_builtins.property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> _builtins.bool:
        """
        If true, branches that do NOT match the git_ref will trigger a build.
        """
        return pulumi.get(self, "invert_regex")


@pulumi.output_type
class GetTriggerRepositoryEventConfigPushResult(dict):
    def __init__(__self__, *,
                 branch: _builtins.str,
                 invert_regex: _builtins.bool,
                 tag: _builtins.str):
        """
        :param _builtins.str branch: Regex of branches to match.
               
               The syntax of the regular expressions accepted is the syntax accepted by
               RE2 and described at https://github.com/google/re2/wiki/Syntax
        :param _builtins.bool invert_regex: If true, only trigger a build if the revision regex does NOT match the git_ref regex.
        :param _builtins.str tag: Regex of tags to match.
               
               The syntax of the regular expressions accepted is the syntax accepted by
               RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        pulumi.set(__self__, "branch", branch)
        pulumi.set(__self__, "invert_regex", invert_regex)
        pulumi.set(__self__, "tag", tag)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> _builtins.str:
        """
        Regex of branches to match.

        The syntax of the regular expressions accepted is the syntax accepted by
        RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "branch")

    @_builtins.property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> _builtins.bool:
        """
        If true, only trigger a build if the revision regex does NOT match the git_ref regex.
        """
        return pulumi.get(self, "invert_regex")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> _builtins.str:
        """
        Regex of tags to match.

        The syntax of the regular expressions accepted is the syntax accepted by
        RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class GetTriggerSourceToBuildResult(dict):
    def __init__(__self__, *,
                 bitbucket_server_config: _builtins.str,
                 github_enterprise_config: _builtins.str,
                 ref: _builtins.str,
                 repo_type: _builtins.str,
                 repository: _builtins.str,
                 uri: _builtins.str):
        """
        :param _builtins.str bitbucket_server_config: The full resource name of the bitbucket server config.
               Format: projects/{project}/locations/{location}/bitbucketServerConfigs/{id}.
        :param _builtins.str github_enterprise_config: The full resource name of the github enterprise config.
               Format: projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}. projects/{project}/githubEnterpriseConfigs/{id}.
        :param _builtins.str ref: The branch or tag to use. Must start with "refs/" (required).
        :param _builtins.str repo_type: The type of the repo, since it may not be explicit from the repo field (e.g from a URL).
               Values can be UNKNOWN, CLOUD_SOURCE_REPOSITORIES, GITHUB, BITBUCKET_SERVER Possible values: ["UNKNOWN", "CLOUD_SOURCE_REPOSITORIES", "GITHUB", "BITBUCKET_SERVER"]
        :param _builtins.str repository: The qualified resource name of the Repo API repository.
               Either uri or repository can be specified and is required.
        :param _builtins.str uri: The URI of the repo.
        """
        pulumi.set(__self__, "bitbucket_server_config", bitbucket_server_config)
        pulumi.set(__self__, "github_enterprise_config", github_enterprise_config)
        pulumi.set(__self__, "ref", ref)
        pulumi.set(__self__, "repo_type", repo_type)
        pulumi.set(__self__, "repository", repository)
        pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter(name="bitbucketServerConfig")
    def bitbucket_server_config(self) -> _builtins.str:
        """
        The full resource name of the bitbucket server config.
        Format: projects/{project}/locations/{location}/bitbucketServerConfigs/{id}.
        """
        return pulumi.get(self, "bitbucket_server_config")

    @_builtins.property
    @pulumi.getter(name="githubEnterpriseConfig")
    def github_enterprise_config(self) -> _builtins.str:
        """
        The full resource name of the github enterprise config.
        Format: projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}. projects/{project}/githubEnterpriseConfigs/{id}.
        """
        return pulumi.get(self, "github_enterprise_config")

    @_builtins.property
    @pulumi.getter
    def ref(self) -> _builtins.str:
        """
        The branch or tag to use. Must start with "refs/" (required).
        """
        return pulumi.get(self, "ref")

    @_builtins.property
    @pulumi.getter(name="repoType")
    def repo_type(self) -> _builtins.str:
        """
        The type of the repo, since it may not be explicit from the repo field (e.g from a URL).
        Values can be UNKNOWN, CLOUD_SOURCE_REPOSITORIES, GITHUB, BITBUCKET_SERVER Possible values: ["UNKNOWN", "CLOUD_SOURCE_REPOSITORIES", "GITHUB", "BITBUCKET_SERVER"]
        """
        return pulumi.get(self, "repo_type")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> _builtins.str:
        """
        The qualified resource name of the Repo API repository.
        Either uri or repository can be specified and is required.
        """
        return pulumi.get(self, "repository")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        The URI of the repo.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetTriggerTriggerTemplateResult(dict):
    def __init__(__self__, *,
                 branch_name: _builtins.str,
                 commit_sha: _builtins.str,
                 dir: _builtins.str,
                 invert_regex: _builtins.bool,
                 project_id: _builtins.str,
                 repo_name: _builtins.str,
                 tag_name: _builtins.str):
        """
        :param _builtins.str branch_name: Name of the branch to build. Exactly one a of branch name, tag, or commit SHA must be provided.
               This field is a regular expression.
        :param _builtins.str commit_sha: Explicit commit SHA to build. Exactly one of a branch name, tag, or commit SHA must be provided.
        :param _builtins.str dir: Directory, relative to the source root, in which to run the build.
               
               This must be a relative path. If a step's dir is specified and
               is an absolute path, this value is ignored for that step's
               execution.
        :param _builtins.bool invert_regex: Only trigger a build if the revision regex does NOT match the revision regex.
        :param _builtins.str project_id: ID of the project that owns the Cloud Source Repository. If
               omitted, the project ID requesting the build is assumed.
        :param _builtins.str repo_name: Name of the Cloud Source Repository. If omitted, the name "default" is assumed.
        :param _builtins.str tag_name: Name of the tag to build. Exactly one of a branch name, tag, or commit SHA must be provided.
               This field is a regular expression.
        """
        pulumi.set(__self__, "branch_name", branch_name)
        pulumi.set(__self__, "commit_sha", commit_sha)
        pulumi.set(__self__, "dir", dir)
        pulumi.set(__self__, "invert_regex", invert_regex)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "repo_name", repo_name)
        pulumi.set(__self__, "tag_name", tag_name)

    @_builtins.property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> _builtins.str:
        """
        Name of the branch to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        This field is a regular expression.
        """
        return pulumi.get(self, "branch_name")

    @_builtins.property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> _builtins.str:
        """
        Explicit commit SHA to build. Exactly one of a branch name, tag, or commit SHA must be provided.
        """
        return pulumi.get(self, "commit_sha")

    @_builtins.property
    @pulumi.getter
    def dir(self) -> _builtins.str:
        """
        Directory, relative to the source root, in which to run the build.

        This must be a relative path. If a step's dir is specified and
        is an absolute path, this value is ignored for that step's
        execution.
        """
        return pulumi.get(self, "dir")

    @_builtins.property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> _builtins.bool:
        """
        Only trigger a build if the revision regex does NOT match the revision regex.
        """
        return pulumi.get(self, "invert_regex")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        ID of the project that owns the Cloud Source Repository. If
        omitted, the project ID requesting the build is assumed.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> _builtins.str:
        """
        Name of the Cloud Source Repository. If omitted, the name "default" is assumed.
        """
        return pulumi.get(self, "repo_name")

    @_builtins.property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> _builtins.str:
        """
        Name of the tag to build. Exactly one of a branch name, tag, or commit SHA must be provided.
        This field is a regular expression.
        """
        return pulumi.get(self, "tag_name")


@pulumi.output_type
class GetTriggerWebhookConfigResult(dict):
    def __init__(__self__, *,
                 secret: _builtins.str,
                 state: _builtins.str):
        """
        :param _builtins.str secret: Resource name for the secret required as a URL parameter.
        :param _builtins.str state: Potential issues with the underlying Pub/Sub subscription configuration.
               Only populated on get requests.
        """
        pulumi.set(__self__, "secret", secret)
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> _builtins.str:
        """
        Resource name for the secret required as a URL parameter.
        """
        return pulumi.get(self, "secret")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Potential issues with the underlying Pub/Sub subscription configuration.
        Only populated on get requests.
        """
        return pulumi.get(self, "state")


