# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DeliveryPipelineArgs', 'DeliveryPipeline']

@pulumi.input_type
class DeliveryPipelineArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 serial_pipeline: Optional[pulumi.Input['DeliveryPipelineSerialPipelineArgs']] = None,
                 suspended: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a DeliveryPipeline resource.
        :param pulumi.Input[_builtins.str] location: The location for the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] description: Description of the `DeliveryPipeline`. Max length is 255 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: Name of the `DeliveryPipeline`. Format is `a-z?`.
               
               
               
               - - -
        :param pulumi.Input[_builtins.str] project: The project for the resource
        :param pulumi.Input['DeliveryPipelineSerialPipelineArgs'] serial_pipeline: SerialPipeline defines a sequential set of stages for a `DeliveryPipeline`.
        :param pulumi.Input[_builtins.bool] suspended: When suspended, no new releases or rollouts can be created, but in-progress ones will complete.
        """
        pulumi.set(__self__, "location", location)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if serial_pipeline is not None:
            pulumi.set(__self__, "serial_pipeline", serial_pipeline)
        if suspended is not None:
            pulumi.set(__self__, "suspended", suspended)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.

        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the `DeliveryPipeline`. Max length is 255 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the `DeliveryPipeline`. Format is `a-z?`.



        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="serialPipeline")
    def serial_pipeline(self) -> Optional[pulumi.Input['DeliveryPipelineSerialPipelineArgs']]:
        """
        SerialPipeline defines a sequential set of stages for a `DeliveryPipeline`.
        """
        return pulumi.get(self, "serial_pipeline")

    @serial_pipeline.setter
    def serial_pipeline(self, value: Optional[pulumi.Input['DeliveryPipelineSerialPipelineArgs']]):
        pulumi.set(self, "serial_pipeline", value)

    @_builtins.property
    @pulumi.getter
    def suspended(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When suspended, no new releases or rollouts can be created, but in-progress ones will complete.
        """
        return pulumi.get(self, "suspended")

    @suspended.setter
    def suspended(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "suspended", value)


@pulumi.input_type
class _DeliveryPipelineState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['DeliveryPipelineConditionArgs']]]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 serial_pipeline: Optional[pulumi.Input['DeliveryPipelineSerialPipelineArgs']] = None,
                 suspended: Optional[pulumi.Input[_builtins.bool]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DeliveryPipeline resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Sequence[pulumi.Input['DeliveryPipelineConditionArgs']]] conditions: Output only. Information around the state of the Delivery Pipeline.
        :param pulumi.Input[_builtins.str] create_time: Output only. Time at which the pipeline was created.
        :param pulumi.Input[_builtins.str] description: Description of the `DeliveryPipeline`. Max length is 255 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] etag: This checksum is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location for the resource
        :param pulumi.Input[_builtins.str] name: Name of the `DeliveryPipeline`. Format is `a-z?`.
               
               
               
               - - -
        :param pulumi.Input[_builtins.str] project: The project for the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource and default labels configured on the provider.
        :param pulumi.Input['DeliveryPipelineSerialPipelineArgs'] serial_pipeline: SerialPipeline defines a sequential set of stages for a `DeliveryPipeline`.
        :param pulumi.Input[_builtins.bool] suspended: When suspended, no new releases or rollouts can be created, but in-progress ones will complete.
        :param pulumi.Input[_builtins.str] uid: Output only. Unique identifier of the `DeliveryPipeline`.
        :param pulumi.Input[_builtins.str] update_time: Output only. Most recent time at which the pipeline was updated.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if serial_pipeline is not None:
            pulumi.set(__self__, "serial_pipeline", serial_pipeline)
        if suspended is not None:
            pulumi.set(__self__, "suspended", suspended)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.

        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeliveryPipelineConditionArgs']]]]:
        """
        Output only. Information around the state of the Delivery Pipeline.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeliveryPipelineConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Time at which the pipeline was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the `DeliveryPipeline`. Max length is 255 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This checksum is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the `DeliveryPipeline`. Format is `a-z?`.



        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="serialPipeline")
    def serial_pipeline(self) -> Optional[pulumi.Input['DeliveryPipelineSerialPipelineArgs']]:
        """
        SerialPipeline defines a sequential set of stages for a `DeliveryPipeline`.
        """
        return pulumi.get(self, "serial_pipeline")

    @serial_pipeline.setter
    def serial_pipeline(self, value: Optional[pulumi.Input['DeliveryPipelineSerialPipelineArgs']]):
        pulumi.set(self, "serial_pipeline", value)

    @_builtins.property
    @pulumi.getter
    def suspended(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When suspended, no new releases or rollouts can be created, but in-progress ones will complete.
        """
        return pulumi.get(self, "suspended")

    @suspended.setter
    def suspended(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "suspended", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Unique identifier of the `DeliveryPipeline`.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Most recent time at which the pipeline was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:clouddeploy/deliveryPipeline:DeliveryPipeline")
class DeliveryPipeline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 serial_pipeline: Optional[pulumi.Input[Union['DeliveryPipelineSerialPipelineArgs', 'DeliveryPipelineSerialPipelineArgsDict']]] = None,
                 suspended: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        The Cloud Deploy `DeliveryPipeline` resource

        ## Example Usage

        ### Canary_delivery_pipeline
        Creates a basic Cloud Deploy delivery pipeline
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.clouddeploy.DeliveryPipeline("primary",
            location="us-west1",
            name="pipeline",
            description="basic description",
            project="my-project-name",
            serial_pipeline={
                "stages": [
                    {
                        "deploy_parameters": [{
                            "values": {
                                "deployParameterKey": "deployParameterValue",
                            },
                            "match_target_labels": {},
                        }],
                        "profiles": [
                            "example-profile-one",
                            "example-profile-two",
                        ],
                        "target_id": "example-target-one",
                    },
                    {
                        "profiles": [],
                        "target_id": "example-target-two",
                    },
                ],
            },
            annotations={
                "my_first_annotation": "example-annotation-1",
                "my_second_annotation": "example-annotation-2",
            },
            labels={
                "my_first_label": "example-label-1",
                "my_second_label": "example-label-2",
            })
        ```
        ### Canary_service_networking_delivery_pipeline
        Creates a basic Cloud Deploy delivery pipeline
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.clouddeploy.DeliveryPipeline("primary",
            location="us-west1",
            name="pipeline",
            description="basic description",
            project="my-project-name",
            serial_pipeline={
                "stages": [
                    {
                        "deploy_parameters": [{
                            "values": {
                                "deployParameterKey": "deployParameterValue",
                            },
                            "match_target_labels": {},
                        }],
                        "profiles": [
                            "example-profile-one",
                            "example-profile-two",
                        ],
                        "target_id": "example-target-one",
                    },
                    {
                        "profiles": [],
                        "target_id": "example-target-two",
                    },
                ],
            },
            annotations={
                "my_first_annotation": "example-annotation-1",
                "my_second_annotation": "example-annotation-2",
            },
            labels={
                "my_first_label": "example-label-1",
                "my_second_label": "example-label-2",
            })
        ```
        ### Canaryrun_delivery_pipeline
        Creates a basic Cloud Deploy delivery pipeline
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.clouddeploy.DeliveryPipeline("primary",
            location="us-west1",
            name="pipeline",
            description="basic description",
            project="my-project-name",
            serial_pipeline={
                "stages": [
                    {
                        "deploy_parameters": [{
                            "values": {
                                "deployParameterKey": "deployParameterValue",
                            },
                            "match_target_labels": {},
                        }],
                        "profiles": [
                            "example-profile-one",
                            "example-profile-two",
                        ],
                        "target_id": "example-target-one",
                    },
                    {
                        "profiles": [],
                        "target_id": "example-target-two",
                    },
                ],
            },
            annotations={
                "my_first_annotation": "example-annotation-1",
                "my_second_annotation": "example-annotation-2",
            },
            labels={
                "my_first_label": "example-label-1",
                "my_second_label": "example-label-2",
            })
        ```
        ### Delivery_pipeline
        Creates a basic Cloud Deploy delivery pipeline
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.clouddeploy.DeliveryPipeline("primary",
            location="us-west1",
            name="pipeline",
            description="basic description",
            project="my-project-name",
            serial_pipeline={
                "stages": [
                    {
                        "deploy_parameters": [{
                            "values": {
                                "deployParameterKey": "deployParameterValue",
                            },
                            "match_target_labels": {},
                        }],
                        "profiles": [
                            "example-profile-one",
                            "example-profile-two",
                        ],
                        "target_id": "example-target-one",
                    },
                    {
                        "profiles": [],
                        "target_id": "example-target-two",
                    },
                ],
            },
            annotations={
                "my_first_annotation": "example-annotation-1",
                "my_second_annotation": "example-annotation-2",
            },
            labels={
                "my_first_label": "example-label-1",
                "my_second_label": "example-label-2",
            })
        ```
        ### Verify_delivery_pipeline
        tests creating and updating a delivery pipeline with deployment verification strategy
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.clouddeploy.DeliveryPipeline("primary",
            location="us-west1",
            name="pipeline",
            description="basic description",
            project="my-project-name",
            serial_pipeline={
                "stages": [
                    {
                        "deploy_parameters": [{
                            "values": {
                                "deployParameterKey": "deployParameterValue",
                            },
                            "match_target_labels": {},
                        }],
                        "profiles": [
                            "example-profile-one",
                            "example-profile-two",
                        ],
                        "target_id": "example-target-one",
                    },
                    {
                        "profiles": [],
                        "target_id": "example-target-two",
                    },
                ],
            },
            annotations={
                "my_first_annotation": "example-annotation-1",
                "my_second_annotation": "example-annotation-2",
            },
            labels={
                "my_first_label": "example-label-1",
                "my_second_label": "example-label-2",
            })
        ```

        ## Import

        DeliveryPipeline can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/deliveryPipelines/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, DeliveryPipeline can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:clouddeploy/deliveryPipeline:DeliveryPipeline default projects/{{project}}/locations/{{location}}/deliveryPipelines/{{name}}
        ```

        ```sh
        $ pulumi import gcp:clouddeploy/deliveryPipeline:DeliveryPipeline default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:clouddeploy/deliveryPipeline:DeliveryPipeline default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] description: Description of the `DeliveryPipeline`. Max length is 255 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location for the resource
        :param pulumi.Input[_builtins.str] name: Name of the `DeliveryPipeline`. Format is `a-z?`.
               
               
               
               - - -
        :param pulumi.Input[_builtins.str] project: The project for the resource
        :param pulumi.Input[Union['DeliveryPipelineSerialPipelineArgs', 'DeliveryPipelineSerialPipelineArgsDict']] serial_pipeline: SerialPipeline defines a sequential set of stages for a `DeliveryPipeline`.
        :param pulumi.Input[_builtins.bool] suspended: When suspended, no new releases or rollouts can be created, but in-progress ones will complete.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeliveryPipelineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Cloud Deploy `DeliveryPipeline` resource

        ## Example Usage

        ### Canary_delivery_pipeline
        Creates a basic Cloud Deploy delivery pipeline
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.clouddeploy.DeliveryPipeline("primary",
            location="us-west1",
            name="pipeline",
            description="basic description",
            project="my-project-name",
            serial_pipeline={
                "stages": [
                    {
                        "deploy_parameters": [{
                            "values": {
                                "deployParameterKey": "deployParameterValue",
                            },
                            "match_target_labels": {},
                        }],
                        "profiles": [
                            "example-profile-one",
                            "example-profile-two",
                        ],
                        "target_id": "example-target-one",
                    },
                    {
                        "profiles": [],
                        "target_id": "example-target-two",
                    },
                ],
            },
            annotations={
                "my_first_annotation": "example-annotation-1",
                "my_second_annotation": "example-annotation-2",
            },
            labels={
                "my_first_label": "example-label-1",
                "my_second_label": "example-label-2",
            })
        ```
        ### Canary_service_networking_delivery_pipeline
        Creates a basic Cloud Deploy delivery pipeline
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.clouddeploy.DeliveryPipeline("primary",
            location="us-west1",
            name="pipeline",
            description="basic description",
            project="my-project-name",
            serial_pipeline={
                "stages": [
                    {
                        "deploy_parameters": [{
                            "values": {
                                "deployParameterKey": "deployParameterValue",
                            },
                            "match_target_labels": {},
                        }],
                        "profiles": [
                            "example-profile-one",
                            "example-profile-two",
                        ],
                        "target_id": "example-target-one",
                    },
                    {
                        "profiles": [],
                        "target_id": "example-target-two",
                    },
                ],
            },
            annotations={
                "my_first_annotation": "example-annotation-1",
                "my_second_annotation": "example-annotation-2",
            },
            labels={
                "my_first_label": "example-label-1",
                "my_second_label": "example-label-2",
            })
        ```
        ### Canaryrun_delivery_pipeline
        Creates a basic Cloud Deploy delivery pipeline
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.clouddeploy.DeliveryPipeline("primary",
            location="us-west1",
            name="pipeline",
            description="basic description",
            project="my-project-name",
            serial_pipeline={
                "stages": [
                    {
                        "deploy_parameters": [{
                            "values": {
                                "deployParameterKey": "deployParameterValue",
                            },
                            "match_target_labels": {},
                        }],
                        "profiles": [
                            "example-profile-one",
                            "example-profile-two",
                        ],
                        "target_id": "example-target-one",
                    },
                    {
                        "profiles": [],
                        "target_id": "example-target-two",
                    },
                ],
            },
            annotations={
                "my_first_annotation": "example-annotation-1",
                "my_second_annotation": "example-annotation-2",
            },
            labels={
                "my_first_label": "example-label-1",
                "my_second_label": "example-label-2",
            })
        ```
        ### Delivery_pipeline
        Creates a basic Cloud Deploy delivery pipeline
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.clouddeploy.DeliveryPipeline("primary",
            location="us-west1",
            name="pipeline",
            description="basic description",
            project="my-project-name",
            serial_pipeline={
                "stages": [
                    {
                        "deploy_parameters": [{
                            "values": {
                                "deployParameterKey": "deployParameterValue",
                            },
                            "match_target_labels": {},
                        }],
                        "profiles": [
                            "example-profile-one",
                            "example-profile-two",
                        ],
                        "target_id": "example-target-one",
                    },
                    {
                        "profiles": [],
                        "target_id": "example-target-two",
                    },
                ],
            },
            annotations={
                "my_first_annotation": "example-annotation-1",
                "my_second_annotation": "example-annotation-2",
            },
            labels={
                "my_first_label": "example-label-1",
                "my_second_label": "example-label-2",
            })
        ```
        ### Verify_delivery_pipeline
        tests creating and updating a delivery pipeline with deployment verification strategy
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.clouddeploy.DeliveryPipeline("primary",
            location="us-west1",
            name="pipeline",
            description="basic description",
            project="my-project-name",
            serial_pipeline={
                "stages": [
                    {
                        "deploy_parameters": [{
                            "values": {
                                "deployParameterKey": "deployParameterValue",
                            },
                            "match_target_labels": {},
                        }],
                        "profiles": [
                            "example-profile-one",
                            "example-profile-two",
                        ],
                        "target_id": "example-target-one",
                    },
                    {
                        "profiles": [],
                        "target_id": "example-target-two",
                    },
                ],
            },
            annotations={
                "my_first_annotation": "example-annotation-1",
                "my_second_annotation": "example-annotation-2",
            },
            labels={
                "my_first_label": "example-label-1",
                "my_second_label": "example-label-2",
            })
        ```

        ## Import

        DeliveryPipeline can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/deliveryPipelines/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, DeliveryPipeline can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:clouddeploy/deliveryPipeline:DeliveryPipeline default projects/{{project}}/locations/{{location}}/deliveryPipelines/{{name}}
        ```

        ```sh
        $ pulumi import gcp:clouddeploy/deliveryPipeline:DeliveryPipeline default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:clouddeploy/deliveryPipeline:DeliveryPipeline default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param DeliveryPipelineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeliveryPipelineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 serial_pipeline: Optional[pulumi.Input[Union['DeliveryPipelineSerialPipelineArgs', 'DeliveryPipelineSerialPipelineArgsDict']]] = None,
                 suspended: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeliveryPipelineArgs.__new__(DeliveryPipelineArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["serial_pipeline"] = serial_pipeline
            __props__.__dict__["suspended"] = suspended
            __props__.__dict__["conditions"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DeliveryPipeline, __self__).__init__(
            'gcp:clouddeploy/deliveryPipeline:DeliveryPipeline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeliveryPipelineConditionArgs', 'DeliveryPipelineConditionArgsDict']]]]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            serial_pipeline: Optional[pulumi.Input[Union['DeliveryPipelineSerialPipelineArgs', 'DeliveryPipelineSerialPipelineArgsDict']]] = None,
            suspended: Optional[pulumi.Input[_builtins.bool]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'DeliveryPipeline':
        """
        Get an existing DeliveryPipeline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeliveryPipelineConditionArgs', 'DeliveryPipelineConditionArgsDict']]]] conditions: Output only. Information around the state of the Delivery Pipeline.
        :param pulumi.Input[_builtins.str] create_time: Output only. Time at which the pipeline was created.
        :param pulumi.Input[_builtins.str] description: Description of the `DeliveryPipeline`. Max length is 255 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] etag: This checksum is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location for the resource
        :param pulumi.Input[_builtins.str] name: Name of the `DeliveryPipeline`. Format is `a-z?`.
               
               
               
               - - -
        :param pulumi.Input[_builtins.str] project: The project for the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource and default labels configured on the provider.
        :param pulumi.Input[Union['DeliveryPipelineSerialPipelineArgs', 'DeliveryPipelineSerialPipelineArgsDict']] serial_pipeline: SerialPipeline defines a sequential set of stages for a `DeliveryPipeline`.
        :param pulumi.Input[_builtins.bool] suspended: When suspended, no new releases or rollouts can be created, but in-progress ones will complete.
        :param pulumi.Input[_builtins.str] uid: Output only. Unique identifier of the `DeliveryPipeline`.
        :param pulumi.Input[_builtins.str] update_time: Output only. Most recent time at which the pipeline was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeliveryPipelineState.__new__(_DeliveryPipelineState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["etag"] = etag
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["serial_pipeline"] = serial_pipeline
        __props__.__dict__["suspended"] = suspended
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return DeliveryPipeline(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.

        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Sequence['outputs.DeliveryPipelineCondition']]:
        """
        Output only. Information around the state of the Delivery Pipeline.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Time at which the pipeline was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the `DeliveryPipeline`. Max length is 255 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        This checksum is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the `DeliveryPipeline`. Format is `a-z?`.



        - - -
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="serialPipeline")
    def serial_pipeline(self) -> pulumi.Output[Optional['outputs.DeliveryPipelineSerialPipeline']]:
        """
        SerialPipeline defines a sequential set of stages for a `DeliveryPipeline`.
        """
        return pulumi.get(self, "serial_pipeline")

    @_builtins.property
    @pulumi.getter
    def suspended(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        When suspended, no new releases or rollouts can be created, but in-progress ones will complete.
        """
        return pulumi.get(self, "suspended")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Unique identifier of the `DeliveryPipeline`.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Most recent time at which the pipeline was updated.
        """
        return pulumi.get(self, "update_time")

