# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DomainMappingMetadata',
    'DomainMappingSpec',
    'DomainMappingStatus',
    'DomainMappingStatusCondition',
    'DomainMappingStatusResourceRecord',
    'IamBindingCondition',
    'IamMemberCondition',
    'ServiceMetadata',
    'ServiceStatus',
    'ServiceStatusCondition',
    'ServiceStatusTraffic',
    'ServiceTemplate',
    'ServiceTemplateMetadata',
    'ServiceTemplateSpec',
    'ServiceTemplateSpecContainer',
    'ServiceTemplateSpecContainerEnv',
    'ServiceTemplateSpecContainerEnvFrom',
    'ServiceTemplateSpecContainerEnvFromConfigMapRef',
    'ServiceTemplateSpecContainerEnvFromConfigMapRefLocalObjectReference',
    'ServiceTemplateSpecContainerEnvFromSecretRef',
    'ServiceTemplateSpecContainerEnvFromSecretRefLocalObjectReference',
    'ServiceTemplateSpecContainerEnvValueFrom',
    'ServiceTemplateSpecContainerEnvValueFromSecretKeyRef',
    'ServiceTemplateSpecContainerLivenessProbe',
    'ServiceTemplateSpecContainerLivenessProbeGrpc',
    'ServiceTemplateSpecContainerLivenessProbeHttpGet',
    'ServiceTemplateSpecContainerLivenessProbeHttpGetHttpHeader',
    'ServiceTemplateSpecContainerPort',
    'ServiceTemplateSpecContainerResources',
    'ServiceTemplateSpecContainerStartupProbe',
    'ServiceTemplateSpecContainerStartupProbeGrpc',
    'ServiceTemplateSpecContainerStartupProbeHttpGet',
    'ServiceTemplateSpecContainerStartupProbeHttpGetHttpHeader',
    'ServiceTemplateSpecContainerStartupProbeTcpSocket',
    'ServiceTemplateSpecContainerVolumeMount',
    'ServiceTemplateSpecVolume',
    'ServiceTemplateSpecVolumeCsi',
    'ServiceTemplateSpecVolumeEmptyDir',
    'ServiceTemplateSpecVolumeNfs',
    'ServiceTemplateSpecVolumeSecret',
    'ServiceTemplateSpecVolumeSecretItem',
    'ServiceTraffic',
    'GetServiceMetadataResult',
    'GetServiceStatusResult',
    'GetServiceStatusConditionResult',
    'GetServiceStatusTrafficResult',
    'GetServiceTemplateResult',
    'GetServiceTemplateMetadataResult',
    'GetServiceTemplateSpecResult',
    'GetServiceTemplateSpecContainerResult',
    'GetServiceTemplateSpecContainerEnvResult',
    'GetServiceTemplateSpecContainerEnvFromResult',
    'GetServiceTemplateSpecContainerEnvFromConfigMapRefResult',
    'GetServiceTemplateSpecContainerEnvFromConfigMapRefLocalObjectReferenceResult',
    'GetServiceTemplateSpecContainerEnvFromSecretRefResult',
    'GetServiceTemplateSpecContainerEnvFromSecretRefLocalObjectReferenceResult',
    'GetServiceTemplateSpecContainerEnvValueFromResult',
    'GetServiceTemplateSpecContainerEnvValueFromSecretKeyRefResult',
    'GetServiceTemplateSpecContainerLivenessProbeResult',
    'GetServiceTemplateSpecContainerLivenessProbeGrpcResult',
    'GetServiceTemplateSpecContainerLivenessProbeHttpGetResult',
    'GetServiceTemplateSpecContainerLivenessProbeHttpGetHttpHeaderResult',
    'GetServiceTemplateSpecContainerPortResult',
    'GetServiceTemplateSpecContainerResourceResult',
    'GetServiceTemplateSpecContainerStartupProbeResult',
    'GetServiceTemplateSpecContainerStartupProbeGrpcResult',
    'GetServiceTemplateSpecContainerStartupProbeHttpGetResult',
    'GetServiceTemplateSpecContainerStartupProbeHttpGetHttpHeaderResult',
    'GetServiceTemplateSpecContainerStartupProbeTcpSocketResult',
    'GetServiceTemplateSpecContainerVolumeMountResult',
    'GetServiceTemplateSpecVolumeResult',
    'GetServiceTemplateSpecVolumeCsiResult',
    'GetServiceTemplateSpecVolumeEmptyDirResult',
    'GetServiceTemplateSpecVolumeNfResult',
    'GetServiceTemplateSpecVolumeSecretResult',
    'GetServiceTemplateSpecVolumeSecretItemResult',
    'GetServiceTrafficResult',
]

@pulumi.output_type
class DomainMappingMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "effectiveAnnotations":
            suggest = "effective_annotations"
        elif key == "effectiveLabels":
            suggest = "effective_labels"
        elif key == "pulumiLabels":
            suggest = "pulumi_labels"
        elif key == "resourceVersion":
            suggest = "resource_version"
        elif key == "selfLink":
            suggest = "self_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainMappingMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainMappingMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainMappingMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 namespace: _builtins.str,
                 annotations: Optional[Mapping[str, _builtins.str]] = None,
                 effective_annotations: Optional[Mapping[str, _builtins.str]] = None,
                 effective_labels: Optional[Mapping[str, _builtins.str]] = None,
                 generation: Optional[_builtins.int] = None,
                 labels: Optional[Mapping[str, _builtins.str]] = None,
                 pulumi_labels: Optional[Mapping[str, _builtins.str]] = None,
                 resource_version: Optional[_builtins.str] = None,
                 self_link: Optional[_builtins.str] = None,
                 uid: Optional[_builtins.str] = None):
        """
        :param _builtins.str namespace: In Cloud Run the namespace must be equal to either the
               project ID or project number.
        :param Mapping[str, _builtins.str] annotations: Annotations is a key value map stored with a resource that
               may be set by external tools to store and retrieve arbitrary metadata.
               More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
               **Note**: The Cloud Run API may add additional annotations that were not provided in your config.
               If the provider plan shows a diff where a server-side annotation is added, you can add it to your config
               or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param Mapping[str, _builtins.str] effective_labels: (Output)
               All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param _builtins.int generation: (Output)
               A sequence number representing a specific generation of the desired state.
        :param Mapping[str, _builtins.str] labels: Map of string keys and values that can be used to organize and categorize
               (scope and select) objects. May match selectors of replication controllers
               and routes.
               More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param Mapping[str, _builtins.str] pulumi_labels: (Output)
               The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param _builtins.str resource_version: (Output)
               An opaque value that represents the internal version of this object that
               can be used by clients to determine when objects have changed. May be used
               for optimistic concurrency, change detection, and the watch operation on a
               resource or set of resources. They may only be valid for a
               particular resource or set of resources.
               More info:
               https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency
        :param _builtins.str self_link: (Output)
               SelfLink is a URL representing this object.
        :param _builtins.str uid: (Output)
               UID is a unique id generated by the server on successful creation of a resource and is not
               allowed to change on PUT operations.
               More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids
        """
        pulumi.set(__self__, "namespace", namespace)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if resource_version is not None:
            pulumi.set(__self__, "resource_version", resource_version)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        In Cloud Run the namespace must be equal to either the
        project ID or project number.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Annotations is a key value map stored with a resource that
        may be set by external tools to store and retrieve arbitrary metadata.
        More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
        **Note**: The Cloud Run API may add additional annotations that were not provided in your config.
        If the provider plan shows a diff where a server-side annotation is added, you can add it to your config
        or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        (Output)
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def generation(self) -> Optional[_builtins.int]:
        """
        (Output)
        A sequence number representing a specific generation of the desired state.
        """
        return pulumi.get(self, "generation")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Map of string keys and values that can be used to organize and categorize
        (scope and select) objects. May match selectors of replication controllers
        and routes.
        More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        (Output)
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> Optional[_builtins.str]:
        """
        (Output)
        An opaque value that represents the internal version of this object that
        can be used by clients to determine when objects have changed. May be used
        for optimistic concurrency, change detection, and the watch operation on a
        resource or set of resources. They may only be valid for a
        particular resource or set of resources.
        More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency
        """
        return pulumi.get(self, "resource_version")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[_builtins.str]:
        """
        (Output)
        SelfLink is a URL representing this object.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[_builtins.str]:
        """
        (Output)
        UID is a unique id generated by the server on successful creation of a resource and is not
        allowed to change on PUT operations.
        More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class DomainMappingSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "routeName":
            suggest = "route_name"
        elif key == "certificateMode":
            suggest = "certificate_mode"
        elif key == "forceOverride":
            suggest = "force_override"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainMappingSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainMappingSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainMappingSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 route_name: _builtins.str,
                 certificate_mode: Optional[_builtins.str] = None,
                 force_override: Optional[_builtins.bool] = None):
        """
        :param _builtins.str route_name: The name of the Cloud Run Service that this DomainMapping applies to.
               The route must exist.
        :param _builtins.str certificate_mode: The mode of the certificate.
               Default value is `AUTOMATIC`.
               Possible values are: `NONE`, `AUTOMATIC`.
        :param _builtins.bool force_override: If set, the mapping will override any mapping set before this spec was set.
               It is recommended that the user leaves this empty to receive an error
               warning about a potential conflict and only set it once the respective UI
               has given such a warning.
        """
        pulumi.set(__self__, "route_name", route_name)
        if certificate_mode is not None:
            pulumi.set(__self__, "certificate_mode", certificate_mode)
        if force_override is not None:
            pulumi.set(__self__, "force_override", force_override)

    @_builtins.property
    @pulumi.getter(name="routeName")
    def route_name(self) -> _builtins.str:
        """
        The name of the Cloud Run Service that this DomainMapping applies to.
        The route must exist.
        """
        return pulumi.get(self, "route_name")

    @_builtins.property
    @pulumi.getter(name="certificateMode")
    def certificate_mode(self) -> Optional[_builtins.str]:
        """
        The mode of the certificate.
        Default value is `AUTOMATIC`.
        Possible values are: `NONE`, `AUTOMATIC`.
        """
        return pulumi.get(self, "certificate_mode")

    @_builtins.property
    @pulumi.getter(name="forceOverride")
    def force_override(self) -> Optional[_builtins.bool]:
        """
        If set, the mapping will override any mapping set before this spec was set.
        It is recommended that the user leaves this empty to receive an error
        warning about a potential conflict and only set it once the respective UI
        has given such a warning.
        """
        return pulumi.get(self, "force_override")


@pulumi.output_type
class DomainMappingStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mappedRouteName":
            suggest = "mapped_route_name"
        elif key == "observedGeneration":
            suggest = "observed_generation"
        elif key == "resourceRecords":
            suggest = "resource_records"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainMappingStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainMappingStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainMappingStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.DomainMappingStatusCondition']] = None,
                 mapped_route_name: Optional[_builtins.str] = None,
                 observed_generation: Optional[_builtins.int] = None,
                 resource_records: Optional[Sequence['outputs.DomainMappingStatusResourceRecord']] = None):
        """
        :param Sequence['DomainMappingStatusConditionArgs'] conditions: (Output)
               Array of observed DomainMappingConditions, indicating the current state
               of the DomainMapping.
               Structure is documented below.
        :param _builtins.str mapped_route_name: (Output)
               The name of the route that the mapping currently points to.
        :param _builtins.int observed_generation: (Output)
               ObservedGeneration is the 'Generation' of the DomainMapping that
               was last processed by the controller.
        :param Sequence['DomainMappingStatusResourceRecordArgs'] resource_records: The resource records required to configure this domain mapping. These
               records must be added to the domain's DNS configuration in order to
               serve the application via this domain mapping.
               Structure is documented below.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if mapped_route_name is not None:
            pulumi.set(__self__, "mapped_route_name", mapped_route_name)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if resource_records is not None:
            pulumi.set(__self__, "resource_records", resource_records)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.DomainMappingStatusCondition']]:
        """
        (Output)
        Array of observed DomainMappingConditions, indicating the current state
        of the DomainMapping.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="mappedRouteName")
    def mapped_route_name(self) -> Optional[_builtins.str]:
        """
        (Output)
        The name of the route that the mapping currently points to.
        """
        return pulumi.get(self, "mapped_route_name")

    @_builtins.property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[_builtins.int]:
        """
        (Output)
        ObservedGeneration is the 'Generation' of the DomainMapping that
        was last processed by the controller.
        """
        return pulumi.get(self, "observed_generation")

    @_builtins.property
    @pulumi.getter(name="resourceRecords")
    def resource_records(self) -> Optional[Sequence['outputs.DomainMappingStatusResourceRecord']]:
        """
        The resource records required to configure this domain mapping. These
        records must be added to the domain's DNS configuration in order to
        serve the application via this domain mapping.
        Structure is documented below.
        """
        return pulumi.get(self, "resource_records")


@pulumi.output_type
class DomainMappingStatusCondition(dict):
    def __init__(__self__, *,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str message: (Output)
               Human readable message indicating details about the current status.
        :param _builtins.str reason: (Output)
               One-word CamelCase reason for the condition's current status.
        :param _builtins.str status: (Output)
               Status of the condition, one of True, False, Unknown.
        :param _builtins.str type: Resource record type. Example: `AAAA`.
               Possible values are: `A`, `AAAA`, `CNAME`.
        """
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        (Output)
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        (Output)
        One-word CamelCase reason for the condition's current status.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        (Output)
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Resource record type. Example: `AAAA`.
        Possible values are: `A`, `AAAA`, `CNAME`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DomainMappingStatusResourceRecord(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 rrdata: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Name should be a [verified](https://support.google.com/webmasters/answer/9008080) domain
        :param _builtins.str rrdata: (Output)
               Data for this record. Values vary by record type, as defined in RFC 1035
               (section 5) and RFC 1034 (section 3.6.1).
        :param _builtins.str type: Resource record type. Example: `AAAA`.
               Possible values are: `A`, `AAAA`, `CNAME`.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rrdata is not None:
            pulumi.set(__self__, "rrdata", rrdata)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name should be a [verified](https://support.google.com/webmasters/answer/9008080) domain
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def rrdata(self) -> Optional[_builtins.str]:
        """
        (Output)
        Data for this record. Values vary by record type, as defined in RFC 1035
        (section 5) and RFC 1034 (section 3.6.1).
        """
        return pulumi.get(self, "rrdata")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Resource record type. Example: `AAAA`.
        Possible values are: `A`, `AAAA`, `CNAME`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class IamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class IamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class ServiceMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "effectiveAnnotations":
            suggest = "effective_annotations"
        elif key == "effectiveLabels":
            suggest = "effective_labels"
        elif key == "pulumiLabels":
            suggest = "pulumi_labels"
        elif key == "resourceVersion":
            suggest = "resource_version"
        elif key == "selfLink":
            suggest = "self_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 annotations: Optional[Mapping[str, _builtins.str]] = None,
                 effective_annotations: Optional[Mapping[str, _builtins.str]] = None,
                 effective_labels: Optional[Mapping[str, _builtins.str]] = None,
                 generation: Optional[_builtins.int] = None,
                 labels: Optional[Mapping[str, _builtins.str]] = None,
                 namespace: Optional[_builtins.str] = None,
                 pulumi_labels: Optional[Mapping[str, _builtins.str]] = None,
                 resource_version: Optional[_builtins.str] = None,
                 self_link: Optional[_builtins.str] = None,
                 uid: Optional[_builtins.str] = None):
        """
        :param Mapping[str, _builtins.str] annotations: Annotations is a key value map stored with a resource that
               may be set by external tools to store and retrieve arbitrary metadata.
               More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
               **Note**: The Cloud Run API may add additional annotations that were not provided in your config.
               If the provider plan shows a diff where a server-side annotation is added, you can add it to your config
               or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
               Annotations with `run.googleapis.com/` and `autoscaling.knative.dev` are restricted. Use the following annotation
               keys to configure features on a Service:
               - `run.googleapis.com/binary-authorization-breakglass` sets the [Binary Authorization breakglass](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--breakglass).
               - `run.googleapis.com/binary-authorization` sets the [Binary Authorization](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--binary-authorization).
               - `run.googleapis.com/client-name` sets the client name calling the Cloud Run API.
               - `run.googleapis.com/custom-audiences` sets the [custom audiences](https://cloud.google.com/sdk/gcloud/reference/alpha/run/deploy#--add-custom-audiences)
               that can be used in the audience field of ID token for authenticated requests.
               - `run.googleapis.com/description` sets a user defined description for the Service.
               - `run.googleapis.com/ingress` sets the [ingress settings](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--ingress)
               for the Service. For example, `"run.googleapis.com/ingress" = "all"`.
               - `run.googleapis.com/launch-stage` sets the [launch stage](https://cloud.google.com/run/docs/troubleshooting#launch-stage-validation)
               when a preview feature is used. For example, `"run.googleapis.com/launch-stage": "BETA"`
               - `run.googleapis.com/minScale` sets the [minimum number of container instances](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--min) of the Service.
               - `run.googleapis.com/scalingMode` sets the type of scaling mode for the service. The supported values for scaling mode are "manual" and "automatic". If not provided, it defaults to "automatic".
               - `run.googleapis.com/manualInstanceCount` sets the total instance count for the service in manual scaling mode. This number of instances is divided among all revisions with specified traffic based on the percent of traffic they are receiving.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param Mapping[str, _builtins.str] effective_labels: (Output)
               All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param _builtins.int generation: (Output)
               A sequence number representing a specific generation of the desired state.
        :param Mapping[str, _builtins.str] labels: Map of string keys and values that can be used to organize and categorize
               (scope and select) objects. May match selectors of replication controllers
               and routes.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param _builtins.str namespace: In Cloud Run the namespace must be equal to either the
               project ID or project number.
        :param Mapping[str, _builtins.str] pulumi_labels: (Output)
               The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param _builtins.str resource_version: (Output)
               An opaque value that represents the internal version of this object that
               can be used by clients to determine when objects have changed. May be used
               for optimistic concurrency, change detection, and the watch operation on a
               resource or set of resources. They may only be valid for a
               particular resource or set of resources.
        :param _builtins.str self_link: (Output)
               SelfLink is a URL representing this object.
        :param _builtins.str uid: (Output)
               UID is a unique id generated by the server on successful creation of a resource and is not
               allowed to change on PUT operations.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if resource_version is not None:
            pulumi.set(__self__, "resource_version", resource_version)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Annotations is a key value map stored with a resource that
        may be set by external tools to store and retrieve arbitrary metadata.
        More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
        **Note**: The Cloud Run API may add additional annotations that were not provided in your config.
        If the provider plan shows a diff where a server-side annotation is added, you can add it to your config
        or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
        Annotations with `run.googleapis.com/` and `autoscaling.knative.dev` are restricted. Use the following annotation
        keys to configure features on a Service:
        - `run.googleapis.com/binary-authorization-breakglass` sets the [Binary Authorization breakglass](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--breakglass).
        - `run.googleapis.com/binary-authorization` sets the [Binary Authorization](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--binary-authorization).
        - `run.googleapis.com/client-name` sets the client name calling the Cloud Run API.
        - `run.googleapis.com/custom-audiences` sets the [custom audiences](https://cloud.google.com/sdk/gcloud/reference/alpha/run/deploy#--add-custom-audiences)
        that can be used in the audience field of ID token for authenticated requests.
        - `run.googleapis.com/description` sets a user defined description for the Service.
        - `run.googleapis.com/ingress` sets the [ingress settings](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--ingress)
        for the Service. For example, `"run.googleapis.com/ingress" = "all"`.
        - `run.googleapis.com/launch-stage` sets the [launch stage](https://cloud.google.com/run/docs/troubleshooting#launch-stage-validation)
        when a preview feature is used. For example, `"run.googleapis.com/launch-stage": "BETA"`
        - `run.googleapis.com/minScale` sets the [minimum number of container instances](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--min) of the Service.
        - `run.googleapis.com/scalingMode` sets the type of scaling mode for the service. The supported values for scaling mode are "manual" and "automatic". If not provided, it defaults to "automatic".
        - `run.googleapis.com/manualInstanceCount` sets the total instance count for the service in manual scaling mode. This number of instances is divided among all revisions with specified traffic based on the percent of traffic they are receiving.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        (Output)
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def generation(self) -> Optional[_builtins.int]:
        """
        (Output)
        A sequence number representing a specific generation of the desired state.
        """
        return pulumi.get(self, "generation")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Map of string keys and values that can be used to organize and categorize
        (scope and select) objects. May match selectors of replication controllers
        and routes.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        In Cloud Run the namespace must be equal to either the
        project ID or project number.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        (Output)
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> Optional[_builtins.str]:
        """
        (Output)
        An opaque value that represents the internal version of this object that
        can be used by clients to determine when objects have changed. May be used
        for optimistic concurrency, change detection, and the watch operation on a
        resource or set of resources. They may only be valid for a
        particular resource or set of resources.
        """
        return pulumi.get(self, "resource_version")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[_builtins.str]:
        """
        (Output)
        SelfLink is a URL representing this object.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[_builtins.str]:
        """
        (Output)
        UID is a unique id generated by the server on successful creation of a resource and is not
        allowed to change on PUT operations.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ServiceStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "latestCreatedRevisionName":
            suggest = "latest_created_revision_name"
        elif key == "latestReadyRevisionName":
            suggest = "latest_ready_revision_name"
        elif key == "observedGeneration":
            suggest = "observed_generation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.ServiceStatusCondition']] = None,
                 latest_created_revision_name: Optional[_builtins.str] = None,
                 latest_ready_revision_name: Optional[_builtins.str] = None,
                 observed_generation: Optional[_builtins.int] = None,
                 traffics: Optional[Sequence['outputs.ServiceStatusTraffic']] = None,
                 url: Optional[_builtins.str] = None):
        """
        :param Sequence['ServiceStatusConditionArgs'] conditions: (Output)
               Array of observed Service Conditions, indicating the current ready state of the service.
               Structure is documented below.
        :param _builtins.str latest_created_revision_name: (Output)
               From ConfigurationStatus. LatestCreatedRevisionName is the last revision that was created
               from this Service's Configuration. It might not be ready yet, for that use
               LatestReadyRevisionName.
        :param _builtins.str latest_ready_revision_name: (Output)
               From ConfigurationStatus. LatestReadyRevisionName holds the name of the latest Revision
               stamped out from this Service's Configuration that has had its "Ready" condition become
               "True".
        :param _builtins.int observed_generation: (Output)
               ObservedGeneration is the 'Generation' of the Route that was last processed by the
               controller.
               Clients polling for completed reconciliation should poll until observedGeneration =
               metadata.generation and the Ready condition's status is True or False.
        :param Sequence['ServiceStatusTrafficArgs'] traffics: Traffic specifies how to distribute traffic over a collection of Knative Revisions
               and Configurations
               Structure is documented below.
        :param _builtins.str url: (Output)
               URL displays the URL for accessing tagged traffic targets. URL is displayed in status,
               and is disallowed on spec. URL must contain a scheme (e.g. http://) and a hostname,
               but may not contain anything else (e.g. basic auth, url path, etc.)
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if latest_created_revision_name is not None:
            pulumi.set(__self__, "latest_created_revision_name", latest_created_revision_name)
        if latest_ready_revision_name is not None:
            pulumi.set(__self__, "latest_ready_revision_name", latest_ready_revision_name)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if traffics is not None:
            pulumi.set(__self__, "traffics", traffics)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.ServiceStatusCondition']]:
        """
        (Output)
        Array of observed Service Conditions, indicating the current ready state of the service.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="latestCreatedRevisionName")
    def latest_created_revision_name(self) -> Optional[_builtins.str]:
        """
        (Output)
        From ConfigurationStatus. LatestCreatedRevisionName is the last revision that was created
        from this Service's Configuration. It might not be ready yet, for that use
        LatestReadyRevisionName.
        """
        return pulumi.get(self, "latest_created_revision_name")

    @_builtins.property
    @pulumi.getter(name="latestReadyRevisionName")
    def latest_ready_revision_name(self) -> Optional[_builtins.str]:
        """
        (Output)
        From ConfigurationStatus. LatestReadyRevisionName holds the name of the latest Revision
        stamped out from this Service's Configuration that has had its "Ready" condition become
        "True".
        """
        return pulumi.get(self, "latest_ready_revision_name")

    @_builtins.property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[_builtins.int]:
        """
        (Output)
        ObservedGeneration is the 'Generation' of the Route that was last processed by the
        controller.
        Clients polling for completed reconciliation should poll until observedGeneration =
        metadata.generation and the Ready condition's status is True or False.
        """
        return pulumi.get(self, "observed_generation")

    @_builtins.property
    @pulumi.getter
    def traffics(self) -> Optional[Sequence['outputs.ServiceStatusTraffic']]:
        """
        Traffic specifies how to distribute traffic over a collection of Knative Revisions
        and Configurations
        Structure is documented below.
        """
        return pulumi.get(self, "traffics")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        """
        (Output)
        URL displays the URL for accessing tagged traffic targets. URL is displayed in status,
        and is disallowed on spec. URL must contain a scheme (e.g. http://) and a hostname,
        but may not contain anything else (e.g. basic auth, url path, etc.)
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ServiceStatusCondition(dict):
    def __init__(__self__, *,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str message: (Output)
               Human readable message indicating details about the current status.
        :param _builtins.str reason: (Output)
               One-word CamelCase reason for the condition's current status.
        :param _builtins.str status: (Output)
               Status of the condition, one of True, False, Unknown.
        :param _builtins.str type: (Output)
               Type of domain mapping condition.
        """
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        (Output)
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        (Output)
        One-word CamelCase reason for the condition's current status.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        (Output)
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        (Output)
        Type of domain mapping condition.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceStatusTraffic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "latestRevision":
            suggest = "latest_revision"
        elif key == "revisionName":
            suggest = "revision_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceStatusTraffic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceStatusTraffic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceStatusTraffic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 latest_revision: Optional[_builtins.bool] = None,
                 percent: Optional[_builtins.int] = None,
                 revision_name: Optional[_builtins.str] = None,
                 tag: Optional[_builtins.str] = None,
                 url: Optional[_builtins.str] = None):
        """
        :param _builtins.bool latest_revision: LatestRevision may be optionally provided to indicate that the latest ready
               Revision of the Configuration should be used for this traffic target. When
               provided LatestRevision must be true if RevisionName is empty; it must be
               false when RevisionName is non-empty.
        :param _builtins.int percent: Percent specifies percent of the traffic to this Revision or Configuration.
        :param _builtins.str revision_name: RevisionName of a specific revision to which to send this portion of traffic.
        :param _builtins.str tag: Tag is optionally used to expose a dedicated url for referencing this target exclusively.
        :param _builtins.str url: (Output)
               URL displays the URL for accessing tagged traffic targets. URL is displayed in status,
               and is disallowed on spec. URL must contain a scheme (e.g. http://) and a hostname,
               but may not contain anything else (e.g. basic auth, url path, etc.)
        """
        if latest_revision is not None:
            pulumi.set(__self__, "latest_revision", latest_revision)
        if percent is not None:
            pulumi.set(__self__, "percent", percent)
        if revision_name is not None:
            pulumi.set(__self__, "revision_name", revision_name)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="latestRevision")
    def latest_revision(self) -> Optional[_builtins.bool]:
        """
        LatestRevision may be optionally provided to indicate that the latest ready
        Revision of the Configuration should be used for this traffic target. When
        provided LatestRevision must be true if RevisionName is empty; it must be
        false when RevisionName is non-empty.
        """
        return pulumi.get(self, "latest_revision")

    @_builtins.property
    @pulumi.getter
    def percent(self) -> Optional[_builtins.int]:
        """
        Percent specifies percent of the traffic to this Revision or Configuration.
        """
        return pulumi.get(self, "percent")

    @_builtins.property
    @pulumi.getter(name="revisionName")
    def revision_name(self) -> Optional[_builtins.str]:
        """
        RevisionName of a specific revision to which to send this portion of traffic.
        """
        return pulumi.get(self, "revision_name")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[_builtins.str]:
        """
        Tag is optionally used to expose a dedicated url for referencing this target exclusively.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        """
        (Output)
        URL displays the URL for accessing tagged traffic targets. URL is displayed in status,
        and is disallowed on spec. URL must contain a scheme (e.g. http://) and a hostname,
        but may not contain anything else (e.g. basic auth, url path, etc.)
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ServiceTemplate(dict):
    def __init__(__self__, *,
                 metadata: Optional['outputs.ServiceTemplateMetadata'] = None,
                 spec: Optional['outputs.ServiceTemplateSpec'] = None):
        """
        :param 'ServiceTemplateMetadataArgs' metadata: Optional metadata for this Revision, including labels and annotations.
               Name will be generated by the Configuration. To set minimum instances
               for this revision, use the "autoscaling.knative.dev/minScale" annotation
               key. To set maximum instances for this revision, use the
               "autoscaling.knative.dev/maxScale" annotation key. To set Cloud SQL
               connections for the revision, use the "run.googleapis.com/cloudsql-instances"
               annotation key.
               Structure is documented below.
        :param 'ServiceTemplateSpecArgs' spec: RevisionSpec holds the desired state of the Revision (from the client).
               Structure is documented below.
        """
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['outputs.ServiceTemplateMetadata']:
        """
        Optional metadata for this Revision, including labels and annotations.
        Name will be generated by the Configuration. To set minimum instances
        for this revision, use the "autoscaling.knative.dev/minScale" annotation
        key. To set maximum instances for this revision, use the
        "autoscaling.knative.dev/maxScale" annotation key. To set Cloud SQL
        connections for the revision, use the "run.googleapis.com/cloudsql-instances"
        annotation key.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.ServiceTemplateSpec']:
        """
        RevisionSpec holds the desired state of the Revision (from the client).
        Structure is documented below.
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class ServiceTemplateMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceVersion":
            suggest = "resource_version"
        elif key == "selfLink":
            suggest = "self_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 annotations: Optional[Mapping[str, _builtins.str]] = None,
                 generation: Optional[_builtins.int] = None,
                 labels: Optional[Mapping[str, _builtins.str]] = None,
                 name: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 resource_version: Optional[_builtins.str] = None,
                 self_link: Optional[_builtins.str] = None,
                 uid: Optional[_builtins.str] = None):
        """
        :param Mapping[str, _builtins.str] annotations: Annotations is a key value map stored with a resource that
               may be set by external tools to store and retrieve arbitrary metadata.
               More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
               **Note**: The Cloud Run API may add additional annotations that were not provided in your config.
               If the provider plan shows a diff where a server-side annotation is added, you can add it to your config
               or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
               Annotations with `run.googleapis.com/` and `autoscaling.knative.dev` are restricted. Use the following annotation
               keys to configure features on a Service:
               - `run.googleapis.com/binary-authorization-breakglass` sets the [Binary Authorization breakglass](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--breakglass).
               - `run.googleapis.com/binary-authorization` sets the [Binary Authorization](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--binary-authorization).
               - `run.googleapis.com/client-name` sets the client name calling the Cloud Run API.
               - `run.googleapis.com/custom-audiences` sets the [custom audiences](https://cloud.google.com/sdk/gcloud/reference/alpha/run/deploy#--add-custom-audiences)
               that can be used in the audience field of ID token for authenticated requests.
               - `run.googleapis.com/description` sets a user defined description for the Service.
               - `run.googleapis.com/ingress` sets the [ingress settings](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--ingress)
               for the Service. For example, `"run.googleapis.com/ingress" = "all"`.
               - `run.googleapis.com/launch-stage` sets the [launch stage](https://cloud.google.com/run/docs/troubleshooting#launch-stage-validation)
               when a preview feature is used. For example, `"run.googleapis.com/launch-stage": "BETA"`
               - `run.googleapis.com/minScale` sets the [minimum number of container instances](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--min) of the Service.
               - `run.googleapis.com/scalingMode` sets the type of scaling mode for the service. The supported values for scaling mode are "manual" and "automatic". If not provided, it defaults to "automatic".
               - `run.googleapis.com/manualInstanceCount` sets the total instance count for the service in manual scaling mode. This number of instances is divided among all revisions with specified traffic based on the percent of traffic they are receiving.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param _builtins.int generation: (Output)
               A sequence number representing a specific generation of the desired state.
        :param Mapping[str, _builtins.str] labels: Map of string keys and values that can be used to organize and categorize
               (scope and select) objects. May match selectors of replication controllers
               and routes.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param _builtins.str name: Name must be unique within a Google Cloud project and region.
               Is required when creating resources. Name is primarily intended
               for creation idempotence and configuration definition. Cannot be updated.
        :param _builtins.str namespace: In Cloud Run the namespace must be equal to either the
               project ID or project number.
        :param _builtins.str resource_version: (Output)
               An opaque value that represents the internal version of this object that
               can be used by clients to determine when objects have changed. May be used
               for optimistic concurrency, change detection, and the watch operation on a
               resource or set of resources. They may only be valid for a
               particular resource or set of resources.
        :param _builtins.str self_link: (Output)
               SelfLink is a URL representing this object.
        :param _builtins.str uid: (Output)
               UID is a unique id generated by the server on successful creation of a resource and is not
               allowed to change on PUT operations.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if resource_version is not None:
            pulumi.set(__self__, "resource_version", resource_version)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Annotations is a key value map stored with a resource that
        may be set by external tools to store and retrieve arbitrary metadata.
        More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
        **Note**: The Cloud Run API may add additional annotations that were not provided in your config.
        If the provider plan shows a diff where a server-side annotation is added, you can add it to your config
        or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
        Annotations with `run.googleapis.com/` and `autoscaling.knative.dev` are restricted. Use the following annotation
        keys to configure features on a Service:
        - `run.googleapis.com/binary-authorization-breakglass` sets the [Binary Authorization breakglass](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--breakglass).
        - `run.googleapis.com/binary-authorization` sets the [Binary Authorization](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--binary-authorization).
        - `run.googleapis.com/client-name` sets the client name calling the Cloud Run API.
        - `run.googleapis.com/custom-audiences` sets the [custom audiences](https://cloud.google.com/sdk/gcloud/reference/alpha/run/deploy#--add-custom-audiences)
        that can be used in the audience field of ID token for authenticated requests.
        - `run.googleapis.com/description` sets a user defined description for the Service.
        - `run.googleapis.com/ingress` sets the [ingress settings](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--ingress)
        for the Service. For example, `"run.googleapis.com/ingress" = "all"`.
        - `run.googleapis.com/launch-stage` sets the [launch stage](https://cloud.google.com/run/docs/troubleshooting#launch-stage-validation)
        when a preview feature is used. For example, `"run.googleapis.com/launch-stage": "BETA"`
        - `run.googleapis.com/minScale` sets the [minimum number of container instances](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--min) of the Service.
        - `run.googleapis.com/scalingMode` sets the type of scaling mode for the service. The supported values for scaling mode are "manual" and "automatic". If not provided, it defaults to "automatic".
        - `run.googleapis.com/manualInstanceCount` sets the total instance count for the service in manual scaling mode. This number of instances is divided among all revisions with specified traffic based on the percent of traffic they are receiving.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def generation(self) -> Optional[_builtins.int]:
        """
        (Output)
        A sequence number representing a specific generation of the desired state.
        """
        return pulumi.get(self, "generation")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Map of string keys and values that can be used to organize and categorize
        (scope and select) objects. May match selectors of replication controllers
        and routes.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name must be unique within a Google Cloud project and region.
        Is required when creating resources. Name is primarily intended
        for creation idempotence and configuration definition. Cannot be updated.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        In Cloud Run the namespace must be equal to either the
        project ID or project number.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> Optional[_builtins.str]:
        """
        (Output)
        An opaque value that represents the internal version of this object that
        can be used by clients to determine when objects have changed. May be used
        for optimistic concurrency, change detection, and the watch operation on a
        resource or set of resources. They may only be valid for a
        particular resource or set of resources.
        """
        return pulumi.get(self, "resource_version")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[_builtins.str]:
        """
        (Output)
        SelfLink is a URL representing this object.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[_builtins.str]:
        """
        (Output)
        UID is a unique id generated by the server on successful creation of a resource and is not
        allowed to change on PUT operations.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ServiceTemplateSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerConcurrency":
            suggest = "container_concurrency"
        elif key == "nodeSelector":
            suggest = "node_selector"
        elif key == "serviceAccountName":
            suggest = "service_account_name"
        elif key == "servingState":
            suggest = "serving_state"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_concurrency: Optional[_builtins.int] = None,
                 containers: Optional[Sequence['outputs.ServiceTemplateSpecContainer']] = None,
                 node_selector: Optional[Mapping[str, _builtins.str]] = None,
                 service_account_name: Optional[_builtins.str] = None,
                 serving_state: Optional[_builtins.str] = None,
                 timeout_seconds: Optional[_builtins.int] = None,
                 volumes: Optional[Sequence['outputs.ServiceTemplateSpecVolume']] = None):
        """
        :param _builtins.int container_concurrency: ContainerConcurrency specifies the maximum allowed in-flight (concurrent)
               requests per container of the Revision. If not specified or 0, defaults to 80 when
               requested CPU >= 1 and defaults to 1 when requested CPU < 1.
        :param Sequence['ServiceTemplateSpecContainerArgs'] containers: Containers defines the unit of execution for this Revision.
               Structure is documented below.
        :param Mapping[str, _builtins.str] node_selector: Node Selector describes the hardware requirements of the resources.
               Use the following node selector keys to configure features on a Revision:
               - `run.googleapis.com/accelerator` sets the [type of GPU](https://cloud.google.com/run/docs/configuring/services/gpu) required by the Revision to run.
        :param _builtins.str service_account_name: Email address of the IAM service account associated with the revision of the
               service. The service account represents the identity of the running revision,
               and determines what permissions the revision has. If not provided, the revision
               will use the project's default service account.
        :param _builtins.str serving_state: (Output, Deprecated)
               ServingState holds a value describing the state the resources
               are in for this Revision.
               It is expected
               that the system will manipulate this based on routability and load.
               
               > **Warning:** `serving_state` is deprecated and will be removed in a future major release. This field is not supported by the Cloud Run API.
        :param _builtins.int timeout_seconds: TimeoutSeconds holds the max duration the instance is allowed for responding to a request.
        :param Sequence['ServiceTemplateSpecVolumeArgs'] volumes: Volume represents a named volume in a container.
               Structure is documented below.
        """
        if container_concurrency is not None:
            pulumi.set(__self__, "container_concurrency", container_concurrency)
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)
        if service_account_name is not None:
            pulumi.set(__self__, "service_account_name", service_account_name)
        if serving_state is not None:
            pulumi.set(__self__, "serving_state", serving_state)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @_builtins.property
    @pulumi.getter(name="containerConcurrency")
    def container_concurrency(self) -> Optional[_builtins.int]:
        """
        ContainerConcurrency specifies the maximum allowed in-flight (concurrent)
        requests per container of the Revision. If not specified or 0, defaults to 80 when
        requested CPU >= 1 and defaults to 1 when requested CPU < 1.
        """
        return pulumi.get(self, "container_concurrency")

    @_builtins.property
    @pulumi.getter
    def containers(self) -> Optional[Sequence['outputs.ServiceTemplateSpecContainer']]:
        """
        Containers defines the unit of execution for this Revision.
        Structure is documented below.
        """
        return pulumi.get(self, "containers")

    @_builtins.property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Node Selector describes the hardware requirements of the resources.
        Use the following node selector keys to configure features on a Revision:
        - `run.googleapis.com/accelerator` sets the [type of GPU](https://cloud.google.com/run/docs/configuring/services/gpu) required by the Revision to run.
        """
        return pulumi.get(self, "node_selector")

    @_builtins.property
    @pulumi.getter(name="serviceAccountName")
    def service_account_name(self) -> Optional[_builtins.str]:
        """
        Email address of the IAM service account associated with the revision of the
        service. The service account represents the identity of the running revision,
        and determines what permissions the revision has. If not provided, the revision
        will use the project's default service account.
        """
        return pulumi.get(self, "service_account_name")

    @_builtins.property
    @pulumi.getter(name="servingState")
    @_utilities.deprecated("""`serving_state` is deprecated and will be removed in a future major release. This field is not supported by the Cloud Run API.""")
    def serving_state(self) -> Optional[_builtins.str]:
        """
        (Output, Deprecated)
        ServingState holds a value describing the state the resources
        are in for this Revision.
        It is expected
        that the system will manipulate this based on routability and load.

        > **Warning:** `serving_state` is deprecated and will be removed in a future major release. This field is not supported by the Cloud Run API.
        """
        return pulumi.get(self, "serving_state")

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[_builtins.int]:
        """
        TimeoutSeconds holds the max duration the instance is allowed for responding to a request.
        """
        return pulumi.get(self, "timeout_seconds")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.ServiceTemplateSpecVolume']]:
        """
        Volume represents a named volume in a container.
        Structure is documented below.
        """
        return pulumi.get(self, "volumes")


@pulumi.output_type
class ServiceTemplateSpecContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "envFroms":
            suggest = "env_froms"
        elif key == "livenessProbe":
            suggest = "liveness_probe"
        elif key == "startupProbe":
            suggest = "startup_probe"
        elif key == "volumeMounts":
            suggest = "volume_mounts"
        elif key == "workingDir":
            suggest = "working_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateSpecContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateSpecContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateSpecContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: _builtins.str,
                 args: Optional[Sequence[_builtins.str]] = None,
                 commands: Optional[Sequence[_builtins.str]] = None,
                 env_froms: Optional[Sequence['outputs.ServiceTemplateSpecContainerEnvFrom']] = None,
                 envs: Optional[Sequence['outputs.ServiceTemplateSpecContainerEnv']] = None,
                 liveness_probe: Optional['outputs.ServiceTemplateSpecContainerLivenessProbe'] = None,
                 name: Optional[_builtins.str] = None,
                 ports: Optional[Sequence['outputs.ServiceTemplateSpecContainerPort']] = None,
                 resources: Optional['outputs.ServiceTemplateSpecContainerResources'] = None,
                 startup_probe: Optional['outputs.ServiceTemplateSpecContainerStartupProbe'] = None,
                 volume_mounts: Optional[Sequence['outputs.ServiceTemplateSpecContainerVolumeMount']] = None,
                 working_dir: Optional[_builtins.str] = None):
        """
        :param _builtins.str image: Docker image name. This is most often a reference to a container located
               in the container registry, such as gcr.io/cloudrun/hello
        :param Sequence[_builtins.str] args: Arguments to the entrypoint.
               The docker image's CMD is used if this is not provided.
        :param Sequence[_builtins.str] commands: Entrypoint array. Not executed within a shell.
               The docker image's ENTRYPOINT is used if this is not provided.
        :param Sequence['ServiceTemplateSpecContainerEnvFromArgs'] env_froms: (Optional, Deprecated)
               List of sources to populate environment variables in the container.
               All invalid keys will be reported as an event when the container is starting.
               When a key exists in multiple sources, the value associated with the last source will
               take precedence. Values defined by an Env with a duplicate key will take
               precedence.
               Structure is documented below.
               
               > **Warning:** `env_from` is deprecated and will be removed in a future major release. This field is not supported by the Cloud Run API.
        :param Sequence['ServiceTemplateSpecContainerEnvArgs'] envs: List of environment variables to set in the container.
               Structure is documented below.
        :param 'ServiceTemplateSpecContainerLivenessProbeArgs' liveness_probe: Periodic probe of container liveness. Container will be restarted if the probe fails. More info:
               https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
               Structure is documented below.
        :param _builtins.str name: Name of the container
        :param Sequence['ServiceTemplateSpecContainerPortArgs'] ports: List of open ports in the container.
               Structure is documented below.
        :param 'ServiceTemplateSpecContainerResourcesArgs' resources: Compute Resources required by this container. Used to set values such as max memory
               Structure is documented below.
        :param 'ServiceTemplateSpecContainerStartupProbeArgs' startup_probe: Startup probe of application within the container.
               All other probes are disabled if a startup probe is provided, until it
               succeeds. Container will not be added to service endpoints if the probe fails.
               Structure is documented below.
        :param Sequence['ServiceTemplateSpecContainerVolumeMountArgs'] volume_mounts: Volume to mount into the container's filesystem.
               Only supports SecretVolumeSources.
               Structure is documented below.
        :param _builtins.str working_dir: (Optional, Deprecated)
               Container's working directory.
               If not specified, the container runtime's default will be used, which
               might be configured in the container image.
               
               > **Warning:** `working_dir` is deprecated and will be removed in a future major release. This field is not supported by the Cloud Run API.
        """
        pulumi.set(__self__, "image", image)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if env_froms is not None:
            pulumi.set(__self__, "env_froms", env_froms)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if liveness_probe is not None:
            pulumi.set(__self__, "liveness_probe", liveness_probe)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if startup_probe is not None:
            pulumi.set(__self__, "startup_probe", startup_probe)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @_builtins.property
    @pulumi.getter
    def image(self) -> _builtins.str:
        """
        Docker image name. This is most often a reference to a container located
        in the container registry, such as gcr.io/cloudrun/hello
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        Arguments to the entrypoint.
        The docker image's CMD is used if this is not provided.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[_builtins.str]]:
        """
        Entrypoint array. Not executed within a shell.
        The docker image's ENTRYPOINT is used if this is not provided.
        """
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter(name="envFroms")
    @_utilities.deprecated("""`env_from` is deprecated and will be removed in a future major release. This field is not supported by the Cloud Run API.""")
    def env_froms(self) -> Optional[Sequence['outputs.ServiceTemplateSpecContainerEnvFrom']]:
        """
        (Optional, Deprecated)
        List of sources to populate environment variables in the container.
        All invalid keys will be reported as an event when the container is starting.
        When a key exists in multiple sources, the value associated with the last source will
        take precedence. Values defined by an Env with a duplicate key will take
        precedence.
        Structure is documented below.

        > **Warning:** `env_from` is deprecated and will be removed in a future major release. This field is not supported by the Cloud Run API.
        """
        return pulumi.get(self, "env_froms")

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.ServiceTemplateSpecContainerEnv']]:
        """
        List of environment variables to set in the container.
        Structure is documented below.
        """
        return pulumi.get(self, "envs")

    @_builtins.property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> Optional['outputs.ServiceTemplateSpecContainerLivenessProbe']:
        """
        Periodic probe of container liveness. Container will be restarted if the probe fails. More info:
        https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        Structure is documented below.
        """
        return pulumi.get(self, "liveness_probe")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the container
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.ServiceTemplateSpecContainerPort']]:
        """
        List of open ports in the container.
        Structure is documented below.
        """
        return pulumi.get(self, "ports")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional['outputs.ServiceTemplateSpecContainerResources']:
        """
        Compute Resources required by this container. Used to set values such as max memory
        Structure is documented below.
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter(name="startupProbe")
    def startup_probe(self) -> Optional['outputs.ServiceTemplateSpecContainerStartupProbe']:
        """
        Startup probe of application within the container.
        All other probes are disabled if a startup probe is provided, until it
        succeeds. Container will not be added to service endpoints if the probe fails.
        Structure is documented below.
        """
        return pulumi.get(self, "startup_probe")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.ServiceTemplateSpecContainerVolumeMount']]:
        """
        Volume to mount into the container's filesystem.
        Only supports SecretVolumeSources.
        Structure is documented below.
        """
        return pulumi.get(self, "volume_mounts")

    @_builtins.property
    @pulumi.getter(name="workingDir")
    @_utilities.deprecated("""`working_dir` is deprecated and will be removed in a future major release. This field is not supported by the Cloud Run API.""")
    def working_dir(self) -> Optional[_builtins.str]:
        """
        (Optional, Deprecated)
        Container's working directory.
        If not specified, the container runtime's default will be used, which
        might be configured in the container image.

        > **Warning:** `working_dir` is deprecated and will be removed in a future major release. This field is not supported by the Cloud Run API.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class ServiceTemplateSpecContainerEnv(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueFrom":
            suggest = "value_from"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateSpecContainerEnv. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateSpecContainerEnv.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateSpecContainerEnv.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None,
                 value_from: Optional['outputs.ServiceTemplateSpecContainerEnvValueFrom'] = None):
        """
        :param _builtins.str name: Name of the environment variable.
        :param _builtins.str value: Defaults to "".
        :param 'ServiceTemplateSpecContainerEnvValueFromArgs' value_from: Source for the environment variable's value. Only supports secret_key_ref.
               Structure is documented below.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_from is not None:
            pulumi.set(__self__, "value_from", value_from)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the environment variable.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        Defaults to "".
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="valueFrom")
    def value_from(self) -> Optional['outputs.ServiceTemplateSpecContainerEnvValueFrom']:
        """
        Source for the environment variable's value. Only supports secret_key_ref.
        Structure is documented below.
        """
        return pulumi.get(self, "value_from")


@pulumi.output_type
class ServiceTemplateSpecContainerEnvFrom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configMapRef":
            suggest = "config_map_ref"
        elif key == "secretRef":
            suggest = "secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateSpecContainerEnvFrom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateSpecContainerEnvFrom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateSpecContainerEnvFrom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_map_ref: Optional['outputs.ServiceTemplateSpecContainerEnvFromConfigMapRef'] = None,
                 prefix: Optional[_builtins.str] = None,
                 secret_ref: Optional['outputs.ServiceTemplateSpecContainerEnvFromSecretRef'] = None):
        """
        :param 'ServiceTemplateSpecContainerEnvFromConfigMapRefArgs' config_map_ref: The ConfigMap to select from.
               Structure is documented below.
        :param _builtins.str prefix: An optional identifier to prepend to each key in the ConfigMap.
        :param 'ServiceTemplateSpecContainerEnvFromSecretRefArgs' secret_ref: The Secret to select from.
               Structure is documented below.
        """
        if config_map_ref is not None:
            pulumi.set(__self__, "config_map_ref", config_map_ref)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)

    @_builtins.property
    @pulumi.getter(name="configMapRef")
    def config_map_ref(self) -> Optional['outputs.ServiceTemplateSpecContainerEnvFromConfigMapRef']:
        """
        The ConfigMap to select from.
        Structure is documented below.
        """
        return pulumi.get(self, "config_map_ref")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> Optional[_builtins.str]:
        """
        An optional identifier to prepend to each key in the ConfigMap.
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional['outputs.ServiceTemplateSpecContainerEnvFromSecretRef']:
        """
        The Secret to select from.
        Structure is documented below.
        """
        return pulumi.get(self, "secret_ref")


@pulumi.output_type
class ServiceTemplateSpecContainerEnvFromConfigMapRef(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localObjectReference":
            suggest = "local_object_reference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateSpecContainerEnvFromConfigMapRef. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateSpecContainerEnvFromConfigMapRef.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateSpecContainerEnvFromConfigMapRef.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_object_reference: Optional['outputs.ServiceTemplateSpecContainerEnvFromConfigMapRefLocalObjectReference'] = None,
                 optional: Optional[_builtins.bool] = None):
        """
        :param 'ServiceTemplateSpecContainerEnvFromConfigMapRefLocalObjectReferenceArgs' local_object_reference: The ConfigMap to select from.
               Structure is documented below.
        :param _builtins.bool optional: Specify whether the ConfigMap must be defined
        """
        if local_object_reference is not None:
            pulumi.set(__self__, "local_object_reference", local_object_reference)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @_builtins.property
    @pulumi.getter(name="localObjectReference")
    def local_object_reference(self) -> Optional['outputs.ServiceTemplateSpecContainerEnvFromConfigMapRefLocalObjectReference']:
        """
        The ConfigMap to select from.
        Structure is documented below.
        """
        return pulumi.get(self, "local_object_reference")

    @_builtins.property
    @pulumi.getter
    def optional(self) -> Optional[_builtins.bool]:
        """
        Specify whether the ConfigMap must be defined
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class ServiceTemplateSpecContainerEnvFromConfigMapRefLocalObjectReference(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: Name of the referent.
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the referent.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServiceTemplateSpecContainerEnvFromSecretRef(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localObjectReference":
            suggest = "local_object_reference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateSpecContainerEnvFromSecretRef. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateSpecContainerEnvFromSecretRef.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateSpecContainerEnvFromSecretRef.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_object_reference: Optional['outputs.ServiceTemplateSpecContainerEnvFromSecretRefLocalObjectReference'] = None,
                 optional: Optional[_builtins.bool] = None):
        """
        :param 'ServiceTemplateSpecContainerEnvFromSecretRefLocalObjectReferenceArgs' local_object_reference: The Secret to select from.
               Structure is documented below.
        :param _builtins.bool optional: Specify whether the Secret must be defined
        """
        if local_object_reference is not None:
            pulumi.set(__self__, "local_object_reference", local_object_reference)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @_builtins.property
    @pulumi.getter(name="localObjectReference")
    def local_object_reference(self) -> Optional['outputs.ServiceTemplateSpecContainerEnvFromSecretRefLocalObjectReference']:
        """
        The Secret to select from.
        Structure is documented below.
        """
        return pulumi.get(self, "local_object_reference")

    @_builtins.property
    @pulumi.getter
    def optional(self) -> Optional[_builtins.bool]:
        """
        Specify whether the Secret must be defined
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class ServiceTemplateSpecContainerEnvFromSecretRefLocalObjectReference(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: Name of the referent.
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the referent.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServiceTemplateSpecContainerEnvValueFrom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretKeyRef":
            suggest = "secret_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateSpecContainerEnvValueFrom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateSpecContainerEnvValueFrom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateSpecContainerEnvValueFrom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_key_ref: 'outputs.ServiceTemplateSpecContainerEnvValueFromSecretKeyRef'):
        """
        :param 'ServiceTemplateSpecContainerEnvValueFromSecretKeyRefArgs' secret_key_ref: Selects a key (version) of a secret in Secret Manager.
               Structure is documented below.
        """
        pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @_builtins.property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> 'outputs.ServiceTemplateSpecContainerEnvValueFromSecretKeyRef':
        """
        Selects a key (version) of a secret in Secret Manager.
        Structure is documented below.
        """
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class ServiceTemplateSpecContainerEnvValueFromSecretKeyRef(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str key: A Cloud Secret Manager secret version. Must be 'latest' for the latest
               version or an integer for a specific version.
        :param _builtins.str name: The name of the secret in Cloud Secret Manager. By default, the secret is assumed to be in the same project.
               If the secret is in another project, you must define an alias.
               An alias definition has the form:
               {alias}:projects/{project-id|project-number}/secrets/{secret-name}.
               If multiple alias definitions are needed, they must be separated by commas.
               The alias definitions must be set on the run.googleapis.com/secrets annotation.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        A Cloud Secret Manager secret version. Must be 'latest' for the latest
        version or an integer for a specific version.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the secret in Cloud Secret Manager. By default, the secret is assumed to be in the same project.
        If the secret is in another project, you must define an alias.
        An alias definition has the form:
        {alias}:projects/{project-id|project-number}/secrets/{secret-name}.
        If multiple alias definitions are needed, they must be separated by commas.
        The alias definitions must be set on the run.googleapis.com/secrets annotation.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServiceTemplateSpecContainerLivenessProbe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "httpGet":
            suggest = "http_get"
        elif key == "initialDelaySeconds":
            suggest = "initial_delay_seconds"
        elif key == "periodSeconds":
            suggest = "period_seconds"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateSpecContainerLivenessProbe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateSpecContainerLivenessProbe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateSpecContainerLivenessProbe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_threshold: Optional[_builtins.int] = None,
                 grpc: Optional['outputs.ServiceTemplateSpecContainerLivenessProbeGrpc'] = None,
                 http_get: Optional['outputs.ServiceTemplateSpecContainerLivenessProbeHttpGet'] = None,
                 initial_delay_seconds: Optional[_builtins.int] = None,
                 period_seconds: Optional[_builtins.int] = None,
                 timeout_seconds: Optional[_builtins.int] = None):
        """
        :param _builtins.int failure_threshold: Minimum consecutive failures for the probe to be considered failed after
               having succeeded. Defaults to 3. Minimum value is 1.
        :param 'ServiceTemplateSpecContainerLivenessProbeGrpcArgs' grpc: GRPC specifies an action involving a GRPC port.
               Structure is documented below.
        :param 'ServiceTemplateSpecContainerLivenessProbeHttpGetArgs' http_get: HttpGet specifies the http request to perform.
               Structure is documented below.
        :param _builtins.int initial_delay_seconds: Number of seconds after the container has started before the probe is
               initiated.
               Defaults to 0 seconds. Minimum value is 0. Maximum value is 3600.
        :param _builtins.int period_seconds: How often (in seconds) to perform the probe.
               Default to 10 seconds. Minimum value is 1. Maximum value is 3600.
        :param _builtins.int timeout_seconds: Number of seconds after which the probe times out.
               Defaults to 1 second. Minimum value is 1. Maximum value is 3600.
               Must be smaller than period_seconds.
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if grpc is not None:
            pulumi.set(__self__, "grpc", grpc)
        if http_get is not None:
            pulumi.set(__self__, "http_get", http_get)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @_builtins.property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[_builtins.int]:
        """
        Minimum consecutive failures for the probe to be considered failed after
        having succeeded. Defaults to 3. Minimum value is 1.
        """
        return pulumi.get(self, "failure_threshold")

    @_builtins.property
    @pulumi.getter
    def grpc(self) -> Optional['outputs.ServiceTemplateSpecContainerLivenessProbeGrpc']:
        """
        GRPC specifies an action involving a GRPC port.
        Structure is documented below.
        """
        return pulumi.get(self, "grpc")

    @_builtins.property
    @pulumi.getter(name="httpGet")
    def http_get(self) -> Optional['outputs.ServiceTemplateSpecContainerLivenessProbeHttpGet']:
        """
        HttpGet specifies the http request to perform.
        Structure is documented below.
        """
        return pulumi.get(self, "http_get")

    @_builtins.property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[_builtins.int]:
        """
        Number of seconds after the container has started before the probe is
        initiated.
        Defaults to 0 seconds. Minimum value is 0. Maximum value is 3600.
        """
        return pulumi.get(self, "initial_delay_seconds")

    @_builtins.property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[_builtins.int]:
        """
        How often (in seconds) to perform the probe.
        Default to 10 seconds. Minimum value is 1. Maximum value is 3600.
        """
        return pulumi.get(self, "period_seconds")

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[_builtins.int]:
        """
        Number of seconds after which the probe times out.
        Defaults to 1 second. Minimum value is 1. Maximum value is 3600.
        Must be smaller than period_seconds.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class ServiceTemplateSpecContainerLivenessProbeGrpc(dict):
    def __init__(__self__, *,
                 port: Optional[_builtins.int] = None,
                 service: Optional[_builtins.str] = None):
        """
        :param _builtins.int port: Port number to access on the container. Number must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        :param _builtins.str service: The name of the service to place in the gRPC HealthCheckRequest
               (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
               If this is not specified, the default behavior is defined by gRPC.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def service(self) -> Optional[_builtins.str]:
        """
        The name of the service to place in the gRPC HealthCheckRequest
        (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
        If this is not specified, the default behavior is defined by gRPC.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class ServiceTemplateSpecContainerLivenessProbeHttpGet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpHeaders":
            suggest = "http_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateSpecContainerLivenessProbeHttpGet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateSpecContainerLivenessProbeHttpGet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateSpecContainerLivenessProbeHttpGet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_headers: Optional[Sequence['outputs.ServiceTemplateSpecContainerLivenessProbeHttpGetHttpHeader']] = None,
                 path: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None):
        """
        :param Sequence['ServiceTemplateSpecContainerLivenessProbeHttpGetHttpHeaderArgs'] http_headers: Custom headers to set in the request. HTTP allows repeated headers.
               Structure is documented below.
        :param _builtins.str path: Path to access on the HTTP server. If set, it should not be empty string.
        :param _builtins.int port: Port number to access on the container. Number must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[Sequence['outputs.ServiceTemplateSpecContainerLivenessProbeHttpGetHttpHeader']]:
        """
        Custom headers to set in the request. HTTP allows repeated headers.
        Structure is documented below.
        """
        return pulumi.get(self, "http_headers")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Path to access on the HTTP server. If set, it should not be empty string.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ServiceTemplateSpecContainerLivenessProbeHttpGetHttpHeader(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The header field name.
        :param _builtins.str value: The header field value.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The header field name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The header field value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceTemplateSpecContainerPort(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerPort":
            suggest = "container_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateSpecContainerPort. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateSpecContainerPort.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateSpecContainerPort.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_port: Optional[_builtins.int] = None,
                 name: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None):
        """
        :param _builtins.int container_port: Port number the container listens on. This must be a valid port number (between 1 and 65535). Defaults to "8080".
        :param _builtins.str name: If specified, used to specify which protocol to use. Allowed values are "http1" (HTTP/1) and "h2c" (HTTP/2 end-to-end). Defaults to "http1".
        :param _builtins.str protocol: Protocol for port. Must be "TCP". Defaults to "TCP".
        """
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[_builtins.int]:
        """
        Port number the container listens on. This must be a valid port number (between 1 and 65535). Defaults to "8080".
        """
        return pulumi.get(self, "container_port")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        If specified, used to specify which protocol to use. Allowed values are "http1" (HTTP/1) and "h2c" (HTTP/2 end-to-end). Defaults to "http1".
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        Protocol for port. Must be "TCP". Defaults to "TCP".
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class ServiceTemplateSpecContainerResources(dict):
    def __init__(__self__, *,
                 limits: Optional[Mapping[str, _builtins.str]] = None,
                 requests: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Mapping[str, _builtins.str] limits: Limits describes the maximum amount of compute resources allowed.
               The values of the map is string form of the 'quantity' k8s type:
               https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        :param Mapping[str, _builtins.str] requests: Requests describes the minimum amount of compute resources required.
               If Requests is omitted for a container, it defaults to Limits if that is
               explicitly specified, otherwise to an implementation-defined value.
               The values of the map is string form of the 'quantity' k8s type:
               https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @_builtins.property
    @pulumi.getter
    def limits(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Limits describes the maximum amount of compute resources allowed.
        The values of the map is string form of the 'quantity' k8s type:
        https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "limits")

    @_builtins.property
    @pulumi.getter
    def requests(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Requests describes the minimum amount of compute resources required.
        If Requests is omitted for a container, it defaults to Limits if that is
        explicitly specified, otherwise to an implementation-defined value.
        The values of the map is string form of the 'quantity' k8s type:
        https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "requests")


@pulumi.output_type
class ServiceTemplateSpecContainerStartupProbe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "httpGet":
            suggest = "http_get"
        elif key == "initialDelaySeconds":
            suggest = "initial_delay_seconds"
        elif key == "periodSeconds":
            suggest = "period_seconds"
        elif key == "tcpSocket":
            suggest = "tcp_socket"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateSpecContainerStartupProbe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateSpecContainerStartupProbe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateSpecContainerStartupProbe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_threshold: Optional[_builtins.int] = None,
                 grpc: Optional['outputs.ServiceTemplateSpecContainerStartupProbeGrpc'] = None,
                 http_get: Optional['outputs.ServiceTemplateSpecContainerStartupProbeHttpGet'] = None,
                 initial_delay_seconds: Optional[_builtins.int] = None,
                 period_seconds: Optional[_builtins.int] = None,
                 tcp_socket: Optional['outputs.ServiceTemplateSpecContainerStartupProbeTcpSocket'] = None,
                 timeout_seconds: Optional[_builtins.int] = None):
        """
        :param _builtins.int failure_threshold: Minimum consecutive failures for the probe to be considered failed after
               having succeeded. Defaults to 3. Minimum value is 1.
        :param 'ServiceTemplateSpecContainerStartupProbeGrpcArgs' grpc: GRPC specifies an action involving a GRPC port.
               Structure is documented below.
        :param 'ServiceTemplateSpecContainerStartupProbeHttpGetArgs' http_get: HttpGet specifies the http request to perform.
               Structure is documented below.
        :param _builtins.int initial_delay_seconds: Number of seconds after the container has started before the probe is
               initiated.
               Defaults to 0 seconds. Minimum value is 0. Maximum value is 240.
        :param _builtins.int period_seconds: How often (in seconds) to perform the probe.
               Default to 10 seconds. Minimum value is 1. Maximum value is 240.
        :param 'ServiceTemplateSpecContainerStartupProbeTcpSocketArgs' tcp_socket: TcpSocket specifies an action involving a TCP port.
               Structure is documented below.
        :param _builtins.int timeout_seconds: Number of seconds after which the probe times out.
               Defaults to 1 second. Minimum value is 1. Maximum value is 3600.
               Must be smaller than periodSeconds.
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if grpc is not None:
            pulumi.set(__self__, "grpc", grpc)
        if http_get is not None:
            pulumi.set(__self__, "http_get", http_get)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if tcp_socket is not None:
            pulumi.set(__self__, "tcp_socket", tcp_socket)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @_builtins.property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[_builtins.int]:
        """
        Minimum consecutive failures for the probe to be considered failed after
        having succeeded. Defaults to 3. Minimum value is 1.
        """
        return pulumi.get(self, "failure_threshold")

    @_builtins.property
    @pulumi.getter
    def grpc(self) -> Optional['outputs.ServiceTemplateSpecContainerStartupProbeGrpc']:
        """
        GRPC specifies an action involving a GRPC port.
        Structure is documented below.
        """
        return pulumi.get(self, "grpc")

    @_builtins.property
    @pulumi.getter(name="httpGet")
    def http_get(self) -> Optional['outputs.ServiceTemplateSpecContainerStartupProbeHttpGet']:
        """
        HttpGet specifies the http request to perform.
        Structure is documented below.
        """
        return pulumi.get(self, "http_get")

    @_builtins.property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[_builtins.int]:
        """
        Number of seconds after the container has started before the probe is
        initiated.
        Defaults to 0 seconds. Minimum value is 0. Maximum value is 240.
        """
        return pulumi.get(self, "initial_delay_seconds")

    @_builtins.property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[_builtins.int]:
        """
        How often (in seconds) to perform the probe.
        Default to 10 seconds. Minimum value is 1. Maximum value is 240.
        """
        return pulumi.get(self, "period_seconds")

    @_builtins.property
    @pulumi.getter(name="tcpSocket")
    def tcp_socket(self) -> Optional['outputs.ServiceTemplateSpecContainerStartupProbeTcpSocket']:
        """
        TcpSocket specifies an action involving a TCP port.
        Structure is documented below.
        """
        return pulumi.get(self, "tcp_socket")

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[_builtins.int]:
        """
        Number of seconds after which the probe times out.
        Defaults to 1 second. Minimum value is 1. Maximum value is 3600.
        Must be smaller than periodSeconds.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class ServiceTemplateSpecContainerStartupProbeGrpc(dict):
    def __init__(__self__, *,
                 port: Optional[_builtins.int] = None,
                 service: Optional[_builtins.str] = None):
        """
        :param _builtins.int port: Port number to access on the container. Number must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        :param _builtins.str service: The name of the service to place in the gRPC HealthCheckRequest
               (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
               If this is not specified, the default behavior is defined by gRPC.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def service(self) -> Optional[_builtins.str]:
        """
        The name of the service to place in the gRPC HealthCheckRequest
        (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
        If this is not specified, the default behavior is defined by gRPC.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class ServiceTemplateSpecContainerStartupProbeHttpGet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpHeaders":
            suggest = "http_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateSpecContainerStartupProbeHttpGet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateSpecContainerStartupProbeHttpGet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateSpecContainerStartupProbeHttpGet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_headers: Optional[Sequence['outputs.ServiceTemplateSpecContainerStartupProbeHttpGetHttpHeader']] = None,
                 path: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None):
        """
        :param Sequence['ServiceTemplateSpecContainerStartupProbeHttpGetHttpHeaderArgs'] http_headers: Custom headers to set in the request. HTTP allows repeated headers.
               Structure is documented below.
        :param _builtins.str path: Path to access on the HTTP server. If set, it should not be empty string.
        :param _builtins.int port: Port number to access on the container. Number must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[Sequence['outputs.ServiceTemplateSpecContainerStartupProbeHttpGetHttpHeader']]:
        """
        Custom headers to set in the request. HTTP allows repeated headers.
        Structure is documented below.
        """
        return pulumi.get(self, "http_headers")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Path to access on the HTTP server. If set, it should not be empty string.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ServiceTemplateSpecContainerStartupProbeHttpGetHttpHeader(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The header field name.
        :param _builtins.str value: The header field value.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The header field name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The header field value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceTemplateSpecContainerStartupProbeTcpSocket(dict):
    def __init__(__self__, *,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.int port: Port number to access on the container. Number must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ServiceTemplateSpecContainerVolumeMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateSpecContainerVolumeMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateSpecContainerVolumeMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateSpecContainerVolumeMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str mount_path: Path within the container at which the volume should be mounted.  Must
               not contain ':'.
        :param _builtins.str name: This must match the Name of a Volume.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> _builtins.str:
        """
        Path within the container at which the volume should be mounted.  Must
        not contain ':'.
        """
        return pulumi.get(self, "mount_path")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        This must match the Name of a Volume.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServiceTemplateSpecVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emptyDir":
            suggest = "empty_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateSpecVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateSpecVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateSpecVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 csi: Optional['outputs.ServiceTemplateSpecVolumeCsi'] = None,
                 empty_dir: Optional['outputs.ServiceTemplateSpecVolumeEmptyDir'] = None,
                 nfs: Optional['outputs.ServiceTemplateSpecVolumeNfs'] = None,
                 secret: Optional['outputs.ServiceTemplateSpecVolumeSecret'] = None):
        """
        :param _builtins.str name: Volume's name.
        :param 'ServiceTemplateSpecVolumeCsiArgs' csi: A filesystem specified by the Container Storage Interface (CSI).
               Structure is documented below.
        :param 'ServiceTemplateSpecVolumeEmptyDirArgs' empty_dir: Ephemeral storage which can be backed by real disks (HD, SSD), network storage or memory (i.e. tmpfs). For now only in memory (tmpfs) is supported. It is ephemeral in the sense that when the sandbox is taken down, the data is destroyed with it (it does not persist across sandbox runs).
               Structure is documented below.
        :param 'ServiceTemplateSpecVolumeNfsArgs' nfs: A filesystem backed by a Network File System share. This filesystem requires the
               run.googleapis.com/execution-environment annotation to be unset or set to "gen2"
               Structure is documented below.
        :param 'ServiceTemplateSpecVolumeSecretArgs' secret: The secret's value will be presented as the content of a file whose
               name is defined in the item path. If no items are defined, the name of
               the file is the secret_name.
               Structure is documented below.
        """
        pulumi.set(__self__, "name", name)
        if csi is not None:
            pulumi.set(__self__, "csi", csi)
        if empty_dir is not None:
            pulumi.set(__self__, "empty_dir", empty_dir)
        if nfs is not None:
            pulumi.set(__self__, "nfs", nfs)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Volume's name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def csi(self) -> Optional['outputs.ServiceTemplateSpecVolumeCsi']:
        """
        A filesystem specified by the Container Storage Interface (CSI).
        Structure is documented below.
        """
        return pulumi.get(self, "csi")

    @_builtins.property
    @pulumi.getter(name="emptyDir")
    def empty_dir(self) -> Optional['outputs.ServiceTemplateSpecVolumeEmptyDir']:
        """
        Ephemeral storage which can be backed by real disks (HD, SSD), network storage or memory (i.e. tmpfs). For now only in memory (tmpfs) is supported. It is ephemeral in the sense that when the sandbox is taken down, the data is destroyed with it (it does not persist across sandbox runs).
        Structure is documented below.
        """
        return pulumi.get(self, "empty_dir")

    @_builtins.property
    @pulumi.getter
    def nfs(self) -> Optional['outputs.ServiceTemplateSpecVolumeNfs']:
        """
        A filesystem backed by a Network File System share. This filesystem requires the
        run.googleapis.com/execution-environment annotation to be unset or set to "gen2"
        Structure is documented below.
        """
        return pulumi.get(self, "nfs")

    @_builtins.property
    @pulumi.getter
    def secret(self) -> Optional['outputs.ServiceTemplateSpecVolumeSecret']:
        """
        The secret's value will be presented as the content of a file whose
        name is defined in the item path. If no items are defined, the name of
        the file is the secret_name.
        Structure is documented below.
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class ServiceTemplateSpecVolumeCsi(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnly":
            suggest = "read_only"
        elif key == "volumeAttributes":
            suggest = "volume_attributes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateSpecVolumeCsi. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateSpecVolumeCsi.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateSpecVolumeCsi.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver: _builtins.str,
                 read_only: Optional[_builtins.bool] = None,
                 volume_attributes: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str driver: Unique name representing the type of file system to be created. Cloud Run supports the following values:
               * gcsfuse.run.googleapis.com: Mount a Google Cloud Storage bucket using GCSFuse. This driver requires the
               run.googleapis.com/execution-environment annotation to be unset or set to "gen2"
        :param _builtins.bool read_only: If true, all mounts created from this volume will be read-only.
        :param Mapping[str, _builtins.str] volume_attributes: Driver-specific attributes. The following options are supported for available drivers:
               * gcsfuse.run.googleapis.com
               * bucketName: The name of the Cloud Storage Bucket that backs this volume. The Cloud Run Service identity must have access to this bucket.
        """
        pulumi.set(__self__, "driver", driver)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if volume_attributes is not None:
            pulumi.set(__self__, "volume_attributes", volume_attributes)

    @_builtins.property
    @pulumi.getter
    def driver(self) -> _builtins.str:
        """
        Unique name representing the type of file system to be created. Cloud Run supports the following values:
        * gcsfuse.run.googleapis.com: Mount a Google Cloud Storage bucket using GCSFuse. This driver requires the
        run.googleapis.com/execution-environment annotation to be unset or set to "gen2"
        """
        return pulumi.get(self, "driver")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        If true, all mounts created from this volume will be read-only.
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="volumeAttributes")
    def volume_attributes(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Driver-specific attributes. The following options are supported for available drivers:
        * gcsfuse.run.googleapis.com
        * bucketName: The name of the Cloud Storage Bucket that backs this volume. The Cloud Run Service identity must have access to this bucket.
        """
        return pulumi.get(self, "volume_attributes")


@pulumi.output_type
class ServiceTemplateSpecVolumeEmptyDir(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeLimit":
            suggest = "size_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateSpecVolumeEmptyDir. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateSpecVolumeEmptyDir.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateSpecVolumeEmptyDir.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 medium: Optional[_builtins.str] = None,
                 size_limit: Optional[_builtins.str] = None):
        """
        :param _builtins.str medium: The medium on which the data is stored. The default is "" which means to use the node's default medium. Must be an empty string (default) or Memory.
        :param _builtins.str size_limit: Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
        """
        if medium is not None:
            pulumi.set(__self__, "medium", medium)
        if size_limit is not None:
            pulumi.set(__self__, "size_limit", size_limit)

    @_builtins.property
    @pulumi.getter
    def medium(self) -> Optional[_builtins.str]:
        """
        The medium on which the data is stored. The default is "" which means to use the node's default medium. Must be an empty string (default) or Memory.
        """
        return pulumi.get(self, "medium")

    @_builtins.property
    @pulumi.getter(name="sizeLimit")
    def size_limit(self) -> Optional[_builtins.str]:
        """
        Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
        """
        return pulumi.get(self, "size_limit")


@pulumi.output_type
class ServiceTemplateSpecVolumeNfs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateSpecVolumeNfs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateSpecVolumeNfs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateSpecVolumeNfs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: _builtins.str,
                 server: _builtins.str,
                 read_only: Optional[_builtins.bool] = None):
        """
        :param _builtins.str path: Path exported by the NFS server
        :param _builtins.str server: IP address or hostname of the NFS server
        :param _builtins.bool read_only: If true, mount the NFS volume as read only in all mounts. Defaults to false.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "server", server)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Path exported by the NFS server
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def server(self) -> _builtins.str:
        """
        IP address or hostname of the NFS server
        """
        return pulumi.get(self, "server")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        If true, mount the NFS volume as read only in all mounts. Defaults to false.
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class ServiceTemplateSpecVolumeSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretName":
            suggest = "secret_name"
        elif key == "defaultMode":
            suggest = "default_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateSpecVolumeSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateSpecVolumeSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateSpecVolumeSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_name: _builtins.str,
                 default_mode: Optional[_builtins.int] = None,
                 items: Optional[Sequence['outputs.ServiceTemplateSpecVolumeSecretItem']] = None):
        """
        :param _builtins.str secret_name: The name of the secret in Cloud Secret Manager. By default, the secret
               is assumed to be in the same project.
               If the secret is in another project, you must define an alias.
               An alias definition has the form:
               {alias}:projects/{project-id|project-number}/secrets/{secret-name}.
               If multiple alias definitions are needed, they must be separated by
               commas.
               The alias definitions must be set on the run.googleapis.com/secrets
               annotation.
        :param _builtins.int default_mode: Mode bits to use on created files by default. Must be a value between 0000
               and 0777. Defaults to 0644. Directories within the path are not affected by
               this setting. This might be in conflict with other options that affect the
               file mode, like fsGroup, and the result can be other mode bits set.
        :param Sequence['ServiceTemplateSpecVolumeSecretItemArgs'] items: If unspecified, the volume will expose a file whose name is the
               secret_name.
               If specified, the key will be used as the version to fetch from Cloud
               Secret Manager and the path will be the name of the file exposed in the
               volume. When items are defined, they must specify a key and a path.
               Structure is documented below.
        """
        pulumi.set(__self__, "secret_name", secret_name)
        if default_mode is not None:
            pulumi.set(__self__, "default_mode", default_mode)
        if items is not None:
            pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> _builtins.str:
        """
        The name of the secret in Cloud Secret Manager. By default, the secret
        is assumed to be in the same project.
        If the secret is in another project, you must define an alias.
        An alias definition has the form:
        {alias}:projects/{project-id|project-number}/secrets/{secret-name}.
        If multiple alias definitions are needed, they must be separated by
        commas.
        The alias definitions must be set on the run.googleapis.com/secrets
        annotation.
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> Optional[_builtins.int]:
        """
        Mode bits to use on created files by default. Must be a value between 0000
        and 0777. Defaults to 0644. Directories within the path are not affected by
        this setting. This might be in conflict with other options that affect the
        file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "default_mode")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.ServiceTemplateSpecVolumeSecretItem']]:
        """
        If unspecified, the volume will expose a file whose name is the
        secret_name.
        If specified, the key will be used as the version to fetch from Cloud
        Secret Manager and the path will be the name of the file exposed in the
        volume. When items are defined, they must specify a key and a path.
        Structure is documented below.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class ServiceTemplateSpecVolumeSecretItem(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 path: _builtins.str,
                 mode: Optional[_builtins.int] = None):
        """
        :param _builtins.str key: The Cloud Secret Manager secret version.
               Can be 'latest' for the latest value or an integer for a specific version.
        :param _builtins.str path: The relative path of the file to map the key to.
               May not be an absolute path.
               May not contain the path element '..'.
               May not start with the string '..'.
        :param _builtins.int mode: Mode bits to use on this file, must be a value between 0000 and 0777. If
               not specified, the volume defaultMode will be used. This might be in
               conflict with other options that affect the file mode, like fsGroup, and
               the result can be other mode bits set.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "path", path)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The Cloud Secret Manager secret version.
        Can be 'latest' for the latest value or an integer for a specific version.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The relative path of the file to map the key to.
        May not be an absolute path.
        May not contain the path element '..'.
        May not start with the string '..'.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.int]:
        """
        Mode bits to use on this file, must be a value between 0000 and 0777. If
        not specified, the volume defaultMode will be used. This might be in
        conflict with other options that affect the file mode, like fsGroup, and
        the result can be other mode bits set.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class ServiceTraffic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "latestRevision":
            suggest = "latest_revision"
        elif key == "revisionName":
            suggest = "revision_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTraffic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTraffic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTraffic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 percent: _builtins.int,
                 latest_revision: Optional[_builtins.bool] = None,
                 revision_name: Optional[_builtins.str] = None,
                 tag: Optional[_builtins.str] = None,
                 url: Optional[_builtins.str] = None):
        """
        :param _builtins.int percent: Percent specifies percent of the traffic to this Revision or Configuration.
        :param _builtins.bool latest_revision: LatestRevision may be optionally provided to indicate that the latest ready
               Revision of the Configuration should be used for this traffic target. When
               provided LatestRevision must be true if RevisionName is empty; it must be
               false when RevisionName is non-empty.
        :param _builtins.str revision_name: RevisionName of a specific revision to which to send this portion of traffic.
        :param _builtins.str tag: Tag is optionally used to expose a dedicated url for referencing this target exclusively.
        :param _builtins.str url: (Output)
               URL displays the URL for accessing tagged traffic targets. URL is displayed in status,
               and is disallowed on spec. URL must contain a scheme (e.g. http://) and a hostname,
               but may not contain anything else (e.g. basic auth, url path, etc.)
        """
        pulumi.set(__self__, "percent", percent)
        if latest_revision is not None:
            pulumi.set(__self__, "latest_revision", latest_revision)
        if revision_name is not None:
            pulumi.set(__self__, "revision_name", revision_name)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def percent(self) -> _builtins.int:
        """
        Percent specifies percent of the traffic to this Revision or Configuration.
        """
        return pulumi.get(self, "percent")

    @_builtins.property
    @pulumi.getter(name="latestRevision")
    def latest_revision(self) -> Optional[_builtins.bool]:
        """
        LatestRevision may be optionally provided to indicate that the latest ready
        Revision of the Configuration should be used for this traffic target. When
        provided LatestRevision must be true if RevisionName is empty; it must be
        false when RevisionName is non-empty.
        """
        return pulumi.get(self, "latest_revision")

    @_builtins.property
    @pulumi.getter(name="revisionName")
    def revision_name(self) -> Optional[_builtins.str]:
        """
        RevisionName of a specific revision to which to send this portion of traffic.
        """
        return pulumi.get(self, "revision_name")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[_builtins.str]:
        """
        Tag is optionally used to expose a dedicated url for referencing this target exclusively.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        """
        (Output)
        URL displays the URL for accessing tagged traffic targets. URL is displayed in status,
        and is disallowed on spec. URL must contain a scheme (e.g. http://) and a hostname,
        but may not contain anything else (e.g. basic auth, url path, etc.)
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetServiceMetadataResult(dict):
    def __init__(__self__, *,
                 annotations: Mapping[str, _builtins.str],
                 effective_annotations: Mapping[str, _builtins.str],
                 effective_labels: Mapping[str, _builtins.str],
                 generation: _builtins.int,
                 labels: Mapping[str, _builtins.str],
                 namespace: _builtins.str,
                 pulumi_labels: Mapping[str, _builtins.str],
                 resource_version: _builtins.str,
                 self_link: _builtins.str,
                 uid: _builtins.str):
        """
        :param _builtins.int generation: A sequence number representing a specific generation of the desired state.
        :param Mapping[str, _builtins.str] labels: Map of string keys and values that can be used to organize and categorize
               (scope and select) objects. May match selectors of replication controllers
               and routes.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param _builtins.str namespace: In Cloud Run the namespace must be equal to either the
               project ID or project number.
        :param Mapping[str, _builtins.str] pulumi_labels: The combination of labels configured directly on the resource
                and default labels configured on the provider.
        :param _builtins.str resource_version: An opaque value that represents the internal version of this object that
               can be used by clients to determine when objects have changed. May be used
               for optimistic concurrency, change detection, and the watch operation on a
               resource or set of resources. They may only be valid for a
               particular resource or set of resources.
        :param _builtins.str self_link: SelfLink is a URL representing this object.
        :param _builtins.str uid: UID is a unique id generated by the server on successful creation of a resource and is not
               allowed to change on PUT operations.
        """
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "effective_annotations", effective_annotations)
        pulumi.set(__self__, "effective_labels", effective_labels)
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        pulumi.set(__self__, "resource_version", resource_version)
        pulumi.set(__self__, "self_link", self_link)
        pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "effective_annotations")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def generation(self) -> _builtins.int:
        """
        A sequence number representing a specific generation of the desired state.
        """
        return pulumi.get(self, "generation")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Map of string keys and values that can be used to organize and categorize
        (scope and select) objects. May match selectors of replication controllers
        and routes.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field 'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        In Cloud Run the namespace must be equal to either the
        project ID or project number.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Mapping[str, _builtins.str]:
        """
        The combination of labels configured directly on the resource
         and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> _builtins.str:
        """
        An opaque value that represents the internal version of this object that
        can be used by clients to determine when objects have changed. May be used
        for optimistic concurrency, change detection, and the watch operation on a
        resource or set of resources. They may only be valid for a
        particular resource or set of resources.
        """
        return pulumi.get(self, "resource_version")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> _builtins.str:
        """
        SelfLink is a URL representing this object.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> _builtins.str:
        """
        UID is a unique id generated by the server on successful creation of a resource and is not
        allowed to change on PUT operations.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class GetServiceStatusResult(dict):
    def __init__(__self__, *,
                 conditions: Sequence['outputs.GetServiceStatusConditionResult'],
                 latest_created_revision_name: _builtins.str,
                 latest_ready_revision_name: _builtins.str,
                 observed_generation: _builtins.int,
                 traffics: Sequence['outputs.GetServiceStatusTrafficResult'],
                 url: _builtins.str):
        """
        :param Sequence['GetServiceStatusConditionArgs'] conditions: Array of observed Service Conditions, indicating the current ready state of the service.
        :param _builtins.str latest_created_revision_name: From ConfigurationStatus. LatestCreatedRevisionName is the last revision that was created
               from this Service's Configuration. It might not be ready yet, for that use
               LatestReadyRevisionName.
        :param _builtins.str latest_ready_revision_name: From ConfigurationStatus. LatestReadyRevisionName holds the name of the latest Revision
               stamped out from this Service's Configuration that has had its "Ready" condition become
               "True".
        :param _builtins.int observed_generation: ObservedGeneration is the 'Generation' of the Route that was last processed by the
               controller.
               
               Clients polling for completed reconciliation should poll until observedGeneration =
               metadata.generation and the Ready condition's status is True or False.
        :param Sequence['GetServiceStatusTrafficArgs'] traffics: Traffic specifies how to distribute traffic over a collection of Knative Revisions
               and Configurations
        :param _builtins.str url: From RouteStatus. URL holds the url that will distribute traffic over the provided traffic
               targets. It generally has the form
               https://{route-hash}-{project-hash}-{cluster-level-suffix}.a.run.app
        """
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "latest_created_revision_name", latest_created_revision_name)
        pulumi.set(__self__, "latest_ready_revision_name", latest_ready_revision_name)
        pulumi.set(__self__, "observed_generation", observed_generation)
        pulumi.set(__self__, "traffics", traffics)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GetServiceStatusConditionResult']:
        """
        Array of observed Service Conditions, indicating the current ready state of the service.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="latestCreatedRevisionName")
    def latest_created_revision_name(self) -> _builtins.str:
        """
        From ConfigurationStatus. LatestCreatedRevisionName is the last revision that was created
        from this Service's Configuration. It might not be ready yet, for that use
        LatestReadyRevisionName.
        """
        return pulumi.get(self, "latest_created_revision_name")

    @_builtins.property
    @pulumi.getter(name="latestReadyRevisionName")
    def latest_ready_revision_name(self) -> _builtins.str:
        """
        From ConfigurationStatus. LatestReadyRevisionName holds the name of the latest Revision
        stamped out from this Service's Configuration that has had its "Ready" condition become
        "True".
        """
        return pulumi.get(self, "latest_ready_revision_name")

    @_builtins.property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> _builtins.int:
        """
        ObservedGeneration is the 'Generation' of the Route that was last processed by the
        controller.

        Clients polling for completed reconciliation should poll until observedGeneration =
        metadata.generation and the Ready condition's status is True or False.
        """
        return pulumi.get(self, "observed_generation")

    @_builtins.property
    @pulumi.getter
    def traffics(self) -> Sequence['outputs.GetServiceStatusTrafficResult']:
        """
        Traffic specifies how to distribute traffic over a collection of Knative Revisions
        and Configurations
        """
        return pulumi.get(self, "traffics")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        From RouteStatus. URL holds the url that will distribute traffic over the provided traffic
        targets. It generally has the form
        https://{route-hash}-{project-hash}-{cluster-level-suffix}.a.run.app
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetServiceStatusConditionResult(dict):
    def __init__(__self__, *,
                 message: _builtins.str,
                 reason: _builtins.str,
                 status: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str message: Human readable message indicating details about the current status.
        :param _builtins.str reason: One-word CamelCase reason for the condition's current status.
        :param _builtins.str status: Status of the condition, one of True, False, Unknown.
        :param _builtins.str type: Type of domain mapping condition.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> _builtins.str:
        """
        One-word CamelCase reason for the condition's current status.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of domain mapping condition.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServiceStatusTrafficResult(dict):
    def __init__(__self__, *,
                 latest_revision: _builtins.bool,
                 percent: _builtins.int,
                 revision_name: _builtins.str,
                 tag: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.bool latest_revision: LatestRevision may be optionally provided to indicate that the latest ready
               Revision of the Configuration should be used for this traffic target. When
               provided LatestRevision must be true if RevisionName is empty; it must be
               false when RevisionName is non-empty.
        :param _builtins.int percent: Percent specifies percent of the traffic to this Revision or Configuration.
        :param _builtins.str revision_name: RevisionName of a specific revision to which to send this portion of traffic.
        :param _builtins.str tag: Tag is optionally used to expose a dedicated url for referencing this target exclusively.
        :param _builtins.str url: URL displays the URL for accessing tagged traffic targets. URL is displayed in status,
               and is disallowed on spec. URL must contain a scheme (e.g. http://) and a hostname,
               but may not contain anything else (e.g. basic auth, url path, etc.)
        """
        pulumi.set(__self__, "latest_revision", latest_revision)
        pulumi.set(__self__, "percent", percent)
        pulumi.set(__self__, "revision_name", revision_name)
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="latestRevision")
    def latest_revision(self) -> _builtins.bool:
        """
        LatestRevision may be optionally provided to indicate that the latest ready
        Revision of the Configuration should be used for this traffic target. When
        provided LatestRevision must be true if RevisionName is empty; it must be
        false when RevisionName is non-empty.
        """
        return pulumi.get(self, "latest_revision")

    @_builtins.property
    @pulumi.getter
    def percent(self) -> _builtins.int:
        """
        Percent specifies percent of the traffic to this Revision or Configuration.
        """
        return pulumi.get(self, "percent")

    @_builtins.property
    @pulumi.getter(name="revisionName")
    def revision_name(self) -> _builtins.str:
        """
        RevisionName of a specific revision to which to send this portion of traffic.
        """
        return pulumi.get(self, "revision_name")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> _builtins.str:
        """
        Tag is optionally used to expose a dedicated url for referencing this target exclusively.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        URL displays the URL for accessing tagged traffic targets. URL is displayed in status,
        and is disallowed on spec. URL must contain a scheme (e.g. http://) and a hostname,
        but may not contain anything else (e.g. basic auth, url path, etc.)
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetServiceTemplateResult(dict):
    def __init__(__self__, *,
                 metadatas: Sequence['outputs.GetServiceTemplateMetadataResult'],
                 specs: Sequence['outputs.GetServiceTemplateSpecResult']):
        """
        :param Sequence['GetServiceTemplateMetadataArgs'] metadatas: Optional metadata for this Revision, including labels and annotations.
               Name will be generated by the Configuration. To set minimum instances
               for this revision, use the "autoscaling.knative.dev/minScale" annotation
               key. To set maximum instances for this revision, use the
               "autoscaling.knative.dev/maxScale" annotation key. To set Cloud SQL
               connections for the revision, use the "run.googleapis.com/cloudsql-instances"
               annotation key.
        :param Sequence['GetServiceTemplateSpecArgs'] specs: RevisionSpec holds the desired state of the Revision (from the client).
        """
        pulumi.set(__self__, "metadatas", metadatas)
        pulumi.set(__self__, "specs", specs)

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> Sequence['outputs.GetServiceTemplateMetadataResult']:
        """
        Optional metadata for this Revision, including labels and annotations.
        Name will be generated by the Configuration. To set minimum instances
        for this revision, use the "autoscaling.knative.dev/minScale" annotation
        key. To set maximum instances for this revision, use the
        "autoscaling.knative.dev/maxScale" annotation key. To set Cloud SQL
        connections for the revision, use the "run.googleapis.com/cloudsql-instances"
        annotation key.
        """
        return pulumi.get(self, "metadatas")

    @_builtins.property
    @pulumi.getter
    def specs(self) -> Sequence['outputs.GetServiceTemplateSpecResult']:
        """
        RevisionSpec holds the desired state of the Revision (from the client).
        """
        return pulumi.get(self, "specs")


@pulumi.output_type
class GetServiceTemplateMetadataResult(dict):
    def __init__(__self__, *,
                 annotations: Mapping[str, _builtins.str],
                 generation: _builtins.int,
                 labels: Mapping[str, _builtins.str],
                 name: _builtins.str,
                 namespace: _builtins.str,
                 resource_version: _builtins.str,
                 self_link: _builtins.str,
                 uid: _builtins.str):
        """
        :param _builtins.int generation: A sequence number representing a specific generation of the desired state.
        :param Mapping[str, _builtins.str] labels: Map of string keys and values that can be used to organize and categorize
               (scope and select) objects.
        :param _builtins.str name: The name of the Cloud Run Service.
        :param _builtins.str namespace: In Cloud Run the namespace must be equal to either the
               project ID or project number. It will default to the resource's project.
        :param _builtins.str resource_version: An opaque value that represents the internal version of this object that
               can be used by clients to determine when objects have changed. May be used
               for optimistic concurrency, change detection, and the watch operation on a
               resource or set of resources. They may only be valid for a
               particular resource or set of resources.
        :param _builtins.str self_link: SelfLink is a URL representing this object.
        :param _builtins.str uid: UID is a unique id generated by the server on successful creation of a resource and is not
               allowed to change on PUT operations.
        """
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "resource_version", resource_version)
        pulumi.set(__self__, "self_link", self_link)
        pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def generation(self) -> _builtins.int:
        """
        A sequence number representing a specific generation of the desired state.
        """
        return pulumi.get(self, "generation")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Map of string keys and values that can be used to organize and categorize
        (scope and select) objects.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run Service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        In Cloud Run the namespace must be equal to either the
        project ID or project number. It will default to the resource's project.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> _builtins.str:
        """
        An opaque value that represents the internal version of this object that
        can be used by clients to determine when objects have changed. May be used
        for optimistic concurrency, change detection, and the watch operation on a
        resource or set of resources. They may only be valid for a
        particular resource or set of resources.
        """
        return pulumi.get(self, "resource_version")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> _builtins.str:
        """
        SelfLink is a URL representing this object.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> _builtins.str:
        """
        UID is a unique id generated by the server on successful creation of a resource and is not
        allowed to change on PUT operations.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class GetServiceTemplateSpecResult(dict):
    def __init__(__self__, *,
                 container_concurrency: _builtins.int,
                 containers: Sequence['outputs.GetServiceTemplateSpecContainerResult'],
                 node_selector: Mapping[str, _builtins.str],
                 service_account_name: _builtins.str,
                 serving_state: _builtins.str,
                 timeout_seconds: _builtins.int,
                 volumes: Sequence['outputs.GetServiceTemplateSpecVolumeResult']):
        """
        :param _builtins.int container_concurrency: ContainerConcurrency specifies the maximum allowed in-flight (concurrent)
               requests per container of the Revision. If not specified or 0, defaults to 80 when
               requested CPU >= 1 and defaults to 1 when requested CPU < 1.
        :param Sequence['GetServiceTemplateSpecContainerArgs'] containers: Containers defines the unit of execution for this Revision.
        :param Mapping[str, _builtins.str] node_selector: Node Selector describes the hardware requirements of the resources.
               Use the following node selector keys to configure features on a Revision:
                 - 'run.googleapis.com/accelerator' sets the [type of GPU](https://cloud.google.com/run/docs/configuring/services/gpu) required by the Revision to run.
        :param _builtins.str service_account_name: Email address of the IAM service account associated with the revision of the
               service. The service account represents the identity of the running revision,
               and determines what permissions the revision has. If not provided, the revision
               will use the project's default service account.
        :param _builtins.str serving_state: ServingState holds a value describing the state the resources
               are in for this Revision.
               It is expected
               that the system will manipulate this based on routability and load.
        :param _builtins.int timeout_seconds: TimeoutSeconds holds the max duration the instance is allowed for responding to a request.
        :param Sequence['GetServiceTemplateSpecVolumeArgs'] volumes: Volume represents a named volume in a container.
        """
        pulumi.set(__self__, "container_concurrency", container_concurrency)
        pulumi.set(__self__, "containers", containers)
        pulumi.set(__self__, "node_selector", node_selector)
        pulumi.set(__self__, "service_account_name", service_account_name)
        pulumi.set(__self__, "serving_state", serving_state)
        pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        pulumi.set(__self__, "volumes", volumes)

    @_builtins.property
    @pulumi.getter(name="containerConcurrency")
    def container_concurrency(self) -> _builtins.int:
        """
        ContainerConcurrency specifies the maximum allowed in-flight (concurrent)
        requests per container of the Revision. If not specified or 0, defaults to 80 when
        requested CPU >= 1 and defaults to 1 when requested CPU < 1.
        """
        return pulumi.get(self, "container_concurrency")

    @_builtins.property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.GetServiceTemplateSpecContainerResult']:
        """
        Containers defines the unit of execution for this Revision.
        """
        return pulumi.get(self, "containers")

    @_builtins.property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Mapping[str, _builtins.str]:
        """
        Node Selector describes the hardware requirements of the resources.
        Use the following node selector keys to configure features on a Revision:
          - 'run.googleapis.com/accelerator' sets the [type of GPU](https://cloud.google.com/run/docs/configuring/services/gpu) required by the Revision to run.
        """
        return pulumi.get(self, "node_selector")

    @_builtins.property
    @pulumi.getter(name="serviceAccountName")
    def service_account_name(self) -> _builtins.str:
        """
        Email address of the IAM service account associated with the revision of the
        service. The service account represents the identity of the running revision,
        and determines what permissions the revision has. If not provided, the revision
        will use the project's default service account.
        """
        return pulumi.get(self, "service_account_name")

    @_builtins.property
    @pulumi.getter(name="servingState")
    def serving_state(self) -> _builtins.str:
        """
        ServingState holds a value describing the state the resources
        are in for this Revision.
        It is expected
        that the system will manipulate this based on routability and load.
        """
        return pulumi.get(self, "serving_state")

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> _builtins.int:
        """
        TimeoutSeconds holds the max duration the instance is allowed for responding to a request.
        """
        return pulumi.get(self, "timeout_seconds")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.GetServiceTemplateSpecVolumeResult']:
        """
        Volume represents a named volume in a container.
        """
        return pulumi.get(self, "volumes")


@pulumi.output_type
class GetServiceTemplateSpecContainerResult(dict):
    def __init__(__self__, *,
                 args: Sequence[_builtins.str],
                 commands: Sequence[_builtins.str],
                 env_froms: Sequence['outputs.GetServiceTemplateSpecContainerEnvFromResult'],
                 envs: Sequence['outputs.GetServiceTemplateSpecContainerEnvResult'],
                 image: _builtins.str,
                 liveness_probes: Sequence['outputs.GetServiceTemplateSpecContainerLivenessProbeResult'],
                 name: _builtins.str,
                 ports: Sequence['outputs.GetServiceTemplateSpecContainerPortResult'],
                 resources: Sequence['outputs.GetServiceTemplateSpecContainerResourceResult'],
                 startup_probes: Sequence['outputs.GetServiceTemplateSpecContainerStartupProbeResult'],
                 volume_mounts: Sequence['outputs.GetServiceTemplateSpecContainerVolumeMountResult'],
                 working_dir: _builtins.str):
        """
        :param Sequence[_builtins.str] args: Arguments to the entrypoint.
               The docker image's CMD is used if this is not provided.
        :param Sequence[_builtins.str] commands: Entrypoint array. Not executed within a shell.
               The docker image's ENTRYPOINT is used if this is not provided.
        :param Sequence['GetServiceTemplateSpecContainerEnvFromArgs'] env_froms: List of sources to populate environment variables in the container.
               All invalid keys will be reported as an event when the container is starting.
               When a key exists in multiple sources, the value associated with the last source will
               take precedence. Values defined by an Env with a duplicate key will take
               precedence.
        :param Sequence['GetServiceTemplateSpecContainerEnvArgs'] envs: List of environment variables to set in the container.
        :param _builtins.str image: Docker image name. This is most often a reference to a container located
               in the container registry, such as gcr.io/cloudrun/hello
        :param Sequence['GetServiceTemplateSpecContainerLivenessProbeArgs'] liveness_probes: Periodic probe of container liveness. Container will be restarted if the probe fails.
        :param _builtins.str name: The name of the Cloud Run Service.
        :param Sequence['GetServiceTemplateSpecContainerPortArgs'] ports: List of open ports in the container.
        :param Sequence['GetServiceTemplateSpecContainerResourceArgs'] resources: Compute Resources required by this container. Used to set values such as max memory
        :param Sequence['GetServiceTemplateSpecContainerStartupProbeArgs'] startup_probes: Startup probe of application within the container.
               All other probes are disabled if a startup probe is provided, until it
               succeeds. Container will not be added to service endpoints if the probe fails.
        :param Sequence['GetServiceTemplateSpecContainerVolumeMountArgs'] volume_mounts: Volume to mount into the container's filesystem.
               Only supports SecretVolumeSources.
        :param _builtins.str working_dir: Container's working directory.
               If not specified, the container runtime's default will be used, which
               might be configured in the container image.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "env_froms", env_froms)
        pulumi.set(__self__, "envs", envs)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "liveness_probes", liveness_probes)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ports", ports)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "startup_probes", startup_probes)
        pulumi.set(__self__, "volume_mounts", volume_mounts)
        pulumi.set(__self__, "working_dir", working_dir)

    @_builtins.property
    @pulumi.getter
    def args(self) -> Sequence[_builtins.str]:
        """
        Arguments to the entrypoint.
        The docker image's CMD is used if this is not provided.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Sequence[_builtins.str]:
        """
        Entrypoint array. Not executed within a shell.
        The docker image's ENTRYPOINT is used if this is not provided.
        """
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter(name="envFroms")
    def env_froms(self) -> Sequence['outputs.GetServiceTemplateSpecContainerEnvFromResult']:
        """
        List of sources to populate environment variables in the container.
        All invalid keys will be reported as an event when the container is starting.
        When a key exists in multiple sources, the value associated with the last source will
        take precedence. Values defined by an Env with a duplicate key will take
        precedence.
        """
        return pulumi.get(self, "env_froms")

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Sequence['outputs.GetServiceTemplateSpecContainerEnvResult']:
        """
        List of environment variables to set in the container.
        """
        return pulumi.get(self, "envs")

    @_builtins.property
    @pulumi.getter
    def image(self) -> _builtins.str:
        """
        Docker image name. This is most often a reference to a container located
        in the container registry, such as gcr.io/cloudrun/hello
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter(name="livenessProbes")
    def liveness_probes(self) -> Sequence['outputs.GetServiceTemplateSpecContainerLivenessProbeResult']:
        """
        Periodic probe of container liveness. Container will be restarted if the probe fails.
        """
        return pulumi.get(self, "liveness_probes")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run Service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Sequence['outputs.GetServiceTemplateSpecContainerPortResult']:
        """
        List of open ports in the container.
        """
        return pulumi.get(self, "ports")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetServiceTemplateSpecContainerResourceResult']:
        """
        Compute Resources required by this container. Used to set values such as max memory
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter(name="startupProbes")
    def startup_probes(self) -> Sequence['outputs.GetServiceTemplateSpecContainerStartupProbeResult']:
        """
        Startup probe of application within the container.
        All other probes are disabled if a startup probe is provided, until it
        succeeds. Container will not be added to service endpoints if the probe fails.
        """
        return pulumi.get(self, "startup_probes")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Sequence['outputs.GetServiceTemplateSpecContainerVolumeMountResult']:
        """
        Volume to mount into the container's filesystem.
        Only supports SecretVolumeSources.
        """
        return pulumi.get(self, "volume_mounts")

    @_builtins.property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> _builtins.str:
        """
        Container's working directory.
        If not specified, the container runtime's default will be used, which
        might be configured in the container image.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class GetServiceTemplateSpecContainerEnvResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str,
                 value_froms: Sequence['outputs.GetServiceTemplateSpecContainerEnvValueFromResult']):
        """
        :param _builtins.str name: The name of the Cloud Run Service.
        :param _builtins.str value: Defaults to "".
        :param Sequence['GetServiceTemplateSpecContainerEnvValueFromArgs'] value_froms: Source for the environment variable's value. Only supports secret_key_ref.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "value_froms", value_froms)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run Service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Defaults to "".
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="valueFroms")
    def value_froms(self) -> Sequence['outputs.GetServiceTemplateSpecContainerEnvValueFromResult']:
        """
        Source for the environment variable's value. Only supports secret_key_ref.
        """
        return pulumi.get(self, "value_froms")


@pulumi.output_type
class GetServiceTemplateSpecContainerEnvFromResult(dict):
    def __init__(__self__, *,
                 config_map_reves: Sequence['outputs.GetServiceTemplateSpecContainerEnvFromConfigMapRefResult'],
                 prefix: _builtins.str,
                 secret_reves: Sequence['outputs.GetServiceTemplateSpecContainerEnvFromSecretRefResult']):
        """
        :param Sequence['GetServiceTemplateSpecContainerEnvFromConfigMapRefArgs'] config_map_reves: The ConfigMap to select from.
        :param _builtins.str prefix: An optional identifier to prepend to each key in the ConfigMap.
        :param Sequence['GetServiceTemplateSpecContainerEnvFromSecretRefArgs'] secret_reves: The Secret to select from.
        """
        pulumi.set(__self__, "config_map_reves", config_map_reves)
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "secret_reves", secret_reves)

    @_builtins.property
    @pulumi.getter(name="configMapReves")
    def config_map_reves(self) -> Sequence['outputs.GetServiceTemplateSpecContainerEnvFromConfigMapRefResult']:
        """
        The ConfigMap to select from.
        """
        return pulumi.get(self, "config_map_reves")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> _builtins.str:
        """
        An optional identifier to prepend to each key in the ConfigMap.
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter(name="secretReves")
    def secret_reves(self) -> Sequence['outputs.GetServiceTemplateSpecContainerEnvFromSecretRefResult']:
        """
        The Secret to select from.
        """
        return pulumi.get(self, "secret_reves")


@pulumi.output_type
class GetServiceTemplateSpecContainerEnvFromConfigMapRefResult(dict):
    def __init__(__self__, *,
                 local_object_references: Sequence['outputs.GetServiceTemplateSpecContainerEnvFromConfigMapRefLocalObjectReferenceResult'],
                 optional: _builtins.bool):
        """
        :param Sequence['GetServiceTemplateSpecContainerEnvFromConfigMapRefLocalObjectReferenceArgs'] local_object_references: The ConfigMap to select from.
        :param _builtins.bool optional: Specify whether the ConfigMap must be defined
        """
        pulumi.set(__self__, "local_object_references", local_object_references)
        pulumi.set(__self__, "optional", optional)

    @_builtins.property
    @pulumi.getter(name="localObjectReferences")
    def local_object_references(self) -> Sequence['outputs.GetServiceTemplateSpecContainerEnvFromConfigMapRefLocalObjectReferenceResult']:
        """
        The ConfigMap to select from.
        """
        return pulumi.get(self, "local_object_references")

    @_builtins.property
    @pulumi.getter
    def optional(self) -> _builtins.bool:
        """
        Specify whether the ConfigMap must be defined
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class GetServiceTemplateSpecContainerEnvFromConfigMapRefLocalObjectReferenceResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: The name of the Cloud Run Service.
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run Service.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetServiceTemplateSpecContainerEnvFromSecretRefResult(dict):
    def __init__(__self__, *,
                 local_object_references: Sequence['outputs.GetServiceTemplateSpecContainerEnvFromSecretRefLocalObjectReferenceResult'],
                 optional: _builtins.bool):
        """
        :param Sequence['GetServiceTemplateSpecContainerEnvFromSecretRefLocalObjectReferenceArgs'] local_object_references: The Secret to select from.
        :param _builtins.bool optional: Specify whether the Secret must be defined
        """
        pulumi.set(__self__, "local_object_references", local_object_references)
        pulumi.set(__self__, "optional", optional)

    @_builtins.property
    @pulumi.getter(name="localObjectReferences")
    def local_object_references(self) -> Sequence['outputs.GetServiceTemplateSpecContainerEnvFromSecretRefLocalObjectReferenceResult']:
        """
        The Secret to select from.
        """
        return pulumi.get(self, "local_object_references")

    @_builtins.property
    @pulumi.getter
    def optional(self) -> _builtins.bool:
        """
        Specify whether the Secret must be defined
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class GetServiceTemplateSpecContainerEnvFromSecretRefLocalObjectReferenceResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: The name of the Cloud Run Service.
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run Service.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetServiceTemplateSpecContainerEnvValueFromResult(dict):
    def __init__(__self__, *,
                 secret_key_reves: Sequence['outputs.GetServiceTemplateSpecContainerEnvValueFromSecretKeyRefResult']):
        """
        :param Sequence['GetServiceTemplateSpecContainerEnvValueFromSecretKeyRefArgs'] secret_key_reves: Selects a key (version) of a secret in Secret Manager.
        """
        pulumi.set(__self__, "secret_key_reves", secret_key_reves)

    @_builtins.property
    @pulumi.getter(name="secretKeyReves")
    def secret_key_reves(self) -> Sequence['outputs.GetServiceTemplateSpecContainerEnvValueFromSecretKeyRefResult']:
        """
        Selects a key (version) of a secret in Secret Manager.
        """
        return pulumi.get(self, "secret_key_reves")


@pulumi.output_type
class GetServiceTemplateSpecContainerEnvValueFromSecretKeyRefResult(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str key: A Cloud Secret Manager secret version. Must be 'latest' for the latest
               version or an integer for a specific version.
        :param _builtins.str name: The name of the Cloud Run Service.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        A Cloud Secret Manager secret version. Must be 'latest' for the latest
        version or an integer for a specific version.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run Service.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetServiceTemplateSpecContainerLivenessProbeResult(dict):
    def __init__(__self__, *,
                 failure_threshold: _builtins.int,
                 grpcs: Sequence['outputs.GetServiceTemplateSpecContainerLivenessProbeGrpcResult'],
                 http_gets: Sequence['outputs.GetServiceTemplateSpecContainerLivenessProbeHttpGetResult'],
                 initial_delay_seconds: _builtins.int,
                 period_seconds: _builtins.int,
                 timeout_seconds: _builtins.int):
        """
        :param _builtins.int failure_threshold: Minimum consecutive failures for the probe to be considered failed after
               having succeeded. Defaults to 3. Minimum value is 1.
        :param Sequence['GetServiceTemplateSpecContainerLivenessProbeGrpcArgs'] grpcs: GRPC specifies an action involving a GRPC port.
        :param Sequence['GetServiceTemplateSpecContainerLivenessProbeHttpGetArgs'] http_gets: HttpGet specifies the http request to perform.
        :param _builtins.int initial_delay_seconds: Number of seconds after the container has started before the probe is
               initiated.
               Defaults to 0 seconds. Minimum value is 0. Maximum value is 3600.
        :param _builtins.int period_seconds: How often (in seconds) to perform the probe.
               Default to 10 seconds. Minimum value is 1. Maximum value is 3600.
        :param _builtins.int timeout_seconds: Number of seconds after which the probe times out.
               Defaults to 1 second. Minimum value is 1. Maximum value is 3600.
               Must be smaller than period_seconds.
        """
        pulumi.set(__self__, "failure_threshold", failure_threshold)
        pulumi.set(__self__, "grpcs", grpcs)
        pulumi.set(__self__, "http_gets", http_gets)
        pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        pulumi.set(__self__, "period_seconds", period_seconds)
        pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @_builtins.property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> _builtins.int:
        """
        Minimum consecutive failures for the probe to be considered failed after
        having succeeded. Defaults to 3. Minimum value is 1.
        """
        return pulumi.get(self, "failure_threshold")

    @_builtins.property
    @pulumi.getter
    def grpcs(self) -> Sequence['outputs.GetServiceTemplateSpecContainerLivenessProbeGrpcResult']:
        """
        GRPC specifies an action involving a GRPC port.
        """
        return pulumi.get(self, "grpcs")

    @_builtins.property
    @pulumi.getter(name="httpGets")
    def http_gets(self) -> Sequence['outputs.GetServiceTemplateSpecContainerLivenessProbeHttpGetResult']:
        """
        HttpGet specifies the http request to perform.
        """
        return pulumi.get(self, "http_gets")

    @_builtins.property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> _builtins.int:
        """
        Number of seconds after the container has started before the probe is
        initiated.
        Defaults to 0 seconds. Minimum value is 0. Maximum value is 3600.
        """
        return pulumi.get(self, "initial_delay_seconds")

    @_builtins.property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> _builtins.int:
        """
        How often (in seconds) to perform the probe.
        Default to 10 seconds. Minimum value is 1. Maximum value is 3600.
        """
        return pulumi.get(self, "period_seconds")

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> _builtins.int:
        """
        Number of seconds after which the probe times out.
        Defaults to 1 second. Minimum value is 1. Maximum value is 3600.
        Must be smaller than period_seconds.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class GetServiceTemplateSpecContainerLivenessProbeGrpcResult(dict):
    def __init__(__self__, *,
                 port: _builtins.int,
                 service: _builtins.str):
        """
        :param _builtins.int port: Port number to access on the container. Number must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        :param _builtins.str service: The name of the service to place in the gRPC HealthCheckRequest
               (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
               If this is not specified, the default behavior is defined by gRPC.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "service", service)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def service(self) -> _builtins.str:
        """
        The name of the service to place in the gRPC HealthCheckRequest
        (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
        If this is not specified, the default behavior is defined by gRPC.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class GetServiceTemplateSpecContainerLivenessProbeHttpGetResult(dict):
    def __init__(__self__, *,
                 http_headers: Sequence['outputs.GetServiceTemplateSpecContainerLivenessProbeHttpGetHttpHeaderResult'],
                 path: _builtins.str,
                 port: _builtins.int):
        """
        :param Sequence['GetServiceTemplateSpecContainerLivenessProbeHttpGetHttpHeaderArgs'] http_headers: Custom headers to set in the request. HTTP allows repeated headers.
        :param _builtins.str path: Path to access on the HTTP server. If set, it should not be empty string.
        :param _builtins.int port: Port number to access on the container. Number must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        pulumi.set(__self__, "http_headers", http_headers)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Sequence['outputs.GetServiceTemplateSpecContainerLivenessProbeHttpGetHttpHeaderResult']:
        """
        Custom headers to set in the request. HTTP allows repeated headers.
        """
        return pulumi.get(self, "http_headers")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Path to access on the HTTP server. If set, it should not be empty string.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetServiceTemplateSpecContainerLivenessProbeHttpGetHttpHeaderResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The name of the Cloud Run Service.
        :param _builtins.str value: The header field value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run Service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The header field value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServiceTemplateSpecContainerPortResult(dict):
    def __init__(__self__, *,
                 container_port: _builtins.int,
                 name: _builtins.str,
                 protocol: _builtins.str):
        """
        :param _builtins.int container_port: Port number the container listens on. This must be a valid port number (between 1 and 65535). Defaults to "8080".
        :param _builtins.str name: The name of the Cloud Run Service.
        :param _builtins.str protocol: Protocol for port. Must be "TCP". Defaults to "TCP".
        """
        pulumi.set(__self__, "container_port", container_port)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> _builtins.int:
        """
        Port number the container listens on. This must be a valid port number (between 1 and 65535). Defaults to "8080".
        """
        return pulumi.get(self, "container_port")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run Service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Protocol for port. Must be "TCP". Defaults to "TCP".
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class GetServiceTemplateSpecContainerResourceResult(dict):
    def __init__(__self__, *,
                 limits: Mapping[str, _builtins.str],
                 requests: Mapping[str, _builtins.str]):
        """
        :param Mapping[str, _builtins.str] limits: Limits describes the maximum amount of compute resources allowed.
               The values of the map is string form of the 'quantity' k8s type:
               https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        :param Mapping[str, _builtins.str] requests: Requests describes the minimum amount of compute resources required.
               If Requests is omitted for a container, it defaults to Limits if that is
               explicitly specified, otherwise to an implementation-defined value.
               The values of the map is string form of the 'quantity' k8s type:
               https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        pulumi.set(__self__, "limits", limits)
        pulumi.set(__self__, "requests", requests)

    @_builtins.property
    @pulumi.getter
    def limits(self) -> Mapping[str, _builtins.str]:
        """
        Limits describes the maximum amount of compute resources allowed.
        The values of the map is string form of the 'quantity' k8s type:
        https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "limits")

    @_builtins.property
    @pulumi.getter
    def requests(self) -> Mapping[str, _builtins.str]:
        """
        Requests describes the minimum amount of compute resources required.
        If Requests is omitted for a container, it defaults to Limits if that is
        explicitly specified, otherwise to an implementation-defined value.
        The values of the map is string form of the 'quantity' k8s type:
        https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "requests")


@pulumi.output_type
class GetServiceTemplateSpecContainerStartupProbeResult(dict):
    def __init__(__self__, *,
                 failure_threshold: _builtins.int,
                 grpcs: Sequence['outputs.GetServiceTemplateSpecContainerStartupProbeGrpcResult'],
                 http_gets: Sequence['outputs.GetServiceTemplateSpecContainerStartupProbeHttpGetResult'],
                 initial_delay_seconds: _builtins.int,
                 period_seconds: _builtins.int,
                 tcp_sockets: Sequence['outputs.GetServiceTemplateSpecContainerStartupProbeTcpSocketResult'],
                 timeout_seconds: _builtins.int):
        """
        :param _builtins.int failure_threshold: Minimum consecutive failures for the probe to be considered failed after
               having succeeded. Defaults to 3. Minimum value is 1.
        :param Sequence['GetServiceTemplateSpecContainerStartupProbeGrpcArgs'] grpcs: GRPC specifies an action involving a GRPC port.
        :param Sequence['GetServiceTemplateSpecContainerStartupProbeHttpGetArgs'] http_gets: HttpGet specifies the http request to perform.
        :param _builtins.int initial_delay_seconds: Number of seconds after the container has started before the probe is
               initiated.
               Defaults to 0 seconds. Minimum value is 0. Maximum value is 240.
        :param _builtins.int period_seconds: How often (in seconds) to perform the probe.
               Default to 10 seconds. Minimum value is 1. Maximum value is 240.
        :param Sequence['GetServiceTemplateSpecContainerStartupProbeTcpSocketArgs'] tcp_sockets: TcpSocket specifies an action involving a TCP port.
        :param _builtins.int timeout_seconds: Number of seconds after which the probe times out.
               Defaults to 1 second. Minimum value is 1. Maximum value is 3600.
               Must be smaller than periodSeconds.
        """
        pulumi.set(__self__, "failure_threshold", failure_threshold)
        pulumi.set(__self__, "grpcs", grpcs)
        pulumi.set(__self__, "http_gets", http_gets)
        pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        pulumi.set(__self__, "period_seconds", period_seconds)
        pulumi.set(__self__, "tcp_sockets", tcp_sockets)
        pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @_builtins.property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> _builtins.int:
        """
        Minimum consecutive failures for the probe to be considered failed after
        having succeeded. Defaults to 3. Minimum value is 1.
        """
        return pulumi.get(self, "failure_threshold")

    @_builtins.property
    @pulumi.getter
    def grpcs(self) -> Sequence['outputs.GetServiceTemplateSpecContainerStartupProbeGrpcResult']:
        """
        GRPC specifies an action involving a GRPC port.
        """
        return pulumi.get(self, "grpcs")

    @_builtins.property
    @pulumi.getter(name="httpGets")
    def http_gets(self) -> Sequence['outputs.GetServiceTemplateSpecContainerStartupProbeHttpGetResult']:
        """
        HttpGet specifies the http request to perform.
        """
        return pulumi.get(self, "http_gets")

    @_builtins.property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> _builtins.int:
        """
        Number of seconds after the container has started before the probe is
        initiated.
        Defaults to 0 seconds. Minimum value is 0. Maximum value is 240.
        """
        return pulumi.get(self, "initial_delay_seconds")

    @_builtins.property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> _builtins.int:
        """
        How often (in seconds) to perform the probe.
        Default to 10 seconds. Minimum value is 1. Maximum value is 240.
        """
        return pulumi.get(self, "period_seconds")

    @_builtins.property
    @pulumi.getter(name="tcpSockets")
    def tcp_sockets(self) -> Sequence['outputs.GetServiceTemplateSpecContainerStartupProbeTcpSocketResult']:
        """
        TcpSocket specifies an action involving a TCP port.
        """
        return pulumi.get(self, "tcp_sockets")

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> _builtins.int:
        """
        Number of seconds after which the probe times out.
        Defaults to 1 second. Minimum value is 1. Maximum value is 3600.
        Must be smaller than periodSeconds.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class GetServiceTemplateSpecContainerStartupProbeGrpcResult(dict):
    def __init__(__self__, *,
                 port: _builtins.int,
                 service: _builtins.str):
        """
        :param _builtins.int port: Port number to access on the container. Number must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        :param _builtins.str service: The name of the service to place in the gRPC HealthCheckRequest
               (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
               If this is not specified, the default behavior is defined by gRPC.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "service", service)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def service(self) -> _builtins.str:
        """
        The name of the service to place in the gRPC HealthCheckRequest
        (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
        If this is not specified, the default behavior is defined by gRPC.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class GetServiceTemplateSpecContainerStartupProbeHttpGetResult(dict):
    def __init__(__self__, *,
                 http_headers: Sequence['outputs.GetServiceTemplateSpecContainerStartupProbeHttpGetHttpHeaderResult'],
                 path: _builtins.str,
                 port: _builtins.int):
        """
        :param Sequence['GetServiceTemplateSpecContainerStartupProbeHttpGetHttpHeaderArgs'] http_headers: Custom headers to set in the request. HTTP allows repeated headers.
        :param _builtins.str path: Path to access on the HTTP server. If set, it should not be empty string.
        :param _builtins.int port: Port number to access on the container. Number must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        pulumi.set(__self__, "http_headers", http_headers)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Sequence['outputs.GetServiceTemplateSpecContainerStartupProbeHttpGetHttpHeaderResult']:
        """
        Custom headers to set in the request. HTTP allows repeated headers.
        """
        return pulumi.get(self, "http_headers")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Path to access on the HTTP server. If set, it should not be empty string.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetServiceTemplateSpecContainerStartupProbeHttpGetHttpHeaderResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The name of the Cloud Run Service.
        :param _builtins.str value: The header field value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run Service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The header field value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServiceTemplateSpecContainerStartupProbeTcpSocketResult(dict):
    def __init__(__self__, *,
                 port: _builtins.int):
        """
        :param _builtins.int port: Port number to access on the container. Number must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetServiceTemplateSpecContainerVolumeMountResult(dict):
    def __init__(__self__, *,
                 mount_path: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str mount_path: Path within the container at which the volume should be mounted.  Must
               not contain ':'.
        :param _builtins.str name: The name of the Cloud Run Service.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> _builtins.str:
        """
        Path within the container at which the volume should be mounted.  Must
        not contain ':'.
        """
        return pulumi.get(self, "mount_path")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run Service.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetServiceTemplateSpecVolumeResult(dict):
    def __init__(__self__, *,
                 csis: Sequence['outputs.GetServiceTemplateSpecVolumeCsiResult'],
                 empty_dirs: Sequence['outputs.GetServiceTemplateSpecVolumeEmptyDirResult'],
                 name: _builtins.str,
                 nfs: Sequence['outputs.GetServiceTemplateSpecVolumeNfResult'],
                 secrets: Sequence['outputs.GetServiceTemplateSpecVolumeSecretResult']):
        """
        :param Sequence['GetServiceTemplateSpecVolumeCsiArgs'] csis: A filesystem specified by the Container Storage Interface (CSI).
        :param Sequence['GetServiceTemplateSpecVolumeEmptyDirArgs'] empty_dirs: Ephemeral storage which can be backed by real disks (HD, SSD), network storage or memory (i.e. tmpfs). For now only in memory (tmpfs) is supported. It is ephemeral in the sense that when the sandbox is taken down, the data is destroyed with it (it does not persist across sandbox runs).
        :param _builtins.str name: The name of the Cloud Run Service.
        :param Sequence['GetServiceTemplateSpecVolumeNfArgs'] nfs: A filesystem backed by a Network File System share. This filesystem requires the
               run.googleapis.com/execution-environment annotation to be unset or set to "gen2"
        :param Sequence['GetServiceTemplateSpecVolumeSecretArgs'] secrets: The secret's value will be presented as the content of a file whose
               name is defined in the item path. If no items are defined, the name of
               the file is the secret_name.
        """
        pulumi.set(__self__, "csis", csis)
        pulumi.set(__self__, "empty_dirs", empty_dirs)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nfs", nfs)
        pulumi.set(__self__, "secrets", secrets)

    @_builtins.property
    @pulumi.getter
    def csis(self) -> Sequence['outputs.GetServiceTemplateSpecVolumeCsiResult']:
        """
        A filesystem specified by the Container Storage Interface (CSI).
        """
        return pulumi.get(self, "csis")

    @_builtins.property
    @pulumi.getter(name="emptyDirs")
    def empty_dirs(self) -> Sequence['outputs.GetServiceTemplateSpecVolumeEmptyDirResult']:
        """
        Ephemeral storage which can be backed by real disks (HD, SSD), network storage or memory (i.e. tmpfs). For now only in memory (tmpfs) is supported. It is ephemeral in the sense that when the sandbox is taken down, the data is destroyed with it (it does not persist across sandbox runs).
        """
        return pulumi.get(self, "empty_dirs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run Service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def nfs(self) -> Sequence['outputs.GetServiceTemplateSpecVolumeNfResult']:
        """
        A filesystem backed by a Network File System share. This filesystem requires the
        run.googleapis.com/execution-environment annotation to be unset or set to "gen2"
        """
        return pulumi.get(self, "nfs")

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Sequence['outputs.GetServiceTemplateSpecVolumeSecretResult']:
        """
        The secret's value will be presented as the content of a file whose
        name is defined in the item path. If no items are defined, the name of
        the file is the secret_name.
        """
        return pulumi.get(self, "secrets")


@pulumi.output_type
class GetServiceTemplateSpecVolumeCsiResult(dict):
    def __init__(__self__, *,
                 driver: _builtins.str,
                 read_only: _builtins.bool,
                 volume_attributes: Mapping[str, _builtins.str]):
        """
        :param _builtins.str driver: Unique name representing the type of file system to be created. Cloud Run supports the following values:
                 * gcsfuse.run.googleapis.com: Mount a Google Cloud Storage bucket using GCSFuse. This driver requires the
                   run.googleapis.com/execution-environment annotation to be unset or set to "gen2"
        :param _builtins.bool read_only: If true, all mounts created from this volume will be read-only.
        :param Mapping[str, _builtins.str] volume_attributes: Driver-specific attributes. The following options are supported for available drivers:
                 * gcsfuse.run.googleapis.com
                   * bucketName: The name of the Cloud Storage Bucket that backs this volume. The Cloud Run Service identity must have access to this bucket.
        """
        pulumi.set(__self__, "driver", driver)
        pulumi.set(__self__, "read_only", read_only)
        pulumi.set(__self__, "volume_attributes", volume_attributes)

    @_builtins.property
    @pulumi.getter
    def driver(self) -> _builtins.str:
        """
        Unique name representing the type of file system to be created. Cloud Run supports the following values:
          * gcsfuse.run.googleapis.com: Mount a Google Cloud Storage bucket using GCSFuse. This driver requires the
            run.googleapis.com/execution-environment annotation to be unset or set to "gen2"
        """
        return pulumi.get(self, "driver")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> _builtins.bool:
        """
        If true, all mounts created from this volume will be read-only.
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="volumeAttributes")
    def volume_attributes(self) -> Mapping[str, _builtins.str]:
        """
        Driver-specific attributes. The following options are supported for available drivers:
          * gcsfuse.run.googleapis.com
            * bucketName: The name of the Cloud Storage Bucket that backs this volume. The Cloud Run Service identity must have access to this bucket.
        """
        return pulumi.get(self, "volume_attributes")


@pulumi.output_type
class GetServiceTemplateSpecVolumeEmptyDirResult(dict):
    def __init__(__self__, *,
                 medium: _builtins.str,
                 size_limit: _builtins.str):
        """
        :param _builtins.str medium: The medium on which the data is stored. The default is "" which means to use the node's default medium. Must be an empty string (default) or Memory.
        :param _builtins.str size_limit: Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
        """
        pulumi.set(__self__, "medium", medium)
        pulumi.set(__self__, "size_limit", size_limit)

    @_builtins.property
    @pulumi.getter
    def medium(self) -> _builtins.str:
        """
        The medium on which the data is stored. The default is "" which means to use the node's default medium. Must be an empty string (default) or Memory.
        """
        return pulumi.get(self, "medium")

    @_builtins.property
    @pulumi.getter(name="sizeLimit")
    def size_limit(self) -> _builtins.str:
        """
        Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
        """
        return pulumi.get(self, "size_limit")


@pulumi.output_type
class GetServiceTemplateSpecVolumeNfResult(dict):
    def __init__(__self__, *,
                 path: _builtins.str,
                 read_only: _builtins.bool,
                 server: _builtins.str):
        """
        :param _builtins.str path: Path exported by the NFS server
        :param _builtins.bool read_only: If true, mount the NFS volume as read only in all mounts. Defaults to false.
        :param _builtins.str server: IP address or hostname of the NFS server
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "read_only", read_only)
        pulumi.set(__self__, "server", server)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Path exported by the NFS server
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> _builtins.bool:
        """
        If true, mount the NFS volume as read only in all mounts. Defaults to false.
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter
    def server(self) -> _builtins.str:
        """
        IP address or hostname of the NFS server
        """
        return pulumi.get(self, "server")


@pulumi.output_type
class GetServiceTemplateSpecVolumeSecretResult(dict):
    def __init__(__self__, *,
                 default_mode: _builtins.int,
                 items: Sequence['outputs.GetServiceTemplateSpecVolumeSecretItemResult'],
                 secret_name: _builtins.str):
        """
        :param _builtins.int default_mode: Mode bits to use on created files by default. Must be a value between 0000
               and 0777. Defaults to 0644. Directories within the path are not affected by
               this setting. This might be in conflict with other options that affect the
               file mode, like fsGroup, and the result can be other mode bits set.
        :param Sequence['GetServiceTemplateSpecVolumeSecretItemArgs'] items: If unspecified, the volume will expose a file whose name is the
               secret_name.
               If specified, the key will be used as the version to fetch from Cloud
               Secret Manager and the path will be the name of the file exposed in the
               volume. When items are defined, they must specify a key and a path.
        :param _builtins.str secret_name: The name of the secret in Cloud Secret Manager. By default, the secret
               is assumed to be in the same project.
               If the secret is in another project, you must define an alias.
               An alias definition has the form:
               {alias}:projects/{project-id|project-number}/secrets/{secret-name}.
               If multiple alias definitions are needed, they must be separated by
               commas.
               The alias definitions must be set on the run.googleapis.com/secrets
               annotation.
        """
        pulumi.set(__self__, "default_mode", default_mode)
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "secret_name", secret_name)

    @_builtins.property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> _builtins.int:
        """
        Mode bits to use on created files by default. Must be a value between 0000
        and 0777. Defaults to 0644. Directories within the path are not affected by
        this setting. This might be in conflict with other options that affect the
        file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "default_mode")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetServiceTemplateSpecVolumeSecretItemResult']:
        """
        If unspecified, the volume will expose a file whose name is the
        secret_name.
        If specified, the key will be used as the version to fetch from Cloud
        Secret Manager and the path will be the name of the file exposed in the
        volume. When items are defined, they must specify a key and a path.
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> _builtins.str:
        """
        The name of the secret in Cloud Secret Manager. By default, the secret
        is assumed to be in the same project.
        If the secret is in another project, you must define an alias.
        An alias definition has the form:
        {alias}:projects/{project-id|project-number}/secrets/{secret-name}.
        If multiple alias definitions are needed, they must be separated by
        commas.
        The alias definitions must be set on the run.googleapis.com/secrets
        annotation.
        """
        return pulumi.get(self, "secret_name")


@pulumi.output_type
class GetServiceTemplateSpecVolumeSecretItemResult(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 mode: _builtins.int,
                 path: _builtins.str):
        """
        :param _builtins.str key: The Cloud Secret Manager secret version.
               Can be 'latest' for the latest value or an integer for a specific version.
        :param _builtins.int mode: Mode bits to use on this file, must be a value between 0000 and 0777. If
               not specified, the volume defaultMode will be used. This might be in
               conflict with other options that affect the file mode, like fsGroup, and
               the result can be other mode bits set.
        :param _builtins.str path: The relative path of the file to map the key to.
               May not be an absolute path.
               May not contain the path element '..'.
               May not start with the string '..'.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The Cloud Secret Manager secret version.
        Can be 'latest' for the latest value or an integer for a specific version.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.int:
        """
        Mode bits to use on this file, must be a value between 0000 and 0777. If
        not specified, the volume defaultMode will be used. This might be in
        conflict with other options that affect the file mode, like fsGroup, and
        the result can be other mode bits set.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The relative path of the file to map the key to.
        May not be an absolute path.
        May not contain the path element '..'.
        May not start with the string '..'.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class GetServiceTrafficResult(dict):
    def __init__(__self__, *,
                 latest_revision: _builtins.bool,
                 percent: _builtins.int,
                 revision_name: _builtins.str,
                 tag: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.bool latest_revision: LatestRevision may be optionally provided to indicate that the latest ready
               Revision of the Configuration should be used for this traffic target. When
               provided LatestRevision must be true if RevisionName is empty; it must be
               false when RevisionName is non-empty.
        :param _builtins.int percent: Percent specifies percent of the traffic to this Revision or Configuration.
        :param _builtins.str revision_name: RevisionName of a specific revision to which to send this portion of traffic.
        :param _builtins.str tag: Tag is optionally used to expose a dedicated url for referencing this target exclusively.
        :param _builtins.str url: URL displays the URL for accessing tagged traffic targets. URL is displayed in status,
               and is disallowed on spec. URL must contain a scheme (e.g. http://) and a hostname,
               but may not contain anything else (e.g. basic auth, url path, etc.)
        """
        pulumi.set(__self__, "latest_revision", latest_revision)
        pulumi.set(__self__, "percent", percent)
        pulumi.set(__self__, "revision_name", revision_name)
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="latestRevision")
    def latest_revision(self) -> _builtins.bool:
        """
        LatestRevision may be optionally provided to indicate that the latest ready
        Revision of the Configuration should be used for this traffic target. When
        provided LatestRevision must be true if RevisionName is empty; it must be
        false when RevisionName is non-empty.
        """
        return pulumi.get(self, "latest_revision")

    @_builtins.property
    @pulumi.getter
    def percent(self) -> _builtins.int:
        """
        Percent specifies percent of the traffic to this Revision or Configuration.
        """
        return pulumi.get(self, "percent")

    @_builtins.property
    @pulumi.getter(name="revisionName")
    def revision_name(self) -> _builtins.str:
        """
        RevisionName of a specific revision to which to send this portion of traffic.
        """
        return pulumi.get(self, "revision_name")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> _builtins.str:
        """
        Tag is optionally used to expose a dedicated url for referencing this target exclusively.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        URL displays the URL for accessing tagged traffic targets. URL is displayed in status,
        and is disallowed on spec. URL must contain a scheme (e.g. http://) and a hostname,
        but may not contain anything else (e.g. basic auth, url path, etc.)
        """
        return pulumi.get(self, "url")


