# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BackendServiceArgs', 'BackendService']

@pulumi.input_type
class BackendServiceArgs:
    def __init__(__self__, *,
                 affinity_cookie_ttl_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 backends: Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceBackendArgs']]]] = None,
                 cdn_policy: Optional[pulumi.Input['BackendServiceCdnPolicyArgs']] = None,
                 circuit_breakers: Optional[pulumi.Input['BackendServiceCircuitBreakersArgs']] = None,
                 compression_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_draining_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 consistent_hash: Optional[pulumi.Input['BackendServiceConsistentHashArgs']] = None,
                 custom_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceCustomMetricArgs']]]] = None,
                 custom_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 custom_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic_forwarding: Optional[pulumi.Input['BackendServiceDynamicForwardingArgs']] = None,
                 edge_security_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_cdn: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_managed_migration_state: Optional[pulumi.Input[_builtins.str]] = None,
                 external_managed_migration_testing_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 health_checks: Optional[pulumi.Input[_builtins.str]] = None,
                 iap: Optional[pulumi.Input['BackendServiceIapArgs']] = None,
                 ip_address_selection_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 locality_lb_policies: Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceLocalityLbPolicyArgs']]]] = None,
                 locality_lb_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 log_config: Optional[pulumi.Input['BackendServiceLogConfigArgs']] = None,
                 max_stream_duration: Optional[pulumi.Input['BackendServiceMaxStreamDurationArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_pass_through_lb_traffic_policy: Optional[pulumi.Input['BackendServiceNetworkPassThroughLbTrafficPolicyArgs']] = None,
                 outlier_detection: Optional[pulumi.Input['BackendServiceOutlierDetectionArgs']] = None,
                 params: Optional[pulumi.Input['BackendServiceParamsArgs']] = None,
                 port_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 security_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_settings: Optional[pulumi.Input['BackendServiceSecuritySettingsArgs']] = None,
                 service_lb_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 session_affinity: Optional[pulumi.Input[_builtins.str]] = None,
                 strong_session_affinity_cookie: Optional[pulumi.Input['BackendServiceStrongSessionAffinityCookieArgs']] = None,
                 timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 tls_settings: Optional[pulumi.Input['BackendServiceTlsSettingsArgs']] = None):
        """
        The set of arguments for constructing a BackendService resource.
        :param pulumi.Input[_builtins.int] affinity_cookie_ttl_sec: Lifetime of cookies in seconds if session_affinity is
               GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
               only until the end of the browser session (or equivalent). The
               maximum allowed value for TTL is one day.
               When the load balancing scheme is INTERNAL, this field is not used.
        :param pulumi.Input[Sequence[pulumi.Input['BackendServiceBackendArgs']]] backends: The set of backends that serve this BackendService.
               Structure is documented below.
        :param pulumi.Input['BackendServiceCdnPolicyArgs'] cdn_policy: Cloud CDN configuration for this BackendService.
               Structure is documented below.
        :param pulumi.Input['BackendServiceCircuitBreakersArgs'] circuit_breakers: Settings controlling the volume of connections to a backend service. This field
               is applicable only when the load_balancing_scheme is set to INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] compression_mode: Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
               Possible values are: `AUTOMATIC`, `DISABLED`.
        :param pulumi.Input[_builtins.int] connection_draining_timeout_sec: Time for which instance will be drained (not accept new
               connections, but still work to finish started).
        :param pulumi.Input['BackendServiceConsistentHashArgs'] consistent_hash: Consistent Hash-based load balancing can be used to provide soft session
               affinity based on HTTP headers, cookies or other properties. This load balancing
               policy is applicable only for HTTP connections. The affinity to a particular
               destination host will be lost when one or more hosts are added/removed from the
               destination service. This field specifies parameters that control consistent
               hashing. This field only applies if the load_balancing_scheme is set to
               INTERNAL_SELF_MANAGED. This field is only applicable when locality_lb_policy is
               set to MAGLEV or RING_HASH.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['BackendServiceCustomMetricArgs']]] custom_metrics: List of custom metrics that are used for the WEIGHTED_ROUND_ROBIN locality_lb_policy.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_request_headers: Headers that the HTTP/S load balancer should add to proxied
               requests.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_response_headers: Headers that the HTTP/S load balancer should add to proxied
               responses.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input['BackendServiceDynamicForwardingArgs'] dynamic_forwarding: Dynamic forwarding configuration. This field is used to configure the backend service with dynamic forwarding
               feature which together with Service Extension allows customized and complex routing logic.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] edge_security_policy: The resource URL for the edge security policy associated with this backend service.
        :param pulumi.Input[_builtins.bool] enable_cdn: If true, enable Cloud CDN for this BackendService.
        :param pulumi.Input[_builtins.str] external_managed_migration_state: Specifies the canary migration state. Possible values are PREPARE, TEST_BY_PERCENTAGE, and
               TEST_ALL_TRAFFIC.
               To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to
               PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be
               changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate
               traffic by percentage using externalManagedMigrationTestingPercentage.
               Rolling back a migration requires the states to be set in reverse order. So changing the
               scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at
               the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic
               back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
               Possible values are: `PREPARE`, `TEST_BY_PERCENTAGE`, `TEST_ALL_TRAFFIC`.
        :param pulumi.Input[_builtins.float] external_managed_migration_testing_percentage: Determines the fraction of requests that should be processed by the Global external
               Application Load Balancer.
               The value of this field must be in the range [0, 100].
               Session affinity options will slightly affect this routing behavior, for more details,
               see: Session Affinity.
               This value can only be set if the loadBalancingScheme in the backend service is set to
               EXTERNAL (when using the Classic ALB) and the migration state is TEST_BY_PERCENTAGE.
        :param pulumi.Input[_builtins.str] health_checks: The set of URLs to the HttpHealthCheck or HttpsHealthCheck resource
               for health checking this BackendService. Currently at most one health
               check can be specified.
               A health check must be specified unless the backend service uses an internet
               or serverless NEG as a backend.
               For internal load balancing, a URL to a HealthCheck resource must be specified instead.
        :param pulumi.Input['BackendServiceIapArgs'] iap: Settings for enabling Cloud Identity Aware Proxy.
               If OAuth client is not set, the Google-managed OAuth client is used.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] ip_address_selection_policy: Specifies preference of traffic to the backend (from the proxy and from the client for proxyless gRPC).
               Possible values are: `IPV4_ONLY`, `PREFER_IPV6`, `IPV6_ONLY`.
        :param pulumi.Input[_builtins.str] load_balancing_scheme: Indicates whether the backend service will be used with internal or
               external load balancing. A backend service created for one type of
               load balancing cannot be used with the other. For more information, refer to
               [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service).
               Default value is `EXTERNAL`.
               Possible values are: `EXTERNAL`, `INTERNAL_SELF_MANAGED`, `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`.
        :param pulumi.Input[Sequence[pulumi.Input['BackendServiceLocalityLbPolicyArgs']]] locality_lb_policies: A list of locality load balancing policies to be used in order of
               preference. Either the policy or the customPolicy field should be set.
               Overrides any value set in the localityLbPolicy field.
               localityLbPolicies is only supported when the BackendService is referenced
               by a URL Map that is referenced by a target gRPC proxy that has the
               validateForProxyless field set to true.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] locality_lb_policy: The load balancing algorithm used within the scope of the locality.
               The possible values are:
               * `ROUND_ROBIN`: This is a simple policy in which each healthy backend
               is selected in round robin order.
               * `LEAST_REQUEST`: An O(1) algorithm which selects two random healthy
               hosts and picks the host which has fewer active requests.
               * `RING_HASH`: The ring/modulo hash load balancer implements consistent
               hashing to backends. The algorithm has the property that the
               addition/removal of a host from a set of N hosts only affects
               1/N of the requests.
               * `RANDOM`: The load balancer selects a random healthy host.
               * `ORIGINAL_DESTINATION`: Backend host is selected based on the client
               connection metadata, i.e., connections are opened
               to the same address as the destination address of
               the incoming connection before the connection
               was redirected to the load balancer.
               * `MAGLEV`: used as a drop in replacement for the ring hash load balancer.
               Maglev is not as stable as ring hash but has faster table lookup
               build times and host selection times. For more information about
               Maglev, refer to https://ai.google/research/pubs/pub44824
               * `WEIGHTED_MAGLEV`: Per-instance weighted Load Balancing via health check
               reported weights. Only applicable to loadBalancingScheme
               EXTERNAL. If set, the Backend Service must
               configure a non legacy HTTP-based Health Check, and
               health check replies are expected to contain
               non-standard HTTP response header field
               X-Load-Balancing-Endpoint-Weight to specify the
               per-instance weights. If set, Load Balancing is weight
               based on the per-instance weights reported in the last
               processed health check replies, as long as every
               instance either reported a valid weight or had
               UNAVAILABLE_WEIGHT. Otherwise, Load Balancing remains
               equal-weight.
               * `WEIGHTED_ROUND_ROBIN`: Per-endpoint weighted round-robin Load Balancing using weights computed
               from Backend reported Custom Metrics. If set, the Backend Service
               responses are expected to contain non-standard HTTP response header field
               X-Endpoint-Load-Metrics. The reported metrics
               to use for computing the weights are specified via the
               backends[].customMetrics fields.
               locality_lb_policy is applicable to either:
               * A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C,
               and loadBalancingScheme set to INTERNAL_MANAGED.
               * A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
               * A regional backend service with loadBalancingScheme set to EXTERNAL (External Network
               Load Balancing). Only MAGLEV and WEIGHTED_MAGLEV values are possible for External
               Network Load Balancing. The default is MAGLEV.
               If session_affinity is not NONE, and locality_lb_policy is not set to MAGLEV, WEIGHTED_MAGLEV,
               or RING_HASH, session affinity settings will not take effect.
               Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced
               by a URL map that is bound to target gRPC proxy that has validate_for_proxyless
               field set to true.
               Possible values are: `ROUND_ROBIN`, `LEAST_REQUEST`, `RING_HASH`, `RANDOM`, `ORIGINAL_DESTINATION`, `MAGLEV`, `WEIGHTED_MAGLEV`, `WEIGHTED_ROUND_ROBIN`.
        :param pulumi.Input['BackendServiceLogConfigArgs'] log_config: This field denotes the logging options for the load balancer traffic served by this backend service.
               If logging is enabled, logs will be exported to Stackdriver.
               Structure is documented below.
        :param pulumi.Input['BackendServiceMaxStreamDurationArgs'] max_stream_duration: Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the
               beginning of the stream until the response has been completely processed, including all retries. A stream that
               does not complete in this duration is closed.
               If not specified, there will be no timeout limit, i.e. the maximum duration is infinite.
               This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service.
               This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input['BackendServiceNetworkPassThroughLbTrafficPolicyArgs'] network_pass_through_lb_traffic_policy: Configures traffic steering properties of internal passthrough Network Load Balancers.
               Structure is documented below.
        :param pulumi.Input['BackendServiceOutlierDetectionArgs'] outlier_detection: Settings controlling eviction of unhealthy hosts from the load balancing pool.
               Applicable backend service types can be a global backend service with the
               loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED.
               Structure is documented below.
        :param pulumi.Input['BackendServiceParamsArgs'] params: Additional params passed with the request, but not persisted as part of resource payload
               Structure is documented below.
        :param pulumi.Input[_builtins.str] port_name: Name of backend port. The same name should appear in the instance
               groups referenced by this service. Required when the load balancing
               scheme is EXTERNAL.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] protocol: The protocol this BackendService uses to communicate with backends.
               The default is HTTP. Possible values are HTTP, HTTPS, HTTP2, H2C, TCP, SSL, UDP
               or GRPC. Refer to the documentation for the load balancers or for Traffic Director
               for more information. Must be set to GRPC when the backend service is referenced
               by a URL map that is bound to target gRPC proxy.
               Possible values are: `HTTP`, `HTTPS`, `HTTP2`, `TCP`, `SSL`, `UDP`, `GRPC`, `UNSPECIFIED`, `H2C`.
        :param pulumi.Input[_builtins.str] security_policy: The security policy associated with this backend service.
        :param pulumi.Input['BackendServiceSecuritySettingsArgs'] security_settings: The security settings that apply to this backend service. This field is applicable to either
               a regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C, and
               load_balancing_scheme set to INTERNAL_MANAGED; or a global backend service with the
               load_balancing_scheme set to INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] service_lb_policy: URL to networkservices.ServiceLbPolicy resource.
               Can only be set if load balancing scheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED or INTERNAL_SELF_MANAGED and the scope is global.
        :param pulumi.Input[_builtins.str] session_affinity: Type of session affinity to use. The default is NONE. Session affinity is
               not applicable if the protocol is UDP.
               Possible values are: `NONE`, `CLIENT_IP`, `CLIENT_IP_PORT_PROTO`, `CLIENT_IP_PROTO`, `GENERATED_COOKIE`, `HEADER_FIELD`, `HTTP_COOKIE`, `STRONG_COOKIE_AFFINITY`.
        :param pulumi.Input['BackendServiceStrongSessionAffinityCookieArgs'] strong_session_affinity_cookie: Describes the HTTP cookie used for stateful session affinity. This field is applicable and required if the sessionAffinity is set to STRONG_COOKIE_AFFINITY.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] timeout_sec: The backend service timeout has a different meaning depending on the type of load balancer.
               For more information see, [Backend service settings](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices).
               The default is 30 seconds.
               The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds.
        :param pulumi.Input['BackendServiceTlsSettingsArgs'] tls_settings: Configuration for Backend Authenticated TLS and mTLS. May only be specified when the backend protocol is SSL, HTTPS or HTTP2.
               Structure is documented below.
        """
        if affinity_cookie_ttl_sec is not None:
            pulumi.set(__self__, "affinity_cookie_ttl_sec", affinity_cookie_ttl_sec)
        if backends is not None:
            pulumi.set(__self__, "backends", backends)
        if cdn_policy is not None:
            pulumi.set(__self__, "cdn_policy", cdn_policy)
        if circuit_breakers is not None:
            pulumi.set(__self__, "circuit_breakers", circuit_breakers)
        if compression_mode is not None:
            pulumi.set(__self__, "compression_mode", compression_mode)
        if connection_draining_timeout_sec is not None:
            pulumi.set(__self__, "connection_draining_timeout_sec", connection_draining_timeout_sec)
        if consistent_hash is not None:
            pulumi.set(__self__, "consistent_hash", consistent_hash)
        if custom_metrics is not None:
            pulumi.set(__self__, "custom_metrics", custom_metrics)
        if custom_request_headers is not None:
            pulumi.set(__self__, "custom_request_headers", custom_request_headers)
        if custom_response_headers is not None:
            pulumi.set(__self__, "custom_response_headers", custom_response_headers)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dynamic_forwarding is not None:
            pulumi.set(__self__, "dynamic_forwarding", dynamic_forwarding)
        if edge_security_policy is not None:
            pulumi.set(__self__, "edge_security_policy", edge_security_policy)
        if enable_cdn is not None:
            pulumi.set(__self__, "enable_cdn", enable_cdn)
        if external_managed_migration_state is not None:
            pulumi.set(__self__, "external_managed_migration_state", external_managed_migration_state)
        if external_managed_migration_testing_percentage is not None:
            pulumi.set(__self__, "external_managed_migration_testing_percentage", external_managed_migration_testing_percentage)
        if health_checks is not None:
            pulumi.set(__self__, "health_checks", health_checks)
        if iap is not None:
            pulumi.set(__self__, "iap", iap)
        if ip_address_selection_policy is not None:
            pulumi.set(__self__, "ip_address_selection_policy", ip_address_selection_policy)
        if load_balancing_scheme is not None:
            pulumi.set(__self__, "load_balancing_scheme", load_balancing_scheme)
        if locality_lb_policies is not None:
            pulumi.set(__self__, "locality_lb_policies", locality_lb_policies)
        if locality_lb_policy is not None:
            pulumi.set(__self__, "locality_lb_policy", locality_lb_policy)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if max_stream_duration is not None:
            pulumi.set(__self__, "max_stream_duration", max_stream_duration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_pass_through_lb_traffic_policy is not None:
            pulumi.set(__self__, "network_pass_through_lb_traffic_policy", network_pass_through_lb_traffic_policy)
        if outlier_detection is not None:
            pulumi.set(__self__, "outlier_detection", outlier_detection)
        if params is not None:
            pulumi.set(__self__, "params", params)
        if port_name is not None:
            pulumi.set(__self__, "port_name", port_name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if security_policy is not None:
            pulumi.set(__self__, "security_policy", security_policy)
        if security_settings is not None:
            pulumi.set(__self__, "security_settings", security_settings)
        if service_lb_policy is not None:
            pulumi.set(__self__, "service_lb_policy", service_lb_policy)
        if session_affinity is not None:
            pulumi.set(__self__, "session_affinity", session_affinity)
        if strong_session_affinity_cookie is not None:
            pulumi.set(__self__, "strong_session_affinity_cookie", strong_session_affinity_cookie)
        if timeout_sec is not None:
            pulumi.set(__self__, "timeout_sec", timeout_sec)
        if tls_settings is not None:
            pulumi.set(__self__, "tls_settings", tls_settings)

    @_builtins.property
    @pulumi.getter(name="affinityCookieTtlSec")
    def affinity_cookie_ttl_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Lifetime of cookies in seconds if session_affinity is
        GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
        only until the end of the browser session (or equivalent). The
        maximum allowed value for TTL is one day.
        When the load balancing scheme is INTERNAL, this field is not used.
        """
        return pulumi.get(self, "affinity_cookie_ttl_sec")

    @affinity_cookie_ttl_sec.setter
    def affinity_cookie_ttl_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "affinity_cookie_ttl_sec", value)

    @_builtins.property
    @pulumi.getter
    def backends(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceBackendArgs']]]]:
        """
        The set of backends that serve this BackendService.
        Structure is documented below.
        """
        return pulumi.get(self, "backends")

    @backends.setter
    def backends(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceBackendArgs']]]]):
        pulumi.set(self, "backends", value)

    @_builtins.property
    @pulumi.getter(name="cdnPolicy")
    def cdn_policy(self) -> Optional[pulumi.Input['BackendServiceCdnPolicyArgs']]:
        """
        Cloud CDN configuration for this BackendService.
        Structure is documented below.
        """
        return pulumi.get(self, "cdn_policy")

    @cdn_policy.setter
    def cdn_policy(self, value: Optional[pulumi.Input['BackendServiceCdnPolicyArgs']]):
        pulumi.set(self, "cdn_policy", value)

    @_builtins.property
    @pulumi.getter(name="circuitBreakers")
    def circuit_breakers(self) -> Optional[pulumi.Input['BackendServiceCircuitBreakersArgs']]:
        """
        Settings controlling the volume of connections to a backend service. This field
        is applicable only when the load_balancing_scheme is set to INTERNAL_SELF_MANAGED.
        Structure is documented below.
        """
        return pulumi.get(self, "circuit_breakers")

    @circuit_breakers.setter
    def circuit_breakers(self, value: Optional[pulumi.Input['BackendServiceCircuitBreakersArgs']]):
        pulumi.set(self, "circuit_breakers", value)

    @_builtins.property
    @pulumi.getter(name="compressionMode")
    def compression_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
        Possible values are: `AUTOMATIC`, `DISABLED`.
        """
        return pulumi.get(self, "compression_mode")

    @compression_mode.setter
    def compression_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compression_mode", value)

    @_builtins.property
    @pulumi.getter(name="connectionDrainingTimeoutSec")
    def connection_draining_timeout_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time for which instance will be drained (not accept new
        connections, but still work to finish started).
        """
        return pulumi.get(self, "connection_draining_timeout_sec")

    @connection_draining_timeout_sec.setter
    def connection_draining_timeout_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_draining_timeout_sec", value)

    @_builtins.property
    @pulumi.getter(name="consistentHash")
    def consistent_hash(self) -> Optional[pulumi.Input['BackendServiceConsistentHashArgs']]:
        """
        Consistent Hash-based load balancing can be used to provide soft session
        affinity based on HTTP headers, cookies or other properties. This load balancing
        policy is applicable only for HTTP connections. The affinity to a particular
        destination host will be lost when one or more hosts are added/removed from the
        destination service. This field specifies parameters that control consistent
        hashing. This field only applies if the load_balancing_scheme is set to
        INTERNAL_SELF_MANAGED. This field is only applicable when locality_lb_policy is
        set to MAGLEV or RING_HASH.
        Structure is documented below.
        """
        return pulumi.get(self, "consistent_hash")

    @consistent_hash.setter
    def consistent_hash(self, value: Optional[pulumi.Input['BackendServiceConsistentHashArgs']]):
        pulumi.set(self, "consistent_hash", value)

    @_builtins.property
    @pulumi.getter(name="customMetrics")
    def custom_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceCustomMetricArgs']]]]:
        """
        List of custom metrics that are used for the WEIGHTED_ROUND_ROBIN locality_lb_policy.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_metrics")

    @custom_metrics.setter
    def custom_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceCustomMetricArgs']]]]):
        pulumi.set(self, "custom_metrics", value)

    @_builtins.property
    @pulumi.getter(name="customRequestHeaders")
    def custom_request_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Headers that the HTTP/S load balancer should add to proxied
        requests.
        """
        return pulumi.get(self, "custom_request_headers")

    @custom_request_headers.setter
    def custom_request_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_request_headers", value)

    @_builtins.property
    @pulumi.getter(name="customResponseHeaders")
    def custom_response_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Headers that the HTTP/S load balancer should add to proxied
        responses.
        """
        return pulumi.get(self, "custom_response_headers")

    @custom_response_headers.setter
    def custom_response_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_response_headers", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dynamicForwarding")
    def dynamic_forwarding(self) -> Optional[pulumi.Input['BackendServiceDynamicForwardingArgs']]:
        """
        Dynamic forwarding configuration. This field is used to configure the backend service with dynamic forwarding
        feature which together with Service Extension allows customized and complex routing logic.
        Structure is documented below.
        """
        return pulumi.get(self, "dynamic_forwarding")

    @dynamic_forwarding.setter
    def dynamic_forwarding(self, value: Optional[pulumi.Input['BackendServiceDynamicForwardingArgs']]):
        pulumi.set(self, "dynamic_forwarding", value)

    @_builtins.property
    @pulumi.getter(name="edgeSecurityPolicy")
    def edge_security_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource URL for the edge security policy associated with this backend service.
        """
        return pulumi.get(self, "edge_security_policy")

    @edge_security_policy.setter
    def edge_security_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_security_policy", value)

    @_builtins.property
    @pulumi.getter(name="enableCdn")
    def enable_cdn(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, enable Cloud CDN for this BackendService.
        """
        return pulumi.get(self, "enable_cdn")

    @enable_cdn.setter
    def enable_cdn(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_cdn", value)

    @_builtins.property
    @pulumi.getter(name="externalManagedMigrationState")
    def external_managed_migration_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the canary migration state. Possible values are PREPARE, TEST_BY_PERCENTAGE, and
        TEST_ALL_TRAFFIC.
        To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to
        PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be
        changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate
        traffic by percentage using externalManagedMigrationTestingPercentage.
        Rolling back a migration requires the states to be set in reverse order. So changing the
        scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at
        the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic
        back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
        Possible values are: `PREPARE`, `TEST_BY_PERCENTAGE`, `TEST_ALL_TRAFFIC`.
        """
        return pulumi.get(self, "external_managed_migration_state")

    @external_managed_migration_state.setter
    def external_managed_migration_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_managed_migration_state", value)

    @_builtins.property
    @pulumi.getter(name="externalManagedMigrationTestingPercentage")
    def external_managed_migration_testing_percentage(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Determines the fraction of requests that should be processed by the Global external
        Application Load Balancer.
        The value of this field must be in the range [0, 100].
        Session affinity options will slightly affect this routing behavior, for more details,
        see: Session Affinity.
        This value can only be set if the loadBalancingScheme in the backend service is set to
        EXTERNAL (when using the Classic ALB) and the migration state is TEST_BY_PERCENTAGE.
        """
        return pulumi.get(self, "external_managed_migration_testing_percentage")

    @external_managed_migration_testing_percentage.setter
    def external_managed_migration_testing_percentage(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "external_managed_migration_testing_percentage", value)

    @_builtins.property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The set of URLs to the HttpHealthCheck or HttpsHealthCheck resource
        for health checking this BackendService. Currently at most one health
        check can be specified.
        A health check must be specified unless the backend service uses an internet
        or serverless NEG as a backend.
        For internal load balancing, a URL to a HealthCheck resource must be specified instead.
        """
        return pulumi.get(self, "health_checks")

    @health_checks.setter
    def health_checks(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_checks", value)

    @_builtins.property
    @pulumi.getter
    def iap(self) -> Optional[pulumi.Input['BackendServiceIapArgs']]:
        """
        Settings for enabling Cloud Identity Aware Proxy.
        If OAuth client is not set, the Google-managed OAuth client is used.
        Structure is documented below.
        """
        return pulumi.get(self, "iap")

    @iap.setter
    def iap(self, value: Optional[pulumi.Input['BackendServiceIapArgs']]):
        pulumi.set(self, "iap", value)

    @_builtins.property
    @pulumi.getter(name="ipAddressSelectionPolicy")
    def ip_address_selection_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies preference of traffic to the backend (from the proxy and from the client for proxyless gRPC).
        Possible values are: `IPV4_ONLY`, `PREFER_IPV6`, `IPV6_ONLY`.
        """
        return pulumi.get(self, "ip_address_selection_policy")

    @ip_address_selection_policy.setter
    def ip_address_selection_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address_selection_policy", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether the backend service will be used with internal or
        external load balancing. A backend service created for one type of
        load balancing cannot be used with the other. For more information, refer to
        [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service).
        Default value is `EXTERNAL`.
        Possible values are: `EXTERNAL`, `INTERNAL_SELF_MANAGED`, `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @load_balancing_scheme.setter
    def load_balancing_scheme(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancing_scheme", value)

    @_builtins.property
    @pulumi.getter(name="localityLbPolicies")
    def locality_lb_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceLocalityLbPolicyArgs']]]]:
        """
        A list of locality load balancing policies to be used in order of
        preference. Either the policy or the customPolicy field should be set.
        Overrides any value set in the localityLbPolicy field.
        localityLbPolicies is only supported when the BackendService is referenced
        by a URL Map that is referenced by a target gRPC proxy that has the
        validateForProxyless field set to true.
        Structure is documented below.
        """
        return pulumi.get(self, "locality_lb_policies")

    @locality_lb_policies.setter
    def locality_lb_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceLocalityLbPolicyArgs']]]]):
        pulumi.set(self, "locality_lb_policies", value)

    @_builtins.property
    @pulumi.getter(name="localityLbPolicy")
    def locality_lb_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The load balancing algorithm used within the scope of the locality.
        The possible values are:
        * `ROUND_ROBIN`: This is a simple policy in which each healthy backend
        is selected in round robin order.
        * `LEAST_REQUEST`: An O(1) algorithm which selects two random healthy
        hosts and picks the host which has fewer active requests.
        * `RING_HASH`: The ring/modulo hash load balancer implements consistent
        hashing to backends. The algorithm has the property that the
        addition/removal of a host from a set of N hosts only affects
        1/N of the requests.
        * `RANDOM`: The load balancer selects a random healthy host.
        * `ORIGINAL_DESTINATION`: Backend host is selected based on the client
        connection metadata, i.e., connections are opened
        to the same address as the destination address of
        the incoming connection before the connection
        was redirected to the load balancer.
        * `MAGLEV`: used as a drop in replacement for the ring hash load balancer.
        Maglev is not as stable as ring hash but has faster table lookup
        build times and host selection times. For more information about
        Maglev, refer to https://ai.google/research/pubs/pub44824
        * `WEIGHTED_MAGLEV`: Per-instance weighted Load Balancing via health check
        reported weights. Only applicable to loadBalancingScheme
        EXTERNAL. If set, the Backend Service must
        configure a non legacy HTTP-based Health Check, and
        health check replies are expected to contain
        non-standard HTTP response header field
        X-Load-Balancing-Endpoint-Weight to specify the
        per-instance weights. If set, Load Balancing is weight
        based on the per-instance weights reported in the last
        processed health check replies, as long as every
        instance either reported a valid weight or had
        UNAVAILABLE_WEIGHT. Otherwise, Load Balancing remains
        equal-weight.
        * `WEIGHTED_ROUND_ROBIN`: Per-endpoint weighted round-robin Load Balancing using weights computed
        from Backend reported Custom Metrics. If set, the Backend Service
        responses are expected to contain non-standard HTTP response header field
        X-Endpoint-Load-Metrics. The reported metrics
        to use for computing the weights are specified via the
        backends[].customMetrics fields.
        locality_lb_policy is applicable to either:
        * A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C,
        and loadBalancingScheme set to INTERNAL_MANAGED.
        * A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
        * A regional backend service with loadBalancingScheme set to EXTERNAL (External Network
        Load Balancing). Only MAGLEV and WEIGHTED_MAGLEV values are possible for External
        Network Load Balancing. The default is MAGLEV.
        If session_affinity is not NONE, and locality_lb_policy is not set to MAGLEV, WEIGHTED_MAGLEV,
        or RING_HASH, session affinity settings will not take effect.
        Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced
        by a URL map that is bound to target gRPC proxy that has validate_for_proxyless
        field set to true.
        Possible values are: `ROUND_ROBIN`, `LEAST_REQUEST`, `RING_HASH`, `RANDOM`, `ORIGINAL_DESTINATION`, `MAGLEV`, `WEIGHTED_MAGLEV`, `WEIGHTED_ROUND_ROBIN`.
        """
        return pulumi.get(self, "locality_lb_policy")

    @locality_lb_policy.setter
    def locality_lb_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "locality_lb_policy", value)

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['BackendServiceLogConfigArgs']]:
        """
        This field denotes the logging options for the load balancer traffic served by this backend service.
        If logging is enabled, logs will be exported to Stackdriver.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['BackendServiceLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @_builtins.property
    @pulumi.getter(name="maxStreamDuration")
    def max_stream_duration(self) -> Optional[pulumi.Input['BackendServiceMaxStreamDurationArgs']]:
        """
        Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the
        beginning of the stream until the response has been completely processed, including all retries. A stream that
        does not complete in this duration is closed.
        If not specified, there will be no timeout limit, i.e. the maximum duration is infinite.
        This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service.
        This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
        Structure is documented below.
        """
        return pulumi.get(self, "max_stream_duration")

    @max_stream_duration.setter
    def max_stream_duration(self, value: Optional[pulumi.Input['BackendServiceMaxStreamDurationArgs']]):
        pulumi.set(self, "max_stream_duration", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkPassThroughLbTrafficPolicy")
    def network_pass_through_lb_traffic_policy(self) -> Optional[pulumi.Input['BackendServiceNetworkPassThroughLbTrafficPolicyArgs']]:
        """
        Configures traffic steering properties of internal passthrough Network Load Balancers.
        Structure is documented below.
        """
        return pulumi.get(self, "network_pass_through_lb_traffic_policy")

    @network_pass_through_lb_traffic_policy.setter
    def network_pass_through_lb_traffic_policy(self, value: Optional[pulumi.Input['BackendServiceNetworkPassThroughLbTrafficPolicyArgs']]):
        pulumi.set(self, "network_pass_through_lb_traffic_policy", value)

    @_builtins.property
    @pulumi.getter(name="outlierDetection")
    def outlier_detection(self) -> Optional[pulumi.Input['BackendServiceOutlierDetectionArgs']]:
        """
        Settings controlling eviction of unhealthy hosts from the load balancing pool.
        Applicable backend service types can be a global backend service with the
        loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED.
        Structure is documented below.
        """
        return pulumi.get(self, "outlier_detection")

    @outlier_detection.setter
    def outlier_detection(self, value: Optional[pulumi.Input['BackendServiceOutlierDetectionArgs']]):
        pulumi.set(self, "outlier_detection", value)

    @_builtins.property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input['BackendServiceParamsArgs']]:
        """
        Additional params passed with the request, but not persisted as part of resource payload
        Structure is documented below.
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input['BackendServiceParamsArgs']]):
        pulumi.set(self, "params", value)

    @_builtins.property
    @pulumi.getter(name="portName")
    def port_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of backend port. The same name should appear in the instance
        groups referenced by this service. Required when the load balancing
        scheme is EXTERNAL.
        """
        return pulumi.get(self, "port_name")

    @port_name.setter
    def port_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port_name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol this BackendService uses to communicate with backends.
        The default is HTTP. Possible values are HTTP, HTTPS, HTTP2, H2C, TCP, SSL, UDP
        or GRPC. Refer to the documentation for the load balancers or for Traffic Director
        for more information. Must be set to GRPC when the backend service is referenced
        by a URL map that is bound to target gRPC proxy.
        Possible values are: `HTTP`, `HTTPS`, `HTTP2`, `TCP`, `SSL`, `UDP`, `GRPC`, `UNSPECIFIED`, `H2C`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The security policy associated with this backend service.
        """
        return pulumi.get(self, "security_policy")

    @security_policy.setter
    def security_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_policy", value)

    @_builtins.property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> Optional[pulumi.Input['BackendServiceSecuritySettingsArgs']]:
        """
        The security settings that apply to this backend service. This field is applicable to either
        a regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C, and
        load_balancing_scheme set to INTERNAL_MANAGED; or a global backend service with the
        load_balancing_scheme set to INTERNAL_SELF_MANAGED.
        Structure is documented below.
        """
        return pulumi.get(self, "security_settings")

    @security_settings.setter
    def security_settings(self, value: Optional[pulumi.Input['BackendServiceSecuritySettingsArgs']]):
        pulumi.set(self, "security_settings", value)

    @_builtins.property
    @pulumi.getter(name="serviceLbPolicy")
    def service_lb_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL to networkservices.ServiceLbPolicy resource.
        Can only be set if load balancing scheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED or INTERNAL_SELF_MANAGED and the scope is global.
        """
        return pulumi.get(self, "service_lb_policy")

    @service_lb_policy.setter
    def service_lb_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_lb_policy", value)

    @_builtins.property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of session affinity to use. The default is NONE. Session affinity is
        not applicable if the protocol is UDP.
        Possible values are: `NONE`, `CLIENT_IP`, `CLIENT_IP_PORT_PROTO`, `CLIENT_IP_PROTO`, `GENERATED_COOKIE`, `HEADER_FIELD`, `HTTP_COOKIE`, `STRONG_COOKIE_AFFINITY`.
        """
        return pulumi.get(self, "session_affinity")

    @session_affinity.setter
    def session_affinity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "session_affinity", value)

    @_builtins.property
    @pulumi.getter(name="strongSessionAffinityCookie")
    def strong_session_affinity_cookie(self) -> Optional[pulumi.Input['BackendServiceStrongSessionAffinityCookieArgs']]:
        """
        Describes the HTTP cookie used for stateful session affinity. This field is applicable and required if the sessionAffinity is set to STRONG_COOKIE_AFFINITY.
        Structure is documented below.
        """
        return pulumi.get(self, "strong_session_affinity_cookie")

    @strong_session_affinity_cookie.setter
    def strong_session_affinity_cookie(self, value: Optional[pulumi.Input['BackendServiceStrongSessionAffinityCookieArgs']]):
        pulumi.set(self, "strong_session_affinity_cookie", value)

    @_builtins.property
    @pulumi.getter(name="timeoutSec")
    def timeout_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The backend service timeout has a different meaning depending on the type of load balancer.
        For more information see, [Backend service settings](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices).
        The default is 30 seconds.
        The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds.
        """
        return pulumi.get(self, "timeout_sec")

    @timeout_sec.setter
    def timeout_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_sec", value)

    @_builtins.property
    @pulumi.getter(name="tlsSettings")
    def tls_settings(self) -> Optional[pulumi.Input['BackendServiceTlsSettingsArgs']]:
        """
        Configuration for Backend Authenticated TLS and mTLS. May only be specified when the backend protocol is SSL, HTTPS or HTTP2.
        Structure is documented below.
        """
        return pulumi.get(self, "tls_settings")

    @tls_settings.setter
    def tls_settings(self, value: Optional[pulumi.Input['BackendServiceTlsSettingsArgs']]):
        pulumi.set(self, "tls_settings", value)


@pulumi.input_type
class _BackendServiceState:
    def __init__(__self__, *,
                 affinity_cookie_ttl_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 backends: Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceBackendArgs']]]] = None,
                 cdn_policy: Optional[pulumi.Input['BackendServiceCdnPolicyArgs']] = None,
                 circuit_breakers: Optional[pulumi.Input['BackendServiceCircuitBreakersArgs']] = None,
                 compression_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_draining_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 consistent_hash: Optional[pulumi.Input['BackendServiceConsistentHashArgs']] = None,
                 creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceCustomMetricArgs']]]] = None,
                 custom_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 custom_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic_forwarding: Optional[pulumi.Input['BackendServiceDynamicForwardingArgs']] = None,
                 edge_security_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_cdn: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_managed_migration_state: Optional[pulumi.Input[_builtins.str]] = None,
                 external_managed_migration_testing_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 generated_id: Optional[pulumi.Input[_builtins.int]] = None,
                 health_checks: Optional[pulumi.Input[_builtins.str]] = None,
                 iap: Optional[pulumi.Input['BackendServiceIapArgs']] = None,
                 ip_address_selection_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 locality_lb_policies: Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceLocalityLbPolicyArgs']]]] = None,
                 locality_lb_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 log_config: Optional[pulumi.Input['BackendServiceLogConfigArgs']] = None,
                 max_stream_duration: Optional[pulumi.Input['BackendServiceMaxStreamDurationArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_pass_through_lb_traffic_policy: Optional[pulumi.Input['BackendServiceNetworkPassThroughLbTrafficPolicyArgs']] = None,
                 outlier_detection: Optional[pulumi.Input['BackendServiceOutlierDetectionArgs']] = None,
                 params: Optional[pulumi.Input['BackendServiceParamsArgs']] = None,
                 port_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 security_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_settings: Optional[pulumi.Input['BackendServiceSecuritySettingsArgs']] = None,
                 self_link: Optional[pulumi.Input[_builtins.str]] = None,
                 service_lb_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 session_affinity: Optional[pulumi.Input[_builtins.str]] = None,
                 strong_session_affinity_cookie: Optional[pulumi.Input['BackendServiceStrongSessionAffinityCookieArgs']] = None,
                 timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 tls_settings: Optional[pulumi.Input['BackendServiceTlsSettingsArgs']] = None):
        """
        Input properties used for looking up and filtering BackendService resources.
        :param pulumi.Input[_builtins.int] affinity_cookie_ttl_sec: Lifetime of cookies in seconds if session_affinity is
               GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
               only until the end of the browser session (or equivalent). The
               maximum allowed value for TTL is one day.
               When the load balancing scheme is INTERNAL, this field is not used.
        :param pulumi.Input[Sequence[pulumi.Input['BackendServiceBackendArgs']]] backends: The set of backends that serve this BackendService.
               Structure is documented below.
        :param pulumi.Input['BackendServiceCdnPolicyArgs'] cdn_policy: Cloud CDN configuration for this BackendService.
               Structure is documented below.
        :param pulumi.Input['BackendServiceCircuitBreakersArgs'] circuit_breakers: Settings controlling the volume of connections to a backend service. This field
               is applicable only when the load_balancing_scheme is set to INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] compression_mode: Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
               Possible values are: `AUTOMATIC`, `DISABLED`.
        :param pulumi.Input[_builtins.int] connection_draining_timeout_sec: Time for which instance will be drained (not accept new
               connections, but still work to finish started).
        :param pulumi.Input['BackendServiceConsistentHashArgs'] consistent_hash: Consistent Hash-based load balancing can be used to provide soft session
               affinity based on HTTP headers, cookies or other properties. This load balancing
               policy is applicable only for HTTP connections. The affinity to a particular
               destination host will be lost when one or more hosts are added/removed from the
               destination service. This field specifies parameters that control consistent
               hashing. This field only applies if the load_balancing_scheme is set to
               INTERNAL_SELF_MANAGED. This field is only applicable when locality_lb_policy is
               set to MAGLEV or RING_HASH.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[Sequence[pulumi.Input['BackendServiceCustomMetricArgs']]] custom_metrics: List of custom metrics that are used for the WEIGHTED_ROUND_ROBIN locality_lb_policy.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_request_headers: Headers that the HTTP/S load balancer should add to proxied
               requests.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_response_headers: Headers that the HTTP/S load balancer should add to proxied
               responses.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input['BackendServiceDynamicForwardingArgs'] dynamic_forwarding: Dynamic forwarding configuration. This field is used to configure the backend service with dynamic forwarding
               feature which together with Service Extension allows customized and complex routing logic.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] edge_security_policy: The resource URL for the edge security policy associated with this backend service.
        :param pulumi.Input[_builtins.bool] enable_cdn: If true, enable Cloud CDN for this BackendService.
        :param pulumi.Input[_builtins.str] external_managed_migration_state: Specifies the canary migration state. Possible values are PREPARE, TEST_BY_PERCENTAGE, and
               TEST_ALL_TRAFFIC.
               To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to
               PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be
               changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate
               traffic by percentage using externalManagedMigrationTestingPercentage.
               Rolling back a migration requires the states to be set in reverse order. So changing the
               scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at
               the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic
               back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
               Possible values are: `PREPARE`, `TEST_BY_PERCENTAGE`, `TEST_ALL_TRAFFIC`.
        :param pulumi.Input[_builtins.float] external_managed_migration_testing_percentage: Determines the fraction of requests that should be processed by the Global external
               Application Load Balancer.
               The value of this field must be in the range [0, 100].
               Session affinity options will slightly affect this routing behavior, for more details,
               see: Session Affinity.
               This value can only be set if the loadBalancingScheme in the backend service is set to
               EXTERNAL (when using the Classic ALB) and the migration state is TEST_BY_PERCENTAGE.
        :param pulumi.Input[_builtins.str] fingerprint: Fingerprint of this resource. A hash of the contents stored in this
               object. This field is used in optimistic locking.
        :param pulumi.Input[_builtins.int] generated_id: The unique identifier for the resource. This identifier is defined by the server.
        :param pulumi.Input[_builtins.str] health_checks: The set of URLs to the HttpHealthCheck or HttpsHealthCheck resource
               for health checking this BackendService. Currently at most one health
               check can be specified.
               A health check must be specified unless the backend service uses an internet
               or serverless NEG as a backend.
               For internal load balancing, a URL to a HealthCheck resource must be specified instead.
        :param pulumi.Input['BackendServiceIapArgs'] iap: Settings for enabling Cloud Identity Aware Proxy.
               If OAuth client is not set, the Google-managed OAuth client is used.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] ip_address_selection_policy: Specifies preference of traffic to the backend (from the proxy and from the client for proxyless gRPC).
               Possible values are: `IPV4_ONLY`, `PREFER_IPV6`, `IPV6_ONLY`.
        :param pulumi.Input[_builtins.str] load_balancing_scheme: Indicates whether the backend service will be used with internal or
               external load balancing. A backend service created for one type of
               load balancing cannot be used with the other. For more information, refer to
               [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service).
               Default value is `EXTERNAL`.
               Possible values are: `EXTERNAL`, `INTERNAL_SELF_MANAGED`, `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`.
        :param pulumi.Input[Sequence[pulumi.Input['BackendServiceLocalityLbPolicyArgs']]] locality_lb_policies: A list of locality load balancing policies to be used in order of
               preference. Either the policy or the customPolicy field should be set.
               Overrides any value set in the localityLbPolicy field.
               localityLbPolicies is only supported when the BackendService is referenced
               by a URL Map that is referenced by a target gRPC proxy that has the
               validateForProxyless field set to true.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] locality_lb_policy: The load balancing algorithm used within the scope of the locality.
               The possible values are:
               * `ROUND_ROBIN`: This is a simple policy in which each healthy backend
               is selected in round robin order.
               * `LEAST_REQUEST`: An O(1) algorithm which selects two random healthy
               hosts and picks the host which has fewer active requests.
               * `RING_HASH`: The ring/modulo hash load balancer implements consistent
               hashing to backends. The algorithm has the property that the
               addition/removal of a host from a set of N hosts only affects
               1/N of the requests.
               * `RANDOM`: The load balancer selects a random healthy host.
               * `ORIGINAL_DESTINATION`: Backend host is selected based on the client
               connection metadata, i.e., connections are opened
               to the same address as the destination address of
               the incoming connection before the connection
               was redirected to the load balancer.
               * `MAGLEV`: used as a drop in replacement for the ring hash load balancer.
               Maglev is not as stable as ring hash but has faster table lookup
               build times and host selection times. For more information about
               Maglev, refer to https://ai.google/research/pubs/pub44824
               * `WEIGHTED_MAGLEV`: Per-instance weighted Load Balancing via health check
               reported weights. Only applicable to loadBalancingScheme
               EXTERNAL. If set, the Backend Service must
               configure a non legacy HTTP-based Health Check, and
               health check replies are expected to contain
               non-standard HTTP response header field
               X-Load-Balancing-Endpoint-Weight to specify the
               per-instance weights. If set, Load Balancing is weight
               based on the per-instance weights reported in the last
               processed health check replies, as long as every
               instance either reported a valid weight or had
               UNAVAILABLE_WEIGHT. Otherwise, Load Balancing remains
               equal-weight.
               * `WEIGHTED_ROUND_ROBIN`: Per-endpoint weighted round-robin Load Balancing using weights computed
               from Backend reported Custom Metrics. If set, the Backend Service
               responses are expected to contain non-standard HTTP response header field
               X-Endpoint-Load-Metrics. The reported metrics
               to use for computing the weights are specified via the
               backends[].customMetrics fields.
               locality_lb_policy is applicable to either:
               * A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C,
               and loadBalancingScheme set to INTERNAL_MANAGED.
               * A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
               * A regional backend service with loadBalancingScheme set to EXTERNAL (External Network
               Load Balancing). Only MAGLEV and WEIGHTED_MAGLEV values are possible for External
               Network Load Balancing. The default is MAGLEV.
               If session_affinity is not NONE, and locality_lb_policy is not set to MAGLEV, WEIGHTED_MAGLEV,
               or RING_HASH, session affinity settings will not take effect.
               Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced
               by a URL map that is bound to target gRPC proxy that has validate_for_proxyless
               field set to true.
               Possible values are: `ROUND_ROBIN`, `LEAST_REQUEST`, `RING_HASH`, `RANDOM`, `ORIGINAL_DESTINATION`, `MAGLEV`, `WEIGHTED_MAGLEV`, `WEIGHTED_ROUND_ROBIN`.
        :param pulumi.Input['BackendServiceLogConfigArgs'] log_config: This field denotes the logging options for the load balancer traffic served by this backend service.
               If logging is enabled, logs will be exported to Stackdriver.
               Structure is documented below.
        :param pulumi.Input['BackendServiceMaxStreamDurationArgs'] max_stream_duration: Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the
               beginning of the stream until the response has been completely processed, including all retries. A stream that
               does not complete in this duration is closed.
               If not specified, there will be no timeout limit, i.e. the maximum duration is infinite.
               This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service.
               This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input['BackendServiceNetworkPassThroughLbTrafficPolicyArgs'] network_pass_through_lb_traffic_policy: Configures traffic steering properties of internal passthrough Network Load Balancers.
               Structure is documented below.
        :param pulumi.Input['BackendServiceOutlierDetectionArgs'] outlier_detection: Settings controlling eviction of unhealthy hosts from the load balancing pool.
               Applicable backend service types can be a global backend service with the
               loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED.
               Structure is documented below.
        :param pulumi.Input['BackendServiceParamsArgs'] params: Additional params passed with the request, but not persisted as part of resource payload
               Structure is documented below.
        :param pulumi.Input[_builtins.str] port_name: Name of backend port. The same name should appear in the instance
               groups referenced by this service. Required when the load balancing
               scheme is EXTERNAL.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] protocol: The protocol this BackendService uses to communicate with backends.
               The default is HTTP. Possible values are HTTP, HTTPS, HTTP2, H2C, TCP, SSL, UDP
               or GRPC. Refer to the documentation for the load balancers or for Traffic Director
               for more information. Must be set to GRPC when the backend service is referenced
               by a URL map that is bound to target gRPC proxy.
               Possible values are: `HTTP`, `HTTPS`, `HTTP2`, `TCP`, `SSL`, `UDP`, `GRPC`, `UNSPECIFIED`, `H2C`.
        :param pulumi.Input[_builtins.str] security_policy: The security policy associated with this backend service.
        :param pulumi.Input['BackendServiceSecuritySettingsArgs'] security_settings: The security settings that apply to this backend service. This field is applicable to either
               a regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C, and
               load_balancing_scheme set to INTERNAL_MANAGED; or a global backend service with the
               load_balancing_scheme set to INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[_builtins.str] service_lb_policy: URL to networkservices.ServiceLbPolicy resource.
               Can only be set if load balancing scheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED or INTERNAL_SELF_MANAGED and the scope is global.
        :param pulumi.Input[_builtins.str] session_affinity: Type of session affinity to use. The default is NONE. Session affinity is
               not applicable if the protocol is UDP.
               Possible values are: `NONE`, `CLIENT_IP`, `CLIENT_IP_PORT_PROTO`, `CLIENT_IP_PROTO`, `GENERATED_COOKIE`, `HEADER_FIELD`, `HTTP_COOKIE`, `STRONG_COOKIE_AFFINITY`.
        :param pulumi.Input['BackendServiceStrongSessionAffinityCookieArgs'] strong_session_affinity_cookie: Describes the HTTP cookie used for stateful session affinity. This field is applicable and required if the sessionAffinity is set to STRONG_COOKIE_AFFINITY.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] timeout_sec: The backend service timeout has a different meaning depending on the type of load balancer.
               For more information see, [Backend service settings](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices).
               The default is 30 seconds.
               The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds.
        :param pulumi.Input['BackendServiceTlsSettingsArgs'] tls_settings: Configuration for Backend Authenticated TLS and mTLS. May only be specified when the backend protocol is SSL, HTTPS or HTTP2.
               Structure is documented below.
        """
        if affinity_cookie_ttl_sec is not None:
            pulumi.set(__self__, "affinity_cookie_ttl_sec", affinity_cookie_ttl_sec)
        if backends is not None:
            pulumi.set(__self__, "backends", backends)
        if cdn_policy is not None:
            pulumi.set(__self__, "cdn_policy", cdn_policy)
        if circuit_breakers is not None:
            pulumi.set(__self__, "circuit_breakers", circuit_breakers)
        if compression_mode is not None:
            pulumi.set(__self__, "compression_mode", compression_mode)
        if connection_draining_timeout_sec is not None:
            pulumi.set(__self__, "connection_draining_timeout_sec", connection_draining_timeout_sec)
        if consistent_hash is not None:
            pulumi.set(__self__, "consistent_hash", consistent_hash)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if custom_metrics is not None:
            pulumi.set(__self__, "custom_metrics", custom_metrics)
        if custom_request_headers is not None:
            pulumi.set(__self__, "custom_request_headers", custom_request_headers)
        if custom_response_headers is not None:
            pulumi.set(__self__, "custom_response_headers", custom_response_headers)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dynamic_forwarding is not None:
            pulumi.set(__self__, "dynamic_forwarding", dynamic_forwarding)
        if edge_security_policy is not None:
            pulumi.set(__self__, "edge_security_policy", edge_security_policy)
        if enable_cdn is not None:
            pulumi.set(__self__, "enable_cdn", enable_cdn)
        if external_managed_migration_state is not None:
            pulumi.set(__self__, "external_managed_migration_state", external_managed_migration_state)
        if external_managed_migration_testing_percentage is not None:
            pulumi.set(__self__, "external_managed_migration_testing_percentage", external_managed_migration_testing_percentage)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if generated_id is not None:
            pulumi.set(__self__, "generated_id", generated_id)
        if health_checks is not None:
            pulumi.set(__self__, "health_checks", health_checks)
        if iap is not None:
            pulumi.set(__self__, "iap", iap)
        if ip_address_selection_policy is not None:
            pulumi.set(__self__, "ip_address_selection_policy", ip_address_selection_policy)
        if load_balancing_scheme is not None:
            pulumi.set(__self__, "load_balancing_scheme", load_balancing_scheme)
        if locality_lb_policies is not None:
            pulumi.set(__self__, "locality_lb_policies", locality_lb_policies)
        if locality_lb_policy is not None:
            pulumi.set(__self__, "locality_lb_policy", locality_lb_policy)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if max_stream_duration is not None:
            pulumi.set(__self__, "max_stream_duration", max_stream_duration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_pass_through_lb_traffic_policy is not None:
            pulumi.set(__self__, "network_pass_through_lb_traffic_policy", network_pass_through_lb_traffic_policy)
        if outlier_detection is not None:
            pulumi.set(__self__, "outlier_detection", outlier_detection)
        if params is not None:
            pulumi.set(__self__, "params", params)
        if port_name is not None:
            pulumi.set(__self__, "port_name", port_name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if security_policy is not None:
            pulumi.set(__self__, "security_policy", security_policy)
        if security_settings is not None:
            pulumi.set(__self__, "security_settings", security_settings)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if service_lb_policy is not None:
            pulumi.set(__self__, "service_lb_policy", service_lb_policy)
        if session_affinity is not None:
            pulumi.set(__self__, "session_affinity", session_affinity)
        if strong_session_affinity_cookie is not None:
            pulumi.set(__self__, "strong_session_affinity_cookie", strong_session_affinity_cookie)
        if timeout_sec is not None:
            pulumi.set(__self__, "timeout_sec", timeout_sec)
        if tls_settings is not None:
            pulumi.set(__self__, "tls_settings", tls_settings)

    @_builtins.property
    @pulumi.getter(name="affinityCookieTtlSec")
    def affinity_cookie_ttl_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Lifetime of cookies in seconds if session_affinity is
        GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
        only until the end of the browser session (or equivalent). The
        maximum allowed value for TTL is one day.
        When the load balancing scheme is INTERNAL, this field is not used.
        """
        return pulumi.get(self, "affinity_cookie_ttl_sec")

    @affinity_cookie_ttl_sec.setter
    def affinity_cookie_ttl_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "affinity_cookie_ttl_sec", value)

    @_builtins.property
    @pulumi.getter
    def backends(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceBackendArgs']]]]:
        """
        The set of backends that serve this BackendService.
        Structure is documented below.
        """
        return pulumi.get(self, "backends")

    @backends.setter
    def backends(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceBackendArgs']]]]):
        pulumi.set(self, "backends", value)

    @_builtins.property
    @pulumi.getter(name="cdnPolicy")
    def cdn_policy(self) -> Optional[pulumi.Input['BackendServiceCdnPolicyArgs']]:
        """
        Cloud CDN configuration for this BackendService.
        Structure is documented below.
        """
        return pulumi.get(self, "cdn_policy")

    @cdn_policy.setter
    def cdn_policy(self, value: Optional[pulumi.Input['BackendServiceCdnPolicyArgs']]):
        pulumi.set(self, "cdn_policy", value)

    @_builtins.property
    @pulumi.getter(name="circuitBreakers")
    def circuit_breakers(self) -> Optional[pulumi.Input['BackendServiceCircuitBreakersArgs']]:
        """
        Settings controlling the volume of connections to a backend service. This field
        is applicable only when the load_balancing_scheme is set to INTERNAL_SELF_MANAGED.
        Structure is documented below.
        """
        return pulumi.get(self, "circuit_breakers")

    @circuit_breakers.setter
    def circuit_breakers(self, value: Optional[pulumi.Input['BackendServiceCircuitBreakersArgs']]):
        pulumi.set(self, "circuit_breakers", value)

    @_builtins.property
    @pulumi.getter(name="compressionMode")
    def compression_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
        Possible values are: `AUTOMATIC`, `DISABLED`.
        """
        return pulumi.get(self, "compression_mode")

    @compression_mode.setter
    def compression_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compression_mode", value)

    @_builtins.property
    @pulumi.getter(name="connectionDrainingTimeoutSec")
    def connection_draining_timeout_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time for which instance will be drained (not accept new
        connections, but still work to finish started).
        """
        return pulumi.get(self, "connection_draining_timeout_sec")

    @connection_draining_timeout_sec.setter
    def connection_draining_timeout_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_draining_timeout_sec", value)

    @_builtins.property
    @pulumi.getter(name="consistentHash")
    def consistent_hash(self) -> Optional[pulumi.Input['BackendServiceConsistentHashArgs']]:
        """
        Consistent Hash-based load balancing can be used to provide soft session
        affinity based on HTTP headers, cookies or other properties. This load balancing
        policy is applicable only for HTTP connections. The affinity to a particular
        destination host will be lost when one or more hosts are added/removed from the
        destination service. This field specifies parameters that control consistent
        hashing. This field only applies if the load_balancing_scheme is set to
        INTERNAL_SELF_MANAGED. This field is only applicable when locality_lb_policy is
        set to MAGLEV or RING_HASH.
        Structure is documented below.
        """
        return pulumi.get(self, "consistent_hash")

    @consistent_hash.setter
    def consistent_hash(self, value: Optional[pulumi.Input['BackendServiceConsistentHashArgs']]):
        pulumi.set(self, "consistent_hash", value)

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @_builtins.property
    @pulumi.getter(name="customMetrics")
    def custom_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceCustomMetricArgs']]]]:
        """
        List of custom metrics that are used for the WEIGHTED_ROUND_ROBIN locality_lb_policy.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_metrics")

    @custom_metrics.setter
    def custom_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceCustomMetricArgs']]]]):
        pulumi.set(self, "custom_metrics", value)

    @_builtins.property
    @pulumi.getter(name="customRequestHeaders")
    def custom_request_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Headers that the HTTP/S load balancer should add to proxied
        requests.
        """
        return pulumi.get(self, "custom_request_headers")

    @custom_request_headers.setter
    def custom_request_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_request_headers", value)

    @_builtins.property
    @pulumi.getter(name="customResponseHeaders")
    def custom_response_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Headers that the HTTP/S load balancer should add to proxied
        responses.
        """
        return pulumi.get(self, "custom_response_headers")

    @custom_response_headers.setter
    def custom_response_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_response_headers", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dynamicForwarding")
    def dynamic_forwarding(self) -> Optional[pulumi.Input['BackendServiceDynamicForwardingArgs']]:
        """
        Dynamic forwarding configuration. This field is used to configure the backend service with dynamic forwarding
        feature which together with Service Extension allows customized and complex routing logic.
        Structure is documented below.
        """
        return pulumi.get(self, "dynamic_forwarding")

    @dynamic_forwarding.setter
    def dynamic_forwarding(self, value: Optional[pulumi.Input['BackendServiceDynamicForwardingArgs']]):
        pulumi.set(self, "dynamic_forwarding", value)

    @_builtins.property
    @pulumi.getter(name="edgeSecurityPolicy")
    def edge_security_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource URL for the edge security policy associated with this backend service.
        """
        return pulumi.get(self, "edge_security_policy")

    @edge_security_policy.setter
    def edge_security_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_security_policy", value)

    @_builtins.property
    @pulumi.getter(name="enableCdn")
    def enable_cdn(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, enable Cloud CDN for this BackendService.
        """
        return pulumi.get(self, "enable_cdn")

    @enable_cdn.setter
    def enable_cdn(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_cdn", value)

    @_builtins.property
    @pulumi.getter(name="externalManagedMigrationState")
    def external_managed_migration_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the canary migration state. Possible values are PREPARE, TEST_BY_PERCENTAGE, and
        TEST_ALL_TRAFFIC.
        To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to
        PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be
        changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate
        traffic by percentage using externalManagedMigrationTestingPercentage.
        Rolling back a migration requires the states to be set in reverse order. So changing the
        scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at
        the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic
        back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
        Possible values are: `PREPARE`, `TEST_BY_PERCENTAGE`, `TEST_ALL_TRAFFIC`.
        """
        return pulumi.get(self, "external_managed_migration_state")

    @external_managed_migration_state.setter
    def external_managed_migration_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_managed_migration_state", value)

    @_builtins.property
    @pulumi.getter(name="externalManagedMigrationTestingPercentage")
    def external_managed_migration_testing_percentage(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Determines the fraction of requests that should be processed by the Global external
        Application Load Balancer.
        The value of this field must be in the range [0, 100].
        Session affinity options will slightly affect this routing behavior, for more details,
        see: Session Affinity.
        This value can only be set if the loadBalancingScheme in the backend service is set to
        EXTERNAL (when using the Classic ALB) and the migration state is TEST_BY_PERCENTAGE.
        """
        return pulumi.get(self, "external_managed_migration_testing_percentage")

    @external_managed_migration_testing_percentage.setter
    def external_managed_migration_testing_percentage(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "external_managed_migration_testing_percentage", value)

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fingerprint of this resource. A hash of the contents stored in this
        object. This field is used in optimistic locking.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fingerprint", value)

    @_builtins.property
    @pulumi.getter(name="generatedId")
    def generated_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The unique identifier for the resource. This identifier is defined by the server.
        """
        return pulumi.get(self, "generated_id")

    @generated_id.setter
    def generated_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "generated_id", value)

    @_builtins.property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The set of URLs to the HttpHealthCheck or HttpsHealthCheck resource
        for health checking this BackendService. Currently at most one health
        check can be specified.
        A health check must be specified unless the backend service uses an internet
        or serverless NEG as a backend.
        For internal load balancing, a URL to a HealthCheck resource must be specified instead.
        """
        return pulumi.get(self, "health_checks")

    @health_checks.setter
    def health_checks(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_checks", value)

    @_builtins.property
    @pulumi.getter
    def iap(self) -> Optional[pulumi.Input['BackendServiceIapArgs']]:
        """
        Settings for enabling Cloud Identity Aware Proxy.
        If OAuth client is not set, the Google-managed OAuth client is used.
        Structure is documented below.
        """
        return pulumi.get(self, "iap")

    @iap.setter
    def iap(self, value: Optional[pulumi.Input['BackendServiceIapArgs']]):
        pulumi.set(self, "iap", value)

    @_builtins.property
    @pulumi.getter(name="ipAddressSelectionPolicy")
    def ip_address_selection_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies preference of traffic to the backend (from the proxy and from the client for proxyless gRPC).
        Possible values are: `IPV4_ONLY`, `PREFER_IPV6`, `IPV6_ONLY`.
        """
        return pulumi.get(self, "ip_address_selection_policy")

    @ip_address_selection_policy.setter
    def ip_address_selection_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address_selection_policy", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether the backend service will be used with internal or
        external load balancing. A backend service created for one type of
        load balancing cannot be used with the other. For more information, refer to
        [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service).
        Default value is `EXTERNAL`.
        Possible values are: `EXTERNAL`, `INTERNAL_SELF_MANAGED`, `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @load_balancing_scheme.setter
    def load_balancing_scheme(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancing_scheme", value)

    @_builtins.property
    @pulumi.getter(name="localityLbPolicies")
    def locality_lb_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceLocalityLbPolicyArgs']]]]:
        """
        A list of locality load balancing policies to be used in order of
        preference. Either the policy or the customPolicy field should be set.
        Overrides any value set in the localityLbPolicy field.
        localityLbPolicies is only supported when the BackendService is referenced
        by a URL Map that is referenced by a target gRPC proxy that has the
        validateForProxyless field set to true.
        Structure is documented below.
        """
        return pulumi.get(self, "locality_lb_policies")

    @locality_lb_policies.setter
    def locality_lb_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceLocalityLbPolicyArgs']]]]):
        pulumi.set(self, "locality_lb_policies", value)

    @_builtins.property
    @pulumi.getter(name="localityLbPolicy")
    def locality_lb_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The load balancing algorithm used within the scope of the locality.
        The possible values are:
        * `ROUND_ROBIN`: This is a simple policy in which each healthy backend
        is selected in round robin order.
        * `LEAST_REQUEST`: An O(1) algorithm which selects two random healthy
        hosts and picks the host which has fewer active requests.
        * `RING_HASH`: The ring/modulo hash load balancer implements consistent
        hashing to backends. The algorithm has the property that the
        addition/removal of a host from a set of N hosts only affects
        1/N of the requests.
        * `RANDOM`: The load balancer selects a random healthy host.
        * `ORIGINAL_DESTINATION`: Backend host is selected based on the client
        connection metadata, i.e., connections are opened
        to the same address as the destination address of
        the incoming connection before the connection
        was redirected to the load balancer.
        * `MAGLEV`: used as a drop in replacement for the ring hash load balancer.
        Maglev is not as stable as ring hash but has faster table lookup
        build times and host selection times. For more information about
        Maglev, refer to https://ai.google/research/pubs/pub44824
        * `WEIGHTED_MAGLEV`: Per-instance weighted Load Balancing via health check
        reported weights. Only applicable to loadBalancingScheme
        EXTERNAL. If set, the Backend Service must
        configure a non legacy HTTP-based Health Check, and
        health check replies are expected to contain
        non-standard HTTP response header field
        X-Load-Balancing-Endpoint-Weight to specify the
        per-instance weights. If set, Load Balancing is weight
        based on the per-instance weights reported in the last
        processed health check replies, as long as every
        instance either reported a valid weight or had
        UNAVAILABLE_WEIGHT. Otherwise, Load Balancing remains
        equal-weight.
        * `WEIGHTED_ROUND_ROBIN`: Per-endpoint weighted round-robin Load Balancing using weights computed
        from Backend reported Custom Metrics. If set, the Backend Service
        responses are expected to contain non-standard HTTP response header field
        X-Endpoint-Load-Metrics. The reported metrics
        to use for computing the weights are specified via the
        backends[].customMetrics fields.
        locality_lb_policy is applicable to either:
        * A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C,
        and loadBalancingScheme set to INTERNAL_MANAGED.
        * A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
        * A regional backend service with loadBalancingScheme set to EXTERNAL (External Network
        Load Balancing). Only MAGLEV and WEIGHTED_MAGLEV values are possible for External
        Network Load Balancing. The default is MAGLEV.
        If session_affinity is not NONE, and locality_lb_policy is not set to MAGLEV, WEIGHTED_MAGLEV,
        or RING_HASH, session affinity settings will not take effect.
        Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced
        by a URL map that is bound to target gRPC proxy that has validate_for_proxyless
        field set to true.
        Possible values are: `ROUND_ROBIN`, `LEAST_REQUEST`, `RING_HASH`, `RANDOM`, `ORIGINAL_DESTINATION`, `MAGLEV`, `WEIGHTED_MAGLEV`, `WEIGHTED_ROUND_ROBIN`.
        """
        return pulumi.get(self, "locality_lb_policy")

    @locality_lb_policy.setter
    def locality_lb_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "locality_lb_policy", value)

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['BackendServiceLogConfigArgs']]:
        """
        This field denotes the logging options for the load balancer traffic served by this backend service.
        If logging is enabled, logs will be exported to Stackdriver.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['BackendServiceLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @_builtins.property
    @pulumi.getter(name="maxStreamDuration")
    def max_stream_duration(self) -> Optional[pulumi.Input['BackendServiceMaxStreamDurationArgs']]:
        """
        Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the
        beginning of the stream until the response has been completely processed, including all retries. A stream that
        does not complete in this duration is closed.
        If not specified, there will be no timeout limit, i.e. the maximum duration is infinite.
        This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service.
        This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
        Structure is documented below.
        """
        return pulumi.get(self, "max_stream_duration")

    @max_stream_duration.setter
    def max_stream_duration(self, value: Optional[pulumi.Input['BackendServiceMaxStreamDurationArgs']]):
        pulumi.set(self, "max_stream_duration", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkPassThroughLbTrafficPolicy")
    def network_pass_through_lb_traffic_policy(self) -> Optional[pulumi.Input['BackendServiceNetworkPassThroughLbTrafficPolicyArgs']]:
        """
        Configures traffic steering properties of internal passthrough Network Load Balancers.
        Structure is documented below.
        """
        return pulumi.get(self, "network_pass_through_lb_traffic_policy")

    @network_pass_through_lb_traffic_policy.setter
    def network_pass_through_lb_traffic_policy(self, value: Optional[pulumi.Input['BackendServiceNetworkPassThroughLbTrafficPolicyArgs']]):
        pulumi.set(self, "network_pass_through_lb_traffic_policy", value)

    @_builtins.property
    @pulumi.getter(name="outlierDetection")
    def outlier_detection(self) -> Optional[pulumi.Input['BackendServiceOutlierDetectionArgs']]:
        """
        Settings controlling eviction of unhealthy hosts from the load balancing pool.
        Applicable backend service types can be a global backend service with the
        loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED.
        Structure is documented below.
        """
        return pulumi.get(self, "outlier_detection")

    @outlier_detection.setter
    def outlier_detection(self, value: Optional[pulumi.Input['BackendServiceOutlierDetectionArgs']]):
        pulumi.set(self, "outlier_detection", value)

    @_builtins.property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input['BackendServiceParamsArgs']]:
        """
        Additional params passed with the request, but not persisted as part of resource payload
        Structure is documented below.
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input['BackendServiceParamsArgs']]):
        pulumi.set(self, "params", value)

    @_builtins.property
    @pulumi.getter(name="portName")
    def port_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of backend port. The same name should appear in the instance
        groups referenced by this service. Required when the load balancing
        scheme is EXTERNAL.
        """
        return pulumi.get(self, "port_name")

    @port_name.setter
    def port_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port_name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol this BackendService uses to communicate with backends.
        The default is HTTP. Possible values are HTTP, HTTPS, HTTP2, H2C, TCP, SSL, UDP
        or GRPC. Refer to the documentation for the load balancers or for Traffic Director
        for more information. Must be set to GRPC when the backend service is referenced
        by a URL map that is bound to target gRPC proxy.
        Possible values are: `HTTP`, `HTTPS`, `HTTP2`, `TCP`, `SSL`, `UDP`, `GRPC`, `UNSPECIFIED`, `H2C`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The security policy associated with this backend service.
        """
        return pulumi.get(self, "security_policy")

    @security_policy.setter
    def security_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_policy", value)

    @_builtins.property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> Optional[pulumi.Input['BackendServiceSecuritySettingsArgs']]:
        """
        The security settings that apply to this backend service. This field is applicable to either
        a regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C, and
        load_balancing_scheme set to INTERNAL_MANAGED; or a global backend service with the
        load_balancing_scheme set to INTERNAL_SELF_MANAGED.
        Structure is documented below.
        """
        return pulumi.get(self, "security_settings")

    @security_settings.setter
    def security_settings(self, value: Optional[pulumi.Input['BackendServiceSecuritySettingsArgs']]):
        pulumi.set(self, "security_settings", value)

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link", value)

    @_builtins.property
    @pulumi.getter(name="serviceLbPolicy")
    def service_lb_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL to networkservices.ServiceLbPolicy resource.
        Can only be set if load balancing scheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED or INTERNAL_SELF_MANAGED and the scope is global.
        """
        return pulumi.get(self, "service_lb_policy")

    @service_lb_policy.setter
    def service_lb_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_lb_policy", value)

    @_builtins.property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of session affinity to use. The default is NONE. Session affinity is
        not applicable if the protocol is UDP.
        Possible values are: `NONE`, `CLIENT_IP`, `CLIENT_IP_PORT_PROTO`, `CLIENT_IP_PROTO`, `GENERATED_COOKIE`, `HEADER_FIELD`, `HTTP_COOKIE`, `STRONG_COOKIE_AFFINITY`.
        """
        return pulumi.get(self, "session_affinity")

    @session_affinity.setter
    def session_affinity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "session_affinity", value)

    @_builtins.property
    @pulumi.getter(name="strongSessionAffinityCookie")
    def strong_session_affinity_cookie(self) -> Optional[pulumi.Input['BackendServiceStrongSessionAffinityCookieArgs']]:
        """
        Describes the HTTP cookie used for stateful session affinity. This field is applicable and required if the sessionAffinity is set to STRONG_COOKIE_AFFINITY.
        Structure is documented below.
        """
        return pulumi.get(self, "strong_session_affinity_cookie")

    @strong_session_affinity_cookie.setter
    def strong_session_affinity_cookie(self, value: Optional[pulumi.Input['BackendServiceStrongSessionAffinityCookieArgs']]):
        pulumi.set(self, "strong_session_affinity_cookie", value)

    @_builtins.property
    @pulumi.getter(name="timeoutSec")
    def timeout_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The backend service timeout has a different meaning depending on the type of load balancer.
        For more information see, [Backend service settings](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices).
        The default is 30 seconds.
        The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds.
        """
        return pulumi.get(self, "timeout_sec")

    @timeout_sec.setter
    def timeout_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_sec", value)

    @_builtins.property
    @pulumi.getter(name="tlsSettings")
    def tls_settings(self) -> Optional[pulumi.Input['BackendServiceTlsSettingsArgs']]:
        """
        Configuration for Backend Authenticated TLS and mTLS. May only be specified when the backend protocol is SSL, HTTPS or HTTP2.
        Structure is documented below.
        """
        return pulumi.get(self, "tls_settings")

    @tls_settings.setter
    def tls_settings(self, value: Optional[pulumi.Input['BackendServiceTlsSettingsArgs']]):
        pulumi.set(self, "tls_settings", value)


@pulumi.type_token("gcp:compute/backendService:BackendService")
class BackendService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 affinity_cookie_ttl_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 backends: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackendServiceBackendArgs', 'BackendServiceBackendArgsDict']]]]] = None,
                 cdn_policy: Optional[pulumi.Input[Union['BackendServiceCdnPolicyArgs', 'BackendServiceCdnPolicyArgsDict']]] = None,
                 circuit_breakers: Optional[pulumi.Input[Union['BackendServiceCircuitBreakersArgs', 'BackendServiceCircuitBreakersArgsDict']]] = None,
                 compression_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_draining_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 consistent_hash: Optional[pulumi.Input[Union['BackendServiceConsistentHashArgs', 'BackendServiceConsistentHashArgsDict']]] = None,
                 custom_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackendServiceCustomMetricArgs', 'BackendServiceCustomMetricArgsDict']]]]] = None,
                 custom_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 custom_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic_forwarding: Optional[pulumi.Input[Union['BackendServiceDynamicForwardingArgs', 'BackendServiceDynamicForwardingArgsDict']]] = None,
                 edge_security_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_cdn: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_managed_migration_state: Optional[pulumi.Input[_builtins.str]] = None,
                 external_managed_migration_testing_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 health_checks: Optional[pulumi.Input[_builtins.str]] = None,
                 iap: Optional[pulumi.Input[Union['BackendServiceIapArgs', 'BackendServiceIapArgsDict']]] = None,
                 ip_address_selection_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 locality_lb_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackendServiceLocalityLbPolicyArgs', 'BackendServiceLocalityLbPolicyArgsDict']]]]] = None,
                 locality_lb_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 log_config: Optional[pulumi.Input[Union['BackendServiceLogConfigArgs', 'BackendServiceLogConfigArgsDict']]] = None,
                 max_stream_duration: Optional[pulumi.Input[Union['BackendServiceMaxStreamDurationArgs', 'BackendServiceMaxStreamDurationArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_pass_through_lb_traffic_policy: Optional[pulumi.Input[Union['BackendServiceNetworkPassThroughLbTrafficPolicyArgs', 'BackendServiceNetworkPassThroughLbTrafficPolicyArgsDict']]] = None,
                 outlier_detection: Optional[pulumi.Input[Union['BackendServiceOutlierDetectionArgs', 'BackendServiceOutlierDetectionArgsDict']]] = None,
                 params: Optional[pulumi.Input[Union['BackendServiceParamsArgs', 'BackendServiceParamsArgsDict']]] = None,
                 port_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 security_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_settings: Optional[pulumi.Input[Union['BackendServiceSecuritySettingsArgs', 'BackendServiceSecuritySettingsArgsDict']]] = None,
                 service_lb_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 session_affinity: Optional[pulumi.Input[_builtins.str]] = None,
                 strong_session_affinity_cookie: Optional[pulumi.Input[Union['BackendServiceStrongSessionAffinityCookieArgs', 'BackendServiceStrongSessionAffinityCookieArgsDict']]] = None,
                 timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 tls_settings: Optional[pulumi.Input[Union['BackendServiceTlsSettingsArgs', 'BackendServiceTlsSettingsArgsDict']]] = None,
                 __props__=None):
        """
        A Backend Service defines a group of virtual machines that will serve
        traffic for load balancing. This resource is a global backend service,
        appropriate for external load balancing or self-managed internal load balancing.
        For managed internal load balancing, use a regional backend service instead.

        Currently self-managed internal load balancing is only available in beta.

        > **Note:** Recreating a `compute.BackendService` that references other dependent resources like `compute.URLMap` will give a `resourceInUseByAnotherResource` error, when modifying the number of other dependent resources.
        Use `lifecycle.create_before_destroy` on the dependent resources to avoid this type of error as shown in the Dynamic Backends example.

        To get more information about BackendService, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/v1/backendServices)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/compute/docs/load-balancing/http/backend-service)

        > **Warning:** All arguments including the following potentially sensitive
        values will be stored in the raw state as plain text: `iap.oauth2_client_secret`, `iap.oauth2_client_secret_sha256`, `security_settings.aws_v4_authentication.access_key`.

        ## Example Usage

        ### Backend Service Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_http_health_check = gcp.compute.HttpHealthCheck("default",
            name="health-check",
            request_path="/",
            check_interval_sec=1,
            timeout_sec=1)
        default = gcp.compute.BackendService("default",
            name="backend-service",
            health_checks=default_http_health_check.id)
        ```
        ### Backend Service External Iap

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.BackendService("default",
            name="tf-test-backend-service-external",
            protocol="HTTP",
            load_balancing_scheme="EXTERNAL",
            iap={
                "enabled": True,
                "oauth2_client_id": "abc",
                "oauth2_client_secret": "xyz",
            })
        ```
        ### Backend Service Cache Simple

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_http_health_check = gcp.compute.HttpHealthCheck("default",
            name="health-check",
            request_path="/",
            check_interval_sec=1,
            timeout_sec=1)
        default = gcp.compute.BackendService("default",
            name="backend-service",
            health_checks=default_http_health_check.id,
            enable_cdn=True,
            cdn_policy={
                "signed_url_cache_max_age_sec": 7200,
            })
        ```
        ### Backend Service Cache Include Http Headers

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.BackendService("default",
            name="backend-service",
            enable_cdn=True,
            cdn_policy={
                "cache_mode": "USE_ORIGIN_HEADERS",
                "cache_key_policy": {
                    "include_host": True,
                    "include_protocol": True,
                    "include_query_string": True,
                    "include_http_headers": ["X-My-Header-Field"],
                },
            })
        ```
        ### Backend Service Cache Include Named Cookies

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.BackendService("default",
            name="backend-service",
            enable_cdn=True,
            cdn_policy={
                "cache_mode": "CACHE_ALL_STATIC",
                "default_ttl": 3600,
                "client_ttl": 7200,
                "max_ttl": 10800,
                "cache_key_policy": {
                    "include_host": True,
                    "include_protocol": True,
                    "include_query_string": True,
                    "include_named_cookies": [
                        "__next_preview_data",
                        "__prerender_bypass",
                    ],
                },
            })
        ```
        ### Backend Service Cache

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_http_health_check = gcp.compute.HttpHealthCheck("default",
            name="health-check",
            request_path="/",
            check_interval_sec=1,
            timeout_sec=1)
        default = gcp.compute.BackendService("default",
            name="backend-service",
            health_checks=default_http_health_check.id,
            enable_cdn=True,
            cdn_policy={
                "cache_mode": "CACHE_ALL_STATIC",
                "default_ttl": 3600,
                "client_ttl": 7200,
                "max_ttl": 10800,
                "negative_caching": True,
                "signed_url_cache_max_age_sec": 7200,
            })
        ```
        ### Backend Service Cache Bypass Cache On Request Headers

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_http_health_check = gcp.compute.HttpHealthCheck("default",
            name="health-check",
            request_path="/",
            check_interval_sec=1,
            timeout_sec=1)
        default = gcp.compute.BackendService("default",
            name="backend-service",
            health_checks=default_http_health_check.id,
            enable_cdn=True,
            cdn_policy={
                "cache_mode": "CACHE_ALL_STATIC",
                "default_ttl": 3600,
                "client_ttl": 7200,
                "max_ttl": 10800,
                "negative_caching": True,
                "signed_url_cache_max_age_sec": 7200,
                "bypass_cache_on_request_headers": [
                    {
                        "header_name": "Authorization",
                    },
                    {
                        "header_name": "Proxy-Authorization",
                    },
                ],
            })
        ```
        ### Backend Service Traffic Director Round Robin

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.HealthCheck("health_check",
            name="health-check",
            http_health_check={
                "port": 80,
            })
        default = gcp.compute.BackendService("default",
            name="backend-service",
            health_checks=health_check.id,
            load_balancing_scheme="INTERNAL_SELF_MANAGED",
            locality_lb_policy="ROUND_ROBIN")
        ```
        ### Backend Service Traffic Director Ring Hash

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.HealthCheck("health_check",
            name="health-check",
            http_health_check={
                "port": 80,
            })
        default = gcp.compute.BackendService("default",
            name="backend-service",
            health_checks=health_check.id,
            load_balancing_scheme="INTERNAL_SELF_MANAGED",
            locality_lb_policy="RING_HASH",
            session_affinity="HTTP_COOKIE",
            circuit_breakers={
                "max_connections": 10,
            },
            consistent_hash={
                "http_cookie": {
                    "ttl": {
                        "seconds": 11,
                        "nanos": 1111,
                    },
                    "name": "mycookie",
                },
            },
            outlier_detection={
                "consecutive_errors": 2,
                "consecutive_gateway_failure": 5,
                "enforcing_consecutive_errors": 100,
                "enforcing_consecutive_gateway_failure": 0,
                "enforcing_success_rate": 100,
                "max_ejection_percent": 10,
                "success_rate_minimum_hosts": 5,
                "success_rate_request_volume": 100,
                "success_rate_stdev_factor": 1900,
            })
        ```
        ### Backend Service Stateful Session Affinity

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.HealthCheck("health_check",
            name="health-check",
            http_health_check={
                "port": 80,
            })
        default = gcp.compute.BackendService("default",
            name="backend-service",
            health_checks=health_check.id,
            load_balancing_scheme="EXTERNAL_MANAGED",
            locality_lb_policy="RING_HASH",
            session_affinity="STRONG_COOKIE_AFFINITY",
            strong_session_affinity_cookie={
                "ttl": {
                    "seconds": 11,
                    "nanos": 1111,
                },
                "name": "mycookie",
            })
        ```
        ### Backend Service Network Endpoint

        ```python
        import pulumi
        import pulumi_gcp as gcp

        external_proxy = gcp.compute.GlobalNetworkEndpointGroup("external_proxy",
            name="network-endpoint",
            network_endpoint_type="INTERNET_FQDN_PORT",
            default_port=443)
        proxy = gcp.compute.GlobalNetworkEndpoint("proxy",
            global_network_endpoint_group=external_proxy.id,
            fqdn="test.example.com",
            port=external_proxy.default_port)
        default = gcp.compute.BackendService("default",
            name="backend-service",
            enable_cdn=True,
            timeout_sec=10,
            connection_draining_timeout_sec=10,
            custom_request_headers=[proxy.fqdn.apply(lambda fqdn: f"host: {fqdn}")],
            custom_response_headers=["X-Cache-Hit: {cdn_cache_status}"],
            backends=[{
                "group": external_proxy.id,
            }])
        ```
        ### Backend Service External Managed

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_health_check = gcp.compute.HealthCheck("default",
            name="health-check",
            http_health_check={
                "port": 80,
            })
        default = gcp.compute.BackendService("default",
            name="backend-service",
            health_checks=default_health_check.id,
            load_balancing_scheme="EXTERNAL_MANAGED",
            protocol="H2C")
        ```
        ### Backend Service Ip Address Selection Policy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.BackendService("default",
            name="backend-service",
            load_balancing_scheme="EXTERNAL_MANAGED",
            ip_address_selection_policy="IPV6_ONLY")
        ```
        ### Backend Service Custom Metrics

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default", name="network")
        # Zonal NEG with GCE_VM_IP_PORT
        default_network_endpoint_group = gcp.compute.NetworkEndpointGroup("default",
            name="network-endpoint",
            network=default.id,
            default_port=90,
            zone="us-central1-a",
            network_endpoint_type="GCE_VM_IP_PORT")
        default_health_check = gcp.compute.HealthCheck("default",
            name="health-check",
            timeout_sec=1,
            check_interval_sec=1,
            tcp_health_check={
                "port": 80,
            })
        default_backend_service = gcp.compute.BackendService("default",
            name="backend-service",
            health_checks=default_health_check.id,
            load_balancing_scheme="EXTERNAL_MANAGED",
            locality_lb_policy="WEIGHTED_ROUND_ROBIN",
            custom_metrics=[{
                "name": "orca.application_utilization",
                "dry_run": False,
            }],
            backends=[{
                "group": default_network_endpoint_group.id,
                "balancing_mode": "CUSTOM_METRICS",
                "custom_metrics": [
                    {
                        "name": "orca.cpu_utilization",
                        "max_utilization": 0.9,
                        "dry_run": True,
                    },
                    {
                        "name": "orca.named_metrics.foo",
                        "dry_run": False,
                    },
                ],
            }],
            log_config={
                "enable": True,
                "optional_mode": "CUSTOM",
                "optional_fields": [
                    "orca_load_report",
                    "tls.protocol",
                ],
            })
        ```
        ### Backend Service Tls Settings

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_health_check = gcp.compute.HealthCheck("default",
            name="health-check",
            http_health_check={
                "port": 80,
            })
        default_backend_authentication_config = gcp.networksecurity.BackendAuthenticationConfig("default",
            name="authentication",
            well_known_roots="PUBLIC_ROOTS")
        default = gcp.compute.BackendService("default",
            name="backend-service",
            health_checks=default_health_check.id,
            load_balancing_scheme="EXTERNAL_MANAGED",
            protocol="HTTPS",
            tls_settings={
                "sni": "example.com",
                "subject_alt_names": [
                    {
                        "dns_name": "example.com",
                    },
                    {
                        "uniform_resource_identifier": "https://example.com",
                    },
                ],
                "authentication_config": default_backend_authentication_config.id.apply(lambda id: f"//networksecurity.googleapis.com/{id}"),
            })
        ```
        ### Backend Service Dynamic Forwarding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.BackendService("default",
            name="backend-service",
            load_balancing_scheme="INTERNAL_MANAGED",
            dynamic_forwarding={
                "ip_port_selection": {
                    "enabled": True,
                },
            })
        ```

        ## Import

        BackendService can be imported using any of these accepted formats:

        * `projects/{{project}}/global/backendServices/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, BackendService can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/backendService:BackendService default projects/{{project}}/global/backendServices/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/backendService:BackendService default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/backendService:BackendService default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] affinity_cookie_ttl_sec: Lifetime of cookies in seconds if session_affinity is
               GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
               only until the end of the browser session (or equivalent). The
               maximum allowed value for TTL is one day.
               When the load balancing scheme is INTERNAL, this field is not used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BackendServiceBackendArgs', 'BackendServiceBackendArgsDict']]]] backends: The set of backends that serve this BackendService.
               Structure is documented below.
        :param pulumi.Input[Union['BackendServiceCdnPolicyArgs', 'BackendServiceCdnPolicyArgsDict']] cdn_policy: Cloud CDN configuration for this BackendService.
               Structure is documented below.
        :param pulumi.Input[Union['BackendServiceCircuitBreakersArgs', 'BackendServiceCircuitBreakersArgsDict']] circuit_breakers: Settings controlling the volume of connections to a backend service. This field
               is applicable only when the load_balancing_scheme is set to INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] compression_mode: Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
               Possible values are: `AUTOMATIC`, `DISABLED`.
        :param pulumi.Input[_builtins.int] connection_draining_timeout_sec: Time for which instance will be drained (not accept new
               connections, but still work to finish started).
        :param pulumi.Input[Union['BackendServiceConsistentHashArgs', 'BackendServiceConsistentHashArgsDict']] consistent_hash: Consistent Hash-based load balancing can be used to provide soft session
               affinity based on HTTP headers, cookies or other properties. This load balancing
               policy is applicable only for HTTP connections. The affinity to a particular
               destination host will be lost when one or more hosts are added/removed from the
               destination service. This field specifies parameters that control consistent
               hashing. This field only applies if the load_balancing_scheme is set to
               INTERNAL_SELF_MANAGED. This field is only applicable when locality_lb_policy is
               set to MAGLEV or RING_HASH.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BackendServiceCustomMetricArgs', 'BackendServiceCustomMetricArgsDict']]]] custom_metrics: List of custom metrics that are used for the WEIGHTED_ROUND_ROBIN locality_lb_policy.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_request_headers: Headers that the HTTP/S load balancer should add to proxied
               requests.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_response_headers: Headers that the HTTP/S load balancer should add to proxied
               responses.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[Union['BackendServiceDynamicForwardingArgs', 'BackendServiceDynamicForwardingArgsDict']] dynamic_forwarding: Dynamic forwarding configuration. This field is used to configure the backend service with dynamic forwarding
               feature which together with Service Extension allows customized and complex routing logic.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] edge_security_policy: The resource URL for the edge security policy associated with this backend service.
        :param pulumi.Input[_builtins.bool] enable_cdn: If true, enable Cloud CDN for this BackendService.
        :param pulumi.Input[_builtins.str] external_managed_migration_state: Specifies the canary migration state. Possible values are PREPARE, TEST_BY_PERCENTAGE, and
               TEST_ALL_TRAFFIC.
               To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to
               PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be
               changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate
               traffic by percentage using externalManagedMigrationTestingPercentage.
               Rolling back a migration requires the states to be set in reverse order. So changing the
               scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at
               the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic
               back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
               Possible values are: `PREPARE`, `TEST_BY_PERCENTAGE`, `TEST_ALL_TRAFFIC`.
        :param pulumi.Input[_builtins.float] external_managed_migration_testing_percentage: Determines the fraction of requests that should be processed by the Global external
               Application Load Balancer.
               The value of this field must be in the range [0, 100].
               Session affinity options will slightly affect this routing behavior, for more details,
               see: Session Affinity.
               This value can only be set if the loadBalancingScheme in the backend service is set to
               EXTERNAL (when using the Classic ALB) and the migration state is TEST_BY_PERCENTAGE.
        :param pulumi.Input[_builtins.str] health_checks: The set of URLs to the HttpHealthCheck or HttpsHealthCheck resource
               for health checking this BackendService. Currently at most one health
               check can be specified.
               A health check must be specified unless the backend service uses an internet
               or serverless NEG as a backend.
               For internal load balancing, a URL to a HealthCheck resource must be specified instead.
        :param pulumi.Input[Union['BackendServiceIapArgs', 'BackendServiceIapArgsDict']] iap: Settings for enabling Cloud Identity Aware Proxy.
               If OAuth client is not set, the Google-managed OAuth client is used.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] ip_address_selection_policy: Specifies preference of traffic to the backend (from the proxy and from the client for proxyless gRPC).
               Possible values are: `IPV4_ONLY`, `PREFER_IPV6`, `IPV6_ONLY`.
        :param pulumi.Input[_builtins.str] load_balancing_scheme: Indicates whether the backend service will be used with internal or
               external load balancing. A backend service created for one type of
               load balancing cannot be used with the other. For more information, refer to
               [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service).
               Default value is `EXTERNAL`.
               Possible values are: `EXTERNAL`, `INTERNAL_SELF_MANAGED`, `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BackendServiceLocalityLbPolicyArgs', 'BackendServiceLocalityLbPolicyArgsDict']]]] locality_lb_policies: A list of locality load balancing policies to be used in order of
               preference. Either the policy or the customPolicy field should be set.
               Overrides any value set in the localityLbPolicy field.
               localityLbPolicies is only supported when the BackendService is referenced
               by a URL Map that is referenced by a target gRPC proxy that has the
               validateForProxyless field set to true.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] locality_lb_policy: The load balancing algorithm used within the scope of the locality.
               The possible values are:
               * `ROUND_ROBIN`: This is a simple policy in which each healthy backend
               is selected in round robin order.
               * `LEAST_REQUEST`: An O(1) algorithm which selects two random healthy
               hosts and picks the host which has fewer active requests.
               * `RING_HASH`: The ring/modulo hash load balancer implements consistent
               hashing to backends. The algorithm has the property that the
               addition/removal of a host from a set of N hosts only affects
               1/N of the requests.
               * `RANDOM`: The load balancer selects a random healthy host.
               * `ORIGINAL_DESTINATION`: Backend host is selected based on the client
               connection metadata, i.e., connections are opened
               to the same address as the destination address of
               the incoming connection before the connection
               was redirected to the load balancer.
               * `MAGLEV`: used as a drop in replacement for the ring hash load balancer.
               Maglev is not as stable as ring hash but has faster table lookup
               build times and host selection times. For more information about
               Maglev, refer to https://ai.google/research/pubs/pub44824
               * `WEIGHTED_MAGLEV`: Per-instance weighted Load Balancing via health check
               reported weights. Only applicable to loadBalancingScheme
               EXTERNAL. If set, the Backend Service must
               configure a non legacy HTTP-based Health Check, and
               health check replies are expected to contain
               non-standard HTTP response header field
               X-Load-Balancing-Endpoint-Weight to specify the
               per-instance weights. If set, Load Balancing is weight
               based on the per-instance weights reported in the last
               processed health check replies, as long as every
               instance either reported a valid weight or had
               UNAVAILABLE_WEIGHT. Otherwise, Load Balancing remains
               equal-weight.
               * `WEIGHTED_ROUND_ROBIN`: Per-endpoint weighted round-robin Load Balancing using weights computed
               from Backend reported Custom Metrics. If set, the Backend Service
               responses are expected to contain non-standard HTTP response header field
               X-Endpoint-Load-Metrics. The reported metrics
               to use for computing the weights are specified via the
               backends[].customMetrics fields.
               locality_lb_policy is applicable to either:
               * A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C,
               and loadBalancingScheme set to INTERNAL_MANAGED.
               * A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
               * A regional backend service with loadBalancingScheme set to EXTERNAL (External Network
               Load Balancing). Only MAGLEV and WEIGHTED_MAGLEV values are possible for External
               Network Load Balancing. The default is MAGLEV.
               If session_affinity is not NONE, and locality_lb_policy is not set to MAGLEV, WEIGHTED_MAGLEV,
               or RING_HASH, session affinity settings will not take effect.
               Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced
               by a URL map that is bound to target gRPC proxy that has validate_for_proxyless
               field set to true.
               Possible values are: `ROUND_ROBIN`, `LEAST_REQUEST`, `RING_HASH`, `RANDOM`, `ORIGINAL_DESTINATION`, `MAGLEV`, `WEIGHTED_MAGLEV`, `WEIGHTED_ROUND_ROBIN`.
        :param pulumi.Input[Union['BackendServiceLogConfigArgs', 'BackendServiceLogConfigArgsDict']] log_config: This field denotes the logging options for the load balancer traffic served by this backend service.
               If logging is enabled, logs will be exported to Stackdriver.
               Structure is documented below.
        :param pulumi.Input[Union['BackendServiceMaxStreamDurationArgs', 'BackendServiceMaxStreamDurationArgsDict']] max_stream_duration: Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the
               beginning of the stream until the response has been completely processed, including all retries. A stream that
               does not complete in this duration is closed.
               If not specified, there will be no timeout limit, i.e. the maximum duration is infinite.
               This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service.
               This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[Union['BackendServiceNetworkPassThroughLbTrafficPolicyArgs', 'BackendServiceNetworkPassThroughLbTrafficPolicyArgsDict']] network_pass_through_lb_traffic_policy: Configures traffic steering properties of internal passthrough Network Load Balancers.
               Structure is documented below.
        :param pulumi.Input[Union['BackendServiceOutlierDetectionArgs', 'BackendServiceOutlierDetectionArgsDict']] outlier_detection: Settings controlling eviction of unhealthy hosts from the load balancing pool.
               Applicable backend service types can be a global backend service with the
               loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED.
               Structure is documented below.
        :param pulumi.Input[Union['BackendServiceParamsArgs', 'BackendServiceParamsArgsDict']] params: Additional params passed with the request, but not persisted as part of resource payload
               Structure is documented below.
        :param pulumi.Input[_builtins.str] port_name: Name of backend port. The same name should appear in the instance
               groups referenced by this service. Required when the load balancing
               scheme is EXTERNAL.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] protocol: The protocol this BackendService uses to communicate with backends.
               The default is HTTP. Possible values are HTTP, HTTPS, HTTP2, H2C, TCP, SSL, UDP
               or GRPC. Refer to the documentation for the load balancers or for Traffic Director
               for more information. Must be set to GRPC when the backend service is referenced
               by a URL map that is bound to target gRPC proxy.
               Possible values are: `HTTP`, `HTTPS`, `HTTP2`, `TCP`, `SSL`, `UDP`, `GRPC`, `UNSPECIFIED`, `H2C`.
        :param pulumi.Input[_builtins.str] security_policy: The security policy associated with this backend service.
        :param pulumi.Input[Union['BackendServiceSecuritySettingsArgs', 'BackendServiceSecuritySettingsArgsDict']] security_settings: The security settings that apply to this backend service. This field is applicable to either
               a regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C, and
               load_balancing_scheme set to INTERNAL_MANAGED; or a global backend service with the
               load_balancing_scheme set to INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] service_lb_policy: URL to networkservices.ServiceLbPolicy resource.
               Can only be set if load balancing scheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED or INTERNAL_SELF_MANAGED and the scope is global.
        :param pulumi.Input[_builtins.str] session_affinity: Type of session affinity to use. The default is NONE. Session affinity is
               not applicable if the protocol is UDP.
               Possible values are: `NONE`, `CLIENT_IP`, `CLIENT_IP_PORT_PROTO`, `CLIENT_IP_PROTO`, `GENERATED_COOKIE`, `HEADER_FIELD`, `HTTP_COOKIE`, `STRONG_COOKIE_AFFINITY`.
        :param pulumi.Input[Union['BackendServiceStrongSessionAffinityCookieArgs', 'BackendServiceStrongSessionAffinityCookieArgsDict']] strong_session_affinity_cookie: Describes the HTTP cookie used for stateful session affinity. This field is applicable and required if the sessionAffinity is set to STRONG_COOKIE_AFFINITY.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] timeout_sec: The backend service timeout has a different meaning depending on the type of load balancer.
               For more information see, [Backend service settings](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices).
               The default is 30 seconds.
               The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds.
        :param pulumi.Input[Union['BackendServiceTlsSettingsArgs', 'BackendServiceTlsSettingsArgsDict']] tls_settings: Configuration for Backend Authenticated TLS and mTLS. May only be specified when the backend protocol is SSL, HTTPS or HTTP2.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[BackendServiceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Backend Service defines a group of virtual machines that will serve
        traffic for load balancing. This resource is a global backend service,
        appropriate for external load balancing or self-managed internal load balancing.
        For managed internal load balancing, use a regional backend service instead.

        Currently self-managed internal load balancing is only available in beta.

        > **Note:** Recreating a `compute.BackendService` that references other dependent resources like `compute.URLMap` will give a `resourceInUseByAnotherResource` error, when modifying the number of other dependent resources.
        Use `lifecycle.create_before_destroy` on the dependent resources to avoid this type of error as shown in the Dynamic Backends example.

        To get more information about BackendService, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/v1/backendServices)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/compute/docs/load-balancing/http/backend-service)

        > **Warning:** All arguments including the following potentially sensitive
        values will be stored in the raw state as plain text: `iap.oauth2_client_secret`, `iap.oauth2_client_secret_sha256`, `security_settings.aws_v4_authentication.access_key`.

        ## Example Usage

        ### Backend Service Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_http_health_check = gcp.compute.HttpHealthCheck("default",
            name="health-check",
            request_path="/",
            check_interval_sec=1,
            timeout_sec=1)
        default = gcp.compute.BackendService("default",
            name="backend-service",
            health_checks=default_http_health_check.id)
        ```
        ### Backend Service External Iap

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.BackendService("default",
            name="tf-test-backend-service-external",
            protocol="HTTP",
            load_balancing_scheme="EXTERNAL",
            iap={
                "enabled": True,
                "oauth2_client_id": "abc",
                "oauth2_client_secret": "xyz",
            })
        ```
        ### Backend Service Cache Simple

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_http_health_check = gcp.compute.HttpHealthCheck("default",
            name="health-check",
            request_path="/",
            check_interval_sec=1,
            timeout_sec=1)
        default = gcp.compute.BackendService("default",
            name="backend-service",
            health_checks=default_http_health_check.id,
            enable_cdn=True,
            cdn_policy={
                "signed_url_cache_max_age_sec": 7200,
            })
        ```
        ### Backend Service Cache Include Http Headers

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.BackendService("default",
            name="backend-service",
            enable_cdn=True,
            cdn_policy={
                "cache_mode": "USE_ORIGIN_HEADERS",
                "cache_key_policy": {
                    "include_host": True,
                    "include_protocol": True,
                    "include_query_string": True,
                    "include_http_headers": ["X-My-Header-Field"],
                },
            })
        ```
        ### Backend Service Cache Include Named Cookies

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.BackendService("default",
            name="backend-service",
            enable_cdn=True,
            cdn_policy={
                "cache_mode": "CACHE_ALL_STATIC",
                "default_ttl": 3600,
                "client_ttl": 7200,
                "max_ttl": 10800,
                "cache_key_policy": {
                    "include_host": True,
                    "include_protocol": True,
                    "include_query_string": True,
                    "include_named_cookies": [
                        "__next_preview_data",
                        "__prerender_bypass",
                    ],
                },
            })
        ```
        ### Backend Service Cache

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_http_health_check = gcp.compute.HttpHealthCheck("default",
            name="health-check",
            request_path="/",
            check_interval_sec=1,
            timeout_sec=1)
        default = gcp.compute.BackendService("default",
            name="backend-service",
            health_checks=default_http_health_check.id,
            enable_cdn=True,
            cdn_policy={
                "cache_mode": "CACHE_ALL_STATIC",
                "default_ttl": 3600,
                "client_ttl": 7200,
                "max_ttl": 10800,
                "negative_caching": True,
                "signed_url_cache_max_age_sec": 7200,
            })
        ```
        ### Backend Service Cache Bypass Cache On Request Headers

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_http_health_check = gcp.compute.HttpHealthCheck("default",
            name="health-check",
            request_path="/",
            check_interval_sec=1,
            timeout_sec=1)
        default = gcp.compute.BackendService("default",
            name="backend-service",
            health_checks=default_http_health_check.id,
            enable_cdn=True,
            cdn_policy={
                "cache_mode": "CACHE_ALL_STATIC",
                "default_ttl": 3600,
                "client_ttl": 7200,
                "max_ttl": 10800,
                "negative_caching": True,
                "signed_url_cache_max_age_sec": 7200,
                "bypass_cache_on_request_headers": [
                    {
                        "header_name": "Authorization",
                    },
                    {
                        "header_name": "Proxy-Authorization",
                    },
                ],
            })
        ```
        ### Backend Service Traffic Director Round Robin

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.HealthCheck("health_check",
            name="health-check",
            http_health_check={
                "port": 80,
            })
        default = gcp.compute.BackendService("default",
            name="backend-service",
            health_checks=health_check.id,
            load_balancing_scheme="INTERNAL_SELF_MANAGED",
            locality_lb_policy="ROUND_ROBIN")
        ```
        ### Backend Service Traffic Director Ring Hash

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.HealthCheck("health_check",
            name="health-check",
            http_health_check={
                "port": 80,
            })
        default = gcp.compute.BackendService("default",
            name="backend-service",
            health_checks=health_check.id,
            load_balancing_scheme="INTERNAL_SELF_MANAGED",
            locality_lb_policy="RING_HASH",
            session_affinity="HTTP_COOKIE",
            circuit_breakers={
                "max_connections": 10,
            },
            consistent_hash={
                "http_cookie": {
                    "ttl": {
                        "seconds": 11,
                        "nanos": 1111,
                    },
                    "name": "mycookie",
                },
            },
            outlier_detection={
                "consecutive_errors": 2,
                "consecutive_gateway_failure": 5,
                "enforcing_consecutive_errors": 100,
                "enforcing_consecutive_gateway_failure": 0,
                "enforcing_success_rate": 100,
                "max_ejection_percent": 10,
                "success_rate_minimum_hosts": 5,
                "success_rate_request_volume": 100,
                "success_rate_stdev_factor": 1900,
            })
        ```
        ### Backend Service Stateful Session Affinity

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.HealthCheck("health_check",
            name="health-check",
            http_health_check={
                "port": 80,
            })
        default = gcp.compute.BackendService("default",
            name="backend-service",
            health_checks=health_check.id,
            load_balancing_scheme="EXTERNAL_MANAGED",
            locality_lb_policy="RING_HASH",
            session_affinity="STRONG_COOKIE_AFFINITY",
            strong_session_affinity_cookie={
                "ttl": {
                    "seconds": 11,
                    "nanos": 1111,
                },
                "name": "mycookie",
            })
        ```
        ### Backend Service Network Endpoint

        ```python
        import pulumi
        import pulumi_gcp as gcp

        external_proxy = gcp.compute.GlobalNetworkEndpointGroup("external_proxy",
            name="network-endpoint",
            network_endpoint_type="INTERNET_FQDN_PORT",
            default_port=443)
        proxy = gcp.compute.GlobalNetworkEndpoint("proxy",
            global_network_endpoint_group=external_proxy.id,
            fqdn="test.example.com",
            port=external_proxy.default_port)
        default = gcp.compute.BackendService("default",
            name="backend-service",
            enable_cdn=True,
            timeout_sec=10,
            connection_draining_timeout_sec=10,
            custom_request_headers=[proxy.fqdn.apply(lambda fqdn: f"host: {fqdn}")],
            custom_response_headers=["X-Cache-Hit: {cdn_cache_status}"],
            backends=[{
                "group": external_proxy.id,
            }])
        ```
        ### Backend Service External Managed

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_health_check = gcp.compute.HealthCheck("default",
            name="health-check",
            http_health_check={
                "port": 80,
            })
        default = gcp.compute.BackendService("default",
            name="backend-service",
            health_checks=default_health_check.id,
            load_balancing_scheme="EXTERNAL_MANAGED",
            protocol="H2C")
        ```
        ### Backend Service Ip Address Selection Policy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.BackendService("default",
            name="backend-service",
            load_balancing_scheme="EXTERNAL_MANAGED",
            ip_address_selection_policy="IPV6_ONLY")
        ```
        ### Backend Service Custom Metrics

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default", name="network")
        # Zonal NEG with GCE_VM_IP_PORT
        default_network_endpoint_group = gcp.compute.NetworkEndpointGroup("default",
            name="network-endpoint",
            network=default.id,
            default_port=90,
            zone="us-central1-a",
            network_endpoint_type="GCE_VM_IP_PORT")
        default_health_check = gcp.compute.HealthCheck("default",
            name="health-check",
            timeout_sec=1,
            check_interval_sec=1,
            tcp_health_check={
                "port": 80,
            })
        default_backend_service = gcp.compute.BackendService("default",
            name="backend-service",
            health_checks=default_health_check.id,
            load_balancing_scheme="EXTERNAL_MANAGED",
            locality_lb_policy="WEIGHTED_ROUND_ROBIN",
            custom_metrics=[{
                "name": "orca.application_utilization",
                "dry_run": False,
            }],
            backends=[{
                "group": default_network_endpoint_group.id,
                "balancing_mode": "CUSTOM_METRICS",
                "custom_metrics": [
                    {
                        "name": "orca.cpu_utilization",
                        "max_utilization": 0.9,
                        "dry_run": True,
                    },
                    {
                        "name": "orca.named_metrics.foo",
                        "dry_run": False,
                    },
                ],
            }],
            log_config={
                "enable": True,
                "optional_mode": "CUSTOM",
                "optional_fields": [
                    "orca_load_report",
                    "tls.protocol",
                ],
            })
        ```
        ### Backend Service Tls Settings

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_health_check = gcp.compute.HealthCheck("default",
            name="health-check",
            http_health_check={
                "port": 80,
            })
        default_backend_authentication_config = gcp.networksecurity.BackendAuthenticationConfig("default",
            name="authentication",
            well_known_roots="PUBLIC_ROOTS")
        default = gcp.compute.BackendService("default",
            name="backend-service",
            health_checks=default_health_check.id,
            load_balancing_scheme="EXTERNAL_MANAGED",
            protocol="HTTPS",
            tls_settings={
                "sni": "example.com",
                "subject_alt_names": [
                    {
                        "dns_name": "example.com",
                    },
                    {
                        "uniform_resource_identifier": "https://example.com",
                    },
                ],
                "authentication_config": default_backend_authentication_config.id.apply(lambda id: f"//networksecurity.googleapis.com/{id}"),
            })
        ```
        ### Backend Service Dynamic Forwarding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.BackendService("default",
            name="backend-service",
            load_balancing_scheme="INTERNAL_MANAGED",
            dynamic_forwarding={
                "ip_port_selection": {
                    "enabled": True,
                },
            })
        ```

        ## Import

        BackendService can be imported using any of these accepted formats:

        * `projects/{{project}}/global/backendServices/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, BackendService can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/backendService:BackendService default projects/{{project}}/global/backendServices/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/backendService:BackendService default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/backendService:BackendService default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param BackendServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackendServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 affinity_cookie_ttl_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 backends: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackendServiceBackendArgs', 'BackendServiceBackendArgsDict']]]]] = None,
                 cdn_policy: Optional[pulumi.Input[Union['BackendServiceCdnPolicyArgs', 'BackendServiceCdnPolicyArgsDict']]] = None,
                 circuit_breakers: Optional[pulumi.Input[Union['BackendServiceCircuitBreakersArgs', 'BackendServiceCircuitBreakersArgsDict']]] = None,
                 compression_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_draining_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 consistent_hash: Optional[pulumi.Input[Union['BackendServiceConsistentHashArgs', 'BackendServiceConsistentHashArgsDict']]] = None,
                 custom_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackendServiceCustomMetricArgs', 'BackendServiceCustomMetricArgsDict']]]]] = None,
                 custom_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 custom_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic_forwarding: Optional[pulumi.Input[Union['BackendServiceDynamicForwardingArgs', 'BackendServiceDynamicForwardingArgsDict']]] = None,
                 edge_security_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_cdn: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_managed_migration_state: Optional[pulumi.Input[_builtins.str]] = None,
                 external_managed_migration_testing_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 health_checks: Optional[pulumi.Input[_builtins.str]] = None,
                 iap: Optional[pulumi.Input[Union['BackendServiceIapArgs', 'BackendServiceIapArgsDict']]] = None,
                 ip_address_selection_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 locality_lb_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackendServiceLocalityLbPolicyArgs', 'BackendServiceLocalityLbPolicyArgsDict']]]]] = None,
                 locality_lb_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 log_config: Optional[pulumi.Input[Union['BackendServiceLogConfigArgs', 'BackendServiceLogConfigArgsDict']]] = None,
                 max_stream_duration: Optional[pulumi.Input[Union['BackendServiceMaxStreamDurationArgs', 'BackendServiceMaxStreamDurationArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_pass_through_lb_traffic_policy: Optional[pulumi.Input[Union['BackendServiceNetworkPassThroughLbTrafficPolicyArgs', 'BackendServiceNetworkPassThroughLbTrafficPolicyArgsDict']]] = None,
                 outlier_detection: Optional[pulumi.Input[Union['BackendServiceOutlierDetectionArgs', 'BackendServiceOutlierDetectionArgsDict']]] = None,
                 params: Optional[pulumi.Input[Union['BackendServiceParamsArgs', 'BackendServiceParamsArgsDict']]] = None,
                 port_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 security_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_settings: Optional[pulumi.Input[Union['BackendServiceSecuritySettingsArgs', 'BackendServiceSecuritySettingsArgsDict']]] = None,
                 service_lb_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 session_affinity: Optional[pulumi.Input[_builtins.str]] = None,
                 strong_session_affinity_cookie: Optional[pulumi.Input[Union['BackendServiceStrongSessionAffinityCookieArgs', 'BackendServiceStrongSessionAffinityCookieArgsDict']]] = None,
                 timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 tls_settings: Optional[pulumi.Input[Union['BackendServiceTlsSettingsArgs', 'BackendServiceTlsSettingsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackendServiceArgs.__new__(BackendServiceArgs)

            __props__.__dict__["affinity_cookie_ttl_sec"] = affinity_cookie_ttl_sec
            __props__.__dict__["backends"] = backends
            __props__.__dict__["cdn_policy"] = cdn_policy
            __props__.__dict__["circuit_breakers"] = circuit_breakers
            __props__.__dict__["compression_mode"] = compression_mode
            __props__.__dict__["connection_draining_timeout_sec"] = connection_draining_timeout_sec
            __props__.__dict__["consistent_hash"] = consistent_hash
            __props__.__dict__["custom_metrics"] = custom_metrics
            __props__.__dict__["custom_request_headers"] = custom_request_headers
            __props__.__dict__["custom_response_headers"] = custom_response_headers
            __props__.__dict__["description"] = description
            __props__.__dict__["dynamic_forwarding"] = dynamic_forwarding
            __props__.__dict__["edge_security_policy"] = edge_security_policy
            __props__.__dict__["enable_cdn"] = enable_cdn
            __props__.__dict__["external_managed_migration_state"] = external_managed_migration_state
            __props__.__dict__["external_managed_migration_testing_percentage"] = external_managed_migration_testing_percentage
            __props__.__dict__["health_checks"] = health_checks
            __props__.__dict__["iap"] = iap
            __props__.__dict__["ip_address_selection_policy"] = ip_address_selection_policy
            __props__.__dict__["load_balancing_scheme"] = load_balancing_scheme
            __props__.__dict__["locality_lb_policies"] = locality_lb_policies
            __props__.__dict__["locality_lb_policy"] = locality_lb_policy
            __props__.__dict__["log_config"] = log_config
            __props__.__dict__["max_stream_duration"] = max_stream_duration
            __props__.__dict__["name"] = name
            __props__.__dict__["network_pass_through_lb_traffic_policy"] = network_pass_through_lb_traffic_policy
            __props__.__dict__["outlier_detection"] = outlier_detection
            __props__.__dict__["params"] = params
            __props__.__dict__["port_name"] = port_name
            __props__.__dict__["project"] = project
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["security_policy"] = security_policy
            __props__.__dict__["security_settings"] = security_settings
            __props__.__dict__["service_lb_policy"] = service_lb_policy
            __props__.__dict__["session_affinity"] = session_affinity
            __props__.__dict__["strong_session_affinity_cookie"] = strong_session_affinity_cookie
            __props__.__dict__["timeout_sec"] = timeout_sec
            __props__.__dict__["tls_settings"] = tls_settings
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["fingerprint"] = None
            __props__.__dict__["generated_id"] = None
            __props__.__dict__["self_link"] = None
        super(BackendService, __self__).__init__(
            'gcp:compute/backendService:BackendService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            affinity_cookie_ttl_sec: Optional[pulumi.Input[_builtins.int]] = None,
            backends: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackendServiceBackendArgs', 'BackendServiceBackendArgsDict']]]]] = None,
            cdn_policy: Optional[pulumi.Input[Union['BackendServiceCdnPolicyArgs', 'BackendServiceCdnPolicyArgsDict']]] = None,
            circuit_breakers: Optional[pulumi.Input[Union['BackendServiceCircuitBreakersArgs', 'BackendServiceCircuitBreakersArgsDict']]] = None,
            compression_mode: Optional[pulumi.Input[_builtins.str]] = None,
            connection_draining_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
            consistent_hash: Optional[pulumi.Input[Union['BackendServiceConsistentHashArgs', 'BackendServiceConsistentHashArgsDict']]] = None,
            creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            custom_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackendServiceCustomMetricArgs', 'BackendServiceCustomMetricArgsDict']]]]] = None,
            custom_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            custom_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dynamic_forwarding: Optional[pulumi.Input[Union['BackendServiceDynamicForwardingArgs', 'BackendServiceDynamicForwardingArgsDict']]] = None,
            edge_security_policy: Optional[pulumi.Input[_builtins.str]] = None,
            enable_cdn: Optional[pulumi.Input[_builtins.bool]] = None,
            external_managed_migration_state: Optional[pulumi.Input[_builtins.str]] = None,
            external_managed_migration_testing_percentage: Optional[pulumi.Input[_builtins.float]] = None,
            fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
            generated_id: Optional[pulumi.Input[_builtins.int]] = None,
            health_checks: Optional[pulumi.Input[_builtins.str]] = None,
            iap: Optional[pulumi.Input[Union['BackendServiceIapArgs', 'BackendServiceIapArgsDict']]] = None,
            ip_address_selection_policy: Optional[pulumi.Input[_builtins.str]] = None,
            load_balancing_scheme: Optional[pulumi.Input[_builtins.str]] = None,
            locality_lb_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackendServiceLocalityLbPolicyArgs', 'BackendServiceLocalityLbPolicyArgsDict']]]]] = None,
            locality_lb_policy: Optional[pulumi.Input[_builtins.str]] = None,
            log_config: Optional[pulumi.Input[Union['BackendServiceLogConfigArgs', 'BackendServiceLogConfigArgsDict']]] = None,
            max_stream_duration: Optional[pulumi.Input[Union['BackendServiceMaxStreamDurationArgs', 'BackendServiceMaxStreamDurationArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_pass_through_lb_traffic_policy: Optional[pulumi.Input[Union['BackendServiceNetworkPassThroughLbTrafficPolicyArgs', 'BackendServiceNetworkPassThroughLbTrafficPolicyArgsDict']]] = None,
            outlier_detection: Optional[pulumi.Input[Union['BackendServiceOutlierDetectionArgs', 'BackendServiceOutlierDetectionArgsDict']]] = None,
            params: Optional[pulumi.Input[Union['BackendServiceParamsArgs', 'BackendServiceParamsArgsDict']]] = None,
            port_name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            security_policy: Optional[pulumi.Input[_builtins.str]] = None,
            security_settings: Optional[pulumi.Input[Union['BackendServiceSecuritySettingsArgs', 'BackendServiceSecuritySettingsArgsDict']]] = None,
            self_link: Optional[pulumi.Input[_builtins.str]] = None,
            service_lb_policy: Optional[pulumi.Input[_builtins.str]] = None,
            session_affinity: Optional[pulumi.Input[_builtins.str]] = None,
            strong_session_affinity_cookie: Optional[pulumi.Input[Union['BackendServiceStrongSessionAffinityCookieArgs', 'BackendServiceStrongSessionAffinityCookieArgsDict']]] = None,
            timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
            tls_settings: Optional[pulumi.Input[Union['BackendServiceTlsSettingsArgs', 'BackendServiceTlsSettingsArgsDict']]] = None) -> 'BackendService':
        """
        Get an existing BackendService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] affinity_cookie_ttl_sec: Lifetime of cookies in seconds if session_affinity is
               GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
               only until the end of the browser session (or equivalent). The
               maximum allowed value for TTL is one day.
               When the load balancing scheme is INTERNAL, this field is not used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BackendServiceBackendArgs', 'BackendServiceBackendArgsDict']]]] backends: The set of backends that serve this BackendService.
               Structure is documented below.
        :param pulumi.Input[Union['BackendServiceCdnPolicyArgs', 'BackendServiceCdnPolicyArgsDict']] cdn_policy: Cloud CDN configuration for this BackendService.
               Structure is documented below.
        :param pulumi.Input[Union['BackendServiceCircuitBreakersArgs', 'BackendServiceCircuitBreakersArgsDict']] circuit_breakers: Settings controlling the volume of connections to a backend service. This field
               is applicable only when the load_balancing_scheme is set to INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] compression_mode: Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
               Possible values are: `AUTOMATIC`, `DISABLED`.
        :param pulumi.Input[_builtins.int] connection_draining_timeout_sec: Time for which instance will be drained (not accept new
               connections, but still work to finish started).
        :param pulumi.Input[Union['BackendServiceConsistentHashArgs', 'BackendServiceConsistentHashArgsDict']] consistent_hash: Consistent Hash-based load balancing can be used to provide soft session
               affinity based on HTTP headers, cookies or other properties. This load balancing
               policy is applicable only for HTTP connections. The affinity to a particular
               destination host will be lost when one or more hosts are added/removed from the
               destination service. This field specifies parameters that control consistent
               hashing. This field only applies if the load_balancing_scheme is set to
               INTERNAL_SELF_MANAGED. This field is only applicable when locality_lb_policy is
               set to MAGLEV or RING_HASH.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BackendServiceCustomMetricArgs', 'BackendServiceCustomMetricArgsDict']]]] custom_metrics: List of custom metrics that are used for the WEIGHTED_ROUND_ROBIN locality_lb_policy.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_request_headers: Headers that the HTTP/S load balancer should add to proxied
               requests.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_response_headers: Headers that the HTTP/S load balancer should add to proxied
               responses.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[Union['BackendServiceDynamicForwardingArgs', 'BackendServiceDynamicForwardingArgsDict']] dynamic_forwarding: Dynamic forwarding configuration. This field is used to configure the backend service with dynamic forwarding
               feature which together with Service Extension allows customized and complex routing logic.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] edge_security_policy: The resource URL for the edge security policy associated with this backend service.
        :param pulumi.Input[_builtins.bool] enable_cdn: If true, enable Cloud CDN for this BackendService.
        :param pulumi.Input[_builtins.str] external_managed_migration_state: Specifies the canary migration state. Possible values are PREPARE, TEST_BY_PERCENTAGE, and
               TEST_ALL_TRAFFIC.
               To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to
               PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be
               changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate
               traffic by percentage using externalManagedMigrationTestingPercentage.
               Rolling back a migration requires the states to be set in reverse order. So changing the
               scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at
               the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic
               back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
               Possible values are: `PREPARE`, `TEST_BY_PERCENTAGE`, `TEST_ALL_TRAFFIC`.
        :param pulumi.Input[_builtins.float] external_managed_migration_testing_percentage: Determines the fraction of requests that should be processed by the Global external
               Application Load Balancer.
               The value of this field must be in the range [0, 100].
               Session affinity options will slightly affect this routing behavior, for more details,
               see: Session Affinity.
               This value can only be set if the loadBalancingScheme in the backend service is set to
               EXTERNAL (when using the Classic ALB) and the migration state is TEST_BY_PERCENTAGE.
        :param pulumi.Input[_builtins.str] fingerprint: Fingerprint of this resource. A hash of the contents stored in this
               object. This field is used in optimistic locking.
        :param pulumi.Input[_builtins.int] generated_id: The unique identifier for the resource. This identifier is defined by the server.
        :param pulumi.Input[_builtins.str] health_checks: The set of URLs to the HttpHealthCheck or HttpsHealthCheck resource
               for health checking this BackendService. Currently at most one health
               check can be specified.
               A health check must be specified unless the backend service uses an internet
               or serverless NEG as a backend.
               For internal load balancing, a URL to a HealthCheck resource must be specified instead.
        :param pulumi.Input[Union['BackendServiceIapArgs', 'BackendServiceIapArgsDict']] iap: Settings for enabling Cloud Identity Aware Proxy.
               If OAuth client is not set, the Google-managed OAuth client is used.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] ip_address_selection_policy: Specifies preference of traffic to the backend (from the proxy and from the client for proxyless gRPC).
               Possible values are: `IPV4_ONLY`, `PREFER_IPV6`, `IPV6_ONLY`.
        :param pulumi.Input[_builtins.str] load_balancing_scheme: Indicates whether the backend service will be used with internal or
               external load balancing. A backend service created for one type of
               load balancing cannot be used with the other. For more information, refer to
               [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service).
               Default value is `EXTERNAL`.
               Possible values are: `EXTERNAL`, `INTERNAL_SELF_MANAGED`, `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BackendServiceLocalityLbPolicyArgs', 'BackendServiceLocalityLbPolicyArgsDict']]]] locality_lb_policies: A list of locality load balancing policies to be used in order of
               preference. Either the policy or the customPolicy field should be set.
               Overrides any value set in the localityLbPolicy field.
               localityLbPolicies is only supported when the BackendService is referenced
               by a URL Map that is referenced by a target gRPC proxy that has the
               validateForProxyless field set to true.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] locality_lb_policy: The load balancing algorithm used within the scope of the locality.
               The possible values are:
               * `ROUND_ROBIN`: This is a simple policy in which each healthy backend
               is selected in round robin order.
               * `LEAST_REQUEST`: An O(1) algorithm which selects two random healthy
               hosts and picks the host which has fewer active requests.
               * `RING_HASH`: The ring/modulo hash load balancer implements consistent
               hashing to backends. The algorithm has the property that the
               addition/removal of a host from a set of N hosts only affects
               1/N of the requests.
               * `RANDOM`: The load balancer selects a random healthy host.
               * `ORIGINAL_DESTINATION`: Backend host is selected based on the client
               connection metadata, i.e., connections are opened
               to the same address as the destination address of
               the incoming connection before the connection
               was redirected to the load balancer.
               * `MAGLEV`: used as a drop in replacement for the ring hash load balancer.
               Maglev is not as stable as ring hash but has faster table lookup
               build times and host selection times. For more information about
               Maglev, refer to https://ai.google/research/pubs/pub44824
               * `WEIGHTED_MAGLEV`: Per-instance weighted Load Balancing via health check
               reported weights. Only applicable to loadBalancingScheme
               EXTERNAL. If set, the Backend Service must
               configure a non legacy HTTP-based Health Check, and
               health check replies are expected to contain
               non-standard HTTP response header field
               X-Load-Balancing-Endpoint-Weight to specify the
               per-instance weights. If set, Load Balancing is weight
               based on the per-instance weights reported in the last
               processed health check replies, as long as every
               instance either reported a valid weight or had
               UNAVAILABLE_WEIGHT. Otherwise, Load Balancing remains
               equal-weight.
               * `WEIGHTED_ROUND_ROBIN`: Per-endpoint weighted round-robin Load Balancing using weights computed
               from Backend reported Custom Metrics. If set, the Backend Service
               responses are expected to contain non-standard HTTP response header field
               X-Endpoint-Load-Metrics. The reported metrics
               to use for computing the weights are specified via the
               backends[].customMetrics fields.
               locality_lb_policy is applicable to either:
               * A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C,
               and loadBalancingScheme set to INTERNAL_MANAGED.
               * A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
               * A regional backend service with loadBalancingScheme set to EXTERNAL (External Network
               Load Balancing). Only MAGLEV and WEIGHTED_MAGLEV values are possible for External
               Network Load Balancing. The default is MAGLEV.
               If session_affinity is not NONE, and locality_lb_policy is not set to MAGLEV, WEIGHTED_MAGLEV,
               or RING_HASH, session affinity settings will not take effect.
               Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced
               by a URL map that is bound to target gRPC proxy that has validate_for_proxyless
               field set to true.
               Possible values are: `ROUND_ROBIN`, `LEAST_REQUEST`, `RING_HASH`, `RANDOM`, `ORIGINAL_DESTINATION`, `MAGLEV`, `WEIGHTED_MAGLEV`, `WEIGHTED_ROUND_ROBIN`.
        :param pulumi.Input[Union['BackendServiceLogConfigArgs', 'BackendServiceLogConfigArgsDict']] log_config: This field denotes the logging options for the load balancer traffic served by this backend service.
               If logging is enabled, logs will be exported to Stackdriver.
               Structure is documented below.
        :param pulumi.Input[Union['BackendServiceMaxStreamDurationArgs', 'BackendServiceMaxStreamDurationArgsDict']] max_stream_duration: Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the
               beginning of the stream until the response has been completely processed, including all retries. A stream that
               does not complete in this duration is closed.
               If not specified, there will be no timeout limit, i.e. the maximum duration is infinite.
               This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service.
               This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[Union['BackendServiceNetworkPassThroughLbTrafficPolicyArgs', 'BackendServiceNetworkPassThroughLbTrafficPolicyArgsDict']] network_pass_through_lb_traffic_policy: Configures traffic steering properties of internal passthrough Network Load Balancers.
               Structure is documented below.
        :param pulumi.Input[Union['BackendServiceOutlierDetectionArgs', 'BackendServiceOutlierDetectionArgsDict']] outlier_detection: Settings controlling eviction of unhealthy hosts from the load balancing pool.
               Applicable backend service types can be a global backend service with the
               loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED.
               Structure is documented below.
        :param pulumi.Input[Union['BackendServiceParamsArgs', 'BackendServiceParamsArgsDict']] params: Additional params passed with the request, but not persisted as part of resource payload
               Structure is documented below.
        :param pulumi.Input[_builtins.str] port_name: Name of backend port. The same name should appear in the instance
               groups referenced by this service. Required when the load balancing
               scheme is EXTERNAL.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] protocol: The protocol this BackendService uses to communicate with backends.
               The default is HTTP. Possible values are HTTP, HTTPS, HTTP2, H2C, TCP, SSL, UDP
               or GRPC. Refer to the documentation for the load balancers or for Traffic Director
               for more information. Must be set to GRPC when the backend service is referenced
               by a URL map that is bound to target gRPC proxy.
               Possible values are: `HTTP`, `HTTPS`, `HTTP2`, `TCP`, `SSL`, `UDP`, `GRPC`, `UNSPECIFIED`, `H2C`.
        :param pulumi.Input[_builtins.str] security_policy: The security policy associated with this backend service.
        :param pulumi.Input[Union['BackendServiceSecuritySettingsArgs', 'BackendServiceSecuritySettingsArgsDict']] security_settings: The security settings that apply to this backend service. This field is applicable to either
               a regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C, and
               load_balancing_scheme set to INTERNAL_MANAGED; or a global backend service with the
               load_balancing_scheme set to INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[_builtins.str] service_lb_policy: URL to networkservices.ServiceLbPolicy resource.
               Can only be set if load balancing scheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED or INTERNAL_SELF_MANAGED and the scope is global.
        :param pulumi.Input[_builtins.str] session_affinity: Type of session affinity to use. The default is NONE. Session affinity is
               not applicable if the protocol is UDP.
               Possible values are: `NONE`, `CLIENT_IP`, `CLIENT_IP_PORT_PROTO`, `CLIENT_IP_PROTO`, `GENERATED_COOKIE`, `HEADER_FIELD`, `HTTP_COOKIE`, `STRONG_COOKIE_AFFINITY`.
        :param pulumi.Input[Union['BackendServiceStrongSessionAffinityCookieArgs', 'BackendServiceStrongSessionAffinityCookieArgsDict']] strong_session_affinity_cookie: Describes the HTTP cookie used for stateful session affinity. This field is applicable and required if the sessionAffinity is set to STRONG_COOKIE_AFFINITY.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] timeout_sec: The backend service timeout has a different meaning depending on the type of load balancer.
               For more information see, [Backend service settings](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices).
               The default is 30 seconds.
               The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds.
        :param pulumi.Input[Union['BackendServiceTlsSettingsArgs', 'BackendServiceTlsSettingsArgsDict']] tls_settings: Configuration for Backend Authenticated TLS and mTLS. May only be specified when the backend protocol is SSL, HTTPS or HTTP2.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackendServiceState.__new__(_BackendServiceState)

        __props__.__dict__["affinity_cookie_ttl_sec"] = affinity_cookie_ttl_sec
        __props__.__dict__["backends"] = backends
        __props__.__dict__["cdn_policy"] = cdn_policy
        __props__.__dict__["circuit_breakers"] = circuit_breakers
        __props__.__dict__["compression_mode"] = compression_mode
        __props__.__dict__["connection_draining_timeout_sec"] = connection_draining_timeout_sec
        __props__.__dict__["consistent_hash"] = consistent_hash
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["custom_metrics"] = custom_metrics
        __props__.__dict__["custom_request_headers"] = custom_request_headers
        __props__.__dict__["custom_response_headers"] = custom_response_headers
        __props__.__dict__["description"] = description
        __props__.__dict__["dynamic_forwarding"] = dynamic_forwarding
        __props__.__dict__["edge_security_policy"] = edge_security_policy
        __props__.__dict__["enable_cdn"] = enable_cdn
        __props__.__dict__["external_managed_migration_state"] = external_managed_migration_state
        __props__.__dict__["external_managed_migration_testing_percentage"] = external_managed_migration_testing_percentage
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["generated_id"] = generated_id
        __props__.__dict__["health_checks"] = health_checks
        __props__.__dict__["iap"] = iap
        __props__.__dict__["ip_address_selection_policy"] = ip_address_selection_policy
        __props__.__dict__["load_balancing_scheme"] = load_balancing_scheme
        __props__.__dict__["locality_lb_policies"] = locality_lb_policies
        __props__.__dict__["locality_lb_policy"] = locality_lb_policy
        __props__.__dict__["log_config"] = log_config
        __props__.__dict__["max_stream_duration"] = max_stream_duration
        __props__.__dict__["name"] = name
        __props__.__dict__["network_pass_through_lb_traffic_policy"] = network_pass_through_lb_traffic_policy
        __props__.__dict__["outlier_detection"] = outlier_detection
        __props__.__dict__["params"] = params
        __props__.__dict__["port_name"] = port_name
        __props__.__dict__["project"] = project
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["security_policy"] = security_policy
        __props__.__dict__["security_settings"] = security_settings
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["service_lb_policy"] = service_lb_policy
        __props__.__dict__["session_affinity"] = session_affinity
        __props__.__dict__["strong_session_affinity_cookie"] = strong_session_affinity_cookie
        __props__.__dict__["timeout_sec"] = timeout_sec
        __props__.__dict__["tls_settings"] = tls_settings
        return BackendService(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="affinityCookieTtlSec")
    def affinity_cookie_ttl_sec(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Lifetime of cookies in seconds if session_affinity is
        GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
        only until the end of the browser session (or equivalent). The
        maximum allowed value for TTL is one day.
        When the load balancing scheme is INTERNAL, this field is not used.
        """
        return pulumi.get(self, "affinity_cookie_ttl_sec")

    @_builtins.property
    @pulumi.getter
    def backends(self) -> pulumi.Output[Optional[Sequence['outputs.BackendServiceBackend']]]:
        """
        The set of backends that serve this BackendService.
        Structure is documented below.
        """
        return pulumi.get(self, "backends")

    @_builtins.property
    @pulumi.getter(name="cdnPolicy")
    def cdn_policy(self) -> pulumi.Output['outputs.BackendServiceCdnPolicy']:
        """
        Cloud CDN configuration for this BackendService.
        Structure is documented below.
        """
        return pulumi.get(self, "cdn_policy")

    @_builtins.property
    @pulumi.getter(name="circuitBreakers")
    def circuit_breakers(self) -> pulumi.Output[Optional['outputs.BackendServiceCircuitBreakers']]:
        """
        Settings controlling the volume of connections to a backend service. This field
        is applicable only when the load_balancing_scheme is set to INTERNAL_SELF_MANAGED.
        Structure is documented below.
        """
        return pulumi.get(self, "circuit_breakers")

    @_builtins.property
    @pulumi.getter(name="compressionMode")
    def compression_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
        Possible values are: `AUTOMATIC`, `DISABLED`.
        """
        return pulumi.get(self, "compression_mode")

    @_builtins.property
    @pulumi.getter(name="connectionDrainingTimeoutSec")
    def connection_draining_timeout_sec(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Time for which instance will be drained (not accept new
        connections, but still work to finish started).
        """
        return pulumi.get(self, "connection_draining_timeout_sec")

    @_builtins.property
    @pulumi.getter(name="consistentHash")
    def consistent_hash(self) -> pulumi.Output[Optional['outputs.BackendServiceConsistentHash']]:
        """
        Consistent Hash-based load balancing can be used to provide soft session
        affinity based on HTTP headers, cookies or other properties. This load balancing
        policy is applicable only for HTTP connections. The affinity to a particular
        destination host will be lost when one or more hosts are added/removed from the
        destination service. This field specifies parameters that control consistent
        hashing. This field only applies if the load_balancing_scheme is set to
        INTERNAL_SELF_MANAGED. This field is only applicable when locality_lb_policy is
        set to MAGLEV or RING_HASH.
        Structure is documented below.
        """
        return pulumi.get(self, "consistent_hash")

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @_builtins.property
    @pulumi.getter(name="customMetrics")
    def custom_metrics(self) -> pulumi.Output[Optional[Sequence['outputs.BackendServiceCustomMetric']]]:
        """
        List of custom metrics that are used for the WEIGHTED_ROUND_ROBIN locality_lb_policy.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_metrics")

    @_builtins.property
    @pulumi.getter(name="customRequestHeaders")
    def custom_request_headers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Headers that the HTTP/S load balancer should add to proxied
        requests.
        """
        return pulumi.get(self, "custom_request_headers")

    @_builtins.property
    @pulumi.getter(name="customResponseHeaders")
    def custom_response_headers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Headers that the HTTP/S load balancer should add to proxied
        responses.
        """
        return pulumi.get(self, "custom_response_headers")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dynamicForwarding")
    def dynamic_forwarding(self) -> pulumi.Output[Optional['outputs.BackendServiceDynamicForwarding']]:
        """
        Dynamic forwarding configuration. This field is used to configure the backend service with dynamic forwarding
        feature which together with Service Extension allows customized and complex routing logic.
        Structure is documented below.
        """
        return pulumi.get(self, "dynamic_forwarding")

    @_builtins.property
    @pulumi.getter(name="edgeSecurityPolicy")
    def edge_security_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource URL for the edge security policy associated with this backend service.
        """
        return pulumi.get(self, "edge_security_policy")

    @_builtins.property
    @pulumi.getter(name="enableCdn")
    def enable_cdn(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, enable Cloud CDN for this BackendService.
        """
        return pulumi.get(self, "enable_cdn")

    @_builtins.property
    @pulumi.getter(name="externalManagedMigrationState")
    def external_managed_migration_state(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the canary migration state. Possible values are PREPARE, TEST_BY_PERCENTAGE, and
        TEST_ALL_TRAFFIC.
        To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to
        PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be
        changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate
        traffic by percentage using externalManagedMigrationTestingPercentage.
        Rolling back a migration requires the states to be set in reverse order. So changing the
        scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at
        the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic
        back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
        Possible values are: `PREPARE`, `TEST_BY_PERCENTAGE`, `TEST_ALL_TRAFFIC`.
        """
        return pulumi.get(self, "external_managed_migration_state")

    @_builtins.property
    @pulumi.getter(name="externalManagedMigrationTestingPercentage")
    def external_managed_migration_testing_percentage(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        Determines the fraction of requests that should be processed by the Global external
        Application Load Balancer.
        The value of this field must be in the range [0, 100].
        Session affinity options will slightly affect this routing behavior, for more details,
        see: Session Affinity.
        This value can only be set if the loadBalancingScheme in the backend service is set to
        EXTERNAL (when using the Classic ALB) and the migration state is TEST_BY_PERCENTAGE.
        """
        return pulumi.get(self, "external_managed_migration_testing_percentage")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[_builtins.str]:
        """
        Fingerprint of this resource. A hash of the contents stored in this
        object. This field is used in optimistic locking.
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter(name="generatedId")
    def generated_id(self) -> pulumi.Output[_builtins.int]:
        """
        The unique identifier for the resource. This identifier is defined by the server.
        """
        return pulumi.get(self, "generated_id")

    @_builtins.property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The set of URLs to the HttpHealthCheck or HttpsHealthCheck resource
        for health checking this BackendService. Currently at most one health
        check can be specified.
        A health check must be specified unless the backend service uses an internet
        or serverless NEG as a backend.
        For internal load balancing, a URL to a HealthCheck resource must be specified instead.
        """
        return pulumi.get(self, "health_checks")

    @_builtins.property
    @pulumi.getter
    def iap(self) -> pulumi.Output['outputs.BackendServiceIap']:
        """
        Settings for enabling Cloud Identity Aware Proxy.
        If OAuth client is not set, the Google-managed OAuth client is used.
        Structure is documented below.
        """
        return pulumi.get(self, "iap")

    @_builtins.property
    @pulumi.getter(name="ipAddressSelectionPolicy")
    def ip_address_selection_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies preference of traffic to the backend (from the proxy and from the client for proxyless gRPC).
        Possible values are: `IPV4_ONLY`, `PREFER_IPV6`, `IPV6_ONLY`.
        """
        return pulumi.get(self, "ip_address_selection_policy")

    @_builtins.property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Indicates whether the backend service will be used with internal or
        external load balancing. A backend service created for one type of
        load balancing cannot be used with the other. For more information, refer to
        [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service).
        Default value is `EXTERNAL`.
        Possible values are: `EXTERNAL`, `INTERNAL_SELF_MANAGED`, `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @_builtins.property
    @pulumi.getter(name="localityLbPolicies")
    def locality_lb_policies(self) -> pulumi.Output[Optional[Sequence['outputs.BackendServiceLocalityLbPolicy']]]:
        """
        A list of locality load balancing policies to be used in order of
        preference. Either the policy or the customPolicy field should be set.
        Overrides any value set in the localityLbPolicy field.
        localityLbPolicies is only supported when the BackendService is referenced
        by a URL Map that is referenced by a target gRPC proxy that has the
        validateForProxyless field set to true.
        Structure is documented below.
        """
        return pulumi.get(self, "locality_lb_policies")

    @_builtins.property
    @pulumi.getter(name="localityLbPolicy")
    def locality_lb_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The load balancing algorithm used within the scope of the locality.
        The possible values are:
        * `ROUND_ROBIN`: This is a simple policy in which each healthy backend
        is selected in round robin order.
        * `LEAST_REQUEST`: An O(1) algorithm which selects two random healthy
        hosts and picks the host which has fewer active requests.
        * `RING_HASH`: The ring/modulo hash load balancer implements consistent
        hashing to backends. The algorithm has the property that the
        addition/removal of a host from a set of N hosts only affects
        1/N of the requests.
        * `RANDOM`: The load balancer selects a random healthy host.
        * `ORIGINAL_DESTINATION`: Backend host is selected based on the client
        connection metadata, i.e., connections are opened
        to the same address as the destination address of
        the incoming connection before the connection
        was redirected to the load balancer.
        * `MAGLEV`: used as a drop in replacement for the ring hash load balancer.
        Maglev is not as stable as ring hash but has faster table lookup
        build times and host selection times. For more information about
        Maglev, refer to https://ai.google/research/pubs/pub44824
        * `WEIGHTED_MAGLEV`: Per-instance weighted Load Balancing via health check
        reported weights. Only applicable to loadBalancingScheme
        EXTERNAL. If set, the Backend Service must
        configure a non legacy HTTP-based Health Check, and
        health check replies are expected to contain
        non-standard HTTP response header field
        X-Load-Balancing-Endpoint-Weight to specify the
        per-instance weights. If set, Load Balancing is weight
        based on the per-instance weights reported in the last
        processed health check replies, as long as every
        instance either reported a valid weight or had
        UNAVAILABLE_WEIGHT. Otherwise, Load Balancing remains
        equal-weight.
        * `WEIGHTED_ROUND_ROBIN`: Per-endpoint weighted round-robin Load Balancing using weights computed
        from Backend reported Custom Metrics. If set, the Backend Service
        responses are expected to contain non-standard HTTP response header field
        X-Endpoint-Load-Metrics. The reported metrics
        to use for computing the weights are specified via the
        backends[].customMetrics fields.
        locality_lb_policy is applicable to either:
        * A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C,
        and loadBalancingScheme set to INTERNAL_MANAGED.
        * A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
        * A regional backend service with loadBalancingScheme set to EXTERNAL (External Network
        Load Balancing). Only MAGLEV and WEIGHTED_MAGLEV values are possible for External
        Network Load Balancing. The default is MAGLEV.
        If session_affinity is not NONE, and locality_lb_policy is not set to MAGLEV, WEIGHTED_MAGLEV,
        or RING_HASH, session affinity settings will not take effect.
        Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced
        by a URL map that is bound to target gRPC proxy that has validate_for_proxyless
        field set to true.
        Possible values are: `ROUND_ROBIN`, `LEAST_REQUEST`, `RING_HASH`, `RANDOM`, `ORIGINAL_DESTINATION`, `MAGLEV`, `WEIGHTED_MAGLEV`, `WEIGHTED_ROUND_ROBIN`.
        """
        return pulumi.get(self, "locality_lb_policy")

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> pulumi.Output['outputs.BackendServiceLogConfig']:
        """
        This field denotes the logging options for the load balancer traffic served by this backend service.
        If logging is enabled, logs will be exported to Stackdriver.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @_builtins.property
    @pulumi.getter(name="maxStreamDuration")
    def max_stream_duration(self) -> pulumi.Output[Optional['outputs.BackendServiceMaxStreamDuration']]:
        """
        Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the
        beginning of the stream until the response has been completely processed, including all retries. A stream that
        does not complete in this duration is closed.
        If not specified, there will be no timeout limit, i.e. the maximum duration is infinite.
        This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service.
        This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
        Structure is documented below.
        """
        return pulumi.get(self, "max_stream_duration")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkPassThroughLbTrafficPolicy")
    def network_pass_through_lb_traffic_policy(self) -> pulumi.Output[Optional['outputs.BackendServiceNetworkPassThroughLbTrafficPolicy']]:
        """
        Configures traffic steering properties of internal passthrough Network Load Balancers.
        Structure is documented below.
        """
        return pulumi.get(self, "network_pass_through_lb_traffic_policy")

    @_builtins.property
    @pulumi.getter(name="outlierDetection")
    def outlier_detection(self) -> pulumi.Output[Optional['outputs.BackendServiceOutlierDetection']]:
        """
        Settings controlling eviction of unhealthy hosts from the load balancing pool.
        Applicable backend service types can be a global backend service with the
        loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED.
        Structure is documented below.
        """
        return pulumi.get(self, "outlier_detection")

    @_builtins.property
    @pulumi.getter
    def params(self) -> pulumi.Output[Optional['outputs.BackendServiceParams']]:
        """
        Additional params passed with the request, but not persisted as part of resource payload
        Structure is documented below.
        """
        return pulumi.get(self, "params")

    @_builtins.property
    @pulumi.getter(name="portName")
    def port_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of backend port. The same name should appear in the instance
        groups referenced by this service. Required when the load balancing
        scheme is EXTERNAL.
        """
        return pulumi.get(self, "port_name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.str]:
        """
        The protocol this BackendService uses to communicate with backends.
        The default is HTTP. Possible values are HTTP, HTTPS, HTTP2, H2C, TCP, SSL, UDP
        or GRPC. Refer to the documentation for the load balancers or for Traffic Director
        for more information. Must be set to GRPC when the backend service is referenced
        by a URL map that is bound to target gRPC proxy.
        Possible values are: `HTTP`, `HTTPS`, `HTTP2`, `TCP`, `SSL`, `UDP`, `GRPC`, `UNSPECIFIED`, `H2C`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The security policy associated with this backend service.
        """
        return pulumi.get(self, "security_policy")

    @_builtins.property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> pulumi.Output[Optional['outputs.BackendServiceSecuritySettings']]:
        """
        The security settings that apply to this backend service. This field is applicable to either
        a regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C, and
        load_balancing_scheme set to INTERNAL_MANAGED; or a global backend service with the
        load_balancing_scheme set to INTERNAL_SELF_MANAGED.
        Structure is documented below.
        """
        return pulumi.get(self, "security_settings")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[_builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter(name="serviceLbPolicy")
    def service_lb_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        URL to networkservices.ServiceLbPolicy resource.
        Can only be set if load balancing scheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED or INTERNAL_SELF_MANAGED and the scope is global.
        """
        return pulumi.get(self, "service_lb_policy")

    @_builtins.property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> pulumi.Output[_builtins.str]:
        """
        Type of session affinity to use. The default is NONE. Session affinity is
        not applicable if the protocol is UDP.
        Possible values are: `NONE`, `CLIENT_IP`, `CLIENT_IP_PORT_PROTO`, `CLIENT_IP_PROTO`, `GENERATED_COOKIE`, `HEADER_FIELD`, `HTTP_COOKIE`, `STRONG_COOKIE_AFFINITY`.
        """
        return pulumi.get(self, "session_affinity")

    @_builtins.property
    @pulumi.getter(name="strongSessionAffinityCookie")
    def strong_session_affinity_cookie(self) -> pulumi.Output[Optional['outputs.BackendServiceStrongSessionAffinityCookie']]:
        """
        Describes the HTTP cookie used for stateful session affinity. This field is applicable and required if the sessionAffinity is set to STRONG_COOKIE_AFFINITY.
        Structure is documented below.
        """
        return pulumi.get(self, "strong_session_affinity_cookie")

    @_builtins.property
    @pulumi.getter(name="timeoutSec")
    def timeout_sec(self) -> pulumi.Output[_builtins.int]:
        """
        The backend service timeout has a different meaning depending on the type of load balancer.
        For more information see, [Backend service settings](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices).
        The default is 30 seconds.
        The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds.
        """
        return pulumi.get(self, "timeout_sec")

    @_builtins.property
    @pulumi.getter(name="tlsSettings")
    def tls_settings(self) -> pulumi.Output[Optional['outputs.BackendServiceTlsSettings']]:
        """
        Configuration for Backend Authenticated TLS and mTLS. May only be specified when the backend protocol is SSL, HTTPS or HTTP2.
        Structure is documented below.
        """
        return pulumi.get(self, "tls_settings")

