# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetNetworkAttachmentResult',
    'AwaitableGetNetworkAttachmentResult',
    'get_network_attachment',
    'get_network_attachment_output',
]

@pulumi.output_type
class GetNetworkAttachmentResult:
    """
    A collection of values returned by getNetworkAttachment.
    """
    def __init__(__self__, connection_endpoints=None, connection_preference=None, creation_timestamp=None, description=None, fingerprint=None, id=None, kind=None, name=None, network=None, producer_accept_lists=None, producer_reject_lists=None, project=None, region=None, self_link=None, self_link_with_id=None, subnetworks=None):
        if connection_endpoints and not isinstance(connection_endpoints, list):
            raise TypeError("Expected argument 'connection_endpoints' to be a list")
        pulumi.set(__self__, "connection_endpoints", connection_endpoints)
        if connection_preference and not isinstance(connection_preference, str):
            raise TypeError("Expected argument 'connection_preference' to be a str")
        pulumi.set(__self__, "connection_preference", connection_preference)
        if creation_timestamp and not isinstance(creation_timestamp, str):
            raise TypeError("Expected argument 'creation_timestamp' to be a str")
        pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if fingerprint and not isinstance(fingerprint, str):
            raise TypeError("Expected argument 'fingerprint' to be a str")
        pulumi.set(__self__, "fingerprint", fingerprint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network and not isinstance(network, str):
            raise TypeError("Expected argument 'network' to be a str")
        pulumi.set(__self__, "network", network)
        if producer_accept_lists and not isinstance(producer_accept_lists, list):
            raise TypeError("Expected argument 'producer_accept_lists' to be a list")
        pulumi.set(__self__, "producer_accept_lists", producer_accept_lists)
        if producer_reject_lists and not isinstance(producer_reject_lists, list):
            raise TypeError("Expected argument 'producer_reject_lists' to be a list")
        pulumi.set(__self__, "producer_reject_lists", producer_reject_lists)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if self_link and not isinstance(self_link, str):
            raise TypeError("Expected argument 'self_link' to be a str")
        pulumi.set(__self__, "self_link", self_link)
        if self_link_with_id and not isinstance(self_link_with_id, str):
            raise TypeError("Expected argument 'self_link_with_id' to be a str")
        pulumi.set(__self__, "self_link_with_id", self_link_with_id)
        if subnetworks and not isinstance(subnetworks, list):
            raise TypeError("Expected argument 'subnetworks' to be a list")
        pulumi.set(__self__, "subnetworks", subnetworks)

    @_builtins.property
    @pulumi.getter(name="connectionEndpoints")
    def connection_endpoints(self) -> Sequence['outputs.GetNetworkAttachmentConnectionEndpointResult']:
        return pulumi.get(self, "connection_endpoints")

    @_builtins.property
    @pulumi.getter(name="connectionPreference")
    def connection_preference(self) -> _builtins.str:
        return pulumi.get(self, "connection_preference")

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> _builtins.str:
        return pulumi.get(self, "creation_timestamp")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> _builtins.str:
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="producerAcceptLists")
    def producer_accept_lists(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "producer_accept_lists")

    @_builtins.property
    @pulumi.getter(name="producerRejectLists")
    def producer_reject_lists(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "producer_reject_lists")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> _builtins.str:
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter(name="selfLinkWithId")
    def self_link_with_id(self) -> _builtins.str:
        return pulumi.get(self, "self_link_with_id")

    @_builtins.property
    @pulumi.getter
    def subnetworks(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "subnetworks")


class AwaitableGetNetworkAttachmentResult(GetNetworkAttachmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkAttachmentResult(
            connection_endpoints=self.connection_endpoints,
            connection_preference=self.connection_preference,
            creation_timestamp=self.creation_timestamp,
            description=self.description,
            fingerprint=self.fingerprint,
            id=self.id,
            kind=self.kind,
            name=self.name,
            network=self.network,
            producer_accept_lists=self.producer_accept_lists,
            producer_reject_lists=self.producer_reject_lists,
            project=self.project,
            region=self.region,
            self_link=self.self_link,
            self_link_with_id=self.self_link_with_id,
            subnetworks=self.subnetworks)


def get_network_attachment(name: Optional[_builtins.str] = None,
                           project: Optional[_builtins.str] = None,
                           region: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkAttachmentResult:
    """
    Get a specific network attachment within a region. For more information see
    the [official documentation](https://cloud.google.com/vpc/docs/about-network-attachments)
    and [API](https://cloud.google.com/compute/docs/reference/rest/v1/networkAttachments/get).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    default = gcp.compute.get_network_attachment(project="my-project",
        name="my-network-attachment",
        region="europe-west1")
    ```


    :param _builtins.str name: The name of the network attachment to retrieve.
           The name must be unique within the region.
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    :param _builtins.str region: The region in which the network attachment resides.
           For example, `europe-west1`.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:compute/getNetworkAttachment:getNetworkAttachment', __args__, opts=opts, typ=GetNetworkAttachmentResult).value

    return AwaitableGetNetworkAttachmentResult(
        connection_endpoints=pulumi.get(__ret__, 'connection_endpoints'),
        connection_preference=pulumi.get(__ret__, 'connection_preference'),
        creation_timestamp=pulumi.get(__ret__, 'creation_timestamp'),
        description=pulumi.get(__ret__, 'description'),
        fingerprint=pulumi.get(__ret__, 'fingerprint'),
        id=pulumi.get(__ret__, 'id'),
        kind=pulumi.get(__ret__, 'kind'),
        name=pulumi.get(__ret__, 'name'),
        network=pulumi.get(__ret__, 'network'),
        producer_accept_lists=pulumi.get(__ret__, 'producer_accept_lists'),
        producer_reject_lists=pulumi.get(__ret__, 'producer_reject_lists'),
        project=pulumi.get(__ret__, 'project'),
        region=pulumi.get(__ret__, 'region'),
        self_link=pulumi.get(__ret__, 'self_link'),
        self_link_with_id=pulumi.get(__ret__, 'self_link_with_id'),
        subnetworks=pulumi.get(__ret__, 'subnetworks'))
def get_network_attachment_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                  project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  region: Optional[pulumi.Input[_builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkAttachmentResult]:
    """
    Get a specific network attachment within a region. For more information see
    the [official documentation](https://cloud.google.com/vpc/docs/about-network-attachments)
    and [API](https://cloud.google.com/compute/docs/reference/rest/v1/networkAttachments/get).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    default = gcp.compute.get_network_attachment(project="my-project",
        name="my-network-attachment",
        region="europe-west1")
    ```


    :param _builtins.str name: The name of the network attachment to retrieve.
           The name must be unique within the region.
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    :param _builtins.str region: The region in which the network attachment resides.
           For example, `europe-west1`.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:compute/getNetworkAttachment:getNetworkAttachment', __args__, opts=opts, typ=GetNetworkAttachmentResult)
    return __ret__.apply(lambda __response__: GetNetworkAttachmentResult(
        connection_endpoints=pulumi.get(__response__, 'connection_endpoints'),
        connection_preference=pulumi.get(__response__, 'connection_preference'),
        creation_timestamp=pulumi.get(__response__, 'creation_timestamp'),
        description=pulumi.get(__response__, 'description'),
        fingerprint=pulumi.get(__response__, 'fingerprint'),
        id=pulumi.get(__response__, 'id'),
        kind=pulumi.get(__response__, 'kind'),
        name=pulumi.get(__response__, 'name'),
        network=pulumi.get(__response__, 'network'),
        producer_accept_lists=pulumi.get(__response__, 'producer_accept_lists'),
        producer_reject_lists=pulumi.get(__response__, 'producer_reject_lists'),
        project=pulumi.get(__response__, 'project'),
        region=pulumi.get(__response__, 'region'),
        self_link=pulumi.get(__response__, 'self_link'),
        self_link_with_id=pulumi.get(__response__, 'self_link_with_id'),
        subnetworks=pulumi.get(__response__, 'subnetworks')))
