# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GlobalForwardingRuleArgs', 'GlobalForwardingRule']

@pulumi.input_type
class GlobalForwardingRuleArgs:
    def __init__(__self__, *,
                 target: pulumi.Input[_builtins.str],
                 allow_psc_global_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_managed_backend_bucket_migration_state: Optional[pulumi.Input[_builtins.str]] = None,
                 external_managed_backend_bucket_migration_testing_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata_filters: Optional[pulumi.Input[Sequence[pulumi.Input['GlobalForwardingRuleMetadataFilterArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 network_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 no_automate_dns_zone: Optional[pulumi.Input[_builtins.bool]] = None,
                 port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_directory_registrations: Optional[pulumi.Input['GlobalForwardingRuleServiceDirectoryRegistrationsArgs']] = None,
                 source_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subnetwork: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GlobalForwardingRule resource.
        :param pulumi.Input[_builtins.str] target: The URL of the target resource to receive the matched traffic.  For
               regional forwarding rules, this target must be in the same region as the
               forwarding rule. For global forwarding rules, this target must be a global
               load balancing resource.
               The forwarded traffic must be of a type appropriate to the target object.
               *  For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               *  For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle:
               *  `vpc-sc` - [ APIs that support VPC Service Controls](https://cloud.google.com/vpc-service-controls/docs/supported-products).
               *  `all-apis` - [All supported Google APIs](https://cloud.google.com/vpc/docs/private-service-connect#supported-apis).
               For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
        :param pulumi.Input[_builtins.bool] allow_psc_global_access: This is used in PSC consumer ForwardingRule to control whether the PSC endpoint can be accessed from another region.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[_builtins.str] external_managed_backend_bucket_migration_state: Specifies the canary migration state for the backend buckets attached to this forwarding rule.
               Possible values are PREPARE, TEST_BY_PERCENTAGE, and TEST_ALL_TRAFFIC.
               To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to
               PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be
               changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate
               traffic to backend buckets attached to this forwarding rule by percentage using
               externalManagedBackendBucketMigrationTestingPercentage.
               Rolling back a migration requires the states to be set in reverse order. So changing the
               scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at
               the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic
               back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
               Possible values are: `PREPARE`, `TEST_BY_PERCENTAGE`, `TEST_ALL_TRAFFIC`.
        :param pulumi.Input[_builtins.float] external_managed_backend_bucket_migration_testing_percentage: Determines the fraction of requests to backend buckets that should be processed by the Global
               external Application Load Balancer.
               The value of this field must be in the range [0, 100].
               This value can only be set if the loadBalancingScheme in the forwarding rule is set to
               EXTERNAL (when using the Classic ALB) and the migration state is TEST_BY_PERCENTAGE.
        :param pulumi.Input[_builtins.str] ip_address: IP address for which this forwarding rule accepts traffic. When a client
               sends traffic to this IP address, the forwarding rule directs the traffic
               to the referenced `target`.
               While creating a forwarding rule, specifying an `IPAddress` is
               required under the following circumstances:
               * When the `target` is set to `targetGrpcProxy` and
               `validateForProxyless` is set to `true`, the
               `IPAddress` should be set to `0.0.0.0`.
               * When the `target` is a Private Service Connect Google APIs
               bundle, you must specify an `IPAddress`.
               Otherwise, you can optionally specify an IP address that references an
               existing static (reserved) IP address resource. When omitted, Google Cloud
               assigns an ephemeral IP address.
               Use one of the following formats to specify an IP address while creating a
               forwarding rule:
               * IP address number, as in `100.1.2.3`
               * IPv6 address range, as in `2600:1234::/96`
               * Full resource URL, as in
               `https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name`
               * Partial URL or by name, as in:
               * `projects/project_id/regions/region/addresses/address-name`
               * `regions/region/addresses/address-name`
               * `global/addresses/address-name`
               * `address-name`
               The forwarding rule's `target`,
               and in most cases, also the `loadBalancingScheme`, determine the
               type of IP address that you can use. For detailed information, see
               [IP address
               specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               When reading an `IPAddress`, the API always returns the IP
               address number.
        :param pulumi.Input[_builtins.str] ip_protocol: The IP protocol to which this rule applies.
               For protocol forwarding, valid
               options are `TCP`, `UDP`, `ESP`,
               `AH`, `SCTP`, `ICMP` and
               `L3_DEFAULT`.
               The valid IP protocols are different for different load balancing products
               as described in [Load balancing
               features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
               Possible values are: `TCP`, `UDP`, `ESP`, `AH`, `SCTP`, `ICMP`.
        :param pulumi.Input[_builtins.str] ip_version: The IP Version that will be used by this global forwarding rule.
               Possible values are: `IPV4`, `IPV6`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels to apply to this forwarding rule.  A list of key->value pairs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] load_balancing_scheme: Specifies the forwarding rule type.
               For more information about forwarding rules, refer to
               [Forwarding rule concepts](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts).
               Default value is `EXTERNAL`.
               Possible values are: `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL_MANAGED`, `INTERNAL_SELF_MANAGED`.
        :param pulumi.Input[Sequence[pulumi.Input['GlobalForwardingRuleMetadataFilterArgs']]] metadata_filters: Opaque filter criteria used by Loadbalancer to restrict routing
               configuration to a limited set xDS compliant clients. In their xDS
               requests to Loadbalancer, xDS clients present node metadata. If a
               match takes place, the relevant routing configuration is made available
               to those proxies.
               For each metadataFilter in this list, if its filterMatchCriteria is set
               to MATCH_ANY, at least one of the filterLabels must match the
               corresponding label provided in the metadata. If its filterMatchCriteria
               is set to MATCH_ALL, then all of its filterLabels must match with
               corresponding labels in the provided metadata.
               metadataFilters specified here can be overridden by those specified in
               the UrlMap that this ForwardingRule references.
               metadataFilters only applies to Loadbalancers that have their
               loadBalancingScheme set to INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of the resource; provided by the client when the resource is created.
               The name must be 1-63 characters long, and comply with
               [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
               Specifically, the name must be 1-63 characters long and match the regular
               expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must
               be a dash, lowercase letter, or digit, except the last character, which
               cannot be a dash.
               For Private Service Connect forwarding rules that forward traffic to Google
               APIs, the forwarding rule name must be a 1-20 characters string with
               lowercase letters and numbers and must start with a letter.
        :param pulumi.Input[_builtins.str] network: This field is not used for external load balancing.
               For Internal TCP/UDP Load Balancing, this field identifies the network that
               the load balanced IP should belong to for this Forwarding Rule.
               If the subnetwork is specified, the network of the subnetwork will be used.
               If neither subnetwork nor this field is specified, the default network will
               be used.
               For Private Service Connect forwarding rules that forward traffic to Google
               APIs, a network must be provided.
        :param pulumi.Input[_builtins.str] network_tier: This signifies the networking tier used for configuring
               this load balancer and can only take the following values:
               `PREMIUM`, `STANDARD`.
               For regional ForwardingRule, the valid values are `PREMIUM` and
               `STANDARD`. For GlobalForwardingRule, the valid value is
               `PREMIUM`.
               If this field is not specified, it is assumed to be `PREMIUM`.
               If `IPAddress` is specified, this value must be equal to the
               networkTier of the Address.
               Possible values are: `PREMIUM`, `STANDARD`.
        :param pulumi.Input[_builtins.bool] no_automate_dns_zone: This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
        :param pulumi.Input[_builtins.str] port_range: The `portRange` field has the following limitations:
               * It requires that the forwarding rule `IPProtocol` be TCP, UDP, or SCTP,
               and
               * It's applicable only to the following products: external passthrough
               Network Load Balancers, internal and external proxy Network Load
               Balancers, internal and external Application Load Balancers, external
               protocol forwarding, and Classic VPN.
               * Some products have restrictions on what ports can be used. See
               [port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications)
               for details.
               For external forwarding rules, two or more forwarding rules cannot use the
               same `[IPAddress, IPProtocol]` pair, and cannot have overlapping
               `portRange`s.
               For internal forwarding rules within the same VPC network, two or more
               forwarding rules cannot use the same `[IPAddress, IPProtocol]` pair, and
               cannot have overlapping `portRange`s.
               @pattern: \\d+(?:-\\d+)?
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['GlobalForwardingRuleServiceDirectoryRegistrationsArgs'] service_directory_registrations: Service Directory resources to register this forwarding rule with.
               Currently, only supports a single Service Directory resource.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_ip_ranges: If not empty, this Forwarding Rule will only forward the traffic when the source IP address matches one of the IP addresses or CIDR ranges set here. Note that a Forwarding Rule can only have up to 64 source IP ranges, and this field can only be used with a regional Forwarding Rule whose scheme is EXTERNAL. Each sourceIpRange entry should be either an IP address (for example, 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
        :param pulumi.Input[_builtins.str] subnetwork: This field identifies the subnetwork that the load balanced IP should
               belong to for this Forwarding Rule, used in internal load balancing and
               network load balancing with IPv6.
               If the network specified is in auto subnet mode, this field is optional.
               However, a subnetwork must be specified if the network is in custom subnet
               mode or when creating external forwarding rule with IPv6.
        """
        pulumi.set(__self__, "target", target)
        if allow_psc_global_access is not None:
            pulumi.set(__self__, "allow_psc_global_access", allow_psc_global_access)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_managed_backend_bucket_migration_state is not None:
            pulumi.set(__self__, "external_managed_backend_bucket_migration_state", external_managed_backend_bucket_migration_state)
        if external_managed_backend_bucket_migration_testing_percentage is not None:
            pulumi.set(__self__, "external_managed_backend_bucket_migration_testing_percentage", external_managed_backend_bucket_migration_testing_percentage)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_protocol is not None:
            pulumi.set(__self__, "ip_protocol", ip_protocol)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if load_balancing_scheme is not None:
            pulumi.set(__self__, "load_balancing_scheme", load_balancing_scheme)
        if metadata_filters is not None:
            pulumi.set(__self__, "metadata_filters", metadata_filters)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if network_tier is not None:
            pulumi.set(__self__, "network_tier", network_tier)
        if no_automate_dns_zone is not None:
            pulumi.set(__self__, "no_automate_dns_zone", no_automate_dns_zone)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service_directory_registrations is not None:
            pulumi.set(__self__, "service_directory_registrations", service_directory_registrations)
        if source_ip_ranges is not None:
            pulumi.set(__self__, "source_ip_ranges", source_ip_ranges)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)

    @_builtins.property
    @pulumi.getter
    def target(self) -> pulumi.Input[_builtins.str]:
        """
        The URL of the target resource to receive the matched traffic.  For
        regional forwarding rules, this target must be in the same region as the
        forwarding rule. For global forwarding rules, this target must be a global
        load balancing resource.
        The forwarded traffic must be of a type appropriate to the target object.
        *  For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
        *  For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle:
        *  `vpc-sc` - [ APIs that support VPC Service Controls](https://cloud.google.com/vpc-service-controls/docs/supported-products).
        *  `all-apis` - [All supported Google APIs](https://cloud.google.com/vpc/docs/private-service-connect#supported-apis).
        For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target", value)

    @_builtins.property
    @pulumi.getter(name="allowPscGlobalAccess")
    def allow_psc_global_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This is used in PSC consumer ForwardingRule to control whether the PSC endpoint can be accessed from another region.
        """
        return pulumi.get(self, "allow_psc_global_access")

    @allow_psc_global_access.setter
    def allow_psc_global_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_psc_global_access", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="externalManagedBackendBucketMigrationState")
    def external_managed_backend_bucket_migration_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the canary migration state for the backend buckets attached to this forwarding rule.
        Possible values are PREPARE, TEST_BY_PERCENTAGE, and TEST_ALL_TRAFFIC.
        To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to
        PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be
        changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate
        traffic to backend buckets attached to this forwarding rule by percentage using
        externalManagedBackendBucketMigrationTestingPercentage.
        Rolling back a migration requires the states to be set in reverse order. So changing the
        scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at
        the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic
        back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
        Possible values are: `PREPARE`, `TEST_BY_PERCENTAGE`, `TEST_ALL_TRAFFIC`.
        """
        return pulumi.get(self, "external_managed_backend_bucket_migration_state")

    @external_managed_backend_bucket_migration_state.setter
    def external_managed_backend_bucket_migration_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_managed_backend_bucket_migration_state", value)

    @_builtins.property
    @pulumi.getter(name="externalManagedBackendBucketMigrationTestingPercentage")
    def external_managed_backend_bucket_migration_testing_percentage(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Determines the fraction of requests to backend buckets that should be processed by the Global
        external Application Load Balancer.
        The value of this field must be in the range [0, 100].
        This value can only be set if the loadBalancingScheme in the forwarding rule is set to
        EXTERNAL (when using the Classic ALB) and the migration state is TEST_BY_PERCENTAGE.
        """
        return pulumi.get(self, "external_managed_backend_bucket_migration_testing_percentage")

    @external_managed_backend_bucket_migration_testing_percentage.setter
    def external_managed_backend_bucket_migration_testing_percentage(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "external_managed_backend_bucket_migration_testing_percentage", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP address for which this forwarding rule accepts traffic. When a client
        sends traffic to this IP address, the forwarding rule directs the traffic
        to the referenced `target`.
        While creating a forwarding rule, specifying an `IPAddress` is
        required under the following circumstances:
        * When the `target` is set to `targetGrpcProxy` and
        `validateForProxyless` is set to `true`, the
        `IPAddress` should be set to `0.0.0.0`.
        * When the `target` is a Private Service Connect Google APIs
        bundle, you must specify an `IPAddress`.
        Otherwise, you can optionally specify an IP address that references an
        existing static (reserved) IP address resource. When omitted, Google Cloud
        assigns an ephemeral IP address.
        Use one of the following formats to specify an IP address while creating a
        forwarding rule:
        * IP address number, as in `100.1.2.3`
        * IPv6 address range, as in `2600:1234::/96`
        * Full resource URL, as in
        `https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name`
        * Partial URL or by name, as in:
        * `projects/project_id/regions/region/addresses/address-name`
        * `regions/region/addresses/address-name`
        * `global/addresses/address-name`
        * `address-name`
        The forwarding rule's `target`,
        and in most cases, also the `loadBalancingScheme`, determine the
        type of IP address that you can use. For detailed information, see
        [IP address
        specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
        When reading an `IPAddress`, the API always returns the IP
        address number.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP protocol to which this rule applies.
        For protocol forwarding, valid
        options are `TCP`, `UDP`, `ESP`,
        `AH`, `SCTP`, `ICMP` and
        `L3_DEFAULT`.
        The valid IP protocols are different for different load balancing products
        as described in [Load balancing
        features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
        Possible values are: `TCP`, `UDP`, `ESP`, `AH`, `SCTP`, `ICMP`.
        """
        return pulumi.get(self, "ip_protocol")

    @ip_protocol.setter
    def ip_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_protocol", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP Version that will be used by this global forwarding rule.
        Possible values are: `IPV4`, `IPV6`.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels to apply to this forwarding rule.  A list of key->value pairs.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the forwarding rule type.
        For more information about forwarding rules, refer to
        [Forwarding rule concepts](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts).
        Default value is `EXTERNAL`.
        Possible values are: `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL_MANAGED`, `INTERNAL_SELF_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @load_balancing_scheme.setter
    def load_balancing_scheme(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancing_scheme", value)

    @_builtins.property
    @pulumi.getter(name="metadataFilters")
    def metadata_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GlobalForwardingRuleMetadataFilterArgs']]]]:
        """
        Opaque filter criteria used by Loadbalancer to restrict routing
        configuration to a limited set xDS compliant clients. In their xDS
        requests to Loadbalancer, xDS clients present node metadata. If a
        match takes place, the relevant routing configuration is made available
        to those proxies.
        For each metadataFilter in this list, if its filterMatchCriteria is set
        to MATCH_ANY, at least one of the filterLabels must match the
        corresponding label provided in the metadata. If its filterMatchCriteria
        is set to MATCH_ALL, then all of its filterLabels must match with
        corresponding labels in the provided metadata.
        metadataFilters specified here can be overridden by those specified in
        the UrlMap that this ForwardingRule references.
        metadataFilters only applies to Loadbalancers that have their
        loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata_filters")

    @metadata_filters.setter
    def metadata_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GlobalForwardingRuleMetadataFilterArgs']]]]):
        pulumi.set(self, "metadata_filters", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource; provided by the client when the resource is created.
        The name must be 1-63 characters long, and comply with
        [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
        Specifically, the name must be 1-63 characters long and match the regular
        expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters must
        be a dash, lowercase letter, or digit, except the last character, which
        cannot be a dash.
        For Private Service Connect forwarding rules that forward traffic to Google
        APIs, the forwarding rule name must be a 1-20 characters string with
        lowercase letters and numbers and must start with a letter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This field is not used for external load balancing.
        For Internal TCP/UDP Load Balancing, this field identifies the network that
        the load balanced IP should belong to for this Forwarding Rule.
        If the subnetwork is specified, the network of the subnetwork will be used.
        If neither subnetwork nor this field is specified, the default network will
        be used.
        For Private Service Connect forwarding rules that forward traffic to Google
        APIs, a network must be provided.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="networkTier")
    def network_tier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This signifies the networking tier used for configuring
        this load balancer and can only take the following values:
        `PREMIUM`, `STANDARD`.
        For regional ForwardingRule, the valid values are `PREMIUM` and
        `STANDARD`. For GlobalForwardingRule, the valid value is
        `PREMIUM`.
        If this field is not specified, it is assumed to be `PREMIUM`.
        If `IPAddress` is specified, this value must be equal to the
        networkTier of the Address.
        Possible values are: `PREMIUM`, `STANDARD`.
        """
        return pulumi.get(self, "network_tier")

    @network_tier.setter
    def network_tier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_tier", value)

    @_builtins.property
    @pulumi.getter(name="noAutomateDnsZone")
    def no_automate_dns_zone(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
        """
        return pulumi.get(self, "no_automate_dns_zone")

    @no_automate_dns_zone.setter
    def no_automate_dns_zone(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no_automate_dns_zone", value)

    @_builtins.property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `portRange` field has the following limitations:
        * It requires that the forwarding rule `IPProtocol` be TCP, UDP, or SCTP,
        and
        * It's applicable only to the following products: external passthrough
        Network Load Balancers, internal and external proxy Network Load
        Balancers, internal and external Application Load Balancers, external
        protocol forwarding, and Classic VPN.
        * Some products have restrictions on what ports can be used. See
        [port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications)
        for details.
        For external forwarding rules, two or more forwarding rules cannot use the
        same `[IPAddress, IPProtocol]` pair, and cannot have overlapping
        `portRange`s.
        For internal forwarding rules within the same VPC network, two or more
        forwarding rules cannot use the same `[IPAddress, IPProtocol]` pair, and
        cannot have overlapping `portRange`s.
        @pattern: \\d+(?:-\\d+)?
        """
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port_range", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="serviceDirectoryRegistrations")
    def service_directory_registrations(self) -> Optional[pulumi.Input['GlobalForwardingRuleServiceDirectoryRegistrationsArgs']]:
        """
        Service Directory resources to register this forwarding rule with.
        Currently, only supports a single Service Directory resource.
        Structure is documented below.
        """
        return pulumi.get(self, "service_directory_registrations")

    @service_directory_registrations.setter
    def service_directory_registrations(self, value: Optional[pulumi.Input['GlobalForwardingRuleServiceDirectoryRegistrationsArgs']]):
        pulumi.set(self, "service_directory_registrations", value)

    @_builtins.property
    @pulumi.getter(name="sourceIpRanges")
    def source_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        If not empty, this Forwarding Rule will only forward the traffic when the source IP address matches one of the IP addresses or CIDR ranges set here. Note that a Forwarding Rule can only have up to 64 source IP ranges, and this field can only be used with a regional Forwarding Rule whose scheme is EXTERNAL. Each sourceIpRange entry should be either an IP address (for example, 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
        """
        return pulumi.get(self, "source_ip_ranges")

    @source_ip_ranges.setter
    def source_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "source_ip_ranges", value)

    @_builtins.property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This field identifies the subnetwork that the load balanced IP should
        belong to for this Forwarding Rule, used in internal load balancing and
        network load balancing with IPv6.
        If the network specified is in auto subnet mode, this field is optional.
        However, a subnetwork must be specified if the network is in custom subnet
        mode or when creating external forwarding rule with IPv6.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnetwork", value)


@pulumi.input_type
class _GlobalForwardingRuleState:
    def __init__(__self__, *,
                 allow_psc_global_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 base_forwarding_rule: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 external_managed_backend_bucket_migration_state: Optional[pulumi.Input[_builtins.str]] = None,
                 external_managed_backend_bucket_migration_testing_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 forwarding_rule_id: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 label_fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata_filters: Optional[pulumi.Input[Sequence[pulumi.Input['GlobalForwardingRuleMetadataFilterArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 network_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 no_automate_dns_zone: Optional[pulumi.Input[_builtins.bool]] = None,
                 port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 psc_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 psc_connection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 self_link: Optional[pulumi.Input[_builtins.str]] = None,
                 service_directory_registrations: Optional[pulumi.Input['GlobalForwardingRuleServiceDirectoryRegistrationsArgs']] = None,
                 source_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subnetwork: Optional[pulumi.Input[_builtins.str]] = None,
                 target: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GlobalForwardingRule resources.
        :param pulumi.Input[_builtins.bool] allow_psc_global_access: This is used in PSC consumer ForwardingRule to control whether the PSC endpoint can be accessed from another region.
        :param pulumi.Input[_builtins.str] base_forwarding_rule: [Output Only] The URL for the corresponding base Forwarding Rule. By base Forwarding Rule, we mean the Forwarding Rule that has the same IP address, protocol, and port settings with the current Forwarding Rule, but without sourceIPRanges specified. Always empty if the current Forwarding Rule does not have sourceIPRanges specified.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] external_managed_backend_bucket_migration_state: Specifies the canary migration state for the backend buckets attached to this forwarding rule.
               Possible values are PREPARE, TEST_BY_PERCENTAGE, and TEST_ALL_TRAFFIC.
               To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to
               PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be
               changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate
               traffic to backend buckets attached to this forwarding rule by percentage using
               externalManagedBackendBucketMigrationTestingPercentage.
               Rolling back a migration requires the states to be set in reverse order. So changing the
               scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at
               the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic
               back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
               Possible values are: `PREPARE`, `TEST_BY_PERCENTAGE`, `TEST_ALL_TRAFFIC`.
        :param pulumi.Input[_builtins.float] external_managed_backend_bucket_migration_testing_percentage: Determines the fraction of requests to backend buckets that should be processed by the Global
               external Application Load Balancer.
               The value of this field must be in the range [0, 100].
               This value can only be set if the loadBalancingScheme in the forwarding rule is set to
               EXTERNAL (when using the Classic ALB) and the migration state is TEST_BY_PERCENTAGE.
        :param pulumi.Input[_builtins.int] forwarding_rule_id: The unique identifier number for the resource. This identifier is defined by the server.
        :param pulumi.Input[_builtins.str] ip_address: IP address for which this forwarding rule accepts traffic. When a client
               sends traffic to this IP address, the forwarding rule directs the traffic
               to the referenced `target`.
               While creating a forwarding rule, specifying an `IPAddress` is
               required under the following circumstances:
               * When the `target` is set to `targetGrpcProxy` and
               `validateForProxyless` is set to `true`, the
               `IPAddress` should be set to `0.0.0.0`.
               * When the `target` is a Private Service Connect Google APIs
               bundle, you must specify an `IPAddress`.
               Otherwise, you can optionally specify an IP address that references an
               existing static (reserved) IP address resource. When omitted, Google Cloud
               assigns an ephemeral IP address.
               Use one of the following formats to specify an IP address while creating a
               forwarding rule:
               * IP address number, as in `100.1.2.3`
               * IPv6 address range, as in `2600:1234::/96`
               * Full resource URL, as in
               `https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name`
               * Partial URL or by name, as in:
               * `projects/project_id/regions/region/addresses/address-name`
               * `regions/region/addresses/address-name`
               * `global/addresses/address-name`
               * `address-name`
               The forwarding rule's `target`,
               and in most cases, also the `loadBalancingScheme`, determine the
               type of IP address that you can use. For detailed information, see
               [IP address
               specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               When reading an `IPAddress`, the API always returns the IP
               address number.
        :param pulumi.Input[_builtins.str] ip_protocol: The IP protocol to which this rule applies.
               For protocol forwarding, valid
               options are `TCP`, `UDP`, `ESP`,
               `AH`, `SCTP`, `ICMP` and
               `L3_DEFAULT`.
               The valid IP protocols are different for different load balancing products
               as described in [Load balancing
               features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
               Possible values are: `TCP`, `UDP`, `ESP`, `AH`, `SCTP`, `ICMP`.
        :param pulumi.Input[_builtins.str] ip_version: The IP Version that will be used by this global forwarding rule.
               Possible values are: `IPV4`, `IPV6`.
        :param pulumi.Input[_builtins.str] label_fingerprint: The fingerprint used for optimistic locking of this resource.  Used
               internally during updates.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels to apply to this forwarding rule.  A list of key->value pairs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] load_balancing_scheme: Specifies the forwarding rule type.
               For more information about forwarding rules, refer to
               [Forwarding rule concepts](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts).
               Default value is `EXTERNAL`.
               Possible values are: `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL_MANAGED`, `INTERNAL_SELF_MANAGED`.
        :param pulumi.Input[Sequence[pulumi.Input['GlobalForwardingRuleMetadataFilterArgs']]] metadata_filters: Opaque filter criteria used by Loadbalancer to restrict routing
               configuration to a limited set xDS compliant clients. In their xDS
               requests to Loadbalancer, xDS clients present node metadata. If a
               match takes place, the relevant routing configuration is made available
               to those proxies.
               For each metadataFilter in this list, if its filterMatchCriteria is set
               to MATCH_ANY, at least one of the filterLabels must match the
               corresponding label provided in the metadata. If its filterMatchCriteria
               is set to MATCH_ALL, then all of its filterLabels must match with
               corresponding labels in the provided metadata.
               metadataFilters specified here can be overridden by those specified in
               the UrlMap that this ForwardingRule references.
               metadataFilters only applies to Loadbalancers that have their
               loadBalancingScheme set to INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of the resource; provided by the client when the resource is created.
               The name must be 1-63 characters long, and comply with
               [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
               Specifically, the name must be 1-63 characters long and match the regular
               expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must
               be a dash, lowercase letter, or digit, except the last character, which
               cannot be a dash.
               For Private Service Connect forwarding rules that forward traffic to Google
               APIs, the forwarding rule name must be a 1-20 characters string with
               lowercase letters and numbers and must start with a letter.
        :param pulumi.Input[_builtins.str] network: This field is not used for external load balancing.
               For Internal TCP/UDP Load Balancing, this field identifies the network that
               the load balanced IP should belong to for this Forwarding Rule.
               If the subnetwork is specified, the network of the subnetwork will be used.
               If neither subnetwork nor this field is specified, the default network will
               be used.
               For Private Service Connect forwarding rules that forward traffic to Google
               APIs, a network must be provided.
        :param pulumi.Input[_builtins.str] network_tier: This signifies the networking tier used for configuring
               this load balancer and can only take the following values:
               `PREMIUM`, `STANDARD`.
               For regional ForwardingRule, the valid values are `PREMIUM` and
               `STANDARD`. For GlobalForwardingRule, the valid value is
               `PREMIUM`.
               If this field is not specified, it is assumed to be `PREMIUM`.
               If `IPAddress` is specified, this value must be equal to the
               networkTier of the Address.
               Possible values are: `PREMIUM`, `STANDARD`.
        :param pulumi.Input[_builtins.bool] no_automate_dns_zone: This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
        :param pulumi.Input[_builtins.str] port_range: The `portRange` field has the following limitations:
               * It requires that the forwarding rule `IPProtocol` be TCP, UDP, or SCTP,
               and
               * It's applicable only to the following products: external passthrough
               Network Load Balancers, internal and external proxy Network Load
               Balancers, internal and external Application Load Balancers, external
               protocol forwarding, and Classic VPN.
               * Some products have restrictions on what ports can be used. See
               [port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications)
               for details.
               For external forwarding rules, two or more forwarding rules cannot use the
               same `[IPAddress, IPProtocol]` pair, and cannot have overlapping
               `portRange`s.
               For internal forwarding rules within the same VPC network, two or more
               forwarding rules cannot use the same `[IPAddress, IPProtocol]` pair, and
               cannot have overlapping `portRange`s.
               @pattern: \\d+(?:-\\d+)?
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] psc_connection_id: The PSC connection id of the PSC Forwarding Rule.
        :param pulumi.Input[_builtins.str] psc_connection_status: The PSC connection status of the PSC Forwarding Rule. Possible values: `STATUS_UNSPECIFIED`, `PENDING`, `ACCEPTED`, `REJECTED`, `CLOSED`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input['GlobalForwardingRuleServiceDirectoryRegistrationsArgs'] service_directory_registrations: Service Directory resources to register this forwarding rule with.
               Currently, only supports a single Service Directory resource.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_ip_ranges: If not empty, this Forwarding Rule will only forward the traffic when the source IP address matches one of the IP addresses or CIDR ranges set here. Note that a Forwarding Rule can only have up to 64 source IP ranges, and this field can only be used with a regional Forwarding Rule whose scheme is EXTERNAL. Each sourceIpRange entry should be either an IP address (for example, 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
        :param pulumi.Input[_builtins.str] subnetwork: This field identifies the subnetwork that the load balanced IP should
               belong to for this Forwarding Rule, used in internal load balancing and
               network load balancing with IPv6.
               If the network specified is in auto subnet mode, this field is optional.
               However, a subnetwork must be specified if the network is in custom subnet
               mode or when creating external forwarding rule with IPv6.
        :param pulumi.Input[_builtins.str] target: The URL of the target resource to receive the matched traffic.  For
               regional forwarding rules, this target must be in the same region as the
               forwarding rule. For global forwarding rules, this target must be a global
               load balancing resource.
               The forwarded traffic must be of a type appropriate to the target object.
               *  For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               *  For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle:
               *  `vpc-sc` - [ APIs that support VPC Service Controls](https://cloud.google.com/vpc-service-controls/docs/supported-products).
               *  `all-apis` - [All supported Google APIs](https://cloud.google.com/vpc/docs/private-service-connect#supported-apis).
               For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
        """
        if allow_psc_global_access is not None:
            pulumi.set(__self__, "allow_psc_global_access", allow_psc_global_access)
        if base_forwarding_rule is not None:
            pulumi.set(__self__, "base_forwarding_rule", base_forwarding_rule)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if external_managed_backend_bucket_migration_state is not None:
            pulumi.set(__self__, "external_managed_backend_bucket_migration_state", external_managed_backend_bucket_migration_state)
        if external_managed_backend_bucket_migration_testing_percentage is not None:
            pulumi.set(__self__, "external_managed_backend_bucket_migration_testing_percentage", external_managed_backend_bucket_migration_testing_percentage)
        if forwarding_rule_id is not None:
            pulumi.set(__self__, "forwarding_rule_id", forwarding_rule_id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_protocol is not None:
            pulumi.set(__self__, "ip_protocol", ip_protocol)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if label_fingerprint is not None:
            pulumi.set(__self__, "label_fingerprint", label_fingerprint)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if load_balancing_scheme is not None:
            pulumi.set(__self__, "load_balancing_scheme", load_balancing_scheme)
        if metadata_filters is not None:
            pulumi.set(__self__, "metadata_filters", metadata_filters)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if network_tier is not None:
            pulumi.set(__self__, "network_tier", network_tier)
        if no_automate_dns_zone is not None:
            pulumi.set(__self__, "no_automate_dns_zone", no_automate_dns_zone)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if psc_connection_id is not None:
            pulumi.set(__self__, "psc_connection_id", psc_connection_id)
        if psc_connection_status is not None:
            pulumi.set(__self__, "psc_connection_status", psc_connection_status)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if service_directory_registrations is not None:
            pulumi.set(__self__, "service_directory_registrations", service_directory_registrations)
        if source_ip_ranges is not None:
            pulumi.set(__self__, "source_ip_ranges", source_ip_ranges)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @_builtins.property
    @pulumi.getter(name="allowPscGlobalAccess")
    def allow_psc_global_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This is used in PSC consumer ForwardingRule to control whether the PSC endpoint can be accessed from another region.
        """
        return pulumi.get(self, "allow_psc_global_access")

    @allow_psc_global_access.setter
    def allow_psc_global_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_psc_global_access", value)

    @_builtins.property
    @pulumi.getter(name="baseForwardingRule")
    def base_forwarding_rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Output Only] The URL for the corresponding base Forwarding Rule. By base Forwarding Rule, we mean the Forwarding Rule that has the same IP address, protocol, and port settings with the current Forwarding Rule, but without sourceIPRanges specified. Always empty if the current Forwarding Rule does not have sourceIPRanges specified.
        """
        return pulumi.get(self, "base_forwarding_rule")

    @base_forwarding_rule.setter
    def base_forwarding_rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "base_forwarding_rule", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="externalManagedBackendBucketMigrationState")
    def external_managed_backend_bucket_migration_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the canary migration state for the backend buckets attached to this forwarding rule.
        Possible values are PREPARE, TEST_BY_PERCENTAGE, and TEST_ALL_TRAFFIC.
        To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to
        PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be
        changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate
        traffic to backend buckets attached to this forwarding rule by percentage using
        externalManagedBackendBucketMigrationTestingPercentage.
        Rolling back a migration requires the states to be set in reverse order. So changing the
        scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at
        the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic
        back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
        Possible values are: `PREPARE`, `TEST_BY_PERCENTAGE`, `TEST_ALL_TRAFFIC`.
        """
        return pulumi.get(self, "external_managed_backend_bucket_migration_state")

    @external_managed_backend_bucket_migration_state.setter
    def external_managed_backend_bucket_migration_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_managed_backend_bucket_migration_state", value)

    @_builtins.property
    @pulumi.getter(name="externalManagedBackendBucketMigrationTestingPercentage")
    def external_managed_backend_bucket_migration_testing_percentage(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Determines the fraction of requests to backend buckets that should be processed by the Global
        external Application Load Balancer.
        The value of this field must be in the range [0, 100].
        This value can only be set if the loadBalancingScheme in the forwarding rule is set to
        EXTERNAL (when using the Classic ALB) and the migration state is TEST_BY_PERCENTAGE.
        """
        return pulumi.get(self, "external_managed_backend_bucket_migration_testing_percentage")

    @external_managed_backend_bucket_migration_testing_percentage.setter
    def external_managed_backend_bucket_migration_testing_percentage(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "external_managed_backend_bucket_migration_testing_percentage", value)

    @_builtins.property
    @pulumi.getter(name="forwardingRuleId")
    def forwarding_rule_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The unique identifier number for the resource. This identifier is defined by the server.
        """
        return pulumi.get(self, "forwarding_rule_id")

    @forwarding_rule_id.setter
    def forwarding_rule_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "forwarding_rule_id", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP address for which this forwarding rule accepts traffic. When a client
        sends traffic to this IP address, the forwarding rule directs the traffic
        to the referenced `target`.
        While creating a forwarding rule, specifying an `IPAddress` is
        required under the following circumstances:
        * When the `target` is set to `targetGrpcProxy` and
        `validateForProxyless` is set to `true`, the
        `IPAddress` should be set to `0.0.0.0`.
        * When the `target` is a Private Service Connect Google APIs
        bundle, you must specify an `IPAddress`.
        Otherwise, you can optionally specify an IP address that references an
        existing static (reserved) IP address resource. When omitted, Google Cloud
        assigns an ephemeral IP address.
        Use one of the following formats to specify an IP address while creating a
        forwarding rule:
        * IP address number, as in `100.1.2.3`
        * IPv6 address range, as in `2600:1234::/96`
        * Full resource URL, as in
        `https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name`
        * Partial URL or by name, as in:
        * `projects/project_id/regions/region/addresses/address-name`
        * `regions/region/addresses/address-name`
        * `global/addresses/address-name`
        * `address-name`
        The forwarding rule's `target`,
        and in most cases, also the `loadBalancingScheme`, determine the
        type of IP address that you can use. For detailed information, see
        [IP address
        specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
        When reading an `IPAddress`, the API always returns the IP
        address number.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP protocol to which this rule applies.
        For protocol forwarding, valid
        options are `TCP`, `UDP`, `ESP`,
        `AH`, `SCTP`, `ICMP` and
        `L3_DEFAULT`.
        The valid IP protocols are different for different load balancing products
        as described in [Load balancing
        features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
        Possible values are: `TCP`, `UDP`, `ESP`, `AH`, `SCTP`, `ICMP`.
        """
        return pulumi.get(self, "ip_protocol")

    @ip_protocol.setter
    def ip_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_protocol", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP Version that will be used by this global forwarding rule.
        Possible values are: `IPV4`, `IPV6`.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fingerprint used for optimistic locking of this resource.  Used
        internally during updates.
        """
        return pulumi.get(self, "label_fingerprint")

    @label_fingerprint.setter
    def label_fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label_fingerprint", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels to apply to this forwarding rule.  A list of key->value pairs.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the forwarding rule type.
        For more information about forwarding rules, refer to
        [Forwarding rule concepts](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts).
        Default value is `EXTERNAL`.
        Possible values are: `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL_MANAGED`, `INTERNAL_SELF_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @load_balancing_scheme.setter
    def load_balancing_scheme(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancing_scheme", value)

    @_builtins.property
    @pulumi.getter(name="metadataFilters")
    def metadata_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GlobalForwardingRuleMetadataFilterArgs']]]]:
        """
        Opaque filter criteria used by Loadbalancer to restrict routing
        configuration to a limited set xDS compliant clients. In their xDS
        requests to Loadbalancer, xDS clients present node metadata. If a
        match takes place, the relevant routing configuration is made available
        to those proxies.
        For each metadataFilter in this list, if its filterMatchCriteria is set
        to MATCH_ANY, at least one of the filterLabels must match the
        corresponding label provided in the metadata. If its filterMatchCriteria
        is set to MATCH_ALL, then all of its filterLabels must match with
        corresponding labels in the provided metadata.
        metadataFilters specified here can be overridden by those specified in
        the UrlMap that this ForwardingRule references.
        metadataFilters only applies to Loadbalancers that have their
        loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata_filters")

    @metadata_filters.setter
    def metadata_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GlobalForwardingRuleMetadataFilterArgs']]]]):
        pulumi.set(self, "metadata_filters", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource; provided by the client when the resource is created.
        The name must be 1-63 characters long, and comply with
        [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
        Specifically, the name must be 1-63 characters long and match the regular
        expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters must
        be a dash, lowercase letter, or digit, except the last character, which
        cannot be a dash.
        For Private Service Connect forwarding rules that forward traffic to Google
        APIs, the forwarding rule name must be a 1-20 characters string with
        lowercase letters and numbers and must start with a letter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This field is not used for external load balancing.
        For Internal TCP/UDP Load Balancing, this field identifies the network that
        the load balanced IP should belong to for this Forwarding Rule.
        If the subnetwork is specified, the network of the subnetwork will be used.
        If neither subnetwork nor this field is specified, the default network will
        be used.
        For Private Service Connect forwarding rules that forward traffic to Google
        APIs, a network must be provided.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="networkTier")
    def network_tier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This signifies the networking tier used for configuring
        this load balancer and can only take the following values:
        `PREMIUM`, `STANDARD`.
        For regional ForwardingRule, the valid values are `PREMIUM` and
        `STANDARD`. For GlobalForwardingRule, the valid value is
        `PREMIUM`.
        If this field is not specified, it is assumed to be `PREMIUM`.
        If `IPAddress` is specified, this value must be equal to the
        networkTier of the Address.
        Possible values are: `PREMIUM`, `STANDARD`.
        """
        return pulumi.get(self, "network_tier")

    @network_tier.setter
    def network_tier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_tier", value)

    @_builtins.property
    @pulumi.getter(name="noAutomateDnsZone")
    def no_automate_dns_zone(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
        """
        return pulumi.get(self, "no_automate_dns_zone")

    @no_automate_dns_zone.setter
    def no_automate_dns_zone(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no_automate_dns_zone", value)

    @_builtins.property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `portRange` field has the following limitations:
        * It requires that the forwarding rule `IPProtocol` be TCP, UDP, or SCTP,
        and
        * It's applicable only to the following products: external passthrough
        Network Load Balancers, internal and external proxy Network Load
        Balancers, internal and external Application Load Balancers, external
        protocol forwarding, and Classic VPN.
        * Some products have restrictions on what ports can be used. See
        [port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications)
        for details.
        For external forwarding rules, two or more forwarding rules cannot use the
        same `[IPAddress, IPProtocol]` pair, and cannot have overlapping
        `portRange`s.
        For internal forwarding rules within the same VPC network, two or more
        forwarding rules cannot use the same `[IPAddress, IPProtocol]` pair, and
        cannot have overlapping `portRange`s.
        @pattern: \\d+(?:-\\d+)?
        """
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port_range", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pscConnectionId")
    def psc_connection_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The PSC connection id of the PSC Forwarding Rule.
        """
        return pulumi.get(self, "psc_connection_id")

    @psc_connection_id.setter
    def psc_connection_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "psc_connection_id", value)

    @_builtins.property
    @pulumi.getter(name="pscConnectionStatus")
    def psc_connection_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The PSC connection status of the PSC Forwarding Rule. Possible values: `STATUS_UNSPECIFIED`, `PENDING`, `ACCEPTED`, `REJECTED`, `CLOSED`
        """
        return pulumi.get(self, "psc_connection_status")

    @psc_connection_status.setter
    def psc_connection_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "psc_connection_status", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link", value)

    @_builtins.property
    @pulumi.getter(name="serviceDirectoryRegistrations")
    def service_directory_registrations(self) -> Optional[pulumi.Input['GlobalForwardingRuleServiceDirectoryRegistrationsArgs']]:
        """
        Service Directory resources to register this forwarding rule with.
        Currently, only supports a single Service Directory resource.
        Structure is documented below.
        """
        return pulumi.get(self, "service_directory_registrations")

    @service_directory_registrations.setter
    def service_directory_registrations(self, value: Optional[pulumi.Input['GlobalForwardingRuleServiceDirectoryRegistrationsArgs']]):
        pulumi.set(self, "service_directory_registrations", value)

    @_builtins.property
    @pulumi.getter(name="sourceIpRanges")
    def source_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        If not empty, this Forwarding Rule will only forward the traffic when the source IP address matches one of the IP addresses or CIDR ranges set here. Note that a Forwarding Rule can only have up to 64 source IP ranges, and this field can only be used with a regional Forwarding Rule whose scheme is EXTERNAL. Each sourceIpRange entry should be either an IP address (for example, 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
        """
        return pulumi.get(self, "source_ip_ranges")

    @source_ip_ranges.setter
    def source_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "source_ip_ranges", value)

    @_builtins.property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This field identifies the subnetwork that the load balanced IP should
        belong to for this Forwarding Rule, used in internal load balancing and
        network load balancing with IPv6.
        If the network specified is in auto subnet mode, this field is optional.
        However, a subnetwork must be specified if the network is in custom subnet
        mode or when creating external forwarding rule with IPv6.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnetwork", value)

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the target resource to receive the matched traffic.  For
        regional forwarding rules, this target must be in the same region as the
        forwarding rule. For global forwarding rules, this target must be a global
        load balancing resource.
        The forwarded traffic must be of a type appropriate to the target object.
        *  For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
        *  For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle:
        *  `vpc-sc` - [ APIs that support VPC Service Controls](https://cloud.google.com/vpc-service-controls/docs/supported-products).
        *  `all-apis` - [All supported Google APIs](https://cloud.google.com/vpc/docs/private-service-connect#supported-apis).
        For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target", value)


@pulumi.type_token("gcp:compute/globalForwardingRule:GlobalForwardingRule")
class GlobalForwardingRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_psc_global_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_managed_backend_bucket_migration_state: Optional[pulumi.Input[_builtins.str]] = None,
                 external_managed_backend_bucket_migration_testing_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GlobalForwardingRuleMetadataFilterArgs', 'GlobalForwardingRuleMetadataFilterArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 network_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 no_automate_dns_zone: Optional[pulumi.Input[_builtins.bool]] = None,
                 port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_directory_registrations: Optional[pulumi.Input[Union['GlobalForwardingRuleServiceDirectoryRegistrationsArgs', 'GlobalForwardingRuleServiceDirectoryRegistrationsArgsDict']]] = None,
                 source_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subnetwork: Optional[pulumi.Input[_builtins.str]] = None,
                 target: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Represents a GlobalForwardingRule resource. Global forwarding rules are
        used to forward traffic to the correct load balancer for HTTP load
        balancing. Global forwarding rules can only be used for HTTP load
        balancing.

        For more information, see https://cloud.google.com/compute/docs/load-balancing/http/

        ## Example Usage

        ### Global Forwarding Rule Http

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_http_health_check = gcp.compute.HttpHealthCheck("default",
            name="check-backend",
            request_path="/",
            check_interval_sec=1,
            timeout_sec=1)
        default_backend_service = gcp.compute.BackendService("default",
            name="backend",
            port_name="http",
            protocol="HTTP",
            timeout_sec=10,
            health_checks=default_http_health_check.id)
        default_url_map = gcp.compute.URLMap("default",
            name="url-map-target-proxy",
            description="a description",
            default_service=default_backend_service.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": default_backend_service.id,
                "path_rules": [{
                    "paths": ["/*"],
                    "service": default_backend_service.id,
                }],
            }])
        default_target_http_proxy = gcp.compute.TargetHttpProxy("default",
            name="target-proxy",
            description="a description",
            url_map=default_url_map.id)
        default = gcp.compute.GlobalForwardingRule("default",
            name="global-rule",
            target=default_target_http_proxy.id,
            port_range="80")
        ```
        ### Global Forwarding Rule Internal

        ```python
        import pulumi
        import pulumi_gcp as gcp

        debian_image = gcp.compute.get_image(family="debian-11",
            project="debian-cloud")
        instance_template = gcp.compute.InstanceTemplate("instance_template",
            name="template-backend",
            machine_type="e2-medium",
            network_interfaces=[{
                "network": "default",
            }],
            disks=[{
                "source_image": debian_image.self_link,
                "auto_delete": True,
                "boot": True,
            }])
        igm = gcp.compute.InstanceGroupManager("igm",
            name="igm-internal",
            versions=[{
                "instance_template": instance_template.id,
                "name": "primary",
            }],
            base_instance_name="internal-glb",
            zone="us-central1-f",
            target_size=1)
        default_health_check = gcp.compute.HealthCheck("default",
            name="check-backend",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        default_backend_service = gcp.compute.BackendService("default",
            name="backend",
            port_name="http",
            protocol="HTTP",
            timeout_sec=10,
            load_balancing_scheme="INTERNAL_SELF_MANAGED",
            backends=[{
                "group": igm.instance_group,
                "balancing_mode": "RATE",
                "capacity_scaler": 0.4,
                "max_rate_per_instance": 50,
            }],
            health_checks=default_health_check.id)
        default_url_map = gcp.compute.URLMap("default",
            name="url-map-target-proxy",
            description="a description",
            default_service=default_backend_service.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": default_backend_service.id,
                "path_rules": [{
                    "paths": ["/*"],
                    "service": default_backend_service.id,
                }],
            }])
        default_target_http_proxy = gcp.compute.TargetHttpProxy("default",
            name="target-proxy",
            description="a description",
            url_map=default_url_map.id)
        default = gcp.compute.GlobalForwardingRule("default",
            name="global-rule",
            target=default_target_http_proxy.id,
            port_range="80",
            load_balancing_scheme="INTERNAL_SELF_MANAGED",
            ip_address="0.0.0.0",
            metadata_filters=[{
                "filter_match_criteria": "MATCH_ANY",
                "filter_labels": [{
                    "name": "PLANET",
                    "value": "MARS",
                }],
            }])
        ```
        ### Global Forwarding Rule External Managed

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_backend_service = gcp.compute.BackendService("default",
            name="backend",
            port_name="http",
            protocol="HTTP",
            timeout_sec=10,
            load_balancing_scheme="EXTERNAL_MANAGED")
        default_url_map = gcp.compute.URLMap("default",
            name="url-map-target-proxy",
            description="a description",
            default_service=default_backend_service.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": default_backend_service.id,
                "path_rules": [{
                    "paths": ["/*"],
                    "service": default_backend_service.id,
                }],
            }])
        default_target_http_proxy = gcp.compute.TargetHttpProxy("default",
            name="target-proxy",
            description="a description",
            url_map=default_url_map.id)
        default = gcp.compute.GlobalForwardingRule("default",
            name="global-rule",
            target=default_target_http_proxy.id,
            port_range="80",
            load_balancing_scheme="EXTERNAL_MANAGED",
            network_tier="PREMIUM")
        ```
        ### Global Forwarding Rule Hybrid

        ```python
        import pulumi
        import pulumi_gcp as gcp

        config = pulumi.Config()
        subnetwork_cidr = config.get("subnetworkCidr")
        if subnetwork_cidr is None:
            subnetwork_cidr = "10.0.0.0/24"
        default = gcp.compute.Network("default", name="my-network")
        internal = gcp.compute.Network("internal",
            name="my-internal-network",
            auto_create_subnetworks=False)
        internal_subnetwork = gcp.compute.Subnetwork("internal",
            name="my-subnetwork",
            network=internal.id,
            ip_cidr_range=subnetwork_cidr,
            region="us-central1",
            private_ip_google_access=True)
        # Zonal NEG with GCE_VM_IP_PORT
        default_network_endpoint_group = gcp.compute.NetworkEndpointGroup("default",
            name="default-neg",
            network=default.id,
            default_port=90,
            zone="us-central1-a",
            network_endpoint_type="GCE_VM_IP_PORT")
        # Zonal NEG with GCE_VM_IP
        internal_network_endpoint_group = gcp.compute.NetworkEndpointGroup("internal",
            name="internal-neg",
            network=internal.id,
            subnetwork=internal_subnetwork.id,
            zone="us-central1-a",
            network_endpoint_type="GCE_VM_IP")
        # Hybrid connectivity NEG
        hybrid = gcp.compute.NetworkEndpointGroup("hybrid",
            name="hybrid-neg",
            network=default.id,
            default_port=90,
            zone="us-central1-a",
            network_endpoint_type="NON_GCP_PRIVATE_IP_PORT")
        hybrid_endpoint = gcp.compute.NetworkEndpoint("hybrid-endpoint",
            network_endpoint_group=hybrid.name,
            port=hybrid.default_port,
            ip_address="127.0.0.1")
        default_health_check = gcp.compute.HealthCheck("default",
            name="health-check",
            timeout_sec=1,
            check_interval_sec=1,
            tcp_health_check={
                "port": 80,
            })
        # Backend service for Zonal NEG
        default_backend_service = gcp.compute.BackendService("default",
            name="backend-default",
            port_name="http",
            protocol="HTTP",
            timeout_sec=10,
            backends=[{
                "group": default_network_endpoint_group.id,
                "balancing_mode": "RATE",
                "max_rate_per_endpoint": 10,
            }],
            health_checks=default_health_check.id)
        # Backgend service for Hybrid NEG
        hybrid_backend_service = gcp.compute.BackendService("hybrid",
            name="backend-hybrid",
            port_name="http",
            protocol="HTTP",
            timeout_sec=10,
            backends=[{
                "group": hybrid.id,
                "balancing_mode": "RATE",
                "max_rate_per_endpoint": 10,
            }],
            health_checks=default_health_check.id)
        default_url_map = gcp.compute.URLMap("default",
            name="url-map-target-proxy",
            description="a description",
            default_service=default_backend_service.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": default_backend_service.id,
                "path_rules": [
                    {
                        "paths": ["/*"],
                        "service": default_backend_service.id,
                    },
                    {
                        "paths": ["/hybrid"],
                        "service": hybrid_backend_service.id,
                    },
                ],
            }])
        default_target_http_proxy = gcp.compute.TargetHttpProxy("default",
            name="target-proxy",
            description="a description",
            url_map=default_url_map.id)
        default_global_forwarding_rule = gcp.compute.GlobalForwardingRule("default",
            name="global-rule",
            target=default_target_http_proxy.id,
            port_range="80")
        ```
        ### Private Service Connect Google Apis

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            project="my-project-name",
            name="my-network",
            auto_create_subnetworks=False)
        vpc_subnetwork = gcp.compute.Subnetwork("vpc_subnetwork",
            project=network.project,
            name="my-subnetwork",
            ip_cidr_range="10.2.0.0/16",
            region="us-central1",
            network=network.id,
            private_ip_google_access=True)
        default = gcp.compute.GlobalAddress("default",
            project=network.project,
            name="global-psconnect-ip",
            address_type="INTERNAL",
            purpose="PRIVATE_SERVICE_CONNECT",
            network=network.id,
            address="100.100.100.106")
        default_global_forwarding_rule = gcp.compute.GlobalForwardingRule("default",
            project=network.project,
            name="globalrule",
            target="all-apis",
            network=network.id,
            ip_address=default.id,
            load_balancing_scheme="",
            service_directory_registrations={
                "namespace": "sd-namespace",
                "service_directory_region": "europe-west3",
            })
        ```
        ### Private Service Connect Google Apis No Automate Dns

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            project="my-project-name",
            name="my-network",
            auto_create_subnetworks=False)
        vpc_subnetwork = gcp.compute.Subnetwork("vpc_subnetwork",
            project=network.project,
            name="my-subnetwork",
            ip_cidr_range="10.2.0.0/16",
            region="us-central1",
            network=network.id,
            private_ip_google_access=True)
        default = gcp.compute.GlobalAddress("default",
            project=network.project,
            name="global-psconnect-ip",
            address_type="INTERNAL",
            purpose="PRIVATE_SERVICE_CONNECT",
            network=network.id,
            address="100.100.100.106")
        default_global_forwarding_rule = gcp.compute.GlobalForwardingRule("default",
            project=network.project,
            name="globalrule",
            target="all-apis",
            network=network.id,
            ip_address=default.id,
            load_balancing_scheme="",
            no_automate_dns_zone=False)
        ```

        ## Import

        GlobalForwardingRule can be imported using any of these accepted formats:

        * `projects/{{project}}/global/forwardingRules/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, GlobalForwardingRule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/globalForwardingRule:GlobalForwardingRule default projects/{{project}}/global/forwardingRules/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/globalForwardingRule:GlobalForwardingRule default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/globalForwardingRule:GlobalForwardingRule default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_psc_global_access: This is used in PSC consumer ForwardingRule to control whether the PSC endpoint can be accessed from another region.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[_builtins.str] external_managed_backend_bucket_migration_state: Specifies the canary migration state for the backend buckets attached to this forwarding rule.
               Possible values are PREPARE, TEST_BY_PERCENTAGE, and TEST_ALL_TRAFFIC.
               To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to
               PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be
               changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate
               traffic to backend buckets attached to this forwarding rule by percentage using
               externalManagedBackendBucketMigrationTestingPercentage.
               Rolling back a migration requires the states to be set in reverse order. So changing the
               scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at
               the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic
               back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
               Possible values are: `PREPARE`, `TEST_BY_PERCENTAGE`, `TEST_ALL_TRAFFIC`.
        :param pulumi.Input[_builtins.float] external_managed_backend_bucket_migration_testing_percentage: Determines the fraction of requests to backend buckets that should be processed by the Global
               external Application Load Balancer.
               The value of this field must be in the range [0, 100].
               This value can only be set if the loadBalancingScheme in the forwarding rule is set to
               EXTERNAL (when using the Classic ALB) and the migration state is TEST_BY_PERCENTAGE.
        :param pulumi.Input[_builtins.str] ip_address: IP address for which this forwarding rule accepts traffic. When a client
               sends traffic to this IP address, the forwarding rule directs the traffic
               to the referenced `target`.
               While creating a forwarding rule, specifying an `IPAddress` is
               required under the following circumstances:
               * When the `target` is set to `targetGrpcProxy` and
               `validateForProxyless` is set to `true`, the
               `IPAddress` should be set to `0.0.0.0`.
               * When the `target` is a Private Service Connect Google APIs
               bundle, you must specify an `IPAddress`.
               Otherwise, you can optionally specify an IP address that references an
               existing static (reserved) IP address resource. When omitted, Google Cloud
               assigns an ephemeral IP address.
               Use one of the following formats to specify an IP address while creating a
               forwarding rule:
               * IP address number, as in `100.1.2.3`
               * IPv6 address range, as in `2600:1234::/96`
               * Full resource URL, as in
               `https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name`
               * Partial URL or by name, as in:
               * `projects/project_id/regions/region/addresses/address-name`
               * `regions/region/addresses/address-name`
               * `global/addresses/address-name`
               * `address-name`
               The forwarding rule's `target`,
               and in most cases, also the `loadBalancingScheme`, determine the
               type of IP address that you can use. For detailed information, see
               [IP address
               specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               When reading an `IPAddress`, the API always returns the IP
               address number.
        :param pulumi.Input[_builtins.str] ip_protocol: The IP protocol to which this rule applies.
               For protocol forwarding, valid
               options are `TCP`, `UDP`, `ESP`,
               `AH`, `SCTP`, `ICMP` and
               `L3_DEFAULT`.
               The valid IP protocols are different for different load balancing products
               as described in [Load balancing
               features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
               Possible values are: `TCP`, `UDP`, `ESP`, `AH`, `SCTP`, `ICMP`.
        :param pulumi.Input[_builtins.str] ip_version: The IP Version that will be used by this global forwarding rule.
               Possible values are: `IPV4`, `IPV6`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels to apply to this forwarding rule.  A list of key->value pairs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] load_balancing_scheme: Specifies the forwarding rule type.
               For more information about forwarding rules, refer to
               [Forwarding rule concepts](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts).
               Default value is `EXTERNAL`.
               Possible values are: `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL_MANAGED`, `INTERNAL_SELF_MANAGED`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GlobalForwardingRuleMetadataFilterArgs', 'GlobalForwardingRuleMetadataFilterArgsDict']]]] metadata_filters: Opaque filter criteria used by Loadbalancer to restrict routing
               configuration to a limited set xDS compliant clients. In their xDS
               requests to Loadbalancer, xDS clients present node metadata. If a
               match takes place, the relevant routing configuration is made available
               to those proxies.
               For each metadataFilter in this list, if its filterMatchCriteria is set
               to MATCH_ANY, at least one of the filterLabels must match the
               corresponding label provided in the metadata. If its filterMatchCriteria
               is set to MATCH_ALL, then all of its filterLabels must match with
               corresponding labels in the provided metadata.
               metadataFilters specified here can be overridden by those specified in
               the UrlMap that this ForwardingRule references.
               metadataFilters only applies to Loadbalancers that have their
               loadBalancingScheme set to INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of the resource; provided by the client when the resource is created.
               The name must be 1-63 characters long, and comply with
               [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
               Specifically, the name must be 1-63 characters long and match the regular
               expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must
               be a dash, lowercase letter, or digit, except the last character, which
               cannot be a dash.
               For Private Service Connect forwarding rules that forward traffic to Google
               APIs, the forwarding rule name must be a 1-20 characters string with
               lowercase letters and numbers and must start with a letter.
        :param pulumi.Input[_builtins.str] network: This field is not used for external load balancing.
               For Internal TCP/UDP Load Balancing, this field identifies the network that
               the load balanced IP should belong to for this Forwarding Rule.
               If the subnetwork is specified, the network of the subnetwork will be used.
               If neither subnetwork nor this field is specified, the default network will
               be used.
               For Private Service Connect forwarding rules that forward traffic to Google
               APIs, a network must be provided.
        :param pulumi.Input[_builtins.str] network_tier: This signifies the networking tier used for configuring
               this load balancer and can only take the following values:
               `PREMIUM`, `STANDARD`.
               For regional ForwardingRule, the valid values are `PREMIUM` and
               `STANDARD`. For GlobalForwardingRule, the valid value is
               `PREMIUM`.
               If this field is not specified, it is assumed to be `PREMIUM`.
               If `IPAddress` is specified, this value must be equal to the
               networkTier of the Address.
               Possible values are: `PREMIUM`, `STANDARD`.
        :param pulumi.Input[_builtins.bool] no_automate_dns_zone: This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
        :param pulumi.Input[_builtins.str] port_range: The `portRange` field has the following limitations:
               * It requires that the forwarding rule `IPProtocol` be TCP, UDP, or SCTP,
               and
               * It's applicable only to the following products: external passthrough
               Network Load Balancers, internal and external proxy Network Load
               Balancers, internal and external Application Load Balancers, external
               protocol forwarding, and Classic VPN.
               * Some products have restrictions on what ports can be used. See
               [port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications)
               for details.
               For external forwarding rules, two or more forwarding rules cannot use the
               same `[IPAddress, IPProtocol]` pair, and cannot have overlapping
               `portRange`s.
               For internal forwarding rules within the same VPC network, two or more
               forwarding rules cannot use the same `[IPAddress, IPProtocol]` pair, and
               cannot have overlapping `portRange`s.
               @pattern: \\d+(?:-\\d+)?
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['GlobalForwardingRuleServiceDirectoryRegistrationsArgs', 'GlobalForwardingRuleServiceDirectoryRegistrationsArgsDict']] service_directory_registrations: Service Directory resources to register this forwarding rule with.
               Currently, only supports a single Service Directory resource.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_ip_ranges: If not empty, this Forwarding Rule will only forward the traffic when the source IP address matches one of the IP addresses or CIDR ranges set here. Note that a Forwarding Rule can only have up to 64 source IP ranges, and this field can only be used with a regional Forwarding Rule whose scheme is EXTERNAL. Each sourceIpRange entry should be either an IP address (for example, 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
        :param pulumi.Input[_builtins.str] subnetwork: This field identifies the subnetwork that the load balanced IP should
               belong to for this Forwarding Rule, used in internal load balancing and
               network load balancing with IPv6.
               If the network specified is in auto subnet mode, this field is optional.
               However, a subnetwork must be specified if the network is in custom subnet
               mode or when creating external forwarding rule with IPv6.
        :param pulumi.Input[_builtins.str] target: The URL of the target resource to receive the matched traffic.  For
               regional forwarding rules, this target must be in the same region as the
               forwarding rule. For global forwarding rules, this target must be a global
               load balancing resource.
               The forwarded traffic must be of a type appropriate to the target object.
               *  For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               *  For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle:
               *  `vpc-sc` - [ APIs that support VPC Service Controls](https://cloud.google.com/vpc-service-controls/docs/supported-products).
               *  `all-apis` - [All supported Google APIs](https://cloud.google.com/vpc/docs/private-service-connect#supported-apis).
               For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GlobalForwardingRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a GlobalForwardingRule resource. Global forwarding rules are
        used to forward traffic to the correct load balancer for HTTP load
        balancing. Global forwarding rules can only be used for HTTP load
        balancing.

        For more information, see https://cloud.google.com/compute/docs/load-balancing/http/

        ## Example Usage

        ### Global Forwarding Rule Http

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_http_health_check = gcp.compute.HttpHealthCheck("default",
            name="check-backend",
            request_path="/",
            check_interval_sec=1,
            timeout_sec=1)
        default_backend_service = gcp.compute.BackendService("default",
            name="backend",
            port_name="http",
            protocol="HTTP",
            timeout_sec=10,
            health_checks=default_http_health_check.id)
        default_url_map = gcp.compute.URLMap("default",
            name="url-map-target-proxy",
            description="a description",
            default_service=default_backend_service.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": default_backend_service.id,
                "path_rules": [{
                    "paths": ["/*"],
                    "service": default_backend_service.id,
                }],
            }])
        default_target_http_proxy = gcp.compute.TargetHttpProxy("default",
            name="target-proxy",
            description="a description",
            url_map=default_url_map.id)
        default = gcp.compute.GlobalForwardingRule("default",
            name="global-rule",
            target=default_target_http_proxy.id,
            port_range="80")
        ```
        ### Global Forwarding Rule Internal

        ```python
        import pulumi
        import pulumi_gcp as gcp

        debian_image = gcp.compute.get_image(family="debian-11",
            project="debian-cloud")
        instance_template = gcp.compute.InstanceTemplate("instance_template",
            name="template-backend",
            machine_type="e2-medium",
            network_interfaces=[{
                "network": "default",
            }],
            disks=[{
                "source_image": debian_image.self_link,
                "auto_delete": True,
                "boot": True,
            }])
        igm = gcp.compute.InstanceGroupManager("igm",
            name="igm-internal",
            versions=[{
                "instance_template": instance_template.id,
                "name": "primary",
            }],
            base_instance_name="internal-glb",
            zone="us-central1-f",
            target_size=1)
        default_health_check = gcp.compute.HealthCheck("default",
            name="check-backend",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        default_backend_service = gcp.compute.BackendService("default",
            name="backend",
            port_name="http",
            protocol="HTTP",
            timeout_sec=10,
            load_balancing_scheme="INTERNAL_SELF_MANAGED",
            backends=[{
                "group": igm.instance_group,
                "balancing_mode": "RATE",
                "capacity_scaler": 0.4,
                "max_rate_per_instance": 50,
            }],
            health_checks=default_health_check.id)
        default_url_map = gcp.compute.URLMap("default",
            name="url-map-target-proxy",
            description="a description",
            default_service=default_backend_service.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": default_backend_service.id,
                "path_rules": [{
                    "paths": ["/*"],
                    "service": default_backend_service.id,
                }],
            }])
        default_target_http_proxy = gcp.compute.TargetHttpProxy("default",
            name="target-proxy",
            description="a description",
            url_map=default_url_map.id)
        default = gcp.compute.GlobalForwardingRule("default",
            name="global-rule",
            target=default_target_http_proxy.id,
            port_range="80",
            load_balancing_scheme="INTERNAL_SELF_MANAGED",
            ip_address="0.0.0.0",
            metadata_filters=[{
                "filter_match_criteria": "MATCH_ANY",
                "filter_labels": [{
                    "name": "PLANET",
                    "value": "MARS",
                }],
            }])
        ```
        ### Global Forwarding Rule External Managed

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_backend_service = gcp.compute.BackendService("default",
            name="backend",
            port_name="http",
            protocol="HTTP",
            timeout_sec=10,
            load_balancing_scheme="EXTERNAL_MANAGED")
        default_url_map = gcp.compute.URLMap("default",
            name="url-map-target-proxy",
            description="a description",
            default_service=default_backend_service.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": default_backend_service.id,
                "path_rules": [{
                    "paths": ["/*"],
                    "service": default_backend_service.id,
                }],
            }])
        default_target_http_proxy = gcp.compute.TargetHttpProxy("default",
            name="target-proxy",
            description="a description",
            url_map=default_url_map.id)
        default = gcp.compute.GlobalForwardingRule("default",
            name="global-rule",
            target=default_target_http_proxy.id,
            port_range="80",
            load_balancing_scheme="EXTERNAL_MANAGED",
            network_tier="PREMIUM")
        ```
        ### Global Forwarding Rule Hybrid

        ```python
        import pulumi
        import pulumi_gcp as gcp

        config = pulumi.Config()
        subnetwork_cidr = config.get("subnetworkCidr")
        if subnetwork_cidr is None:
            subnetwork_cidr = "10.0.0.0/24"
        default = gcp.compute.Network("default", name="my-network")
        internal = gcp.compute.Network("internal",
            name="my-internal-network",
            auto_create_subnetworks=False)
        internal_subnetwork = gcp.compute.Subnetwork("internal",
            name="my-subnetwork",
            network=internal.id,
            ip_cidr_range=subnetwork_cidr,
            region="us-central1",
            private_ip_google_access=True)
        # Zonal NEG with GCE_VM_IP_PORT
        default_network_endpoint_group = gcp.compute.NetworkEndpointGroup("default",
            name="default-neg",
            network=default.id,
            default_port=90,
            zone="us-central1-a",
            network_endpoint_type="GCE_VM_IP_PORT")
        # Zonal NEG with GCE_VM_IP
        internal_network_endpoint_group = gcp.compute.NetworkEndpointGroup("internal",
            name="internal-neg",
            network=internal.id,
            subnetwork=internal_subnetwork.id,
            zone="us-central1-a",
            network_endpoint_type="GCE_VM_IP")
        # Hybrid connectivity NEG
        hybrid = gcp.compute.NetworkEndpointGroup("hybrid",
            name="hybrid-neg",
            network=default.id,
            default_port=90,
            zone="us-central1-a",
            network_endpoint_type="NON_GCP_PRIVATE_IP_PORT")
        hybrid_endpoint = gcp.compute.NetworkEndpoint("hybrid-endpoint",
            network_endpoint_group=hybrid.name,
            port=hybrid.default_port,
            ip_address="127.0.0.1")
        default_health_check = gcp.compute.HealthCheck("default",
            name="health-check",
            timeout_sec=1,
            check_interval_sec=1,
            tcp_health_check={
                "port": 80,
            })
        # Backend service for Zonal NEG
        default_backend_service = gcp.compute.BackendService("default",
            name="backend-default",
            port_name="http",
            protocol="HTTP",
            timeout_sec=10,
            backends=[{
                "group": default_network_endpoint_group.id,
                "balancing_mode": "RATE",
                "max_rate_per_endpoint": 10,
            }],
            health_checks=default_health_check.id)
        # Backgend service for Hybrid NEG
        hybrid_backend_service = gcp.compute.BackendService("hybrid",
            name="backend-hybrid",
            port_name="http",
            protocol="HTTP",
            timeout_sec=10,
            backends=[{
                "group": hybrid.id,
                "balancing_mode": "RATE",
                "max_rate_per_endpoint": 10,
            }],
            health_checks=default_health_check.id)
        default_url_map = gcp.compute.URLMap("default",
            name="url-map-target-proxy",
            description="a description",
            default_service=default_backend_service.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": default_backend_service.id,
                "path_rules": [
                    {
                        "paths": ["/*"],
                        "service": default_backend_service.id,
                    },
                    {
                        "paths": ["/hybrid"],
                        "service": hybrid_backend_service.id,
                    },
                ],
            }])
        default_target_http_proxy = gcp.compute.TargetHttpProxy("default",
            name="target-proxy",
            description="a description",
            url_map=default_url_map.id)
        default_global_forwarding_rule = gcp.compute.GlobalForwardingRule("default",
            name="global-rule",
            target=default_target_http_proxy.id,
            port_range="80")
        ```
        ### Private Service Connect Google Apis

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            project="my-project-name",
            name="my-network",
            auto_create_subnetworks=False)
        vpc_subnetwork = gcp.compute.Subnetwork("vpc_subnetwork",
            project=network.project,
            name="my-subnetwork",
            ip_cidr_range="10.2.0.0/16",
            region="us-central1",
            network=network.id,
            private_ip_google_access=True)
        default = gcp.compute.GlobalAddress("default",
            project=network.project,
            name="global-psconnect-ip",
            address_type="INTERNAL",
            purpose="PRIVATE_SERVICE_CONNECT",
            network=network.id,
            address="100.100.100.106")
        default_global_forwarding_rule = gcp.compute.GlobalForwardingRule("default",
            project=network.project,
            name="globalrule",
            target="all-apis",
            network=network.id,
            ip_address=default.id,
            load_balancing_scheme="",
            service_directory_registrations={
                "namespace": "sd-namespace",
                "service_directory_region": "europe-west3",
            })
        ```
        ### Private Service Connect Google Apis No Automate Dns

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            project="my-project-name",
            name="my-network",
            auto_create_subnetworks=False)
        vpc_subnetwork = gcp.compute.Subnetwork("vpc_subnetwork",
            project=network.project,
            name="my-subnetwork",
            ip_cidr_range="10.2.0.0/16",
            region="us-central1",
            network=network.id,
            private_ip_google_access=True)
        default = gcp.compute.GlobalAddress("default",
            project=network.project,
            name="global-psconnect-ip",
            address_type="INTERNAL",
            purpose="PRIVATE_SERVICE_CONNECT",
            network=network.id,
            address="100.100.100.106")
        default_global_forwarding_rule = gcp.compute.GlobalForwardingRule("default",
            project=network.project,
            name="globalrule",
            target="all-apis",
            network=network.id,
            ip_address=default.id,
            load_balancing_scheme="",
            no_automate_dns_zone=False)
        ```

        ## Import

        GlobalForwardingRule can be imported using any of these accepted formats:

        * `projects/{{project}}/global/forwardingRules/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, GlobalForwardingRule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/globalForwardingRule:GlobalForwardingRule default projects/{{project}}/global/forwardingRules/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/globalForwardingRule:GlobalForwardingRule default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/globalForwardingRule:GlobalForwardingRule default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param GlobalForwardingRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GlobalForwardingRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_psc_global_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_managed_backend_bucket_migration_state: Optional[pulumi.Input[_builtins.str]] = None,
                 external_managed_backend_bucket_migration_testing_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GlobalForwardingRuleMetadataFilterArgs', 'GlobalForwardingRuleMetadataFilterArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 network_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 no_automate_dns_zone: Optional[pulumi.Input[_builtins.bool]] = None,
                 port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_directory_registrations: Optional[pulumi.Input[Union['GlobalForwardingRuleServiceDirectoryRegistrationsArgs', 'GlobalForwardingRuleServiceDirectoryRegistrationsArgsDict']]] = None,
                 source_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subnetwork: Optional[pulumi.Input[_builtins.str]] = None,
                 target: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GlobalForwardingRuleArgs.__new__(GlobalForwardingRuleArgs)

            __props__.__dict__["allow_psc_global_access"] = allow_psc_global_access
            __props__.__dict__["description"] = description
            __props__.__dict__["external_managed_backend_bucket_migration_state"] = external_managed_backend_bucket_migration_state
            __props__.__dict__["external_managed_backend_bucket_migration_testing_percentage"] = external_managed_backend_bucket_migration_testing_percentage
            __props__.__dict__["ip_address"] = ip_address
            __props__.__dict__["ip_protocol"] = ip_protocol
            __props__.__dict__["ip_version"] = ip_version
            __props__.__dict__["labels"] = labels
            __props__.__dict__["load_balancing_scheme"] = load_balancing_scheme
            __props__.__dict__["metadata_filters"] = metadata_filters
            __props__.__dict__["name"] = name
            __props__.__dict__["network"] = network
            __props__.__dict__["network_tier"] = network_tier
            __props__.__dict__["no_automate_dns_zone"] = no_automate_dns_zone
            __props__.__dict__["port_range"] = port_range
            __props__.__dict__["project"] = project
            __props__.__dict__["service_directory_registrations"] = service_directory_registrations
            __props__.__dict__["source_ip_ranges"] = source_ip_ranges
            __props__.__dict__["subnetwork"] = subnetwork
            if target is None and not opts.urn:
                raise TypeError("Missing required property 'target'")
            __props__.__dict__["target"] = target
            __props__.__dict__["base_forwarding_rule"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["forwarding_rule_id"] = None
            __props__.__dict__["label_fingerprint"] = None
            __props__.__dict__["psc_connection_id"] = None
            __props__.__dict__["psc_connection_status"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["self_link"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(GlobalForwardingRule, __self__).__init__(
            'gcp:compute/globalForwardingRule:GlobalForwardingRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_psc_global_access: Optional[pulumi.Input[_builtins.bool]] = None,
            base_forwarding_rule: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            external_managed_backend_bucket_migration_state: Optional[pulumi.Input[_builtins.str]] = None,
            external_managed_backend_bucket_migration_testing_percentage: Optional[pulumi.Input[_builtins.float]] = None,
            forwarding_rule_id: Optional[pulumi.Input[_builtins.int]] = None,
            ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            ip_protocol: Optional[pulumi.Input[_builtins.str]] = None,
            ip_version: Optional[pulumi.Input[_builtins.str]] = None,
            label_fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            load_balancing_scheme: Optional[pulumi.Input[_builtins.str]] = None,
            metadata_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GlobalForwardingRuleMetadataFilterArgs', 'GlobalForwardingRuleMetadataFilterArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network: Optional[pulumi.Input[_builtins.str]] = None,
            network_tier: Optional[pulumi.Input[_builtins.str]] = None,
            no_automate_dns_zone: Optional[pulumi.Input[_builtins.bool]] = None,
            port_range: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            psc_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
            psc_connection_status: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            self_link: Optional[pulumi.Input[_builtins.str]] = None,
            service_directory_registrations: Optional[pulumi.Input[Union['GlobalForwardingRuleServiceDirectoryRegistrationsArgs', 'GlobalForwardingRuleServiceDirectoryRegistrationsArgsDict']]] = None,
            source_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            subnetwork: Optional[pulumi.Input[_builtins.str]] = None,
            target: Optional[pulumi.Input[_builtins.str]] = None) -> 'GlobalForwardingRule':
        """
        Get an existing GlobalForwardingRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_psc_global_access: This is used in PSC consumer ForwardingRule to control whether the PSC endpoint can be accessed from another region.
        :param pulumi.Input[_builtins.str] base_forwarding_rule: [Output Only] The URL for the corresponding base Forwarding Rule. By base Forwarding Rule, we mean the Forwarding Rule that has the same IP address, protocol, and port settings with the current Forwarding Rule, but without sourceIPRanges specified. Always empty if the current Forwarding Rule does not have sourceIPRanges specified.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] external_managed_backend_bucket_migration_state: Specifies the canary migration state for the backend buckets attached to this forwarding rule.
               Possible values are PREPARE, TEST_BY_PERCENTAGE, and TEST_ALL_TRAFFIC.
               To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to
               PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be
               changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate
               traffic to backend buckets attached to this forwarding rule by percentage using
               externalManagedBackendBucketMigrationTestingPercentage.
               Rolling back a migration requires the states to be set in reverse order. So changing the
               scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at
               the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic
               back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
               Possible values are: `PREPARE`, `TEST_BY_PERCENTAGE`, `TEST_ALL_TRAFFIC`.
        :param pulumi.Input[_builtins.float] external_managed_backend_bucket_migration_testing_percentage: Determines the fraction of requests to backend buckets that should be processed by the Global
               external Application Load Balancer.
               The value of this field must be in the range [0, 100].
               This value can only be set if the loadBalancingScheme in the forwarding rule is set to
               EXTERNAL (when using the Classic ALB) and the migration state is TEST_BY_PERCENTAGE.
        :param pulumi.Input[_builtins.int] forwarding_rule_id: The unique identifier number for the resource. This identifier is defined by the server.
        :param pulumi.Input[_builtins.str] ip_address: IP address for which this forwarding rule accepts traffic. When a client
               sends traffic to this IP address, the forwarding rule directs the traffic
               to the referenced `target`.
               While creating a forwarding rule, specifying an `IPAddress` is
               required under the following circumstances:
               * When the `target` is set to `targetGrpcProxy` and
               `validateForProxyless` is set to `true`, the
               `IPAddress` should be set to `0.0.0.0`.
               * When the `target` is a Private Service Connect Google APIs
               bundle, you must specify an `IPAddress`.
               Otherwise, you can optionally specify an IP address that references an
               existing static (reserved) IP address resource. When omitted, Google Cloud
               assigns an ephemeral IP address.
               Use one of the following formats to specify an IP address while creating a
               forwarding rule:
               * IP address number, as in `100.1.2.3`
               * IPv6 address range, as in `2600:1234::/96`
               * Full resource URL, as in
               `https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name`
               * Partial URL or by name, as in:
               * `projects/project_id/regions/region/addresses/address-name`
               * `regions/region/addresses/address-name`
               * `global/addresses/address-name`
               * `address-name`
               The forwarding rule's `target`,
               and in most cases, also the `loadBalancingScheme`, determine the
               type of IP address that you can use. For detailed information, see
               [IP address
               specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               When reading an `IPAddress`, the API always returns the IP
               address number.
        :param pulumi.Input[_builtins.str] ip_protocol: The IP protocol to which this rule applies.
               For protocol forwarding, valid
               options are `TCP`, `UDP`, `ESP`,
               `AH`, `SCTP`, `ICMP` and
               `L3_DEFAULT`.
               The valid IP protocols are different for different load balancing products
               as described in [Load balancing
               features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
               Possible values are: `TCP`, `UDP`, `ESP`, `AH`, `SCTP`, `ICMP`.
        :param pulumi.Input[_builtins.str] ip_version: The IP Version that will be used by this global forwarding rule.
               Possible values are: `IPV4`, `IPV6`.
        :param pulumi.Input[_builtins.str] label_fingerprint: The fingerprint used for optimistic locking of this resource.  Used
               internally during updates.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels to apply to this forwarding rule.  A list of key->value pairs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] load_balancing_scheme: Specifies the forwarding rule type.
               For more information about forwarding rules, refer to
               [Forwarding rule concepts](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts).
               Default value is `EXTERNAL`.
               Possible values are: `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL_MANAGED`, `INTERNAL_SELF_MANAGED`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GlobalForwardingRuleMetadataFilterArgs', 'GlobalForwardingRuleMetadataFilterArgsDict']]]] metadata_filters: Opaque filter criteria used by Loadbalancer to restrict routing
               configuration to a limited set xDS compliant clients. In their xDS
               requests to Loadbalancer, xDS clients present node metadata. If a
               match takes place, the relevant routing configuration is made available
               to those proxies.
               For each metadataFilter in this list, if its filterMatchCriteria is set
               to MATCH_ANY, at least one of the filterLabels must match the
               corresponding label provided in the metadata. If its filterMatchCriteria
               is set to MATCH_ALL, then all of its filterLabels must match with
               corresponding labels in the provided metadata.
               metadataFilters specified here can be overridden by those specified in
               the UrlMap that this ForwardingRule references.
               metadataFilters only applies to Loadbalancers that have their
               loadBalancingScheme set to INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of the resource; provided by the client when the resource is created.
               The name must be 1-63 characters long, and comply with
               [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
               Specifically, the name must be 1-63 characters long and match the regular
               expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must
               be a dash, lowercase letter, or digit, except the last character, which
               cannot be a dash.
               For Private Service Connect forwarding rules that forward traffic to Google
               APIs, the forwarding rule name must be a 1-20 characters string with
               lowercase letters and numbers and must start with a letter.
        :param pulumi.Input[_builtins.str] network: This field is not used for external load balancing.
               For Internal TCP/UDP Load Balancing, this field identifies the network that
               the load balanced IP should belong to for this Forwarding Rule.
               If the subnetwork is specified, the network of the subnetwork will be used.
               If neither subnetwork nor this field is specified, the default network will
               be used.
               For Private Service Connect forwarding rules that forward traffic to Google
               APIs, a network must be provided.
        :param pulumi.Input[_builtins.str] network_tier: This signifies the networking tier used for configuring
               this load balancer and can only take the following values:
               `PREMIUM`, `STANDARD`.
               For regional ForwardingRule, the valid values are `PREMIUM` and
               `STANDARD`. For GlobalForwardingRule, the valid value is
               `PREMIUM`.
               If this field is not specified, it is assumed to be `PREMIUM`.
               If `IPAddress` is specified, this value must be equal to the
               networkTier of the Address.
               Possible values are: `PREMIUM`, `STANDARD`.
        :param pulumi.Input[_builtins.bool] no_automate_dns_zone: This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
        :param pulumi.Input[_builtins.str] port_range: The `portRange` field has the following limitations:
               * It requires that the forwarding rule `IPProtocol` be TCP, UDP, or SCTP,
               and
               * It's applicable only to the following products: external passthrough
               Network Load Balancers, internal and external proxy Network Load
               Balancers, internal and external Application Load Balancers, external
               protocol forwarding, and Classic VPN.
               * Some products have restrictions on what ports can be used. See
               [port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications)
               for details.
               For external forwarding rules, two or more forwarding rules cannot use the
               same `[IPAddress, IPProtocol]` pair, and cannot have overlapping
               `portRange`s.
               For internal forwarding rules within the same VPC network, two or more
               forwarding rules cannot use the same `[IPAddress, IPProtocol]` pair, and
               cannot have overlapping `portRange`s.
               @pattern: \\d+(?:-\\d+)?
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] psc_connection_id: The PSC connection id of the PSC Forwarding Rule.
        :param pulumi.Input[_builtins.str] psc_connection_status: The PSC connection status of the PSC Forwarding Rule. Possible values: `STATUS_UNSPECIFIED`, `PENDING`, `ACCEPTED`, `REJECTED`, `CLOSED`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[Union['GlobalForwardingRuleServiceDirectoryRegistrationsArgs', 'GlobalForwardingRuleServiceDirectoryRegistrationsArgsDict']] service_directory_registrations: Service Directory resources to register this forwarding rule with.
               Currently, only supports a single Service Directory resource.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_ip_ranges: If not empty, this Forwarding Rule will only forward the traffic when the source IP address matches one of the IP addresses or CIDR ranges set here. Note that a Forwarding Rule can only have up to 64 source IP ranges, and this field can only be used with a regional Forwarding Rule whose scheme is EXTERNAL. Each sourceIpRange entry should be either an IP address (for example, 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
        :param pulumi.Input[_builtins.str] subnetwork: This field identifies the subnetwork that the load balanced IP should
               belong to for this Forwarding Rule, used in internal load balancing and
               network load balancing with IPv6.
               If the network specified is in auto subnet mode, this field is optional.
               However, a subnetwork must be specified if the network is in custom subnet
               mode or when creating external forwarding rule with IPv6.
        :param pulumi.Input[_builtins.str] target: The URL of the target resource to receive the matched traffic.  For
               regional forwarding rules, this target must be in the same region as the
               forwarding rule. For global forwarding rules, this target must be a global
               load balancing resource.
               The forwarded traffic must be of a type appropriate to the target object.
               *  For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               *  For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle:
               *  `vpc-sc` - [ APIs that support VPC Service Controls](https://cloud.google.com/vpc-service-controls/docs/supported-products).
               *  `all-apis` - [All supported Google APIs](https://cloud.google.com/vpc/docs/private-service-connect#supported-apis).
               For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GlobalForwardingRuleState.__new__(_GlobalForwardingRuleState)

        __props__.__dict__["allow_psc_global_access"] = allow_psc_global_access
        __props__.__dict__["base_forwarding_rule"] = base_forwarding_rule
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["external_managed_backend_bucket_migration_state"] = external_managed_backend_bucket_migration_state
        __props__.__dict__["external_managed_backend_bucket_migration_testing_percentage"] = external_managed_backend_bucket_migration_testing_percentage
        __props__.__dict__["forwarding_rule_id"] = forwarding_rule_id
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["ip_protocol"] = ip_protocol
        __props__.__dict__["ip_version"] = ip_version
        __props__.__dict__["label_fingerprint"] = label_fingerprint
        __props__.__dict__["labels"] = labels
        __props__.__dict__["load_balancing_scheme"] = load_balancing_scheme
        __props__.__dict__["metadata_filters"] = metadata_filters
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["network_tier"] = network_tier
        __props__.__dict__["no_automate_dns_zone"] = no_automate_dns_zone
        __props__.__dict__["port_range"] = port_range
        __props__.__dict__["project"] = project
        __props__.__dict__["psc_connection_id"] = psc_connection_id
        __props__.__dict__["psc_connection_status"] = psc_connection_status
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["service_directory_registrations"] = service_directory_registrations
        __props__.__dict__["source_ip_ranges"] = source_ip_ranges
        __props__.__dict__["subnetwork"] = subnetwork
        __props__.__dict__["target"] = target
        return GlobalForwardingRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowPscGlobalAccess")
    def allow_psc_global_access(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        This is used in PSC consumer ForwardingRule to control whether the PSC endpoint can be accessed from another region.
        """
        return pulumi.get(self, "allow_psc_global_access")

    @_builtins.property
    @pulumi.getter(name="baseForwardingRule")
    def base_forwarding_rule(self) -> pulumi.Output[_builtins.str]:
        """
        [Output Only] The URL for the corresponding base Forwarding Rule. By base Forwarding Rule, we mean the Forwarding Rule that has the same IP address, protocol, and port settings with the current Forwarding Rule, but without sourceIPRanges specified. Always empty if the current Forwarding Rule does not have sourceIPRanges specified.
        """
        return pulumi.get(self, "base_forwarding_rule")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="externalManagedBackendBucketMigrationState")
    def external_managed_backend_bucket_migration_state(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the canary migration state for the backend buckets attached to this forwarding rule.
        Possible values are PREPARE, TEST_BY_PERCENTAGE, and TEST_ALL_TRAFFIC.
        To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to
        PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be
        changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate
        traffic to backend buckets attached to this forwarding rule by percentage using
        externalManagedBackendBucketMigrationTestingPercentage.
        Rolling back a migration requires the states to be set in reverse order. So changing the
        scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at
        the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic
        back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
        Possible values are: `PREPARE`, `TEST_BY_PERCENTAGE`, `TEST_ALL_TRAFFIC`.
        """
        return pulumi.get(self, "external_managed_backend_bucket_migration_state")

    @_builtins.property
    @pulumi.getter(name="externalManagedBackendBucketMigrationTestingPercentage")
    def external_managed_backend_bucket_migration_testing_percentage(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        Determines the fraction of requests to backend buckets that should be processed by the Global
        external Application Load Balancer.
        The value of this field must be in the range [0, 100].
        This value can only be set if the loadBalancingScheme in the forwarding rule is set to
        EXTERNAL (when using the Classic ALB) and the migration state is TEST_BY_PERCENTAGE.
        """
        return pulumi.get(self, "external_managed_backend_bucket_migration_testing_percentage")

    @_builtins.property
    @pulumi.getter(name="forwardingRuleId")
    def forwarding_rule_id(self) -> pulumi.Output[_builtins.int]:
        """
        The unique identifier number for the resource. This identifier is defined by the server.
        """
        return pulumi.get(self, "forwarding_rule_id")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        IP address for which this forwarding rule accepts traffic. When a client
        sends traffic to this IP address, the forwarding rule directs the traffic
        to the referenced `target`.
        While creating a forwarding rule, specifying an `IPAddress` is
        required under the following circumstances:
        * When the `target` is set to `targetGrpcProxy` and
        `validateForProxyless` is set to `true`, the
        `IPAddress` should be set to `0.0.0.0`.
        * When the `target` is a Private Service Connect Google APIs
        bundle, you must specify an `IPAddress`.
        Otherwise, you can optionally specify an IP address that references an
        existing static (reserved) IP address resource. When omitted, Google Cloud
        assigns an ephemeral IP address.
        Use one of the following formats to specify an IP address while creating a
        forwarding rule:
        * IP address number, as in `100.1.2.3`
        * IPv6 address range, as in `2600:1234::/96`
        * Full resource URL, as in
        `https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name`
        * Partial URL or by name, as in:
        * `projects/project_id/regions/region/addresses/address-name`
        * `regions/region/addresses/address-name`
        * `global/addresses/address-name`
        * `address-name`
        The forwarding rule's `target`,
        and in most cases, also the `loadBalancingScheme`, determine the
        type of IP address that you can use. For detailed information, see
        [IP address
        specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
        When reading an `IPAddress`, the API always returns the IP
        address number.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> pulumi.Output[_builtins.str]:
        """
        The IP protocol to which this rule applies.
        For protocol forwarding, valid
        options are `TCP`, `UDP`, `ESP`,
        `AH`, `SCTP`, `ICMP` and
        `L3_DEFAULT`.
        The valid IP protocols are different for different load balancing products
        as described in [Load balancing
        features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
        Possible values are: `TCP`, `UDP`, `ESP`, `AH`, `SCTP`, `ICMP`.
        """
        return pulumi.get(self, "ip_protocol")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IP Version that will be used by this global forwarding rule.
        Possible values are: `IPV4`, `IPV6`.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> pulumi.Output[_builtins.str]:
        """
        The fingerprint used for optimistic locking of this resource.  Used
        internally during updates.
        """
        return pulumi.get(self, "label_fingerprint")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Labels to apply to this forwarding rule.  A list of key->value pairs.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the forwarding rule type.
        For more information about forwarding rules, refer to
        [Forwarding rule concepts](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts).
        Default value is `EXTERNAL`.
        Possible values are: `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL_MANAGED`, `INTERNAL_SELF_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @_builtins.property
    @pulumi.getter(name="metadataFilters")
    def metadata_filters(self) -> pulumi.Output[Optional[Sequence['outputs.GlobalForwardingRuleMetadataFilter']]]:
        """
        Opaque filter criteria used by Loadbalancer to restrict routing
        configuration to a limited set xDS compliant clients. In their xDS
        requests to Loadbalancer, xDS clients present node metadata. If a
        match takes place, the relevant routing configuration is made available
        to those proxies.
        For each metadataFilter in this list, if its filterMatchCriteria is set
        to MATCH_ANY, at least one of the filterLabels must match the
        corresponding label provided in the metadata. If its filterMatchCriteria
        is set to MATCH_ALL, then all of its filterLabels must match with
        corresponding labels in the provided metadata.
        metadataFilters specified here can be overridden by those specified in
        the UrlMap that this ForwardingRule references.
        metadataFilters only applies to Loadbalancers that have their
        loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata_filters")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the resource; provided by the client when the resource is created.
        The name must be 1-63 characters long, and comply with
        [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
        Specifically, the name must be 1-63 characters long and match the regular
        expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters must
        be a dash, lowercase letter, or digit, except the last character, which
        cannot be a dash.
        For Private Service Connect forwarding rules that forward traffic to Google
        APIs, the forwarding rule name must be a 1-20 characters string with
        lowercase letters and numbers and must start with a letter.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output[_builtins.str]:
        """
        This field is not used for external load balancing.
        For Internal TCP/UDP Load Balancing, this field identifies the network that
        the load balanced IP should belong to for this Forwarding Rule.
        If the subnetwork is specified, the network of the subnetwork will be used.
        If neither subnetwork nor this field is specified, the default network will
        be used.
        For Private Service Connect forwarding rules that forward traffic to Google
        APIs, a network must be provided.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="networkTier")
    def network_tier(self) -> pulumi.Output[_builtins.str]:
        """
        This signifies the networking tier used for configuring
        this load balancer and can only take the following values:
        `PREMIUM`, `STANDARD`.
        For regional ForwardingRule, the valid values are `PREMIUM` and
        `STANDARD`. For GlobalForwardingRule, the valid value is
        `PREMIUM`.
        If this field is not specified, it is assumed to be `PREMIUM`.
        If `IPAddress` is specified, this value must be equal to the
        networkTier of the Address.
        Possible values are: `PREMIUM`, `STANDARD`.
        """
        return pulumi.get(self, "network_tier")

    @_builtins.property
    @pulumi.getter(name="noAutomateDnsZone")
    def no_automate_dns_zone(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
        """
        return pulumi.get(self, "no_automate_dns_zone")

    @_builtins.property
    @pulumi.getter(name="portRange")
    def port_range(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The `portRange` field has the following limitations:
        * It requires that the forwarding rule `IPProtocol` be TCP, UDP, or SCTP,
        and
        * It's applicable only to the following products: external passthrough
        Network Load Balancers, internal and external proxy Network Load
        Balancers, internal and external Application Load Balancers, external
        protocol forwarding, and Classic VPN.
        * Some products have restrictions on what ports can be used. See
        [port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications)
        for details.
        For external forwarding rules, two or more forwarding rules cannot use the
        same `[IPAddress, IPProtocol]` pair, and cannot have overlapping
        `portRange`s.
        For internal forwarding rules within the same VPC network, two or more
        forwarding rules cannot use the same `[IPAddress, IPProtocol]` pair, and
        cannot have overlapping `portRange`s.
        @pattern: \\d+(?:-\\d+)?
        """
        return pulumi.get(self, "port_range")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pscConnectionId")
    def psc_connection_id(self) -> pulumi.Output[_builtins.str]:
        """
        The PSC connection id of the PSC Forwarding Rule.
        """
        return pulumi.get(self, "psc_connection_id")

    @_builtins.property
    @pulumi.getter(name="pscConnectionStatus")
    def psc_connection_status(self) -> pulumi.Output[_builtins.str]:
        """
        The PSC connection status of the PSC Forwarding Rule. Possible values: `STATUS_UNSPECIFIED`, `PENDING`, `ACCEPTED`, `REJECTED`, `CLOSED`
        """
        return pulumi.get(self, "psc_connection_status")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[_builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter(name="serviceDirectoryRegistrations")
    def service_directory_registrations(self) -> pulumi.Output['outputs.GlobalForwardingRuleServiceDirectoryRegistrations']:
        """
        Service Directory resources to register this forwarding rule with.
        Currently, only supports a single Service Directory resource.
        Structure is documented below.
        """
        return pulumi.get(self, "service_directory_registrations")

    @_builtins.property
    @pulumi.getter(name="sourceIpRanges")
    def source_ip_ranges(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        If not empty, this Forwarding Rule will only forward the traffic when the source IP address matches one of the IP addresses or CIDR ranges set here. Note that a Forwarding Rule can only have up to 64 source IP ranges, and this field can only be used with a regional Forwarding Rule whose scheme is EXTERNAL. Each sourceIpRange entry should be either an IP address (for example, 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
        """
        return pulumi.get(self, "source_ip_ranges")

    @_builtins.property
    @pulumi.getter
    def subnetwork(self) -> pulumi.Output[_builtins.str]:
        """
        This field identifies the subnetwork that the load balanced IP should
        belong to for this Forwarding Rule, used in internal load balancing and
        network load balancing with IPv6.
        If the network specified is in auto subnet mode, this field is optional.
        However, a subnetwork must be specified if the network is in custom subnet
        mode or when creating external forwarding rule with IPv6.
        """
        return pulumi.get(self, "subnetwork")

    @_builtins.property
    @pulumi.getter
    def target(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of the target resource to receive the matched traffic.  For
        regional forwarding rules, this target must be in the same region as the
        forwarding rule. For global forwarding rules, this target must be a global
        load balancing resource.
        The forwarded traffic must be of a type appropriate to the target object.
        *  For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
        *  For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle:
        *  `vpc-sc` - [ APIs that support VPC Service Controls](https://cloud.google.com/vpc-service-controls/docs/supported-products).
        *  `all-apis` - [All supported Google APIs](https://cloud.google.com/vpc/docs/private-service-connect#supported-apis).
        For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
        """
        return pulumi.get(self, "target")

