# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkAttachmentArgs', 'NetworkAttachment']

@pulumi.input_type
class NetworkAttachmentArgs:
    def __init__(__self__, *,
                 connection_preference: pulumi.Input[_builtins.str],
                 subnetworks: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 producer_accept_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 producer_reject_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkAttachment resource.
        :param pulumi.Input[_builtins.str] connection_preference: The connection preference of service attachment. The value can be set to ACCEPT_AUTOMATIC. An ACCEPT_AUTOMATIC service attachment is one that always accepts the connection from consumer forwarding rules.
               Possible values are: `ACCEPT_AUTOMATIC`, `ACCEPT_MANUAL`, `INVALID`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnetworks: An array of URLs where each entry is the URL of a subnet provided by the service consumer to use for endpoints in the producers that connect to this network attachment.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression a-z? which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] producer_accept_lists: Projects that are allowed to connect to this network attachment. The project can be specified using its id or number.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] producer_reject_lists: Projects that are not allowed to connect to this network attachment. The project can be specified using its id or number.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: URL of the region where the network attachment resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        """
        pulumi.set(__self__, "connection_preference", connection_preference)
        pulumi.set(__self__, "subnetworks", subnetworks)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if producer_accept_lists is not None:
            pulumi.set(__self__, "producer_accept_lists", producer_accept_lists)
        if producer_reject_lists is not None:
            pulumi.set(__self__, "producer_reject_lists", producer_reject_lists)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="connectionPreference")
    def connection_preference(self) -> pulumi.Input[_builtins.str]:
        """
        The connection preference of service attachment. The value can be set to ACCEPT_AUTOMATIC. An ACCEPT_AUTOMATIC service attachment is one that always accepts the connection from consumer forwarding rules.
        Possible values are: `ACCEPT_AUTOMATIC`, `ACCEPT_MANUAL`, `INVALID`.
        """
        return pulumi.get(self, "connection_preference")

    @connection_preference.setter
    def connection_preference(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "connection_preference", value)

    @_builtins.property
    @pulumi.getter
    def subnetworks(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        An array of URLs where each entry is the URL of a subnet provided by the service consumer to use for endpoints in the producers that connect to this network attachment.
        """
        return pulumi.get(self, "subnetworks")

    @subnetworks.setter
    def subnetworks(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "subnetworks", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression a-z? which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="producerAcceptLists")
    def producer_accept_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Projects that are allowed to connect to this network attachment. The project can be specified using its id or number.
        """
        return pulumi.get(self, "producer_accept_lists")

    @producer_accept_lists.setter
    def producer_accept_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "producer_accept_lists", value)

    @_builtins.property
    @pulumi.getter(name="producerRejectLists")
    def producer_reject_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Projects that are not allowed to connect to this network attachment. The project can be specified using its id or number.
        """
        return pulumi.get(self, "producer_reject_lists")

    @producer_reject_lists.setter
    def producer_reject_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "producer_reject_lists", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of the region where the network attachment resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _NetworkAttachmentState:
    def __init__(__self__, *,
                 connection_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAttachmentConnectionEndpointArgs']]]] = None,
                 connection_preference: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 producer_accept_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 producer_reject_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 self_link: Optional[pulumi.Input[_builtins.str]] = None,
                 self_link_with_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnetworks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering NetworkAttachment resources.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkAttachmentConnectionEndpointArgs']]] connection_endpoints: An array of connections for all the producers connected to this network attachment.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] connection_preference: The connection preference of service attachment. The value can be set to ACCEPT_AUTOMATIC. An ACCEPT_AUTOMATIC service attachment is one that always accepts the connection from consumer forwarding rules.
               Possible values are: `ACCEPT_AUTOMATIC`, `ACCEPT_MANUAL`, `INVALID`.
        :param pulumi.Input[_builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[_builtins.str] fingerprint: Fingerprint of this resource. A hash of the contents stored in this object. This
               field is used in optimistic locking. An up-to-date fingerprint must be provided in order to patch.
        :param pulumi.Input[_builtins.str] kind: Type of the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression a-z? which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] network: The URL of the network which the Network Attachment belongs to. Practically it is inferred by fetching the network of the first subnetwork associated.
               Because it is required that all the subnetworks must be from the same network, it is assured that the Network Attachment belongs to the same network as all the subnetworks.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] producer_accept_lists: Projects that are allowed to connect to this network attachment. The project can be specified using its id or number.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] producer_reject_lists: Projects that are not allowed to connect to this network attachment. The project can be specified using its id or number.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: URL of the region where the network attachment resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        :param pulumi.Input[_builtins.str] self_link: Server-defined URL for the resource.
        :param pulumi.Input[_builtins.str] self_link_with_id: Server-defined URL for this resource's resource id.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnetworks: An array of URLs where each entry is the URL of a subnet provided by the service consumer to use for endpoints in the producers that connect to this network attachment.
        """
        if connection_endpoints is not None:
            pulumi.set(__self__, "connection_endpoints", connection_endpoints)
        if connection_preference is not None:
            pulumi.set(__self__, "connection_preference", connection_preference)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if producer_accept_lists is not None:
            pulumi.set(__self__, "producer_accept_lists", producer_accept_lists)
        if producer_reject_lists is not None:
            pulumi.set(__self__, "producer_reject_lists", producer_reject_lists)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if self_link_with_id is not None:
            pulumi.set(__self__, "self_link_with_id", self_link_with_id)
        if subnetworks is not None:
            pulumi.set(__self__, "subnetworks", subnetworks)

    @_builtins.property
    @pulumi.getter(name="connectionEndpoints")
    def connection_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAttachmentConnectionEndpointArgs']]]]:
        """
        An array of connections for all the producers connected to this network attachment.
        Structure is documented below.
        """
        return pulumi.get(self, "connection_endpoints")

    @connection_endpoints.setter
    def connection_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAttachmentConnectionEndpointArgs']]]]):
        pulumi.set(self, "connection_endpoints", value)

    @_builtins.property
    @pulumi.getter(name="connectionPreference")
    def connection_preference(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection preference of service attachment. The value can be set to ACCEPT_AUTOMATIC. An ACCEPT_AUTOMATIC service attachment is one that always accepts the connection from consumer forwarding rules.
        Possible values are: `ACCEPT_AUTOMATIC`, `ACCEPT_MANUAL`, `INVALID`.
        """
        return pulumi.get(self, "connection_preference")

    @connection_preference.setter
    def connection_preference(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_preference", value)

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fingerprint of this resource. A hash of the contents stored in this object. This
        field is used in optimistic locking. An up-to-date fingerprint must be provided in order to patch.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fingerprint", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the resource.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression a-z? which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the network which the Network Attachment belongs to. Practically it is inferred by fetching the network of the first subnetwork associated.
        Because it is required that all the subnetworks must be from the same network, it is assured that the Network Attachment belongs to the same network as all the subnetworks.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="producerAcceptLists")
    def producer_accept_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Projects that are allowed to connect to this network attachment. The project can be specified using its id or number.
        """
        return pulumi.get(self, "producer_accept_lists")

    @producer_accept_lists.setter
    def producer_accept_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "producer_accept_lists", value)

    @_builtins.property
    @pulumi.getter(name="producerRejectLists")
    def producer_reject_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Projects that are not allowed to connect to this network attachment. The project can be specified using its id or number.
        """
        return pulumi.get(self, "producer_reject_lists")

    @producer_reject_lists.setter
    def producer_reject_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "producer_reject_lists", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of the region where the network attachment resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Server-defined URL for the resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link", value)

    @_builtins.property
    @pulumi.getter(name="selfLinkWithId")
    def self_link_with_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Server-defined URL for this resource's resource id.
        """
        return pulumi.get(self, "self_link_with_id")

    @self_link_with_id.setter
    def self_link_with_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link_with_id", value)

    @_builtins.property
    @pulumi.getter
    def subnetworks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An array of URLs where each entry is the URL of a subnet provided by the service consumer to use for endpoints in the producers that connect to this network attachment.
        """
        return pulumi.get(self, "subnetworks")

    @subnetworks.setter
    def subnetworks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "subnetworks", value)


@pulumi.type_token("gcp:compute/networkAttachment:NetworkAttachment")
class NetworkAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_preference: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 producer_accept_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 producer_reject_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subnetworks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        A network attachment is a resource that lets a producer Virtual Private Cloud (VPC) network initiate connections to a consumer VPC network through a Private Service Connect interface.

        To get more information about NetworkAttachment, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/networkAttachments)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/vpc/docs/about-network-attachments)

        ## Example Usage

        ### Network Attachment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("default",
            name="basic-network",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="basic-subnetwork",
            region="us-central1",
            network=default_network.id,
            ip_cidr_range="10.0.0.0/16")
        rejected_producer_project = gcp.organizations.Project("rejected_producer_project",
            project_id="prj-rejected",
            name="prj-rejected",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE")
        accepted_producer_project = gcp.organizations.Project("accepted_producer_project",
            project_id="prj-accepted",
            name="prj-accepted",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE")
        default = gcp.compute.NetworkAttachment("default",
            name="basic-network-attachment",
            region="us-central1",
            description="basic network attachment description",
            connection_preference="ACCEPT_MANUAL",
            subnetworks=[default_subnetwork.self_link],
            producer_accept_lists=[accepted_producer_project.project_id],
            producer_reject_lists=[rejected_producer_project.project_id])
        ```
        ### Network Attachment Instance Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="basic-network",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="basic-subnetwork",
            region="us-central1",
            network=default.id,
            ip_cidr_range="10.0.0.0/16")
        default_network_attachment = gcp.compute.NetworkAttachment("default",
            name="basic-network-attachment",
            region="us-central1",
            description="my basic network attachment",
            subnetworks=[default_subnetwork.id],
            connection_preference="ACCEPT_AUTOMATIC")
        default_instance = gcp.compute.Instance("default",
            name="basic-instance",
            zone="us-central1-a",
            machine_type="e2-micro",
            boot_disk={
                "initialize_params": {
                    "image": "debian-cloud/debian-11",
                },
            },
            network_interfaces=[
                {
                    "network": "default",
                },
                {
                    "network_attachment": default_network_attachment.self_link,
                },
            ])
        ```

        ## Import

        NetworkAttachment can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/networkAttachments/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, NetworkAttachment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/networkAttachment:NetworkAttachment default projects/{{project}}/regions/{{region}}/networkAttachments/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/networkAttachment:NetworkAttachment default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/networkAttachment:NetworkAttachment default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/networkAttachment:NetworkAttachment default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] connection_preference: The connection preference of service attachment. The value can be set to ACCEPT_AUTOMATIC. An ACCEPT_AUTOMATIC service attachment is one that always accepts the connection from consumer forwarding rules.
               Possible values are: `ACCEPT_AUTOMATIC`, `ACCEPT_MANUAL`, `INVALID`.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression a-z? which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] producer_accept_lists: Projects that are allowed to connect to this network attachment. The project can be specified using its id or number.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] producer_reject_lists: Projects that are not allowed to connect to this network attachment. The project can be specified using its id or number.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: URL of the region where the network attachment resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnetworks: An array of URLs where each entry is the URL of a subnet provided by the service consumer to use for endpoints in the producers that connect to this network attachment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A network attachment is a resource that lets a producer Virtual Private Cloud (VPC) network initiate connections to a consumer VPC network through a Private Service Connect interface.

        To get more information about NetworkAttachment, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/networkAttachments)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/vpc/docs/about-network-attachments)

        ## Example Usage

        ### Network Attachment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("default",
            name="basic-network",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="basic-subnetwork",
            region="us-central1",
            network=default_network.id,
            ip_cidr_range="10.0.0.0/16")
        rejected_producer_project = gcp.organizations.Project("rejected_producer_project",
            project_id="prj-rejected",
            name="prj-rejected",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE")
        accepted_producer_project = gcp.organizations.Project("accepted_producer_project",
            project_id="prj-accepted",
            name="prj-accepted",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE")
        default = gcp.compute.NetworkAttachment("default",
            name="basic-network-attachment",
            region="us-central1",
            description="basic network attachment description",
            connection_preference="ACCEPT_MANUAL",
            subnetworks=[default_subnetwork.self_link],
            producer_accept_lists=[accepted_producer_project.project_id],
            producer_reject_lists=[rejected_producer_project.project_id])
        ```
        ### Network Attachment Instance Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="basic-network",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="basic-subnetwork",
            region="us-central1",
            network=default.id,
            ip_cidr_range="10.0.0.0/16")
        default_network_attachment = gcp.compute.NetworkAttachment("default",
            name="basic-network-attachment",
            region="us-central1",
            description="my basic network attachment",
            subnetworks=[default_subnetwork.id],
            connection_preference="ACCEPT_AUTOMATIC")
        default_instance = gcp.compute.Instance("default",
            name="basic-instance",
            zone="us-central1-a",
            machine_type="e2-micro",
            boot_disk={
                "initialize_params": {
                    "image": "debian-cloud/debian-11",
                },
            },
            network_interfaces=[
                {
                    "network": "default",
                },
                {
                    "network_attachment": default_network_attachment.self_link,
                },
            ])
        ```

        ## Import

        NetworkAttachment can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/networkAttachments/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, NetworkAttachment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/networkAttachment:NetworkAttachment default projects/{{project}}/regions/{{region}}/networkAttachments/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/networkAttachment:NetworkAttachment default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/networkAttachment:NetworkAttachment default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/networkAttachment:NetworkAttachment default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param NetworkAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_preference: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 producer_accept_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 producer_reject_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subnetworks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkAttachmentArgs.__new__(NetworkAttachmentArgs)

            if connection_preference is None and not opts.urn:
                raise TypeError("Missing required property 'connection_preference'")
            __props__.__dict__["connection_preference"] = connection_preference
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["producer_accept_lists"] = producer_accept_lists
            __props__.__dict__["producer_reject_lists"] = producer_reject_lists
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            if subnetworks is None and not opts.urn:
                raise TypeError("Missing required property 'subnetworks'")
            __props__.__dict__["subnetworks"] = subnetworks
            __props__.__dict__["connection_endpoints"] = None
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["fingerprint"] = None
            __props__.__dict__["kind"] = None
            __props__.__dict__["network"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["self_link_with_id"] = None
        super(NetworkAttachment, __self__).__init__(
            'gcp:compute/networkAttachment:NetworkAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkAttachmentConnectionEndpointArgs', 'NetworkAttachmentConnectionEndpointArgsDict']]]]] = None,
            connection_preference: Optional[pulumi.Input[_builtins.str]] = None,
            creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
            kind: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network: Optional[pulumi.Input[_builtins.str]] = None,
            producer_accept_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            producer_reject_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            self_link: Optional[pulumi.Input[_builtins.str]] = None,
            self_link_with_id: Optional[pulumi.Input[_builtins.str]] = None,
            subnetworks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'NetworkAttachment':
        """
        Get an existing NetworkAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkAttachmentConnectionEndpointArgs', 'NetworkAttachmentConnectionEndpointArgsDict']]]] connection_endpoints: An array of connections for all the producers connected to this network attachment.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] connection_preference: The connection preference of service attachment. The value can be set to ACCEPT_AUTOMATIC. An ACCEPT_AUTOMATIC service attachment is one that always accepts the connection from consumer forwarding rules.
               Possible values are: `ACCEPT_AUTOMATIC`, `ACCEPT_MANUAL`, `INVALID`.
        :param pulumi.Input[_builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[_builtins.str] fingerprint: Fingerprint of this resource. A hash of the contents stored in this object. This
               field is used in optimistic locking. An up-to-date fingerprint must be provided in order to patch.
        :param pulumi.Input[_builtins.str] kind: Type of the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression a-z? which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] network: The URL of the network which the Network Attachment belongs to. Practically it is inferred by fetching the network of the first subnetwork associated.
               Because it is required that all the subnetworks must be from the same network, it is assured that the Network Attachment belongs to the same network as all the subnetworks.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] producer_accept_lists: Projects that are allowed to connect to this network attachment. The project can be specified using its id or number.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] producer_reject_lists: Projects that are not allowed to connect to this network attachment. The project can be specified using its id or number.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: URL of the region where the network attachment resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        :param pulumi.Input[_builtins.str] self_link: Server-defined URL for the resource.
        :param pulumi.Input[_builtins.str] self_link_with_id: Server-defined URL for this resource's resource id.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnetworks: An array of URLs where each entry is the URL of a subnet provided by the service consumer to use for endpoints in the producers that connect to this network attachment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkAttachmentState.__new__(_NetworkAttachmentState)

        __props__.__dict__["connection_endpoints"] = connection_endpoints
        __props__.__dict__["connection_preference"] = connection_preference
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["kind"] = kind
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["producer_accept_lists"] = producer_accept_lists
        __props__.__dict__["producer_reject_lists"] = producer_reject_lists
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["self_link_with_id"] = self_link_with_id
        __props__.__dict__["subnetworks"] = subnetworks
        return NetworkAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="connectionEndpoints")
    def connection_endpoints(self) -> pulumi.Output[Sequence['outputs.NetworkAttachmentConnectionEndpoint']]:
        """
        An array of connections for all the producers connected to this network attachment.
        Structure is documented below.
        """
        return pulumi.get(self, "connection_endpoints")

    @_builtins.property
    @pulumi.getter(name="connectionPreference")
    def connection_preference(self) -> pulumi.Output[_builtins.str]:
        """
        The connection preference of service attachment. The value can be set to ACCEPT_AUTOMATIC. An ACCEPT_AUTOMATIC service attachment is one that always accepts the connection from consumer forwarding rules.
        Possible values are: `ACCEPT_AUTOMATIC`, `ACCEPT_MANUAL`, `INVALID`.
        """
        return pulumi.get(self, "connection_preference")

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[_builtins.str]:
        """
        Fingerprint of this resource. A hash of the contents stored in this object. This
        field is used in optimistic locking. An up-to-date fingerprint must be provided in order to patch.
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the resource.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression a-z? which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of the network which the Network Attachment belongs to. Practically it is inferred by fetching the network of the first subnetwork associated.
        Because it is required that all the subnetworks must be from the same network, it is assured that the Network Attachment belongs to the same network as all the subnetworks.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="producerAcceptLists")
    def producer_accept_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Projects that are allowed to connect to this network attachment. The project can be specified using its id or number.
        """
        return pulumi.get(self, "producer_accept_lists")

    @_builtins.property
    @pulumi.getter(name="producerRejectLists")
    def producer_reject_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Projects that are not allowed to connect to this network attachment. The project can be specified using its id or number.
        """
        return pulumi.get(self, "producer_reject_lists")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        URL of the region where the network attachment resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[_builtins.str]:
        """
        Server-defined URL for the resource.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter(name="selfLinkWithId")
    def self_link_with_id(self) -> pulumi.Output[_builtins.str]:
        """
        Server-defined URL for this resource's resource id.
        """
        return pulumi.get(self, "self_link_with_id")

    @_builtins.property
    @pulumi.getter
    def subnetworks(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        An array of URLs where each entry is the URL of a subnet provided by the service consumer to use for endpoints in the producers that connect to this network attachment.
        """
        return pulumi.get(self, "subnetworks")

