# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RegionHealthCheckArgs', 'RegionHealthCheck']

@pulumi.input_type
class RegionHealthCheckArgs:
    def __init__(__self__, *,
                 check_interval_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 grpc_health_check: Optional[pulumi.Input['RegionHealthCheckGrpcHealthCheckArgs']] = None,
                 grpc_tls_health_check: Optional[pulumi.Input['RegionHealthCheckGrpcTlsHealthCheckArgs']] = None,
                 healthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 http2_health_check: Optional[pulumi.Input['RegionHealthCheckHttp2HealthCheckArgs']] = None,
                 http_health_check: Optional[pulumi.Input['RegionHealthCheckHttpHealthCheckArgs']] = None,
                 https_health_check: Optional[pulumi.Input['RegionHealthCheckHttpsHealthCheckArgs']] = None,
                 log_config: Optional[pulumi.Input['RegionHealthCheckLogConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_health_check: Optional[pulumi.Input['RegionHealthCheckSslHealthCheckArgs']] = None,
                 tcp_health_check: Optional[pulumi.Input['RegionHealthCheckTcpHealthCheckArgs']] = None,
                 timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a RegionHealthCheck resource.
        :param pulumi.Input[_builtins.int] check_interval_sec: How often (in seconds) to send a health check. The default value is 5
               seconds.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input['RegionHealthCheckGrpcHealthCheckArgs'] grpc_health_check: A nested object resource.
               Structure is documented below.
        :param pulumi.Input['RegionHealthCheckGrpcTlsHealthCheckArgs'] grpc_tls_health_check: A nested object resource.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] healthy_threshold: A so-far unhealthy instance will be marked healthy after this many
               consecutive successes. The default value is 2.
        :param pulumi.Input['RegionHealthCheckHttp2HealthCheckArgs'] http2_health_check: A nested object resource.
               Structure is documented below.
        :param pulumi.Input['RegionHealthCheckHttpHealthCheckArgs'] http_health_check: A nested object resource.
               Structure is documented below.
        :param pulumi.Input['RegionHealthCheckHttpsHealthCheckArgs'] https_health_check: A nested object resource.
               Structure is documented below.
        :param pulumi.Input['RegionHealthCheckLogConfigArgs'] log_config: Configure logging on this health check.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035.  Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z?` which means
               the first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the
               last character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The Region in which the created health check should reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input['RegionHealthCheckSslHealthCheckArgs'] ssl_health_check: A nested object resource.
               Structure is documented below.
        :param pulumi.Input['RegionHealthCheckTcpHealthCheckArgs'] tcp_health_check: A nested object resource.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] timeout_sec: How long (in seconds) to wait before claiming failure.
               The default value is 5 seconds.  It is invalid for timeoutSec to have
               greater value than checkIntervalSec.
        :param pulumi.Input[_builtins.int] unhealthy_threshold: A so-far healthy instance will be marked unhealthy after this many
               consecutive failures. The default value is 2.
        """
        if check_interval_sec is not None:
            pulumi.set(__self__, "check_interval_sec", check_interval_sec)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if grpc_health_check is not None:
            pulumi.set(__self__, "grpc_health_check", grpc_health_check)
        if grpc_tls_health_check is not None:
            pulumi.set(__self__, "grpc_tls_health_check", grpc_tls_health_check)
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if http2_health_check is not None:
            pulumi.set(__self__, "http2_health_check", http2_health_check)
        if http_health_check is not None:
            pulumi.set(__self__, "http_health_check", http_health_check)
        if https_health_check is not None:
            pulumi.set(__self__, "https_health_check", https_health_check)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if ssl_health_check is not None:
            pulumi.set(__self__, "ssl_health_check", ssl_health_check)
        if tcp_health_check is not None:
            pulumi.set(__self__, "tcp_health_check", tcp_health_check)
        if timeout_sec is not None:
            pulumi.set(__self__, "timeout_sec", timeout_sec)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @_builtins.property
    @pulumi.getter(name="checkIntervalSec")
    def check_interval_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How often (in seconds) to send a health check. The default value is 5
        seconds.
        """
        return pulumi.get(self, "check_interval_sec")

    @check_interval_sec.setter
    def check_interval_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "check_interval_sec", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="grpcHealthCheck")
    def grpc_health_check(self) -> Optional[pulumi.Input['RegionHealthCheckGrpcHealthCheckArgs']]:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "grpc_health_check")

    @grpc_health_check.setter
    def grpc_health_check(self, value: Optional[pulumi.Input['RegionHealthCheckGrpcHealthCheckArgs']]):
        pulumi.set(self, "grpc_health_check", value)

    @_builtins.property
    @pulumi.getter(name="grpcTlsHealthCheck")
    def grpc_tls_health_check(self) -> Optional[pulumi.Input['RegionHealthCheckGrpcTlsHealthCheckArgs']]:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "grpc_tls_health_check")

    @grpc_tls_health_check.setter
    def grpc_tls_health_check(self, value: Optional[pulumi.Input['RegionHealthCheckGrpcTlsHealthCheckArgs']]):
        pulumi.set(self, "grpc_tls_health_check", value)

    @_builtins.property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        A so-far unhealthy instance will be marked healthy after this many
        consecutive successes. The default value is 2.
        """
        return pulumi.get(self, "healthy_threshold")

    @healthy_threshold.setter
    def healthy_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "healthy_threshold", value)

    @_builtins.property
    @pulumi.getter(name="http2HealthCheck")
    def http2_health_check(self) -> Optional[pulumi.Input['RegionHealthCheckHttp2HealthCheckArgs']]:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "http2_health_check")

    @http2_health_check.setter
    def http2_health_check(self, value: Optional[pulumi.Input['RegionHealthCheckHttp2HealthCheckArgs']]):
        pulumi.set(self, "http2_health_check", value)

    @_builtins.property
    @pulumi.getter(name="httpHealthCheck")
    def http_health_check(self) -> Optional[pulumi.Input['RegionHealthCheckHttpHealthCheckArgs']]:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "http_health_check")

    @http_health_check.setter
    def http_health_check(self, value: Optional[pulumi.Input['RegionHealthCheckHttpHealthCheckArgs']]):
        pulumi.set(self, "http_health_check", value)

    @_builtins.property
    @pulumi.getter(name="httpsHealthCheck")
    def https_health_check(self) -> Optional[pulumi.Input['RegionHealthCheckHttpsHealthCheckArgs']]:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "https_health_check")

    @https_health_check.setter
    def https_health_check(self, value: Optional[pulumi.Input['RegionHealthCheckHttpsHealthCheckArgs']]):
        pulumi.set(self, "https_health_check", value)

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['RegionHealthCheckLogConfigArgs']]:
        """
        Configure logging on this health check.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['RegionHealthCheckLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035.  Specifically, the name must be 1-63 characters long and
        match the regular expression `a-z?` which means
        the first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the
        last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Region in which the created health check should reside.
        If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sslHealthCheck")
    def ssl_health_check(self) -> Optional[pulumi.Input['RegionHealthCheckSslHealthCheckArgs']]:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "ssl_health_check")

    @ssl_health_check.setter
    def ssl_health_check(self, value: Optional[pulumi.Input['RegionHealthCheckSslHealthCheckArgs']]):
        pulumi.set(self, "ssl_health_check", value)

    @_builtins.property
    @pulumi.getter(name="tcpHealthCheck")
    def tcp_health_check(self) -> Optional[pulumi.Input['RegionHealthCheckTcpHealthCheckArgs']]:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "tcp_health_check")

    @tcp_health_check.setter
    def tcp_health_check(self, value: Optional[pulumi.Input['RegionHealthCheckTcpHealthCheckArgs']]):
        pulumi.set(self, "tcp_health_check", value)

    @_builtins.property
    @pulumi.getter(name="timeoutSec")
    def timeout_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How long (in seconds) to wait before claiming failure.
        The default value is 5 seconds.  It is invalid for timeoutSec to have
        greater value than checkIntervalSec.
        """
        return pulumi.get(self, "timeout_sec")

    @timeout_sec.setter
    def timeout_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_sec", value)

    @_builtins.property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        A so-far healthy instance will be marked unhealthy after this many
        consecutive failures. The default value is 2.
        """
        return pulumi.get(self, "unhealthy_threshold")

    @unhealthy_threshold.setter
    def unhealthy_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "unhealthy_threshold", value)


@pulumi.input_type
class _RegionHealthCheckState:
    def __init__(__self__, *,
                 check_interval_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 grpc_health_check: Optional[pulumi.Input['RegionHealthCheckGrpcHealthCheckArgs']] = None,
                 grpc_tls_health_check: Optional[pulumi.Input['RegionHealthCheckGrpcTlsHealthCheckArgs']] = None,
                 health_check_id: Optional[pulumi.Input[_builtins.int]] = None,
                 healthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 http2_health_check: Optional[pulumi.Input['RegionHealthCheckHttp2HealthCheckArgs']] = None,
                 http_health_check: Optional[pulumi.Input['RegionHealthCheckHttpHealthCheckArgs']] = None,
                 https_health_check: Optional[pulumi.Input['RegionHealthCheckHttpsHealthCheckArgs']] = None,
                 log_config: Optional[pulumi.Input['RegionHealthCheckLogConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 self_link: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_health_check: Optional[pulumi.Input['RegionHealthCheckSslHealthCheckArgs']] = None,
                 tcp_health_check: Optional[pulumi.Input['RegionHealthCheckTcpHealthCheckArgs']] = None,
                 timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering RegionHealthCheck resources.
        :param pulumi.Input[_builtins.int] check_interval_sec: How often (in seconds) to send a health check. The default value is 5
               seconds.
        :param pulumi.Input[_builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input['RegionHealthCheckGrpcHealthCheckArgs'] grpc_health_check: A nested object resource.
               Structure is documented below.
        :param pulumi.Input['RegionHealthCheckGrpcTlsHealthCheckArgs'] grpc_tls_health_check: A nested object resource.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] health_check_id: The unique identifier number for the resource. This identifier is defined by the server.
        :param pulumi.Input[_builtins.int] healthy_threshold: A so-far unhealthy instance will be marked healthy after this many
               consecutive successes. The default value is 2.
        :param pulumi.Input['RegionHealthCheckHttp2HealthCheckArgs'] http2_health_check: A nested object resource.
               Structure is documented below.
        :param pulumi.Input['RegionHealthCheckHttpHealthCheckArgs'] http_health_check: A nested object resource.
               Structure is documented below.
        :param pulumi.Input['RegionHealthCheckHttpsHealthCheckArgs'] https_health_check: A nested object resource.
               Structure is documented below.
        :param pulumi.Input['RegionHealthCheckLogConfigArgs'] log_config: Configure logging on this health check.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035.  Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z?` which means
               the first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the
               last character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The Region in which the created health check should reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input['RegionHealthCheckSslHealthCheckArgs'] ssl_health_check: A nested object resource.
               Structure is documented below.
        :param pulumi.Input['RegionHealthCheckTcpHealthCheckArgs'] tcp_health_check: A nested object resource.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] timeout_sec: How long (in seconds) to wait before claiming failure.
               The default value is 5 seconds.  It is invalid for timeoutSec to have
               greater value than checkIntervalSec.
        :param pulumi.Input[_builtins.str] type: The type of the health check. One of HTTP, HTTP2, HTTPS, TCP, or SSL.
        :param pulumi.Input[_builtins.int] unhealthy_threshold: A so-far healthy instance will be marked unhealthy after this many
               consecutive failures. The default value is 2.
        """
        if check_interval_sec is not None:
            pulumi.set(__self__, "check_interval_sec", check_interval_sec)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if grpc_health_check is not None:
            pulumi.set(__self__, "grpc_health_check", grpc_health_check)
        if grpc_tls_health_check is not None:
            pulumi.set(__self__, "grpc_tls_health_check", grpc_tls_health_check)
        if health_check_id is not None:
            pulumi.set(__self__, "health_check_id", health_check_id)
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if http2_health_check is not None:
            pulumi.set(__self__, "http2_health_check", http2_health_check)
        if http_health_check is not None:
            pulumi.set(__self__, "http_health_check", http_health_check)
        if https_health_check is not None:
            pulumi.set(__self__, "https_health_check", https_health_check)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if ssl_health_check is not None:
            pulumi.set(__self__, "ssl_health_check", ssl_health_check)
        if tcp_health_check is not None:
            pulumi.set(__self__, "tcp_health_check", tcp_health_check)
        if timeout_sec is not None:
            pulumi.set(__self__, "timeout_sec", timeout_sec)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @_builtins.property
    @pulumi.getter(name="checkIntervalSec")
    def check_interval_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How often (in seconds) to send a health check. The default value is 5
        seconds.
        """
        return pulumi.get(self, "check_interval_sec")

    @check_interval_sec.setter
    def check_interval_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "check_interval_sec", value)

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="grpcHealthCheck")
    def grpc_health_check(self) -> Optional[pulumi.Input['RegionHealthCheckGrpcHealthCheckArgs']]:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "grpc_health_check")

    @grpc_health_check.setter
    def grpc_health_check(self, value: Optional[pulumi.Input['RegionHealthCheckGrpcHealthCheckArgs']]):
        pulumi.set(self, "grpc_health_check", value)

    @_builtins.property
    @pulumi.getter(name="grpcTlsHealthCheck")
    def grpc_tls_health_check(self) -> Optional[pulumi.Input['RegionHealthCheckGrpcTlsHealthCheckArgs']]:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "grpc_tls_health_check")

    @grpc_tls_health_check.setter
    def grpc_tls_health_check(self, value: Optional[pulumi.Input['RegionHealthCheckGrpcTlsHealthCheckArgs']]):
        pulumi.set(self, "grpc_tls_health_check", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckId")
    def health_check_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The unique identifier number for the resource. This identifier is defined by the server.
        """
        return pulumi.get(self, "health_check_id")

    @health_check_id.setter
    def health_check_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_id", value)

    @_builtins.property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        A so-far unhealthy instance will be marked healthy after this many
        consecutive successes. The default value is 2.
        """
        return pulumi.get(self, "healthy_threshold")

    @healthy_threshold.setter
    def healthy_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "healthy_threshold", value)

    @_builtins.property
    @pulumi.getter(name="http2HealthCheck")
    def http2_health_check(self) -> Optional[pulumi.Input['RegionHealthCheckHttp2HealthCheckArgs']]:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "http2_health_check")

    @http2_health_check.setter
    def http2_health_check(self, value: Optional[pulumi.Input['RegionHealthCheckHttp2HealthCheckArgs']]):
        pulumi.set(self, "http2_health_check", value)

    @_builtins.property
    @pulumi.getter(name="httpHealthCheck")
    def http_health_check(self) -> Optional[pulumi.Input['RegionHealthCheckHttpHealthCheckArgs']]:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "http_health_check")

    @http_health_check.setter
    def http_health_check(self, value: Optional[pulumi.Input['RegionHealthCheckHttpHealthCheckArgs']]):
        pulumi.set(self, "http_health_check", value)

    @_builtins.property
    @pulumi.getter(name="httpsHealthCheck")
    def https_health_check(self) -> Optional[pulumi.Input['RegionHealthCheckHttpsHealthCheckArgs']]:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "https_health_check")

    @https_health_check.setter
    def https_health_check(self, value: Optional[pulumi.Input['RegionHealthCheckHttpsHealthCheckArgs']]):
        pulumi.set(self, "https_health_check", value)

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['RegionHealthCheckLogConfigArgs']]:
        """
        Configure logging on this health check.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['RegionHealthCheckLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035.  Specifically, the name must be 1-63 characters long and
        match the regular expression `a-z?` which means
        the first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the
        last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Region in which the created health check should reside.
        If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link", value)

    @_builtins.property
    @pulumi.getter(name="sslHealthCheck")
    def ssl_health_check(self) -> Optional[pulumi.Input['RegionHealthCheckSslHealthCheckArgs']]:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "ssl_health_check")

    @ssl_health_check.setter
    def ssl_health_check(self, value: Optional[pulumi.Input['RegionHealthCheckSslHealthCheckArgs']]):
        pulumi.set(self, "ssl_health_check", value)

    @_builtins.property
    @pulumi.getter(name="tcpHealthCheck")
    def tcp_health_check(self) -> Optional[pulumi.Input['RegionHealthCheckTcpHealthCheckArgs']]:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "tcp_health_check")

    @tcp_health_check.setter
    def tcp_health_check(self, value: Optional[pulumi.Input['RegionHealthCheckTcpHealthCheckArgs']]):
        pulumi.set(self, "tcp_health_check", value)

    @_builtins.property
    @pulumi.getter(name="timeoutSec")
    def timeout_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How long (in seconds) to wait before claiming failure.
        The default value is 5 seconds.  It is invalid for timeoutSec to have
        greater value than checkIntervalSec.
        """
        return pulumi.get(self, "timeout_sec")

    @timeout_sec.setter
    def timeout_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_sec", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the health check. One of HTTP, HTTP2, HTTPS, TCP, or SSL.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        A so-far healthy instance will be marked unhealthy after this many
        consecutive failures. The default value is 2.
        """
        return pulumi.get(self, "unhealthy_threshold")

    @unhealthy_threshold.setter
    def unhealthy_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "unhealthy_threshold", value)


@pulumi.type_token("gcp:compute/regionHealthCheck:RegionHealthCheck")
class RegionHealthCheck(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 check_interval_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 grpc_health_check: Optional[pulumi.Input[Union['RegionHealthCheckGrpcHealthCheckArgs', 'RegionHealthCheckGrpcHealthCheckArgsDict']]] = None,
                 grpc_tls_health_check: Optional[pulumi.Input[Union['RegionHealthCheckGrpcTlsHealthCheckArgs', 'RegionHealthCheckGrpcTlsHealthCheckArgsDict']]] = None,
                 healthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 http2_health_check: Optional[pulumi.Input[Union['RegionHealthCheckHttp2HealthCheckArgs', 'RegionHealthCheckHttp2HealthCheckArgsDict']]] = None,
                 http_health_check: Optional[pulumi.Input[Union['RegionHealthCheckHttpHealthCheckArgs', 'RegionHealthCheckHttpHealthCheckArgsDict']]] = None,
                 https_health_check: Optional[pulumi.Input[Union['RegionHealthCheckHttpsHealthCheckArgs', 'RegionHealthCheckHttpsHealthCheckArgsDict']]] = None,
                 log_config: Optional[pulumi.Input[Union['RegionHealthCheckLogConfigArgs', 'RegionHealthCheckLogConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_health_check: Optional[pulumi.Input[Union['RegionHealthCheckSslHealthCheckArgs', 'RegionHealthCheckSslHealthCheckArgsDict']]] = None,
                 tcp_health_check: Optional[pulumi.Input[Union['RegionHealthCheckTcpHealthCheckArgs', 'RegionHealthCheckTcpHealthCheckArgsDict']]] = None,
                 timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Health Checks determine whether instances are responsive and able to do work.
        They are an important part of a comprehensive load balancing configuration,
        as they enable monitoring instances behind load balancers.

        Health Checks poll instances at a specified interval. Instances that
        do not respond successfully to some number of probes in a row are marked
        as unhealthy. No new connections are sent to unhealthy instances,
        though existing connections will continue. The health check will
        continue to poll unhealthy instances. If an instance later responds
        successfully to some number of consecutive probes, it is marked
        healthy again and can receive new connections.

        To get more information about RegionHealthCheck, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/regionHealthChecks)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/load-balancing/docs/health-checks)

        ## Example Usage

        ### Region Health Check Tcp

        ```python
        import pulumi
        import pulumi_gcp as gcp

        tcp_region_health_check = gcp.compute.RegionHealthCheck("tcp-region-health-check",
            name="tcp-region-health-check",
            timeout_sec=1,
            check_interval_sec=1,
            tcp_health_check={
                "port": 80,
            })
        ```
        ### Region Health Check Tcp Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        tcp_region_health_check = gcp.compute.RegionHealthCheck("tcp-region-health-check",
            name="tcp-region-health-check",
            description="Health check via tcp",
            timeout_sec=1,
            check_interval_sec=1,
            healthy_threshold=4,
            unhealthy_threshold=5,
            tcp_health_check={
                "port_name": "health-check-port",
                "port_specification": "USE_NAMED_PORT",
                "request": "ARE YOU HEALTHY?",
                "proxy_header": "NONE",
                "response": "I AM HEALTHY",
            })
        ```
        ### Region Health Check Ssl

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ssl_region_health_check = gcp.compute.RegionHealthCheck("ssl-region-health-check",
            name="ssl-region-health-check",
            timeout_sec=1,
            check_interval_sec=1,
            ssl_health_check={
                "port": 443,
            })
        ```
        ### Region Health Check Ssl Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ssl_region_health_check = gcp.compute.RegionHealthCheck("ssl-region-health-check",
            name="ssl-region-health-check",
            description="Health check via ssl",
            timeout_sec=1,
            check_interval_sec=1,
            healthy_threshold=4,
            unhealthy_threshold=5,
            ssl_health_check={
                "port_name": "health-check-port",
                "port_specification": "USE_NAMED_PORT",
                "request": "ARE YOU HEALTHY?",
                "proxy_header": "NONE",
                "response": "I AM HEALTHY",
            })
        ```
        ### Region Health Check Http

        ```python
        import pulumi
        import pulumi_gcp as gcp

        http_region_health_check = gcp.compute.RegionHealthCheck("http-region-health-check",
            name="http-region-health-check",
            timeout_sec=1,
            check_interval_sec=1,
            http_health_check={
                "port": 80,
            })
        ```
        ### Region Health Check Http Logs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        http_region_health_check = gcp.compute.RegionHealthCheck("http-region-health-check",
            name="http-region-health-check",
            timeout_sec=1,
            check_interval_sec=1,
            http_health_check={
                "port": 80,
            },
            log_config={
                "enable": True,
            })
        ```
        ### Region Health Check Http Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        http_region_health_check = gcp.compute.RegionHealthCheck("http-region-health-check",
            name="http-region-health-check",
            description="Health check via http",
            timeout_sec=1,
            check_interval_sec=1,
            healthy_threshold=4,
            unhealthy_threshold=5,
            http_health_check={
                "port_name": "health-check-port",
                "port_specification": "USE_NAMED_PORT",
                "host": "1.2.3.4",
                "request_path": "/mypath",
                "proxy_header": "NONE",
                "response": "I AM HEALTHY",
            })
        ```
        ### Region Health Check Https

        ```python
        import pulumi
        import pulumi_gcp as gcp

        https_region_health_check = gcp.compute.RegionHealthCheck("https-region-health-check",
            name="https-region-health-check",
            timeout_sec=1,
            check_interval_sec=1,
            https_health_check={
                "port": 443,
            })
        ```
        ### Region Health Check Https Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        https_region_health_check = gcp.compute.RegionHealthCheck("https-region-health-check",
            name="https-region-health-check",
            description="Health check via https",
            timeout_sec=1,
            check_interval_sec=1,
            healthy_threshold=4,
            unhealthy_threshold=5,
            https_health_check={
                "port_name": "health-check-port",
                "port_specification": "USE_NAMED_PORT",
                "host": "1.2.3.4",
                "request_path": "/mypath",
                "proxy_header": "NONE",
                "response": "I AM HEALTHY",
            })
        ```
        ### Region Health Check Http2

        ```python
        import pulumi
        import pulumi_gcp as gcp

        http2_region_health_check = gcp.compute.RegionHealthCheck("http2-region-health-check",
            name="http2-region-health-check",
            timeout_sec=1,
            check_interval_sec=1,
            http2_health_check={
                "port": 443,
            })
        ```
        ### Region Health Check Http2 Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        http2_region_health_check = gcp.compute.RegionHealthCheck("http2-region-health-check",
            name="http2-region-health-check",
            description="Health check via http2",
            timeout_sec=1,
            check_interval_sec=1,
            healthy_threshold=4,
            unhealthy_threshold=5,
            http2_health_check={
                "port_name": "health-check-port",
                "port_specification": "USE_NAMED_PORT",
                "host": "1.2.3.4",
                "request_path": "/mypath",
                "proxy_header": "NONE",
                "response": "I AM HEALTHY",
            })
        ```
        ### Region Health Check Grpc

        ```python
        import pulumi
        import pulumi_gcp as gcp

        grpc_region_health_check = gcp.compute.RegionHealthCheck("grpc-region-health-check",
            name="grpc-region-health-check",
            timeout_sec=1,
            check_interval_sec=1,
            grpc_health_check={
                "port": 443,
            })
        ```
        ### Region Health Check Grpc Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        grpc_region_health_check = gcp.compute.RegionHealthCheck("grpc-region-health-check",
            name="grpc-region-health-check",
            timeout_sec=1,
            check_interval_sec=1,
            grpc_health_check={
                "port_name": "health-check-port",
                "port_specification": "USE_NAMED_PORT",
                "grpc_service_name": "testservice",
            })
        ```
        ### Region Health Check Grpc With Tls

        ```python
        import pulumi
        import pulumi_gcp as gcp

        grpc_with_tls_region_health_check = gcp.compute.RegionHealthCheck("grpc-with-tls-region-health-check",
            name="grpc-with-tls-region-health-check",
            timeout_sec=1,
            check_interval_sec=1,
            grpc_tls_health_check={
                "port": 443,
            })
        ```
        ### Region Health Check Grpc With Tls Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        grpc_with_tls_region_health_check = gcp.compute.RegionHealthCheck("grpc-with-tls-region-health-check",
            name="grpc-with-tls-region-health-check",
            description="regional health check via GRPC with TLS",
            timeout_sec=1,
            check_interval_sec=1,
            healthy_threshold=4,
            unhealthy_threshold=5,
            grpc_tls_health_check={
                "port_specification": "USE_FIXED_PORT",
                "port": 443,
                "grpc_service_name": "testservice",
            })
        ```

        ## Import

        RegionHealthCheck can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/healthChecks/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, RegionHealthCheck can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/regionHealthCheck:RegionHealthCheck default projects/{{project}}/regions/{{region}}/healthChecks/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionHealthCheck:RegionHealthCheck default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionHealthCheck:RegionHealthCheck default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionHealthCheck:RegionHealthCheck default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] check_interval_sec: How often (in seconds) to send a health check. The default value is 5
               seconds.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[Union['RegionHealthCheckGrpcHealthCheckArgs', 'RegionHealthCheckGrpcHealthCheckArgsDict']] grpc_health_check: A nested object resource.
               Structure is documented below.
        :param pulumi.Input[Union['RegionHealthCheckGrpcTlsHealthCheckArgs', 'RegionHealthCheckGrpcTlsHealthCheckArgsDict']] grpc_tls_health_check: A nested object resource.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] healthy_threshold: A so-far unhealthy instance will be marked healthy after this many
               consecutive successes. The default value is 2.
        :param pulumi.Input[Union['RegionHealthCheckHttp2HealthCheckArgs', 'RegionHealthCheckHttp2HealthCheckArgsDict']] http2_health_check: A nested object resource.
               Structure is documented below.
        :param pulumi.Input[Union['RegionHealthCheckHttpHealthCheckArgs', 'RegionHealthCheckHttpHealthCheckArgsDict']] http_health_check: A nested object resource.
               Structure is documented below.
        :param pulumi.Input[Union['RegionHealthCheckHttpsHealthCheckArgs', 'RegionHealthCheckHttpsHealthCheckArgsDict']] https_health_check: A nested object resource.
               Structure is documented below.
        :param pulumi.Input[Union['RegionHealthCheckLogConfigArgs', 'RegionHealthCheckLogConfigArgsDict']] log_config: Configure logging on this health check.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035.  Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z?` which means
               the first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the
               last character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The Region in which the created health check should reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[Union['RegionHealthCheckSslHealthCheckArgs', 'RegionHealthCheckSslHealthCheckArgsDict']] ssl_health_check: A nested object resource.
               Structure is documented below.
        :param pulumi.Input[Union['RegionHealthCheckTcpHealthCheckArgs', 'RegionHealthCheckTcpHealthCheckArgsDict']] tcp_health_check: A nested object resource.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] timeout_sec: How long (in seconds) to wait before claiming failure.
               The default value is 5 seconds.  It is invalid for timeoutSec to have
               greater value than checkIntervalSec.
        :param pulumi.Input[_builtins.int] unhealthy_threshold: A so-far healthy instance will be marked unhealthy after this many
               consecutive failures. The default value is 2.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RegionHealthCheckArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Health Checks determine whether instances are responsive and able to do work.
        They are an important part of a comprehensive load balancing configuration,
        as they enable monitoring instances behind load balancers.

        Health Checks poll instances at a specified interval. Instances that
        do not respond successfully to some number of probes in a row are marked
        as unhealthy. No new connections are sent to unhealthy instances,
        though existing connections will continue. The health check will
        continue to poll unhealthy instances. If an instance later responds
        successfully to some number of consecutive probes, it is marked
        healthy again and can receive new connections.

        To get more information about RegionHealthCheck, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/regionHealthChecks)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/load-balancing/docs/health-checks)

        ## Example Usage

        ### Region Health Check Tcp

        ```python
        import pulumi
        import pulumi_gcp as gcp

        tcp_region_health_check = gcp.compute.RegionHealthCheck("tcp-region-health-check",
            name="tcp-region-health-check",
            timeout_sec=1,
            check_interval_sec=1,
            tcp_health_check={
                "port": 80,
            })
        ```
        ### Region Health Check Tcp Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        tcp_region_health_check = gcp.compute.RegionHealthCheck("tcp-region-health-check",
            name="tcp-region-health-check",
            description="Health check via tcp",
            timeout_sec=1,
            check_interval_sec=1,
            healthy_threshold=4,
            unhealthy_threshold=5,
            tcp_health_check={
                "port_name": "health-check-port",
                "port_specification": "USE_NAMED_PORT",
                "request": "ARE YOU HEALTHY?",
                "proxy_header": "NONE",
                "response": "I AM HEALTHY",
            })
        ```
        ### Region Health Check Ssl

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ssl_region_health_check = gcp.compute.RegionHealthCheck("ssl-region-health-check",
            name="ssl-region-health-check",
            timeout_sec=1,
            check_interval_sec=1,
            ssl_health_check={
                "port": 443,
            })
        ```
        ### Region Health Check Ssl Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ssl_region_health_check = gcp.compute.RegionHealthCheck("ssl-region-health-check",
            name="ssl-region-health-check",
            description="Health check via ssl",
            timeout_sec=1,
            check_interval_sec=1,
            healthy_threshold=4,
            unhealthy_threshold=5,
            ssl_health_check={
                "port_name": "health-check-port",
                "port_specification": "USE_NAMED_PORT",
                "request": "ARE YOU HEALTHY?",
                "proxy_header": "NONE",
                "response": "I AM HEALTHY",
            })
        ```
        ### Region Health Check Http

        ```python
        import pulumi
        import pulumi_gcp as gcp

        http_region_health_check = gcp.compute.RegionHealthCheck("http-region-health-check",
            name="http-region-health-check",
            timeout_sec=1,
            check_interval_sec=1,
            http_health_check={
                "port": 80,
            })
        ```
        ### Region Health Check Http Logs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        http_region_health_check = gcp.compute.RegionHealthCheck("http-region-health-check",
            name="http-region-health-check",
            timeout_sec=1,
            check_interval_sec=1,
            http_health_check={
                "port": 80,
            },
            log_config={
                "enable": True,
            })
        ```
        ### Region Health Check Http Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        http_region_health_check = gcp.compute.RegionHealthCheck("http-region-health-check",
            name="http-region-health-check",
            description="Health check via http",
            timeout_sec=1,
            check_interval_sec=1,
            healthy_threshold=4,
            unhealthy_threshold=5,
            http_health_check={
                "port_name": "health-check-port",
                "port_specification": "USE_NAMED_PORT",
                "host": "1.2.3.4",
                "request_path": "/mypath",
                "proxy_header": "NONE",
                "response": "I AM HEALTHY",
            })
        ```
        ### Region Health Check Https

        ```python
        import pulumi
        import pulumi_gcp as gcp

        https_region_health_check = gcp.compute.RegionHealthCheck("https-region-health-check",
            name="https-region-health-check",
            timeout_sec=1,
            check_interval_sec=1,
            https_health_check={
                "port": 443,
            })
        ```
        ### Region Health Check Https Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        https_region_health_check = gcp.compute.RegionHealthCheck("https-region-health-check",
            name="https-region-health-check",
            description="Health check via https",
            timeout_sec=1,
            check_interval_sec=1,
            healthy_threshold=4,
            unhealthy_threshold=5,
            https_health_check={
                "port_name": "health-check-port",
                "port_specification": "USE_NAMED_PORT",
                "host": "1.2.3.4",
                "request_path": "/mypath",
                "proxy_header": "NONE",
                "response": "I AM HEALTHY",
            })
        ```
        ### Region Health Check Http2

        ```python
        import pulumi
        import pulumi_gcp as gcp

        http2_region_health_check = gcp.compute.RegionHealthCheck("http2-region-health-check",
            name="http2-region-health-check",
            timeout_sec=1,
            check_interval_sec=1,
            http2_health_check={
                "port": 443,
            })
        ```
        ### Region Health Check Http2 Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        http2_region_health_check = gcp.compute.RegionHealthCheck("http2-region-health-check",
            name="http2-region-health-check",
            description="Health check via http2",
            timeout_sec=1,
            check_interval_sec=1,
            healthy_threshold=4,
            unhealthy_threshold=5,
            http2_health_check={
                "port_name": "health-check-port",
                "port_specification": "USE_NAMED_PORT",
                "host": "1.2.3.4",
                "request_path": "/mypath",
                "proxy_header": "NONE",
                "response": "I AM HEALTHY",
            })
        ```
        ### Region Health Check Grpc

        ```python
        import pulumi
        import pulumi_gcp as gcp

        grpc_region_health_check = gcp.compute.RegionHealthCheck("grpc-region-health-check",
            name="grpc-region-health-check",
            timeout_sec=1,
            check_interval_sec=1,
            grpc_health_check={
                "port": 443,
            })
        ```
        ### Region Health Check Grpc Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        grpc_region_health_check = gcp.compute.RegionHealthCheck("grpc-region-health-check",
            name="grpc-region-health-check",
            timeout_sec=1,
            check_interval_sec=1,
            grpc_health_check={
                "port_name": "health-check-port",
                "port_specification": "USE_NAMED_PORT",
                "grpc_service_name": "testservice",
            })
        ```
        ### Region Health Check Grpc With Tls

        ```python
        import pulumi
        import pulumi_gcp as gcp

        grpc_with_tls_region_health_check = gcp.compute.RegionHealthCheck("grpc-with-tls-region-health-check",
            name="grpc-with-tls-region-health-check",
            timeout_sec=1,
            check_interval_sec=1,
            grpc_tls_health_check={
                "port": 443,
            })
        ```
        ### Region Health Check Grpc With Tls Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        grpc_with_tls_region_health_check = gcp.compute.RegionHealthCheck("grpc-with-tls-region-health-check",
            name="grpc-with-tls-region-health-check",
            description="regional health check via GRPC with TLS",
            timeout_sec=1,
            check_interval_sec=1,
            healthy_threshold=4,
            unhealthy_threshold=5,
            grpc_tls_health_check={
                "port_specification": "USE_FIXED_PORT",
                "port": 443,
                "grpc_service_name": "testservice",
            })
        ```

        ## Import

        RegionHealthCheck can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/healthChecks/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, RegionHealthCheck can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/regionHealthCheck:RegionHealthCheck default projects/{{project}}/regions/{{region}}/healthChecks/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionHealthCheck:RegionHealthCheck default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionHealthCheck:RegionHealthCheck default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionHealthCheck:RegionHealthCheck default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param RegionHealthCheckArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegionHealthCheckArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 check_interval_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 grpc_health_check: Optional[pulumi.Input[Union['RegionHealthCheckGrpcHealthCheckArgs', 'RegionHealthCheckGrpcHealthCheckArgsDict']]] = None,
                 grpc_tls_health_check: Optional[pulumi.Input[Union['RegionHealthCheckGrpcTlsHealthCheckArgs', 'RegionHealthCheckGrpcTlsHealthCheckArgsDict']]] = None,
                 healthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 http2_health_check: Optional[pulumi.Input[Union['RegionHealthCheckHttp2HealthCheckArgs', 'RegionHealthCheckHttp2HealthCheckArgsDict']]] = None,
                 http_health_check: Optional[pulumi.Input[Union['RegionHealthCheckHttpHealthCheckArgs', 'RegionHealthCheckHttpHealthCheckArgsDict']]] = None,
                 https_health_check: Optional[pulumi.Input[Union['RegionHealthCheckHttpsHealthCheckArgs', 'RegionHealthCheckHttpsHealthCheckArgsDict']]] = None,
                 log_config: Optional[pulumi.Input[Union['RegionHealthCheckLogConfigArgs', 'RegionHealthCheckLogConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_health_check: Optional[pulumi.Input[Union['RegionHealthCheckSslHealthCheckArgs', 'RegionHealthCheckSslHealthCheckArgsDict']]] = None,
                 tcp_health_check: Optional[pulumi.Input[Union['RegionHealthCheckTcpHealthCheckArgs', 'RegionHealthCheckTcpHealthCheckArgsDict']]] = None,
                 timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegionHealthCheckArgs.__new__(RegionHealthCheckArgs)

            __props__.__dict__["check_interval_sec"] = check_interval_sec
            __props__.__dict__["description"] = description
            __props__.__dict__["grpc_health_check"] = grpc_health_check
            __props__.__dict__["grpc_tls_health_check"] = grpc_tls_health_check
            __props__.__dict__["healthy_threshold"] = healthy_threshold
            __props__.__dict__["http2_health_check"] = http2_health_check
            __props__.__dict__["http_health_check"] = http_health_check
            __props__.__dict__["https_health_check"] = https_health_check
            __props__.__dict__["log_config"] = log_config
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            __props__.__dict__["ssl_health_check"] = ssl_health_check
            __props__.__dict__["tcp_health_check"] = tcp_health_check
            __props__.__dict__["timeout_sec"] = timeout_sec
            __props__.__dict__["unhealthy_threshold"] = unhealthy_threshold
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["health_check_id"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["type"] = None
        super(RegionHealthCheck, __self__).__init__(
            'gcp:compute/regionHealthCheck:RegionHealthCheck',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            check_interval_sec: Optional[pulumi.Input[_builtins.int]] = None,
            creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            grpc_health_check: Optional[pulumi.Input[Union['RegionHealthCheckGrpcHealthCheckArgs', 'RegionHealthCheckGrpcHealthCheckArgsDict']]] = None,
            grpc_tls_health_check: Optional[pulumi.Input[Union['RegionHealthCheckGrpcTlsHealthCheckArgs', 'RegionHealthCheckGrpcTlsHealthCheckArgsDict']]] = None,
            health_check_id: Optional[pulumi.Input[_builtins.int]] = None,
            healthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
            http2_health_check: Optional[pulumi.Input[Union['RegionHealthCheckHttp2HealthCheckArgs', 'RegionHealthCheckHttp2HealthCheckArgsDict']]] = None,
            http_health_check: Optional[pulumi.Input[Union['RegionHealthCheckHttpHealthCheckArgs', 'RegionHealthCheckHttpHealthCheckArgsDict']]] = None,
            https_health_check: Optional[pulumi.Input[Union['RegionHealthCheckHttpsHealthCheckArgs', 'RegionHealthCheckHttpsHealthCheckArgsDict']]] = None,
            log_config: Optional[pulumi.Input[Union['RegionHealthCheckLogConfigArgs', 'RegionHealthCheckLogConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            self_link: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_health_check: Optional[pulumi.Input[Union['RegionHealthCheckSslHealthCheckArgs', 'RegionHealthCheckSslHealthCheckArgsDict']]] = None,
            tcp_health_check: Optional[pulumi.Input[Union['RegionHealthCheckTcpHealthCheckArgs', 'RegionHealthCheckTcpHealthCheckArgsDict']]] = None,
            timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            unhealthy_threshold: Optional[pulumi.Input[_builtins.int]] = None) -> 'RegionHealthCheck':
        """
        Get an existing RegionHealthCheck resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] check_interval_sec: How often (in seconds) to send a health check. The default value is 5
               seconds.
        :param pulumi.Input[_builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[Union['RegionHealthCheckGrpcHealthCheckArgs', 'RegionHealthCheckGrpcHealthCheckArgsDict']] grpc_health_check: A nested object resource.
               Structure is documented below.
        :param pulumi.Input[Union['RegionHealthCheckGrpcTlsHealthCheckArgs', 'RegionHealthCheckGrpcTlsHealthCheckArgsDict']] grpc_tls_health_check: A nested object resource.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] health_check_id: The unique identifier number for the resource. This identifier is defined by the server.
        :param pulumi.Input[_builtins.int] healthy_threshold: A so-far unhealthy instance will be marked healthy after this many
               consecutive successes. The default value is 2.
        :param pulumi.Input[Union['RegionHealthCheckHttp2HealthCheckArgs', 'RegionHealthCheckHttp2HealthCheckArgsDict']] http2_health_check: A nested object resource.
               Structure is documented below.
        :param pulumi.Input[Union['RegionHealthCheckHttpHealthCheckArgs', 'RegionHealthCheckHttpHealthCheckArgsDict']] http_health_check: A nested object resource.
               Structure is documented below.
        :param pulumi.Input[Union['RegionHealthCheckHttpsHealthCheckArgs', 'RegionHealthCheckHttpsHealthCheckArgsDict']] https_health_check: A nested object resource.
               Structure is documented below.
        :param pulumi.Input[Union['RegionHealthCheckLogConfigArgs', 'RegionHealthCheckLogConfigArgsDict']] log_config: Configure logging on this health check.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035.  Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z?` which means
               the first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the
               last character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The Region in which the created health check should reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[Union['RegionHealthCheckSslHealthCheckArgs', 'RegionHealthCheckSslHealthCheckArgsDict']] ssl_health_check: A nested object resource.
               Structure is documented below.
        :param pulumi.Input[Union['RegionHealthCheckTcpHealthCheckArgs', 'RegionHealthCheckTcpHealthCheckArgsDict']] tcp_health_check: A nested object resource.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] timeout_sec: How long (in seconds) to wait before claiming failure.
               The default value is 5 seconds.  It is invalid for timeoutSec to have
               greater value than checkIntervalSec.
        :param pulumi.Input[_builtins.str] type: The type of the health check. One of HTTP, HTTP2, HTTPS, TCP, or SSL.
        :param pulumi.Input[_builtins.int] unhealthy_threshold: A so-far healthy instance will be marked unhealthy after this many
               consecutive failures. The default value is 2.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegionHealthCheckState.__new__(_RegionHealthCheckState)

        __props__.__dict__["check_interval_sec"] = check_interval_sec
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["grpc_health_check"] = grpc_health_check
        __props__.__dict__["grpc_tls_health_check"] = grpc_tls_health_check
        __props__.__dict__["health_check_id"] = health_check_id
        __props__.__dict__["healthy_threshold"] = healthy_threshold
        __props__.__dict__["http2_health_check"] = http2_health_check
        __props__.__dict__["http_health_check"] = http_health_check
        __props__.__dict__["https_health_check"] = https_health_check
        __props__.__dict__["log_config"] = log_config
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["ssl_health_check"] = ssl_health_check
        __props__.__dict__["tcp_health_check"] = tcp_health_check
        __props__.__dict__["timeout_sec"] = timeout_sec
        __props__.__dict__["type"] = type
        __props__.__dict__["unhealthy_threshold"] = unhealthy_threshold
        return RegionHealthCheck(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="checkIntervalSec")
    def check_interval_sec(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        How often (in seconds) to send a health check. The default value is 5
        seconds.
        """
        return pulumi.get(self, "check_interval_sec")

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="grpcHealthCheck")
    def grpc_health_check(self) -> pulumi.Output[Optional['outputs.RegionHealthCheckGrpcHealthCheck']]:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "grpc_health_check")

    @_builtins.property
    @pulumi.getter(name="grpcTlsHealthCheck")
    def grpc_tls_health_check(self) -> pulumi.Output[Optional['outputs.RegionHealthCheckGrpcTlsHealthCheck']]:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "grpc_tls_health_check")

    @_builtins.property
    @pulumi.getter(name="healthCheckId")
    def health_check_id(self) -> pulumi.Output[_builtins.int]:
        """
        The unique identifier number for the resource. This identifier is defined by the server.
        """
        return pulumi.get(self, "health_check_id")

    @_builtins.property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        A so-far unhealthy instance will be marked healthy after this many
        consecutive successes. The default value is 2.
        """
        return pulumi.get(self, "healthy_threshold")

    @_builtins.property
    @pulumi.getter(name="http2HealthCheck")
    def http2_health_check(self) -> pulumi.Output[Optional['outputs.RegionHealthCheckHttp2HealthCheck']]:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "http2_health_check")

    @_builtins.property
    @pulumi.getter(name="httpHealthCheck")
    def http_health_check(self) -> pulumi.Output[Optional['outputs.RegionHealthCheckHttpHealthCheck']]:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "http_health_check")

    @_builtins.property
    @pulumi.getter(name="httpsHealthCheck")
    def https_health_check(self) -> pulumi.Output[Optional['outputs.RegionHealthCheckHttpsHealthCheck']]:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "https_health_check")

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> pulumi.Output['outputs.RegionHealthCheckLogConfig']:
        """
        Configure logging on this health check.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035.  Specifically, the name must be 1-63 characters long and
        match the regular expression `a-z?` which means
        the first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the
        last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The Region in which the created health check should reside.
        If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[_builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter(name="sslHealthCheck")
    def ssl_health_check(self) -> pulumi.Output[Optional['outputs.RegionHealthCheckSslHealthCheck']]:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "ssl_health_check")

    @_builtins.property
    @pulumi.getter(name="tcpHealthCheck")
    def tcp_health_check(self) -> pulumi.Output[Optional['outputs.RegionHealthCheckTcpHealthCheck']]:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "tcp_health_check")

    @_builtins.property
    @pulumi.getter(name="timeoutSec")
    def timeout_sec(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        How long (in seconds) to wait before claiming failure.
        The default value is 5 seconds.  It is invalid for timeoutSec to have
        greater value than checkIntervalSec.
        """
        return pulumi.get(self, "timeout_sec")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the health check. One of HTTP, HTTP2, HTTPS, TCP, or SSL.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        A so-far healthy instance will be marked unhealthy after this many
        consecutive failures. The default value is 2.
        """
        return pulumi.get(self, "unhealthy_threshold")

