# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RegionResizeRequestArgs', 'RegionResizeRequest']

@pulumi.input_type
class RegionResizeRequestArgs:
    def __init__(__self__, *,
                 instance_group_manager: pulumi.Input[_builtins.str],
                 resize_by: pulumi.Input[_builtins.int],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 requested_run_duration: Optional[pulumi.Input['RegionResizeRequestRequestedRunDurationArgs']] = None):
        """
        The set of arguments for constructing a RegionResizeRequest resource.
        :param pulumi.Input[_builtins.str] instance_group_manager: The reference of the regional instance group manager this ResizeRequest is a part of.
        :param pulumi.Input[_builtins.int] resize_by: The number of instances to be created by this resize request. The group's target size will be increased by this number.
        :param pulumi.Input[_builtins.str] description: An optional description of this resize-request.
        :param pulumi.Input[_builtins.str] name: The name of this resize request. The name must be 1-63 characters long, and comply with RFC1035.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The reference of the compute region scoping this request. If it is not provided, the provider region is used.
        :param pulumi.Input['RegionResizeRequestRequestedRunDurationArgs'] requested_run_duration: Requested run duration for instances that will be created by this request. At the end of the run duration instances will be deleted.
               Structure is documented below.
        """
        pulumi.set(__self__, "instance_group_manager", instance_group_manager)
        pulumi.set(__self__, "resize_by", resize_by)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if requested_run_duration is not None:
            pulumi.set(__self__, "requested_run_duration", requested_run_duration)

    @_builtins.property
    @pulumi.getter(name="instanceGroupManager")
    def instance_group_manager(self) -> pulumi.Input[_builtins.str]:
        """
        The reference of the regional instance group manager this ResizeRequest is a part of.
        """
        return pulumi.get(self, "instance_group_manager")

    @instance_group_manager.setter
    def instance_group_manager(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_group_manager", value)

    @_builtins.property
    @pulumi.getter(name="resizeBy")
    def resize_by(self) -> pulumi.Input[_builtins.int]:
        """
        The number of instances to be created by this resize request. The group's target size will be increased by this number.
        """
        return pulumi.get(self, "resize_by")

    @resize_by.setter
    def resize_by(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "resize_by", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resize-request.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of this resize request. The name must be 1-63 characters long, and comply with RFC1035.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reference of the compute region scoping this request. If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="requestedRunDuration")
    def requested_run_duration(self) -> Optional[pulumi.Input['RegionResizeRequestRequestedRunDurationArgs']]:
        """
        Requested run duration for instances that will be created by this request. At the end of the run duration instances will be deleted.
        Structure is documented below.
        """
        return pulumi.get(self, "requested_run_duration")

    @requested_run_duration.setter
    def requested_run_duration(self, value: Optional[pulumi.Input['RegionResizeRequestRequestedRunDurationArgs']]):
        pulumi.set(self, "requested_run_duration", value)


@pulumi.input_type
class _RegionResizeRequestState:
    def __init__(__self__, *,
                 creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_group_manager: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 requested_run_duration: Optional[pulumi.Input['RegionResizeRequestRequestedRunDurationArgs']] = None,
                 resize_by: Optional[pulumi.Input[_builtins.int]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['RegionResizeRequestStatusArgs']]]] = None):
        """
        Input properties used for looking up and filtering RegionResizeRequest resources.
        :param pulumi.Input[_builtins.str] creation_timestamp: The creation timestamp for this resize request in RFC3339 text format.
        :param pulumi.Input[_builtins.str] description: An optional description of this resize-request.
        :param pulumi.Input[_builtins.str] instance_group_manager: The reference of the regional instance group manager this ResizeRequest is a part of.
        :param pulumi.Input[_builtins.str] name: The name of this resize request. The name must be 1-63 characters long, and comply with RFC1035.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The reference of the compute region scoping this request. If it is not provided, the provider region is used.
        :param pulumi.Input['RegionResizeRequestRequestedRunDurationArgs'] requested_run_duration: Requested run duration for instances that will be created by this request. At the end of the run duration instances will be deleted.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] resize_by: The number of instances to be created by this resize request. The group's target size will be increased by this number.
        :param pulumi.Input[_builtins.str] state: Current state of the request.
        :param pulumi.Input[Sequence[pulumi.Input['RegionResizeRequestStatusArgs']]] statuses: Status of the request.
               Structure is documented below.
        """
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_group_manager is not None:
            pulumi.set(__self__, "instance_group_manager", instance_group_manager)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if requested_run_duration is not None:
            pulumi.set(__self__, "requested_run_duration", requested_run_duration)
        if resize_by is not None:
            pulumi.set(__self__, "resize_by", resize_by)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp for this resize request in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resize-request.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceGroupManager")
    def instance_group_manager(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reference of the regional instance group manager this ResizeRequest is a part of.
        """
        return pulumi.get(self, "instance_group_manager")

    @instance_group_manager.setter
    def instance_group_manager(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_group_manager", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of this resize request. The name must be 1-63 characters long, and comply with RFC1035.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reference of the compute region scoping this request. If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="requestedRunDuration")
    def requested_run_duration(self) -> Optional[pulumi.Input['RegionResizeRequestRequestedRunDurationArgs']]:
        """
        Requested run duration for instances that will be created by this request. At the end of the run duration instances will be deleted.
        Structure is documented below.
        """
        return pulumi.get(self, "requested_run_duration")

    @requested_run_duration.setter
    def requested_run_duration(self, value: Optional[pulumi.Input['RegionResizeRequestRequestedRunDurationArgs']]):
        pulumi.set(self, "requested_run_duration", value)

    @_builtins.property
    @pulumi.getter(name="resizeBy")
    def resize_by(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of instances to be created by this resize request. The group's target size will be increased by this number.
        """
        return pulumi.get(self, "resize_by")

    @resize_by.setter
    def resize_by(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "resize_by", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Current state of the request.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegionResizeRequestStatusArgs']]]]:
        """
        Status of the request.
        Structure is documented below.
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegionResizeRequestStatusArgs']]]]):
        pulumi.set(self, "statuses", value)


@pulumi.type_token("gcp:compute/regionResizeRequest:RegionResizeRequest")
class RegionResizeRequest(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_group_manager: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 requested_run_duration: Optional[pulumi.Input[Union['RegionResizeRequestRequestedRunDurationArgs', 'RegionResizeRequestRequestedRunDurationArgsDict']]] = None,
                 resize_by: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Represents a Regional Managed Instance Group Resize Request

        Resize Requests are the Managed Instance Group implementation of Dynamic Workload Scheduler Flex Start.

        With Dynamic Workload Scheduler in Flex Start mode, you submit a GPU capacity request for your AI/ML jobs by indicating how many you need, a duration, and your preferred region. Dynamic Workload Scheduler intelligently persists the request; once the capacity becomes available, it automatically provisions your VMs enabling your workloads to run continuously for the entire duration of the capacity allocation.

        To get more information about RegionResizeRequest, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/beta/regionInstanceGroupManagerResizeRequests)
        * How-to Guides
            * [About resize requests in a MIG](https://cloud.google.com/compute/docs/instance-groups/about-resize-requests-mig)

        ## Example Usage

        ### Compute Rmig Resize Request

        ```python
        import pulumi
        import pulumi_gcp as gcp

        a3_dws = gcp.compute.RegionInstanceTemplate("a3_dws",
            name="a3-dws",
            region="us-central1",
            description="This template is used to create a mig instance that is compatible with DWS resize requests.",
            instance_description="A3 GPU",
            machine_type="a3-highgpu-8g",
            can_ip_forward=False,
            scheduling={
                "automatic_restart": False,
                "on_host_maintenance": "TERMINATE",
            },
            disks=[{
                "source_image": "cos-cloud/cos-121-lts",
                "auto_delete": True,
                "boot": True,
                "disk_type": "pd-ssd",
                "disk_size_gb": 960,
                "mode": "READ_WRITE",
            }],
            guest_accelerators=[{
                "type": "nvidia-h100-80gb",
                "count": 8,
            }],
            reservation_affinity={
                "type": "NO_RESERVATION",
            },
            shielded_instance_config={
                "enable_vtpm": True,
                "enable_integrity_monitoring": True,
            },
            network_interfaces=[{
                "network": "default",
            }])
        a3_dws_region_instance_group_manager = gcp.compute.RegionInstanceGroupManager("a3_dws",
            name="a3-dws",
            base_instance_name="a3-dws",
            region="us-central1",
            versions=[{
                "instance_template": a3_dws.self_link,
            }],
            instance_lifecycle_policy={
                "default_action_on_failure": "DO_NOTHING",
            },
            distribution_policy_target_shape="ANY_SINGLE_ZONE",
            distribution_policy_zones=[
                "us-central1-a",
                "us-central1-b",
                "us-central1-c",
                "us-central1-f",
            ],
            update_policy={
                "instance_redistribution_type": "NONE",
                "type": "OPPORTUNISTIC",
                "minimal_action": "REPLACE",
                "max_surge_fixed": 0,
                "max_unavailable_fixed": 6,
            },
            wait_for_instances=False)
        a3_resize_request = gcp.compute.RegionResizeRequest("a3_resize_request",
            name="a3-dws",
            instance_group_manager=a3_dws_region_instance_group_manager.name,
            region="us-central1",
            description="Test resize request resource",
            resize_by=2,
            requested_run_duration={
                "seconds": "14400",
                "nanos": 0,
            })
        ```

        ## Import

        RegionResizeRequest can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/instanceGroupManagers/{{instance_group_manager}}/resizeRequests/{{name}}`

        * `{{project}}/{{region}}/{{instance_group_manager}}/{{name}}`

        * `{{region}}/{{instance_group_manager}}/{{name}}`

        * `{{instance_group_manager}}/{{name}}`

        When using the `pulumi import` command, RegionResizeRequest can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/regionResizeRequest:RegionResizeRequest default projects/{{project}}/regions/{{region}}/instanceGroupManagers/{{instance_group_manager}}/resizeRequests/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionResizeRequest:RegionResizeRequest default {{project}}/{{region}}/{{instance_group_manager}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionResizeRequest:RegionResizeRequest default {{region}}/{{instance_group_manager}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionResizeRequest:RegionResizeRequest default {{instance_group_manager}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: An optional description of this resize-request.
        :param pulumi.Input[_builtins.str] instance_group_manager: The reference of the regional instance group manager this ResizeRequest is a part of.
        :param pulumi.Input[_builtins.str] name: The name of this resize request. The name must be 1-63 characters long, and comply with RFC1035.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The reference of the compute region scoping this request. If it is not provided, the provider region is used.
        :param pulumi.Input[Union['RegionResizeRequestRequestedRunDurationArgs', 'RegionResizeRequestRequestedRunDurationArgsDict']] requested_run_duration: Requested run duration for instances that will be created by this request. At the end of the run duration instances will be deleted.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] resize_by: The number of instances to be created by this resize request. The group's target size will be increased by this number.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegionResizeRequestArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a Regional Managed Instance Group Resize Request

        Resize Requests are the Managed Instance Group implementation of Dynamic Workload Scheduler Flex Start.

        With Dynamic Workload Scheduler in Flex Start mode, you submit a GPU capacity request for your AI/ML jobs by indicating how many you need, a duration, and your preferred region. Dynamic Workload Scheduler intelligently persists the request; once the capacity becomes available, it automatically provisions your VMs enabling your workloads to run continuously for the entire duration of the capacity allocation.

        To get more information about RegionResizeRequest, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/beta/regionInstanceGroupManagerResizeRequests)
        * How-to Guides
            * [About resize requests in a MIG](https://cloud.google.com/compute/docs/instance-groups/about-resize-requests-mig)

        ## Example Usage

        ### Compute Rmig Resize Request

        ```python
        import pulumi
        import pulumi_gcp as gcp

        a3_dws = gcp.compute.RegionInstanceTemplate("a3_dws",
            name="a3-dws",
            region="us-central1",
            description="This template is used to create a mig instance that is compatible with DWS resize requests.",
            instance_description="A3 GPU",
            machine_type="a3-highgpu-8g",
            can_ip_forward=False,
            scheduling={
                "automatic_restart": False,
                "on_host_maintenance": "TERMINATE",
            },
            disks=[{
                "source_image": "cos-cloud/cos-121-lts",
                "auto_delete": True,
                "boot": True,
                "disk_type": "pd-ssd",
                "disk_size_gb": 960,
                "mode": "READ_WRITE",
            }],
            guest_accelerators=[{
                "type": "nvidia-h100-80gb",
                "count": 8,
            }],
            reservation_affinity={
                "type": "NO_RESERVATION",
            },
            shielded_instance_config={
                "enable_vtpm": True,
                "enable_integrity_monitoring": True,
            },
            network_interfaces=[{
                "network": "default",
            }])
        a3_dws_region_instance_group_manager = gcp.compute.RegionInstanceGroupManager("a3_dws",
            name="a3-dws",
            base_instance_name="a3-dws",
            region="us-central1",
            versions=[{
                "instance_template": a3_dws.self_link,
            }],
            instance_lifecycle_policy={
                "default_action_on_failure": "DO_NOTHING",
            },
            distribution_policy_target_shape="ANY_SINGLE_ZONE",
            distribution_policy_zones=[
                "us-central1-a",
                "us-central1-b",
                "us-central1-c",
                "us-central1-f",
            ],
            update_policy={
                "instance_redistribution_type": "NONE",
                "type": "OPPORTUNISTIC",
                "minimal_action": "REPLACE",
                "max_surge_fixed": 0,
                "max_unavailable_fixed": 6,
            },
            wait_for_instances=False)
        a3_resize_request = gcp.compute.RegionResizeRequest("a3_resize_request",
            name="a3-dws",
            instance_group_manager=a3_dws_region_instance_group_manager.name,
            region="us-central1",
            description="Test resize request resource",
            resize_by=2,
            requested_run_duration={
                "seconds": "14400",
                "nanos": 0,
            })
        ```

        ## Import

        RegionResizeRequest can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/instanceGroupManagers/{{instance_group_manager}}/resizeRequests/{{name}}`

        * `{{project}}/{{region}}/{{instance_group_manager}}/{{name}}`

        * `{{region}}/{{instance_group_manager}}/{{name}}`

        * `{{instance_group_manager}}/{{name}}`

        When using the `pulumi import` command, RegionResizeRequest can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/regionResizeRequest:RegionResizeRequest default projects/{{project}}/regions/{{region}}/instanceGroupManagers/{{instance_group_manager}}/resizeRequests/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionResizeRequest:RegionResizeRequest default {{project}}/{{region}}/{{instance_group_manager}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionResizeRequest:RegionResizeRequest default {{region}}/{{instance_group_manager}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionResizeRequest:RegionResizeRequest default {{instance_group_manager}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param RegionResizeRequestArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegionResizeRequestArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_group_manager: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 requested_run_duration: Optional[pulumi.Input[Union['RegionResizeRequestRequestedRunDurationArgs', 'RegionResizeRequestRequestedRunDurationArgsDict']]] = None,
                 resize_by: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegionResizeRequestArgs.__new__(RegionResizeRequestArgs)

            __props__.__dict__["description"] = description
            if instance_group_manager is None and not opts.urn:
                raise TypeError("Missing required property 'instance_group_manager'")
            __props__.__dict__["instance_group_manager"] = instance_group_manager
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            __props__.__dict__["requested_run_duration"] = requested_run_duration
            if resize_by is None and not opts.urn:
                raise TypeError("Missing required property 'resize_by'")
            __props__.__dict__["resize_by"] = resize_by
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["statuses"] = None
        super(RegionResizeRequest, __self__).__init__(
            'gcp:compute/regionResizeRequest:RegionResizeRequest',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            instance_group_manager: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            requested_run_duration: Optional[pulumi.Input[Union['RegionResizeRequestRequestedRunDurationArgs', 'RegionResizeRequestRequestedRunDurationArgsDict']]] = None,
            resize_by: Optional[pulumi.Input[_builtins.int]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionResizeRequestStatusArgs', 'RegionResizeRequestStatusArgsDict']]]]] = None) -> 'RegionResizeRequest':
        """
        Get an existing RegionResizeRequest resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] creation_timestamp: The creation timestamp for this resize request in RFC3339 text format.
        :param pulumi.Input[_builtins.str] description: An optional description of this resize-request.
        :param pulumi.Input[_builtins.str] instance_group_manager: The reference of the regional instance group manager this ResizeRequest is a part of.
        :param pulumi.Input[_builtins.str] name: The name of this resize request. The name must be 1-63 characters long, and comply with RFC1035.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The reference of the compute region scoping this request. If it is not provided, the provider region is used.
        :param pulumi.Input[Union['RegionResizeRequestRequestedRunDurationArgs', 'RegionResizeRequestRequestedRunDurationArgsDict']] requested_run_duration: Requested run duration for instances that will be created by this request. At the end of the run duration instances will be deleted.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] resize_by: The number of instances to be created by this resize request. The group's target size will be increased by this number.
        :param pulumi.Input[_builtins.str] state: Current state of the request.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegionResizeRequestStatusArgs', 'RegionResizeRequestStatusArgsDict']]]] statuses: Status of the request.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegionResizeRequestState.__new__(_RegionResizeRequestState)

        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["instance_group_manager"] = instance_group_manager
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["requested_run_duration"] = requested_run_duration
        __props__.__dict__["resize_by"] = resize_by
        __props__.__dict__["state"] = state
        __props__.__dict__["statuses"] = statuses
        return RegionResizeRequest(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp for this resize request in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An optional description of this resize-request.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="instanceGroupManager")
    def instance_group_manager(self) -> pulumi.Output[_builtins.str]:
        """
        The reference of the regional instance group manager this ResizeRequest is a part of.
        """
        return pulumi.get(self, "instance_group_manager")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of this resize request. The name must be 1-63 characters long, and comply with RFC1035.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The reference of the compute region scoping this request. If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="requestedRunDuration")
    def requested_run_duration(self) -> pulumi.Output[Optional['outputs.RegionResizeRequestRequestedRunDuration']]:
        """
        Requested run duration for instances that will be created by this request. At the end of the run duration instances will be deleted.
        Structure is documented below.
        """
        return pulumi.get(self, "requested_run_duration")

    @_builtins.property
    @pulumi.getter(name="resizeBy")
    def resize_by(self) -> pulumi.Output[_builtins.int]:
        """
        The number of instances to be created by this resize request. The group's target size will be increased by this number.
        """
        return pulumi.get(self, "resize_by")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        Current state of the request.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence['outputs.RegionResizeRequestStatus']]:
        """
        Status of the request.
        Structure is documented below.
        """
        return pulumi.get(self, "statuses")

