# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPolicyTagIamPolicyResult',
    'AwaitableGetPolicyTagIamPolicyResult',
    'get_policy_tag_iam_policy',
    'get_policy_tag_iam_policy_output',
]

@pulumi.output_type
class GetPolicyTagIamPolicyResult:
    """
    A collection of values returned by getPolicyTagIamPolicy.
    """
    def __init__(__self__, etag=None, id=None, policy_data=None, policy_tag=None):
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)
        if policy_tag and not isinstance(policy_tag, str):
            raise TypeError("Expected argument 'policy_tag' to be a str")
        pulumi.set(__self__, "policy_tag", policy_tag)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> _builtins.str:
        """
        (Required only by `datacatalog.PolicyTagIamPolicy`) The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @_builtins.property
    @pulumi.getter(name="policyTag")
    def policy_tag(self) -> _builtins.str:
        return pulumi.get(self, "policy_tag")


class AwaitableGetPolicyTagIamPolicyResult(GetPolicyTagIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPolicyTagIamPolicyResult(
            etag=self.etag,
            id=self.id,
            policy_data=self.policy_data,
            policy_tag=self.policy_tag)


def get_policy_tag_iam_policy(policy_tag: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPolicyTagIamPolicyResult:
    """
    Retrieves the current IAM policy data for policytag

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.datacatalog.get_policy_tag_iam_policy(policy_tag=basic_policy_tag["name"])
    ```


    :param _builtins.str policy_tag: Used to find the parent resource to bind the IAM policy to
    """
    __args__ = dict()
    __args__['policyTag'] = policy_tag
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:datacatalog/getPolicyTagIamPolicy:getPolicyTagIamPolicy', __args__, opts=opts, typ=GetPolicyTagIamPolicyResult).value

    return AwaitableGetPolicyTagIamPolicyResult(
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        policy_data=pulumi.get(__ret__, 'policy_data'),
        policy_tag=pulumi.get(__ret__, 'policy_tag'))
def get_policy_tag_iam_policy_output(policy_tag: Optional[pulumi.Input[_builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPolicyTagIamPolicyResult]:
    """
    Retrieves the current IAM policy data for policytag

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.datacatalog.get_policy_tag_iam_policy(policy_tag=basic_policy_tag["name"])
    ```


    :param _builtins.str policy_tag: Used to find the parent resource to bind the IAM policy to
    """
    __args__ = dict()
    __args__['policyTag'] = policy_tag
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:datacatalog/getPolicyTagIamPolicy:getPolicyTagIamPolicy', __args__, opts=opts, typ=GetPolicyTagIamPolicyResult)
    return __ret__.apply(lambda __response__: GetPolicyTagIamPolicyResult(
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        policy_data=pulumi.get(__response__, 'policy_data'),
        policy_tag=pulumi.get(__response__, 'policy_tag')))
