# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GdcSparkApplicationArgs', 'GdcSparkApplication']

@pulumi.input_type
class GdcSparkApplicationArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 serviceinstance: pulumi.Input[_builtins.str],
                 spark_application_id: pulumi.Input[_builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 application_environment: Optional[pulumi.Input[_builtins.str]] = None,
                 dependency_images: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 pyspark_application_config: Optional[pulumi.Input['GdcSparkApplicationPysparkApplicationConfigArgs']] = None,
                 spark_application_config: Optional[pulumi.Input['GdcSparkApplicationSparkApplicationConfigArgs']] = None,
                 spark_r_application_config: Optional[pulumi.Input['GdcSparkApplicationSparkRApplicationConfigArgs']] = None,
                 spark_sql_application_config: Optional[pulumi.Input['GdcSparkApplicationSparkSqlApplicationConfigArgs']] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GdcSparkApplication resource.
        :param pulumi.Input[_builtins.str] location: The location of the spark application.
        :param pulumi.Input[_builtins.str] serviceinstance: The id of the service instance to which this spark application belongs.
        :param pulumi.Input[_builtins.str] spark_application_id: The id of the application
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: The annotations to associate with this application. Annotations may be used to store client information, but are not used by the server.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] application_environment: An ApplicationEnvironment from which to inherit configuration properties.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dependency_images: List of container image uris for additional file dependencies. Dependent files are sequentially copied from each image. If a file with the same name exists in 2 images then the file from later image is used.
        :param pulumi.Input[_builtins.str] display_name: User-provided human-readable name to be used in user interfaces.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels to associate with this application. Labels may be used for filtering and billing tracking.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] namespace: The Kubernetes namespace in which to create the application. This namespace must already exist on the cluster.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: application-specific properties.
        :param pulumi.Input['GdcSparkApplicationPysparkApplicationConfigArgs'] pyspark_application_config: Represents the PySparkApplicationConfig.
               Structure is documented below.
        :param pulumi.Input['GdcSparkApplicationSparkApplicationConfigArgs'] spark_application_config: Represents the SparkApplicationConfig.
               Structure is documented below.
        :param pulumi.Input['GdcSparkApplicationSparkRApplicationConfigArgs'] spark_r_application_config: Represents the SparkRApplicationConfig.
               Structure is documented below.
        :param pulumi.Input['GdcSparkApplicationSparkSqlApplicationConfigArgs'] spark_sql_application_config: Represents the SparkRApplicationConfig.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] version: The Dataproc version of this application.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "serviceinstance", serviceinstance)
        pulumi.set(__self__, "spark_application_id", spark_application_id)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if application_environment is not None:
            pulumi.set(__self__, "application_environment", application_environment)
        if dependency_images is not None:
            pulumi.set(__self__, "dependency_images", dependency_images)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if pyspark_application_config is not None:
            pulumi.set(__self__, "pyspark_application_config", pyspark_application_config)
        if spark_application_config is not None:
            pulumi.set(__self__, "spark_application_config", spark_application_config)
        if spark_r_application_config is not None:
            pulumi.set(__self__, "spark_r_application_config", spark_r_application_config)
        if spark_sql_application_config is not None:
            pulumi.set(__self__, "spark_sql_application_config", spark_sql_application_config)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location of the spark application.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def serviceinstance(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the service instance to which this spark application belongs.
        """
        return pulumi.get(self, "serviceinstance")

    @serviceinstance.setter
    def serviceinstance(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "serviceinstance", value)

    @_builtins.property
    @pulumi.getter(name="sparkApplicationId")
    def spark_application_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the application
        """
        return pulumi.get(self, "spark_application_id")

    @spark_application_id.setter
    def spark_application_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "spark_application_id", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The annotations to associate with this application. Annotations may be used to store client information, but are not used by the server.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="applicationEnvironment")
    def application_environment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An ApplicationEnvironment from which to inherit configuration properties.
        """
        return pulumi.get(self, "application_environment")

    @application_environment.setter
    def application_environment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_environment", value)

    @_builtins.property
    @pulumi.getter(name="dependencyImages")
    def dependency_images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of container image uris for additional file dependencies. Dependent files are sequentially copied from each image. If a file with the same name exists in 2 images then the file from later image is used.
        """
        return pulumi.get(self, "dependency_images")

    @dependency_images.setter
    def dependency_images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dependency_images", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-provided human-readable name to be used in user interfaces.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The labels to associate with this application. Labels may be used for filtering and billing tracking.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Kubernetes namespace in which to create the application. This namespace must already exist on the cluster.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        application-specific properties.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter(name="pysparkApplicationConfig")
    def pyspark_application_config(self) -> Optional[pulumi.Input['GdcSparkApplicationPysparkApplicationConfigArgs']]:
        """
        Represents the PySparkApplicationConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "pyspark_application_config")

    @pyspark_application_config.setter
    def pyspark_application_config(self, value: Optional[pulumi.Input['GdcSparkApplicationPysparkApplicationConfigArgs']]):
        pulumi.set(self, "pyspark_application_config", value)

    @_builtins.property
    @pulumi.getter(name="sparkApplicationConfig")
    def spark_application_config(self) -> Optional[pulumi.Input['GdcSparkApplicationSparkApplicationConfigArgs']]:
        """
        Represents the SparkApplicationConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "spark_application_config")

    @spark_application_config.setter
    def spark_application_config(self, value: Optional[pulumi.Input['GdcSparkApplicationSparkApplicationConfigArgs']]):
        pulumi.set(self, "spark_application_config", value)

    @_builtins.property
    @pulumi.getter(name="sparkRApplicationConfig")
    def spark_r_application_config(self) -> Optional[pulumi.Input['GdcSparkApplicationSparkRApplicationConfigArgs']]:
        """
        Represents the SparkRApplicationConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "spark_r_application_config")

    @spark_r_application_config.setter
    def spark_r_application_config(self, value: Optional[pulumi.Input['GdcSparkApplicationSparkRApplicationConfigArgs']]):
        pulumi.set(self, "spark_r_application_config", value)

    @_builtins.property
    @pulumi.getter(name="sparkSqlApplicationConfig")
    def spark_sql_application_config(self) -> Optional[pulumi.Input['GdcSparkApplicationSparkSqlApplicationConfigArgs']]:
        """
        Represents the SparkRApplicationConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "spark_sql_application_config")

    @spark_sql_application_config.setter
    def spark_sql_application_config(self, value: Optional[pulumi.Input['GdcSparkApplicationSparkSqlApplicationConfigArgs']]):
        pulumi.set(self, "spark_sql_application_config", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Dataproc version of this application.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _GdcSparkApplicationState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 application_environment: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 dependency_images: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 monitoring_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 output_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 pyspark_application_config: Optional[pulumi.Input['GdcSparkApplicationPysparkApplicationConfigArgs']] = None,
                 reconciling: Optional[pulumi.Input[_builtins.bool]] = None,
                 serviceinstance: Optional[pulumi.Input[_builtins.str]] = None,
                 spark_application_config: Optional[pulumi.Input['GdcSparkApplicationSparkApplicationConfigArgs']] = None,
                 spark_application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spark_r_application_config: Optional[pulumi.Input['GdcSparkApplicationSparkRApplicationConfigArgs']] = None,
                 spark_sql_application_config: Optional[pulumi.Input['GdcSparkApplicationSparkSqlApplicationConfigArgs']] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 state_message: Optional[pulumi.Input[_builtins.str]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GdcSparkApplication resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: The annotations to associate with this application. Annotations may be used to store client information, but are not used by the server.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] application_environment: An ApplicationEnvironment from which to inherit configuration properties.
        :param pulumi.Input[_builtins.str] create_time: The timestamp when the resource was created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dependency_images: List of container image uris for additional file dependencies. Dependent files are sequentially copied from each image. If a file with the same name exists in 2 images then the file from later image is used.
        :param pulumi.Input[_builtins.str] display_name: User-provided human-readable name to be used in user interfaces.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels to associate with this application. Labels may be used for filtering and billing tracking.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location of the spark application.
        :param pulumi.Input[_builtins.str] monitoring_endpoint: URL for a monitoring UI for this application (for eventual Spark PHS/UI support) Out of scope for private GA
        :param pulumi.Input[_builtins.str] name: Identifier. The name of the application. Format: projects/{project}/locations/{location}/serviceInstances/{service_instance}/sparkApplications/{application}
        :param pulumi.Input[_builtins.str] namespace: The Kubernetes namespace in which to create the application. This namespace must already exist on the cluster.
        :param pulumi.Input[_builtins.str] output_uri: An HCFS URI pointing to the location of stdout and stdout of the application Mainly useful for Pantheon and gcloud Not in scope for private GA
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: application-specific properties.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input['GdcSparkApplicationPysparkApplicationConfigArgs'] pyspark_application_config: Represents the PySparkApplicationConfig.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] reconciling: Whether the application is currently reconciling. True if the current state of the resource does not match the intended state, and the system is working to reconcile them, whether or not the change was user initiated.
        :param pulumi.Input[_builtins.str] serviceinstance: The id of the service instance to which this spark application belongs.
        :param pulumi.Input['GdcSparkApplicationSparkApplicationConfigArgs'] spark_application_config: Represents the SparkApplicationConfig.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] spark_application_id: The id of the application
        :param pulumi.Input['GdcSparkApplicationSparkRApplicationConfigArgs'] spark_r_application_config: Represents the SparkRApplicationConfig.
               Structure is documented below.
        :param pulumi.Input['GdcSparkApplicationSparkSqlApplicationConfigArgs'] spark_sql_application_config: Represents the SparkRApplicationConfig.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] state: The current state.
               Possible values:
               * `STATE_UNSPECIFIED`
               * `PENDING`
               * `RUNNING`
               * `CANCELLING`
               * `CANCELLED`
               * `SUCCEEDED`
               * `FAILED`
        :param pulumi.Input[_builtins.str] state_message: A message explaining the current state.
        :param pulumi.Input[_builtins.str] uid: System generated unique identifier for this application, formatted as UUID4.
        :param pulumi.Input[_builtins.str] update_time: The timestamp when the resource was most recently updated.
        :param pulumi.Input[_builtins.str] version: The Dataproc version of this application.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if application_environment is not None:
            pulumi.set(__self__, "application_environment", application_environment)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if dependency_images is not None:
            pulumi.set(__self__, "dependency_images", dependency_images)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if monitoring_endpoint is not None:
            pulumi.set(__self__, "monitoring_endpoint", monitoring_endpoint)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if output_uri is not None:
            pulumi.set(__self__, "output_uri", output_uri)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if pyspark_application_config is not None:
            pulumi.set(__self__, "pyspark_application_config", pyspark_application_config)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if serviceinstance is not None:
            pulumi.set(__self__, "serviceinstance", serviceinstance)
        if spark_application_config is not None:
            pulumi.set(__self__, "spark_application_config", spark_application_config)
        if spark_application_id is not None:
            pulumi.set(__self__, "spark_application_id", spark_application_id)
        if spark_r_application_config is not None:
            pulumi.set(__self__, "spark_r_application_config", spark_r_application_config)
        if spark_sql_application_config is not None:
            pulumi.set(__self__, "spark_sql_application_config", spark_sql_application_config)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_message is not None:
            pulumi.set(__self__, "state_message", state_message)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The annotations to associate with this application. Annotations may be used to store client information, but are not used by the server.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="applicationEnvironment")
    def application_environment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An ApplicationEnvironment from which to inherit configuration properties.
        """
        return pulumi.get(self, "application_environment")

    @application_environment.setter
    def application_environment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_environment", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="dependencyImages")
    def dependency_images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of container image uris for additional file dependencies. Dependent files are sequentially copied from each image. If a file with the same name exists in 2 images then the file from later image is used.
        """
        return pulumi.get(self, "dependency_images")

    @dependency_images.setter
    def dependency_images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dependency_images", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-provided human-readable name to be used in user interfaces.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The labels to associate with this application. Labels may be used for filtering and billing tracking.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the spark application.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="monitoringEndpoint")
    def monitoring_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL for a monitoring UI for this application (for eventual Spark PHS/UI support) Out of scope for private GA
        """
        return pulumi.get(self, "monitoring_endpoint")

    @monitoring_endpoint.setter
    def monitoring_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "monitoring_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. The name of the application. Format: projects/{project}/locations/{location}/serviceInstances/{service_instance}/sparkApplications/{application}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Kubernetes namespace in which to create the application. This namespace must already exist on the cluster.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="outputUri")
    def output_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An HCFS URI pointing to the location of stdout and stdout of the application Mainly useful for Pantheon and gcloud Not in scope for private GA
        """
        return pulumi.get(self, "output_uri")

    @output_uri.setter
    def output_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_uri", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        application-specific properties.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="pysparkApplicationConfig")
    def pyspark_application_config(self) -> Optional[pulumi.Input['GdcSparkApplicationPysparkApplicationConfigArgs']]:
        """
        Represents the PySparkApplicationConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "pyspark_application_config")

    @pyspark_application_config.setter
    def pyspark_application_config(self, value: Optional[pulumi.Input['GdcSparkApplicationPysparkApplicationConfigArgs']]):
        pulumi.set(self, "pyspark_application_config", value)

    @_builtins.property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the application is currently reconciling. True if the current state of the resource does not match the intended state, and the system is working to reconcile them, whether or not the change was user initiated.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reconciling", value)

    @_builtins.property
    @pulumi.getter
    def serviceinstance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the service instance to which this spark application belongs.
        """
        return pulumi.get(self, "serviceinstance")

    @serviceinstance.setter
    def serviceinstance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "serviceinstance", value)

    @_builtins.property
    @pulumi.getter(name="sparkApplicationConfig")
    def spark_application_config(self) -> Optional[pulumi.Input['GdcSparkApplicationSparkApplicationConfigArgs']]:
        """
        Represents the SparkApplicationConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "spark_application_config")

    @spark_application_config.setter
    def spark_application_config(self, value: Optional[pulumi.Input['GdcSparkApplicationSparkApplicationConfigArgs']]):
        pulumi.set(self, "spark_application_config", value)

    @_builtins.property
    @pulumi.getter(name="sparkApplicationId")
    def spark_application_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the application
        """
        return pulumi.get(self, "spark_application_id")

    @spark_application_id.setter
    def spark_application_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spark_application_id", value)

    @_builtins.property
    @pulumi.getter(name="sparkRApplicationConfig")
    def spark_r_application_config(self) -> Optional[pulumi.Input['GdcSparkApplicationSparkRApplicationConfigArgs']]:
        """
        Represents the SparkRApplicationConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "spark_r_application_config")

    @spark_r_application_config.setter
    def spark_r_application_config(self, value: Optional[pulumi.Input['GdcSparkApplicationSparkRApplicationConfigArgs']]):
        pulumi.set(self, "spark_r_application_config", value)

    @_builtins.property
    @pulumi.getter(name="sparkSqlApplicationConfig")
    def spark_sql_application_config(self) -> Optional[pulumi.Input['GdcSparkApplicationSparkSqlApplicationConfigArgs']]:
        """
        Represents the SparkRApplicationConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "spark_sql_application_config")

    @spark_sql_application_config.setter
    def spark_sql_application_config(self, value: Optional[pulumi.Input['GdcSparkApplicationSparkSqlApplicationConfigArgs']]):
        pulumi.set(self, "spark_sql_application_config", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state.
        Possible values:
        * `STATE_UNSPECIFIED`
        * `PENDING`
        * `RUNNING`
        * `CANCELLING`
        * `CANCELLED`
        * `SUCCEEDED`
        * `FAILED`
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message explaining the current state.
        """
        return pulumi.get(self, "state_message")

    @state_message.setter
    def state_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state_message", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        System generated unique identifier for this application, formatted as UUID4.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp when the resource was most recently updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Dataproc version of this application.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("gcp:dataproc/gdcSparkApplication:GdcSparkApplication")
class GdcSparkApplication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 application_environment: Optional[pulumi.Input[_builtins.str]] = None,
                 dependency_images: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 pyspark_application_config: Optional[pulumi.Input[Union['GdcSparkApplicationPysparkApplicationConfigArgs', 'GdcSparkApplicationPysparkApplicationConfigArgsDict']]] = None,
                 serviceinstance: Optional[pulumi.Input[_builtins.str]] = None,
                 spark_application_config: Optional[pulumi.Input[Union['GdcSparkApplicationSparkApplicationConfigArgs', 'GdcSparkApplicationSparkApplicationConfigArgsDict']]] = None,
                 spark_application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spark_r_application_config: Optional[pulumi.Input[Union['GdcSparkApplicationSparkRApplicationConfigArgs', 'GdcSparkApplicationSparkRApplicationConfigArgsDict']]] = None,
                 spark_sql_application_config: Optional[pulumi.Input[Union['GdcSparkApplicationSparkSqlApplicationConfigArgs', 'GdcSparkApplicationSparkSqlApplicationConfigArgsDict']]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A Spark application is a single Spark workload run on a GDC cluster.

        To get more information about SparkApplication, see:

        * [API documentation](https://cloud.google.com/dataproc-gdc/docs/reference/rest/v1/projects.locations.serviceInstances.sparkApplications)
        * How-to Guides
            * [Dataproc Intro](https://cloud.google.com/dataproc/)

        ## Example Usage

        ### Dataprocgdc Sparkapplication Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        spark_application = gcp.dataproc.GdcSparkApplication("spark-application",
            spark_application_id="tf-e2e-spark-app-basic",
            serviceinstance="do-not-delete-dataproc-gdc-instance",
            project="my-project",
            location="us-west2",
            namespace="default",
            spark_application_config={
                "main_class": "org.apache.spark.examples.SparkPi",
                "jar_file_uris": ["file:///usr/lib/spark/examples/jars/spark-examples.jar"],
                "args": ["10000"],
            })
        ```
        ### Dataprocgdc Sparkapplication

        ```python
        import pulumi
        import pulumi_gcp as gcp

        app_env = gcp.dataproc.GdcApplicationEnvironment("app_env",
            application_environment_id="tf-e2e-spark-app-env",
            serviceinstance="do-not-delete-dataproc-gdc-instance",
            project="my-project",
            location="us-west2",
            namespace="default")
        spark_application = gcp.dataproc.GdcSparkApplication("spark-application",
            spark_application_id="tf-e2e-spark-app",
            serviceinstance="do-not-delete-dataproc-gdc-instance",
            project="my-project",
            location="us-west2",
            namespace="default",
            labels={
                "test-label": "label-value",
            },
            annotations={
                "an_annotation": "annotation_value",
            },
            properties={
                "spark.executor.instances": "2",
            },
            application_environment=app_env.name,
            version="1.2",
            spark_application_config={
                "main_jar_file_uri": "file:///usr/lib/spark/examples/jars/spark-examples.jar",
                "jar_file_uris": ["file:///usr/lib/spark/examples/jars/spark-examples.jar"],
                "archive_uris": ["file://usr/lib/spark/examples/spark-examples.jar"],
                "file_uris": ["file:///usr/lib/spark/examples/jars/spark-examples.jar"],
            })
        ```
        ### Dataprocgdc Sparkapplication Pyspark

        ```python
        import pulumi
        import pulumi_gcp as gcp

        spark_application = gcp.dataproc.GdcSparkApplication("spark-application",
            spark_application_id="tf-e2e-pyspark-app",
            serviceinstance="do-not-delete-dataproc-gdc-instance",
            project="my-project",
            location="us-west2",
            namespace="default",
            display_name="A Pyspark application for a Terraform create test",
            dependency_images=["gcr.io/some/image"],
            pyspark_application_config={
                "main_python_file_uri": "gs://goog-dataproc-initialization-actions-us-west2/conda/test_conda.py",
                "jar_file_uris": ["file:///usr/lib/spark/examples/jars/spark-examples.jar"],
                "python_file_uris": ["gs://goog-dataproc-initialization-actions-us-west2/conda/get-sys-exec.py"],
                "file_uris": ["file://usr/lib/spark/examples/spark-examples.jar"],
                "archive_uris": ["file://usr/lib/spark/examples/spark-examples.jar"],
                "args": ["10"],
            })
        ```
        ### Dataprocgdc Sparkapplication Sparkr

        ```python
        import pulumi
        import pulumi_gcp as gcp

        spark_application = gcp.dataproc.GdcSparkApplication("spark-application",
            spark_application_id="tf-e2e-sparkr-app",
            serviceinstance="do-not-delete-dataproc-gdc-instance",
            project="my-project",
            location="us-west2",
            namespace="default",
            display_name="A SparkR application for a Terraform create test",
            spark_r_application_config={
                "main_r_file_uri": "gs://some-bucket/something.R",
                "file_uris": ["file://usr/lib/spark/examples/spark-examples.jar"],
                "archive_uris": ["file://usr/lib/spark/examples/spark-examples.jar"],
                "args": ["10"],
            })
        ```
        ### Dataprocgdc Sparkapplication Sparksql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        spark_application = gcp.dataproc.GdcSparkApplication("spark-application",
            spark_application_id="tf-e2e-sparksql-app",
            serviceinstance="do-not-delete-dataproc-gdc-instance",
            project="my-project",
            location="us-west2",
            namespace="default",
            display_name="A SparkSql application for a Terraform create test",
            spark_sql_application_config={
                "jar_file_uris": ["file:///usr/lib/spark/examples/jars/spark-examples.jar"],
                "query_list": {
                    "queries": ["show tables;"],
                },
                "script_variables": {
                    "MY_VAR": "1",
                },
            })
        ```
        ### Dataprocgdc Sparkapplication Sparksql Query File

        ```python
        import pulumi
        import pulumi_gcp as gcp

        spark_application = gcp.dataproc.GdcSparkApplication("spark-application",
            spark_application_id="tf-e2e-sparksql-app",
            serviceinstance="do-not-delete-dataproc-gdc-instance",
            project="my-project",
            location="us-west2",
            namespace="default",
            display_name="A SparkSql application for a Terraform create test",
            spark_sql_application_config={
                "jar_file_uris": ["file:///usr/lib/spark/examples/jars/spark-examples.jar"],
                "query_file_uri": "gs://some-bucket/something.sql",
                "script_variables": {
                    "MY_VAR": "1",
                },
            })
        ```

        ## Import

        SparkApplication can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/serviceInstances/{{serviceinstance}}/sparkApplications/{{spark_application_id}}`

        * `{{project}}/{{location}}/{{serviceinstance}}/{{spark_application_id}}`

        * `{{location}}/{{serviceinstance}}/{{spark_application_id}}`

        When using the `pulumi import` command, SparkApplication can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataproc/gdcSparkApplication:GdcSparkApplication default projects/{{project}}/locations/{{location}}/serviceInstances/{{serviceinstance}}/sparkApplications/{{spark_application_id}}
        ```

        ```sh
        $ pulumi import gcp:dataproc/gdcSparkApplication:GdcSparkApplication default {{project}}/{{location}}/{{serviceinstance}}/{{spark_application_id}}
        ```

        ```sh
        $ pulumi import gcp:dataproc/gdcSparkApplication:GdcSparkApplication default {{location}}/{{serviceinstance}}/{{spark_application_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: The annotations to associate with this application. Annotations may be used to store client information, but are not used by the server.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] application_environment: An ApplicationEnvironment from which to inherit configuration properties.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dependency_images: List of container image uris for additional file dependencies. Dependent files are sequentially copied from each image. If a file with the same name exists in 2 images then the file from later image is used.
        :param pulumi.Input[_builtins.str] display_name: User-provided human-readable name to be used in user interfaces.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels to associate with this application. Labels may be used for filtering and billing tracking.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location of the spark application.
        :param pulumi.Input[_builtins.str] namespace: The Kubernetes namespace in which to create the application. This namespace must already exist on the cluster.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: application-specific properties.
        :param pulumi.Input[Union['GdcSparkApplicationPysparkApplicationConfigArgs', 'GdcSparkApplicationPysparkApplicationConfigArgsDict']] pyspark_application_config: Represents the PySparkApplicationConfig.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] serviceinstance: The id of the service instance to which this spark application belongs.
        :param pulumi.Input[Union['GdcSparkApplicationSparkApplicationConfigArgs', 'GdcSparkApplicationSparkApplicationConfigArgsDict']] spark_application_config: Represents the SparkApplicationConfig.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] spark_application_id: The id of the application
        :param pulumi.Input[Union['GdcSparkApplicationSparkRApplicationConfigArgs', 'GdcSparkApplicationSparkRApplicationConfigArgsDict']] spark_r_application_config: Represents the SparkRApplicationConfig.
               Structure is documented below.
        :param pulumi.Input[Union['GdcSparkApplicationSparkSqlApplicationConfigArgs', 'GdcSparkApplicationSparkSqlApplicationConfigArgsDict']] spark_sql_application_config: Represents the SparkRApplicationConfig.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] version: The Dataproc version of this application.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GdcSparkApplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Spark application is a single Spark workload run on a GDC cluster.

        To get more information about SparkApplication, see:

        * [API documentation](https://cloud.google.com/dataproc-gdc/docs/reference/rest/v1/projects.locations.serviceInstances.sparkApplications)
        * How-to Guides
            * [Dataproc Intro](https://cloud.google.com/dataproc/)

        ## Example Usage

        ### Dataprocgdc Sparkapplication Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        spark_application = gcp.dataproc.GdcSparkApplication("spark-application",
            spark_application_id="tf-e2e-spark-app-basic",
            serviceinstance="do-not-delete-dataproc-gdc-instance",
            project="my-project",
            location="us-west2",
            namespace="default",
            spark_application_config={
                "main_class": "org.apache.spark.examples.SparkPi",
                "jar_file_uris": ["file:///usr/lib/spark/examples/jars/spark-examples.jar"],
                "args": ["10000"],
            })
        ```
        ### Dataprocgdc Sparkapplication

        ```python
        import pulumi
        import pulumi_gcp as gcp

        app_env = gcp.dataproc.GdcApplicationEnvironment("app_env",
            application_environment_id="tf-e2e-spark-app-env",
            serviceinstance="do-not-delete-dataproc-gdc-instance",
            project="my-project",
            location="us-west2",
            namespace="default")
        spark_application = gcp.dataproc.GdcSparkApplication("spark-application",
            spark_application_id="tf-e2e-spark-app",
            serviceinstance="do-not-delete-dataproc-gdc-instance",
            project="my-project",
            location="us-west2",
            namespace="default",
            labels={
                "test-label": "label-value",
            },
            annotations={
                "an_annotation": "annotation_value",
            },
            properties={
                "spark.executor.instances": "2",
            },
            application_environment=app_env.name,
            version="1.2",
            spark_application_config={
                "main_jar_file_uri": "file:///usr/lib/spark/examples/jars/spark-examples.jar",
                "jar_file_uris": ["file:///usr/lib/spark/examples/jars/spark-examples.jar"],
                "archive_uris": ["file://usr/lib/spark/examples/spark-examples.jar"],
                "file_uris": ["file:///usr/lib/spark/examples/jars/spark-examples.jar"],
            })
        ```
        ### Dataprocgdc Sparkapplication Pyspark

        ```python
        import pulumi
        import pulumi_gcp as gcp

        spark_application = gcp.dataproc.GdcSparkApplication("spark-application",
            spark_application_id="tf-e2e-pyspark-app",
            serviceinstance="do-not-delete-dataproc-gdc-instance",
            project="my-project",
            location="us-west2",
            namespace="default",
            display_name="A Pyspark application for a Terraform create test",
            dependency_images=["gcr.io/some/image"],
            pyspark_application_config={
                "main_python_file_uri": "gs://goog-dataproc-initialization-actions-us-west2/conda/test_conda.py",
                "jar_file_uris": ["file:///usr/lib/spark/examples/jars/spark-examples.jar"],
                "python_file_uris": ["gs://goog-dataproc-initialization-actions-us-west2/conda/get-sys-exec.py"],
                "file_uris": ["file://usr/lib/spark/examples/spark-examples.jar"],
                "archive_uris": ["file://usr/lib/spark/examples/spark-examples.jar"],
                "args": ["10"],
            })
        ```
        ### Dataprocgdc Sparkapplication Sparkr

        ```python
        import pulumi
        import pulumi_gcp as gcp

        spark_application = gcp.dataproc.GdcSparkApplication("spark-application",
            spark_application_id="tf-e2e-sparkr-app",
            serviceinstance="do-not-delete-dataproc-gdc-instance",
            project="my-project",
            location="us-west2",
            namespace="default",
            display_name="A SparkR application for a Terraform create test",
            spark_r_application_config={
                "main_r_file_uri": "gs://some-bucket/something.R",
                "file_uris": ["file://usr/lib/spark/examples/spark-examples.jar"],
                "archive_uris": ["file://usr/lib/spark/examples/spark-examples.jar"],
                "args": ["10"],
            })
        ```
        ### Dataprocgdc Sparkapplication Sparksql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        spark_application = gcp.dataproc.GdcSparkApplication("spark-application",
            spark_application_id="tf-e2e-sparksql-app",
            serviceinstance="do-not-delete-dataproc-gdc-instance",
            project="my-project",
            location="us-west2",
            namespace="default",
            display_name="A SparkSql application for a Terraform create test",
            spark_sql_application_config={
                "jar_file_uris": ["file:///usr/lib/spark/examples/jars/spark-examples.jar"],
                "query_list": {
                    "queries": ["show tables;"],
                },
                "script_variables": {
                    "MY_VAR": "1",
                },
            })
        ```
        ### Dataprocgdc Sparkapplication Sparksql Query File

        ```python
        import pulumi
        import pulumi_gcp as gcp

        spark_application = gcp.dataproc.GdcSparkApplication("spark-application",
            spark_application_id="tf-e2e-sparksql-app",
            serviceinstance="do-not-delete-dataproc-gdc-instance",
            project="my-project",
            location="us-west2",
            namespace="default",
            display_name="A SparkSql application for a Terraform create test",
            spark_sql_application_config={
                "jar_file_uris": ["file:///usr/lib/spark/examples/jars/spark-examples.jar"],
                "query_file_uri": "gs://some-bucket/something.sql",
                "script_variables": {
                    "MY_VAR": "1",
                },
            })
        ```

        ## Import

        SparkApplication can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/serviceInstances/{{serviceinstance}}/sparkApplications/{{spark_application_id}}`

        * `{{project}}/{{location}}/{{serviceinstance}}/{{spark_application_id}}`

        * `{{location}}/{{serviceinstance}}/{{spark_application_id}}`

        When using the `pulumi import` command, SparkApplication can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataproc/gdcSparkApplication:GdcSparkApplication default projects/{{project}}/locations/{{location}}/serviceInstances/{{serviceinstance}}/sparkApplications/{{spark_application_id}}
        ```

        ```sh
        $ pulumi import gcp:dataproc/gdcSparkApplication:GdcSparkApplication default {{project}}/{{location}}/{{serviceinstance}}/{{spark_application_id}}
        ```

        ```sh
        $ pulumi import gcp:dataproc/gdcSparkApplication:GdcSparkApplication default {{location}}/{{serviceinstance}}/{{spark_application_id}}
        ```

        :param str resource_name: The name of the resource.
        :param GdcSparkApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GdcSparkApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 application_environment: Optional[pulumi.Input[_builtins.str]] = None,
                 dependency_images: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 pyspark_application_config: Optional[pulumi.Input[Union['GdcSparkApplicationPysparkApplicationConfigArgs', 'GdcSparkApplicationPysparkApplicationConfigArgsDict']]] = None,
                 serviceinstance: Optional[pulumi.Input[_builtins.str]] = None,
                 spark_application_config: Optional[pulumi.Input[Union['GdcSparkApplicationSparkApplicationConfigArgs', 'GdcSparkApplicationSparkApplicationConfigArgsDict']]] = None,
                 spark_application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spark_r_application_config: Optional[pulumi.Input[Union['GdcSparkApplicationSparkRApplicationConfigArgs', 'GdcSparkApplicationSparkRApplicationConfigArgsDict']]] = None,
                 spark_sql_application_config: Optional[pulumi.Input[Union['GdcSparkApplicationSparkSqlApplicationConfigArgs', 'GdcSparkApplicationSparkSqlApplicationConfigArgsDict']]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GdcSparkApplicationArgs.__new__(GdcSparkApplicationArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["application_environment"] = application_environment
            __props__.__dict__["dependency_images"] = dependency_images
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["project"] = project
            __props__.__dict__["properties"] = properties
            __props__.__dict__["pyspark_application_config"] = pyspark_application_config
            if serviceinstance is None and not opts.urn:
                raise TypeError("Missing required property 'serviceinstance'")
            __props__.__dict__["serviceinstance"] = serviceinstance
            __props__.__dict__["spark_application_config"] = spark_application_config
            if spark_application_id is None and not opts.urn:
                raise TypeError("Missing required property 'spark_application_id'")
            __props__.__dict__["spark_application_id"] = spark_application_id
            __props__.__dict__["spark_r_application_config"] = spark_r_application_config
            __props__.__dict__["spark_sql_application_config"] = spark_sql_application_config
            __props__.__dict__["version"] = version
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["monitoring_endpoint"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["output_uri"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_message"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(GdcSparkApplication, __self__).__init__(
            'gcp:dataproc/gdcSparkApplication:GdcSparkApplication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            application_environment: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            dependency_images: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            monitoring_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            output_uri: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            pyspark_application_config: Optional[pulumi.Input[Union['GdcSparkApplicationPysparkApplicationConfigArgs', 'GdcSparkApplicationPysparkApplicationConfigArgsDict']]] = None,
            reconciling: Optional[pulumi.Input[_builtins.bool]] = None,
            serviceinstance: Optional[pulumi.Input[_builtins.str]] = None,
            spark_application_config: Optional[pulumi.Input[Union['GdcSparkApplicationSparkApplicationConfigArgs', 'GdcSparkApplicationSparkApplicationConfigArgsDict']]] = None,
            spark_application_id: Optional[pulumi.Input[_builtins.str]] = None,
            spark_r_application_config: Optional[pulumi.Input[Union['GdcSparkApplicationSparkRApplicationConfigArgs', 'GdcSparkApplicationSparkRApplicationConfigArgsDict']]] = None,
            spark_sql_application_config: Optional[pulumi.Input[Union['GdcSparkApplicationSparkSqlApplicationConfigArgs', 'GdcSparkApplicationSparkSqlApplicationConfigArgsDict']]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            state_message: Optional[pulumi.Input[_builtins.str]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'GdcSparkApplication':
        """
        Get an existing GdcSparkApplication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: The annotations to associate with this application. Annotations may be used to store client information, but are not used by the server.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] application_environment: An ApplicationEnvironment from which to inherit configuration properties.
        :param pulumi.Input[_builtins.str] create_time: The timestamp when the resource was created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dependency_images: List of container image uris for additional file dependencies. Dependent files are sequentially copied from each image. If a file with the same name exists in 2 images then the file from later image is used.
        :param pulumi.Input[_builtins.str] display_name: User-provided human-readable name to be used in user interfaces.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels to associate with this application. Labels may be used for filtering and billing tracking.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location of the spark application.
        :param pulumi.Input[_builtins.str] monitoring_endpoint: URL for a monitoring UI for this application (for eventual Spark PHS/UI support) Out of scope for private GA
        :param pulumi.Input[_builtins.str] name: Identifier. The name of the application. Format: projects/{project}/locations/{location}/serviceInstances/{service_instance}/sparkApplications/{application}
        :param pulumi.Input[_builtins.str] namespace: The Kubernetes namespace in which to create the application. This namespace must already exist on the cluster.
        :param pulumi.Input[_builtins.str] output_uri: An HCFS URI pointing to the location of stdout and stdout of the application Mainly useful for Pantheon and gcloud Not in scope for private GA
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: application-specific properties.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Union['GdcSparkApplicationPysparkApplicationConfigArgs', 'GdcSparkApplicationPysparkApplicationConfigArgsDict']] pyspark_application_config: Represents the PySparkApplicationConfig.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] reconciling: Whether the application is currently reconciling. True if the current state of the resource does not match the intended state, and the system is working to reconcile them, whether or not the change was user initiated.
        :param pulumi.Input[_builtins.str] serviceinstance: The id of the service instance to which this spark application belongs.
        :param pulumi.Input[Union['GdcSparkApplicationSparkApplicationConfigArgs', 'GdcSparkApplicationSparkApplicationConfigArgsDict']] spark_application_config: Represents the SparkApplicationConfig.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] spark_application_id: The id of the application
        :param pulumi.Input[Union['GdcSparkApplicationSparkRApplicationConfigArgs', 'GdcSparkApplicationSparkRApplicationConfigArgsDict']] spark_r_application_config: Represents the SparkRApplicationConfig.
               Structure is documented below.
        :param pulumi.Input[Union['GdcSparkApplicationSparkSqlApplicationConfigArgs', 'GdcSparkApplicationSparkSqlApplicationConfigArgsDict']] spark_sql_application_config: Represents the SparkRApplicationConfig.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] state: The current state.
               Possible values:
               * `STATE_UNSPECIFIED`
               * `PENDING`
               * `RUNNING`
               * `CANCELLING`
               * `CANCELLED`
               * `SUCCEEDED`
               * `FAILED`
        :param pulumi.Input[_builtins.str] state_message: A message explaining the current state.
        :param pulumi.Input[_builtins.str] uid: System generated unique identifier for this application, formatted as UUID4.
        :param pulumi.Input[_builtins.str] update_time: The timestamp when the resource was most recently updated.
        :param pulumi.Input[_builtins.str] version: The Dataproc version of this application.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GdcSparkApplicationState.__new__(_GdcSparkApplicationState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["application_environment"] = application_environment
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["dependency_images"] = dependency_images
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["monitoring_endpoint"] = monitoring_endpoint
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["output_uri"] = output_uri
        __props__.__dict__["project"] = project
        __props__.__dict__["properties"] = properties
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["pyspark_application_config"] = pyspark_application_config
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["serviceinstance"] = serviceinstance
        __props__.__dict__["spark_application_config"] = spark_application_config
        __props__.__dict__["spark_application_id"] = spark_application_id
        __props__.__dict__["spark_r_application_config"] = spark_r_application_config
        __props__.__dict__["spark_sql_application_config"] = spark_sql_application_config
        __props__.__dict__["state"] = state
        __props__.__dict__["state_message"] = state_message
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["version"] = version
        return GdcSparkApplication(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The annotations to associate with this application. Annotations may be used to store client information, but are not used by the server.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="applicationEnvironment")
    def application_environment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An ApplicationEnvironment from which to inherit configuration properties.
        """
        return pulumi.get(self, "application_environment")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dependencyImages")
    def dependency_images(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of container image uris for additional file dependencies. Dependent files are sequentially copied from each image. If a file with the same name exists in 2 images then the file from later image is used.
        """
        return pulumi.get(self, "dependency_images")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User-provided human-readable name to be used in user interfaces.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The labels to associate with this application. Labels may be used for filtering and billing tracking.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location of the spark application.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="monitoringEndpoint")
    def monitoring_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        URL for a monitoring UI for this application (for eventual Spark PHS/UI support) Out of scope for private GA
        """
        return pulumi.get(self, "monitoring_endpoint")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. The name of the application. Format: projects/{project}/locations/{location}/serviceInstances/{service_instance}/sparkApplications/{application}
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Kubernetes namespace in which to create the application. This namespace must already exist on the cluster.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="outputUri")
    def output_uri(self) -> pulumi.Output[_builtins.str]:
        """
        An HCFS URI pointing to the location of stdout and stdout of the application Mainly useful for Pantheon and gcloud Not in scope for private GA
        """
        return pulumi.get(self, "output_uri")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        application-specific properties.
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="pysparkApplicationConfig")
    def pyspark_application_config(self) -> pulumi.Output[Optional['outputs.GdcSparkApplicationPysparkApplicationConfig']]:
        """
        Represents the PySparkApplicationConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "pyspark_application_config")

    @_builtins.property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the application is currently reconciling. True if the current state of the resource does not match the intended state, and the system is working to reconcile them, whether or not the change was user initiated.
        """
        return pulumi.get(self, "reconciling")

    @_builtins.property
    @pulumi.getter
    def serviceinstance(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the service instance to which this spark application belongs.
        """
        return pulumi.get(self, "serviceinstance")

    @_builtins.property
    @pulumi.getter(name="sparkApplicationConfig")
    def spark_application_config(self) -> pulumi.Output[Optional['outputs.GdcSparkApplicationSparkApplicationConfig']]:
        """
        Represents the SparkApplicationConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "spark_application_config")

    @_builtins.property
    @pulumi.getter(name="sparkApplicationId")
    def spark_application_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the application
        """
        return pulumi.get(self, "spark_application_id")

    @_builtins.property
    @pulumi.getter(name="sparkRApplicationConfig")
    def spark_r_application_config(self) -> pulumi.Output[Optional['outputs.GdcSparkApplicationSparkRApplicationConfig']]:
        """
        Represents the SparkRApplicationConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "spark_r_application_config")

    @_builtins.property
    @pulumi.getter(name="sparkSqlApplicationConfig")
    def spark_sql_application_config(self) -> pulumi.Output[Optional['outputs.GdcSparkApplicationSparkSqlApplicationConfig']]:
        """
        Represents the SparkRApplicationConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "spark_sql_application_config")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state.
        Possible values:
        * `STATE_UNSPECIFIED`
        * `PENDING`
        * `RUNNING`
        * `CANCELLING`
        * `CANCELLED`
        * `SUCCEEDED`
        * `FAILED`
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> pulumi.Output[_builtins.str]:
        """
        A message explaining the current state.
        """
        return pulumi.get(self, "state_message")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        System generated unique identifier for this application, formatted as UUID4.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp when the resource was most recently updated.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Dataproc version of this application.
        """
        return pulumi.get(self, "version")

