# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AutoscalingPolicyBasicAlgorithm',
    'AutoscalingPolicyBasicAlgorithmYarnConfig',
    'AutoscalingPolicyIamBindingCondition',
    'AutoscalingPolicyIamMemberCondition',
    'AutoscalingPolicySecondaryWorkerConfig',
    'AutoscalingPolicyWorkerConfig',
    'BatchEnvironmentConfig',
    'BatchEnvironmentConfigExecutionConfig',
    'BatchEnvironmentConfigExecutionConfigAuthenticationConfig',
    'BatchEnvironmentConfigPeripheralsConfig',
    'BatchEnvironmentConfigPeripheralsConfigSparkHistoryServerConfig',
    'BatchPysparkBatch',
    'BatchRuntimeConfig',
    'BatchRuntimeConfigAutotuningConfig',
    'BatchRuntimeInfo',
    'BatchRuntimeInfoApproximateUsage',
    'BatchRuntimeInfoCurrentUsage',
    'BatchSparkBatch',
    'BatchSparkRBatch',
    'BatchSparkSqlBatch',
    'BatchStateHistory',
    'ClusterClusterConfig',
    'ClusterClusterConfigAutoscalingConfig',
    'ClusterClusterConfigAuxiliaryNodeGroup',
    'ClusterClusterConfigAuxiliaryNodeGroupNodeGroup',
    'ClusterClusterConfigAuxiliaryNodeGroupNodeGroupNodeGroupConfig',
    'ClusterClusterConfigAuxiliaryNodeGroupNodeGroupNodeGroupConfigAccelerator',
    'ClusterClusterConfigAuxiliaryNodeGroupNodeGroupNodeGroupConfigDiskConfig',
    'ClusterClusterConfigDataprocMetricConfig',
    'ClusterClusterConfigDataprocMetricConfigMetric',
    'ClusterClusterConfigEncryptionConfig',
    'ClusterClusterConfigEndpointConfig',
    'ClusterClusterConfigGceClusterConfig',
    'ClusterClusterConfigGceClusterConfigConfidentialInstanceConfig',
    'ClusterClusterConfigGceClusterConfigNodeGroupAffinity',
    'ClusterClusterConfigGceClusterConfigReservationAffinity',
    'ClusterClusterConfigGceClusterConfigShieldedInstanceConfig',
    'ClusterClusterConfigInitializationAction',
    'ClusterClusterConfigLifecycleConfig',
    'ClusterClusterConfigMasterConfig',
    'ClusterClusterConfigMasterConfigAccelerator',
    'ClusterClusterConfigMasterConfigDiskConfig',
    'ClusterClusterConfigMetastoreConfig',
    'ClusterClusterConfigPreemptibleWorkerConfig',
    'ClusterClusterConfigPreemptibleWorkerConfigDiskConfig',
    'ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicy',
    'ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicyInstanceSelectionList',
    'ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicyInstanceSelectionResult',
    'ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicyProvisioningModelMix',
    'ClusterClusterConfigSecurityConfig',
    'ClusterClusterConfigSecurityConfigIdentityConfig',
    'ClusterClusterConfigSecurityConfigKerberosConfig',
    'ClusterClusterConfigSoftwareConfig',
    'ClusterClusterConfigWorkerConfig',
    'ClusterClusterConfigWorkerConfigAccelerator',
    'ClusterClusterConfigWorkerConfigDiskConfig',
    'ClusterIAMBindingCondition',
    'ClusterIAMMemberCondition',
    'ClusterVirtualClusterConfig',
    'ClusterVirtualClusterConfigAuxiliaryServicesConfig',
    'ClusterVirtualClusterConfigAuxiliaryServicesConfigMetastoreConfig',
    'ClusterVirtualClusterConfigAuxiliaryServicesConfigSparkHistoryServerConfig',
    'ClusterVirtualClusterConfigKubernetesClusterConfig',
    'ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfig',
    'ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTarget',
    'ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfig',
    'ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigAutoscaling',
    'ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigConfig',
    'ClusterVirtualClusterConfigKubernetesClusterConfigKubernetesSoftwareConfig',
    'GdcApplicationEnvironmentSparkApplicationEnvironmentConfig',
    'GdcServiceInstanceGdceCluster',
    'GdcServiceInstanceSparkServiceInstanceConfig',
    'GdcSparkApplicationPysparkApplicationConfig',
    'GdcSparkApplicationSparkApplicationConfig',
    'GdcSparkApplicationSparkRApplicationConfig',
    'GdcSparkApplicationSparkSqlApplicationConfig',
    'GdcSparkApplicationSparkSqlApplicationConfigQueryList',
    'JobHadoopConfig',
    'JobHadoopConfigLoggingConfig',
    'JobHiveConfig',
    'JobIAMBindingCondition',
    'JobIAMMemberCondition',
    'JobPigConfig',
    'JobPigConfigLoggingConfig',
    'JobPlacement',
    'JobPrestoConfig',
    'JobPrestoConfigLoggingConfig',
    'JobPysparkConfig',
    'JobPysparkConfigLoggingConfig',
    'JobReference',
    'JobScheduling',
    'JobSparkConfig',
    'JobSparkConfigLoggingConfig',
    'JobSparksqlConfig',
    'JobSparksqlConfigLoggingConfig',
    'JobStatus',
    'MetastoreDatabaseIamBindingCondition',
    'MetastoreDatabaseIamMemberCondition',
    'MetastoreFederationBackendMetastore',
    'MetastoreFederationIamBindingCondition',
    'MetastoreFederationIamMemberCondition',
    'MetastoreServiceEncryptionConfig',
    'MetastoreServiceHiveMetastoreConfig',
    'MetastoreServiceHiveMetastoreConfigAuxiliaryVersion',
    'MetastoreServiceHiveMetastoreConfigKerberosConfig',
    'MetastoreServiceHiveMetastoreConfigKerberosConfigKeytab',
    'MetastoreServiceIamBindingCondition',
    'MetastoreServiceIamMemberCondition',
    'MetastoreServiceMaintenanceWindow',
    'MetastoreServiceMetadataIntegration',
    'MetastoreServiceMetadataIntegrationDataCatalogConfig',
    'MetastoreServiceNetworkConfig',
    'MetastoreServiceNetworkConfigConsumer',
    'MetastoreServiceScalingConfig',
    'MetastoreServiceScalingConfigAutoscalingConfig',
    'MetastoreServiceScalingConfigAutoscalingConfigLimitConfig',
    'MetastoreServiceScheduledBackup',
    'MetastoreServiceTelemetryConfig',
    'MetastoreTableIamBindingCondition',
    'MetastoreTableIamMemberCondition',
    'SessionTemplateEnvironmentConfig',
    'SessionTemplateEnvironmentConfigExecutionConfig',
    'SessionTemplateEnvironmentConfigExecutionConfigAuthenticationConfig',
    'SessionTemplateEnvironmentConfigPeripheralsConfig',
    'SessionTemplateEnvironmentConfigPeripheralsConfigSparkHistoryServerConfig',
    'SessionTemplateJupyterSession',
    'SessionTemplateRuntimeConfig',
    'SessionTemplateSparkConnectSession',
    'WorkflowTemplateEncryptionConfig',
    'WorkflowTemplateJob',
    'WorkflowTemplateJobHadoopJob',
    'WorkflowTemplateJobHadoopJobLoggingConfig',
    'WorkflowTemplateJobHiveJob',
    'WorkflowTemplateJobHiveJobQueryList',
    'WorkflowTemplateJobPigJob',
    'WorkflowTemplateJobPigJobLoggingConfig',
    'WorkflowTemplateJobPigJobQueryList',
    'WorkflowTemplateJobPrestoJob',
    'WorkflowTemplateJobPrestoJobLoggingConfig',
    'WorkflowTemplateJobPrestoJobQueryList',
    'WorkflowTemplateJobPysparkJob',
    'WorkflowTemplateJobPysparkJobLoggingConfig',
    'WorkflowTemplateJobScheduling',
    'WorkflowTemplateJobSparkJob',
    'WorkflowTemplateJobSparkJobLoggingConfig',
    'WorkflowTemplateJobSparkRJob',
    'WorkflowTemplateJobSparkRJobLoggingConfig',
    'WorkflowTemplateJobSparkSqlJob',
    'WorkflowTemplateJobSparkSqlJobLoggingConfig',
    'WorkflowTemplateJobSparkSqlJobQueryList',
    'WorkflowTemplateParameter',
    'WorkflowTemplateParameterValidation',
    'WorkflowTemplateParameterValidationRegex',
    'WorkflowTemplateParameterValidationValues',
    'WorkflowTemplatePlacement',
    'WorkflowTemplatePlacementClusterSelector',
    'WorkflowTemplatePlacementManagedCluster',
    'WorkflowTemplatePlacementManagedClusterConfig',
    'WorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig',
    'WorkflowTemplatePlacementManagedClusterConfigEncryptionConfig',
    'WorkflowTemplatePlacementManagedClusterConfigEndpointConfig',
    'WorkflowTemplatePlacementManagedClusterConfigGceClusterConfig',
    'WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity',
    'WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity',
    'WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigShieldedInstanceConfig',
    'WorkflowTemplatePlacementManagedClusterConfigGkeClusterConfig',
    'WorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigNamespacedGkeDeploymentTarget',
    'WorkflowTemplatePlacementManagedClusterConfigInitializationAction',
    'WorkflowTemplatePlacementManagedClusterConfigLifecycleConfig',
    'WorkflowTemplatePlacementManagedClusterConfigMasterConfig',
    'WorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerator',
    'WorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig',
    'WorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfig',
    'WorkflowTemplatePlacementManagedClusterConfigMetastoreConfig',
    'WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig',
    'WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerator',
    'WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig',
    'WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfig',
    'WorkflowTemplatePlacementManagedClusterConfigSecurityConfig',
    'WorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig',
    'WorkflowTemplatePlacementManagedClusterConfigSoftwareConfig',
    'WorkflowTemplatePlacementManagedClusterConfigWorkerConfig',
    'WorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerator',
    'WorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig',
    'WorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfig',
    'GetMetastoreServiceEncryptionConfigResult',
    'GetMetastoreServiceHiveMetastoreConfigResult',
    'GetMetastoreServiceHiveMetastoreConfigAuxiliaryVersionResult',
    'GetMetastoreServiceHiveMetastoreConfigKerberosConfigResult',
    'GetMetastoreServiceHiveMetastoreConfigKerberosConfigKeytabResult',
    'GetMetastoreServiceMaintenanceWindowResult',
    'GetMetastoreServiceMetadataIntegrationResult',
    'GetMetastoreServiceMetadataIntegrationDataCatalogConfigResult',
    'GetMetastoreServiceNetworkConfigResult',
    'GetMetastoreServiceNetworkConfigConsumerResult',
    'GetMetastoreServiceScalingConfigResult',
    'GetMetastoreServiceScalingConfigAutoscalingConfigResult',
    'GetMetastoreServiceScalingConfigAutoscalingConfigLimitConfigResult',
    'GetMetastoreServiceScheduledBackupResult',
    'GetMetastoreServiceTelemetryConfigResult',
]

@pulumi.output_type
class AutoscalingPolicyBasicAlgorithm(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "yarnConfig":
            suggest = "yarn_config"
        elif key == "cooldownPeriod":
            suggest = "cooldown_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoscalingPolicyBasicAlgorithm. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoscalingPolicyBasicAlgorithm.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoscalingPolicyBasicAlgorithm.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 yarn_config: 'outputs.AutoscalingPolicyBasicAlgorithmYarnConfig',
                 cooldown_period: Optional[_builtins.str] = None):
        """
        :param 'AutoscalingPolicyBasicAlgorithmYarnConfigArgs' yarn_config: YARN autoscaling configuration.
               Structure is documented below.
        :param _builtins.str cooldown_period: Duration between scaling events. A scaling period starts after the
               update operation from the previous event has completed.
               Bounds: [2m, 1d]. Default: 2m.
        """
        pulumi.set(__self__, "yarn_config", yarn_config)
        if cooldown_period is not None:
            pulumi.set(__self__, "cooldown_period", cooldown_period)

    @_builtins.property
    @pulumi.getter(name="yarnConfig")
    def yarn_config(self) -> 'outputs.AutoscalingPolicyBasicAlgorithmYarnConfig':
        """
        YARN autoscaling configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "yarn_config")

    @_builtins.property
    @pulumi.getter(name="cooldownPeriod")
    def cooldown_period(self) -> Optional[_builtins.str]:
        """
        Duration between scaling events. A scaling period starts after the
        update operation from the previous event has completed.
        Bounds: [2m, 1d]. Default: 2m.
        """
        return pulumi.get(self, "cooldown_period")


@pulumi.output_type
class AutoscalingPolicyBasicAlgorithmYarnConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gracefulDecommissionTimeout":
            suggest = "graceful_decommission_timeout"
        elif key == "scaleDownFactor":
            suggest = "scale_down_factor"
        elif key == "scaleUpFactor":
            suggest = "scale_up_factor"
        elif key == "scaleDownMinWorkerFraction":
            suggest = "scale_down_min_worker_fraction"
        elif key == "scaleUpMinWorkerFraction":
            suggest = "scale_up_min_worker_fraction"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoscalingPolicyBasicAlgorithmYarnConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoscalingPolicyBasicAlgorithmYarnConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoscalingPolicyBasicAlgorithmYarnConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 graceful_decommission_timeout: _builtins.str,
                 scale_down_factor: _builtins.float,
                 scale_up_factor: _builtins.float,
                 scale_down_min_worker_fraction: Optional[_builtins.float] = None,
                 scale_up_min_worker_fraction: Optional[_builtins.float] = None):
        """
        :param _builtins.str graceful_decommission_timeout: Timeout for YARN graceful decommissioning of Node Managers. Specifies the
               duration to wait for jobs to complete before forcefully removing workers
               (and potentially interrupting jobs). Only applicable to downscaling operations.
               Bounds: [0s, 1d].
        :param _builtins.float scale_down_factor: Fraction of average pending memory in the last cooldown period for which to
               remove workers. A scale-down factor of 1 will result in scaling down so that there
               is no available memory remaining after the update (more aggressive scaling).
               A scale-down factor of 0 disables removing workers, which can be beneficial for
               autoscaling a single job.
               Bounds: [0.0, 1.0].
        :param _builtins.float scale_up_factor: Fraction of average pending memory in the last cooldown period for which to
               add workers. A scale-up factor of 1.0 will result in scaling up so that there
               is no pending memory remaining after the update (more aggressive scaling).
               A scale-up factor closer to 0 will result in a smaller magnitude of scaling up
               (less aggressive scaling).
               Bounds: [0.0, 1.0].
        :param _builtins.float scale_down_min_worker_fraction: Minimum scale-down threshold as a fraction of total cluster size before scaling occurs.
               For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must
               recommend at least a 2 worker scale-down for the cluster to scale. A threshold of 0
               means the autoscaler will scale down on any recommended change.
               Bounds: [0.0, 1.0]. Default: 0.0.
        :param _builtins.float scale_up_min_worker_fraction: Minimum scale-up threshold as a fraction of total cluster size before scaling
               occurs. For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler
               must recommend at least a 2-worker scale-up for the cluster to scale. A threshold of
               0 means the autoscaler will scale up on any recommended change.
               Bounds: [0.0, 1.0]. Default: 0.0.
        """
        pulumi.set(__self__, "graceful_decommission_timeout", graceful_decommission_timeout)
        pulumi.set(__self__, "scale_down_factor", scale_down_factor)
        pulumi.set(__self__, "scale_up_factor", scale_up_factor)
        if scale_down_min_worker_fraction is not None:
            pulumi.set(__self__, "scale_down_min_worker_fraction", scale_down_min_worker_fraction)
        if scale_up_min_worker_fraction is not None:
            pulumi.set(__self__, "scale_up_min_worker_fraction", scale_up_min_worker_fraction)

    @_builtins.property
    @pulumi.getter(name="gracefulDecommissionTimeout")
    def graceful_decommission_timeout(self) -> _builtins.str:
        """
        Timeout for YARN graceful decommissioning of Node Managers. Specifies the
        duration to wait for jobs to complete before forcefully removing workers
        (and potentially interrupting jobs). Only applicable to downscaling operations.
        Bounds: [0s, 1d].
        """
        return pulumi.get(self, "graceful_decommission_timeout")

    @_builtins.property
    @pulumi.getter(name="scaleDownFactor")
    def scale_down_factor(self) -> _builtins.float:
        """
        Fraction of average pending memory in the last cooldown period for which to
        remove workers. A scale-down factor of 1 will result in scaling down so that there
        is no available memory remaining after the update (more aggressive scaling).
        A scale-down factor of 0 disables removing workers, which can be beneficial for
        autoscaling a single job.
        Bounds: [0.0, 1.0].
        """
        return pulumi.get(self, "scale_down_factor")

    @_builtins.property
    @pulumi.getter(name="scaleUpFactor")
    def scale_up_factor(self) -> _builtins.float:
        """
        Fraction of average pending memory in the last cooldown period for which to
        add workers. A scale-up factor of 1.0 will result in scaling up so that there
        is no pending memory remaining after the update (more aggressive scaling).
        A scale-up factor closer to 0 will result in a smaller magnitude of scaling up
        (less aggressive scaling).
        Bounds: [0.0, 1.0].
        """
        return pulumi.get(self, "scale_up_factor")

    @_builtins.property
    @pulumi.getter(name="scaleDownMinWorkerFraction")
    def scale_down_min_worker_fraction(self) -> Optional[_builtins.float]:
        """
        Minimum scale-down threshold as a fraction of total cluster size before scaling occurs.
        For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must
        recommend at least a 2 worker scale-down for the cluster to scale. A threshold of 0
        means the autoscaler will scale down on any recommended change.
        Bounds: [0.0, 1.0]. Default: 0.0.
        """
        return pulumi.get(self, "scale_down_min_worker_fraction")

    @_builtins.property
    @pulumi.getter(name="scaleUpMinWorkerFraction")
    def scale_up_min_worker_fraction(self) -> Optional[_builtins.float]:
        """
        Minimum scale-up threshold as a fraction of total cluster size before scaling
        occurs. For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler
        must recommend at least a 2-worker scale-up for the cluster to scale. A threshold of
        0 means the autoscaler will scale up on any recommended change.
        Bounds: [0.0, 1.0]. Default: 0.0.
        """
        return pulumi.get(self, "scale_up_min_worker_fraction")


@pulumi.output_type
class AutoscalingPolicyIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class AutoscalingPolicyIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class AutoscalingPolicySecondaryWorkerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxInstances":
            suggest = "max_instances"
        elif key == "minInstances":
            suggest = "min_instances"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoscalingPolicySecondaryWorkerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoscalingPolicySecondaryWorkerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoscalingPolicySecondaryWorkerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_instances: Optional[_builtins.int] = None,
                 min_instances: Optional[_builtins.int] = None,
                 weight: Optional[_builtins.int] = None):
        """
        :param _builtins.int max_instances: Maximum number of instances for this group. Note that by default, clusters will not use
               secondary workers. Required for secondary workers if the minimum secondary instances is set.
               Bounds: [minInstances, ). Defaults to 0.
        :param _builtins.int min_instances: Minimum number of instances for this group. Bounds: [0, maxInstances]. Defaults to 0.
        :param _builtins.int weight: Weight for the instance group, which is used to determine the fraction of total workers
               in the cluster from this instance group. For example, if primary workers have weight 2,
               and secondary workers have weight 1, the cluster will have approximately 2 primary workers
               for each secondary worker.
               The cluster may not reach the specified balance if constrained by min/max bounds or other
               autoscaling settings. For example, if maxInstances for secondary workers is 0, then only
               primary workers will be added. The cluster can also be out of balance when created.
               If weight is not set on any instance group, the cluster will default to equal weight for
               all groups: the cluster will attempt to maintain an equal number of workers in each group
               within the configured size bounds for each group. If weight is set for one group only,
               the cluster will default to zero weight on the unset group. For example if weight is set
               only on primary workers, the cluster will use primary workers only and no secondary workers.
        """
        if max_instances is not None:
            pulumi.set(__self__, "max_instances", max_instances)
        if min_instances is not None:
            pulumi.set(__self__, "min_instances", min_instances)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> Optional[_builtins.int]:
        """
        Maximum number of instances for this group. Note that by default, clusters will not use
        secondary workers. Required for secondary workers if the minimum secondary instances is set.
        Bounds: [minInstances, ). Defaults to 0.
        """
        return pulumi.get(self, "max_instances")

    @_builtins.property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> Optional[_builtins.int]:
        """
        Minimum number of instances for this group. Bounds: [0, maxInstances]. Defaults to 0.
        """
        return pulumi.get(self, "min_instances")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[_builtins.int]:
        """
        Weight for the instance group, which is used to determine the fraction of total workers
        in the cluster from this instance group. For example, if primary workers have weight 2,
        and secondary workers have weight 1, the cluster will have approximately 2 primary workers
        for each secondary worker.
        The cluster may not reach the specified balance if constrained by min/max bounds or other
        autoscaling settings. For example, if maxInstances for secondary workers is 0, then only
        primary workers will be added. The cluster can also be out of balance when created.
        If weight is not set on any instance group, the cluster will default to equal weight for
        all groups: the cluster will attempt to maintain an equal number of workers in each group
        within the configured size bounds for each group. If weight is set for one group only,
        the cluster will default to zero weight on the unset group. For example if weight is set
        only on primary workers, the cluster will use primary workers only and no secondary workers.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class AutoscalingPolicyWorkerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxInstances":
            suggest = "max_instances"
        elif key == "minInstances":
            suggest = "min_instances"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoscalingPolicyWorkerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoscalingPolicyWorkerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoscalingPolicyWorkerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_instances: _builtins.int,
                 min_instances: Optional[_builtins.int] = None,
                 weight: Optional[_builtins.int] = None):
        """
        :param _builtins.int max_instances: Maximum number of instances for this group.
        :param _builtins.int min_instances: Minimum number of instances for this group. Bounds: [2, maxInstances]. Defaults to 2.
        :param _builtins.int weight: Weight for the instance group, which is used to determine the fraction of total workers
               in the cluster from this instance group. For example, if primary workers have weight 2,
               and secondary workers have weight 1, the cluster will have approximately 2 primary workers
               for each secondary worker.
               The cluster may not reach the specified balance if constrained by min/max bounds or other
               autoscaling settings. For example, if maxInstances for secondary workers is 0, then only
               primary workers will be added. The cluster can also be out of balance when created.
               If weight is not set on any instance group, the cluster will default to equal weight for
               all groups: the cluster will attempt to maintain an equal number of workers in each group
               within the configured size bounds for each group. If weight is set for one group only,
               the cluster will default to zero weight on the unset group. For example if weight is set
               only on primary workers, the cluster will use primary workers only and no secondary workers.
        """
        pulumi.set(__self__, "max_instances", max_instances)
        if min_instances is not None:
            pulumi.set(__self__, "min_instances", min_instances)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> _builtins.int:
        """
        Maximum number of instances for this group.
        """
        return pulumi.get(self, "max_instances")

    @_builtins.property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> Optional[_builtins.int]:
        """
        Minimum number of instances for this group. Bounds: [2, maxInstances]. Defaults to 2.
        """
        return pulumi.get(self, "min_instances")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[_builtins.int]:
        """
        Weight for the instance group, which is used to determine the fraction of total workers
        in the cluster from this instance group. For example, if primary workers have weight 2,
        and secondary workers have weight 1, the cluster will have approximately 2 primary workers
        for each secondary worker.
        The cluster may not reach the specified balance if constrained by min/max bounds or other
        autoscaling settings. For example, if maxInstances for secondary workers is 0, then only
        primary workers will be added. The cluster can also be out of balance when created.
        If weight is not set on any instance group, the cluster will default to equal weight for
        all groups: the cluster will attempt to maintain an equal number of workers in each group
        within the configured size bounds for each group. If weight is set for one group only,
        the cluster will default to zero weight on the unset group. For example if weight is set
        only on primary workers, the cluster will use primary workers only and no secondary workers.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class BatchEnvironmentConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionConfig":
            suggest = "execution_config"
        elif key == "peripheralsConfig":
            suggest = "peripherals_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchEnvironmentConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchEnvironmentConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchEnvironmentConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_config: Optional['outputs.BatchEnvironmentConfigExecutionConfig'] = None,
                 peripherals_config: Optional['outputs.BatchEnvironmentConfigPeripheralsConfig'] = None):
        """
        :param 'BatchEnvironmentConfigExecutionConfigArgs' execution_config: Execution configuration for a workload.
               Structure is documented below.
        :param 'BatchEnvironmentConfigPeripheralsConfigArgs' peripherals_config: Peripherals configuration that workload has access to.
               Structure is documented below.
        """
        if execution_config is not None:
            pulumi.set(__self__, "execution_config", execution_config)
        if peripherals_config is not None:
            pulumi.set(__self__, "peripherals_config", peripherals_config)

    @_builtins.property
    @pulumi.getter(name="executionConfig")
    def execution_config(self) -> Optional['outputs.BatchEnvironmentConfigExecutionConfig']:
        """
        Execution configuration for a workload.
        Structure is documented below.
        """
        return pulumi.get(self, "execution_config")

    @_builtins.property
    @pulumi.getter(name="peripheralsConfig")
    def peripherals_config(self) -> Optional['outputs.BatchEnvironmentConfigPeripheralsConfig']:
        """
        Peripherals configuration that workload has access to.
        Structure is documented below.
        """
        return pulumi.get(self, "peripherals_config")


@pulumi.output_type
class BatchEnvironmentConfigExecutionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationConfig":
            suggest = "authentication_config"
        elif key == "kmsKey":
            suggest = "kms_key"
        elif key == "networkTags":
            suggest = "network_tags"
        elif key == "networkUri":
            suggest = "network_uri"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "stagingBucket":
            suggest = "staging_bucket"
        elif key == "subnetworkUri":
            suggest = "subnetwork_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchEnvironmentConfigExecutionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchEnvironmentConfigExecutionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchEnvironmentConfigExecutionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_config: Optional['outputs.BatchEnvironmentConfigExecutionConfigAuthenticationConfig'] = None,
                 kms_key: Optional[_builtins.str] = None,
                 network_tags: Optional[Sequence[_builtins.str]] = None,
                 network_uri: Optional[_builtins.str] = None,
                 service_account: Optional[_builtins.str] = None,
                 staging_bucket: Optional[_builtins.str] = None,
                 subnetwork_uri: Optional[_builtins.str] = None,
                 ttl: Optional[_builtins.str] = None):
        """
        :param 'BatchEnvironmentConfigExecutionConfigAuthenticationConfigArgs' authentication_config: Authentication configuration for a workload is used to set the default identity for the workload execution.
               Structure is documented below.
        :param _builtins.str kms_key: The Cloud KMS key to use for encryption.
        :param Sequence[_builtins.str] network_tags: Tags used for network traffic control.
        :param _builtins.str network_uri: Network configuration for workload execution.
        :param _builtins.str service_account: Service account that used to execute workload.
        :param _builtins.str staging_bucket: A Cloud Storage bucket used to stage workload dependencies, config files, and store
               workload output and other ephemeral data, such as Spark history files. If you do not specify a staging bucket,
               Cloud Dataproc will determine a Cloud Storage location according to the region where your workload is running,
               and then create and manage project-level, per-location staging and temporary buckets.
               This field requires a Cloud Storage bucket name, not a gs://... URI to a Cloud Storage bucket.
        :param _builtins.str subnetwork_uri: Subnetwork configuration for workload execution.
        :param _builtins.str ttl: The duration after which the workload will be terminated.
               When the workload exceeds this duration, it will be unconditionally terminated without waiting for ongoing
               work to finish. If ttl is not specified for a batch workload, the workload will be allowed to run until it
               exits naturally (or run forever without exiting). If ttl is not specified for an interactive session,
               it defaults to 24 hours. If ttl is not specified for a batch that uses 2.1+ runtime version, it defaults to 4 hours.
               Minimum value is 10 minutes; maximum value is 14 days. If both ttl and idleTtl are specified (for an interactive session),
               the conditions are treated as OR conditions: the workload will be terminated when it has been idle for idleTtl or
               when ttl has been exceeded, whichever occurs first.
        """
        if authentication_config is not None:
            pulumi.set(__self__, "authentication_config", authentication_config)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if network_tags is not None:
            pulumi.set(__self__, "network_tags", network_tags)
        if network_uri is not None:
            pulumi.set(__self__, "network_uri", network_uri)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if staging_bucket is not None:
            pulumi.set(__self__, "staging_bucket", staging_bucket)
        if subnetwork_uri is not None:
            pulumi.set(__self__, "subnetwork_uri", subnetwork_uri)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter(name="authenticationConfig")
    def authentication_config(self) -> Optional['outputs.BatchEnvironmentConfigExecutionConfigAuthenticationConfig']:
        """
        Authentication configuration for a workload is used to set the default identity for the workload execution.
        Structure is documented below.
        """
        return pulumi.get(self, "authentication_config")

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[_builtins.str]:
        """
        The Cloud KMS key to use for encryption.
        """
        return pulumi.get(self, "kms_key")

    @_builtins.property
    @pulumi.getter(name="networkTags")
    def network_tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        Tags used for network traffic control.
        """
        return pulumi.get(self, "network_tags")

    @_builtins.property
    @pulumi.getter(name="networkUri")
    def network_uri(self) -> Optional[_builtins.str]:
        """
        Network configuration for workload execution.
        """
        return pulumi.get(self, "network_uri")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[_builtins.str]:
        """
        Service account that used to execute workload.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter(name="stagingBucket")
    def staging_bucket(self) -> Optional[_builtins.str]:
        """
        A Cloud Storage bucket used to stage workload dependencies, config files, and store
        workload output and other ephemeral data, such as Spark history files. If you do not specify a staging bucket,
        Cloud Dataproc will determine a Cloud Storage location according to the region where your workload is running,
        and then create and manage project-level, per-location staging and temporary buckets.
        This field requires a Cloud Storage bucket name, not a gs://... URI to a Cloud Storage bucket.
        """
        return pulumi.get(self, "staging_bucket")

    @_builtins.property
    @pulumi.getter(name="subnetworkUri")
    def subnetwork_uri(self) -> Optional[_builtins.str]:
        """
        Subnetwork configuration for workload execution.
        """
        return pulumi.get(self, "subnetwork_uri")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[_builtins.str]:
        """
        The duration after which the workload will be terminated.
        When the workload exceeds this duration, it will be unconditionally terminated without waiting for ongoing
        work to finish. If ttl is not specified for a batch workload, the workload will be allowed to run until it
        exits naturally (or run forever without exiting). If ttl is not specified for an interactive session,
        it defaults to 24 hours. If ttl is not specified for a batch that uses 2.1+ runtime version, it defaults to 4 hours.
        Minimum value is 10 minutes; maximum value is 14 days. If both ttl and idleTtl are specified (for an interactive session),
        the conditions are treated as OR conditions: the workload will be terminated when it has been idle for idleTtl or
        when ttl has been exceeded, whichever occurs first.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class BatchEnvironmentConfigExecutionConfigAuthenticationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userWorkloadAuthenticationType":
            suggest = "user_workload_authentication_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchEnvironmentConfigExecutionConfigAuthenticationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchEnvironmentConfigExecutionConfigAuthenticationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchEnvironmentConfigExecutionConfigAuthenticationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_workload_authentication_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str user_workload_authentication_type: Authentication type for the user workload running in containers.
               Possible values are: `SERVICE_ACCOUNT`, `END_USER_CREDENTIALS`.
        """
        if user_workload_authentication_type is not None:
            pulumi.set(__self__, "user_workload_authentication_type", user_workload_authentication_type)

    @_builtins.property
    @pulumi.getter(name="userWorkloadAuthenticationType")
    def user_workload_authentication_type(self) -> Optional[_builtins.str]:
        """
        Authentication type for the user workload running in containers.
        Possible values are: `SERVICE_ACCOUNT`, `END_USER_CREDENTIALS`.
        """
        return pulumi.get(self, "user_workload_authentication_type")


@pulumi.output_type
class BatchEnvironmentConfigPeripheralsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metastoreService":
            suggest = "metastore_service"
        elif key == "sparkHistoryServerConfig":
            suggest = "spark_history_server_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchEnvironmentConfigPeripheralsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchEnvironmentConfigPeripheralsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchEnvironmentConfigPeripheralsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metastore_service: Optional[_builtins.str] = None,
                 spark_history_server_config: Optional['outputs.BatchEnvironmentConfigPeripheralsConfigSparkHistoryServerConfig'] = None):
        """
        :param _builtins.str metastore_service: Resource name of an existing Dataproc Metastore service.
        :param 'BatchEnvironmentConfigPeripheralsConfigSparkHistoryServerConfigArgs' spark_history_server_config: The Spark History Server configuration for the workload.
               Structure is documented below.
        """
        if metastore_service is not None:
            pulumi.set(__self__, "metastore_service", metastore_service)
        if spark_history_server_config is not None:
            pulumi.set(__self__, "spark_history_server_config", spark_history_server_config)

    @_builtins.property
    @pulumi.getter(name="metastoreService")
    def metastore_service(self) -> Optional[_builtins.str]:
        """
        Resource name of an existing Dataproc Metastore service.
        """
        return pulumi.get(self, "metastore_service")

    @_builtins.property
    @pulumi.getter(name="sparkHistoryServerConfig")
    def spark_history_server_config(self) -> Optional['outputs.BatchEnvironmentConfigPeripheralsConfigSparkHistoryServerConfig']:
        """
        The Spark History Server configuration for the workload.
        Structure is documented below.
        """
        return pulumi.get(self, "spark_history_server_config")


@pulumi.output_type
class BatchEnvironmentConfigPeripheralsConfigSparkHistoryServerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataprocCluster":
            suggest = "dataproc_cluster"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchEnvironmentConfigPeripheralsConfigSparkHistoryServerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchEnvironmentConfigPeripheralsConfigSparkHistoryServerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchEnvironmentConfigPeripheralsConfigSparkHistoryServerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataproc_cluster: Optional[_builtins.str] = None):
        """
        :param _builtins.str dataproc_cluster: Resource name of an existing Dataproc Cluster to act as a Spark History Server for the workload.
        """
        if dataproc_cluster is not None:
            pulumi.set(__self__, "dataproc_cluster", dataproc_cluster)

    @_builtins.property
    @pulumi.getter(name="dataprocCluster")
    def dataproc_cluster(self) -> Optional[_builtins.str]:
        """
        Resource name of an existing Dataproc Cluster to act as a Spark History Server for the workload.
        """
        return pulumi.get(self, "dataproc_cluster")


@pulumi.output_type
class BatchPysparkBatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveUris":
            suggest = "archive_uris"
        elif key == "fileUris":
            suggest = "file_uris"
        elif key == "jarFileUris":
            suggest = "jar_file_uris"
        elif key == "mainPythonFileUri":
            suggest = "main_python_file_uri"
        elif key == "pythonFileUris":
            suggest = "python_file_uris"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchPysparkBatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchPysparkBatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchPysparkBatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_uris: Optional[Sequence[_builtins.str]] = None,
                 args: Optional[Sequence[_builtins.str]] = None,
                 file_uris: Optional[Sequence[_builtins.str]] = None,
                 jar_file_uris: Optional[Sequence[_builtins.str]] = None,
                 main_python_file_uri: Optional[_builtins.str] = None,
                 python_file_uris: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] archive_uris: HCFS URIs of archives to be extracted into the working directory of each executor.
               Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        :param Sequence[_builtins.str] args: The arguments to pass to the driver. Do not include arguments that can be set as batch
               properties, such as --conf, since a collision can occur that causes an incorrect batch submission.
        :param Sequence[_builtins.str] file_uris: HCFS URIs of files to be placed in the working directory of each executor.
        :param Sequence[_builtins.str] jar_file_uris: HCFS URIs of jar files to add to the classpath of the Spark driver and tasks.
        :param _builtins.str main_python_file_uri: The HCFS URI of the main Python file to use as the Spark driver. Must be a .py file.
        :param Sequence[_builtins.str] python_file_uris: HCFS file URIs of Python files to pass to the PySpark framework.
               Supported file types: .py, .egg, and .zip.
        """
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if main_python_file_uri is not None:
            pulumi.set(__self__, "main_python_file_uri", main_python_file_uri)
        if python_file_uris is not None:
            pulumi.set(__self__, "python_file_uris", python_file_uris)

    @_builtins.property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of archives to be extracted into the working directory of each executor.
        Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        The arguments to pass to the driver. Do not include arguments that can be set as batch
        properties, such as --conf, since a collision can occur that causes an incorrect batch submission.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of files to be placed in the working directory of each executor.
        """
        return pulumi.get(self, "file_uris")

    @_builtins.property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of jar files to add to the classpath of the Spark driver and tasks.
        """
        return pulumi.get(self, "jar_file_uris")

    @_builtins.property
    @pulumi.getter(name="mainPythonFileUri")
    def main_python_file_uri(self) -> Optional[_builtins.str]:
        """
        The HCFS URI of the main Python file to use as the Spark driver. Must be a .py file.
        """
        return pulumi.get(self, "main_python_file_uri")

    @_builtins.property
    @pulumi.getter(name="pythonFileUris")
    def python_file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS file URIs of Python files to pass to the PySpark framework.
        Supported file types: .py, .egg, and .zip.
        """
        return pulumi.get(self, "python_file_uris")


@pulumi.output_type
class BatchRuntimeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autotuningConfig":
            suggest = "autotuning_config"
        elif key == "containerImage":
            suggest = "container_image"
        elif key == "effectiveProperties":
            suggest = "effective_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchRuntimeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchRuntimeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchRuntimeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autotuning_config: Optional['outputs.BatchRuntimeConfigAutotuningConfig'] = None,
                 cohort: Optional[_builtins.str] = None,
                 container_image: Optional[_builtins.str] = None,
                 effective_properties: Optional[Mapping[str, _builtins.str]] = None,
                 properties: Optional[Mapping[str, _builtins.str]] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param 'BatchRuntimeConfigAutotuningConfigArgs' autotuning_config: Optional. Autotuning configuration of the workload.
               Structure is documented below.
        :param _builtins.str cohort: Optional. Cohort identifier. Identifies families of the workloads having the same shape, e.g. daily ETL jobs.
        :param _builtins.str container_image: Optional custom container image for the job runtime environment. If not specified, a default container image will be used.
        :param Mapping[str, _builtins.str] effective_properties: (Output)
               A mapping of property names to values, which are used to configure workload execution.
        :param Mapping[str, _builtins.str] properties: A mapping of property names to values, which are used to configure workload execution.
        :param _builtins.str version: Version of the batch runtime.
        """
        if autotuning_config is not None:
            pulumi.set(__self__, "autotuning_config", autotuning_config)
        if cohort is not None:
            pulumi.set(__self__, "cohort", cohort)
        if container_image is not None:
            pulumi.set(__self__, "container_image", container_image)
        if effective_properties is not None:
            pulumi.set(__self__, "effective_properties", effective_properties)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="autotuningConfig")
    def autotuning_config(self) -> Optional['outputs.BatchRuntimeConfigAutotuningConfig']:
        """
        Optional. Autotuning configuration of the workload.
        Structure is documented below.
        """
        return pulumi.get(self, "autotuning_config")

    @_builtins.property
    @pulumi.getter
    def cohort(self) -> Optional[_builtins.str]:
        """
        Optional. Cohort identifier. Identifies families of the workloads having the same shape, e.g. daily ETL jobs.
        """
        return pulumi.get(self, "cohort")

    @_builtins.property
    @pulumi.getter(name="containerImage")
    def container_image(self) -> Optional[_builtins.str]:
        """
        Optional custom container image for the job runtime environment. If not specified, a default container image will be used.
        """
        return pulumi.get(self, "container_image")

    @_builtins.property
    @pulumi.getter(name="effectiveProperties")
    def effective_properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        (Output)
        A mapping of property names to values, which are used to configure workload execution.
        """
        return pulumi.get(self, "effective_properties")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of property names to values, which are used to configure workload execution.
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        Version of the batch runtime.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class BatchRuntimeConfigAutotuningConfig(dict):
    def __init__(__self__, *,
                 scenarios: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] scenarios: Optional. Scenarios for which tunings are applied.
               Each value may be one of: `SCALING`, `BROADCAST_HASH_JOIN`, `MEMORY`.
        """
        if scenarios is not None:
            pulumi.set(__self__, "scenarios", scenarios)

    @_builtins.property
    @pulumi.getter
    def scenarios(self) -> Optional[Sequence[_builtins.str]]:
        """
        Optional. Scenarios for which tunings are applied.
        Each value may be one of: `SCALING`, `BROADCAST_HASH_JOIN`, `MEMORY`.
        """
        return pulumi.get(self, "scenarios")


@pulumi.output_type
class BatchRuntimeInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "approximateUsages":
            suggest = "approximate_usages"
        elif key == "currentUsages":
            suggest = "current_usages"
        elif key == "diagnosticOutputUri":
            suggest = "diagnostic_output_uri"
        elif key == "outputUri":
            suggest = "output_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchRuntimeInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchRuntimeInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchRuntimeInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 approximate_usages: Optional[Sequence['outputs.BatchRuntimeInfoApproximateUsage']] = None,
                 current_usages: Optional[Sequence['outputs.BatchRuntimeInfoCurrentUsage']] = None,
                 diagnostic_output_uri: Optional[_builtins.str] = None,
                 endpoints: Optional[Mapping[str, _builtins.str]] = None,
                 output_uri: Optional[_builtins.str] = None):
        """
        :param Sequence['BatchRuntimeInfoApproximateUsageArgs'] approximate_usages: (Output)
               Approximate workload resource usage, calculated when the workload completes(see [Dataproc Serverless pricing](https://cloud.google.com/dataproc-serverless/pricing))
               Structure is documented below.
        :param Sequence['BatchRuntimeInfoCurrentUsageArgs'] current_usages: (Output)
               Snapshot of current workload resource usage(see [Dataproc Serverless pricing](https://cloud.google.com/dataproc-serverless/pricing))
               Structure is documented below.
        :param _builtins.str diagnostic_output_uri: (Output)
               A URI pointing to the location of the diagnostics tarball.
        :param Mapping[str, _builtins.str] endpoints: (Output)
               Map of remote access endpoints (such as web interfaces and APIs) to their URIs.
        :param _builtins.str output_uri: (Output)
               A URI pointing to the location of the stdout and stderr of the workload.
        """
        if approximate_usages is not None:
            pulumi.set(__self__, "approximate_usages", approximate_usages)
        if current_usages is not None:
            pulumi.set(__self__, "current_usages", current_usages)
        if diagnostic_output_uri is not None:
            pulumi.set(__self__, "diagnostic_output_uri", diagnostic_output_uri)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if output_uri is not None:
            pulumi.set(__self__, "output_uri", output_uri)

    @_builtins.property
    @pulumi.getter(name="approximateUsages")
    def approximate_usages(self) -> Optional[Sequence['outputs.BatchRuntimeInfoApproximateUsage']]:
        """
        (Output)
        Approximate workload resource usage, calculated when the workload completes(see [Dataproc Serverless pricing](https://cloud.google.com/dataproc-serverless/pricing))
        Structure is documented below.
        """
        return pulumi.get(self, "approximate_usages")

    @_builtins.property
    @pulumi.getter(name="currentUsages")
    def current_usages(self) -> Optional[Sequence['outputs.BatchRuntimeInfoCurrentUsage']]:
        """
        (Output)
        Snapshot of current workload resource usage(see [Dataproc Serverless pricing](https://cloud.google.com/dataproc-serverless/pricing))
        Structure is documented below.
        """
        return pulumi.get(self, "current_usages")

    @_builtins.property
    @pulumi.getter(name="diagnosticOutputUri")
    def diagnostic_output_uri(self) -> Optional[_builtins.str]:
        """
        (Output)
        A URI pointing to the location of the diagnostics tarball.
        """
        return pulumi.get(self, "diagnostic_output_uri")

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        (Output)
        Map of remote access endpoints (such as web interfaces and APIs) to their URIs.
        """
        return pulumi.get(self, "endpoints")

    @_builtins.property
    @pulumi.getter(name="outputUri")
    def output_uri(self) -> Optional[_builtins.str]:
        """
        (Output)
        A URI pointing to the location of the stdout and stderr of the workload.
        """
        return pulumi.get(self, "output_uri")


@pulumi.output_type
class BatchRuntimeInfoApproximateUsage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceleratorType":
            suggest = "accelerator_type"
        elif key == "milliAcceleratorSeconds":
            suggest = "milli_accelerator_seconds"
        elif key == "milliDcuSeconds":
            suggest = "milli_dcu_seconds"
        elif key == "shuffleStorageGbSeconds":
            suggest = "shuffle_storage_gb_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchRuntimeInfoApproximateUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchRuntimeInfoApproximateUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchRuntimeInfoApproximateUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerator_type: Optional[_builtins.str] = None,
                 milli_accelerator_seconds: Optional[_builtins.str] = None,
                 milli_dcu_seconds: Optional[_builtins.str] = None,
                 shuffle_storage_gb_seconds: Optional[_builtins.str] = None):
        """
        :param _builtins.str accelerator_type: (Output)
               Accelerator type being used, if any.
        :param _builtins.str milli_accelerator_seconds: (Output)
               Accelerator usage in (milliAccelerator x seconds)
        :param _builtins.str milli_dcu_seconds: (Output)
               DCU (Dataproc Compute Units) usage in (milliDCU x seconds)
        :param _builtins.str shuffle_storage_gb_seconds: (Output)
               Shuffle storage usage in (GB x seconds)
        """
        if accelerator_type is not None:
            pulumi.set(__self__, "accelerator_type", accelerator_type)
        if milli_accelerator_seconds is not None:
            pulumi.set(__self__, "milli_accelerator_seconds", milli_accelerator_seconds)
        if milli_dcu_seconds is not None:
            pulumi.set(__self__, "milli_dcu_seconds", milli_dcu_seconds)
        if shuffle_storage_gb_seconds is not None:
            pulumi.set(__self__, "shuffle_storage_gb_seconds", shuffle_storage_gb_seconds)

    @_builtins.property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> Optional[_builtins.str]:
        """
        (Output)
        Accelerator type being used, if any.
        """
        return pulumi.get(self, "accelerator_type")

    @_builtins.property
    @pulumi.getter(name="milliAcceleratorSeconds")
    def milli_accelerator_seconds(self) -> Optional[_builtins.str]:
        """
        (Output)
        Accelerator usage in (milliAccelerator x seconds)
        """
        return pulumi.get(self, "milli_accelerator_seconds")

    @_builtins.property
    @pulumi.getter(name="milliDcuSeconds")
    def milli_dcu_seconds(self) -> Optional[_builtins.str]:
        """
        (Output)
        DCU (Dataproc Compute Units) usage in (milliDCU x seconds)
        """
        return pulumi.get(self, "milli_dcu_seconds")

    @_builtins.property
    @pulumi.getter(name="shuffleStorageGbSeconds")
    def shuffle_storage_gb_seconds(self) -> Optional[_builtins.str]:
        """
        (Output)
        Shuffle storage usage in (GB x seconds)
        """
        return pulumi.get(self, "shuffle_storage_gb_seconds")


@pulumi.output_type
class BatchRuntimeInfoCurrentUsage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceleratorType":
            suggest = "accelerator_type"
        elif key == "milliAccelerator":
            suggest = "milli_accelerator"
        elif key == "milliDcu":
            suggest = "milli_dcu"
        elif key == "milliDcuPremium":
            suggest = "milli_dcu_premium"
        elif key == "shuffleStorageGb":
            suggest = "shuffle_storage_gb"
        elif key == "shuffleStorageGbPremium":
            suggest = "shuffle_storage_gb_premium"
        elif key == "snapshotTime":
            suggest = "snapshot_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchRuntimeInfoCurrentUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchRuntimeInfoCurrentUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchRuntimeInfoCurrentUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerator_type: Optional[_builtins.str] = None,
                 milli_accelerator: Optional[_builtins.str] = None,
                 milli_dcu: Optional[_builtins.str] = None,
                 milli_dcu_premium: Optional[_builtins.str] = None,
                 shuffle_storage_gb: Optional[_builtins.str] = None,
                 shuffle_storage_gb_premium: Optional[_builtins.str] = None,
                 snapshot_time: Optional[_builtins.str] = None):
        """
        :param _builtins.str accelerator_type: (Output)
               Accelerator type being used, if any.
        :param _builtins.str milli_accelerator: (Output)
               Milli (one-thousandth) accelerator..
        :param _builtins.str milli_dcu: (Output)
               Milli (one-thousandth) Dataproc Compute Units (DCUs).
        :param _builtins.str milli_dcu_premium: (Output)
               Milli (one-thousandth) Dataproc Compute Units (DCUs) charged at premium tier.
        :param _builtins.str shuffle_storage_gb: (Output)
               Shuffle Storage in gigabytes (GB).
        :param _builtins.str shuffle_storage_gb_premium: (Output)
               Shuffle Storage in gigabytes (GB) charged at premium tier.
        :param _builtins.str snapshot_time: (Output)
               The timestamp of the usage snapshot.
        """
        if accelerator_type is not None:
            pulumi.set(__self__, "accelerator_type", accelerator_type)
        if milli_accelerator is not None:
            pulumi.set(__self__, "milli_accelerator", milli_accelerator)
        if milli_dcu is not None:
            pulumi.set(__self__, "milli_dcu", milli_dcu)
        if milli_dcu_premium is not None:
            pulumi.set(__self__, "milli_dcu_premium", milli_dcu_premium)
        if shuffle_storage_gb is not None:
            pulumi.set(__self__, "shuffle_storage_gb", shuffle_storage_gb)
        if shuffle_storage_gb_premium is not None:
            pulumi.set(__self__, "shuffle_storage_gb_premium", shuffle_storage_gb_premium)
        if snapshot_time is not None:
            pulumi.set(__self__, "snapshot_time", snapshot_time)

    @_builtins.property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> Optional[_builtins.str]:
        """
        (Output)
        Accelerator type being used, if any.
        """
        return pulumi.get(self, "accelerator_type")

    @_builtins.property
    @pulumi.getter(name="milliAccelerator")
    def milli_accelerator(self) -> Optional[_builtins.str]:
        """
        (Output)
        Milli (one-thousandth) accelerator..
        """
        return pulumi.get(self, "milli_accelerator")

    @_builtins.property
    @pulumi.getter(name="milliDcu")
    def milli_dcu(self) -> Optional[_builtins.str]:
        """
        (Output)
        Milli (one-thousandth) Dataproc Compute Units (DCUs).
        """
        return pulumi.get(self, "milli_dcu")

    @_builtins.property
    @pulumi.getter(name="milliDcuPremium")
    def milli_dcu_premium(self) -> Optional[_builtins.str]:
        """
        (Output)
        Milli (one-thousandth) Dataproc Compute Units (DCUs) charged at premium tier.
        """
        return pulumi.get(self, "milli_dcu_premium")

    @_builtins.property
    @pulumi.getter(name="shuffleStorageGb")
    def shuffle_storage_gb(self) -> Optional[_builtins.str]:
        """
        (Output)
        Shuffle Storage in gigabytes (GB).
        """
        return pulumi.get(self, "shuffle_storage_gb")

    @_builtins.property
    @pulumi.getter(name="shuffleStorageGbPremium")
    def shuffle_storage_gb_premium(self) -> Optional[_builtins.str]:
        """
        (Output)
        Shuffle Storage in gigabytes (GB) charged at premium tier.
        """
        return pulumi.get(self, "shuffle_storage_gb_premium")

    @_builtins.property
    @pulumi.getter(name="snapshotTime")
    def snapshot_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        The timestamp of the usage snapshot.
        """
        return pulumi.get(self, "snapshot_time")


@pulumi.output_type
class BatchSparkBatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveUris":
            suggest = "archive_uris"
        elif key == "fileUris":
            suggest = "file_uris"
        elif key == "jarFileUris":
            suggest = "jar_file_uris"
        elif key == "mainClass":
            suggest = "main_class"
        elif key == "mainJarFileUri":
            suggest = "main_jar_file_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchSparkBatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchSparkBatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchSparkBatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_uris: Optional[Sequence[_builtins.str]] = None,
                 args: Optional[Sequence[_builtins.str]] = None,
                 file_uris: Optional[Sequence[_builtins.str]] = None,
                 jar_file_uris: Optional[Sequence[_builtins.str]] = None,
                 main_class: Optional[_builtins.str] = None,
                 main_jar_file_uri: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] archive_uris: HCFS URIs of archives to be extracted into the working directory of each executor.
               Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        :param Sequence[_builtins.str] args: The arguments to pass to the driver. Do not include arguments that can be set as batch
               properties, such as --conf, since a collision can occur that causes an incorrect batch submission.
        :param Sequence[_builtins.str] file_uris: HCFS URIs of files to be placed in the working directory of each executor.
        :param Sequence[_builtins.str] jar_file_uris: HCFS URIs of jar files to add to the classpath of the Spark driver and tasks.
        :param _builtins.str main_class: The name of the driver main class. The jar file that contains the class must be in the
               classpath or specified in jarFileUris.
        :param _builtins.str main_jar_file_uri: The HCFS URI of the jar file that contains the main class.
        """
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if main_class is not None:
            pulumi.set(__self__, "main_class", main_class)
        if main_jar_file_uri is not None:
            pulumi.set(__self__, "main_jar_file_uri", main_jar_file_uri)

    @_builtins.property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of archives to be extracted into the working directory of each executor.
        Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        The arguments to pass to the driver. Do not include arguments that can be set as batch
        properties, such as --conf, since a collision can occur that causes an incorrect batch submission.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of files to be placed in the working directory of each executor.
        """
        return pulumi.get(self, "file_uris")

    @_builtins.property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of jar files to add to the classpath of the Spark driver and tasks.
        """
        return pulumi.get(self, "jar_file_uris")

    @_builtins.property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> Optional[_builtins.str]:
        """
        The name of the driver main class. The jar file that contains the class must be in the
        classpath or specified in jarFileUris.
        """
        return pulumi.get(self, "main_class")

    @_builtins.property
    @pulumi.getter(name="mainJarFileUri")
    def main_jar_file_uri(self) -> Optional[_builtins.str]:
        """
        The HCFS URI of the jar file that contains the main class.
        """
        return pulumi.get(self, "main_jar_file_uri")


@pulumi.output_type
class BatchSparkRBatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveUris":
            suggest = "archive_uris"
        elif key == "fileUris":
            suggest = "file_uris"
        elif key == "mainRFileUri":
            suggest = "main_r_file_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchSparkRBatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchSparkRBatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchSparkRBatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_uris: Optional[Sequence[_builtins.str]] = None,
                 args: Optional[Sequence[_builtins.str]] = None,
                 file_uris: Optional[Sequence[_builtins.str]] = None,
                 main_r_file_uri: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] archive_uris: HCFS URIs of archives to be extracted into the working directory of each executor.
               Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        :param Sequence[_builtins.str] args: The arguments to pass to the driver. Do not include arguments that can be set as batch
               properties, such as --conf, since a collision can occur that causes an incorrect batch submission.
        :param Sequence[_builtins.str] file_uris: HCFS URIs of files to be placed in the working directory of each executor.
        :param _builtins.str main_r_file_uri: The HCFS URI of the main R file to use as the driver. Must be a .R or .r file.
        """
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if main_r_file_uri is not None:
            pulumi.set(__self__, "main_r_file_uri", main_r_file_uri)

    @_builtins.property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of archives to be extracted into the working directory of each executor.
        Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        The arguments to pass to the driver. Do not include arguments that can be set as batch
        properties, such as --conf, since a collision can occur that causes an incorrect batch submission.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of files to be placed in the working directory of each executor.
        """
        return pulumi.get(self, "file_uris")

    @_builtins.property
    @pulumi.getter(name="mainRFileUri")
    def main_r_file_uri(self) -> Optional[_builtins.str]:
        """
        The HCFS URI of the main R file to use as the driver. Must be a .R or .r file.
        """
        return pulumi.get(self, "main_r_file_uri")


@pulumi.output_type
class BatchSparkSqlBatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jarFileUris":
            suggest = "jar_file_uris"
        elif key == "queryFileUri":
            suggest = "query_file_uri"
        elif key == "queryVariables":
            suggest = "query_variables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchSparkSqlBatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchSparkSqlBatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchSparkSqlBatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 jar_file_uris: Optional[Sequence[_builtins.str]] = None,
                 query_file_uri: Optional[_builtins.str] = None,
                 query_variables: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Sequence[_builtins.str] jar_file_uris: HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param _builtins.str query_file_uri: The HCFS URI of the script that contains Spark SQL queries to execute.
        :param Mapping[str, _builtins.str] query_variables: Mapping of query variable names to values (equivalent to the Spark SQL command: SET name="value";).
        """
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if query_file_uri is not None:
            pulumi.set(__self__, "query_file_uri", query_file_uri)
        if query_variables is not None:
            pulumi.set(__self__, "query_variables", query_variables)

    @_builtins.property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @_builtins.property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> Optional[_builtins.str]:
        """
        The HCFS URI of the script that contains Spark SQL queries to execute.
        """
        return pulumi.get(self, "query_file_uri")

    @_builtins.property
    @pulumi.getter(name="queryVariables")
    def query_variables(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Mapping of query variable names to values (equivalent to the Spark SQL command: SET name="value";).
        """
        return pulumi.get(self, "query_variables")


@pulumi.output_type
class BatchStateHistory(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stateMessage":
            suggest = "state_message"
        elif key == "stateStartTime":
            suggest = "state_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchStateHistory. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchStateHistory.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchStateHistory.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 state: Optional[_builtins.str] = None,
                 state_message: Optional[_builtins.str] = None,
                 state_start_time: Optional[_builtins.str] = None):
        """
        :param _builtins.str state: (Output)
               The state of the batch at this point in history. For possible values, see the [API documentation](https://cloud.google.com/dataproc-serverless/docs/reference/rest/v1/projects.locations.batches#State).
        :param _builtins.str state_message: (Output)
               Details about the state at this point in history.
        :param _builtins.str state_start_time: (Output)
               The time when the batch entered the historical state.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_message is not None:
            pulumi.set(__self__, "state_message", state_message)
        if state_start_time is not None:
            pulumi.set(__self__, "state_start_time", state_start_time)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        (Output)
        The state of the batch at this point in history. For possible values, see the [API documentation](https://cloud.google.com/dataproc-serverless/docs/reference/rest/v1/projects.locations.batches#State).
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> Optional[_builtins.str]:
        """
        (Output)
        Details about the state at this point in history.
        """
        return pulumi.get(self, "state_message")

    @_builtins.property
    @pulumi.getter(name="stateStartTime")
    def state_start_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        The time when the batch entered the historical state.
        """
        return pulumi.get(self, "state_start_time")


@pulumi.output_type
class ClusterClusterConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscalingConfig":
            suggest = "autoscaling_config"
        elif key == "auxiliaryNodeGroups":
            suggest = "auxiliary_node_groups"
        elif key == "clusterTier":
            suggest = "cluster_tier"
        elif key == "dataprocMetricConfig":
            suggest = "dataproc_metric_config"
        elif key == "encryptionConfig":
            suggest = "encryption_config"
        elif key == "endpointConfig":
            suggest = "endpoint_config"
        elif key == "gceClusterConfig":
            suggest = "gce_cluster_config"
        elif key == "initializationActions":
            suggest = "initialization_actions"
        elif key == "lifecycleConfig":
            suggest = "lifecycle_config"
        elif key == "masterConfig":
            suggest = "master_config"
        elif key == "metastoreConfig":
            suggest = "metastore_config"
        elif key == "preemptibleWorkerConfig":
            suggest = "preemptible_worker_config"
        elif key == "securityConfig":
            suggest = "security_config"
        elif key == "softwareConfig":
            suggest = "software_config"
        elif key == "stagingBucket":
            suggest = "staging_bucket"
        elif key == "tempBucket":
            suggest = "temp_bucket"
        elif key == "workerConfig":
            suggest = "worker_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscaling_config: Optional['outputs.ClusterClusterConfigAutoscalingConfig'] = None,
                 auxiliary_node_groups: Optional[Sequence['outputs.ClusterClusterConfigAuxiliaryNodeGroup']] = None,
                 bucket: Optional[_builtins.str] = None,
                 cluster_tier: Optional[_builtins.str] = None,
                 dataproc_metric_config: Optional['outputs.ClusterClusterConfigDataprocMetricConfig'] = None,
                 encryption_config: Optional['outputs.ClusterClusterConfigEncryptionConfig'] = None,
                 endpoint_config: Optional['outputs.ClusterClusterConfigEndpointConfig'] = None,
                 gce_cluster_config: Optional['outputs.ClusterClusterConfigGceClusterConfig'] = None,
                 initialization_actions: Optional[Sequence['outputs.ClusterClusterConfigInitializationAction']] = None,
                 lifecycle_config: Optional['outputs.ClusterClusterConfigLifecycleConfig'] = None,
                 master_config: Optional['outputs.ClusterClusterConfigMasterConfig'] = None,
                 metastore_config: Optional['outputs.ClusterClusterConfigMetastoreConfig'] = None,
                 preemptible_worker_config: Optional['outputs.ClusterClusterConfigPreemptibleWorkerConfig'] = None,
                 security_config: Optional['outputs.ClusterClusterConfigSecurityConfig'] = None,
                 software_config: Optional['outputs.ClusterClusterConfigSoftwareConfig'] = None,
                 staging_bucket: Optional[_builtins.str] = None,
                 temp_bucket: Optional[_builtins.str] = None,
                 worker_config: Optional['outputs.ClusterClusterConfigWorkerConfig'] = None):
        """
        :param 'ClusterClusterConfigAutoscalingConfigArgs' autoscaling_config: The autoscaling policy config associated with the cluster.
               Note that once set, if `autoscaling_config` is the only field set in `cluster_config`, it can
               only be removed by setting `policy_uri = ""`, rather than removing the whole block.
               Structure defined below.
        :param Sequence['ClusterClusterConfigAuxiliaryNodeGroupArgs'] auxiliary_node_groups: A Dataproc NodeGroup resource is a group of Dataproc cluster nodes that execute an assigned role. 
               Structure defined below.
        :param _builtins.str bucket: The name of the cloud storage bucket ultimately used to house the staging data
               for the cluster. If `staging_bucket` is specified, it will contain this value, otherwise
               it will be the auto generated name.
        :param _builtins.str cluster_tier: The tier of the cluster.
        :param 'ClusterClusterConfigDataprocMetricConfigArgs' dataproc_metric_config: The Compute Engine accelerator (GPU) configuration for these instances. Can be specified multiple times.
               Structure defined below.
        :param 'ClusterClusterConfigEncryptionConfigArgs' encryption_config: The Customer managed encryption keys settings for the cluster.
               Structure defined below.
        :param 'ClusterClusterConfigEndpointConfigArgs' endpoint_config: The config settings for port access on the cluster.
               Structure defined below.
        :param 'ClusterClusterConfigGceClusterConfigArgs' gce_cluster_config: Common config settings for resources of Google Compute Engine cluster
               instances, applicable to all instances in the cluster. Structure defined below.
        :param Sequence['ClusterClusterConfigInitializationActionArgs'] initialization_actions: Commands to execute on each node after config is completed.
               You can specify multiple versions of these. Structure defined below.
        :param 'ClusterClusterConfigLifecycleConfigArgs' lifecycle_config: The settings for auto deletion cluster schedule.
               Structure defined below.
        :param 'ClusterClusterConfigMasterConfigArgs' master_config: The Google Compute Engine config settings for the master instances
               in a cluster. Structure defined below.
        :param 'ClusterClusterConfigMetastoreConfigArgs' metastore_config: The config setting for metastore service with the cluster.
               Structure defined below.
               - - -
        :param 'ClusterClusterConfigPreemptibleWorkerConfigArgs' preemptible_worker_config: The Google Compute Engine config settings for the additional
               instances in a cluster. Structure defined below.
               * **NOTE** : `preemptible_worker_config` is
               an alias for the api's [secondaryWorkerConfig](https://cloud.google.com/dataproc/docs/reference/rest/v1/ClusterConfig#InstanceGroupConfig). The name doesn't necessarily mean it is preemptible and is named as
               such for legacy/compatibility reasons.
        :param 'ClusterClusterConfigSecurityConfigArgs' security_config: Security related configuration. Structure defined below.
        :param 'ClusterClusterConfigSoftwareConfigArgs' software_config: The config settings for software inside the cluster.
               Structure defined below.
        :param _builtins.str staging_bucket: The Cloud Storage staging bucket used to stage files,
               such as Hadoop jars, between client machines and the cluster.
               Note: If you don't explicitly specify a `staging_bucket`
               then GCP will auto create / assign one for you. However, you are not guaranteed
               an auto generated bucket which is solely dedicated to your cluster; it may be shared
               with other clusters in the same region/zone also choosing to use the auto generation
               option.
        :param _builtins.str temp_bucket: The Cloud Storage temp bucket used to store ephemeral cluster
               and jobs data, such as Spark and MapReduce history files.
               Note: If you don't explicitly specify a `temp_bucket` then GCP will auto create / assign one for you.
        :param 'ClusterClusterConfigWorkerConfigArgs' worker_config: The Google Compute Engine config settings for the worker instances
               in a cluster. Structure defined below.
        """
        if autoscaling_config is not None:
            pulumi.set(__self__, "autoscaling_config", autoscaling_config)
        if auxiliary_node_groups is not None:
            pulumi.set(__self__, "auxiliary_node_groups", auxiliary_node_groups)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if cluster_tier is not None:
            pulumi.set(__self__, "cluster_tier", cluster_tier)
        if dataproc_metric_config is not None:
            pulumi.set(__self__, "dataproc_metric_config", dataproc_metric_config)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if endpoint_config is not None:
            pulumi.set(__self__, "endpoint_config", endpoint_config)
        if gce_cluster_config is not None:
            pulumi.set(__self__, "gce_cluster_config", gce_cluster_config)
        if initialization_actions is not None:
            pulumi.set(__self__, "initialization_actions", initialization_actions)
        if lifecycle_config is not None:
            pulumi.set(__self__, "lifecycle_config", lifecycle_config)
        if master_config is not None:
            pulumi.set(__self__, "master_config", master_config)
        if metastore_config is not None:
            pulumi.set(__self__, "metastore_config", metastore_config)
        if preemptible_worker_config is not None:
            pulumi.set(__self__, "preemptible_worker_config", preemptible_worker_config)
        if security_config is not None:
            pulumi.set(__self__, "security_config", security_config)
        if software_config is not None:
            pulumi.set(__self__, "software_config", software_config)
        if staging_bucket is not None:
            pulumi.set(__self__, "staging_bucket", staging_bucket)
        if temp_bucket is not None:
            pulumi.set(__self__, "temp_bucket", temp_bucket)
        if worker_config is not None:
            pulumi.set(__self__, "worker_config", worker_config)

    @_builtins.property
    @pulumi.getter(name="autoscalingConfig")
    def autoscaling_config(self) -> Optional['outputs.ClusterClusterConfigAutoscalingConfig']:
        """
        The autoscaling policy config associated with the cluster.
        Note that once set, if `autoscaling_config` is the only field set in `cluster_config`, it can
        only be removed by setting `policy_uri = ""`, rather than removing the whole block.
        Structure defined below.
        """
        return pulumi.get(self, "autoscaling_config")

    @_builtins.property
    @pulumi.getter(name="auxiliaryNodeGroups")
    def auxiliary_node_groups(self) -> Optional[Sequence['outputs.ClusterClusterConfigAuxiliaryNodeGroup']]:
        """
        A Dataproc NodeGroup resource is a group of Dataproc cluster nodes that execute an assigned role. 
        Structure defined below.
        """
        return pulumi.get(self, "auxiliary_node_groups")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[_builtins.str]:
        """
        The name of the cloud storage bucket ultimately used to house the staging data
        for the cluster. If `staging_bucket` is specified, it will contain this value, otherwise
        it will be the auto generated name.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="clusterTier")
    def cluster_tier(self) -> Optional[_builtins.str]:
        """
        The tier of the cluster.
        """
        return pulumi.get(self, "cluster_tier")

    @_builtins.property
    @pulumi.getter(name="dataprocMetricConfig")
    def dataproc_metric_config(self) -> Optional['outputs.ClusterClusterConfigDataprocMetricConfig']:
        """
        The Compute Engine accelerator (GPU) configuration for these instances. Can be specified multiple times.
        Structure defined below.
        """
        return pulumi.get(self, "dataproc_metric_config")

    @_builtins.property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional['outputs.ClusterClusterConfigEncryptionConfig']:
        """
        The Customer managed encryption keys settings for the cluster.
        Structure defined below.
        """
        return pulumi.get(self, "encryption_config")

    @_builtins.property
    @pulumi.getter(name="endpointConfig")
    def endpoint_config(self) -> Optional['outputs.ClusterClusterConfigEndpointConfig']:
        """
        The config settings for port access on the cluster.
        Structure defined below.
        """
        return pulumi.get(self, "endpoint_config")

    @_builtins.property
    @pulumi.getter(name="gceClusterConfig")
    def gce_cluster_config(self) -> Optional['outputs.ClusterClusterConfigGceClusterConfig']:
        """
        Common config settings for resources of Google Compute Engine cluster
        instances, applicable to all instances in the cluster. Structure defined below.
        """
        return pulumi.get(self, "gce_cluster_config")

    @_builtins.property
    @pulumi.getter(name="initializationActions")
    def initialization_actions(self) -> Optional[Sequence['outputs.ClusterClusterConfigInitializationAction']]:
        """
        Commands to execute on each node after config is completed.
        You can specify multiple versions of these. Structure defined below.
        """
        return pulumi.get(self, "initialization_actions")

    @_builtins.property
    @pulumi.getter(name="lifecycleConfig")
    def lifecycle_config(self) -> Optional['outputs.ClusterClusterConfigLifecycleConfig']:
        """
        The settings for auto deletion cluster schedule.
        Structure defined below.
        """
        return pulumi.get(self, "lifecycle_config")

    @_builtins.property
    @pulumi.getter(name="masterConfig")
    def master_config(self) -> Optional['outputs.ClusterClusterConfigMasterConfig']:
        """
        The Google Compute Engine config settings for the master instances
        in a cluster. Structure defined below.
        """
        return pulumi.get(self, "master_config")

    @_builtins.property
    @pulumi.getter(name="metastoreConfig")
    def metastore_config(self) -> Optional['outputs.ClusterClusterConfigMetastoreConfig']:
        """
        The config setting for metastore service with the cluster.
        Structure defined below.
        - - -
        """
        return pulumi.get(self, "metastore_config")

    @_builtins.property
    @pulumi.getter(name="preemptibleWorkerConfig")
    def preemptible_worker_config(self) -> Optional['outputs.ClusterClusterConfigPreemptibleWorkerConfig']:
        """
        The Google Compute Engine config settings for the additional
        instances in a cluster. Structure defined below.
        * **NOTE** : `preemptible_worker_config` is
        an alias for the api's [secondaryWorkerConfig](https://cloud.google.com/dataproc/docs/reference/rest/v1/ClusterConfig#InstanceGroupConfig). The name doesn't necessarily mean it is preemptible and is named as
        such for legacy/compatibility reasons.
        """
        return pulumi.get(self, "preemptible_worker_config")

    @_builtins.property
    @pulumi.getter(name="securityConfig")
    def security_config(self) -> Optional['outputs.ClusterClusterConfigSecurityConfig']:
        """
        Security related configuration. Structure defined below.
        """
        return pulumi.get(self, "security_config")

    @_builtins.property
    @pulumi.getter(name="softwareConfig")
    def software_config(self) -> Optional['outputs.ClusterClusterConfigSoftwareConfig']:
        """
        The config settings for software inside the cluster.
        Structure defined below.
        """
        return pulumi.get(self, "software_config")

    @_builtins.property
    @pulumi.getter(name="stagingBucket")
    def staging_bucket(self) -> Optional[_builtins.str]:
        """
        The Cloud Storage staging bucket used to stage files,
        such as Hadoop jars, between client machines and the cluster.
        Note: If you don't explicitly specify a `staging_bucket`
        then GCP will auto create / assign one for you. However, you are not guaranteed
        an auto generated bucket which is solely dedicated to your cluster; it may be shared
        with other clusters in the same region/zone also choosing to use the auto generation
        option.
        """
        return pulumi.get(self, "staging_bucket")

    @_builtins.property
    @pulumi.getter(name="tempBucket")
    def temp_bucket(self) -> Optional[_builtins.str]:
        """
        The Cloud Storage temp bucket used to store ephemeral cluster
        and jobs data, such as Spark and MapReduce history files.
        Note: If you don't explicitly specify a `temp_bucket` then GCP will auto create / assign one for you.
        """
        return pulumi.get(self, "temp_bucket")

    @_builtins.property
    @pulumi.getter(name="workerConfig")
    def worker_config(self) -> Optional['outputs.ClusterClusterConfigWorkerConfig']:
        """
        The Google Compute Engine config settings for the worker instances
        in a cluster. Structure defined below.
        """
        return pulumi.get(self, "worker_config")


@pulumi.output_type
class ClusterClusterConfigAutoscalingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyUri":
            suggest = "policy_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigAutoscalingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigAutoscalingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigAutoscalingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_uri: _builtins.str):
        """
        :param _builtins.str policy_uri: The autoscaling policy used by the cluster.
               
               Only resource names including projectid and location (region) are valid. Examples:
               
               `https://www.googleapis.com/compute/v1/projects/[projectId]/locations/[dataproc_region]/autoscalingPolicies/[policy_id]`
               `projects/[projectId]/locations/[dataproc_region]/autoscalingPolicies/[policy_id]`
               Note that the policy must be in the same project and Cloud Dataproc region.
               
               - - -
        """
        pulumi.set(__self__, "policy_uri", policy_uri)

    @_builtins.property
    @pulumi.getter(name="policyUri")
    def policy_uri(self) -> _builtins.str:
        """
        The autoscaling policy used by the cluster.

        Only resource names including projectid and location (region) are valid. Examples:

        `https://www.googleapis.com/compute/v1/projects/[projectId]/locations/[dataproc_region]/autoscalingPolicies/[policy_id]`
        `projects/[projectId]/locations/[dataproc_region]/autoscalingPolicies/[policy_id]`
        Note that the policy must be in the same project and Cloud Dataproc region.

        - - -
        """
        return pulumi.get(self, "policy_uri")


@pulumi.output_type
class ClusterClusterConfigAuxiliaryNodeGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeGroups":
            suggest = "node_groups"
        elif key == "nodeGroupId":
            suggest = "node_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigAuxiliaryNodeGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigAuxiliaryNodeGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigAuxiliaryNodeGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_groups: Sequence['outputs.ClusterClusterConfigAuxiliaryNodeGroupNodeGroup'],
                 node_group_id: Optional[_builtins.str] = None):
        """
        :param Sequence['ClusterClusterConfigAuxiliaryNodeGroupNodeGroupArgs'] node_groups: Node group configuration.
        :param _builtins.str node_group_id: A node group ID. Generated if not specified. The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of from 3 to 33 characters.
        """
        pulumi.set(__self__, "node_groups", node_groups)
        if node_group_id is not None:
            pulumi.set(__self__, "node_group_id", node_group_id)

    @_builtins.property
    @pulumi.getter(name="nodeGroups")
    def node_groups(self) -> Sequence['outputs.ClusterClusterConfigAuxiliaryNodeGroupNodeGroup']:
        """
        Node group configuration.
        """
        return pulumi.get(self, "node_groups")

    @_builtins.property
    @pulumi.getter(name="nodeGroupId")
    def node_group_id(self) -> Optional[_builtins.str]:
        """
        A node group ID. Generated if not specified. The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of from 3 to 33 characters.
        """
        return pulumi.get(self, "node_group_id")


@pulumi.output_type
class ClusterClusterConfigAuxiliaryNodeGroupNodeGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeGroupConfig":
            suggest = "node_group_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigAuxiliaryNodeGroupNodeGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigAuxiliaryNodeGroupNodeGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigAuxiliaryNodeGroupNodeGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 roles: Sequence[_builtins.str],
                 name: Optional[_builtins.str] = None,
                 node_group_config: Optional['outputs.ClusterClusterConfigAuxiliaryNodeGroupNodeGroupNodeGroupConfig'] = None):
        """
        :param Sequence[_builtins.str] roles: Node group roles. 
               One of `"DRIVER"`.
        :param _builtins.str name: The Node group resource name.
        :param 'ClusterClusterConfigAuxiliaryNodeGroupNodeGroupNodeGroupConfigArgs' node_group_config: The node group instance group configuration.
        """
        pulumi.set(__self__, "roles", roles)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_group_config is not None:
            pulumi.set(__self__, "node_group_config", node_group_config)

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Sequence[_builtins.str]:
        """
        Node group roles. 
        One of `"DRIVER"`.
        """
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The Node group resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodeGroupConfig")
    def node_group_config(self) -> Optional['outputs.ClusterClusterConfigAuxiliaryNodeGroupNodeGroupNodeGroupConfig']:
        """
        The node group instance group configuration.
        """
        return pulumi.get(self, "node_group_config")


@pulumi.output_type
class ClusterClusterConfigAuxiliaryNodeGroupNodeGroupNodeGroupConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskConfig":
            suggest = "disk_config"
        elif key == "instanceNames":
            suggest = "instance_names"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "minCpuPlatform":
            suggest = "min_cpu_platform"
        elif key == "numInstances":
            suggest = "num_instances"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigAuxiliaryNodeGroupNodeGroupNodeGroupConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigAuxiliaryNodeGroupNodeGroupNodeGroupConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigAuxiliaryNodeGroupNodeGroupNodeGroupConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerators: Optional[Sequence['outputs.ClusterClusterConfigAuxiliaryNodeGroupNodeGroupNodeGroupConfigAccelerator']] = None,
                 disk_config: Optional['outputs.ClusterClusterConfigAuxiliaryNodeGroupNodeGroupNodeGroupConfigDiskConfig'] = None,
                 instance_names: Optional[Sequence[_builtins.str]] = None,
                 machine_type: Optional[_builtins.str] = None,
                 min_cpu_platform: Optional[_builtins.str] = None,
                 num_instances: Optional[_builtins.int] = None):
        """
        :param Sequence['ClusterClusterConfigAuxiliaryNodeGroupNodeGroupNodeGroupConfigAcceleratorArgs'] accelerators: The Compute Engine accelerator (GPU) configuration for these instances. Can be specified 
               multiple times.
        :param 'ClusterClusterConfigAuxiliaryNodeGroupNodeGroupNodeGroupConfigDiskConfigArgs' disk_config: Disk Config
        :param Sequence[_builtins.str] instance_names: List of auxiliary node group instance names which have been assigned to the cluster.
        :param _builtins.str machine_type: The name of a Google Compute Engine machine type
               to create for the node group. If not specified, GCP will default to a predetermined
               computed value (currently `n1-standard-4`).
        :param _builtins.str min_cpu_platform: The name of a minimum generation of CPU family
               for the node group. If not specified, GCP will default to a predetermined computed value
               for each zone. See [the guide](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
               for details about which CPU families are available (and defaulted) for each zone.
        :param _builtins.int num_instances: Specifies the number of master nodes to create.
               Please set a number greater than 0. Node Group must have at least 1 instance.
        """
        if accelerators is not None:
            pulumi.set(__self__, "accelerators", accelerators)
        if disk_config is not None:
            pulumi.set(__self__, "disk_config", disk_config)
        if instance_names is not None:
            pulumi.set(__self__, "instance_names", instance_names)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if num_instances is not None:
            pulumi.set(__self__, "num_instances", num_instances)

    @_builtins.property
    @pulumi.getter
    def accelerators(self) -> Optional[Sequence['outputs.ClusterClusterConfigAuxiliaryNodeGroupNodeGroupNodeGroupConfigAccelerator']]:
        """
        The Compute Engine accelerator (GPU) configuration for these instances. Can be specified 
        multiple times.
        """
        return pulumi.get(self, "accelerators")

    @_builtins.property
    @pulumi.getter(name="diskConfig")
    def disk_config(self) -> Optional['outputs.ClusterClusterConfigAuxiliaryNodeGroupNodeGroupNodeGroupConfigDiskConfig']:
        """
        Disk Config
        """
        return pulumi.get(self, "disk_config")

    @_builtins.property
    @pulumi.getter(name="instanceNames")
    def instance_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of auxiliary node group instance names which have been assigned to the cluster.
        """
        return pulumi.get(self, "instance_names")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[_builtins.str]:
        """
        The name of a Google Compute Engine machine type
        to create for the node group. If not specified, GCP will default to a predetermined
        computed value (currently `n1-standard-4`).
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[_builtins.str]:
        """
        The name of a minimum generation of CPU family
        for the node group. If not specified, GCP will default to a predetermined computed value
        for each zone. See [the guide](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
        for details about which CPU families are available (and defaulted) for each zone.
        """
        return pulumi.get(self, "min_cpu_platform")

    @_builtins.property
    @pulumi.getter(name="numInstances")
    def num_instances(self) -> Optional[_builtins.int]:
        """
        Specifies the number of master nodes to create.
        Please set a number greater than 0. Node Group must have at least 1 instance.
        """
        return pulumi.get(self, "num_instances")


@pulumi.output_type
class ClusterClusterConfigAuxiliaryNodeGroupNodeGroupNodeGroupConfigAccelerator(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceleratorCount":
            suggest = "accelerator_count"
        elif key == "acceleratorType":
            suggest = "accelerator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigAuxiliaryNodeGroupNodeGroupNodeGroupConfigAccelerator. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigAuxiliaryNodeGroupNodeGroupNodeGroupConfigAccelerator.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigAuxiliaryNodeGroupNodeGroupNodeGroupConfigAccelerator.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerator_count: _builtins.int,
                 accelerator_type: _builtins.str):
        """
        :param _builtins.int accelerator_count: The number of the accelerator cards of this type exposed to this instance. Often restricted to one of `1`, `2`, `4`, or `8`.
               
               
               - - -
        :param _builtins.str accelerator_type: The short name of the accelerator type to expose to this instance. For example, `nvidia-tesla-k80`.
        """
        pulumi.set(__self__, "accelerator_count", accelerator_count)
        pulumi.set(__self__, "accelerator_type", accelerator_type)

    @_builtins.property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> _builtins.int:
        """
        The number of the accelerator cards of this type exposed to this instance. Often restricted to one of `1`, `2`, `4`, or `8`.


        - - -
        """
        return pulumi.get(self, "accelerator_count")

    @_builtins.property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> _builtins.str:
        """
        The short name of the accelerator type to expose to this instance. For example, `nvidia-tesla-k80`.
        """
        return pulumi.get(self, "accelerator_type")


@pulumi.output_type
class ClusterClusterConfigAuxiliaryNodeGroupNodeGroupNodeGroupConfigDiskConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootDiskSizeGb":
            suggest = "boot_disk_size_gb"
        elif key == "bootDiskType":
            suggest = "boot_disk_type"
        elif key == "localSsdInterface":
            suggest = "local_ssd_interface"
        elif key == "numLocalSsds":
            suggest = "num_local_ssds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigAuxiliaryNodeGroupNodeGroupNodeGroupConfigDiskConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigAuxiliaryNodeGroupNodeGroupNodeGroupConfigDiskConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigAuxiliaryNodeGroupNodeGroupNodeGroupConfigDiskConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot_disk_size_gb: Optional[_builtins.int] = None,
                 boot_disk_type: Optional[_builtins.str] = None,
                 local_ssd_interface: Optional[_builtins.str] = None,
                 num_local_ssds: Optional[_builtins.int] = None):
        """
        :param _builtins.int boot_disk_size_gb: Size of the primary disk attached to each node, specified
               in GB. The primary disk contains the boot volume and system libraries, and the
               smallest allowed disk size is 10GB. GCP will default to a predetermined
               computed value if not set (currently 500GB). Note: If SSDs are not
               attached, it also contains the HDFS data blocks and Hadoop working directories.
        :param _builtins.str boot_disk_type: The disk type of the primary disk attached to each node.
               One of `"pd-ssd"` or `"pd-standard"`. Defaults to `"pd-standard"`.
        :param _builtins.str local_ssd_interface: Interface type of local SSDs (default is "scsi"). Valid values: "scsi" (Small Computer System Interface), "nvme" (Non-Volatile Memory Express).
        :param _builtins.int num_local_ssds: The amount of local SSD disks that will be attached to each master cluster node. 
               Defaults to 0.
        """
        if boot_disk_size_gb is not None:
            pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        if boot_disk_type is not None:
            pulumi.set(__self__, "boot_disk_type", boot_disk_type)
        if local_ssd_interface is not None:
            pulumi.set(__self__, "local_ssd_interface", local_ssd_interface)
        if num_local_ssds is not None:
            pulumi.set(__self__, "num_local_ssds", num_local_ssds)

    @_builtins.property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> Optional[_builtins.int]:
        """
        Size of the primary disk attached to each node, specified
        in GB. The primary disk contains the boot volume and system libraries, and the
        smallest allowed disk size is 10GB. GCP will default to a predetermined
        computed value if not set (currently 500GB). Note: If SSDs are not
        attached, it also contains the HDFS data blocks and Hadoop working directories.
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @_builtins.property
    @pulumi.getter(name="bootDiskType")
    def boot_disk_type(self) -> Optional[_builtins.str]:
        """
        The disk type of the primary disk attached to each node.
        One of `"pd-ssd"` or `"pd-standard"`. Defaults to `"pd-standard"`.
        """
        return pulumi.get(self, "boot_disk_type")

    @_builtins.property
    @pulumi.getter(name="localSsdInterface")
    def local_ssd_interface(self) -> Optional[_builtins.str]:
        """
        Interface type of local SSDs (default is "scsi"). Valid values: "scsi" (Small Computer System Interface), "nvme" (Non-Volatile Memory Express).
        """
        return pulumi.get(self, "local_ssd_interface")

    @_builtins.property
    @pulumi.getter(name="numLocalSsds")
    def num_local_ssds(self) -> Optional[_builtins.int]:
        """
        The amount of local SSD disks that will be attached to each master cluster node. 
        Defaults to 0.
        """
        return pulumi.get(self, "num_local_ssds")


@pulumi.output_type
class ClusterClusterConfigDataprocMetricConfig(dict):
    def __init__(__self__, *,
                 metrics: Sequence['outputs.ClusterClusterConfigDataprocMetricConfigMetric']):
        """
        :param Sequence['ClusterClusterConfigDataprocMetricConfigMetricArgs'] metrics: Metrics sources to enable.
        """
        pulumi.set(__self__, "metrics", metrics)

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Sequence['outputs.ClusterClusterConfigDataprocMetricConfigMetric']:
        """
        Metrics sources to enable.
        """
        return pulumi.get(self, "metrics")


@pulumi.output_type
class ClusterClusterConfigDataprocMetricConfigMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricSource":
            suggest = "metric_source"
        elif key == "metricOverrides":
            suggest = "metric_overrides"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigDataprocMetricConfigMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigDataprocMetricConfigMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigDataprocMetricConfigMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_source: _builtins.str,
                 metric_overrides: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str metric_source: A source for the collection of Dataproc OSS metrics (see [available OSS metrics](https://cloud.google.com//dataproc/docs/guides/monitoring#available_oss_metrics)).
        :param Sequence[_builtins.str] metric_overrides: One or more [available OSS metrics] (https://cloud.google.com/dataproc/docs/guides/monitoring#available_oss_metrics) to collect for the metric course.
               
               - - -
        """
        pulumi.set(__self__, "metric_source", metric_source)
        if metric_overrides is not None:
            pulumi.set(__self__, "metric_overrides", metric_overrides)

    @_builtins.property
    @pulumi.getter(name="metricSource")
    def metric_source(self) -> _builtins.str:
        """
        A source for the collection of Dataproc OSS metrics (see [available OSS metrics](https://cloud.google.com//dataproc/docs/guides/monitoring#available_oss_metrics)).
        """
        return pulumi.get(self, "metric_source")

    @_builtins.property
    @pulumi.getter(name="metricOverrides")
    def metric_overrides(self) -> Optional[Sequence[_builtins.str]]:
        """
        One or more [available OSS metrics] (https://cloud.google.com/dataproc/docs/guides/monitoring#available_oss_metrics) to collect for the metric course.

        - - -
        """
        return pulumi.get(self, "metric_overrides")


@pulumi.output_type
class ClusterClusterConfigEncryptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigEncryptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigEncryptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigEncryptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: _builtins.str):
        """
        :param _builtins.str kms_key_name: The Cloud KMS key name to use for PD disk encryption for
               all instances in the cluster.
               
               - - -
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> _builtins.str:
        """
        The Cloud KMS key name to use for PD disk encryption for
        all instances in the cluster.

        - - -
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class ClusterClusterConfigEndpointConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableHttpPortAccess":
            suggest = "enable_http_port_access"
        elif key == "httpPorts":
            suggest = "http_ports"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigEndpointConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigEndpointConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigEndpointConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_http_port_access: _builtins.bool,
                 http_ports: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.bool enable_http_port_access: The flag to enable http access to specific ports
               on the cluster from external sources (aka Component Gateway). Defaults to false.
        :param Mapping[str, _builtins.str] http_ports: The map of port descriptions to URLs. Will only be populated if
               `enable_http_port_access` is true.
        """
        pulumi.set(__self__, "enable_http_port_access", enable_http_port_access)
        if http_ports is not None:
            pulumi.set(__self__, "http_ports", http_ports)

    @_builtins.property
    @pulumi.getter(name="enableHttpPortAccess")
    def enable_http_port_access(self) -> _builtins.bool:
        """
        The flag to enable http access to specific ports
        on the cluster from external sources (aka Component Gateway). Defaults to false.
        """
        return pulumi.get(self, "enable_http_port_access")

    @_builtins.property
    @pulumi.getter(name="httpPorts")
    def http_ports(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The map of port descriptions to URLs. Will only be populated if
        `enable_http_port_access` is true.
        """
        return pulumi.get(self, "http_ports")


@pulumi.output_type
class ClusterClusterConfigGceClusterConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "confidentialInstanceConfig":
            suggest = "confidential_instance_config"
        elif key == "internalIpOnly":
            suggest = "internal_ip_only"
        elif key == "nodeGroupAffinity":
            suggest = "node_group_affinity"
        elif key == "reservationAffinity":
            suggest = "reservation_affinity"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "serviceAccountScopes":
            suggest = "service_account_scopes"
        elif key == "shieldedInstanceConfig":
            suggest = "shielded_instance_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigGceClusterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigGceClusterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigGceClusterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 confidential_instance_config: Optional['outputs.ClusterClusterConfigGceClusterConfigConfidentialInstanceConfig'] = None,
                 internal_ip_only: Optional[_builtins.bool] = None,
                 metadata: Optional[Mapping[str, _builtins.str]] = None,
                 network: Optional[_builtins.str] = None,
                 node_group_affinity: Optional['outputs.ClusterClusterConfigGceClusterConfigNodeGroupAffinity'] = None,
                 reservation_affinity: Optional['outputs.ClusterClusterConfigGceClusterConfigReservationAffinity'] = None,
                 service_account: Optional[_builtins.str] = None,
                 service_account_scopes: Optional[Sequence[_builtins.str]] = None,
                 shielded_instance_config: Optional['outputs.ClusterClusterConfigGceClusterConfigShieldedInstanceConfig'] = None,
                 subnetwork: Optional[_builtins.str] = None,
                 tags: Optional[Sequence[_builtins.str]] = None,
                 zone: Optional[_builtins.str] = None):
        """
        :param 'ClusterClusterConfigGceClusterConfigConfidentialInstanceConfigArgs' confidential_instance_config: Confidential Instance Config for clusters using [Confidential VMs](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/confidential-compute)
        :param _builtins.bool internal_ip_only: By default, clusters are not restricted to internal IP addresses,
               and will have ephemeral external IP addresses assigned to each instance. If set to true, all
               instances in the cluster will only have internal IP addresses. Note: Private Google Access
               (also known as `privateIpGoogleAccess`) must be enabled on the subnetwork that the cluster
               will be launched in.
        :param Mapping[str, _builtins.str] metadata: A map of the Compute Engine metadata entries to add to all instances
               (see [Project and instance metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
        :param _builtins.str network: The name or self_link of the Google Compute Engine
               network to the cluster will be part of. Conflicts with `subnetwork`.
               If neither is specified, this defaults to the "default" network.
        :param 'ClusterClusterConfigGceClusterConfigNodeGroupAffinityArgs' node_group_affinity: Node Group Affinity for sole-tenant clusters.
        :param 'ClusterClusterConfigGceClusterConfigReservationAffinityArgs' reservation_affinity: Reservation Affinity for consuming zonal reservation.
        :param _builtins.str service_account: The service account to be used by the Node VMs.
               If not specified, the "default" service account is used.
        :param Sequence[_builtins.str] service_account_scopes: The set of Google API scopes
               to be made available on all of the node VMs under the `service_account`
               specified. Both OAuth2 URLs and gcloud
               short names are supported. To allow full access to all Cloud APIs, use the
               `cloud-platform` scope. See a complete list of scopes [here](https://cloud.google.com/sdk/gcloud/reference/alpha/compute/instances/set-scopes#--scopes).
        :param 'ClusterClusterConfigGceClusterConfigShieldedInstanceConfigArgs' shielded_instance_config: Shielded Instance Config for clusters using [Compute Engine Shielded VMs](https://cloud.google.com/security/shielded-cloud/shielded-vm).
               
               - - -
        :param _builtins.str subnetwork: The name or self_link of the Google Compute Engine
               subnetwork the cluster will be part of. Conflicts with `network`.
        :param Sequence[_builtins.str] tags: The list of instance tags applied to instances in the cluster.
               Tags are used to identify valid sources or targets for network firewalls.
        :param _builtins.str zone: The GCP zone where your data is stored and used (i.e. where
               the master and the worker nodes will be created in). If `region` is set to 'global' (default)
               then `zone` is mandatory, otherwise GCP is able to make use of [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/auto-zone)
               to determine this automatically for you.
               Note: This setting additionally determines and restricts
               which computing resources are available for use with other configs such as
               `cluster_config.master_config.machine_type` and `cluster_config.worker_config.machine_type`.
        """
        if confidential_instance_config is not None:
            pulumi.set(__self__, "confidential_instance_config", confidential_instance_config)
        if internal_ip_only is not None:
            pulumi.set(__self__, "internal_ip_only", internal_ip_only)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if node_group_affinity is not None:
            pulumi.set(__self__, "node_group_affinity", node_group_affinity)
        if reservation_affinity is not None:
            pulumi.set(__self__, "reservation_affinity", reservation_affinity)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if service_account_scopes is not None:
            pulumi.set(__self__, "service_account_scopes", service_account_scopes)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="confidentialInstanceConfig")
    def confidential_instance_config(self) -> Optional['outputs.ClusterClusterConfigGceClusterConfigConfidentialInstanceConfig']:
        """
        Confidential Instance Config for clusters using [Confidential VMs](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/confidential-compute)
        """
        return pulumi.get(self, "confidential_instance_config")

    @_builtins.property
    @pulumi.getter(name="internalIpOnly")
    def internal_ip_only(self) -> Optional[_builtins.bool]:
        """
        By default, clusters are not restricted to internal IP addresses,
        and will have ephemeral external IP addresses assigned to each instance. If set to true, all
        instances in the cluster will only have internal IP addresses. Note: Private Google Access
        (also known as `privateIpGoogleAccess`) must be enabled on the subnetwork that the cluster
        will be launched in.
        """
        return pulumi.get(self, "internal_ip_only")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of the Compute Engine metadata entries to add to all instances
        (see [Project and instance metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[_builtins.str]:
        """
        The name or self_link of the Google Compute Engine
        network to the cluster will be part of. Conflicts with `subnetwork`.
        If neither is specified, this defaults to the "default" network.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="nodeGroupAffinity")
    def node_group_affinity(self) -> Optional['outputs.ClusterClusterConfigGceClusterConfigNodeGroupAffinity']:
        """
        Node Group Affinity for sole-tenant clusters.
        """
        return pulumi.get(self, "node_group_affinity")

    @_builtins.property
    @pulumi.getter(name="reservationAffinity")
    def reservation_affinity(self) -> Optional['outputs.ClusterClusterConfigGceClusterConfigReservationAffinity']:
        """
        Reservation Affinity for consuming zonal reservation.
        """
        return pulumi.get(self, "reservation_affinity")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[_builtins.str]:
        """
        The service account to be used by the Node VMs.
        If not specified, the "default" service account is used.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter(name="serviceAccountScopes")
    def service_account_scopes(self) -> Optional[Sequence[_builtins.str]]:
        """
        The set of Google API scopes
        to be made available on all of the node VMs under the `service_account`
        specified. Both OAuth2 URLs and gcloud
        short names are supported. To allow full access to all Cloud APIs, use the
        `cloud-platform` scope. See a complete list of scopes [here](https://cloud.google.com/sdk/gcloud/reference/alpha/compute/instances/set-scopes#--scopes).
        """
        return pulumi.get(self, "service_account_scopes")

    @_builtins.property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional['outputs.ClusterClusterConfigGceClusterConfigShieldedInstanceConfig']:
        """
        Shielded Instance Config for clusters using [Compute Engine Shielded VMs](https://cloud.google.com/security/shielded-cloud/shielded-vm).

        - - -
        """
        return pulumi.get(self, "shielded_instance_config")

    @_builtins.property
    @pulumi.getter
    def subnetwork(self) -> Optional[_builtins.str]:
        """
        The name or self_link of the Google Compute Engine
        subnetwork the cluster will be part of. Conflicts with `network`.
        """
        return pulumi.get(self, "subnetwork")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        The list of instance tags applied to instances in the cluster.
        Tags are used to identify valid sources or targets for network firewalls.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        """
        The GCP zone where your data is stored and used (i.e. where
        the master and the worker nodes will be created in). If `region` is set to 'global' (default)
        then `zone` is mandatory, otherwise GCP is able to make use of [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/auto-zone)
        to determine this automatically for you.
        Note: This setting additionally determines and restricts
        which computing resources are available for use with other configs such as
        `cluster_config.master_config.machine_type` and `cluster_config.worker_config.machine_type`.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class ClusterClusterConfigGceClusterConfigConfidentialInstanceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableConfidentialCompute":
            suggest = "enable_confidential_compute"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigGceClusterConfigConfidentialInstanceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigGceClusterConfigConfidentialInstanceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigGceClusterConfigConfidentialInstanceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_confidential_compute: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool enable_confidential_compute: Defines whether the instance should have confidential compute enabled.
        """
        if enable_confidential_compute is not None:
            pulumi.set(__self__, "enable_confidential_compute", enable_confidential_compute)

    @_builtins.property
    @pulumi.getter(name="enableConfidentialCompute")
    def enable_confidential_compute(self) -> Optional[_builtins.bool]:
        """
        Defines whether the instance should have confidential compute enabled.
        """
        return pulumi.get(self, "enable_confidential_compute")


@pulumi.output_type
class ClusterClusterConfigGceClusterConfigNodeGroupAffinity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeGroupUri":
            suggest = "node_group_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigGceClusterConfigNodeGroupAffinity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigGceClusterConfigNodeGroupAffinity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigGceClusterConfigNodeGroupAffinity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_group_uri: _builtins.str):
        """
        :param _builtins.str node_group_uri: The URI of a sole-tenant node group resource that the cluster will be created on.
        """
        pulumi.set(__self__, "node_group_uri", node_group_uri)

    @_builtins.property
    @pulumi.getter(name="nodeGroupUri")
    def node_group_uri(self) -> _builtins.str:
        """
        The URI of a sole-tenant node group resource that the cluster will be created on.
        """
        return pulumi.get(self, "node_group_uri")


@pulumi.output_type
class ClusterClusterConfigGceClusterConfigReservationAffinity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumeReservationType":
            suggest = "consume_reservation_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigGceClusterConfigReservationAffinity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigGceClusterConfigReservationAffinity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigGceClusterConfigReservationAffinity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consume_reservation_type: Optional[_builtins.str] = None,
                 key: Optional[_builtins.str] = None,
                 values: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str consume_reservation_type: Corresponds to the type of reservation consumption.
        :param _builtins.str key: Corresponds to the label key of reservation resource.
        :param Sequence[_builtins.str] values: Corresponds to the label values of reservation resource.
        """
        if consume_reservation_type is not None:
            pulumi.set(__self__, "consume_reservation_type", consume_reservation_type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter(name="consumeReservationType")
    def consume_reservation_type(self) -> Optional[_builtins.str]:
        """
        Corresponds to the type of reservation consumption.
        """
        return pulumi.get(self, "consume_reservation_type")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        Corresponds to the label key of reservation resource.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[Sequence[_builtins.str]]:
        """
        Corresponds to the label values of reservation resource.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ClusterClusterConfigGceClusterConfigShieldedInstanceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableIntegrityMonitoring":
            suggest = "enable_integrity_monitoring"
        elif key == "enableSecureBoot":
            suggest = "enable_secure_boot"
        elif key == "enableVtpm":
            suggest = "enable_vtpm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigGceClusterConfigShieldedInstanceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigGceClusterConfigShieldedInstanceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigGceClusterConfigShieldedInstanceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_integrity_monitoring: Optional[_builtins.bool] = None,
                 enable_secure_boot: Optional[_builtins.bool] = None,
                 enable_vtpm: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool enable_integrity_monitoring: Defines whether instances have integrity monitoring enabled.
               
               - - -
        :param _builtins.bool enable_secure_boot: Defines whether instances have Secure Boot enabled.
        :param _builtins.bool enable_vtpm: Defines whether instances have the [vTPM](https://cloud.google.com/security/shielded-cloud/shielded-vm#vtpm) enabled.
        """
        if enable_integrity_monitoring is not None:
            pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        if enable_secure_boot is not None:
            pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)
        if enable_vtpm is not None:
            pulumi.set(__self__, "enable_vtpm", enable_vtpm)

    @_builtins.property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> Optional[_builtins.bool]:
        """
        Defines whether instances have integrity monitoring enabled.

        - - -
        """
        return pulumi.get(self, "enable_integrity_monitoring")

    @_builtins.property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> Optional[_builtins.bool]:
        """
        Defines whether instances have Secure Boot enabled.
        """
        return pulumi.get(self, "enable_secure_boot")

    @_builtins.property
    @pulumi.getter(name="enableVtpm")
    def enable_vtpm(self) -> Optional[_builtins.bool]:
        """
        Defines whether instances have the [vTPM](https://cloud.google.com/security/shielded-cloud/shielded-vm#vtpm) enabled.
        """
        return pulumi.get(self, "enable_vtpm")


@pulumi.output_type
class ClusterClusterConfigInitializationAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeoutSec":
            suggest = "timeout_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigInitializationAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigInitializationAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigInitializationAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 script: _builtins.str,
                 timeout_sec: Optional[_builtins.int] = None):
        """
        :param _builtins.str script: The script to be executed during initialization of the cluster.
               The script must be a GCS file with a gs:// prefix.
        :param _builtins.int timeout_sec: The maximum duration (in seconds) which `script` is
               allowed to take to execute its action. GCP will default to a predetermined
               computed value if not set (currently 300).
               
               - - -
        """
        pulumi.set(__self__, "script", script)
        if timeout_sec is not None:
            pulumi.set(__self__, "timeout_sec", timeout_sec)

    @_builtins.property
    @pulumi.getter
    def script(self) -> _builtins.str:
        """
        The script to be executed during initialization of the cluster.
        The script must be a GCS file with a gs:// prefix.
        """
        return pulumi.get(self, "script")

    @_builtins.property
    @pulumi.getter(name="timeoutSec")
    def timeout_sec(self) -> Optional[_builtins.int]:
        """
        The maximum duration (in seconds) which `script` is
        allowed to take to execute its action. GCP will default to a predetermined
        computed value if not set (currently 300).

        - - -
        """
        return pulumi.get(self, "timeout_sec")


@pulumi.output_type
class ClusterClusterConfigLifecycleConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoDeleteTime":
            suggest = "auto_delete_time"
        elif key == "idleDeleteTtl":
            suggest = "idle_delete_ttl"
        elif key == "idleStartTime":
            suggest = "idle_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigLifecycleConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigLifecycleConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigLifecycleConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_delete_time: Optional[_builtins.str] = None,
                 idle_delete_ttl: Optional[_builtins.str] = None,
                 idle_start_time: Optional[_builtins.str] = None):
        """
        :param _builtins.str auto_delete_time: The time when cluster will be auto-deleted.
               A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
               Example: "2014-10-02T15:01:23.045123456Z".
               
               - - -
        :param _builtins.str idle_delete_ttl: The duration to keep the cluster alive while idling
               (no jobs running). After this TTL, the cluster will be deleted. Valid range: [10m, 14d].
        :param _builtins.str idle_start_time: Time when the cluster became idle
               (most recent job finished) and became eligible for deletion due to idleness.
        """
        if auto_delete_time is not None:
            pulumi.set(__self__, "auto_delete_time", auto_delete_time)
        if idle_delete_ttl is not None:
            pulumi.set(__self__, "idle_delete_ttl", idle_delete_ttl)
        if idle_start_time is not None:
            pulumi.set(__self__, "idle_start_time", idle_start_time)

    @_builtins.property
    @pulumi.getter(name="autoDeleteTime")
    def auto_delete_time(self) -> Optional[_builtins.str]:
        """
        The time when cluster will be auto-deleted.
        A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
        Example: "2014-10-02T15:01:23.045123456Z".

        - - -
        """
        return pulumi.get(self, "auto_delete_time")

    @_builtins.property
    @pulumi.getter(name="idleDeleteTtl")
    def idle_delete_ttl(self) -> Optional[_builtins.str]:
        """
        The duration to keep the cluster alive while idling
        (no jobs running). After this TTL, the cluster will be deleted. Valid range: [10m, 14d].
        """
        return pulumi.get(self, "idle_delete_ttl")

    @_builtins.property
    @pulumi.getter(name="idleStartTime")
    def idle_start_time(self) -> Optional[_builtins.str]:
        """
        Time when the cluster became idle
        (most recent job finished) and became eligible for deletion due to idleness.
        """
        return pulumi.get(self, "idle_start_time")


@pulumi.output_type
class ClusterClusterConfigMasterConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskConfig":
            suggest = "disk_config"
        elif key == "imageUri":
            suggest = "image_uri"
        elif key == "instanceNames":
            suggest = "instance_names"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "minCpuPlatform":
            suggest = "min_cpu_platform"
        elif key == "numInstances":
            suggest = "num_instances"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigMasterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigMasterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigMasterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerators: Optional[Sequence['outputs.ClusterClusterConfigMasterConfigAccelerator']] = None,
                 disk_config: Optional['outputs.ClusterClusterConfigMasterConfigDiskConfig'] = None,
                 image_uri: Optional[_builtins.str] = None,
                 instance_names: Optional[Sequence[_builtins.str]] = None,
                 machine_type: Optional[_builtins.str] = None,
                 min_cpu_platform: Optional[_builtins.str] = None,
                 num_instances: Optional[_builtins.int] = None):
        """
        :param Sequence['ClusterClusterConfigMasterConfigAcceleratorArgs'] accelerators: The Compute Engine accelerator (GPU) configuration for these instances. Can be specified multiple times.
        :param 'ClusterClusterConfigMasterConfigDiskConfigArgs' disk_config: Disk Config
        :param _builtins.str image_uri: The URI for the image to use for this worker.  See [the guide](https://cloud.google.com/dataproc/docs/guides/dataproc-images)
               for more information.
        :param Sequence[_builtins.str] instance_names: List of master instance names which
               have been assigned to the cluster.
        :param _builtins.str machine_type: The name of a Google Compute Engine machine type
               to create for the master. If not specified, GCP will default to a predetermined
               computed value (currently `n1-standard-4`).
        :param _builtins.str min_cpu_platform: The name of a minimum generation of CPU family
               for the master. If not specified, GCP will default to a predetermined computed value
               for each zone. See [the guide](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
               for details about which CPU families are available (and defaulted) for each zone.
        :param _builtins.int num_instances: Specifies the number of master nodes to create.
               If not specified, GCP will default to a predetermined computed value (currently 1).
        """
        if accelerators is not None:
            pulumi.set(__self__, "accelerators", accelerators)
        if disk_config is not None:
            pulumi.set(__self__, "disk_config", disk_config)
        if image_uri is not None:
            pulumi.set(__self__, "image_uri", image_uri)
        if instance_names is not None:
            pulumi.set(__self__, "instance_names", instance_names)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if num_instances is not None:
            pulumi.set(__self__, "num_instances", num_instances)

    @_builtins.property
    @pulumi.getter
    def accelerators(self) -> Optional[Sequence['outputs.ClusterClusterConfigMasterConfigAccelerator']]:
        """
        The Compute Engine accelerator (GPU) configuration for these instances. Can be specified multiple times.
        """
        return pulumi.get(self, "accelerators")

    @_builtins.property
    @pulumi.getter(name="diskConfig")
    def disk_config(self) -> Optional['outputs.ClusterClusterConfigMasterConfigDiskConfig']:
        """
        Disk Config
        """
        return pulumi.get(self, "disk_config")

    @_builtins.property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> Optional[_builtins.str]:
        """
        The URI for the image to use for this worker.  See [the guide](https://cloud.google.com/dataproc/docs/guides/dataproc-images)
        for more information.
        """
        return pulumi.get(self, "image_uri")

    @_builtins.property
    @pulumi.getter(name="instanceNames")
    def instance_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of master instance names which
        have been assigned to the cluster.
        """
        return pulumi.get(self, "instance_names")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[_builtins.str]:
        """
        The name of a Google Compute Engine machine type
        to create for the master. If not specified, GCP will default to a predetermined
        computed value (currently `n1-standard-4`).
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[_builtins.str]:
        """
        The name of a minimum generation of CPU family
        for the master. If not specified, GCP will default to a predetermined computed value
        for each zone. See [the guide](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
        for details about which CPU families are available (and defaulted) for each zone.
        """
        return pulumi.get(self, "min_cpu_platform")

    @_builtins.property
    @pulumi.getter(name="numInstances")
    def num_instances(self) -> Optional[_builtins.int]:
        """
        Specifies the number of master nodes to create.
        If not specified, GCP will default to a predetermined computed value (currently 1).
        """
        return pulumi.get(self, "num_instances")


@pulumi.output_type
class ClusterClusterConfigMasterConfigAccelerator(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceleratorCount":
            suggest = "accelerator_count"
        elif key == "acceleratorType":
            suggest = "accelerator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigMasterConfigAccelerator. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigMasterConfigAccelerator.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigMasterConfigAccelerator.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerator_count: _builtins.int,
                 accelerator_type: _builtins.str):
        """
        :param _builtins.int accelerator_count: The number of the accelerator cards of this type exposed to this instance. Often restricted to one of `1`, `2`, `4`, or `8`.
               
               > The Cloud Dataproc API can return unintuitive error messages when using accelerators; even when you have defined an accelerator, Auto Zone Placement does not exclusively select
               zones that have that accelerator available. If you get a 400 error that the accelerator can't be found, this is a likely cause. Make sure you check [accelerator availability by zone](https://cloud.google.com/compute/docs/reference/rest/v1/acceleratorTypes/list)
               if you are trying to use accelerators in a given zone.
               
               - - -
        :param _builtins.str accelerator_type: The short name of the accelerator type to expose to this instance. For example, `nvidia-tesla-k80`.
        """
        pulumi.set(__self__, "accelerator_count", accelerator_count)
        pulumi.set(__self__, "accelerator_type", accelerator_type)

    @_builtins.property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> _builtins.int:
        """
        The number of the accelerator cards of this type exposed to this instance. Often restricted to one of `1`, `2`, `4`, or `8`.

        > The Cloud Dataproc API can return unintuitive error messages when using accelerators; even when you have defined an accelerator, Auto Zone Placement does not exclusively select
        zones that have that accelerator available. If you get a 400 error that the accelerator can't be found, this is a likely cause. Make sure you check [accelerator availability by zone](https://cloud.google.com/compute/docs/reference/rest/v1/acceleratorTypes/list)
        if you are trying to use accelerators in a given zone.

        - - -
        """
        return pulumi.get(self, "accelerator_count")

    @_builtins.property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> _builtins.str:
        """
        The short name of the accelerator type to expose to this instance. For example, `nvidia-tesla-k80`.
        """
        return pulumi.get(self, "accelerator_type")


@pulumi.output_type
class ClusterClusterConfigMasterConfigDiskConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootDiskSizeGb":
            suggest = "boot_disk_size_gb"
        elif key == "bootDiskType":
            suggest = "boot_disk_type"
        elif key == "localSsdInterface":
            suggest = "local_ssd_interface"
        elif key == "numLocalSsds":
            suggest = "num_local_ssds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigMasterConfigDiskConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigMasterConfigDiskConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigMasterConfigDiskConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot_disk_size_gb: Optional[_builtins.int] = None,
                 boot_disk_type: Optional[_builtins.str] = None,
                 local_ssd_interface: Optional[_builtins.str] = None,
                 num_local_ssds: Optional[_builtins.int] = None):
        """
        :param _builtins.int boot_disk_size_gb: Size of the primary disk attached to each node, specified
               in GB. The primary disk contains the boot volume and system libraries, and the
               smallest allowed disk size is 10GB. GCP will default to a predetermined
               computed value if not set (currently 500GB). Note: If SSDs are not
               attached, it also contains the HDFS data blocks and Hadoop working directories.
        :param _builtins.str boot_disk_type: The disk type of the primary disk attached to each node.
               One of `"pd-ssd"` or `"pd-standard"`. Defaults to `"pd-standard"`.
        :param _builtins.str local_ssd_interface: Optional. Interface type of local SSDs (default is "scsi").
               Valid values: "scsi" (Small Computer System Interface), "nvme" (Non-Volatile
               Memory Express). See
               [local SSD performance](https://cloud.google.com/compute/docs/disks/local-ssd#performance).
        :param _builtins.int num_local_ssds: The amount of local SSD disks that will be
               attached to each master cluster node. Defaults to 0.
        """
        if boot_disk_size_gb is not None:
            pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        if boot_disk_type is not None:
            pulumi.set(__self__, "boot_disk_type", boot_disk_type)
        if local_ssd_interface is not None:
            pulumi.set(__self__, "local_ssd_interface", local_ssd_interface)
        if num_local_ssds is not None:
            pulumi.set(__self__, "num_local_ssds", num_local_ssds)

    @_builtins.property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> Optional[_builtins.int]:
        """
        Size of the primary disk attached to each node, specified
        in GB. The primary disk contains the boot volume and system libraries, and the
        smallest allowed disk size is 10GB. GCP will default to a predetermined
        computed value if not set (currently 500GB). Note: If SSDs are not
        attached, it also contains the HDFS data blocks and Hadoop working directories.
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @_builtins.property
    @pulumi.getter(name="bootDiskType")
    def boot_disk_type(self) -> Optional[_builtins.str]:
        """
        The disk type of the primary disk attached to each node.
        One of `"pd-ssd"` or `"pd-standard"`. Defaults to `"pd-standard"`.
        """
        return pulumi.get(self, "boot_disk_type")

    @_builtins.property
    @pulumi.getter(name="localSsdInterface")
    def local_ssd_interface(self) -> Optional[_builtins.str]:
        """
        Optional. Interface type of local SSDs (default is "scsi").
        Valid values: "scsi" (Small Computer System Interface), "nvme" (Non-Volatile
        Memory Express). See
        [local SSD performance](https://cloud.google.com/compute/docs/disks/local-ssd#performance).
        """
        return pulumi.get(self, "local_ssd_interface")

    @_builtins.property
    @pulumi.getter(name="numLocalSsds")
    def num_local_ssds(self) -> Optional[_builtins.int]:
        """
        The amount of local SSD disks that will be
        attached to each master cluster node. Defaults to 0.
        """
        return pulumi.get(self, "num_local_ssds")


@pulumi.output_type
class ClusterClusterConfigMetastoreConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataprocMetastoreService":
            suggest = "dataproc_metastore_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigMetastoreConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigMetastoreConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigMetastoreConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataproc_metastore_service: _builtins.str):
        """
        :param _builtins.str dataproc_metastore_service: Resource name of an existing Dataproc Metastore service.
               
               Only resource names including projectid and location (region) are valid. Examples:
               
               `projects/[projectId]/locations/[dataproc_region]/services/[service-name]`
        """
        pulumi.set(__self__, "dataproc_metastore_service", dataproc_metastore_service)

    @_builtins.property
    @pulumi.getter(name="dataprocMetastoreService")
    def dataproc_metastore_service(self) -> _builtins.str:
        """
        Resource name of an existing Dataproc Metastore service.

        Only resource names including projectid and location (region) are valid. Examples:

        `projects/[projectId]/locations/[dataproc_region]/services/[service-name]`
        """
        return pulumi.get(self, "dataproc_metastore_service")


@pulumi.output_type
class ClusterClusterConfigPreemptibleWorkerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskConfig":
            suggest = "disk_config"
        elif key == "instanceFlexibilityPolicy":
            suggest = "instance_flexibility_policy"
        elif key == "instanceNames":
            suggest = "instance_names"
        elif key == "numInstances":
            suggest = "num_instances"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigPreemptibleWorkerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigPreemptibleWorkerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigPreemptibleWorkerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_config: Optional['outputs.ClusterClusterConfigPreemptibleWorkerConfigDiskConfig'] = None,
                 instance_flexibility_policy: Optional['outputs.ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicy'] = None,
                 instance_names: Optional[Sequence[_builtins.str]] = None,
                 num_instances: Optional[_builtins.int] = None,
                 preemptibility: Optional[_builtins.str] = None):
        """
        :param 'ClusterClusterConfigPreemptibleWorkerConfigDiskConfigArgs' disk_config: Disk Config
        :param 'ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicyArgs' instance_flexibility_policy: Instance flexibility Policy allowing a mixture of VM shapes and provisioning models.
        :param Sequence[_builtins.str] instance_names: List of preemptible instance names which have been assigned
               to the cluster.
        :param _builtins.int num_instances: Specifies the number of preemptible nodes to create.
               Defaults to 0.
        :param _builtins.str preemptibility: Specifies the preemptibility of the secondary workers. The default value is `PREEMPTIBLE`
               Accepted values are:
               * PREEMPTIBILITY_UNSPECIFIED
               * NON_PREEMPTIBLE
               * PREEMPTIBLE
        """
        if disk_config is not None:
            pulumi.set(__self__, "disk_config", disk_config)
        if instance_flexibility_policy is not None:
            pulumi.set(__self__, "instance_flexibility_policy", instance_flexibility_policy)
        if instance_names is not None:
            pulumi.set(__self__, "instance_names", instance_names)
        if num_instances is not None:
            pulumi.set(__self__, "num_instances", num_instances)
        if preemptibility is not None:
            pulumi.set(__self__, "preemptibility", preemptibility)

    @_builtins.property
    @pulumi.getter(name="diskConfig")
    def disk_config(self) -> Optional['outputs.ClusterClusterConfigPreemptibleWorkerConfigDiskConfig']:
        """
        Disk Config
        """
        return pulumi.get(self, "disk_config")

    @_builtins.property
    @pulumi.getter(name="instanceFlexibilityPolicy")
    def instance_flexibility_policy(self) -> Optional['outputs.ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicy']:
        """
        Instance flexibility Policy allowing a mixture of VM shapes and provisioning models.
        """
        return pulumi.get(self, "instance_flexibility_policy")

    @_builtins.property
    @pulumi.getter(name="instanceNames")
    def instance_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of preemptible instance names which have been assigned
        to the cluster.
        """
        return pulumi.get(self, "instance_names")

    @_builtins.property
    @pulumi.getter(name="numInstances")
    def num_instances(self) -> Optional[_builtins.int]:
        """
        Specifies the number of preemptible nodes to create.
        Defaults to 0.
        """
        return pulumi.get(self, "num_instances")

    @_builtins.property
    @pulumi.getter
    def preemptibility(self) -> Optional[_builtins.str]:
        """
        Specifies the preemptibility of the secondary workers. The default value is `PREEMPTIBLE`
        Accepted values are:
        * PREEMPTIBILITY_UNSPECIFIED
        * NON_PREEMPTIBLE
        * PREEMPTIBLE
        """
        return pulumi.get(self, "preemptibility")


@pulumi.output_type
class ClusterClusterConfigPreemptibleWorkerConfigDiskConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootDiskSizeGb":
            suggest = "boot_disk_size_gb"
        elif key == "bootDiskType":
            suggest = "boot_disk_type"
        elif key == "localSsdInterface":
            suggest = "local_ssd_interface"
        elif key == "numLocalSsds":
            suggest = "num_local_ssds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigPreemptibleWorkerConfigDiskConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigPreemptibleWorkerConfigDiskConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigPreemptibleWorkerConfigDiskConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot_disk_size_gb: Optional[_builtins.int] = None,
                 boot_disk_type: Optional[_builtins.str] = None,
                 local_ssd_interface: Optional[_builtins.str] = None,
                 num_local_ssds: Optional[_builtins.int] = None):
        """
        :param _builtins.int boot_disk_size_gb: Size of the primary disk attached to each preemptible worker node, specified
               in GB. The smallest allowed disk size is 10GB. GCP will default to a predetermined
               computed value if not set (currently 500GB). Note: If SSDs are not
               attached, it also contains the HDFS data blocks and Hadoop working directories.
        :param _builtins.str boot_disk_type: The disk type of the primary disk attached to each preemptible worker node.
               One of `"pd-ssd"` or `"pd-standard"`. Defaults to `"pd-standard"`.
        :param _builtins.str local_ssd_interface: Interface type of local SSDs (default is "scsi"). Valid values: "scsi" (Small Computer System Interface), "nvme" (Non-Volatile Memory Express).
        :param _builtins.int num_local_ssds: The amount of local SSD disks that will be
               attached to each preemptible worker node. Defaults to 0.
        """
        if boot_disk_size_gb is not None:
            pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        if boot_disk_type is not None:
            pulumi.set(__self__, "boot_disk_type", boot_disk_type)
        if local_ssd_interface is not None:
            pulumi.set(__self__, "local_ssd_interface", local_ssd_interface)
        if num_local_ssds is not None:
            pulumi.set(__self__, "num_local_ssds", num_local_ssds)

    @_builtins.property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> Optional[_builtins.int]:
        """
        Size of the primary disk attached to each preemptible worker node, specified
        in GB. The smallest allowed disk size is 10GB. GCP will default to a predetermined
        computed value if not set (currently 500GB). Note: If SSDs are not
        attached, it also contains the HDFS data blocks and Hadoop working directories.
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @_builtins.property
    @pulumi.getter(name="bootDiskType")
    def boot_disk_type(self) -> Optional[_builtins.str]:
        """
        The disk type of the primary disk attached to each preemptible worker node.
        One of `"pd-ssd"` or `"pd-standard"`. Defaults to `"pd-standard"`.
        """
        return pulumi.get(self, "boot_disk_type")

    @_builtins.property
    @pulumi.getter(name="localSsdInterface")
    def local_ssd_interface(self) -> Optional[_builtins.str]:
        """
        Interface type of local SSDs (default is "scsi"). Valid values: "scsi" (Small Computer System Interface), "nvme" (Non-Volatile Memory Express).
        """
        return pulumi.get(self, "local_ssd_interface")

    @_builtins.property
    @pulumi.getter(name="numLocalSsds")
    def num_local_ssds(self) -> Optional[_builtins.int]:
        """
        The amount of local SSD disks that will be
        attached to each preemptible worker node. Defaults to 0.
        """
        return pulumi.get(self, "num_local_ssds")


@pulumi.output_type
class ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceSelectionLists":
            suggest = "instance_selection_lists"
        elif key == "instanceSelectionResults":
            suggest = "instance_selection_results"
        elif key == "provisioningModelMix":
            suggest = "provisioning_model_mix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_selection_lists: Optional[Sequence['outputs.ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicyInstanceSelectionList']] = None,
                 instance_selection_results: Optional[Sequence['outputs.ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicyInstanceSelectionResult']] = None,
                 provisioning_model_mix: Optional['outputs.ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicyProvisioningModelMix'] = None):
        """
        :param Sequence['ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicyInstanceSelectionListArgs'] instance_selection_lists: List of instance selection options that the group will use when creating new VMs.
        :param Sequence['ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicyInstanceSelectionResultArgs'] instance_selection_results: A list of instance selection results in the group.
        :param 'ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicyProvisioningModelMixArgs' provisioning_model_mix: Defines how the Group selects the provisioning model to ensure required reliability.
        """
        if instance_selection_lists is not None:
            pulumi.set(__self__, "instance_selection_lists", instance_selection_lists)
        if instance_selection_results is not None:
            pulumi.set(__self__, "instance_selection_results", instance_selection_results)
        if provisioning_model_mix is not None:
            pulumi.set(__self__, "provisioning_model_mix", provisioning_model_mix)

    @_builtins.property
    @pulumi.getter(name="instanceSelectionLists")
    def instance_selection_lists(self) -> Optional[Sequence['outputs.ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicyInstanceSelectionList']]:
        """
        List of instance selection options that the group will use when creating new VMs.
        """
        return pulumi.get(self, "instance_selection_lists")

    @_builtins.property
    @pulumi.getter(name="instanceSelectionResults")
    def instance_selection_results(self) -> Optional[Sequence['outputs.ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicyInstanceSelectionResult']]:
        """
        A list of instance selection results in the group.
        """
        return pulumi.get(self, "instance_selection_results")

    @_builtins.property
    @pulumi.getter(name="provisioningModelMix")
    def provisioning_model_mix(self) -> Optional['outputs.ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicyProvisioningModelMix']:
        """
        Defines how the Group selects the provisioning model to ensure required reliability.
        """
        return pulumi.get(self, "provisioning_model_mix")


@pulumi.output_type
class ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicyInstanceSelectionList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "machineTypes":
            suggest = "machine_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicyInstanceSelectionList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicyInstanceSelectionList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicyInstanceSelectionList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 machine_types: Optional[Sequence[_builtins.str]] = None,
                 rank: Optional[_builtins.int] = None):
        """
        :param Sequence[_builtins.str] machine_types: Full machine-type names, e.g. `"n1-standard-16"`.
        :param _builtins.int rank: Preference of this instance selection. A lower number means higher preference. Dataproc will first try to create a VM based on the machine-type with priority rank and fallback to next rank based on availability. Machine types and instance selections with the same priority have the same preference.
        """
        if machine_types is not None:
            pulumi.set(__self__, "machine_types", machine_types)
        if rank is not None:
            pulumi.set(__self__, "rank", rank)

    @_builtins.property
    @pulumi.getter(name="machineTypes")
    def machine_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        Full machine-type names, e.g. `"n1-standard-16"`.
        """
        return pulumi.get(self, "machine_types")

    @_builtins.property
    @pulumi.getter
    def rank(self) -> Optional[_builtins.int]:
        """
        Preference of this instance selection. A lower number means higher preference. Dataproc will first try to create a VM based on the machine-type with priority rank and fallback to next rank based on availability. Machine types and instance selections with the same priority have the same preference.
        """
        return pulumi.get(self, "rank")


@pulumi.output_type
class ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicyInstanceSelectionResult(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "machineType":
            suggest = "machine_type"
        elif key == "vmCount":
            suggest = "vm_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicyInstanceSelectionResult. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicyInstanceSelectionResult.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicyInstanceSelectionResult.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 machine_type: Optional[_builtins.str] = None,
                 vm_count: Optional[_builtins.int] = None):
        """
        :param _builtins.str machine_type: Full machine-type names, e.g. "n1-standard-16".
        :param _builtins.int vm_count: Number of VM provisioned with the machine_type.
        """
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if vm_count is not None:
            pulumi.set(__self__, "vm_count", vm_count)

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[_builtins.str]:
        """
        Full machine-type names, e.g. "n1-standard-16".
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter(name="vmCount")
    def vm_count(self) -> Optional[_builtins.int]:
        """
        Number of VM provisioned with the machine_type.
        """
        return pulumi.get(self, "vm_count")


@pulumi.output_type
class ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicyProvisioningModelMix(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "standardCapacityBase":
            suggest = "standard_capacity_base"
        elif key == "standardCapacityPercentAboveBase":
            suggest = "standard_capacity_percent_above_base"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicyProvisioningModelMix. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicyProvisioningModelMix.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigPreemptibleWorkerConfigInstanceFlexibilityPolicyProvisioningModelMix.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 standard_capacity_base: Optional[_builtins.int] = None,
                 standard_capacity_percent_above_base: Optional[_builtins.int] = None):
        """
        :param _builtins.int standard_capacity_base: The base capacity that will always use Standard VMs to avoid risk of more preemption than the minimum capacity you need. Dataproc will create only standard VMs until it reaches standardCapacityBase, then it will start using standardCapacityPercentAboveBase to mix Spot with Standard VMs. eg. If 15 instances are requested and standardCapacityBase is 5, Dataproc will create 5 standard VMs and then start mixing spot and standard VMs for remaining 10 instances.
        :param _builtins.int standard_capacity_percent_above_base: The percentage of target capacity that should use Standard VM. The remaining percentage will use Spot VMs. The percentage applies only to the capacity above standardCapacityBase. eg. If 15 instances are requested and standardCapacityBase is 5 and standardCapacityPercentAboveBase is 30, Dataproc will create 5 standard VMs and then start mixing spot and standard VMs for remaining 10 instances. The mix will be 30% standard and 70% spot.
               - - -
        """
        if standard_capacity_base is not None:
            pulumi.set(__self__, "standard_capacity_base", standard_capacity_base)
        if standard_capacity_percent_above_base is not None:
            pulumi.set(__self__, "standard_capacity_percent_above_base", standard_capacity_percent_above_base)

    @_builtins.property
    @pulumi.getter(name="standardCapacityBase")
    def standard_capacity_base(self) -> Optional[_builtins.int]:
        """
        The base capacity that will always use Standard VMs to avoid risk of more preemption than the minimum capacity you need. Dataproc will create only standard VMs until it reaches standardCapacityBase, then it will start using standardCapacityPercentAboveBase to mix Spot with Standard VMs. eg. If 15 instances are requested and standardCapacityBase is 5, Dataproc will create 5 standard VMs and then start mixing spot and standard VMs for remaining 10 instances.
        """
        return pulumi.get(self, "standard_capacity_base")

    @_builtins.property
    @pulumi.getter(name="standardCapacityPercentAboveBase")
    def standard_capacity_percent_above_base(self) -> Optional[_builtins.int]:
        """
        The percentage of target capacity that should use Standard VM. The remaining percentage will use Spot VMs. The percentage applies only to the capacity above standardCapacityBase. eg. If 15 instances are requested and standardCapacityBase is 5 and standardCapacityPercentAboveBase is 30, Dataproc will create 5 standard VMs and then start mixing spot and standard VMs for remaining 10 instances. The mix will be 30% standard and 70% spot.
        - - -
        """
        return pulumi.get(self, "standard_capacity_percent_above_base")


@pulumi.output_type
class ClusterClusterConfigSecurityConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityConfig":
            suggest = "identity_config"
        elif key == "kerberosConfig":
            suggest = "kerberos_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigSecurityConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigSecurityConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigSecurityConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_config: Optional['outputs.ClusterClusterConfigSecurityConfigIdentityConfig'] = None,
                 kerberos_config: Optional['outputs.ClusterClusterConfigSecurityConfigKerberosConfig'] = None):
        """
        :param 'ClusterClusterConfigSecurityConfigIdentityConfigArgs' identity_config: Identity Configuration. At least one of `identity_config`
               or `kerberos_config` is required.
        :param 'ClusterClusterConfigSecurityConfigKerberosConfigArgs' kerberos_config: Kerberos Configuration. At least one of `identity_config`
               or `kerberos_config` is required.
        """
        if identity_config is not None:
            pulumi.set(__self__, "identity_config", identity_config)
        if kerberos_config is not None:
            pulumi.set(__self__, "kerberos_config", kerberos_config)

    @_builtins.property
    @pulumi.getter(name="identityConfig")
    def identity_config(self) -> Optional['outputs.ClusterClusterConfigSecurityConfigIdentityConfig']:
        """
        Identity Configuration. At least one of `identity_config`
        or `kerberos_config` is required.
        """
        return pulumi.get(self, "identity_config")

    @_builtins.property
    @pulumi.getter(name="kerberosConfig")
    def kerberos_config(self) -> Optional['outputs.ClusterClusterConfigSecurityConfigKerberosConfig']:
        """
        Kerberos Configuration. At least one of `identity_config`
        or `kerberos_config` is required.
        """
        return pulumi.get(self, "kerberos_config")


@pulumi.output_type
class ClusterClusterConfigSecurityConfigIdentityConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userServiceAccountMapping":
            suggest = "user_service_account_mapping"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigSecurityConfigIdentityConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigSecurityConfigIdentityConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigSecurityConfigIdentityConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_service_account_mapping: Mapping[str, _builtins.str]):
        """
        :param Mapping[str, _builtins.str] user_service_account_mapping: The end user to service account mappings
               in a service account based multi-tenant cluster
               
               - - -
        """
        pulumi.set(__self__, "user_service_account_mapping", user_service_account_mapping)

    @_builtins.property
    @pulumi.getter(name="userServiceAccountMapping")
    def user_service_account_mapping(self) -> Mapping[str, _builtins.str]:
        """
        The end user to service account mappings
        in a service account based multi-tenant cluster

        - - -
        """
        return pulumi.get(self, "user_service_account_mapping")


@pulumi.output_type
class ClusterClusterConfigSecurityConfigKerberosConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyUri":
            suggest = "kms_key_uri"
        elif key == "rootPrincipalPasswordUri":
            suggest = "root_principal_password_uri"
        elif key == "crossRealmTrustAdminServer":
            suggest = "cross_realm_trust_admin_server"
        elif key == "crossRealmTrustKdc":
            suggest = "cross_realm_trust_kdc"
        elif key == "crossRealmTrustRealm":
            suggest = "cross_realm_trust_realm"
        elif key == "crossRealmTrustSharedPasswordUri":
            suggest = "cross_realm_trust_shared_password_uri"
        elif key == "enableKerberos":
            suggest = "enable_kerberos"
        elif key == "kdcDbKeyUri":
            suggest = "kdc_db_key_uri"
        elif key == "keyPasswordUri":
            suggest = "key_password_uri"
        elif key == "keystorePasswordUri":
            suggest = "keystore_password_uri"
        elif key == "keystoreUri":
            suggest = "keystore_uri"
        elif key == "tgtLifetimeHours":
            suggest = "tgt_lifetime_hours"
        elif key == "truststorePasswordUri":
            suggest = "truststore_password_uri"
        elif key == "truststoreUri":
            suggest = "truststore_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigSecurityConfigKerberosConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigSecurityConfigKerberosConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigSecurityConfigKerberosConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_uri: _builtins.str,
                 root_principal_password_uri: _builtins.str,
                 cross_realm_trust_admin_server: Optional[_builtins.str] = None,
                 cross_realm_trust_kdc: Optional[_builtins.str] = None,
                 cross_realm_trust_realm: Optional[_builtins.str] = None,
                 cross_realm_trust_shared_password_uri: Optional[_builtins.str] = None,
                 enable_kerberos: Optional[_builtins.bool] = None,
                 kdc_db_key_uri: Optional[_builtins.str] = None,
                 key_password_uri: Optional[_builtins.str] = None,
                 keystore_password_uri: Optional[_builtins.str] = None,
                 keystore_uri: Optional[_builtins.str] = None,
                 realm: Optional[_builtins.str] = None,
                 tgt_lifetime_hours: Optional[_builtins.int] = None,
                 truststore_password_uri: Optional[_builtins.str] = None,
                 truststore_uri: Optional[_builtins.str] = None):
        """
        :param _builtins.str kms_key_uri: The URI of the KMS key used to encrypt various sensitive files.
        :param _builtins.str root_principal_password_uri: The Cloud Storage URI of a KMS encrypted file
               containing the root principal password.
        :param _builtins.str cross_realm_trust_admin_server: The admin server (IP or hostname) for the
               remote trusted realm in a cross realm trust relationship.
        :param _builtins.str cross_realm_trust_kdc: The KDC (IP or hostname) for the
               remote trusted realm in a cross realm trust relationship.
        :param _builtins.str cross_realm_trust_realm: The remote realm the Dataproc on-cluster KDC will
               trust, should the user enable cross realm trust.
        :param _builtins.str cross_realm_trust_shared_password_uri: The Cloud Storage URI of a KMS
               encrypted file containing the shared password between the on-cluster Kerberos realm
               and the remote trusted realm, in a cross realm trust relationship.
        :param _builtins.bool enable_kerberos: Flag to indicate whether to Kerberize the cluster.
        :param _builtins.str kdc_db_key_uri: The Cloud Storage URI of a KMS encrypted file containing
               the master key of the KDC database.
        :param _builtins.str key_password_uri: The Cloud Storage URI of a KMS encrypted file containing
               the password to the user provided key. For the self-signed certificate, this password
               is generated by Dataproc.
        :param _builtins.str keystore_password_uri: The Cloud Storage URI of a KMS encrypted file containing
               the password to the user provided keystore. For the self-signed certificated, the password
               is generated by Dataproc.
        :param _builtins.str keystore_uri: The Cloud Storage URI of the keystore file used for SSL encryption.
               If not provided, Dataproc will provide a self-signed certificate.
        :param _builtins.str realm: The name of the on-cluster Kerberos realm. If not specified, the
               uppercased domain of hostnames will be the realm.
        :param _builtins.int tgt_lifetime_hours: The lifetime of the ticket granting ticket, in hours.
        :param _builtins.str truststore_password_uri: The Cloud Storage URI of a KMS encrypted file
               containing the password to the user provided truststore. For the self-signed
               certificate, this password is generated by Dataproc.
        :param _builtins.str truststore_uri: The Cloud Storage URI of the truststore file used for
               SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
        """
        pulumi.set(__self__, "kms_key_uri", kms_key_uri)
        pulumi.set(__self__, "root_principal_password_uri", root_principal_password_uri)
        if cross_realm_trust_admin_server is not None:
            pulumi.set(__self__, "cross_realm_trust_admin_server", cross_realm_trust_admin_server)
        if cross_realm_trust_kdc is not None:
            pulumi.set(__self__, "cross_realm_trust_kdc", cross_realm_trust_kdc)
        if cross_realm_trust_realm is not None:
            pulumi.set(__self__, "cross_realm_trust_realm", cross_realm_trust_realm)
        if cross_realm_trust_shared_password_uri is not None:
            pulumi.set(__self__, "cross_realm_trust_shared_password_uri", cross_realm_trust_shared_password_uri)
        if enable_kerberos is not None:
            pulumi.set(__self__, "enable_kerberos", enable_kerberos)
        if kdc_db_key_uri is not None:
            pulumi.set(__self__, "kdc_db_key_uri", kdc_db_key_uri)
        if key_password_uri is not None:
            pulumi.set(__self__, "key_password_uri", key_password_uri)
        if keystore_password_uri is not None:
            pulumi.set(__self__, "keystore_password_uri", keystore_password_uri)
        if keystore_uri is not None:
            pulumi.set(__self__, "keystore_uri", keystore_uri)
        if realm is not None:
            pulumi.set(__self__, "realm", realm)
        if tgt_lifetime_hours is not None:
            pulumi.set(__self__, "tgt_lifetime_hours", tgt_lifetime_hours)
        if truststore_password_uri is not None:
            pulumi.set(__self__, "truststore_password_uri", truststore_password_uri)
        if truststore_uri is not None:
            pulumi.set(__self__, "truststore_uri", truststore_uri)

    @_builtins.property
    @pulumi.getter(name="kmsKeyUri")
    def kms_key_uri(self) -> _builtins.str:
        """
        The URI of the KMS key used to encrypt various sensitive files.
        """
        return pulumi.get(self, "kms_key_uri")

    @_builtins.property
    @pulumi.getter(name="rootPrincipalPasswordUri")
    def root_principal_password_uri(self) -> _builtins.str:
        """
        The Cloud Storage URI of a KMS encrypted file
        containing the root principal password.
        """
        return pulumi.get(self, "root_principal_password_uri")

    @_builtins.property
    @pulumi.getter(name="crossRealmTrustAdminServer")
    def cross_realm_trust_admin_server(self) -> Optional[_builtins.str]:
        """
        The admin server (IP or hostname) for the
        remote trusted realm in a cross realm trust relationship.
        """
        return pulumi.get(self, "cross_realm_trust_admin_server")

    @_builtins.property
    @pulumi.getter(name="crossRealmTrustKdc")
    def cross_realm_trust_kdc(self) -> Optional[_builtins.str]:
        """
        The KDC (IP or hostname) for the
        remote trusted realm in a cross realm trust relationship.
        """
        return pulumi.get(self, "cross_realm_trust_kdc")

    @_builtins.property
    @pulumi.getter(name="crossRealmTrustRealm")
    def cross_realm_trust_realm(self) -> Optional[_builtins.str]:
        """
        The remote realm the Dataproc on-cluster KDC will
        trust, should the user enable cross realm trust.
        """
        return pulumi.get(self, "cross_realm_trust_realm")

    @_builtins.property
    @pulumi.getter(name="crossRealmTrustSharedPasswordUri")
    def cross_realm_trust_shared_password_uri(self) -> Optional[_builtins.str]:
        """
        The Cloud Storage URI of a KMS
        encrypted file containing the shared password between the on-cluster Kerberos realm
        and the remote trusted realm, in a cross realm trust relationship.
        """
        return pulumi.get(self, "cross_realm_trust_shared_password_uri")

    @_builtins.property
    @pulumi.getter(name="enableKerberos")
    def enable_kerberos(self) -> Optional[_builtins.bool]:
        """
        Flag to indicate whether to Kerberize the cluster.
        """
        return pulumi.get(self, "enable_kerberos")

    @_builtins.property
    @pulumi.getter(name="kdcDbKeyUri")
    def kdc_db_key_uri(self) -> Optional[_builtins.str]:
        """
        The Cloud Storage URI of a KMS encrypted file containing
        the master key of the KDC database.
        """
        return pulumi.get(self, "kdc_db_key_uri")

    @_builtins.property
    @pulumi.getter(name="keyPasswordUri")
    def key_password_uri(self) -> Optional[_builtins.str]:
        """
        The Cloud Storage URI of a KMS encrypted file containing
        the password to the user provided key. For the self-signed certificate, this password
        is generated by Dataproc.
        """
        return pulumi.get(self, "key_password_uri")

    @_builtins.property
    @pulumi.getter(name="keystorePasswordUri")
    def keystore_password_uri(self) -> Optional[_builtins.str]:
        """
        The Cloud Storage URI of a KMS encrypted file containing
        the password to the user provided keystore. For the self-signed certificated, the password
        is generated by Dataproc.
        """
        return pulumi.get(self, "keystore_password_uri")

    @_builtins.property
    @pulumi.getter(name="keystoreUri")
    def keystore_uri(self) -> Optional[_builtins.str]:
        """
        The Cloud Storage URI of the keystore file used for SSL encryption.
        If not provided, Dataproc will provide a self-signed certificate.
        """
        return pulumi.get(self, "keystore_uri")

    @_builtins.property
    @pulumi.getter
    def realm(self) -> Optional[_builtins.str]:
        """
        The name of the on-cluster Kerberos realm. If not specified, the
        uppercased domain of hostnames will be the realm.
        """
        return pulumi.get(self, "realm")

    @_builtins.property
    @pulumi.getter(name="tgtLifetimeHours")
    def tgt_lifetime_hours(self) -> Optional[_builtins.int]:
        """
        The lifetime of the ticket granting ticket, in hours.
        """
        return pulumi.get(self, "tgt_lifetime_hours")

    @_builtins.property
    @pulumi.getter(name="truststorePasswordUri")
    def truststore_password_uri(self) -> Optional[_builtins.str]:
        """
        The Cloud Storage URI of a KMS encrypted file
        containing the password to the user provided truststore. For the self-signed
        certificate, this password is generated by Dataproc.
        """
        return pulumi.get(self, "truststore_password_uri")

    @_builtins.property
    @pulumi.getter(name="truststoreUri")
    def truststore_uri(self) -> Optional[_builtins.str]:
        """
        The Cloud Storage URI of the truststore file used for
        SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
        """
        return pulumi.get(self, "truststore_uri")


@pulumi.output_type
class ClusterClusterConfigSoftwareConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageVersion":
            suggest = "image_version"
        elif key == "optionalComponents":
            suggest = "optional_components"
        elif key == "overrideProperties":
            suggest = "override_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigSoftwareConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigSoftwareConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigSoftwareConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_version: Optional[_builtins.str] = None,
                 optional_components: Optional[Sequence[_builtins.str]] = None,
                 override_properties: Optional[Mapping[str, _builtins.str]] = None,
                 properties: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str image_version: The Cloud Dataproc image version to use
               for the cluster - this controls the sets of software versions
               installed onto the nodes when you create clusters. If not specified, defaults to the
               latest version. For a list of valid versions see
               [Cloud Dataproc versions](https://cloud.google.com/dataproc/docs/concepts/dataproc-versions)
        :param Sequence[_builtins.str] optional_components: The set of optional components to activate on the cluster. See [Available Optional Components](https://cloud.google.com/dataproc/docs/concepts/components/overview#available_optional_components).
               
               - - -
        :param Mapping[str, _builtins.str] override_properties: A list of override and additional properties (key/value pairs)
               used to modify various aspects of the common configuration files used when creating
               a cluster. For a list of valid properties please see
               [Cluster properties](https://cloud.google.com/dataproc/docs/concepts/cluster-properties)
        :param Mapping[str, _builtins.str] properties: A list of the properties used to set the daemon config files.
               This will include any values supplied by the user via `cluster_config.software_config.override_properties`
        """
        if image_version is not None:
            pulumi.set(__self__, "image_version", image_version)
        if optional_components is not None:
            pulumi.set(__self__, "optional_components", optional_components)
        if override_properties is not None:
            pulumi.set(__self__, "override_properties", override_properties)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @_builtins.property
    @pulumi.getter(name="imageVersion")
    def image_version(self) -> Optional[_builtins.str]:
        """
        The Cloud Dataproc image version to use
        for the cluster - this controls the sets of software versions
        installed onto the nodes when you create clusters. If not specified, defaults to the
        latest version. For a list of valid versions see
        [Cloud Dataproc versions](https://cloud.google.com/dataproc/docs/concepts/dataproc-versions)
        """
        return pulumi.get(self, "image_version")

    @_builtins.property
    @pulumi.getter(name="optionalComponents")
    def optional_components(self) -> Optional[Sequence[_builtins.str]]:
        """
        The set of optional components to activate on the cluster. See [Available Optional Components](https://cloud.google.com/dataproc/docs/concepts/components/overview#available_optional_components).

        - - -
        """
        return pulumi.get(self, "optional_components")

    @_builtins.property
    @pulumi.getter(name="overrideProperties")
    def override_properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A list of override and additional properties (key/value pairs)
        used to modify various aspects of the common configuration files used when creating
        a cluster. For a list of valid properties please see
        [Cluster properties](https://cloud.google.com/dataproc/docs/concepts/cluster-properties)
        """
        return pulumi.get(self, "override_properties")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A list of the properties used to set the daemon config files.
        This will include any values supplied by the user via `cluster_config.software_config.override_properties`
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class ClusterClusterConfigWorkerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskConfig":
            suggest = "disk_config"
        elif key == "imageUri":
            suggest = "image_uri"
        elif key == "instanceNames":
            suggest = "instance_names"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "minCpuPlatform":
            suggest = "min_cpu_platform"
        elif key == "minNumInstances":
            suggest = "min_num_instances"
        elif key == "numInstances":
            suggest = "num_instances"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigWorkerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigWorkerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigWorkerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerators: Optional[Sequence['outputs.ClusterClusterConfigWorkerConfigAccelerator']] = None,
                 disk_config: Optional['outputs.ClusterClusterConfigWorkerConfigDiskConfig'] = None,
                 image_uri: Optional[_builtins.str] = None,
                 instance_names: Optional[Sequence[_builtins.str]] = None,
                 machine_type: Optional[_builtins.str] = None,
                 min_cpu_platform: Optional[_builtins.str] = None,
                 min_num_instances: Optional[_builtins.int] = None,
                 num_instances: Optional[_builtins.int] = None):
        """
        :param Sequence['ClusterClusterConfigWorkerConfigAcceleratorArgs'] accelerators: The Compute Engine accelerator configuration for these instances. Can be specified multiple times.
        :param 'ClusterClusterConfigWorkerConfigDiskConfigArgs' disk_config: Disk Config
        :param _builtins.str image_uri: The URI for the image to use for this worker.  See [the guide](https://cloud.google.com/dataproc/docs/guides/dataproc-images)
               for more information.
        :param Sequence[_builtins.str] instance_names: List of worker instance names which have been assigned
               to the cluster.
        :param _builtins.str machine_type: The name of a Google Compute Engine machine type
               to create for the worker nodes. If not specified, GCP will default to a predetermined
               computed value (currently `n1-standard-4`).
        :param _builtins.str min_cpu_platform: The name of a minimum generation of CPU family
               for the master. If not specified, GCP will default to a predetermined computed value
               for each zone. See [the guide](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
               for details about which CPU families are available (and defaulted) for each zone.
        :param _builtins.int min_num_instances: The minimum number of primary worker instances to create.  If `min_num_instances` is set, cluster creation will succeed if the number of primary workers created is at least equal to the `min_num_instances` number.
        :param _builtins.int num_instances: Specifies the number of worker nodes to create.
               If not specified, GCP will default to a predetermined computed value (currently 2).
               There is currently a beta feature which allows you to run a
               [Single Node Cluster](https://cloud.google.com/dataproc/docs/concepts/single-node-clusters).
               In order to take advantage of this you need to set
               `"dataproc:dataproc.allow.zero.workers" = "true"` in
               `cluster_config.software_config.properties`
        """
        if accelerators is not None:
            pulumi.set(__self__, "accelerators", accelerators)
        if disk_config is not None:
            pulumi.set(__self__, "disk_config", disk_config)
        if image_uri is not None:
            pulumi.set(__self__, "image_uri", image_uri)
        if instance_names is not None:
            pulumi.set(__self__, "instance_names", instance_names)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if min_num_instances is not None:
            pulumi.set(__self__, "min_num_instances", min_num_instances)
        if num_instances is not None:
            pulumi.set(__self__, "num_instances", num_instances)

    @_builtins.property
    @pulumi.getter
    def accelerators(self) -> Optional[Sequence['outputs.ClusterClusterConfigWorkerConfigAccelerator']]:
        """
        The Compute Engine accelerator configuration for these instances. Can be specified multiple times.
        """
        return pulumi.get(self, "accelerators")

    @_builtins.property
    @pulumi.getter(name="diskConfig")
    def disk_config(self) -> Optional['outputs.ClusterClusterConfigWorkerConfigDiskConfig']:
        """
        Disk Config
        """
        return pulumi.get(self, "disk_config")

    @_builtins.property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> Optional[_builtins.str]:
        """
        The URI for the image to use for this worker.  See [the guide](https://cloud.google.com/dataproc/docs/guides/dataproc-images)
        for more information.
        """
        return pulumi.get(self, "image_uri")

    @_builtins.property
    @pulumi.getter(name="instanceNames")
    def instance_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of worker instance names which have been assigned
        to the cluster.
        """
        return pulumi.get(self, "instance_names")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[_builtins.str]:
        """
        The name of a Google Compute Engine machine type
        to create for the worker nodes. If not specified, GCP will default to a predetermined
        computed value (currently `n1-standard-4`).
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[_builtins.str]:
        """
        The name of a minimum generation of CPU family
        for the master. If not specified, GCP will default to a predetermined computed value
        for each zone. See [the guide](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
        for details about which CPU families are available (and defaulted) for each zone.
        """
        return pulumi.get(self, "min_cpu_platform")

    @_builtins.property
    @pulumi.getter(name="minNumInstances")
    def min_num_instances(self) -> Optional[_builtins.int]:
        """
        The minimum number of primary worker instances to create.  If `min_num_instances` is set, cluster creation will succeed if the number of primary workers created is at least equal to the `min_num_instances` number.
        """
        return pulumi.get(self, "min_num_instances")

    @_builtins.property
    @pulumi.getter(name="numInstances")
    def num_instances(self) -> Optional[_builtins.int]:
        """
        Specifies the number of worker nodes to create.
        If not specified, GCP will default to a predetermined computed value (currently 2).
        There is currently a beta feature which allows you to run a
        [Single Node Cluster](https://cloud.google.com/dataproc/docs/concepts/single-node-clusters).
        In order to take advantage of this you need to set
        `"dataproc:dataproc.allow.zero.workers" = "true"` in
        `cluster_config.software_config.properties`
        """
        return pulumi.get(self, "num_instances")


@pulumi.output_type
class ClusterClusterConfigWorkerConfigAccelerator(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceleratorCount":
            suggest = "accelerator_count"
        elif key == "acceleratorType":
            suggest = "accelerator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigWorkerConfigAccelerator. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigWorkerConfigAccelerator.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigWorkerConfigAccelerator.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerator_count: _builtins.int,
                 accelerator_type: _builtins.str):
        """
        :param _builtins.int accelerator_count: The number of the accelerator cards of this type exposed to this instance. Often restricted to one of `1`, `2`, `4`, or `8`.
               
               > The Cloud Dataproc API can return unintuitive error messages when using accelerators; even when you have defined an accelerator, Auto Zone Placement does not exclusively select
               zones that have that accelerator available. If you get a 400 error that the accelerator can't be found, this is a likely cause. Make sure you check [accelerator availability by zone](https://cloud.google.com/compute/docs/reference/rest/v1/acceleratorTypes/list)
               if you are trying to use accelerators in a given zone.
               
               - - -
        :param _builtins.str accelerator_type: The short name of the accelerator type to expose to this instance. For example, `nvidia-tesla-k80`.
        """
        pulumi.set(__self__, "accelerator_count", accelerator_count)
        pulumi.set(__self__, "accelerator_type", accelerator_type)

    @_builtins.property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> _builtins.int:
        """
        The number of the accelerator cards of this type exposed to this instance. Often restricted to one of `1`, `2`, `4`, or `8`.

        > The Cloud Dataproc API can return unintuitive error messages when using accelerators; even when you have defined an accelerator, Auto Zone Placement does not exclusively select
        zones that have that accelerator available. If you get a 400 error that the accelerator can't be found, this is a likely cause. Make sure you check [accelerator availability by zone](https://cloud.google.com/compute/docs/reference/rest/v1/acceleratorTypes/list)
        if you are trying to use accelerators in a given zone.

        - - -
        """
        return pulumi.get(self, "accelerator_count")

    @_builtins.property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> _builtins.str:
        """
        The short name of the accelerator type to expose to this instance. For example, `nvidia-tesla-k80`.
        """
        return pulumi.get(self, "accelerator_type")


@pulumi.output_type
class ClusterClusterConfigWorkerConfigDiskConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootDiskSizeGb":
            suggest = "boot_disk_size_gb"
        elif key == "bootDiskType":
            suggest = "boot_disk_type"
        elif key == "localSsdInterface":
            suggest = "local_ssd_interface"
        elif key == "numLocalSsds":
            suggest = "num_local_ssds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterConfigWorkerConfigDiskConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterConfigWorkerConfigDiskConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterConfigWorkerConfigDiskConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot_disk_size_gb: Optional[_builtins.int] = None,
                 boot_disk_type: Optional[_builtins.str] = None,
                 local_ssd_interface: Optional[_builtins.str] = None,
                 num_local_ssds: Optional[_builtins.int] = None):
        """
        :param _builtins.int boot_disk_size_gb: Size of the primary disk attached to each worker node, specified
               in GB. The smallest allowed disk size is 10GB. GCP will default to a predetermined
               computed value if not set (currently 500GB). Note: If SSDs are not
               attached, it also contains the HDFS data blocks and Hadoop working directories.
        :param _builtins.str boot_disk_type: The disk type of the primary disk attached to each node.
               One of `"pd-ssd"` or `"pd-standard"`. Defaults to `"pd-standard"`.
        :param _builtins.str local_ssd_interface: Interface type of local SSDs (default is "scsi"). Valid values: "scsi" (Small Computer System Interface), "nvme" (Non-Volatile Memory Express).
        :param _builtins.int num_local_ssds: The amount of local SSD disks that will be
               attached to each worker cluster node. Defaults to 0.
        """
        if boot_disk_size_gb is not None:
            pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        if boot_disk_type is not None:
            pulumi.set(__self__, "boot_disk_type", boot_disk_type)
        if local_ssd_interface is not None:
            pulumi.set(__self__, "local_ssd_interface", local_ssd_interface)
        if num_local_ssds is not None:
            pulumi.set(__self__, "num_local_ssds", num_local_ssds)

    @_builtins.property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> Optional[_builtins.int]:
        """
        Size of the primary disk attached to each worker node, specified
        in GB. The smallest allowed disk size is 10GB. GCP will default to a predetermined
        computed value if not set (currently 500GB). Note: If SSDs are not
        attached, it also contains the HDFS data blocks and Hadoop working directories.
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @_builtins.property
    @pulumi.getter(name="bootDiskType")
    def boot_disk_type(self) -> Optional[_builtins.str]:
        """
        The disk type of the primary disk attached to each node.
        One of `"pd-ssd"` or `"pd-standard"`. Defaults to `"pd-standard"`.
        """
        return pulumi.get(self, "boot_disk_type")

    @_builtins.property
    @pulumi.getter(name="localSsdInterface")
    def local_ssd_interface(self) -> Optional[_builtins.str]:
        """
        Interface type of local SSDs (default is "scsi"). Valid values: "scsi" (Small Computer System Interface), "nvme" (Non-Volatile Memory Express).
        """
        return pulumi.get(self, "local_ssd_interface")

    @_builtins.property
    @pulumi.getter(name="numLocalSsds")
    def num_local_ssds(self) -> Optional[_builtins.int]:
        """
        The amount of local SSD disks that will be
        attached to each worker cluster node. Defaults to 0.
        """
        return pulumi.get(self, "num_local_ssds")


@pulumi.output_type
class ClusterIAMBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class ClusterIAMMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class ClusterVirtualClusterConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auxiliaryServicesConfig":
            suggest = "auxiliary_services_config"
        elif key == "kubernetesClusterConfig":
            suggest = "kubernetes_cluster_config"
        elif key == "stagingBucket":
            suggest = "staging_bucket"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterVirtualClusterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterVirtualClusterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterVirtualClusterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auxiliary_services_config: Optional['outputs.ClusterVirtualClusterConfigAuxiliaryServicesConfig'] = None,
                 kubernetes_cluster_config: Optional['outputs.ClusterVirtualClusterConfigKubernetesClusterConfig'] = None,
                 staging_bucket: Optional[_builtins.str] = None):
        """
        :param 'ClusterVirtualClusterConfigAuxiliaryServicesConfigArgs' auxiliary_services_config: Configuration of auxiliary services used by this cluster. 
               Structure defined below.
        :param 'ClusterVirtualClusterConfigKubernetesClusterConfigArgs' kubernetes_cluster_config: The configuration for running the Dataproc cluster on Kubernetes.
               Structure defined below.
               - - -
        :param _builtins.str staging_bucket: The Cloud Storage staging bucket used to stage files,
               such as Hadoop jars, between client machines and the cluster.
               Note: If you don't explicitly specify a `staging_bucket`
               then GCP will auto create / assign one for you. However, you are not guaranteed
               an auto generated bucket which is solely dedicated to your cluster; it may be shared
               with other clusters in the same region/zone also choosing to use the auto generation
               option.
        """
        if auxiliary_services_config is not None:
            pulumi.set(__self__, "auxiliary_services_config", auxiliary_services_config)
        if kubernetes_cluster_config is not None:
            pulumi.set(__self__, "kubernetes_cluster_config", kubernetes_cluster_config)
        if staging_bucket is not None:
            pulumi.set(__self__, "staging_bucket", staging_bucket)

    @_builtins.property
    @pulumi.getter(name="auxiliaryServicesConfig")
    def auxiliary_services_config(self) -> Optional['outputs.ClusterVirtualClusterConfigAuxiliaryServicesConfig']:
        """
        Configuration of auxiliary services used by this cluster. 
        Structure defined below.
        """
        return pulumi.get(self, "auxiliary_services_config")

    @_builtins.property
    @pulumi.getter(name="kubernetesClusterConfig")
    def kubernetes_cluster_config(self) -> Optional['outputs.ClusterVirtualClusterConfigKubernetesClusterConfig']:
        """
        The configuration for running the Dataproc cluster on Kubernetes.
        Structure defined below.
        - - -
        """
        return pulumi.get(self, "kubernetes_cluster_config")

    @_builtins.property
    @pulumi.getter(name="stagingBucket")
    def staging_bucket(self) -> Optional[_builtins.str]:
        """
        The Cloud Storage staging bucket used to stage files,
        such as Hadoop jars, between client machines and the cluster.
        Note: If you don't explicitly specify a `staging_bucket`
        then GCP will auto create / assign one for you. However, you are not guaranteed
        an auto generated bucket which is solely dedicated to your cluster; it may be shared
        with other clusters in the same region/zone also choosing to use the auto generation
        option.
        """
        return pulumi.get(self, "staging_bucket")


@pulumi.output_type
class ClusterVirtualClusterConfigAuxiliaryServicesConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metastoreConfig":
            suggest = "metastore_config"
        elif key == "sparkHistoryServerConfig":
            suggest = "spark_history_server_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterVirtualClusterConfigAuxiliaryServicesConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterVirtualClusterConfigAuxiliaryServicesConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterVirtualClusterConfigAuxiliaryServicesConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metastore_config: Optional['outputs.ClusterVirtualClusterConfigAuxiliaryServicesConfigMetastoreConfig'] = None,
                 spark_history_server_config: Optional['outputs.ClusterVirtualClusterConfigAuxiliaryServicesConfigSparkHistoryServerConfig'] = None):
        """
        :param 'ClusterVirtualClusterConfigAuxiliaryServicesConfigMetastoreConfigArgs' metastore_config: The Hive Metastore configuration for this workload.
        :param 'ClusterVirtualClusterConfigAuxiliaryServicesConfigSparkHistoryServerConfigArgs' spark_history_server_config: The Spark History Server configuration for the workload.
        """
        if metastore_config is not None:
            pulumi.set(__self__, "metastore_config", metastore_config)
        if spark_history_server_config is not None:
            pulumi.set(__self__, "spark_history_server_config", spark_history_server_config)

    @_builtins.property
    @pulumi.getter(name="metastoreConfig")
    def metastore_config(self) -> Optional['outputs.ClusterVirtualClusterConfigAuxiliaryServicesConfigMetastoreConfig']:
        """
        The Hive Metastore configuration for this workload.
        """
        return pulumi.get(self, "metastore_config")

    @_builtins.property
    @pulumi.getter(name="sparkHistoryServerConfig")
    def spark_history_server_config(self) -> Optional['outputs.ClusterVirtualClusterConfigAuxiliaryServicesConfigSparkHistoryServerConfig']:
        """
        The Spark History Server configuration for the workload.
        """
        return pulumi.get(self, "spark_history_server_config")


@pulumi.output_type
class ClusterVirtualClusterConfigAuxiliaryServicesConfigMetastoreConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataprocMetastoreService":
            suggest = "dataproc_metastore_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterVirtualClusterConfigAuxiliaryServicesConfigMetastoreConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterVirtualClusterConfigAuxiliaryServicesConfigMetastoreConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterVirtualClusterConfigAuxiliaryServicesConfigMetastoreConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataproc_metastore_service: Optional[_builtins.str] = None):
        """
        :param _builtins.str dataproc_metastore_service: Resource name of an existing Dataproc Metastore service.
        """
        if dataproc_metastore_service is not None:
            pulumi.set(__self__, "dataproc_metastore_service", dataproc_metastore_service)

    @_builtins.property
    @pulumi.getter(name="dataprocMetastoreService")
    def dataproc_metastore_service(self) -> Optional[_builtins.str]:
        """
        Resource name of an existing Dataproc Metastore service.
        """
        return pulumi.get(self, "dataproc_metastore_service")


@pulumi.output_type
class ClusterVirtualClusterConfigAuxiliaryServicesConfigSparkHistoryServerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataprocCluster":
            suggest = "dataproc_cluster"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterVirtualClusterConfigAuxiliaryServicesConfigSparkHistoryServerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterVirtualClusterConfigAuxiliaryServicesConfigSparkHistoryServerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterVirtualClusterConfigAuxiliaryServicesConfigSparkHistoryServerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataproc_cluster: Optional[_builtins.str] = None):
        """
        :param _builtins.str dataproc_cluster: Resource name of an existing Dataproc Cluster to act as a Spark History Server for the workload.
               - - -
        """
        if dataproc_cluster is not None:
            pulumi.set(__self__, "dataproc_cluster", dataproc_cluster)

    @_builtins.property
    @pulumi.getter(name="dataprocCluster")
    def dataproc_cluster(self) -> Optional[_builtins.str]:
        """
        Resource name of an existing Dataproc Cluster to act as a Spark History Server for the workload.
        - - -
        """
        return pulumi.get(self, "dataproc_cluster")


@pulumi.output_type
class ClusterVirtualClusterConfigKubernetesClusterConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gkeClusterConfig":
            suggest = "gke_cluster_config"
        elif key == "kubernetesSoftwareConfig":
            suggest = "kubernetes_software_config"
        elif key == "kubernetesNamespace":
            suggest = "kubernetes_namespace"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterVirtualClusterConfigKubernetesClusterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterVirtualClusterConfigKubernetesClusterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterVirtualClusterConfigKubernetesClusterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gke_cluster_config: 'outputs.ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfig',
                 kubernetes_software_config: 'outputs.ClusterVirtualClusterConfigKubernetesClusterConfigKubernetesSoftwareConfig',
                 kubernetes_namespace: Optional[_builtins.str] = None):
        """
        :param 'ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigArgs' gke_cluster_config: The configuration for running the Dataproc cluster on GKE.
        :param 'ClusterVirtualClusterConfigKubernetesClusterConfigKubernetesSoftwareConfigArgs' kubernetes_software_config: The software configuration for this Dataproc cluster running on Kubernetes.
        :param _builtins.str kubernetes_namespace: A namespace within the Kubernetes cluster to deploy into. 
               If this namespace does not exist, it is created.
               If it  exists, Dataproc verifies that another Dataproc VirtualCluster is not installed into it.
               If not specified, the name of the Dataproc Cluster is used.
        """
        pulumi.set(__self__, "gke_cluster_config", gke_cluster_config)
        pulumi.set(__self__, "kubernetes_software_config", kubernetes_software_config)
        if kubernetes_namespace is not None:
            pulumi.set(__self__, "kubernetes_namespace", kubernetes_namespace)

    @_builtins.property
    @pulumi.getter(name="gkeClusterConfig")
    def gke_cluster_config(self) -> 'outputs.ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfig':
        """
        The configuration for running the Dataproc cluster on GKE.
        """
        return pulumi.get(self, "gke_cluster_config")

    @_builtins.property
    @pulumi.getter(name="kubernetesSoftwareConfig")
    def kubernetes_software_config(self) -> 'outputs.ClusterVirtualClusterConfigKubernetesClusterConfigKubernetesSoftwareConfig':
        """
        The software configuration for this Dataproc cluster running on Kubernetes.
        """
        return pulumi.get(self, "kubernetes_software_config")

    @_builtins.property
    @pulumi.getter(name="kubernetesNamespace")
    def kubernetes_namespace(self) -> Optional[_builtins.str]:
        """
        A namespace within the Kubernetes cluster to deploy into. 
        If this namespace does not exist, it is created.
        If it  exists, Dataproc verifies that another Dataproc VirtualCluster is not installed into it.
        If not specified, the name of the Dataproc Cluster is used.
        """
        return pulumi.get(self, "kubernetes_namespace")


@pulumi.output_type
class ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gkeClusterTarget":
            suggest = "gke_cluster_target"
        elif key == "nodePoolTargets":
            suggest = "node_pool_targets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gke_cluster_target: Optional[_builtins.str] = None,
                 node_pool_targets: Optional[Sequence['outputs.ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTarget']] = None):
        """
        :param _builtins.str gke_cluster_target: A target GKE cluster to deploy to. It must be in the same project and region as the Dataproc cluster 
               (the GKE cluster can be zonal or regional)
        :param Sequence['ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetArgs'] node_pool_targets: GKE node pools where workloads will be scheduled. At least one node pool must be assigned the `DEFAULT` 
               GkeNodePoolTarget.Role. If a GkeNodePoolTarget is not specified, Dataproc constructs a `DEFAULT` GkeNodePoolTarget.
               Each role can be given to only one GkeNodePoolTarget. All node pools must have the same location settings.
        """
        if gke_cluster_target is not None:
            pulumi.set(__self__, "gke_cluster_target", gke_cluster_target)
        if node_pool_targets is not None:
            pulumi.set(__self__, "node_pool_targets", node_pool_targets)

    @_builtins.property
    @pulumi.getter(name="gkeClusterTarget")
    def gke_cluster_target(self) -> Optional[_builtins.str]:
        """
        A target GKE cluster to deploy to. It must be in the same project and region as the Dataproc cluster 
        (the GKE cluster can be zonal or regional)
        """
        return pulumi.get(self, "gke_cluster_target")

    @_builtins.property
    @pulumi.getter(name="nodePoolTargets")
    def node_pool_targets(self) -> Optional[Sequence['outputs.ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTarget']]:
        """
        GKE node pools where workloads will be scheduled. At least one node pool must be assigned the `DEFAULT` 
        GkeNodePoolTarget.Role. If a GkeNodePoolTarget is not specified, Dataproc constructs a `DEFAULT` GkeNodePoolTarget.
        Each role can be given to only one GkeNodePoolTarget. All node pools must have the same location settings.
        """
        return pulumi.get(self, "node_pool_targets")


@pulumi.output_type
class ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodePool":
            suggest = "node_pool"
        elif key == "nodePoolConfig":
            suggest = "node_pool_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_pool: _builtins.str,
                 roles: Sequence[_builtins.str],
                 node_pool_config: Optional['outputs.ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfig'] = None):
        """
        :param _builtins.str node_pool: The target GKE node pool.
        :param Sequence[_builtins.str] roles: The roles associated with the GKE node pool. 
               One of `"DEFAULT"`, `"CONTROLLER"`, `"SPARK_DRIVER"` or `"SPARK_EXECUTOR"`.
        :param 'ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigArgs' node_pool_config: The configuration for the GKE node pool. 
               If specified, Dataproc attempts to create a node pool with the specified shape.
               If one with the same name already exists, it is verified against all specified fields.
               If a field differs, the virtual cluster creation will fail.
        """
        pulumi.set(__self__, "node_pool", node_pool)
        pulumi.set(__self__, "roles", roles)
        if node_pool_config is not None:
            pulumi.set(__self__, "node_pool_config", node_pool_config)

    @_builtins.property
    @pulumi.getter(name="nodePool")
    def node_pool(self) -> _builtins.str:
        """
        The target GKE node pool.
        """
        return pulumi.get(self, "node_pool")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Sequence[_builtins.str]:
        """
        The roles associated with the GKE node pool. 
        One of `"DEFAULT"`, `"CONTROLLER"`, `"SPARK_DRIVER"` or `"SPARK_EXECUTOR"`.
        """
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter(name="nodePoolConfig")
    def node_pool_config(self) -> Optional['outputs.ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfig']:
        """
        The configuration for the GKE node pool. 
        If specified, Dataproc attempts to create a node pool with the specified shape.
        If one with the same name already exists, it is verified against all specified fields.
        If a field differs, the virtual cluster creation will fail.
        """
        return pulumi.get(self, "node_pool_config")


@pulumi.output_type
class ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfig(dict):
    def __init__(__self__, *,
                 locations: Sequence[_builtins.str],
                 autoscaling: Optional['outputs.ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigAutoscaling'] = None,
                 config: Optional['outputs.ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigConfig'] = None):
        """
        :param Sequence[_builtins.str] locations: The list of Compute Engine zones where node pool nodes associated 
               with a Dataproc on GKE virtual cluster will be located.
               - - -
        :param 'ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigAutoscalingArgs' autoscaling: The autoscaler configuration for this node pool. 
               The autoscaler is enabled only when a valid configuration is present.
        :param 'ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigConfigArgs' config: The node pool configuration.
        """
        pulumi.set(__self__, "locations", locations)
        if autoscaling is not None:
            pulumi.set(__self__, "autoscaling", autoscaling)
        if config is not None:
            pulumi.set(__self__, "config", config)

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Sequence[_builtins.str]:
        """
        The list of Compute Engine zones where node pool nodes associated 
        with a Dataproc on GKE virtual cluster will be located.
        - - -
        """
        return pulumi.get(self, "locations")

    @_builtins.property
    @pulumi.getter
    def autoscaling(self) -> Optional['outputs.ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigAutoscaling']:
        """
        The autoscaler configuration for this node pool. 
        The autoscaler is enabled only when a valid configuration is present.
        """
        return pulumi.get(self, "autoscaling")

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional['outputs.ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigConfig']:
        """
        The node pool configuration.
        """
        return pulumi.get(self, "config")


@pulumi.output_type
class ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigAutoscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxNodeCount":
            suggest = "max_node_count"
        elif key == "minNodeCount":
            suggest = "min_node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigAutoscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigAutoscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigAutoscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_node_count: Optional[_builtins.int] = None,
                 min_node_count: Optional[_builtins.int] = None):
        """
        :param _builtins.int max_node_count: The maximum number of nodes in the node pool. Must be >= minNodeCount, and must be > 0.
        :param _builtins.int min_node_count: The minimum number of nodes in the node pool. Must be >= 0 and <= maxNodeCount.
        """
        if max_node_count is not None:
            pulumi.set(__self__, "max_node_count", max_node_count)
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)

    @_builtins.property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> Optional[_builtins.int]:
        """
        The maximum number of nodes in the node pool. Must be >= minNodeCount, and must be > 0.
        """
        return pulumi.get(self, "max_node_count")

    @_builtins.property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[_builtins.int]:
        """
        The minimum number of nodes in the node pool. Must be >= 0 and <= maxNodeCount.
        """
        return pulumi.get(self, "min_node_count")


@pulumi.output_type
class ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localSsdCount":
            suggest = "local_ssd_count"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "minCpuPlatform":
            suggest = "min_cpu_platform"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_ssd_count: Optional[_builtins.int] = None,
                 machine_type: Optional[_builtins.str] = None,
                 min_cpu_platform: Optional[_builtins.str] = None,
                 preemptible: Optional[_builtins.bool] = None,
                 spot: Optional[_builtins.bool] = None):
        """
        :param _builtins.int local_ssd_count: The number of local SSD disks to attach to the node, 
               which is limited by the maximum number of disks allowable per zone.
        :param _builtins.str machine_type: The name of a Compute Engine machine type.
        :param _builtins.str min_cpu_platform: Minimum CPU platform to be used by this instance. 
               The instance may be scheduled on the specified or a newer CPU platform.
               Specify the friendly names of CPU platforms, such as "Intel Haswell" or "Intel Sandy Bridge".
        :param _builtins.bool preemptible: Whether the nodes are created as preemptible VM instances. 
               Preemptible nodes cannot be used in a node pool with the CONTROLLER role or in the DEFAULT node pool if the
               CONTROLLER role is not assigned (the DEFAULT node pool will assume the CONTROLLER role).
        :param _builtins.bool spot: Spot flag for enabling Spot VM, which is a rebrand of the existing preemptible flag.
        """
        if local_ssd_count is not None:
            pulumi.set(__self__, "local_ssd_count", local_ssd_count)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if preemptible is not None:
            pulumi.set(__self__, "preemptible", preemptible)
        if spot is not None:
            pulumi.set(__self__, "spot", spot)

    @_builtins.property
    @pulumi.getter(name="localSsdCount")
    def local_ssd_count(self) -> Optional[_builtins.int]:
        """
        The number of local SSD disks to attach to the node, 
        which is limited by the maximum number of disks allowable per zone.
        """
        return pulumi.get(self, "local_ssd_count")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[_builtins.str]:
        """
        The name of a Compute Engine machine type.
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[_builtins.str]:
        """
        Minimum CPU platform to be used by this instance. 
        The instance may be scheduled on the specified or a newer CPU platform.
        Specify the friendly names of CPU platforms, such as "Intel Haswell" or "Intel Sandy Bridge".
        """
        return pulumi.get(self, "min_cpu_platform")

    @_builtins.property
    @pulumi.getter
    def preemptible(self) -> Optional[_builtins.bool]:
        """
        Whether the nodes are created as preemptible VM instances. 
        Preemptible nodes cannot be used in a node pool with the CONTROLLER role or in the DEFAULT node pool if the
        CONTROLLER role is not assigned (the DEFAULT node pool will assume the CONTROLLER role).
        """
        return pulumi.get(self, "preemptible")

    @_builtins.property
    @pulumi.getter
    def spot(self) -> Optional[_builtins.bool]:
        """
        Spot flag for enabling Spot VM, which is a rebrand of the existing preemptible flag.
        """
        return pulumi.get(self, "spot")


@pulumi.output_type
class ClusterVirtualClusterConfigKubernetesClusterConfigKubernetesSoftwareConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentVersion":
            suggest = "component_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterVirtualClusterConfigKubernetesClusterConfigKubernetesSoftwareConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterVirtualClusterConfigKubernetesClusterConfigKubernetesSoftwareConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterVirtualClusterConfigKubernetesClusterConfigKubernetesSoftwareConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_version: Mapping[str, _builtins.str],
                 properties: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Mapping[str, _builtins.str] component_version: The components that should be installed in this Dataproc cluster. The key must be a string from the   
               KubernetesComponent enumeration. The value is the version of the software to be installed. At least one entry must be specified.
               * **NOTE** : `component_version[SPARK]` is mandatory to set, or the creation of the cluster will fail.
        :param Mapping[str, _builtins.str] properties: The properties to set on daemon config files. Property keys are specified in prefix:property format, 
               for example spark:spark.kubernetes.container.image.
        """
        pulumi.set(__self__, "component_version", component_version)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @_builtins.property
    @pulumi.getter(name="componentVersion")
    def component_version(self) -> Mapping[str, _builtins.str]:
        """
        The components that should be installed in this Dataproc cluster. The key must be a string from the   
        KubernetesComponent enumeration. The value is the version of the software to be installed. At least one entry must be specified.
        * **NOTE** : `component_version[SPARK]` is mandatory to set, or the creation of the cluster will fail.
        """
        return pulumi.get(self, "component_version")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The properties to set on daemon config files. Property keys are specified in prefix:property format, 
        for example spark:spark.kubernetes.container.image.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class GdcApplicationEnvironmentSparkApplicationEnvironmentConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultProperties":
            suggest = "default_properties"
        elif key == "defaultVersion":
            suggest = "default_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GdcApplicationEnvironmentSparkApplicationEnvironmentConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GdcApplicationEnvironmentSparkApplicationEnvironmentConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GdcApplicationEnvironmentSparkApplicationEnvironmentConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_properties: Optional[Mapping[str, _builtins.str]] = None,
                 default_version: Optional[_builtins.str] = None):
        """
        :param Mapping[str, _builtins.str] default_properties: A map of default Spark properties to apply to workloads in this application environment. These defaults may be overridden by per-application properties.
        :param _builtins.str default_version: The default Dataproc version to use for applications submitted to this application environment
        """
        if default_properties is not None:
            pulumi.set(__self__, "default_properties", default_properties)
        if default_version is not None:
            pulumi.set(__self__, "default_version", default_version)

    @_builtins.property
    @pulumi.getter(name="defaultProperties")
    def default_properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of default Spark properties to apply to workloads in this application environment. These defaults may be overridden by per-application properties.
        """
        return pulumi.get(self, "default_properties")

    @_builtins.property
    @pulumi.getter(name="defaultVersion")
    def default_version(self) -> Optional[_builtins.str]:
        """
        The default Dataproc version to use for applications submitted to this application environment
        """
        return pulumi.get(self, "default_version")


@pulumi.output_type
class GdcServiceInstanceGdceCluster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gdceCluster":
            suggest = "gdce_cluster"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GdcServiceInstanceGdceCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GdcServiceInstanceGdceCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GdcServiceInstanceGdceCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gdce_cluster: _builtins.str):
        """
        :param _builtins.str gdce_cluster: Gdce cluster resource id.
        """
        pulumi.set(__self__, "gdce_cluster", gdce_cluster)

    @_builtins.property
    @pulumi.getter(name="gdceCluster")
    def gdce_cluster(self) -> _builtins.str:
        """
        Gdce cluster resource id.
        """
        return pulumi.get(self, "gdce_cluster")


@pulumi.output_type
class GdcServiceInstanceSparkServiceInstanceConfig(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class GdcSparkApplicationPysparkApplicationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mainPythonFileUri":
            suggest = "main_python_file_uri"
        elif key == "archiveUris":
            suggest = "archive_uris"
        elif key == "fileUris":
            suggest = "file_uris"
        elif key == "jarFileUris":
            suggest = "jar_file_uris"
        elif key == "pythonFileUris":
            suggest = "python_file_uris"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GdcSparkApplicationPysparkApplicationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GdcSparkApplicationPysparkApplicationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GdcSparkApplicationPysparkApplicationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 main_python_file_uri: _builtins.str,
                 archive_uris: Optional[Sequence[_builtins.str]] = None,
                 args: Optional[Sequence[_builtins.str]] = None,
                 file_uris: Optional[Sequence[_builtins.str]] = None,
                 jar_file_uris: Optional[Sequence[_builtins.str]] = None,
                 python_file_uris: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str main_python_file_uri: The HCFS URI of the main Python file to use as the driver. Must be a .py file.
        :param Sequence[_builtins.str] archive_uris: HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        :param Sequence[_builtins.str] args: The arguments to pass to the driver.  Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param Sequence[_builtins.str] file_uris: HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        :param Sequence[_builtins.str] jar_file_uris: HCFS URIs of jar files to add to the CLASSPATHs of the Python driver and tasks.
        :param Sequence[_builtins.str] python_file_uris: HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip.
        """
        pulumi.set(__self__, "main_python_file_uri", main_python_file_uri)
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if python_file_uris is not None:
            pulumi.set(__self__, "python_file_uris", python_file_uris)

    @_builtins.property
    @pulumi.getter(name="mainPythonFileUri")
    def main_python_file_uri(self) -> _builtins.str:
        """
        The HCFS URI of the main Python file to use as the driver. Must be a .py file.
        """
        return pulumi.get(self, "main_python_file_uri")

    @_builtins.property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        The arguments to pass to the driver.  Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @_builtins.property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of jar files to add to the CLASSPATHs of the Python driver and tasks.
        """
        return pulumi.get(self, "jar_file_uris")

    @_builtins.property
    @pulumi.getter(name="pythonFileUris")
    def python_file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip.
        """
        return pulumi.get(self, "python_file_uris")


@pulumi.output_type
class GdcSparkApplicationSparkApplicationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveUris":
            suggest = "archive_uris"
        elif key == "fileUris":
            suggest = "file_uris"
        elif key == "jarFileUris":
            suggest = "jar_file_uris"
        elif key == "mainClass":
            suggest = "main_class"
        elif key == "mainJarFileUri":
            suggest = "main_jar_file_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GdcSparkApplicationSparkApplicationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GdcSparkApplicationSparkApplicationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GdcSparkApplicationSparkApplicationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_uris: Optional[Sequence[_builtins.str]] = None,
                 args: Optional[Sequence[_builtins.str]] = None,
                 file_uris: Optional[Sequence[_builtins.str]] = None,
                 jar_file_uris: Optional[Sequence[_builtins.str]] = None,
                 main_class: Optional[_builtins.str] = None,
                 main_jar_file_uri: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] archive_uris: HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
        :param Sequence[_builtins.str] args: The arguments to pass to the driver. Do not include arguments that can be set as application properties, such as `--conf`, since a collision can occur that causes an incorrect application submission.
        :param Sequence[_builtins.str] file_uris: HCFS URIs of files to be placed in the working directory of each executor.
        :param Sequence[_builtins.str] jar_file_uris: HCFS URIs of jar files to add to the classpath of the Spark driver and tasks.
        :param _builtins.str main_class: The name of the driver main class. The jar file that contains the class must be in the classpath or specified in `jar_file_uris`.
        :param _builtins.str main_jar_file_uri: The HCFS URI of the jar file that contains the main class.
        """
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if main_class is not None:
            pulumi.set(__self__, "main_class", main_class)
        if main_jar_file_uri is not None:
            pulumi.set(__self__, "main_jar_file_uri", main_jar_file_uri)

    @_builtins.property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
        """
        return pulumi.get(self, "archive_uris")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        The arguments to pass to the driver. Do not include arguments that can be set as application properties, such as `--conf`, since a collision can occur that causes an incorrect application submission.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of files to be placed in the working directory of each executor.
        """
        return pulumi.get(self, "file_uris")

    @_builtins.property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of jar files to add to the classpath of the Spark driver and tasks.
        """
        return pulumi.get(self, "jar_file_uris")

    @_builtins.property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> Optional[_builtins.str]:
        """
        The name of the driver main class. The jar file that contains the class must be in the classpath or specified in `jar_file_uris`.
        """
        return pulumi.get(self, "main_class")

    @_builtins.property
    @pulumi.getter(name="mainJarFileUri")
    def main_jar_file_uri(self) -> Optional[_builtins.str]:
        """
        The HCFS URI of the jar file that contains the main class.
        """
        return pulumi.get(self, "main_jar_file_uri")


@pulumi.output_type
class GdcSparkApplicationSparkRApplicationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mainRFileUri":
            suggest = "main_r_file_uri"
        elif key == "archiveUris":
            suggest = "archive_uris"
        elif key == "fileUris":
            suggest = "file_uris"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GdcSparkApplicationSparkRApplicationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GdcSparkApplicationSparkRApplicationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GdcSparkApplicationSparkRApplicationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 main_r_file_uri: _builtins.str,
                 archive_uris: Optional[Sequence[_builtins.str]] = None,
                 args: Optional[Sequence[_builtins.str]] = None,
                 file_uris: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str main_r_file_uri: The HCFS URI of the main R file to use as the driver. Must be a .R file.
        :param Sequence[_builtins.str] archive_uris: HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        :param Sequence[_builtins.str] args: The arguments to pass to the driver.  Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param Sequence[_builtins.str] file_uris: HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        """
        pulumi.set(__self__, "main_r_file_uri", main_r_file_uri)
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)

    @_builtins.property
    @pulumi.getter(name="mainRFileUri")
    def main_r_file_uri(self) -> _builtins.str:
        """
        The HCFS URI of the main R file to use as the driver. Must be a .R file.
        """
        return pulumi.get(self, "main_r_file_uri")

    @_builtins.property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        The arguments to pass to the driver.  Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")


@pulumi.output_type
class GdcSparkApplicationSparkSqlApplicationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jarFileUris":
            suggest = "jar_file_uris"
        elif key == "queryFileUri":
            suggest = "query_file_uri"
        elif key == "queryList":
            suggest = "query_list"
        elif key == "scriptVariables":
            suggest = "script_variables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GdcSparkApplicationSparkSqlApplicationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GdcSparkApplicationSparkSqlApplicationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GdcSparkApplicationSparkSqlApplicationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 jar_file_uris: Optional[Sequence[_builtins.str]] = None,
                 query_file_uri: Optional[_builtins.str] = None,
                 query_list: Optional['outputs.GdcSparkApplicationSparkSqlApplicationConfigQueryList'] = None,
                 script_variables: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Sequence[_builtins.str] jar_file_uris: HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param _builtins.str query_file_uri: The HCFS URI of the script that contains SQL queries.
        :param 'GdcSparkApplicationSparkSqlApplicationConfigQueryListArgs' query_list: Represents a list of queries.
               Structure is documented below.
        :param Mapping[str, _builtins.str] script_variables: Mapping of query variable names to values (equivalent to the Spark SQL command: SET `name="value";`).
        """
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if query_file_uri is not None:
            pulumi.set(__self__, "query_file_uri", query_file_uri)
        if query_list is not None:
            pulumi.set(__self__, "query_list", query_list)
        if script_variables is not None:
            pulumi.set(__self__, "script_variables", script_variables)

    @_builtins.property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @_builtins.property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> Optional[_builtins.str]:
        """
        The HCFS URI of the script that contains SQL queries.
        """
        return pulumi.get(self, "query_file_uri")

    @_builtins.property
    @pulumi.getter(name="queryList")
    def query_list(self) -> Optional['outputs.GdcSparkApplicationSparkSqlApplicationConfigQueryList']:
        """
        Represents a list of queries.
        Structure is documented below.
        """
        return pulumi.get(self, "query_list")

    @_builtins.property
    @pulumi.getter(name="scriptVariables")
    def script_variables(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Mapping of query variable names to values (equivalent to the Spark SQL command: SET `name="value";`).
        """
        return pulumi.get(self, "script_variables")


@pulumi.output_type
class GdcSparkApplicationSparkSqlApplicationConfigQueryList(dict):
    def __init__(__self__, *,
                 queries: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] queries: The queries to run.
        """
        pulumi.set(__self__, "queries", queries)

    @_builtins.property
    @pulumi.getter
    def queries(self) -> Sequence[_builtins.str]:
        """
        The queries to run.
        """
        return pulumi.get(self, "queries")


@pulumi.output_type
class JobHadoopConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveUris":
            suggest = "archive_uris"
        elif key == "fileUris":
            suggest = "file_uris"
        elif key == "jarFileUris":
            suggest = "jar_file_uris"
        elif key == "loggingConfig":
            suggest = "logging_config"
        elif key == "mainClass":
            suggest = "main_class"
        elif key == "mainJarFileUri":
            suggest = "main_jar_file_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobHadoopConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobHadoopConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobHadoopConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_uris: Optional[Sequence[_builtins.str]] = None,
                 args: Optional[Sequence[_builtins.str]] = None,
                 file_uris: Optional[Sequence[_builtins.str]] = None,
                 jar_file_uris: Optional[Sequence[_builtins.str]] = None,
                 logging_config: Optional['outputs.JobHadoopConfigLoggingConfig'] = None,
                 main_class: Optional[_builtins.str] = None,
                 main_jar_file_uri: Optional[_builtins.str] = None,
                 properties: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Sequence[_builtins.str] archive_uris: HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
        :param Sequence[_builtins.str] args: The arguments to pass to the driver. Do not include arguments, such as -libjars or -Dfoo=bar, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param Sequence[_builtins.str] file_uris: HCFS URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
        :param Sequence[_builtins.str] jar_file_uris: HCFS URIs of jar files to add to the CLASSPATHs of the Spark driver and tasks.
        :param 'JobHadoopConfigLoggingConfigArgs' logging_config: The runtime logging config of the job
        :param _builtins.str main_class: The name of the driver's main class. The jar file containing the class must be in the default CLASSPATH or specified in `jar_file_uris`. Conflicts with `main_jar_file_uri`
        :param _builtins.str main_jar_file_uri: The HCFS URI of the jar file containing the main class. Examples: 'gs://foo-bucket/analytics-binaries/extract-useful-metrics-mr.jar' 'hdfs:/tmp/test-samples/custom-wordcount.jar' 'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'. Conflicts with `main_class`
        :param Mapping[str, _builtins.str] properties: A mapping of property names to values, used to configure Hadoop. Properties that conflict with values set by the Cloud Dataproc API may be overwritten. Can include properties set in `/etc/hadoop/conf/*-site` and classes in user code..
               
               * `logging_config.driver_log_levels`- (Required) The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if main_class is not None:
            pulumi.set(__self__, "main_class", main_class)
        if main_jar_file_uri is not None:
            pulumi.set(__self__, "main_jar_file_uri", main_jar_file_uri)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @_builtins.property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        The arguments to pass to the driver. Do not include arguments, such as -libjars or -Dfoo=bar, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @_builtins.property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of jar files to add to the CLASSPATHs of the Spark driver and tasks.
        """
        return pulumi.get(self, "jar_file_uris")

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional['outputs.JobHadoopConfigLoggingConfig']:
        """
        The runtime logging config of the job
        """
        return pulumi.get(self, "logging_config")

    @_builtins.property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> Optional[_builtins.str]:
        """
        The name of the driver's main class. The jar file containing the class must be in the default CLASSPATH or specified in `jar_file_uris`. Conflicts with `main_jar_file_uri`
        """
        return pulumi.get(self, "main_class")

    @_builtins.property
    @pulumi.getter(name="mainJarFileUri")
    def main_jar_file_uri(self) -> Optional[_builtins.str]:
        """
        The HCFS URI of the jar file containing the main class. Examples: 'gs://foo-bucket/analytics-binaries/extract-useful-metrics-mr.jar' 'hdfs:/tmp/test-samples/custom-wordcount.jar' 'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'. Conflicts with `main_class`
        """
        return pulumi.get(self, "main_jar_file_uri")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of property names to values, used to configure Hadoop. Properties that conflict with values set by the Cloud Dataproc API may be overwritten. Can include properties set in `/etc/hadoop/conf/*-site` and classes in user code..

        * `logging_config.driver_log_levels`- (Required) The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class JobHadoopConfigLoggingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverLogLevels":
            suggest = "driver_log_levels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobHadoopConfigLoggingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobHadoopConfigLoggingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobHadoopConfigLoggingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver_log_levels: Mapping[str, _builtins.str]):
        """
        :param Mapping[str, _builtins.str] driver_log_levels: Optional. The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'.
        """
        pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @_builtins.property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> Mapping[str, _builtins.str]:
        """
        Optional. The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'.
        """
        return pulumi.get(self, "driver_log_levels")


@pulumi.output_type
class JobHiveConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "continueOnFailure":
            suggest = "continue_on_failure"
        elif key == "jarFileUris":
            suggest = "jar_file_uris"
        elif key == "queryFileUri":
            suggest = "query_file_uri"
        elif key == "queryLists":
            suggest = "query_lists"
        elif key == "scriptVariables":
            suggest = "script_variables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobHiveConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobHiveConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobHiveConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 continue_on_failure: Optional[_builtins.bool] = None,
                 jar_file_uris: Optional[Sequence[_builtins.str]] = None,
                 properties: Optional[Mapping[str, _builtins.str]] = None,
                 query_file_uri: Optional[_builtins.str] = None,
                 query_lists: Optional[Sequence[_builtins.str]] = None,
                 script_variables: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.bool continue_on_failure: Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries. Defaults to false.
        :param Sequence[_builtins.str] jar_file_uris: HCFS URIs of jar files to add to the CLASSPATH of the Hive server and Hadoop MapReduce (MR) tasks. Can contain Hive SerDes and UDFs.
        :param Mapping[str, _builtins.str] properties: A mapping of property names and values, used to configure Hive. Properties that conflict with values set by the Cloud Dataproc API may be overwritten. Can include properties set in `/etc/hadoop/conf/*-site.xml`, `/etc/hive/conf/hive-site.xml`, and classes in user code..
        :param _builtins.str query_file_uri: HCFS URI of file containing Hive script to execute as the job.
               Conflicts with `query_list`
        :param Sequence[_builtins.str] query_lists: The list of Hive queries or statements to execute as part of the job.
               Conflicts with `query_file_uri`
        :param Mapping[str, _builtins.str] script_variables: Mapping of query variable names to values (equivalent to the Hive command: `SET name="value";`).
        """
        if continue_on_failure is not None:
            pulumi.set(__self__, "continue_on_failure", continue_on_failure)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if query_file_uri is not None:
            pulumi.set(__self__, "query_file_uri", query_file_uri)
        if query_lists is not None:
            pulumi.set(__self__, "query_lists", query_lists)
        if script_variables is not None:
            pulumi.set(__self__, "script_variables", script_variables)

    @_builtins.property
    @pulumi.getter(name="continueOnFailure")
    def continue_on_failure(self) -> Optional[_builtins.bool]:
        """
        Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries. Defaults to false.
        """
        return pulumi.get(self, "continue_on_failure")

    @_builtins.property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of jar files to add to the CLASSPATH of the Hive server and Hadoop MapReduce (MR) tasks. Can contain Hive SerDes and UDFs.
        """
        return pulumi.get(self, "jar_file_uris")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of property names and values, used to configure Hive. Properties that conflict with values set by the Cloud Dataproc API may be overwritten. Can include properties set in `/etc/hadoop/conf/*-site.xml`, `/etc/hive/conf/hive-site.xml`, and classes in user code..
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> Optional[_builtins.str]:
        """
        HCFS URI of file containing Hive script to execute as the job.
        Conflicts with `query_list`
        """
        return pulumi.get(self, "query_file_uri")

    @_builtins.property
    @pulumi.getter(name="queryLists")
    def query_lists(self) -> Optional[Sequence[_builtins.str]]:
        """
        The list of Hive queries or statements to execute as part of the job.
        Conflicts with `query_file_uri`
        """
        return pulumi.get(self, "query_lists")

    @_builtins.property
    @pulumi.getter(name="scriptVariables")
    def script_variables(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Mapping of query variable names to values (equivalent to the Hive command: `SET name="value";`).
        """
        return pulumi.get(self, "script_variables")


@pulumi.output_type
class JobIAMBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class JobIAMMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class JobPigConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "continueOnFailure":
            suggest = "continue_on_failure"
        elif key == "jarFileUris":
            suggest = "jar_file_uris"
        elif key == "loggingConfig":
            suggest = "logging_config"
        elif key == "queryFileUri":
            suggest = "query_file_uri"
        elif key == "queryLists":
            suggest = "query_lists"
        elif key == "scriptVariables":
            suggest = "script_variables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobPigConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobPigConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobPigConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 continue_on_failure: Optional[_builtins.bool] = None,
                 jar_file_uris: Optional[Sequence[_builtins.str]] = None,
                 logging_config: Optional['outputs.JobPigConfigLoggingConfig'] = None,
                 properties: Optional[Mapping[str, _builtins.str]] = None,
                 query_file_uri: Optional[_builtins.str] = None,
                 query_lists: Optional[Sequence[_builtins.str]] = None,
                 script_variables: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.bool continue_on_failure: Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries. Defaults to false.
        :param Sequence[_builtins.str] jar_file_uris: HCFS URIs of jar files to add to the CLASSPATH of the Pig Client and Hadoop MapReduce (MR) tasks. Can contain Pig UDFs.
               
               * `logging_config.driver_log_levels`- (Required) The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        :param 'JobPigConfigLoggingConfigArgs' logging_config: The runtime logging config of the job
        :param Mapping[str, _builtins.str] properties: A mapping of property names to values, used to configure Pig. Properties that conflict with values set by the Cloud Dataproc API may be overwritten. Can include properties set in `/etc/hadoop/conf/*-site.xml`, `/etc/pig/conf/pig.properties`, and classes in user code.
        :param _builtins.str query_file_uri: HCFS URI of file containing Hive script to execute as the job.
               Conflicts with `query_list`
        :param Sequence[_builtins.str] query_lists: The list of Hive queries or statements to execute as part of the job.
               Conflicts with `query_file_uri`
        :param Mapping[str, _builtins.str] script_variables: Mapping of query variable names to values (equivalent to the Pig command: `name=[value]`).
        """
        if continue_on_failure is not None:
            pulumi.set(__self__, "continue_on_failure", continue_on_failure)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if query_file_uri is not None:
            pulumi.set(__self__, "query_file_uri", query_file_uri)
        if query_lists is not None:
            pulumi.set(__self__, "query_lists", query_lists)
        if script_variables is not None:
            pulumi.set(__self__, "script_variables", script_variables)

    @_builtins.property
    @pulumi.getter(name="continueOnFailure")
    def continue_on_failure(self) -> Optional[_builtins.bool]:
        """
        Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries. Defaults to false.
        """
        return pulumi.get(self, "continue_on_failure")

    @_builtins.property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of jar files to add to the CLASSPATH of the Pig Client and Hadoop MapReduce (MR) tasks. Can contain Pig UDFs.

        * `logging_config.driver_log_levels`- (Required) The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        return pulumi.get(self, "jar_file_uris")

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional['outputs.JobPigConfigLoggingConfig']:
        """
        The runtime logging config of the job
        """
        return pulumi.get(self, "logging_config")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of property names to values, used to configure Pig. Properties that conflict with values set by the Cloud Dataproc API may be overwritten. Can include properties set in `/etc/hadoop/conf/*-site.xml`, `/etc/pig/conf/pig.properties`, and classes in user code.
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> Optional[_builtins.str]:
        """
        HCFS URI of file containing Hive script to execute as the job.
        Conflicts with `query_list`
        """
        return pulumi.get(self, "query_file_uri")

    @_builtins.property
    @pulumi.getter(name="queryLists")
    def query_lists(self) -> Optional[Sequence[_builtins.str]]:
        """
        The list of Hive queries or statements to execute as part of the job.
        Conflicts with `query_file_uri`
        """
        return pulumi.get(self, "query_lists")

    @_builtins.property
    @pulumi.getter(name="scriptVariables")
    def script_variables(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Mapping of query variable names to values (equivalent to the Pig command: `name=[value]`).
        """
        return pulumi.get(self, "script_variables")


@pulumi.output_type
class JobPigConfigLoggingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverLogLevels":
            suggest = "driver_log_levels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobPigConfigLoggingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobPigConfigLoggingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobPigConfigLoggingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver_log_levels: Mapping[str, _builtins.str]):
        """
        :param Mapping[str, _builtins.str] driver_log_levels: Optional. The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'.
        """
        pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @_builtins.property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> Mapping[str, _builtins.str]:
        """
        Optional. The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'.
        """
        return pulumi.get(self, "driver_log_levels")


@pulumi.output_type
class JobPlacement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterName":
            suggest = "cluster_name"
        elif key == "clusterUuid":
            suggest = "cluster_uuid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobPlacement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobPlacement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobPlacement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_name: _builtins.str,
                 cluster_uuid: Optional[_builtins.str] = None):
        """
        :param _builtins.str cluster_name: The name of the cluster where the job will be submitted
        :param _builtins.str cluster_uuid: Output-only. A cluster UUID generated by the Cloud Dataproc service when the job is submitted
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        if cluster_uuid is not None:
            pulumi.set(__self__, "cluster_uuid", cluster_uuid)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> _builtins.str:
        """
        The name of the cluster where the job will be submitted
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="clusterUuid")
    def cluster_uuid(self) -> Optional[_builtins.str]:
        """
        Output-only. A cluster UUID generated by the Cloud Dataproc service when the job is submitted
        """
        return pulumi.get(self, "cluster_uuid")


@pulumi.output_type
class JobPrestoConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientTags":
            suggest = "client_tags"
        elif key == "continueOnFailure":
            suggest = "continue_on_failure"
        elif key == "loggingConfig":
            suggest = "logging_config"
        elif key == "outputFormat":
            suggest = "output_format"
        elif key == "queryFileUri":
            suggest = "query_file_uri"
        elif key == "queryLists":
            suggest = "query_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobPrestoConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobPrestoConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobPrestoConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_tags: Optional[Sequence[_builtins.str]] = None,
                 continue_on_failure: Optional[_builtins.bool] = None,
                 logging_config: Optional['outputs.JobPrestoConfigLoggingConfig'] = None,
                 output_format: Optional[_builtins.str] = None,
                 properties: Optional[Mapping[str, _builtins.str]] = None,
                 query_file_uri: Optional[_builtins.str] = None,
                 query_lists: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] client_tags: Presto client tags to attach to this query.
        :param _builtins.bool continue_on_failure: Whether to continue executing queries if a query fails. Setting to true can be useful when executing independent parallel queries. Defaults to false.
        :param 'JobPrestoConfigLoggingConfigArgs' logging_config: The runtime logging config of the job
        :param _builtins.str output_format: The format in which query output will be displayed. See the Presto documentation for supported output formats.
               
               * `logging_config.driver_log_levels`- (Required) The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        :param Mapping[str, _builtins.str] properties: A mapping of property names to values. Used to set Presto session properties Equivalent to using the --session flag in the Presto CLI.
        :param _builtins.str query_file_uri: The HCFS URI of the script that contains SQL queries.
               Conflicts with `query_list`
        :param Sequence[_builtins.str] query_lists: The list of SQL queries or statements to execute as part of the job.
               Conflicts with `query_file_uri`
        """
        if client_tags is not None:
            pulumi.set(__self__, "client_tags", client_tags)
        if continue_on_failure is not None:
            pulumi.set(__self__, "continue_on_failure", continue_on_failure)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if output_format is not None:
            pulumi.set(__self__, "output_format", output_format)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if query_file_uri is not None:
            pulumi.set(__self__, "query_file_uri", query_file_uri)
        if query_lists is not None:
            pulumi.set(__self__, "query_lists", query_lists)

    @_builtins.property
    @pulumi.getter(name="clientTags")
    def client_tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        Presto client tags to attach to this query.
        """
        return pulumi.get(self, "client_tags")

    @_builtins.property
    @pulumi.getter(name="continueOnFailure")
    def continue_on_failure(self) -> Optional[_builtins.bool]:
        """
        Whether to continue executing queries if a query fails. Setting to true can be useful when executing independent parallel queries. Defaults to false.
        """
        return pulumi.get(self, "continue_on_failure")

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional['outputs.JobPrestoConfigLoggingConfig']:
        """
        The runtime logging config of the job
        """
        return pulumi.get(self, "logging_config")

    @_builtins.property
    @pulumi.getter(name="outputFormat")
    def output_format(self) -> Optional[_builtins.str]:
        """
        The format in which query output will be displayed. See the Presto documentation for supported output formats.

        * `logging_config.driver_log_levels`- (Required) The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        return pulumi.get(self, "output_format")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of property names to values. Used to set Presto session properties Equivalent to using the --session flag in the Presto CLI.
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> Optional[_builtins.str]:
        """
        The HCFS URI of the script that contains SQL queries.
        Conflicts with `query_list`
        """
        return pulumi.get(self, "query_file_uri")

    @_builtins.property
    @pulumi.getter(name="queryLists")
    def query_lists(self) -> Optional[Sequence[_builtins.str]]:
        """
        The list of SQL queries or statements to execute as part of the job.
        Conflicts with `query_file_uri`
        """
        return pulumi.get(self, "query_lists")


@pulumi.output_type
class JobPrestoConfigLoggingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverLogLevels":
            suggest = "driver_log_levels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobPrestoConfigLoggingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobPrestoConfigLoggingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobPrestoConfigLoggingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver_log_levels: Mapping[str, _builtins.str]):
        """
        :param Mapping[str, _builtins.str] driver_log_levels: Optional. The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'.
        """
        pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @_builtins.property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> Mapping[str, _builtins.str]:
        """
        Optional. The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'.
        """
        return pulumi.get(self, "driver_log_levels")


@pulumi.output_type
class JobPysparkConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mainPythonFileUri":
            suggest = "main_python_file_uri"
        elif key == "archiveUris":
            suggest = "archive_uris"
        elif key == "fileUris":
            suggest = "file_uris"
        elif key == "jarFileUris":
            suggest = "jar_file_uris"
        elif key == "loggingConfig":
            suggest = "logging_config"
        elif key == "pythonFileUris":
            suggest = "python_file_uris"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobPysparkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobPysparkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobPysparkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 main_python_file_uri: _builtins.str,
                 archive_uris: Optional[Sequence[_builtins.str]] = None,
                 args: Optional[Sequence[_builtins.str]] = None,
                 file_uris: Optional[Sequence[_builtins.str]] = None,
                 jar_file_uris: Optional[Sequence[_builtins.str]] = None,
                 logging_config: Optional['outputs.JobPysparkConfigLoggingConfig'] = None,
                 properties: Optional[Mapping[str, _builtins.str]] = None,
                 python_file_uris: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str main_python_file_uri: The HCFS URI of the main Python file to use as the driver. Must be a .py file.
        :param Sequence[_builtins.str] archive_uris: HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
        :param Sequence[_builtins.str] args: The arguments to pass to the driver.
        :param Sequence[_builtins.str] file_uris: HCFS URIs of files to be copied to the working directory of Python drivers and distributed tasks. Useful for naively parallel tasks.
        :param Sequence[_builtins.str] jar_file_uris: HCFS URIs of jar files to add to the CLASSPATHs of the Python driver and tasks.
        :param 'JobPysparkConfigLoggingConfigArgs' logging_config: The runtime logging config of the job
        :param Mapping[str, _builtins.str] properties: A mapping of property names to values, used to configure PySpark. Properties that conflict with values set by the Cloud Dataproc API may be overwritten. Can include properties set in `/etc/spark/conf/spark-defaults.conf` and classes in user code.
               
               * `logging_config.driver_log_levels`- (Required) The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        :param Sequence[_builtins.str] python_file_uris: HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip.
        """
        pulumi.set(__self__, "main_python_file_uri", main_python_file_uri)
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if python_file_uris is not None:
            pulumi.set(__self__, "python_file_uris", python_file_uris)

    @_builtins.property
    @pulumi.getter(name="mainPythonFileUri")
    def main_python_file_uri(self) -> _builtins.str:
        """
        The HCFS URI of the main Python file to use as the driver. Must be a .py file.
        """
        return pulumi.get(self, "main_python_file_uri")

    @_builtins.property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        The arguments to pass to the driver.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of files to be copied to the working directory of Python drivers and distributed tasks. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @_builtins.property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of jar files to add to the CLASSPATHs of the Python driver and tasks.
        """
        return pulumi.get(self, "jar_file_uris")

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional['outputs.JobPysparkConfigLoggingConfig']:
        """
        The runtime logging config of the job
        """
        return pulumi.get(self, "logging_config")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of property names to values, used to configure PySpark. Properties that conflict with values set by the Cloud Dataproc API may be overwritten. Can include properties set in `/etc/spark/conf/spark-defaults.conf` and classes in user code.

        * `logging_config.driver_log_levels`- (Required) The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="pythonFileUris")
    def python_file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip.
        """
        return pulumi.get(self, "python_file_uris")


@pulumi.output_type
class JobPysparkConfigLoggingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverLogLevels":
            suggest = "driver_log_levels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobPysparkConfigLoggingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobPysparkConfigLoggingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobPysparkConfigLoggingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver_log_levels: Mapping[str, _builtins.str]):
        """
        :param Mapping[str, _builtins.str] driver_log_levels: Optional. The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'.
        """
        pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @_builtins.property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> Mapping[str, _builtins.str]:
        """
        Optional. The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'.
        """
        return pulumi.get(self, "driver_log_levels")


@pulumi.output_type
class JobReference(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobId":
            suggest = "job_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str job_id: The job ID, which must be unique within the project. The job ID is generated by the server upon job submission or provided by the user as a means to perform retries without creating duplicate jobs
        """
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[_builtins.str]:
        """
        The job ID, which must be unique within the project. The job ID is generated by the server upon job submission or provided by the user as a means to perform retries without creating duplicate jobs
        """
        return pulumi.get(self, "job_id")


@pulumi.output_type
class JobScheduling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxFailuresPerHour":
            suggest = "max_failures_per_hour"
        elif key == "maxFailuresTotal":
            suggest = "max_failures_total"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobScheduling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobScheduling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobScheduling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_failures_per_hour: _builtins.int,
                 max_failures_total: _builtins.int):
        """
        :param _builtins.int max_failures_per_hour: Maximum number of times per hour a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed.
        :param _builtins.int max_failures_total: Maximum number of times in total a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed.
        """
        pulumi.set(__self__, "max_failures_per_hour", max_failures_per_hour)
        pulumi.set(__self__, "max_failures_total", max_failures_total)

    @_builtins.property
    @pulumi.getter(name="maxFailuresPerHour")
    def max_failures_per_hour(self) -> _builtins.int:
        """
        Maximum number of times per hour a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed.
        """
        return pulumi.get(self, "max_failures_per_hour")

    @_builtins.property
    @pulumi.getter(name="maxFailuresTotal")
    def max_failures_total(self) -> _builtins.int:
        """
        Maximum number of times in total a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed.
        """
        return pulumi.get(self, "max_failures_total")


@pulumi.output_type
class JobSparkConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveUris":
            suggest = "archive_uris"
        elif key == "fileUris":
            suggest = "file_uris"
        elif key == "jarFileUris":
            suggest = "jar_file_uris"
        elif key == "loggingConfig":
            suggest = "logging_config"
        elif key == "mainClass":
            suggest = "main_class"
        elif key == "mainJarFileUri":
            suggest = "main_jar_file_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobSparkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobSparkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobSparkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_uris: Optional[Sequence[_builtins.str]] = None,
                 args: Optional[Sequence[_builtins.str]] = None,
                 file_uris: Optional[Sequence[_builtins.str]] = None,
                 jar_file_uris: Optional[Sequence[_builtins.str]] = None,
                 logging_config: Optional['outputs.JobSparkConfigLoggingConfig'] = None,
                 main_class: Optional[_builtins.str] = None,
                 main_jar_file_uri: Optional[_builtins.str] = None,
                 properties: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Sequence[_builtins.str] archive_uris: HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
        :param Sequence[_builtins.str] args: The arguments to pass to the driver.
        :param Sequence[_builtins.str] file_uris: HCFS URIs of files to be copied to the working directory of Spark drivers and distributed tasks. Useful for naively parallel tasks.
        :param Sequence[_builtins.str] jar_file_uris: HCFS URIs of jar files to add to the CLASSPATHs of the Spark driver and tasks.
        :param 'JobSparkConfigLoggingConfigArgs' logging_config: The runtime logging config of the job
        :param _builtins.str main_class: The class containing the main method of the driver. Must be in a
               provided jar or jar that is already on the classpath. Conflicts with `main_jar_file_uri`
        :param _builtins.str main_jar_file_uri: The HCFS URI of jar file containing
               the driver jar. Conflicts with `main_class`
        :param Mapping[str, _builtins.str] properties: A mapping of property names to values, used to configure Spark. Properties that conflict with values set by the Cloud Dataproc API may be overwritten. Can include properties set in `/etc/spark/conf/spark-defaults.conf` and classes in user code.
               
               * `logging_config.driver_log_levels`- (Required) The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if main_class is not None:
            pulumi.set(__self__, "main_class", main_class)
        if main_jar_file_uri is not None:
            pulumi.set(__self__, "main_jar_file_uri", main_jar_file_uri)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @_builtins.property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        The arguments to pass to the driver.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of files to be copied to the working directory of Spark drivers and distributed tasks. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @_builtins.property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of jar files to add to the CLASSPATHs of the Spark driver and tasks.
        """
        return pulumi.get(self, "jar_file_uris")

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional['outputs.JobSparkConfigLoggingConfig']:
        """
        The runtime logging config of the job
        """
        return pulumi.get(self, "logging_config")

    @_builtins.property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> Optional[_builtins.str]:
        """
        The class containing the main method of the driver. Must be in a
        provided jar or jar that is already on the classpath. Conflicts with `main_jar_file_uri`
        """
        return pulumi.get(self, "main_class")

    @_builtins.property
    @pulumi.getter(name="mainJarFileUri")
    def main_jar_file_uri(self) -> Optional[_builtins.str]:
        """
        The HCFS URI of jar file containing
        the driver jar. Conflicts with `main_class`
        """
        return pulumi.get(self, "main_jar_file_uri")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of property names to values, used to configure Spark. Properties that conflict with values set by the Cloud Dataproc API may be overwritten. Can include properties set in `/etc/spark/conf/spark-defaults.conf` and classes in user code.

        * `logging_config.driver_log_levels`- (Required) The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class JobSparkConfigLoggingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverLogLevels":
            suggest = "driver_log_levels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobSparkConfigLoggingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobSparkConfigLoggingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobSparkConfigLoggingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver_log_levels: Mapping[str, _builtins.str]):
        """
        :param Mapping[str, _builtins.str] driver_log_levels: Optional. The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'.
        """
        pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @_builtins.property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> Mapping[str, _builtins.str]:
        """
        Optional. The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'.
        """
        return pulumi.get(self, "driver_log_levels")


@pulumi.output_type
class JobSparksqlConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jarFileUris":
            suggest = "jar_file_uris"
        elif key == "loggingConfig":
            suggest = "logging_config"
        elif key == "queryFileUri":
            suggest = "query_file_uri"
        elif key == "queryLists":
            suggest = "query_lists"
        elif key == "scriptVariables":
            suggest = "script_variables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobSparksqlConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobSparksqlConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobSparksqlConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 jar_file_uris: Optional[Sequence[_builtins.str]] = None,
                 logging_config: Optional['outputs.JobSparksqlConfigLoggingConfig'] = None,
                 properties: Optional[Mapping[str, _builtins.str]] = None,
                 query_file_uri: Optional[_builtins.str] = None,
                 query_lists: Optional[Sequence[_builtins.str]] = None,
                 script_variables: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Sequence[_builtins.str] jar_file_uris: HCFS URIs of jar files to be added to the Spark CLASSPATH.
               
               * `logging_config.driver_log_levels`- (Required) The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        :param 'JobSparksqlConfigLoggingConfigArgs' logging_config: The runtime logging config of the job
        :param Mapping[str, _builtins.str] properties: A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        :param _builtins.str query_file_uri: The HCFS URI of the script that contains SQL queries.
               Conflicts with `query_list`
        :param Sequence[_builtins.str] query_lists: The list of SQL queries or statements to execute as part of the job.
               Conflicts with `query_file_uri`
        :param Mapping[str, _builtins.str] script_variables: Mapping of query variable names to values (equivalent to the Spark SQL command: `SET name="value";`).
        """
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if query_file_uri is not None:
            pulumi.set(__self__, "query_file_uri", query_file_uri)
        if query_lists is not None:
            pulumi.set(__self__, "query_lists", query_lists)
        if script_variables is not None:
            pulumi.set(__self__, "script_variables", script_variables)

    @_builtins.property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of jar files to be added to the Spark CLASSPATH.

        * `logging_config.driver_log_levels`- (Required) The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        return pulumi.get(self, "jar_file_uris")

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional['outputs.JobSparksqlConfigLoggingConfig']:
        """
        The runtime logging config of the job
        """
        return pulumi.get(self, "logging_config")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> Optional[_builtins.str]:
        """
        The HCFS URI of the script that contains SQL queries.
        Conflicts with `query_list`
        """
        return pulumi.get(self, "query_file_uri")

    @_builtins.property
    @pulumi.getter(name="queryLists")
    def query_lists(self) -> Optional[Sequence[_builtins.str]]:
        """
        The list of SQL queries or statements to execute as part of the job.
        Conflicts with `query_file_uri`
        """
        return pulumi.get(self, "query_lists")

    @_builtins.property
    @pulumi.getter(name="scriptVariables")
    def script_variables(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Mapping of query variable names to values (equivalent to the Spark SQL command: `SET name="value";`).
        """
        return pulumi.get(self, "script_variables")


@pulumi.output_type
class JobSparksqlConfigLoggingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverLogLevels":
            suggest = "driver_log_levels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobSparksqlConfigLoggingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobSparksqlConfigLoggingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobSparksqlConfigLoggingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver_log_levels: Mapping[str, _builtins.str]):
        """
        :param Mapping[str, _builtins.str] driver_log_levels: Optional. The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'.
        """
        pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @_builtins.property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> Mapping[str, _builtins.str]:
        """
        Optional. The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'.
        """
        return pulumi.get(self, "driver_log_levels")


@pulumi.output_type
class JobStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stateStartTime":
            suggest = "state_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 details: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None,
                 state_start_time: Optional[_builtins.str] = None,
                 substate: Optional[_builtins.str] = None):
        """
        :param _builtins.str details: Optional job state details, such as an error description if the state is ERROR.
        :param _builtins.str state: A state message specifying the overall job state.
        :param _builtins.str state_start_time: The time when this state was entered.
        :param _builtins.str substate: Additional state information, which includes status reported by the agent.
        """
        if details is not None:
            pulumi.set(__self__, "details", details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_start_time is not None:
            pulumi.set(__self__, "state_start_time", state_start_time)
        if substate is not None:
            pulumi.set(__self__, "substate", substate)

    @_builtins.property
    @pulumi.getter
    def details(self) -> Optional[_builtins.str]:
        """
        Optional job state details, such as an error description if the state is ERROR.
        """
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        A state message specifying the overall job state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="stateStartTime")
    def state_start_time(self) -> Optional[_builtins.str]:
        """
        The time when this state was entered.
        """
        return pulumi.get(self, "state_start_time")

    @_builtins.property
    @pulumi.getter
    def substate(self) -> Optional[_builtins.str]:
        """
        Additional state information, which includes status reported by the agent.
        """
        return pulumi.get(self, "substate")


@pulumi.output_type
class MetastoreDatabaseIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class MetastoreDatabaseIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class MetastoreFederationBackendMetastore(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metastoreType":
            suggest = "metastore_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetastoreFederationBackendMetastore. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetastoreFederationBackendMetastore.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetastoreFederationBackendMetastore.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metastore_type: _builtins.str,
                 name: _builtins.str,
                 rank: _builtins.str):
        """
        :param _builtins.str metastore_type: The type of the backend metastore.
               Possible values are: `METASTORE_TYPE_UNSPECIFIED`, `DATAPROC_METASTORE`, `BIGQUERY`.
        :param _builtins.str name: The relative resource name of the metastore that is being federated. The formats of the relative resource names for the currently supported metastores are listed below: Dataplex: projects/{projectId}/locations/{location}/lakes/{lake_id} BigQuery: projects/{projectId} Dataproc Metastore: projects/{projectId}/locations/{location}/services/{serviceId}
        :param _builtins.str rank: The identifier for this object. Format specified above.
        """
        pulumi.set(__self__, "metastore_type", metastore_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rank", rank)

    @_builtins.property
    @pulumi.getter(name="metastoreType")
    def metastore_type(self) -> _builtins.str:
        """
        The type of the backend metastore.
        Possible values are: `METASTORE_TYPE_UNSPECIFIED`, `DATAPROC_METASTORE`, `BIGQUERY`.
        """
        return pulumi.get(self, "metastore_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The relative resource name of the metastore that is being federated. The formats of the relative resource names for the currently supported metastores are listed below: Dataplex: projects/{projectId}/locations/{location}/lakes/{lake_id} BigQuery: projects/{projectId} Dataproc Metastore: projects/{projectId}/locations/{location}/services/{serviceId}
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def rank(self) -> _builtins.str:
        """
        The identifier for this object. Format specified above.
        """
        return pulumi.get(self, "rank")


@pulumi.output_type
class MetastoreFederationIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class MetastoreFederationIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class MetastoreServiceEncryptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKey":
            suggest = "kms_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetastoreServiceEncryptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetastoreServiceEncryptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetastoreServiceEncryptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key: _builtins.str):
        """
        :param _builtins.str kms_key: The fully qualified customer provided Cloud KMS key name to use for customer data encryption.
               Use the following format: `projects/([^/]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+)`
        """
        pulumi.set(__self__, "kms_key", kms_key)

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> _builtins.str:
        """
        The fully qualified customer provided Cloud KMS key name to use for customer data encryption.
        Use the following format: `projects/([^/]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+)`
        """
        return pulumi.get(self, "kms_key")


@pulumi.output_type
class MetastoreServiceHiveMetastoreConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auxiliaryVersions":
            suggest = "auxiliary_versions"
        elif key == "configOverrides":
            suggest = "config_overrides"
        elif key == "endpointProtocol":
            suggest = "endpoint_protocol"
        elif key == "kerberosConfig":
            suggest = "kerberos_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetastoreServiceHiveMetastoreConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetastoreServiceHiveMetastoreConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetastoreServiceHiveMetastoreConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 version: _builtins.str,
                 auxiliary_versions: Optional[Sequence['outputs.MetastoreServiceHiveMetastoreConfigAuxiliaryVersion']] = None,
                 config_overrides: Optional[Mapping[str, _builtins.str]] = None,
                 endpoint_protocol: Optional[_builtins.str] = None,
                 kerberos_config: Optional['outputs.MetastoreServiceHiveMetastoreConfigKerberosConfig'] = None):
        """
        :param _builtins.str version: The Hive metastore schema version.
        :param Sequence['MetastoreServiceHiveMetastoreConfigAuxiliaryVersionArgs'] auxiliary_versions: A mapping of Hive metastore version to the auxiliary version configuration.
               When specified, a secondary Hive metastore service is created along with the primary service.
               All auxiliary versions must be less than the service's primary version.
               The key is the auxiliary service name and it must match the regular expression a-z?.
               This means that the first character must be a lowercase letter, and all the following characters must be hyphens, lowercase letters, or digits, except the last character, which cannot be a hyphen.
               Structure is documented below.
        :param Mapping[str, _builtins.str] config_overrides: A mapping of Hive metastore configuration key-value pairs to apply to the Hive metastore (configured in hive-site.xml).
               The mappings override system defaults (some keys cannot be overridden)
        :param _builtins.str endpoint_protocol: The protocol to use for the metastore service endpoint. If unspecified, defaults to `THRIFT`.
               Default value is `THRIFT`.
               Possible values are: `THRIFT`, `GRPC`.
        :param 'MetastoreServiceHiveMetastoreConfigKerberosConfigArgs' kerberos_config: Information used to configure the Hive metastore service as a service principal in a Kerberos realm.
               Structure is documented below.
        """
        pulumi.set(__self__, "version", version)
        if auxiliary_versions is not None:
            pulumi.set(__self__, "auxiliary_versions", auxiliary_versions)
        if config_overrides is not None:
            pulumi.set(__self__, "config_overrides", config_overrides)
        if endpoint_protocol is not None:
            pulumi.set(__self__, "endpoint_protocol", endpoint_protocol)
        if kerberos_config is not None:
            pulumi.set(__self__, "kerberos_config", kerberos_config)

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The Hive metastore schema version.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="auxiliaryVersions")
    def auxiliary_versions(self) -> Optional[Sequence['outputs.MetastoreServiceHiveMetastoreConfigAuxiliaryVersion']]:
        """
        A mapping of Hive metastore version to the auxiliary version configuration.
        When specified, a secondary Hive metastore service is created along with the primary service.
        All auxiliary versions must be less than the service's primary version.
        The key is the auxiliary service name and it must match the regular expression a-z?.
        This means that the first character must be a lowercase letter, and all the following characters must be hyphens, lowercase letters, or digits, except the last character, which cannot be a hyphen.
        Structure is documented below.
        """
        return pulumi.get(self, "auxiliary_versions")

    @_builtins.property
    @pulumi.getter(name="configOverrides")
    def config_overrides(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of Hive metastore configuration key-value pairs to apply to the Hive metastore (configured in hive-site.xml).
        The mappings override system defaults (some keys cannot be overridden)
        """
        return pulumi.get(self, "config_overrides")

    @_builtins.property
    @pulumi.getter(name="endpointProtocol")
    def endpoint_protocol(self) -> Optional[_builtins.str]:
        """
        The protocol to use for the metastore service endpoint. If unspecified, defaults to `THRIFT`.
        Default value is `THRIFT`.
        Possible values are: `THRIFT`, `GRPC`.
        """
        return pulumi.get(self, "endpoint_protocol")

    @_builtins.property
    @pulumi.getter(name="kerberosConfig")
    def kerberos_config(self) -> Optional['outputs.MetastoreServiceHiveMetastoreConfigKerberosConfig']:
        """
        Information used to configure the Hive metastore service as a service principal in a Kerberos realm.
        Structure is documented below.
        """
        return pulumi.get(self, "kerberos_config")


@pulumi.output_type
class MetastoreServiceHiveMetastoreConfigAuxiliaryVersion(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configOverrides":
            suggest = "config_overrides"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetastoreServiceHiveMetastoreConfigAuxiliaryVersion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetastoreServiceHiveMetastoreConfigAuxiliaryVersion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetastoreServiceHiveMetastoreConfigAuxiliaryVersion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: _builtins.str,
                 version: _builtins.str,
                 config_overrides: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str key: The identifier for this object. Format specified above.
        :param _builtins.str version: The Hive metastore version of the auxiliary service. It must be less than the primary Hive metastore service's version.
        :param Mapping[str, _builtins.str] config_overrides: A mapping of Hive metastore configuration key-value pairs to apply to the auxiliary Hive metastore (configured in hive-site.xml) in addition to the primary version's overrides.
               If keys are present in both the auxiliary version's overrides and the primary version's overrides, the value from the auxiliary version's overrides takes precedence.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "version", version)
        if config_overrides is not None:
            pulumi.set(__self__, "config_overrides", config_overrides)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The identifier for this object. Format specified above.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The Hive metastore version of the auxiliary service. It must be less than the primary Hive metastore service's version.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="configOverrides")
    def config_overrides(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of Hive metastore configuration key-value pairs to apply to the auxiliary Hive metastore (configured in hive-site.xml) in addition to the primary version's overrides.
        If keys are present in both the auxiliary version's overrides and the primary version's overrides, the value from the auxiliary version's overrides takes precedence.
        """
        return pulumi.get(self, "config_overrides")


@pulumi.output_type
class MetastoreServiceHiveMetastoreConfigKerberosConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "krb5ConfigGcsUri":
            suggest = "krb5_config_gcs_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetastoreServiceHiveMetastoreConfigKerberosConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetastoreServiceHiveMetastoreConfigKerberosConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetastoreServiceHiveMetastoreConfigKerberosConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 keytab: 'outputs.MetastoreServiceHiveMetastoreConfigKerberosConfigKeytab',
                 krb5_config_gcs_uri: _builtins.str,
                 principal: _builtins.str):
        """
        :param 'MetastoreServiceHiveMetastoreConfigKerberosConfigKeytabArgs' keytab: A Kerberos keytab file that can be used to authenticate a service principal with a Kerberos Key Distribution Center (KDC).
               Structure is documented below.
        :param _builtins.str krb5_config_gcs_uri: A Cloud Storage URI that specifies the path to a krb5.conf file. It is of the form gs://{bucket_name}/path/to/krb5.conf, although the file does not need to be named krb5.conf explicitly.
        :param _builtins.str principal: A Kerberos principal that exists in the both the keytab the KDC to authenticate as. A typical principal is of the form "primary/instance@REALM", but there is no exact format.
        """
        pulumi.set(__self__, "keytab", keytab)
        pulumi.set(__self__, "krb5_config_gcs_uri", krb5_config_gcs_uri)
        pulumi.set(__self__, "principal", principal)

    @_builtins.property
    @pulumi.getter
    def keytab(self) -> 'outputs.MetastoreServiceHiveMetastoreConfigKerberosConfigKeytab':
        """
        A Kerberos keytab file that can be used to authenticate a service principal with a Kerberos Key Distribution Center (KDC).
        Structure is documented below.
        """
        return pulumi.get(self, "keytab")

    @_builtins.property
    @pulumi.getter(name="krb5ConfigGcsUri")
    def krb5_config_gcs_uri(self) -> _builtins.str:
        """
        A Cloud Storage URI that specifies the path to a krb5.conf file. It is of the form gs://{bucket_name}/path/to/krb5.conf, although the file does not need to be named krb5.conf explicitly.
        """
        return pulumi.get(self, "krb5_config_gcs_uri")

    @_builtins.property
    @pulumi.getter
    def principal(self) -> _builtins.str:
        """
        A Kerberos principal that exists in the both the keytab the KDC to authenticate as. A typical principal is of the form "primary/instance@REALM", but there is no exact format.
        """
        return pulumi.get(self, "principal")


@pulumi.output_type
class MetastoreServiceHiveMetastoreConfigKerberosConfigKeytab(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudSecret":
            suggest = "cloud_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetastoreServiceHiveMetastoreConfigKerberosConfigKeytab. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetastoreServiceHiveMetastoreConfigKerberosConfigKeytab.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetastoreServiceHiveMetastoreConfigKerberosConfigKeytab.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_secret: _builtins.str):
        """
        :param _builtins.str cloud_secret: The relative resource name of a Secret Manager secret version, in the following form:
               "projects/{projectNumber}/secrets/{secret_id}/versions/{version_id}".
        """
        pulumi.set(__self__, "cloud_secret", cloud_secret)

    @_builtins.property
    @pulumi.getter(name="cloudSecret")
    def cloud_secret(self) -> _builtins.str:
        """
        The relative resource name of a Secret Manager secret version, in the following form:
        "projects/{projectNumber}/secrets/{secret_id}/versions/{version_id}".
        """
        return pulumi.get(self, "cloud_secret")


@pulumi.output_type
class MetastoreServiceIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class MetastoreServiceIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class MetastoreServiceMaintenanceWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "hourOfDay":
            suggest = "hour_of_day"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetastoreServiceMaintenanceWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetastoreServiceMaintenanceWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetastoreServiceMaintenanceWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: _builtins.str,
                 hour_of_day: _builtins.int):
        """
        :param _builtins.str day_of_week: The day of week, when the window starts.
               Possible values are: `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        :param _builtins.int hour_of_day: The hour of day (0-23) when the window starts.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "hour_of_day", hour_of_day)

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> _builtins.str:
        """
        The day of week, when the window starts.
        Possible values are: `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        return pulumi.get(self, "day_of_week")

    @_builtins.property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> _builtins.int:
        """
        The hour of day (0-23) when the window starts.
        """
        return pulumi.get(self, "hour_of_day")


@pulumi.output_type
class MetastoreServiceMetadataIntegration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataCatalogConfig":
            suggest = "data_catalog_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetastoreServiceMetadataIntegration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetastoreServiceMetadataIntegration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetastoreServiceMetadataIntegration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_catalog_config: 'outputs.MetastoreServiceMetadataIntegrationDataCatalogConfig'):
        """
        :param 'MetastoreServiceMetadataIntegrationDataCatalogConfigArgs' data_catalog_config: The integration config for the Data Catalog service.
               Structure is documented below.
        """
        pulumi.set(__self__, "data_catalog_config", data_catalog_config)

    @_builtins.property
    @pulumi.getter(name="dataCatalogConfig")
    def data_catalog_config(self) -> 'outputs.MetastoreServiceMetadataIntegrationDataCatalogConfig':
        """
        The integration config for the Data Catalog service.
        Structure is documented below.
        """
        return pulumi.get(self, "data_catalog_config")


@pulumi.output_type
class MetastoreServiceMetadataIntegrationDataCatalogConfig(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool):
        """
        :param _builtins.bool enabled: Defines whether the metastore metadata should be synced to Data Catalog. The default value is to disable syncing metastore metadata to Data Catalog.
        """
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Defines whether the metastore metadata should be synced to Data Catalog. The default value is to disable syncing metastore metadata to Data Catalog.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class MetastoreServiceNetworkConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customRoutesEnabled":
            suggest = "custom_routes_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetastoreServiceNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetastoreServiceNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetastoreServiceNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consumers: Sequence['outputs.MetastoreServiceNetworkConfigConsumer'],
                 custom_routes_enabled: Optional[_builtins.bool] = None):
        """
        :param Sequence['MetastoreServiceNetworkConfigConsumerArgs'] consumers: The consumer-side network configuration for the Dataproc Metastore instance.
               Structure is documented below.
        :param _builtins.bool custom_routes_enabled: Enables custom routes to be imported and exported for the Dataproc Metastore service's peered VPC network.
        """
        pulumi.set(__self__, "consumers", consumers)
        if custom_routes_enabled is not None:
            pulumi.set(__self__, "custom_routes_enabled", custom_routes_enabled)

    @_builtins.property
    @pulumi.getter
    def consumers(self) -> Sequence['outputs.MetastoreServiceNetworkConfigConsumer']:
        """
        The consumer-side network configuration for the Dataproc Metastore instance.
        Structure is documented below.
        """
        return pulumi.get(self, "consumers")

    @_builtins.property
    @pulumi.getter(name="customRoutesEnabled")
    def custom_routes_enabled(self) -> Optional[_builtins.bool]:
        """
        Enables custom routes to be imported and exported for the Dataproc Metastore service's peered VPC network.
        """
        return pulumi.get(self, "custom_routes_enabled")


@pulumi.output_type
class MetastoreServiceNetworkConfigConsumer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointUri":
            suggest = "endpoint_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetastoreServiceNetworkConfigConsumer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetastoreServiceNetworkConfigConsumer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetastoreServiceNetworkConfigConsumer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnetwork: _builtins.str,
                 endpoint_uri: Optional[_builtins.str] = None):
        """
        :param _builtins.str subnetwork: The subnetwork of the customer project from which an IP address is reserved and used as the Dataproc Metastore service's endpoint.
               It is accessible to hosts in the subnet and to all hosts in a subnet in the same region and same network.
               There must be at least one IP address available in the subnet's primary range. The subnet is specified in the following form:
               `projects/{projectNumber}/regions/{region_id}/subnetworks/{subnetwork_id}
        :param _builtins.str endpoint_uri: (Output)
               The URI of the endpoint used to access the metastore service.
        """
        pulumi.set(__self__, "subnetwork", subnetwork)
        if endpoint_uri is not None:
            pulumi.set(__self__, "endpoint_uri", endpoint_uri)

    @_builtins.property
    @pulumi.getter
    def subnetwork(self) -> _builtins.str:
        """
        The subnetwork of the customer project from which an IP address is reserved and used as the Dataproc Metastore service's endpoint.
        It is accessible to hosts in the subnet and to all hosts in a subnet in the same region and same network.
        There must be at least one IP address available in the subnet's primary range. The subnet is specified in the following form:
        `projects/{projectNumber}/regions/{region_id}/subnetworks/{subnetwork_id}
        """
        return pulumi.get(self, "subnetwork")

    @_builtins.property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> Optional[_builtins.str]:
        """
        (Output)
        The URI of the endpoint used to access the metastore service.
        """
        return pulumi.get(self, "endpoint_uri")


@pulumi.output_type
class MetastoreServiceScalingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscalingConfig":
            suggest = "autoscaling_config"
        elif key == "instanceSize":
            suggest = "instance_size"
        elif key == "scalingFactor":
            suggest = "scaling_factor"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetastoreServiceScalingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetastoreServiceScalingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetastoreServiceScalingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscaling_config: Optional['outputs.MetastoreServiceScalingConfigAutoscalingConfig'] = None,
                 instance_size: Optional[_builtins.str] = None,
                 scaling_factor: Optional[_builtins.float] = None):
        """
        :param 'MetastoreServiceScalingConfigAutoscalingConfigArgs' autoscaling_config: Represents the autoscaling configuration of a metastore service.
               Structure is documented below.
        :param _builtins.str instance_size: Metastore instance sizes.
               Possible values are: `EXTRA_SMALL`, `SMALL`, `MEDIUM`, `LARGE`, `EXTRA_LARGE`.
        :param _builtins.float scaling_factor: Scaling factor, in increments of 0.1 for values less than 1.0, and increments of 1.0 for values greater than 1.0.
        """
        if autoscaling_config is not None:
            pulumi.set(__self__, "autoscaling_config", autoscaling_config)
        if instance_size is not None:
            pulumi.set(__self__, "instance_size", instance_size)
        if scaling_factor is not None:
            pulumi.set(__self__, "scaling_factor", scaling_factor)

    @_builtins.property
    @pulumi.getter(name="autoscalingConfig")
    def autoscaling_config(self) -> Optional['outputs.MetastoreServiceScalingConfigAutoscalingConfig']:
        """
        Represents the autoscaling configuration of a metastore service.
        Structure is documented below.
        """
        return pulumi.get(self, "autoscaling_config")

    @_builtins.property
    @pulumi.getter(name="instanceSize")
    def instance_size(self) -> Optional[_builtins.str]:
        """
        Metastore instance sizes.
        Possible values are: `EXTRA_SMALL`, `SMALL`, `MEDIUM`, `LARGE`, `EXTRA_LARGE`.
        """
        return pulumi.get(self, "instance_size")

    @_builtins.property
    @pulumi.getter(name="scalingFactor")
    def scaling_factor(self) -> Optional[_builtins.float]:
        """
        Scaling factor, in increments of 0.1 for values less than 1.0, and increments of 1.0 for values greater than 1.0.
        """
        return pulumi.get(self, "scaling_factor")


@pulumi.output_type
class MetastoreServiceScalingConfigAutoscalingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscalingEnabled":
            suggest = "autoscaling_enabled"
        elif key == "autoscalingFactor":
            suggest = "autoscaling_factor"
        elif key == "limitConfig":
            suggest = "limit_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetastoreServiceScalingConfigAutoscalingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetastoreServiceScalingConfigAutoscalingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetastoreServiceScalingConfigAutoscalingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscaling_enabled: Optional[_builtins.bool] = None,
                 autoscaling_factor: Optional[_builtins.float] = None,
                 limit_config: Optional['outputs.MetastoreServiceScalingConfigAutoscalingConfigLimitConfig'] = None):
        """
        :param _builtins.bool autoscaling_enabled: Defines whether autoscaling is enabled. The default value is false.
        :param _builtins.float autoscaling_factor: (Output)
               Output only. The scaling factor of a service with autoscaling enabled.
        :param 'MetastoreServiceScalingConfigAutoscalingConfigLimitConfigArgs' limit_config: Represents the limit configuration of a metastore service.
               Structure is documented below.
        """
        if autoscaling_enabled is not None:
            pulumi.set(__self__, "autoscaling_enabled", autoscaling_enabled)
        if autoscaling_factor is not None:
            pulumi.set(__self__, "autoscaling_factor", autoscaling_factor)
        if limit_config is not None:
            pulumi.set(__self__, "limit_config", limit_config)

    @_builtins.property
    @pulumi.getter(name="autoscalingEnabled")
    def autoscaling_enabled(self) -> Optional[_builtins.bool]:
        """
        Defines whether autoscaling is enabled. The default value is false.
        """
        return pulumi.get(self, "autoscaling_enabled")

    @_builtins.property
    @pulumi.getter(name="autoscalingFactor")
    def autoscaling_factor(self) -> Optional[_builtins.float]:
        """
        (Output)
        Output only. The scaling factor of a service with autoscaling enabled.
        """
        return pulumi.get(self, "autoscaling_factor")

    @_builtins.property
    @pulumi.getter(name="limitConfig")
    def limit_config(self) -> Optional['outputs.MetastoreServiceScalingConfigAutoscalingConfigLimitConfig']:
        """
        Represents the limit configuration of a metastore service.
        Structure is documented below.
        """
        return pulumi.get(self, "limit_config")


@pulumi.output_type
class MetastoreServiceScalingConfigAutoscalingConfigLimitConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxScalingFactor":
            suggest = "max_scaling_factor"
        elif key == "minScalingFactor":
            suggest = "min_scaling_factor"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetastoreServiceScalingConfigAutoscalingConfigLimitConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetastoreServiceScalingConfigAutoscalingConfigLimitConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetastoreServiceScalingConfigAutoscalingConfigLimitConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_scaling_factor: Optional[_builtins.float] = None,
                 min_scaling_factor: Optional[_builtins.float] = None):
        """
        :param _builtins.float max_scaling_factor: The maximum scaling factor that the service will autoscale to. The default value is 6.0.
        :param _builtins.float min_scaling_factor: The minimum scaling factor that the service will autoscale to. The default value is 0.1.
        """
        if max_scaling_factor is not None:
            pulumi.set(__self__, "max_scaling_factor", max_scaling_factor)
        if min_scaling_factor is not None:
            pulumi.set(__self__, "min_scaling_factor", min_scaling_factor)

    @_builtins.property
    @pulumi.getter(name="maxScalingFactor")
    def max_scaling_factor(self) -> Optional[_builtins.float]:
        """
        The maximum scaling factor that the service will autoscale to. The default value is 6.0.
        """
        return pulumi.get(self, "max_scaling_factor")

    @_builtins.property
    @pulumi.getter(name="minScalingFactor")
    def min_scaling_factor(self) -> Optional[_builtins.float]:
        """
        The minimum scaling factor that the service will autoscale to. The default value is 0.1.
        """
        return pulumi.get(self, "min_scaling_factor")


@pulumi.output_type
class MetastoreServiceScheduledBackup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupLocation":
            suggest = "backup_location"
        elif key == "cronSchedule":
            suggest = "cron_schedule"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetastoreServiceScheduledBackup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetastoreServiceScheduledBackup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetastoreServiceScheduledBackup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_location: _builtins.str,
                 cron_schedule: Optional[_builtins.str] = None,
                 enabled: Optional[_builtins.bool] = None,
                 time_zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str backup_location: A Cloud Storage URI of a folder, in the format gs://<bucket_name>/<path_inside_bucket>. A sub-folder <backup_folder> containing backup files will be stored below it.
        :param _builtins.str cron_schedule: The scheduled interval in Cron format, see https://en.wikipedia.org/wiki/Cron The default is empty: scheduled backup is not enabled. Must be specified to enable scheduled backups.
        :param _builtins.bool enabled: Defines whether the scheduled backup is enabled. The default value is false.
        :param _builtins.str time_zone: Specifies the time zone to be used when interpreting cronSchedule. Must be a time zone name from the time zone database (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones), e.g. America/Los_Angeles or Africa/Abidjan. If left unspecified, the default is UTC.
        """
        pulumi.set(__self__, "backup_location", backup_location)
        if cron_schedule is not None:
            pulumi.set(__self__, "cron_schedule", cron_schedule)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @_builtins.property
    @pulumi.getter(name="backupLocation")
    def backup_location(self) -> _builtins.str:
        """
        A Cloud Storage URI of a folder, in the format gs://<bucket_name>/<path_inside_bucket>. A sub-folder <backup_folder> containing backup files will be stored below it.
        """
        return pulumi.get(self, "backup_location")

    @_builtins.property
    @pulumi.getter(name="cronSchedule")
    def cron_schedule(self) -> Optional[_builtins.str]:
        """
        The scheduled interval in Cron format, see https://en.wikipedia.org/wiki/Cron The default is empty: scheduled backup is not enabled. Must be specified to enable scheduled backups.
        """
        return pulumi.get(self, "cron_schedule")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Defines whether the scheduled backup is enabled. The default value is false.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[_builtins.str]:
        """
        Specifies the time zone to be used when interpreting cronSchedule. Must be a time zone name from the time zone database (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones), e.g. America/Los_Angeles or Africa/Abidjan. If left unspecified, the default is UTC.
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class MetastoreServiceTelemetryConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logFormat":
            suggest = "log_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetastoreServiceTelemetryConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetastoreServiceTelemetryConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetastoreServiceTelemetryConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_format: Optional[_builtins.str] = None):
        """
        :param _builtins.str log_format: The output format of the Dataproc Metastore service's logs.
               Default value is `JSON`.
               Possible values are: `LEGACY`, `JSON`.
        """
        if log_format is not None:
            pulumi.set(__self__, "log_format", log_format)

    @_builtins.property
    @pulumi.getter(name="logFormat")
    def log_format(self) -> Optional[_builtins.str]:
        """
        The output format of the Dataproc Metastore service's logs.
        Default value is `JSON`.
        Possible values are: `LEGACY`, `JSON`.
        """
        return pulumi.get(self, "log_format")


@pulumi.output_type
class MetastoreTableIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class MetastoreTableIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class SessionTemplateEnvironmentConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionConfig":
            suggest = "execution_config"
        elif key == "peripheralsConfig":
            suggest = "peripherals_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SessionTemplateEnvironmentConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SessionTemplateEnvironmentConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SessionTemplateEnvironmentConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_config: Optional['outputs.SessionTemplateEnvironmentConfigExecutionConfig'] = None,
                 peripherals_config: Optional['outputs.SessionTemplateEnvironmentConfigPeripheralsConfig'] = None):
        """
        :param 'SessionTemplateEnvironmentConfigExecutionConfigArgs' execution_config: Execution configuration for a workload.
               Structure is documented below.
        :param 'SessionTemplateEnvironmentConfigPeripheralsConfigArgs' peripherals_config: Peripherals configuration that workload has access to.
               Structure is documented below.
        """
        if execution_config is not None:
            pulumi.set(__self__, "execution_config", execution_config)
        if peripherals_config is not None:
            pulumi.set(__self__, "peripherals_config", peripherals_config)

    @_builtins.property
    @pulumi.getter(name="executionConfig")
    def execution_config(self) -> Optional['outputs.SessionTemplateEnvironmentConfigExecutionConfig']:
        """
        Execution configuration for a workload.
        Structure is documented below.
        """
        return pulumi.get(self, "execution_config")

    @_builtins.property
    @pulumi.getter(name="peripheralsConfig")
    def peripherals_config(self) -> Optional['outputs.SessionTemplateEnvironmentConfigPeripheralsConfig']:
        """
        Peripherals configuration that workload has access to.
        Structure is documented below.
        """
        return pulumi.get(self, "peripherals_config")


@pulumi.output_type
class SessionTemplateEnvironmentConfigExecutionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationConfig":
            suggest = "authentication_config"
        elif key == "idleTtl":
            suggest = "idle_ttl"
        elif key == "kmsKey":
            suggest = "kms_key"
        elif key == "networkTags":
            suggest = "network_tags"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "stagingBucket":
            suggest = "staging_bucket"
        elif key == "subnetworkUri":
            suggest = "subnetwork_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SessionTemplateEnvironmentConfigExecutionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SessionTemplateEnvironmentConfigExecutionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SessionTemplateEnvironmentConfigExecutionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_config: Optional['outputs.SessionTemplateEnvironmentConfigExecutionConfigAuthenticationConfig'] = None,
                 idle_ttl: Optional[_builtins.str] = None,
                 kms_key: Optional[_builtins.str] = None,
                 network_tags: Optional[Sequence[_builtins.str]] = None,
                 service_account: Optional[_builtins.str] = None,
                 staging_bucket: Optional[_builtins.str] = None,
                 subnetwork_uri: Optional[_builtins.str] = None,
                 ttl: Optional[_builtins.str] = None):
        """
        :param 'SessionTemplateEnvironmentConfigExecutionConfigAuthenticationConfigArgs' authentication_config: Authentication configuration for a workload is used to set the default identity for the workload execution.
               Structure is documented below.
        :param _builtins.str idle_ttl: The duration to keep the session alive while it's idling.
               Exceeding this threshold causes the session to terminate. Minimum value is 10 minutes; maximum value is 14 day.
               Defaults to 1 hour if not set. If both ttl and idleTtl are specified for an interactive session, the conditions
               are treated as OR conditions: the workload will be terminated when it has been idle for idleTtl or when ttl has
               been exceeded, whichever occurs first.
        :param _builtins.str kms_key: The Cloud KMS key to use for encryption.
        :param Sequence[_builtins.str] network_tags: Tags used for network traffic control.
        :param _builtins.str service_account: Service account that used to execute workload.
        :param _builtins.str staging_bucket: A Cloud Storage bucket used to stage workload dependencies, config files, and store
               workload output and other ephemeral data, such as Spark history files. If you do not specify a staging bucket,
               Cloud Dataproc will determine a Cloud Storage location according to the region where your workload is running,
               and then create and manage project-level, per-location staging and temporary buckets.
               This field requires a Cloud Storage bucket name, not a gs://... URI to a Cloud Storage bucket.
        :param _builtins.str subnetwork_uri: Subnetwork configuration for workload execution.
        :param _builtins.str ttl: The duration after which the workload will be terminated.
               When the workload exceeds this duration, it will be unconditionally terminated without waiting for ongoing
               work to finish. If ttl is not specified for a session workload, the workload will be allowed to run until it
               exits naturally (or run forever without exiting). If ttl is not specified for an interactive session,
               it defaults to 24 hours. If ttl is not specified for a batch that uses 2.1+ runtime version, it defaults to 4 hours.
               Minimum value is 10 minutes; maximum value is 14 days. If both ttl and idleTtl are specified (for an interactive session),
               the conditions are treated as OR conditions: the workload will be terminated when it has been idle for idleTtl or
               when ttl has been exceeded, whichever occurs first.
        """
        if authentication_config is not None:
            pulumi.set(__self__, "authentication_config", authentication_config)
        if idle_ttl is not None:
            pulumi.set(__self__, "idle_ttl", idle_ttl)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if network_tags is not None:
            pulumi.set(__self__, "network_tags", network_tags)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if staging_bucket is not None:
            pulumi.set(__self__, "staging_bucket", staging_bucket)
        if subnetwork_uri is not None:
            pulumi.set(__self__, "subnetwork_uri", subnetwork_uri)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter(name="authenticationConfig")
    def authentication_config(self) -> Optional['outputs.SessionTemplateEnvironmentConfigExecutionConfigAuthenticationConfig']:
        """
        Authentication configuration for a workload is used to set the default identity for the workload execution.
        Structure is documented below.
        """
        return pulumi.get(self, "authentication_config")

    @_builtins.property
    @pulumi.getter(name="idleTtl")
    def idle_ttl(self) -> Optional[_builtins.str]:
        """
        The duration to keep the session alive while it's idling.
        Exceeding this threshold causes the session to terminate. Minimum value is 10 minutes; maximum value is 14 day.
        Defaults to 1 hour if not set. If both ttl and idleTtl are specified for an interactive session, the conditions
        are treated as OR conditions: the workload will be terminated when it has been idle for idleTtl or when ttl has
        been exceeded, whichever occurs first.
        """
        return pulumi.get(self, "idle_ttl")

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[_builtins.str]:
        """
        The Cloud KMS key to use for encryption.
        """
        return pulumi.get(self, "kms_key")

    @_builtins.property
    @pulumi.getter(name="networkTags")
    def network_tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        Tags used for network traffic control.
        """
        return pulumi.get(self, "network_tags")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[_builtins.str]:
        """
        Service account that used to execute workload.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter(name="stagingBucket")
    def staging_bucket(self) -> Optional[_builtins.str]:
        """
        A Cloud Storage bucket used to stage workload dependencies, config files, and store
        workload output and other ephemeral data, such as Spark history files. If you do not specify a staging bucket,
        Cloud Dataproc will determine a Cloud Storage location according to the region where your workload is running,
        and then create and manage project-level, per-location staging and temporary buckets.
        This field requires a Cloud Storage bucket name, not a gs://... URI to a Cloud Storage bucket.
        """
        return pulumi.get(self, "staging_bucket")

    @_builtins.property
    @pulumi.getter(name="subnetworkUri")
    def subnetwork_uri(self) -> Optional[_builtins.str]:
        """
        Subnetwork configuration for workload execution.
        """
        return pulumi.get(self, "subnetwork_uri")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[_builtins.str]:
        """
        The duration after which the workload will be terminated.
        When the workload exceeds this duration, it will be unconditionally terminated without waiting for ongoing
        work to finish. If ttl is not specified for a session workload, the workload will be allowed to run until it
        exits naturally (or run forever without exiting). If ttl is not specified for an interactive session,
        it defaults to 24 hours. If ttl is not specified for a batch that uses 2.1+ runtime version, it defaults to 4 hours.
        Minimum value is 10 minutes; maximum value is 14 days. If both ttl and idleTtl are specified (for an interactive session),
        the conditions are treated as OR conditions: the workload will be terminated when it has been idle for idleTtl or
        when ttl has been exceeded, whichever occurs first.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class SessionTemplateEnvironmentConfigExecutionConfigAuthenticationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userWorkloadAuthenticationType":
            suggest = "user_workload_authentication_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SessionTemplateEnvironmentConfigExecutionConfigAuthenticationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SessionTemplateEnvironmentConfigExecutionConfigAuthenticationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SessionTemplateEnvironmentConfigExecutionConfigAuthenticationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_workload_authentication_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str user_workload_authentication_type: Authentication type for the user workload running in containers.
               Possible values are: `SERVICE_ACCOUNT`, `END_USER_CREDENTIALS`.
        """
        if user_workload_authentication_type is not None:
            pulumi.set(__self__, "user_workload_authentication_type", user_workload_authentication_type)

    @_builtins.property
    @pulumi.getter(name="userWorkloadAuthenticationType")
    def user_workload_authentication_type(self) -> Optional[_builtins.str]:
        """
        Authentication type for the user workload running in containers.
        Possible values are: `SERVICE_ACCOUNT`, `END_USER_CREDENTIALS`.
        """
        return pulumi.get(self, "user_workload_authentication_type")


@pulumi.output_type
class SessionTemplateEnvironmentConfigPeripheralsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metastoreService":
            suggest = "metastore_service"
        elif key == "sparkHistoryServerConfig":
            suggest = "spark_history_server_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SessionTemplateEnvironmentConfigPeripheralsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SessionTemplateEnvironmentConfigPeripheralsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SessionTemplateEnvironmentConfigPeripheralsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metastore_service: Optional[_builtins.str] = None,
                 spark_history_server_config: Optional['outputs.SessionTemplateEnvironmentConfigPeripheralsConfigSparkHistoryServerConfig'] = None):
        """
        :param _builtins.str metastore_service: Resource name of an existing Dataproc Metastore service.
        :param 'SessionTemplateEnvironmentConfigPeripheralsConfigSparkHistoryServerConfigArgs' spark_history_server_config: The Spark History Server configuration for the workload.
               Structure is documented below.
        """
        if metastore_service is not None:
            pulumi.set(__self__, "metastore_service", metastore_service)
        if spark_history_server_config is not None:
            pulumi.set(__self__, "spark_history_server_config", spark_history_server_config)

    @_builtins.property
    @pulumi.getter(name="metastoreService")
    def metastore_service(self) -> Optional[_builtins.str]:
        """
        Resource name of an existing Dataproc Metastore service.
        """
        return pulumi.get(self, "metastore_service")

    @_builtins.property
    @pulumi.getter(name="sparkHistoryServerConfig")
    def spark_history_server_config(self) -> Optional['outputs.SessionTemplateEnvironmentConfigPeripheralsConfigSparkHistoryServerConfig']:
        """
        The Spark History Server configuration for the workload.
        Structure is documented below.
        """
        return pulumi.get(self, "spark_history_server_config")


@pulumi.output_type
class SessionTemplateEnvironmentConfigPeripheralsConfigSparkHistoryServerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataprocCluster":
            suggest = "dataproc_cluster"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SessionTemplateEnvironmentConfigPeripheralsConfigSparkHistoryServerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SessionTemplateEnvironmentConfigPeripheralsConfigSparkHistoryServerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SessionTemplateEnvironmentConfigPeripheralsConfigSparkHistoryServerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataproc_cluster: Optional[_builtins.str] = None):
        """
        :param _builtins.str dataproc_cluster: Resource name of an existing Dataproc Cluster to act as a Spark History Server for the workload.
        """
        if dataproc_cluster is not None:
            pulumi.set(__self__, "dataproc_cluster", dataproc_cluster)

    @_builtins.property
    @pulumi.getter(name="dataprocCluster")
    def dataproc_cluster(self) -> Optional[_builtins.str]:
        """
        Resource name of an existing Dataproc Cluster to act as a Spark History Server for the workload.
        """
        return pulumi.get(self, "dataproc_cluster")


@pulumi.output_type
class SessionTemplateJupyterSession(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SessionTemplateJupyterSession. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SessionTemplateJupyterSession.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SessionTemplateJupyterSession.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[_builtins.str] = None,
                 kernel: Optional[_builtins.str] = None):
        """
        :param _builtins.str display_name: Display name, shown in the Jupyter kernelspec card.
        :param _builtins.str kernel: Kernel to be used with Jupyter interactive session.
               Possible values are: `PYTHON`, `SCALA`.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if kernel is not None:
            pulumi.set(__self__, "kernel", kernel)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        Display name, shown in the Jupyter kernelspec card.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def kernel(self) -> Optional[_builtins.str]:
        """
        Kernel to be used with Jupyter interactive session.
        Possible values are: `PYTHON`, `SCALA`.
        """
        return pulumi.get(self, "kernel")


@pulumi.output_type
class SessionTemplateRuntimeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerImage":
            suggest = "container_image"
        elif key == "effectiveProperties":
            suggest = "effective_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SessionTemplateRuntimeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SessionTemplateRuntimeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SessionTemplateRuntimeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_image: Optional[_builtins.str] = None,
                 effective_properties: Optional[Mapping[str, _builtins.str]] = None,
                 properties: Optional[Mapping[str, _builtins.str]] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str container_image: Optional custom container image for the job runtime environment. If not specified, a default container image will be used.
        :param Mapping[str, _builtins.str] effective_properties: (Output)
               A mapping of property names to values, which are used to configure workload execution.
        :param Mapping[str, _builtins.str] properties: A mapping of property names to values, which are used to configure workload execution.
        :param _builtins.str version: Version of the session runtime.
        """
        if container_image is not None:
            pulumi.set(__self__, "container_image", container_image)
        if effective_properties is not None:
            pulumi.set(__self__, "effective_properties", effective_properties)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="containerImage")
    def container_image(self) -> Optional[_builtins.str]:
        """
        Optional custom container image for the job runtime environment. If not specified, a default container image will be used.
        """
        return pulumi.get(self, "container_image")

    @_builtins.property
    @pulumi.getter(name="effectiveProperties")
    def effective_properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        (Output)
        A mapping of property names to values, which are used to configure workload execution.
        """
        return pulumi.get(self, "effective_properties")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of property names to values, which are used to configure workload execution.
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        Version of the session runtime.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class SessionTemplateSparkConnectSession(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class WorkflowTemplateEncryptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKey":
            suggest = "kms_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplateEncryptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplateEncryptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplateEncryptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key: Optional[_builtins.str] = None):
        """
        :param _builtins.str kms_key: Optional. The Cloud KMS key name to use for encryption.
        """
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[_builtins.str]:
        """
        Optional. The Cloud KMS key name to use for encryption.
        """
        return pulumi.get(self, "kms_key")


@pulumi.output_type
class WorkflowTemplateJob(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stepId":
            suggest = "step_id"
        elif key == "hadoopJob":
            suggest = "hadoop_job"
        elif key == "hiveJob":
            suggest = "hive_job"
        elif key == "pigJob":
            suggest = "pig_job"
        elif key == "prerequisiteStepIds":
            suggest = "prerequisite_step_ids"
        elif key == "prestoJob":
            suggest = "presto_job"
        elif key == "pysparkJob":
            suggest = "pyspark_job"
        elif key == "sparkJob":
            suggest = "spark_job"
        elif key == "sparkRJob":
            suggest = "spark_r_job"
        elif key == "sparkSqlJob":
            suggest = "spark_sql_job"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplateJob. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplateJob.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplateJob.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 step_id: _builtins.str,
                 hadoop_job: Optional['outputs.WorkflowTemplateJobHadoopJob'] = None,
                 hive_job: Optional['outputs.WorkflowTemplateJobHiveJob'] = None,
                 labels: Optional[Mapping[str, _builtins.str]] = None,
                 pig_job: Optional['outputs.WorkflowTemplateJobPigJob'] = None,
                 prerequisite_step_ids: Optional[Sequence[_builtins.str]] = None,
                 presto_job: Optional['outputs.WorkflowTemplateJobPrestoJob'] = None,
                 pyspark_job: Optional['outputs.WorkflowTemplateJobPysparkJob'] = None,
                 scheduling: Optional['outputs.WorkflowTemplateJobScheduling'] = None,
                 spark_job: Optional['outputs.WorkflowTemplateJobSparkJob'] = None,
                 spark_r_job: Optional['outputs.WorkflowTemplateJobSparkRJob'] = None,
                 spark_sql_job: Optional['outputs.WorkflowTemplateJobSparkSqlJob'] = None):
        """
        :param _builtins.str step_id: Required. The step id. The id must be unique among all jobs within the template. The step id is used as prefix for job id, as job `goog-dataproc-workflow-step-id` label, and in field from other steps. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between 3 and 50 characters.
        :param 'WorkflowTemplateJobHadoopJobArgs' hadoop_job: Job is a Hadoop job.
        :param 'WorkflowTemplateJobHiveJobArgs' hive_job: Job is a Hive job.
        :param Mapping[str, _builtins.str] labels: The labels to associate with this job. Label keys must be between 1 and 63 characters long, and must conform to the following regular expression: {0,63} No more than 32 labels can be associated with a given job.
        :param 'WorkflowTemplateJobPigJobArgs' pig_job: Job is a Pig job.
        :param Sequence[_builtins.str] prerequisite_step_ids: The optional list of prerequisite job step_ids. If not specified, the job will start at the beginning of workflow.
        :param 'WorkflowTemplateJobPrestoJobArgs' presto_job: Job is a Presto job.
        :param 'WorkflowTemplateJobPysparkJobArgs' pyspark_job: Job is a PySpark job.
        :param 'WorkflowTemplateJobSchedulingArgs' scheduling: Job scheduling configuration.
        :param 'WorkflowTemplateJobSparkJobArgs' spark_job: Job is a Spark job.
        :param 'WorkflowTemplateJobSparkRJobArgs' spark_r_job: Job is a SparkR job.
        :param 'WorkflowTemplateJobSparkSqlJobArgs' spark_sql_job: Job is a SparkSql job.
        """
        pulumi.set(__self__, "step_id", step_id)
        if hadoop_job is not None:
            pulumi.set(__self__, "hadoop_job", hadoop_job)
        if hive_job is not None:
            pulumi.set(__self__, "hive_job", hive_job)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if pig_job is not None:
            pulumi.set(__self__, "pig_job", pig_job)
        if prerequisite_step_ids is not None:
            pulumi.set(__self__, "prerequisite_step_ids", prerequisite_step_ids)
        if presto_job is not None:
            pulumi.set(__self__, "presto_job", presto_job)
        if pyspark_job is not None:
            pulumi.set(__self__, "pyspark_job", pyspark_job)
        if scheduling is not None:
            pulumi.set(__self__, "scheduling", scheduling)
        if spark_job is not None:
            pulumi.set(__self__, "spark_job", spark_job)
        if spark_r_job is not None:
            pulumi.set(__self__, "spark_r_job", spark_r_job)
        if spark_sql_job is not None:
            pulumi.set(__self__, "spark_sql_job", spark_sql_job)

    @_builtins.property
    @pulumi.getter(name="stepId")
    def step_id(self) -> _builtins.str:
        """
        Required. The step id. The id must be unique among all jobs within the template. The step id is used as prefix for job id, as job `goog-dataproc-workflow-step-id` label, and in field from other steps. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between 3 and 50 characters.
        """
        return pulumi.get(self, "step_id")

    @_builtins.property
    @pulumi.getter(name="hadoopJob")
    def hadoop_job(self) -> Optional['outputs.WorkflowTemplateJobHadoopJob']:
        """
        Job is a Hadoop job.
        """
        return pulumi.get(self, "hadoop_job")

    @_builtins.property
    @pulumi.getter(name="hiveJob")
    def hive_job(self) -> Optional['outputs.WorkflowTemplateJobHiveJob']:
        """
        Job is a Hive job.
        """
        return pulumi.get(self, "hive_job")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The labels to associate with this job. Label keys must be between 1 and 63 characters long, and must conform to the following regular expression: {0,63} No more than 32 labels can be associated with a given job.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="pigJob")
    def pig_job(self) -> Optional['outputs.WorkflowTemplateJobPigJob']:
        """
        Job is a Pig job.
        """
        return pulumi.get(self, "pig_job")

    @_builtins.property
    @pulumi.getter(name="prerequisiteStepIds")
    def prerequisite_step_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        The optional list of prerequisite job step_ids. If not specified, the job will start at the beginning of workflow.
        """
        return pulumi.get(self, "prerequisite_step_ids")

    @_builtins.property
    @pulumi.getter(name="prestoJob")
    def presto_job(self) -> Optional['outputs.WorkflowTemplateJobPrestoJob']:
        """
        Job is a Presto job.
        """
        return pulumi.get(self, "presto_job")

    @_builtins.property
    @pulumi.getter(name="pysparkJob")
    def pyspark_job(self) -> Optional['outputs.WorkflowTemplateJobPysparkJob']:
        """
        Job is a PySpark job.
        """
        return pulumi.get(self, "pyspark_job")

    @_builtins.property
    @pulumi.getter
    def scheduling(self) -> Optional['outputs.WorkflowTemplateJobScheduling']:
        """
        Job scheduling configuration.
        """
        return pulumi.get(self, "scheduling")

    @_builtins.property
    @pulumi.getter(name="sparkJob")
    def spark_job(self) -> Optional['outputs.WorkflowTemplateJobSparkJob']:
        """
        Job is a Spark job.
        """
        return pulumi.get(self, "spark_job")

    @_builtins.property
    @pulumi.getter(name="sparkRJob")
    def spark_r_job(self) -> Optional['outputs.WorkflowTemplateJobSparkRJob']:
        """
        Job is a SparkR job.
        """
        return pulumi.get(self, "spark_r_job")

    @_builtins.property
    @pulumi.getter(name="sparkSqlJob")
    def spark_sql_job(self) -> Optional['outputs.WorkflowTemplateJobSparkSqlJob']:
        """
        Job is a SparkSql job.
        """
        return pulumi.get(self, "spark_sql_job")


@pulumi.output_type
class WorkflowTemplateJobHadoopJob(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveUris":
            suggest = "archive_uris"
        elif key == "fileUris":
            suggest = "file_uris"
        elif key == "jarFileUris":
            suggest = "jar_file_uris"
        elif key == "loggingConfig":
            suggest = "logging_config"
        elif key == "mainClass":
            suggest = "main_class"
        elif key == "mainJarFileUri":
            suggest = "main_jar_file_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplateJobHadoopJob. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplateJobHadoopJob.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplateJobHadoopJob.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_uris: Optional[Sequence[_builtins.str]] = None,
                 args: Optional[Sequence[_builtins.str]] = None,
                 file_uris: Optional[Sequence[_builtins.str]] = None,
                 jar_file_uris: Optional[Sequence[_builtins.str]] = None,
                 logging_config: Optional['outputs.WorkflowTemplateJobHadoopJobLoggingConfig'] = None,
                 main_class: Optional[_builtins.str] = None,
                 main_jar_file_uri: Optional[_builtins.str] = None,
                 properties: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Sequence[_builtins.str] archive_uris: HCFS URIs of archives to be extracted in the working directory of Hadoop drivers and tasks. Supported file types: .jar, .tar, .tar.gz, .tgz, or .zip.
        :param Sequence[_builtins.str] args: The arguments to pass to the driver. Do not include arguments, such as `-libjars` or `-Dfoo=bar`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param Sequence[_builtins.str] file_uris: HCFS (Hadoop Compatible Filesystem) URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
        :param Sequence[_builtins.str] jar_file_uris: Jar file URIs to add to the CLASSPATHs of the Hadoop driver and tasks.
        :param 'WorkflowTemplateJobHadoopJobLoggingConfigArgs' logging_config: The runtime log config for job execution.
        :param _builtins.str main_class: The name of the driver's main class. The jar file containing the class must be in the default CLASSPATH or specified in `jar_file_uris`.
        :param _builtins.str main_jar_file_uri: The HCFS URI of the jar file containing the main class. Examples: 'gs://foo-bucket/analytics-binaries/extract-useful-metrics-mr.jar' 'hdfs:/tmp/test-samples/custom-wordcount.jar' 'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'
        :param Mapping[str, _builtins.str] properties: A mapping of property names to values, used to configure Hadoop. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site and classes in user code.
        """
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if main_class is not None:
            pulumi.set(__self__, "main_class", main_class)
        if main_jar_file_uri is not None:
            pulumi.set(__self__, "main_jar_file_uri", main_jar_file_uri)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @_builtins.property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of archives to be extracted in the working directory of Hadoop drivers and tasks. Supported file types: .jar, .tar, .tar.gz, .tgz, or .zip.
        """
        return pulumi.get(self, "archive_uris")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        The arguments to pass to the driver. Do not include arguments, such as `-libjars` or `-Dfoo=bar`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS (Hadoop Compatible Filesystem) URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @_builtins.property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        Jar file URIs to add to the CLASSPATHs of the Hadoop driver and tasks.
        """
        return pulumi.get(self, "jar_file_uris")

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional['outputs.WorkflowTemplateJobHadoopJobLoggingConfig']:
        """
        The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @_builtins.property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> Optional[_builtins.str]:
        """
        The name of the driver's main class. The jar file containing the class must be in the default CLASSPATH or specified in `jar_file_uris`.
        """
        return pulumi.get(self, "main_class")

    @_builtins.property
    @pulumi.getter(name="mainJarFileUri")
    def main_jar_file_uri(self) -> Optional[_builtins.str]:
        """
        The HCFS URI of the jar file containing the main class. Examples: 'gs://foo-bucket/analytics-binaries/extract-useful-metrics-mr.jar' 'hdfs:/tmp/test-samples/custom-wordcount.jar' 'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'
        """
        return pulumi.get(self, "main_jar_file_uri")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of property names to values, used to configure Hadoop. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site and classes in user code.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class WorkflowTemplateJobHadoopJobLoggingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverLogLevels":
            suggest = "driver_log_levels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplateJobHadoopJobLoggingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplateJobHadoopJobLoggingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplateJobHadoopJobLoggingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver_log_levels: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Mapping[str, _builtins.str] driver_log_levels: The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        if driver_log_levels is not None:
            pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @_builtins.property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        return pulumi.get(self, "driver_log_levels")


@pulumi.output_type
class WorkflowTemplateJobHiveJob(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "continueOnFailure":
            suggest = "continue_on_failure"
        elif key == "jarFileUris":
            suggest = "jar_file_uris"
        elif key == "queryFileUri":
            suggest = "query_file_uri"
        elif key == "queryList":
            suggest = "query_list"
        elif key == "scriptVariables":
            suggest = "script_variables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplateJobHiveJob. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplateJobHiveJob.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplateJobHiveJob.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 continue_on_failure: Optional[_builtins.bool] = None,
                 jar_file_uris: Optional[Sequence[_builtins.str]] = None,
                 properties: Optional[Mapping[str, _builtins.str]] = None,
                 query_file_uri: Optional[_builtins.str] = None,
                 query_list: Optional['outputs.WorkflowTemplateJobHiveJobQueryList'] = None,
                 script_variables: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.bool continue_on_failure: Whether to continue executing queries if a query fails. The default value is `false`. Setting to `true` can be useful when executing independent parallel queries.
        :param Sequence[_builtins.str] jar_file_uris: HCFS URIs of jar files to add to the CLASSPATH of the Hive server and Hadoop MapReduce (MR) tasks. Can contain Hive SerDes and UDFs.
        :param Mapping[str, _builtins.str] properties: A mapping of property names and values, used to configure Hive. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/hive/conf/hive-site.xml, and classes in user code.
        :param _builtins.str query_file_uri: The HCFS URI of the script that contains Hive queries.
        :param 'WorkflowTemplateJobHiveJobQueryListArgs' query_list: A list of queries.
        :param Mapping[str, _builtins.str] script_variables: Mapping of query variable names to values (equivalent to the Hive command: `SET name="value";`).
        """
        if continue_on_failure is not None:
            pulumi.set(__self__, "continue_on_failure", continue_on_failure)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if query_file_uri is not None:
            pulumi.set(__self__, "query_file_uri", query_file_uri)
        if query_list is not None:
            pulumi.set(__self__, "query_list", query_list)
        if script_variables is not None:
            pulumi.set(__self__, "script_variables", script_variables)

    @_builtins.property
    @pulumi.getter(name="continueOnFailure")
    def continue_on_failure(self) -> Optional[_builtins.bool]:
        """
        Whether to continue executing queries if a query fails. The default value is `false`. Setting to `true` can be useful when executing independent parallel queries.
        """
        return pulumi.get(self, "continue_on_failure")

    @_builtins.property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of jar files to add to the CLASSPATH of the Hive server and Hadoop MapReduce (MR) tasks. Can contain Hive SerDes and UDFs.
        """
        return pulumi.get(self, "jar_file_uris")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of property names and values, used to configure Hive. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/hive/conf/hive-site.xml, and classes in user code.
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> Optional[_builtins.str]:
        """
        The HCFS URI of the script that contains Hive queries.
        """
        return pulumi.get(self, "query_file_uri")

    @_builtins.property
    @pulumi.getter(name="queryList")
    def query_list(self) -> Optional['outputs.WorkflowTemplateJobHiveJobQueryList']:
        """
        A list of queries.
        """
        return pulumi.get(self, "query_list")

    @_builtins.property
    @pulumi.getter(name="scriptVariables")
    def script_variables(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Mapping of query variable names to values (equivalent to the Hive command: `SET name="value";`).
        """
        return pulumi.get(self, "script_variables")


@pulumi.output_type
class WorkflowTemplateJobHiveJobQueryList(dict):
    def __init__(__self__, *,
                 queries: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] queries: Required. The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": } }
        """
        pulumi.set(__self__, "queries", queries)

    @_builtins.property
    @pulumi.getter
    def queries(self) -> Sequence[_builtins.str]:
        """
        Required. The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": } }
        """
        return pulumi.get(self, "queries")


@pulumi.output_type
class WorkflowTemplateJobPigJob(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "continueOnFailure":
            suggest = "continue_on_failure"
        elif key == "jarFileUris":
            suggest = "jar_file_uris"
        elif key == "loggingConfig":
            suggest = "logging_config"
        elif key == "queryFileUri":
            suggest = "query_file_uri"
        elif key == "queryList":
            suggest = "query_list"
        elif key == "scriptVariables":
            suggest = "script_variables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplateJobPigJob. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplateJobPigJob.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplateJobPigJob.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 continue_on_failure: Optional[_builtins.bool] = None,
                 jar_file_uris: Optional[Sequence[_builtins.str]] = None,
                 logging_config: Optional['outputs.WorkflowTemplateJobPigJobLoggingConfig'] = None,
                 properties: Optional[Mapping[str, _builtins.str]] = None,
                 query_file_uri: Optional[_builtins.str] = None,
                 query_list: Optional['outputs.WorkflowTemplateJobPigJobQueryList'] = None,
                 script_variables: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.bool continue_on_failure: Whether to continue executing queries if a query fails. The default value is `false`. Setting to `true` can be useful when executing independent parallel queries.
        :param Sequence[_builtins.str] jar_file_uris: HCFS URIs of jar files to add to the CLASSPATH of the Pig Client and Hadoop MapReduce (MR) tasks. Can contain Pig UDFs.
        :param 'WorkflowTemplateJobPigJobLoggingConfigArgs' logging_config: The runtime log config for job execution.
        :param Mapping[str, _builtins.str] properties: A mapping of property names to values, used to configure Pig. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/pig/conf/pig.properties, and classes in user code.
        :param _builtins.str query_file_uri: The HCFS URI of the script that contains the Pig queries.
        :param 'WorkflowTemplateJobPigJobQueryListArgs' query_list: A list of queries.
        :param Mapping[str, _builtins.str] script_variables: Mapping of query variable names to values (equivalent to the Pig command: `name=`).
        """
        if continue_on_failure is not None:
            pulumi.set(__self__, "continue_on_failure", continue_on_failure)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if query_file_uri is not None:
            pulumi.set(__self__, "query_file_uri", query_file_uri)
        if query_list is not None:
            pulumi.set(__self__, "query_list", query_list)
        if script_variables is not None:
            pulumi.set(__self__, "script_variables", script_variables)

    @_builtins.property
    @pulumi.getter(name="continueOnFailure")
    def continue_on_failure(self) -> Optional[_builtins.bool]:
        """
        Whether to continue executing queries if a query fails. The default value is `false`. Setting to `true` can be useful when executing independent parallel queries.
        """
        return pulumi.get(self, "continue_on_failure")

    @_builtins.property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of jar files to add to the CLASSPATH of the Pig Client and Hadoop MapReduce (MR) tasks. Can contain Pig UDFs.
        """
        return pulumi.get(self, "jar_file_uris")

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional['outputs.WorkflowTemplateJobPigJobLoggingConfig']:
        """
        The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of property names to values, used to configure Pig. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/pig/conf/pig.properties, and classes in user code.
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> Optional[_builtins.str]:
        """
        The HCFS URI of the script that contains the Pig queries.
        """
        return pulumi.get(self, "query_file_uri")

    @_builtins.property
    @pulumi.getter(name="queryList")
    def query_list(self) -> Optional['outputs.WorkflowTemplateJobPigJobQueryList']:
        """
        A list of queries.
        """
        return pulumi.get(self, "query_list")

    @_builtins.property
    @pulumi.getter(name="scriptVariables")
    def script_variables(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Mapping of query variable names to values (equivalent to the Pig command: `name=`).
        """
        return pulumi.get(self, "script_variables")


@pulumi.output_type
class WorkflowTemplateJobPigJobLoggingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverLogLevels":
            suggest = "driver_log_levels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplateJobPigJobLoggingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplateJobPigJobLoggingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplateJobPigJobLoggingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver_log_levels: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Mapping[str, _builtins.str] driver_log_levels: The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        if driver_log_levels is not None:
            pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @_builtins.property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        return pulumi.get(self, "driver_log_levels")


@pulumi.output_type
class WorkflowTemplateJobPigJobQueryList(dict):
    def __init__(__self__, *,
                 queries: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] queries: Required. The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": } }
        """
        pulumi.set(__self__, "queries", queries)

    @_builtins.property
    @pulumi.getter
    def queries(self) -> Sequence[_builtins.str]:
        """
        Required. The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": } }
        """
        return pulumi.get(self, "queries")


@pulumi.output_type
class WorkflowTemplateJobPrestoJob(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientTags":
            suggest = "client_tags"
        elif key == "continueOnFailure":
            suggest = "continue_on_failure"
        elif key == "loggingConfig":
            suggest = "logging_config"
        elif key == "outputFormat":
            suggest = "output_format"
        elif key == "queryFileUri":
            suggest = "query_file_uri"
        elif key == "queryList":
            suggest = "query_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplateJobPrestoJob. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplateJobPrestoJob.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplateJobPrestoJob.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_tags: Optional[Sequence[_builtins.str]] = None,
                 continue_on_failure: Optional[_builtins.bool] = None,
                 logging_config: Optional['outputs.WorkflowTemplateJobPrestoJobLoggingConfig'] = None,
                 output_format: Optional[_builtins.str] = None,
                 properties: Optional[Mapping[str, _builtins.str]] = None,
                 query_file_uri: Optional[_builtins.str] = None,
                 query_list: Optional['outputs.WorkflowTemplateJobPrestoJobQueryList'] = None):
        """
        :param Sequence[_builtins.str] client_tags: Presto client tags to attach to this query
        :param _builtins.bool continue_on_failure: Whether to continue executing queries if a query fails. The default value is `false`. Setting to `true` can be useful when executing independent parallel queries.
        :param 'WorkflowTemplateJobPrestoJobLoggingConfigArgs' logging_config: The runtime log config for job execution.
        :param _builtins.str output_format: The format in which query output will be displayed. See the Presto documentation for supported output formats
        :param Mapping[str, _builtins.str] properties: A mapping of property names to values. Used to set Presto (https://prestodb.io/docs/current/sql/set-session.html) Equivalent to using the --session flag in the Presto CLI
        :param _builtins.str query_file_uri: The HCFS URI of the script that contains SQL queries.
        :param 'WorkflowTemplateJobPrestoJobQueryListArgs' query_list: A list of queries.
        """
        if client_tags is not None:
            pulumi.set(__self__, "client_tags", client_tags)
        if continue_on_failure is not None:
            pulumi.set(__self__, "continue_on_failure", continue_on_failure)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if output_format is not None:
            pulumi.set(__self__, "output_format", output_format)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if query_file_uri is not None:
            pulumi.set(__self__, "query_file_uri", query_file_uri)
        if query_list is not None:
            pulumi.set(__self__, "query_list", query_list)

    @_builtins.property
    @pulumi.getter(name="clientTags")
    def client_tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        Presto client tags to attach to this query
        """
        return pulumi.get(self, "client_tags")

    @_builtins.property
    @pulumi.getter(name="continueOnFailure")
    def continue_on_failure(self) -> Optional[_builtins.bool]:
        """
        Whether to continue executing queries if a query fails. The default value is `false`. Setting to `true` can be useful when executing independent parallel queries.
        """
        return pulumi.get(self, "continue_on_failure")

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional['outputs.WorkflowTemplateJobPrestoJobLoggingConfig']:
        """
        The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @_builtins.property
    @pulumi.getter(name="outputFormat")
    def output_format(self) -> Optional[_builtins.str]:
        """
        The format in which query output will be displayed. See the Presto documentation for supported output formats
        """
        return pulumi.get(self, "output_format")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of property names to values. Used to set Presto (https://prestodb.io/docs/current/sql/set-session.html) Equivalent to using the --session flag in the Presto CLI
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> Optional[_builtins.str]:
        """
        The HCFS URI of the script that contains SQL queries.
        """
        return pulumi.get(self, "query_file_uri")

    @_builtins.property
    @pulumi.getter(name="queryList")
    def query_list(self) -> Optional['outputs.WorkflowTemplateJobPrestoJobQueryList']:
        """
        A list of queries.
        """
        return pulumi.get(self, "query_list")


@pulumi.output_type
class WorkflowTemplateJobPrestoJobLoggingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverLogLevels":
            suggest = "driver_log_levels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplateJobPrestoJobLoggingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplateJobPrestoJobLoggingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplateJobPrestoJobLoggingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver_log_levels: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Mapping[str, _builtins.str] driver_log_levels: The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        if driver_log_levels is not None:
            pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @_builtins.property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        return pulumi.get(self, "driver_log_levels")


@pulumi.output_type
class WorkflowTemplateJobPrestoJobQueryList(dict):
    def __init__(__self__, *,
                 queries: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] queries: Required. The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": } }
        """
        pulumi.set(__self__, "queries", queries)

    @_builtins.property
    @pulumi.getter
    def queries(self) -> Sequence[_builtins.str]:
        """
        Required. The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": } }
        """
        return pulumi.get(self, "queries")


@pulumi.output_type
class WorkflowTemplateJobPysparkJob(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mainPythonFileUri":
            suggest = "main_python_file_uri"
        elif key == "archiveUris":
            suggest = "archive_uris"
        elif key == "fileUris":
            suggest = "file_uris"
        elif key == "jarFileUris":
            suggest = "jar_file_uris"
        elif key == "loggingConfig":
            suggest = "logging_config"
        elif key == "pythonFileUris":
            suggest = "python_file_uris"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplateJobPysparkJob. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplateJobPysparkJob.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplateJobPysparkJob.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 main_python_file_uri: _builtins.str,
                 archive_uris: Optional[Sequence[_builtins.str]] = None,
                 args: Optional[Sequence[_builtins.str]] = None,
                 file_uris: Optional[Sequence[_builtins.str]] = None,
                 jar_file_uris: Optional[Sequence[_builtins.str]] = None,
                 logging_config: Optional['outputs.WorkflowTemplateJobPysparkJobLoggingConfig'] = None,
                 properties: Optional[Mapping[str, _builtins.str]] = None,
                 python_file_uris: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str main_python_file_uri: Required. The HCFS URI of the main Python file to use as the driver. Must be a .py file.
        :param Sequence[_builtins.str] archive_uris: HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        :param Sequence[_builtins.str] args: The arguments to pass to the driver. Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param Sequence[_builtins.str] file_uris: HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        :param Sequence[_builtins.str] jar_file_uris: HCFS URIs of jar files to add to the CLASSPATHs of the Python driver and tasks.
        :param 'WorkflowTemplateJobPysparkJobLoggingConfigArgs' logging_config: The runtime log config for job execution.
        :param Mapping[str, _builtins.str] properties: A mapping of property names to values, used to configure PySpark. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
        :param Sequence[_builtins.str] python_file_uris: HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip.
        """
        pulumi.set(__self__, "main_python_file_uri", main_python_file_uri)
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if python_file_uris is not None:
            pulumi.set(__self__, "python_file_uris", python_file_uris)

    @_builtins.property
    @pulumi.getter(name="mainPythonFileUri")
    def main_python_file_uri(self) -> _builtins.str:
        """
        Required. The HCFS URI of the main Python file to use as the driver. Must be a .py file.
        """
        return pulumi.get(self, "main_python_file_uri")

    @_builtins.property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        The arguments to pass to the driver. Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @_builtins.property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of jar files to add to the CLASSPATHs of the Python driver and tasks.
        """
        return pulumi.get(self, "jar_file_uris")

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional['outputs.WorkflowTemplateJobPysparkJobLoggingConfig']:
        """
        The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of property names to values, used to configure PySpark. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="pythonFileUris")
    def python_file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip.
        """
        return pulumi.get(self, "python_file_uris")


@pulumi.output_type
class WorkflowTemplateJobPysparkJobLoggingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverLogLevels":
            suggest = "driver_log_levels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplateJobPysparkJobLoggingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplateJobPysparkJobLoggingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplateJobPysparkJobLoggingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver_log_levels: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Mapping[str, _builtins.str] driver_log_levels: The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        if driver_log_levels is not None:
            pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @_builtins.property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        return pulumi.get(self, "driver_log_levels")


@pulumi.output_type
class WorkflowTemplateJobScheduling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxFailuresPerHour":
            suggest = "max_failures_per_hour"
        elif key == "maxFailuresTotal":
            suggest = "max_failures_total"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplateJobScheduling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplateJobScheduling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplateJobScheduling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_failures_per_hour: Optional[_builtins.int] = None,
                 max_failures_total: Optional[_builtins.int] = None):
        """
        :param _builtins.int max_failures_per_hour: Maximum number of times per hour a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed. A job may be reported as thrashing if driver exits with non-zero code 4 times within 10 minute window. Maximum value is 10.
        :param _builtins.int max_failures_total: Maximum number of times in total a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed. Maximum value is 240
        """
        if max_failures_per_hour is not None:
            pulumi.set(__self__, "max_failures_per_hour", max_failures_per_hour)
        if max_failures_total is not None:
            pulumi.set(__self__, "max_failures_total", max_failures_total)

    @_builtins.property
    @pulumi.getter(name="maxFailuresPerHour")
    def max_failures_per_hour(self) -> Optional[_builtins.int]:
        """
        Maximum number of times per hour a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed. A job may be reported as thrashing if driver exits with non-zero code 4 times within 10 minute window. Maximum value is 10.
        """
        return pulumi.get(self, "max_failures_per_hour")

    @_builtins.property
    @pulumi.getter(name="maxFailuresTotal")
    def max_failures_total(self) -> Optional[_builtins.int]:
        """
        Maximum number of times in total a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed. Maximum value is 240
        """
        return pulumi.get(self, "max_failures_total")


@pulumi.output_type
class WorkflowTemplateJobSparkJob(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveUris":
            suggest = "archive_uris"
        elif key == "fileUris":
            suggest = "file_uris"
        elif key == "jarFileUris":
            suggest = "jar_file_uris"
        elif key == "loggingConfig":
            suggest = "logging_config"
        elif key == "mainClass":
            suggest = "main_class"
        elif key == "mainJarFileUri":
            suggest = "main_jar_file_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplateJobSparkJob. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplateJobSparkJob.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplateJobSparkJob.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_uris: Optional[Sequence[_builtins.str]] = None,
                 args: Optional[Sequence[_builtins.str]] = None,
                 file_uris: Optional[Sequence[_builtins.str]] = None,
                 jar_file_uris: Optional[Sequence[_builtins.str]] = None,
                 logging_config: Optional['outputs.WorkflowTemplateJobSparkJobLoggingConfig'] = None,
                 main_class: Optional[_builtins.str] = None,
                 main_jar_file_uri: Optional[_builtins.str] = None,
                 properties: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Sequence[_builtins.str] archive_uris: HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        :param Sequence[_builtins.str] args: The arguments to pass to the driver. Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param Sequence[_builtins.str] file_uris: HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        :param Sequence[_builtins.str] jar_file_uris: HCFS URIs of jar files to add to the CLASSPATHs of the Spark driver and tasks.
        :param 'WorkflowTemplateJobSparkJobLoggingConfigArgs' logging_config: The runtime log config for job execution.
        :param _builtins.str main_class: The name of the driver's main class. The jar file that contains the class must be in the default CLASSPATH or specified in `jar_file_uris`.
        :param _builtins.str main_jar_file_uri: The HCFS URI of the jar file that contains the main class.
        :param Mapping[str, _builtins.str] properties: A mapping of property names to values, used to configure Spark. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
        """
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if main_class is not None:
            pulumi.set(__self__, "main_class", main_class)
        if main_jar_file_uri is not None:
            pulumi.set(__self__, "main_jar_file_uri", main_jar_file_uri)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @_builtins.property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        The arguments to pass to the driver. Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @_builtins.property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of jar files to add to the CLASSPATHs of the Spark driver and tasks.
        """
        return pulumi.get(self, "jar_file_uris")

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional['outputs.WorkflowTemplateJobSparkJobLoggingConfig']:
        """
        The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @_builtins.property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> Optional[_builtins.str]:
        """
        The name of the driver's main class. The jar file that contains the class must be in the default CLASSPATH or specified in `jar_file_uris`.
        """
        return pulumi.get(self, "main_class")

    @_builtins.property
    @pulumi.getter(name="mainJarFileUri")
    def main_jar_file_uri(self) -> Optional[_builtins.str]:
        """
        The HCFS URI of the jar file that contains the main class.
        """
        return pulumi.get(self, "main_jar_file_uri")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of property names to values, used to configure Spark. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class WorkflowTemplateJobSparkJobLoggingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverLogLevels":
            suggest = "driver_log_levels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplateJobSparkJobLoggingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplateJobSparkJobLoggingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplateJobSparkJobLoggingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver_log_levels: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Mapping[str, _builtins.str] driver_log_levels: The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        if driver_log_levels is not None:
            pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @_builtins.property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        return pulumi.get(self, "driver_log_levels")


@pulumi.output_type
class WorkflowTemplateJobSparkRJob(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mainRFileUri":
            suggest = "main_r_file_uri"
        elif key == "archiveUris":
            suggest = "archive_uris"
        elif key == "fileUris":
            suggest = "file_uris"
        elif key == "loggingConfig":
            suggest = "logging_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplateJobSparkRJob. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplateJobSparkRJob.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplateJobSparkRJob.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 main_r_file_uri: _builtins.str,
                 archive_uris: Optional[Sequence[_builtins.str]] = None,
                 args: Optional[Sequence[_builtins.str]] = None,
                 file_uris: Optional[Sequence[_builtins.str]] = None,
                 logging_config: Optional['outputs.WorkflowTemplateJobSparkRJobLoggingConfig'] = None,
                 properties: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str main_r_file_uri: Required. The HCFS URI of the main R file to use as the driver. Must be a .R file.
        :param Sequence[_builtins.str] archive_uris: HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        :param Sequence[_builtins.str] args: The arguments to pass to the driver. Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param Sequence[_builtins.str] file_uris: HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        :param 'WorkflowTemplateJobSparkRJobLoggingConfigArgs' logging_config: The runtime log config for job execution.
        :param Mapping[str, _builtins.str] properties: A mapping of property names to values, used to configure SparkR. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
        """
        pulumi.set(__self__, "main_r_file_uri", main_r_file_uri)
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @_builtins.property
    @pulumi.getter(name="mainRFileUri")
    def main_r_file_uri(self) -> _builtins.str:
        """
        Required. The HCFS URI of the main R file to use as the driver. Must be a .R file.
        """
        return pulumi.get(self, "main_r_file_uri")

    @_builtins.property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        The arguments to pass to the driver. Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional['outputs.WorkflowTemplateJobSparkRJobLoggingConfig']:
        """
        The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of property names to values, used to configure SparkR. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class WorkflowTemplateJobSparkRJobLoggingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverLogLevels":
            suggest = "driver_log_levels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplateJobSparkRJobLoggingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplateJobSparkRJobLoggingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplateJobSparkRJobLoggingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver_log_levels: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Mapping[str, _builtins.str] driver_log_levels: The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        if driver_log_levels is not None:
            pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @_builtins.property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        return pulumi.get(self, "driver_log_levels")


@pulumi.output_type
class WorkflowTemplateJobSparkSqlJob(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jarFileUris":
            suggest = "jar_file_uris"
        elif key == "loggingConfig":
            suggest = "logging_config"
        elif key == "queryFileUri":
            suggest = "query_file_uri"
        elif key == "queryList":
            suggest = "query_list"
        elif key == "scriptVariables":
            suggest = "script_variables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplateJobSparkSqlJob. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplateJobSparkSqlJob.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplateJobSparkSqlJob.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 jar_file_uris: Optional[Sequence[_builtins.str]] = None,
                 logging_config: Optional['outputs.WorkflowTemplateJobSparkSqlJobLoggingConfig'] = None,
                 properties: Optional[Mapping[str, _builtins.str]] = None,
                 query_file_uri: Optional[_builtins.str] = None,
                 query_list: Optional['outputs.WorkflowTemplateJobSparkSqlJobQueryList'] = None,
                 script_variables: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Sequence[_builtins.str] jar_file_uris: HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param 'WorkflowTemplateJobSparkSqlJobLoggingConfigArgs' logging_config: The runtime log config for job execution.
        :param Mapping[str, _builtins.str] properties: A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Dataproc API may be overwritten.
        :param _builtins.str query_file_uri: The HCFS URI of the script that contains SQL queries.
        :param 'WorkflowTemplateJobSparkSqlJobQueryListArgs' query_list: A list of queries.
        :param Mapping[str, _builtins.str] script_variables: Mapping of query variable names to values (equivalent to the Spark SQL command: SET `name="value";`).
        """
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if query_file_uri is not None:
            pulumi.set(__self__, "query_file_uri", query_file_uri)
        if query_list is not None:
            pulumi.set(__self__, "query_list", query_list)
        if script_variables is not None:
            pulumi.set(__self__, "script_variables", script_variables)

    @_builtins.property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional['outputs.WorkflowTemplateJobSparkSqlJobLoggingConfig']:
        """
        The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Dataproc API may be overwritten.
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> Optional[_builtins.str]:
        """
        The HCFS URI of the script that contains SQL queries.
        """
        return pulumi.get(self, "query_file_uri")

    @_builtins.property
    @pulumi.getter(name="queryList")
    def query_list(self) -> Optional['outputs.WorkflowTemplateJobSparkSqlJobQueryList']:
        """
        A list of queries.
        """
        return pulumi.get(self, "query_list")

    @_builtins.property
    @pulumi.getter(name="scriptVariables")
    def script_variables(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Mapping of query variable names to values (equivalent to the Spark SQL command: SET `name="value";`).
        """
        return pulumi.get(self, "script_variables")


@pulumi.output_type
class WorkflowTemplateJobSparkSqlJobLoggingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverLogLevels":
            suggest = "driver_log_levels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplateJobSparkSqlJobLoggingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplateJobSparkSqlJobLoggingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplateJobSparkSqlJobLoggingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver_log_levels: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Mapping[str, _builtins.str] driver_log_levels: The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        if driver_log_levels is not None:
            pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @_builtins.property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        return pulumi.get(self, "driver_log_levels")


@pulumi.output_type
class WorkflowTemplateJobSparkSqlJobQueryList(dict):
    def __init__(__self__, *,
                 queries: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] queries: Required. The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": } }
        """
        pulumi.set(__self__, "queries", queries)

    @_builtins.property
    @pulumi.getter
    def queries(self) -> Sequence[_builtins.str]:
        """
        Required. The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": } }
        """
        return pulumi.get(self, "queries")


@pulumi.output_type
class WorkflowTemplateParameter(dict):
    def __init__(__self__, *,
                 fields: Sequence[_builtins.str],
                 name: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 validation: Optional['outputs.WorkflowTemplateParameterValidation'] = None):
        """
        :param Sequence[_builtins.str] fields: Required. Paths to all fields that the parameter replaces. A field is allowed to appear in at most one parameter's list of field paths. A field path is similar in syntax to a .sparkJob.args
        :param _builtins.str name: Required. Parameter name. The parameter name is used as the key, and paired with the parameter value, which are passed to the template when the template is instantiated. The name must contain only capital letters (A-Z), numbers (0-9), and underscores (_), and must not start with a number. The maximum length is 40 characters.
        :param _builtins.str description: Brief description of the parameter. Must not exceed 1024 characters.
        :param 'WorkflowTemplateParameterValidationArgs' validation: Validation rules to be applied to this parameter's value.
        """
        pulumi.set(__self__, "fields", fields)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if validation is not None:
            pulumi.set(__self__, "validation", validation)

    @_builtins.property
    @pulumi.getter
    def fields(self) -> Sequence[_builtins.str]:
        """
        Required. Paths to all fields that the parameter replaces. A field is allowed to appear in at most one parameter's list of field paths. A field path is similar in syntax to a .sparkJob.args
        """
        return pulumi.get(self, "fields")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Required. Parameter name. The parameter name is used as the key, and paired with the parameter value, which are passed to the template when the template is instantiated. The name must contain only capital letters (A-Z), numbers (0-9), and underscores (_), and must not start with a number. The maximum length is 40 characters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Brief description of the parameter. Must not exceed 1024 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def validation(self) -> Optional['outputs.WorkflowTemplateParameterValidation']:
        """
        Validation rules to be applied to this parameter's value.
        """
        return pulumi.get(self, "validation")


@pulumi.output_type
class WorkflowTemplateParameterValidation(dict):
    def __init__(__self__, *,
                 regex: Optional['outputs.WorkflowTemplateParameterValidationRegex'] = None,
                 values: Optional['outputs.WorkflowTemplateParameterValidationValues'] = None):
        """
        :param 'WorkflowTemplateParameterValidationRegexArgs' regex: Validation based on regular expressions.
        :param 'WorkflowTemplateParameterValidationValuesArgs' values: Validation based on a list of allowed values.
        """
        if regex is not None:
            pulumi.set(__self__, "regex", regex)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional['outputs.WorkflowTemplateParameterValidationRegex']:
        """
        Validation based on regular expressions.
        """
        return pulumi.get(self, "regex")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional['outputs.WorkflowTemplateParameterValidationValues']:
        """
        Validation based on a list of allowed values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class WorkflowTemplateParameterValidationRegex(dict):
    def __init__(__self__, *,
                 regexes: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] regexes: Required. RE2 regular expressions used to validate the parameter's value. The value must match the regex in its entirety (substring matches are not sufficient).
        """
        pulumi.set(__self__, "regexes", regexes)

    @_builtins.property
    @pulumi.getter
    def regexes(self) -> Sequence[_builtins.str]:
        """
        Required. RE2 regular expressions used to validate the parameter's value. The value must match the regex in its entirety (substring matches are not sufficient).
        """
        return pulumi.get(self, "regexes")


@pulumi.output_type
class WorkflowTemplateParameterValidationValues(dict):
    def __init__(__self__, *,
                 values: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] values: Required. List of allowed values for the parameter.
        """
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        Required. List of allowed values for the parameter.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class WorkflowTemplatePlacement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterSelector":
            suggest = "cluster_selector"
        elif key == "managedCluster":
            suggest = "managed_cluster"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_selector: Optional['outputs.WorkflowTemplatePlacementClusterSelector'] = None,
                 managed_cluster: Optional['outputs.WorkflowTemplatePlacementManagedCluster'] = None):
        """
        :param 'WorkflowTemplatePlacementClusterSelectorArgs' cluster_selector: A selector that chooses target cluster for jobs based on metadata. The selector is evaluated at the time each job is submitted.
        :param 'WorkflowTemplatePlacementManagedClusterArgs' managed_cluster: A cluster that is managed by the workflow.
        """
        if cluster_selector is not None:
            pulumi.set(__self__, "cluster_selector", cluster_selector)
        if managed_cluster is not None:
            pulumi.set(__self__, "managed_cluster", managed_cluster)

    @_builtins.property
    @pulumi.getter(name="clusterSelector")
    def cluster_selector(self) -> Optional['outputs.WorkflowTemplatePlacementClusterSelector']:
        """
        A selector that chooses target cluster for jobs based on metadata. The selector is evaluated at the time each job is submitted.
        """
        return pulumi.get(self, "cluster_selector")

    @_builtins.property
    @pulumi.getter(name="managedCluster")
    def managed_cluster(self) -> Optional['outputs.WorkflowTemplatePlacementManagedCluster']:
        """
        A cluster that is managed by the workflow.
        """
        return pulumi.get(self, "managed_cluster")


@pulumi.output_type
class WorkflowTemplatePlacementClusterSelector(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterLabels":
            suggest = "cluster_labels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementClusterSelector. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementClusterSelector.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementClusterSelector.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_labels: Mapping[str, _builtins.str],
                 zone: Optional[_builtins.str] = None):
        """
        :param Mapping[str, _builtins.str] cluster_labels: Required. The cluster labels. Cluster must have all labels to match.
        :param _builtins.str zone: The zone where workflow process executes. This parameter does not affect the selection of the cluster. If unspecified, the zone of the first cluster matching the selector is used.
        """
        pulumi.set(__self__, "cluster_labels", cluster_labels)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="clusterLabels")
    def cluster_labels(self) -> Mapping[str, _builtins.str]:
        """
        Required. The cluster labels. Cluster must have all labels to match.
        """
        return pulumi.get(self, "cluster_labels")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        """
        The zone where workflow process executes. This parameter does not affect the selection of the cluster. If unspecified, the zone of the first cluster matching the selector is used.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class WorkflowTemplatePlacementManagedCluster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterName":
            suggest = "cluster_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementManagedCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementManagedCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementManagedCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_name: _builtins.str,
                 config: 'outputs.WorkflowTemplatePlacementManagedClusterConfig',
                 labels: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str cluster_name: Required. The cluster name prefix. A unique cluster name will be formed by appending a random suffix. The name must contain only lower-case letters (a-z), numbers (0-9), and hyphens (-). Must begin with a letter. Cannot begin or end with hyphen. Must consist of between 2 and 35 characters.
        :param 'WorkflowTemplatePlacementManagedClusterConfigArgs' config: Required. The cluster configuration.
        :param Mapping[str, _builtins.str] labels: The labels to associate with this cluster. Label keys must be between 1 and 63 characters long, and must conform to the following PCRE regular expression: {0,63} No more than 32 labels can be associated with a given cluster.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "config", config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> _builtins.str:
        """
        Required. The cluster name prefix. A unique cluster name will be formed by appending a random suffix. The name must contain only lower-case letters (a-z), numbers (0-9), and hyphens (-). Must begin with a letter. Cannot begin or end with hyphen. Must consist of between 2 and 35 characters.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter
    def config(self) -> 'outputs.WorkflowTemplatePlacementManagedClusterConfig':
        """
        Required. The cluster configuration.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The labels to associate with this cluster. Label keys must be between 1 and 63 characters long, and must conform to the following PCRE regular expression: {0,63} No more than 32 labels can be associated with a given cluster.
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class WorkflowTemplatePlacementManagedClusterConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscalingConfig":
            suggest = "autoscaling_config"
        elif key == "encryptionConfig":
            suggest = "encryption_config"
        elif key == "endpointConfig":
            suggest = "endpoint_config"
        elif key == "gceClusterConfig":
            suggest = "gce_cluster_config"
        elif key == "gkeClusterConfig":
            suggest = "gke_cluster_config"
        elif key == "initializationActions":
            suggest = "initialization_actions"
        elif key == "lifecycleConfig":
            suggest = "lifecycle_config"
        elif key == "masterConfig":
            suggest = "master_config"
        elif key == "metastoreConfig":
            suggest = "metastore_config"
        elif key == "secondaryWorkerConfig":
            suggest = "secondary_worker_config"
        elif key == "securityConfig":
            suggest = "security_config"
        elif key == "softwareConfig":
            suggest = "software_config"
        elif key == "stagingBucket":
            suggest = "staging_bucket"
        elif key == "tempBucket":
            suggest = "temp_bucket"
        elif key == "workerConfig":
            suggest = "worker_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementManagedClusterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementManagedClusterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementManagedClusterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscaling_config: Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig'] = None,
                 encryption_config: Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigEncryptionConfig'] = None,
                 endpoint_config: Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigEndpointConfig'] = None,
                 gce_cluster_config: Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigGceClusterConfig'] = None,
                 gke_cluster_config: Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigGkeClusterConfig'] = None,
                 initialization_actions: Optional[Sequence['outputs.WorkflowTemplatePlacementManagedClusterConfigInitializationAction']] = None,
                 lifecycle_config: Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigLifecycleConfig'] = None,
                 master_config: Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigMasterConfig'] = None,
                 metastore_config: Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigMetastoreConfig'] = None,
                 secondary_worker_config: Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig'] = None,
                 security_config: Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigSecurityConfig'] = None,
                 software_config: Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigSoftwareConfig'] = None,
                 staging_bucket: Optional[_builtins.str] = None,
                 temp_bucket: Optional[_builtins.str] = None,
                 worker_config: Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigWorkerConfig'] = None):
        """
        :param 'WorkflowTemplatePlacementManagedClusterConfigAutoscalingConfigArgs' autoscaling_config: Autoscaling config for the policy associated with the cluster. Cluster does not autoscale if this field is unset.
        :param 'WorkflowTemplatePlacementManagedClusterConfigEncryptionConfigArgs' encryption_config: Encryption settings for the cluster.
        :param 'WorkflowTemplatePlacementManagedClusterConfigEndpointConfigArgs' endpoint_config: Port/endpoint configuration for this cluster
        :param 'WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigArgs' gce_cluster_config: The shared Compute Engine config settings for all instances in a cluster.
        :param 'WorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigArgs' gke_cluster_config: The Kubernetes Engine config for Dataproc clusters deployed to Kubernetes. Setting this is considered mutually exclusive with Compute Engine-based options such as `gce_cluster_config`, `master_config`, `worker_config`, `secondary_worker_config`, and `autoscaling_config`.
        :param Sequence['WorkflowTemplatePlacementManagedClusterConfigInitializationActionArgs'] initialization_actions: Commands to execute on each node after config is completed. By default, executables are run on master and all worker nodes. You can test a node's `role` metadata to run an executable on a master or worker node, as shown below using `curl` (you can also use `wget`): ROLE=$(curl -H Metadata-Flavor:Google http://metadata/computeMetadata/v1/instance/attributes/dataproc-role) if ; then ... master specific actions ... else ... worker specific actions ... fi
        :param 'WorkflowTemplatePlacementManagedClusterConfigLifecycleConfigArgs' lifecycle_config: Lifecycle setting for the cluster.
        :param 'WorkflowTemplatePlacementManagedClusterConfigMasterConfigArgs' master_config: The Compute Engine config settings for additional worker instances in a cluster.
        :param 'WorkflowTemplatePlacementManagedClusterConfigMetastoreConfigArgs' metastore_config: Metastore configuration.
        :param 'WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigArgs' secondary_worker_config: The Compute Engine config settings for additional worker instances in a cluster.
        :param 'WorkflowTemplatePlacementManagedClusterConfigSecurityConfigArgs' security_config: Security settings for the cluster.
        :param 'WorkflowTemplatePlacementManagedClusterConfigSoftwareConfigArgs' software_config: The config settings for software inside the cluster.
        :param _builtins.str staging_bucket: A Cloud Storage bucket used to stage job dependencies, config files, and job driver console output. If you do not specify a staging bucket, Cloud Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's staging bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket (see [Dataproc staging and temp buckets](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)).
        :param _builtins.str temp_bucket: A Cloud Storage bucket used to store ephemeral cluster and jobs data, such as Spark and MapReduce history files. If you do not specify a temp bucket, Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's temp bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket. The default bucket has a TTL of 90 days, but you can use any TTL (or none) if you specify a bucket.
        :param 'WorkflowTemplatePlacementManagedClusterConfigWorkerConfigArgs' worker_config: The Compute Engine config settings for additional worker instances in a cluster.
               
               - - -
        """
        if autoscaling_config is not None:
            pulumi.set(__self__, "autoscaling_config", autoscaling_config)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if endpoint_config is not None:
            pulumi.set(__self__, "endpoint_config", endpoint_config)
        if gce_cluster_config is not None:
            pulumi.set(__self__, "gce_cluster_config", gce_cluster_config)
        if gke_cluster_config is not None:
            pulumi.set(__self__, "gke_cluster_config", gke_cluster_config)
        if initialization_actions is not None:
            pulumi.set(__self__, "initialization_actions", initialization_actions)
        if lifecycle_config is not None:
            pulumi.set(__self__, "lifecycle_config", lifecycle_config)
        if master_config is not None:
            pulumi.set(__self__, "master_config", master_config)
        if metastore_config is not None:
            pulumi.set(__self__, "metastore_config", metastore_config)
        if secondary_worker_config is not None:
            pulumi.set(__self__, "secondary_worker_config", secondary_worker_config)
        if security_config is not None:
            pulumi.set(__self__, "security_config", security_config)
        if software_config is not None:
            pulumi.set(__self__, "software_config", software_config)
        if staging_bucket is not None:
            pulumi.set(__self__, "staging_bucket", staging_bucket)
        if temp_bucket is not None:
            pulumi.set(__self__, "temp_bucket", temp_bucket)
        if worker_config is not None:
            pulumi.set(__self__, "worker_config", worker_config)

    @_builtins.property
    @pulumi.getter(name="autoscalingConfig")
    def autoscaling_config(self) -> Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig']:
        """
        Autoscaling config for the policy associated with the cluster. Cluster does not autoscale if this field is unset.
        """
        return pulumi.get(self, "autoscaling_config")

    @_builtins.property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigEncryptionConfig']:
        """
        Encryption settings for the cluster.
        """
        return pulumi.get(self, "encryption_config")

    @_builtins.property
    @pulumi.getter(name="endpointConfig")
    def endpoint_config(self) -> Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigEndpointConfig']:
        """
        Port/endpoint configuration for this cluster
        """
        return pulumi.get(self, "endpoint_config")

    @_builtins.property
    @pulumi.getter(name="gceClusterConfig")
    def gce_cluster_config(self) -> Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigGceClusterConfig']:
        """
        The shared Compute Engine config settings for all instances in a cluster.
        """
        return pulumi.get(self, "gce_cluster_config")

    @_builtins.property
    @pulumi.getter(name="gkeClusterConfig")
    def gke_cluster_config(self) -> Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigGkeClusterConfig']:
        """
        The Kubernetes Engine config for Dataproc clusters deployed to Kubernetes. Setting this is considered mutually exclusive with Compute Engine-based options such as `gce_cluster_config`, `master_config`, `worker_config`, `secondary_worker_config`, and `autoscaling_config`.
        """
        return pulumi.get(self, "gke_cluster_config")

    @_builtins.property
    @pulumi.getter(name="initializationActions")
    def initialization_actions(self) -> Optional[Sequence['outputs.WorkflowTemplatePlacementManagedClusterConfigInitializationAction']]:
        """
        Commands to execute on each node after config is completed. By default, executables are run on master and all worker nodes. You can test a node's `role` metadata to run an executable on a master or worker node, as shown below using `curl` (you can also use `wget`): ROLE=$(curl -H Metadata-Flavor:Google http://metadata/computeMetadata/v1/instance/attributes/dataproc-role) if ; then ... master specific actions ... else ... worker specific actions ... fi
        """
        return pulumi.get(self, "initialization_actions")

    @_builtins.property
    @pulumi.getter(name="lifecycleConfig")
    def lifecycle_config(self) -> Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigLifecycleConfig']:
        """
        Lifecycle setting for the cluster.
        """
        return pulumi.get(self, "lifecycle_config")

    @_builtins.property
    @pulumi.getter(name="masterConfig")
    def master_config(self) -> Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigMasterConfig']:
        """
        The Compute Engine config settings for additional worker instances in a cluster.
        """
        return pulumi.get(self, "master_config")

    @_builtins.property
    @pulumi.getter(name="metastoreConfig")
    def metastore_config(self) -> Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigMetastoreConfig']:
        """
        Metastore configuration.
        """
        return pulumi.get(self, "metastore_config")

    @_builtins.property
    @pulumi.getter(name="secondaryWorkerConfig")
    def secondary_worker_config(self) -> Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig']:
        """
        The Compute Engine config settings for additional worker instances in a cluster.
        """
        return pulumi.get(self, "secondary_worker_config")

    @_builtins.property
    @pulumi.getter(name="securityConfig")
    def security_config(self) -> Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigSecurityConfig']:
        """
        Security settings for the cluster.
        """
        return pulumi.get(self, "security_config")

    @_builtins.property
    @pulumi.getter(name="softwareConfig")
    def software_config(self) -> Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigSoftwareConfig']:
        """
        The config settings for software inside the cluster.
        """
        return pulumi.get(self, "software_config")

    @_builtins.property
    @pulumi.getter(name="stagingBucket")
    def staging_bucket(self) -> Optional[_builtins.str]:
        """
        A Cloud Storage bucket used to stage job dependencies, config files, and job driver console output. If you do not specify a staging bucket, Cloud Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's staging bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket (see [Dataproc staging and temp buckets](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)).
        """
        return pulumi.get(self, "staging_bucket")

    @_builtins.property
    @pulumi.getter(name="tempBucket")
    def temp_bucket(self) -> Optional[_builtins.str]:
        """
        A Cloud Storage bucket used to store ephemeral cluster and jobs data, such as Spark and MapReduce history files. If you do not specify a temp bucket, Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's temp bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket. The default bucket has a TTL of 90 days, but you can use any TTL (or none) if you specify a bucket.
        """
        return pulumi.get(self, "temp_bucket")

    @_builtins.property
    @pulumi.getter(name="workerConfig")
    def worker_config(self) -> Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigWorkerConfig']:
        """
        The Compute Engine config settings for additional worker instances in a cluster.

        - - -
        """
        return pulumi.get(self, "worker_config")


@pulumi.output_type
class WorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig(dict):
    def __init__(__self__, *,
                 policy: Optional[_builtins.str] = None):
        """
        :param _builtins.str policy: The autoscaling policy used by the cluster. Only resource names including projectid and location (region) are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/` Note that the policy must be in the same project and Dataproc region.
        """
        if policy is not None:
            pulumi.set(__self__, "policy", policy)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[_builtins.str]:
        """
        The autoscaling policy used by the cluster. Only resource names including projectid and location (region) are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/` Note that the policy must be in the same project and Dataproc region.
        """
        return pulumi.get(self, "policy")


@pulumi.output_type
class WorkflowTemplatePlacementManagedClusterConfigEncryptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gcePdKmsKeyName":
            suggest = "gce_pd_kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementManagedClusterConfigEncryptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigEncryptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigEncryptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gce_pd_kms_key_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str gce_pd_kms_key_name: The Cloud KMS key name to use for PD disk encryption for all instances in the cluster.
        """
        if gce_pd_kms_key_name is not None:
            pulumi.set(__self__, "gce_pd_kms_key_name", gce_pd_kms_key_name)

    @_builtins.property
    @pulumi.getter(name="gcePdKmsKeyName")
    def gce_pd_kms_key_name(self) -> Optional[_builtins.str]:
        """
        The Cloud KMS key name to use for PD disk encryption for all instances in the cluster.
        """
        return pulumi.get(self, "gce_pd_kms_key_name")


@pulumi.output_type
class WorkflowTemplatePlacementManagedClusterConfigEndpointConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableHttpPortAccess":
            suggest = "enable_http_port_access"
        elif key == "httpPorts":
            suggest = "http_ports"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementManagedClusterConfigEndpointConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigEndpointConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigEndpointConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_http_port_access: Optional[_builtins.bool] = None,
                 http_ports: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.bool enable_http_port_access: If true, enable http access to specific ports on the cluster from external sources. Defaults to false.
        :param Mapping[str, _builtins.str] http_ports: Output only. The map of port descriptions to URLs. Will only be populated if enable_http_port_access is true.
        """
        if enable_http_port_access is not None:
            pulumi.set(__self__, "enable_http_port_access", enable_http_port_access)
        if http_ports is not None:
            pulumi.set(__self__, "http_ports", http_ports)

    @_builtins.property
    @pulumi.getter(name="enableHttpPortAccess")
    def enable_http_port_access(self) -> Optional[_builtins.bool]:
        """
        If true, enable http access to specific ports on the cluster from external sources. Defaults to false.
        """
        return pulumi.get(self, "enable_http_port_access")

    @_builtins.property
    @pulumi.getter(name="httpPorts")
    def http_ports(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Output only. The map of port descriptions to URLs. Will only be populated if enable_http_port_access is true.
        """
        return pulumi.get(self, "http_ports")


@pulumi.output_type
class WorkflowTemplatePlacementManagedClusterConfigGceClusterConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "internalIpOnly":
            suggest = "internal_ip_only"
        elif key == "nodeGroupAffinity":
            suggest = "node_group_affinity"
        elif key == "privateIpv6GoogleAccess":
            suggest = "private_ipv6_google_access"
        elif key == "reservationAffinity":
            suggest = "reservation_affinity"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "serviceAccountScopes":
            suggest = "service_account_scopes"
        elif key == "shieldedInstanceConfig":
            suggest = "shielded_instance_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementManagedClusterConfigGceClusterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigGceClusterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigGceClusterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 internal_ip_only: Optional[_builtins.bool] = None,
                 metadata: Optional[Mapping[str, _builtins.str]] = None,
                 network: Optional[_builtins.str] = None,
                 node_group_affinity: Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity'] = None,
                 private_ipv6_google_access: Optional[_builtins.str] = None,
                 reservation_affinity: Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity'] = None,
                 service_account: Optional[_builtins.str] = None,
                 service_account_scopes: Optional[Sequence[_builtins.str]] = None,
                 shielded_instance_config: Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigShieldedInstanceConfig'] = None,
                 subnetwork: Optional[_builtins.str] = None,
                 tags: Optional[Sequence[_builtins.str]] = None,
                 zone: Optional[_builtins.str] = None):
        """
        :param _builtins.bool internal_ip_only: If true, all instances in the cluster will only have internal IP addresses. By default, clusters are not restricted to internal IP addresses, and will have ephemeral external IP addresses assigned to each instance. This `internal_ip_only` restriction can only be enabled for subnetwork enabled networks, and all off-cluster dependencies must be configured to be accessible without external IP addresses.
        :param Mapping[str, _builtins.str] metadata: The Compute Engine metadata entries to add to all instances (see [About VM metadata](https://cloud.google.com/compute/docs/metadata/overview)).
        :param _builtins.str network: The Compute Engine network to be used for machine communications. Cannot be specified with subnetwork_uri. If neither `network_uri` nor `subnetwork_uri` is specified, the "default" network of the project is used, if it exists. Cannot be a "Custom Subnet Network" (see /regions/global/default` * `default`
        :param 'WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinityArgs' node_group_affinity: Node Group Affinity for sole-tenant clusters.
        :param _builtins.str private_ipv6_google_access: The type of IPv6 access for a cluster. Possible values: PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED, INHERIT_FROM_SUBNETWORK, OUTBOUND, BIDIRECTIONAL
        :param 'WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinityArgs' reservation_affinity: Reservation Affinity for consuming Zonal reservation.
        :param _builtins.str service_account: The (https://cloud.google.com/compute/docs/access/service-accounts#default_service_account) is used.
        :param Sequence[_builtins.str] service_account_scopes: The URIs of service account scopes to be included in Compute Engine instances. The following base set of scopes is always included: * https://www.googleapis.com/auth/cloud.useraccounts.readonly * https://www.googleapis.com/auth/devstorage.read_write * https://www.googleapis.com/auth/logging.write If no scopes are specified, the following defaults are also provided: * https://www.googleapis.com/auth/bigquery * https://www.googleapis.com/auth/bigtable.admin.table * https://www.googleapis.com/auth/bigtable.data * https://www.googleapis.com/auth/devstorage.full_control
        :param 'WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigShieldedInstanceConfigArgs' shielded_instance_config: Shielded Instance Config for clusters using [Compute Engine Shielded VMs](https://cloud.google.com/security/shielded-cloud/shielded-vm). Structure defined below.
        :param _builtins.str subnetwork: The Compute Engine subnetwork to be used for machine communications. Cannot be specified with network_uri. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects//regions/us-east1/subnetworks/sub0` * `sub0`
        :param Sequence[_builtins.str] tags: The Compute Engine tags to add to all instances (see [Manage tags for resources](https://cloud.google.com/compute/docs/tag-resources)).
        :param _builtins.str zone: The zone where the Compute Engine cluster will be located. On a create request, it is required in the "global" region. If omitted in a non-global Dataproc region, the service will pick a zone in the corresponding Compute Engine region. On a get request, zone will always be present. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/` * `us-central1-f`
        """
        if internal_ip_only is not None:
            pulumi.set(__self__, "internal_ip_only", internal_ip_only)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if node_group_affinity is not None:
            pulumi.set(__self__, "node_group_affinity", node_group_affinity)
        if private_ipv6_google_access is not None:
            pulumi.set(__self__, "private_ipv6_google_access", private_ipv6_google_access)
        if reservation_affinity is not None:
            pulumi.set(__self__, "reservation_affinity", reservation_affinity)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if service_account_scopes is not None:
            pulumi.set(__self__, "service_account_scopes", service_account_scopes)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="internalIpOnly")
    def internal_ip_only(self) -> Optional[_builtins.bool]:
        """
        If true, all instances in the cluster will only have internal IP addresses. By default, clusters are not restricted to internal IP addresses, and will have ephemeral external IP addresses assigned to each instance. This `internal_ip_only` restriction can only be enabled for subnetwork enabled networks, and all off-cluster dependencies must be configured to be accessible without external IP addresses.
        """
        return pulumi.get(self, "internal_ip_only")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The Compute Engine metadata entries to add to all instances (see [About VM metadata](https://cloud.google.com/compute/docs/metadata/overview)).
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[_builtins.str]:
        """
        The Compute Engine network to be used for machine communications. Cannot be specified with subnetwork_uri. If neither `network_uri` nor `subnetwork_uri` is specified, the "default" network of the project is used, if it exists. Cannot be a "Custom Subnet Network" (see /regions/global/default` * `default`
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="nodeGroupAffinity")
    def node_group_affinity(self) -> Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity']:
        """
        Node Group Affinity for sole-tenant clusters.
        """
        return pulumi.get(self, "node_group_affinity")

    @_builtins.property
    @pulumi.getter(name="privateIpv6GoogleAccess")
    def private_ipv6_google_access(self) -> Optional[_builtins.str]:
        """
        The type of IPv6 access for a cluster. Possible values: PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED, INHERIT_FROM_SUBNETWORK, OUTBOUND, BIDIRECTIONAL
        """
        return pulumi.get(self, "private_ipv6_google_access")

    @_builtins.property
    @pulumi.getter(name="reservationAffinity")
    def reservation_affinity(self) -> Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity']:
        """
        Reservation Affinity for consuming Zonal reservation.
        """
        return pulumi.get(self, "reservation_affinity")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[_builtins.str]:
        """
        The (https://cloud.google.com/compute/docs/access/service-accounts#default_service_account) is used.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter(name="serviceAccountScopes")
    def service_account_scopes(self) -> Optional[Sequence[_builtins.str]]:
        """
        The URIs of service account scopes to be included in Compute Engine instances. The following base set of scopes is always included: * https://www.googleapis.com/auth/cloud.useraccounts.readonly * https://www.googleapis.com/auth/devstorage.read_write * https://www.googleapis.com/auth/logging.write If no scopes are specified, the following defaults are also provided: * https://www.googleapis.com/auth/bigquery * https://www.googleapis.com/auth/bigtable.admin.table * https://www.googleapis.com/auth/bigtable.data * https://www.googleapis.com/auth/devstorage.full_control
        """
        return pulumi.get(self, "service_account_scopes")

    @_builtins.property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigShieldedInstanceConfig']:
        """
        Shielded Instance Config for clusters using [Compute Engine Shielded VMs](https://cloud.google.com/security/shielded-cloud/shielded-vm). Structure defined below.
        """
        return pulumi.get(self, "shielded_instance_config")

    @_builtins.property
    @pulumi.getter
    def subnetwork(self) -> Optional[_builtins.str]:
        """
        The Compute Engine subnetwork to be used for machine communications. Cannot be specified with network_uri. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects//regions/us-east1/subnetworks/sub0` * `sub0`
        """
        return pulumi.get(self, "subnetwork")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        The Compute Engine tags to add to all instances (see [Manage tags for resources](https://cloud.google.com/compute/docs/tag-resources)).
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        """
        The zone where the Compute Engine cluster will be located. On a create request, it is required in the "global" region. If omitted in a non-global Dataproc region, the service will pick a zone in the corresponding Compute Engine region. On a get request, zone will always be present. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/` * `us-central1-f`
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeGroup":
            suggest = "node_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_group: _builtins.str):
        """
        :param _builtins.str node_group: Required. The URI of a sole-tenant /zones/us-central1-a/nodeGroups/node-group-1` * `node-group-1`
        """
        pulumi.set(__self__, "node_group", node_group)

    @_builtins.property
    @pulumi.getter(name="nodeGroup")
    def node_group(self) -> _builtins.str:
        """
        Required. The URI of a sole-tenant /zones/us-central1-a/nodeGroups/node-group-1` * `node-group-1`
        """
        return pulumi.get(self, "node_group")


@pulumi.output_type
class WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumeReservationType":
            suggest = "consume_reservation_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consume_reservation_type: Optional[_builtins.str] = None,
                 key: Optional[_builtins.str] = None,
                 values: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str consume_reservation_type: Type of reservation to consume Possible values: TYPE_UNSPECIFIED, NO_RESERVATION, ANY_RESERVATION, SPECIFIC_RESERVATION
        :param _builtins.str key: Corresponds to the label key of reservation resource.
        :param Sequence[_builtins.str] values: Corresponds to the label values of reservation resource.
        """
        if consume_reservation_type is not None:
            pulumi.set(__self__, "consume_reservation_type", consume_reservation_type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter(name="consumeReservationType")
    def consume_reservation_type(self) -> Optional[_builtins.str]:
        """
        Type of reservation to consume Possible values: TYPE_UNSPECIFIED, NO_RESERVATION, ANY_RESERVATION, SPECIFIC_RESERVATION
        """
        return pulumi.get(self, "consume_reservation_type")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        Corresponds to the label key of reservation resource.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[Sequence[_builtins.str]]:
        """
        Corresponds to the label values of reservation resource.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigShieldedInstanceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableIntegrityMonitoring":
            suggest = "enable_integrity_monitoring"
        elif key == "enableSecureBoot":
            suggest = "enable_secure_boot"
        elif key == "enableVtpm":
            suggest = "enable_vtpm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigShieldedInstanceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigShieldedInstanceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigShieldedInstanceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_integrity_monitoring: Optional[_builtins.bool] = None,
                 enable_secure_boot: Optional[_builtins.bool] = None,
                 enable_vtpm: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool enable_integrity_monitoring: Defines whether instances have [Integrity Monitoring](https://cloud.google.com/compute/shielded-vm/docs/shielded-vm#integrity-monitoring) enabled.
        :param _builtins.bool enable_secure_boot: Defines whether instances have [Secure Boot](https://cloud.google.com/compute/shielded-vm/docs/shielded-vm#secure-boot) enabled.
        :param _builtins.bool enable_vtpm: Defines whether instances have the [vTPM](https://cloud.google.com/compute/shielded-vm/docs/shielded-vm#vtpm) enabled.
        """
        if enable_integrity_monitoring is not None:
            pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        if enable_secure_boot is not None:
            pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)
        if enable_vtpm is not None:
            pulumi.set(__self__, "enable_vtpm", enable_vtpm)

    @_builtins.property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> Optional[_builtins.bool]:
        """
        Defines whether instances have [Integrity Monitoring](https://cloud.google.com/compute/shielded-vm/docs/shielded-vm#integrity-monitoring) enabled.
        """
        return pulumi.get(self, "enable_integrity_monitoring")

    @_builtins.property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> Optional[_builtins.bool]:
        """
        Defines whether instances have [Secure Boot](https://cloud.google.com/compute/shielded-vm/docs/shielded-vm#secure-boot) enabled.
        """
        return pulumi.get(self, "enable_secure_boot")

    @_builtins.property
    @pulumi.getter(name="enableVtpm")
    def enable_vtpm(self) -> Optional[_builtins.bool]:
        """
        Defines whether instances have the [vTPM](https://cloud.google.com/compute/shielded-vm/docs/shielded-vm#vtpm) enabled.
        """
        return pulumi.get(self, "enable_vtpm")


@pulumi.output_type
class WorkflowTemplatePlacementManagedClusterConfigGkeClusterConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "namespacedGkeDeploymentTarget":
            suggest = "namespaced_gke_deployment_target"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementManagedClusterConfigGkeClusterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigGkeClusterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigGkeClusterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 namespaced_gke_deployment_target: Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigNamespacedGkeDeploymentTarget'] = None):
        """
        :param 'WorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigNamespacedGkeDeploymentTargetArgs' namespaced_gke_deployment_target: A target for the deployment.
        """
        if namespaced_gke_deployment_target is not None:
            pulumi.set(__self__, "namespaced_gke_deployment_target", namespaced_gke_deployment_target)

    @_builtins.property
    @pulumi.getter(name="namespacedGkeDeploymentTarget")
    def namespaced_gke_deployment_target(self) -> Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigNamespacedGkeDeploymentTarget']:
        """
        A target for the deployment.
        """
        return pulumi.get(self, "namespaced_gke_deployment_target")


@pulumi.output_type
class WorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigNamespacedGkeDeploymentTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterNamespace":
            suggest = "cluster_namespace"
        elif key == "targetGkeCluster":
            suggest = "target_gke_cluster"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigNamespacedGkeDeploymentTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigNamespacedGkeDeploymentTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigNamespacedGkeDeploymentTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_namespace: Optional[_builtins.str] = None,
                 target_gke_cluster: Optional[_builtins.str] = None):
        """
        :param _builtins.str cluster_namespace: A namespace within the GKE cluster to deploy into.
        :param _builtins.str target_gke_cluster: The target GKE cluster to deploy to. Format: 'projects/{project}/locations/{location}/clusters/{cluster_id}'
        """
        if cluster_namespace is not None:
            pulumi.set(__self__, "cluster_namespace", cluster_namespace)
        if target_gke_cluster is not None:
            pulumi.set(__self__, "target_gke_cluster", target_gke_cluster)

    @_builtins.property
    @pulumi.getter(name="clusterNamespace")
    def cluster_namespace(self) -> Optional[_builtins.str]:
        """
        A namespace within the GKE cluster to deploy into.
        """
        return pulumi.get(self, "cluster_namespace")

    @_builtins.property
    @pulumi.getter(name="targetGkeCluster")
    def target_gke_cluster(self) -> Optional[_builtins.str]:
        """
        The target GKE cluster to deploy to. Format: 'projects/{project}/locations/{location}/clusters/{cluster_id}'
        """
        return pulumi.get(self, "target_gke_cluster")


@pulumi.output_type
class WorkflowTemplatePlacementManagedClusterConfigInitializationAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executableFile":
            suggest = "executable_file"
        elif key == "executionTimeout":
            suggest = "execution_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementManagedClusterConfigInitializationAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigInitializationAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigInitializationAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 executable_file: Optional[_builtins.str] = None,
                 execution_timeout: Optional[_builtins.str] = None):
        """
        :param _builtins.str executable_file: Required. Cloud Storage URI of executable file.
        :param _builtins.str execution_timeout: Amount of time executable has to complete. Default is 10 minutes (see JSON representation of [JSON Mapping - Language Guide (proto 3)](https://developers.google.com/protocol-buffers/docs/proto3#json)). Cluster creation fails with an explanatory error message (the name of the executable that caused the error and the exceeded timeout period) if the executable is not completed at end of the timeout period.
        """
        if executable_file is not None:
            pulumi.set(__self__, "executable_file", executable_file)
        if execution_timeout is not None:
            pulumi.set(__self__, "execution_timeout", execution_timeout)

    @_builtins.property
    @pulumi.getter(name="executableFile")
    def executable_file(self) -> Optional[_builtins.str]:
        """
        Required. Cloud Storage URI of executable file.
        """
        return pulumi.get(self, "executable_file")

    @_builtins.property
    @pulumi.getter(name="executionTimeout")
    def execution_timeout(self) -> Optional[_builtins.str]:
        """
        Amount of time executable has to complete. Default is 10 minutes (see JSON representation of [JSON Mapping - Language Guide (proto 3)](https://developers.google.com/protocol-buffers/docs/proto3#json)). Cluster creation fails with an explanatory error message (the name of the executable that caused the error and the exceeded timeout period) if the executable is not completed at end of the timeout period.
        """
        return pulumi.get(self, "execution_timeout")


@pulumi.output_type
class WorkflowTemplatePlacementManagedClusterConfigLifecycleConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoDeleteTime":
            suggest = "auto_delete_time"
        elif key == "autoDeleteTtl":
            suggest = "auto_delete_ttl"
        elif key == "idleDeleteTtl":
            suggest = "idle_delete_ttl"
        elif key == "idleStartTime":
            suggest = "idle_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementManagedClusterConfigLifecycleConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigLifecycleConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigLifecycleConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_delete_time: Optional[_builtins.str] = None,
                 auto_delete_ttl: Optional[_builtins.str] = None,
                 idle_delete_ttl: Optional[_builtins.str] = None,
                 idle_start_time: Optional[_builtins.str] = None):
        """
        :param _builtins.str auto_delete_time: The time when cluster will be auto-deleted (see JSON representation of [JSON Mapping - Language Guide (proto 3)](https://developers.google.com/protocol-buffers/docs/proto3#json)).
        :param _builtins.str auto_delete_ttl: The lifetime duration of cluster. The cluster will be auto-deleted at the end of this period. Minimum value is 10 minutes; maximum value is 14 days (see JSON representation of [JSON Mapping - Language Guide (proto 3)](https://developers.google.com/protocol-buffers/docs/proto3#json)).
        :param _builtins.str idle_delete_ttl: The duration to keep the cluster alive while idling (when no jobs are running). Passing this threshold will cause the cluster to be deleted. Minimum value is 5 minutes; maximum value is 14 days (see JSON representation of [JSON Mapping - Language Guide (proto 3)](https://developers.google.com/protocol-buffers/docs/proto3#json).
        :param _builtins.str idle_start_time: Output only. The time when cluster became idle (most recent job finished) and became eligible for deletion due to idleness (see JSON representation of [JSON Mapping - Language Guide (proto 3)](https://developers.google.com/protocol-buffers/docs/proto3#json)).
        """
        if auto_delete_time is not None:
            pulumi.set(__self__, "auto_delete_time", auto_delete_time)
        if auto_delete_ttl is not None:
            pulumi.set(__self__, "auto_delete_ttl", auto_delete_ttl)
        if idle_delete_ttl is not None:
            pulumi.set(__self__, "idle_delete_ttl", idle_delete_ttl)
        if idle_start_time is not None:
            pulumi.set(__self__, "idle_start_time", idle_start_time)

    @_builtins.property
    @pulumi.getter(name="autoDeleteTime")
    def auto_delete_time(self) -> Optional[_builtins.str]:
        """
        The time when cluster will be auto-deleted (see JSON representation of [JSON Mapping - Language Guide (proto 3)](https://developers.google.com/protocol-buffers/docs/proto3#json)).
        """
        return pulumi.get(self, "auto_delete_time")

    @_builtins.property
    @pulumi.getter(name="autoDeleteTtl")
    def auto_delete_ttl(self) -> Optional[_builtins.str]:
        """
        The lifetime duration of cluster. The cluster will be auto-deleted at the end of this period. Minimum value is 10 minutes; maximum value is 14 days (see JSON representation of [JSON Mapping - Language Guide (proto 3)](https://developers.google.com/protocol-buffers/docs/proto3#json)).
        """
        return pulumi.get(self, "auto_delete_ttl")

    @_builtins.property
    @pulumi.getter(name="idleDeleteTtl")
    def idle_delete_ttl(self) -> Optional[_builtins.str]:
        """
        The duration to keep the cluster alive while idling (when no jobs are running). Passing this threshold will cause the cluster to be deleted. Minimum value is 5 minutes; maximum value is 14 days (see JSON representation of [JSON Mapping - Language Guide (proto 3)](https://developers.google.com/protocol-buffers/docs/proto3#json).
        """
        return pulumi.get(self, "idle_delete_ttl")

    @_builtins.property
    @pulumi.getter(name="idleStartTime")
    def idle_start_time(self) -> Optional[_builtins.str]:
        """
        Output only. The time when cluster became idle (most recent job finished) and became eligible for deletion due to idleness (see JSON representation of [JSON Mapping - Language Guide (proto 3)](https://developers.google.com/protocol-buffers/docs/proto3#json)).
        """
        return pulumi.get(self, "idle_start_time")


@pulumi.output_type
class WorkflowTemplatePlacementManagedClusterConfigMasterConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskConfig":
            suggest = "disk_config"
        elif key == "instanceNames":
            suggest = "instance_names"
        elif key == "isPreemptible":
            suggest = "is_preemptible"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "managedGroupConfigs":
            suggest = "managed_group_configs"
        elif key == "minCpuPlatform":
            suggest = "min_cpu_platform"
        elif key == "numInstances":
            suggest = "num_instances"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementManagedClusterConfigMasterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigMasterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigMasterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerators: Optional[Sequence['outputs.WorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerator']] = None,
                 disk_config: Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig'] = None,
                 image: Optional[_builtins.str] = None,
                 instance_names: Optional[Sequence[_builtins.str]] = None,
                 is_preemptible: Optional[_builtins.bool] = None,
                 machine_type: Optional[_builtins.str] = None,
                 managed_group_configs: Optional[Sequence['outputs.WorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfig']] = None,
                 min_cpu_platform: Optional[_builtins.str] = None,
                 num_instances: Optional[_builtins.int] = None,
                 preemptibility: Optional[_builtins.str] = None):
        """
        :param Sequence['WorkflowTemplatePlacementManagedClusterConfigMasterConfigAcceleratorArgs'] accelerators: The Compute Engine accelerator configuration for these instances.
        :param 'WorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfigArgs' disk_config: Disk option config settings.
        :param _builtins.str image: The Compute Engine image resource used for cluster instances. The URI can represent an image or image family. Image examples: * `https://www.googleapis.com/compute/beta/projects/` If the URI is unspecified, it will be inferred from `SoftwareConfig.image_version` or the system default.
        :param Sequence[_builtins.str] instance_names: Output only. The list of instance names. Dataproc derives the names from `cluster_name`, `num_instances`, and the instance group.
        :param _builtins.bool is_preemptible: Output only. Specifies that this instance group contains preemptible instances.
        :param _builtins.str machine_type: The Compute Engine machine type used for cluster instances. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/(https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, `n1-standard-2`.
        :param Sequence['WorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfigArgs'] managed_group_configs: Output only. The config for Compute Engine Instance Group Manager that manages this group. This is only used for preemptible instance groups.
        :param _builtins.str min_cpu_platform: Specifies the minimum cpu platform for the Instance Group. See [Minimum CPU platform](https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
        :param _builtins.int num_instances: The number of VM instances in the instance group. For master instance groups, must be set to 1.
        :param _builtins.str preemptibility: Specifies the preemptibility of the instance group. The default value for master and worker groups is `NON_PREEMPTIBLE`. This default cannot be changed. The default value for secondary instances is `PREEMPTIBLE`. Possible values: PREEMPTIBILITY_UNSPECIFIED, NON_PREEMPTIBLE, PREEMPTIBLE
        """
        if accelerators is not None:
            pulumi.set(__self__, "accelerators", accelerators)
        if disk_config is not None:
            pulumi.set(__self__, "disk_config", disk_config)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if instance_names is not None:
            pulumi.set(__self__, "instance_names", instance_names)
        if is_preemptible is not None:
            pulumi.set(__self__, "is_preemptible", is_preemptible)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if managed_group_configs is not None:
            pulumi.set(__self__, "managed_group_configs", managed_group_configs)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if num_instances is not None:
            pulumi.set(__self__, "num_instances", num_instances)
        if preemptibility is not None:
            pulumi.set(__self__, "preemptibility", preemptibility)

    @_builtins.property
    @pulumi.getter
    def accelerators(self) -> Optional[Sequence['outputs.WorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerator']]:
        """
        The Compute Engine accelerator configuration for these instances.
        """
        return pulumi.get(self, "accelerators")

    @_builtins.property
    @pulumi.getter(name="diskConfig")
    def disk_config(self) -> Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig']:
        """
        Disk option config settings.
        """
        return pulumi.get(self, "disk_config")

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[_builtins.str]:
        """
        The Compute Engine image resource used for cluster instances. The URI can represent an image or image family. Image examples: * `https://www.googleapis.com/compute/beta/projects/` If the URI is unspecified, it will be inferred from `SoftwareConfig.image_version` or the system default.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter(name="instanceNames")
    def instance_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        Output only. The list of instance names. Dataproc derives the names from `cluster_name`, `num_instances`, and the instance group.
        """
        return pulumi.get(self, "instance_names")

    @_builtins.property
    @pulumi.getter(name="isPreemptible")
    def is_preemptible(self) -> Optional[_builtins.bool]:
        """
        Output only. Specifies that this instance group contains preemptible instances.
        """
        return pulumi.get(self, "is_preemptible")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[_builtins.str]:
        """
        The Compute Engine machine type used for cluster instances. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/(https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, `n1-standard-2`.
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter(name="managedGroupConfigs")
    def managed_group_configs(self) -> Optional[Sequence['outputs.WorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfig']]:
        """
        Output only. The config for Compute Engine Instance Group Manager that manages this group. This is only used for preemptible instance groups.
        """
        return pulumi.get(self, "managed_group_configs")

    @_builtins.property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[_builtins.str]:
        """
        Specifies the minimum cpu platform for the Instance Group. See [Minimum CPU platform](https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
        """
        return pulumi.get(self, "min_cpu_platform")

    @_builtins.property
    @pulumi.getter(name="numInstances")
    def num_instances(self) -> Optional[_builtins.int]:
        """
        The number of VM instances in the instance group. For master instance groups, must be set to 1.
        """
        return pulumi.get(self, "num_instances")

    @_builtins.property
    @pulumi.getter
    def preemptibility(self) -> Optional[_builtins.str]:
        """
        Specifies the preemptibility of the instance group. The default value for master and worker groups is `NON_PREEMPTIBLE`. This default cannot be changed. The default value for secondary instances is `PREEMPTIBLE`. Possible values: PREEMPTIBILITY_UNSPECIFIED, NON_PREEMPTIBLE, PREEMPTIBLE
        """
        return pulumi.get(self, "preemptibility")


@pulumi.output_type
class WorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerator(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceleratorCount":
            suggest = "accelerator_count"
        elif key == "acceleratorType":
            suggest = "accelerator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerator. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerator.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerator.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerator_count: Optional[_builtins.int] = None,
                 accelerator_type: Optional[_builtins.str] = None):
        """
        :param _builtins.int accelerator_count: The number of the accelerator cards of this type exposed to this instance.
        :param _builtins.str accelerator_type: Full URL, partial URI, or short name of the accelerator type resource to expose to this instance. See (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, `nvidia-tesla-k80`.
        """
        if accelerator_count is not None:
            pulumi.set(__self__, "accelerator_count", accelerator_count)
        if accelerator_type is not None:
            pulumi.set(__self__, "accelerator_type", accelerator_type)

    @_builtins.property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> Optional[_builtins.int]:
        """
        The number of the accelerator cards of this type exposed to this instance.
        """
        return pulumi.get(self, "accelerator_count")

    @_builtins.property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> Optional[_builtins.str]:
        """
        Full URL, partial URI, or short name of the accelerator type resource to expose to this instance. See (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, `nvidia-tesla-k80`.
        """
        return pulumi.get(self, "accelerator_type")


@pulumi.output_type
class WorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootDiskSizeGb":
            suggest = "boot_disk_size_gb"
        elif key == "bootDiskType":
            suggest = "boot_disk_type"
        elif key == "numLocalSsds":
            suggest = "num_local_ssds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot_disk_size_gb: Optional[_builtins.int] = None,
                 boot_disk_type: Optional[_builtins.str] = None,
                 num_local_ssds: Optional[_builtins.int] = None):
        """
        :param _builtins.int boot_disk_size_gb: Size in GB of the boot disk (default is 500GB).
        :param _builtins.str boot_disk_type: Type of the boot disk (default is "pd-standard"). Valid values: "pd-ssd" (Persistent Disk Solid State Drive) or "pd-standard" (Persistent Disk Hard Disk Drive).
        :param _builtins.int num_local_ssds: Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and (https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
        """
        if boot_disk_size_gb is not None:
            pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        if boot_disk_type is not None:
            pulumi.set(__self__, "boot_disk_type", boot_disk_type)
        if num_local_ssds is not None:
            pulumi.set(__self__, "num_local_ssds", num_local_ssds)

    @_builtins.property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> Optional[_builtins.int]:
        """
        Size in GB of the boot disk (default is 500GB).
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @_builtins.property
    @pulumi.getter(name="bootDiskType")
    def boot_disk_type(self) -> Optional[_builtins.str]:
        """
        Type of the boot disk (default is "pd-standard"). Valid values: "pd-ssd" (Persistent Disk Solid State Drive) or "pd-standard" (Persistent Disk Hard Disk Drive).
        """
        return pulumi.get(self, "boot_disk_type")

    @_builtins.property
    @pulumi.getter(name="numLocalSsds")
    def num_local_ssds(self) -> Optional[_builtins.int]:
        """
        Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and (https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
        """
        return pulumi.get(self, "num_local_ssds")


@pulumi.output_type
class WorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceGroupManagerName":
            suggest = "instance_group_manager_name"
        elif key == "instanceTemplateName":
            suggest = "instance_template_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_group_manager_name: Optional[_builtins.str] = None,
                 instance_template_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str instance_group_manager_name: Output only. The name of the Instance Group Manager for this group.
        :param _builtins.str instance_template_name: Output only. The name of the Instance Template used for the Managed Instance Group.
        """
        if instance_group_manager_name is not None:
            pulumi.set(__self__, "instance_group_manager_name", instance_group_manager_name)
        if instance_template_name is not None:
            pulumi.set(__self__, "instance_template_name", instance_template_name)

    @_builtins.property
    @pulumi.getter(name="instanceGroupManagerName")
    def instance_group_manager_name(self) -> Optional[_builtins.str]:
        """
        Output only. The name of the Instance Group Manager for this group.
        """
        return pulumi.get(self, "instance_group_manager_name")

    @_builtins.property
    @pulumi.getter(name="instanceTemplateName")
    def instance_template_name(self) -> Optional[_builtins.str]:
        """
        Output only. The name of the Instance Template used for the Managed Instance Group.
        """
        return pulumi.get(self, "instance_template_name")


@pulumi.output_type
class WorkflowTemplatePlacementManagedClusterConfigMetastoreConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataprocMetastoreService":
            suggest = "dataproc_metastore_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementManagedClusterConfigMetastoreConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigMetastoreConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigMetastoreConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataproc_metastore_service: _builtins.str):
        """
        :param _builtins.str dataproc_metastore_service: Required. Resource name of an existing Dataproc Metastore service. Example: * `projects/`
        """
        pulumi.set(__self__, "dataproc_metastore_service", dataproc_metastore_service)

    @_builtins.property
    @pulumi.getter(name="dataprocMetastoreService")
    def dataproc_metastore_service(self) -> _builtins.str:
        """
        Required. Resource name of an existing Dataproc Metastore service. Example: * `projects/`
        """
        return pulumi.get(self, "dataproc_metastore_service")


@pulumi.output_type
class WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskConfig":
            suggest = "disk_config"
        elif key == "instanceNames":
            suggest = "instance_names"
        elif key == "isPreemptible":
            suggest = "is_preemptible"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "managedGroupConfigs":
            suggest = "managed_group_configs"
        elif key == "minCpuPlatform":
            suggest = "min_cpu_platform"
        elif key == "numInstances":
            suggest = "num_instances"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerators: Optional[Sequence['outputs.WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerator']] = None,
                 disk_config: Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig'] = None,
                 image: Optional[_builtins.str] = None,
                 instance_names: Optional[Sequence[_builtins.str]] = None,
                 is_preemptible: Optional[_builtins.bool] = None,
                 machine_type: Optional[_builtins.str] = None,
                 managed_group_configs: Optional[Sequence['outputs.WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfig']] = None,
                 min_cpu_platform: Optional[_builtins.str] = None,
                 num_instances: Optional[_builtins.int] = None,
                 preemptibility: Optional[_builtins.str] = None):
        """
        :param Sequence['WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAcceleratorArgs'] accelerators: Optional. The Compute Engine accelerator configuration for these instances.
        :param 'WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfigArgs' disk_config: Optional. Disk option config settings.
        :param _builtins.str image: Optional. The Compute Engine image resource used for cluster instances. The URI can represent an image or image family. Image examples: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id]` * `projects/[project_id]/global/images/[image-id]` * `image-id` Image family examples. Dataproc will use the most recent image from the family: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name]` * `projects/[project_id]/global/images/family/[custom-image-family-name]` If the URI is unspecified, it will be inferred from `SoftwareConfig.image_version` or the system default.
        :param Sequence[_builtins.str] instance_names: Output only. The list of instance names. Dataproc derives the names from `cluster_name`, `num_instances`, and the instance group.
        :param _builtins.bool is_preemptible: Output only. Specifies that this instance group contains preemptible instances.
        :param _builtins.str machine_type: Optional. The Compute Engine machine type used for cluster instances. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `n1-standard-2` **Auto Zone Exception**: If you are using the Dataproc [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, `n1-standard-2`.
        :param Sequence['WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfigArgs'] managed_group_configs: Output only. The config for Compute Engine Instance Group Manager that manages this group. This is only used for preemptible instance groups.
        :param _builtins.str min_cpu_platform: Optional. Specifies the minimum cpu platform for the Instance Group. See [Dataproc > Minimum CPU Platform](https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
        :param _builtins.int num_instances: Optional. The number of VM instances in the instance group. For [HA cluster](https://www.terraform.io/dataproc/docs/concepts/configuring-clusters/high-availability) master_config groups, **must be set to 3**. For standard cluster master_config groups, **must be set to 1**.
        :param _builtins.str preemptibility: Optional. Specifies the preemptibility of the instance group. The default value for master and worker groups is `NON_PREEMPTIBLE`. This default cannot be changed. The default value for secondary instances is `PREEMPTIBLE`. Possible values: PREEMPTIBILITY_UNSPECIFIED, NON_PREEMPTIBLE, PREEMPTIBLE
        """
        if accelerators is not None:
            pulumi.set(__self__, "accelerators", accelerators)
        if disk_config is not None:
            pulumi.set(__self__, "disk_config", disk_config)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if instance_names is not None:
            pulumi.set(__self__, "instance_names", instance_names)
        if is_preemptible is not None:
            pulumi.set(__self__, "is_preemptible", is_preemptible)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if managed_group_configs is not None:
            pulumi.set(__self__, "managed_group_configs", managed_group_configs)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if num_instances is not None:
            pulumi.set(__self__, "num_instances", num_instances)
        if preemptibility is not None:
            pulumi.set(__self__, "preemptibility", preemptibility)

    @_builtins.property
    @pulumi.getter
    def accelerators(self) -> Optional[Sequence['outputs.WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerator']]:
        """
        Optional. The Compute Engine accelerator configuration for these instances.
        """
        return pulumi.get(self, "accelerators")

    @_builtins.property
    @pulumi.getter(name="diskConfig")
    def disk_config(self) -> Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig']:
        """
        Optional. Disk option config settings.
        """
        return pulumi.get(self, "disk_config")

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[_builtins.str]:
        """
        Optional. The Compute Engine image resource used for cluster instances. The URI can represent an image or image family. Image examples: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id]` * `projects/[project_id]/global/images/[image-id]` * `image-id` Image family examples. Dataproc will use the most recent image from the family: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name]` * `projects/[project_id]/global/images/family/[custom-image-family-name]` If the URI is unspecified, it will be inferred from `SoftwareConfig.image_version` or the system default.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter(name="instanceNames")
    def instance_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        Output only. The list of instance names. Dataproc derives the names from `cluster_name`, `num_instances`, and the instance group.
        """
        return pulumi.get(self, "instance_names")

    @_builtins.property
    @pulumi.getter(name="isPreemptible")
    def is_preemptible(self) -> Optional[_builtins.bool]:
        """
        Output only. Specifies that this instance group contains preemptible instances.
        """
        return pulumi.get(self, "is_preemptible")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[_builtins.str]:
        """
        Optional. The Compute Engine machine type used for cluster instances. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `n1-standard-2` **Auto Zone Exception**: If you are using the Dataproc [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, `n1-standard-2`.
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter(name="managedGroupConfigs")
    def managed_group_configs(self) -> Optional[Sequence['outputs.WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfig']]:
        """
        Output only. The config for Compute Engine Instance Group Manager that manages this group. This is only used for preemptible instance groups.
        """
        return pulumi.get(self, "managed_group_configs")

    @_builtins.property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[_builtins.str]:
        """
        Optional. Specifies the minimum cpu platform for the Instance Group. See [Dataproc > Minimum CPU Platform](https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
        """
        return pulumi.get(self, "min_cpu_platform")

    @_builtins.property
    @pulumi.getter(name="numInstances")
    def num_instances(self) -> Optional[_builtins.int]:
        """
        Optional. The number of VM instances in the instance group. For [HA cluster](https://www.terraform.io/dataproc/docs/concepts/configuring-clusters/high-availability) master_config groups, **must be set to 3**. For standard cluster master_config groups, **must be set to 1**.
        """
        return pulumi.get(self, "num_instances")

    @_builtins.property
    @pulumi.getter
    def preemptibility(self) -> Optional[_builtins.str]:
        """
        Optional. Specifies the preemptibility of the instance group. The default value for master and worker groups is `NON_PREEMPTIBLE`. This default cannot be changed. The default value for secondary instances is `PREEMPTIBLE`. Possible values: PREEMPTIBILITY_UNSPECIFIED, NON_PREEMPTIBLE, PREEMPTIBLE
        """
        return pulumi.get(self, "preemptibility")


@pulumi.output_type
class WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerator(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceleratorCount":
            suggest = "accelerator_count"
        elif key == "acceleratorType":
            suggest = "accelerator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerator. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerator.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerator.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerator_count: Optional[_builtins.int] = None,
                 accelerator_type: Optional[_builtins.str] = None):
        """
        :param _builtins.int accelerator_count: The number of the accelerator cards of this type exposed to this instance.
        :param _builtins.str accelerator_type: Full URL, partial URI, or short name of the accelerator type resource to expose to this instance. See (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, `nvidia-tesla-k80`.
        """
        if accelerator_count is not None:
            pulumi.set(__self__, "accelerator_count", accelerator_count)
        if accelerator_type is not None:
            pulumi.set(__self__, "accelerator_type", accelerator_type)

    @_builtins.property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> Optional[_builtins.int]:
        """
        The number of the accelerator cards of this type exposed to this instance.
        """
        return pulumi.get(self, "accelerator_count")

    @_builtins.property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> Optional[_builtins.str]:
        """
        Full URL, partial URI, or short name of the accelerator type resource to expose to this instance. See (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, `nvidia-tesla-k80`.
        """
        return pulumi.get(self, "accelerator_type")


@pulumi.output_type
class WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootDiskSizeGb":
            suggest = "boot_disk_size_gb"
        elif key == "bootDiskType":
            suggest = "boot_disk_type"
        elif key == "numLocalSsds":
            suggest = "num_local_ssds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot_disk_size_gb: Optional[_builtins.int] = None,
                 boot_disk_type: Optional[_builtins.str] = None,
                 num_local_ssds: Optional[_builtins.int] = None):
        """
        :param _builtins.int boot_disk_size_gb: Size in GB of the boot disk (default is 500GB).
        :param _builtins.str boot_disk_type: Type of the boot disk (default is "pd-standard"). Valid values: "pd-ssd" (Persistent Disk Solid State Drive) or "pd-standard" (Persistent Disk Hard Disk Drive).
        :param _builtins.int num_local_ssds: Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and (https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
        """
        if boot_disk_size_gb is not None:
            pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        if boot_disk_type is not None:
            pulumi.set(__self__, "boot_disk_type", boot_disk_type)
        if num_local_ssds is not None:
            pulumi.set(__self__, "num_local_ssds", num_local_ssds)

    @_builtins.property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> Optional[_builtins.int]:
        """
        Size in GB of the boot disk (default is 500GB).
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @_builtins.property
    @pulumi.getter(name="bootDiskType")
    def boot_disk_type(self) -> Optional[_builtins.str]:
        """
        Type of the boot disk (default is "pd-standard"). Valid values: "pd-ssd" (Persistent Disk Solid State Drive) or "pd-standard" (Persistent Disk Hard Disk Drive).
        """
        return pulumi.get(self, "boot_disk_type")

    @_builtins.property
    @pulumi.getter(name="numLocalSsds")
    def num_local_ssds(self) -> Optional[_builtins.int]:
        """
        Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and (https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
        """
        return pulumi.get(self, "num_local_ssds")


@pulumi.output_type
class WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceGroupManagerName":
            suggest = "instance_group_manager_name"
        elif key == "instanceTemplateName":
            suggest = "instance_template_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_group_manager_name: Optional[_builtins.str] = None,
                 instance_template_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str instance_group_manager_name: Output only. The name of the Instance Group Manager for this group.
        :param _builtins.str instance_template_name: Output only. The name of the Instance Template used for the Managed Instance Group.
        """
        if instance_group_manager_name is not None:
            pulumi.set(__self__, "instance_group_manager_name", instance_group_manager_name)
        if instance_template_name is not None:
            pulumi.set(__self__, "instance_template_name", instance_template_name)

    @_builtins.property
    @pulumi.getter(name="instanceGroupManagerName")
    def instance_group_manager_name(self) -> Optional[_builtins.str]:
        """
        Output only. The name of the Instance Group Manager for this group.
        """
        return pulumi.get(self, "instance_group_manager_name")

    @_builtins.property
    @pulumi.getter(name="instanceTemplateName")
    def instance_template_name(self) -> Optional[_builtins.str]:
        """
        Output only. The name of the Instance Template used for the Managed Instance Group.
        """
        return pulumi.get(self, "instance_template_name")


@pulumi.output_type
class WorkflowTemplatePlacementManagedClusterConfigSecurityConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kerberosConfig":
            suggest = "kerberos_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementManagedClusterConfigSecurityConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigSecurityConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigSecurityConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kerberos_config: Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig'] = None):
        """
        :param 'WorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfigArgs' kerberos_config: Kerberos related configuration.
        """
        if kerberos_config is not None:
            pulumi.set(__self__, "kerberos_config", kerberos_config)

    @_builtins.property
    @pulumi.getter(name="kerberosConfig")
    def kerberos_config(self) -> Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig']:
        """
        Kerberos related configuration.
        """
        return pulumi.get(self, "kerberos_config")


@pulumi.output_type
class WorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "crossRealmTrustAdminServer":
            suggest = "cross_realm_trust_admin_server"
        elif key == "crossRealmTrustKdc":
            suggest = "cross_realm_trust_kdc"
        elif key == "crossRealmTrustRealm":
            suggest = "cross_realm_trust_realm"
        elif key == "crossRealmTrustSharedPassword":
            suggest = "cross_realm_trust_shared_password"
        elif key == "enableKerberos":
            suggest = "enable_kerberos"
        elif key == "kdcDbKey":
            suggest = "kdc_db_key"
        elif key == "keyPassword":
            suggest = "key_password"
        elif key == "keystorePassword":
            suggest = "keystore_password"
        elif key == "kmsKey":
            suggest = "kms_key"
        elif key == "rootPrincipalPassword":
            suggest = "root_principal_password"
        elif key == "tgtLifetimeHours":
            suggest = "tgt_lifetime_hours"
        elif key == "truststorePassword":
            suggest = "truststore_password"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cross_realm_trust_admin_server: Optional[_builtins.str] = None,
                 cross_realm_trust_kdc: Optional[_builtins.str] = None,
                 cross_realm_trust_realm: Optional[_builtins.str] = None,
                 cross_realm_trust_shared_password: Optional[_builtins.str] = None,
                 enable_kerberos: Optional[_builtins.bool] = None,
                 kdc_db_key: Optional[_builtins.str] = None,
                 key_password: Optional[_builtins.str] = None,
                 keystore: Optional[_builtins.str] = None,
                 keystore_password: Optional[_builtins.str] = None,
                 kms_key: Optional[_builtins.str] = None,
                 realm: Optional[_builtins.str] = None,
                 root_principal_password: Optional[_builtins.str] = None,
                 tgt_lifetime_hours: Optional[_builtins.int] = None,
                 truststore: Optional[_builtins.str] = None,
                 truststore_password: Optional[_builtins.str] = None):
        """
        :param _builtins.str cross_realm_trust_admin_server: The admin server (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
        :param _builtins.str cross_realm_trust_kdc: The KDC (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
        :param _builtins.str cross_realm_trust_realm: The remote realm the Dataproc on-cluster KDC will trust, should the user enable cross realm trust.
        :param _builtins.str cross_realm_trust_shared_password: The Cloud Storage URI of a KMS encrypted file containing the shared password between the on-cluster Kerberos realm and the remote trusted realm, in a cross realm trust relationship.
        :param _builtins.bool enable_kerberos: Flag to indicate whether to Kerberize the cluster (default: false). Set this field to true to enable Kerberos on a cluster.
        :param _builtins.str kdc_db_key: The Cloud Storage URI of a KMS encrypted file containing the master key of the KDC database.
        :param _builtins.str key_password: The Cloud Storage URI of a KMS encrypted file containing the password to the user provided key. For the self-signed certificate, this password is generated by Dataproc.
        :param _builtins.str keystore: The Cloud Storage URI of the keystore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
        :param _builtins.str keystore_password: The Cloud Storage URI of a KMS encrypted file containing the password to the user provided keystore. For the self-signed certificate, this password is generated by Dataproc.
        :param _builtins.str kms_key: The uri of the KMS key used to encrypt various sensitive files.
        :param _builtins.str realm: The name of the on-cluster Kerberos realm. If not specified, the uppercased domain of hostnames will be the realm.
        :param _builtins.str root_principal_password: The Cloud Storage URI of a KMS encrypted file containing the root principal password.
        :param _builtins.int tgt_lifetime_hours: The lifetime of the ticket granting ticket, in hours. If not specified, or user specifies 0, then default value 10 will be used.
        :param _builtins.str truststore: The Cloud Storage URI of the truststore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
        :param _builtins.str truststore_password: The Cloud Storage URI of a KMS encrypted file containing the password to the user provided truststore. For the self-signed certificate, this password is generated by Dataproc.
        """
        if cross_realm_trust_admin_server is not None:
            pulumi.set(__self__, "cross_realm_trust_admin_server", cross_realm_trust_admin_server)
        if cross_realm_trust_kdc is not None:
            pulumi.set(__self__, "cross_realm_trust_kdc", cross_realm_trust_kdc)
        if cross_realm_trust_realm is not None:
            pulumi.set(__self__, "cross_realm_trust_realm", cross_realm_trust_realm)
        if cross_realm_trust_shared_password is not None:
            pulumi.set(__self__, "cross_realm_trust_shared_password", cross_realm_trust_shared_password)
        if enable_kerberos is not None:
            pulumi.set(__self__, "enable_kerberos", enable_kerberos)
        if kdc_db_key is not None:
            pulumi.set(__self__, "kdc_db_key", kdc_db_key)
        if key_password is not None:
            pulumi.set(__self__, "key_password", key_password)
        if keystore is not None:
            pulumi.set(__self__, "keystore", keystore)
        if keystore_password is not None:
            pulumi.set(__self__, "keystore_password", keystore_password)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if realm is not None:
            pulumi.set(__self__, "realm", realm)
        if root_principal_password is not None:
            pulumi.set(__self__, "root_principal_password", root_principal_password)
        if tgt_lifetime_hours is not None:
            pulumi.set(__self__, "tgt_lifetime_hours", tgt_lifetime_hours)
        if truststore is not None:
            pulumi.set(__self__, "truststore", truststore)
        if truststore_password is not None:
            pulumi.set(__self__, "truststore_password", truststore_password)

    @_builtins.property
    @pulumi.getter(name="crossRealmTrustAdminServer")
    def cross_realm_trust_admin_server(self) -> Optional[_builtins.str]:
        """
        The admin server (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
        """
        return pulumi.get(self, "cross_realm_trust_admin_server")

    @_builtins.property
    @pulumi.getter(name="crossRealmTrustKdc")
    def cross_realm_trust_kdc(self) -> Optional[_builtins.str]:
        """
        The KDC (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
        """
        return pulumi.get(self, "cross_realm_trust_kdc")

    @_builtins.property
    @pulumi.getter(name="crossRealmTrustRealm")
    def cross_realm_trust_realm(self) -> Optional[_builtins.str]:
        """
        The remote realm the Dataproc on-cluster KDC will trust, should the user enable cross realm trust.
        """
        return pulumi.get(self, "cross_realm_trust_realm")

    @_builtins.property
    @pulumi.getter(name="crossRealmTrustSharedPassword")
    def cross_realm_trust_shared_password(self) -> Optional[_builtins.str]:
        """
        The Cloud Storage URI of a KMS encrypted file containing the shared password between the on-cluster Kerberos realm and the remote trusted realm, in a cross realm trust relationship.
        """
        return pulumi.get(self, "cross_realm_trust_shared_password")

    @_builtins.property
    @pulumi.getter(name="enableKerberos")
    def enable_kerberos(self) -> Optional[_builtins.bool]:
        """
        Flag to indicate whether to Kerberize the cluster (default: false). Set this field to true to enable Kerberos on a cluster.
        """
        return pulumi.get(self, "enable_kerberos")

    @_builtins.property
    @pulumi.getter(name="kdcDbKey")
    def kdc_db_key(self) -> Optional[_builtins.str]:
        """
        The Cloud Storage URI of a KMS encrypted file containing the master key of the KDC database.
        """
        return pulumi.get(self, "kdc_db_key")

    @_builtins.property
    @pulumi.getter(name="keyPassword")
    def key_password(self) -> Optional[_builtins.str]:
        """
        The Cloud Storage URI of a KMS encrypted file containing the password to the user provided key. For the self-signed certificate, this password is generated by Dataproc.
        """
        return pulumi.get(self, "key_password")

    @_builtins.property
    @pulumi.getter
    def keystore(self) -> Optional[_builtins.str]:
        """
        The Cloud Storage URI of the keystore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
        """
        return pulumi.get(self, "keystore")

    @_builtins.property
    @pulumi.getter(name="keystorePassword")
    def keystore_password(self) -> Optional[_builtins.str]:
        """
        The Cloud Storage URI of a KMS encrypted file containing the password to the user provided keystore. For the self-signed certificate, this password is generated by Dataproc.
        """
        return pulumi.get(self, "keystore_password")

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[_builtins.str]:
        """
        The uri of the KMS key used to encrypt various sensitive files.
        """
        return pulumi.get(self, "kms_key")

    @_builtins.property
    @pulumi.getter
    def realm(self) -> Optional[_builtins.str]:
        """
        The name of the on-cluster Kerberos realm. If not specified, the uppercased domain of hostnames will be the realm.
        """
        return pulumi.get(self, "realm")

    @_builtins.property
    @pulumi.getter(name="rootPrincipalPassword")
    def root_principal_password(self) -> Optional[_builtins.str]:
        """
        The Cloud Storage URI of a KMS encrypted file containing the root principal password.
        """
        return pulumi.get(self, "root_principal_password")

    @_builtins.property
    @pulumi.getter(name="tgtLifetimeHours")
    def tgt_lifetime_hours(self) -> Optional[_builtins.int]:
        """
        The lifetime of the ticket granting ticket, in hours. If not specified, or user specifies 0, then default value 10 will be used.
        """
        return pulumi.get(self, "tgt_lifetime_hours")

    @_builtins.property
    @pulumi.getter
    def truststore(self) -> Optional[_builtins.str]:
        """
        The Cloud Storage URI of the truststore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
        """
        return pulumi.get(self, "truststore")

    @_builtins.property
    @pulumi.getter(name="truststorePassword")
    def truststore_password(self) -> Optional[_builtins.str]:
        """
        The Cloud Storage URI of a KMS encrypted file containing the password to the user provided truststore. For the self-signed certificate, this password is generated by Dataproc.
        """
        return pulumi.get(self, "truststore_password")


@pulumi.output_type
class WorkflowTemplatePlacementManagedClusterConfigSoftwareConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageVersion":
            suggest = "image_version"
        elif key == "optionalComponents":
            suggest = "optional_components"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementManagedClusterConfigSoftwareConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigSoftwareConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigSoftwareConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_version: Optional[_builtins.str] = None,
                 optional_components: Optional[Sequence[_builtins.str]] = None,
                 properties: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str image_version: The version of software inside the cluster. It must be one of the supported [Dataproc Versions](https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#supported_dataproc_versions), such as "1.2" (including a subminor version, such as "1.2.29"), or the ["preview" version](https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#other_versions). If unspecified, it defaults to the latest Debian version.
        :param Sequence[_builtins.str] optional_components: The set of components to activate on the cluster.
        :param Mapping[str, _builtins.str] properties: The properties to set on daemon config files.
               
               Property keys are specified in `prefix:property` format, for example `core:hadoop.tmp.dir`. The following are supported prefixes and their mappings:
               
               * capacity-scheduler: `capacity-scheduler.xml`
               * core: `core-site.xml`
               * distcp: `distcp-default.xml`
               * hdfs: `hdfs-site.xml`
               * hive: `hive-site.xml`
               * mapred: `mapred-site.xml`
               * pig: `pig.properties`
               * spark: `spark-defaults.conf`
               * yarn: `yarn-site.xml`
               
               
               For more information, see [Cluster properties](https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        """
        if image_version is not None:
            pulumi.set(__self__, "image_version", image_version)
        if optional_components is not None:
            pulumi.set(__self__, "optional_components", optional_components)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @_builtins.property
    @pulumi.getter(name="imageVersion")
    def image_version(self) -> Optional[_builtins.str]:
        """
        The version of software inside the cluster. It must be one of the supported [Dataproc Versions](https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#supported_dataproc_versions), such as "1.2" (including a subminor version, such as "1.2.29"), or the ["preview" version](https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#other_versions). If unspecified, it defaults to the latest Debian version.
        """
        return pulumi.get(self, "image_version")

    @_builtins.property
    @pulumi.getter(name="optionalComponents")
    def optional_components(self) -> Optional[Sequence[_builtins.str]]:
        """
        The set of components to activate on the cluster.
        """
        return pulumi.get(self, "optional_components")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The properties to set on daemon config files.

        Property keys are specified in `prefix:property` format, for example `core:hadoop.tmp.dir`. The following are supported prefixes and their mappings:

        * capacity-scheduler: `capacity-scheduler.xml`
        * core: `core-site.xml`
        * distcp: `distcp-default.xml`
        * hdfs: `hdfs-site.xml`
        * hive: `hive-site.xml`
        * mapred: `mapred-site.xml`
        * pig: `pig.properties`
        * spark: `spark-defaults.conf`
        * yarn: `yarn-site.xml`


        For more information, see [Cluster properties](https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class WorkflowTemplatePlacementManagedClusterConfigWorkerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskConfig":
            suggest = "disk_config"
        elif key == "instanceNames":
            suggest = "instance_names"
        elif key == "isPreemptible":
            suggest = "is_preemptible"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "managedGroupConfigs":
            suggest = "managed_group_configs"
        elif key == "minCpuPlatform":
            suggest = "min_cpu_platform"
        elif key == "numInstances":
            suggest = "num_instances"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementManagedClusterConfigWorkerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigWorkerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigWorkerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerators: Optional[Sequence['outputs.WorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerator']] = None,
                 disk_config: Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig'] = None,
                 image: Optional[_builtins.str] = None,
                 instance_names: Optional[Sequence[_builtins.str]] = None,
                 is_preemptible: Optional[_builtins.bool] = None,
                 machine_type: Optional[_builtins.str] = None,
                 managed_group_configs: Optional[Sequence['outputs.WorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfig']] = None,
                 min_cpu_platform: Optional[_builtins.str] = None,
                 num_instances: Optional[_builtins.int] = None,
                 preemptibility: Optional[_builtins.str] = None):
        """
        :param Sequence['WorkflowTemplatePlacementManagedClusterConfigWorkerConfigAcceleratorArgs'] accelerators: Optional. The Compute Engine accelerator configuration for these instances.
        :param 'WorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfigArgs' disk_config: Optional. Disk option config settings.
        :param _builtins.str image: Optional. The Compute Engine image resource used for cluster instances. The URI can represent an image or image family. Image examples: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id]` * `projects/[project_id]/global/images/[image-id]` * `image-id` Image family examples. Dataproc will use the most recent image from the family: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name]` * `projects/[project_id]/global/images/family/[custom-image-family-name]` If the URI is unspecified, it will be inferred from `SoftwareConfig.image_version` or the system default.
        :param Sequence[_builtins.str] instance_names: Output only. The list of instance names. Dataproc derives the names from `cluster_name`, `num_instances`, and the instance group.
        :param _builtins.bool is_preemptible: Output only. Specifies that this instance group contains preemptible instances.
        :param _builtins.str machine_type: Optional. The Compute Engine machine type used for cluster instances. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `n1-standard-2` **Auto Zone Exception**: If you are using the Dataproc [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, `n1-standard-2`.
        :param Sequence['WorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfigArgs'] managed_group_configs: Output only. The config for Compute Engine Instance Group Manager that manages this group. This is only used for preemptible instance groups.
        :param _builtins.str min_cpu_platform: Optional. Specifies the minimum cpu platform for the Instance Group. See [Dataproc > Minimum CPU Platform](https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
        :param _builtins.int num_instances: Optional. The number of VM instances in the instance group. For [HA cluster](https://www.terraform.io/dataproc/docs/concepts/configuring-clusters/high-availability) master_config groups, **must be set to 3**. For standard cluster master_config groups, **must be set to 1**.
        :param _builtins.str preemptibility: Optional. Specifies the preemptibility of the instance group. The default value for master and worker groups is `NON_PREEMPTIBLE`. This default cannot be changed. The default value for secondary instances is `PREEMPTIBLE`. Possible values: PREEMPTIBILITY_UNSPECIFIED, NON_PREEMPTIBLE, PREEMPTIBLE
        """
        if accelerators is not None:
            pulumi.set(__self__, "accelerators", accelerators)
        if disk_config is not None:
            pulumi.set(__self__, "disk_config", disk_config)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if instance_names is not None:
            pulumi.set(__self__, "instance_names", instance_names)
        if is_preemptible is not None:
            pulumi.set(__self__, "is_preemptible", is_preemptible)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if managed_group_configs is not None:
            pulumi.set(__self__, "managed_group_configs", managed_group_configs)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if num_instances is not None:
            pulumi.set(__self__, "num_instances", num_instances)
        if preemptibility is not None:
            pulumi.set(__self__, "preemptibility", preemptibility)

    @_builtins.property
    @pulumi.getter
    def accelerators(self) -> Optional[Sequence['outputs.WorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerator']]:
        """
        Optional. The Compute Engine accelerator configuration for these instances.
        """
        return pulumi.get(self, "accelerators")

    @_builtins.property
    @pulumi.getter(name="diskConfig")
    def disk_config(self) -> Optional['outputs.WorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig']:
        """
        Optional. Disk option config settings.
        """
        return pulumi.get(self, "disk_config")

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[_builtins.str]:
        """
        Optional. The Compute Engine image resource used for cluster instances. The URI can represent an image or image family. Image examples: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id]` * `projects/[project_id]/global/images/[image-id]` * `image-id` Image family examples. Dataproc will use the most recent image from the family: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name]` * `projects/[project_id]/global/images/family/[custom-image-family-name]` If the URI is unspecified, it will be inferred from `SoftwareConfig.image_version` or the system default.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter(name="instanceNames")
    def instance_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        Output only. The list of instance names. Dataproc derives the names from `cluster_name`, `num_instances`, and the instance group.
        """
        return pulumi.get(self, "instance_names")

    @_builtins.property
    @pulumi.getter(name="isPreemptible")
    def is_preemptible(self) -> Optional[_builtins.bool]:
        """
        Output only. Specifies that this instance group contains preemptible instances.
        """
        return pulumi.get(self, "is_preemptible")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[_builtins.str]:
        """
        Optional. The Compute Engine machine type used for cluster instances. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `n1-standard-2` **Auto Zone Exception**: If you are using the Dataproc [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, `n1-standard-2`.
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter(name="managedGroupConfigs")
    def managed_group_configs(self) -> Optional[Sequence['outputs.WorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfig']]:
        """
        Output only. The config for Compute Engine Instance Group Manager that manages this group. This is only used for preemptible instance groups.
        """
        return pulumi.get(self, "managed_group_configs")

    @_builtins.property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[_builtins.str]:
        """
        Optional. Specifies the minimum cpu platform for the Instance Group. See [Dataproc > Minimum CPU Platform](https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
        """
        return pulumi.get(self, "min_cpu_platform")

    @_builtins.property
    @pulumi.getter(name="numInstances")
    def num_instances(self) -> Optional[_builtins.int]:
        """
        Optional. The number of VM instances in the instance group. For [HA cluster](https://www.terraform.io/dataproc/docs/concepts/configuring-clusters/high-availability) master_config groups, **must be set to 3**. For standard cluster master_config groups, **must be set to 1**.
        """
        return pulumi.get(self, "num_instances")

    @_builtins.property
    @pulumi.getter
    def preemptibility(self) -> Optional[_builtins.str]:
        """
        Optional. Specifies the preemptibility of the instance group. The default value for master and worker groups is `NON_PREEMPTIBLE`. This default cannot be changed. The default value for secondary instances is `PREEMPTIBLE`. Possible values: PREEMPTIBILITY_UNSPECIFIED, NON_PREEMPTIBLE, PREEMPTIBLE
        """
        return pulumi.get(self, "preemptibility")


@pulumi.output_type
class WorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerator(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceleratorCount":
            suggest = "accelerator_count"
        elif key == "acceleratorType":
            suggest = "accelerator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerator. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerator.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerator.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerator_count: Optional[_builtins.int] = None,
                 accelerator_type: Optional[_builtins.str] = None):
        """
        :param _builtins.int accelerator_count: The number of the accelerator cards of this type exposed to this instance.
        :param _builtins.str accelerator_type: Full URL, partial URI, or short name of the accelerator type resource to expose to this instance. See (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, `nvidia-tesla-k80`.
        """
        if accelerator_count is not None:
            pulumi.set(__self__, "accelerator_count", accelerator_count)
        if accelerator_type is not None:
            pulumi.set(__self__, "accelerator_type", accelerator_type)

    @_builtins.property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> Optional[_builtins.int]:
        """
        The number of the accelerator cards of this type exposed to this instance.
        """
        return pulumi.get(self, "accelerator_count")

    @_builtins.property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> Optional[_builtins.str]:
        """
        Full URL, partial URI, or short name of the accelerator type resource to expose to this instance. See (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, `nvidia-tesla-k80`.
        """
        return pulumi.get(self, "accelerator_type")


@pulumi.output_type
class WorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootDiskSizeGb":
            suggest = "boot_disk_size_gb"
        elif key == "bootDiskType":
            suggest = "boot_disk_type"
        elif key == "numLocalSsds":
            suggest = "num_local_ssds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot_disk_size_gb: Optional[_builtins.int] = None,
                 boot_disk_type: Optional[_builtins.str] = None,
                 num_local_ssds: Optional[_builtins.int] = None):
        """
        :param _builtins.int boot_disk_size_gb: Size in GB of the boot disk (default is 500GB).
        :param _builtins.str boot_disk_type: Type of the boot disk (default is "pd-standard"). Valid values: "pd-ssd" (Persistent Disk Solid State Drive) or "pd-standard" (Persistent Disk Hard Disk Drive).
        :param _builtins.int num_local_ssds: Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and (https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
        """
        if boot_disk_size_gb is not None:
            pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        if boot_disk_type is not None:
            pulumi.set(__self__, "boot_disk_type", boot_disk_type)
        if num_local_ssds is not None:
            pulumi.set(__self__, "num_local_ssds", num_local_ssds)

    @_builtins.property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> Optional[_builtins.int]:
        """
        Size in GB of the boot disk (default is 500GB).
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @_builtins.property
    @pulumi.getter(name="bootDiskType")
    def boot_disk_type(self) -> Optional[_builtins.str]:
        """
        Type of the boot disk (default is "pd-standard"). Valid values: "pd-ssd" (Persistent Disk Solid State Drive) or "pd-standard" (Persistent Disk Hard Disk Drive).
        """
        return pulumi.get(self, "boot_disk_type")

    @_builtins.property
    @pulumi.getter(name="numLocalSsds")
    def num_local_ssds(self) -> Optional[_builtins.int]:
        """
        Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and (https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
        """
        return pulumi.get(self, "num_local_ssds")


@pulumi.output_type
class WorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceGroupManagerName":
            suggest = "instance_group_manager_name"
        elif key == "instanceTemplateName":
            suggest = "instance_template_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_group_manager_name: Optional[_builtins.str] = None,
                 instance_template_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str instance_group_manager_name: Output only. The name of the Instance Group Manager for this group.
        :param _builtins.str instance_template_name: Output only. The name of the Instance Template used for the Managed Instance Group.
        """
        if instance_group_manager_name is not None:
            pulumi.set(__self__, "instance_group_manager_name", instance_group_manager_name)
        if instance_template_name is not None:
            pulumi.set(__self__, "instance_template_name", instance_template_name)

    @_builtins.property
    @pulumi.getter(name="instanceGroupManagerName")
    def instance_group_manager_name(self) -> Optional[_builtins.str]:
        """
        Output only. The name of the Instance Group Manager for this group.
        """
        return pulumi.get(self, "instance_group_manager_name")

    @_builtins.property
    @pulumi.getter(name="instanceTemplateName")
    def instance_template_name(self) -> Optional[_builtins.str]:
        """
        Output only. The name of the Instance Template used for the Managed Instance Group.
        """
        return pulumi.get(self, "instance_template_name")


@pulumi.output_type
class GetMetastoreServiceEncryptionConfigResult(dict):
    def __init__(__self__, *,
                 kms_key: _builtins.str):
        """
        :param _builtins.str kms_key: The fully qualified customer provided Cloud KMS key name to use for customer data encryption.
               Use the following format: 'projects/([^/]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+)'
        """
        pulumi.set(__self__, "kms_key", kms_key)

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> _builtins.str:
        """
        The fully qualified customer provided Cloud KMS key name to use for customer data encryption.
        Use the following format: 'projects/([^/]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+)'
        """
        return pulumi.get(self, "kms_key")


@pulumi.output_type
class GetMetastoreServiceHiveMetastoreConfigResult(dict):
    def __init__(__self__, *,
                 auxiliary_versions: Sequence['outputs.GetMetastoreServiceHiveMetastoreConfigAuxiliaryVersionResult'],
                 config_overrides: Mapping[str, _builtins.str],
                 endpoint_protocol: _builtins.str,
                 kerberos_configs: Sequence['outputs.GetMetastoreServiceHiveMetastoreConfigKerberosConfigResult'],
                 version: _builtins.str):
        """
        :param Sequence['GetMetastoreServiceHiveMetastoreConfigAuxiliaryVersionArgs'] auxiliary_versions: A mapping of Hive metastore version to the auxiliary version configuration.
               When specified, a secondary Hive metastore service is created along with the primary service.
               All auxiliary versions must be less than the service's primary version.
               The key is the auxiliary service name and it must match the regular expression a-z?.
               This means that the first character must be a lowercase letter, and all the following characters must be hyphens, lowercase letters, or digits, except the last character, which cannot be a hyphen.
        :param Mapping[str, _builtins.str] config_overrides: A mapping of Hive metastore configuration key-value pairs to apply to the Hive metastore (configured in hive-site.xml).
               The mappings override system defaults (some keys cannot be overridden)
        :param _builtins.str endpoint_protocol: The protocol to use for the metastore service endpoint. If unspecified, defaults to 'THRIFT'. Default value: "THRIFT" Possible values: ["THRIFT", "GRPC"]
        :param Sequence['GetMetastoreServiceHiveMetastoreConfigKerberosConfigArgs'] kerberos_configs: Information used to configure the Hive metastore service as a service principal in a Kerberos realm.
        :param _builtins.str version: The Hive metastore schema version.
        """
        pulumi.set(__self__, "auxiliary_versions", auxiliary_versions)
        pulumi.set(__self__, "config_overrides", config_overrides)
        pulumi.set(__self__, "endpoint_protocol", endpoint_protocol)
        pulumi.set(__self__, "kerberos_configs", kerberos_configs)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="auxiliaryVersions")
    def auxiliary_versions(self) -> Sequence['outputs.GetMetastoreServiceHiveMetastoreConfigAuxiliaryVersionResult']:
        """
        A mapping of Hive metastore version to the auxiliary version configuration.
        When specified, a secondary Hive metastore service is created along with the primary service.
        All auxiliary versions must be less than the service's primary version.
        The key is the auxiliary service name and it must match the regular expression a-z?.
        This means that the first character must be a lowercase letter, and all the following characters must be hyphens, lowercase letters, or digits, except the last character, which cannot be a hyphen.
        """
        return pulumi.get(self, "auxiliary_versions")

    @_builtins.property
    @pulumi.getter(name="configOverrides")
    def config_overrides(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of Hive metastore configuration key-value pairs to apply to the Hive metastore (configured in hive-site.xml).
        The mappings override system defaults (some keys cannot be overridden)
        """
        return pulumi.get(self, "config_overrides")

    @_builtins.property
    @pulumi.getter(name="endpointProtocol")
    def endpoint_protocol(self) -> _builtins.str:
        """
        The protocol to use for the metastore service endpoint. If unspecified, defaults to 'THRIFT'. Default value: "THRIFT" Possible values: ["THRIFT", "GRPC"]
        """
        return pulumi.get(self, "endpoint_protocol")

    @_builtins.property
    @pulumi.getter(name="kerberosConfigs")
    def kerberos_configs(self) -> Sequence['outputs.GetMetastoreServiceHiveMetastoreConfigKerberosConfigResult']:
        """
        Information used to configure the Hive metastore service as a service principal in a Kerberos realm.
        """
        return pulumi.get(self, "kerberos_configs")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The Hive metastore schema version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetMetastoreServiceHiveMetastoreConfigAuxiliaryVersionResult(dict):
    def __init__(__self__, *,
                 config_overrides: Mapping[str, _builtins.str],
                 key: _builtins.str,
                 version: _builtins.str):
        """
        :param Mapping[str, _builtins.str] config_overrides: A mapping of Hive metastore configuration key-value pairs to apply to the auxiliary Hive metastore (configured in hive-site.xml) in addition to the primary version's overrides.
               If keys are present in both the auxiliary version's overrides and the primary version's overrides, the value from the auxiliary version's overrides takes precedence.
        :param _builtins.str version: The Hive metastore version of the auxiliary service. It must be less than the primary Hive metastore service's version.
        """
        pulumi.set(__self__, "config_overrides", config_overrides)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="configOverrides")
    def config_overrides(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of Hive metastore configuration key-value pairs to apply to the auxiliary Hive metastore (configured in hive-site.xml) in addition to the primary version's overrides.
        If keys are present in both the auxiliary version's overrides and the primary version's overrides, the value from the auxiliary version's overrides takes precedence.
        """
        return pulumi.get(self, "config_overrides")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The Hive metastore version of the auxiliary service. It must be less than the primary Hive metastore service's version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetMetastoreServiceHiveMetastoreConfigKerberosConfigResult(dict):
    def __init__(__self__, *,
                 keytabs: Sequence['outputs.GetMetastoreServiceHiveMetastoreConfigKerberosConfigKeytabResult'],
                 krb5_config_gcs_uri: _builtins.str,
                 principal: _builtins.str):
        """
        :param Sequence['GetMetastoreServiceHiveMetastoreConfigKerberosConfigKeytabArgs'] keytabs: A Kerberos keytab file that can be used to authenticate a service principal with a Kerberos Key Distribution Center (KDC).
        :param _builtins.str krb5_config_gcs_uri: A Cloud Storage URI that specifies the path to a krb5.conf file. It is of the form gs://{bucket_name}/path/to/krb5.conf, although the file does not need to be named krb5.conf explicitly.
        :param _builtins.str principal: A Kerberos principal that exists in the both the keytab the KDC to authenticate as. A typical principal is of the form "primary/instance@REALM", but there is no exact format.
        """
        pulumi.set(__self__, "keytabs", keytabs)
        pulumi.set(__self__, "krb5_config_gcs_uri", krb5_config_gcs_uri)
        pulumi.set(__self__, "principal", principal)

    @_builtins.property
    @pulumi.getter
    def keytabs(self) -> Sequence['outputs.GetMetastoreServiceHiveMetastoreConfigKerberosConfigKeytabResult']:
        """
        A Kerberos keytab file that can be used to authenticate a service principal with a Kerberos Key Distribution Center (KDC).
        """
        return pulumi.get(self, "keytabs")

    @_builtins.property
    @pulumi.getter(name="krb5ConfigGcsUri")
    def krb5_config_gcs_uri(self) -> _builtins.str:
        """
        A Cloud Storage URI that specifies the path to a krb5.conf file. It is of the form gs://{bucket_name}/path/to/krb5.conf, although the file does not need to be named krb5.conf explicitly.
        """
        return pulumi.get(self, "krb5_config_gcs_uri")

    @_builtins.property
    @pulumi.getter
    def principal(self) -> _builtins.str:
        """
        A Kerberos principal that exists in the both the keytab the KDC to authenticate as. A typical principal is of the form "primary/instance@REALM", but there is no exact format.
        """
        return pulumi.get(self, "principal")


@pulumi.output_type
class GetMetastoreServiceHiveMetastoreConfigKerberosConfigKeytabResult(dict):
    def __init__(__self__, *,
                 cloud_secret: _builtins.str):
        """
        :param _builtins.str cloud_secret: The relative resource name of a Secret Manager secret version, in the following form:
               
               "projects/{projectNumber}/secrets/{secret_id}/versions/{version_id}".
        """
        pulumi.set(__self__, "cloud_secret", cloud_secret)

    @_builtins.property
    @pulumi.getter(name="cloudSecret")
    def cloud_secret(self) -> _builtins.str:
        """
        The relative resource name of a Secret Manager secret version, in the following form:

        "projects/{projectNumber}/secrets/{secret_id}/versions/{version_id}".
        """
        return pulumi.get(self, "cloud_secret")


@pulumi.output_type
class GetMetastoreServiceMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 day_of_week: _builtins.str,
                 hour_of_day: _builtins.int):
        """
        :param _builtins.str day_of_week: The day of week, when the window starts. Possible values: ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
        :param _builtins.int hour_of_day: The hour of day (0-23) when the window starts.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "hour_of_day", hour_of_day)

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> _builtins.str:
        """
        The day of week, when the window starts. Possible values: ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
        """
        return pulumi.get(self, "day_of_week")

    @_builtins.property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> _builtins.int:
        """
        The hour of day (0-23) when the window starts.
        """
        return pulumi.get(self, "hour_of_day")


@pulumi.output_type
class GetMetastoreServiceMetadataIntegrationResult(dict):
    def __init__(__self__, *,
                 data_catalog_configs: Sequence['outputs.GetMetastoreServiceMetadataIntegrationDataCatalogConfigResult']):
        """
        :param Sequence['GetMetastoreServiceMetadataIntegrationDataCatalogConfigArgs'] data_catalog_configs: The integration config for the Data Catalog service.
        """
        pulumi.set(__self__, "data_catalog_configs", data_catalog_configs)

    @_builtins.property
    @pulumi.getter(name="dataCatalogConfigs")
    def data_catalog_configs(self) -> Sequence['outputs.GetMetastoreServiceMetadataIntegrationDataCatalogConfigResult']:
        """
        The integration config for the Data Catalog service.
        """
        return pulumi.get(self, "data_catalog_configs")


@pulumi.output_type
class GetMetastoreServiceMetadataIntegrationDataCatalogConfigResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool):
        """
        :param _builtins.bool enabled: Defines whether the metastore metadata should be synced to Data Catalog. The default value is to disable syncing metastore metadata to Data Catalog.
        """
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Defines whether the metastore metadata should be synced to Data Catalog. The default value is to disable syncing metastore metadata to Data Catalog.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetMetastoreServiceNetworkConfigResult(dict):
    def __init__(__self__, *,
                 consumers: Sequence['outputs.GetMetastoreServiceNetworkConfigConsumerResult'],
                 custom_routes_enabled: _builtins.bool):
        """
        :param Sequence['GetMetastoreServiceNetworkConfigConsumerArgs'] consumers: The consumer-side network configuration for the Dataproc Metastore instance.
        :param _builtins.bool custom_routes_enabled: Enables custom routes to be imported and exported for the Dataproc Metastore service's peered VPC network.
        """
        pulumi.set(__self__, "consumers", consumers)
        pulumi.set(__self__, "custom_routes_enabled", custom_routes_enabled)

    @_builtins.property
    @pulumi.getter
    def consumers(self) -> Sequence['outputs.GetMetastoreServiceNetworkConfigConsumerResult']:
        """
        The consumer-side network configuration for the Dataproc Metastore instance.
        """
        return pulumi.get(self, "consumers")

    @_builtins.property
    @pulumi.getter(name="customRoutesEnabled")
    def custom_routes_enabled(self) -> _builtins.bool:
        """
        Enables custom routes to be imported and exported for the Dataproc Metastore service's peered VPC network.
        """
        return pulumi.get(self, "custom_routes_enabled")


@pulumi.output_type
class GetMetastoreServiceNetworkConfigConsumerResult(dict):
    def __init__(__self__, *,
                 endpoint_uri: _builtins.str,
                 subnetwork: _builtins.str):
        """
        :param _builtins.str endpoint_uri: The URI of the endpoint used to access the metastore service.
        :param _builtins.str subnetwork: The subnetwork of the customer project from which an IP address is reserved and used as the Dataproc Metastore service's endpoint.
               It is accessible to hosts in the subnet and to all hosts in a subnet in the same region and same network.
               There must be at least one IP address available in the subnet's primary range. The subnet is specified in the following form:
               'projects/{projectNumber}/regions/{region_id}/subnetworks/{subnetwork_id}
        """
        pulumi.set(__self__, "endpoint_uri", endpoint_uri)
        pulumi.set(__self__, "subnetwork", subnetwork)

    @_builtins.property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> _builtins.str:
        """
        The URI of the endpoint used to access the metastore service.
        """
        return pulumi.get(self, "endpoint_uri")

    @_builtins.property
    @pulumi.getter
    def subnetwork(self) -> _builtins.str:
        """
        The subnetwork of the customer project from which an IP address is reserved and used as the Dataproc Metastore service's endpoint.
        It is accessible to hosts in the subnet and to all hosts in a subnet in the same region and same network.
        There must be at least one IP address available in the subnet's primary range. The subnet is specified in the following form:
        'projects/{projectNumber}/regions/{region_id}/subnetworks/{subnetwork_id}
        """
        return pulumi.get(self, "subnetwork")


@pulumi.output_type
class GetMetastoreServiceScalingConfigResult(dict):
    def __init__(__self__, *,
                 autoscaling_configs: Sequence['outputs.GetMetastoreServiceScalingConfigAutoscalingConfigResult'],
                 instance_size: _builtins.str,
                 scaling_factor: _builtins.float):
        """
        :param Sequence['GetMetastoreServiceScalingConfigAutoscalingConfigArgs'] autoscaling_configs: Represents the autoscaling configuration of a metastore service.
        :param _builtins.str instance_size: Metastore instance sizes. Possible values: ["EXTRA_SMALL", "SMALL", "MEDIUM", "LARGE", "EXTRA_LARGE"]
        :param _builtins.float scaling_factor: Scaling factor, in increments of 0.1 for values less than 1.0, and increments of 1.0 for values greater than 1.0.
        """
        pulumi.set(__self__, "autoscaling_configs", autoscaling_configs)
        pulumi.set(__self__, "instance_size", instance_size)
        pulumi.set(__self__, "scaling_factor", scaling_factor)

    @_builtins.property
    @pulumi.getter(name="autoscalingConfigs")
    def autoscaling_configs(self) -> Sequence['outputs.GetMetastoreServiceScalingConfigAutoscalingConfigResult']:
        """
        Represents the autoscaling configuration of a metastore service.
        """
        return pulumi.get(self, "autoscaling_configs")

    @_builtins.property
    @pulumi.getter(name="instanceSize")
    def instance_size(self) -> _builtins.str:
        """
        Metastore instance sizes. Possible values: ["EXTRA_SMALL", "SMALL", "MEDIUM", "LARGE", "EXTRA_LARGE"]
        """
        return pulumi.get(self, "instance_size")

    @_builtins.property
    @pulumi.getter(name="scalingFactor")
    def scaling_factor(self) -> _builtins.float:
        """
        Scaling factor, in increments of 0.1 for values less than 1.0, and increments of 1.0 for values greater than 1.0.
        """
        return pulumi.get(self, "scaling_factor")


@pulumi.output_type
class GetMetastoreServiceScalingConfigAutoscalingConfigResult(dict):
    def __init__(__self__, *,
                 autoscaling_enabled: _builtins.bool,
                 autoscaling_factor: _builtins.float,
                 limit_configs: Sequence['outputs.GetMetastoreServiceScalingConfigAutoscalingConfigLimitConfigResult']):
        """
        :param _builtins.bool autoscaling_enabled: Defines whether autoscaling is enabled. The default value is false.
        :param _builtins.float autoscaling_factor: Output only. The scaling factor of a service with autoscaling enabled.
        :param Sequence['GetMetastoreServiceScalingConfigAutoscalingConfigLimitConfigArgs'] limit_configs: Represents the limit configuration of a metastore service.
        """
        pulumi.set(__self__, "autoscaling_enabled", autoscaling_enabled)
        pulumi.set(__self__, "autoscaling_factor", autoscaling_factor)
        pulumi.set(__self__, "limit_configs", limit_configs)

    @_builtins.property
    @pulumi.getter(name="autoscalingEnabled")
    def autoscaling_enabled(self) -> _builtins.bool:
        """
        Defines whether autoscaling is enabled. The default value is false.
        """
        return pulumi.get(self, "autoscaling_enabled")

    @_builtins.property
    @pulumi.getter(name="autoscalingFactor")
    def autoscaling_factor(self) -> _builtins.float:
        """
        Output only. The scaling factor of a service with autoscaling enabled.
        """
        return pulumi.get(self, "autoscaling_factor")

    @_builtins.property
    @pulumi.getter(name="limitConfigs")
    def limit_configs(self) -> Sequence['outputs.GetMetastoreServiceScalingConfigAutoscalingConfigLimitConfigResult']:
        """
        Represents the limit configuration of a metastore service.
        """
        return pulumi.get(self, "limit_configs")


@pulumi.output_type
class GetMetastoreServiceScalingConfigAutoscalingConfigLimitConfigResult(dict):
    def __init__(__self__, *,
                 max_scaling_factor: _builtins.float,
                 min_scaling_factor: _builtins.float):
        """
        :param _builtins.float max_scaling_factor: The maximum scaling factor that the service will autoscale to. The default value is 6.0.
        :param _builtins.float min_scaling_factor: The minimum scaling factor that the service will autoscale to. The default value is 0.1.
        """
        pulumi.set(__self__, "max_scaling_factor", max_scaling_factor)
        pulumi.set(__self__, "min_scaling_factor", min_scaling_factor)

    @_builtins.property
    @pulumi.getter(name="maxScalingFactor")
    def max_scaling_factor(self) -> _builtins.float:
        """
        The maximum scaling factor that the service will autoscale to. The default value is 6.0.
        """
        return pulumi.get(self, "max_scaling_factor")

    @_builtins.property
    @pulumi.getter(name="minScalingFactor")
    def min_scaling_factor(self) -> _builtins.float:
        """
        The minimum scaling factor that the service will autoscale to. The default value is 0.1.
        """
        return pulumi.get(self, "min_scaling_factor")


@pulumi.output_type
class GetMetastoreServiceScheduledBackupResult(dict):
    def __init__(__self__, *,
                 backup_location: _builtins.str,
                 cron_schedule: _builtins.str,
                 enabled: _builtins.bool,
                 time_zone: _builtins.str):
        """
        :param _builtins.str backup_location: A Cloud Storage URI of a folder, in the format gs://<bucket_name>/<path_inside_bucket>. A sub-folder <backup_folder> containing backup files will be stored below it.
        :param _builtins.str cron_schedule: The scheduled interval in Cron format, see https://en.wikipedia.org/wiki/Cron The default is empty: scheduled backup is not enabled. Must be specified to enable scheduled backups.
        :param _builtins.bool enabled: Defines whether the scheduled backup is enabled. The default value is false.
        :param _builtins.str time_zone: Specifies the time zone to be used when interpreting cronSchedule. Must be a time zone name from the time zone database (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones), e.g. America/Los_Angeles or Africa/Abidjan. If left unspecified, the default is UTC.
        """
        pulumi.set(__self__, "backup_location", backup_location)
        pulumi.set(__self__, "cron_schedule", cron_schedule)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "time_zone", time_zone)

    @_builtins.property
    @pulumi.getter(name="backupLocation")
    def backup_location(self) -> _builtins.str:
        """
        A Cloud Storage URI of a folder, in the format gs://<bucket_name>/<path_inside_bucket>. A sub-folder <backup_folder> containing backup files will be stored below it.
        """
        return pulumi.get(self, "backup_location")

    @_builtins.property
    @pulumi.getter(name="cronSchedule")
    def cron_schedule(self) -> _builtins.str:
        """
        The scheduled interval in Cron format, see https://en.wikipedia.org/wiki/Cron The default is empty: scheduled backup is not enabled. Must be specified to enable scheduled backups.
        """
        return pulumi.get(self, "cron_schedule")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Defines whether the scheduled backup is enabled. The default value is false.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> _builtins.str:
        """
        Specifies the time zone to be used when interpreting cronSchedule. Must be a time zone name from the time zone database (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones), e.g. America/Los_Angeles or Africa/Abidjan. If left unspecified, the default is UTC.
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class GetMetastoreServiceTelemetryConfigResult(dict):
    def __init__(__self__, *,
                 log_format: _builtins.str):
        """
        :param _builtins.str log_format: The output format of the Dataproc Metastore service's logs. Default value: "JSON" Possible values: ["LEGACY", "JSON"]
        """
        pulumi.set(__self__, "log_format", log_format)

    @_builtins.property
    @pulumi.getter(name="logFormat")
    def log_format(self) -> _builtins.str:
        """
        The output format of the Dataproc Metastore service's logs. Default value: "JSON" Possible values: ["LEGACY", "JSON"]
        """
        return pulumi.get(self, "log_format")


