# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CxEntityTypeArgs', 'CxEntityType']

@pulumi.input_type
class CxEntityTypeArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 entities: pulumi.Input[Sequence[pulumi.Input['CxEntityTypeEntityArgs']]],
                 kind: pulumi.Input[_builtins.str],
                 auto_expansion_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_fuzzy_extraction: Optional[pulumi.Input[_builtins.bool]] = None,
                 excluded_phrases: Optional[pulumi.Input[Sequence[pulumi.Input['CxEntityTypeExcludedPhraseArgs']]]] = None,
                 language_code: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 redact: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a CxEntityType resource.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the entity type, unique within the agent.
        :param pulumi.Input[Sequence[pulumi.Input['CxEntityTypeEntityArgs']]] entities: The collection of entity entries associated with the entity type.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] kind: Indicates whether the entity type can be automatically expanded.
               * KIND_MAP: Map entity types allow mapping of a group of synonyms to a canonical value.
               * KIND_LIST: List entity types contain a set of entries that do not map to canonical values. However, list entity types can contain references to other entity types (with or without aliases).
               * KIND_REGEXP: Regexp entity types allow to specify regular expressions in entries values.
               Possible values are: `KIND_MAP`, `KIND_LIST`, `KIND_REGEXP`.
        :param pulumi.Input[_builtins.str] auto_expansion_mode: Represents kinds of entities.
               * AUTO_EXPANSION_MODE_UNSPECIFIED: Auto expansion disabled for the entity.
               * AUTO_EXPANSION_MODE_DEFAULT: Allows an agent to recognize values that have not been explicitly listed in the entity.
               Possible values are: `AUTO_EXPANSION_MODE_DEFAULT`, `AUTO_EXPANSION_MODE_UNSPECIFIED`.
        :param pulumi.Input[_builtins.bool] enable_fuzzy_extraction: Enables fuzzy entity extraction during classification.
        :param pulumi.Input[Sequence[pulumi.Input['CxEntityTypeExcludedPhraseArgs']]] excluded_phrases: Collection of exceptional words and phrases that shouldn't be matched. For example, if you have a size entity type with entry giant(an adjective), you might consider adding giants(a noun) as an exclusion.
               If the kind of entity type is KIND_MAP, then the phrases specified by entities and excluded phrases should be mutually exclusive.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] language_code: The language of the following fields in entityType:
               EntityType.entities.value
               EntityType.entities.synonyms
               EntityType.excluded_phrases.value
               If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
        :param pulumi.Input[_builtins.str] parent: The agent to create a entity type for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[_builtins.bool] redact: Indicates whether parameters of the entity type should be redacted in log. If redaction is enabled, page parameters and intent parameters referring to the entity type will be replaced by parameter name when logging.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "entities", entities)
        pulumi.set(__self__, "kind", kind)
        if auto_expansion_mode is not None:
            pulumi.set(__self__, "auto_expansion_mode", auto_expansion_mode)
        if enable_fuzzy_extraction is not None:
            pulumi.set(__self__, "enable_fuzzy_extraction", enable_fuzzy_extraction)
        if excluded_phrases is not None:
            pulumi.set(__self__, "excluded_phrases", excluded_phrases)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if redact is not None:
            pulumi.set(__self__, "redact", redact)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The human-readable name of the entity type, unique within the agent.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def entities(self) -> pulumi.Input[Sequence[pulumi.Input['CxEntityTypeEntityArgs']]]:
        """
        The collection of entity entries associated with the entity type.
        Structure is documented below.
        """
        return pulumi.get(self, "entities")

    @entities.setter
    def entities(self, value: pulumi.Input[Sequence[pulumi.Input['CxEntityTypeEntityArgs']]]):
        pulumi.set(self, "entities", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> pulumi.Input[_builtins.str]:
        """
        Indicates whether the entity type can be automatically expanded.
        * KIND_MAP: Map entity types allow mapping of a group of synonyms to a canonical value.
        * KIND_LIST: List entity types contain a set of entries that do not map to canonical values. However, list entity types can contain references to other entity types (with or without aliases).
        * KIND_REGEXP: Regexp entity types allow to specify regular expressions in entries values.
        Possible values are: `KIND_MAP`, `KIND_LIST`, `KIND_REGEXP`.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter(name="autoExpansionMode")
    def auto_expansion_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Represents kinds of entities.
        * AUTO_EXPANSION_MODE_UNSPECIFIED: Auto expansion disabled for the entity.
        * AUTO_EXPANSION_MODE_DEFAULT: Allows an agent to recognize values that have not been explicitly listed in the entity.
        Possible values are: `AUTO_EXPANSION_MODE_DEFAULT`, `AUTO_EXPANSION_MODE_UNSPECIFIED`.
        """
        return pulumi.get(self, "auto_expansion_mode")

    @auto_expansion_mode.setter
    def auto_expansion_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_expansion_mode", value)

    @_builtins.property
    @pulumi.getter(name="enableFuzzyExtraction")
    def enable_fuzzy_extraction(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables fuzzy entity extraction during classification.
        """
        return pulumi.get(self, "enable_fuzzy_extraction")

    @enable_fuzzy_extraction.setter
    def enable_fuzzy_extraction(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_fuzzy_extraction", value)

    @_builtins.property
    @pulumi.getter(name="excludedPhrases")
    def excluded_phrases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CxEntityTypeExcludedPhraseArgs']]]]:
        """
        Collection of exceptional words and phrases that shouldn't be matched. For example, if you have a size entity type with entry giant(an adjective), you might consider adding giants(a noun) as an exclusion.
        If the kind of entity type is KIND_MAP, then the phrases specified by entities and excluded phrases should be mutually exclusive.
        Structure is documented below.
        """
        return pulumi.get(self, "excluded_phrases")

    @excluded_phrases.setter
    def excluded_phrases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CxEntityTypeExcludedPhraseArgs']]]]):
        pulumi.set(self, "excluded_phrases", value)

    @_builtins.property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The language of the following fields in entityType:
        EntityType.entities.value
        EntityType.entities.synonyms
        EntityType.excluded_phrases.value
        If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "language_code", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The agent to create a entity type for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter
    def redact(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether parameters of the entity type should be redacted in log. If redaction is enabled, page parameters and intent parameters referring to the entity type will be replaced by parameter name when logging.
        """
        return pulumi.get(self, "redact")

    @redact.setter
    def redact(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "redact", value)


@pulumi.input_type
class _CxEntityTypeState:
    def __init__(__self__, *,
                 auto_expansion_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_fuzzy_extraction: Optional[pulumi.Input[_builtins.bool]] = None,
                 entities: Optional[pulumi.Input[Sequence[pulumi.Input['CxEntityTypeEntityArgs']]]] = None,
                 excluded_phrases: Optional[pulumi.Input[Sequence[pulumi.Input['CxEntityTypeExcludedPhraseArgs']]]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 language_code: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 redact: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering CxEntityType resources.
        :param pulumi.Input[_builtins.str] auto_expansion_mode: Represents kinds of entities.
               * AUTO_EXPANSION_MODE_UNSPECIFIED: Auto expansion disabled for the entity.
               * AUTO_EXPANSION_MODE_DEFAULT: Allows an agent to recognize values that have not been explicitly listed in the entity.
               Possible values are: `AUTO_EXPANSION_MODE_DEFAULT`, `AUTO_EXPANSION_MODE_UNSPECIFIED`.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the entity type, unique within the agent.
        :param pulumi.Input[_builtins.bool] enable_fuzzy_extraction: Enables fuzzy entity extraction during classification.
        :param pulumi.Input[Sequence[pulumi.Input['CxEntityTypeEntityArgs']]] entities: The collection of entity entries associated with the entity type.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['CxEntityTypeExcludedPhraseArgs']]] excluded_phrases: Collection of exceptional words and phrases that shouldn't be matched. For example, if you have a size entity type with entry giant(an adjective), you might consider adding giants(a noun) as an exclusion.
               If the kind of entity type is KIND_MAP, then the phrases specified by entities and excluded phrases should be mutually exclusive.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] kind: Indicates whether the entity type can be automatically expanded.
               * KIND_MAP: Map entity types allow mapping of a group of synonyms to a canonical value.
               * KIND_LIST: List entity types contain a set of entries that do not map to canonical values. However, list entity types can contain references to other entity types (with or without aliases).
               * KIND_REGEXP: Regexp entity types allow to specify regular expressions in entries values.
               Possible values are: `KIND_MAP`, `KIND_LIST`, `KIND_REGEXP`.
        :param pulumi.Input[_builtins.str] language_code: The language of the following fields in entityType:
               EntityType.entities.value
               EntityType.entities.synonyms
               EntityType.excluded_phrases.value
               If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
        :param pulumi.Input[_builtins.str] name: The unique identifier of the entity type.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/entityTypes/<Entity Type ID>.
        :param pulumi.Input[_builtins.str] parent: The agent to create a entity type for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[_builtins.bool] redact: Indicates whether parameters of the entity type should be redacted in log. If redaction is enabled, page parameters and intent parameters referring to the entity type will be replaced by parameter name when logging.
        """
        if auto_expansion_mode is not None:
            pulumi.set(__self__, "auto_expansion_mode", auto_expansion_mode)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enable_fuzzy_extraction is not None:
            pulumi.set(__self__, "enable_fuzzy_extraction", enable_fuzzy_extraction)
        if entities is not None:
            pulumi.set(__self__, "entities", entities)
        if excluded_phrases is not None:
            pulumi.set(__self__, "excluded_phrases", excluded_phrases)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if redact is not None:
            pulumi.set(__self__, "redact", redact)

    @_builtins.property
    @pulumi.getter(name="autoExpansionMode")
    def auto_expansion_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Represents kinds of entities.
        * AUTO_EXPANSION_MODE_UNSPECIFIED: Auto expansion disabled for the entity.
        * AUTO_EXPANSION_MODE_DEFAULT: Allows an agent to recognize values that have not been explicitly listed in the entity.
        Possible values are: `AUTO_EXPANSION_MODE_DEFAULT`, `AUTO_EXPANSION_MODE_UNSPECIFIED`.
        """
        return pulumi.get(self, "auto_expansion_mode")

    @auto_expansion_mode.setter
    def auto_expansion_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_expansion_mode", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The human-readable name of the entity type, unique within the agent.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="enableFuzzyExtraction")
    def enable_fuzzy_extraction(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables fuzzy entity extraction during classification.
        """
        return pulumi.get(self, "enable_fuzzy_extraction")

    @enable_fuzzy_extraction.setter
    def enable_fuzzy_extraction(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_fuzzy_extraction", value)

    @_builtins.property
    @pulumi.getter
    def entities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CxEntityTypeEntityArgs']]]]:
        """
        The collection of entity entries associated with the entity type.
        Structure is documented below.
        """
        return pulumi.get(self, "entities")

    @entities.setter
    def entities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CxEntityTypeEntityArgs']]]]):
        pulumi.set(self, "entities", value)

    @_builtins.property
    @pulumi.getter(name="excludedPhrases")
    def excluded_phrases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CxEntityTypeExcludedPhraseArgs']]]]:
        """
        Collection of exceptional words and phrases that shouldn't be matched. For example, if you have a size entity type with entry giant(an adjective), you might consider adding giants(a noun) as an exclusion.
        If the kind of entity type is KIND_MAP, then the phrases specified by entities and excluded phrases should be mutually exclusive.
        Structure is documented below.
        """
        return pulumi.get(self, "excluded_phrases")

    @excluded_phrases.setter
    def excluded_phrases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CxEntityTypeExcludedPhraseArgs']]]]):
        pulumi.set(self, "excluded_phrases", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether the entity type can be automatically expanded.
        * KIND_MAP: Map entity types allow mapping of a group of synonyms to a canonical value.
        * KIND_LIST: List entity types contain a set of entries that do not map to canonical values. However, list entity types can contain references to other entity types (with or without aliases).
        * KIND_REGEXP: Regexp entity types allow to specify regular expressions in entries values.
        Possible values are: `KIND_MAP`, `KIND_LIST`, `KIND_REGEXP`.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The language of the following fields in entityType:
        EntityType.entities.value
        EntityType.entities.synonyms
        EntityType.excluded_phrases.value
        If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "language_code", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the entity type.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/entityTypes/<Entity Type ID>.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The agent to create a entity type for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter
    def redact(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether parameters of the entity type should be redacted in log. If redaction is enabled, page parameters and intent parameters referring to the entity type will be replaced by parameter name when logging.
        """
        return pulumi.get(self, "redact")

    @redact.setter
    def redact(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "redact", value)


@pulumi.type_token("gcp:diagflow/cxEntityType:CxEntityType")
class CxEntityType(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_expansion_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_fuzzy_extraction: Optional[pulumi.Input[_builtins.bool]] = None,
                 entities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CxEntityTypeEntityArgs', 'CxEntityTypeEntityArgsDict']]]]] = None,
                 excluded_phrases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CxEntityTypeExcludedPhraseArgs', 'CxEntityTypeExcludedPhraseArgsDict']]]]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 language_code: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 redact: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Entities are extracted from user input and represent parameters that are meaningful to your application.
        For example, a date range, a proper name such as a geographic location or landmark, and so on. Entities represent actionable data for your application.

        To get more information about EntityType, see:

        * [API documentation](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents.entityTypes)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dialogflow/cx/docs)

        ## Example Usage

        ### Dialogflowcx Entity Type Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent",
            location="global",
            default_language_code="en",
            supported_language_codes=[
                "fr",
                "de",
                "es",
            ],
            time_zone="America/New_York",
            description="Example description.",
            avatar_uri="https://cloud.google.com/_static/images/cloud/icons/favicons/onecloud/super_cloud.png",
            enable_stackdriver_logging=True,
            enable_spell_correction=True,
            speech_to_text_settings={
                "enable_speech_adaptation": True,
            })
        basic_entity_type = gcp.diagflow.CxEntityType("basic_entity_type",
            parent=agent.id,
            display_name="MyEntity",
            kind="KIND_MAP",
            entities=[
                {
                    "value": "value1",
                    "synonyms": [
                        "synonym1",
                        "synonym2",
                    ],
                },
                {
                    "value": "value2",
                    "synonyms": [
                        "synonym3",
                        "synonym4",
                    ],
                },
            ],
            enable_fuzzy_extraction=False)
        ```

        ## Import

        EntityType can be imported using any of these accepted formats:

        * `{{parent}}/entityTypes/{{name}}`

        * `{{parent}}/{{name}}`

        When using the `pulumi import` command, EntityType can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:diagflow/cxEntityType:CxEntityType default {{parent}}/entityTypes/{{name}}
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxEntityType:CxEntityType default {{parent}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_expansion_mode: Represents kinds of entities.
               * AUTO_EXPANSION_MODE_UNSPECIFIED: Auto expansion disabled for the entity.
               * AUTO_EXPANSION_MODE_DEFAULT: Allows an agent to recognize values that have not been explicitly listed in the entity.
               Possible values are: `AUTO_EXPANSION_MODE_DEFAULT`, `AUTO_EXPANSION_MODE_UNSPECIFIED`.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the entity type, unique within the agent.
        :param pulumi.Input[_builtins.bool] enable_fuzzy_extraction: Enables fuzzy entity extraction during classification.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CxEntityTypeEntityArgs', 'CxEntityTypeEntityArgsDict']]]] entities: The collection of entity entries associated with the entity type.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CxEntityTypeExcludedPhraseArgs', 'CxEntityTypeExcludedPhraseArgsDict']]]] excluded_phrases: Collection of exceptional words and phrases that shouldn't be matched. For example, if you have a size entity type with entry giant(an adjective), you might consider adding giants(a noun) as an exclusion.
               If the kind of entity type is KIND_MAP, then the phrases specified by entities and excluded phrases should be mutually exclusive.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] kind: Indicates whether the entity type can be automatically expanded.
               * KIND_MAP: Map entity types allow mapping of a group of synonyms to a canonical value.
               * KIND_LIST: List entity types contain a set of entries that do not map to canonical values. However, list entity types can contain references to other entity types (with or without aliases).
               * KIND_REGEXP: Regexp entity types allow to specify regular expressions in entries values.
               Possible values are: `KIND_MAP`, `KIND_LIST`, `KIND_REGEXP`.
        :param pulumi.Input[_builtins.str] language_code: The language of the following fields in entityType:
               EntityType.entities.value
               EntityType.entities.synonyms
               EntityType.excluded_phrases.value
               If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
        :param pulumi.Input[_builtins.str] parent: The agent to create a entity type for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[_builtins.bool] redact: Indicates whether parameters of the entity type should be redacted in log. If redaction is enabled, page parameters and intent parameters referring to the entity type will be replaced by parameter name when logging.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CxEntityTypeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Entities are extracted from user input and represent parameters that are meaningful to your application.
        For example, a date range, a proper name such as a geographic location or landmark, and so on. Entities represent actionable data for your application.

        To get more information about EntityType, see:

        * [API documentation](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents.entityTypes)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dialogflow/cx/docs)

        ## Example Usage

        ### Dialogflowcx Entity Type Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent",
            location="global",
            default_language_code="en",
            supported_language_codes=[
                "fr",
                "de",
                "es",
            ],
            time_zone="America/New_York",
            description="Example description.",
            avatar_uri="https://cloud.google.com/_static/images/cloud/icons/favicons/onecloud/super_cloud.png",
            enable_stackdriver_logging=True,
            enable_spell_correction=True,
            speech_to_text_settings={
                "enable_speech_adaptation": True,
            })
        basic_entity_type = gcp.diagflow.CxEntityType("basic_entity_type",
            parent=agent.id,
            display_name="MyEntity",
            kind="KIND_MAP",
            entities=[
                {
                    "value": "value1",
                    "synonyms": [
                        "synonym1",
                        "synonym2",
                    ],
                },
                {
                    "value": "value2",
                    "synonyms": [
                        "synonym3",
                        "synonym4",
                    ],
                },
            ],
            enable_fuzzy_extraction=False)
        ```

        ## Import

        EntityType can be imported using any of these accepted formats:

        * `{{parent}}/entityTypes/{{name}}`

        * `{{parent}}/{{name}}`

        When using the `pulumi import` command, EntityType can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:diagflow/cxEntityType:CxEntityType default {{parent}}/entityTypes/{{name}}
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxEntityType:CxEntityType default {{parent}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param CxEntityTypeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CxEntityTypeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_expansion_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_fuzzy_extraction: Optional[pulumi.Input[_builtins.bool]] = None,
                 entities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CxEntityTypeEntityArgs', 'CxEntityTypeEntityArgsDict']]]]] = None,
                 excluded_phrases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CxEntityTypeExcludedPhraseArgs', 'CxEntityTypeExcludedPhraseArgsDict']]]]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 language_code: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 redact: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CxEntityTypeArgs.__new__(CxEntityTypeArgs)

            __props__.__dict__["auto_expansion_mode"] = auto_expansion_mode
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["enable_fuzzy_extraction"] = enable_fuzzy_extraction
            if entities is None and not opts.urn:
                raise TypeError("Missing required property 'entities'")
            __props__.__dict__["entities"] = entities
            __props__.__dict__["excluded_phrases"] = excluded_phrases
            if kind is None and not opts.urn:
                raise TypeError("Missing required property 'kind'")
            __props__.__dict__["kind"] = kind
            __props__.__dict__["language_code"] = language_code
            __props__.__dict__["parent"] = parent
            __props__.__dict__["redact"] = redact
            __props__.__dict__["name"] = None
        super(CxEntityType, __self__).__init__(
            'gcp:diagflow/cxEntityType:CxEntityType',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_expansion_mode: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            enable_fuzzy_extraction: Optional[pulumi.Input[_builtins.bool]] = None,
            entities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CxEntityTypeEntityArgs', 'CxEntityTypeEntityArgsDict']]]]] = None,
            excluded_phrases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CxEntityTypeExcludedPhraseArgs', 'CxEntityTypeExcludedPhraseArgsDict']]]]] = None,
            kind: Optional[pulumi.Input[_builtins.str]] = None,
            language_code: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parent: Optional[pulumi.Input[_builtins.str]] = None,
            redact: Optional[pulumi.Input[_builtins.bool]] = None) -> 'CxEntityType':
        """
        Get an existing CxEntityType resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_expansion_mode: Represents kinds of entities.
               * AUTO_EXPANSION_MODE_UNSPECIFIED: Auto expansion disabled for the entity.
               * AUTO_EXPANSION_MODE_DEFAULT: Allows an agent to recognize values that have not been explicitly listed in the entity.
               Possible values are: `AUTO_EXPANSION_MODE_DEFAULT`, `AUTO_EXPANSION_MODE_UNSPECIFIED`.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the entity type, unique within the agent.
        :param pulumi.Input[_builtins.bool] enable_fuzzy_extraction: Enables fuzzy entity extraction during classification.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CxEntityTypeEntityArgs', 'CxEntityTypeEntityArgsDict']]]] entities: The collection of entity entries associated with the entity type.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CxEntityTypeExcludedPhraseArgs', 'CxEntityTypeExcludedPhraseArgsDict']]]] excluded_phrases: Collection of exceptional words and phrases that shouldn't be matched. For example, if you have a size entity type with entry giant(an adjective), you might consider adding giants(a noun) as an exclusion.
               If the kind of entity type is KIND_MAP, then the phrases specified by entities and excluded phrases should be mutually exclusive.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] kind: Indicates whether the entity type can be automatically expanded.
               * KIND_MAP: Map entity types allow mapping of a group of synonyms to a canonical value.
               * KIND_LIST: List entity types contain a set of entries that do not map to canonical values. However, list entity types can contain references to other entity types (with or without aliases).
               * KIND_REGEXP: Regexp entity types allow to specify regular expressions in entries values.
               Possible values are: `KIND_MAP`, `KIND_LIST`, `KIND_REGEXP`.
        :param pulumi.Input[_builtins.str] language_code: The language of the following fields in entityType:
               EntityType.entities.value
               EntityType.entities.synonyms
               EntityType.excluded_phrases.value
               If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
        :param pulumi.Input[_builtins.str] name: The unique identifier of the entity type.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/entityTypes/<Entity Type ID>.
        :param pulumi.Input[_builtins.str] parent: The agent to create a entity type for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[_builtins.bool] redact: Indicates whether parameters of the entity type should be redacted in log. If redaction is enabled, page parameters and intent parameters referring to the entity type will be replaced by parameter name when logging.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CxEntityTypeState.__new__(_CxEntityTypeState)

        __props__.__dict__["auto_expansion_mode"] = auto_expansion_mode
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enable_fuzzy_extraction"] = enable_fuzzy_extraction
        __props__.__dict__["entities"] = entities
        __props__.__dict__["excluded_phrases"] = excluded_phrases
        __props__.__dict__["kind"] = kind
        __props__.__dict__["language_code"] = language_code
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        __props__.__dict__["redact"] = redact
        return CxEntityType(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoExpansionMode")
    def auto_expansion_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Represents kinds of entities.
        * AUTO_EXPANSION_MODE_UNSPECIFIED: Auto expansion disabled for the entity.
        * AUTO_EXPANSION_MODE_DEFAULT: Allows an agent to recognize values that have not been explicitly listed in the entity.
        Possible values are: `AUTO_EXPANSION_MODE_DEFAULT`, `AUTO_EXPANSION_MODE_UNSPECIFIED`.
        """
        return pulumi.get(self, "auto_expansion_mode")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The human-readable name of the entity type, unique within the agent.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="enableFuzzyExtraction")
    def enable_fuzzy_extraction(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enables fuzzy entity extraction during classification.
        """
        return pulumi.get(self, "enable_fuzzy_extraction")

    @_builtins.property
    @pulumi.getter
    def entities(self) -> pulumi.Output[Sequence['outputs.CxEntityTypeEntity']]:
        """
        The collection of entity entries associated with the entity type.
        Structure is documented below.
        """
        return pulumi.get(self, "entities")

    @_builtins.property
    @pulumi.getter(name="excludedPhrases")
    def excluded_phrases(self) -> pulumi.Output[Optional[Sequence['outputs.CxEntityTypeExcludedPhrase']]]:
        """
        Collection of exceptional words and phrases that shouldn't be matched. For example, if you have a size entity type with entry giant(an adjective), you might consider adding giants(a noun) as an exclusion.
        If the kind of entity type is KIND_MAP, then the phrases specified by entities and excluded phrases should be mutually exclusive.
        Structure is documented below.
        """
        return pulumi.get(self, "excluded_phrases")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates whether the entity type can be automatically expanded.
        * KIND_MAP: Map entity types allow mapping of a group of synonyms to a canonical value.
        * KIND_LIST: List entity types contain a set of entries that do not map to canonical values. However, list entity types can contain references to other entity types (with or without aliases).
        * KIND_REGEXP: Regexp entity types allow to specify regular expressions in entries values.
        Possible values are: `KIND_MAP`, `KIND_LIST`, `KIND_REGEXP`.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The language of the following fields in entityType:
        EntityType.entities.value
        EntityType.entities.synonyms
        EntityType.excluded_phrases.value
        If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
        """
        return pulumi.get(self, "language_code")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the entity type.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/entityTypes/<Entity Type ID>.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parent(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The agent to create a entity type for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        return pulumi.get(self, "parent")

    @_builtins.property
    @pulumi.getter
    def redact(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether parameters of the entity type should be redacted in log. If redaction is enabled, page parameters and intent parameters referring to the entity type will be replaced by parameter name when logging.
        """
        return pulumi.get(self, "redact")

