# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CxWebhookArgs', 'CxWebhook']

@pulumi.input_type
class CxWebhookArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_spell_correction: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_stackdriver_logging: Optional[pulumi.Input[_builtins.bool]] = None,
                 generic_web_service: Optional[pulumi.Input['CxWebhookGenericWebServiceArgs']] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 security_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 service_directory: Optional[pulumi.Input['CxWebhookServiceDirectoryArgs']] = None,
                 timeout: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CxWebhook resource.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the webhook, unique within the agent.
        :param pulumi.Input[_builtins.bool] disabled: Indicates whether the webhook is disabled.
        :param pulumi.Input[_builtins.bool] enable_spell_correction: Deprecated. Indicates if automatic spell correction is enabled in detect intent requests.
        :param pulumi.Input[_builtins.bool] enable_stackdriver_logging: Deprecated. Determines whether this agent should log conversation queries.
        :param pulumi.Input['CxWebhookGenericWebServiceArgs'] generic_web_service: Represents configuration for a generic web service.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] parent: The agent to create a webhook for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[_builtins.str] security_settings: Deprecated. Name of the SecuritySettings reference for the agent. Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
        :param pulumi.Input['CxWebhookServiceDirectoryArgs'] service_directory: Configuration for a Service Directory service.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] timeout: Webhook execution timeout.
        """
        pulumi.set(__self__, "display_name", display_name)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if enable_spell_correction is not None:
            pulumi.set(__self__, "enable_spell_correction", enable_spell_correction)
        if enable_stackdriver_logging is not None:
            pulumi.set(__self__, "enable_stackdriver_logging", enable_stackdriver_logging)
        if generic_web_service is not None:
            pulumi.set(__self__, "generic_web_service", generic_web_service)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if security_settings is not None:
            pulumi.set(__self__, "security_settings", security_settings)
        if service_directory is not None:
            pulumi.set(__self__, "service_directory", service_directory)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The human-readable name of the webhook, unique within the agent.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the webhook is disabled.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter(name="enableSpellCorrection")
    def enable_spell_correction(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Deprecated. Indicates if automatic spell correction is enabled in detect intent requests.
        """
        return pulumi.get(self, "enable_spell_correction")

    @enable_spell_correction.setter
    def enable_spell_correction(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_spell_correction", value)

    @_builtins.property
    @pulumi.getter(name="enableStackdriverLogging")
    def enable_stackdriver_logging(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Deprecated. Determines whether this agent should log conversation queries.
        """
        return pulumi.get(self, "enable_stackdriver_logging")

    @enable_stackdriver_logging.setter
    def enable_stackdriver_logging(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_stackdriver_logging", value)

    @_builtins.property
    @pulumi.getter(name="genericWebService")
    def generic_web_service(self) -> Optional[pulumi.Input['CxWebhookGenericWebServiceArgs']]:
        """
        Represents configuration for a generic web service.
        Structure is documented below.
        """
        return pulumi.get(self, "generic_web_service")

    @generic_web_service.setter
    def generic_web_service(self, value: Optional[pulumi.Input['CxWebhookGenericWebServiceArgs']]):
        pulumi.set(self, "generic_web_service", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The agent to create a webhook for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deprecated. Name of the SecuritySettings reference for the agent. Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
        """
        return pulumi.get(self, "security_settings")

    @security_settings.setter
    def security_settings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_settings", value)

    @_builtins.property
    @pulumi.getter(name="serviceDirectory")
    def service_directory(self) -> Optional[pulumi.Input['CxWebhookServiceDirectoryArgs']]:
        """
        Configuration for a Service Directory service.
        Structure is documented below.
        """
        return pulumi.get(self, "service_directory")

    @service_directory.setter
    def service_directory(self, value: Optional[pulumi.Input['CxWebhookServiceDirectoryArgs']]):
        pulumi.set(self, "service_directory", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Webhook execution timeout.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class _CxWebhookState:
    def __init__(__self__, *,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_spell_correction: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_stackdriver_logging: Optional[pulumi.Input[_builtins.bool]] = None,
                 generic_web_service: Optional[pulumi.Input['CxWebhookGenericWebServiceArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 security_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 service_directory: Optional[pulumi.Input['CxWebhookServiceDirectoryArgs']] = None,
                 start_flow: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CxWebhook resources.
        :param pulumi.Input[_builtins.bool] disabled: Indicates whether the webhook is disabled.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the webhook, unique within the agent.
        :param pulumi.Input[_builtins.bool] enable_spell_correction: Deprecated. Indicates if automatic spell correction is enabled in detect intent requests.
        :param pulumi.Input[_builtins.bool] enable_stackdriver_logging: Deprecated. Determines whether this agent should log conversation queries.
        :param pulumi.Input['CxWebhookGenericWebServiceArgs'] generic_web_service: Represents configuration for a generic web service.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The unique identifier of the webhook.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
        :param pulumi.Input[_builtins.str] parent: The agent to create a webhook for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[_builtins.str] security_settings: Deprecated. Name of the SecuritySettings reference for the agent. Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
        :param pulumi.Input['CxWebhookServiceDirectoryArgs'] service_directory: Configuration for a Service Directory service.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] start_flow: Deprecated. Name of the start flow in this agent. A start flow will be automatically created when the agent is created, and can only be deleted by deleting the agent. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        :param pulumi.Input[_builtins.str] timeout: Webhook execution timeout.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enable_spell_correction is not None:
            pulumi.set(__self__, "enable_spell_correction", enable_spell_correction)
        if enable_stackdriver_logging is not None:
            pulumi.set(__self__, "enable_stackdriver_logging", enable_stackdriver_logging)
        if generic_web_service is not None:
            pulumi.set(__self__, "generic_web_service", generic_web_service)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if security_settings is not None:
            pulumi.set(__self__, "security_settings", security_settings)
        if service_directory is not None:
            pulumi.set(__self__, "service_directory", service_directory)
        if start_flow is not None:
            pulumi.set(__self__, "start_flow", start_flow)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the webhook is disabled.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The human-readable name of the webhook, unique within the agent.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="enableSpellCorrection")
    def enable_spell_correction(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Deprecated. Indicates if automatic spell correction is enabled in detect intent requests.
        """
        return pulumi.get(self, "enable_spell_correction")

    @enable_spell_correction.setter
    def enable_spell_correction(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_spell_correction", value)

    @_builtins.property
    @pulumi.getter(name="enableStackdriverLogging")
    def enable_stackdriver_logging(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Deprecated. Determines whether this agent should log conversation queries.
        """
        return pulumi.get(self, "enable_stackdriver_logging")

    @enable_stackdriver_logging.setter
    def enable_stackdriver_logging(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_stackdriver_logging", value)

    @_builtins.property
    @pulumi.getter(name="genericWebService")
    def generic_web_service(self) -> Optional[pulumi.Input['CxWebhookGenericWebServiceArgs']]:
        """
        Represents configuration for a generic web service.
        Structure is documented below.
        """
        return pulumi.get(self, "generic_web_service")

    @generic_web_service.setter
    def generic_web_service(self, value: Optional[pulumi.Input['CxWebhookGenericWebServiceArgs']]):
        pulumi.set(self, "generic_web_service", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the webhook.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The agent to create a webhook for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deprecated. Name of the SecuritySettings reference for the agent. Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
        """
        return pulumi.get(self, "security_settings")

    @security_settings.setter
    def security_settings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_settings", value)

    @_builtins.property
    @pulumi.getter(name="serviceDirectory")
    def service_directory(self) -> Optional[pulumi.Input['CxWebhookServiceDirectoryArgs']]:
        """
        Configuration for a Service Directory service.
        Structure is documented below.
        """
        return pulumi.get(self, "service_directory")

    @service_directory.setter
    def service_directory(self, value: Optional[pulumi.Input['CxWebhookServiceDirectoryArgs']]):
        pulumi.set(self, "service_directory", value)

    @_builtins.property
    @pulumi.getter(name="startFlow")
    def start_flow(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deprecated. Name of the start flow in this agent. A start flow will be automatically created when the agent is created, and can only be deleted by deleting the agent. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        """
        return pulumi.get(self, "start_flow")

    @start_flow.setter
    def start_flow(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_flow", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Webhook execution timeout.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timeout", value)


@pulumi.type_token("gcp:diagflow/cxWebhook:CxWebhook")
class CxWebhook(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_spell_correction: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_stackdriver_logging: Optional[pulumi.Input[_builtins.bool]] = None,
                 generic_web_service: Optional[pulumi.Input[Union['CxWebhookGenericWebServiceArgs', 'CxWebhookGenericWebServiceArgsDict']]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 security_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 service_directory: Optional[pulumi.Input[Union['CxWebhookServiceDirectoryArgs', 'CxWebhookServiceDirectoryArgsDict']]] = None,
                 timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Webhooks host the developer's business logic. During a session, webhooks allow the developer to use the data extracted by Dialogflow's natural language processing to generate dynamic responses, validate collected data, or trigger actions on the backend.

        To get more information about Webhook, see:

        * [API documentation](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents.webhooks)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dialogflow/cx/docs)

        ## Example Usage

        ### Dialogflowcx Webhook Standard

        ```python
        import pulumi
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent",
            location="global",
            default_language_code="en",
            supported_language_codes=[
                "it",
                "de",
                "es",
            ],
            time_zone="America/New_York",
            description="Example description.",
            avatar_uri="https://cloud.google.com/_static/images/cloud/icons/favicons/onecloud/super_cloud.png",
            enable_stackdriver_logging=True,
            enable_spell_correction=True,
            speech_to_text_settings={
                "enable_speech_adaptation": True,
            })
        standard_webhook = gcp.diagflow.CxWebhook("standard_webhook",
            parent=agent.id,
            display_name="MyFlow",
            generic_web_service={
                "allowed_ca_certs": ["BQA="],
                "uri": "https://example.com",
                "request_headers": {
                    "example-key": "example-value",
                },
                "webhook_type": "STANDARD",
                "oauth_config": {
                    "client_id": "example-client-id",
                    "secret_version_for_client_secret": "projects/example-proj/secrets/example-secret/versions/example-version",
                    "token_endpoint": "https://example.com",
                    "scopes": ["example-scope"],
                },
                "service_agent_auth": "NONE",
                "secret_version_for_username_password": "projects/example-proj/secrets/example-secret/versions/example-version",
                "secret_versions_for_request_headers": [
                    {
                        "key": "example-key-1",
                        "secret_version": "projects/example-proj/secrets/example-secret/versions/example-version",
                    },
                    {
                        "key": "example-key-2",
                        "secret_version": "projects/example-proj/secrets/example-secret/versions/example-version-2",
                    },
                ],
            })
        ```
        ### Dialogflowcx Webhook Flexible

        ```python
        import pulumi
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent",
            location="global",
            default_language_code="en",
            supported_language_codes=[
                "it",
                "de",
                "es",
            ],
            time_zone="America/New_York",
            description="Example description.",
            avatar_uri="https://cloud.google.com/_static/images/cloud/icons/favicons/onecloud/super_cloud.png",
            enable_stackdriver_logging=True,
            enable_spell_correction=True,
            speech_to_text_settings={
                "enable_speech_adaptation": True,
            })
        flexible_webhook = gcp.diagflow.CxWebhook("flexible_webhook",
            parent=agent.id,
            display_name="MyFlow",
            generic_web_service={
                "uri": "https://example.com",
                "request_headers": {
                    "example-key": "example-value",
                },
                "webhook_type": "FLEXIBLE",
                "oauth_config": {
                    "client_id": "example-client-id",
                    "client_secret": "projects/example-proj/secrets/example-secret/versions/example-version",
                    "token_endpoint": "https://example.com",
                },
                "service_agent_auth": "NONE",
                "http_method": "POST",
                "request_body": "{\\"example-key\\": \\"example-value\\"}",
                "parameter_mapping": {
                    "example-parameter": "examplePath",
                },
            })
        ```
        ### Dialogflowcx Webhook Service Directory Standard

        ```python
        import pulumi
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent",
            location="us-central1",
            default_language_code="en",
            supported_language_codes=[
                "it",
                "de",
                "es",
            ],
            time_zone="America/New_York",
            description="Example description.",
            avatar_uri="https://cloud.google.com/_static/images/cloud/icons/favicons/onecloud/super_cloud.png",
            enable_stackdriver_logging=True,
            enable_spell_correction=True,
            speech_to_text_settings={
                "enable_speech_adaptation": True,
            })
        standard_webhook = gcp.diagflow.CxWebhook("standard_webhook",
            parent=agent.id,
            display_name="MyFlow",
            service_directory={
                "service": "projects/example-proj/locations/us-central1/namespaces/example-namespace/services/example-service",
                "generic_web_service": {
                    "allowed_ca_certs": ["BQA="],
                    "uri": "https://example.com",
                    "request_headers": {
                        "example-key": "example-value",
                    },
                    "webhook_type": "STANDARD",
                    "oauth_config": {
                        "client_id": "example-client-id",
                        "secret_version_for_client_secret": "projects/example-proj/secrets/example-secret/versions/example-version",
                        "token_endpoint": "https://example.com",
                        "scopes": ["example-scope"],
                    },
                    "service_agent_auth": "NONE",
                    "secret_version_for_username_password": "projects/example-proj/secrets/example-secret/versions/example-version",
                    "secret_versions_for_request_headers": [
                        {
                            "key": "example-key-1",
                            "secret_version": "projects/example-proj/secrets/example-secret/versions/example-version",
                        },
                        {
                            "key": "example-key-2",
                            "secret_version": "projects/example-proj/secrets/example-secret/versions/example-version-2",
                        },
                    ],
                },
            })
        ```
        ### Dialogflowcx Webhook Service Directory Flexible

        ```python
        import pulumi
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent",
            location="us-central1",
            default_language_code="en",
            supported_language_codes=[
                "it",
                "de",
                "es",
            ],
            time_zone="America/New_York",
            description="Example description.",
            avatar_uri="https://cloud.google.com/_static/images/cloud/icons/favicons/onecloud/super_cloud.png",
            enable_stackdriver_logging=True,
            enable_spell_correction=True,
            speech_to_text_settings={
                "enable_speech_adaptation": True,
            })
        flexible_webhook = gcp.diagflow.CxWebhook("flexible_webhook",
            parent=agent.id,
            display_name="MyFlow",
            service_directory={
                "service": "projects/example-proj/locations/us-central1/namespaces/example-namespace/services/example-service",
                "generic_web_service": {
                    "uri": "https://example.com",
                    "request_headers": {
                        "example-key": "example-value",
                    },
                    "webhook_type": "FLEXIBLE",
                    "oauth_config": {
                        "client_id": "example-client-id",
                        "client_secret": "projects/example-proj/secrets/example-secret/versions/example-version",
                        "token_endpoint": "https://example.com",
                    },
                    "service_agent_auth": "NONE",
                    "http_method": "POST",
                    "request_body": "{\\"example-key\\": \\"example-value\\"}",
                    "parameter_mapping": {
                        "example-parameter": "examplePath",
                    },
                },
            })
        ```

        ## Import

        Webhook can be imported using any of these accepted formats:

        * `{{parent}}/webhooks/{{name}}`

        * `{{parent}}/{{name}}`

        When using the `pulumi import` command, Webhook can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:diagflow/cxWebhook:CxWebhook default {{parent}}/webhooks/{{name}}
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxWebhook:CxWebhook default {{parent}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] disabled: Indicates whether the webhook is disabled.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the webhook, unique within the agent.
        :param pulumi.Input[_builtins.bool] enable_spell_correction: Deprecated. Indicates if automatic spell correction is enabled in detect intent requests.
        :param pulumi.Input[_builtins.bool] enable_stackdriver_logging: Deprecated. Determines whether this agent should log conversation queries.
        :param pulumi.Input[Union['CxWebhookGenericWebServiceArgs', 'CxWebhookGenericWebServiceArgsDict']] generic_web_service: Represents configuration for a generic web service.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] parent: The agent to create a webhook for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[_builtins.str] security_settings: Deprecated. Name of the SecuritySettings reference for the agent. Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
        :param pulumi.Input[Union['CxWebhookServiceDirectoryArgs', 'CxWebhookServiceDirectoryArgsDict']] service_directory: Configuration for a Service Directory service.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] timeout: Webhook execution timeout.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CxWebhookArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Webhooks host the developer's business logic. During a session, webhooks allow the developer to use the data extracted by Dialogflow's natural language processing to generate dynamic responses, validate collected data, or trigger actions on the backend.

        To get more information about Webhook, see:

        * [API documentation](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents.webhooks)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dialogflow/cx/docs)

        ## Example Usage

        ### Dialogflowcx Webhook Standard

        ```python
        import pulumi
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent",
            location="global",
            default_language_code="en",
            supported_language_codes=[
                "it",
                "de",
                "es",
            ],
            time_zone="America/New_York",
            description="Example description.",
            avatar_uri="https://cloud.google.com/_static/images/cloud/icons/favicons/onecloud/super_cloud.png",
            enable_stackdriver_logging=True,
            enable_spell_correction=True,
            speech_to_text_settings={
                "enable_speech_adaptation": True,
            })
        standard_webhook = gcp.diagflow.CxWebhook("standard_webhook",
            parent=agent.id,
            display_name="MyFlow",
            generic_web_service={
                "allowed_ca_certs": ["BQA="],
                "uri": "https://example.com",
                "request_headers": {
                    "example-key": "example-value",
                },
                "webhook_type": "STANDARD",
                "oauth_config": {
                    "client_id": "example-client-id",
                    "secret_version_for_client_secret": "projects/example-proj/secrets/example-secret/versions/example-version",
                    "token_endpoint": "https://example.com",
                    "scopes": ["example-scope"],
                },
                "service_agent_auth": "NONE",
                "secret_version_for_username_password": "projects/example-proj/secrets/example-secret/versions/example-version",
                "secret_versions_for_request_headers": [
                    {
                        "key": "example-key-1",
                        "secret_version": "projects/example-proj/secrets/example-secret/versions/example-version",
                    },
                    {
                        "key": "example-key-2",
                        "secret_version": "projects/example-proj/secrets/example-secret/versions/example-version-2",
                    },
                ],
            })
        ```
        ### Dialogflowcx Webhook Flexible

        ```python
        import pulumi
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent",
            location="global",
            default_language_code="en",
            supported_language_codes=[
                "it",
                "de",
                "es",
            ],
            time_zone="America/New_York",
            description="Example description.",
            avatar_uri="https://cloud.google.com/_static/images/cloud/icons/favicons/onecloud/super_cloud.png",
            enable_stackdriver_logging=True,
            enable_spell_correction=True,
            speech_to_text_settings={
                "enable_speech_adaptation": True,
            })
        flexible_webhook = gcp.diagflow.CxWebhook("flexible_webhook",
            parent=agent.id,
            display_name="MyFlow",
            generic_web_service={
                "uri": "https://example.com",
                "request_headers": {
                    "example-key": "example-value",
                },
                "webhook_type": "FLEXIBLE",
                "oauth_config": {
                    "client_id": "example-client-id",
                    "client_secret": "projects/example-proj/secrets/example-secret/versions/example-version",
                    "token_endpoint": "https://example.com",
                },
                "service_agent_auth": "NONE",
                "http_method": "POST",
                "request_body": "{\\"example-key\\": \\"example-value\\"}",
                "parameter_mapping": {
                    "example-parameter": "examplePath",
                },
            })
        ```
        ### Dialogflowcx Webhook Service Directory Standard

        ```python
        import pulumi
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent",
            location="us-central1",
            default_language_code="en",
            supported_language_codes=[
                "it",
                "de",
                "es",
            ],
            time_zone="America/New_York",
            description="Example description.",
            avatar_uri="https://cloud.google.com/_static/images/cloud/icons/favicons/onecloud/super_cloud.png",
            enable_stackdriver_logging=True,
            enable_spell_correction=True,
            speech_to_text_settings={
                "enable_speech_adaptation": True,
            })
        standard_webhook = gcp.diagflow.CxWebhook("standard_webhook",
            parent=agent.id,
            display_name="MyFlow",
            service_directory={
                "service": "projects/example-proj/locations/us-central1/namespaces/example-namespace/services/example-service",
                "generic_web_service": {
                    "allowed_ca_certs": ["BQA="],
                    "uri": "https://example.com",
                    "request_headers": {
                        "example-key": "example-value",
                    },
                    "webhook_type": "STANDARD",
                    "oauth_config": {
                        "client_id": "example-client-id",
                        "secret_version_for_client_secret": "projects/example-proj/secrets/example-secret/versions/example-version",
                        "token_endpoint": "https://example.com",
                        "scopes": ["example-scope"],
                    },
                    "service_agent_auth": "NONE",
                    "secret_version_for_username_password": "projects/example-proj/secrets/example-secret/versions/example-version",
                    "secret_versions_for_request_headers": [
                        {
                            "key": "example-key-1",
                            "secret_version": "projects/example-proj/secrets/example-secret/versions/example-version",
                        },
                        {
                            "key": "example-key-2",
                            "secret_version": "projects/example-proj/secrets/example-secret/versions/example-version-2",
                        },
                    ],
                },
            })
        ```
        ### Dialogflowcx Webhook Service Directory Flexible

        ```python
        import pulumi
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent",
            location="us-central1",
            default_language_code="en",
            supported_language_codes=[
                "it",
                "de",
                "es",
            ],
            time_zone="America/New_York",
            description="Example description.",
            avatar_uri="https://cloud.google.com/_static/images/cloud/icons/favicons/onecloud/super_cloud.png",
            enable_stackdriver_logging=True,
            enable_spell_correction=True,
            speech_to_text_settings={
                "enable_speech_adaptation": True,
            })
        flexible_webhook = gcp.diagflow.CxWebhook("flexible_webhook",
            parent=agent.id,
            display_name="MyFlow",
            service_directory={
                "service": "projects/example-proj/locations/us-central1/namespaces/example-namespace/services/example-service",
                "generic_web_service": {
                    "uri": "https://example.com",
                    "request_headers": {
                        "example-key": "example-value",
                    },
                    "webhook_type": "FLEXIBLE",
                    "oauth_config": {
                        "client_id": "example-client-id",
                        "client_secret": "projects/example-proj/secrets/example-secret/versions/example-version",
                        "token_endpoint": "https://example.com",
                    },
                    "service_agent_auth": "NONE",
                    "http_method": "POST",
                    "request_body": "{\\"example-key\\": \\"example-value\\"}",
                    "parameter_mapping": {
                        "example-parameter": "examplePath",
                    },
                },
            })
        ```

        ## Import

        Webhook can be imported using any of these accepted formats:

        * `{{parent}}/webhooks/{{name}}`

        * `{{parent}}/{{name}}`

        When using the `pulumi import` command, Webhook can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:diagflow/cxWebhook:CxWebhook default {{parent}}/webhooks/{{name}}
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxWebhook:CxWebhook default {{parent}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param CxWebhookArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CxWebhookArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_spell_correction: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_stackdriver_logging: Optional[pulumi.Input[_builtins.bool]] = None,
                 generic_web_service: Optional[pulumi.Input[Union['CxWebhookGenericWebServiceArgs', 'CxWebhookGenericWebServiceArgsDict']]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 security_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 service_directory: Optional[pulumi.Input[Union['CxWebhookServiceDirectoryArgs', 'CxWebhookServiceDirectoryArgsDict']]] = None,
                 timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CxWebhookArgs.__new__(CxWebhookArgs)

            __props__.__dict__["disabled"] = disabled
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["enable_spell_correction"] = enable_spell_correction
            __props__.__dict__["enable_stackdriver_logging"] = enable_stackdriver_logging
            __props__.__dict__["generic_web_service"] = generic_web_service
            __props__.__dict__["parent"] = parent
            __props__.__dict__["security_settings"] = security_settings
            __props__.__dict__["service_directory"] = service_directory
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["name"] = None
            __props__.__dict__["start_flow"] = None
        super(CxWebhook, __self__).__init__(
            'gcp:diagflow/cxWebhook:CxWebhook',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            enable_spell_correction: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_stackdriver_logging: Optional[pulumi.Input[_builtins.bool]] = None,
            generic_web_service: Optional[pulumi.Input[Union['CxWebhookGenericWebServiceArgs', 'CxWebhookGenericWebServiceArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parent: Optional[pulumi.Input[_builtins.str]] = None,
            security_settings: Optional[pulumi.Input[_builtins.str]] = None,
            service_directory: Optional[pulumi.Input[Union['CxWebhookServiceDirectoryArgs', 'CxWebhookServiceDirectoryArgsDict']]] = None,
            start_flow: Optional[pulumi.Input[_builtins.str]] = None,
            timeout: Optional[pulumi.Input[_builtins.str]] = None) -> 'CxWebhook':
        """
        Get an existing CxWebhook resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] disabled: Indicates whether the webhook is disabled.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the webhook, unique within the agent.
        :param pulumi.Input[_builtins.bool] enable_spell_correction: Deprecated. Indicates if automatic spell correction is enabled in detect intent requests.
        :param pulumi.Input[_builtins.bool] enable_stackdriver_logging: Deprecated. Determines whether this agent should log conversation queries.
        :param pulumi.Input[Union['CxWebhookGenericWebServiceArgs', 'CxWebhookGenericWebServiceArgsDict']] generic_web_service: Represents configuration for a generic web service.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The unique identifier of the webhook.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
        :param pulumi.Input[_builtins.str] parent: The agent to create a webhook for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[_builtins.str] security_settings: Deprecated. Name of the SecuritySettings reference for the agent. Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
        :param pulumi.Input[Union['CxWebhookServiceDirectoryArgs', 'CxWebhookServiceDirectoryArgsDict']] service_directory: Configuration for a Service Directory service.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] start_flow: Deprecated. Name of the start flow in this agent. A start flow will be automatically created when the agent is created, and can only be deleted by deleting the agent. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        :param pulumi.Input[_builtins.str] timeout: Webhook execution timeout.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CxWebhookState.__new__(_CxWebhookState)

        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enable_spell_correction"] = enable_spell_correction
        __props__.__dict__["enable_stackdriver_logging"] = enable_stackdriver_logging
        __props__.__dict__["generic_web_service"] = generic_web_service
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        __props__.__dict__["security_settings"] = security_settings
        __props__.__dict__["service_directory"] = service_directory
        __props__.__dict__["start_flow"] = start_flow
        __props__.__dict__["timeout"] = timeout
        return CxWebhook(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether the webhook is disabled.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The human-readable name of the webhook, unique within the agent.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="enableSpellCorrection")
    def enable_spell_correction(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Deprecated. Indicates if automatic spell correction is enabled in detect intent requests.
        """
        return pulumi.get(self, "enable_spell_correction")

    @_builtins.property
    @pulumi.getter(name="enableStackdriverLogging")
    def enable_stackdriver_logging(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Deprecated. Determines whether this agent should log conversation queries.
        """
        return pulumi.get(self, "enable_stackdriver_logging")

    @_builtins.property
    @pulumi.getter(name="genericWebService")
    def generic_web_service(self) -> pulumi.Output[Optional['outputs.CxWebhookGenericWebService']]:
        """
        Represents configuration for a generic web service.
        Structure is documented below.
        """
        return pulumi.get(self, "generic_web_service")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the webhook.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parent(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The agent to create a webhook for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        return pulumi.get(self, "parent")

    @_builtins.property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Deprecated. Name of the SecuritySettings reference for the agent. Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
        """
        return pulumi.get(self, "security_settings")

    @_builtins.property
    @pulumi.getter(name="serviceDirectory")
    def service_directory(self) -> pulumi.Output[Optional['outputs.CxWebhookServiceDirectory']]:
        """
        Configuration for a Service Directory service.
        Structure is documented below.
        """
        return pulumi.get(self, "service_directory")

    @_builtins.property
    @pulumi.getter(name="startFlow")
    def start_flow(self) -> pulumi.Output[_builtins.str]:
        """
        Deprecated. Name of the start flow in this agent. A start flow will be automatically created when the agent is created, and can only be deleted by deleting the agent. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        """
        return pulumi.get(self, "start_flow")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Webhook execution timeout.
        """
        return pulumi.get(self, "timeout")

