# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DataStoreArgs', 'DataStore']

@pulumi.input_type
class DataStoreArgs:
    def __init__(__self__, *,
                 content_config: pulumi.Input[_builtins.str],
                 data_store_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 industry_vertical: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 advanced_site_search_config: Optional[pulumi.Input['DataStoreAdvancedSiteSearchConfigArgs']] = None,
                 create_advanced_site_search: Optional[pulumi.Input[_builtins.bool]] = None,
                 document_processing_config: Optional[pulumi.Input['DataStoreDocumentProcessingConfigArgs']] = None,
                 kms_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_default_schema_creation: Optional[pulumi.Input[_builtins.bool]] = None,
                 solution_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a DataStore resource.
        :param pulumi.Input[_builtins.str] content_config: The content config of the data store.
               Possible values are: `NO_CONTENT`, `CONTENT_REQUIRED`, `PUBLIC_WEBSITE`.
        :param pulumi.Input[_builtins.str] data_store_id: The unique id of the data store.
        :param pulumi.Input[_builtins.str] display_name: The display name of the data store. This field must be a UTF-8 encoded
               string with a length limit of 128 characters.
        :param pulumi.Input[_builtins.str] industry_vertical: The industry vertical that the data store registers.
               Possible values are: `GENERIC`, `MEDIA`, `HEALTHCARE_FHIR`.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input['DataStoreAdvancedSiteSearchConfigArgs'] advanced_site_search_config: Configuration data for advance site search.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] create_advanced_site_search: If true, an advanced data store for site search will be created. If the
               data store is not configured as site search (GENERIC vertical and
               PUBLIC_WEBSITE contentConfig), this flag will be ignored.
        :param pulumi.Input['DataStoreDocumentProcessingConfigArgs'] document_processing_config: Configuration for Document understanding and enrichment.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] kms_key_name: KMS key resource name which will be used to encrypt resources:
               `/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId}`
               The KMS key to be used to protect this DataStore at creation time. Must be
               set for requests that need to comply with CMEK Org Policy protections.
               If this field is set and processed successfully, the DataStore will be
               protected by the KMS key, as indicated in the cmek_config field.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.bool] skip_default_schema_creation: A boolean flag indicating whether to skip the default schema creation for
               the data store. Only enable this flag if you are certain that the default
               schema is incompatible with your use case.
               If set to true, you must manually create a schema for the data store
               before any documents can be ingested.
               This flag cannot be specified if `data_store.starting_schema` is
               specified.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] solution_types: The solutions that the data store enrolls.
               Each value may be one of: `SOLUTION_TYPE_RECOMMENDATION`, `SOLUTION_TYPE_SEARCH`, `SOLUTION_TYPE_CHAT`, `SOLUTION_TYPE_GENERATIVE_CHAT`.
        """
        pulumi.set(__self__, "content_config", content_config)
        pulumi.set(__self__, "data_store_id", data_store_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "industry_vertical", industry_vertical)
        pulumi.set(__self__, "location", location)
        if advanced_site_search_config is not None:
            pulumi.set(__self__, "advanced_site_search_config", advanced_site_search_config)
        if create_advanced_site_search is not None:
            pulumi.set(__self__, "create_advanced_site_search", create_advanced_site_search)
        if document_processing_config is not None:
            pulumi.set(__self__, "document_processing_config", document_processing_config)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if skip_default_schema_creation is not None:
            pulumi.set(__self__, "skip_default_schema_creation", skip_default_schema_creation)
        if solution_types is not None:
            pulumi.set(__self__, "solution_types", solution_types)

    @_builtins.property
    @pulumi.getter(name="contentConfig")
    def content_config(self) -> pulumi.Input[_builtins.str]:
        """
        The content config of the data store.
        Possible values are: `NO_CONTENT`, `CONTENT_REQUIRED`, `PUBLIC_WEBSITE`.
        """
        return pulumi.get(self, "content_config")

    @content_config.setter
    def content_config(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "content_config", value)

    @_builtins.property
    @pulumi.getter(name="dataStoreId")
    def data_store_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique id of the data store.
        """
        return pulumi.get(self, "data_store_id")

    @data_store_id.setter
    def data_store_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_store_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The display name of the data store. This field must be a UTF-8 encoded
        string with a length limit of 128 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="industryVertical")
    def industry_vertical(self) -> pulumi.Input[_builtins.str]:
        """
        The industry vertical that the data store registers.
        Possible values are: `GENERIC`, `MEDIA`, `HEALTHCARE_FHIR`.
        """
        return pulumi.get(self, "industry_vertical")

    @industry_vertical.setter
    def industry_vertical(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "industry_vertical", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="advancedSiteSearchConfig")
    def advanced_site_search_config(self) -> Optional[pulumi.Input['DataStoreAdvancedSiteSearchConfigArgs']]:
        """
        Configuration data for advance site search.
        Structure is documented below.
        """
        return pulumi.get(self, "advanced_site_search_config")

    @advanced_site_search_config.setter
    def advanced_site_search_config(self, value: Optional[pulumi.Input['DataStoreAdvancedSiteSearchConfigArgs']]):
        pulumi.set(self, "advanced_site_search_config", value)

    @_builtins.property
    @pulumi.getter(name="createAdvancedSiteSearch")
    def create_advanced_site_search(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, an advanced data store for site search will be created. If the
        data store is not configured as site search (GENERIC vertical and
        PUBLIC_WEBSITE contentConfig), this flag will be ignored.
        """
        return pulumi.get(self, "create_advanced_site_search")

    @create_advanced_site_search.setter
    def create_advanced_site_search(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "create_advanced_site_search", value)

    @_builtins.property
    @pulumi.getter(name="documentProcessingConfig")
    def document_processing_config(self) -> Optional[pulumi.Input['DataStoreDocumentProcessingConfigArgs']]:
        """
        Configuration for Document understanding and enrichment.
        Structure is documented below.
        """
        return pulumi.get(self, "document_processing_config")

    @document_processing_config.setter
    def document_processing_config(self, value: Optional[pulumi.Input['DataStoreDocumentProcessingConfigArgs']]):
        pulumi.set(self, "document_processing_config", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        KMS key resource name which will be used to encrypt resources:
        `/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId}`
        The KMS key to be used to protect this DataStore at creation time. Must be
        set for requests that need to comply with CMEK Org Policy protections.
        If this field is set and processed successfully, the DataStore will be
        protected by the KMS key, as indicated in the cmek_config field.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="skipDefaultSchemaCreation")
    def skip_default_schema_creation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean flag indicating whether to skip the default schema creation for
        the data store. Only enable this flag if you are certain that the default
        schema is incompatible with your use case.
        If set to true, you must manually create a schema for the data store
        before any documents can be ingested.
        This flag cannot be specified if `data_store.starting_schema` is
        specified.
        """
        return pulumi.get(self, "skip_default_schema_creation")

    @skip_default_schema_creation.setter
    def skip_default_schema_creation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_default_schema_creation", value)

    @_builtins.property
    @pulumi.getter(name="solutionTypes")
    def solution_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The solutions that the data store enrolls.
        Each value may be one of: `SOLUTION_TYPE_RECOMMENDATION`, `SOLUTION_TYPE_SEARCH`, `SOLUTION_TYPE_CHAT`, `SOLUTION_TYPE_GENERATIVE_CHAT`.
        """
        return pulumi.get(self, "solution_types")

    @solution_types.setter
    def solution_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "solution_types", value)


@pulumi.input_type
class _DataStoreState:
    def __init__(__self__, *,
                 advanced_site_search_config: Optional[pulumi.Input['DataStoreAdvancedSiteSearchConfigArgs']] = None,
                 content_config: Optional[pulumi.Input[_builtins.str]] = None,
                 create_advanced_site_search: Optional[pulumi.Input[_builtins.bool]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 data_store_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_schema_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 document_processing_config: Optional[pulumi.Input['DataStoreDocumentProcessingConfigArgs']] = None,
                 industry_vertical: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_default_schema_creation: Optional[pulumi.Input[_builtins.bool]] = None,
                 solution_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering DataStore resources.
        :param pulumi.Input['DataStoreAdvancedSiteSearchConfigArgs'] advanced_site_search_config: Configuration data for advance site search.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] content_config: The content config of the data store.
               Possible values are: `NO_CONTENT`, `CONTENT_REQUIRED`, `PUBLIC_WEBSITE`.
        :param pulumi.Input[_builtins.bool] create_advanced_site_search: If true, an advanced data store for site search will be created. If the
               data store is not configured as site search (GENERIC vertical and
               PUBLIC_WEBSITE contentConfig), this flag will be ignored.
        :param pulumi.Input[_builtins.str] create_time: Timestamp when the DataStore was created.
        :param pulumi.Input[_builtins.str] data_store_id: The unique id of the data store.
        :param pulumi.Input[_builtins.str] default_schema_id: The id of the default Schema associated with this data store.
        :param pulumi.Input[_builtins.str] display_name: The display name of the data store. This field must be a UTF-8 encoded
               string with a length limit of 128 characters.
        :param pulumi.Input['DataStoreDocumentProcessingConfigArgs'] document_processing_config: Configuration for Document understanding and enrichment.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] industry_vertical: The industry vertical that the data store registers.
               Possible values are: `GENERIC`, `MEDIA`, `HEALTHCARE_FHIR`.
        :param pulumi.Input[_builtins.str] kms_key_name: KMS key resource name which will be used to encrypt resources:
               `/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId}`
               The KMS key to be used to protect this DataStore at creation time. Must be
               set for requests that need to comply with CMEK Org Policy protections.
               If this field is set and processed successfully, the DataStore will be
               protected by the KMS key, as indicated in the cmek_config field.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[_builtins.str] name: The unique full resource name of the data store. Values are of the format
               `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
               This field must be a UTF-8 encoded string with a length limit of 1024
               characters.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.bool] skip_default_schema_creation: A boolean flag indicating whether to skip the default schema creation for
               the data store. Only enable this flag if you are certain that the default
               schema is incompatible with your use case.
               If set to true, you must manually create a schema for the data store
               before any documents can be ingested.
               This flag cannot be specified if `data_store.starting_schema` is
               specified.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] solution_types: The solutions that the data store enrolls.
               Each value may be one of: `SOLUTION_TYPE_RECOMMENDATION`, `SOLUTION_TYPE_SEARCH`, `SOLUTION_TYPE_CHAT`, `SOLUTION_TYPE_GENERATIVE_CHAT`.
        """
        if advanced_site_search_config is not None:
            pulumi.set(__self__, "advanced_site_search_config", advanced_site_search_config)
        if content_config is not None:
            pulumi.set(__self__, "content_config", content_config)
        if create_advanced_site_search is not None:
            pulumi.set(__self__, "create_advanced_site_search", create_advanced_site_search)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if data_store_id is not None:
            pulumi.set(__self__, "data_store_id", data_store_id)
        if default_schema_id is not None:
            pulumi.set(__self__, "default_schema_id", default_schema_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if document_processing_config is not None:
            pulumi.set(__self__, "document_processing_config", document_processing_config)
        if industry_vertical is not None:
            pulumi.set(__self__, "industry_vertical", industry_vertical)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if skip_default_schema_creation is not None:
            pulumi.set(__self__, "skip_default_schema_creation", skip_default_schema_creation)
        if solution_types is not None:
            pulumi.set(__self__, "solution_types", solution_types)

    @_builtins.property
    @pulumi.getter(name="advancedSiteSearchConfig")
    def advanced_site_search_config(self) -> Optional[pulumi.Input['DataStoreAdvancedSiteSearchConfigArgs']]:
        """
        Configuration data for advance site search.
        Structure is documented below.
        """
        return pulumi.get(self, "advanced_site_search_config")

    @advanced_site_search_config.setter
    def advanced_site_search_config(self, value: Optional[pulumi.Input['DataStoreAdvancedSiteSearchConfigArgs']]):
        pulumi.set(self, "advanced_site_search_config", value)

    @_builtins.property
    @pulumi.getter(name="contentConfig")
    def content_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content config of the data store.
        Possible values are: `NO_CONTENT`, `CONTENT_REQUIRED`, `PUBLIC_WEBSITE`.
        """
        return pulumi.get(self, "content_config")

    @content_config.setter
    def content_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_config", value)

    @_builtins.property
    @pulumi.getter(name="createAdvancedSiteSearch")
    def create_advanced_site_search(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, an advanced data store for site search will be created. If the
        data store is not configured as site search (GENERIC vertical and
        PUBLIC_WEBSITE contentConfig), this flag will be ignored.
        """
        return pulumi.get(self, "create_advanced_site_search")

    @create_advanced_site_search.setter
    def create_advanced_site_search(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "create_advanced_site_search", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the DataStore was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="dataStoreId")
    def data_store_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique id of the data store.
        """
        return pulumi.get(self, "data_store_id")

    @data_store_id.setter
    def data_store_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_store_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultSchemaId")
    def default_schema_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the default Schema associated with this data store.
        """
        return pulumi.get(self, "default_schema_id")

    @default_schema_id.setter
    def default_schema_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_schema_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the data store. This field must be a UTF-8 encoded
        string with a length limit of 128 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="documentProcessingConfig")
    def document_processing_config(self) -> Optional[pulumi.Input['DataStoreDocumentProcessingConfigArgs']]:
        """
        Configuration for Document understanding and enrichment.
        Structure is documented below.
        """
        return pulumi.get(self, "document_processing_config")

    @document_processing_config.setter
    def document_processing_config(self, value: Optional[pulumi.Input['DataStoreDocumentProcessingConfigArgs']]):
        pulumi.set(self, "document_processing_config", value)

    @_builtins.property
    @pulumi.getter(name="industryVertical")
    def industry_vertical(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The industry vertical that the data store registers.
        Possible values are: `GENERIC`, `MEDIA`, `HEALTHCARE_FHIR`.
        """
        return pulumi.get(self, "industry_vertical")

    @industry_vertical.setter
    def industry_vertical(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "industry_vertical", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        KMS key resource name which will be used to encrypt resources:
        `/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId}`
        The KMS key to be used to protect this DataStore at creation time. Must be
        set for requests that need to comply with CMEK Org Policy protections.
        If this field is set and processed successfully, the DataStore will be
        protected by the KMS key, as indicated in the cmek_config field.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique full resource name of the data store. Values are of the format
        `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
        This field must be a UTF-8 encoded string with a length limit of 1024
        characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="skipDefaultSchemaCreation")
    def skip_default_schema_creation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean flag indicating whether to skip the default schema creation for
        the data store. Only enable this flag if you are certain that the default
        schema is incompatible with your use case.
        If set to true, you must manually create a schema for the data store
        before any documents can be ingested.
        This flag cannot be specified if `data_store.starting_schema` is
        specified.
        """
        return pulumi.get(self, "skip_default_schema_creation")

    @skip_default_schema_creation.setter
    def skip_default_schema_creation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_default_schema_creation", value)

    @_builtins.property
    @pulumi.getter(name="solutionTypes")
    def solution_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The solutions that the data store enrolls.
        Each value may be one of: `SOLUTION_TYPE_RECOMMENDATION`, `SOLUTION_TYPE_SEARCH`, `SOLUTION_TYPE_CHAT`, `SOLUTION_TYPE_GENERATIVE_CHAT`.
        """
        return pulumi.get(self, "solution_types")

    @solution_types.setter
    def solution_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "solution_types", value)


@pulumi.type_token("gcp:discoveryengine/dataStore:DataStore")
class DataStore(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_site_search_config: Optional[pulumi.Input[Union['DataStoreAdvancedSiteSearchConfigArgs', 'DataStoreAdvancedSiteSearchConfigArgsDict']]] = None,
                 content_config: Optional[pulumi.Input[_builtins.str]] = None,
                 create_advanced_site_search: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_store_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 document_processing_config: Optional[pulumi.Input[Union['DataStoreDocumentProcessingConfigArgs', 'DataStoreDocumentProcessingConfigArgsDict']]] = None,
                 industry_vertical: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_default_schema_creation: Optional[pulumi.Input[_builtins.bool]] = None,
                 solution_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Data store is a collection of websites and documents used to find answers for
        end-user's questions in Discovery Engine (a.k.a. Vertex AI Search and
        Conversation).

        To get more information about DataStore, see:

        * [API documentation](https://cloud.google.com/generative-ai-app-builder/docs/reference/rest/v1/projects.locations.collections.dataStores)
        * How-to Guides
            * [Create a search data store](https://cloud.google.com/generative-ai-app-builder/docs/create-data-store-es)

        ## Example Usage

        ### Discoveryengine Datastore Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.discoveryengine.DataStore("basic",
            location="global",
            data_store_id="data-store-id",
            display_name="tf-test-structured-datastore",
            industry_vertical="GENERIC",
            content_config="NO_CONTENT",
            solution_types=["SOLUTION_TYPE_SEARCH"],
            create_advanced_site_search=False,
            skip_default_schema_creation=False)
        ```
        ### Discoveryengine Datastore Kms Key Name

        ```python
        import pulumi
        import pulumi_gcp as gcp

        kms_key_name = gcp.discoveryengine.DataStore("kms_key_name",
            location="us",
            data_store_id="data-store-id",
            display_name="tf-test-structured-datastore",
            industry_vertical="GENERIC",
            content_config="NO_CONTENT",
            solution_types=["SOLUTION_TYPE_SEARCH"],
            kms_key_name="kms-key",
            create_advanced_site_search=False,
            skip_default_schema_creation=False)
        ```
        ### Discoveryengine Datastore Document Processing Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        document_processing_config = gcp.discoveryengine.DataStore("document_processing_config",
            location="global",
            data_store_id="data-store-id",
            display_name="tf-test-structured-datastore",
            industry_vertical="GENERIC",
            content_config="NO_CONTENT",
            solution_types=["SOLUTION_TYPE_SEARCH"],
            create_advanced_site_search=False,
            document_processing_config={
                "default_parsing_config": {
                    "digital_parsing_config": {},
                },
                "parsing_config_overrides": [{
                    "file_type": "pdf",
                    "ocr_parsing_config": {
                        "use_native_text": True,
                    },
                }],
            })
        ```
        ### Discoveryengine Datastore Advanced Site Search Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        advanced_site_search_config = gcp.discoveryengine.DataStore("advanced_site_search_config",
            location="global",
            data_store_id="data-store-id",
            display_name="tf-test-advanced-site-search-config-datastore",
            industry_vertical="GENERIC",
            content_config="PUBLIC_WEBSITE",
            solution_types=["SOLUTION_TYPE_CHAT"],
            create_advanced_site_search=True,
            skip_default_schema_creation=False,
            advanced_site_search_config={
                "disable_initial_index": True,
                "disable_automatic_refresh": True,
            })
        ```

        ## Import

        DataStore can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/collections/default_collection/dataStores/{{data_store_id}}`

        * `{{project}}/{{location}}/{{data_store_id}}`

        * `{{location}}/{{data_store_id}}`

        When using the `pulumi import` command, DataStore can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:discoveryengine/dataStore:DataStore default projects/{{project}}/locations/{{location}}/collections/default_collection/dataStores/{{data_store_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/dataStore:DataStore default {{project}}/{{location}}/{{data_store_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/dataStore:DataStore default {{location}}/{{data_store_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DataStoreAdvancedSiteSearchConfigArgs', 'DataStoreAdvancedSiteSearchConfigArgsDict']] advanced_site_search_config: Configuration data for advance site search.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] content_config: The content config of the data store.
               Possible values are: `NO_CONTENT`, `CONTENT_REQUIRED`, `PUBLIC_WEBSITE`.
        :param pulumi.Input[_builtins.bool] create_advanced_site_search: If true, an advanced data store for site search will be created. If the
               data store is not configured as site search (GENERIC vertical and
               PUBLIC_WEBSITE contentConfig), this flag will be ignored.
        :param pulumi.Input[_builtins.str] data_store_id: The unique id of the data store.
        :param pulumi.Input[_builtins.str] display_name: The display name of the data store. This field must be a UTF-8 encoded
               string with a length limit of 128 characters.
        :param pulumi.Input[Union['DataStoreDocumentProcessingConfigArgs', 'DataStoreDocumentProcessingConfigArgsDict']] document_processing_config: Configuration for Document understanding and enrichment.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] industry_vertical: The industry vertical that the data store registers.
               Possible values are: `GENERIC`, `MEDIA`, `HEALTHCARE_FHIR`.
        :param pulumi.Input[_builtins.str] kms_key_name: KMS key resource name which will be used to encrypt resources:
               `/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId}`
               The KMS key to be used to protect this DataStore at creation time. Must be
               set for requests that need to comply with CMEK Org Policy protections.
               If this field is set and processed successfully, the DataStore will be
               protected by the KMS key, as indicated in the cmek_config field.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.bool] skip_default_schema_creation: A boolean flag indicating whether to skip the default schema creation for
               the data store. Only enable this flag if you are certain that the default
               schema is incompatible with your use case.
               If set to true, you must manually create a schema for the data store
               before any documents can be ingested.
               This flag cannot be specified if `data_store.starting_schema` is
               specified.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] solution_types: The solutions that the data store enrolls.
               Each value may be one of: `SOLUTION_TYPE_RECOMMENDATION`, `SOLUTION_TYPE_SEARCH`, `SOLUTION_TYPE_CHAT`, `SOLUTION_TYPE_GENERATIVE_CHAT`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataStoreArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Data store is a collection of websites and documents used to find answers for
        end-user's questions in Discovery Engine (a.k.a. Vertex AI Search and
        Conversation).

        To get more information about DataStore, see:

        * [API documentation](https://cloud.google.com/generative-ai-app-builder/docs/reference/rest/v1/projects.locations.collections.dataStores)
        * How-to Guides
            * [Create a search data store](https://cloud.google.com/generative-ai-app-builder/docs/create-data-store-es)

        ## Example Usage

        ### Discoveryengine Datastore Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.discoveryengine.DataStore("basic",
            location="global",
            data_store_id="data-store-id",
            display_name="tf-test-structured-datastore",
            industry_vertical="GENERIC",
            content_config="NO_CONTENT",
            solution_types=["SOLUTION_TYPE_SEARCH"],
            create_advanced_site_search=False,
            skip_default_schema_creation=False)
        ```
        ### Discoveryengine Datastore Kms Key Name

        ```python
        import pulumi
        import pulumi_gcp as gcp

        kms_key_name = gcp.discoveryengine.DataStore("kms_key_name",
            location="us",
            data_store_id="data-store-id",
            display_name="tf-test-structured-datastore",
            industry_vertical="GENERIC",
            content_config="NO_CONTENT",
            solution_types=["SOLUTION_TYPE_SEARCH"],
            kms_key_name="kms-key",
            create_advanced_site_search=False,
            skip_default_schema_creation=False)
        ```
        ### Discoveryengine Datastore Document Processing Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        document_processing_config = gcp.discoveryengine.DataStore("document_processing_config",
            location="global",
            data_store_id="data-store-id",
            display_name="tf-test-structured-datastore",
            industry_vertical="GENERIC",
            content_config="NO_CONTENT",
            solution_types=["SOLUTION_TYPE_SEARCH"],
            create_advanced_site_search=False,
            document_processing_config={
                "default_parsing_config": {
                    "digital_parsing_config": {},
                },
                "parsing_config_overrides": [{
                    "file_type": "pdf",
                    "ocr_parsing_config": {
                        "use_native_text": True,
                    },
                }],
            })
        ```
        ### Discoveryengine Datastore Advanced Site Search Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        advanced_site_search_config = gcp.discoveryengine.DataStore("advanced_site_search_config",
            location="global",
            data_store_id="data-store-id",
            display_name="tf-test-advanced-site-search-config-datastore",
            industry_vertical="GENERIC",
            content_config="PUBLIC_WEBSITE",
            solution_types=["SOLUTION_TYPE_CHAT"],
            create_advanced_site_search=True,
            skip_default_schema_creation=False,
            advanced_site_search_config={
                "disable_initial_index": True,
                "disable_automatic_refresh": True,
            })
        ```

        ## Import

        DataStore can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/collections/default_collection/dataStores/{{data_store_id}}`

        * `{{project}}/{{location}}/{{data_store_id}}`

        * `{{location}}/{{data_store_id}}`

        When using the `pulumi import` command, DataStore can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:discoveryengine/dataStore:DataStore default projects/{{project}}/locations/{{location}}/collections/default_collection/dataStores/{{data_store_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/dataStore:DataStore default {{project}}/{{location}}/{{data_store_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/dataStore:DataStore default {{location}}/{{data_store_id}}
        ```

        :param str resource_name: The name of the resource.
        :param DataStoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataStoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_site_search_config: Optional[pulumi.Input[Union['DataStoreAdvancedSiteSearchConfigArgs', 'DataStoreAdvancedSiteSearchConfigArgsDict']]] = None,
                 content_config: Optional[pulumi.Input[_builtins.str]] = None,
                 create_advanced_site_search: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_store_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 document_processing_config: Optional[pulumi.Input[Union['DataStoreDocumentProcessingConfigArgs', 'DataStoreDocumentProcessingConfigArgsDict']]] = None,
                 industry_vertical: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_default_schema_creation: Optional[pulumi.Input[_builtins.bool]] = None,
                 solution_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataStoreArgs.__new__(DataStoreArgs)

            __props__.__dict__["advanced_site_search_config"] = advanced_site_search_config
            if content_config is None and not opts.urn:
                raise TypeError("Missing required property 'content_config'")
            __props__.__dict__["content_config"] = content_config
            __props__.__dict__["create_advanced_site_search"] = create_advanced_site_search
            if data_store_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_store_id'")
            __props__.__dict__["data_store_id"] = data_store_id
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["document_processing_config"] = document_processing_config
            if industry_vertical is None and not opts.urn:
                raise TypeError("Missing required property 'industry_vertical'")
            __props__.__dict__["industry_vertical"] = industry_vertical
            __props__.__dict__["kms_key_name"] = kms_key_name
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["skip_default_schema_creation"] = skip_default_schema_creation
            __props__.__dict__["solution_types"] = solution_types
            __props__.__dict__["create_time"] = None
            __props__.__dict__["default_schema_id"] = None
            __props__.__dict__["name"] = None
        super(DataStore, __self__).__init__(
            'gcp:discoveryengine/dataStore:DataStore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advanced_site_search_config: Optional[pulumi.Input[Union['DataStoreAdvancedSiteSearchConfigArgs', 'DataStoreAdvancedSiteSearchConfigArgsDict']]] = None,
            content_config: Optional[pulumi.Input[_builtins.str]] = None,
            create_advanced_site_search: Optional[pulumi.Input[_builtins.bool]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            data_store_id: Optional[pulumi.Input[_builtins.str]] = None,
            default_schema_id: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            document_processing_config: Optional[pulumi.Input[Union['DataStoreDocumentProcessingConfigArgs', 'DataStoreDocumentProcessingConfigArgsDict']]] = None,
            industry_vertical: Optional[pulumi.Input[_builtins.str]] = None,
            kms_key_name: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            skip_default_schema_creation: Optional[pulumi.Input[_builtins.bool]] = None,
            solution_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'DataStore':
        """
        Get an existing DataStore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DataStoreAdvancedSiteSearchConfigArgs', 'DataStoreAdvancedSiteSearchConfigArgsDict']] advanced_site_search_config: Configuration data for advance site search.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] content_config: The content config of the data store.
               Possible values are: `NO_CONTENT`, `CONTENT_REQUIRED`, `PUBLIC_WEBSITE`.
        :param pulumi.Input[_builtins.bool] create_advanced_site_search: If true, an advanced data store for site search will be created. If the
               data store is not configured as site search (GENERIC vertical and
               PUBLIC_WEBSITE contentConfig), this flag will be ignored.
        :param pulumi.Input[_builtins.str] create_time: Timestamp when the DataStore was created.
        :param pulumi.Input[_builtins.str] data_store_id: The unique id of the data store.
        :param pulumi.Input[_builtins.str] default_schema_id: The id of the default Schema associated with this data store.
        :param pulumi.Input[_builtins.str] display_name: The display name of the data store. This field must be a UTF-8 encoded
               string with a length limit of 128 characters.
        :param pulumi.Input[Union['DataStoreDocumentProcessingConfigArgs', 'DataStoreDocumentProcessingConfigArgsDict']] document_processing_config: Configuration for Document understanding and enrichment.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] industry_vertical: The industry vertical that the data store registers.
               Possible values are: `GENERIC`, `MEDIA`, `HEALTHCARE_FHIR`.
        :param pulumi.Input[_builtins.str] kms_key_name: KMS key resource name which will be used to encrypt resources:
               `/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId}`
               The KMS key to be used to protect this DataStore at creation time. Must be
               set for requests that need to comply with CMEK Org Policy protections.
               If this field is set and processed successfully, the DataStore will be
               protected by the KMS key, as indicated in the cmek_config field.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[_builtins.str] name: The unique full resource name of the data store. Values are of the format
               `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
               This field must be a UTF-8 encoded string with a length limit of 1024
               characters.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.bool] skip_default_schema_creation: A boolean flag indicating whether to skip the default schema creation for
               the data store. Only enable this flag if you are certain that the default
               schema is incompatible with your use case.
               If set to true, you must manually create a schema for the data store
               before any documents can be ingested.
               This flag cannot be specified if `data_store.starting_schema` is
               specified.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] solution_types: The solutions that the data store enrolls.
               Each value may be one of: `SOLUTION_TYPE_RECOMMENDATION`, `SOLUTION_TYPE_SEARCH`, `SOLUTION_TYPE_CHAT`, `SOLUTION_TYPE_GENERATIVE_CHAT`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataStoreState.__new__(_DataStoreState)

        __props__.__dict__["advanced_site_search_config"] = advanced_site_search_config
        __props__.__dict__["content_config"] = content_config
        __props__.__dict__["create_advanced_site_search"] = create_advanced_site_search
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["data_store_id"] = data_store_id
        __props__.__dict__["default_schema_id"] = default_schema_id
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["document_processing_config"] = document_processing_config
        __props__.__dict__["industry_vertical"] = industry_vertical
        __props__.__dict__["kms_key_name"] = kms_key_name
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["skip_default_schema_creation"] = skip_default_schema_creation
        __props__.__dict__["solution_types"] = solution_types
        return DataStore(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="advancedSiteSearchConfig")
    def advanced_site_search_config(self) -> pulumi.Output[Optional['outputs.DataStoreAdvancedSiteSearchConfig']]:
        """
        Configuration data for advance site search.
        Structure is documented below.
        """
        return pulumi.get(self, "advanced_site_search_config")

    @_builtins.property
    @pulumi.getter(name="contentConfig")
    def content_config(self) -> pulumi.Output[_builtins.str]:
        """
        The content config of the data store.
        Possible values are: `NO_CONTENT`, `CONTENT_REQUIRED`, `PUBLIC_WEBSITE`.
        """
        return pulumi.get(self, "content_config")

    @_builtins.property
    @pulumi.getter(name="createAdvancedSiteSearch")
    def create_advanced_site_search(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, an advanced data store for site search will be created. If the
        data store is not configured as site search (GENERIC vertical and
        PUBLIC_WEBSITE contentConfig), this flag will be ignored.
        """
        return pulumi.get(self, "create_advanced_site_search")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when the DataStore was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dataStoreId")
    def data_store_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique id of the data store.
        """
        return pulumi.get(self, "data_store_id")

    @_builtins.property
    @pulumi.getter(name="defaultSchemaId")
    def default_schema_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the default Schema associated with this data store.
        """
        return pulumi.get(self, "default_schema_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The display name of the data store. This field must be a UTF-8 encoded
        string with a length limit of 128 characters.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="documentProcessingConfig")
    def document_processing_config(self) -> pulumi.Output[Optional['outputs.DataStoreDocumentProcessingConfig']]:
        """
        Configuration for Document understanding and enrichment.
        Structure is documented below.
        """
        return pulumi.get(self, "document_processing_config")

    @_builtins.property
    @pulumi.getter(name="industryVertical")
    def industry_vertical(self) -> pulumi.Output[_builtins.str]:
        """
        The industry vertical that the data store registers.
        Possible values are: `GENERIC`, `MEDIA`, `HEALTHCARE_FHIR`.
        """
        return pulumi.get(self, "industry_vertical")

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        KMS key resource name which will be used to encrypt resources:
        `/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId}`
        The KMS key to be used to protect this DataStore at creation time. Must be
        set for requests that need to comply with CMEK Org Policy protections.
        If this field is set and processed successfully, the DataStore will be
        protected by the KMS key, as indicated in the cmek_config field.
        """
        return pulumi.get(self, "kms_key_name")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The unique full resource name of the data store. Values are of the format
        `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
        This field must be a UTF-8 encoded string with a length limit of 1024
        characters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="skipDefaultSchemaCreation")
    def skip_default_schema_creation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        A boolean flag indicating whether to skip the default schema creation for
        the data store. Only enable this flag if you are certain that the default
        schema is incompatible with your use case.
        If set to true, you must manually create a schema for the data store
        before any documents can be ingested.
        This flag cannot be specified if `data_store.starting_schema` is
        specified.
        """
        return pulumi.get(self, "skip_default_schema_creation")

    @_builtins.property
    @pulumi.getter(name="solutionTypes")
    def solution_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The solutions that the data store enrolls.
        Each value may be one of: `SOLUTION_TYPE_RECOMMENDATION`, `SOLUTION_TYPE_SEARCH`, `SOLUTION_TYPE_CHAT`, `SOLUTION_TYPE_GENERATIVE_CHAT`.
        """
        return pulumi.get(self, "solution_types")

