# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppHostingBuildArgs', 'AppHostingBuild']

@pulumi.input_type
class AppHostingBuildArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[_builtins.str],
                 build_id: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 source: pulumi.Input['AppHostingBuildSourceArgs'],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AppHostingBuild resource.
        :param pulumi.Input[_builtins.str] backend: The ID of the Backend that this Build applies to
        :param pulumi.Input[_builtins.str] build_id: The user-specified ID of the build being created.
        :param pulumi.Input[_builtins.str] location: The location of the Backend that this Build applies to
        :param pulumi.Input['AppHostingBuildSourceArgs'] source: The source for the build.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Unstructured key value map that may be set by external tools to
               store and arbitrary metadata. They are not queryable and should be
               preserved when modifying objects.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] display_name: Human-readable name. 63 character limit.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Unstructured key value map that can be used to organize and categorize
               objects.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "build_id", build_id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "source", source)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Backend that this Build applies to
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="buildId")
    def build_id(self) -> pulumi.Input[_builtins.str]:
        """
        The user-specified ID of the build being created.
        """
        return pulumi.get(self, "build_id")

    @build_id.setter
    def build_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "build_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location of the Backend that this Build applies to
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Input['AppHostingBuildSourceArgs']:
        """
        The source for the build.
        Structure is documented below.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['AppHostingBuildSourceArgs']):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Unstructured key value map that may be set by external tools to
        store and arbitrary metadata. They are not queryable and should be
        preserved when modifying objects.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable name. 63 character limit.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Unstructured key value map that can be used to organize and categorize
        objects.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _AppHostingBuildState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 build_id: Optional[pulumi.Input[_builtins.str]] = None,
                 build_logs_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 error_source: Optional[pulumi.Input[_builtins.str]] = None,
                 errors: Optional[pulumi.Input[Sequence[pulumi.Input['AppHostingBuildErrorArgs']]]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 image: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 source: Optional[pulumi.Input['AppHostingBuildSourceArgs']] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppHostingBuild resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Unstructured key value map that may be set by external tools to
               store and arbitrary metadata. They are not queryable and should be
               preserved when modifying objects.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] backend: The ID of the Backend that this Build applies to
        :param pulumi.Input[_builtins.str] build_id: The user-specified ID of the build being created.
        :param pulumi.Input[_builtins.str] build_logs_uri: The location of the [Cloud Build
               logs](https://cloud.google.com/build/docs/view-build-results) for the build
               process.
        :param pulumi.Input[_builtins.str] create_time: Time at which the build was created.
        :param pulumi.Input[_builtins.str] display_name: Human-readable name. 63 character limit.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] environment: The environment name of the backend when this build was created.
        :param pulumi.Input[_builtins.str] error_source: The source of the error for the build, if in a `FAILED` state.
               Possible values:
               CLOUD_BUILD
               CLOUD_RUN
        :param pulumi.Input[Sequence[pulumi.Input['AppHostingBuildErrorArgs']]] errors: The `Status` type defines a logical error model that is suitable for
               different programming environments, including REST APIs and RPC APIs. It is
               used by [gRPC](https://github.com/grpc). Each `Status` message contains
               three pieces of data: error code, error message, and error details.
               You can find out more about this error model and how to work with it in the
               [API Design Guide](https://cloud.google.com/apis/design/errors).
               Structure is documented below.
        :param pulumi.Input[_builtins.str] etag: Server-computed checksum based on other values; may be sent
               on update or delete to ensure operation is done on expected resource.
        :param pulumi.Input[_builtins.str] image: The Artifact Registry
               [container
               image](https://cloud.google.com/artifact-registry/docs/reference/rest/v1/projects.locations.repositories.dockerImages)
               URI, used by the Cloud Run
               [`revision`](https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.services.revisions)
               for this build.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Unstructured key value map that can be used to organize and categorize
               objects.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location of the Backend that this Build applies to
        :param pulumi.Input[_builtins.str] name: Identifier. The resource name of the build.
               Format:
               `projects/{project}/locations/{locationId}/backends/{backendId}/builds/{buildId}`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input['AppHostingBuildSourceArgs'] source: The source for the build.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] state: The state of the build.
               Possible values:
               BUILDING
               BUILT
               DEPLOYING
               READY
               FAILED
        :param pulumi.Input[_builtins.str] uid: System-assigned, unique identifier.
        :param pulumi.Input[_builtins.str] update_time: Time at which the build was last updated.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if build_id is not None:
            pulumi.set(__self__, "build_id", build_id)
        if build_logs_uri is not None:
            pulumi.set(__self__, "build_logs_uri", build_logs_uri)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if error_source is not None:
            pulumi.set(__self__, "error_source", error_source)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Unstructured key value map that may be set by external tools to
        store and arbitrary metadata. They are not queryable and should be
        preserved when modifying objects.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Backend that this Build applies to
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="buildId")
    def build_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user-specified ID of the build being created.
        """
        return pulumi.get(self, "build_id")

    @build_id.setter
    def build_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "build_id", value)

    @_builtins.property
    @pulumi.getter(name="buildLogsUri")
    def build_logs_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the [Cloud Build
        logs](https://cloud.google.com/build/docs/view-build-results) for the build
        process.
        """
        return pulumi.get(self, "build_logs_uri")

    @build_logs_uri.setter
    def build_logs_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "build_logs_uri", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time at which the build was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable name. 63 character limit.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The environment name of the backend when this build was created.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="errorSource")
    def error_source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source of the error for the build, if in a `FAILED` state.
        Possible values:
        CLOUD_BUILD
        CLOUD_RUN
        """
        return pulumi.get(self, "error_source")

    @error_source.setter
    def error_source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "error_source", value)

    @_builtins.property
    @pulumi.getter
    def errors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppHostingBuildErrorArgs']]]]:
        """
        The `Status` type defines a logical error model that is suitable for
        different programming environments, including REST APIs and RPC APIs. It is
        used by [gRPC](https://github.com/grpc). Each `Status` message contains
        three pieces of data: error code, error message, and error details.
        You can find out more about this error model and how to work with it in the
        [API Design Guide](https://cloud.google.com/apis/design/errors).
        Structure is documented below.
        """
        return pulumi.get(self, "errors")

    @errors.setter
    def errors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppHostingBuildErrorArgs']]]]):
        pulumi.set(self, "errors", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Server-computed checksum based on other values; may be sent
        on update or delete to ensure operation is done on expected resource.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Artifact Registry
        [container
        image](https://cloud.google.com/artifact-registry/docs/reference/rest/v1/projects.locations.repositories.dockerImages)
        URI, used by the Cloud Run
        [`revision`](https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.services.revisions)
        for this build.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Unstructured key value map that can be used to organize and categorize
        objects.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the Backend that this Build applies to
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. The resource name of the build.
        Format:
        `projects/{project}/locations/{locationId}/backends/{backendId}/builds/{buildId}`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['AppHostingBuildSourceArgs']]:
        """
        The source for the build.
        Structure is documented below.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['AppHostingBuildSourceArgs']]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of the build.
        Possible values:
        BUILDING
        BUILT
        DEPLOYING
        READY
        FAILED
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        System-assigned, unique identifier.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time at which the build was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:firebase/appHostingBuild:AppHostingBuild")
class AppHostingBuild(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 build_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[Union['AppHostingBuildSourceArgs', 'AppHostingBuildSourceArgsDict']]] = None,
                 __props__=None):
        """
        A single build for a backend, at a specific point codebase reference tag
        and point in time. Encapsulates several resources, including an Artifact Registry
        container image, a Cloud Build invocation that built the image, and the
        Cloud Run revision that uses that image.

        ## Example Usage

        ### Firebase App Hosting Build Minimal

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ### Include these blocks only once per project if you are starting from scratch ###
        service_account = gcp.serviceaccount.Account("service_account",
            project="my-project-name",
            account_id="firebase-app-hosting-compute",
            display_name="Firebase App Hosting compute service account",
            create_ignore_already_exists=True)
        fah = gcp.projects.Service("fah",
            project="my-project-name",
            service="firebaseapphosting.googleapis.com")
        example_app_hosting_backend = gcp.firebase.AppHostingBackend("example",
            project="my-project-name",
            location="us-central1",
            backend_id="mini",
            app_id="1:0000000000:web:674cde32020e16fbce9dbd",
            serving_locality="GLOBAL_ACCESS",
            service_account=service_account.email,
            opts = pulumi.ResourceOptions(depends_on=[fah]))
        example = gcp.firebase.AppHostingBuild("example",
            project=example_app_hosting_backend.project,
            location=example_app_hosting_backend.location,
            backend=example_app_hosting_backend.backend_id,
            build_id="mini-build",
            source={
                "container": {
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                },
            })
        app_hosting_sa_runner = gcp.projects.IAMMember("app_hosting_sa_runner",
            project="my-project-name",
            role="roles/firebaseapphosting.computeRunner",
            member=service_account.member)
        ```
        ### Firebase App Hosting Build Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ### Include these blocks only once per project if you are starting from scratch ###
        service_account = gcp.serviceaccount.Account("service_account",
            project="my-project-name",
            account_id="firebase-app-hosting-compute",
            display_name="Firebase App Hosting compute service account",
            create_ignore_already_exists=True)
        fah = gcp.projects.Service("fah",
            project="my-project-name",
            service="firebaseapphosting.googleapis.com")
        example_app_hosting_backend = gcp.firebase.AppHostingBackend("example",
            project="my-project-name",
            location="us-central1",
            backend_id="full",
            app_id="1:0000000000:web:674cde32020e16fbce9dbd",
            serving_locality="GLOBAL_ACCESS",
            service_account=service_account.email,
            opts = pulumi.ResourceOptions(depends_on=[fah]))
        example = gcp.firebase.AppHostingBuild("example",
            project=example_app_hosting_backend.project,
            location=example_app_hosting_backend.location,
            backend=example_app_hosting_backend.backend_id,
            build_id="full-build",
            display_name="My Build",
            annotations={
                "key": "value",
            },
            labels={
                "key": "value",
            },
            source={
                "container": {
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                },
            })
        app_hosting_sa_runner = gcp.projects.IAMMember("app_hosting_sa_runner",
            project="my-project-name",
            role="roles/firebaseapphosting.computeRunner",
            member=service_account.member)
        ```
        ## Import

        Build can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/backends/{{backend}}/builds/{{build_id}}`

        * `{{project}}/{{location}}/{{backend}}/{{build_id}}`

        * `{{location}}/{{backend}}/{{build_id}}`

        When using the `pulumi import` command, Build can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firebase/appHostingBuild:AppHostingBuild default projects/{{project}}/locations/{{location}}/backends/{{backend}}/builds/{{build_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appHostingBuild:AppHostingBuild default {{project}}/{{location}}/{{backend}}/{{build_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appHostingBuild:AppHostingBuild default {{location}}/{{backend}}/{{build_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Unstructured key value map that may be set by external tools to
               store and arbitrary metadata. They are not queryable and should be
               preserved when modifying objects.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] backend: The ID of the Backend that this Build applies to
        :param pulumi.Input[_builtins.str] build_id: The user-specified ID of the build being created.
        :param pulumi.Input[_builtins.str] display_name: Human-readable name. 63 character limit.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Unstructured key value map that can be used to organize and categorize
               objects.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location of the Backend that this Build applies to
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['AppHostingBuildSourceArgs', 'AppHostingBuildSourceArgsDict']] source: The source for the build.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppHostingBuildArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A single build for a backend, at a specific point codebase reference tag
        and point in time. Encapsulates several resources, including an Artifact Registry
        container image, a Cloud Build invocation that built the image, and the
        Cloud Run revision that uses that image.

        ## Example Usage

        ### Firebase App Hosting Build Minimal

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ### Include these blocks only once per project if you are starting from scratch ###
        service_account = gcp.serviceaccount.Account("service_account",
            project="my-project-name",
            account_id="firebase-app-hosting-compute",
            display_name="Firebase App Hosting compute service account",
            create_ignore_already_exists=True)
        fah = gcp.projects.Service("fah",
            project="my-project-name",
            service="firebaseapphosting.googleapis.com")
        example_app_hosting_backend = gcp.firebase.AppHostingBackend("example",
            project="my-project-name",
            location="us-central1",
            backend_id="mini",
            app_id="1:0000000000:web:674cde32020e16fbce9dbd",
            serving_locality="GLOBAL_ACCESS",
            service_account=service_account.email,
            opts = pulumi.ResourceOptions(depends_on=[fah]))
        example = gcp.firebase.AppHostingBuild("example",
            project=example_app_hosting_backend.project,
            location=example_app_hosting_backend.location,
            backend=example_app_hosting_backend.backend_id,
            build_id="mini-build",
            source={
                "container": {
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                },
            })
        app_hosting_sa_runner = gcp.projects.IAMMember("app_hosting_sa_runner",
            project="my-project-name",
            role="roles/firebaseapphosting.computeRunner",
            member=service_account.member)
        ```
        ### Firebase App Hosting Build Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ### Include these blocks only once per project if you are starting from scratch ###
        service_account = gcp.serviceaccount.Account("service_account",
            project="my-project-name",
            account_id="firebase-app-hosting-compute",
            display_name="Firebase App Hosting compute service account",
            create_ignore_already_exists=True)
        fah = gcp.projects.Service("fah",
            project="my-project-name",
            service="firebaseapphosting.googleapis.com")
        example_app_hosting_backend = gcp.firebase.AppHostingBackend("example",
            project="my-project-name",
            location="us-central1",
            backend_id="full",
            app_id="1:0000000000:web:674cde32020e16fbce9dbd",
            serving_locality="GLOBAL_ACCESS",
            service_account=service_account.email,
            opts = pulumi.ResourceOptions(depends_on=[fah]))
        example = gcp.firebase.AppHostingBuild("example",
            project=example_app_hosting_backend.project,
            location=example_app_hosting_backend.location,
            backend=example_app_hosting_backend.backend_id,
            build_id="full-build",
            display_name="My Build",
            annotations={
                "key": "value",
            },
            labels={
                "key": "value",
            },
            source={
                "container": {
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                },
            })
        app_hosting_sa_runner = gcp.projects.IAMMember("app_hosting_sa_runner",
            project="my-project-name",
            role="roles/firebaseapphosting.computeRunner",
            member=service_account.member)
        ```
        ## Import

        Build can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/backends/{{backend}}/builds/{{build_id}}`

        * `{{project}}/{{location}}/{{backend}}/{{build_id}}`

        * `{{location}}/{{backend}}/{{build_id}}`

        When using the `pulumi import` command, Build can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firebase/appHostingBuild:AppHostingBuild default projects/{{project}}/locations/{{location}}/backends/{{backend}}/builds/{{build_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appHostingBuild:AppHostingBuild default {{project}}/{{location}}/{{backend}}/{{build_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appHostingBuild:AppHostingBuild default {{location}}/{{backend}}/{{build_id}}
        ```

        :param str resource_name: The name of the resource.
        :param AppHostingBuildArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppHostingBuildArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 build_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[Union['AppHostingBuildSourceArgs', 'AppHostingBuildSourceArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppHostingBuildArgs.__new__(AppHostingBuildArgs)

            __props__.__dict__["annotations"] = annotations
            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            if build_id is None and not opts.urn:
                raise TypeError("Missing required property 'build_id'")
            __props__.__dict__["build_id"] = build_id
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["build_logs_uri"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["environment"] = None
            __props__.__dict__["error_source"] = None
            __props__.__dict__["errors"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["image"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AppHostingBuild, __self__).__init__(
            'gcp:firebase/appHostingBuild:AppHostingBuild',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            build_id: Optional[pulumi.Input[_builtins.str]] = None,
            build_logs_uri: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            environment: Optional[pulumi.Input[_builtins.str]] = None,
            error_source: Optional[pulumi.Input[_builtins.str]] = None,
            errors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppHostingBuildErrorArgs', 'AppHostingBuildErrorArgsDict']]]]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            image: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            source: Optional[pulumi.Input[Union['AppHostingBuildSourceArgs', 'AppHostingBuildSourceArgsDict']]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'AppHostingBuild':
        """
        Get an existing AppHostingBuild resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Unstructured key value map that may be set by external tools to
               store and arbitrary metadata. They are not queryable and should be
               preserved when modifying objects.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] backend: The ID of the Backend that this Build applies to
        :param pulumi.Input[_builtins.str] build_id: The user-specified ID of the build being created.
        :param pulumi.Input[_builtins.str] build_logs_uri: The location of the [Cloud Build
               logs](https://cloud.google.com/build/docs/view-build-results) for the build
               process.
        :param pulumi.Input[_builtins.str] create_time: Time at which the build was created.
        :param pulumi.Input[_builtins.str] display_name: Human-readable name. 63 character limit.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] environment: The environment name of the backend when this build was created.
        :param pulumi.Input[_builtins.str] error_source: The source of the error for the build, if in a `FAILED` state.
               Possible values:
               CLOUD_BUILD
               CLOUD_RUN
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppHostingBuildErrorArgs', 'AppHostingBuildErrorArgsDict']]]] errors: The `Status` type defines a logical error model that is suitable for
               different programming environments, including REST APIs and RPC APIs. It is
               used by [gRPC](https://github.com/grpc). Each `Status` message contains
               three pieces of data: error code, error message, and error details.
               You can find out more about this error model and how to work with it in the
               [API Design Guide](https://cloud.google.com/apis/design/errors).
               Structure is documented below.
        :param pulumi.Input[_builtins.str] etag: Server-computed checksum based on other values; may be sent
               on update or delete to ensure operation is done on expected resource.
        :param pulumi.Input[_builtins.str] image: The Artifact Registry
               [container
               image](https://cloud.google.com/artifact-registry/docs/reference/rest/v1/projects.locations.repositories.dockerImages)
               URI, used by the Cloud Run
               [`revision`](https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.services.revisions)
               for this build.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Unstructured key value map that can be used to organize and categorize
               objects.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location of the Backend that this Build applies to
        :param pulumi.Input[_builtins.str] name: Identifier. The resource name of the build.
               Format:
               `projects/{project}/locations/{locationId}/backends/{backendId}/builds/{buildId}`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Union['AppHostingBuildSourceArgs', 'AppHostingBuildSourceArgsDict']] source: The source for the build.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] state: The state of the build.
               Possible values:
               BUILDING
               BUILT
               DEPLOYING
               READY
               FAILED
        :param pulumi.Input[_builtins.str] uid: System-assigned, unique identifier.
        :param pulumi.Input[_builtins.str] update_time: Time at which the build was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppHostingBuildState.__new__(_AppHostingBuildState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["backend"] = backend
        __props__.__dict__["build_id"] = build_id
        __props__.__dict__["build_logs_uri"] = build_logs_uri
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["environment"] = environment
        __props__.__dict__["error_source"] = error_source
        __props__.__dict__["errors"] = errors
        __props__.__dict__["etag"] = etag
        __props__.__dict__["image"] = image
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["source"] = source
        __props__.__dict__["state"] = state
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return AppHostingBuild(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Unstructured key value map that may be set by external tools to
        store and arbitrary metadata. They are not queryable and should be
        preserved when modifying objects.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Backend that this Build applies to
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="buildId")
    def build_id(self) -> pulumi.Output[_builtins.str]:
        """
        The user-specified ID of the build being created.
        """
        return pulumi.get(self, "build_id")

    @_builtins.property
    @pulumi.getter(name="buildLogsUri")
    def build_logs_uri(self) -> pulumi.Output[_builtins.str]:
        """
        The location of the [Cloud Build
        logs](https://cloud.google.com/build/docs/view-build-results) for the build
        process.
        """
        return pulumi.get(self, "build_logs_uri")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time at which the build was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Human-readable name. 63 character limit.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output[_builtins.str]:
        """
        The environment name of the backend when this build was created.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter(name="errorSource")
    def error_source(self) -> pulumi.Output[_builtins.str]:
        """
        The source of the error for the build, if in a `FAILED` state.
        Possible values:
        CLOUD_BUILD
        CLOUD_RUN
        """
        return pulumi.get(self, "error_source")

    @_builtins.property
    @pulumi.getter
    def errors(self) -> pulumi.Output[Sequence['outputs.AppHostingBuildError']]:
        """
        The `Status` type defines a logical error model that is suitable for
        different programming environments, including REST APIs and RPC APIs. It is
        used by [gRPC](https://github.com/grpc). Each `Status` message contains
        three pieces of data: error code, error message, and error details.
        You can find out more about this error model and how to work with it in the
        [API Design Guide](https://cloud.google.com/apis/design/errors).
        Structure is documented below.
        """
        return pulumi.get(self, "errors")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        Server-computed checksum based on other values; may be sent
        on update or delete to ensure operation is done on expected resource.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def image(self) -> pulumi.Output[_builtins.str]:
        """
        The Artifact Registry
        [container
        image](https://cloud.google.com/artifact-registry/docs/reference/rest/v1/projects.locations.repositories.dockerImages)
        URI, used by the Cloud Run
        [`revision`](https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.services.revisions)
        for this build.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Unstructured key value map that can be used to organize and categorize
        objects.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location of the Backend that this Build applies to
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. The resource name of the build.
        Format:
        `projects/{project}/locations/{locationId}/backends/{backendId}/builds/{buildId}`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output['outputs.AppHostingBuildSource']:
        """
        The source for the build.
        Structure is documented below.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The state of the build.
        Possible values:
        BUILDING
        BUILT
        DEPLOYING
        READY
        FAILED
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        System-assigned, unique identifier.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time at which the build was last updated.
        """
        return pulumi.get(self, "update_time")

