# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AppHostingBackendCodebase',
    'AppHostingBackendManagedResource',
    'AppHostingBackendManagedResourceRunService',
    'AppHostingBuildError',
    'AppHostingBuildSource',
    'AppHostingBuildSourceCodebase',
    'AppHostingBuildSourceCodebaseAuthor',
    'AppHostingBuildSourceContainer',
    'AppHostingDomainCustomDomainStatus',
    'AppHostingDomainCustomDomainStatusIssue',
    'AppHostingDomainCustomDomainStatusRequiredDnsUpdate',
    'AppHostingDomainCustomDomainStatusRequiredDnsUpdateDesired',
    'AppHostingDomainCustomDomainStatusRequiredDnsUpdateDesiredCheckError',
    'AppHostingDomainCustomDomainStatusRequiredDnsUpdateDesiredRecord',
    'AppHostingDomainCustomDomainStatusRequiredDnsUpdateDiscovered',
    'AppHostingDomainCustomDomainStatusRequiredDnsUpdateDiscoveredCheckError',
    'AppHostingDomainCustomDomainStatusRequiredDnsUpdateDiscoveredRecord',
    'AppHostingDomainServe',
    'AppHostingDomainServeRedirect',
    'AppHostingTrafficCurrent',
    'AppHostingTrafficCurrentSplit',
    'AppHostingTrafficRolloutPolicy',
    'AppHostingTrafficTarget',
    'AppHostingTrafficTargetSplit',
    'ExtensionsInstanceConfig',
    'ExtensionsInstanceErrorStatus',
    'ExtensionsInstanceRuntimeData',
    'ExtensionsInstanceRuntimeDataFatalError',
    'ExtensionsInstanceRuntimeDataProcessingState',
    'HostingCustomDomainCert',
    'HostingCustomDomainCertVerification',
    'HostingCustomDomainCertVerificationDns',
    'HostingCustomDomainCertVerificationDnsDesired',
    'HostingCustomDomainCertVerificationDnsDesiredRecord',
    'HostingCustomDomainCertVerificationDnsDiscovered',
    'HostingCustomDomainCertVerificationDnsDiscoveredRecord',
    'HostingCustomDomainCertVerificationHttp',
    'HostingCustomDomainIssue',
    'HostingCustomDomainRequiredDnsUpdate',
    'HostingCustomDomainRequiredDnsUpdateDesired',
    'HostingCustomDomainRequiredDnsUpdateDesiredRecord',
    'HostingCustomDomainRequiredDnsUpdateDiscovered',
    'HostingCustomDomainRequiredDnsUpdateDiscoveredRecord',
    'HostingVersionConfig',
    'HostingVersionConfigHeader',
    'HostingVersionConfigRedirect',
    'HostingVersionConfigRewrite',
    'HostingVersionConfigRewriteRun',
]

@pulumi.output_type
class AppHostingBackendCodebase(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rootDirectory":
            suggest = "root_directory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppHostingBackendCodebase. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppHostingBackendCodebase.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppHostingBackendCodebase.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repository: _builtins.str,
                 root_directory: Optional[_builtins.str] = None):
        """
        :param _builtins.str repository: The resource name for the Developer Connect
               [`gitRepositoryLink`](https://cloud.google.com/developer-connect/docs/api/reference/rest/v1/projects.locations.connections.gitRepositoryLinks)
               connected to this backend, in the format:
               projects/{project}/locations/{location}/connections/{connection}/gitRepositoryLinks/{repositoryLink}
        :param _builtins.str root_directory: If `repository` is provided, the directory relative to the root of the
               repository to use as the root for the deployed web app.
        """
        pulumi.set(__self__, "repository", repository)
        if root_directory is not None:
            pulumi.set(__self__, "root_directory", root_directory)

    @_builtins.property
    @pulumi.getter
    def repository(self) -> _builtins.str:
        """
        The resource name for the Developer Connect
        [`gitRepositoryLink`](https://cloud.google.com/developer-connect/docs/api/reference/rest/v1/projects.locations.connections.gitRepositoryLinks)
        connected to this backend, in the format:
        projects/{project}/locations/{location}/connections/{connection}/gitRepositoryLinks/{repositoryLink}
        """
        return pulumi.get(self, "repository")

    @_builtins.property
    @pulumi.getter(name="rootDirectory")
    def root_directory(self) -> Optional[_builtins.str]:
        """
        If `repository` is provided, the directory relative to the root of the
        repository to use as the root for the deployed web app.
        """
        return pulumi.get(self, "root_directory")


@pulumi.output_type
class AppHostingBackendManagedResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runServices":
            suggest = "run_services"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppHostingBackendManagedResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppHostingBackendManagedResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppHostingBackendManagedResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 run_services: Optional[Sequence['outputs.AppHostingBackendManagedResourceRunService']] = None):
        """
        :param Sequence['AppHostingBackendManagedResourceRunServiceArgs'] run_services: (Output)
               A managed Cloud Run
               [`service`](https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.services#resource:-service).
               Structure is documented below.
        """
        if run_services is not None:
            pulumi.set(__self__, "run_services", run_services)

    @_builtins.property
    @pulumi.getter(name="runServices")
    def run_services(self) -> Optional[Sequence['outputs.AppHostingBackendManagedResourceRunService']]:
        """
        (Output)
        A managed Cloud Run
        [`service`](https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.services#resource:-service).
        Structure is documented below.
        """
        return pulumi.get(self, "run_services")


@pulumi.output_type
class AppHostingBackendManagedResourceRunService(dict):
    def __init__(__self__, *,
                 service: Optional[_builtins.str] = None):
        """
        :param _builtins.str service: (Output)
               The name of the Cloud Run
               [`service`](https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.services#resource:-service),
               in the format:
               projects/{project}/locations/{location}/services/{serviceId}
        """
        if service is not None:
            pulumi.set(__self__, "service", service)

    @_builtins.property
    @pulumi.getter
    def service(self) -> Optional[_builtins.str]:
        """
        (Output)
        The name of the Cloud Run
        [`service`](https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.services#resource:-service),
        in the format:
        projects/{project}/locations/{location}/services/{serviceId}
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class AppHostingBuildError(dict):
    def __init__(__self__, *,
                 code: Optional[_builtins.int] = None,
                 details: Optional[Sequence[Mapping[str, _builtins.str]]] = None,
                 message: Optional[_builtins.str] = None):
        """
        :param _builtins.int code: (Output)
               The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, _builtins.str]] details: (Output)
               A list of messages that carry the error details. There is a common set of
               message types for APIs to use.
        :param _builtins.str message: (Output)
               A developer-facing error message, which should be in English. Any
               user-facing error message should be localized and sent in the
               google.rpc.Status.details field, or localized by the client.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[_builtins.int]:
        """
        (Output)
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def details(self) -> Optional[Sequence[Mapping[str, _builtins.str]]]:
        """
        (Output)
        A list of messages that carry the error details. There is a common set of
        message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        (Output)
        A developer-facing error message, which should be in English. Any
        user-facing error message should be localized and sent in the
        google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class AppHostingBuildSource(dict):
    def __init__(__self__, *,
                 codebase: Optional['outputs.AppHostingBuildSourceCodebase'] = None,
                 container: Optional['outputs.AppHostingBuildSourceContainer'] = None):
        """
        :param 'AppHostingBuildSourceCodebaseArgs' codebase: A codebase source, representing the state of the codebase
               that the build will be created at.
               Structure is documented below.
        :param 'AppHostingBuildSourceContainerArgs' container: The URI of an Artifact Registry
               [container
               image](https://cloud.google.com/artifact-registry/docs/reference/rest/v1/projects.locations.repositories.dockerImages)
               to use as the build source.
               Structure is documented below.
        """
        if codebase is not None:
            pulumi.set(__self__, "codebase", codebase)
        if container is not None:
            pulumi.set(__self__, "container", container)

    @_builtins.property
    @pulumi.getter
    def codebase(self) -> Optional['outputs.AppHostingBuildSourceCodebase']:
        """
        A codebase source, representing the state of the codebase
        that the build will be created at.
        Structure is documented below.
        """
        return pulumi.get(self, "codebase")

    @_builtins.property
    @pulumi.getter
    def container(self) -> Optional['outputs.AppHostingBuildSourceContainer']:
        """
        The URI of an Artifact Registry
        [container
        image](https://cloud.google.com/artifact-registry/docs/reference/rest/v1/projects.locations.repositories.dockerImages)
        to use as the build source.
        Structure is documented below.
        """
        return pulumi.get(self, "container")


@pulumi.output_type
class AppHostingBuildSourceCodebase(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commitMessage":
            suggest = "commit_message"
        elif key == "commitTime":
            suggest = "commit_time"
        elif key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppHostingBuildSourceCodebase. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppHostingBuildSourceCodebase.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppHostingBuildSourceCodebase.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authors: Optional[Sequence['outputs.AppHostingBuildSourceCodebaseAuthor']] = None,
                 branch: Optional[_builtins.str] = None,
                 commit: Optional[_builtins.str] = None,
                 commit_message: Optional[_builtins.str] = None,
                 commit_time: Optional[_builtins.str] = None,
                 display_name: Optional[_builtins.str] = None,
                 hash: Optional[_builtins.str] = None,
                 uri: Optional[_builtins.str] = None):
        """
        :param Sequence['AppHostingBuildSourceCodebaseAuthorArgs'] authors: (Output)
               Version control metadata for a user associated with a resolved codebase.
               Currently assumes a Git user.
               Structure is documented below.
        :param _builtins.str branch: The branch in the codebase to build from, using the latest commit.
        :param _builtins.str commit: The commit in the codebase to build from.
               
               
               <a name="nested_source_codebase_author"></a>The `author` block contains:
        :param _builtins.str commit_message: (Output)
               The message of a codebase change.
        :param _builtins.str commit_time: (Output)
               The time the change was made.
        :param _builtins.str display_name: (Output)
               The 'name' field in a Git user's git.config. Required by Git.
        :param _builtins.str hash: (Output)
               The full SHA-1 hash of a Git commit, if available.
        :param _builtins.str uri: (Output)
               A URI linking to the codebase on an hosting provider's website. May
               not be valid if the commit has been rebased or force-pushed out of
               existence in the linked repository.
        """
        if authors is not None:
            pulumi.set(__self__, "authors", authors)
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if commit is not None:
            pulumi.set(__self__, "commit", commit)
        if commit_message is not None:
            pulumi.set(__self__, "commit_message", commit_message)
        if commit_time is not None:
            pulumi.set(__self__, "commit_time", commit_time)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if hash is not None:
            pulumi.set(__self__, "hash", hash)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def authors(self) -> Optional[Sequence['outputs.AppHostingBuildSourceCodebaseAuthor']]:
        """
        (Output)
        Version control metadata for a user associated with a resolved codebase.
        Currently assumes a Git user.
        Structure is documented below.
        """
        return pulumi.get(self, "authors")

    @_builtins.property
    @pulumi.getter
    def branch(self) -> Optional[_builtins.str]:
        """
        The branch in the codebase to build from, using the latest commit.
        """
        return pulumi.get(self, "branch")

    @_builtins.property
    @pulumi.getter
    def commit(self) -> Optional[_builtins.str]:
        """
        The commit in the codebase to build from.


        <a name="nested_source_codebase_author"></a>The `author` block contains:
        """
        return pulumi.get(self, "commit")

    @_builtins.property
    @pulumi.getter(name="commitMessage")
    def commit_message(self) -> Optional[_builtins.str]:
        """
        (Output)
        The message of a codebase change.
        """
        return pulumi.get(self, "commit_message")

    @_builtins.property
    @pulumi.getter(name="commitTime")
    def commit_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        The time the change was made.
        """
        return pulumi.get(self, "commit_time")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        (Output)
        The 'name' field in a Git user's git.config. Required by Git.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def hash(self) -> Optional[_builtins.str]:
        """
        (Output)
        The full SHA-1 hash of a Git commit, if available.
        """
        return pulumi.get(self, "hash")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[_builtins.str]:
        """
        (Output)
        A URI linking to the codebase on an hosting provider's website. May
        not be valid if the commit has been rebased or force-pushed out of
        existence in the linked repository.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class AppHostingBuildSourceCodebaseAuthor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "imageUri":
            suggest = "image_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppHostingBuildSourceCodebaseAuthor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppHostingBuildSourceCodebaseAuthor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppHostingBuildSourceCodebaseAuthor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[_builtins.str] = None,
                 email: Optional[_builtins.str] = None,
                 image_uri: Optional[_builtins.str] = None):
        """
        :param _builtins.str display_name: Human-readable name. 63 character limit.
        :param _builtins.str email: The 'email' field in a Git user's git.config, if available.
        :param _builtins.str image_uri: The URI of an image file associated with the user's account in an
               external source control provider, if available.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if image_uri is not None:
            pulumi.set(__self__, "image_uri", image_uri)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        Human-readable name. 63 character limit.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[_builtins.str]:
        """
        The 'email' field in a Git user's git.config, if available.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> Optional[_builtins.str]:
        """
        The URI of an image file associated with the user's account in an
        external source control provider, if available.
        """
        return pulumi.get(self, "image_uri")


@pulumi.output_type
class AppHostingBuildSourceContainer(dict):
    def __init__(__self__, *,
                 image: _builtins.str):
        """
        :param _builtins.str image: A URI representing a container for the backend to use.
        """
        pulumi.set(__self__, "image", image)

    @_builtins.property
    @pulumi.getter
    def image(self) -> _builtins.str:
        """
        A URI representing a container for the backend to use.
        """
        return pulumi.get(self, "image")


@pulumi.output_type
class AppHostingDomainCustomDomainStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certState":
            suggest = "cert_state"
        elif key == "hostState":
            suggest = "host_state"
        elif key == "ownershipState":
            suggest = "ownership_state"
        elif key == "requiredDnsUpdates":
            suggest = "required_dns_updates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppHostingDomainCustomDomainStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppHostingDomainCustomDomainStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppHostingDomainCustomDomainStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_state: Optional[_builtins.str] = None,
                 host_state: Optional[_builtins.str] = None,
                 issues: Optional[Sequence['outputs.AppHostingDomainCustomDomainStatusIssue']] = None,
                 ownership_state: Optional[_builtins.str] = None,
                 required_dns_updates: Optional[Sequence['outputs.AppHostingDomainCustomDomainStatusRequiredDnsUpdate']] = None):
        """
        :param _builtins.str cert_state: (Output)
               Possible values:
               CERT_PREPARING
               CERT_VALIDATING
               CERT_PROPAGATING
               CERT_ACTIVE
               CERT_EXPIRING_SOON
               CERT_EXPIRED
        :param _builtins.str host_state: (Output)
               Possible values:
               HOST_UNHOSTED
               HOST_UNREACHABLE
               HOST_NON_FAH
               HOST_CONFLICT
               HOST_WRONG_SHARD
               HOST_ACTIVE
        :param Sequence['AppHostingDomainCustomDomainStatusIssueArgs'] issues: (Output)
               A list of issues with domain configuration. Allows users to self-correct
               problems with DNS records.
               Structure is documented below.
        :param _builtins.str ownership_state: (Output)
               Possible values:
               OWNERSHIP_MISSING
               OWNERSHIP_UNREACHABLE
               OWNERSHIP_MISMATCH
               OWNERSHIP_CONFLICT
               OWNERSHIP_PENDING
               OWNERSHIP_ACTIVE
        :param Sequence['AppHostingDomainCustomDomainStatusRequiredDnsUpdateArgs'] required_dns_updates: (Output)
               Lists the records that must added or removed to a custom domain's DNS
               in order to finish setup and start serving content.
               Field is present during onboarding. Also present after onboarding if one
               or more of the above states is not *_ACTIVE, indicating the domain's DNS
               records are in a bad state.
               Structure is documented below.
        """
        if cert_state is not None:
            pulumi.set(__self__, "cert_state", cert_state)
        if host_state is not None:
            pulumi.set(__self__, "host_state", host_state)
        if issues is not None:
            pulumi.set(__self__, "issues", issues)
        if ownership_state is not None:
            pulumi.set(__self__, "ownership_state", ownership_state)
        if required_dns_updates is not None:
            pulumi.set(__self__, "required_dns_updates", required_dns_updates)

    @_builtins.property
    @pulumi.getter(name="certState")
    def cert_state(self) -> Optional[_builtins.str]:
        """
        (Output)
        Possible values:
        CERT_PREPARING
        CERT_VALIDATING
        CERT_PROPAGATING
        CERT_ACTIVE
        CERT_EXPIRING_SOON
        CERT_EXPIRED
        """
        return pulumi.get(self, "cert_state")

    @_builtins.property
    @pulumi.getter(name="hostState")
    def host_state(self) -> Optional[_builtins.str]:
        """
        (Output)
        Possible values:
        HOST_UNHOSTED
        HOST_UNREACHABLE
        HOST_NON_FAH
        HOST_CONFLICT
        HOST_WRONG_SHARD
        HOST_ACTIVE
        """
        return pulumi.get(self, "host_state")

    @_builtins.property
    @pulumi.getter
    def issues(self) -> Optional[Sequence['outputs.AppHostingDomainCustomDomainStatusIssue']]:
        """
        (Output)
        A list of issues with domain configuration. Allows users to self-correct
        problems with DNS records.
        Structure is documented below.
        """
        return pulumi.get(self, "issues")

    @_builtins.property
    @pulumi.getter(name="ownershipState")
    def ownership_state(self) -> Optional[_builtins.str]:
        """
        (Output)
        Possible values:
        OWNERSHIP_MISSING
        OWNERSHIP_UNREACHABLE
        OWNERSHIP_MISMATCH
        OWNERSHIP_CONFLICT
        OWNERSHIP_PENDING
        OWNERSHIP_ACTIVE
        """
        return pulumi.get(self, "ownership_state")

    @_builtins.property
    @pulumi.getter(name="requiredDnsUpdates")
    def required_dns_updates(self) -> Optional[Sequence['outputs.AppHostingDomainCustomDomainStatusRequiredDnsUpdate']]:
        """
        (Output)
        Lists the records that must added or removed to a custom domain's DNS
        in order to finish setup and start serving content.
        Field is present during onboarding. Also present after onboarding if one
        or more of the above states is not *_ACTIVE, indicating the domain's DNS
        records are in a bad state.
        Structure is documented below.
        """
        return pulumi.get(self, "required_dns_updates")


@pulumi.output_type
class AppHostingDomainCustomDomainStatusIssue(dict):
    def __init__(__self__, *,
                 code: Optional[_builtins.int] = None,
                 details: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None):
        """
        :param _builtins.int code: (Output)
               The status code, which should be an enum value of google.rpc.Code.
        :param _builtins.str details: (Output)
               A list of messages that carry the error details.
        :param _builtins.str message: (Output)
               A developer-facing error message, which should be in English. Any
               user-facing error message should be localized and sent in the
               google.rpc.Status.details field, or localized by the client.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[_builtins.int]:
        """
        (Output)
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def details(self) -> Optional[_builtins.str]:
        """
        (Output)
        A list of messages that carry the error details.
        """
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        (Output)
        A developer-facing error message, which should be in English. Any
        user-facing error message should be localized and sent in the
        google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class AppHostingDomainCustomDomainStatusRequiredDnsUpdate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "checkTime":
            suggest = "check_time"
        elif key == "domainName":
            suggest = "domain_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppHostingDomainCustomDomainStatusRequiredDnsUpdate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppHostingDomainCustomDomainStatusRequiredDnsUpdate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppHostingDomainCustomDomainStatusRequiredDnsUpdate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 check_time: Optional[_builtins.str] = None,
                 desireds: Optional[Sequence['outputs.AppHostingDomainCustomDomainStatusRequiredDnsUpdateDesired']] = None,
                 discovereds: Optional[Sequence['outputs.AppHostingDomainCustomDomainStatusRequiredDnsUpdateDiscovered']] = None,
                 domain_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str check_time: (Output)
               The last time App Hosting checked your custom domain's DNS records.
        :param Sequence['AppHostingDomainCustomDomainStatusRequiredDnsUpdateDesiredArgs'] desireds: (Output)
               The set of DNS records App Hosting needs in order to be able to serve
               secure content on the domain.
               Structure is documented below.
        :param Sequence['AppHostingDomainCustomDomainStatusRequiredDnsUpdateDiscoveredArgs'] discovereds: (Output)
               The set of DNS records App Hosting discovered when inspecting a domain.
               Structure is documented below.
        :param _builtins.str domain_name: (Output)
               The domain the record pertains to, e.g. `foo.bar.com.`.
        """
        if check_time is not None:
            pulumi.set(__self__, "check_time", check_time)
        if desireds is not None:
            pulumi.set(__self__, "desireds", desireds)
        if discovereds is not None:
            pulumi.set(__self__, "discovereds", discovereds)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)

    @_builtins.property
    @pulumi.getter(name="checkTime")
    def check_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        The last time App Hosting checked your custom domain's DNS records.
        """
        return pulumi.get(self, "check_time")

    @_builtins.property
    @pulumi.getter
    def desireds(self) -> Optional[Sequence['outputs.AppHostingDomainCustomDomainStatusRequiredDnsUpdateDesired']]:
        """
        (Output)
        The set of DNS records App Hosting needs in order to be able to serve
        secure content on the domain.
        Structure is documented below.
        """
        return pulumi.get(self, "desireds")

    @_builtins.property
    @pulumi.getter
    def discovereds(self) -> Optional[Sequence['outputs.AppHostingDomainCustomDomainStatusRequiredDnsUpdateDiscovered']]:
        """
        (Output)
        The set of DNS records App Hosting discovered when inspecting a domain.
        Structure is documented below.
        """
        return pulumi.get(self, "discovereds")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[_builtins.str]:
        """
        (Output)
        The domain the record pertains to, e.g. `foo.bar.com.`.
        """
        return pulumi.get(self, "domain_name")


@pulumi.output_type
class AppHostingDomainCustomDomainStatusRequiredDnsUpdateDesired(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "checkErrors":
            suggest = "check_errors"
        elif key == "domainName":
            suggest = "domain_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppHostingDomainCustomDomainStatusRequiredDnsUpdateDesired. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppHostingDomainCustomDomainStatusRequiredDnsUpdateDesired.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppHostingDomainCustomDomainStatusRequiredDnsUpdateDesired.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 check_errors: Optional[Sequence['outputs.AppHostingDomainCustomDomainStatusRequiredDnsUpdateDesiredCheckError']] = None,
                 domain_name: Optional[_builtins.str] = None,
                 records: Optional[Sequence['outputs.AppHostingDomainCustomDomainStatusRequiredDnsUpdateDesiredRecord']] = None):
        """
        :param Sequence['AppHostingDomainCustomDomainStatusRequiredDnsUpdateDesiredCheckErrorArgs'] check_errors: (Output)
               The `Status` type defines a logical error model that is suitable for
               different programming environments, including REST APIs and RPC APIs. It is
               used by [gRPC](https://github.com/grpc). Each `Status` message contains
               three pieces of data: error code, error message, and error details.
               You can find out more about this error model and how to work with it in the
               [API Design Guide](https://cloud.google.com/apis/design/errors).
               Structure is documented below.
        :param _builtins.str domain_name: (Output)
               The domain the record pertains to, e.g. `foo.bar.com.`.
        :param Sequence['AppHostingDomainCustomDomainStatusRequiredDnsUpdateDesiredRecordArgs'] records: (Output)
               Records on the domain.
               Structure is documented below.
        """
        if check_errors is not None:
            pulumi.set(__self__, "check_errors", check_errors)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if records is not None:
            pulumi.set(__self__, "records", records)

    @_builtins.property
    @pulumi.getter(name="checkErrors")
    def check_errors(self) -> Optional[Sequence['outputs.AppHostingDomainCustomDomainStatusRequiredDnsUpdateDesiredCheckError']]:
        """
        (Output)
        The `Status` type defines a logical error model that is suitable for
        different programming environments, including REST APIs and RPC APIs. It is
        used by [gRPC](https://github.com/grpc). Each `Status` message contains
        three pieces of data: error code, error message, and error details.
        You can find out more about this error model and how to work with it in the
        [API Design Guide](https://cloud.google.com/apis/design/errors).
        Structure is documented below.
        """
        return pulumi.get(self, "check_errors")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[_builtins.str]:
        """
        (Output)
        The domain the record pertains to, e.g. `foo.bar.com.`.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter
    def records(self) -> Optional[Sequence['outputs.AppHostingDomainCustomDomainStatusRequiredDnsUpdateDesiredRecord']]:
        """
        (Output)
        Records on the domain.
        Structure is documented below.
        """
        return pulumi.get(self, "records")


@pulumi.output_type
class AppHostingDomainCustomDomainStatusRequiredDnsUpdateDesiredCheckError(dict):
    def __init__(__self__, *,
                 code: Optional[_builtins.int] = None,
                 details: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None):
        """
        :param _builtins.int code: (Output)
               The status code, which should be an enum value of google.rpc.Code.
        :param _builtins.str details: (Output)
               A list of messages that carry the error details.
        :param _builtins.str message: (Output)
               A developer-facing error message, which should be in English. Any
               user-facing error message should be localized and sent in the
               google.rpc.Status.details field, or localized by the client.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[_builtins.int]:
        """
        (Output)
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def details(self) -> Optional[_builtins.str]:
        """
        (Output)
        A list of messages that carry the error details.
        """
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        (Output)
        A developer-facing error message, which should be in English. Any
        user-facing error message should be localized and sent in the
        google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class AppHostingDomainCustomDomainStatusRequiredDnsUpdateDesiredRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "relevantStates":
            suggest = "relevant_states"
        elif key == "requiredAction":
            suggest = "required_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppHostingDomainCustomDomainStatusRequiredDnsUpdateDesiredRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppHostingDomainCustomDomainStatusRequiredDnsUpdateDesiredRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppHostingDomainCustomDomainStatusRequiredDnsUpdateDesiredRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[_builtins.str] = None,
                 rdata: Optional[_builtins.str] = None,
                 relevant_states: Optional[Sequence[_builtins.str]] = None,
                 required_action: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str domain_name: (Output)
               The domain the record pertains to, e.g. `foo.bar.com.`.
        :param _builtins.str rdata: (Output)
               The data of the record. The meaning of the value depends on record type:
               - A and AAAA: IP addresses for the domain.
               - CNAME: Another domain to check for records.
               - TXT: Arbitrary text strings associated with the domain. App Hosting
               uses TXT records to determine which Firebase projects have
               permission to act on the domain's behalf.
               - CAA: The record's flags, tag, and value, e.g. `0 issue "pki.goog"`.
        :param Sequence[_builtins.str] relevant_states: (Output)
               An enum that indicates which state(s) this DNS record applies to. Populated
               for all records with an `ADD` or `REMOVE` required action.
        :param _builtins.str required_action: (Output)
               An enum that indicates the a required action for this record. Populated
               when the record is part of a required change in a  `DnsUpdates`
               `discovered` or `desired` record set.
               Possible values:
               NONE
               ADD
               REMOVE
        :param _builtins.str type: (Output)
               The record's type, which determines what data the record contains.
               Possible values:
               A
               CNAME
               TXT
               AAAA
               CAA
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if rdata is not None:
            pulumi.set(__self__, "rdata", rdata)
        if relevant_states is not None:
            pulumi.set(__self__, "relevant_states", relevant_states)
        if required_action is not None:
            pulumi.set(__self__, "required_action", required_action)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[_builtins.str]:
        """
        (Output)
        The domain the record pertains to, e.g. `foo.bar.com.`.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter
    def rdata(self) -> Optional[_builtins.str]:
        """
        (Output)
        The data of the record. The meaning of the value depends on record type:
        - A and AAAA: IP addresses for the domain.
        - CNAME: Another domain to check for records.
        - TXT: Arbitrary text strings associated with the domain. App Hosting
        uses TXT records to determine which Firebase projects have
        permission to act on the domain's behalf.
        - CAA: The record's flags, tag, and value, e.g. `0 issue "pki.goog"`.
        """
        return pulumi.get(self, "rdata")

    @_builtins.property
    @pulumi.getter(name="relevantStates")
    def relevant_states(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Output)
        An enum that indicates which state(s) this DNS record applies to. Populated
        for all records with an `ADD` or `REMOVE` required action.
        """
        return pulumi.get(self, "relevant_states")

    @_builtins.property
    @pulumi.getter(name="requiredAction")
    def required_action(self) -> Optional[_builtins.str]:
        """
        (Output)
        An enum that indicates the a required action for this record. Populated
        when the record is part of a required change in a  `DnsUpdates`
        `discovered` or `desired` record set.
        Possible values:
        NONE
        ADD
        REMOVE
        """
        return pulumi.get(self, "required_action")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        (Output)
        The record's type, which determines what data the record contains.
        Possible values:
        A
        CNAME
        TXT
        AAAA
        CAA
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AppHostingDomainCustomDomainStatusRequiredDnsUpdateDiscovered(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "checkErrors":
            suggest = "check_errors"
        elif key == "domainName":
            suggest = "domain_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppHostingDomainCustomDomainStatusRequiredDnsUpdateDiscovered. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppHostingDomainCustomDomainStatusRequiredDnsUpdateDiscovered.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppHostingDomainCustomDomainStatusRequiredDnsUpdateDiscovered.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 check_errors: Optional[Sequence['outputs.AppHostingDomainCustomDomainStatusRequiredDnsUpdateDiscoveredCheckError']] = None,
                 domain_name: Optional[_builtins.str] = None,
                 records: Optional[Sequence['outputs.AppHostingDomainCustomDomainStatusRequiredDnsUpdateDiscoveredRecord']] = None):
        """
        :param Sequence['AppHostingDomainCustomDomainStatusRequiredDnsUpdateDiscoveredCheckErrorArgs'] check_errors: (Output)
               The `Status` type defines a logical error model that is suitable for
               different programming environments, including REST APIs and RPC APIs. It is
               used by [gRPC](https://github.com/grpc). Each `Status` message contains
               three pieces of data: error code, error message, and error details.
               You can find out more about this error model and how to work with it in the
               [API Design Guide](https://cloud.google.com/apis/design/errors).
               Structure is documented below.
        :param _builtins.str domain_name: (Output)
               The domain the record pertains to, e.g. `foo.bar.com.`.
        :param Sequence['AppHostingDomainCustomDomainStatusRequiredDnsUpdateDiscoveredRecordArgs'] records: (Output)
               Records on the domain.
               Structure is documented below.
        """
        if check_errors is not None:
            pulumi.set(__self__, "check_errors", check_errors)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if records is not None:
            pulumi.set(__self__, "records", records)

    @_builtins.property
    @pulumi.getter(name="checkErrors")
    def check_errors(self) -> Optional[Sequence['outputs.AppHostingDomainCustomDomainStatusRequiredDnsUpdateDiscoveredCheckError']]:
        """
        (Output)
        The `Status` type defines a logical error model that is suitable for
        different programming environments, including REST APIs and RPC APIs. It is
        used by [gRPC](https://github.com/grpc). Each `Status` message contains
        three pieces of data: error code, error message, and error details.
        You can find out more about this error model and how to work with it in the
        [API Design Guide](https://cloud.google.com/apis/design/errors).
        Structure is documented below.
        """
        return pulumi.get(self, "check_errors")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[_builtins.str]:
        """
        (Output)
        The domain the record pertains to, e.g. `foo.bar.com.`.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter
    def records(self) -> Optional[Sequence['outputs.AppHostingDomainCustomDomainStatusRequiredDnsUpdateDiscoveredRecord']]:
        """
        (Output)
        Records on the domain.
        Structure is documented below.
        """
        return pulumi.get(self, "records")


@pulumi.output_type
class AppHostingDomainCustomDomainStatusRequiredDnsUpdateDiscoveredCheckError(dict):
    def __init__(__self__, *,
                 code: Optional[_builtins.int] = None,
                 details: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None):
        """
        :param _builtins.int code: (Output)
               The status code, which should be an enum value of google.rpc.Code.
        :param _builtins.str details: (Output)
               A list of messages that carry the error details.
        :param _builtins.str message: (Output)
               A developer-facing error message, which should be in English. Any
               user-facing error message should be localized and sent in the
               google.rpc.Status.details field, or localized by the client.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[_builtins.int]:
        """
        (Output)
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def details(self) -> Optional[_builtins.str]:
        """
        (Output)
        A list of messages that carry the error details.
        """
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        (Output)
        A developer-facing error message, which should be in English. Any
        user-facing error message should be localized and sent in the
        google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class AppHostingDomainCustomDomainStatusRequiredDnsUpdateDiscoveredRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "relevantStates":
            suggest = "relevant_states"
        elif key == "requiredAction":
            suggest = "required_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppHostingDomainCustomDomainStatusRequiredDnsUpdateDiscoveredRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppHostingDomainCustomDomainStatusRequiredDnsUpdateDiscoveredRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppHostingDomainCustomDomainStatusRequiredDnsUpdateDiscoveredRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[_builtins.str] = None,
                 rdata: Optional[_builtins.str] = None,
                 relevant_states: Optional[Sequence[_builtins.str]] = None,
                 required_action: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str domain_name: (Output)
               The domain the record pertains to, e.g. `foo.bar.com.`.
        :param _builtins.str rdata: (Output)
               The data of the record. The meaning of the value depends on record type:
               - A and AAAA: IP addresses for the domain.
               - CNAME: Another domain to check for records.
               - TXT: Arbitrary text strings associated with the domain. App Hosting
               uses TXT records to determine which Firebase projects have
               permission to act on the domain's behalf.
               - CAA: The record's flags, tag, and value, e.g. `0 issue "pki.goog"`.
        :param Sequence[_builtins.str] relevant_states: (Output)
               An enum that indicates which state(s) this DNS record applies to. Populated
               for all records with an `ADD` or `REMOVE` required action.
        :param _builtins.str required_action: (Output)
               An enum that indicates the a required action for this record. Populated
               when the record is part of a required change in a  `DnsUpdates`
               `discovered` or `desired` record set.
               Possible values:
               NONE
               ADD
               REMOVE
        :param _builtins.str type: (Output)
               The record's type, which determines what data the record contains.
               Possible values:
               A
               CNAME
               TXT
               AAAA
               CAA
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if rdata is not None:
            pulumi.set(__self__, "rdata", rdata)
        if relevant_states is not None:
            pulumi.set(__self__, "relevant_states", relevant_states)
        if required_action is not None:
            pulumi.set(__self__, "required_action", required_action)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[_builtins.str]:
        """
        (Output)
        The domain the record pertains to, e.g. `foo.bar.com.`.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter
    def rdata(self) -> Optional[_builtins.str]:
        """
        (Output)
        The data of the record. The meaning of the value depends on record type:
        - A and AAAA: IP addresses for the domain.
        - CNAME: Another domain to check for records.
        - TXT: Arbitrary text strings associated with the domain. App Hosting
        uses TXT records to determine which Firebase projects have
        permission to act on the domain's behalf.
        - CAA: The record's flags, tag, and value, e.g. `0 issue "pki.goog"`.
        """
        return pulumi.get(self, "rdata")

    @_builtins.property
    @pulumi.getter(name="relevantStates")
    def relevant_states(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Output)
        An enum that indicates which state(s) this DNS record applies to. Populated
        for all records with an `ADD` or `REMOVE` required action.
        """
        return pulumi.get(self, "relevant_states")

    @_builtins.property
    @pulumi.getter(name="requiredAction")
    def required_action(self) -> Optional[_builtins.str]:
        """
        (Output)
        An enum that indicates the a required action for this record. Populated
        when the record is part of a required change in a  `DnsUpdates`
        `discovered` or `desired` record set.
        Possible values:
        NONE
        ADD
        REMOVE
        """
        return pulumi.get(self, "required_action")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        (Output)
        The record's type, which determines what data the record contains.
        Possible values:
        A
        CNAME
        TXT
        AAAA
        CAA
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AppHostingDomainServe(dict):
    def __init__(__self__, *,
                 redirect: Optional['outputs.AppHostingDomainServeRedirect'] = None):
        """
        :param 'AppHostingDomainServeRedirectArgs' redirect: Specifies redirect behavior for a domain.
               Structure is documented below.
        """
        if redirect is not None:
            pulumi.set(__self__, "redirect", redirect)

    @_builtins.property
    @pulumi.getter
    def redirect(self) -> Optional['outputs.AppHostingDomainServeRedirect']:
        """
        Specifies redirect behavior for a domain.
        Structure is documented below.
        """
        return pulumi.get(self, "redirect")


@pulumi.output_type
class AppHostingDomainServeRedirect(dict):
    def __init__(__self__, *,
                 uri: _builtins.str,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str uri: The URI of the redirect's intended destination. This URI will be
               prepended to the original request path. URI without a scheme are
               assumed to be HTTPS.
        :param _builtins.str status: The status code to use in a redirect response. Must be a valid HTTP 3XX
               status code. Defaults to 302 if not present.
        """
        pulumi.set(__self__, "uri", uri)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        The URI of the redirect's intended destination. This URI will be
        prepended to the original request path. URI without a scheme are
        assumed to be HTTPS.
        """
        return pulumi.get(self, "uri")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status code to use in a redirect response. Must be a valid HTTP 3XX
        status code. Defaults to 302 if not present.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class AppHostingTrafficCurrent(dict):
    def __init__(__self__, *,
                 splits: Optional[Sequence['outputs.AppHostingTrafficCurrentSplit']] = None):
        """
        :param Sequence['AppHostingTrafficCurrentSplitArgs'] splits: (Output)
               A list of traffic splits that together represent where traffic is being routed.
               Structure is documented below.
        """
        if splits is not None:
            pulumi.set(__self__, "splits", splits)

    @_builtins.property
    @pulumi.getter
    def splits(self) -> Optional[Sequence['outputs.AppHostingTrafficCurrentSplit']]:
        """
        (Output)
        A list of traffic splits that together represent where traffic is being routed.
        Structure is documented below.
        """
        return pulumi.get(self, "splits")


@pulumi.output_type
class AppHostingTrafficCurrentSplit(dict):
    def __init__(__self__, *,
                 build: Optional[_builtins.str] = None,
                 percent: Optional[_builtins.int] = None):
        """
        :param _builtins.str build: The build that traffic is being routed to.
        :param _builtins.int percent: The percentage of traffic to send to the build. Currently must be 100 or 0.
        """
        if build is not None:
            pulumi.set(__self__, "build", build)
        if percent is not None:
            pulumi.set(__self__, "percent", percent)

    @_builtins.property
    @pulumi.getter
    def build(self) -> Optional[_builtins.str]:
        """
        The build that traffic is being routed to.
        """
        return pulumi.get(self, "build")

    @_builtins.property
    @pulumi.getter
    def percent(self) -> Optional[_builtins.int]:
        """
        The percentage of traffic to send to the build. Currently must be 100 or 0.
        """
        return pulumi.get(self, "percent")


@pulumi.output_type
class AppHostingTrafficRolloutPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "codebaseBranch":
            suggest = "codebase_branch"
        elif key == "disabledTime":
            suggest = "disabled_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppHostingTrafficRolloutPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppHostingTrafficRolloutPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppHostingTrafficRolloutPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 codebase_branch: Optional[_builtins.str] = None,
                 disabled: Optional[_builtins.bool] = None,
                 disabled_time: Optional[_builtins.str] = None):
        """
        :param _builtins.str codebase_branch: Specifies a branch that triggers a new build to be started with this
               policy. If not set, no automatic rollouts will happen.
        :param _builtins.bool disabled: A flag that, if true, prevents rollouts from being created via this RolloutPolicy.
        :param _builtins.str disabled_time: (Output)
               If disabled is set, the time at which the rollouts were disabled.
        """
        if codebase_branch is not None:
            pulumi.set(__self__, "codebase_branch", codebase_branch)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if disabled_time is not None:
            pulumi.set(__self__, "disabled_time", disabled_time)

    @_builtins.property
    @pulumi.getter(name="codebaseBranch")
    def codebase_branch(self) -> Optional[_builtins.str]:
        """
        Specifies a branch that triggers a new build to be started with this
        policy. If not set, no automatic rollouts will happen.
        """
        return pulumi.get(self, "codebase_branch")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[_builtins.bool]:
        """
        A flag that, if true, prevents rollouts from being created via this RolloutPolicy.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter(name="disabledTime")
    def disabled_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        If disabled is set, the time at which the rollouts were disabled.
        """
        return pulumi.get(self, "disabled_time")


@pulumi.output_type
class AppHostingTrafficTarget(dict):
    def __init__(__self__, *,
                 splits: Sequence['outputs.AppHostingTrafficTargetSplit']):
        """
        :param Sequence['AppHostingTrafficTargetSplitArgs'] splits: A list of traffic splits that together represent where traffic is being routed.
               Structure is documented below.
        """
        pulumi.set(__self__, "splits", splits)

    @_builtins.property
    @pulumi.getter
    def splits(self) -> Sequence['outputs.AppHostingTrafficTargetSplit']:
        """
        A list of traffic splits that together represent where traffic is being routed.
        Structure is documented below.
        """
        return pulumi.get(self, "splits")


@pulumi.output_type
class AppHostingTrafficTargetSplit(dict):
    def __init__(__self__, *,
                 build: _builtins.str,
                 percent: _builtins.int):
        """
        :param _builtins.str build: The build that traffic is being routed to.
        :param _builtins.int percent: The percentage of traffic to send to the build. Currently must be 100 or 0.
        """
        pulumi.set(__self__, "build", build)
        pulumi.set(__self__, "percent", percent)

    @_builtins.property
    @pulumi.getter
    def build(self) -> _builtins.str:
        """
        The build that traffic is being routed to.
        """
        return pulumi.get(self, "build")

    @_builtins.property
    @pulumi.getter
    def percent(self) -> _builtins.int:
        """
        The percentage of traffic to send to the build. Currently must be 100 or 0.
        """
        return pulumi.get(self, "percent")


@pulumi.output_type
class ExtensionsInstanceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "extensionRef":
            suggest = "extension_ref"
        elif key == "allowedEventTypes":
            suggest = "allowed_event_types"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "eventarcChannel":
            suggest = "eventarc_channel"
        elif key == "extensionVersion":
            suggest = "extension_version"
        elif key == "populatedPostinstallContent":
            suggest = "populated_postinstall_content"
        elif key == "systemParams":
            suggest = "system_params"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExtensionsInstanceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExtensionsInstanceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExtensionsInstanceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 extension_ref: _builtins.str,
                 params: Mapping[str, _builtins.str],
                 allowed_event_types: Optional[Sequence[_builtins.str]] = None,
                 create_time: Optional[_builtins.str] = None,
                 eventarc_channel: Optional[_builtins.str] = None,
                 extension_version: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 populated_postinstall_content: Optional[_builtins.str] = None,
                 system_params: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str extension_ref: The ref of the Extension from the Registry (e.g. publisher-id/awesome-extension)
        :param Mapping[str, _builtins.str] params: Environment variables that may be configured for the Extension
        :param Sequence[_builtins.str] allowed_event_types: List of extension events selected by consumer that extension is allowed to
               emit, identified by their types.
        :param _builtins.str create_time: (Output)
               The time at which the Extension Instance Config was created.
        :param _builtins.str eventarc_channel: Fully qualified Eventarc resource name that consumers should use for event triggers.
        :param _builtins.str extension_version: The version of the Extension from the Registry (e.g. 1.0.3). If left blank, latest is assumed.
        :param _builtins.str name: (Output)
               The unique identifier for this configuration.
        :param _builtins.str populated_postinstall_content: (Output)
               Postinstall instructions to be shown for this Extension, with
               template strings representing function and parameter values substituted
               with actual values. These strings include: ${param:FOO},
               ${function:myFunc.url},
               ${function:myFunc.name}, and ${function:myFunc.location}
        :param Mapping[str, _builtins.str] system_params: Params whose values are only available at deployment time.
               Unlike other params, these will not be set as environment variables on
               functions. See a full list of system parameters at
               https://firebase.google.com/docs/extensions/publishers/parameters#system_parameters
        """
        pulumi.set(__self__, "extension_ref", extension_ref)
        pulumi.set(__self__, "params", params)
        if allowed_event_types is not None:
            pulumi.set(__self__, "allowed_event_types", allowed_event_types)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if eventarc_channel is not None:
            pulumi.set(__self__, "eventarc_channel", eventarc_channel)
        if extension_version is not None:
            pulumi.set(__self__, "extension_version", extension_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if populated_postinstall_content is not None:
            pulumi.set(__self__, "populated_postinstall_content", populated_postinstall_content)
        if system_params is not None:
            pulumi.set(__self__, "system_params", system_params)

    @_builtins.property
    @pulumi.getter(name="extensionRef")
    def extension_ref(self) -> _builtins.str:
        """
        The ref of the Extension from the Registry (e.g. publisher-id/awesome-extension)
        """
        return pulumi.get(self, "extension_ref")

    @_builtins.property
    @pulumi.getter
    def params(self) -> Mapping[str, _builtins.str]:
        """
        Environment variables that may be configured for the Extension
        """
        return pulumi.get(self, "params")

    @_builtins.property
    @pulumi.getter(name="allowedEventTypes")
    def allowed_event_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of extension events selected by consumer that extension is allowed to
        emit, identified by their types.
        """
        return pulumi.get(self, "allowed_event_types")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        The time at which the Extension Instance Config was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="eventarcChannel")
    def eventarc_channel(self) -> Optional[_builtins.str]:
        """
        Fully qualified Eventarc resource name that consumers should use for event triggers.
        """
        return pulumi.get(self, "eventarc_channel")

    @_builtins.property
    @pulumi.getter(name="extensionVersion")
    def extension_version(self) -> Optional[_builtins.str]:
        """
        The version of the Extension from the Registry (e.g. 1.0.3). If left blank, latest is assumed.
        """
        return pulumi.get(self, "extension_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        (Output)
        The unique identifier for this configuration.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="populatedPostinstallContent")
    def populated_postinstall_content(self) -> Optional[_builtins.str]:
        """
        (Output)
        Postinstall instructions to be shown for this Extension, with
        template strings representing function and parameter values substituted
        with actual values. These strings include: ${param:FOO},
        ${function:myFunc.url},
        ${function:myFunc.name}, and ${function:myFunc.location}
        """
        return pulumi.get(self, "populated_postinstall_content")

    @_builtins.property
    @pulumi.getter(name="systemParams")
    def system_params(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Params whose values are only available at deployment time.
        Unlike other params, these will not be set as environment variables on
        functions. See a full list of system parameters at
        https://firebase.google.com/docs/extensions/publishers/parameters#system_parameters
        """
        return pulumi.get(self, "system_params")


@pulumi.output_type
class ExtensionsInstanceErrorStatus(dict):
    def __init__(__self__, *,
                 code: Optional[_builtins.int] = None,
                 details: Optional[Sequence[Mapping[str, _builtins.str]]] = None,
                 message: Optional[_builtins.str] = None):
        """
        :param _builtins.int code: The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, _builtins.str]] details: A list of messages that carry the error details.
        :param _builtins.str message: A developer-facing error message, which should be in English.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[_builtins.int]:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def details(self) -> Optional[Sequence[Mapping[str, _builtins.str]]]:
        """
        A list of messages that carry the error details.
        """
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        A developer-facing error message, which should be in English.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class ExtensionsInstanceRuntimeData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fatalError":
            suggest = "fatal_error"
        elif key == "processingState":
            suggest = "processing_state"
        elif key == "stateUpdateTime":
            suggest = "state_update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExtensionsInstanceRuntimeData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExtensionsInstanceRuntimeData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExtensionsInstanceRuntimeData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fatal_error: Optional['outputs.ExtensionsInstanceRuntimeDataFatalError'] = None,
                 processing_state: Optional['outputs.ExtensionsInstanceRuntimeDataProcessingState'] = None,
                 state_update_time: Optional[_builtins.str] = None):
        """
        :param 'ExtensionsInstanceRuntimeDataFatalErrorArgs' fatal_error: The fatal error state for the extension instance
               Structure is documented below.
        :param 'ExtensionsInstanceRuntimeDataProcessingStateArgs' processing_state: The processing state for the extension instance
               Structure is documented below.
        :param _builtins.str state_update_time: The time of the last state update.
        """
        if fatal_error is not None:
            pulumi.set(__self__, "fatal_error", fatal_error)
        if processing_state is not None:
            pulumi.set(__self__, "processing_state", processing_state)
        if state_update_time is not None:
            pulumi.set(__self__, "state_update_time", state_update_time)

    @_builtins.property
    @pulumi.getter(name="fatalError")
    def fatal_error(self) -> Optional['outputs.ExtensionsInstanceRuntimeDataFatalError']:
        """
        The fatal error state for the extension instance
        Structure is documented below.
        """
        return pulumi.get(self, "fatal_error")

    @_builtins.property
    @pulumi.getter(name="processingState")
    def processing_state(self) -> Optional['outputs.ExtensionsInstanceRuntimeDataProcessingState']:
        """
        The processing state for the extension instance
        Structure is documented below.
        """
        return pulumi.get(self, "processing_state")

    @_builtins.property
    @pulumi.getter(name="stateUpdateTime")
    def state_update_time(self) -> Optional[_builtins.str]:
        """
        The time of the last state update.
        """
        return pulumi.get(self, "state_update_time")


@pulumi.output_type
class ExtensionsInstanceRuntimeDataFatalError(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorMessage":
            suggest = "error_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExtensionsInstanceRuntimeDataFatalError. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExtensionsInstanceRuntimeDataFatalError.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExtensionsInstanceRuntimeDataFatalError.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_message: Optional[_builtins.str] = None):
        """
        :param _builtins.str error_message: The error message. This is set by the extension developer to give
               more detail on why the extension is unusable and must be re-installed
               or reconfigured.
        """
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)

    @_builtins.property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[_builtins.str]:
        """
        The error message. This is set by the extension developer to give
        more detail on why the extension is unusable and must be re-installed
        or reconfigured.
        """
        return pulumi.get(self, "error_message")


@pulumi.output_type
class ExtensionsInstanceRuntimeDataProcessingState(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "detailMessage":
            suggest = "detail_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExtensionsInstanceRuntimeDataProcessingState. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExtensionsInstanceRuntimeDataProcessingState.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExtensionsInstanceRuntimeDataProcessingState.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 detail_message: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None):
        """
        :param _builtins.str detail_message: Details about the processing. e.g. This could include the type of
               processing in progress or it could list errors or failures.
               This information will be shown in the console on the detail page
               for the extension instance.
        :param _builtins.str state: The processing state of the extension instance.
        """
        if detail_message is not None:
            pulumi.set(__self__, "detail_message", detail_message)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="detailMessage")
    def detail_message(self) -> Optional[_builtins.str]:
        """
        Details about the processing. e.g. This could include the type of
        processing in progress or it could list errors or failures.
        This information will be shown in the console on the detail page
        for the extension instance.
        """
        return pulumi.get(self, "detail_message")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The processing state of the extension instance.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class HostingCustomDomainCert(dict):
    def __init__(__self__, *,
                 state: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None,
                 verification: Optional['outputs.HostingCustomDomainCertVerification'] = None):
        """
        :param _builtins.str state: The state of the certificate. Only the `CERT_ACTIVE` and
               `CERT_EXPIRING_SOON` states provide SSL coverage for a domain name. If the
               state is `PROPAGATING` and Hosting had an active cert for the domain name
               before, that formerly-active cert provides SSL coverage for the domain name
               until the current cert propagates.
        :param _builtins.str type: The record's type, which determines what data the record contains.
        :param 'HostingCustomDomainCertVerificationArgs' verification: A set of ACME challenges you can add to your DNS records or existing,
               non-Hosting hosting provider to allow Hosting to create an SSL certificate
               for your domain name before you point traffic toward hosting. You can use
               thse challenges as part of a zero downtime transition from your old
               provider to Hosting.
               Structure is documented below.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if verification is not None:
            pulumi.set(__self__, "verification", verification)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The state of the certificate. Only the `CERT_ACTIVE` and
        `CERT_EXPIRING_SOON` states provide SSL coverage for a domain name. If the
        state is `PROPAGATING` and Hosting had an active cert for the domain name
        before, that formerly-active cert provides SSL coverage for the domain name
        until the current cert propagates.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The record's type, which determines what data the record contains.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def verification(self) -> Optional['outputs.HostingCustomDomainCertVerification']:
        """
        A set of ACME challenges you can add to your DNS records or existing,
        non-Hosting hosting provider to allow Hosting to create an SSL certificate
        for your domain name before you point traffic toward hosting. You can use
        thse challenges as part of a zero downtime transition from your old
        provider to Hosting.
        Structure is documented below.
        """
        return pulumi.get(self, "verification")


@pulumi.output_type
class HostingCustomDomainCertVerification(dict):
    def __init__(__self__, *,
                 dns: Optional['outputs.HostingCustomDomainCertVerificationDns'] = None,
                 http: Optional['outputs.HostingCustomDomainCertVerificationHttp'] = None):
        """
        :param 'HostingCustomDomainCertVerificationDnsArgs' dns: A `TXT` record to add to your DNS records that confirms your intent to
               let Hosting create an SSL cert for your domain name.
               Structure is documented below.
        :param 'HostingCustomDomainCertVerificationHttpArgs' http: A file to add to your existing, non-Hosting hosting service that confirms
               your intent to let Hosting create an SSL cert for your domain name.
               Structure is documented below.
        """
        if dns is not None:
            pulumi.set(__self__, "dns", dns)
        if http is not None:
            pulumi.set(__self__, "http", http)

    @_builtins.property
    @pulumi.getter
    def dns(self) -> Optional['outputs.HostingCustomDomainCertVerificationDns']:
        """
        A `TXT` record to add to your DNS records that confirms your intent to
        let Hosting create an SSL cert for your domain name.
        Structure is documented below.
        """
        return pulumi.get(self, "dns")

    @_builtins.property
    @pulumi.getter
    def http(self) -> Optional['outputs.HostingCustomDomainCertVerificationHttp']:
        """
        A file to add to your existing, non-Hosting hosting service that confirms
        your intent to let Hosting create an SSL cert for your domain name.
        Structure is documented below.
        """
        return pulumi.get(self, "http")


@pulumi.output_type
class HostingCustomDomainCertVerificationDns(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "checkTime":
            suggest = "check_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostingCustomDomainCertVerificationDns. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostingCustomDomainCertVerificationDns.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostingCustomDomainCertVerificationDns.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 check_time: Optional[_builtins.str] = None,
                 desireds: Optional[Sequence['outputs.HostingCustomDomainCertVerificationDnsDesired']] = None,
                 discovereds: Optional[Sequence['outputs.HostingCustomDomainCertVerificationDnsDiscovered']] = None):
        """
        :param _builtins.str check_time: (Output)
               The last time Hosting checked your CustomDomain's DNS records.
        :param Sequence['HostingCustomDomainCertVerificationDnsDesiredArgs'] desireds: A text string to serve at the path.
        :param Sequence['HostingCustomDomainCertVerificationDnsDiscoveredArgs'] discovereds: Whether Hosting was able to find the required file contents on the
               specified path during its last check.
        """
        if check_time is not None:
            pulumi.set(__self__, "check_time", check_time)
        if desireds is not None:
            pulumi.set(__self__, "desireds", desireds)
        if discovereds is not None:
            pulumi.set(__self__, "discovereds", discovereds)

    @_builtins.property
    @pulumi.getter(name="checkTime")
    def check_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        The last time Hosting checked your CustomDomain's DNS records.
        """
        return pulumi.get(self, "check_time")

    @_builtins.property
    @pulumi.getter
    def desireds(self) -> Optional[Sequence['outputs.HostingCustomDomainCertVerificationDnsDesired']]:
        """
        A text string to serve at the path.
        """
        return pulumi.get(self, "desireds")

    @_builtins.property
    @pulumi.getter
    def discovereds(self) -> Optional[Sequence['outputs.HostingCustomDomainCertVerificationDnsDiscovered']]:
        """
        Whether Hosting was able to find the required file contents on the
        specified path during its last check.
        """
        return pulumi.get(self, "discovereds")


@pulumi.output_type
class HostingCustomDomainCertVerificationDnsDesired(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostingCustomDomainCertVerificationDnsDesired. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostingCustomDomainCertVerificationDnsDesired.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostingCustomDomainCertVerificationDnsDesired.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[_builtins.str] = None,
                 records: Optional[Sequence['outputs.HostingCustomDomainCertVerificationDnsDesiredRecord']] = None):
        """
        :param _builtins.str domain_name: The domain name the record pertains to, e.g. `foo.bar.com.`.
        :param Sequence['HostingCustomDomainCertVerificationDnsDesiredRecordArgs'] records: Records on the domain
               Structure is documented below.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if records is not None:
            pulumi.set(__self__, "records", records)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[_builtins.str]:
        """
        The domain name the record pertains to, e.g. `foo.bar.com.`.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter
    def records(self) -> Optional[Sequence['outputs.HostingCustomDomainCertVerificationDnsDesiredRecord']]:
        """
        Records on the domain
        Structure is documented below.
        """
        return pulumi.get(self, "records")


@pulumi.output_type
class HostingCustomDomainCertVerificationDnsDesiredRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "requiredAction":
            suggest = "required_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostingCustomDomainCertVerificationDnsDesiredRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostingCustomDomainCertVerificationDnsDesiredRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostingCustomDomainCertVerificationDnsDesiredRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[_builtins.str] = None,
                 rdata: Optional[_builtins.str] = None,
                 required_action: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str domain_name: The domain name the record pertains to, e.g. `foo.bar.com.`.
        :param _builtins.str rdata: The data of the record. The meaning of the value depends on record type:
               - A and AAAA: IP addresses for the domain name.
               - CNAME: Another domain to check for records.
               - TXT: Arbitrary text strings associated with the domain name. Hosting
               uses TXT records to determine a which Firebase Projects have
               permission to act on the domain name's behalf.
               - CAA: The record's flags, tag, and value, e.g. `0 issue "pki.goog"`.
        :param _builtins.str required_action: Indicates the a required action for this record.
        :param _builtins.str type: The record's type, which determines what data the record contains.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if rdata is not None:
            pulumi.set(__self__, "rdata", rdata)
        if required_action is not None:
            pulumi.set(__self__, "required_action", required_action)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[_builtins.str]:
        """
        The domain name the record pertains to, e.g. `foo.bar.com.`.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter
    def rdata(self) -> Optional[_builtins.str]:
        """
        The data of the record. The meaning of the value depends on record type:
        - A and AAAA: IP addresses for the domain name.
        - CNAME: Another domain to check for records.
        - TXT: Arbitrary text strings associated with the domain name. Hosting
        uses TXT records to determine a which Firebase Projects have
        permission to act on the domain name's behalf.
        - CAA: The record's flags, tag, and value, e.g. `0 issue "pki.goog"`.
        """
        return pulumi.get(self, "rdata")

    @_builtins.property
    @pulumi.getter(name="requiredAction")
    def required_action(self) -> Optional[_builtins.str]:
        """
        Indicates the a required action for this record.
        """
        return pulumi.get(self, "required_action")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The record's type, which determines what data the record contains.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class HostingCustomDomainCertVerificationDnsDiscovered(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostingCustomDomainCertVerificationDnsDiscovered. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostingCustomDomainCertVerificationDnsDiscovered.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostingCustomDomainCertVerificationDnsDiscovered.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[_builtins.str] = None,
                 records: Optional[Sequence['outputs.HostingCustomDomainCertVerificationDnsDiscoveredRecord']] = None):
        """
        :param _builtins.str domain_name: The domain name the record pertains to, e.g. `foo.bar.com.`.
        :param Sequence['HostingCustomDomainCertVerificationDnsDiscoveredRecordArgs'] records: Records on the domain
               Structure is documented below.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if records is not None:
            pulumi.set(__self__, "records", records)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[_builtins.str]:
        """
        The domain name the record pertains to, e.g. `foo.bar.com.`.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter
    def records(self) -> Optional[Sequence['outputs.HostingCustomDomainCertVerificationDnsDiscoveredRecord']]:
        """
        Records on the domain
        Structure is documented below.
        """
        return pulumi.get(self, "records")


@pulumi.output_type
class HostingCustomDomainCertVerificationDnsDiscoveredRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "requiredAction":
            suggest = "required_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostingCustomDomainCertVerificationDnsDiscoveredRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostingCustomDomainCertVerificationDnsDiscoveredRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostingCustomDomainCertVerificationDnsDiscoveredRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[_builtins.str] = None,
                 rdata: Optional[_builtins.str] = None,
                 required_action: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str domain_name: The domain name the record pertains to, e.g. `foo.bar.com.`.
        :param _builtins.str rdata: The data of the record. The meaning of the value depends on record type:
               - A and AAAA: IP addresses for the domain name.
               - CNAME: Another domain to check for records.
               - TXT: Arbitrary text strings associated with the domain name. Hosting
               uses TXT records to determine a which Firebase Projects have
               permission to act on the domain name's behalf.
               - CAA: The record's flags, tag, and value, e.g. `0 issue "pki.goog"`.
        :param _builtins.str required_action: Indicates the a required action for this record.
        :param _builtins.str type: The record's type, which determines what data the record contains.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if rdata is not None:
            pulumi.set(__self__, "rdata", rdata)
        if required_action is not None:
            pulumi.set(__self__, "required_action", required_action)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[_builtins.str]:
        """
        The domain name the record pertains to, e.g. `foo.bar.com.`.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter
    def rdata(self) -> Optional[_builtins.str]:
        """
        The data of the record. The meaning of the value depends on record type:
        - A and AAAA: IP addresses for the domain name.
        - CNAME: Another domain to check for records.
        - TXT: Arbitrary text strings associated with the domain name. Hosting
        uses TXT records to determine a which Firebase Projects have
        permission to act on the domain name's behalf.
        - CAA: The record's flags, tag, and value, e.g. `0 issue "pki.goog"`.
        """
        return pulumi.get(self, "rdata")

    @_builtins.property
    @pulumi.getter(name="requiredAction")
    def required_action(self) -> Optional[_builtins.str]:
        """
        Indicates the a required action for this record.
        """
        return pulumi.get(self, "required_action")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The record's type, which determines what data the record contains.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class HostingCustomDomainCertVerificationHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastCheckTime":
            suggest = "last_check_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostingCustomDomainCertVerificationHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostingCustomDomainCertVerificationHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostingCustomDomainCertVerificationHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 desired: Optional[_builtins.str] = None,
                 discovered: Optional[_builtins.str] = None,
                 last_check_time: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None):
        """
        :param _builtins.str desired: A text string to serve at the path.
        :param _builtins.str discovered: Whether Hosting was able to find the required file contents on the
               specified path during its last check.
        :param _builtins.str last_check_time: (Output)
               The last time Hosting systems checked for the file contents.
        :param _builtins.str path: The path to the file.
        """
        if desired is not None:
            pulumi.set(__self__, "desired", desired)
        if discovered is not None:
            pulumi.set(__self__, "discovered", discovered)
        if last_check_time is not None:
            pulumi.set(__self__, "last_check_time", last_check_time)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def desired(self) -> Optional[_builtins.str]:
        """
        A text string to serve at the path.
        """
        return pulumi.get(self, "desired")

    @_builtins.property
    @pulumi.getter
    def discovered(self) -> Optional[_builtins.str]:
        """
        Whether Hosting was able to find the required file contents on the
        specified path during its last check.
        """
        return pulumi.get(self, "discovered")

    @_builtins.property
    @pulumi.getter(name="lastCheckTime")
    def last_check_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        The last time Hosting systems checked for the file contents.
        """
        return pulumi.get(self, "last_check_time")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        The path to the file.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class HostingCustomDomainIssue(dict):
    def __init__(__self__, *,
                 code: Optional[_builtins.int] = None,
                 details: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None):
        """
        :param _builtins.int code: The status code, which should be an enum value of `google.rpc.Code`
        :param _builtins.str details: A list of messages that carry the error details.
        :param _builtins.str message: Error message
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[_builtins.int]:
        """
        The status code, which should be an enum value of `google.rpc.Code`
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def details(self) -> Optional[_builtins.str]:
        """
        A list of messages that carry the error details.
        """
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        Error message
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class HostingCustomDomainRequiredDnsUpdate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "checkTime":
            suggest = "check_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostingCustomDomainRequiredDnsUpdate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostingCustomDomainRequiredDnsUpdate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostingCustomDomainRequiredDnsUpdate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 check_time: Optional[_builtins.str] = None,
                 desireds: Optional[Sequence['outputs.HostingCustomDomainRequiredDnsUpdateDesired']] = None,
                 discovereds: Optional[Sequence['outputs.HostingCustomDomainRequiredDnsUpdateDiscovered']] = None):
        """
        :param _builtins.str check_time: (Output)
               The last time Hosting checked your CustomDomain's DNS records.
        :param Sequence['HostingCustomDomainRequiredDnsUpdateDesiredArgs'] desireds: A text string to serve at the path.
        :param Sequence['HostingCustomDomainRequiredDnsUpdateDiscoveredArgs'] discovereds: Whether Hosting was able to find the required file contents on the
               specified path during its last check.
        """
        if check_time is not None:
            pulumi.set(__self__, "check_time", check_time)
        if desireds is not None:
            pulumi.set(__self__, "desireds", desireds)
        if discovereds is not None:
            pulumi.set(__self__, "discovereds", discovereds)

    @_builtins.property
    @pulumi.getter(name="checkTime")
    def check_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        The last time Hosting checked your CustomDomain's DNS records.
        """
        return pulumi.get(self, "check_time")

    @_builtins.property
    @pulumi.getter
    def desireds(self) -> Optional[Sequence['outputs.HostingCustomDomainRequiredDnsUpdateDesired']]:
        """
        A text string to serve at the path.
        """
        return pulumi.get(self, "desireds")

    @_builtins.property
    @pulumi.getter
    def discovereds(self) -> Optional[Sequence['outputs.HostingCustomDomainRequiredDnsUpdateDiscovered']]:
        """
        Whether Hosting was able to find the required file contents on the
        specified path during its last check.
        """
        return pulumi.get(self, "discovereds")


@pulumi.output_type
class HostingCustomDomainRequiredDnsUpdateDesired(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostingCustomDomainRequiredDnsUpdateDesired. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostingCustomDomainRequiredDnsUpdateDesired.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostingCustomDomainRequiredDnsUpdateDesired.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[_builtins.str] = None,
                 records: Optional[Sequence['outputs.HostingCustomDomainRequiredDnsUpdateDesiredRecord']] = None):
        """
        :param _builtins.str domain_name: The domain name the record pertains to, e.g. `foo.bar.com.`.
        :param Sequence['HostingCustomDomainRequiredDnsUpdateDesiredRecordArgs'] records: Records on the domain
               Structure is documented below.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if records is not None:
            pulumi.set(__self__, "records", records)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[_builtins.str]:
        """
        The domain name the record pertains to, e.g. `foo.bar.com.`.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter
    def records(self) -> Optional[Sequence['outputs.HostingCustomDomainRequiredDnsUpdateDesiredRecord']]:
        """
        Records on the domain
        Structure is documented below.
        """
        return pulumi.get(self, "records")


@pulumi.output_type
class HostingCustomDomainRequiredDnsUpdateDesiredRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "requiredAction":
            suggest = "required_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostingCustomDomainRequiredDnsUpdateDesiredRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostingCustomDomainRequiredDnsUpdateDesiredRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostingCustomDomainRequiredDnsUpdateDesiredRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[_builtins.str] = None,
                 rdata: Optional[_builtins.str] = None,
                 required_action: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str domain_name: The domain name the record pertains to, e.g. `foo.bar.com.`.
        :param _builtins.str rdata: The data of the record. The meaning of the value depends on record type:
               - A and AAAA: IP addresses for the domain name.
               - CNAME: Another domain to check for records.
               - TXT: Arbitrary text strings associated with the domain name. Hosting
               uses TXT records to determine a which Firebase Projects have
               permission to act on the domain name's behalf.
               - CAA: The record's flags, tag, and value, e.g. `0 issue "pki.goog"`.
        :param _builtins.str required_action: Indicates the a required action for this record.
        :param _builtins.str type: The record's type, which determines what data the record contains.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if rdata is not None:
            pulumi.set(__self__, "rdata", rdata)
        if required_action is not None:
            pulumi.set(__self__, "required_action", required_action)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[_builtins.str]:
        """
        The domain name the record pertains to, e.g. `foo.bar.com.`.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter
    def rdata(self) -> Optional[_builtins.str]:
        """
        The data of the record. The meaning of the value depends on record type:
        - A and AAAA: IP addresses for the domain name.
        - CNAME: Another domain to check for records.
        - TXT: Arbitrary text strings associated with the domain name. Hosting
        uses TXT records to determine a which Firebase Projects have
        permission to act on the domain name's behalf.
        - CAA: The record's flags, tag, and value, e.g. `0 issue "pki.goog"`.
        """
        return pulumi.get(self, "rdata")

    @_builtins.property
    @pulumi.getter(name="requiredAction")
    def required_action(self) -> Optional[_builtins.str]:
        """
        Indicates the a required action for this record.
        """
        return pulumi.get(self, "required_action")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The record's type, which determines what data the record contains.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class HostingCustomDomainRequiredDnsUpdateDiscovered(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostingCustomDomainRequiredDnsUpdateDiscovered. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostingCustomDomainRequiredDnsUpdateDiscovered.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostingCustomDomainRequiredDnsUpdateDiscovered.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[_builtins.str] = None,
                 records: Optional[Sequence['outputs.HostingCustomDomainRequiredDnsUpdateDiscoveredRecord']] = None):
        """
        :param _builtins.str domain_name: The domain name the record pertains to, e.g. `foo.bar.com.`.
        :param Sequence['HostingCustomDomainRequiredDnsUpdateDiscoveredRecordArgs'] records: Records on the domain
               Structure is documented below.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if records is not None:
            pulumi.set(__self__, "records", records)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[_builtins.str]:
        """
        The domain name the record pertains to, e.g. `foo.bar.com.`.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter
    def records(self) -> Optional[Sequence['outputs.HostingCustomDomainRequiredDnsUpdateDiscoveredRecord']]:
        """
        Records on the domain
        Structure is documented below.
        """
        return pulumi.get(self, "records")


@pulumi.output_type
class HostingCustomDomainRequiredDnsUpdateDiscoveredRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "requiredAction":
            suggest = "required_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostingCustomDomainRequiredDnsUpdateDiscoveredRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostingCustomDomainRequiredDnsUpdateDiscoveredRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostingCustomDomainRequiredDnsUpdateDiscoveredRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[_builtins.str] = None,
                 rdata: Optional[_builtins.str] = None,
                 required_action: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str domain_name: The domain name the record pertains to, e.g. `foo.bar.com.`.
        :param _builtins.str rdata: The data of the record. The meaning of the value depends on record type:
               - A and AAAA: IP addresses for the domain name.
               - CNAME: Another domain to check for records.
               - TXT: Arbitrary text strings associated with the domain name. Hosting
               uses TXT records to determine a which Firebase Projects have
               permission to act on the domain name's behalf.
               - CAA: The record's flags, tag, and value, e.g. `0 issue "pki.goog"`.
        :param _builtins.str required_action: Indicates the a required action for this record.
        :param _builtins.str type: The record's type, which determines what data the record contains.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if rdata is not None:
            pulumi.set(__self__, "rdata", rdata)
        if required_action is not None:
            pulumi.set(__self__, "required_action", required_action)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[_builtins.str]:
        """
        The domain name the record pertains to, e.g. `foo.bar.com.`.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter
    def rdata(self) -> Optional[_builtins.str]:
        """
        The data of the record. The meaning of the value depends on record type:
        - A and AAAA: IP addresses for the domain name.
        - CNAME: Another domain to check for records.
        - TXT: Arbitrary text strings associated with the domain name. Hosting
        uses TXT records to determine a which Firebase Projects have
        permission to act on the domain name's behalf.
        - CAA: The record's flags, tag, and value, e.g. `0 issue "pki.goog"`.
        """
        return pulumi.get(self, "rdata")

    @_builtins.property
    @pulumi.getter(name="requiredAction")
    def required_action(self) -> Optional[_builtins.str]:
        """
        Indicates the a required action for this record.
        """
        return pulumi.get(self, "required_action")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The record's type, which determines what data the record contains.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class HostingVersionConfig(dict):
    def __init__(__self__, *,
                 headers: Optional[Sequence['outputs.HostingVersionConfigHeader']] = None,
                 redirects: Optional[Sequence['outputs.HostingVersionConfigRedirect']] = None,
                 rewrites: Optional[Sequence['outputs.HostingVersionConfigRewrite']] = None):
        """
        :param Sequence['HostingVersionConfigHeaderArgs'] headers: An array of objects, where each object specifies a URL pattern that, if matched to the request URL path,
               triggers Hosting to apply the specified custom response headers.
               Structure is documented below.
        :param Sequence['HostingVersionConfigRedirectArgs'] redirects: An array of objects (called redirect rules), where each rule specifies a URL pattern that, if matched to the request URL path,
               triggers Hosting to respond with a redirect to the specified destination path.
               Structure is documented below.
        :param Sequence['HostingVersionConfigRewriteArgs'] rewrites: An array of objects (called rewrite rules), where each rule specifies a URL pattern that, if matched to the
               request URL path, triggers Hosting to respond as if the service were given the specified destination URL.
               Structure is documented below.
        """
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if redirects is not None:
            pulumi.set(__self__, "redirects", redirects)
        if rewrites is not None:
            pulumi.set(__self__, "rewrites", rewrites)

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.HostingVersionConfigHeader']]:
        """
        An array of objects, where each object specifies a URL pattern that, if matched to the request URL path,
        triggers Hosting to apply the specified custom response headers.
        Structure is documented below.
        """
        return pulumi.get(self, "headers")

    @_builtins.property
    @pulumi.getter
    def redirects(self) -> Optional[Sequence['outputs.HostingVersionConfigRedirect']]:
        """
        An array of objects (called redirect rules), where each rule specifies a URL pattern that, if matched to the request URL path,
        triggers Hosting to respond with a redirect to the specified destination path.
        Structure is documented below.
        """
        return pulumi.get(self, "redirects")

    @_builtins.property
    @pulumi.getter
    def rewrites(self) -> Optional[Sequence['outputs.HostingVersionConfigRewrite']]:
        """
        An array of objects (called rewrite rules), where each rule specifies a URL pattern that, if matched to the
        request URL path, triggers Hosting to respond as if the service were given the specified destination URL.
        Structure is documented below.
        """
        return pulumi.get(self, "rewrites")


@pulumi.output_type
class HostingVersionConfigHeader(dict):
    def __init__(__self__, *,
                 headers: Mapping[str, _builtins.str],
                 glob: Optional[_builtins.str] = None,
                 regex: Optional[_builtins.str] = None):
        """
        :param Mapping[str, _builtins.str] headers: The additional headers to add to the response. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param _builtins.str glob: The user-supplied glob to match against the request URL path.
        :param _builtins.str regex: The user-supplied RE2 regular expression to match against the request URL path.
        """
        pulumi.set(__self__, "headers", headers)
        if glob is not None:
            pulumi.set(__self__, "glob", glob)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Mapping[str, _builtins.str]:
        """
        The additional headers to add to the response. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        return pulumi.get(self, "headers")

    @_builtins.property
    @pulumi.getter
    def glob(self) -> Optional[_builtins.str]:
        """
        The user-supplied glob to match against the request URL path.
        """
        return pulumi.get(self, "glob")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.str]:
        """
        The user-supplied RE2 regular expression to match against the request URL path.
        """
        return pulumi.get(self, "regex")


@pulumi.output_type
class HostingVersionConfigRedirect(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostingVersionConfigRedirect. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostingVersionConfigRedirect.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostingVersionConfigRedirect.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: _builtins.str,
                 status_code: _builtins.int,
                 glob: Optional[_builtins.str] = None,
                 regex: Optional[_builtins.str] = None):
        """
        :param _builtins.str location: The value to put in the HTTP location header of the response.
               The location can contain capture group values from the pattern using a : prefix to identify
               the segment and an optional * to capture the rest of the URL. For example:
        :param _builtins.int status_code: The status HTTP code to return in the response. It must be a valid 3xx status code.
        :param _builtins.str glob: The user-supplied glob to match against the request URL path.
        :param _builtins.str regex: The user-supplied RE2 regular expression to match against the request URL path.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "status_code", status_code)
        if glob is not None:
            pulumi.set(__self__, "glob", glob)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The value to put in the HTTP location header of the response.
        The location can contain capture group values from the pattern using a : prefix to identify
        the segment and an optional * to capture the rest of the URL. For example:
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> _builtins.int:
        """
        The status HTTP code to return in the response. It must be a valid 3xx status code.
        """
        return pulumi.get(self, "status_code")

    @_builtins.property
    @pulumi.getter
    def glob(self) -> Optional[_builtins.str]:
        """
        The user-supplied glob to match against the request URL path.
        """
        return pulumi.get(self, "glob")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.str]:
        """
        The user-supplied RE2 regular expression to match against the request URL path.
        """
        return pulumi.get(self, "regex")


@pulumi.output_type
class HostingVersionConfigRewrite(dict):
    def __init__(__self__, *,
                 function: Optional[_builtins.str] = None,
                 glob: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 regex: Optional[_builtins.str] = None,
                 run: Optional['outputs.HostingVersionConfigRewriteRun'] = None):
        """
        :param _builtins.str function: The function to proxy requests to. Must match the exported function name exactly.
        :param _builtins.str glob: The user-supplied glob to match against the request URL path.
        :param _builtins.str path: The URL path to rewrite the request to.
        :param _builtins.str regex: The user-supplied RE2 regular expression to match against the request URL path.
        :param 'HostingVersionConfigRewriteRunArgs' run: The request will be forwarded to Cloud Run.
               Structure is documented below.
        """
        if function is not None:
            pulumi.set(__self__, "function", function)
        if glob is not None:
            pulumi.set(__self__, "glob", glob)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)
        if run is not None:
            pulumi.set(__self__, "run", run)

    @_builtins.property
    @pulumi.getter
    def function(self) -> Optional[_builtins.str]:
        """
        The function to proxy requests to. Must match the exported function name exactly.
        """
        return pulumi.get(self, "function")

    @_builtins.property
    @pulumi.getter
    def glob(self) -> Optional[_builtins.str]:
        """
        The user-supplied glob to match against the request URL path.
        """
        return pulumi.get(self, "glob")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        The URL path to rewrite the request to.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.str]:
        """
        The user-supplied RE2 regular expression to match against the request URL path.
        """
        return pulumi.get(self, "regex")

    @_builtins.property
    @pulumi.getter
    def run(self) -> Optional['outputs.HostingVersionConfigRewriteRun']:
        """
        The request will be forwarded to Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "run")


@pulumi.output_type
class HostingVersionConfigRewriteRun(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceId":
            suggest = "service_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostingVersionConfigRewriteRun. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostingVersionConfigRewriteRun.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostingVersionConfigRewriteRun.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_id: _builtins.str,
                 region: Optional[_builtins.str] = None):
        """
        :param _builtins.str service_id: User-defined ID of the Cloud Run service.
        :param _builtins.str region: Optional. User-provided region where the Cloud Run service is hosted. Defaults to `us-central1` if not supplied.
        """
        pulumi.set(__self__, "service_id", service_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> _builtins.str:
        """
        User-defined ID of the Cloud Run service.
        """
        return pulumi.get(self, "service_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        Optional. User-provided region where the Cloud Run service is hosted. Defaults to `us-central1` if not supplied.
        """
        return pulumi.get(self, "region")


