# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IndexArgs', 'Index']

@pulumi.input_type
class IndexArgs:
    def __init__(__self__, *,
                 collection: pulumi.Input[_builtins.str],
                 fields: pulumi.Input[Sequence[pulumi.Input['IndexFieldArgs']]],
                 api_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 density: Optional[pulumi.Input[_builtins.str]] = None,
                 multikey: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 query_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 unique: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Index resource.
        :param pulumi.Input[_builtins.str] collection: The collection being indexed.
        :param pulumi.Input[Sequence[pulumi.Input['IndexFieldArgs']]] fields: The fields supported by this index. The last non-stored field entry is
               always for the field path `__name__`. If, on creation, `__name__` was not
               specified as the last field, it will be added automatically with the same
               direction as that of the last field defined. If the final field in a
               composite index is not directional, the `__name__` will be ordered
               `"ASCENDING"` (unless explicitly specified otherwise).
               Structure is documented below.
        :param pulumi.Input[_builtins.str] api_scope: The API scope at which a query is run.
               Default value is `ANY_API`.
               Possible values are: `ANY_API`, `DATASTORE_MODE_API`, `MONGODB_COMPATIBLE_API`.
        :param pulumi.Input[_builtins.str] database: The Firestore database id. Defaults to `"(default)"`.
        :param pulumi.Input[_builtins.str] density: The density configuration for this index.
               Possible values are: `SPARSE_ALL`, `SPARSE_ANY`, `DENSE`.
        :param pulumi.Input[_builtins.bool] multikey: Optional. Whether the index is multikey. By default, the index is not multikey. For non-multikey indexes, none of the paths in the index definition reach or traverse an array, except via an explicit array index. For multikey indexes, at most one of the paths in the index definition reach or traverse an array, except via an explicit array index. Violations will result in errors. Note this field only applies to indexes with MONGODB_COMPATIBLE_API ApiScope.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] query_scope: The scope at which a query is run.
               Default value is `COLLECTION`.
               Possible values are: `COLLECTION`, `COLLECTION_GROUP`, `COLLECTION_RECURSIVE`.
        :param pulumi.Input[_builtins.bool] unique: Whether it is an unique index. Unique index ensures all values for the indexed field(s) are unique across documents.
        """
        pulumi.set(__self__, "collection", collection)
        pulumi.set(__self__, "fields", fields)
        if api_scope is not None:
            pulumi.set(__self__, "api_scope", api_scope)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if density is not None:
            pulumi.set(__self__, "density", density)
        if multikey is not None:
            pulumi.set(__self__, "multikey", multikey)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if query_scope is not None:
            pulumi.set(__self__, "query_scope", query_scope)
        if unique is not None:
            pulumi.set(__self__, "unique", unique)

    @_builtins.property
    @pulumi.getter
    def collection(self) -> pulumi.Input[_builtins.str]:
        """
        The collection being indexed.
        """
        return pulumi.get(self, "collection")

    @collection.setter
    def collection(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "collection", value)

    @_builtins.property
    @pulumi.getter
    def fields(self) -> pulumi.Input[Sequence[pulumi.Input['IndexFieldArgs']]]:
        """
        The fields supported by this index. The last non-stored field entry is
        always for the field path `__name__`. If, on creation, `__name__` was not
        specified as the last field, it will be added automatically with the same
        direction as that of the last field defined. If the final field in a
        composite index is not directional, the `__name__` will be ordered
        `"ASCENDING"` (unless explicitly specified otherwise).
        Structure is documented below.
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: pulumi.Input[Sequence[pulumi.Input['IndexFieldArgs']]]):
        pulumi.set(self, "fields", value)

    @_builtins.property
    @pulumi.getter(name="apiScope")
    def api_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The API scope at which a query is run.
        Default value is `ANY_API`.
        Possible values are: `ANY_API`, `DATASTORE_MODE_API`, `MONGODB_COMPATIBLE_API`.
        """
        return pulumi.get(self, "api_scope")

    @api_scope.setter
    def api_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_scope", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Firestore database id. Defaults to `"(default)"`.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter
    def density(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The density configuration for this index.
        Possible values are: `SPARSE_ALL`, `SPARSE_ANY`, `DENSE`.
        """
        return pulumi.get(self, "density")

    @density.setter
    def density(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "density", value)

    @_builtins.property
    @pulumi.getter
    def multikey(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optional. Whether the index is multikey. By default, the index is not multikey. For non-multikey indexes, none of the paths in the index definition reach or traverse an array, except via an explicit array index. For multikey indexes, at most one of the paths in the index definition reach or traverse an array, except via an explicit array index. Violations will result in errors. Note this field only applies to indexes with MONGODB_COMPATIBLE_API ApiScope.
        """
        return pulumi.get(self, "multikey")

    @multikey.setter
    def multikey(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "multikey", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="queryScope")
    def query_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scope at which a query is run.
        Default value is `COLLECTION`.
        Possible values are: `COLLECTION`, `COLLECTION_GROUP`, `COLLECTION_RECURSIVE`.
        """
        return pulumi.get(self, "query_scope")

    @query_scope.setter
    def query_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_scope", value)

    @_builtins.property
    @pulumi.getter
    def unique(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether it is an unique index. Unique index ensures all values for the indexed field(s) are unique across documents.
        """
        return pulumi.get(self, "unique")

    @unique.setter
    def unique(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "unique", value)


@pulumi.input_type
class _IndexState:
    def __init__(__self__, *,
                 api_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 collection: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 density: Optional[pulumi.Input[_builtins.str]] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input['IndexFieldArgs']]]] = None,
                 multikey: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 query_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 unique: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Index resources.
        :param pulumi.Input[_builtins.str] api_scope: The API scope at which a query is run.
               Default value is `ANY_API`.
               Possible values are: `ANY_API`, `DATASTORE_MODE_API`, `MONGODB_COMPATIBLE_API`.
        :param pulumi.Input[_builtins.str] collection: The collection being indexed.
        :param pulumi.Input[_builtins.str] database: The Firestore database id. Defaults to `"(default)"`.
        :param pulumi.Input[_builtins.str] density: The density configuration for this index.
               Possible values are: `SPARSE_ALL`, `SPARSE_ANY`, `DENSE`.
        :param pulumi.Input[Sequence[pulumi.Input['IndexFieldArgs']]] fields: The fields supported by this index. The last non-stored field entry is
               always for the field path `__name__`. If, on creation, `__name__` was not
               specified as the last field, it will be added automatically with the same
               direction as that of the last field defined. If the final field in a
               composite index is not directional, the `__name__` will be ordered
               `"ASCENDING"` (unless explicitly specified otherwise).
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] multikey: Optional. Whether the index is multikey. By default, the index is not multikey. For non-multikey indexes, none of the paths in the index definition reach or traverse an array, except via an explicit array index. For multikey indexes, at most one of the paths in the index definition reach or traverse an array, except via an explicit array index. Violations will result in errors. Note this field only applies to indexes with MONGODB_COMPATIBLE_API ApiScope.
        :param pulumi.Input[_builtins.str] name: A server defined name for this index. Format:
               `projects/{{project}}/databases/{{database}}/collectionGroups/{{collection}}/indexes/{{server_generated_id}}`
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] query_scope: The scope at which a query is run.
               Default value is `COLLECTION`.
               Possible values are: `COLLECTION`, `COLLECTION_GROUP`, `COLLECTION_RECURSIVE`.
        :param pulumi.Input[_builtins.bool] unique: Whether it is an unique index. Unique index ensures all values for the indexed field(s) are unique across documents.
        """
        if api_scope is not None:
            pulumi.set(__self__, "api_scope", api_scope)
        if collection is not None:
            pulumi.set(__self__, "collection", collection)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if density is not None:
            pulumi.set(__self__, "density", density)
        if fields is not None:
            pulumi.set(__self__, "fields", fields)
        if multikey is not None:
            pulumi.set(__self__, "multikey", multikey)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if query_scope is not None:
            pulumi.set(__self__, "query_scope", query_scope)
        if unique is not None:
            pulumi.set(__self__, "unique", unique)

    @_builtins.property
    @pulumi.getter(name="apiScope")
    def api_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The API scope at which a query is run.
        Default value is `ANY_API`.
        Possible values are: `ANY_API`, `DATASTORE_MODE_API`, `MONGODB_COMPATIBLE_API`.
        """
        return pulumi.get(self, "api_scope")

    @api_scope.setter
    def api_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_scope", value)

    @_builtins.property
    @pulumi.getter
    def collection(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The collection being indexed.
        """
        return pulumi.get(self, "collection")

    @collection.setter
    def collection(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "collection", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Firestore database id. Defaults to `"(default)"`.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter
    def density(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The density configuration for this index.
        Possible values are: `SPARSE_ALL`, `SPARSE_ANY`, `DENSE`.
        """
        return pulumi.get(self, "density")

    @density.setter
    def density(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "density", value)

    @_builtins.property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IndexFieldArgs']]]]:
        """
        The fields supported by this index. The last non-stored field entry is
        always for the field path `__name__`. If, on creation, `__name__` was not
        specified as the last field, it will be added automatically with the same
        direction as that of the last field defined. If the final field in a
        composite index is not directional, the `__name__` will be ordered
        `"ASCENDING"` (unless explicitly specified otherwise).
        Structure is documented below.
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IndexFieldArgs']]]]):
        pulumi.set(self, "fields", value)

    @_builtins.property
    @pulumi.getter
    def multikey(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optional. Whether the index is multikey. By default, the index is not multikey. For non-multikey indexes, none of the paths in the index definition reach or traverse an array, except via an explicit array index. For multikey indexes, at most one of the paths in the index definition reach or traverse an array, except via an explicit array index. Violations will result in errors. Note this field only applies to indexes with MONGODB_COMPATIBLE_API ApiScope.
        """
        return pulumi.get(self, "multikey")

    @multikey.setter
    def multikey(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "multikey", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A server defined name for this index. Format:
        `projects/{{project}}/databases/{{database}}/collectionGroups/{{collection}}/indexes/{{server_generated_id}}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="queryScope")
    def query_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scope at which a query is run.
        Default value is `COLLECTION`.
        Possible values are: `COLLECTION`, `COLLECTION_GROUP`, `COLLECTION_RECURSIVE`.
        """
        return pulumi.get(self, "query_scope")

    @query_scope.setter
    def query_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_scope", value)

    @_builtins.property
    @pulumi.getter
    def unique(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether it is an unique index. Unique index ensures all values for the indexed field(s) are unique across documents.
        """
        return pulumi.get(self, "unique")

    @unique.setter
    def unique(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "unique", value)


@pulumi.type_token("gcp:firestore/index:Index")
class Index(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 collection: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 density: Optional[pulumi.Input[_builtins.str]] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IndexFieldArgs', 'IndexFieldArgsDict']]]]] = None,
                 multikey: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 query_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 unique: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Cloud Firestore indexes enable simple and complex queries against documents in a database.
         Both Firestore Native and Datastore Mode indexes are supported.
         This resource manages composite indexes and not single field indexes.
         To manage single field indexes, use the `firestore.Field` resource instead.

        To get more information about Index, see:

        * [API documentation](https://cloud.google.com/firestore/docs/reference/rest/v1/projects.databases.collectionGroups.indexes)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/firestore/docs/query-data/indexing)

        > **Warning:** This resource creates a Firestore Index on a project that already has
        a Firestore database. If you haven't already created it, you may
        create a `firestore.Database` resource and `location_id` set
        to your chosen location. If you wish to use App Engine, you may
        instead create a `appengine.Application` resource.
        Your Firestore location will be the same as the App Engine location specified.

        ## Example Usage

        ### Firestore Index Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        database = gcp.firestore.Database("database",
            project="my-project-name",
            name="database-id",
            location_id="nam5",
            type="FIRESTORE_NATIVE",
            delete_protection_state="DELETE_PROTECTION_DISABLED",
            deletion_policy="DELETE")
        my_index = gcp.firestore.Index("my-index",
            project="my-project-name",
            database=database.name,
            collection="atestcollection",
            fields=[
                {
                    "field_path": "name",
                    "order": "ASCENDING",
                },
                {
                    "field_path": "description",
                    "order": "DESCENDING",
                },
            ])
        ```
        ### Firestore Index Datastore Mode

        ```python
        import pulumi
        import pulumi_gcp as gcp

        database = gcp.firestore.Database("database",
            project="my-project-name",
            name="database-id-dm",
            location_id="nam5",
            type="DATASTORE_MODE",
            delete_protection_state="DELETE_PROTECTION_DISABLED",
            deletion_policy="DELETE")
        my_index = gcp.firestore.Index("my-index",
            project="my-project-name",
            database=database.name,
            collection="atestcollection",
            query_scope="COLLECTION_RECURSIVE",
            api_scope="DATASTORE_MODE_API",
            density="SPARSE_ALL",
            fields=[
                {
                    "field_path": "name",
                    "order": "ASCENDING",
                },
                {
                    "field_path": "description",
                    "order": "DESCENDING",
                },
            ])
        ```
        ### Firestore Index Vector

        ```python
        import pulumi
        import pulumi_gcp as gcp

        database = gcp.firestore.Database("database",
            project="my-project-name",
            name="database-id-vector",
            location_id="nam5",
            type="FIRESTORE_NATIVE",
            delete_protection_state="DELETE_PROTECTION_DISABLED",
            deletion_policy="DELETE")
        my_index = gcp.firestore.Index("my-index",
            project="my-project-name",
            database=database.name,
            collection="atestcollection",
            fields=[
                {
                    "field_path": "field_name",
                    "order": "ASCENDING",
                },
                {
                    "field_path": "__name__",
                    "order": "ASCENDING",
                },
                {
                    "field_path": "description",
                    "vector_config": {
                        "dimension": 128,
                        "flat": {},
                    },
                },
            ])
        ```
        ### Firestore Index Name Descending

        ```python
        import pulumi
        import pulumi_gcp as gcp

        database = gcp.firestore.Database("database",
            project="my-project-name",
            name="database-id",
            location_id="nam5",
            type="FIRESTORE_NATIVE",
            delete_protection_state="DELETE_PROTECTION_DISABLED",
            deletion_policy="DELETE")
        my_index = gcp.firestore.Index("my-index",
            project="my-project-name",
            database=database.name,
            collection="atestcollection",
            fields=[{
                "field_path": "__name__",
                "order": "DESCENDING",
            }])
        ```
        ### Firestore Index Mongodb Compatible Scope

        ```python
        import pulumi
        import pulumi_gcp as gcp

        database = gcp.firestore.Database("database",
            project="my-project-name",
            name="database-id-mongodb-compatible",
            location_id="nam5",
            type="FIRESTORE_NATIVE",
            database_edition="ENTERPRISE",
            delete_protection_state="DELETE_PROTECTION_DISABLED",
            deletion_policy="DELETE")
        my_index = gcp.firestore.Index("my-index",
            project="my-project-name",
            database=database.name,
            collection="atestcollection",
            api_scope="MONGODB_COMPATIBLE_API",
            query_scope="COLLECTION_GROUP",
            multikey=True,
            density="DENSE",
            fields=[
                {
                    "field_path": "name",
                    "order": "ASCENDING",
                },
                {
                    "field_path": "description",
                    "order": "DESCENDING",
                },
            ])
        ```
        ### Firestore Index Sparse Any

        ```python
        import pulumi
        import pulumi_gcp as gcp

        database = gcp.firestore.Database("database",
            project="my-project-name",
            name="database-id-sparse-any",
            location_id="nam5",
            type="FIRESTORE_NATIVE",
            database_edition="ENTERPRISE",
            delete_protection_state="DELETE_PROTECTION_DISABLED",
            deletion_policy="DELETE")
        my_index = gcp.firestore.Index("my-index",
            project="my-project-name",
            database=database.name,
            collection="atestcollection",
            api_scope="MONGODB_COMPATIBLE_API",
            query_scope="COLLECTION_GROUP",
            multikey=True,
            density="SPARSE_ANY",
            fields=[
                {
                    "field_path": "name",
                    "order": "ASCENDING",
                },
                {
                    "field_path": "description",
                    "order": "DESCENDING",
                },
            ])
        ```
        ### Firestore Index Unique

        ```python
        import pulumi
        import pulumi_gcp as gcp

        database = gcp.firestore.Database("database",
            project="my-project-name",
            name="database-id-unique",
            location_id="nam5",
            type="FIRESTORE_NATIVE",
            database_edition="ENTERPRISE",
            delete_protection_state="DELETE_PROTECTION_DISABLED",
            deletion_policy="DELETE")
        my_index = gcp.firestore.Index("my-index",
            project="my-project-name",
            database=database.name,
            collection="atestcollection",
            api_scope="MONGODB_COMPATIBLE_API",
            query_scope="COLLECTION_GROUP",
            multikey=True,
            density="DENSE",
            unique=True,
            fields=[
                {
                    "field_path": "name",
                    "order": "ASCENDING",
                },
                {
                    "field_path": "description",
                    "order": "DESCENDING",
                },
            ])
        ```

        ## Import

        Index can be imported using any of these accepted formats:

        * `{{name}}`

        When using the `pulumi import` command, Index can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firestore/index:Index default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_scope: The API scope at which a query is run.
               Default value is `ANY_API`.
               Possible values are: `ANY_API`, `DATASTORE_MODE_API`, `MONGODB_COMPATIBLE_API`.
        :param pulumi.Input[_builtins.str] collection: The collection being indexed.
        :param pulumi.Input[_builtins.str] database: The Firestore database id. Defaults to `"(default)"`.
        :param pulumi.Input[_builtins.str] density: The density configuration for this index.
               Possible values are: `SPARSE_ALL`, `SPARSE_ANY`, `DENSE`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IndexFieldArgs', 'IndexFieldArgsDict']]]] fields: The fields supported by this index. The last non-stored field entry is
               always for the field path `__name__`. If, on creation, `__name__` was not
               specified as the last field, it will be added automatically with the same
               direction as that of the last field defined. If the final field in a
               composite index is not directional, the `__name__` will be ordered
               `"ASCENDING"` (unless explicitly specified otherwise).
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] multikey: Optional. Whether the index is multikey. By default, the index is not multikey. For non-multikey indexes, none of the paths in the index definition reach or traverse an array, except via an explicit array index. For multikey indexes, at most one of the paths in the index definition reach or traverse an array, except via an explicit array index. Violations will result in errors. Note this field only applies to indexes with MONGODB_COMPATIBLE_API ApiScope.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] query_scope: The scope at which a query is run.
               Default value is `COLLECTION`.
               Possible values are: `COLLECTION`, `COLLECTION_GROUP`, `COLLECTION_RECURSIVE`.
        :param pulumi.Input[_builtins.bool] unique: Whether it is an unique index. Unique index ensures all values for the indexed field(s) are unique across documents.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IndexArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Cloud Firestore indexes enable simple and complex queries against documents in a database.
         Both Firestore Native and Datastore Mode indexes are supported.
         This resource manages composite indexes and not single field indexes.
         To manage single field indexes, use the `firestore.Field` resource instead.

        To get more information about Index, see:

        * [API documentation](https://cloud.google.com/firestore/docs/reference/rest/v1/projects.databases.collectionGroups.indexes)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/firestore/docs/query-data/indexing)

        > **Warning:** This resource creates a Firestore Index on a project that already has
        a Firestore database. If you haven't already created it, you may
        create a `firestore.Database` resource and `location_id` set
        to your chosen location. If you wish to use App Engine, you may
        instead create a `appengine.Application` resource.
        Your Firestore location will be the same as the App Engine location specified.

        ## Example Usage

        ### Firestore Index Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        database = gcp.firestore.Database("database",
            project="my-project-name",
            name="database-id",
            location_id="nam5",
            type="FIRESTORE_NATIVE",
            delete_protection_state="DELETE_PROTECTION_DISABLED",
            deletion_policy="DELETE")
        my_index = gcp.firestore.Index("my-index",
            project="my-project-name",
            database=database.name,
            collection="atestcollection",
            fields=[
                {
                    "field_path": "name",
                    "order": "ASCENDING",
                },
                {
                    "field_path": "description",
                    "order": "DESCENDING",
                },
            ])
        ```
        ### Firestore Index Datastore Mode

        ```python
        import pulumi
        import pulumi_gcp as gcp

        database = gcp.firestore.Database("database",
            project="my-project-name",
            name="database-id-dm",
            location_id="nam5",
            type="DATASTORE_MODE",
            delete_protection_state="DELETE_PROTECTION_DISABLED",
            deletion_policy="DELETE")
        my_index = gcp.firestore.Index("my-index",
            project="my-project-name",
            database=database.name,
            collection="atestcollection",
            query_scope="COLLECTION_RECURSIVE",
            api_scope="DATASTORE_MODE_API",
            density="SPARSE_ALL",
            fields=[
                {
                    "field_path": "name",
                    "order": "ASCENDING",
                },
                {
                    "field_path": "description",
                    "order": "DESCENDING",
                },
            ])
        ```
        ### Firestore Index Vector

        ```python
        import pulumi
        import pulumi_gcp as gcp

        database = gcp.firestore.Database("database",
            project="my-project-name",
            name="database-id-vector",
            location_id="nam5",
            type="FIRESTORE_NATIVE",
            delete_protection_state="DELETE_PROTECTION_DISABLED",
            deletion_policy="DELETE")
        my_index = gcp.firestore.Index("my-index",
            project="my-project-name",
            database=database.name,
            collection="atestcollection",
            fields=[
                {
                    "field_path": "field_name",
                    "order": "ASCENDING",
                },
                {
                    "field_path": "__name__",
                    "order": "ASCENDING",
                },
                {
                    "field_path": "description",
                    "vector_config": {
                        "dimension": 128,
                        "flat": {},
                    },
                },
            ])
        ```
        ### Firestore Index Name Descending

        ```python
        import pulumi
        import pulumi_gcp as gcp

        database = gcp.firestore.Database("database",
            project="my-project-name",
            name="database-id",
            location_id="nam5",
            type="FIRESTORE_NATIVE",
            delete_protection_state="DELETE_PROTECTION_DISABLED",
            deletion_policy="DELETE")
        my_index = gcp.firestore.Index("my-index",
            project="my-project-name",
            database=database.name,
            collection="atestcollection",
            fields=[{
                "field_path": "__name__",
                "order": "DESCENDING",
            }])
        ```
        ### Firestore Index Mongodb Compatible Scope

        ```python
        import pulumi
        import pulumi_gcp as gcp

        database = gcp.firestore.Database("database",
            project="my-project-name",
            name="database-id-mongodb-compatible",
            location_id="nam5",
            type="FIRESTORE_NATIVE",
            database_edition="ENTERPRISE",
            delete_protection_state="DELETE_PROTECTION_DISABLED",
            deletion_policy="DELETE")
        my_index = gcp.firestore.Index("my-index",
            project="my-project-name",
            database=database.name,
            collection="atestcollection",
            api_scope="MONGODB_COMPATIBLE_API",
            query_scope="COLLECTION_GROUP",
            multikey=True,
            density="DENSE",
            fields=[
                {
                    "field_path": "name",
                    "order": "ASCENDING",
                },
                {
                    "field_path": "description",
                    "order": "DESCENDING",
                },
            ])
        ```
        ### Firestore Index Sparse Any

        ```python
        import pulumi
        import pulumi_gcp as gcp

        database = gcp.firestore.Database("database",
            project="my-project-name",
            name="database-id-sparse-any",
            location_id="nam5",
            type="FIRESTORE_NATIVE",
            database_edition="ENTERPRISE",
            delete_protection_state="DELETE_PROTECTION_DISABLED",
            deletion_policy="DELETE")
        my_index = gcp.firestore.Index("my-index",
            project="my-project-name",
            database=database.name,
            collection="atestcollection",
            api_scope="MONGODB_COMPATIBLE_API",
            query_scope="COLLECTION_GROUP",
            multikey=True,
            density="SPARSE_ANY",
            fields=[
                {
                    "field_path": "name",
                    "order": "ASCENDING",
                },
                {
                    "field_path": "description",
                    "order": "DESCENDING",
                },
            ])
        ```
        ### Firestore Index Unique

        ```python
        import pulumi
        import pulumi_gcp as gcp

        database = gcp.firestore.Database("database",
            project="my-project-name",
            name="database-id-unique",
            location_id="nam5",
            type="FIRESTORE_NATIVE",
            database_edition="ENTERPRISE",
            delete_protection_state="DELETE_PROTECTION_DISABLED",
            deletion_policy="DELETE")
        my_index = gcp.firestore.Index("my-index",
            project="my-project-name",
            database=database.name,
            collection="atestcollection",
            api_scope="MONGODB_COMPATIBLE_API",
            query_scope="COLLECTION_GROUP",
            multikey=True,
            density="DENSE",
            unique=True,
            fields=[
                {
                    "field_path": "name",
                    "order": "ASCENDING",
                },
                {
                    "field_path": "description",
                    "order": "DESCENDING",
                },
            ])
        ```

        ## Import

        Index can be imported using any of these accepted formats:

        * `{{name}}`

        When using the `pulumi import` command, Index can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firestore/index:Index default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param IndexArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IndexArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 collection: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 density: Optional[pulumi.Input[_builtins.str]] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IndexFieldArgs', 'IndexFieldArgsDict']]]]] = None,
                 multikey: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 query_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 unique: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IndexArgs.__new__(IndexArgs)

            __props__.__dict__["api_scope"] = api_scope
            if collection is None and not opts.urn:
                raise TypeError("Missing required property 'collection'")
            __props__.__dict__["collection"] = collection
            __props__.__dict__["database"] = database
            __props__.__dict__["density"] = density
            if fields is None and not opts.urn:
                raise TypeError("Missing required property 'fields'")
            __props__.__dict__["fields"] = fields
            __props__.__dict__["multikey"] = multikey
            __props__.__dict__["project"] = project
            __props__.__dict__["query_scope"] = query_scope
            __props__.__dict__["unique"] = unique
            __props__.__dict__["name"] = None
        super(Index, __self__).__init__(
            'gcp:firestore/index:Index',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_scope: Optional[pulumi.Input[_builtins.str]] = None,
            collection: Optional[pulumi.Input[_builtins.str]] = None,
            database: Optional[pulumi.Input[_builtins.str]] = None,
            density: Optional[pulumi.Input[_builtins.str]] = None,
            fields: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IndexFieldArgs', 'IndexFieldArgsDict']]]]] = None,
            multikey: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            query_scope: Optional[pulumi.Input[_builtins.str]] = None,
            unique: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Index':
        """
        Get an existing Index resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_scope: The API scope at which a query is run.
               Default value is `ANY_API`.
               Possible values are: `ANY_API`, `DATASTORE_MODE_API`, `MONGODB_COMPATIBLE_API`.
        :param pulumi.Input[_builtins.str] collection: The collection being indexed.
        :param pulumi.Input[_builtins.str] database: The Firestore database id. Defaults to `"(default)"`.
        :param pulumi.Input[_builtins.str] density: The density configuration for this index.
               Possible values are: `SPARSE_ALL`, `SPARSE_ANY`, `DENSE`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IndexFieldArgs', 'IndexFieldArgsDict']]]] fields: The fields supported by this index. The last non-stored field entry is
               always for the field path `__name__`. If, on creation, `__name__` was not
               specified as the last field, it will be added automatically with the same
               direction as that of the last field defined. If the final field in a
               composite index is not directional, the `__name__` will be ordered
               `"ASCENDING"` (unless explicitly specified otherwise).
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] multikey: Optional. Whether the index is multikey. By default, the index is not multikey. For non-multikey indexes, none of the paths in the index definition reach or traverse an array, except via an explicit array index. For multikey indexes, at most one of the paths in the index definition reach or traverse an array, except via an explicit array index. Violations will result in errors. Note this field only applies to indexes with MONGODB_COMPATIBLE_API ApiScope.
        :param pulumi.Input[_builtins.str] name: A server defined name for this index. Format:
               `projects/{{project}}/databases/{{database}}/collectionGroups/{{collection}}/indexes/{{server_generated_id}}`
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] query_scope: The scope at which a query is run.
               Default value is `COLLECTION`.
               Possible values are: `COLLECTION`, `COLLECTION_GROUP`, `COLLECTION_RECURSIVE`.
        :param pulumi.Input[_builtins.bool] unique: Whether it is an unique index. Unique index ensures all values for the indexed field(s) are unique across documents.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IndexState.__new__(_IndexState)

        __props__.__dict__["api_scope"] = api_scope
        __props__.__dict__["collection"] = collection
        __props__.__dict__["database"] = database
        __props__.__dict__["density"] = density
        __props__.__dict__["fields"] = fields
        __props__.__dict__["multikey"] = multikey
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["query_scope"] = query_scope
        __props__.__dict__["unique"] = unique
        return Index(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiScope")
    def api_scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The API scope at which a query is run.
        Default value is `ANY_API`.
        Possible values are: `ANY_API`, `DATASTORE_MODE_API`, `MONGODB_COMPATIBLE_API`.
        """
        return pulumi.get(self, "api_scope")

    @_builtins.property
    @pulumi.getter
    def collection(self) -> pulumi.Output[_builtins.str]:
        """
        The collection being indexed.
        """
        return pulumi.get(self, "collection")

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Firestore database id. Defaults to `"(default)"`.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter
    def density(self) -> pulumi.Output[_builtins.str]:
        """
        The density configuration for this index.
        Possible values are: `SPARSE_ALL`, `SPARSE_ANY`, `DENSE`.
        """
        return pulumi.get(self, "density")

    @_builtins.property
    @pulumi.getter
    def fields(self) -> pulumi.Output[Sequence['outputs.IndexField']]:
        """
        The fields supported by this index. The last non-stored field entry is
        always for the field path `__name__`. If, on creation, `__name__` was not
        specified as the last field, it will be added automatically with the same
        direction as that of the last field defined. If the final field in a
        composite index is not directional, the `__name__` will be ordered
        `"ASCENDING"` (unless explicitly specified otherwise).
        Structure is documented below.
        """
        return pulumi.get(self, "fields")

    @_builtins.property
    @pulumi.getter
    def multikey(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Optional. Whether the index is multikey. By default, the index is not multikey. For non-multikey indexes, none of the paths in the index definition reach or traverse an array, except via an explicit array index. For multikey indexes, at most one of the paths in the index definition reach or traverse an array, except via an explicit array index. Violations will result in errors. Note this field only applies to indexes with MONGODB_COMPATIBLE_API ApiScope.
        """
        return pulumi.get(self, "multikey")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A server defined name for this index. Format:
        `projects/{{project}}/databases/{{database}}/collectionGroups/{{collection}}/indexes/{{server_generated_id}}`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="queryScope")
    def query_scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The scope at which a query is run.
        Default value is `COLLECTION`.
        Possible values are: `COLLECTION`, `COLLECTION_GROUP`, `COLLECTION_RECURSIVE`.
        """
        return pulumi.get(self, "query_scope")

    @_builtins.property
    @pulumi.getter
    def unique(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether it is an unique index. Unique index ensures all values for the indexed field(s) are unique across documents.
        """
        return pulumi.get(self, "unique")

