# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RestorePlanArgs', 'RestorePlan']

@pulumi.input_type
class RestorePlanArgs:
    def __init__(__self__, *,
                 backup_plan: pulumi.Input[_builtins.str],
                 cluster: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 restore_config: pulumi.Input['RestorePlanRestoreConfigArgs'],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RestorePlan resource.
        :param pulumi.Input[_builtins.str] backup_plan: A reference to the BackupPlan from which Backups may be used
               as the source for Restores created via this RestorePlan.
        :param pulumi.Input[_builtins.str] cluster: The source cluster from which Restores will be created via this RestorePlan.
        :param pulumi.Input[_builtins.str] location: The region of the Restore Plan.
        :param pulumi.Input['RestorePlanRestoreConfigArgs'] restore_config: Defines the configuration of Restores created via this RestorePlan.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: User specified descriptive string for this RestorePlan.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Description: A set of custom labels supplied by the user.
               A list of key->value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The full name of the BackupPlan Resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "backup_plan", backup_plan)
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "restore_config", restore_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="backupPlan")
    def backup_plan(self) -> pulumi.Input[_builtins.str]:
        """
        A reference to the BackupPlan from which Backups may be used
        as the source for Restores created via this RestorePlan.
        """
        return pulumi.get(self, "backup_plan")

    @backup_plan.setter
    def backup_plan(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backup_plan", value)

    @_builtins.property
    @pulumi.getter
    def cluster(self) -> pulumi.Input[_builtins.str]:
        """
        The source cluster from which Restores will be created via this RestorePlan.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The region of the Restore Plan.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="restoreConfig")
    def restore_config(self) -> pulumi.Input['RestorePlanRestoreConfigArgs']:
        """
        Defines the configuration of Restores created via this RestorePlan.
        Structure is documented below.
        """
        return pulumi.get(self, "restore_config")

    @restore_config.setter
    def restore_config(self, value: pulumi.Input['RestorePlanRestoreConfigArgs']):
        pulumi.set(self, "restore_config", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User specified descriptive string for this RestorePlan.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Description: A set of custom labels supplied by the user.
        A list of key->value pairs.
        Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full name of the BackupPlan Resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _RestorePlanState:
    def __init__(__self__, *,
                 backup_plan: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 restore_config: Optional[pulumi.Input['RestorePlanRestoreConfigArgs']] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 state_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RestorePlan resources.
        :param pulumi.Input[_builtins.str] backup_plan: A reference to the BackupPlan from which Backups may be used
               as the source for Restores created via this RestorePlan.
        :param pulumi.Input[_builtins.str] cluster: The source cluster from which Restores will be created via this RestorePlan.
        :param pulumi.Input[_builtins.str] description: User specified descriptive string for this RestorePlan.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Description: A set of custom labels supplied by the user.
               A list of key->value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The region of the Restore Plan.
        :param pulumi.Input[_builtins.str] name: The full name of the BackupPlan Resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input['RestorePlanRestoreConfigArgs'] restore_config: Defines the configuration of Restores created via this RestorePlan.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] state: The State of the RestorePlan.
        :param pulumi.Input[_builtins.str] state_reason: Detailed description of why RestorePlan is in its current state.
        :param pulumi.Input[_builtins.str] uid: Server generated, unique identifier of UUID format.
        """
        if backup_plan is not None:
            pulumi.set(__self__, "backup_plan", backup_plan)
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if restore_config is not None:
            pulumi.set(__self__, "restore_config", restore_config)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_reason is not None:
            pulumi.set(__self__, "state_reason", state_reason)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter(name="backupPlan")
    def backup_plan(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A reference to the BackupPlan from which Backups may be used
        as the source for Restores created via this RestorePlan.
        """
        return pulumi.get(self, "backup_plan")

    @backup_plan.setter
    def backup_plan(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_plan", value)

    @_builtins.property
    @pulumi.getter
    def cluster(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source cluster from which Restores will be created via this RestorePlan.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User specified descriptive string for this RestorePlan.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Description: A set of custom labels supplied by the user.
        A list of key->value pairs.
        Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the Restore Plan.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full name of the BackupPlan Resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="restoreConfig")
    def restore_config(self) -> Optional[pulumi.Input['RestorePlanRestoreConfigArgs']]:
        """
        Defines the configuration of Restores created via this RestorePlan.
        Structure is documented below.
        """
        return pulumi.get(self, "restore_config")

    @restore_config.setter
    def restore_config(self, value: Optional[pulumi.Input['RestorePlanRestoreConfigArgs']]):
        pulumi.set(self, "restore_config", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The State of the RestorePlan.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="stateReason")
    def state_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Detailed description of why RestorePlan is in its current state.
        """
        return pulumi.get(self, "state_reason")

    @state_reason.setter
    def state_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state_reason", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Server generated, unique identifier of UUID format.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)


@pulumi.type_token("gcp:gkebackup/restorePlan:RestorePlan")
class RestorePlan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_plan: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_config: Optional[pulumi.Input[Union['RestorePlanRestoreConfigArgs', 'RestorePlanRestoreConfigArgsDict']]] = None,
                 __props__=None):
        """
        Represents a Restore Plan instance.

        To get more information about RestorePlan, see:

        * [API documentation](https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/projects.locations.restorePlans)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke)

        ## Example Usage

        ### Gkebackup Restoreplan All Namespaces

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="restore-all-ns-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        basic = gcp.gkebackup.BackupPlan("basic",
            name="restore-all-ns",
            cluster=primary.id,
            location="us-central1",
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "all_namespaces": True,
            })
        all_ns = gcp.gkebackup.RestorePlan("all_ns",
            name="restore-all-ns",
            location="us-central1",
            backup_plan=basic.id,
            cluster=primary.id,
            restore_config={
                "all_namespaces": True,
                "namespaced_resource_restore_mode": "FAIL_ON_CONFLICT",
                "volume_data_restore_policy": "RESTORE_VOLUME_DATA_FROM_BACKUP",
                "cluster_resource_restore_scope": {
                    "all_group_kinds": True,
                },
                "cluster_resource_conflict_policy": "USE_EXISTING_VERSION",
            })
        ```
        ### Gkebackup Restoreplan Rollback Namespace

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="rollback-ns-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        basic = gcp.gkebackup.BackupPlan("basic",
            name="rollback-ns",
            cluster=primary.id,
            location="us-central1",
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "all_namespaces": True,
            })
        rollback_ns = gcp.gkebackup.RestorePlan("rollback_ns",
            name="rollback-ns-rp",
            location="us-central1",
            backup_plan=basic.id,
            cluster=primary.id,
            restore_config={
                "selected_namespaces": {
                    "namespaces": ["my-ns"],
                },
                "namespaced_resource_restore_mode": "DELETE_AND_RESTORE",
                "volume_data_restore_policy": "RESTORE_VOLUME_DATA_FROM_BACKUP",
                "cluster_resource_restore_scope": {
                    "selected_group_kinds": [
                        {
                            "resource_group": "apiextension.k8s.io",
                            "resource_kind": "CustomResourceDefinition",
                        },
                        {
                            "resource_group": "storage.k8s.io",
                            "resource_kind": "StorageClass",
                        },
                    ],
                },
                "cluster_resource_conflict_policy": "USE_EXISTING_VERSION",
            })
        ```
        ### Gkebackup Restoreplan Protected Application

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="rollback-app-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        basic = gcp.gkebackup.BackupPlan("basic",
            name="rollback-app",
            cluster=primary.id,
            location="us-central1",
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "all_namespaces": True,
            })
        rollback_app = gcp.gkebackup.RestorePlan("rollback_app",
            name="rollback-app-rp",
            location="us-central1",
            backup_plan=basic.id,
            cluster=primary.id,
            restore_config={
                "selected_applications": {
                    "namespaced_names": [{
                        "name": "my-app",
                        "namespace": "my-ns",
                    }],
                },
                "namespaced_resource_restore_mode": "DELETE_AND_RESTORE",
                "volume_data_restore_policy": "REUSE_VOLUME_HANDLE_FROM_BACKUP",
                "cluster_resource_restore_scope": {
                    "no_group_kinds": True,
                },
            })
        ```
        ### Gkebackup Restoreplan All Cluster Resources

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="all-groupkinds-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        basic = gcp.gkebackup.BackupPlan("basic",
            name="all-groupkinds",
            cluster=primary.id,
            location="us-central1",
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "all_namespaces": True,
            })
        all_cluster_resources = gcp.gkebackup.RestorePlan("all_cluster_resources",
            name="all-groupkinds-rp",
            location="us-central1",
            backup_plan=basic.id,
            cluster=primary.id,
            restore_config={
                "no_namespaces": True,
                "namespaced_resource_restore_mode": "FAIL_ON_CONFLICT",
                "cluster_resource_restore_scope": {
                    "all_group_kinds": True,
                },
                "cluster_resource_conflict_policy": "USE_EXISTING_VERSION",
            })
        ```
        ### Gkebackup Restoreplan Rename Namespace

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="rename-ns-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        basic = gcp.gkebackup.BackupPlan("basic",
            name="rename-ns",
            cluster=primary.id,
            location="us-central1",
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "all_namespaces": True,
            })
        rename_ns = gcp.gkebackup.RestorePlan("rename_ns",
            name="rename-ns-rp",
            location="us-central1",
            backup_plan=basic.id,
            cluster=primary.id,
            restore_config={
                "selected_namespaces": {
                    "namespaces": ["ns1"],
                },
                "namespaced_resource_restore_mode": "FAIL_ON_CONFLICT",
                "volume_data_restore_policy": "REUSE_VOLUME_HANDLE_FROM_BACKUP",
                "cluster_resource_restore_scope": {
                    "no_group_kinds": True,
                },
                "transformation_rules": [
                    {
                        "description": "rename namespace from ns1 to ns2",
                        "resource_filter": {
                            "group_kinds": [{
                                "resource_kind": "Namespace",
                            }],
                            "json_path": ".metadata[?(@.name == 'ns1')]",
                        },
                        "field_actions": [{
                            "op": "REPLACE",
                            "path": "/metadata/name",
                            "value": "ns2",
                        }],
                    },
                    {
                        "description": "move all resources from ns1 to ns2",
                        "resource_filter": {
                            "namespaces": ["ns1"],
                        },
                        "field_actions": [{
                            "op": "REPLACE",
                            "path": "/metadata/namespace",
                            "value": "ns2",
                        }],
                    },
                ],
            })
        ```
        ### Gkebackup Restoreplan Second Transformation

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="transform-rule-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        basic = gcp.gkebackup.BackupPlan("basic",
            name="transform-rule",
            cluster=primary.id,
            location="us-central1",
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "all_namespaces": True,
            })
        transform_rule = gcp.gkebackup.RestorePlan("transform_rule",
            name="transform-rule-rp",
            description="copy nginx env variables",
            labels={
                "app": "nginx",
            },
            location="us-central1",
            backup_plan=basic.id,
            cluster=primary.id,
            restore_config={
                "excluded_namespaces": {
                    "namespaces": ["my-ns"],
                },
                "namespaced_resource_restore_mode": "DELETE_AND_RESTORE",
                "volume_data_restore_policy": "RESTORE_VOLUME_DATA_FROM_BACKUP",
                "cluster_resource_restore_scope": {
                    "excluded_group_kinds": [{
                        "resource_group": "apiextension.k8s.io",
                        "resource_kind": "CustomResourceDefinition",
                    }],
                },
                "cluster_resource_conflict_policy": "USE_EXISTING_VERSION",
                "transformation_rules": [{
                    "description": "Copy environment variables from the nginx container to the install init container.",
                    "resource_filter": {
                        "group_kinds": [{
                            "resource_kind": "Pod",
                            "resource_group": "",
                        }],
                        "json_path": ".metadata[?(@.name == 'nginx')]",
                    },
                    "field_actions": [{
                        "op": "COPY",
                        "path": "/spec/initContainers/0/env",
                        "from_path": "/spec/containers/0/env",
                    }],
                }],
            })
        ```
        ### Gkebackup Restoreplan Gitops Mode

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="gitops-mode-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        basic = gcp.gkebackup.BackupPlan("basic",
            name="gitops-mode",
            cluster=primary.id,
            location="us-central1",
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "all_namespaces": True,
            })
        gitops_mode = gcp.gkebackup.RestorePlan("gitops_mode",
            name="gitops-mode",
            location="us-central1",
            backup_plan=basic.id,
            cluster=primary.id,
            restore_config={
                "all_namespaces": True,
                "namespaced_resource_restore_mode": "MERGE_SKIP_ON_CONFLICT",
                "volume_data_restore_policy": "RESTORE_VOLUME_DATA_FROM_BACKUP",
                "cluster_resource_restore_scope": {
                    "all_group_kinds": True,
                },
                "cluster_resource_conflict_policy": "USE_EXISTING_VERSION",
            })
        ```
        ### Gkebackup Restoreplan Restore Order

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="restore-order-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        basic = gcp.gkebackup.BackupPlan("basic",
            name="restore-order",
            cluster=primary.id,
            location="us-central1",
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "all_namespaces": True,
            })
        restore_order = gcp.gkebackup.RestorePlan("restore_order",
            name="restore-order",
            location="us-central1",
            backup_plan=basic.id,
            cluster=primary.id,
            restore_config={
                "all_namespaces": True,
                "namespaced_resource_restore_mode": "FAIL_ON_CONFLICT",
                "volume_data_restore_policy": "RESTORE_VOLUME_DATA_FROM_BACKUP",
                "cluster_resource_restore_scope": {
                    "all_group_kinds": True,
                },
                "cluster_resource_conflict_policy": "USE_EXISTING_VERSION",
                "restore_order": {
                    "group_kind_dependencies": [
                        {
                            "satisfying": {
                                "resource_group": "stable.example.com",
                                "resource_kind": "kindA",
                            },
                            "requiring": {
                                "resource_group": "stable.example.com",
                                "resource_kind": "kindB",
                            },
                        },
                        {
                            "satisfying": {
                                "resource_group": "stable.example.com",
                                "resource_kind": "kindB",
                            },
                            "requiring": {
                                "resource_group": "stable.example.com",
                                "resource_kind": "kindC",
                            },
                        },
                    ],
                },
            })
        ```
        ### Gkebackup Restoreplan Volume Res

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="volume-res-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        basic = gcp.gkebackup.BackupPlan("basic",
            name="volume-res",
            cluster=primary.id,
            location="us-central1",
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "all_namespaces": True,
            })
        volume_res = gcp.gkebackup.RestorePlan("volume_res",
            name="volume-res",
            location="us-central1",
            backup_plan=basic.id,
            cluster=primary.id,
            restore_config={
                "all_namespaces": True,
                "namespaced_resource_restore_mode": "FAIL_ON_CONFLICT",
                "volume_data_restore_policy": "NO_VOLUME_DATA_RESTORATION",
                "cluster_resource_restore_scope": {
                    "all_group_kinds": True,
                },
                "cluster_resource_conflict_policy": "USE_EXISTING_VERSION",
                "volume_data_restore_policy_bindings": [{
                    "policy": "RESTORE_VOLUME_DATA_FROM_BACKUP",
                    "volume_type": "GCE_PERSISTENT_DISK",
                }],
            })
        ```

        ## Import

        RestorePlan can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/restorePlans/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, RestorePlan can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:gkebackup/restorePlan:RestorePlan default projects/{{project}}/locations/{{location}}/restorePlans/{{name}}
        ```

        ```sh
        $ pulumi import gcp:gkebackup/restorePlan:RestorePlan default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:gkebackup/restorePlan:RestorePlan default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_plan: A reference to the BackupPlan from which Backups may be used
               as the source for Restores created via this RestorePlan.
        :param pulumi.Input[_builtins.str] cluster: The source cluster from which Restores will be created via this RestorePlan.
        :param pulumi.Input[_builtins.str] description: User specified descriptive string for this RestorePlan.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Description: A set of custom labels supplied by the user.
               A list of key->value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The region of the Restore Plan.
        :param pulumi.Input[_builtins.str] name: The full name of the BackupPlan Resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['RestorePlanRestoreConfigArgs', 'RestorePlanRestoreConfigArgsDict']] restore_config: Defines the configuration of Restores created via this RestorePlan.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RestorePlanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a Restore Plan instance.

        To get more information about RestorePlan, see:

        * [API documentation](https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/projects.locations.restorePlans)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke)

        ## Example Usage

        ### Gkebackup Restoreplan All Namespaces

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="restore-all-ns-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        basic = gcp.gkebackup.BackupPlan("basic",
            name="restore-all-ns",
            cluster=primary.id,
            location="us-central1",
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "all_namespaces": True,
            })
        all_ns = gcp.gkebackup.RestorePlan("all_ns",
            name="restore-all-ns",
            location="us-central1",
            backup_plan=basic.id,
            cluster=primary.id,
            restore_config={
                "all_namespaces": True,
                "namespaced_resource_restore_mode": "FAIL_ON_CONFLICT",
                "volume_data_restore_policy": "RESTORE_VOLUME_DATA_FROM_BACKUP",
                "cluster_resource_restore_scope": {
                    "all_group_kinds": True,
                },
                "cluster_resource_conflict_policy": "USE_EXISTING_VERSION",
            })
        ```
        ### Gkebackup Restoreplan Rollback Namespace

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="rollback-ns-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        basic = gcp.gkebackup.BackupPlan("basic",
            name="rollback-ns",
            cluster=primary.id,
            location="us-central1",
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "all_namespaces": True,
            })
        rollback_ns = gcp.gkebackup.RestorePlan("rollback_ns",
            name="rollback-ns-rp",
            location="us-central1",
            backup_plan=basic.id,
            cluster=primary.id,
            restore_config={
                "selected_namespaces": {
                    "namespaces": ["my-ns"],
                },
                "namespaced_resource_restore_mode": "DELETE_AND_RESTORE",
                "volume_data_restore_policy": "RESTORE_VOLUME_DATA_FROM_BACKUP",
                "cluster_resource_restore_scope": {
                    "selected_group_kinds": [
                        {
                            "resource_group": "apiextension.k8s.io",
                            "resource_kind": "CustomResourceDefinition",
                        },
                        {
                            "resource_group": "storage.k8s.io",
                            "resource_kind": "StorageClass",
                        },
                    ],
                },
                "cluster_resource_conflict_policy": "USE_EXISTING_VERSION",
            })
        ```
        ### Gkebackup Restoreplan Protected Application

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="rollback-app-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        basic = gcp.gkebackup.BackupPlan("basic",
            name="rollback-app",
            cluster=primary.id,
            location="us-central1",
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "all_namespaces": True,
            })
        rollback_app = gcp.gkebackup.RestorePlan("rollback_app",
            name="rollback-app-rp",
            location="us-central1",
            backup_plan=basic.id,
            cluster=primary.id,
            restore_config={
                "selected_applications": {
                    "namespaced_names": [{
                        "name": "my-app",
                        "namespace": "my-ns",
                    }],
                },
                "namespaced_resource_restore_mode": "DELETE_AND_RESTORE",
                "volume_data_restore_policy": "REUSE_VOLUME_HANDLE_FROM_BACKUP",
                "cluster_resource_restore_scope": {
                    "no_group_kinds": True,
                },
            })
        ```
        ### Gkebackup Restoreplan All Cluster Resources

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="all-groupkinds-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        basic = gcp.gkebackup.BackupPlan("basic",
            name="all-groupkinds",
            cluster=primary.id,
            location="us-central1",
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "all_namespaces": True,
            })
        all_cluster_resources = gcp.gkebackup.RestorePlan("all_cluster_resources",
            name="all-groupkinds-rp",
            location="us-central1",
            backup_plan=basic.id,
            cluster=primary.id,
            restore_config={
                "no_namespaces": True,
                "namespaced_resource_restore_mode": "FAIL_ON_CONFLICT",
                "cluster_resource_restore_scope": {
                    "all_group_kinds": True,
                },
                "cluster_resource_conflict_policy": "USE_EXISTING_VERSION",
            })
        ```
        ### Gkebackup Restoreplan Rename Namespace

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="rename-ns-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        basic = gcp.gkebackup.BackupPlan("basic",
            name="rename-ns",
            cluster=primary.id,
            location="us-central1",
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "all_namespaces": True,
            })
        rename_ns = gcp.gkebackup.RestorePlan("rename_ns",
            name="rename-ns-rp",
            location="us-central1",
            backup_plan=basic.id,
            cluster=primary.id,
            restore_config={
                "selected_namespaces": {
                    "namespaces": ["ns1"],
                },
                "namespaced_resource_restore_mode": "FAIL_ON_CONFLICT",
                "volume_data_restore_policy": "REUSE_VOLUME_HANDLE_FROM_BACKUP",
                "cluster_resource_restore_scope": {
                    "no_group_kinds": True,
                },
                "transformation_rules": [
                    {
                        "description": "rename namespace from ns1 to ns2",
                        "resource_filter": {
                            "group_kinds": [{
                                "resource_kind": "Namespace",
                            }],
                            "json_path": ".metadata[?(@.name == 'ns1')]",
                        },
                        "field_actions": [{
                            "op": "REPLACE",
                            "path": "/metadata/name",
                            "value": "ns2",
                        }],
                    },
                    {
                        "description": "move all resources from ns1 to ns2",
                        "resource_filter": {
                            "namespaces": ["ns1"],
                        },
                        "field_actions": [{
                            "op": "REPLACE",
                            "path": "/metadata/namespace",
                            "value": "ns2",
                        }],
                    },
                ],
            })
        ```
        ### Gkebackup Restoreplan Second Transformation

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="transform-rule-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        basic = gcp.gkebackup.BackupPlan("basic",
            name="transform-rule",
            cluster=primary.id,
            location="us-central1",
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "all_namespaces": True,
            })
        transform_rule = gcp.gkebackup.RestorePlan("transform_rule",
            name="transform-rule-rp",
            description="copy nginx env variables",
            labels={
                "app": "nginx",
            },
            location="us-central1",
            backup_plan=basic.id,
            cluster=primary.id,
            restore_config={
                "excluded_namespaces": {
                    "namespaces": ["my-ns"],
                },
                "namespaced_resource_restore_mode": "DELETE_AND_RESTORE",
                "volume_data_restore_policy": "RESTORE_VOLUME_DATA_FROM_BACKUP",
                "cluster_resource_restore_scope": {
                    "excluded_group_kinds": [{
                        "resource_group": "apiextension.k8s.io",
                        "resource_kind": "CustomResourceDefinition",
                    }],
                },
                "cluster_resource_conflict_policy": "USE_EXISTING_VERSION",
                "transformation_rules": [{
                    "description": "Copy environment variables from the nginx container to the install init container.",
                    "resource_filter": {
                        "group_kinds": [{
                            "resource_kind": "Pod",
                            "resource_group": "",
                        }],
                        "json_path": ".metadata[?(@.name == 'nginx')]",
                    },
                    "field_actions": [{
                        "op": "COPY",
                        "path": "/spec/initContainers/0/env",
                        "from_path": "/spec/containers/0/env",
                    }],
                }],
            })
        ```
        ### Gkebackup Restoreplan Gitops Mode

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="gitops-mode-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        basic = gcp.gkebackup.BackupPlan("basic",
            name="gitops-mode",
            cluster=primary.id,
            location="us-central1",
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "all_namespaces": True,
            })
        gitops_mode = gcp.gkebackup.RestorePlan("gitops_mode",
            name="gitops-mode",
            location="us-central1",
            backup_plan=basic.id,
            cluster=primary.id,
            restore_config={
                "all_namespaces": True,
                "namespaced_resource_restore_mode": "MERGE_SKIP_ON_CONFLICT",
                "volume_data_restore_policy": "RESTORE_VOLUME_DATA_FROM_BACKUP",
                "cluster_resource_restore_scope": {
                    "all_group_kinds": True,
                },
                "cluster_resource_conflict_policy": "USE_EXISTING_VERSION",
            })
        ```
        ### Gkebackup Restoreplan Restore Order

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="restore-order-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        basic = gcp.gkebackup.BackupPlan("basic",
            name="restore-order",
            cluster=primary.id,
            location="us-central1",
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "all_namespaces": True,
            })
        restore_order = gcp.gkebackup.RestorePlan("restore_order",
            name="restore-order",
            location="us-central1",
            backup_plan=basic.id,
            cluster=primary.id,
            restore_config={
                "all_namespaces": True,
                "namespaced_resource_restore_mode": "FAIL_ON_CONFLICT",
                "volume_data_restore_policy": "RESTORE_VOLUME_DATA_FROM_BACKUP",
                "cluster_resource_restore_scope": {
                    "all_group_kinds": True,
                },
                "cluster_resource_conflict_policy": "USE_EXISTING_VERSION",
                "restore_order": {
                    "group_kind_dependencies": [
                        {
                            "satisfying": {
                                "resource_group": "stable.example.com",
                                "resource_kind": "kindA",
                            },
                            "requiring": {
                                "resource_group": "stable.example.com",
                                "resource_kind": "kindB",
                            },
                        },
                        {
                            "satisfying": {
                                "resource_group": "stable.example.com",
                                "resource_kind": "kindB",
                            },
                            "requiring": {
                                "resource_group": "stable.example.com",
                                "resource_kind": "kindC",
                            },
                        },
                    ],
                },
            })
        ```
        ### Gkebackup Restoreplan Volume Res

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="volume-res-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        basic = gcp.gkebackup.BackupPlan("basic",
            name="volume-res",
            cluster=primary.id,
            location="us-central1",
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "all_namespaces": True,
            })
        volume_res = gcp.gkebackup.RestorePlan("volume_res",
            name="volume-res",
            location="us-central1",
            backup_plan=basic.id,
            cluster=primary.id,
            restore_config={
                "all_namespaces": True,
                "namespaced_resource_restore_mode": "FAIL_ON_CONFLICT",
                "volume_data_restore_policy": "NO_VOLUME_DATA_RESTORATION",
                "cluster_resource_restore_scope": {
                    "all_group_kinds": True,
                },
                "cluster_resource_conflict_policy": "USE_EXISTING_VERSION",
                "volume_data_restore_policy_bindings": [{
                    "policy": "RESTORE_VOLUME_DATA_FROM_BACKUP",
                    "volume_type": "GCE_PERSISTENT_DISK",
                }],
            })
        ```

        ## Import

        RestorePlan can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/restorePlans/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, RestorePlan can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:gkebackup/restorePlan:RestorePlan default projects/{{project}}/locations/{{location}}/restorePlans/{{name}}
        ```

        ```sh
        $ pulumi import gcp:gkebackup/restorePlan:RestorePlan default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:gkebackup/restorePlan:RestorePlan default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param RestorePlanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RestorePlanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_plan: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_config: Optional[pulumi.Input[Union['RestorePlanRestoreConfigArgs', 'RestorePlanRestoreConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RestorePlanArgs.__new__(RestorePlanArgs)

            if backup_plan is None and not opts.urn:
                raise TypeError("Missing required property 'backup_plan'")
            __props__.__dict__["backup_plan"] = backup_plan
            if cluster is None and not opts.urn:
                raise TypeError("Missing required property 'cluster'")
            __props__.__dict__["cluster"] = cluster
            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if restore_config is None and not opts.urn:
                raise TypeError("Missing required property 'restore_config'")
            __props__.__dict__["restore_config"] = restore_config
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_reason"] = None
            __props__.__dict__["uid"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(RestorePlan, __self__).__init__(
            'gcp:gkebackup/restorePlan:RestorePlan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_plan: Optional[pulumi.Input[_builtins.str]] = None,
            cluster: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            restore_config: Optional[pulumi.Input[Union['RestorePlanRestoreConfigArgs', 'RestorePlanRestoreConfigArgsDict']]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            state_reason: Optional[pulumi.Input[_builtins.str]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None) -> 'RestorePlan':
        """
        Get an existing RestorePlan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_plan: A reference to the BackupPlan from which Backups may be used
               as the source for Restores created via this RestorePlan.
        :param pulumi.Input[_builtins.str] cluster: The source cluster from which Restores will be created via this RestorePlan.
        :param pulumi.Input[_builtins.str] description: User specified descriptive string for this RestorePlan.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Description: A set of custom labels supplied by the user.
               A list of key->value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The region of the Restore Plan.
        :param pulumi.Input[_builtins.str] name: The full name of the BackupPlan Resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Union['RestorePlanRestoreConfigArgs', 'RestorePlanRestoreConfigArgsDict']] restore_config: Defines the configuration of Restores created via this RestorePlan.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] state: The State of the RestorePlan.
        :param pulumi.Input[_builtins.str] state_reason: Detailed description of why RestorePlan is in its current state.
        :param pulumi.Input[_builtins.str] uid: Server generated, unique identifier of UUID format.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RestorePlanState.__new__(_RestorePlanState)

        __props__.__dict__["backup_plan"] = backup_plan
        __props__.__dict__["cluster"] = cluster
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["restore_config"] = restore_config
        __props__.__dict__["state"] = state
        __props__.__dict__["state_reason"] = state_reason
        __props__.__dict__["uid"] = uid
        return RestorePlan(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupPlan")
    def backup_plan(self) -> pulumi.Output[_builtins.str]:
        """
        A reference to the BackupPlan from which Backups may be used
        as the source for Restores created via this RestorePlan.
        """
        return pulumi.get(self, "backup_plan")

    @_builtins.property
    @pulumi.getter
    def cluster(self) -> pulumi.Output[_builtins.str]:
        """
        The source cluster from which Restores will be created via this RestorePlan.
        """
        return pulumi.get(self, "cluster")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User specified descriptive string for this RestorePlan.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Description: A set of custom labels supplied by the user.
        A list of key->value pairs.
        Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The region of the Restore Plan.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The full name of the BackupPlan Resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="restoreConfig")
    def restore_config(self) -> pulumi.Output['outputs.RestorePlanRestoreConfig']:
        """
        Defines the configuration of Restores created via this RestorePlan.
        Structure is documented below.
        """
        return pulumi.get(self, "restore_config")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The State of the RestorePlan.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="stateReason")
    def state_reason(self) -> pulumi.Output[_builtins.str]:
        """
        Detailed description of why RestorePlan is in its current state.
        """
        return pulumi.get(self, "state_reason")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        Server generated, unique identifier of UUID format.
        """
        return pulumi.get(self, "uid")

