# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WebForwardingRuleServiceIamPolicyArgs', 'WebForwardingRuleServiceIamPolicy']

@pulumi.input_type
class WebForwardingRuleServiceIamPolicyArgs:
    def __init__(__self__, *,
                 forwarding_rule_service_name: pulumi.Input[_builtins.str],
                 policy_data: pulumi.Input[_builtins.str],
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WebForwardingRuleServiceIamPolicy resource.
        :param pulumi.Input[_builtins.str] forwarding_rule_service_name: Used to find the parent resource to bind the IAM policy to
        :param pulumi.Input[_builtins.str] policy_data: The policy data generated by
               a `organizations_get_iam_policy` data source.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
        """
        pulumi.set(__self__, "forwarding_rule_service_name", forwarding_rule_service_name)
        pulumi.set(__self__, "policy_data", policy_data)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="forwardingRuleServiceName")
    def forwarding_rule_service_name(self) -> pulumi.Input[_builtins.str]:
        """
        Used to find the parent resource to bind the IAM policy to
        """
        return pulumi.get(self, "forwarding_rule_service_name")

    @forwarding_rule_service_name.setter
    def forwarding_rule_service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "forwarding_rule_service_name", value)

    @_builtins.property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> pulumi.Input[_builtins.str]:
        """
        The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @policy_data.setter
    def policy_data(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_data", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _WebForwardingRuleServiceIamPolicyState:
    def __init__(__self__, *,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 forwarding_rule_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_data: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WebForwardingRuleServiceIamPolicy resources.
        :param pulumi.Input[_builtins.str] etag: (Computed) The etag of the IAM policy.
        :param pulumi.Input[_builtins.str] forwarding_rule_service_name: Used to find the parent resource to bind the IAM policy to
        :param pulumi.Input[_builtins.str] policy_data: The policy data generated by
               a `organizations_get_iam_policy` data source.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
        """
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if forwarding_rule_service_name is not None:
            pulumi.set(__self__, "forwarding_rule_service_name", forwarding_rule_service_name)
        if policy_data is not None:
            pulumi.set(__self__, "policy_data", policy_data)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter(name="forwardingRuleServiceName")
    def forwarding_rule_service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Used to find the parent resource to bind the IAM policy to
        """
        return pulumi.get(self, "forwarding_rule_service_name")

    @forwarding_rule_service_name.setter
    def forwarding_rule_service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "forwarding_rule_service_name", value)

    @_builtins.property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @policy_data.setter
    def policy_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_data", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.type_token("gcp:iap/webForwardingRuleServiceIamPolicy:WebForwardingRuleServiceIamPolicy")
class WebForwardingRuleServiceIamPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 forwarding_rule_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_data: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Three different resources help you manage your IAM policy for Identity-Aware Proxy WebForwardingRuleService. Each of these resources serves a different use case:

        * `iap.WebForwardingRuleServiceIamPolicy`: Authoritative. Sets the IAM policy for the webforwardingruleservice and replaces any existing policy already attached.
        * `iap.WebForwardingRuleServiceIamBinding`: Authoritative for a given role. Updates the IAM policy to grant a role to a list of members. Other roles within the IAM policy for the webforwardingruleservice are preserved.
        * `iap.WebForwardingRuleServiceIamMember`: Non-authoritative. Updates the IAM policy to grant a role to a new member. Other members for the role for the webforwardingruleservice are preserved.

        A data source can be used to retrieve policy data in advent you do not need creation

        * `iap.WebForwardingRuleServiceIamPolicy`: Retrieves the IAM policy for the webforwardingruleservice

        > **Note:** `iap.WebForwardingRuleServiceIamPolicy` **cannot** be used in conjunction with `iap.WebForwardingRuleServiceIamBinding` and `iap.WebForwardingRuleServiceIamMember` or they will fight over what your policy should be.

        > **Note:** `iap.WebForwardingRuleServiceIamBinding` resources **can be** used in conjunction with `iap.WebForwardingRuleServiceIamMember` resources **only if** they do not grant privilege to the same role.

        > **Note:**  This resource supports IAM Conditions but they have some known limitations which can be found [here](https://cloud.google.com/iam/docs/conditions-overview#limitations). Please review this article if you are having issues with IAM Conditions.

        ## iap.WebForwardingRuleServiceIamPolicy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/iap.httpsResourceAccessor",
            "members": ["user:jane@example.com"],
        }])
        policy = gcp.iap.WebForwardingRuleServiceIamPolicy("policy",
            project=default["project"],
            forwarding_rule_service_name=default["name"],
            policy_data=admin.policy_data)
        ```

        With IAM Conditions:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/iap.httpsResourceAccessor",
            "members": ["user:jane@example.com"],
            "condition": {
                "title": "expires_after_2019_12_31",
                "description": "Expiring at midnight of 2019-12-31",
                "expression": "request.time < timestamp(\\"2020-01-01T00:00:00Z\\")",
            },
        }])
        policy = gcp.iap.WebForwardingRuleServiceIamPolicy("policy",
            project=default["project"],
            forwarding_rule_service_name=default["name"],
            policy_data=admin.policy_data)
        ```
        ## iap.WebForwardingRuleServiceIamBinding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        binding = gcp.iap.WebForwardingRuleServiceIamBinding("binding",
            project=default["project"],
            forwarding_rule_service_name=default["name"],
            role="roles/iap.httpsResourceAccessor",
            members=["user:jane@example.com"])
        ```

        With IAM Conditions:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        binding = gcp.iap.WebForwardingRuleServiceIamBinding("binding",
            project=default["project"],
            forwarding_rule_service_name=default["name"],
            role="roles/iap.httpsResourceAccessor",
            members=["user:jane@example.com"],
            condition={
                "title": "expires_after_2019_12_31",
                "description": "Expiring at midnight of 2019-12-31",
                "expression": "request.time < timestamp(\\"2020-01-01T00:00:00Z\\")",
            })
        ```
        ## iap.WebForwardingRuleServiceIamMember

        ```python
        import pulumi
        import pulumi_gcp as gcp

        member = gcp.iap.WebForwardingRuleServiceIamMember("member",
            project=default["project"],
            forwarding_rule_service_name=default["name"],
            role="roles/iap.httpsResourceAccessor",
            member="user:jane@example.com")
        ```

        With IAM Conditions:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        member = gcp.iap.WebForwardingRuleServiceIamMember("member",
            project=default["project"],
            forwarding_rule_service_name=default["name"],
            role="roles/iap.httpsResourceAccessor",
            member="user:jane@example.com",
            condition={
                "title": "expires_after_2019_12_31",
                "description": "Expiring at midnight of 2019-12-31",
                "expression": "request.time < timestamp(\\"2020-01-01T00:00:00Z\\")",
            })
        ```

        ## This resource supports User Project Overrides.

        - 

        # IAM policy for Identity-Aware Proxy WebForwardingRuleService

        Three different resources help you manage your IAM policy for Identity-Aware Proxy WebForwardingRuleService. Each of these resources serves a different use case:

        * `iap.WebForwardingRuleServiceIamPolicy`: Authoritative. Sets the IAM policy for the webforwardingruleservice and replaces any existing policy already attached.
        * `iap.WebForwardingRuleServiceIamBinding`: Authoritative for a given role. Updates the IAM policy to grant a role to a list of members. Other roles within the IAM policy for the webforwardingruleservice are preserved.
        * `iap.WebForwardingRuleServiceIamMember`: Non-authoritative. Updates the IAM policy to grant a role to a new member. Other members for the role for the webforwardingruleservice are preserved.

        A data source can be used to retrieve policy data in advent you do not need creation

        * `iap.WebForwardingRuleServiceIamPolicy`: Retrieves the IAM policy for the webforwardingruleservice

        > **Note:** `iap.WebForwardingRuleServiceIamPolicy` **cannot** be used in conjunction with `iap.WebForwardingRuleServiceIamBinding` and `iap.WebForwardingRuleServiceIamMember` or they will fight over what your policy should be.

        > **Note:** `iap.WebForwardingRuleServiceIamBinding` resources **can be** used in conjunction with `iap.WebForwardingRuleServiceIamMember` resources **only if** they do not grant privilege to the same role.

        > **Note:**  This resource supports IAM Conditions but they have some known limitations which can be found [here](https://cloud.google.com/iam/docs/conditions-overview#limitations). Please review this article if you are having issues with IAM Conditions.

        ## iap.WebForwardingRuleServiceIamPolicy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/iap.httpsResourceAccessor",
            "members": ["user:jane@example.com"],
        }])
        policy = gcp.iap.WebForwardingRuleServiceIamPolicy("policy",
            project=default["project"],
            forwarding_rule_service_name=default["name"],
            policy_data=admin.policy_data)
        ```

        With IAM Conditions:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/iap.httpsResourceAccessor",
            "members": ["user:jane@example.com"],
            "condition": {
                "title": "expires_after_2019_12_31",
                "description": "Expiring at midnight of 2019-12-31",
                "expression": "request.time < timestamp(\\"2020-01-01T00:00:00Z\\")",
            },
        }])
        policy = gcp.iap.WebForwardingRuleServiceIamPolicy("policy",
            project=default["project"],
            forwarding_rule_service_name=default["name"],
            policy_data=admin.policy_data)
        ```
        ## iap.WebForwardingRuleServiceIamBinding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        binding = gcp.iap.WebForwardingRuleServiceIamBinding("binding",
            project=default["project"],
            forwarding_rule_service_name=default["name"],
            role="roles/iap.httpsResourceAccessor",
            members=["user:jane@example.com"])
        ```

        With IAM Conditions:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        binding = gcp.iap.WebForwardingRuleServiceIamBinding("binding",
            project=default["project"],
            forwarding_rule_service_name=default["name"],
            role="roles/iap.httpsResourceAccessor",
            members=["user:jane@example.com"],
            condition={
                "title": "expires_after_2019_12_31",
                "description": "Expiring at midnight of 2019-12-31",
                "expression": "request.time < timestamp(\\"2020-01-01T00:00:00Z\\")",
            })
        ```
        ## iap.WebForwardingRuleServiceIamMember

        ```python
        import pulumi
        import pulumi_gcp as gcp

        member = gcp.iap.WebForwardingRuleServiceIamMember("member",
            project=default["project"],
            forwarding_rule_service_name=default["name"],
            role="roles/iap.httpsResourceAccessor",
            member="user:jane@example.com")
        ```

        With IAM Conditions:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        member = gcp.iap.WebForwardingRuleServiceIamMember("member",
            project=default["project"],
            forwarding_rule_service_name=default["name"],
            role="roles/iap.httpsResourceAccessor",
            member="user:jane@example.com",
            condition={
                "title": "expires_after_2019_12_31",
                "description": "Expiring at midnight of 2019-12-31",
                "expression": "request.time < timestamp(\\"2020-01-01T00:00:00Z\\")",
            })
        ```

        ## Import

        For all import syntaxes, the "resource in question" can take any of the following forms:

        * projects/{{project}}/iap_web/forwarding_rule/services/{{name}}

        * {{project}}/{{name}}

        * {{name}}

        Any variables not passed in the import command will be taken from the provider configuration.

        Identity-Aware Proxy webforwardingruleservice IAM resources can be imported using the resource identifiers, role, and member.

        IAM member imports use space-delimited identifiers: the resource in question, the role, and the member identity, e.g.

        ```sh
        $ pulumi import gcp:iap/webForwardingRuleServiceIamPolicy:WebForwardingRuleServiceIamPolicy editor "projects/{{project}}/iap_web/forwarding_rule/services/{{web_forwarding_rule_service}} roles/iap.httpsResourceAccessor user:jane@example.com"
        ```

        IAM binding imports use space-delimited identifiers: the resource in question and the role, e.g.

        ```sh
        $ pulumi import gcp:iap/webForwardingRuleServiceIamPolicy:WebForwardingRuleServiceIamPolicy editor "projects/{{project}}/iap_web/forwarding_rule/services/{{web_forwarding_rule_service}} roles/iap.httpsResourceAccessor"
        ```

        IAM policy imports use the identifier of the resource in question, e.g.

        ```sh
        $ pulumi import gcp:iap/webForwardingRuleServiceIamPolicy:WebForwardingRuleServiceIamPolicy editor projects/{{project}}/iap_web/forwarding_rule/services/{{web_forwarding_rule_service}}
        ```

        -> **Custom Roles** If you're importing a IAM resource with a custom role, make sure to use the

         full name of the custom role, e.g. `[projects/my-project|organizations/my-org]/roles/my-custom-role`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] forwarding_rule_service_name: Used to find the parent resource to bind the IAM policy to
        :param pulumi.Input[_builtins.str] policy_data: The policy data generated by
               a `organizations_get_iam_policy` data source.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WebForwardingRuleServiceIamPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Three different resources help you manage your IAM policy for Identity-Aware Proxy WebForwardingRuleService. Each of these resources serves a different use case:

        * `iap.WebForwardingRuleServiceIamPolicy`: Authoritative. Sets the IAM policy for the webforwardingruleservice and replaces any existing policy already attached.
        * `iap.WebForwardingRuleServiceIamBinding`: Authoritative for a given role. Updates the IAM policy to grant a role to a list of members. Other roles within the IAM policy for the webforwardingruleservice are preserved.
        * `iap.WebForwardingRuleServiceIamMember`: Non-authoritative. Updates the IAM policy to grant a role to a new member. Other members for the role for the webforwardingruleservice are preserved.

        A data source can be used to retrieve policy data in advent you do not need creation

        * `iap.WebForwardingRuleServiceIamPolicy`: Retrieves the IAM policy for the webforwardingruleservice

        > **Note:** `iap.WebForwardingRuleServiceIamPolicy` **cannot** be used in conjunction with `iap.WebForwardingRuleServiceIamBinding` and `iap.WebForwardingRuleServiceIamMember` or they will fight over what your policy should be.

        > **Note:** `iap.WebForwardingRuleServiceIamBinding` resources **can be** used in conjunction with `iap.WebForwardingRuleServiceIamMember` resources **only if** they do not grant privilege to the same role.

        > **Note:**  This resource supports IAM Conditions but they have some known limitations which can be found [here](https://cloud.google.com/iam/docs/conditions-overview#limitations). Please review this article if you are having issues with IAM Conditions.

        ## iap.WebForwardingRuleServiceIamPolicy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/iap.httpsResourceAccessor",
            "members": ["user:jane@example.com"],
        }])
        policy = gcp.iap.WebForwardingRuleServiceIamPolicy("policy",
            project=default["project"],
            forwarding_rule_service_name=default["name"],
            policy_data=admin.policy_data)
        ```

        With IAM Conditions:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/iap.httpsResourceAccessor",
            "members": ["user:jane@example.com"],
            "condition": {
                "title": "expires_after_2019_12_31",
                "description": "Expiring at midnight of 2019-12-31",
                "expression": "request.time < timestamp(\\"2020-01-01T00:00:00Z\\")",
            },
        }])
        policy = gcp.iap.WebForwardingRuleServiceIamPolicy("policy",
            project=default["project"],
            forwarding_rule_service_name=default["name"],
            policy_data=admin.policy_data)
        ```
        ## iap.WebForwardingRuleServiceIamBinding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        binding = gcp.iap.WebForwardingRuleServiceIamBinding("binding",
            project=default["project"],
            forwarding_rule_service_name=default["name"],
            role="roles/iap.httpsResourceAccessor",
            members=["user:jane@example.com"])
        ```

        With IAM Conditions:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        binding = gcp.iap.WebForwardingRuleServiceIamBinding("binding",
            project=default["project"],
            forwarding_rule_service_name=default["name"],
            role="roles/iap.httpsResourceAccessor",
            members=["user:jane@example.com"],
            condition={
                "title": "expires_after_2019_12_31",
                "description": "Expiring at midnight of 2019-12-31",
                "expression": "request.time < timestamp(\\"2020-01-01T00:00:00Z\\")",
            })
        ```
        ## iap.WebForwardingRuleServiceIamMember

        ```python
        import pulumi
        import pulumi_gcp as gcp

        member = gcp.iap.WebForwardingRuleServiceIamMember("member",
            project=default["project"],
            forwarding_rule_service_name=default["name"],
            role="roles/iap.httpsResourceAccessor",
            member="user:jane@example.com")
        ```

        With IAM Conditions:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        member = gcp.iap.WebForwardingRuleServiceIamMember("member",
            project=default["project"],
            forwarding_rule_service_name=default["name"],
            role="roles/iap.httpsResourceAccessor",
            member="user:jane@example.com",
            condition={
                "title": "expires_after_2019_12_31",
                "description": "Expiring at midnight of 2019-12-31",
                "expression": "request.time < timestamp(\\"2020-01-01T00:00:00Z\\")",
            })
        ```

        ## This resource supports User Project Overrides.

        - 

        # IAM policy for Identity-Aware Proxy WebForwardingRuleService

        Three different resources help you manage your IAM policy for Identity-Aware Proxy WebForwardingRuleService. Each of these resources serves a different use case:

        * `iap.WebForwardingRuleServiceIamPolicy`: Authoritative. Sets the IAM policy for the webforwardingruleservice and replaces any existing policy already attached.
        * `iap.WebForwardingRuleServiceIamBinding`: Authoritative for a given role. Updates the IAM policy to grant a role to a list of members. Other roles within the IAM policy for the webforwardingruleservice are preserved.
        * `iap.WebForwardingRuleServiceIamMember`: Non-authoritative. Updates the IAM policy to grant a role to a new member. Other members for the role for the webforwardingruleservice are preserved.

        A data source can be used to retrieve policy data in advent you do not need creation

        * `iap.WebForwardingRuleServiceIamPolicy`: Retrieves the IAM policy for the webforwardingruleservice

        > **Note:** `iap.WebForwardingRuleServiceIamPolicy` **cannot** be used in conjunction with `iap.WebForwardingRuleServiceIamBinding` and `iap.WebForwardingRuleServiceIamMember` or they will fight over what your policy should be.

        > **Note:** `iap.WebForwardingRuleServiceIamBinding` resources **can be** used in conjunction with `iap.WebForwardingRuleServiceIamMember` resources **only if** they do not grant privilege to the same role.

        > **Note:**  This resource supports IAM Conditions but they have some known limitations which can be found [here](https://cloud.google.com/iam/docs/conditions-overview#limitations). Please review this article if you are having issues with IAM Conditions.

        ## iap.WebForwardingRuleServiceIamPolicy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/iap.httpsResourceAccessor",
            "members": ["user:jane@example.com"],
        }])
        policy = gcp.iap.WebForwardingRuleServiceIamPolicy("policy",
            project=default["project"],
            forwarding_rule_service_name=default["name"],
            policy_data=admin.policy_data)
        ```

        With IAM Conditions:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/iap.httpsResourceAccessor",
            "members": ["user:jane@example.com"],
            "condition": {
                "title": "expires_after_2019_12_31",
                "description": "Expiring at midnight of 2019-12-31",
                "expression": "request.time < timestamp(\\"2020-01-01T00:00:00Z\\")",
            },
        }])
        policy = gcp.iap.WebForwardingRuleServiceIamPolicy("policy",
            project=default["project"],
            forwarding_rule_service_name=default["name"],
            policy_data=admin.policy_data)
        ```
        ## iap.WebForwardingRuleServiceIamBinding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        binding = gcp.iap.WebForwardingRuleServiceIamBinding("binding",
            project=default["project"],
            forwarding_rule_service_name=default["name"],
            role="roles/iap.httpsResourceAccessor",
            members=["user:jane@example.com"])
        ```

        With IAM Conditions:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        binding = gcp.iap.WebForwardingRuleServiceIamBinding("binding",
            project=default["project"],
            forwarding_rule_service_name=default["name"],
            role="roles/iap.httpsResourceAccessor",
            members=["user:jane@example.com"],
            condition={
                "title": "expires_after_2019_12_31",
                "description": "Expiring at midnight of 2019-12-31",
                "expression": "request.time < timestamp(\\"2020-01-01T00:00:00Z\\")",
            })
        ```
        ## iap.WebForwardingRuleServiceIamMember

        ```python
        import pulumi
        import pulumi_gcp as gcp

        member = gcp.iap.WebForwardingRuleServiceIamMember("member",
            project=default["project"],
            forwarding_rule_service_name=default["name"],
            role="roles/iap.httpsResourceAccessor",
            member="user:jane@example.com")
        ```

        With IAM Conditions:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        member = gcp.iap.WebForwardingRuleServiceIamMember("member",
            project=default["project"],
            forwarding_rule_service_name=default["name"],
            role="roles/iap.httpsResourceAccessor",
            member="user:jane@example.com",
            condition={
                "title": "expires_after_2019_12_31",
                "description": "Expiring at midnight of 2019-12-31",
                "expression": "request.time < timestamp(\\"2020-01-01T00:00:00Z\\")",
            })
        ```

        ## Import

        For all import syntaxes, the "resource in question" can take any of the following forms:

        * projects/{{project}}/iap_web/forwarding_rule/services/{{name}}

        * {{project}}/{{name}}

        * {{name}}

        Any variables not passed in the import command will be taken from the provider configuration.

        Identity-Aware Proxy webforwardingruleservice IAM resources can be imported using the resource identifiers, role, and member.

        IAM member imports use space-delimited identifiers: the resource in question, the role, and the member identity, e.g.

        ```sh
        $ pulumi import gcp:iap/webForwardingRuleServiceIamPolicy:WebForwardingRuleServiceIamPolicy editor "projects/{{project}}/iap_web/forwarding_rule/services/{{web_forwarding_rule_service}} roles/iap.httpsResourceAccessor user:jane@example.com"
        ```

        IAM binding imports use space-delimited identifiers: the resource in question and the role, e.g.

        ```sh
        $ pulumi import gcp:iap/webForwardingRuleServiceIamPolicy:WebForwardingRuleServiceIamPolicy editor "projects/{{project}}/iap_web/forwarding_rule/services/{{web_forwarding_rule_service}} roles/iap.httpsResourceAccessor"
        ```

        IAM policy imports use the identifier of the resource in question, e.g.

        ```sh
        $ pulumi import gcp:iap/webForwardingRuleServiceIamPolicy:WebForwardingRuleServiceIamPolicy editor projects/{{project}}/iap_web/forwarding_rule/services/{{web_forwarding_rule_service}}
        ```

        -> **Custom Roles** If you're importing a IAM resource with a custom role, make sure to use the

         full name of the custom role, e.g. `[projects/my-project|organizations/my-org]/roles/my-custom-role`.

        :param str resource_name: The name of the resource.
        :param WebForwardingRuleServiceIamPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WebForwardingRuleServiceIamPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 forwarding_rule_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_data: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WebForwardingRuleServiceIamPolicyArgs.__new__(WebForwardingRuleServiceIamPolicyArgs)

            if forwarding_rule_service_name is None and not opts.urn:
                raise TypeError("Missing required property 'forwarding_rule_service_name'")
            __props__.__dict__["forwarding_rule_service_name"] = forwarding_rule_service_name
            if policy_data is None and not opts.urn:
                raise TypeError("Missing required property 'policy_data'")
            __props__.__dict__["policy_data"] = policy_data
            __props__.__dict__["project"] = project
            __props__.__dict__["etag"] = None
        super(WebForwardingRuleServiceIamPolicy, __self__).__init__(
            'gcp:iap/webForwardingRuleServiceIamPolicy:WebForwardingRuleServiceIamPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            forwarding_rule_service_name: Optional[pulumi.Input[_builtins.str]] = None,
            policy_data: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None) -> 'WebForwardingRuleServiceIamPolicy':
        """
        Get an existing WebForwardingRuleServiceIamPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] etag: (Computed) The etag of the IAM policy.
        :param pulumi.Input[_builtins.str] forwarding_rule_service_name: Used to find the parent resource to bind the IAM policy to
        :param pulumi.Input[_builtins.str] policy_data: The policy data generated by
               a `organizations_get_iam_policy` data source.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WebForwardingRuleServiceIamPolicyState.__new__(_WebForwardingRuleServiceIamPolicyState)

        __props__.__dict__["etag"] = etag
        __props__.__dict__["forwarding_rule_service_name"] = forwarding_rule_service_name
        __props__.__dict__["policy_data"] = policy_data
        __props__.__dict__["project"] = project
        return WebForwardingRuleServiceIamPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="forwardingRuleServiceName")
    def forwarding_rule_service_name(self) -> pulumi.Output[_builtins.str]:
        """
        Used to find the parent resource to bind the IAM policy to
        """
        return pulumi.get(self, "forwarding_rule_service_name")

    @_builtins.property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> pulumi.Output[_builtins.str]:
        """
        The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
        """
        return pulumi.get(self, "project")

