# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectionArgs', 'Connection']

@pulumi.input_type
class ConnectionArgs:
    def __init__(__self__, *,
                 connector_version: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 auth_config: Optional[pulumi.Input['ConnectionAuthConfigArgs']] = None,
                 config_variables: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionConfigVariableArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionDestinationConfigArgs']]]] = None,
                 eventing_config: Optional[pulumi.Input['ConnectionEventingConfigArgs']] = None,
                 eventing_enablement_type: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lock_config: Optional[pulumi.Input['ConnectionLockConfigArgs']] = None,
                 log_config: Optional[pulumi.Input['ConnectionLogConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_config: Optional[pulumi.Input['ConnectionNodeConfigArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_config: Optional[pulumi.Input['ConnectionSslConfigArgs']] = None,
                 suspended: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Connection resource.
        :param pulumi.Input[_builtins.str] connector_version: connectorVersion of the Connector.
        :param pulumi.Input[_builtins.str] location: Location in which Connection needs to be created.
        :param pulumi.Input['ConnectionAuthConfigArgs'] auth_config: authConfig for the connection.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionConfigVariableArgs']]] config_variables: Config Variables for the connection.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: An arbitrary description for the Connection.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionDestinationConfigArgs']]] destination_configs: Define the Connectors target endpoint.
               Structure is documented below.
        :param pulumi.Input['ConnectionEventingConfigArgs'] eventing_config: Eventing Configuration of a connection
               Structure is documented below.
        :param pulumi.Input[_builtins.str] eventing_enablement_type: Eventing enablement type. Will be nil if eventing is not enabled.
               Possible values are: `EVENTING_AND_CONNECTION`, `ONLY_EVENTING`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Resource labels to represent user provided metadata.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input['ConnectionLockConfigArgs'] lock_config: Determines whether or no a connection is locked. If locked, a reason must be specified.
               Structure is documented below.
        :param pulumi.Input['ConnectionLogConfigArgs'] log_config: Log configuration for the connection.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of Connection needs to be created.
        :param pulumi.Input['ConnectionNodeConfigArgs'] node_config: Node configuration for the connection.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] service_account: Service account needed for runtime plane to access Google Cloud resources.
        :param pulumi.Input['ConnectionSslConfigArgs'] ssl_config: SSL Configuration of a connection
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] suspended: Suspended indicates if a user has suspended a connection or not.
        """
        pulumi.set(__self__, "connector_version", connector_version)
        pulumi.set(__self__, "location", location)
        if auth_config is not None:
            pulumi.set(__self__, "auth_config", auth_config)
        if config_variables is not None:
            pulumi.set(__self__, "config_variables", config_variables)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_configs is not None:
            pulumi.set(__self__, "destination_configs", destination_configs)
        if eventing_config is not None:
            pulumi.set(__self__, "eventing_config", eventing_config)
        if eventing_enablement_type is not None:
            pulumi.set(__self__, "eventing_enablement_type", eventing_enablement_type)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if lock_config is not None:
            pulumi.set(__self__, "lock_config", lock_config)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_config is not None:
            pulumi.set(__self__, "node_config", node_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if ssl_config is not None:
            pulumi.set(__self__, "ssl_config", ssl_config)
        if suspended is not None:
            pulumi.set(__self__, "suspended", suspended)

    @_builtins.property
    @pulumi.getter(name="connectorVersion")
    def connector_version(self) -> pulumi.Input[_builtins.str]:
        """
        connectorVersion of the Connector.
        """
        return pulumi.get(self, "connector_version")

    @connector_version.setter
    def connector_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "connector_version", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Location in which Connection needs to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="authConfig")
    def auth_config(self) -> Optional[pulumi.Input['ConnectionAuthConfigArgs']]:
        """
        authConfig for the connection.
        Structure is documented below.
        """
        return pulumi.get(self, "auth_config")

    @auth_config.setter
    def auth_config(self, value: Optional[pulumi.Input['ConnectionAuthConfigArgs']]):
        pulumi.set(self, "auth_config", value)

    @_builtins.property
    @pulumi.getter(name="configVariables")
    def config_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionConfigVariableArgs']]]]:
        """
        Config Variables for the connection.
        Structure is documented below.
        """
        return pulumi.get(self, "config_variables")

    @config_variables.setter
    def config_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionConfigVariableArgs']]]]):
        pulumi.set(self, "config_variables", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An arbitrary description for the Connection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationConfigs")
    def destination_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionDestinationConfigArgs']]]]:
        """
        Define the Connectors target endpoint.
        Structure is documented below.
        """
        return pulumi.get(self, "destination_configs")

    @destination_configs.setter
    def destination_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionDestinationConfigArgs']]]]):
        pulumi.set(self, "destination_configs", value)

    @_builtins.property
    @pulumi.getter(name="eventingConfig")
    def eventing_config(self) -> Optional[pulumi.Input['ConnectionEventingConfigArgs']]:
        """
        Eventing Configuration of a connection
        Structure is documented below.
        """
        return pulumi.get(self, "eventing_config")

    @eventing_config.setter
    def eventing_config(self, value: Optional[pulumi.Input['ConnectionEventingConfigArgs']]):
        pulumi.set(self, "eventing_config", value)

    @_builtins.property
    @pulumi.getter(name="eventingEnablementType")
    def eventing_enablement_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Eventing enablement type. Will be nil if eventing is not enabled.
        Possible values are: `EVENTING_AND_CONNECTION`, `ONLY_EVENTING`.
        """
        return pulumi.get(self, "eventing_enablement_type")

    @eventing_enablement_type.setter
    def eventing_enablement_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eventing_enablement_type", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Resource labels to represent user provided metadata.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="lockConfig")
    def lock_config(self) -> Optional[pulumi.Input['ConnectionLockConfigArgs']]:
        """
        Determines whether or no a connection is locked. If locked, a reason must be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "lock_config")

    @lock_config.setter
    def lock_config(self, value: Optional[pulumi.Input['ConnectionLockConfigArgs']]):
        pulumi.set(self, "lock_config", value)

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['ConnectionLogConfigArgs']]:
        """
        Log configuration for the connection.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['ConnectionLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of Connection needs to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> Optional[pulumi.Input['ConnectionNodeConfigArgs']]:
        """
        Node configuration for the connection.
        Structure is documented below.
        """
        return pulumi.get(self, "node_config")

    @node_config.setter
    def node_config(self, value: Optional[pulumi.Input['ConnectionNodeConfigArgs']]):
        pulumi.set(self, "node_config", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service account needed for runtime plane to access Google Cloud resources.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account", value)

    @_builtins.property
    @pulumi.getter(name="sslConfig")
    def ssl_config(self) -> Optional[pulumi.Input['ConnectionSslConfigArgs']]:
        """
        SSL Configuration of a connection
        Structure is documented below.
        """
        return pulumi.get(self, "ssl_config")

    @ssl_config.setter
    def ssl_config(self, value: Optional[pulumi.Input['ConnectionSslConfigArgs']]):
        pulumi.set(self, "ssl_config", value)

    @_builtins.property
    @pulumi.getter
    def suspended(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Suspended indicates if a user has suspended a connection or not.
        """
        return pulumi.get(self, "suspended")

    @suspended.setter
    def suspended(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "suspended", value)


@pulumi.input_type
class _ConnectionState:
    def __init__(__self__, *,
                 auth_config: Optional[pulumi.Input['ConnectionAuthConfigArgs']] = None,
                 config_variables: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionConfigVariableArgs']]]] = None,
                 connection_revision: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_version: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_version_infra_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionConnectorVersionInfraConfigArgs']]]] = None,
                 connector_version_launch_stage: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionDestinationConfigArgs']]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 eventing_config: Optional[pulumi.Input['ConnectionEventingConfigArgs']] = None,
                 eventing_enablement_type: Optional[pulumi.Input[_builtins.str]] = None,
                 eventing_runtime_datas: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionEventingRuntimeDataArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 lock_config: Optional[pulumi.Input['ConnectionLockConfigArgs']] = None,
                 log_config: Optional[pulumi.Input['ConnectionLogConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_config: Optional[pulumi.Input['ConnectionNodeConfigArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 service_directory: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_config: Optional[pulumi.Input['ConnectionSslConfigArgs']] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionStatusArgs']]]] = None,
                 subscription_type: Optional[pulumi.Input[_builtins.str]] = None,
                 suspended: Optional[pulumi.Input[_builtins.bool]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Connection resources.
        :param pulumi.Input['ConnectionAuthConfigArgs'] auth_config: authConfig for the connection.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionConfigVariableArgs']]] config_variables: Config Variables for the connection.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] connection_revision: Connection revision. This field is only updated when the connection is created or updated by User.
        :param pulumi.Input[_builtins.str] connector_version: connectorVersion of the Connector.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionConnectorVersionInfraConfigArgs']]] connector_version_infra_configs: This configuration provides infra configs like rate limit threshold which need to be configurable for every connector version.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] connector_version_launch_stage: Flag to mark the version indicating the launch stage.
        :param pulumi.Input[_builtins.str] create_time: Time the Namespace was created in UTC.
        :param pulumi.Input[_builtins.str] description: An arbitrary description for the Connection.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionDestinationConfigArgs']]] destination_configs: Define the Connectors target endpoint.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input['ConnectionEventingConfigArgs'] eventing_config: Eventing Configuration of a connection
               Structure is documented below.
        :param pulumi.Input[_builtins.str] eventing_enablement_type: Eventing enablement type. Will be nil if eventing is not enabled.
               Possible values are: `EVENTING_AND_CONNECTION`, `ONLY_EVENTING`.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionEventingRuntimeDataArgs']]] eventing_runtime_datas: Eventing Runtime Data.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Resource labels to represent user provided metadata.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Location in which Connection needs to be created.
        :param pulumi.Input['ConnectionLockConfigArgs'] lock_config: Determines whether or no a connection is locked. If locked, a reason must be specified.
               Structure is documented below.
        :param pulumi.Input['ConnectionLogConfigArgs'] log_config: Log configuration for the connection.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of Connection needs to be created.
        :param pulumi.Input['ConnectionNodeConfigArgs'] node_config: Node configuration for the connection.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] service_account: Service account needed for runtime plane to access Google Cloud resources.
        :param pulumi.Input[_builtins.str] service_directory: The name of the Service Directory service name. Used for Private Harpoon to resolve the ILB address.
               e.g. "projects/cloud-connectors-e2e-testing/locations/us-central1/namespaces/istio-system/services/istio-ingressgateway-connectors"
        :param pulumi.Input['ConnectionSslConfigArgs'] ssl_config: SSL Configuration of a connection
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionStatusArgs']]] statuses: (Output)
               Current status of eventing.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] subscription_type: This subscription type enum states the subscription type of the project.
        :param pulumi.Input[_builtins.bool] suspended: Suspended indicates if a user has suspended a connection or not.
        :param pulumi.Input[_builtins.str] update_time: Time the Namespace was updated in UTC.
        """
        if auth_config is not None:
            pulumi.set(__self__, "auth_config", auth_config)
        if config_variables is not None:
            pulumi.set(__self__, "config_variables", config_variables)
        if connection_revision is not None:
            pulumi.set(__self__, "connection_revision", connection_revision)
        if connector_version is not None:
            pulumi.set(__self__, "connector_version", connector_version)
        if connector_version_infra_configs is not None:
            pulumi.set(__self__, "connector_version_infra_configs", connector_version_infra_configs)
        if connector_version_launch_stage is not None:
            pulumi.set(__self__, "connector_version_launch_stage", connector_version_launch_stage)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_configs is not None:
            pulumi.set(__self__, "destination_configs", destination_configs)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if eventing_config is not None:
            pulumi.set(__self__, "eventing_config", eventing_config)
        if eventing_enablement_type is not None:
            pulumi.set(__self__, "eventing_enablement_type", eventing_enablement_type)
        if eventing_runtime_datas is not None:
            pulumi.set(__self__, "eventing_runtime_datas", eventing_runtime_datas)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if lock_config is not None:
            pulumi.set(__self__, "lock_config", lock_config)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_config is not None:
            pulumi.set(__self__, "node_config", node_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if service_directory is not None:
            pulumi.set(__self__, "service_directory", service_directory)
        if ssl_config is not None:
            pulumi.set(__self__, "ssl_config", ssl_config)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if subscription_type is not None:
            pulumi.set(__self__, "subscription_type", subscription_type)
        if suspended is not None:
            pulumi.set(__self__, "suspended", suspended)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="authConfig")
    def auth_config(self) -> Optional[pulumi.Input['ConnectionAuthConfigArgs']]:
        """
        authConfig for the connection.
        Structure is documented below.
        """
        return pulumi.get(self, "auth_config")

    @auth_config.setter
    def auth_config(self, value: Optional[pulumi.Input['ConnectionAuthConfigArgs']]):
        pulumi.set(self, "auth_config", value)

    @_builtins.property
    @pulumi.getter(name="configVariables")
    def config_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionConfigVariableArgs']]]]:
        """
        Config Variables for the connection.
        Structure is documented below.
        """
        return pulumi.get(self, "config_variables")

    @config_variables.setter
    def config_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionConfigVariableArgs']]]]):
        pulumi.set(self, "config_variables", value)

    @_builtins.property
    @pulumi.getter(name="connectionRevision")
    def connection_revision(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Connection revision. This field is only updated when the connection is created or updated by User.
        """
        return pulumi.get(self, "connection_revision")

    @connection_revision.setter
    def connection_revision(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_revision", value)

    @_builtins.property
    @pulumi.getter(name="connectorVersion")
    def connector_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        connectorVersion of the Connector.
        """
        return pulumi.get(self, "connector_version")

    @connector_version.setter
    def connector_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connector_version", value)

    @_builtins.property
    @pulumi.getter(name="connectorVersionInfraConfigs")
    def connector_version_infra_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionConnectorVersionInfraConfigArgs']]]]:
        """
        This configuration provides infra configs like rate limit threshold which need to be configurable for every connector version.
        Structure is documented below.
        """
        return pulumi.get(self, "connector_version_infra_configs")

    @connector_version_infra_configs.setter
    def connector_version_infra_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionConnectorVersionInfraConfigArgs']]]]):
        pulumi.set(self, "connector_version_infra_configs", value)

    @_builtins.property
    @pulumi.getter(name="connectorVersionLaunchStage")
    def connector_version_launch_stage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Flag to mark the version indicating the launch stage.
        """
        return pulumi.get(self, "connector_version_launch_stage")

    @connector_version_launch_stage.setter
    def connector_version_launch_stage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connector_version_launch_stage", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time the Namespace was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An arbitrary description for the Connection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationConfigs")
    def destination_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionDestinationConfigArgs']]]]:
        """
        Define the Connectors target endpoint.
        Structure is documented below.
        """
        return pulumi.get(self, "destination_configs")

    @destination_configs.setter
    def destination_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionDestinationConfigArgs']]]]):
        pulumi.set(self, "destination_configs", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="eventingConfig")
    def eventing_config(self) -> Optional[pulumi.Input['ConnectionEventingConfigArgs']]:
        """
        Eventing Configuration of a connection
        Structure is documented below.
        """
        return pulumi.get(self, "eventing_config")

    @eventing_config.setter
    def eventing_config(self, value: Optional[pulumi.Input['ConnectionEventingConfigArgs']]):
        pulumi.set(self, "eventing_config", value)

    @_builtins.property
    @pulumi.getter(name="eventingEnablementType")
    def eventing_enablement_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Eventing enablement type. Will be nil if eventing is not enabled.
        Possible values are: `EVENTING_AND_CONNECTION`, `ONLY_EVENTING`.
        """
        return pulumi.get(self, "eventing_enablement_type")

    @eventing_enablement_type.setter
    def eventing_enablement_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eventing_enablement_type", value)

    @_builtins.property
    @pulumi.getter(name="eventingRuntimeDatas")
    def eventing_runtime_datas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionEventingRuntimeDataArgs']]]]:
        """
        Eventing Runtime Data.
        Structure is documented below.
        """
        return pulumi.get(self, "eventing_runtime_datas")

    @eventing_runtime_datas.setter
    def eventing_runtime_datas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionEventingRuntimeDataArgs']]]]):
        pulumi.set(self, "eventing_runtime_datas", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Resource labels to represent user provided metadata.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Location in which Connection needs to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="lockConfig")
    def lock_config(self) -> Optional[pulumi.Input['ConnectionLockConfigArgs']]:
        """
        Determines whether or no a connection is locked. If locked, a reason must be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "lock_config")

    @lock_config.setter
    def lock_config(self, value: Optional[pulumi.Input['ConnectionLockConfigArgs']]):
        pulumi.set(self, "lock_config", value)

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['ConnectionLogConfigArgs']]:
        """
        Log configuration for the connection.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['ConnectionLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of Connection needs to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> Optional[pulumi.Input['ConnectionNodeConfigArgs']]:
        """
        Node configuration for the connection.
        Structure is documented below.
        """
        return pulumi.get(self, "node_config")

    @node_config.setter
    def node_config(self, value: Optional[pulumi.Input['ConnectionNodeConfigArgs']]):
        pulumi.set(self, "node_config", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service account needed for runtime plane to access Google Cloud resources.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account", value)

    @_builtins.property
    @pulumi.getter(name="serviceDirectory")
    def service_directory(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Service Directory service name. Used for Private Harpoon to resolve the ILB address.
        e.g. "projects/cloud-connectors-e2e-testing/locations/us-central1/namespaces/istio-system/services/istio-ingressgateway-connectors"
        """
        return pulumi.get(self, "service_directory")

    @service_directory.setter
    def service_directory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_directory", value)

    @_builtins.property
    @pulumi.getter(name="sslConfig")
    def ssl_config(self) -> Optional[pulumi.Input['ConnectionSslConfigArgs']]:
        """
        SSL Configuration of a connection
        Structure is documented below.
        """
        return pulumi.get(self, "ssl_config")

    @ssl_config.setter
    def ssl_config(self, value: Optional[pulumi.Input['ConnectionSslConfigArgs']]):
        pulumi.set(self, "ssl_config", value)

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionStatusArgs']]]]:
        """
        (Output)
        Current status of eventing.
        Structure is documented below.
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionStatusArgs']]]]):
        pulumi.set(self, "statuses", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionType")
    def subscription_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This subscription type enum states the subscription type of the project.
        """
        return pulumi.get(self, "subscription_type")

    @subscription_type.setter
    def subscription_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscription_type", value)

    @_builtins.property
    @pulumi.getter
    def suspended(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Suspended indicates if a user has suspended a connection or not.
        """
        return pulumi.get(self, "suspended")

    @suspended.setter
    def suspended(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "suspended", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time the Namespace was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:integrationconnectors/connection:Connection")
class Connection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_config: Optional[pulumi.Input[Union['ConnectionAuthConfigArgs', 'ConnectionAuthConfigArgsDict']]] = None,
                 config_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectionConfigVariableArgs', 'ConnectionConfigVariableArgsDict']]]]] = None,
                 connector_version: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectionDestinationConfigArgs', 'ConnectionDestinationConfigArgsDict']]]]] = None,
                 eventing_config: Optional[pulumi.Input[Union['ConnectionEventingConfigArgs', 'ConnectionEventingConfigArgsDict']]] = None,
                 eventing_enablement_type: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 lock_config: Optional[pulumi.Input[Union['ConnectionLockConfigArgs', 'ConnectionLockConfigArgsDict']]] = None,
                 log_config: Optional[pulumi.Input[Union['ConnectionLogConfigArgs', 'ConnectionLogConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_config: Optional[pulumi.Input[Union['ConnectionNodeConfigArgs', 'ConnectionNodeConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_config: Optional[pulumi.Input[Union['ConnectionSslConfigArgs', 'ConnectionSslConfigArgsDict']]] = None,
                 suspended: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        An Integration connectors Connection.

        To get more information about Connection, see:

        * [API documentation](https://cloud.google.com/integration-connectors/docs/reference/rest/v1/projects.locations.connections)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/integration-connectors/docs/createconnection)

        ## Example Usage

        ### Integration Connectors Connection Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_project = gcp.organizations.get_project()
        pubsubconnection = gcp.integrationconnectors.Connection("pubsubconnection",
            name="test-pubsub",
            location="us-central1",
            connector_version=f"projects/{test_project.project_id}/locations/global/providers/gcp/connectors/pubsub/versions/1",
            description="tf created description",
            config_variables=[
                {
                    "key": "project_id",
                    "string_value": "connectors-example",
                },
                {
                    "key": "topic_id",
                    "string_value": "test",
                },
            ])
        ```
        ### Integration Connectors Connection Advanced

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_project = gcp.organizations.get_project()
        secret_basic = gcp.secretmanager.Secret("secret-basic",
            secret_id="test-secret",
            replication={
                "user_managed": {
                    "replicas": [{
                        "location": "us-central1",
                    }],
                },
            })
        secret_version_basic = gcp.secretmanager.SecretVersion("secret-version-basic",
            secret=secret_basic.id,
            secret_data="dummypassword")
        secret_iam = gcp.secretmanager.SecretIamMember("secret_iam",
            secret_id=secret_basic.id,
            role="roles/secretmanager.admin",
            member=f"serviceAccount:{test_project.number}-compute@developer.gserviceaccount.com",
            opts = pulumi.ResourceOptions(depends_on=[secret_version_basic]))
        zendeskconnection = gcp.integrationconnectors.Connection("zendeskconnection",
            name="test-zendesk",
            description="tf updated description",
            location="us-central1",
            service_account=f"{test_project.number}-compute@developer.gserviceaccount.com",
            connector_version=f"projects/{test_project.project_id}/locations/global/providers/zendesk/connectors/zendesk/versions/1",
            config_variables=[
                {
                    "key": "proxy_enabled",
                    "boolean_value": False,
                },
                {
                    "key": "sample_integer_value",
                    "integer_value": 1,
                },
                {
                    "key": "sample_encryption_key_value",
                    "encryption_key_value": {
                        "type": "GOOGLE_MANAGED",
                        "kms_key_name": "sampleKMSKkey",
                    },
                },
                {
                    "key": "sample_secret_value",
                    "secret_value": {
                        "secret_version": secret_version_basic.name,
                    },
                },
            ],
            suspended=False,
            auth_config={
                "additional_variables": [
                    {
                        "key": "sample_string",
                        "string_value": "sampleString",
                    },
                    {
                        "key": "sample_boolean",
                        "boolean_value": False,
                    },
                    {
                        "key": "sample_integer",
                        "integer_value": 1,
                    },
                    {
                        "key": "sample_secret_value",
                        "secret_value": {
                            "secret_version": secret_version_basic.name,
                        },
                    },
                    {
                        "key": "sample_encryption_key_value",
                        "encryption_key_value": {
                            "type": "GOOGLE_MANAGED",
                            "kms_key_name": "sampleKMSKkey",
                        },
                    },
                ],
                "auth_type": "USER_PASSWORD",
                "auth_key": "sampleAuthKey",
                "user_password": {
                    "username": "user@xyz.com",
                    "password": {
                        "secret_version": secret_version_basic.name,
                    },
                },
            },
            destination_configs=[{
                "key": "url",
                "destinations": [{
                    "host": "https://test.zendesk.com",
                    "port": 80,
                }],
            }],
            lock_config={
                "locked": False,
                "reason": "Its not locked",
            },
            log_config={
                "enabled": True,
            },
            node_config={
                "min_node_count": 2,
                "max_node_count": 50,
            },
            labels={
                "foo": "bar",
            },
            ssl_config={
                "additional_variables": [
                    {
                        "key": "sample_string",
                        "string_value": "sampleString",
                    },
                    {
                        "key": "sample_boolean",
                        "boolean_value": False,
                    },
                    {
                        "key": "sample_integer",
                        "integer_value": 1,
                    },
                    {
                        "key": "sample_secret_value",
                        "secret_value": {
                            "secret_version": secret_version_basic.name,
                        },
                    },
                    {
                        "key": "sample_encryption_key_value",
                        "encryption_key_value": {
                            "type": "GOOGLE_MANAGED",
                            "kms_key_name": "sampleKMSKkey",
                        },
                    },
                ],
                "client_cert_type": "PEM",
                "client_certificate": {
                    "secret_version": secret_version_basic.name,
                },
                "client_private_key": {
                    "secret_version": secret_version_basic.name,
                },
                "client_private_key_pass": {
                    "secret_version": secret_version_basic.name,
                },
                "private_server_certificate": {
                    "secret_version": secret_version_basic.name,
                },
                "server_cert_type": "PEM",
                "trust_model": "PRIVATE",
                "type": "TLS",
                "use_ssl": True,
            },
            eventing_enablement_type="EVENTING_AND_CONNECTION",
            eventing_config={
                "additional_variables": [
                    {
                        "key": "sample_string",
                        "string_value": "sampleString",
                    },
                    {
                        "key": "sample_boolean",
                        "boolean_value": False,
                    },
                    {
                        "key": "sample_integer",
                        "integer_value": 1,
                    },
                    {
                        "key": "sample_secret_value",
                        "secret_value": {
                            "secret_version": secret_version_basic.name,
                        },
                    },
                    {
                        "key": "sample_encryption_key_value",
                        "encryption_key_value": {
                            "type": "GOOGLE_MANAGED",
                            "kms_key_name": "sampleKMSKkey",
                        },
                    },
                ],
                "registration_destination_config": {
                    "key": "registration_destination_config",
                    "destinations": [{
                        "host": "https://test.zendesk.com",
                        "port": 80,
                    }],
                },
                "auth_config": {
                    "auth_type": "USER_PASSWORD",
                    "auth_key": "sampleAuthKey",
                    "user_password": {
                        "username": "user@xyz.com",
                        "password": {
                            "secret_version": secret_version_basic.name,
                        },
                    },
                    "additional_variables": [
                        {
                            "key": "sample_string",
                            "string_value": "sampleString",
                        },
                        {
                            "key": "sample_boolean",
                            "boolean_value": False,
                        },
                        {
                            "key": "sample_integer",
                            "integer_value": 1,
                        },
                        {
                            "key": "sample_secret_value",
                            "secret_value": {
                                "secret_version": secret_version_basic.name,
                            },
                        },
                        {
                            "key": "sample_encryption_key_value",
                            "encryption_key_value": {
                                "type": "GOOGLE_MANAGED",
                                "kms_key_name": "sampleKMSKkey",
                            },
                        },
                    ],
                },
                "enrichment_enabled": True,
            })
        ```

        ## Import

        Connection can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/connections/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Connection can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:integrationconnectors/connection:Connection default projects/{{project}}/locations/{{location}}/connections/{{name}}
        ```

        ```sh
        $ pulumi import gcp:integrationconnectors/connection:Connection default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:integrationconnectors/connection:Connection default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConnectionAuthConfigArgs', 'ConnectionAuthConfigArgsDict']] auth_config: authConfig for the connection.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConnectionConfigVariableArgs', 'ConnectionConfigVariableArgsDict']]]] config_variables: Config Variables for the connection.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] connector_version: connectorVersion of the Connector.
        :param pulumi.Input[_builtins.str] description: An arbitrary description for the Connection.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConnectionDestinationConfigArgs', 'ConnectionDestinationConfigArgsDict']]]] destination_configs: Define the Connectors target endpoint.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionEventingConfigArgs', 'ConnectionEventingConfigArgsDict']] eventing_config: Eventing Configuration of a connection
               Structure is documented below.
        :param pulumi.Input[_builtins.str] eventing_enablement_type: Eventing enablement type. Will be nil if eventing is not enabled.
               Possible values are: `EVENTING_AND_CONNECTION`, `ONLY_EVENTING`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Resource labels to represent user provided metadata.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Location in which Connection needs to be created.
        :param pulumi.Input[Union['ConnectionLockConfigArgs', 'ConnectionLockConfigArgsDict']] lock_config: Determines whether or no a connection is locked. If locked, a reason must be specified.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionLogConfigArgs', 'ConnectionLogConfigArgsDict']] log_config: Log configuration for the connection.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of Connection needs to be created.
        :param pulumi.Input[Union['ConnectionNodeConfigArgs', 'ConnectionNodeConfigArgsDict']] node_config: Node configuration for the connection.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] service_account: Service account needed for runtime plane to access Google Cloud resources.
        :param pulumi.Input[Union['ConnectionSslConfigArgs', 'ConnectionSslConfigArgsDict']] ssl_config: SSL Configuration of a connection
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] suspended: Suspended indicates if a user has suspended a connection or not.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An Integration connectors Connection.

        To get more information about Connection, see:

        * [API documentation](https://cloud.google.com/integration-connectors/docs/reference/rest/v1/projects.locations.connections)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/integration-connectors/docs/createconnection)

        ## Example Usage

        ### Integration Connectors Connection Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_project = gcp.organizations.get_project()
        pubsubconnection = gcp.integrationconnectors.Connection("pubsubconnection",
            name="test-pubsub",
            location="us-central1",
            connector_version=f"projects/{test_project.project_id}/locations/global/providers/gcp/connectors/pubsub/versions/1",
            description="tf created description",
            config_variables=[
                {
                    "key": "project_id",
                    "string_value": "connectors-example",
                },
                {
                    "key": "topic_id",
                    "string_value": "test",
                },
            ])
        ```
        ### Integration Connectors Connection Advanced

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_project = gcp.organizations.get_project()
        secret_basic = gcp.secretmanager.Secret("secret-basic",
            secret_id="test-secret",
            replication={
                "user_managed": {
                    "replicas": [{
                        "location": "us-central1",
                    }],
                },
            })
        secret_version_basic = gcp.secretmanager.SecretVersion("secret-version-basic",
            secret=secret_basic.id,
            secret_data="dummypassword")
        secret_iam = gcp.secretmanager.SecretIamMember("secret_iam",
            secret_id=secret_basic.id,
            role="roles/secretmanager.admin",
            member=f"serviceAccount:{test_project.number}-compute@developer.gserviceaccount.com",
            opts = pulumi.ResourceOptions(depends_on=[secret_version_basic]))
        zendeskconnection = gcp.integrationconnectors.Connection("zendeskconnection",
            name="test-zendesk",
            description="tf updated description",
            location="us-central1",
            service_account=f"{test_project.number}-compute@developer.gserviceaccount.com",
            connector_version=f"projects/{test_project.project_id}/locations/global/providers/zendesk/connectors/zendesk/versions/1",
            config_variables=[
                {
                    "key": "proxy_enabled",
                    "boolean_value": False,
                },
                {
                    "key": "sample_integer_value",
                    "integer_value": 1,
                },
                {
                    "key": "sample_encryption_key_value",
                    "encryption_key_value": {
                        "type": "GOOGLE_MANAGED",
                        "kms_key_name": "sampleKMSKkey",
                    },
                },
                {
                    "key": "sample_secret_value",
                    "secret_value": {
                        "secret_version": secret_version_basic.name,
                    },
                },
            ],
            suspended=False,
            auth_config={
                "additional_variables": [
                    {
                        "key": "sample_string",
                        "string_value": "sampleString",
                    },
                    {
                        "key": "sample_boolean",
                        "boolean_value": False,
                    },
                    {
                        "key": "sample_integer",
                        "integer_value": 1,
                    },
                    {
                        "key": "sample_secret_value",
                        "secret_value": {
                            "secret_version": secret_version_basic.name,
                        },
                    },
                    {
                        "key": "sample_encryption_key_value",
                        "encryption_key_value": {
                            "type": "GOOGLE_MANAGED",
                            "kms_key_name": "sampleKMSKkey",
                        },
                    },
                ],
                "auth_type": "USER_PASSWORD",
                "auth_key": "sampleAuthKey",
                "user_password": {
                    "username": "user@xyz.com",
                    "password": {
                        "secret_version": secret_version_basic.name,
                    },
                },
            },
            destination_configs=[{
                "key": "url",
                "destinations": [{
                    "host": "https://test.zendesk.com",
                    "port": 80,
                }],
            }],
            lock_config={
                "locked": False,
                "reason": "Its not locked",
            },
            log_config={
                "enabled": True,
            },
            node_config={
                "min_node_count": 2,
                "max_node_count": 50,
            },
            labels={
                "foo": "bar",
            },
            ssl_config={
                "additional_variables": [
                    {
                        "key": "sample_string",
                        "string_value": "sampleString",
                    },
                    {
                        "key": "sample_boolean",
                        "boolean_value": False,
                    },
                    {
                        "key": "sample_integer",
                        "integer_value": 1,
                    },
                    {
                        "key": "sample_secret_value",
                        "secret_value": {
                            "secret_version": secret_version_basic.name,
                        },
                    },
                    {
                        "key": "sample_encryption_key_value",
                        "encryption_key_value": {
                            "type": "GOOGLE_MANAGED",
                            "kms_key_name": "sampleKMSKkey",
                        },
                    },
                ],
                "client_cert_type": "PEM",
                "client_certificate": {
                    "secret_version": secret_version_basic.name,
                },
                "client_private_key": {
                    "secret_version": secret_version_basic.name,
                },
                "client_private_key_pass": {
                    "secret_version": secret_version_basic.name,
                },
                "private_server_certificate": {
                    "secret_version": secret_version_basic.name,
                },
                "server_cert_type": "PEM",
                "trust_model": "PRIVATE",
                "type": "TLS",
                "use_ssl": True,
            },
            eventing_enablement_type="EVENTING_AND_CONNECTION",
            eventing_config={
                "additional_variables": [
                    {
                        "key": "sample_string",
                        "string_value": "sampleString",
                    },
                    {
                        "key": "sample_boolean",
                        "boolean_value": False,
                    },
                    {
                        "key": "sample_integer",
                        "integer_value": 1,
                    },
                    {
                        "key": "sample_secret_value",
                        "secret_value": {
                            "secret_version": secret_version_basic.name,
                        },
                    },
                    {
                        "key": "sample_encryption_key_value",
                        "encryption_key_value": {
                            "type": "GOOGLE_MANAGED",
                            "kms_key_name": "sampleKMSKkey",
                        },
                    },
                ],
                "registration_destination_config": {
                    "key": "registration_destination_config",
                    "destinations": [{
                        "host": "https://test.zendesk.com",
                        "port": 80,
                    }],
                },
                "auth_config": {
                    "auth_type": "USER_PASSWORD",
                    "auth_key": "sampleAuthKey",
                    "user_password": {
                        "username": "user@xyz.com",
                        "password": {
                            "secret_version": secret_version_basic.name,
                        },
                    },
                    "additional_variables": [
                        {
                            "key": "sample_string",
                            "string_value": "sampleString",
                        },
                        {
                            "key": "sample_boolean",
                            "boolean_value": False,
                        },
                        {
                            "key": "sample_integer",
                            "integer_value": 1,
                        },
                        {
                            "key": "sample_secret_value",
                            "secret_value": {
                                "secret_version": secret_version_basic.name,
                            },
                        },
                        {
                            "key": "sample_encryption_key_value",
                            "encryption_key_value": {
                                "type": "GOOGLE_MANAGED",
                                "kms_key_name": "sampleKMSKkey",
                            },
                        },
                    ],
                },
                "enrichment_enabled": True,
            })
        ```

        ## Import

        Connection can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/connections/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Connection can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:integrationconnectors/connection:Connection default projects/{{project}}/locations/{{location}}/connections/{{name}}
        ```

        ```sh
        $ pulumi import gcp:integrationconnectors/connection:Connection default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:integrationconnectors/connection:Connection default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_config: Optional[pulumi.Input[Union['ConnectionAuthConfigArgs', 'ConnectionAuthConfigArgsDict']]] = None,
                 config_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectionConfigVariableArgs', 'ConnectionConfigVariableArgsDict']]]]] = None,
                 connector_version: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectionDestinationConfigArgs', 'ConnectionDestinationConfigArgsDict']]]]] = None,
                 eventing_config: Optional[pulumi.Input[Union['ConnectionEventingConfigArgs', 'ConnectionEventingConfigArgsDict']]] = None,
                 eventing_enablement_type: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 lock_config: Optional[pulumi.Input[Union['ConnectionLockConfigArgs', 'ConnectionLockConfigArgsDict']]] = None,
                 log_config: Optional[pulumi.Input[Union['ConnectionLogConfigArgs', 'ConnectionLogConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_config: Optional[pulumi.Input[Union['ConnectionNodeConfigArgs', 'ConnectionNodeConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_config: Optional[pulumi.Input[Union['ConnectionSslConfigArgs', 'ConnectionSslConfigArgsDict']]] = None,
                 suspended: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionArgs.__new__(ConnectionArgs)

            __props__.__dict__["auth_config"] = auth_config
            __props__.__dict__["config_variables"] = config_variables
            if connector_version is None and not opts.urn:
                raise TypeError("Missing required property 'connector_version'")
            __props__.__dict__["connector_version"] = connector_version
            __props__.__dict__["description"] = description
            __props__.__dict__["destination_configs"] = destination_configs
            __props__.__dict__["eventing_config"] = eventing_config
            __props__.__dict__["eventing_enablement_type"] = eventing_enablement_type
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["lock_config"] = lock_config
            __props__.__dict__["log_config"] = log_config
            __props__.__dict__["name"] = name
            __props__.__dict__["node_config"] = node_config
            __props__.__dict__["project"] = project
            __props__.__dict__["service_account"] = service_account
            __props__.__dict__["ssl_config"] = ssl_config
            __props__.__dict__["suspended"] = suspended
            __props__.__dict__["connection_revision"] = None
            __props__.__dict__["connector_version_infra_configs"] = None
            __props__.__dict__["connector_version_launch_stage"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["eventing_runtime_datas"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["service_directory"] = None
            __props__.__dict__["statuses"] = None
            __props__.__dict__["subscription_type"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Connection, __self__).__init__(
            'gcp:integrationconnectors/connection:Connection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auth_config: Optional[pulumi.Input[Union['ConnectionAuthConfigArgs', 'ConnectionAuthConfigArgsDict']]] = None,
            config_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectionConfigVariableArgs', 'ConnectionConfigVariableArgsDict']]]]] = None,
            connection_revision: Optional[pulumi.Input[_builtins.str]] = None,
            connector_version: Optional[pulumi.Input[_builtins.str]] = None,
            connector_version_infra_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectionConnectorVersionInfraConfigArgs', 'ConnectionConnectorVersionInfraConfigArgsDict']]]]] = None,
            connector_version_launch_stage: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destination_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectionDestinationConfigArgs', 'ConnectionDestinationConfigArgsDict']]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            eventing_config: Optional[pulumi.Input[Union['ConnectionEventingConfigArgs', 'ConnectionEventingConfigArgsDict']]] = None,
            eventing_enablement_type: Optional[pulumi.Input[_builtins.str]] = None,
            eventing_runtime_datas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectionEventingRuntimeDataArgs', 'ConnectionEventingRuntimeDataArgsDict']]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            lock_config: Optional[pulumi.Input[Union['ConnectionLockConfigArgs', 'ConnectionLockConfigArgsDict']]] = None,
            log_config: Optional[pulumi.Input[Union['ConnectionLogConfigArgs', 'ConnectionLogConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            node_config: Optional[pulumi.Input[Union['ConnectionNodeConfigArgs', 'ConnectionNodeConfigArgsDict']]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            service_account: Optional[pulumi.Input[_builtins.str]] = None,
            service_directory: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_config: Optional[pulumi.Input[Union['ConnectionSslConfigArgs', 'ConnectionSslConfigArgsDict']]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectionStatusArgs', 'ConnectionStatusArgsDict']]]]] = None,
            subscription_type: Optional[pulumi.Input[_builtins.str]] = None,
            suspended: Optional[pulumi.Input[_builtins.bool]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'Connection':
        """
        Get an existing Connection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConnectionAuthConfigArgs', 'ConnectionAuthConfigArgsDict']] auth_config: authConfig for the connection.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConnectionConfigVariableArgs', 'ConnectionConfigVariableArgsDict']]]] config_variables: Config Variables for the connection.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] connection_revision: Connection revision. This field is only updated when the connection is created or updated by User.
        :param pulumi.Input[_builtins.str] connector_version: connectorVersion of the Connector.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConnectionConnectorVersionInfraConfigArgs', 'ConnectionConnectorVersionInfraConfigArgsDict']]]] connector_version_infra_configs: This configuration provides infra configs like rate limit threshold which need to be configurable for every connector version.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] connector_version_launch_stage: Flag to mark the version indicating the launch stage.
        :param pulumi.Input[_builtins.str] create_time: Time the Namespace was created in UTC.
        :param pulumi.Input[_builtins.str] description: An arbitrary description for the Connection.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConnectionDestinationConfigArgs', 'ConnectionDestinationConfigArgsDict']]]] destination_configs: Define the Connectors target endpoint.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Union['ConnectionEventingConfigArgs', 'ConnectionEventingConfigArgsDict']] eventing_config: Eventing Configuration of a connection
               Structure is documented below.
        :param pulumi.Input[_builtins.str] eventing_enablement_type: Eventing enablement type. Will be nil if eventing is not enabled.
               Possible values are: `EVENTING_AND_CONNECTION`, `ONLY_EVENTING`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConnectionEventingRuntimeDataArgs', 'ConnectionEventingRuntimeDataArgsDict']]]] eventing_runtime_datas: Eventing Runtime Data.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Resource labels to represent user provided metadata.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Location in which Connection needs to be created.
        :param pulumi.Input[Union['ConnectionLockConfigArgs', 'ConnectionLockConfigArgsDict']] lock_config: Determines whether or no a connection is locked. If locked, a reason must be specified.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionLogConfigArgs', 'ConnectionLogConfigArgsDict']] log_config: Log configuration for the connection.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of Connection needs to be created.
        :param pulumi.Input[Union['ConnectionNodeConfigArgs', 'ConnectionNodeConfigArgsDict']] node_config: Node configuration for the connection.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] service_account: Service account needed for runtime plane to access Google Cloud resources.
        :param pulumi.Input[_builtins.str] service_directory: The name of the Service Directory service name. Used for Private Harpoon to resolve the ILB address.
               e.g. "projects/cloud-connectors-e2e-testing/locations/us-central1/namespaces/istio-system/services/istio-ingressgateway-connectors"
        :param pulumi.Input[Union['ConnectionSslConfigArgs', 'ConnectionSslConfigArgsDict']] ssl_config: SSL Configuration of a connection
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConnectionStatusArgs', 'ConnectionStatusArgsDict']]]] statuses: (Output)
               Current status of eventing.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] subscription_type: This subscription type enum states the subscription type of the project.
        :param pulumi.Input[_builtins.bool] suspended: Suspended indicates if a user has suspended a connection or not.
        :param pulumi.Input[_builtins.str] update_time: Time the Namespace was updated in UTC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionState.__new__(_ConnectionState)

        __props__.__dict__["auth_config"] = auth_config
        __props__.__dict__["config_variables"] = config_variables
        __props__.__dict__["connection_revision"] = connection_revision
        __props__.__dict__["connector_version"] = connector_version
        __props__.__dict__["connector_version_infra_configs"] = connector_version_infra_configs
        __props__.__dict__["connector_version_launch_stage"] = connector_version_launch_stage
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["destination_configs"] = destination_configs
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["eventing_config"] = eventing_config
        __props__.__dict__["eventing_enablement_type"] = eventing_enablement_type
        __props__.__dict__["eventing_runtime_datas"] = eventing_runtime_datas
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["lock_config"] = lock_config
        __props__.__dict__["log_config"] = log_config
        __props__.__dict__["name"] = name
        __props__.__dict__["node_config"] = node_config
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["service_account"] = service_account
        __props__.__dict__["service_directory"] = service_directory
        __props__.__dict__["ssl_config"] = ssl_config
        __props__.__dict__["statuses"] = statuses
        __props__.__dict__["subscription_type"] = subscription_type
        __props__.__dict__["suspended"] = suspended
        __props__.__dict__["update_time"] = update_time
        return Connection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authConfig")
    def auth_config(self) -> pulumi.Output[Optional['outputs.ConnectionAuthConfig']]:
        """
        authConfig for the connection.
        Structure is documented below.
        """
        return pulumi.get(self, "auth_config")

    @_builtins.property
    @pulumi.getter(name="configVariables")
    def config_variables(self) -> pulumi.Output[Optional[Sequence['outputs.ConnectionConfigVariable']]]:
        """
        Config Variables for the connection.
        Structure is documented below.
        """
        return pulumi.get(self, "config_variables")

    @_builtins.property
    @pulumi.getter(name="connectionRevision")
    def connection_revision(self) -> pulumi.Output[_builtins.str]:
        """
        Connection revision. This field is only updated when the connection is created or updated by User.
        """
        return pulumi.get(self, "connection_revision")

    @_builtins.property
    @pulumi.getter(name="connectorVersion")
    def connector_version(self) -> pulumi.Output[_builtins.str]:
        """
        connectorVersion of the Connector.
        """
        return pulumi.get(self, "connector_version")

    @_builtins.property
    @pulumi.getter(name="connectorVersionInfraConfigs")
    def connector_version_infra_configs(self) -> pulumi.Output[Sequence['outputs.ConnectionConnectorVersionInfraConfig']]:
        """
        This configuration provides infra configs like rate limit threshold which need to be configurable for every connector version.
        Structure is documented below.
        """
        return pulumi.get(self, "connector_version_infra_configs")

    @_builtins.property
    @pulumi.getter(name="connectorVersionLaunchStage")
    def connector_version_launch_stage(self) -> pulumi.Output[_builtins.str]:
        """
        Flag to mark the version indicating the launch stage.
        """
        return pulumi.get(self, "connector_version_launch_stage")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time the Namespace was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An arbitrary description for the Connection.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationConfigs")
    def destination_configs(self) -> pulumi.Output[Optional[Sequence['outputs.ConnectionDestinationConfig']]]:
        """
        Define the Connectors target endpoint.
        Structure is documented below.
        """
        return pulumi.get(self, "destination_configs")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="eventingConfig")
    def eventing_config(self) -> pulumi.Output[Optional['outputs.ConnectionEventingConfig']]:
        """
        Eventing Configuration of a connection
        Structure is documented below.
        """
        return pulumi.get(self, "eventing_config")

    @_builtins.property
    @pulumi.getter(name="eventingEnablementType")
    def eventing_enablement_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Eventing enablement type. Will be nil if eventing is not enabled.
        Possible values are: `EVENTING_AND_CONNECTION`, `ONLY_EVENTING`.
        """
        return pulumi.get(self, "eventing_enablement_type")

    @_builtins.property
    @pulumi.getter(name="eventingRuntimeDatas")
    def eventing_runtime_datas(self) -> pulumi.Output[Sequence['outputs.ConnectionEventingRuntimeData']]:
        """
        Eventing Runtime Data.
        Structure is documented below.
        """
        return pulumi.get(self, "eventing_runtime_datas")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Resource labels to represent user provided metadata.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Location in which Connection needs to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="lockConfig")
    def lock_config(self) -> pulumi.Output[Optional['outputs.ConnectionLockConfig']]:
        """
        Determines whether or no a connection is locked. If locked, a reason must be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "lock_config")

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> pulumi.Output[Optional['outputs.ConnectionLogConfig']]:
        """
        Log configuration for the connection.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of Connection needs to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> pulumi.Output['outputs.ConnectionNodeConfig']:
        """
        Node configuration for the connection.
        Structure is documented below.
        """
        return pulumi.get(self, "node_config")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output[_builtins.str]:
        """
        Service account needed for runtime plane to access Google Cloud resources.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter(name="serviceDirectory")
    def service_directory(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Service Directory service name. Used for Private Harpoon to resolve the ILB address.
        e.g. "projects/cloud-connectors-e2e-testing/locations/us-central1/namespaces/istio-system/services/istio-ingressgateway-connectors"
        """
        return pulumi.get(self, "service_directory")

    @_builtins.property
    @pulumi.getter(name="sslConfig")
    def ssl_config(self) -> pulumi.Output[Optional['outputs.ConnectionSslConfig']]:
        """
        SSL Configuration of a connection
        Structure is documented below.
        """
        return pulumi.get(self, "ssl_config")

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence['outputs.ConnectionStatus']]:
        """
        (Output)
        Current status of eventing.
        Structure is documented below.
        """
        return pulumi.get(self, "statuses")

    @_builtins.property
    @pulumi.getter(name="subscriptionType")
    def subscription_type(self) -> pulumi.Output[_builtins.str]:
        """
        This subscription type enum states the subscription type of the project.
        """
        return pulumi.get(self, "subscription_type")

    @_builtins.property
    @pulumi.getter
    def suspended(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Suspended indicates if a user has suspended a connection or not.
        """
        return pulumi.get(self, "suspended")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time the Namespace was updated in UTC.
        """
        return pulumi.get(self, "update_time")

