# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetKMSSecretCiphertextResult',
    'AwaitableGetKMSSecretCiphertextResult',
    'get_kms_secret_ciphertext',
    'get_kms_secret_ciphertext_output',
]

@pulumi.output_type
class GetKMSSecretCiphertextResult:
    """
    A collection of values returned by getKMSSecretCiphertext.
    """
    def __init__(__self__, ciphertext=None, crypto_key=None, id=None, plaintext=None):
        if ciphertext and not isinstance(ciphertext, str):
            raise TypeError("Expected argument 'ciphertext' to be a str")
        pulumi.set(__self__, "ciphertext", ciphertext)
        if crypto_key and not isinstance(crypto_key, str):
            raise TypeError("Expected argument 'crypto_key' to be a str")
        pulumi.set(__self__, "crypto_key", crypto_key)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if plaintext and not isinstance(plaintext, str):
            raise TypeError("Expected argument 'plaintext' to be a str")
        pulumi.set(__self__, "plaintext", plaintext)

    @_builtins.property
    @pulumi.getter
    def ciphertext(self) -> _builtins.str:
        """
        Contains the result of encrypting the provided plaintext, encoded in base64.
        """
        return pulumi.get(self, "ciphertext")

    @_builtins.property
    @pulumi.getter(name="cryptoKey")
    def crypto_key(self) -> _builtins.str:
        return pulumi.get(self, "crypto_key")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def plaintext(self) -> _builtins.str:
        return pulumi.get(self, "plaintext")


class AwaitableGetKMSSecretCiphertextResult(GetKMSSecretCiphertextResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKMSSecretCiphertextResult(
            ciphertext=self.ciphertext,
            crypto_key=self.crypto_key,
            id=self.id,
            plaintext=self.plaintext)


def get_kms_secret_ciphertext(crypto_key: Optional[_builtins.str] = None,
                              plaintext: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKMSSecretCiphertextResult:
    """
    !> **Warning:** This data source is deprecated. Use the `kms.SecretCiphertext` **resource** instead.

    This data source allows you to encrypt data with Google Cloud KMS and use the
    ciphertext within your resource definitions.

    For more information see
    [the official documentation](https://cloud.google.com/kms/docs/encrypt-decrypt).

    > **NOTE:** Using this data source will allow you to conceal secret data within your
    resource definitions, but it does not take care of protecting that data in the
    logging output, plan output, or state output.  Please take care to secure your secret
    data outside of resource definitions.

    ## Example Usage

    First, create a KMS KeyRing and CryptoKey using the resource definitions:

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_key_ring = gcp.kms.KeyRing("my_key_ring",
        project="my-project",
        name="my-key-ring",
        location="us-central1")
    my_crypto_key = gcp.kms.CryptoKey("my_crypto_key",
        name="my-crypto-key",
        key_ring=my_key_ring.id)
    ```

    Next, encrypt some sensitive information and use the encrypted data in your resource definitions:

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_password = gcp.kms.get_kms_secret_ciphertext(crypto_key=my_crypto_key["id"],
        plaintext="my-secret-password")
    instance = gcp.compute.Instance("instance",
        network_interfaces=[{
            "access_configs": [{}],
            "network": "default",
        }],
        name="test",
        machine_type="e2-medium",
        zone="us-central1-a",
        boot_disk={
            "initialize_params": {
                "image": "debian-cloud/debian-11",
            },
        },
        metadata={
            "password": my_password.ciphertext,
        })
    ```

    The resulting instance can then access the encrypted password from its metadata
    and decrypt it, e.g. using the [Cloud SDK](https://cloud.google.com/sdk/gcloud/reference/kms/decrypt)):


    :param _builtins.str crypto_key: The id of the CryptoKey that will be used to
           encrypt the provided plaintext. This is represented by the format
           `{projectId}/{location}/{keyRingName}/{cryptoKeyName}`.
    :param _builtins.str plaintext: The plaintext to be encrypted
    """
    __args__ = dict()
    __args__['cryptoKey'] = crypto_key
    __args__['plaintext'] = plaintext
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:kms/getKMSSecretCiphertext:getKMSSecretCiphertext', __args__, opts=opts, typ=GetKMSSecretCiphertextResult).value

    return AwaitableGetKMSSecretCiphertextResult(
        ciphertext=pulumi.get(__ret__, 'ciphertext'),
        crypto_key=pulumi.get(__ret__, 'crypto_key'),
        id=pulumi.get(__ret__, 'id'),
        plaintext=pulumi.get(__ret__, 'plaintext'))
def get_kms_secret_ciphertext_output(crypto_key: Optional[pulumi.Input[_builtins.str]] = None,
                                     plaintext: Optional[pulumi.Input[_builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKMSSecretCiphertextResult]:
    """
    !> **Warning:** This data source is deprecated. Use the `kms.SecretCiphertext` **resource** instead.

    This data source allows you to encrypt data with Google Cloud KMS and use the
    ciphertext within your resource definitions.

    For more information see
    [the official documentation](https://cloud.google.com/kms/docs/encrypt-decrypt).

    > **NOTE:** Using this data source will allow you to conceal secret data within your
    resource definitions, but it does not take care of protecting that data in the
    logging output, plan output, or state output.  Please take care to secure your secret
    data outside of resource definitions.

    ## Example Usage

    First, create a KMS KeyRing and CryptoKey using the resource definitions:

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_key_ring = gcp.kms.KeyRing("my_key_ring",
        project="my-project",
        name="my-key-ring",
        location="us-central1")
    my_crypto_key = gcp.kms.CryptoKey("my_crypto_key",
        name="my-crypto-key",
        key_ring=my_key_ring.id)
    ```

    Next, encrypt some sensitive information and use the encrypted data in your resource definitions:

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_password = gcp.kms.get_kms_secret_ciphertext(crypto_key=my_crypto_key["id"],
        plaintext="my-secret-password")
    instance = gcp.compute.Instance("instance",
        network_interfaces=[{
            "access_configs": [{}],
            "network": "default",
        }],
        name="test",
        machine_type="e2-medium",
        zone="us-central1-a",
        boot_disk={
            "initialize_params": {
                "image": "debian-cloud/debian-11",
            },
        },
        metadata={
            "password": my_password.ciphertext,
        })
    ```

    The resulting instance can then access the encrypted password from its metadata
    and decrypt it, e.g. using the [Cloud SDK](https://cloud.google.com/sdk/gcloud/reference/kms/decrypt)):


    :param _builtins.str crypto_key: The id of the CryptoKey that will be used to
           encrypt the provided plaintext. This is represented by the format
           `{projectId}/{location}/{keyRingName}/{cryptoKeyName}`.
    :param _builtins.str plaintext: The plaintext to be encrypted
    """
    __args__ = dict()
    __args__['cryptoKey'] = crypto_key
    __args__['plaintext'] = plaintext
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:kms/getKMSSecretCiphertext:getKMSSecretCiphertext', __args__, opts=opts, typ=GetKMSSecretCiphertextResult)
    return __ret__.apply(lambda __response__: GetKMSSecretCiphertextResult(
        ciphertext=pulumi.get(__response__, 'ciphertext'),
        crypto_key=pulumi.get(__response__, 'crypto_key'),
        id=pulumi.get(__response__, 'id'),
        plaintext=pulumi.get(__response__, 'plaintext')))
