# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetIstioCanonicalServiceResult',
    'AwaitableGetIstioCanonicalServiceResult',
    'get_istio_canonical_service',
    'get_istio_canonical_service_output',
]

@pulumi.output_type
class GetIstioCanonicalServiceResult:
    """
    A collection of values returned by getIstioCanonicalService.
    """
    def __init__(__self__, canonical_service=None, canonical_service_namespace=None, display_name=None, id=None, mesh_uid=None, name=None, project=None, service_id=None, telemetries=None, user_labels=None):
        if canonical_service and not isinstance(canonical_service, str):
            raise TypeError("Expected argument 'canonical_service' to be a str")
        pulumi.set(__self__, "canonical_service", canonical_service)
        if canonical_service_namespace and not isinstance(canonical_service_namespace, str):
            raise TypeError("Expected argument 'canonical_service_namespace' to be a str")
        pulumi.set(__self__, "canonical_service_namespace", canonical_service_namespace)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if mesh_uid and not isinstance(mesh_uid, str):
            raise TypeError("Expected argument 'mesh_uid' to be a str")
        pulumi.set(__self__, "mesh_uid", mesh_uid)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if service_id and not isinstance(service_id, str):
            raise TypeError("Expected argument 'service_id' to be a str")
        pulumi.set(__self__, "service_id", service_id)
        if telemetries and not isinstance(telemetries, list):
            raise TypeError("Expected argument 'telemetries' to be a list")
        pulumi.set(__self__, "telemetries", telemetries)
        if user_labels and not isinstance(user_labels, dict):
            raise TypeError("Expected argument 'user_labels' to be a dict")
        pulumi.set(__self__, "user_labels", user_labels)

    @_builtins.property
    @pulumi.getter(name="canonicalService")
    def canonical_service(self) -> _builtins.str:
        return pulumi.get(self, "canonical_service")

    @_builtins.property
    @pulumi.getter(name="canonicalServiceNamespace")
    def canonical_service_namespace(self) -> _builtins.str:
        return pulumi.get(self, "canonical_service_namespace")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Name used for UI elements listing this (Monitoring) Service.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="meshUid")
    def mesh_uid(self) -> _builtins.str:
        return pulumi.get(self, "mesh_uid")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The full REST resource name for this channel. The syntax is:
        `projects/[PROJECT_ID]/services/[SERVICE_ID]`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> _builtins.str:
        return pulumi.get(self, "service_id")

    @_builtins.property
    @pulumi.getter
    def telemetries(self) -> Sequence['outputs.GetIstioCanonicalServiceTelemetryResult']:
        """
        Configuration for how to query telemetry on the Service. Structure is documented below.
        """
        return pulumi.get(self, "telemetries")

    @_builtins.property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "user_labels")


class AwaitableGetIstioCanonicalServiceResult(GetIstioCanonicalServiceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIstioCanonicalServiceResult(
            canonical_service=self.canonical_service,
            canonical_service_namespace=self.canonical_service_namespace,
            display_name=self.display_name,
            id=self.id,
            mesh_uid=self.mesh_uid,
            name=self.name,
            project=self.project,
            service_id=self.service_id,
            telemetries=self.telemetries,
            user_labels=self.user_labels)


def get_istio_canonical_service(canonical_service: Optional[_builtins.str] = None,
                                canonical_service_namespace: Optional[_builtins.str] = None,
                                mesh_uid: Optional[_builtins.str] = None,
                                project: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIstioCanonicalServiceResult:
    """
    A Monitoring Service is the root resource under which operational aspects of a
    generic service are accessible. A service is some discrete, autonomous, and
    network-accessible unit, designed to solve an individual concern

    A monitoring Istio Canonical Service is automatically created by GCP to monitor
    Istio Canonical Services.

    To get more information about Service, see:

    * [API documentation](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/services)
    * How-to Guides
        * [Service Monitoring](https://cloud.google.com/monitoring/service-monitoring)
        * [Monitoring API Documentation](https://cloud.google.com/monitoring/api/v3/)

    ## Example Usage

    ### Monitoring Istio Canonical Service

    ```python
    import pulumi
    import pulumi_gcp as gcp

    # Monitors the default MeshIstio service
    default = gcp.monitoring.get_istio_canonical_service(mesh_uid="proj-573164786102",
        canonical_service_namespace="istio-system",
        canonical_service="prometheus")
    ```


    :param _builtins.str canonical_service: The name of the canonical service underlying this service.
           Corresponds to the destination_canonical_service_name metric label in label in Istio metrics.
           
           - - -
           
           Other optional fields include:
    :param _builtins.str canonical_service_namespace: The namespace of the canonical service underlying this service.
           Corresponds to the destination_canonical_service_namespace metric label in Istio metrics.
    :param _builtins.str mesh_uid: Identifier for the mesh in which this Istio service is defined.
           Corresponds to the meshUid metric label in Istio metrics.
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['canonicalService'] = canonical_service
    __args__['canonicalServiceNamespace'] = canonical_service_namespace
    __args__['meshUid'] = mesh_uid
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:monitoring/getIstioCanonicalService:getIstioCanonicalService', __args__, opts=opts, typ=GetIstioCanonicalServiceResult).value

    return AwaitableGetIstioCanonicalServiceResult(
        canonical_service=pulumi.get(__ret__, 'canonical_service'),
        canonical_service_namespace=pulumi.get(__ret__, 'canonical_service_namespace'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        mesh_uid=pulumi.get(__ret__, 'mesh_uid'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        service_id=pulumi.get(__ret__, 'service_id'),
        telemetries=pulumi.get(__ret__, 'telemetries'),
        user_labels=pulumi.get(__ret__, 'user_labels'))
def get_istio_canonical_service_output(canonical_service: Optional[pulumi.Input[_builtins.str]] = None,
                                       canonical_service_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                                       mesh_uid: Optional[pulumi.Input[_builtins.str]] = None,
                                       project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIstioCanonicalServiceResult]:
    """
    A Monitoring Service is the root resource under which operational aspects of a
    generic service are accessible. A service is some discrete, autonomous, and
    network-accessible unit, designed to solve an individual concern

    A monitoring Istio Canonical Service is automatically created by GCP to monitor
    Istio Canonical Services.

    To get more information about Service, see:

    * [API documentation](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/services)
    * How-to Guides
        * [Service Monitoring](https://cloud.google.com/monitoring/service-monitoring)
        * [Monitoring API Documentation](https://cloud.google.com/monitoring/api/v3/)

    ## Example Usage

    ### Monitoring Istio Canonical Service

    ```python
    import pulumi
    import pulumi_gcp as gcp

    # Monitors the default MeshIstio service
    default = gcp.monitoring.get_istio_canonical_service(mesh_uid="proj-573164786102",
        canonical_service_namespace="istio-system",
        canonical_service="prometheus")
    ```


    :param _builtins.str canonical_service: The name of the canonical service underlying this service.
           Corresponds to the destination_canonical_service_name metric label in label in Istio metrics.
           
           - - -
           
           Other optional fields include:
    :param _builtins.str canonical_service_namespace: The namespace of the canonical service underlying this service.
           Corresponds to the destination_canonical_service_namespace metric label in Istio metrics.
    :param _builtins.str mesh_uid: Identifier for the mesh in which this Istio service is defined.
           Corresponds to the meshUid metric label in Istio metrics.
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['canonicalService'] = canonical_service
    __args__['canonicalServiceNamespace'] = canonical_service_namespace
    __args__['meshUid'] = mesh_uid
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:monitoring/getIstioCanonicalService:getIstioCanonicalService', __args__, opts=opts, typ=GetIstioCanonicalServiceResult)
    return __ret__.apply(lambda __response__: GetIstioCanonicalServiceResult(
        canonical_service=pulumi.get(__response__, 'canonical_service'),
        canonical_service_namespace=pulumi.get(__response__, 'canonical_service_namespace'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        mesh_uid=pulumi.get(__response__, 'mesh_uid'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        service_id=pulumi.get(__response__, 'service_id'),
        telemetries=pulumi.get(__response__, 'telemetries'),
        user_labels=pulumi.get(__response__, 'user_labels')))
