# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RegionalEndpointArgs', 'RegionalEndpoint']

@pulumi.input_type
class RegionalEndpointArgs:
    def __init__(__self__, *,
                 access_type: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 target_google_api: pulumi.Input[_builtins.str],
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 subnetwork: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RegionalEndpoint resource.
        :param pulumi.Input[_builtins.str] access_type: The access type of this regional endpoint. This field is reflected in the PSC Forwarding Rule configuration to enable global access.
               Possible values are: `GLOBAL`, `REGIONAL`.
        :param pulumi.Input[_builtins.str] location: The location of the RegionalEndpoint.
        :param pulumi.Input[_builtins.str] target_google_api: The service endpoint this private regional endpoint connects to. Format: `{apiname}.{region}.rep.googleapis.com` Example: \\"cloudkms.us-central1.rep.googleapis.com\\".
        :param pulumi.Input[_builtins.str] address: The IP Address of the Regional Endpoint. When no address is provided, an IP from the subnetwork is allocated. Use one of the following formats: * IPv4 address as in `10.0.0.1` * Address resource URI as in `projects/{project}/regions/{region}/addresses/{address_name}`
               > **Note:** This field accepts both a reference to a Compute Address resource, which is the resource name of which format is given in the description, and IP literal value. If the user chooses to input a reserved address value; they need to make sure that the reserved address is in IPv4 version, its purpose is GCE_ENDPOINT, its type is INTERNAL and its status is RESERVED. If the user chooses to input an IP literal, they need to make sure that it's a valid IPv4 address (x.x.x.x) within the subnetwork.
        :param pulumi.Input[_builtins.str] description: A description of this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-defined labels.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The name of the RegionalEndpoint.
        :param pulumi.Input[_builtins.str] network: The name of the VPC network for this private regional endpoint. Format: `projects/{project}/global/networks/{network}`
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] subnetwork: The name of the subnetwork from which the IP address will be allocated. Format: `projects/{project}/regions/{region}/subnetworks/{subnetwork}`
        """
        pulumi.set(__self__, "access_type", access_type)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "target_google_api", target_google_api)
        if address is not None:
            pulumi.set(__self__, "address", address)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> pulumi.Input[_builtins.str]:
        """
        The access type of this regional endpoint. This field is reflected in the PSC Forwarding Rule configuration to enable global access.
        Possible values are: `GLOBAL`, `REGIONAL`.
        """
        return pulumi.get(self, "access_type")

    @access_type.setter
    def access_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_type", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location of the RegionalEndpoint.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="targetGoogleApi")
    def target_google_api(self) -> pulumi.Input[_builtins.str]:
        """
        The service endpoint this private regional endpoint connects to. Format: `{apiname}.{region}.rep.googleapis.com` Example: \\"cloudkms.us-central1.rep.googleapis.com\\".
        """
        return pulumi.get(self, "target_google_api")

    @target_google_api.setter
    def target_google_api(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_google_api", value)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP Address of the Regional Endpoint. When no address is provided, an IP from the subnetwork is allocated. Use one of the following formats: * IPv4 address as in `10.0.0.1` * Address resource URI as in `projects/{project}/regions/{region}/addresses/{address_name}`
        > **Note:** This field accepts both a reference to a Compute Address resource, which is the resource name of which format is given in the description, and IP literal value. If the user chooses to input a reserved address value; they need to make sure that the reserved address is in IPv4 version, its purpose is GCE_ENDPOINT, its type is INTERNAL and its status is RESERVED. If the user chooses to input an IP literal, they need to make sure that it's a valid IPv4 address (x.x.x.x) within the subnetwork.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User-defined labels.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the RegionalEndpoint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the VPC network for this private regional endpoint. Format: `projects/{project}/global/networks/{network}`
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the subnetwork from which the IP address will be allocated. Format: `projects/{project}/regions/{region}/subnetworks/{subnetwork}`
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnetwork", value)


@pulumi.input_type
class _RegionalEndpointState:
    def __init__(__self__, *,
                 access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 psc_forwarding_rule: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 subnetwork: Optional[pulumi.Input[_builtins.str]] = None,
                 target_google_api: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RegionalEndpoint resources.
        :param pulumi.Input[_builtins.str] access_type: The access type of this regional endpoint. This field is reflected in the PSC Forwarding Rule configuration to enable global access.
               Possible values are: `GLOBAL`, `REGIONAL`.
        :param pulumi.Input[_builtins.str] address: The IP Address of the Regional Endpoint. When no address is provided, an IP from the subnetwork is allocated. Use one of the following formats: * IPv4 address as in `10.0.0.1` * Address resource URI as in `projects/{project}/regions/{region}/addresses/{address_name}`
               > **Note:** This field accepts both a reference to a Compute Address resource, which is the resource name of which format is given in the description, and IP literal value. If the user chooses to input a reserved address value; they need to make sure that the reserved address is in IPv4 version, its purpose is GCE_ENDPOINT, its type is INTERNAL and its status is RESERVED. If the user chooses to input an IP literal, they need to make sure that it's a valid IPv4 address (x.x.x.x) within the subnetwork.
        :param pulumi.Input[_builtins.str] create_time: Time when the RegionalEndpoint was created.
        :param pulumi.Input[_builtins.str] description: A description of this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-defined labels.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location of the RegionalEndpoint.
        :param pulumi.Input[_builtins.str] name: The name of the RegionalEndpoint.
        :param pulumi.Input[_builtins.str] network: The name of the VPC network for this private regional endpoint. Format: `projects/{project}/global/networks/{network}`
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] psc_forwarding_rule: The resource reference of the PSC Forwarding Rule created on behalf of the customer. Format: `//compute.googleapis.com/projects/{project}/regions/{region}/forwardingRules/{forwarding_rule_name}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] subnetwork: The name of the subnetwork from which the IP address will be allocated. Format: `projects/{project}/regions/{region}/subnetworks/{subnetwork}`
        :param pulumi.Input[_builtins.str] target_google_api: The service endpoint this private regional endpoint connects to. Format: `{apiname}.{region}.rep.googleapis.com` Example: \\"cloudkms.us-central1.rep.googleapis.com\\".
        :param pulumi.Input[_builtins.str] update_time: Time when the RegionalEndpoint was updated.
        """
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if address is not None:
            pulumi.set(__self__, "address", address)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if psc_forwarding_rule is not None:
            pulumi.set(__self__, "psc_forwarding_rule", psc_forwarding_rule)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if target_google_api is not None:
            pulumi.set(__self__, "target_google_api", target_google_api)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access type of this regional endpoint. This field is reflected in the PSC Forwarding Rule configuration to enable global access.
        Possible values are: `GLOBAL`, `REGIONAL`.
        """
        return pulumi.get(self, "access_type")

    @access_type.setter
    def access_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_type", value)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP Address of the Regional Endpoint. When no address is provided, an IP from the subnetwork is allocated. Use one of the following formats: * IPv4 address as in `10.0.0.1` * Address resource URI as in `projects/{project}/regions/{region}/addresses/{address_name}`
        > **Note:** This field accepts both a reference to a Compute Address resource, which is the resource name of which format is given in the description, and IP literal value. If the user chooses to input a reserved address value; they need to make sure that the reserved address is in IPv4 version, its purpose is GCE_ENDPOINT, its type is INTERNAL and its status is RESERVED. If the user chooses to input an IP literal, they need to make sure that it's a valid IPv4 address (x.x.x.x) within the subnetwork.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time when the RegionalEndpoint was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User-defined labels.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the RegionalEndpoint.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the RegionalEndpoint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the VPC network for this private regional endpoint. Format: `projects/{project}/global/networks/{network}`
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pscForwardingRule")
    def psc_forwarding_rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource reference of the PSC Forwarding Rule created on behalf of the customer. Format: `//compute.googleapis.com/projects/{project}/regions/{region}/forwardingRules/{forwarding_rule_name}`
        """
        return pulumi.get(self, "psc_forwarding_rule")

    @psc_forwarding_rule.setter
    def psc_forwarding_rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "psc_forwarding_rule", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the subnetwork from which the IP address will be allocated. Format: `projects/{project}/regions/{region}/subnetworks/{subnetwork}`
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnetwork", value)

    @_builtins.property
    @pulumi.getter(name="targetGoogleApi")
    def target_google_api(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service endpoint this private regional endpoint connects to. Format: `{apiname}.{region}.rep.googleapis.com` Example: \\"cloudkms.us-central1.rep.googleapis.com\\".
        """
        return pulumi.get(self, "target_google_api")

    @target_google_api.setter
    def target_google_api(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_google_api", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time when the RegionalEndpoint was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:networkconnectivity/regionalEndpoint:RegionalEndpoint")
class RegionalEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 subnetwork: Optional[pulumi.Input[_builtins.str]] = None,
                 target_google_api: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Regional Private Service Connect (PSC) endpoint resource.

        To get more information about RegionalEndpoint, see:

        * [API documentation](https://cloud.google.com/network-connectivity/docs/reference/networkconnectivity/rest/v1/projects.locations.regionalEndpoints)
        * How-to Guides
            * [Access regional Google APIs through endpoints](https://cloud.google.com/vpc/docs/access-regional-google-apis-endpoints)

        ## Example Usage

        ### Network Connectivity Regional Endpoint Regional Access

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_network = gcp.compute.Network("my_network",
            name="my-network",
            auto_create_subnetworks=False)
        my_subnetwork = gcp.compute.Subnetwork("my_subnetwork",
            name="my-subnetwork",
            ip_cidr_range="192.168.0.0/24",
            region="us-central1",
            network=my_network.id)
        default = gcp.networkconnectivity.RegionalEndpoint("default",
            name="my-rep",
            location="us-central1",
            target_google_api="storage.us-central1.rep.googleapis.com",
            access_type="REGIONAL",
            address="192.168.0.5",
            network=my_network.id,
            subnetwork=my_subnetwork.id,
            description="My RegionalEndpoint targeting Google API storage.us-central1.rep.googleapis.com",
            labels={
                "env": "default",
            })
        ```
        ### Network Connectivity Regional Endpoint Global Access

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_network = gcp.compute.Network("my_network",
            name="my-network",
            auto_create_subnetworks=False)
        my_subnetwork = gcp.compute.Subnetwork("my_subnetwork",
            name="my-subnetwork",
            ip_cidr_range="192.168.0.0/24",
            region="us-central1",
            network=my_network.id)
        default = gcp.networkconnectivity.RegionalEndpoint("default",
            name="my-rep",
            location="us-central1",
            target_google_api="storage.us-central1.rep.googleapis.com",
            access_type="GLOBAL",
            address="192.168.0.4",
            network=my_network.id,
            subnetwork=my_subnetwork.id)
        ```

        ## Import

        RegionalEndpoint can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/regionalEndpoints/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, RegionalEndpoint can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkconnectivity/regionalEndpoint:RegionalEndpoint default projects/{{project}}/locations/{{location}}/regionalEndpoints/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkconnectivity/regionalEndpoint:RegionalEndpoint default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkconnectivity/regionalEndpoint:RegionalEndpoint default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_type: The access type of this regional endpoint. This field is reflected in the PSC Forwarding Rule configuration to enable global access.
               Possible values are: `GLOBAL`, `REGIONAL`.
        :param pulumi.Input[_builtins.str] address: The IP Address of the Regional Endpoint. When no address is provided, an IP from the subnetwork is allocated. Use one of the following formats: * IPv4 address as in `10.0.0.1` * Address resource URI as in `projects/{project}/regions/{region}/addresses/{address_name}`
               > **Note:** This field accepts both a reference to a Compute Address resource, which is the resource name of which format is given in the description, and IP literal value. If the user chooses to input a reserved address value; they need to make sure that the reserved address is in IPv4 version, its purpose is GCE_ENDPOINT, its type is INTERNAL and its status is RESERVED. If the user chooses to input an IP literal, they need to make sure that it's a valid IPv4 address (x.x.x.x) within the subnetwork.
        :param pulumi.Input[_builtins.str] description: A description of this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-defined labels.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location of the RegionalEndpoint.
        :param pulumi.Input[_builtins.str] name: The name of the RegionalEndpoint.
        :param pulumi.Input[_builtins.str] network: The name of the VPC network for this private regional endpoint. Format: `projects/{project}/global/networks/{network}`
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] subnetwork: The name of the subnetwork from which the IP address will be allocated. Format: `projects/{project}/regions/{region}/subnetworks/{subnetwork}`
        :param pulumi.Input[_builtins.str] target_google_api: The service endpoint this private regional endpoint connects to. Format: `{apiname}.{region}.rep.googleapis.com` Example: \\"cloudkms.us-central1.rep.googleapis.com\\".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegionalEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Regional Private Service Connect (PSC) endpoint resource.

        To get more information about RegionalEndpoint, see:

        * [API documentation](https://cloud.google.com/network-connectivity/docs/reference/networkconnectivity/rest/v1/projects.locations.regionalEndpoints)
        * How-to Guides
            * [Access regional Google APIs through endpoints](https://cloud.google.com/vpc/docs/access-regional-google-apis-endpoints)

        ## Example Usage

        ### Network Connectivity Regional Endpoint Regional Access

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_network = gcp.compute.Network("my_network",
            name="my-network",
            auto_create_subnetworks=False)
        my_subnetwork = gcp.compute.Subnetwork("my_subnetwork",
            name="my-subnetwork",
            ip_cidr_range="192.168.0.0/24",
            region="us-central1",
            network=my_network.id)
        default = gcp.networkconnectivity.RegionalEndpoint("default",
            name="my-rep",
            location="us-central1",
            target_google_api="storage.us-central1.rep.googleapis.com",
            access_type="REGIONAL",
            address="192.168.0.5",
            network=my_network.id,
            subnetwork=my_subnetwork.id,
            description="My RegionalEndpoint targeting Google API storage.us-central1.rep.googleapis.com",
            labels={
                "env": "default",
            })
        ```
        ### Network Connectivity Regional Endpoint Global Access

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_network = gcp.compute.Network("my_network",
            name="my-network",
            auto_create_subnetworks=False)
        my_subnetwork = gcp.compute.Subnetwork("my_subnetwork",
            name="my-subnetwork",
            ip_cidr_range="192.168.0.0/24",
            region="us-central1",
            network=my_network.id)
        default = gcp.networkconnectivity.RegionalEndpoint("default",
            name="my-rep",
            location="us-central1",
            target_google_api="storage.us-central1.rep.googleapis.com",
            access_type="GLOBAL",
            address="192.168.0.4",
            network=my_network.id,
            subnetwork=my_subnetwork.id)
        ```

        ## Import

        RegionalEndpoint can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/regionalEndpoints/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, RegionalEndpoint can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkconnectivity/regionalEndpoint:RegionalEndpoint default projects/{{project}}/locations/{{location}}/regionalEndpoints/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkconnectivity/regionalEndpoint:RegionalEndpoint default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkconnectivity/regionalEndpoint:RegionalEndpoint default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param RegionalEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegionalEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 subnetwork: Optional[pulumi.Input[_builtins.str]] = None,
                 target_google_api: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegionalEndpointArgs.__new__(RegionalEndpointArgs)

            if access_type is None and not opts.urn:
                raise TypeError("Missing required property 'access_type'")
            __props__.__dict__["access_type"] = access_type
            __props__.__dict__["address"] = address
            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["network"] = network
            __props__.__dict__["project"] = project
            __props__.__dict__["subnetwork"] = subnetwork
            if target_google_api is None and not opts.urn:
                raise TypeError("Missing required property 'target_google_api'")
            __props__.__dict__["target_google_api"] = target_google_api
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["psc_forwarding_rule"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(RegionalEndpoint, __self__).__init__(
            'gcp:networkconnectivity/regionalEndpoint:RegionalEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_type: Optional[pulumi.Input[_builtins.str]] = None,
            address: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            psc_forwarding_rule: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            subnetwork: Optional[pulumi.Input[_builtins.str]] = None,
            target_google_api: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'RegionalEndpoint':
        """
        Get an existing RegionalEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_type: The access type of this regional endpoint. This field is reflected in the PSC Forwarding Rule configuration to enable global access.
               Possible values are: `GLOBAL`, `REGIONAL`.
        :param pulumi.Input[_builtins.str] address: The IP Address of the Regional Endpoint. When no address is provided, an IP from the subnetwork is allocated. Use one of the following formats: * IPv4 address as in `10.0.0.1` * Address resource URI as in `projects/{project}/regions/{region}/addresses/{address_name}`
               > **Note:** This field accepts both a reference to a Compute Address resource, which is the resource name of which format is given in the description, and IP literal value. If the user chooses to input a reserved address value; they need to make sure that the reserved address is in IPv4 version, its purpose is GCE_ENDPOINT, its type is INTERNAL and its status is RESERVED. If the user chooses to input an IP literal, they need to make sure that it's a valid IPv4 address (x.x.x.x) within the subnetwork.
        :param pulumi.Input[_builtins.str] create_time: Time when the RegionalEndpoint was created.
        :param pulumi.Input[_builtins.str] description: A description of this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-defined labels.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location of the RegionalEndpoint.
        :param pulumi.Input[_builtins.str] name: The name of the RegionalEndpoint.
        :param pulumi.Input[_builtins.str] network: The name of the VPC network for this private regional endpoint. Format: `projects/{project}/global/networks/{network}`
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] psc_forwarding_rule: The resource reference of the PSC Forwarding Rule created on behalf of the customer. Format: `//compute.googleapis.com/projects/{project}/regions/{region}/forwardingRules/{forwarding_rule_name}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] subnetwork: The name of the subnetwork from which the IP address will be allocated. Format: `projects/{project}/regions/{region}/subnetworks/{subnetwork}`
        :param pulumi.Input[_builtins.str] target_google_api: The service endpoint this private regional endpoint connects to. Format: `{apiname}.{region}.rep.googleapis.com` Example: \\"cloudkms.us-central1.rep.googleapis.com\\".
        :param pulumi.Input[_builtins.str] update_time: Time when the RegionalEndpoint was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegionalEndpointState.__new__(_RegionalEndpointState)

        __props__.__dict__["access_type"] = access_type
        __props__.__dict__["address"] = address
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["project"] = project
        __props__.__dict__["psc_forwarding_rule"] = psc_forwarding_rule
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["subnetwork"] = subnetwork
        __props__.__dict__["target_google_api"] = target_google_api
        __props__.__dict__["update_time"] = update_time
        return RegionalEndpoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> pulumi.Output[_builtins.str]:
        """
        The access type of this regional endpoint. This field is reflected in the PSC Forwarding Rule configuration to enable global access.
        Possible values are: `GLOBAL`, `REGIONAL`.
        """
        return pulumi.get(self, "access_type")

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Output[_builtins.str]:
        """
        The IP Address of the Regional Endpoint. When no address is provided, an IP from the subnetwork is allocated. Use one of the following formats: * IPv4 address as in `10.0.0.1` * Address resource URI as in `projects/{project}/regions/{region}/addresses/{address_name}`
        > **Note:** This field accepts both a reference to a Compute Address resource, which is the resource name of which format is given in the description, and IP literal value. If the user chooses to input a reserved address value; they need to make sure that the reserved address is in IPv4 version, its purpose is GCE_ENDPOINT, its type is INTERNAL and its status is RESERVED. If the user chooses to input an IP literal, they need to make sure that it's a valid IPv4 address (x.x.x.x) within the subnetwork.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time when the RegionalEndpoint was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description of this resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        User-defined labels.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location of the RegionalEndpoint.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the RegionalEndpoint.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the VPC network for this private regional endpoint. Format: `projects/{project}/global/networks/{network}`
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pscForwardingRule")
    def psc_forwarding_rule(self) -> pulumi.Output[_builtins.str]:
        """
        The resource reference of the PSC Forwarding Rule created on behalf of the customer. Format: `//compute.googleapis.com/projects/{project}/regions/{region}/forwardingRules/{forwarding_rule_name}`
        """
        return pulumi.get(self, "psc_forwarding_rule")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def subnetwork(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the subnetwork from which the IP address will be allocated. Format: `projects/{project}/regions/{region}/subnetworks/{subnetwork}`
        """
        return pulumi.get(self, "subnetwork")

    @_builtins.property
    @pulumi.getter(name="targetGoogleApi")
    def target_google_api(self) -> pulumi.Output[_builtins.str]:
        """
        The service endpoint this private regional endpoint connects to. Format: `{apiname}.{region}.rep.googleapis.com` Example: \\"cloudkms.us-central1.rep.googleapis.com\\".
        """
        return pulumi.get(self, "target_google_api")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time when the RegionalEndpoint was updated.
        """
        return pulumi.get(self, "update_time")

