# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MirroringDeploymentGroupArgs', 'MirroringDeploymentGroup']

@pulumi.input_type
class MirroringDeploymentGroupArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 mirroring_deployment_group_id: pulumi.Input[_builtins.str],
                 network: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MirroringDeploymentGroup resource.
        :param pulumi.Input[_builtins.str] location: The cloud location of the deployment group, currently restricted to `global`.
        :param pulumi.Input[_builtins.str] mirroring_deployment_group_id: The ID to use for the new deployment group, which will become the final
               component of the deployment group's resource name.
        :param pulumi.Input[_builtins.str] network: The network that will be used for all child deployments, for example:
               `projects/{project}/global/networks/{network}`.
               See https://google.aip.dev/124.
        :param pulumi.Input[_builtins.str] description: User-provided description of the deployment group.
               Used as additional context for the deployment group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are key/value pairs that help to organize and filter resources.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "mirroring_deployment_group_id", mirroring_deployment_group_id)
        pulumi.set(__self__, "network", network)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The cloud location of the deployment group, currently restricted to `global`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="mirroringDeploymentGroupId")
    def mirroring_deployment_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID to use for the new deployment group, which will become the final
        component of the deployment group's resource name.
        """
        return pulumi.get(self, "mirroring_deployment_group_id")

    @mirroring_deployment_group_id.setter
    def mirroring_deployment_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "mirroring_deployment_group_id", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Input[_builtins.str]:
        """
        The network that will be used for all child deployments, for example:
        `projects/{project}/global/networks/{network}`.
        See https://google.aip.dev/124.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-provided description of the deployment group.
        Used as additional context for the deployment group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels are key/value pairs that help to organize and filter resources.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _MirroringDeploymentGroupState:
    def __init__(__self__, *,
                 connected_endpoint_groups: Optional[pulumi.Input[Sequence[pulumi.Input['MirroringDeploymentGroupConnectedEndpointGroupArgs']]]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input['MirroringDeploymentGroupLocationArgs']]]] = None,
                 mirroring_deployment_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 reconciling: Optional[pulumi.Input[_builtins.bool]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MirroringDeploymentGroup resources.
        :param pulumi.Input[Sequence[pulumi.Input['MirroringDeploymentGroupConnectedEndpointGroupArgs']]] connected_endpoint_groups: The list of endpoint groups that are connected to this resource.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: The timestamp when the resource was created.
               See https://google.aip.dev/148#timestamps.
        :param pulumi.Input[_builtins.str] description: User-provided description of the deployment group.
               Used as additional context for the deployment group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are key/value pairs that help to organize and filter resources.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The cloud location of the deployment group, currently restricted to `global`.
        :param pulumi.Input[Sequence[pulumi.Input['MirroringDeploymentGroupLocationArgs']]] locations: The list of locations where the deployment group is present.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] mirroring_deployment_group_id: The ID to use for the new deployment group, which will become the final
               component of the deployment group's resource name.
        :param pulumi.Input[_builtins.str] name: (Output)
               The connected endpoint group's resource name, for example:
               `projects/123456789/locations/global/mirroringEndpointGroups/my-eg`.
               See https://google.aip.dev/124.
        :param pulumi.Input[_builtins.str] network: The network that will be used for all child deployments, for example:
               `projects/{project}/global/networks/{network}`.
               See https://google.aip.dev/124.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.bool] reconciling: The current state of the resource does not match the user's intended state,
               and the system is working to reconcile them. This is part of the normal
               operation (e.g. adding a new deployment to the group)
               See https://google.aip.dev/128.
        :param pulumi.Input[_builtins.str] state: (Output)
               The current state of the association in this location.
               Possible values:
               STATE_UNSPECIFIED
               ACTIVE
               OUT_OF_SYNC
        :param pulumi.Input[_builtins.str] update_time: The timestamp when the resource was most recently updated.
               See https://google.aip.dev/148#timestamps.
        """
        if connected_endpoint_groups is not None:
            pulumi.set(__self__, "connected_endpoint_groups", connected_endpoint_groups)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if mirroring_deployment_group_id is not None:
            pulumi.set(__self__, "mirroring_deployment_group_id", mirroring_deployment_group_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="connectedEndpointGroups")
    def connected_endpoint_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MirroringDeploymentGroupConnectedEndpointGroupArgs']]]]:
        """
        The list of endpoint groups that are connected to this resource.
        Structure is documented below.
        """
        return pulumi.get(self, "connected_endpoint_groups")

    @connected_endpoint_groups.setter
    def connected_endpoint_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MirroringDeploymentGroupConnectedEndpointGroupArgs']]]]):
        pulumi.set(self, "connected_endpoint_groups", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp when the resource was created.
        See https://google.aip.dev/148#timestamps.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-provided description of the deployment group.
        Used as additional context for the deployment group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels are key/value pairs that help to organize and filter resources.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cloud location of the deployment group, currently restricted to `global`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MirroringDeploymentGroupLocationArgs']]]]:
        """
        The list of locations where the deployment group is present.
        Structure is documented below.
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MirroringDeploymentGroupLocationArgs']]]]):
        pulumi.set(self, "locations", value)

    @_builtins.property
    @pulumi.getter(name="mirroringDeploymentGroupId")
    def mirroring_deployment_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID to use for the new deployment group, which will become the final
        component of the deployment group's resource name.
        """
        return pulumi.get(self, "mirroring_deployment_group_id")

    @mirroring_deployment_group_id.setter
    def mirroring_deployment_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mirroring_deployment_group_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        The connected endpoint group's resource name, for example:
        `projects/123456789/locations/global/mirroringEndpointGroups/my-eg`.
        See https://google.aip.dev/124.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network that will be used for all child deployments, for example:
        `projects/{project}/global/networks/{network}`.
        See https://google.aip.dev/124.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The current state of the resource does not match the user's intended state,
        and the system is working to reconcile them. This is part of the normal
        operation (e.g. adding a new deployment to the group)
        See https://google.aip.dev/128.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reconciling", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        The current state of the association in this location.
        Possible values:
        STATE_UNSPECIFIED
        ACTIVE
        OUT_OF_SYNC
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp when the resource was most recently updated.
        See https://google.aip.dev/148#timestamps.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:networksecurity/mirroringDeploymentGroup:MirroringDeploymentGroup")
class MirroringDeploymentGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 mirroring_deployment_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A deployment group aggregates many zonal mirroring backends (deployments)
        into a single global mirroring service. Consumers can connect this service
        using an endpoint group.

        To get more information about MirroringDeploymentGroup, see:

        * [API documentation](https://cloud.google.com/network-security-integration/docs/reference/rest/v1/projects.locations.mirroringDeploymentGroups)
        * How-to Guides
            * [Mirroring deployment group overview](https://cloud.google.com/network-security-integration/docs/out-of-band/deployment-groups-overview)

        ## Example Usage

        ### Network Security Mirroring Deployment Group Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            name="example-network",
            auto_create_subnetworks=False)
        default = gcp.networksecurity.MirroringDeploymentGroup("default",
            mirroring_deployment_group_id="example-dg",
            location="global",
            network=network.id,
            description="some description",
            labels={
                "foo": "bar",
            })
        ```

        ## Import

        MirroringDeploymentGroup can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/mirroringDeploymentGroups/{{mirroring_deployment_group_id}}`

        * `{{project}}/{{location}}/{{mirroring_deployment_group_id}}`

        * `{{location}}/{{mirroring_deployment_group_id}}`

        When using the `pulumi import` command, MirroringDeploymentGroup can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networksecurity/mirroringDeploymentGroup:MirroringDeploymentGroup default projects/{{project}}/locations/{{location}}/mirroringDeploymentGroups/{{mirroring_deployment_group_id}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/mirroringDeploymentGroup:MirroringDeploymentGroup default {{project}}/{{location}}/{{mirroring_deployment_group_id}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/mirroringDeploymentGroup:MirroringDeploymentGroup default {{location}}/{{mirroring_deployment_group_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: User-provided description of the deployment group.
               Used as additional context for the deployment group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are key/value pairs that help to organize and filter resources.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The cloud location of the deployment group, currently restricted to `global`.
        :param pulumi.Input[_builtins.str] mirroring_deployment_group_id: The ID to use for the new deployment group, which will become the final
               component of the deployment group's resource name.
        :param pulumi.Input[_builtins.str] network: The network that will be used for all child deployments, for example:
               `projects/{project}/global/networks/{network}`.
               See https://google.aip.dev/124.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MirroringDeploymentGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A deployment group aggregates many zonal mirroring backends (deployments)
        into a single global mirroring service. Consumers can connect this service
        using an endpoint group.

        To get more information about MirroringDeploymentGroup, see:

        * [API documentation](https://cloud.google.com/network-security-integration/docs/reference/rest/v1/projects.locations.mirroringDeploymentGroups)
        * How-to Guides
            * [Mirroring deployment group overview](https://cloud.google.com/network-security-integration/docs/out-of-band/deployment-groups-overview)

        ## Example Usage

        ### Network Security Mirroring Deployment Group Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            name="example-network",
            auto_create_subnetworks=False)
        default = gcp.networksecurity.MirroringDeploymentGroup("default",
            mirroring_deployment_group_id="example-dg",
            location="global",
            network=network.id,
            description="some description",
            labels={
                "foo": "bar",
            })
        ```

        ## Import

        MirroringDeploymentGroup can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/mirroringDeploymentGroups/{{mirroring_deployment_group_id}}`

        * `{{project}}/{{location}}/{{mirroring_deployment_group_id}}`

        * `{{location}}/{{mirroring_deployment_group_id}}`

        When using the `pulumi import` command, MirroringDeploymentGroup can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networksecurity/mirroringDeploymentGroup:MirroringDeploymentGroup default projects/{{project}}/locations/{{location}}/mirroringDeploymentGroups/{{mirroring_deployment_group_id}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/mirroringDeploymentGroup:MirroringDeploymentGroup default {{project}}/{{location}}/{{mirroring_deployment_group_id}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/mirroringDeploymentGroup:MirroringDeploymentGroup default {{location}}/{{mirroring_deployment_group_id}}
        ```

        :param str resource_name: The name of the resource.
        :param MirroringDeploymentGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MirroringDeploymentGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 mirroring_deployment_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MirroringDeploymentGroupArgs.__new__(MirroringDeploymentGroupArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if mirroring_deployment_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'mirroring_deployment_group_id'")
            __props__.__dict__["mirroring_deployment_group_id"] = mirroring_deployment_group_id
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            __props__.__dict__["project"] = project
            __props__.__dict__["connected_endpoint_groups"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["locations"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(MirroringDeploymentGroup, __self__).__init__(
            'gcp:networksecurity/mirroringDeploymentGroup:MirroringDeploymentGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connected_endpoint_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MirroringDeploymentGroupConnectedEndpointGroupArgs', 'MirroringDeploymentGroupConnectedEndpointGroupArgsDict']]]]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MirroringDeploymentGroupLocationArgs', 'MirroringDeploymentGroupLocationArgsDict']]]]] = None,
            mirroring_deployment_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            reconciling: Optional[pulumi.Input[_builtins.bool]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'MirroringDeploymentGroup':
        """
        Get an existing MirroringDeploymentGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MirroringDeploymentGroupConnectedEndpointGroupArgs', 'MirroringDeploymentGroupConnectedEndpointGroupArgsDict']]]] connected_endpoint_groups: The list of endpoint groups that are connected to this resource.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: The timestamp when the resource was created.
               See https://google.aip.dev/148#timestamps.
        :param pulumi.Input[_builtins.str] description: User-provided description of the deployment group.
               Used as additional context for the deployment group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are key/value pairs that help to organize and filter resources.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The cloud location of the deployment group, currently restricted to `global`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MirroringDeploymentGroupLocationArgs', 'MirroringDeploymentGroupLocationArgsDict']]]] locations: The list of locations where the deployment group is present.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] mirroring_deployment_group_id: The ID to use for the new deployment group, which will become the final
               component of the deployment group's resource name.
        :param pulumi.Input[_builtins.str] name: (Output)
               The connected endpoint group's resource name, for example:
               `projects/123456789/locations/global/mirroringEndpointGroups/my-eg`.
               See https://google.aip.dev/124.
        :param pulumi.Input[_builtins.str] network: The network that will be used for all child deployments, for example:
               `projects/{project}/global/networks/{network}`.
               See https://google.aip.dev/124.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.bool] reconciling: The current state of the resource does not match the user's intended state,
               and the system is working to reconcile them. This is part of the normal
               operation (e.g. adding a new deployment to the group)
               See https://google.aip.dev/128.
        :param pulumi.Input[_builtins.str] state: (Output)
               The current state of the association in this location.
               Possible values:
               STATE_UNSPECIFIED
               ACTIVE
               OUT_OF_SYNC
        :param pulumi.Input[_builtins.str] update_time: The timestamp when the resource was most recently updated.
               See https://google.aip.dev/148#timestamps.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MirroringDeploymentGroupState.__new__(_MirroringDeploymentGroupState)

        __props__.__dict__["connected_endpoint_groups"] = connected_endpoint_groups
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["locations"] = locations
        __props__.__dict__["mirroring_deployment_group_id"] = mirroring_deployment_group_id
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["state"] = state
        __props__.__dict__["update_time"] = update_time
        return MirroringDeploymentGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="connectedEndpointGroups")
    def connected_endpoint_groups(self) -> pulumi.Output[Sequence['outputs.MirroringDeploymentGroupConnectedEndpointGroup']]:
        """
        The list of endpoint groups that are connected to this resource.
        Structure is documented below.
        """
        return pulumi.get(self, "connected_endpoint_groups")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp when the resource was created.
        See https://google.aip.dev/148#timestamps.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User-provided description of the deployment group.
        Used as additional context for the deployment group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Labels are key/value pairs that help to organize and filter resources.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The cloud location of the deployment group, currently restricted to `global`.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def locations(self) -> pulumi.Output[Sequence['outputs.MirroringDeploymentGroupLocation']]:
        """
        The list of locations where the deployment group is present.
        Structure is documented below.
        """
        return pulumi.get(self, "locations")

    @_builtins.property
    @pulumi.getter(name="mirroringDeploymentGroupId")
    def mirroring_deployment_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID to use for the new deployment group, which will become the final
        component of the deployment group's resource name.
        """
        return pulumi.get(self, "mirroring_deployment_group_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        (Output)
        The connected endpoint group's resource name, for example:
        `projects/123456789/locations/global/mirroringEndpointGroups/my-eg`.
        See https://google.aip.dev/124.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output[_builtins.str]:
        """
        The network that will be used for all child deployments, for example:
        `projects/{project}/global/networks/{network}`.
        See https://google.aip.dev/124.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[_builtins.bool]:
        """
        The current state of the resource does not match the user's intended state,
        and the system is working to reconcile them. This is part of the normal
        operation (e.g. adding a new deployment to the group)
        See https://google.aip.dev/128.
        """
        return pulumi.get(self, "reconciling")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        (Output)
        The current state of the association in this location.
        Possible values:
        STATE_UNSPECIFIED
        ACTIVE
        OUT_OF_SYNC
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp when the resource was most recently updated.
        See https://google.aip.dev/148#timestamps.
        """
        return pulumi.get(self, "update_time")

