# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EdgeCacheServiceArgs', 'EdgeCacheService']

@pulumi.input_type
class EdgeCacheServiceArgs:
    def __init__(__self__, *,
                 routing: pulumi.Input['EdgeCacheServiceRoutingArgs'],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_http2: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_quic: Optional[pulumi.Input[_builtins.bool]] = None,
                 edge_security_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_ssl_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 log_config: Optional[pulumi.Input['EdgeCacheServiceLogConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 require_tls: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssl_policy: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EdgeCacheService resource.
        :param pulumi.Input['EdgeCacheServiceRoutingArgs'] routing: Defines how requests are routed, modified, cached and/or which origin content is filled from.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: A human-readable description of the resource.
        :param pulumi.Input[_builtins.bool] disable_http2: Disables HTTP/2.
               HTTP/2 (h2) is enabled by default and recommended for performance. HTTP/2 improves connection re-use and reduces connection setup overhead by sending multiple streams over the same connection.
               Some legacy HTTP clients may have issues with HTTP/2 connections due to broken HTTP/2 implementations. Setting this to true will prevent HTTP/2 from being advertised and negotiated.
        :param pulumi.Input[_builtins.bool] disable_quic: HTTP/3 (IETF QUIC) and Google QUIC are enabled by default.
        :param pulumi.Input[_builtins.str] edge_security_policy: Resource URL that points at the Cloud Armor edge security policy that is applied on each request against the EdgeCacheService.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] edge_ssl_certificates: URLs to sslCertificate resources that are used to authenticate connections between users and the EdgeCacheService.
               Note that only "global" certificates with a "scope" of "EDGE_CACHE" can be attached to an EdgeCacheService.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of label tags associated with the EdgeCache resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input['EdgeCacheServiceLogConfigArgs'] log_config: Specifies the logging options for the traffic served by this service. If logging is enabled, logs will be exported to Cloud Logging.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of the resource; provided by the client when the resource is created.
               The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
               and all following characters must be a dash, underscore, letter or digit.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.bool] require_tls: Require TLS (HTTPS) for all clients connecting to this service.
               Clients who connect over HTTP (port 80) will receive a HTTP 301 to the same URL over HTTPS (port 443).
               You must have at least one (1) edgeSslCertificate specified to enable this.
        :param pulumi.Input[_builtins.str] ssl_policy: URL of the SslPolicy resource that will be associated with the EdgeCacheService.
               If not set, the EdgeCacheService has no SSL policy configured, and will default to the "COMPATIBLE" policy.
        """
        pulumi.set(__self__, "routing", routing)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_http2 is not None:
            pulumi.set(__self__, "disable_http2", disable_http2)
        if disable_quic is not None:
            pulumi.set(__self__, "disable_quic", disable_quic)
        if edge_security_policy is not None:
            pulumi.set(__self__, "edge_security_policy", edge_security_policy)
        if edge_ssl_certificates is not None:
            pulumi.set(__self__, "edge_ssl_certificates", edge_ssl_certificates)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if require_tls is not None:
            pulumi.set(__self__, "require_tls", require_tls)
        if ssl_policy is not None:
            pulumi.set(__self__, "ssl_policy", ssl_policy)

    @_builtins.property
    @pulumi.getter
    def routing(self) -> pulumi.Input['EdgeCacheServiceRoutingArgs']:
        """
        Defines how requests are routed, modified, cached and/or which origin content is filled from.
        Structure is documented below.
        """
        return pulumi.get(self, "routing")

    @routing.setter
    def routing(self, value: pulumi.Input['EdgeCacheServiceRoutingArgs']):
        pulumi.set(self, "routing", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableHttp2")
    def disable_http2(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disables HTTP/2.
        HTTP/2 (h2) is enabled by default and recommended for performance. HTTP/2 improves connection re-use and reduces connection setup overhead by sending multiple streams over the same connection.
        Some legacy HTTP clients may have issues with HTTP/2 connections due to broken HTTP/2 implementations. Setting this to true will prevent HTTP/2 from being advertised and negotiated.
        """
        return pulumi.get(self, "disable_http2")

    @disable_http2.setter
    def disable_http2(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_http2", value)

    @_builtins.property
    @pulumi.getter(name="disableQuic")
    def disable_quic(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        HTTP/3 (IETF QUIC) and Google QUIC are enabled by default.
        """
        return pulumi.get(self, "disable_quic")

    @disable_quic.setter
    def disable_quic(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_quic", value)

    @_builtins.property
    @pulumi.getter(name="edgeSecurityPolicy")
    def edge_security_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource URL that points at the Cloud Armor edge security policy that is applied on each request against the EdgeCacheService.
        """
        return pulumi.get(self, "edge_security_policy")

    @edge_security_policy.setter
    def edge_security_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_security_policy", value)

    @_builtins.property
    @pulumi.getter(name="edgeSslCertificates")
    def edge_ssl_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        URLs to sslCertificate resources that are used to authenticate connections between users and the EdgeCacheService.
        Note that only "global" certificates with a "scope" of "EDGE_CACHE" can be attached to an EdgeCacheService.
        """
        return pulumi.get(self, "edge_ssl_certificates")

    @edge_ssl_certificates.setter
    def edge_ssl_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "edge_ssl_certificates", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Set of label tags associated with the EdgeCache resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['EdgeCacheServiceLogConfigArgs']]:
        """
        Specifies the logging options for the traffic served by this service. If logging is enabled, logs will be exported to Cloud Logging.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['EdgeCacheServiceLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource; provided by the client when the resource is created.
        The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
        and all following characters must be a dash, underscore, letter or digit.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="requireTls")
    def require_tls(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Require TLS (HTTPS) for all clients connecting to this service.
        Clients who connect over HTTP (port 80) will receive a HTTP 301 to the same URL over HTTPS (port 443).
        You must have at least one (1) edgeSslCertificate specified to enable this.
        """
        return pulumi.get(self, "require_tls")

    @require_tls.setter
    def require_tls(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "require_tls", value)

    @_builtins.property
    @pulumi.getter(name="sslPolicy")
    def ssl_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of the SslPolicy resource that will be associated with the EdgeCacheService.
        If not set, the EdgeCacheService has no SSL policy configured, and will default to the "COMPATIBLE" policy.
        """
        return pulumi.get(self, "ssl_policy")

    @ssl_policy.setter
    def ssl_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_policy", value)


@pulumi.input_type
class _EdgeCacheServiceState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_http2: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_quic: Optional[pulumi.Input[_builtins.bool]] = None,
                 edge_security_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_ssl_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ipv4_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 log_config: Optional[pulumi.Input['EdgeCacheServiceLogConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 require_tls: Optional[pulumi.Input[_builtins.bool]] = None,
                 routing: Optional[pulumi.Input['EdgeCacheServiceRoutingArgs']] = None,
                 ssl_policy: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EdgeCacheService resources.
        :param pulumi.Input[_builtins.str] description: A human-readable description of the resource.
        :param pulumi.Input[_builtins.bool] disable_http2: Disables HTTP/2.
               HTTP/2 (h2) is enabled by default and recommended for performance. HTTP/2 improves connection re-use and reduces connection setup overhead by sending multiple streams over the same connection.
               Some legacy HTTP clients may have issues with HTTP/2 connections due to broken HTTP/2 implementations. Setting this to true will prevent HTTP/2 from being advertised and negotiated.
        :param pulumi.Input[_builtins.bool] disable_quic: HTTP/3 (IETF QUIC) and Google QUIC are enabled by default.
        :param pulumi.Input[_builtins.str] edge_security_policy: Resource URL that points at the Cloud Armor edge security policy that is applied on each request against the EdgeCacheService.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] edge_ssl_certificates: URLs to sslCertificate resources that are used to authenticate connections between users and the EdgeCacheService.
               Note that only "global" certificates with a "scope" of "EDGE_CACHE" can be attached to an EdgeCacheService.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv4_addresses: The IPv4 addresses associated with this service. Addresses are static for the lifetime of the service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv6_addresses: The IPv6 addresses associated with this service. Addresses are static for the lifetime of the service.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of label tags associated with the EdgeCache resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input['EdgeCacheServiceLogConfigArgs'] log_config: Specifies the logging options for the traffic served by this service. If logging is enabled, logs will be exported to Cloud Logging.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of the resource; provided by the client when the resource is created.
               The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
               and all following characters must be a dash, underscore, letter or digit.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.bool] require_tls: Require TLS (HTTPS) for all clients connecting to this service.
               Clients who connect over HTTP (port 80) will receive a HTTP 301 to the same URL over HTTPS (port 443).
               You must have at least one (1) edgeSslCertificate specified to enable this.
        :param pulumi.Input['EdgeCacheServiceRoutingArgs'] routing: Defines how requests are routed, modified, cached and/or which origin content is filled from.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] ssl_policy: URL of the SslPolicy resource that will be associated with the EdgeCacheService.
               If not set, the EdgeCacheService has no SSL policy configured, and will default to the "COMPATIBLE" policy.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_http2 is not None:
            pulumi.set(__self__, "disable_http2", disable_http2)
        if disable_quic is not None:
            pulumi.set(__self__, "disable_quic", disable_quic)
        if edge_security_policy is not None:
            pulumi.set(__self__, "edge_security_policy", edge_security_policy)
        if edge_ssl_certificates is not None:
            pulumi.set(__self__, "edge_ssl_certificates", edge_ssl_certificates)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if ipv4_addresses is not None:
            pulumi.set(__self__, "ipv4_addresses", ipv4_addresses)
        if ipv6_addresses is not None:
            pulumi.set(__self__, "ipv6_addresses", ipv6_addresses)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if require_tls is not None:
            pulumi.set(__self__, "require_tls", require_tls)
        if routing is not None:
            pulumi.set(__self__, "routing", routing)
        if ssl_policy is not None:
            pulumi.set(__self__, "ssl_policy", ssl_policy)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableHttp2")
    def disable_http2(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disables HTTP/2.
        HTTP/2 (h2) is enabled by default and recommended for performance. HTTP/2 improves connection re-use and reduces connection setup overhead by sending multiple streams over the same connection.
        Some legacy HTTP clients may have issues with HTTP/2 connections due to broken HTTP/2 implementations. Setting this to true will prevent HTTP/2 from being advertised and negotiated.
        """
        return pulumi.get(self, "disable_http2")

    @disable_http2.setter
    def disable_http2(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_http2", value)

    @_builtins.property
    @pulumi.getter(name="disableQuic")
    def disable_quic(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        HTTP/3 (IETF QUIC) and Google QUIC are enabled by default.
        """
        return pulumi.get(self, "disable_quic")

    @disable_quic.setter
    def disable_quic(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_quic", value)

    @_builtins.property
    @pulumi.getter(name="edgeSecurityPolicy")
    def edge_security_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource URL that points at the Cloud Armor edge security policy that is applied on each request against the EdgeCacheService.
        """
        return pulumi.get(self, "edge_security_policy")

    @edge_security_policy.setter
    def edge_security_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_security_policy", value)

    @_builtins.property
    @pulumi.getter(name="edgeSslCertificates")
    def edge_ssl_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        URLs to sslCertificate resources that are used to authenticate connections between users and the EdgeCacheService.
        Note that only "global" certificates with a "scope" of "EDGE_CACHE" can be attached to an EdgeCacheService.
        """
        return pulumi.get(self, "edge_ssl_certificates")

    @edge_ssl_certificates.setter
    def edge_ssl_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "edge_ssl_certificates", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="ipv4Addresses")
    def ipv4_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IPv4 addresses associated with this service. Addresses are static for the lifetime of the service.
        """
        return pulumi.get(self, "ipv4_addresses")

    @ipv4_addresses.setter
    def ipv4_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ipv4_addresses", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IPv6 addresses associated with this service. Addresses are static for the lifetime of the service.
        """
        return pulumi.get(self, "ipv6_addresses")

    @ipv6_addresses.setter
    def ipv6_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ipv6_addresses", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Set of label tags associated with the EdgeCache resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['EdgeCacheServiceLogConfigArgs']]:
        """
        Specifies the logging options for the traffic served by this service. If logging is enabled, logs will be exported to Cloud Logging.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['EdgeCacheServiceLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource; provided by the client when the resource is created.
        The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
        and all following characters must be a dash, underscore, letter or digit.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="requireTls")
    def require_tls(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Require TLS (HTTPS) for all clients connecting to this service.
        Clients who connect over HTTP (port 80) will receive a HTTP 301 to the same URL over HTTPS (port 443).
        You must have at least one (1) edgeSslCertificate specified to enable this.
        """
        return pulumi.get(self, "require_tls")

    @require_tls.setter
    def require_tls(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "require_tls", value)

    @_builtins.property
    @pulumi.getter
    def routing(self) -> Optional[pulumi.Input['EdgeCacheServiceRoutingArgs']]:
        """
        Defines how requests are routed, modified, cached and/or which origin content is filled from.
        Structure is documented below.
        """
        return pulumi.get(self, "routing")

    @routing.setter
    def routing(self, value: Optional[pulumi.Input['EdgeCacheServiceRoutingArgs']]):
        pulumi.set(self, "routing", value)

    @_builtins.property
    @pulumi.getter(name="sslPolicy")
    def ssl_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of the SslPolicy resource that will be associated with the EdgeCacheService.
        If not set, the EdgeCacheService has no SSL policy configured, and will default to the "COMPATIBLE" policy.
        """
        return pulumi.get(self, "ssl_policy")

    @ssl_policy.setter
    def ssl_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_policy", value)


@pulumi.type_token("gcp:networkservices/edgeCacheService:EdgeCacheService")
class EdgeCacheService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_http2: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_quic: Optional[pulumi.Input[_builtins.bool]] = None,
                 edge_security_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_ssl_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 log_config: Optional[pulumi.Input[Union['EdgeCacheServiceLogConfigArgs', 'EdgeCacheServiceLogConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 require_tls: Optional[pulumi.Input[_builtins.bool]] = None,
                 routing: Optional[pulumi.Input[Union['EdgeCacheServiceRoutingArgs', 'EdgeCacheServiceRoutingArgsDict']]] = None,
                 ssl_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        EdgeCacheService defines the IP addresses, protocols, security policies, cache policies and routing configuration.

        > **Warning:** These resources require allow-listing to use, and are not openly available to all Cloud customers. Engage with your Cloud account team to discuss how to onboard.

        ## Example Usage

        ### Network Services Edge Cache Service Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        dest = gcp.storage.Bucket("dest",
            name="my-bucket",
            location="US",
            force_destroy=True)
        instance = gcp.networkservices.EdgeCacheOrigin("instance",
            name="my-origin",
            origin_address=dest.url,
            description="The default bucket for media edge test",
            max_attempts=2,
            timeout={
                "connect_timeout": "10s",
            })
        instance_edge_cache_service = gcp.networkservices.EdgeCacheService("instance",
            name="my-service",
            description="some description",
            routing={
                "host_rules": [{
                    "description": "host rule description",
                    "hosts": ["sslcert.tf-test.club"],
                    "path_matcher": "routes",
                }],
                "path_matchers": [{
                    "name": "routes",
                    "route_rules": [{
                        "description": "a route rule to match against",
                        "priority": "1",
                        "match_rules": [{
                            "prefix_match": "/",
                        }],
                        "origin": instance.name,
                        "route_action": {
                            "cdn_policy": {
                                "cache_mode": "CACHE_ALL_STATIC",
                                "default_ttl": "3600s",
                            },
                        },
                        "header_action": {
                            "response_header_to_adds": [{
                                "header_name": "x-cache-status",
                                "header_value": "{cdn_cache_status}",
                            }],
                        },
                    }],
                }],
            })
        ```
        ### Network Services Edge Cache Service Advanced

        ```python
        import pulumi
        import pulumi_gcp as gcp

        dest = gcp.storage.Bucket("dest",
            name="my-bucket",
            location="US",
            force_destroy=True)
        google = gcp.networkservices.EdgeCacheOrigin("google",
            name="origin-google",
            origin_address="google.com",
            description="The default bucket for media edge test",
            max_attempts=2,
            timeout={
                "connect_timeout": "10s",
            })
        instance = gcp.networkservices.EdgeCacheOrigin("instance",
            name="my-origin",
            origin_address=dest.url,
            description="The default bucket for media edge test",
            max_attempts=2,
            timeout={
                "connect_timeout": "10s",
            })
        instance_edge_cache_service = gcp.networkservices.EdgeCacheService("instance",
            name="my-service",
            description="some description",
            disable_quic=True,
            disable_http2=True,
            labels={
                "a": "b",
            },
            routing={
                "host_rules": [
                    {
                        "description": "host rule description",
                        "hosts": ["sslcert.tf-test.club"],
                        "path_matcher": "routes",
                    },
                    {
                        "description": "host rule2",
                        "hosts": ["sslcert.tf-test2.club"],
                        "path_matcher": "routes",
                    },
                    {
                        "description": "host rule3",
                        "hosts": ["sslcert.tf-test3.club"],
                        "path_matcher": "routesAdvanced",
                    },
                ],
                "path_matchers": [
                    {
                        "name": "routes",
                        "route_rules": [{
                            "description": "a route rule to match against",
                            "priority": "1",
                            "match_rules": [{
                                "prefix_match": "/",
                            }],
                            "origin": instance.name,
                            "route_action": {
                                "cdn_policy": {
                                    "cache_mode": "CACHE_ALL_STATIC",
                                    "default_ttl": "3600s",
                                },
                            },
                            "header_action": {
                                "response_header_to_adds": [{
                                    "header_name": "x-cache-status",
                                    "header_value": "{cdn_cache_status}",
                                }],
                            },
                        }],
                    },
                    {
                        "name": "routesAdvanced",
                        "description": "an advanced ruleset",
                        "route_rules": [
                            {
                                "description": "an advanced route rule to match against",
                                "priority": "1",
                                "match_rules": [
                                    {
                                        "prefix_match": "/potato/",
                                        "query_parameter_matches": [
                                            {
                                                "name": "debug",
                                                "present_match": True,
                                            },
                                            {
                                                "name": "state",
                                                "exact_match": "debug",
                                            },
                                        ],
                                    },
                                    {
                                        "full_path_match": "/apple",
                                    },
                                ],
                                "header_action": {
                                    "request_header_to_adds": [
                                        {
                                            "header_name": "debug",
                                            "header_value": "true",
                                            "replace": True,
                                        },
                                        {
                                            "header_name": "potato",
                                            "header_value": "plant",
                                        },
                                    ],
                                    "response_header_to_adds": [{
                                        "header_name": "potato",
                                        "header_value": "plant",
                                        "replace": True,
                                    }],
                                    "request_header_to_removes": [{
                                        "header_name": "prod",
                                    }],
                                    "response_header_to_removes": [{
                                        "header_name": "prod",
                                    }],
                                },
                                "origin": instance.name,
                                "route_action": {
                                    "cdn_policy": {
                                        "cache_mode": "CACHE_ALL_STATIC",
                                        "default_ttl": "3800s",
                                        "client_ttl": "3600s",
                                        "max_ttl": "9000s",
                                        "cache_key_policy": {
                                            "include_protocol": True,
                                            "exclude_host": True,
                                            "included_query_parameters": [
                                                "apple",
                                                "dev",
                                                "santa",
                                                "claus",
                                            ],
                                            "included_header_names": ["banana"],
                                            "included_cookie_names": ["orange"],
                                        },
                                        "negative_caching": True,
                                        "signed_request_mode": "DISABLED",
                                        "negative_caching_policy": {
                                            "500": "3000s",
                                        },
                                    },
                                    "url_rewrite": {
                                        "path_prefix_rewrite": "/dev",
                                        "host_rewrite": "dev.club",
                                    },
                                    "cors_policy": {
                                        "max_age": "2500s",
                                        "allow_credentials": True,
                                        "allow_origins": ["*"],
                                        "allow_methods": ["GET"],
                                        "allow_headers": ["dev"],
                                        "expose_headers": ["prod"],
                                    },
                                },
                            },
                            {
                                "description": "a second route rule to match against",
                                "priority": "2",
                                "match_rules": [{
                                    "full_path_match": "/yay",
                                }],
                                "origin": instance.name,
                                "route_action": {
                                    "cdn_policy": {
                                        "cache_mode": "CACHE_ALL_STATIC",
                                        "default_ttl": "3600s",
                                        "cache_key_policy": {
                                            "excluded_query_parameters": ["dev"],
                                        },
                                    },
                                    "cors_policy": {
                                        "max_age": "3000s",
                                        "allow_headers": ["dev"],
                                        "disabled": True,
                                    },
                                },
                            },
                        ],
                    },
                ],
            },
            log_config={
                "enable": True,
                "sample_rate": 0.01,
            })
        ```
        ### Network Services Edge Cache Service Dual Token

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret_basic = gcp.secretmanager.Secret("secret-basic",
            secret_id="secret-name",
            replication={
                "auto": {},
            })
        secret_version_basic = gcp.secretmanager.SecretVersion("secret-version-basic",
            secret=secret_basic.id,
            secret_data="secret-data")
        keyset = gcp.networkservices.EdgeCacheKeyset("keyset",
            name="keyset-name",
            description="The default keyset",
            public_keys=[{
                "id": "my-public-key",
                "managed": True,
            }],
            validation_shared_keys=[{
                "secret_version": secret_version_basic.id,
            }])
        instance = gcp.networkservices.EdgeCacheOrigin("instance",
            name="my-origin",
            origin_address="gs://media-edge-default",
            description="The default bucket for media edge test")
        instance_edge_cache_service = gcp.networkservices.EdgeCacheService("instance",
            name="my-service",
            description="some description",
            routing={
                "host_rules": [{
                    "description": "host rule description",
                    "hosts": ["sslcert.tf-test.club"],
                    "path_matcher": "routes",
                }],
                "path_matchers": [{
                    "name": "routes",
                    "route_rules": [
                        {
                            "description": "a route rule to match against master playlist",
                            "priority": "1",
                            "match_rules": [{
                                "path_template_match": "/master.m3u8",
                            }],
                            "origin": instance.name,
                            "route_action": {
                                "cdn_policy": {
                                    "signed_request_mode": "REQUIRE_TOKENS",
                                    "signed_request_keyset": keyset.id,
                                    "signed_token_options": {
                                        "token_query_parameter": "edge-cache-token",
                                    },
                                    "signed_request_maximum_expiration_ttl": "600s",
                                    "add_signatures": {
                                        "actions": "GENERATE_COOKIE",
                                        "keyset": keyset.id,
                                        "copied_parameters": [
                                            "PathGlobs",
                                            "SessionID",
                                        ],
                                    },
                                },
                            },
                        },
                        {
                            "description": "a route rule to match against all playlists",
                            "priority": "2",
                            "match_rules": [{
                                "path_template_match": "/*.m3u8",
                            }],
                            "origin": instance.name,
                            "route_action": {
                                "cdn_policy": {
                                    "signed_request_mode": "REQUIRE_TOKENS",
                                    "signed_request_keyset": keyset.id,
                                    "signed_token_options": {
                                        "token_query_parameter": "hdnts",
                                        "allowed_signature_algorithms": [
                                            "ED25519",
                                            "HMAC_SHA_256",
                                            "HMAC_SHA1",
                                        ],
                                    },
                                    "add_signatures": {
                                        "actions": "GENERATE_TOKEN_HLS_COOKIELESS",
                                        "keyset": keyset.id,
                                        "token_ttl": "1200s",
                                        "token_query_parameter": "hdntl",
                                        "copied_parameters": ["URLPrefix"],
                                    },
                                },
                            },
                        },
                        {
                            "description": "a route rule to match against",
                            "priority": "3",
                            "match_rules": [{
                                "path_template_match": "/**.m3u8",
                            }],
                            "origin": instance.name,
                            "route_action": {
                                "cdn_policy": {
                                    "signed_request_mode": "REQUIRE_TOKENS",
                                    "signed_request_keyset": keyset.id,
                                    "signed_token_options": {
                                        "token_query_parameter": "hdntl",
                                    },
                                    "add_signatures": {
                                        "actions": "PROPAGATE_TOKEN_HLS_COOKIELESS",
                                        "token_query_parameter": "hdntl",
                                    },
                                },
                            },
                        },
                    ],
                }],
            })
        ```

        ## Import

        EdgeCacheService can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/edgeCacheServices/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, EdgeCacheService can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkservices/edgeCacheService:EdgeCacheService default projects/{{project}}/locations/global/edgeCacheServices/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/edgeCacheService:EdgeCacheService default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/edgeCacheService:EdgeCacheService default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A human-readable description of the resource.
        :param pulumi.Input[_builtins.bool] disable_http2: Disables HTTP/2.
               HTTP/2 (h2) is enabled by default and recommended for performance. HTTP/2 improves connection re-use and reduces connection setup overhead by sending multiple streams over the same connection.
               Some legacy HTTP clients may have issues with HTTP/2 connections due to broken HTTP/2 implementations. Setting this to true will prevent HTTP/2 from being advertised and negotiated.
        :param pulumi.Input[_builtins.bool] disable_quic: HTTP/3 (IETF QUIC) and Google QUIC are enabled by default.
        :param pulumi.Input[_builtins.str] edge_security_policy: Resource URL that points at the Cloud Armor edge security policy that is applied on each request against the EdgeCacheService.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] edge_ssl_certificates: URLs to sslCertificate resources that are used to authenticate connections between users and the EdgeCacheService.
               Note that only "global" certificates with a "scope" of "EDGE_CACHE" can be attached to an EdgeCacheService.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of label tags associated with the EdgeCache resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[Union['EdgeCacheServiceLogConfigArgs', 'EdgeCacheServiceLogConfigArgsDict']] log_config: Specifies the logging options for the traffic served by this service. If logging is enabled, logs will be exported to Cloud Logging.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of the resource; provided by the client when the resource is created.
               The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
               and all following characters must be a dash, underscore, letter or digit.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.bool] require_tls: Require TLS (HTTPS) for all clients connecting to this service.
               Clients who connect over HTTP (port 80) will receive a HTTP 301 to the same URL over HTTPS (port 443).
               You must have at least one (1) edgeSslCertificate specified to enable this.
        :param pulumi.Input[Union['EdgeCacheServiceRoutingArgs', 'EdgeCacheServiceRoutingArgsDict']] routing: Defines how requests are routed, modified, cached and/or which origin content is filled from.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] ssl_policy: URL of the SslPolicy resource that will be associated with the EdgeCacheService.
               If not set, the EdgeCacheService has no SSL policy configured, and will default to the "COMPATIBLE" policy.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EdgeCacheServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        EdgeCacheService defines the IP addresses, protocols, security policies, cache policies and routing configuration.

        > **Warning:** These resources require allow-listing to use, and are not openly available to all Cloud customers. Engage with your Cloud account team to discuss how to onboard.

        ## Example Usage

        ### Network Services Edge Cache Service Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        dest = gcp.storage.Bucket("dest",
            name="my-bucket",
            location="US",
            force_destroy=True)
        instance = gcp.networkservices.EdgeCacheOrigin("instance",
            name="my-origin",
            origin_address=dest.url,
            description="The default bucket for media edge test",
            max_attempts=2,
            timeout={
                "connect_timeout": "10s",
            })
        instance_edge_cache_service = gcp.networkservices.EdgeCacheService("instance",
            name="my-service",
            description="some description",
            routing={
                "host_rules": [{
                    "description": "host rule description",
                    "hosts": ["sslcert.tf-test.club"],
                    "path_matcher": "routes",
                }],
                "path_matchers": [{
                    "name": "routes",
                    "route_rules": [{
                        "description": "a route rule to match against",
                        "priority": "1",
                        "match_rules": [{
                            "prefix_match": "/",
                        }],
                        "origin": instance.name,
                        "route_action": {
                            "cdn_policy": {
                                "cache_mode": "CACHE_ALL_STATIC",
                                "default_ttl": "3600s",
                            },
                        },
                        "header_action": {
                            "response_header_to_adds": [{
                                "header_name": "x-cache-status",
                                "header_value": "{cdn_cache_status}",
                            }],
                        },
                    }],
                }],
            })
        ```
        ### Network Services Edge Cache Service Advanced

        ```python
        import pulumi
        import pulumi_gcp as gcp

        dest = gcp.storage.Bucket("dest",
            name="my-bucket",
            location="US",
            force_destroy=True)
        google = gcp.networkservices.EdgeCacheOrigin("google",
            name="origin-google",
            origin_address="google.com",
            description="The default bucket for media edge test",
            max_attempts=2,
            timeout={
                "connect_timeout": "10s",
            })
        instance = gcp.networkservices.EdgeCacheOrigin("instance",
            name="my-origin",
            origin_address=dest.url,
            description="The default bucket for media edge test",
            max_attempts=2,
            timeout={
                "connect_timeout": "10s",
            })
        instance_edge_cache_service = gcp.networkservices.EdgeCacheService("instance",
            name="my-service",
            description="some description",
            disable_quic=True,
            disable_http2=True,
            labels={
                "a": "b",
            },
            routing={
                "host_rules": [
                    {
                        "description": "host rule description",
                        "hosts": ["sslcert.tf-test.club"],
                        "path_matcher": "routes",
                    },
                    {
                        "description": "host rule2",
                        "hosts": ["sslcert.tf-test2.club"],
                        "path_matcher": "routes",
                    },
                    {
                        "description": "host rule3",
                        "hosts": ["sslcert.tf-test3.club"],
                        "path_matcher": "routesAdvanced",
                    },
                ],
                "path_matchers": [
                    {
                        "name": "routes",
                        "route_rules": [{
                            "description": "a route rule to match against",
                            "priority": "1",
                            "match_rules": [{
                                "prefix_match": "/",
                            }],
                            "origin": instance.name,
                            "route_action": {
                                "cdn_policy": {
                                    "cache_mode": "CACHE_ALL_STATIC",
                                    "default_ttl": "3600s",
                                },
                            },
                            "header_action": {
                                "response_header_to_adds": [{
                                    "header_name": "x-cache-status",
                                    "header_value": "{cdn_cache_status}",
                                }],
                            },
                        }],
                    },
                    {
                        "name": "routesAdvanced",
                        "description": "an advanced ruleset",
                        "route_rules": [
                            {
                                "description": "an advanced route rule to match against",
                                "priority": "1",
                                "match_rules": [
                                    {
                                        "prefix_match": "/potato/",
                                        "query_parameter_matches": [
                                            {
                                                "name": "debug",
                                                "present_match": True,
                                            },
                                            {
                                                "name": "state",
                                                "exact_match": "debug",
                                            },
                                        ],
                                    },
                                    {
                                        "full_path_match": "/apple",
                                    },
                                ],
                                "header_action": {
                                    "request_header_to_adds": [
                                        {
                                            "header_name": "debug",
                                            "header_value": "true",
                                            "replace": True,
                                        },
                                        {
                                            "header_name": "potato",
                                            "header_value": "plant",
                                        },
                                    ],
                                    "response_header_to_adds": [{
                                        "header_name": "potato",
                                        "header_value": "plant",
                                        "replace": True,
                                    }],
                                    "request_header_to_removes": [{
                                        "header_name": "prod",
                                    }],
                                    "response_header_to_removes": [{
                                        "header_name": "prod",
                                    }],
                                },
                                "origin": instance.name,
                                "route_action": {
                                    "cdn_policy": {
                                        "cache_mode": "CACHE_ALL_STATIC",
                                        "default_ttl": "3800s",
                                        "client_ttl": "3600s",
                                        "max_ttl": "9000s",
                                        "cache_key_policy": {
                                            "include_protocol": True,
                                            "exclude_host": True,
                                            "included_query_parameters": [
                                                "apple",
                                                "dev",
                                                "santa",
                                                "claus",
                                            ],
                                            "included_header_names": ["banana"],
                                            "included_cookie_names": ["orange"],
                                        },
                                        "negative_caching": True,
                                        "signed_request_mode": "DISABLED",
                                        "negative_caching_policy": {
                                            "500": "3000s",
                                        },
                                    },
                                    "url_rewrite": {
                                        "path_prefix_rewrite": "/dev",
                                        "host_rewrite": "dev.club",
                                    },
                                    "cors_policy": {
                                        "max_age": "2500s",
                                        "allow_credentials": True,
                                        "allow_origins": ["*"],
                                        "allow_methods": ["GET"],
                                        "allow_headers": ["dev"],
                                        "expose_headers": ["prod"],
                                    },
                                },
                            },
                            {
                                "description": "a second route rule to match against",
                                "priority": "2",
                                "match_rules": [{
                                    "full_path_match": "/yay",
                                }],
                                "origin": instance.name,
                                "route_action": {
                                    "cdn_policy": {
                                        "cache_mode": "CACHE_ALL_STATIC",
                                        "default_ttl": "3600s",
                                        "cache_key_policy": {
                                            "excluded_query_parameters": ["dev"],
                                        },
                                    },
                                    "cors_policy": {
                                        "max_age": "3000s",
                                        "allow_headers": ["dev"],
                                        "disabled": True,
                                    },
                                },
                            },
                        ],
                    },
                ],
            },
            log_config={
                "enable": True,
                "sample_rate": 0.01,
            })
        ```
        ### Network Services Edge Cache Service Dual Token

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret_basic = gcp.secretmanager.Secret("secret-basic",
            secret_id="secret-name",
            replication={
                "auto": {},
            })
        secret_version_basic = gcp.secretmanager.SecretVersion("secret-version-basic",
            secret=secret_basic.id,
            secret_data="secret-data")
        keyset = gcp.networkservices.EdgeCacheKeyset("keyset",
            name="keyset-name",
            description="The default keyset",
            public_keys=[{
                "id": "my-public-key",
                "managed": True,
            }],
            validation_shared_keys=[{
                "secret_version": secret_version_basic.id,
            }])
        instance = gcp.networkservices.EdgeCacheOrigin("instance",
            name="my-origin",
            origin_address="gs://media-edge-default",
            description="The default bucket for media edge test")
        instance_edge_cache_service = gcp.networkservices.EdgeCacheService("instance",
            name="my-service",
            description="some description",
            routing={
                "host_rules": [{
                    "description": "host rule description",
                    "hosts": ["sslcert.tf-test.club"],
                    "path_matcher": "routes",
                }],
                "path_matchers": [{
                    "name": "routes",
                    "route_rules": [
                        {
                            "description": "a route rule to match against master playlist",
                            "priority": "1",
                            "match_rules": [{
                                "path_template_match": "/master.m3u8",
                            }],
                            "origin": instance.name,
                            "route_action": {
                                "cdn_policy": {
                                    "signed_request_mode": "REQUIRE_TOKENS",
                                    "signed_request_keyset": keyset.id,
                                    "signed_token_options": {
                                        "token_query_parameter": "edge-cache-token",
                                    },
                                    "signed_request_maximum_expiration_ttl": "600s",
                                    "add_signatures": {
                                        "actions": "GENERATE_COOKIE",
                                        "keyset": keyset.id,
                                        "copied_parameters": [
                                            "PathGlobs",
                                            "SessionID",
                                        ],
                                    },
                                },
                            },
                        },
                        {
                            "description": "a route rule to match against all playlists",
                            "priority": "2",
                            "match_rules": [{
                                "path_template_match": "/*.m3u8",
                            }],
                            "origin": instance.name,
                            "route_action": {
                                "cdn_policy": {
                                    "signed_request_mode": "REQUIRE_TOKENS",
                                    "signed_request_keyset": keyset.id,
                                    "signed_token_options": {
                                        "token_query_parameter": "hdnts",
                                        "allowed_signature_algorithms": [
                                            "ED25519",
                                            "HMAC_SHA_256",
                                            "HMAC_SHA1",
                                        ],
                                    },
                                    "add_signatures": {
                                        "actions": "GENERATE_TOKEN_HLS_COOKIELESS",
                                        "keyset": keyset.id,
                                        "token_ttl": "1200s",
                                        "token_query_parameter": "hdntl",
                                        "copied_parameters": ["URLPrefix"],
                                    },
                                },
                            },
                        },
                        {
                            "description": "a route rule to match against",
                            "priority": "3",
                            "match_rules": [{
                                "path_template_match": "/**.m3u8",
                            }],
                            "origin": instance.name,
                            "route_action": {
                                "cdn_policy": {
                                    "signed_request_mode": "REQUIRE_TOKENS",
                                    "signed_request_keyset": keyset.id,
                                    "signed_token_options": {
                                        "token_query_parameter": "hdntl",
                                    },
                                    "add_signatures": {
                                        "actions": "PROPAGATE_TOKEN_HLS_COOKIELESS",
                                        "token_query_parameter": "hdntl",
                                    },
                                },
                            },
                        },
                    ],
                }],
            })
        ```

        ## Import

        EdgeCacheService can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/edgeCacheServices/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, EdgeCacheService can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkservices/edgeCacheService:EdgeCacheService default projects/{{project}}/locations/global/edgeCacheServices/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/edgeCacheService:EdgeCacheService default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/edgeCacheService:EdgeCacheService default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param EdgeCacheServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EdgeCacheServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_http2: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_quic: Optional[pulumi.Input[_builtins.bool]] = None,
                 edge_security_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_ssl_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 log_config: Optional[pulumi.Input[Union['EdgeCacheServiceLogConfigArgs', 'EdgeCacheServiceLogConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 require_tls: Optional[pulumi.Input[_builtins.bool]] = None,
                 routing: Optional[pulumi.Input[Union['EdgeCacheServiceRoutingArgs', 'EdgeCacheServiceRoutingArgsDict']]] = None,
                 ssl_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EdgeCacheServiceArgs.__new__(EdgeCacheServiceArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["disable_http2"] = disable_http2
            __props__.__dict__["disable_quic"] = disable_quic
            __props__.__dict__["edge_security_policy"] = edge_security_policy
            __props__.__dict__["edge_ssl_certificates"] = edge_ssl_certificates
            __props__.__dict__["labels"] = labels
            __props__.__dict__["log_config"] = log_config
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["require_tls"] = require_tls
            if routing is None and not opts.urn:
                raise TypeError("Missing required property 'routing'")
            __props__.__dict__["routing"] = routing
            __props__.__dict__["ssl_policy"] = ssl_policy
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["ipv4_addresses"] = None
            __props__.__dict__["ipv6_addresses"] = None
            __props__.__dict__["pulumi_labels"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(EdgeCacheService, __self__).__init__(
            'gcp:networkservices/edgeCacheService:EdgeCacheService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disable_http2: Optional[pulumi.Input[_builtins.bool]] = None,
            disable_quic: Optional[pulumi.Input[_builtins.bool]] = None,
            edge_security_policy: Optional[pulumi.Input[_builtins.str]] = None,
            edge_ssl_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            ipv4_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            log_config: Optional[pulumi.Input[Union['EdgeCacheServiceLogConfigArgs', 'EdgeCacheServiceLogConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            require_tls: Optional[pulumi.Input[_builtins.bool]] = None,
            routing: Optional[pulumi.Input[Union['EdgeCacheServiceRoutingArgs', 'EdgeCacheServiceRoutingArgsDict']]] = None,
            ssl_policy: Optional[pulumi.Input[_builtins.str]] = None) -> 'EdgeCacheService':
        """
        Get an existing EdgeCacheService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A human-readable description of the resource.
        :param pulumi.Input[_builtins.bool] disable_http2: Disables HTTP/2.
               HTTP/2 (h2) is enabled by default and recommended for performance. HTTP/2 improves connection re-use and reduces connection setup overhead by sending multiple streams over the same connection.
               Some legacy HTTP clients may have issues with HTTP/2 connections due to broken HTTP/2 implementations. Setting this to true will prevent HTTP/2 from being advertised and negotiated.
        :param pulumi.Input[_builtins.bool] disable_quic: HTTP/3 (IETF QUIC) and Google QUIC are enabled by default.
        :param pulumi.Input[_builtins.str] edge_security_policy: Resource URL that points at the Cloud Armor edge security policy that is applied on each request against the EdgeCacheService.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] edge_ssl_certificates: URLs to sslCertificate resources that are used to authenticate connections between users and the EdgeCacheService.
               Note that only "global" certificates with a "scope" of "EDGE_CACHE" can be attached to an EdgeCacheService.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv4_addresses: The IPv4 addresses associated with this service. Addresses are static for the lifetime of the service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv6_addresses: The IPv6 addresses associated with this service. Addresses are static for the lifetime of the service.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of label tags associated with the EdgeCache resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[Union['EdgeCacheServiceLogConfigArgs', 'EdgeCacheServiceLogConfigArgsDict']] log_config: Specifies the logging options for the traffic served by this service. If logging is enabled, logs will be exported to Cloud Logging.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of the resource; provided by the client when the resource is created.
               The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
               and all following characters must be a dash, underscore, letter or digit.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.bool] require_tls: Require TLS (HTTPS) for all clients connecting to this service.
               Clients who connect over HTTP (port 80) will receive a HTTP 301 to the same URL over HTTPS (port 443).
               You must have at least one (1) edgeSslCertificate specified to enable this.
        :param pulumi.Input[Union['EdgeCacheServiceRoutingArgs', 'EdgeCacheServiceRoutingArgsDict']] routing: Defines how requests are routed, modified, cached and/or which origin content is filled from.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] ssl_policy: URL of the SslPolicy resource that will be associated with the EdgeCacheService.
               If not set, the EdgeCacheService has no SSL policy configured, and will default to the "COMPATIBLE" policy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EdgeCacheServiceState.__new__(_EdgeCacheServiceState)

        __props__.__dict__["description"] = description
        __props__.__dict__["disable_http2"] = disable_http2
        __props__.__dict__["disable_quic"] = disable_quic
        __props__.__dict__["edge_security_policy"] = edge_security_policy
        __props__.__dict__["edge_ssl_certificates"] = edge_ssl_certificates
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["ipv4_addresses"] = ipv4_addresses
        __props__.__dict__["ipv6_addresses"] = ipv6_addresses
        __props__.__dict__["labels"] = labels
        __props__.__dict__["log_config"] = log_config
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["require_tls"] = require_tls
        __props__.__dict__["routing"] = routing
        __props__.__dict__["ssl_policy"] = ssl_policy
        return EdgeCacheService(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disableHttp2")
    def disable_http2(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Disables HTTP/2.
        HTTP/2 (h2) is enabled by default and recommended for performance. HTTP/2 improves connection re-use and reduces connection setup overhead by sending multiple streams over the same connection.
        Some legacy HTTP clients may have issues with HTTP/2 connections due to broken HTTP/2 implementations. Setting this to true will prevent HTTP/2 from being advertised and negotiated.
        """
        return pulumi.get(self, "disable_http2")

    @_builtins.property
    @pulumi.getter(name="disableQuic")
    def disable_quic(self) -> pulumi.Output[_builtins.bool]:
        """
        HTTP/3 (IETF QUIC) and Google QUIC are enabled by default.
        """
        return pulumi.get(self, "disable_quic")

    @_builtins.property
    @pulumi.getter(name="edgeSecurityPolicy")
    def edge_security_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Resource URL that points at the Cloud Armor edge security policy that is applied on each request against the EdgeCacheService.
        """
        return pulumi.get(self, "edge_security_policy")

    @_builtins.property
    @pulumi.getter(name="edgeSslCertificates")
    def edge_ssl_certificates(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        URLs to sslCertificate resources that are used to authenticate connections between users and the EdgeCacheService.
        Note that only "global" certificates with a "scope" of "EDGE_CACHE" can be attached to an EdgeCacheService.
        """
        return pulumi.get(self, "edge_ssl_certificates")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="ipv4Addresses")
    def ipv4_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The IPv4 addresses associated with this service. Addresses are static for the lifetime of the service.
        """
        return pulumi.get(self, "ipv4_addresses")

    @_builtins.property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The IPv6 addresses associated with this service. Addresses are static for the lifetime of the service.
        """
        return pulumi.get(self, "ipv6_addresses")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Set of label tags associated with the EdgeCache resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> pulumi.Output[Optional['outputs.EdgeCacheServiceLogConfig']]:
        """
        Specifies the logging options for the traffic served by this service. If logging is enabled, logs will be exported to Cloud Logging.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the resource; provided by the client when the resource is created.
        The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
        and all following characters must be a dash, underscore, letter or digit.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="requireTls")
    def require_tls(self) -> pulumi.Output[_builtins.bool]:
        """
        Require TLS (HTTPS) for all clients connecting to this service.
        Clients who connect over HTTP (port 80) will receive a HTTP 301 to the same URL over HTTPS (port 443).
        You must have at least one (1) edgeSslCertificate specified to enable this.
        """
        return pulumi.get(self, "require_tls")

    @_builtins.property
    @pulumi.getter
    def routing(self) -> pulumi.Output['outputs.EdgeCacheServiceRouting']:
        """
        Defines how requests are routed, modified, cached and/or which origin content is filled from.
        Structure is documented below.
        """
        return pulumi.get(self, "routing")

    @_builtins.property
    @pulumi.getter(name="sslPolicy")
    def ssl_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        URL of the SslPolicy resource that will be associated with the EdgeCacheService.
        If not set, the EdgeCacheService has no SSL policy configured, and will default to the "COMPATIBLE" policy.
        """
        return pulumi.get(self, "ssl_policy")

