# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RegionalParameterVersionArgs', 'RegionalParameterVersion']

@pulumi.input_type
class RegionalParameterVersionArgs:
    def __init__(__self__, *,
                 parameter: pulumi.Input[_builtins.str],
                 parameter_data: pulumi.Input[_builtins.str],
                 parameter_version_id: pulumi.Input[_builtins.str],
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a RegionalParameterVersion resource.
        :param pulumi.Input[_builtins.str] parameter: Parameter Manager Regional Parameter resource.
        :param pulumi.Input[_builtins.str] parameter_data: The Regional Parameter data.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[_builtins.str] parameter_version_id: Version ID of the Regional Parameter Version Resource. This must be unique within the Regional Parameter.
        :param pulumi.Input[_builtins.bool] disabled: The current state of Regional Parameter Version. This field is only applicable for updating Regional Parameter Version.
        """
        pulumi.set(__self__, "parameter", parameter)
        pulumi.set(__self__, "parameter_data", parameter_data)
        pulumi.set(__self__, "parameter_version_id", parameter_version_id)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @_builtins.property
    @pulumi.getter
    def parameter(self) -> pulumi.Input[_builtins.str]:
        """
        Parameter Manager Regional Parameter resource.
        """
        return pulumi.get(self, "parameter")

    @parameter.setter
    def parameter(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "parameter", value)

    @_builtins.property
    @pulumi.getter(name="parameterData")
    def parameter_data(self) -> pulumi.Input[_builtins.str]:
        """
        The Regional Parameter data.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "parameter_data")

    @parameter_data.setter
    def parameter_data(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "parameter_data", value)

    @_builtins.property
    @pulumi.getter(name="parameterVersionId")
    def parameter_version_id(self) -> pulumi.Input[_builtins.str]:
        """
        Version ID of the Regional Parameter Version Resource. This must be unique within the Regional Parameter.
        """
        return pulumi.get(self, "parameter_version_id")

    @parameter_version_id.setter
    def parameter_version_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "parameter_version_id", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The current state of Regional Parameter Version. This field is only applicable for updating Regional Parameter Version.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)


@pulumi.input_type
class _RegionalParameterVersionState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 kms_key_version: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameter: Optional[pulumi.Input[_builtins.str]] = None,
                 parameter_data: Optional[pulumi.Input[_builtins.str]] = None,
                 parameter_version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RegionalParameterVersion resources.
        :param pulumi.Input[_builtins.str] create_time: The time at which the Regional Parameter Version was created.
        :param pulumi.Input[_builtins.bool] disabled: The current state of Regional Parameter Version. This field is only applicable for updating Regional Parameter Version.
        :param pulumi.Input[_builtins.str] kms_key_version: The resource name of the Cloud KMS CryptoKeyVersion used to decrypt regional parameter version payload. Format
               `projects/{{project}}/locations/{{location}}/keyRings/{{key_ring}}/cryptoKeys/{{crypto_key}}/cryptoKeyVersions/{{crypto_key_version}}`
        :param pulumi.Input[_builtins.str] location: Location of Parameter Manager Regional parameter resource.
        :param pulumi.Input[_builtins.str] name: The resource name of the Regional Parameter Version. Format:
               `projects/{{project}}/locations/{{location}}/parameters/{{parameter_id}}/versions/{{parameter_version_id}}`
        :param pulumi.Input[_builtins.str] parameter: Parameter Manager Regional Parameter resource.
        :param pulumi.Input[_builtins.str] parameter_data: The Regional Parameter data.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[_builtins.str] parameter_version_id: Version ID of the Regional Parameter Version Resource. This must be unique within the Regional Parameter.
        :param pulumi.Input[_builtins.str] update_time: The time at which the Regional Parameter Version was updated.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if kms_key_version is not None:
            pulumi.set(__self__, "kms_key_version", kms_key_version)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameter is not None:
            pulumi.set(__self__, "parameter", parameter)
        if parameter_data is not None:
            pulumi.set(__self__, "parameter_data", parameter_data)
        if parameter_version_id is not None:
            pulumi.set(__self__, "parameter_version_id", parameter_version_id)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which the Regional Parameter Version was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The current state of Regional Parameter Version. This field is only applicable for updating Regional Parameter Version.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyVersion")
    def kms_key_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the Cloud KMS CryptoKeyVersion used to decrypt regional parameter version payload. Format
        `projects/{{project}}/locations/{{location}}/keyRings/{{key_ring}}/cryptoKeys/{{crypto_key}}/cryptoKeyVersions/{{crypto_key_version}}`
        """
        return pulumi.get(self, "kms_key_version")

    @kms_key_version.setter
    def kms_key_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_version", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Location of Parameter Manager Regional parameter resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the Regional Parameter Version. Format:
        `projects/{{project}}/locations/{{location}}/parameters/{{parameter_id}}/versions/{{parameter_version_id}}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parameter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Parameter Manager Regional Parameter resource.
        """
        return pulumi.get(self, "parameter")

    @parameter.setter
    def parameter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parameter", value)

    @_builtins.property
    @pulumi.getter(name="parameterData")
    def parameter_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Regional Parameter data.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "parameter_data")

    @parameter_data.setter
    def parameter_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parameter_data", value)

    @_builtins.property
    @pulumi.getter(name="parameterVersionId")
    def parameter_version_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version ID of the Regional Parameter Version Resource. This must be unique within the Regional Parameter.
        """
        return pulumi.get(self, "parameter_version_id")

    @parameter_version_id.setter
    def parameter_version_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parameter_version_id", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which the Regional Parameter Version was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:parametermanager/regionalParameterVersion:RegionalParameterVersion")
class RegionalParameterVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 parameter: Optional[pulumi.Input[_builtins.str]] = None,
                 parameter_data: Optional[pulumi.Input[_builtins.str]] = None,
                 parameter_version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A Regional Parameter Version resource that stores the actual value of the regional parameter.

        To get more information about RegionalParameterVersion, see:

        * [API documentation](https://cloud.google.com/secret-manager/parameter-manager/docs/reference/rest/v1/projects.locations.parameters.versions)

        ## Example Usage

        ### Regional Parameter Version Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        regional_parameter_basic = gcp.parametermanager.RegionalParameter("regional-parameter-basic",
            parameter_id="regional_parameter",
            location="us-central1")
        regional_parameter_version_basic = gcp.parametermanager.RegionalParameterVersion("regional-parameter-version-basic",
            parameter=regional_parameter_basic.id,
            parameter_version_id="regional_parameter_version",
            parameter_data="regional-parameter-version-data")
        ```
        ### Regional Parameter Version With Json Format

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        regional_parameter_basic = gcp.parametermanager.RegionalParameter("regional-parameter-basic",
            parameter_id="regional_parameter",
            format="JSON",
            location="us-central1")
        regional_parameter_version_with_json_format = gcp.parametermanager.RegionalParameterVersion("regional-parameter-version-with-json-format",
            parameter=regional_parameter_basic.id,
            parameter_version_id="regional_parameter_version",
            parameter_data=json.dumps({
                "key1": "val1",
                "key2": "val2",
            }))
        ```
        ### Regional Parameter Version With Kms Key

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        regional_parameter_basic = gcp.parametermanager.RegionalParameter("regional-parameter-basic",
            parameter_id="regional_parameter",
            location="us-central1",
            kms_key="kms-key")
        regional_parameter_version_with_kms_key = gcp.parametermanager.RegionalParameterVersion("regional-parameter-version-with-kms-key",
            parameter=regional_parameter_basic.id,
            parameter_version_id="regional_parameter_version",
            parameter_data="regional-parameter-version-data")
        ```
        ### Regional Parameter Version With Json Format With File

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        regional_parameter_basic = gcp.parametermanager.RegionalParameter("regional-parameter-basic",
            parameter_id="regional_parameter",
            format="JSON",
            location="us-central1")
        regional_parameter_version_with_json_format_with_file = gcp.parametermanager.RegionalParameterVersion("regional-parameter-version-with-json-format-with-file",
            parameter=regional_parameter_basic.id,
            parameter_version_id="regional_parameter_version",
            parameter_data=std.file(input="regional-parameter-json-data.json").result)
        ```
        ### Regional Parameter Version With Yaml Format With File

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        regional_parameter_basic = gcp.parametermanager.RegionalParameter("regional-parameter-basic",
            parameter_id="regional_parameter",
            format="YAML",
            location="us-central1")
        regional_parameter_version_with_yaml_format_with_file = gcp.parametermanager.RegionalParameterVersion("regional-parameter-version-with-yaml-format-with-file",
            parameter=regional_parameter_basic.id,
            parameter_version_id="regional_parameter_version",
            parameter_data=std.file(input="regional-parameter-yaml-data.yaml").result)
        ```

        ## Import

        RegionalParameterVersion can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/parameters/{{parameter_id}}/versions/{{parameter_version_id}}`

        When using the `pulumi import` command, RegionalParameterVersion can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:parametermanager/regionalParameterVersion:RegionalParameterVersion default projects/{{project}}/locations/{{location}}/parameters/{{parameter_id}}/versions/{{parameter_version_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] disabled: The current state of Regional Parameter Version. This field is only applicable for updating Regional Parameter Version.
        :param pulumi.Input[_builtins.str] parameter: Parameter Manager Regional Parameter resource.
        :param pulumi.Input[_builtins.str] parameter_data: The Regional Parameter data.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[_builtins.str] parameter_version_id: Version ID of the Regional Parameter Version Resource. This must be unique within the Regional Parameter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegionalParameterVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Regional Parameter Version resource that stores the actual value of the regional parameter.

        To get more information about RegionalParameterVersion, see:

        * [API documentation](https://cloud.google.com/secret-manager/parameter-manager/docs/reference/rest/v1/projects.locations.parameters.versions)

        ## Example Usage

        ### Regional Parameter Version Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        regional_parameter_basic = gcp.parametermanager.RegionalParameter("regional-parameter-basic",
            parameter_id="regional_parameter",
            location="us-central1")
        regional_parameter_version_basic = gcp.parametermanager.RegionalParameterVersion("regional-parameter-version-basic",
            parameter=regional_parameter_basic.id,
            parameter_version_id="regional_parameter_version",
            parameter_data="regional-parameter-version-data")
        ```
        ### Regional Parameter Version With Json Format

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        regional_parameter_basic = gcp.parametermanager.RegionalParameter("regional-parameter-basic",
            parameter_id="regional_parameter",
            format="JSON",
            location="us-central1")
        regional_parameter_version_with_json_format = gcp.parametermanager.RegionalParameterVersion("regional-parameter-version-with-json-format",
            parameter=regional_parameter_basic.id,
            parameter_version_id="regional_parameter_version",
            parameter_data=json.dumps({
                "key1": "val1",
                "key2": "val2",
            }))
        ```
        ### Regional Parameter Version With Kms Key

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        regional_parameter_basic = gcp.parametermanager.RegionalParameter("regional-parameter-basic",
            parameter_id="regional_parameter",
            location="us-central1",
            kms_key="kms-key")
        regional_parameter_version_with_kms_key = gcp.parametermanager.RegionalParameterVersion("regional-parameter-version-with-kms-key",
            parameter=regional_parameter_basic.id,
            parameter_version_id="regional_parameter_version",
            parameter_data="regional-parameter-version-data")
        ```
        ### Regional Parameter Version With Json Format With File

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        regional_parameter_basic = gcp.parametermanager.RegionalParameter("regional-parameter-basic",
            parameter_id="regional_parameter",
            format="JSON",
            location="us-central1")
        regional_parameter_version_with_json_format_with_file = gcp.parametermanager.RegionalParameterVersion("regional-parameter-version-with-json-format-with-file",
            parameter=regional_parameter_basic.id,
            parameter_version_id="regional_parameter_version",
            parameter_data=std.file(input="regional-parameter-json-data.json").result)
        ```
        ### Regional Parameter Version With Yaml Format With File

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        regional_parameter_basic = gcp.parametermanager.RegionalParameter("regional-parameter-basic",
            parameter_id="regional_parameter",
            format="YAML",
            location="us-central1")
        regional_parameter_version_with_yaml_format_with_file = gcp.parametermanager.RegionalParameterVersion("regional-parameter-version-with-yaml-format-with-file",
            parameter=regional_parameter_basic.id,
            parameter_version_id="regional_parameter_version",
            parameter_data=std.file(input="regional-parameter-yaml-data.yaml").result)
        ```

        ## Import

        RegionalParameterVersion can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/parameters/{{parameter_id}}/versions/{{parameter_version_id}}`

        When using the `pulumi import` command, RegionalParameterVersion can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:parametermanager/regionalParameterVersion:RegionalParameterVersion default projects/{{project}}/locations/{{location}}/parameters/{{parameter_id}}/versions/{{parameter_version_id}}
        ```

        :param str resource_name: The name of the resource.
        :param RegionalParameterVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegionalParameterVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 parameter: Optional[pulumi.Input[_builtins.str]] = None,
                 parameter_data: Optional[pulumi.Input[_builtins.str]] = None,
                 parameter_version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegionalParameterVersionArgs.__new__(RegionalParameterVersionArgs)

            __props__.__dict__["disabled"] = disabled
            if parameter is None and not opts.urn:
                raise TypeError("Missing required property 'parameter'")
            __props__.__dict__["parameter"] = parameter
            if parameter_data is None and not opts.urn:
                raise TypeError("Missing required property 'parameter_data'")
            __props__.__dict__["parameter_data"] = None if parameter_data is None else pulumi.Output.secret(parameter_data)
            if parameter_version_id is None and not opts.urn:
                raise TypeError("Missing required property 'parameter_version_id'")
            __props__.__dict__["parameter_version_id"] = parameter_version_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["kms_key_version"] = None
            __props__.__dict__["location"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["parameterData"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(RegionalParameterVersion, __self__).__init__(
            'gcp:parametermanager/regionalParameterVersion:RegionalParameterVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            kms_key_version: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parameter: Optional[pulumi.Input[_builtins.str]] = None,
            parameter_data: Optional[pulumi.Input[_builtins.str]] = None,
            parameter_version_id: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'RegionalParameterVersion':
        """
        Get an existing RegionalParameterVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The time at which the Regional Parameter Version was created.
        :param pulumi.Input[_builtins.bool] disabled: The current state of Regional Parameter Version. This field is only applicable for updating Regional Parameter Version.
        :param pulumi.Input[_builtins.str] kms_key_version: The resource name of the Cloud KMS CryptoKeyVersion used to decrypt regional parameter version payload. Format
               `projects/{{project}}/locations/{{location}}/keyRings/{{key_ring}}/cryptoKeys/{{crypto_key}}/cryptoKeyVersions/{{crypto_key_version}}`
        :param pulumi.Input[_builtins.str] location: Location of Parameter Manager Regional parameter resource.
        :param pulumi.Input[_builtins.str] name: The resource name of the Regional Parameter Version. Format:
               `projects/{{project}}/locations/{{location}}/parameters/{{parameter_id}}/versions/{{parameter_version_id}}`
        :param pulumi.Input[_builtins.str] parameter: Parameter Manager Regional Parameter resource.
        :param pulumi.Input[_builtins.str] parameter_data: The Regional Parameter data.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[_builtins.str] parameter_version_id: Version ID of the Regional Parameter Version Resource. This must be unique within the Regional Parameter.
        :param pulumi.Input[_builtins.str] update_time: The time at which the Regional Parameter Version was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegionalParameterVersionState.__new__(_RegionalParameterVersionState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["kms_key_version"] = kms_key_version
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["parameter"] = parameter
        __props__.__dict__["parameter_data"] = parameter_data
        __props__.__dict__["parameter_version_id"] = parameter_version_id
        __props__.__dict__["update_time"] = update_time
        return RegionalParameterVersion(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time at which the Regional Parameter Version was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The current state of Regional Parameter Version. This field is only applicable for updating Regional Parameter Version.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter(name="kmsKeyVersion")
    def kms_key_version(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name of the Cloud KMS CryptoKeyVersion used to decrypt regional parameter version payload. Format
        `projects/{{project}}/locations/{{location}}/keyRings/{{key_ring}}/cryptoKeys/{{crypto_key}}/cryptoKeyVersions/{{crypto_key_version}}`
        """
        return pulumi.get(self, "kms_key_version")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Location of Parameter Manager Regional parameter resource.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name of the Regional Parameter Version. Format:
        `projects/{{project}}/locations/{{location}}/parameters/{{parameter_id}}/versions/{{parameter_version_id}}`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parameter(self) -> pulumi.Output[_builtins.str]:
        """
        Parameter Manager Regional Parameter resource.
        """
        return pulumi.get(self, "parameter")

    @_builtins.property
    @pulumi.getter(name="parameterData")
    def parameter_data(self) -> pulumi.Output[_builtins.str]:
        """
        The Regional Parameter data.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "parameter_data")

    @_builtins.property
    @pulumi.getter(name="parameterVersionId")
    def parameter_version_id(self) -> pulumi.Output[_builtins.str]:
        """
        Version ID of the Regional Parameter Version Resource. This must be unique within the Regional Parameter.
        """
        return pulumi.get(self, "parameter_version_id")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time at which the Regional Parameter Version was updated.
        """
        return pulumi.get(self, "update_time")

