# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UnitKindArgs', 'UnitKind']

@pulumi.input_type
class UnitKindArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 saas: pulumi.Input[_builtins.str],
                 unit_kind_id: pulumi.Input[_builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 dependencies: Optional[pulumi.Input[Sequence[pulumi.Input['UnitKindDependencyArgs']]]] = None,
                 input_variable_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['UnitKindInputVariableMappingArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 output_variable_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['UnitKindOutputVariableMappingArgs']]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a UnitKind resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] saas: A reference to the Saas that defines the product (managed service) that
               the producer wants to manage with SaaS Runtime. Part of the SaaS Runtime
               common data model. Immutable once set.
        :param pulumi.Input[_builtins.str] unit_kind_id: The ID value for the new unit kind.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations is an unstructured key-value map stored with a resource that
               may be set by external tools to store and retrieve arbitrary metadata.
               They are not queryable and should be preserved when modifying objects.
               More info: https://kubernetes.io/docs/user-guide/annotations
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Sequence[pulumi.Input['UnitKindDependencyArgs']]] dependencies: List of other unit kinds that this release will depend on. Dependencies
               will be automatically provisioned if not found. Maximum 10.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['UnitKindInputVariableMappingArgs']]] input_variable_mappings: List of inputVariables for this release that will either be retrieved from
               a dependency’s outputVariables, or will be passed on to a dependency’s
               inputVariables. Maximum 100.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels on the resource, which can be used for categorization.
               similar to Kubernetes resource labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[Sequence[pulumi.Input['UnitKindOutputVariableMappingArgs']]] output_variable_mappings: List of outputVariables for this unit kind will be passed to this unit's
               outputVariables. Maximum 100.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "saas", saas)
        pulumi.set(__self__, "unit_kind_id", unit_kind_id)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if dependencies is not None:
            pulumi.set(__self__, "dependencies", dependencies)
        if input_variable_mappings is not None:
            pulumi.set(__self__, "input_variable_mappings", input_variable_mappings)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if output_variable_mappings is not None:
            pulumi.set(__self__, "output_variable_mappings", output_variable_mappings)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def saas(self) -> pulumi.Input[_builtins.str]:
        """
        A reference to the Saas that defines the product (managed service) that
        the producer wants to manage with SaaS Runtime. Part of the SaaS Runtime
        common data model. Immutable once set.
        """
        return pulumi.get(self, "saas")

    @saas.setter
    def saas(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "saas", value)

    @_builtins.property
    @pulumi.getter(name="unitKindId")
    def unit_kind_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID value for the new unit kind.
        """
        return pulumi.get(self, "unit_kind_id")

    @unit_kind_id.setter
    def unit_kind_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "unit_kind_id", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations is an unstructured key-value map stored with a resource that
        may be set by external tools to store and retrieve arbitrary metadata.
        They are not queryable and should be preserved when modifying objects.
        More info: https://kubernetes.io/docs/user-guide/annotations
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def dependencies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UnitKindDependencyArgs']]]]:
        """
        List of other unit kinds that this release will depend on. Dependencies
        will be automatically provisioned if not found. Maximum 10.
        Structure is documented below.
        """
        return pulumi.get(self, "dependencies")

    @dependencies.setter
    def dependencies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UnitKindDependencyArgs']]]]):
        pulumi.set(self, "dependencies", value)

    @_builtins.property
    @pulumi.getter(name="inputVariableMappings")
    def input_variable_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UnitKindInputVariableMappingArgs']]]]:
        """
        List of inputVariables for this release that will either be retrieved from
        a dependency’s outputVariables, or will be passed on to a dependency’s
        inputVariables. Maximum 100.
        Structure is documented below.
        """
        return pulumi.get(self, "input_variable_mappings")

    @input_variable_mappings.setter
    def input_variable_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UnitKindInputVariableMappingArgs']]]]):
        pulumi.set(self, "input_variable_mappings", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The labels on the resource, which can be used for categorization.
        similar to Kubernetes resource labels.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="outputVariableMappings")
    def output_variable_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UnitKindOutputVariableMappingArgs']]]]:
        """
        List of outputVariables for this unit kind will be passed to this unit's
        outputVariables. Maximum 100.
        Structure is documented below.
        """
        return pulumi.get(self, "output_variable_mappings")

    @output_variable_mappings.setter
    def output_variable_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UnitKindOutputVariableMappingArgs']]]]):
        pulumi.set(self, "output_variable_mappings", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _UnitKindState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 dependencies: Optional[pulumi.Input[Sequence[pulumi.Input['UnitKindDependencyArgs']]]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 input_variable_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['UnitKindInputVariableMappingArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 output_variable_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['UnitKindOutputVariableMappingArgs']]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 saas: Optional[pulumi.Input[_builtins.str]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_kind_id: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UnitKind resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations is an unstructured key-value map stored with a resource that
               may be set by external tools to store and retrieve arbitrary metadata.
               They are not queryable and should be preserved when modifying objects.
               More info: https://kubernetes.io/docs/user-guide/annotations
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] create_time: The timestamp when the resource was created.
        :param pulumi.Input[Sequence[pulumi.Input['UnitKindDependencyArgs']]] dependencies: List of other unit kinds that this release will depend on. Dependencies
               will be automatically provisioned if not found. Maximum 10.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] etag: An opaque value that uniquely identifies a version or
               generation of a resource. It can be used to confirm that the client
               and server agree on the ordering of a resource being written.
        :param pulumi.Input[Sequence[pulumi.Input['UnitKindInputVariableMappingArgs']]] input_variable_mappings: List of inputVariables for this release that will either be retrieved from
               a dependency’s outputVariables, or will be passed on to a dependency’s
               inputVariables. Maximum 100.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels on the resource, which can be used for categorization.
               similar to Kubernetes resource labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] name: Identifier. The resource name (full URI of the resource) following the standard naming
               scheme:
               "projects/{project}/locations/{location}/unitKinds/{unitKind}"
        :param pulumi.Input[Sequence[pulumi.Input['UnitKindOutputVariableMappingArgs']]] output_variable_mappings: List of outputVariables for this unit kind will be passed to this unit's
               outputVariables. Maximum 100.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] saas: A reference to the Saas that defines the product (managed service) that
               the producer wants to manage with SaaS Runtime. Part of the SaaS Runtime
               common data model. Immutable once set.
        :param pulumi.Input[_builtins.str] uid: The unique identifier of the resource. UID is unique in the time
               and space for this resource within the scope of the service. It is
               typically generated by the server on successful creation of a resource
               and must not be changed. UID is used to uniquely identify resources
               with resource name reuses. This should be a UUID4.
        :param pulumi.Input[_builtins.str] unit_kind_id: The ID value for the new unit kind.
        :param pulumi.Input[_builtins.str] update_time: The timestamp when the resource was last updated. Any
               change to the resource made by users must refresh this value.
               Changes to a resource made by the service should refresh this value.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if dependencies is not None:
            pulumi.set(__self__, "dependencies", dependencies)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if input_variable_mappings is not None:
            pulumi.set(__self__, "input_variable_mappings", input_variable_mappings)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_variable_mappings is not None:
            pulumi.set(__self__, "output_variable_mappings", output_variable_mappings)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if saas is not None:
            pulumi.set(__self__, "saas", saas)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if unit_kind_id is not None:
            pulumi.set(__self__, "unit_kind_id", unit_kind_id)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations is an unstructured key-value map stored with a resource that
        may be set by external tools to store and retrieve arbitrary metadata.
        They are not queryable and should be preserved when modifying objects.
        More info: https://kubernetes.io/docs/user-guide/annotations
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def dependencies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UnitKindDependencyArgs']]]]:
        """
        List of other unit kinds that this release will depend on. Dependencies
        will be automatically provisioned if not found. Maximum 10.
        Structure is documented below.
        """
        return pulumi.get(self, "dependencies")

    @dependencies.setter
    def dependencies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UnitKindDependencyArgs']]]]):
        pulumi.set(self, "dependencies", value)

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An opaque value that uniquely identifies a version or
        generation of a resource. It can be used to confirm that the client
        and server agree on the ordering of a resource being written.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter(name="inputVariableMappings")
    def input_variable_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UnitKindInputVariableMappingArgs']]]]:
        """
        List of inputVariables for this release that will either be retrieved from
        a dependency’s outputVariables, or will be passed on to a dependency’s
        inputVariables. Maximum 100.
        Structure is documented below.
        """
        return pulumi.get(self, "input_variable_mappings")

    @input_variable_mappings.setter
    def input_variable_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UnitKindInputVariableMappingArgs']]]]):
        pulumi.set(self, "input_variable_mappings", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The labels on the resource, which can be used for categorization.
        similar to Kubernetes resource labels.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. The resource name (full URI of the resource) following the standard naming
        scheme:
        "projects/{project}/locations/{location}/unitKinds/{unitKind}"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="outputVariableMappings")
    def output_variable_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UnitKindOutputVariableMappingArgs']]]]:
        """
        List of outputVariables for this unit kind will be passed to this unit's
        outputVariables. Maximum 100.
        Structure is documented below.
        """
        return pulumi.get(self, "output_variable_mappings")

    @output_variable_mappings.setter
    def output_variable_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UnitKindOutputVariableMappingArgs']]]]):
        pulumi.set(self, "output_variable_mappings", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def saas(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A reference to the Saas that defines the product (managed service) that
        the producer wants to manage with SaaS Runtime. Part of the SaaS Runtime
        common data model. Immutable once set.
        """
        return pulumi.get(self, "saas")

    @saas.setter
    def saas(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saas", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the resource. UID is unique in the time
        and space for this resource within the scope of the service. It is
        typically generated by the server on successful creation of a resource
        and must not be changed. UID is used to uniquely identify resources
        with resource name reuses. This should be a UUID4.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="unitKindId")
    def unit_kind_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID value for the new unit kind.
        """
        return pulumi.get(self, "unit_kind_id")

    @unit_kind_id.setter
    def unit_kind_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unit_kind_id", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp when the resource was last updated. Any
        change to the resource made by users must refresh this value.
        Changes to a resource made by the service should refresh this value.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:saasruntime/unitKind:UnitKind")
class UnitKind(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 dependencies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UnitKindDependencyArgs', 'UnitKindDependencyArgsDict']]]]] = None,
                 input_variable_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UnitKindInputVariableMappingArgs', 'UnitKindInputVariableMappingArgsDict']]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 output_variable_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UnitKindOutputVariableMappingArgs', 'UnitKindOutputVariableMappingArgsDict']]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 saas: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_kind_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A UnitKind serves as a template or type definition for a group of Units. Units that belong to the same UnitKind are managed together, follow the same release model, and are typically updated together through rollouts.

        ## Example Usage

        ### Saas Runtime Unit Kind Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_saas = gcp.saasruntime.SaaS("example_saas",
            saas_id="example-saas",
            location="global",
            locations=[{
                "name": "us-central1",
            }])
        cluster_unit_kind = gcp.saasruntime.UnitKind("cluster_unit_kind",
            location="global",
            unit_kind_id="cluster-unitkind",
            saas=example_saas.id)
        example = gcp.saasruntime.UnitKind("example",
            location="global",
            unit_kind_id="app-unitkind",
            saas=example_saas.id,
            dependencies=[{
                "unit_kind": cluster_unit_kind.id,
                "alias": "cluster",
            }])
        ```

        ## Import

        UnitKind can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/unitKinds/{{unit_kind_id}}`

        * `{{project}}/{{location}}/{{unit_kind_id}}`

        * `{{location}}/{{unit_kind_id}}`

        When using the `pulumi import` command, UnitKind can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:saasruntime/unitKind:UnitKind default projects/{{project}}/locations/{{location}}/unitKinds/{{unit_kind_id}}
        ```

        ```sh
        $ pulumi import gcp:saasruntime/unitKind:UnitKind default {{project}}/{{location}}/{{unit_kind_id}}
        ```

        ```sh
        $ pulumi import gcp:saasruntime/unitKind:UnitKind default {{location}}/{{unit_kind_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations is an unstructured key-value map stored with a resource that
               may be set by external tools to store and retrieve arbitrary metadata.
               They are not queryable and should be preserved when modifying objects.
               More info: https://kubernetes.io/docs/user-guide/annotations
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UnitKindDependencyArgs', 'UnitKindDependencyArgsDict']]]] dependencies: List of other unit kinds that this release will depend on. Dependencies
               will be automatically provisioned if not found. Maximum 10.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UnitKindInputVariableMappingArgs', 'UnitKindInputVariableMappingArgsDict']]]] input_variable_mappings: List of inputVariables for this release that will either be retrieved from
               a dependency’s outputVariables, or will be passed on to a dependency’s
               inputVariables. Maximum 100.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels on the resource, which can be used for categorization.
               similar to Kubernetes resource labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UnitKindOutputVariableMappingArgs', 'UnitKindOutputVariableMappingArgsDict']]]] output_variable_mappings: List of outputVariables for this unit kind will be passed to this unit's
               outputVariables. Maximum 100.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] saas: A reference to the Saas that defines the product (managed service) that
               the producer wants to manage with SaaS Runtime. Part of the SaaS Runtime
               common data model. Immutable once set.
        :param pulumi.Input[_builtins.str] unit_kind_id: The ID value for the new unit kind.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UnitKindArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A UnitKind serves as a template or type definition for a group of Units. Units that belong to the same UnitKind are managed together, follow the same release model, and are typically updated together through rollouts.

        ## Example Usage

        ### Saas Runtime Unit Kind Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_saas = gcp.saasruntime.SaaS("example_saas",
            saas_id="example-saas",
            location="global",
            locations=[{
                "name": "us-central1",
            }])
        cluster_unit_kind = gcp.saasruntime.UnitKind("cluster_unit_kind",
            location="global",
            unit_kind_id="cluster-unitkind",
            saas=example_saas.id)
        example = gcp.saasruntime.UnitKind("example",
            location="global",
            unit_kind_id="app-unitkind",
            saas=example_saas.id,
            dependencies=[{
                "unit_kind": cluster_unit_kind.id,
                "alias": "cluster",
            }])
        ```

        ## Import

        UnitKind can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/unitKinds/{{unit_kind_id}}`

        * `{{project}}/{{location}}/{{unit_kind_id}}`

        * `{{location}}/{{unit_kind_id}}`

        When using the `pulumi import` command, UnitKind can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:saasruntime/unitKind:UnitKind default projects/{{project}}/locations/{{location}}/unitKinds/{{unit_kind_id}}
        ```

        ```sh
        $ pulumi import gcp:saasruntime/unitKind:UnitKind default {{project}}/{{location}}/{{unit_kind_id}}
        ```

        ```sh
        $ pulumi import gcp:saasruntime/unitKind:UnitKind default {{location}}/{{unit_kind_id}}
        ```

        :param str resource_name: The name of the resource.
        :param UnitKindArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UnitKindArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 dependencies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UnitKindDependencyArgs', 'UnitKindDependencyArgsDict']]]]] = None,
                 input_variable_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UnitKindInputVariableMappingArgs', 'UnitKindInputVariableMappingArgsDict']]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 output_variable_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UnitKindOutputVariableMappingArgs', 'UnitKindOutputVariableMappingArgsDict']]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 saas: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_kind_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UnitKindArgs.__new__(UnitKindArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["dependencies"] = dependencies
            __props__.__dict__["input_variable_mappings"] = input_variable_mappings
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["output_variable_mappings"] = output_variable_mappings
            __props__.__dict__["project"] = project
            if saas is None and not opts.urn:
                raise TypeError("Missing required property 'saas'")
            __props__.__dict__["saas"] = saas
            if unit_kind_id is None and not opts.urn:
                raise TypeError("Missing required property 'unit_kind_id'")
            __props__.__dict__["unit_kind_id"] = unit_kind_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(UnitKind, __self__).__init__(
            'gcp:saasruntime/unitKind:UnitKind',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            dependencies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UnitKindDependencyArgs', 'UnitKindDependencyArgsDict']]]]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            input_variable_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UnitKindInputVariableMappingArgs', 'UnitKindInputVariableMappingArgsDict']]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            output_variable_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UnitKindOutputVariableMappingArgs', 'UnitKindOutputVariableMappingArgsDict']]]]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            saas: Optional[pulumi.Input[_builtins.str]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            unit_kind_id: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'UnitKind':
        """
        Get an existing UnitKind resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations is an unstructured key-value map stored with a resource that
               may be set by external tools to store and retrieve arbitrary metadata.
               They are not queryable and should be preserved when modifying objects.
               More info: https://kubernetes.io/docs/user-guide/annotations
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] create_time: The timestamp when the resource was created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UnitKindDependencyArgs', 'UnitKindDependencyArgsDict']]]] dependencies: List of other unit kinds that this release will depend on. Dependencies
               will be automatically provisioned if not found. Maximum 10.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] etag: An opaque value that uniquely identifies a version or
               generation of a resource. It can be used to confirm that the client
               and server agree on the ordering of a resource being written.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UnitKindInputVariableMappingArgs', 'UnitKindInputVariableMappingArgsDict']]]] input_variable_mappings: List of inputVariables for this release that will either be retrieved from
               a dependency’s outputVariables, or will be passed on to a dependency’s
               inputVariables. Maximum 100.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels on the resource, which can be used for categorization.
               similar to Kubernetes resource labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] name: Identifier. The resource name (full URI of the resource) following the standard naming
               scheme:
               "projects/{project}/locations/{location}/unitKinds/{unitKind}"
        :param pulumi.Input[Sequence[pulumi.Input[Union['UnitKindOutputVariableMappingArgs', 'UnitKindOutputVariableMappingArgsDict']]]] output_variable_mappings: List of outputVariables for this unit kind will be passed to this unit's
               outputVariables. Maximum 100.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] saas: A reference to the Saas that defines the product (managed service) that
               the producer wants to manage with SaaS Runtime. Part of the SaaS Runtime
               common data model. Immutable once set.
        :param pulumi.Input[_builtins.str] uid: The unique identifier of the resource. UID is unique in the time
               and space for this resource within the scope of the service. It is
               typically generated by the server on successful creation of a resource
               and must not be changed. UID is used to uniquely identify resources
               with resource name reuses. This should be a UUID4.
        :param pulumi.Input[_builtins.str] unit_kind_id: The ID value for the new unit kind.
        :param pulumi.Input[_builtins.str] update_time: The timestamp when the resource was last updated. Any
               change to the resource made by users must refresh this value.
               Changes to a resource made by the service should refresh this value.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UnitKindState.__new__(_UnitKindState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["dependencies"] = dependencies
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["etag"] = etag
        __props__.__dict__["input_variable_mappings"] = input_variable_mappings
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["output_variable_mappings"] = output_variable_mappings
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["saas"] = saas
        __props__.__dict__["uid"] = uid
        __props__.__dict__["unit_kind_id"] = unit_kind_id
        __props__.__dict__["update_time"] = update_time
        return UnitKind(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Annotations is an unstructured key-value map stored with a resource that
        may be set by external tools to store and retrieve arbitrary metadata.
        They are not queryable and should be preserved when modifying objects.
        More info: https://kubernetes.io/docs/user-guide/annotations
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def dependencies(self) -> pulumi.Output[Optional[Sequence['outputs.UnitKindDependency']]]:
        """
        List of other unit kinds that this release will depend on. Dependencies
        will be automatically provisioned if not found. Maximum 10.
        Structure is documented below.
        """
        return pulumi.get(self, "dependencies")

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        An opaque value that uniquely identifies a version or
        generation of a resource. It can be used to confirm that the client
        and server agree on the ordering of a resource being written.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="inputVariableMappings")
    def input_variable_mappings(self) -> pulumi.Output[Optional[Sequence['outputs.UnitKindInputVariableMapping']]]:
        """
        List of inputVariables for this release that will either be retrieved from
        a dependency’s outputVariables, or will be passed on to a dependency’s
        inputVariables. Maximum 100.
        Structure is documented below.
        """
        return pulumi.get(self, "input_variable_mappings")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The labels on the resource, which can be used for categorization.
        similar to Kubernetes resource labels.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. The resource name (full URI of the resource) following the standard naming
        scheme:
        "projects/{project}/locations/{location}/unitKinds/{unitKind}"
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="outputVariableMappings")
    def output_variable_mappings(self) -> pulumi.Output[Optional[Sequence['outputs.UnitKindOutputVariableMapping']]]:
        """
        List of outputVariables for this unit kind will be passed to this unit's
        outputVariables. Maximum 100.
        Structure is documented below.
        """
        return pulumi.get(self, "output_variable_mappings")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def saas(self) -> pulumi.Output[_builtins.str]:
        """
        A reference to the Saas that defines the product (managed service) that
        the producer wants to manage with SaaS Runtime. Part of the SaaS Runtime
        common data model. Immutable once set.
        """
        return pulumi.get(self, "saas")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the resource. UID is unique in the time
        and space for this resource within the scope of the service. It is
        typically generated by the server on successful creation of a resource
        and must not be changed. UID is used to uniquely identify resources
        with resource name reuses. This should be a UUID4.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="unitKindId")
    def unit_kind_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID value for the new unit kind.
        """
        return pulumi.get(self, "unit_kind_id")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp when the resource was last updated. Any
        change to the resource made by users must refresh this value.
        Changes to a resource made by the service should refresh this value.
        """
        return pulumi.get(self, "update_time")

