# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceIamBindingArgs', 'InstanceIamBinding']

@pulumi.input_type
class InstanceIamBindingArgs:
    def __init__(__self__, *,
                 members: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 role: pulumi.Input[_builtins.str],
                 condition: Optional[pulumi.Input['InstanceIamBindingConditionArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a InstanceIamBinding resource.
        :param pulumi.Input[_builtins.str] name: The ID of the instance or a fully qualified identifier for the instance.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The region of the Data Fusion instance.
        """
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def members(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "members", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['InstanceIamBindingConditionArgs']]:
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['InstanceIamBindingConditionArgs']]):
        pulumi.set(self, "condition", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the instance or a fully qualified identifier for the instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the Data Fusion instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _InstanceIamBindingState:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['InstanceIamBindingConditionArgs']] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering InstanceIamBinding resources.
        :param pulumi.Input[_builtins.str] name: The ID of the instance or a fully qualified identifier for the instance.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The region of the Data Fusion instance.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['InstanceIamBindingConditionArgs']]:
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['InstanceIamBindingConditionArgs']]):
        pulumi.set(self, "condition", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "members", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the instance or a fully qualified identifier for the instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the Data Fusion instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)


@pulumi.type_token("gcp:securitycenter/instanceIamBinding:InstanceIamBinding")
class InstanceIamBinding(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 condition: Optional[pulumi.Input[Union['InstanceIamBindingConditionArgs', 'InstanceIamBindingConditionArgsDict']]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Represents a Data Fusion instance.

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/data-fusion/docs/reference/rest/v1beta1/projects.locations.instances)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/data-fusion/docs/)

        ## Example Usage

        ### Data Fusion Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic_instance = gcp.datafusion.Instance("basic_instance",
            name="my-instance",
            region="us-central1",
            type="BASIC")
        ```
        ### Data Fusion Instance Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.appengine.get_default_service_account()
        network = gcp.compute.Network("network", name="datafusion-full-network")
        private_ip_alloc = gcp.compute.GlobalAddress("private_ip_alloc",
            name="datafusion-ip-alloc",
            address_type="INTERNAL",
            purpose="VPC_PEERING",
            prefix_length=22,
            network=network.id)
        extended_instance = gcp.datafusion.Instance("extended_instance",
            name="my-instance",
            description="My Data Fusion instance",
            display_name="My Data Fusion instance",
            region="us-central1",
            type="BASIC",
            enable_stackdriver_logging=True,
            enable_stackdriver_monitoring=True,
            private_instance=True,
            dataproc_service_account=default.email,
            labels={
                "example_key": "example_value",
            },
            network_config={
                "network": "default",
                "ip_allocation": pulumi.Output.all(
                    address=private_ip_alloc.address,
                    prefix_length=private_ip_alloc.prefix_length
        ).apply(lambda resolved_outputs: f"{resolved_outputs['address']}/{resolved_outputs['prefix_length']}")
        ,
            },
            accelerators=[{
                "accelerator_type": "CDC",
                "state": "ENABLED",
            }])
        ```
        ### Data Fusion Instance Psc

        ```python
        import pulumi
        import pulumi_gcp as gcp

        psc = gcp.compute.Network("psc",
            name="datafusion-psc-network",
            auto_create_subnetworks=False)
        psc_subnetwork = gcp.compute.Subnetwork("psc",
            name="datafusion-psc-subnet",
            region="us-central1",
            network=psc.id,
            ip_cidr_range="10.0.0.0/16")
        psc_network_attachment = gcp.compute.NetworkAttachment("psc",
            name="datafusion-psc-attachment",
            region="us-central1",
            connection_preference="ACCEPT_AUTOMATIC",
            subnetworks=[psc_subnetwork.self_link])
        psc_instance = gcp.datafusion.Instance("psc_instance",
            name="psc-instance",
            region="us-central1",
            type="BASIC",
            private_instance=True,
            network_config={
                "connection_type": "PRIVATE_SERVICE_CONNECT_INTERFACES",
                "private_service_connect_config": {
                    "network_attachment": psc_network_attachment.id,
                    "unreachable_cidr_block": "192.168.0.0/25",
                },
            })
        ```
        ### Data Fusion Instance Cmek

        ```python
        import pulumi
        import pulumi_gcp as gcp

        key_ring = gcp.kms.KeyRing("key_ring",
            name="my-instance",
            location="us-central1")
        crypto_key = gcp.kms.CryptoKey("crypto_key",
            name="my-instance",
            key_ring=key_ring.id)
        project = gcp.organizations.get_project()
        crypto_key_member_cdf_sa = gcp.kms.CryptoKeyIAMMember("crypto_key_member_cdf_sa",
            crypto_key_id=crypto_key.id,
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{project.number}@gcp-sa-datafusion.iam.gserviceaccount.com")
        crypto_key_member_gcs_sa = gcp.kms.CryptoKeyIAMMember("crypto_key_member_gcs_sa",
            crypto_key_id=crypto_key.id,
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{project.number}@gs-project-accounts.iam.gserviceaccount.com")
        cmek = gcp.datafusion.Instance("cmek",
            name="my-instance",
            region="us-central1",
            type="BASIC",
            crypto_key_config={
                "key_reference": crypto_key.id,
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    crypto_key_member_cdf_sa,
                    crypto_key_member_gcs_sa,
                ]))
        ```
        ### Data Fusion Instance Enterprise

        ```python
        import pulumi
        import pulumi_gcp as gcp

        enterprise_instance = gcp.datafusion.Instance("enterprise_instance",
            name="my-instance",
            region="us-central1",
            type="ENTERPRISE",
            enable_rbac=True)
        ```
        ### Data Fusion Instance Event

        ```python
        import pulumi
        import pulumi_gcp as gcp

        event_topic = gcp.pubsub.Topic("event", name="my-instance")
        event = gcp.datafusion.Instance("event",
            name="my-instance",
            region="us-central1",
            type="BASIC",
            event_publish_config={
                "enabled": True,
                "topic": event_topic.id,
            })
        ```
        ### Data Fusion Instance Zone

        ```python
        import pulumi
        import pulumi_gcp as gcp

        zone = gcp.datafusion.Instance("zone",
            name="my-instance",
            region="us-central1",
            zone="us-central1-a",
            type="DEVELOPER")
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/instances/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:securitycenter/instanceIamBinding:InstanceIamBinding default projects/{{project}}/locations/{{region}}/instances/{{name}}
        ```

        ```sh
        $ pulumi import gcp:securitycenter/instanceIamBinding:InstanceIamBinding default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:securitycenter/instanceIamBinding:InstanceIamBinding default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:securitycenter/instanceIamBinding:InstanceIamBinding default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The ID of the instance or a fully qualified identifier for the instance.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The region of the Data Fusion instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceIamBindingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a Data Fusion instance.

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/data-fusion/docs/reference/rest/v1beta1/projects.locations.instances)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/data-fusion/docs/)

        ## Example Usage

        ### Data Fusion Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic_instance = gcp.datafusion.Instance("basic_instance",
            name="my-instance",
            region="us-central1",
            type="BASIC")
        ```
        ### Data Fusion Instance Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.appengine.get_default_service_account()
        network = gcp.compute.Network("network", name="datafusion-full-network")
        private_ip_alloc = gcp.compute.GlobalAddress("private_ip_alloc",
            name="datafusion-ip-alloc",
            address_type="INTERNAL",
            purpose="VPC_PEERING",
            prefix_length=22,
            network=network.id)
        extended_instance = gcp.datafusion.Instance("extended_instance",
            name="my-instance",
            description="My Data Fusion instance",
            display_name="My Data Fusion instance",
            region="us-central1",
            type="BASIC",
            enable_stackdriver_logging=True,
            enable_stackdriver_monitoring=True,
            private_instance=True,
            dataproc_service_account=default.email,
            labels={
                "example_key": "example_value",
            },
            network_config={
                "network": "default",
                "ip_allocation": pulumi.Output.all(
                    address=private_ip_alloc.address,
                    prefix_length=private_ip_alloc.prefix_length
        ).apply(lambda resolved_outputs: f"{resolved_outputs['address']}/{resolved_outputs['prefix_length']}")
        ,
            },
            accelerators=[{
                "accelerator_type": "CDC",
                "state": "ENABLED",
            }])
        ```
        ### Data Fusion Instance Psc

        ```python
        import pulumi
        import pulumi_gcp as gcp

        psc = gcp.compute.Network("psc",
            name="datafusion-psc-network",
            auto_create_subnetworks=False)
        psc_subnetwork = gcp.compute.Subnetwork("psc",
            name="datafusion-psc-subnet",
            region="us-central1",
            network=psc.id,
            ip_cidr_range="10.0.0.0/16")
        psc_network_attachment = gcp.compute.NetworkAttachment("psc",
            name="datafusion-psc-attachment",
            region="us-central1",
            connection_preference="ACCEPT_AUTOMATIC",
            subnetworks=[psc_subnetwork.self_link])
        psc_instance = gcp.datafusion.Instance("psc_instance",
            name="psc-instance",
            region="us-central1",
            type="BASIC",
            private_instance=True,
            network_config={
                "connection_type": "PRIVATE_SERVICE_CONNECT_INTERFACES",
                "private_service_connect_config": {
                    "network_attachment": psc_network_attachment.id,
                    "unreachable_cidr_block": "192.168.0.0/25",
                },
            })
        ```
        ### Data Fusion Instance Cmek

        ```python
        import pulumi
        import pulumi_gcp as gcp

        key_ring = gcp.kms.KeyRing("key_ring",
            name="my-instance",
            location="us-central1")
        crypto_key = gcp.kms.CryptoKey("crypto_key",
            name="my-instance",
            key_ring=key_ring.id)
        project = gcp.organizations.get_project()
        crypto_key_member_cdf_sa = gcp.kms.CryptoKeyIAMMember("crypto_key_member_cdf_sa",
            crypto_key_id=crypto_key.id,
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{project.number}@gcp-sa-datafusion.iam.gserviceaccount.com")
        crypto_key_member_gcs_sa = gcp.kms.CryptoKeyIAMMember("crypto_key_member_gcs_sa",
            crypto_key_id=crypto_key.id,
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{project.number}@gs-project-accounts.iam.gserviceaccount.com")
        cmek = gcp.datafusion.Instance("cmek",
            name="my-instance",
            region="us-central1",
            type="BASIC",
            crypto_key_config={
                "key_reference": crypto_key.id,
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    crypto_key_member_cdf_sa,
                    crypto_key_member_gcs_sa,
                ]))
        ```
        ### Data Fusion Instance Enterprise

        ```python
        import pulumi
        import pulumi_gcp as gcp

        enterprise_instance = gcp.datafusion.Instance("enterprise_instance",
            name="my-instance",
            region="us-central1",
            type="ENTERPRISE",
            enable_rbac=True)
        ```
        ### Data Fusion Instance Event

        ```python
        import pulumi
        import pulumi_gcp as gcp

        event_topic = gcp.pubsub.Topic("event", name="my-instance")
        event = gcp.datafusion.Instance("event",
            name="my-instance",
            region="us-central1",
            type="BASIC",
            event_publish_config={
                "enabled": True,
                "topic": event_topic.id,
            })
        ```
        ### Data Fusion Instance Zone

        ```python
        import pulumi
        import pulumi_gcp as gcp

        zone = gcp.datafusion.Instance("zone",
            name="my-instance",
            region="us-central1",
            zone="us-central1-a",
            type="DEVELOPER")
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/instances/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:securitycenter/instanceIamBinding:InstanceIamBinding default projects/{{project}}/locations/{{region}}/instances/{{name}}
        ```

        ```sh
        $ pulumi import gcp:securitycenter/instanceIamBinding:InstanceIamBinding default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:securitycenter/instanceIamBinding:InstanceIamBinding default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:securitycenter/instanceIamBinding:InstanceIamBinding default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param InstanceIamBindingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceIamBindingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 condition: Optional[pulumi.Input[Union['InstanceIamBindingConditionArgs', 'InstanceIamBindingConditionArgsDict']]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceIamBindingArgs.__new__(InstanceIamBindingArgs)

            __props__.__dict__["condition"] = condition
            if members is None and not opts.urn:
                raise TypeError("Missing required property 'members'")
            __props__.__dict__["members"] = members
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            __props__.__dict__["etag"] = None
        super(InstanceIamBinding, __self__).__init__(
            'gcp:securitycenter/instanceIamBinding:InstanceIamBinding',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            condition: Optional[pulumi.Input[Union['InstanceIamBindingConditionArgs', 'InstanceIamBindingConditionArgsDict']]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            role: Optional[pulumi.Input[_builtins.str]] = None) -> 'InstanceIamBinding':
        """
        Get an existing InstanceIamBinding resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The ID of the instance or a fully qualified identifier for the instance.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The region of the Data Fusion instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceIamBindingState.__new__(_InstanceIamBindingState)

        __props__.__dict__["condition"] = condition
        __props__.__dict__["etag"] = etag
        __props__.__dict__["members"] = members
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["role"] = role
        return InstanceIamBinding(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> pulumi.Output[Optional['outputs.InstanceIamBindingCondition']]:
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def members(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "members")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the instance or a fully qualified identifier for the instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region of the Data Fusion instance.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "role")

