# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['V2ProjectNotificationConfigArgs', 'V2ProjectNotificationConfig']

@pulumi.input_type
class V2ProjectNotificationConfigArgs:
    def __init__(__self__, *,
                 config_id: pulumi.Input[_builtins.str],
                 streaming_config: pulumi.Input['V2ProjectNotificationConfigStreamingConfigArgs'],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pubsub_topic: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a V2ProjectNotificationConfig resource.
        :param pulumi.Input[_builtins.str] config_id: This must be unique within the project.
        :param pulumi.Input['V2ProjectNotificationConfigStreamingConfigArgs'] streaming_config: The config for triggering streaming-based notifications.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: The description of the notification config (max of 1024 characters).
        :param pulumi.Input[_builtins.str] location: Location ID of the parent organization. Only global is supported at the moment.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] pubsub_topic: The Pub/Sub topic to send notifications to. Its format is
               "projects/[project_id]/topics/[topic]".
        """
        pulumi.set(__self__, "config_id", config_id)
        pulumi.set(__self__, "streaming_config", streaming_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pubsub_topic is not None:
            pulumi.set(__self__, "pubsub_topic", pubsub_topic)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Input[_builtins.str]:
        """
        This must be unique within the project.
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter(name="streamingConfig")
    def streaming_config(self) -> pulumi.Input['V2ProjectNotificationConfigStreamingConfigArgs']:
        """
        The config for triggering streaming-based notifications.
        Structure is documented below.
        """
        return pulumi.get(self, "streaming_config")

    @streaming_config.setter
    def streaming_config(self, value: pulumi.Input['V2ProjectNotificationConfigStreamingConfigArgs']):
        pulumi.set(self, "streaming_config", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the notification config (max of 1024 characters).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Location ID of the parent organization. Only global is supported at the moment.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Pub/Sub topic to send notifications to. Its format is
        "projects/[project_id]/topics/[topic]".
        """
        return pulumi.get(self, "pubsub_topic")

    @pubsub_topic.setter
    def pubsub_topic(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pubsub_topic", value)


@pulumi.input_type
class _V2ProjectNotificationConfigState:
    def __init__(__self__, *,
                 config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pubsub_topic: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 streaming_config: Optional[pulumi.Input['V2ProjectNotificationConfigStreamingConfigArgs']] = None):
        """
        Input properties used for looking up and filtering V2ProjectNotificationConfig resources.
        :param pulumi.Input[_builtins.str] config_id: This must be unique within the project.
        :param pulumi.Input[_builtins.str] description: The description of the notification config (max of 1024 characters).
        :param pulumi.Input[_builtins.str] location: Location ID of the parent organization. Only global is supported at the moment.
        :param pulumi.Input[_builtins.str] name: The resource name of this notification config, in the format
               `projects/{{projectId}}/locations/{{location}}/notificationConfigs/{{config_id}}`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] pubsub_topic: The Pub/Sub topic to send notifications to. Its format is
               "projects/[project_id]/topics/[topic]".
        :param pulumi.Input[_builtins.str] service_account: The service account that needs "pubsub.topics.publish" permission to
               publish to the Pub/Sub topic.
        :param pulumi.Input['V2ProjectNotificationConfigStreamingConfigArgs'] streaming_config: The config for triggering streaming-based notifications.
               Structure is documented below.
        """
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pubsub_topic is not None:
            pulumi.set(__self__, "pubsub_topic", pubsub_topic)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if streaming_config is not None:
            pulumi.set(__self__, "streaming_config", streaming_config)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This must be unique within the project.
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the notification config (max of 1024 characters).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Location ID of the parent organization. Only global is supported at the moment.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of this notification config, in the format
        `projects/{{projectId}}/locations/{{location}}/notificationConfigs/{{config_id}}`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Pub/Sub topic to send notifications to. Its format is
        "projects/[project_id]/topics/[topic]".
        """
        return pulumi.get(self, "pubsub_topic")

    @pubsub_topic.setter
    def pubsub_topic(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pubsub_topic", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service account that needs "pubsub.topics.publish" permission to
        publish to the Pub/Sub topic.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account", value)

    @_builtins.property
    @pulumi.getter(name="streamingConfig")
    def streaming_config(self) -> Optional[pulumi.Input['V2ProjectNotificationConfigStreamingConfigArgs']]:
        """
        The config for triggering streaming-based notifications.
        Structure is documented below.
        """
        return pulumi.get(self, "streaming_config")

    @streaming_config.setter
    def streaming_config(self, value: Optional[pulumi.Input['V2ProjectNotificationConfigStreamingConfigArgs']]):
        pulumi.set(self, "streaming_config", value)


@pulumi.type_token("gcp:securitycenter/v2ProjectNotificationConfig:V2ProjectNotificationConfig")
class V2ProjectNotificationConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pubsub_topic: Optional[pulumi.Input[_builtins.str]] = None,
                 streaming_config: Optional[pulumi.Input[Union['V2ProjectNotificationConfigStreamingConfigArgs', 'V2ProjectNotificationConfigStreamingConfigArgsDict']]] = None,
                 __props__=None):
        """
        This is a continuous export that exports findings to a Pub/Sub topic.

        To get more information about ProjectNotificationConfig, see:

        * [API documentation](https://cloud.google.com/security-command-center/docs/reference/rest/v2/projects.locations.notificationConfigs)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/security-command-center/docs)

        ## Example Usage

        ### Scc V2 Project Notification Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        scc_v2_project_notification = gcp.pubsub.Topic("scc_v2_project_notification", name="my-topic")
        custom_notification_config = gcp.securitycenter.V2ProjectNotificationConfig("custom_notification_config",
            config_id="my-config",
            project="my-project-name",
            location="global",
            description="My custom Cloud Security Command Center Finding Notification Configuration",
            pubsub_topic=scc_v2_project_notification.id,
            streaming_config={
                "filter": "category = \\"OPEN_FIREWALL\\" AND state = \\"ACTIVE\\"",
            })
        ```

        ## Import

        ProjectNotificationConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/notificationConfigs/{{config_id}}`

        * `{{project}}/{{location}}/{{config_id}}`

        * `{{location}}/{{config_id}}`

        When using the `pulumi import` command, ProjectNotificationConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:securitycenter/v2ProjectNotificationConfig:V2ProjectNotificationConfig default projects/{{project}}/locations/{{location}}/notificationConfigs/{{config_id}}
        ```

        ```sh
        $ pulumi import gcp:securitycenter/v2ProjectNotificationConfig:V2ProjectNotificationConfig default {{project}}/{{location}}/{{config_id}}
        ```

        ```sh
        $ pulumi import gcp:securitycenter/v2ProjectNotificationConfig:V2ProjectNotificationConfig default {{location}}/{{config_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] config_id: This must be unique within the project.
        :param pulumi.Input[_builtins.str] description: The description of the notification config (max of 1024 characters).
        :param pulumi.Input[_builtins.str] location: Location ID of the parent organization. Only global is supported at the moment.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] pubsub_topic: The Pub/Sub topic to send notifications to. Its format is
               "projects/[project_id]/topics/[topic]".
        :param pulumi.Input[Union['V2ProjectNotificationConfigStreamingConfigArgs', 'V2ProjectNotificationConfigStreamingConfigArgsDict']] streaming_config: The config for triggering streaming-based notifications.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: V2ProjectNotificationConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This is a continuous export that exports findings to a Pub/Sub topic.

        To get more information about ProjectNotificationConfig, see:

        * [API documentation](https://cloud.google.com/security-command-center/docs/reference/rest/v2/projects.locations.notificationConfigs)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/security-command-center/docs)

        ## Example Usage

        ### Scc V2 Project Notification Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        scc_v2_project_notification = gcp.pubsub.Topic("scc_v2_project_notification", name="my-topic")
        custom_notification_config = gcp.securitycenter.V2ProjectNotificationConfig("custom_notification_config",
            config_id="my-config",
            project="my-project-name",
            location="global",
            description="My custom Cloud Security Command Center Finding Notification Configuration",
            pubsub_topic=scc_v2_project_notification.id,
            streaming_config={
                "filter": "category = \\"OPEN_FIREWALL\\" AND state = \\"ACTIVE\\"",
            })
        ```

        ## Import

        ProjectNotificationConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/notificationConfigs/{{config_id}}`

        * `{{project}}/{{location}}/{{config_id}}`

        * `{{location}}/{{config_id}}`

        When using the `pulumi import` command, ProjectNotificationConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:securitycenter/v2ProjectNotificationConfig:V2ProjectNotificationConfig default projects/{{project}}/locations/{{location}}/notificationConfigs/{{config_id}}
        ```

        ```sh
        $ pulumi import gcp:securitycenter/v2ProjectNotificationConfig:V2ProjectNotificationConfig default {{project}}/{{location}}/{{config_id}}
        ```

        ```sh
        $ pulumi import gcp:securitycenter/v2ProjectNotificationConfig:V2ProjectNotificationConfig default {{location}}/{{config_id}}
        ```

        :param str resource_name: The name of the resource.
        :param V2ProjectNotificationConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(V2ProjectNotificationConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pubsub_topic: Optional[pulumi.Input[_builtins.str]] = None,
                 streaming_config: Optional[pulumi.Input[Union['V2ProjectNotificationConfigStreamingConfigArgs', 'V2ProjectNotificationConfigStreamingConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = V2ProjectNotificationConfigArgs.__new__(V2ProjectNotificationConfigArgs)

            if config_id is None and not opts.urn:
                raise TypeError("Missing required property 'config_id'")
            __props__.__dict__["config_id"] = config_id
            __props__.__dict__["description"] = description
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["pubsub_topic"] = pubsub_topic
            if streaming_config is None and not opts.urn:
                raise TypeError("Missing required property 'streaming_config'")
            __props__.__dict__["streaming_config"] = streaming_config
            __props__.__dict__["name"] = None
            __props__.__dict__["service_account"] = None
        super(V2ProjectNotificationConfig, __self__).__init__(
            'gcp:securitycenter/v2ProjectNotificationConfig:V2ProjectNotificationConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pubsub_topic: Optional[pulumi.Input[_builtins.str]] = None,
            service_account: Optional[pulumi.Input[_builtins.str]] = None,
            streaming_config: Optional[pulumi.Input[Union['V2ProjectNotificationConfigStreamingConfigArgs', 'V2ProjectNotificationConfigStreamingConfigArgsDict']]] = None) -> 'V2ProjectNotificationConfig':
        """
        Get an existing V2ProjectNotificationConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] config_id: This must be unique within the project.
        :param pulumi.Input[_builtins.str] description: The description of the notification config (max of 1024 characters).
        :param pulumi.Input[_builtins.str] location: Location ID of the parent organization. Only global is supported at the moment.
        :param pulumi.Input[_builtins.str] name: The resource name of this notification config, in the format
               `projects/{{projectId}}/locations/{{location}}/notificationConfigs/{{config_id}}`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] pubsub_topic: The Pub/Sub topic to send notifications to. Its format is
               "projects/[project_id]/topics/[topic]".
        :param pulumi.Input[_builtins.str] service_account: The service account that needs "pubsub.topics.publish" permission to
               publish to the Pub/Sub topic.
        :param pulumi.Input[Union['V2ProjectNotificationConfigStreamingConfigArgs', 'V2ProjectNotificationConfigStreamingConfigArgsDict']] streaming_config: The config for triggering streaming-based notifications.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _V2ProjectNotificationConfigState.__new__(_V2ProjectNotificationConfigState)

        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["description"] = description
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pubsub_topic"] = pubsub_topic
        __props__.__dict__["service_account"] = service_account
        __props__.__dict__["streaming_config"] = streaming_config
        return V2ProjectNotificationConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[_builtins.str]:
        """
        This must be unique within the project.
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the notification config (max of 1024 characters).
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Location ID of the parent organization. Only global is supported at the moment.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name of this notification config, in the format
        `projects/{{projectId}}/locations/{{location}}/notificationConfigs/{{config_id}}`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Pub/Sub topic to send notifications to. Its format is
        "projects/[project_id]/topics/[topic]".
        """
        return pulumi.get(self, "pubsub_topic")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output[_builtins.str]:
        """
        The service account that needs "pubsub.topics.publish" permission to
        publish to the Pub/Sub topic.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter(name="streamingConfig")
    def streaming_config(self) -> pulumi.Output['outputs.V2ProjectNotificationConfigStreamingConfig']:
        """
        The config for triggering streaming-based notifications.
        Structure is documented below.
        """
        return pulumi.get(self, "streaming_config")

