# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAccountIdTokenResult',
    'AwaitableGetAccountIdTokenResult',
    'get_account_id_token',
    'get_account_id_token_output',
]

@pulumi.output_type
class GetAccountIdTokenResult:
    """
    A collection of values returned by getAccountIdToken.
    """
    def __init__(__self__, delegates=None, id=None, id_token=None, include_email=None, target_audience=None, target_service_account=None):
        if delegates and not isinstance(delegates, list):
            raise TypeError("Expected argument 'delegates' to be a list")
        pulumi.set(__self__, "delegates", delegates)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if id_token and not isinstance(id_token, str):
            raise TypeError("Expected argument 'id_token' to be a str")
        pulumi.set(__self__, "id_token", id_token)
        if include_email and not isinstance(include_email, bool):
            raise TypeError("Expected argument 'include_email' to be a bool")
        pulumi.set(__self__, "include_email", include_email)
        if target_audience and not isinstance(target_audience, str):
            raise TypeError("Expected argument 'target_audience' to be a str")
        pulumi.set(__self__, "target_audience", target_audience)
        if target_service_account and not isinstance(target_service_account, str):
            raise TypeError("Expected argument 'target_service_account' to be a str")
        pulumi.set(__self__, "target_service_account", target_service_account)

    @_builtins.property
    @pulumi.getter
    def delegates(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "delegates")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="idToken")
    def id_token(self) -> _builtins.str:
        """
        The `id_token` representing the new generated identity.
        """
        return pulumi.get(self, "id_token")

    @_builtins.property
    @pulumi.getter(name="includeEmail")
    def include_email(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "include_email")

    @_builtins.property
    @pulumi.getter(name="targetAudience")
    def target_audience(self) -> _builtins.str:
        return pulumi.get(self, "target_audience")

    @_builtins.property
    @pulumi.getter(name="targetServiceAccount")
    def target_service_account(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "target_service_account")


class AwaitableGetAccountIdTokenResult(GetAccountIdTokenResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountIdTokenResult(
            delegates=self.delegates,
            id=self.id,
            id_token=self.id_token,
            include_email=self.include_email,
            target_audience=self.target_audience,
            target_service_account=self.target_service_account)


def get_account_id_token(delegates: Optional[Sequence[_builtins.str]] = None,
                         include_email: Optional[_builtins.bool] = None,
                         target_audience: Optional[_builtins.str] = None,
                         target_service_account: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountIdTokenResult:
    """
    This data source provides a Google OpenID Connect (`oidc`) `id_token`.  Tokens issued from this data source are typically used to call external services that accept OIDC tokens for authentication (e.g. [Google Cloud Run](https://cloud.google.com/run/docs/authenticating/service-to-service)).

    For more information see
    [OpenID Connect](https://openid.net/specs/openid-connect-core-1_0.html#IDToken).

    ## Example Usage

    ### ServiceAccount JSON Credential File.
      `serviceaccount_get_account_id_token` will use the configured provider credentials

    ```python
    import pulumi
    import pulumi_gcp as gcp

    oidc = gcp.serviceaccount.get_account_id_token(target_audience="https://foo.bar/")
    pulumi.export("oidcToken", oidc.id_token)
    ```

    ### Service Account Impersonation.
      `serviceaccount_get_account_id_token` will use background impersonated credentials provided by `serviceaccount_get_account_access_token`.

      Note: to use the following, you must grant `target_service_account` the
      `roles/iam.serviceAccountTokenCreator` role on itself.

    ```python
    import pulumi
    import pulumi_gcp as gcp

    impersonated = gcp.serviceaccount.get_account_access_token(target_service_account="impersonated-account@project.iam.gserviceaccount.com",
      delegates=[],
      scopes=[
          "userinfo-email",
          "cloud-platform",
      ],
      lifetime="300s")
    oidc = gcp.serviceaccount.get_account_id_token(target_service_account="impersonated-account@project.iam.gserviceaccount.com",
      delegates=[],
      include_email=True,
      target_audience="https://foo.bar/")
    pulumi.export("oidcToken", oidc.id_token)
    ```

    ### Invoking Cloud Run Endpoint

      The following configuration will invoke [Cloud Run](https://cloud.google.com/run/docs/authenticating/service-to-service) endpoint where the service account for the provider has been granted `roles/run.invoker` role previously.

    ```python
    import pulumi
    import pulumi_gcp as gcp
    import pulumi_http as http

    oidc = gcp.serviceaccount.get_account_id_token(target_audience="https://your.cloud.run.app/")
    cloudrun = http.get_http(url="https://your.cloud.run.app/",
        request_headers={
            "Authorization": f"Bearer {oidc.id_token}",
        })
    pulumi.export("cloudRunResponse", cloudrun.body)
    ```


    :param Sequence[_builtins.str] delegates: Delegate chain of approvals needed to perform full impersonation. Specify the fully qualified service account name.   Used only when using impersonation mode.
    :param _builtins.bool include_email: Include the verified email in the claim. Used only when using impersonation mode.
    :param _builtins.str target_audience: The audience claim for the `id_token`.
    :param _builtins.str target_service_account: The email of the service account being impersonated.  Used only when using impersonation mode.
    """
    __args__ = dict()
    __args__['delegates'] = delegates
    __args__['includeEmail'] = include_email
    __args__['targetAudience'] = target_audience
    __args__['targetServiceAccount'] = target_service_account
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:serviceaccount/getAccountIdToken:getAccountIdToken', __args__, opts=opts, typ=GetAccountIdTokenResult).value

    return AwaitableGetAccountIdTokenResult(
        delegates=pulumi.get(__ret__, 'delegates'),
        id=pulumi.get(__ret__, 'id'),
        id_token=pulumi.get(__ret__, 'id_token'),
        include_email=pulumi.get(__ret__, 'include_email'),
        target_audience=pulumi.get(__ret__, 'target_audience'),
        target_service_account=pulumi.get(__ret__, 'target_service_account'))
def get_account_id_token_output(delegates: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                include_email: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                target_audience: Optional[pulumi.Input[_builtins.str]] = None,
                                target_service_account: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountIdTokenResult]:
    """
    This data source provides a Google OpenID Connect (`oidc`) `id_token`.  Tokens issued from this data source are typically used to call external services that accept OIDC tokens for authentication (e.g. [Google Cloud Run](https://cloud.google.com/run/docs/authenticating/service-to-service)).

    For more information see
    [OpenID Connect](https://openid.net/specs/openid-connect-core-1_0.html#IDToken).

    ## Example Usage

    ### ServiceAccount JSON Credential File.
      `serviceaccount_get_account_id_token` will use the configured provider credentials

    ```python
    import pulumi
    import pulumi_gcp as gcp

    oidc = gcp.serviceaccount.get_account_id_token(target_audience="https://foo.bar/")
    pulumi.export("oidcToken", oidc.id_token)
    ```

    ### Service Account Impersonation.
      `serviceaccount_get_account_id_token` will use background impersonated credentials provided by `serviceaccount_get_account_access_token`.

      Note: to use the following, you must grant `target_service_account` the
      `roles/iam.serviceAccountTokenCreator` role on itself.

    ```python
    import pulumi
    import pulumi_gcp as gcp

    impersonated = gcp.serviceaccount.get_account_access_token(target_service_account="impersonated-account@project.iam.gserviceaccount.com",
      delegates=[],
      scopes=[
          "userinfo-email",
          "cloud-platform",
      ],
      lifetime="300s")
    oidc = gcp.serviceaccount.get_account_id_token(target_service_account="impersonated-account@project.iam.gserviceaccount.com",
      delegates=[],
      include_email=True,
      target_audience="https://foo.bar/")
    pulumi.export("oidcToken", oidc.id_token)
    ```

    ### Invoking Cloud Run Endpoint

      The following configuration will invoke [Cloud Run](https://cloud.google.com/run/docs/authenticating/service-to-service) endpoint where the service account for the provider has been granted `roles/run.invoker` role previously.

    ```python
    import pulumi
    import pulumi_gcp as gcp
    import pulumi_http as http

    oidc = gcp.serviceaccount.get_account_id_token(target_audience="https://your.cloud.run.app/")
    cloudrun = http.get_http(url="https://your.cloud.run.app/",
        request_headers={
            "Authorization": f"Bearer {oidc.id_token}",
        })
    pulumi.export("cloudRunResponse", cloudrun.body)
    ```


    :param Sequence[_builtins.str] delegates: Delegate chain of approvals needed to perform full impersonation. Specify the fully qualified service account name.   Used only when using impersonation mode.
    :param _builtins.bool include_email: Include the verified email in the claim. Used only when using impersonation mode.
    :param _builtins.str target_audience: The audience claim for the `id_token`.
    :param _builtins.str target_service_account: The email of the service account being impersonated.  Used only when using impersonation mode.
    """
    __args__ = dict()
    __args__['delegates'] = delegates
    __args__['includeEmail'] = include_email
    __args__['targetAudience'] = target_audience
    __args__['targetServiceAccount'] = target_service_account
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:serviceaccount/getAccountIdToken:getAccountIdToken', __args__, opts=opts, typ=GetAccountIdTokenResult)
    return __ret__.apply(lambda __response__: GetAccountIdTokenResult(
        delegates=pulumi.get(__response__, 'delegates'),
        id=pulumi.get(__response__, 'id'),
        id_token=pulumi.get(__response__, 'id_token'),
        include_email=pulumi.get(__response__, 'include_email'),
        target_audience=pulumi.get(__response__, 'target_audience'),
        target_service_account=pulumi.get(__response__, 'target_service_account')))
