# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDatabaseInstancesResult',
    'AwaitableGetDatabaseInstancesResult',
    'get_database_instances',
    'get_database_instances_output',
]

@pulumi.output_type
class GetDatabaseInstancesResult:
    """
    A collection of values returned by getDatabaseInstances.
    """
    def __init__(__self__, database_version=None, id=None, instances=None, project=None, region=None, state=None, tier=None, zone=None):
        if database_version and not isinstance(database_version, str):
            raise TypeError("Expected argument 'database_version' to be a str")
        pulumi.set(__self__, "database_version", database_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tier and not isinstance(tier, str):
            raise TypeError("Expected argument 'tier' to be a str")
        pulumi.set(__self__, "tier", tier)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "database_version")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetDatabaseInstancesInstanceResult']:
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def tier(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "tier")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "zone")


class AwaitableGetDatabaseInstancesResult(GetDatabaseInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseInstancesResult(
            database_version=self.database_version,
            id=self.id,
            instances=self.instances,
            project=self.project,
            region=self.region,
            state=self.state,
            tier=self.tier,
            zone=self.zone)


def get_database_instances(database_version: Optional[_builtins.str] = None,
                           project: Optional[_builtins.str] = None,
                           region: Optional[_builtins.str] = None,
                           state: Optional[_builtins.str] = None,
                           tier: Optional[_builtins.str] = None,
                           zone: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseInstancesResult:
    """
    Use this data source to get information about a list of Cloud SQL instances in a project. You can also apply some filters over this list to get a more filtered list of Cloud SQL instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    qa = gcp.sql.get_database_instances(project="test-project")
    ```


    :param _builtins.str database_version: To filter out the Cloud SQL instances which are of the specified database version.
    :param _builtins.str project: The ID of the project in which the resources belong. If it is not provided, the provider project is used.
    :param _builtins.str region: To filter out the Cloud SQL instances which are located in the specified region.
    :param _builtins.str state: To filter out the Cloud SQL instances based on the current serving state of the database instance. Supported values include `SQL_INSTANCE_STATE_UNSPECIFIED`, `RUNNABLE`, `SUSPENDED`, `PENDING_DELETE`, `PENDING_CREATE`, `MAINTENANCE`, `FAILED`.
    :param _builtins.str tier: To filter out the Cloud SQL instances based on the tier(or machine type) of the database instances.
    :param _builtins.str zone: To filter out the Cloud SQL instances which are located in the specified zone. This zone refers to the Compute Engine zone that the instance is currently serving from.
    """
    __args__ = dict()
    __args__['databaseVersion'] = database_version
    __args__['project'] = project
    __args__['region'] = region
    __args__['state'] = state
    __args__['tier'] = tier
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:sql/getDatabaseInstances:getDatabaseInstances', __args__, opts=opts, typ=GetDatabaseInstancesResult).value

    return AwaitableGetDatabaseInstancesResult(
        database_version=pulumi.get(__ret__, 'database_version'),
        id=pulumi.get(__ret__, 'id'),
        instances=pulumi.get(__ret__, 'instances'),
        project=pulumi.get(__ret__, 'project'),
        region=pulumi.get(__ret__, 'region'),
        state=pulumi.get(__ret__, 'state'),
        tier=pulumi.get(__ret__, 'tier'),
        zone=pulumi.get(__ret__, 'zone'))
def get_database_instances_output(database_version: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  tier: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  zone: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatabaseInstancesResult]:
    """
    Use this data source to get information about a list of Cloud SQL instances in a project. You can also apply some filters over this list to get a more filtered list of Cloud SQL instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    qa = gcp.sql.get_database_instances(project="test-project")
    ```


    :param _builtins.str database_version: To filter out the Cloud SQL instances which are of the specified database version.
    :param _builtins.str project: The ID of the project in which the resources belong. If it is not provided, the provider project is used.
    :param _builtins.str region: To filter out the Cloud SQL instances which are located in the specified region.
    :param _builtins.str state: To filter out the Cloud SQL instances based on the current serving state of the database instance. Supported values include `SQL_INSTANCE_STATE_UNSPECIFIED`, `RUNNABLE`, `SUSPENDED`, `PENDING_DELETE`, `PENDING_CREATE`, `MAINTENANCE`, `FAILED`.
    :param _builtins.str tier: To filter out the Cloud SQL instances based on the tier(or machine type) of the database instances.
    :param _builtins.str zone: To filter out the Cloud SQL instances which are located in the specified zone. This zone refers to the Compute Engine zone that the instance is currently serving from.
    """
    __args__ = dict()
    __args__['databaseVersion'] = database_version
    __args__['project'] = project
    __args__['region'] = region
    __args__['state'] = state
    __args__['tier'] = tier
    __args__['zone'] = zone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:sql/getDatabaseInstances:getDatabaseInstances', __args__, opts=opts, typ=GetDatabaseInstancesResult)
    return __ret__.apply(lambda __response__: GetDatabaseInstancesResult(
        database_version=pulumi.get(__response__, 'database_version'),
        id=pulumi.get(__response__, 'id'),
        instances=pulumi.get(__response__, 'instances'),
        project=pulumi.get(__response__, 'project'),
        region=pulumi.get(__response__, 'region'),
        state=pulumi.get(__response__, 'state'),
        tier=pulumi.get(__response__, 'tier'),
        zone=pulumi.get(__response__, 'zone')))
