# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DatabaseInstanceClone',
    'DatabaseInstanceDnsName',
    'DatabaseInstanceIpAddress',
    'DatabaseInstanceReplicaConfiguration',
    'DatabaseInstanceReplicationCluster',
    'DatabaseInstanceRestoreBackupContext',
    'DatabaseInstanceServerCaCert',
    'DatabaseInstanceSettings',
    'DatabaseInstanceSettingsActiveDirectoryConfig',
    'DatabaseInstanceSettingsAdvancedMachineFeatures',
    'DatabaseInstanceSettingsBackupConfiguration',
    'DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings',
    'DatabaseInstanceSettingsConnectionPoolConfig',
    'DatabaseInstanceSettingsConnectionPoolConfigFlag',
    'DatabaseInstanceSettingsDataCacheConfig',
    'DatabaseInstanceSettingsDatabaseFlag',
    'DatabaseInstanceSettingsDenyMaintenancePeriod',
    'DatabaseInstanceSettingsFinalBackupConfig',
    'DatabaseInstanceSettingsInsightsConfig',
    'DatabaseInstanceSettingsIpConfiguration',
    'DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork',
    'DatabaseInstanceSettingsIpConfigurationPscConfig',
    'DatabaseInstanceSettingsIpConfigurationPscConfigPscAutoConnection',
    'DatabaseInstanceSettingsLocationPreference',
    'DatabaseInstanceSettingsMaintenanceWindow',
    'DatabaseInstanceSettingsPasswordValidationPolicy',
    'DatabaseInstanceSettingsSqlServerAuditConfig',
    'UserPasswordPolicy',
    'UserPasswordPolicyStatus',
    'UserSqlServerUserDetail',
    'GetCaCertsCertResult',
    'GetDatabaseInstanceCloneResult',
    'GetDatabaseInstanceDnsNameResult',
    'GetDatabaseInstanceIpAddressResult',
    'GetDatabaseInstanceReplicaConfigurationResult',
    'GetDatabaseInstanceReplicationClusterResult',
    'GetDatabaseInstanceRestoreBackupContextResult',
    'GetDatabaseInstanceServerCaCertResult',
    'GetDatabaseInstanceSettingResult',
    'GetDatabaseInstanceSettingActiveDirectoryConfigResult',
    'GetDatabaseInstanceSettingAdvancedMachineFeatureResult',
    'GetDatabaseInstanceSettingBackupConfigurationResult',
    'GetDatabaseInstanceSettingBackupConfigurationBackupRetentionSettingResult',
    'GetDatabaseInstanceSettingConnectionPoolConfigResult',
    'GetDatabaseInstanceSettingConnectionPoolConfigFlagResult',
    'GetDatabaseInstanceSettingDataCacheConfigResult',
    'GetDatabaseInstanceSettingDatabaseFlagResult',
    'GetDatabaseInstanceSettingDenyMaintenancePeriodResult',
    'GetDatabaseInstanceSettingFinalBackupConfigResult',
    'GetDatabaseInstanceSettingInsightsConfigResult',
    'GetDatabaseInstanceSettingIpConfigurationResult',
    'GetDatabaseInstanceSettingIpConfigurationAuthorizedNetworkResult',
    'GetDatabaseInstanceSettingIpConfigurationPscConfigResult',
    'GetDatabaseInstanceSettingIpConfigurationPscConfigPscAutoConnectionResult',
    'GetDatabaseInstanceSettingLocationPreferenceResult',
    'GetDatabaseInstanceSettingMaintenanceWindowResult',
    'GetDatabaseInstanceSettingPasswordValidationPolicyResult',
    'GetDatabaseInstanceSettingSqlServerAuditConfigResult',
    'GetDatabaseInstancesInstanceResult',
    'GetDatabaseInstancesInstanceCloneResult',
    'GetDatabaseInstancesInstanceDnsNameResult',
    'GetDatabaseInstancesInstanceIpAddressResult',
    'GetDatabaseInstancesInstanceReplicaConfigurationResult',
    'GetDatabaseInstancesInstanceReplicationClusterResult',
    'GetDatabaseInstancesInstanceRestoreBackupContextResult',
    'GetDatabaseInstancesInstanceServerCaCertResult',
    'GetDatabaseInstancesInstanceSettingResult',
    'GetDatabaseInstancesInstanceSettingActiveDirectoryConfigResult',
    'GetDatabaseInstancesInstanceSettingAdvancedMachineFeatureResult',
    'GetDatabaseInstancesInstanceSettingBackupConfigurationResult',
    'GetDatabaseInstancesInstanceSettingBackupConfigurationBackupRetentionSettingResult',
    'GetDatabaseInstancesInstanceSettingConnectionPoolConfigResult',
    'GetDatabaseInstancesInstanceSettingConnectionPoolConfigFlagResult',
    'GetDatabaseInstancesInstanceSettingDataCacheConfigResult',
    'GetDatabaseInstancesInstanceSettingDatabaseFlagResult',
    'GetDatabaseInstancesInstanceSettingDenyMaintenancePeriodResult',
    'GetDatabaseInstancesInstanceSettingFinalBackupConfigResult',
    'GetDatabaseInstancesInstanceSettingInsightsConfigResult',
    'GetDatabaseInstancesInstanceSettingIpConfigurationResult',
    'GetDatabaseInstancesInstanceSettingIpConfigurationAuthorizedNetworkResult',
    'GetDatabaseInstancesInstanceSettingIpConfigurationPscConfigResult',
    'GetDatabaseInstancesInstanceSettingIpConfigurationPscConfigPscAutoConnectionResult',
    'GetDatabaseInstancesInstanceSettingLocationPreferenceResult',
    'GetDatabaseInstancesInstanceSettingMaintenanceWindowResult',
    'GetDatabaseInstancesInstanceSettingPasswordValidationPolicyResult',
    'GetDatabaseInstancesInstanceSettingSqlServerAuditConfigResult',
    'GetDatabasesDatabaseResult',
    'GetTiersTierResult',
]

@pulumi.output_type
class DatabaseInstanceClone(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceInstanceName":
            suggest = "source_instance_name"
        elif key == "allocatedIpRange":
            suggest = "allocated_ip_range"
        elif key == "databaseNames":
            suggest = "database_names"
        elif key == "pointInTime":
            suggest = "point_in_time"
        elif key == "preferredZone":
            suggest = "preferred_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceClone. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceClone.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceClone.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_instance_name: _builtins.str,
                 allocated_ip_range: Optional[_builtins.str] = None,
                 database_names: Optional[Sequence[_builtins.str]] = None,
                 point_in_time: Optional[_builtins.str] = None,
                 preferred_zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str source_instance_name: Name of the source instance which will be cloned.
        :param _builtins.str allocated_ip_range: The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        :param Sequence[_builtins.str] database_names: (SQL Server only, use with `point_in_time`) Clone only the specified databases from the source instance. Clone all databases if empty.
        :param _builtins.str point_in_time: The timestamp of the point in time that should be restored.
               
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param _builtins.str preferred_zone: (Point-in-time recovery for PostgreSQL only) Clone to an instance in the specified zone. If no zone is specified, clone to the same zone as the source instance. [clone-unavailable-instance](https://cloud.google.com/sql/docs/postgres/clone-instance#clone-unavailable-instance)
        """
        pulumi.set(__self__, "source_instance_name", source_instance_name)
        if allocated_ip_range is not None:
            pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        if database_names is not None:
            pulumi.set(__self__, "database_names", database_names)
        if point_in_time is not None:
            pulumi.set(__self__, "point_in_time", point_in_time)
        if preferred_zone is not None:
            pulumi.set(__self__, "preferred_zone", preferred_zone)

    @_builtins.property
    @pulumi.getter(name="sourceInstanceName")
    def source_instance_name(self) -> _builtins.str:
        """
        Name of the source instance which will be cloned.
        """
        return pulumi.get(self, "source_instance_name")

    @_builtins.property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> Optional[_builtins.str]:
        """
        The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        """
        return pulumi.get(self, "allocated_ip_range")

    @_builtins.property
    @pulumi.getter(name="databaseNames")
    def database_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        (SQL Server only, use with `point_in_time`) Clone only the specified databases from the source instance. Clone all databases if empty.
        """
        return pulumi.get(self, "database_names")

    @_builtins.property
    @pulumi.getter(name="pointInTime")
    def point_in_time(self) -> Optional[_builtins.str]:
        """
        The timestamp of the point in time that should be restored.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "point_in_time")

    @_builtins.property
    @pulumi.getter(name="preferredZone")
    def preferred_zone(self) -> Optional[_builtins.str]:
        """
        (Point-in-time recovery for PostgreSQL only) Clone to an instance in the specified zone. If no zone is specified, clone to the same zone as the source instance. [clone-unavailable-instance](https://cloud.google.com/sql/docs/postgres/clone-instance#clone-unavailable-instance)
        """
        return pulumi.get(self, "preferred_zone")


@pulumi.output_type
class DatabaseInstanceDnsName(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionType":
            suggest = "connection_type"
        elif key == "dnsScope":
            suggest = "dns_scope"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceDnsName. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceDnsName.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceDnsName.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_type: Optional[_builtins.str] = None,
                 dns_scope: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str connection_type: The connection type of the DNS name. Can be either `PUBLIC`, `PRIVATE_SERVICES_ACCESS`, or `PRIVATE_SERVICE_CONNECT`.
        :param _builtins.str dns_scope: The scope that the DNS name applies to.
        :param _builtins.str name: The name of the instance. If the name is left
               blank, the provider will randomly generate one when the instance is first
               created. This is done because after a name is used, it cannot be reused for
               up to [one week](https://cloud.google.com/sql/docs/delete-instance).
        """
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if dns_scope is not None:
            pulumi.set(__self__, "dns_scope", dns_scope)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[_builtins.str]:
        """
        The connection type of the DNS name. Can be either `PUBLIC`, `PRIVATE_SERVICES_ACCESS`, or `PRIVATE_SERVICE_CONNECT`.
        """
        return pulumi.get(self, "connection_type")

    @_builtins.property
    @pulumi.getter(name="dnsScope")
    def dns_scope(self) -> Optional[_builtins.str]:
        """
        The scope that the DNS name applies to.
        """
        return pulumi.get(self, "dns_scope")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the instance. If the name is left
        blank, the provider will randomly generate one when the instance is first
        created. This is done because after a name is used, it cannot be reused for
        up to [one week](https://cloud.google.com/sql/docs/delete-instance).
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DatabaseInstanceIpAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "timeToRetire":
            suggest = "time_to_retire"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceIpAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceIpAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceIpAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: Optional[_builtins.str] = None,
                 time_to_retire: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str ip_address: The IPv4 address assigned.
        :param _builtins.str time_to_retire: The time this IP address will be retired, in RFC
               3339 format.
        :param _builtins.str type: The type of this IP address.
        """
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if time_to_retire is not None:
            pulumi.set(__self__, "time_to_retire", time_to_retire)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        """
        The IPv4 address assigned.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="timeToRetire")
    def time_to_retire(self) -> Optional[_builtins.str]:
        """
        The time this IP address will be retired, in RFC
        3339 format.
        """
        return pulumi.get(self, "time_to_retire")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of this IP address.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DatabaseInstanceReplicaConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCertificate":
            suggest = "ca_certificate"
        elif key == "cascadableReplica":
            suggest = "cascadable_replica"
        elif key == "clientCertificate":
            suggest = "client_certificate"
        elif key == "clientKey":
            suggest = "client_key"
        elif key == "connectRetryInterval":
            suggest = "connect_retry_interval"
        elif key == "dumpFilePath":
            suggest = "dump_file_path"
        elif key == "failoverTarget":
            suggest = "failover_target"
        elif key == "masterHeartbeatPeriod":
            suggest = "master_heartbeat_period"
        elif key == "sslCipher":
            suggest = "ssl_cipher"
        elif key == "verifyServerCertificate":
            suggest = "verify_server_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceReplicaConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceReplicaConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceReplicaConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_certificate: Optional[_builtins.str] = None,
                 cascadable_replica: Optional[_builtins.bool] = None,
                 client_certificate: Optional[_builtins.str] = None,
                 client_key: Optional[_builtins.str] = None,
                 connect_retry_interval: Optional[_builtins.int] = None,
                 dump_file_path: Optional[_builtins.str] = None,
                 failover_target: Optional[_builtins.bool] = None,
                 master_heartbeat_period: Optional[_builtins.int] = None,
                 password: Optional[_builtins.str] = None,
                 ssl_cipher: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None,
                 verify_server_certificate: Optional[_builtins.bool] = None):
        """
        :param _builtins.str ca_certificate: PEM representation of the trusted CA's x509
               certificate.
        :param _builtins.bool cascadable_replica: Specifies if the replica is a cascadable replica. If true, instance must be in different region from primary.
               
               > **NOTE:** Only supported for SQL Server database.
        :param _builtins.str client_certificate: PEM representation of the replica's x509
               certificate.
        :param _builtins.str client_key: PEM representation of the replica's private key. The
               corresponding public key in encoded in the `client_certificate`.
        :param _builtins.int connect_retry_interval: The number of seconds
               between connect retries. MySQL's default is 60 seconds.
        :param _builtins.str dump_file_path: Path to a SQL file in GCS from which replica
               instances are created. Format is `gs://bucket/filename`. Note, if the master
               instance is a source representation instance this field must be present.
        :param _builtins.bool failover_target: Specifies if the replica is the failover target.
               If the field is set to true the replica will be designated as a failover replica.
               If the master instance fails, the replica instance will be promoted as
               the new master instance.
               > **NOTE:** Not supported for Postgres database.
        :param _builtins.int master_heartbeat_period: Time in ms between replication
               heartbeats.
        :param _builtins.str password: Password for the replication connection.
        :param _builtins.str ssl_cipher: Permissible ciphers for use in SSL encryption.
        :param _builtins.str username: Username for replication connection.
        :param _builtins.bool verify_server_certificate: True if the master's common name
               value is checked during the SSL handshake.
        """
        if ca_certificate is not None:
            pulumi.set(__self__, "ca_certificate", ca_certificate)
        if cascadable_replica is not None:
            pulumi.set(__self__, "cascadable_replica", cascadable_replica)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if connect_retry_interval is not None:
            pulumi.set(__self__, "connect_retry_interval", connect_retry_interval)
        if dump_file_path is not None:
            pulumi.set(__self__, "dump_file_path", dump_file_path)
        if failover_target is not None:
            pulumi.set(__self__, "failover_target", failover_target)
        if master_heartbeat_period is not None:
            pulumi.set(__self__, "master_heartbeat_period", master_heartbeat_period)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if ssl_cipher is not None:
            pulumi.set(__self__, "ssl_cipher", ssl_cipher)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if verify_server_certificate is not None:
            pulumi.set(__self__, "verify_server_certificate", verify_server_certificate)

    @_builtins.property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> Optional[_builtins.str]:
        """
        PEM representation of the trusted CA's x509
        certificate.
        """
        return pulumi.get(self, "ca_certificate")

    @_builtins.property
    @pulumi.getter(name="cascadableReplica")
    def cascadable_replica(self) -> Optional[_builtins.bool]:
        """
        Specifies if the replica is a cascadable replica. If true, instance must be in different region from primary.

        > **NOTE:** Only supported for SQL Server database.
        """
        return pulumi.get(self, "cascadable_replica")

    @_builtins.property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[_builtins.str]:
        """
        PEM representation of the replica's x509
        certificate.
        """
        return pulumi.get(self, "client_certificate")

    @_builtins.property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[_builtins.str]:
        """
        PEM representation of the replica's private key. The
        corresponding public key in encoded in the `client_certificate`.
        """
        return pulumi.get(self, "client_key")

    @_builtins.property
    @pulumi.getter(name="connectRetryInterval")
    def connect_retry_interval(self) -> Optional[_builtins.int]:
        """
        The number of seconds
        between connect retries. MySQL's default is 60 seconds.
        """
        return pulumi.get(self, "connect_retry_interval")

    @_builtins.property
    @pulumi.getter(name="dumpFilePath")
    def dump_file_path(self) -> Optional[_builtins.str]:
        """
        Path to a SQL file in GCS from which replica
        instances are created. Format is `gs://bucket/filename`. Note, if the master
        instance is a source representation instance this field must be present.
        """
        return pulumi.get(self, "dump_file_path")

    @_builtins.property
    @pulumi.getter(name="failoverTarget")
    def failover_target(self) -> Optional[_builtins.bool]:
        """
        Specifies if the replica is the failover target.
        If the field is set to true the replica will be designated as a failover replica.
        If the master instance fails, the replica instance will be promoted as
        the new master instance.
        > **NOTE:** Not supported for Postgres database.
        """
        return pulumi.get(self, "failover_target")

    @_builtins.property
    @pulumi.getter(name="masterHeartbeatPeriod")
    def master_heartbeat_period(self) -> Optional[_builtins.int]:
        """
        Time in ms between replication
        heartbeats.
        """
        return pulumi.get(self, "master_heartbeat_period")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        Password for the replication connection.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="sslCipher")
    def ssl_cipher(self) -> Optional[_builtins.str]:
        """
        Permissible ciphers for use in SSL encryption.
        """
        return pulumi.get(self, "ssl_cipher")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        Username for replication connection.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="verifyServerCertificate")
    def verify_server_certificate(self) -> Optional[_builtins.bool]:
        """
        True if the master's common name
        value is checked during the SSL handshake.
        """
        return pulumi.get(self, "verify_server_certificate")


@pulumi.output_type
class DatabaseInstanceReplicationCluster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "drReplica":
            suggest = "dr_replica"
        elif key == "failoverDrReplicaName":
            suggest = "failover_dr_replica_name"
        elif key == "psaWriteEndpoint":
            suggest = "psa_write_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceReplicationCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceReplicationCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceReplicationCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dr_replica: Optional[_builtins.bool] = None,
                 failover_dr_replica_name: Optional[_builtins.str] = None,
                 psa_write_endpoint: Optional[_builtins.str] = None):
        """
        :param _builtins.bool dr_replica: Read-only field that indicates whether the replica is a DR replica.
        :param _builtins.str failover_dr_replica_name: If the instance is a primary instance, then this field identifies the disaster recovery (DR) replica. The standard format of this field is "your-project:your-instance". You can also set this field to "your-instance", but cloud SQL backend will convert it to the aforementioned standard format.
        :param _builtins.str psa_write_endpoint: Read-only field which if set, indicates this instance has a private service access (PSA) DNS endpoint that is pointing to the primary instance of the cluster. If this instance is the primary, then the DNS endpoint points to this instance. After a switchover or replica failover operation, this DNS endpoint points to the promoted instance. This is a read-only field, returned to the user as information. This field can exist even if a standalone instance doesn't have a DR replica yet or the DR replica is deleted.
        """
        if dr_replica is not None:
            pulumi.set(__self__, "dr_replica", dr_replica)
        if failover_dr_replica_name is not None:
            pulumi.set(__self__, "failover_dr_replica_name", failover_dr_replica_name)
        if psa_write_endpoint is not None:
            pulumi.set(__self__, "psa_write_endpoint", psa_write_endpoint)

    @_builtins.property
    @pulumi.getter(name="drReplica")
    def dr_replica(self) -> Optional[_builtins.bool]:
        """
        Read-only field that indicates whether the replica is a DR replica.
        """
        return pulumi.get(self, "dr_replica")

    @_builtins.property
    @pulumi.getter(name="failoverDrReplicaName")
    def failover_dr_replica_name(self) -> Optional[_builtins.str]:
        """
        If the instance is a primary instance, then this field identifies the disaster recovery (DR) replica. The standard format of this field is "your-project:your-instance". You can also set this field to "your-instance", but cloud SQL backend will convert it to the aforementioned standard format.
        """
        return pulumi.get(self, "failover_dr_replica_name")

    @_builtins.property
    @pulumi.getter(name="psaWriteEndpoint")
    def psa_write_endpoint(self) -> Optional[_builtins.str]:
        """
        Read-only field which if set, indicates this instance has a private service access (PSA) DNS endpoint that is pointing to the primary instance of the cluster. If this instance is the primary, then the DNS endpoint points to this instance. After a switchover or replica failover operation, this DNS endpoint points to the promoted instance. This is a read-only field, returned to the user as information. This field can exist even if a standalone instance doesn't have a DR replica yet or the DR replica is deleted.
        """
        return pulumi.get(self, "psa_write_endpoint")


@pulumi.output_type
class DatabaseInstanceRestoreBackupContext(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupRunId":
            suggest = "backup_run_id"
        elif key == "instanceId":
            suggest = "instance_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceRestoreBackupContext. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceRestoreBackupContext.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceRestoreBackupContext.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_run_id: _builtins.int,
                 instance_id: Optional[_builtins.str] = None,
                 project: Optional[_builtins.str] = None):
        """
        :param _builtins.int backup_run_id: The ID of the backup run to restore from.
        :param _builtins.str instance_id: The ID of the instance that the backup was taken from. If left empty,
               this instance's ID will be used.
        :param _builtins.str project: The full project ID of the source instance.`
        """
        pulumi.set(__self__, "backup_run_id", backup_run_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="backupRunId")
    def backup_run_id(self) -> _builtins.int:
        """
        The ID of the backup run to restore from.
        """
        return pulumi.get(self, "backup_run_id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[_builtins.str]:
        """
        The ID of the instance that the backup was taken from. If left empty,
        this instance's ID will be used.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        """
        The full project ID of the source instance.`
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class DatabaseInstanceServerCaCert(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonName":
            suggest = "common_name"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "expirationTime":
            suggest = "expiration_time"
        elif key == "sha1Fingerprint":
            suggest = "sha1_fingerprint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceServerCaCert. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceServerCaCert.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceServerCaCert.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert: Optional[_builtins.str] = None,
                 common_name: Optional[_builtins.str] = None,
                 create_time: Optional[_builtins.str] = None,
                 expiration_time: Optional[_builtins.str] = None,
                 sha1_fingerprint: Optional[_builtins.str] = None):
        """
        :param _builtins.str cert: The CA Certificate used to connect to the SQL Instance via SSL.
        :param _builtins.str common_name: The CN valid for the CA Cert.
        :param _builtins.str create_time: Creation time of the CA Cert.
        :param _builtins.str expiration_time: Expiration time of the CA Cert.
        :param _builtins.str sha1_fingerprint: SHA Fingerprint of the CA Cert.
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if sha1_fingerprint is not None:
            pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @_builtins.property
    @pulumi.getter
    def cert(self) -> Optional[_builtins.str]:
        """
        The CA Certificate used to connect to the SQL Instance via SSL.
        """
        return pulumi.get(self, "cert")

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[_builtins.str]:
        """
        The CN valid for the CA Cert.
        """
        return pulumi.get(self, "common_name")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[_builtins.str]:
        """
        Creation time of the CA Cert.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[_builtins.str]:
        """
        Expiration time of the CA Cert.
        """
        return pulumi.get(self, "expiration_time")

    @_builtins.property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> Optional[_builtins.str]:
        """
        SHA Fingerprint of the CA Cert.
        """
        return pulumi.get(self, "sha1_fingerprint")


@pulumi.output_type
class DatabaseInstanceSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activationPolicy":
            suggest = "activation_policy"
        elif key == "activeDirectoryConfig":
            suggest = "active_directory_config"
        elif key == "advancedMachineFeatures":
            suggest = "advanced_machine_features"
        elif key == "availabilityType":
            suggest = "availability_type"
        elif key == "backupConfiguration":
            suggest = "backup_configuration"
        elif key == "connectionPoolConfigs":
            suggest = "connection_pool_configs"
        elif key == "connectorEnforcement":
            suggest = "connector_enforcement"
        elif key == "dataCacheConfig":
            suggest = "data_cache_config"
        elif key == "dataDiskProvisionedIops":
            suggest = "data_disk_provisioned_iops"
        elif key == "dataDiskProvisionedThroughput":
            suggest = "data_disk_provisioned_throughput"
        elif key == "databaseFlags":
            suggest = "database_flags"
        elif key == "deletionProtectionEnabled":
            suggest = "deletion_protection_enabled"
        elif key == "denyMaintenancePeriod":
            suggest = "deny_maintenance_period"
        elif key == "diskAutoresize":
            suggest = "disk_autoresize"
        elif key == "diskAutoresizeLimit":
            suggest = "disk_autoresize_limit"
        elif key == "diskSize":
            suggest = "disk_size"
        elif key == "diskType":
            suggest = "disk_type"
        elif key == "effectiveAvailabilityType":
            suggest = "effective_availability_type"
        elif key == "enableDataplexIntegration":
            suggest = "enable_dataplex_integration"
        elif key == "enableGoogleMlIntegration":
            suggest = "enable_google_ml_integration"
        elif key == "finalBackupConfig":
            suggest = "final_backup_config"
        elif key == "insightsConfig":
            suggest = "insights_config"
        elif key == "ipConfiguration":
            suggest = "ip_configuration"
        elif key == "locationPreference":
            suggest = "location_preference"
        elif key == "maintenanceWindow":
            suggest = "maintenance_window"
        elif key == "passwordValidationPolicy":
            suggest = "password_validation_policy"
        elif key == "pricingPlan":
            suggest = "pricing_plan"
        elif key == "retainBackupsOnDelete":
            suggest = "retain_backups_on_delete"
        elif key == "sqlServerAuditConfig":
            suggest = "sql_server_audit_config"
        elif key == "timeZone":
            suggest = "time_zone"
        elif key == "userLabels":
            suggest = "user_labels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 tier: _builtins.str,
                 activation_policy: Optional[_builtins.str] = None,
                 active_directory_config: Optional['outputs.DatabaseInstanceSettingsActiveDirectoryConfig'] = None,
                 advanced_machine_features: Optional['outputs.DatabaseInstanceSettingsAdvancedMachineFeatures'] = None,
                 availability_type: Optional[_builtins.str] = None,
                 backup_configuration: Optional['outputs.DatabaseInstanceSettingsBackupConfiguration'] = None,
                 collation: Optional[_builtins.str] = None,
                 connection_pool_configs: Optional[Sequence['outputs.DatabaseInstanceSettingsConnectionPoolConfig']] = None,
                 connector_enforcement: Optional[_builtins.str] = None,
                 data_cache_config: Optional['outputs.DatabaseInstanceSettingsDataCacheConfig'] = None,
                 data_disk_provisioned_iops: Optional[_builtins.int] = None,
                 data_disk_provisioned_throughput: Optional[_builtins.int] = None,
                 database_flags: Optional[Sequence['outputs.DatabaseInstanceSettingsDatabaseFlag']] = None,
                 deletion_protection_enabled: Optional[_builtins.bool] = None,
                 deny_maintenance_period: Optional['outputs.DatabaseInstanceSettingsDenyMaintenancePeriod'] = None,
                 disk_autoresize: Optional[_builtins.bool] = None,
                 disk_autoresize_limit: Optional[_builtins.int] = None,
                 disk_size: Optional[_builtins.int] = None,
                 disk_type: Optional[_builtins.str] = None,
                 edition: Optional[_builtins.str] = None,
                 effective_availability_type: Optional[_builtins.str] = None,
                 enable_dataplex_integration: Optional[_builtins.bool] = None,
                 enable_google_ml_integration: Optional[_builtins.bool] = None,
                 final_backup_config: Optional['outputs.DatabaseInstanceSettingsFinalBackupConfig'] = None,
                 insights_config: Optional['outputs.DatabaseInstanceSettingsInsightsConfig'] = None,
                 ip_configuration: Optional['outputs.DatabaseInstanceSettingsIpConfiguration'] = None,
                 location_preference: Optional['outputs.DatabaseInstanceSettingsLocationPreference'] = None,
                 maintenance_window: Optional['outputs.DatabaseInstanceSettingsMaintenanceWindow'] = None,
                 password_validation_policy: Optional['outputs.DatabaseInstanceSettingsPasswordValidationPolicy'] = None,
                 pricing_plan: Optional[_builtins.str] = None,
                 retain_backups_on_delete: Optional[_builtins.bool] = None,
                 sql_server_audit_config: Optional['outputs.DatabaseInstanceSettingsSqlServerAuditConfig'] = None,
                 time_zone: Optional[_builtins.str] = None,
                 user_labels: Optional[Mapping[str, _builtins.str]] = None,
                 version: Optional[_builtins.int] = None):
        """
        :param _builtins.str tier: The machine type to use. See [tiers](https://cloud.google.com/sql/docs/admin-api/v1beta4/tiers)
               for more details and supported versions. Postgres supports only shared-core machine types,
               and custom machine types such as `db-custom-2-13312`. See the [Custom Machine Type Documentation](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create) to learn about specifying custom machine types.
        :param _builtins.str activation_policy: This specifies when the instance should be
               active. Can be either `ALWAYS`, `NEVER` or `ON_DEMAND`.
        :param _builtins.str availability_type: The availability type of the Cloud SQL
               instance, high availability (`REGIONAL`) or single zone (`ZONAL`). For all instances, ensure that
               `settings.backup_configuration.enabled` is set to `true`.
               For MySQL instances, ensure that `settings.backup_configuration.binary_log_enabled` is set to `true`.
               For Postgres and SQL Server instances, ensure that `settings.backup_configuration.point_in_time_recovery_enabled`
               is set to `true`. Defaults to `ZONAL`.
               For read pool instances, this field is read-only. The availability type is changed by specifying
               the number of nodes (`node_count`).
        :param _builtins.str collation: The name of server instance collation.
        :param Sequence['DatabaseInstanceSettingsConnectionPoolConfigArgs'] connection_pool_configs: The managed connection pool setting for a Cloud SQL instance.
        :param _builtins.str connector_enforcement: Control the enforcement of Cloud SQL Auth Proxy or Cloud SQL connectors for all the connections, can be `REQUIRED` or `NOT_REQUIRED`. If enabled, all the direct connections are rejected.
        :param 'DatabaseInstanceSettingsDataCacheConfigArgs' data_cache_config: Data cache configurations.
        :param _builtins.int data_disk_provisioned_iops: Provisioned number of I/O operations per second for the data disk. This field is only used for `HYPERDISK_BALANCED` disk types.
        :param _builtins.int data_disk_provisioned_throughput: Provisioned throughput measured in MiB per second for the data disk. This field is only used for `HYPERDISK_BALANCED` disk types.
        :param _builtins.bool deletion_protection_enabled: Configuration to protect against accidental instance deletion.
        :param _builtins.bool disk_autoresize: Enables auto-resizing of the storage size. Defaults to `true`. Note that if `disk_size` is set, future `pulumi up` calls will attempt to delete the instance in order to resize the disk to the value specified in disk_size if it has been resized. To avoid this, ensure that `lifecycle.ignore_changes` is applied to `disk_size`.
        :param _builtins.int disk_autoresize_limit: The maximum size to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        :param _builtins.int disk_size: The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased. The minimum value is 10GB for `PD_SSD`, `PD_HDD` and 20GB for `HYPERDISK_BALANCED`. Note that this value will override the resizing from `disk_autoresize` if that feature is enabled. To avoid this, set `lifecycle.ignore_changes` on this field.
        :param _builtins.str disk_type: The type of data disk: `PD_SSD`, `PD_HDD`, or `HYPERDISK_BALANCED`. Defaults to `PD_SSD`. `HYPERDISK_BALANCED` is preview.
        :param _builtins.str edition: The edition of the instance, can be `ENTERPRISE` or `ENTERPRISE_PLUS`.
        :param _builtins.str effective_availability_type: (Computed) The availability type of
               the Cloud SQL instance, high availability (REGIONAL) or single zone
               (ZONAL). This field always contains the value that is reported by the API (for
               read pools, `settings.0.effective_availability_type` may differ from
               `settings.0.availability_type`).
        :param _builtins.bool enable_dataplex_integration: Enables [Cloud SQL instance integration with Dataplex](https://cloud.google.com/sql/docs/mysql/dataplex-catalog-integration). MySQL, Postgres and SQL Server instances are supported for this feature. Defaults to `false`.
        :param _builtins.bool enable_google_ml_integration: Enables [Cloud SQL instances to connect to Vertex AI](https://cloud.google.com/sql/docs/postgres/integrate-cloud-sql-with-vertex-ai) and pass requests for real-time predictions and insights. Defaults to `false`.
        :param 'DatabaseInstanceSettingsFinalBackupConfigArgs' final_backup_config: Config used to determine the final backup settings for the instance
        :param 'DatabaseInstanceSettingsInsightsConfigArgs' insights_config: Configuration of Query Insights.
        :param 'DatabaseInstanceSettingsMaintenanceWindowArgs' maintenance_window: Declares a one-hour maintenance window when an Instance can automatically restart to apply updates. The maintenance window is specified in UTC time.
        :param _builtins.str pricing_plan: Pricing plan for this instance, can only be `PER_USE`.
        :param _builtins.bool retain_backups_on_delete: When this parameter is set to true, Cloud SQL retains backups of the instance even after the instance is deleted. The `ON_DEMAND` backup will be retained until customer deletes the backup or the project. The `AUTOMATED` backup will be retained based on the backups retention setting.
        :param _builtins.str time_zone: The time_zone to be used by the database engine (supported only for SQL Server), in SQL Server timezone format.
        :param Mapping[str, _builtins.str] user_labels: A set of key/value user label pairs to assign to the instance.
        :param _builtins.int version: Used to make sure changes to the `settings` block are
               atomic.
        """
        pulumi.set(__self__, "tier", tier)
        if activation_policy is not None:
            pulumi.set(__self__, "activation_policy", activation_policy)
        if active_directory_config is not None:
            pulumi.set(__self__, "active_directory_config", active_directory_config)
        if advanced_machine_features is not None:
            pulumi.set(__self__, "advanced_machine_features", advanced_machine_features)
        if availability_type is not None:
            pulumi.set(__self__, "availability_type", availability_type)
        if backup_configuration is not None:
            pulumi.set(__self__, "backup_configuration", backup_configuration)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if connection_pool_configs is not None:
            pulumi.set(__self__, "connection_pool_configs", connection_pool_configs)
        if connector_enforcement is not None:
            pulumi.set(__self__, "connector_enforcement", connector_enforcement)
        if data_cache_config is not None:
            pulumi.set(__self__, "data_cache_config", data_cache_config)
        if data_disk_provisioned_iops is not None:
            pulumi.set(__self__, "data_disk_provisioned_iops", data_disk_provisioned_iops)
        if data_disk_provisioned_throughput is not None:
            pulumi.set(__self__, "data_disk_provisioned_throughput", data_disk_provisioned_throughput)
        if database_flags is not None:
            pulumi.set(__self__, "database_flags", database_flags)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if deny_maintenance_period is not None:
            pulumi.set(__self__, "deny_maintenance_period", deny_maintenance_period)
        if disk_autoresize is not None:
            pulumi.set(__self__, "disk_autoresize", disk_autoresize)
        if disk_autoresize_limit is not None:
            pulumi.set(__self__, "disk_autoresize_limit", disk_autoresize_limit)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if effective_availability_type is not None:
            pulumi.set(__self__, "effective_availability_type", effective_availability_type)
        if enable_dataplex_integration is not None:
            pulumi.set(__self__, "enable_dataplex_integration", enable_dataplex_integration)
        if enable_google_ml_integration is not None:
            pulumi.set(__self__, "enable_google_ml_integration", enable_google_ml_integration)
        if final_backup_config is not None:
            pulumi.set(__self__, "final_backup_config", final_backup_config)
        if insights_config is not None:
            pulumi.set(__self__, "insights_config", insights_config)
        if ip_configuration is not None:
            pulumi.set(__self__, "ip_configuration", ip_configuration)
        if location_preference is not None:
            pulumi.set(__self__, "location_preference", location_preference)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if password_validation_policy is not None:
            pulumi.set(__self__, "password_validation_policy", password_validation_policy)
        if pricing_plan is not None:
            pulumi.set(__self__, "pricing_plan", pricing_plan)
        if retain_backups_on_delete is not None:
            pulumi.set(__self__, "retain_backups_on_delete", retain_backups_on_delete)
        if sql_server_audit_config is not None:
            pulumi.set(__self__, "sql_server_audit_config", sql_server_audit_config)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if user_labels is not None:
            pulumi.set(__self__, "user_labels", user_labels)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def tier(self) -> _builtins.str:
        """
        The machine type to use. See [tiers](https://cloud.google.com/sql/docs/admin-api/v1beta4/tiers)
        for more details and supported versions. Postgres supports only shared-core machine types,
        and custom machine types such as `db-custom-2-13312`. See the [Custom Machine Type Documentation](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create) to learn about specifying custom machine types.
        """
        return pulumi.get(self, "tier")

    @_builtins.property
    @pulumi.getter(name="activationPolicy")
    def activation_policy(self) -> Optional[_builtins.str]:
        """
        This specifies when the instance should be
        active. Can be either `ALWAYS`, `NEVER` or `ON_DEMAND`.
        """
        return pulumi.get(self, "activation_policy")

    @_builtins.property
    @pulumi.getter(name="activeDirectoryConfig")
    def active_directory_config(self) -> Optional['outputs.DatabaseInstanceSettingsActiveDirectoryConfig']:
        return pulumi.get(self, "active_directory_config")

    @_builtins.property
    @pulumi.getter(name="advancedMachineFeatures")
    def advanced_machine_features(self) -> Optional['outputs.DatabaseInstanceSettingsAdvancedMachineFeatures']:
        return pulumi.get(self, "advanced_machine_features")

    @_builtins.property
    @pulumi.getter(name="availabilityType")
    def availability_type(self) -> Optional[_builtins.str]:
        """
        The availability type of the Cloud SQL
        instance, high availability (`REGIONAL`) or single zone (`ZONAL`). For all instances, ensure that
        `settings.backup_configuration.enabled` is set to `true`.
        For MySQL instances, ensure that `settings.backup_configuration.binary_log_enabled` is set to `true`.
        For Postgres and SQL Server instances, ensure that `settings.backup_configuration.point_in_time_recovery_enabled`
        is set to `true`. Defaults to `ZONAL`.
        For read pool instances, this field is read-only. The availability type is changed by specifying
        the number of nodes (`node_count`).
        """
        return pulumi.get(self, "availability_type")

    @_builtins.property
    @pulumi.getter(name="backupConfiguration")
    def backup_configuration(self) -> Optional['outputs.DatabaseInstanceSettingsBackupConfiguration']:
        return pulumi.get(self, "backup_configuration")

    @_builtins.property
    @pulumi.getter
    def collation(self) -> Optional[_builtins.str]:
        """
        The name of server instance collation.
        """
        return pulumi.get(self, "collation")

    @_builtins.property
    @pulumi.getter(name="connectionPoolConfigs")
    def connection_pool_configs(self) -> Optional[Sequence['outputs.DatabaseInstanceSettingsConnectionPoolConfig']]:
        """
        The managed connection pool setting for a Cloud SQL instance.
        """
        return pulumi.get(self, "connection_pool_configs")

    @_builtins.property
    @pulumi.getter(name="connectorEnforcement")
    def connector_enforcement(self) -> Optional[_builtins.str]:
        """
        Control the enforcement of Cloud SQL Auth Proxy or Cloud SQL connectors for all the connections, can be `REQUIRED` or `NOT_REQUIRED`. If enabled, all the direct connections are rejected.
        """
        return pulumi.get(self, "connector_enforcement")

    @_builtins.property
    @pulumi.getter(name="dataCacheConfig")
    def data_cache_config(self) -> Optional['outputs.DatabaseInstanceSettingsDataCacheConfig']:
        """
        Data cache configurations.
        """
        return pulumi.get(self, "data_cache_config")

    @_builtins.property
    @pulumi.getter(name="dataDiskProvisionedIops")
    def data_disk_provisioned_iops(self) -> Optional[_builtins.int]:
        """
        Provisioned number of I/O operations per second for the data disk. This field is only used for `HYPERDISK_BALANCED` disk types.
        """
        return pulumi.get(self, "data_disk_provisioned_iops")

    @_builtins.property
    @pulumi.getter(name="dataDiskProvisionedThroughput")
    def data_disk_provisioned_throughput(self) -> Optional[_builtins.int]:
        """
        Provisioned throughput measured in MiB per second for the data disk. This field is only used for `HYPERDISK_BALANCED` disk types.
        """
        return pulumi.get(self, "data_disk_provisioned_throughput")

    @_builtins.property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Optional[Sequence['outputs.DatabaseInstanceSettingsDatabaseFlag']]:
        return pulumi.get(self, "database_flags")

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[_builtins.bool]:
        """
        Configuration to protect against accidental instance deletion.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @_builtins.property
    @pulumi.getter(name="denyMaintenancePeriod")
    def deny_maintenance_period(self) -> Optional['outputs.DatabaseInstanceSettingsDenyMaintenancePeriod']:
        return pulumi.get(self, "deny_maintenance_period")

    @_builtins.property
    @pulumi.getter(name="diskAutoresize")
    def disk_autoresize(self) -> Optional[_builtins.bool]:
        """
        Enables auto-resizing of the storage size. Defaults to `true`. Note that if `disk_size` is set, future `pulumi up` calls will attempt to delete the instance in order to resize the disk to the value specified in disk_size if it has been resized. To avoid this, ensure that `lifecycle.ignore_changes` is applied to `disk_size`.
        """
        return pulumi.get(self, "disk_autoresize")

    @_builtins.property
    @pulumi.getter(name="diskAutoresizeLimit")
    def disk_autoresize_limit(self) -> Optional[_builtins.int]:
        """
        The maximum size to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        """
        return pulumi.get(self, "disk_autoresize_limit")

    @_builtins.property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[_builtins.int]:
        """
        The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased. The minimum value is 10GB for `PD_SSD`, `PD_HDD` and 20GB for `HYPERDISK_BALANCED`. Note that this value will override the resizing from `disk_autoresize` if that feature is enabled. To avoid this, set `lifecycle.ignore_changes` on this field.
        """
        return pulumi.get(self, "disk_size")

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[_builtins.str]:
        """
        The type of data disk: `PD_SSD`, `PD_HDD`, or `HYPERDISK_BALANCED`. Defaults to `PD_SSD`. `HYPERDISK_BALANCED` is preview.
        """
        return pulumi.get(self, "disk_type")

    @_builtins.property
    @pulumi.getter
    def edition(self) -> Optional[_builtins.str]:
        """
        The edition of the instance, can be `ENTERPRISE` or `ENTERPRISE_PLUS`.
        """
        return pulumi.get(self, "edition")

    @_builtins.property
    @pulumi.getter(name="effectiveAvailabilityType")
    def effective_availability_type(self) -> Optional[_builtins.str]:
        """
        (Computed) The availability type of
        the Cloud SQL instance, high availability (REGIONAL) or single zone
        (ZONAL). This field always contains the value that is reported by the API (for
        read pools, `settings.0.effective_availability_type` may differ from
        `settings.0.availability_type`).
        """
        return pulumi.get(self, "effective_availability_type")

    @_builtins.property
    @pulumi.getter(name="enableDataplexIntegration")
    def enable_dataplex_integration(self) -> Optional[_builtins.bool]:
        """
        Enables [Cloud SQL instance integration with Dataplex](https://cloud.google.com/sql/docs/mysql/dataplex-catalog-integration). MySQL, Postgres and SQL Server instances are supported for this feature. Defaults to `false`.
        """
        return pulumi.get(self, "enable_dataplex_integration")

    @_builtins.property
    @pulumi.getter(name="enableGoogleMlIntegration")
    def enable_google_ml_integration(self) -> Optional[_builtins.bool]:
        """
        Enables [Cloud SQL instances to connect to Vertex AI](https://cloud.google.com/sql/docs/postgres/integrate-cloud-sql-with-vertex-ai) and pass requests for real-time predictions and insights. Defaults to `false`.
        """
        return pulumi.get(self, "enable_google_ml_integration")

    @_builtins.property
    @pulumi.getter(name="finalBackupConfig")
    def final_backup_config(self) -> Optional['outputs.DatabaseInstanceSettingsFinalBackupConfig']:
        """
        Config used to determine the final backup settings for the instance
        """
        return pulumi.get(self, "final_backup_config")

    @_builtins.property
    @pulumi.getter(name="insightsConfig")
    def insights_config(self) -> Optional['outputs.DatabaseInstanceSettingsInsightsConfig']:
        """
        Configuration of Query Insights.
        """
        return pulumi.get(self, "insights_config")

    @_builtins.property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> Optional['outputs.DatabaseInstanceSettingsIpConfiguration']:
        return pulumi.get(self, "ip_configuration")

    @_builtins.property
    @pulumi.getter(name="locationPreference")
    def location_preference(self) -> Optional['outputs.DatabaseInstanceSettingsLocationPreference']:
        return pulumi.get(self, "location_preference")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional['outputs.DatabaseInstanceSettingsMaintenanceWindow']:
        """
        Declares a one-hour maintenance window when an Instance can automatically restart to apply updates. The maintenance window is specified in UTC time.
        """
        return pulumi.get(self, "maintenance_window")

    @_builtins.property
    @pulumi.getter(name="passwordValidationPolicy")
    def password_validation_policy(self) -> Optional['outputs.DatabaseInstanceSettingsPasswordValidationPolicy']:
        return pulumi.get(self, "password_validation_policy")

    @_builtins.property
    @pulumi.getter(name="pricingPlan")
    def pricing_plan(self) -> Optional[_builtins.str]:
        """
        Pricing plan for this instance, can only be `PER_USE`.
        """
        return pulumi.get(self, "pricing_plan")

    @_builtins.property
    @pulumi.getter(name="retainBackupsOnDelete")
    def retain_backups_on_delete(self) -> Optional[_builtins.bool]:
        """
        When this parameter is set to true, Cloud SQL retains backups of the instance even after the instance is deleted. The `ON_DEMAND` backup will be retained until customer deletes the backup or the project. The `AUTOMATED` backup will be retained based on the backups retention setting.
        """
        return pulumi.get(self, "retain_backups_on_delete")

    @_builtins.property
    @pulumi.getter(name="sqlServerAuditConfig")
    def sql_server_audit_config(self) -> Optional['outputs.DatabaseInstanceSettingsSqlServerAuditConfig']:
        return pulumi.get(self, "sql_server_audit_config")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[_builtins.str]:
        """
        The time_zone to be used by the database engine (supported only for SQL Server), in SQL Server timezone format.
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A set of key/value user label pairs to assign to the instance.
        """
        return pulumi.get(self, "user_labels")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.int]:
        """
        Used to make sure changes to the `settings` block are
        atomic.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class DatabaseInstanceSettingsActiveDirectoryConfig(dict):
    def __init__(__self__, *,
                 domain: _builtins.str):
        """
        :param _builtins.str domain: The domain name for the active directory (e.g., mydomain.com).
               Can only be used with SQL Server.
        """
        pulumi.set(__self__, "domain", domain)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        The domain name for the active directory (e.g., mydomain.com).
        Can only be used with SQL Server.
        """
        return pulumi.get(self, "domain")


@pulumi.output_type
class DatabaseInstanceSettingsAdvancedMachineFeatures(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "threadsPerCore":
            suggest = "threads_per_core"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsAdvancedMachineFeatures. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsAdvancedMachineFeatures.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsAdvancedMachineFeatures.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 threads_per_core: Optional[_builtins.int] = None):
        """
        :param _builtins.int threads_per_core: The number of threads per core. The value of this flag can be 1 or 2. To disable SMT, set this flag to 1. Only available in Cloud SQL for SQL Server instances. See [smt](https://cloud.google.com/sql/docs/sqlserver/create-instance#smt-create-instance) for more details.
        """
        if threads_per_core is not None:
            pulumi.set(__self__, "threads_per_core", threads_per_core)

    @_builtins.property
    @pulumi.getter(name="threadsPerCore")
    def threads_per_core(self) -> Optional[_builtins.int]:
        """
        The number of threads per core. The value of this flag can be 1 or 2. To disable SMT, set this flag to 1. Only available in Cloud SQL for SQL Server instances. See [smt](https://cloud.google.com/sql/docs/sqlserver/create-instance#smt-create-instance) for more details.
        """
        return pulumi.get(self, "threads_per_core")


@pulumi.output_type
class DatabaseInstanceSettingsBackupConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupRetentionSettings":
            suggest = "backup_retention_settings"
        elif key == "binaryLogEnabled":
            suggest = "binary_log_enabled"
        elif key == "pointInTimeRecoveryEnabled":
            suggest = "point_in_time_recovery_enabled"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "transactionLogRetentionDays":
            suggest = "transaction_log_retention_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsBackupConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsBackupConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsBackupConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_retention_settings: Optional['outputs.DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings'] = None,
                 binary_log_enabled: Optional[_builtins.bool] = None,
                 enabled: Optional[_builtins.bool] = None,
                 location: Optional[_builtins.str] = None,
                 point_in_time_recovery_enabled: Optional[_builtins.bool] = None,
                 start_time: Optional[_builtins.str] = None,
                 transaction_log_retention_days: Optional[_builtins.int] = None):
        """
        :param 'DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsArgs' backup_retention_settings: Backup retention settings. The configuration is detailed below.
        :param _builtins.bool binary_log_enabled: True if binary logging is enabled.
               Can only be used with MySQL.
        :param _builtins.bool enabled: True if backup configuration is enabled.
        :param _builtins.str location: The region where the backup will be stored
        :param _builtins.bool point_in_time_recovery_enabled: True if Point-in-time recovery is enabled. Will restart database if enabled after instance creation. Valid only for PostgreSQL and SQL Server instances. Enabled by default for PostgreSQL Enterprise Plus and SQL Server Enterprise Plus instances.
        :param _builtins.str start_time: `HH:MM` format time indicating when backup
               configuration starts.
        :param _builtins.int transaction_log_retention_days: The number of days of transaction logs we retain for point in time restore, from 1-7. For PostgreSQL Enterprise Plus and SQL Server Enterprise Plus instances, the number of days of retained transaction logs can be set from 1 to 35.
        """
        if backup_retention_settings is not None:
            pulumi.set(__self__, "backup_retention_settings", backup_retention_settings)
        if binary_log_enabled is not None:
            pulumi.set(__self__, "binary_log_enabled", binary_log_enabled)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if point_in_time_recovery_enabled is not None:
            pulumi.set(__self__, "point_in_time_recovery_enabled", point_in_time_recovery_enabled)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if transaction_log_retention_days is not None:
            pulumi.set(__self__, "transaction_log_retention_days", transaction_log_retention_days)

    @_builtins.property
    @pulumi.getter(name="backupRetentionSettings")
    def backup_retention_settings(self) -> Optional['outputs.DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings']:
        """
        Backup retention settings. The configuration is detailed below.
        """
        return pulumi.get(self, "backup_retention_settings")

    @_builtins.property
    @pulumi.getter(name="binaryLogEnabled")
    def binary_log_enabled(self) -> Optional[_builtins.bool]:
        """
        True if binary logging is enabled.
        Can only be used with MySQL.
        """
        return pulumi.get(self, "binary_log_enabled")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        True if backup configuration is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[_builtins.str]:
        """
        The region where the backup will be stored
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="pointInTimeRecoveryEnabled")
    def point_in_time_recovery_enabled(self) -> Optional[_builtins.bool]:
        """
        True if Point-in-time recovery is enabled. Will restart database if enabled after instance creation. Valid only for PostgreSQL and SQL Server instances. Enabled by default for PostgreSQL Enterprise Plus and SQL Server Enterprise Plus instances.
        """
        return pulumi.get(self, "point_in_time_recovery_enabled")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[_builtins.str]:
        """
        `HH:MM` format time indicating when backup
        configuration starts.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter(name="transactionLogRetentionDays")
    def transaction_log_retention_days(self) -> Optional[_builtins.int]:
        """
        The number of days of transaction logs we retain for point in time restore, from 1-7. For PostgreSQL Enterprise Plus and SQL Server Enterprise Plus instances, the number of days of retained transaction logs can be set from 1 to 35.
        """
        return pulumi.get(self, "transaction_log_retention_days")


@pulumi.output_type
class DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retainedBackups":
            suggest = "retained_backups"
        elif key == "retentionUnit":
            suggest = "retention_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retained_backups: _builtins.int,
                 retention_unit: Optional[_builtins.str] = None):
        """
        :param _builtins.int retained_backups: Depending on the value of retention_unit, this is used to determine if a backup needs to be deleted. If retention_unit
               is 'COUNT', we will retain this many backups.
        :param _builtins.str retention_unit: The unit that 'retained_backups' represents. Defaults to `COUNT`.
        """
        pulumi.set(__self__, "retained_backups", retained_backups)
        if retention_unit is not None:
            pulumi.set(__self__, "retention_unit", retention_unit)

    @_builtins.property
    @pulumi.getter(name="retainedBackups")
    def retained_backups(self) -> _builtins.int:
        """
        Depending on the value of retention_unit, this is used to determine if a backup needs to be deleted. If retention_unit
        is 'COUNT', we will retain this many backups.
        """
        return pulumi.get(self, "retained_backups")

    @_builtins.property
    @pulumi.getter(name="retentionUnit")
    def retention_unit(self) -> Optional[_builtins.str]:
        """
        The unit that 'retained_backups' represents. Defaults to `COUNT`.
        """
        return pulumi.get(self, "retention_unit")


@pulumi.output_type
class DatabaseInstanceSettingsConnectionPoolConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionPoolingEnabled":
            suggest = "connection_pooling_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsConnectionPoolConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsConnectionPoolConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsConnectionPoolConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_pooling_enabled: Optional[_builtins.bool] = None,
                 flags: Optional[Sequence['outputs.DatabaseInstanceSettingsConnectionPoolConfigFlag']] = None):
        """
        :param _builtins.bool connection_pooling_enabled: True if the manager connection pooling configuration is enabled.
        :param Sequence['DatabaseInstanceSettingsConnectionPoolConfigFlagArgs'] flags: List of connection pool configuration flags
        """
        if connection_pooling_enabled is not None:
            pulumi.set(__self__, "connection_pooling_enabled", connection_pooling_enabled)
        if flags is not None:
            pulumi.set(__self__, "flags", flags)

    @_builtins.property
    @pulumi.getter(name="connectionPoolingEnabled")
    def connection_pooling_enabled(self) -> Optional[_builtins.bool]:
        """
        True if the manager connection pooling configuration is enabled.
        """
        return pulumi.get(self, "connection_pooling_enabled")

    @_builtins.property
    @pulumi.getter
    def flags(self) -> Optional[Sequence['outputs.DatabaseInstanceSettingsConnectionPoolConfigFlag']]:
        """
        List of connection pool configuration flags
        """
        return pulumi.get(self, "flags")


@pulumi.output_type
class DatabaseInstanceSettingsConnectionPoolConfigFlag(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: Name of the flag.
        :param _builtins.str value: Value of the flag.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the flag.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the flag.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DatabaseInstanceSettingsDataCacheConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataCacheEnabled":
            suggest = "data_cache_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsDataCacheConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsDataCacheConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsDataCacheConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_cache_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool data_cache_enabled: Whether data cache is enabled for the instance. Defaults to `false`. Can be used with MYSQL and PostgreSQL only.
        """
        if data_cache_enabled is not None:
            pulumi.set(__self__, "data_cache_enabled", data_cache_enabled)

    @_builtins.property
    @pulumi.getter(name="dataCacheEnabled")
    def data_cache_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether data cache is enabled for the instance. Defaults to `false`. Can be used with MYSQL and PostgreSQL only.
        """
        return pulumi.get(self, "data_cache_enabled")


@pulumi.output_type
class DatabaseInstanceSettingsDatabaseFlag(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: Name of the flag.
        :param _builtins.str value: Value of the flag.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the flag.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the flag.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DatabaseInstanceSettingsDenyMaintenancePeriod(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endDate":
            suggest = "end_date"
        elif key == "startDate":
            suggest = "start_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsDenyMaintenancePeriod. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsDenyMaintenancePeriod.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsDenyMaintenancePeriod.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_date: _builtins.str,
                 start_date: _builtins.str,
                 time: _builtins.str):
        """
        :param _builtins.str end_date: "deny maintenance period" end date. If the year of the end date is empty, the year of the start date also must be empty. In this case, it means the no maintenance interval recurs every year. The date is in format yyyy-m-dd (the month is without leading zeros)i.e., 2020-1-01, or 2020-11-01, or mm-dd, i.e., 11-01
        :param _builtins.str start_date: "deny maintenance period" start date. If the year of the start date is empty, the year of the end date also must be empty. In this case, it means the deny maintenance period recurs every year. The date is in format yyyy-m-dd (the month is without leading zeros)i.e., 2020-1-01, or 2020-11-01, or mm-dd, i.e., 11-01
        :param _builtins.str time: Time in UTC when the "deny maintenance period" starts on startDate and ends on endDate. The time is in format: HH:mm:SS, i.e., 00:00:00
        """
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "start_date", start_date)
        pulumi.set(__self__, "time", time)

    @_builtins.property
    @pulumi.getter(name="endDate")
    def end_date(self) -> _builtins.str:
        """
        "deny maintenance period" end date. If the year of the end date is empty, the year of the start date also must be empty. In this case, it means the no maintenance interval recurs every year. The date is in format yyyy-m-dd (the month is without leading zeros)i.e., 2020-1-01, or 2020-11-01, or mm-dd, i.e., 11-01
        """
        return pulumi.get(self, "end_date")

    @_builtins.property
    @pulumi.getter(name="startDate")
    def start_date(self) -> _builtins.str:
        """
        "deny maintenance period" start date. If the year of the start date is empty, the year of the end date also must be empty. In this case, it means the deny maintenance period recurs every year. The date is in format yyyy-m-dd (the month is without leading zeros)i.e., 2020-1-01, or 2020-11-01, or mm-dd, i.e., 11-01
        """
        return pulumi.get(self, "start_date")

    @_builtins.property
    @pulumi.getter
    def time(self) -> _builtins.str:
        """
        Time in UTC when the "deny maintenance period" starts on startDate and ends on endDate. The time is in format: HH:mm:SS, i.e., 00:00:00
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class DatabaseInstanceSettingsFinalBackupConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionDays":
            suggest = "retention_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsFinalBackupConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsFinalBackupConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsFinalBackupConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 retention_days: Optional[_builtins.int] = None):
        """
        :param _builtins.bool enabled: True if enabled final backup.
        :param _builtins.int retention_days: The number of days we retain the final backup after instance deletion. The valid range is between 1 and 365. For instances managed by BackupDR, the valid range is between 1 day and 99 years.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        True if enabled final backup.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[_builtins.int]:
        """
        The number of days we retain the final backup after instance deletion. The valid range is between 1 and 365. For instances managed by BackupDR, the valid range is between 1 day and 99 years.
        """
        return pulumi.get(self, "retention_days")


@pulumi.output_type
class DatabaseInstanceSettingsInsightsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryInsightsEnabled":
            suggest = "query_insights_enabled"
        elif key == "queryPlansPerMinute":
            suggest = "query_plans_per_minute"
        elif key == "queryStringLength":
            suggest = "query_string_length"
        elif key == "recordApplicationTags":
            suggest = "record_application_tags"
        elif key == "recordClientAddress":
            suggest = "record_client_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsInsightsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsInsightsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsInsightsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query_insights_enabled: Optional[_builtins.bool] = None,
                 query_plans_per_minute: Optional[_builtins.int] = None,
                 query_string_length: Optional[_builtins.int] = None,
                 record_application_tags: Optional[_builtins.bool] = None,
                 record_client_address: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool query_insights_enabled: True if Query Insights feature is enabled.
        :param _builtins.int query_plans_per_minute: Number of query execution plans captured by Insights per minute for all queries combined. Between 0 and 20. Default to 5.
        :param _builtins.int query_string_length: Maximum query length stored in bytes. Between 256 and 4500. Default to 1024. Higher query lengths are more useful for analytical queries, but they also require more memory. Changing the query length requires you to restart the instance. You can still add tags to queries that exceed the length limit.
        :param _builtins.bool record_application_tags: True if Query Insights will record application tags from query when enabled.
        :param _builtins.bool record_client_address: True if Query Insights will record client address when enabled.
        """
        if query_insights_enabled is not None:
            pulumi.set(__self__, "query_insights_enabled", query_insights_enabled)
        if query_plans_per_minute is not None:
            pulumi.set(__self__, "query_plans_per_minute", query_plans_per_minute)
        if query_string_length is not None:
            pulumi.set(__self__, "query_string_length", query_string_length)
        if record_application_tags is not None:
            pulumi.set(__self__, "record_application_tags", record_application_tags)
        if record_client_address is not None:
            pulumi.set(__self__, "record_client_address", record_client_address)

    @_builtins.property
    @pulumi.getter(name="queryInsightsEnabled")
    def query_insights_enabled(self) -> Optional[_builtins.bool]:
        """
        True if Query Insights feature is enabled.
        """
        return pulumi.get(self, "query_insights_enabled")

    @_builtins.property
    @pulumi.getter(name="queryPlansPerMinute")
    def query_plans_per_minute(self) -> Optional[_builtins.int]:
        """
        Number of query execution plans captured by Insights per minute for all queries combined. Between 0 and 20. Default to 5.
        """
        return pulumi.get(self, "query_plans_per_minute")

    @_builtins.property
    @pulumi.getter(name="queryStringLength")
    def query_string_length(self) -> Optional[_builtins.int]:
        """
        Maximum query length stored in bytes. Between 256 and 4500. Default to 1024. Higher query lengths are more useful for analytical queries, but they also require more memory. Changing the query length requires you to restart the instance. You can still add tags to queries that exceed the length limit.
        """
        return pulumi.get(self, "query_string_length")

    @_builtins.property
    @pulumi.getter(name="recordApplicationTags")
    def record_application_tags(self) -> Optional[_builtins.bool]:
        """
        True if Query Insights will record application tags from query when enabled.
        """
        return pulumi.get(self, "record_application_tags")

    @_builtins.property
    @pulumi.getter(name="recordClientAddress")
    def record_client_address(self) -> Optional[_builtins.bool]:
        """
        True if Query Insights will record client address when enabled.
        """
        return pulumi.get(self, "record_client_address")


@pulumi.output_type
class DatabaseInstanceSettingsIpConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocatedIpRange":
            suggest = "allocated_ip_range"
        elif key == "authorizedNetworks":
            suggest = "authorized_networks"
        elif key == "customSubjectAlternativeNames":
            suggest = "custom_subject_alternative_names"
        elif key == "enablePrivatePathForGoogleCloudServices":
            suggest = "enable_private_path_for_google_cloud_services"
        elif key == "ipv4Enabled":
            suggest = "ipv4_enabled"
        elif key == "privateNetwork":
            suggest = "private_network"
        elif key == "pscConfigs":
            suggest = "psc_configs"
        elif key == "serverCaMode":
            suggest = "server_ca_mode"
        elif key == "serverCaPool":
            suggest = "server_ca_pool"
        elif key == "sslMode":
            suggest = "ssl_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsIpConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsIpConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsIpConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocated_ip_range: Optional[_builtins.str] = None,
                 authorized_networks: Optional[Sequence['outputs.DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork']] = None,
                 custom_subject_alternative_names: Optional[Sequence[_builtins.str]] = None,
                 enable_private_path_for_google_cloud_services: Optional[_builtins.bool] = None,
                 ipv4_enabled: Optional[_builtins.bool] = None,
                 private_network: Optional[_builtins.str] = None,
                 psc_configs: Optional[Sequence['outputs.DatabaseInstanceSettingsIpConfigurationPscConfig']] = None,
                 server_ca_mode: Optional[_builtins.str] = None,
                 server_ca_pool: Optional[_builtins.str] = None,
                 ssl_mode: Optional[_builtins.str] = None):
        """
        :param _builtins.str allocated_ip_range: The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://datatracker.ietf.org/doc/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        :param Sequence[_builtins.str] custom_subject_alternative_names: The custom subject alternative names for an instance with `CUSTOMER_MANAGED_CAS_CA` as the `server_ca_mode`.
        :param _builtins.bool enable_private_path_for_google_cloud_services: Whether Google Cloud services such as BigQuery are allowed to access data in this Cloud SQL instance over a private IP connection. SQLSERVER database type is not supported.
        :param _builtins.bool ipv4_enabled: Whether this Cloud SQL instance should be assigned
               a public IPV4 address. At least `ipv4_enabled` must be enabled or a
               `private_network` must be configured.
        :param _builtins.str private_network: The VPC network from which the Cloud SQL
               instance is accessible for private IP. For example, projects/myProject/global/networks/default.
               Specifying a network enables private IP.
               At least `ipv4_enabled` must be enabled or a `private_network` must be configured.
               This setting can be updated, but it cannot be removed after it is set.
        :param Sequence['DatabaseInstanceSettingsIpConfigurationPscConfigArgs'] psc_configs: PSC settings for a Cloud SQL instance.
        :param _builtins.str server_ca_mode: Specify how the server certificate's Certificate Authority is hosted. Supported values are `GOOGLE_MANAGED_INTERNAL_CA` and `GOOGLE_MANAGED_CAS_CA`.
        :param _builtins.str server_ca_pool: The resource name of the server CA pool for an instance with `CUSTOMER_MANAGED_CAS_CA` as the `server_ca_mode`.
        :param _builtins.str ssl_mode: Specify how SSL connection should be enforced in DB connections. Supported values are `ALLOW_UNENCRYPTED_AND_ENCRYPTED`, `ENCRYPTED_ONLY`, and `TRUSTED_CLIENT_CERTIFICATE_REQUIRED` (not supported for SQL Server). See [API reference doc](https://cloud.google.com/sql/docs/postgres/admin-api/rest/v1/instances#ipconfiguration) for details.
        """
        if allocated_ip_range is not None:
            pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        if authorized_networks is not None:
            pulumi.set(__self__, "authorized_networks", authorized_networks)
        if custom_subject_alternative_names is not None:
            pulumi.set(__self__, "custom_subject_alternative_names", custom_subject_alternative_names)
        if enable_private_path_for_google_cloud_services is not None:
            pulumi.set(__self__, "enable_private_path_for_google_cloud_services", enable_private_path_for_google_cloud_services)
        if ipv4_enabled is not None:
            pulumi.set(__self__, "ipv4_enabled", ipv4_enabled)
        if private_network is not None:
            pulumi.set(__self__, "private_network", private_network)
        if psc_configs is not None:
            pulumi.set(__self__, "psc_configs", psc_configs)
        if server_ca_mode is not None:
            pulumi.set(__self__, "server_ca_mode", server_ca_mode)
        if server_ca_pool is not None:
            pulumi.set(__self__, "server_ca_pool", server_ca_pool)
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)

    @_builtins.property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> Optional[_builtins.str]:
        """
        The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://datatracker.ietf.org/doc/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        """
        return pulumi.get(self, "allocated_ip_range")

    @_builtins.property
    @pulumi.getter(name="authorizedNetworks")
    def authorized_networks(self) -> Optional[Sequence['outputs.DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork']]:
        return pulumi.get(self, "authorized_networks")

    @_builtins.property
    @pulumi.getter(name="customSubjectAlternativeNames")
    def custom_subject_alternative_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        The custom subject alternative names for an instance with `CUSTOMER_MANAGED_CAS_CA` as the `server_ca_mode`.
        """
        return pulumi.get(self, "custom_subject_alternative_names")

    @_builtins.property
    @pulumi.getter(name="enablePrivatePathForGoogleCloudServices")
    def enable_private_path_for_google_cloud_services(self) -> Optional[_builtins.bool]:
        """
        Whether Google Cloud services such as BigQuery are allowed to access data in this Cloud SQL instance over a private IP connection. SQLSERVER database type is not supported.
        """
        return pulumi.get(self, "enable_private_path_for_google_cloud_services")

    @_builtins.property
    @pulumi.getter(name="ipv4Enabled")
    def ipv4_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether this Cloud SQL instance should be assigned
        a public IPV4 address. At least `ipv4_enabled` must be enabled or a
        `private_network` must be configured.
        """
        return pulumi.get(self, "ipv4_enabled")

    @_builtins.property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> Optional[_builtins.str]:
        """
        The VPC network from which the Cloud SQL
        instance is accessible for private IP. For example, projects/myProject/global/networks/default.
        Specifying a network enables private IP.
        At least `ipv4_enabled` must be enabled or a `private_network` must be configured.
        This setting can be updated, but it cannot be removed after it is set.
        """
        return pulumi.get(self, "private_network")

    @_builtins.property
    @pulumi.getter(name="pscConfigs")
    def psc_configs(self) -> Optional[Sequence['outputs.DatabaseInstanceSettingsIpConfigurationPscConfig']]:
        """
        PSC settings for a Cloud SQL instance.
        """
        return pulumi.get(self, "psc_configs")

    @_builtins.property
    @pulumi.getter(name="serverCaMode")
    def server_ca_mode(self) -> Optional[_builtins.str]:
        """
        Specify how the server certificate's Certificate Authority is hosted. Supported values are `GOOGLE_MANAGED_INTERNAL_CA` and `GOOGLE_MANAGED_CAS_CA`.
        """
        return pulumi.get(self, "server_ca_mode")

    @_builtins.property
    @pulumi.getter(name="serverCaPool")
    def server_ca_pool(self) -> Optional[_builtins.str]:
        """
        The resource name of the server CA pool for an instance with `CUSTOMER_MANAGED_CAS_CA` as the `server_ca_mode`.
        """
        return pulumi.get(self, "server_ca_pool")

    @_builtins.property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional[_builtins.str]:
        """
        Specify how SSL connection should be enforced in DB connections. Supported values are `ALLOW_UNENCRYPTED_AND_ENCRYPTED`, `ENCRYPTED_ONLY`, and `TRUSTED_CLIENT_CERTIFICATE_REQUIRED` (not supported for SQL Server). See [API reference doc](https://cloud.google.com/sql/docs/postgres/admin-api/rest/v1/instances#ipconfiguration) for details.
        """
        return pulumi.get(self, "ssl_mode")


@pulumi.output_type
class DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationTime":
            suggest = "expiration_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 value: _builtins.str,
                 expiration_time: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str value: A CIDR notation IPv4 or IPv6 address that is allowed to
               access this instance. Must be set even if other two attributes are not for
               the whitelist to become active.
        :param _builtins.str expiration_time: The [RFC 3339](https://tools.ietf.org/html/rfc3339)
               formatted date time string indicating when this whitelist expires.
        :param _builtins.str name: A name for this whitelist entry.
        """
        pulumi.set(__self__, "value", value)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        A CIDR notation IPv4 or IPv6 address that is allowed to
        access this instance. Must be set even if other two attributes are not for
        the whitelist to become active.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[_builtins.str]:
        """
        The [RFC 3339](https://tools.ietf.org/html/rfc3339)
        formatted date time string indicating when this whitelist expires.
        """
        return pulumi.get(self, "expiration_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        A name for this whitelist entry.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DatabaseInstanceSettingsIpConfigurationPscConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedConsumerProjects":
            suggest = "allowed_consumer_projects"
        elif key == "networkAttachmentUri":
            suggest = "network_attachment_uri"
        elif key == "pscAutoConnections":
            suggest = "psc_auto_connections"
        elif key == "pscEnabled":
            suggest = "psc_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsIpConfigurationPscConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsIpConfigurationPscConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsIpConfigurationPscConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_consumer_projects: Optional[Sequence[_builtins.str]] = None,
                 network_attachment_uri: Optional[_builtins.str] = None,
                 psc_auto_connections: Optional[Sequence['outputs.DatabaseInstanceSettingsIpConfigurationPscConfigPscAutoConnection']] = None,
                 psc_enabled: Optional[_builtins.bool] = None):
        """
        :param Sequence[_builtins.str] allowed_consumer_projects: List of consumer projects that are allow-listed for PSC connections to this instance. This instance can be connected to with PSC from any network in these projects. Each consumer project in this list may be represented by a project number (numeric) or by a project id (alphanumeric).
        :param _builtins.str network_attachment_uri: Name of network attachment resource used to authorize a producer service to connect a PSC interface to the consumer's VPC. For example: "projects/myProject/regions/myRegion/networkAttachments/myNetworkAttachment". This is required to enable outbound connection on a PSC instance.
        :param Sequence['DatabaseInstanceSettingsIpConfigurationPscConfigPscAutoConnectionArgs'] psc_auto_connections: A comma-separated list of networks or a comma-separated list of network-project pairs. Each project in this list is represented by a project number (numeric) or by a project ID (alphanumeric). This allows Private Service Connect connections to be created automatically for the specified networks.
        :param _builtins.bool psc_enabled: Whether PSC connectivity is enabled for this instance.
        """
        if allowed_consumer_projects is not None:
            pulumi.set(__self__, "allowed_consumer_projects", allowed_consumer_projects)
        if network_attachment_uri is not None:
            pulumi.set(__self__, "network_attachment_uri", network_attachment_uri)
        if psc_auto_connections is not None:
            pulumi.set(__self__, "psc_auto_connections", psc_auto_connections)
        if psc_enabled is not None:
            pulumi.set(__self__, "psc_enabled", psc_enabled)

    @_builtins.property
    @pulumi.getter(name="allowedConsumerProjects")
    def allowed_consumer_projects(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of consumer projects that are allow-listed for PSC connections to this instance. This instance can be connected to with PSC from any network in these projects. Each consumer project in this list may be represented by a project number (numeric) or by a project id (alphanumeric).
        """
        return pulumi.get(self, "allowed_consumer_projects")

    @_builtins.property
    @pulumi.getter(name="networkAttachmentUri")
    def network_attachment_uri(self) -> Optional[_builtins.str]:
        """
        Name of network attachment resource used to authorize a producer service to connect a PSC interface to the consumer's VPC. For example: "projects/myProject/regions/myRegion/networkAttachments/myNetworkAttachment". This is required to enable outbound connection on a PSC instance.
        """
        return pulumi.get(self, "network_attachment_uri")

    @_builtins.property
    @pulumi.getter(name="pscAutoConnections")
    def psc_auto_connections(self) -> Optional[Sequence['outputs.DatabaseInstanceSettingsIpConfigurationPscConfigPscAutoConnection']]:
        """
        A comma-separated list of networks or a comma-separated list of network-project pairs. Each project in this list is represented by a project number (numeric) or by a project ID (alphanumeric). This allows Private Service Connect connections to be created automatically for the specified networks.
        """
        return pulumi.get(self, "psc_auto_connections")

    @_builtins.property
    @pulumi.getter(name="pscEnabled")
    def psc_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether PSC connectivity is enabled for this instance.
        """
        return pulumi.get(self, "psc_enabled")


@pulumi.output_type
class DatabaseInstanceSettingsIpConfigurationPscConfigPscAutoConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumerNetwork":
            suggest = "consumer_network"
        elif key == "consumerNetworkStatus":
            suggest = "consumer_network_status"
        elif key == "consumerServiceProjectId":
            suggest = "consumer_service_project_id"
        elif key == "ipAddress":
            suggest = "ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsIpConfigurationPscConfigPscAutoConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsIpConfigurationPscConfigPscAutoConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsIpConfigurationPscConfigPscAutoConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consumer_network: _builtins.str,
                 consumer_network_status: Optional[_builtins.str] = None,
                 consumer_service_project_id: Optional[_builtins.str] = None,
                 ip_address: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str consumer_network: "The consumer network of this consumer endpoint. This must be a resource path that includes both the host project and the network name. For example, `projects/project1/global/networks/network1`. The consumer host project of this network might be different from the consumer service project."
        :param _builtins.str consumer_network_status: (Output) The connection policy status of the consumer network.
        :param _builtins.str consumer_service_project_id: The project ID of consumer service project of this consumer endpoint.
        :param _builtins.str ip_address: (Output) The IP address of the consumer endpoint.
        :param _builtins.str status: (Output) The connection status of the consumer endpoint.
        """
        pulumi.set(__self__, "consumer_network", consumer_network)
        if consumer_network_status is not None:
            pulumi.set(__self__, "consumer_network_status", consumer_network_status)
        if consumer_service_project_id is not None:
            pulumi.set(__self__, "consumer_service_project_id", consumer_service_project_id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="consumerNetwork")
    def consumer_network(self) -> _builtins.str:
        """
        "The consumer network of this consumer endpoint. This must be a resource path that includes both the host project and the network name. For example, `projects/project1/global/networks/network1`. The consumer host project of this network might be different from the consumer service project."
        """
        return pulumi.get(self, "consumer_network")

    @_builtins.property
    @pulumi.getter(name="consumerNetworkStatus")
    def consumer_network_status(self) -> Optional[_builtins.str]:
        """
        (Output) The connection policy status of the consumer network.
        """
        return pulumi.get(self, "consumer_network_status")

    @_builtins.property
    @pulumi.getter(name="consumerServiceProjectId")
    def consumer_service_project_id(self) -> Optional[_builtins.str]:
        """
        The project ID of consumer service project of this consumer endpoint.
        """
        return pulumi.get(self, "consumer_service_project_id")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        """
        (Output) The IP address of the consumer endpoint.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        (Output) The connection status of the consumer endpoint.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class DatabaseInstanceSettingsLocationPreference(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "followGaeApplication":
            suggest = "follow_gae_application"
        elif key == "secondaryZone":
            suggest = "secondary_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsLocationPreference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsLocationPreference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsLocationPreference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 follow_gae_application: Optional[_builtins.str] = None,
                 secondary_zone: Optional[_builtins.str] = None,
                 zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str follow_gae_application: A GAE application whose zone to remain
               in. Must be in the same region as this instance.
        :param _builtins.str secondary_zone: The preferred Compute Engine zone for the secondary/failover.
        :param _builtins.str zone: The preferred compute engine
               [zone](https://cloud.google.com/compute/docs/zones?hl=en).
        """
        if follow_gae_application is not None:
            pulumi.set(__self__, "follow_gae_application", follow_gae_application)
        if secondary_zone is not None:
            pulumi.set(__self__, "secondary_zone", secondary_zone)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="followGaeApplication")
    def follow_gae_application(self) -> Optional[_builtins.str]:
        """
        A GAE application whose zone to remain
        in. Must be in the same region as this instance.
        """
        return pulumi.get(self, "follow_gae_application")

    @_builtins.property
    @pulumi.getter(name="secondaryZone")
    def secondary_zone(self) -> Optional[_builtins.str]:
        """
        The preferred Compute Engine zone for the secondary/failover.
        """
        return pulumi.get(self, "secondary_zone")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        """
        The preferred compute engine
        [zone](https://cloud.google.com/compute/docs/zones?hl=en).
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class DatabaseInstanceSettingsMaintenanceWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updateTrack":
            suggest = "update_track"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsMaintenanceWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsMaintenanceWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsMaintenanceWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day: Optional[_builtins.int] = None,
                 hour: Optional[_builtins.int] = None,
                 update_track: Optional[_builtins.str] = None):
        """
        :param _builtins.int day: Day of week (`1-7`), starting on Monday
        :param _builtins.int hour: Hour of day (`0-23`), ignored if `day` not set
        :param _builtins.str update_track: Receive updates after one week (`canary`) or after two weeks (`stable`) or after five weeks (`week5`) of notification.
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if update_track is not None:
            pulumi.set(__self__, "update_track", update_track)

    @_builtins.property
    @pulumi.getter
    def day(self) -> Optional[_builtins.int]:
        """
        Day of week (`1-7`), starting on Monday
        """
        return pulumi.get(self, "day")

    @_builtins.property
    @pulumi.getter
    def hour(self) -> Optional[_builtins.int]:
        """
        Hour of day (`0-23`), ignored if `day` not set
        """
        return pulumi.get(self, "hour")

    @_builtins.property
    @pulumi.getter(name="updateTrack")
    def update_track(self) -> Optional[_builtins.str]:
        """
        Receive updates after one week (`canary`) or after two weeks (`stable`) or after five weeks (`week5`) of notification.
        """
        return pulumi.get(self, "update_track")


@pulumi.output_type
class DatabaseInstanceSettingsPasswordValidationPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enablePasswordPolicy":
            suggest = "enable_password_policy"
        elif key == "disallowUsernameSubstring":
            suggest = "disallow_username_substring"
        elif key == "minLength":
            suggest = "min_length"
        elif key == "passwordChangeInterval":
            suggest = "password_change_interval"
        elif key == "reuseInterval":
            suggest = "reuse_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsPasswordValidationPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsPasswordValidationPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsPasswordValidationPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_password_policy: _builtins.bool,
                 complexity: Optional[_builtins.str] = None,
                 disallow_username_substring: Optional[_builtins.bool] = None,
                 min_length: Optional[_builtins.int] = None,
                 password_change_interval: Optional[_builtins.str] = None,
                 reuse_interval: Optional[_builtins.int] = None):
        """
        :param _builtins.bool enable_password_policy: Enables or disable the password validation policy.
        :param _builtins.str complexity: Checks if the password is a combination of lowercase, uppercase, numeric, and non-alphanumeric characters.
        :param _builtins.bool disallow_username_substring: Prevents the use of the username in the password.
        :param _builtins.int min_length: Specifies the minimum number of characters that the password must have.
        :param _builtins.str password_change_interval: Specifies the minimum duration after which you can change the password.
        :param _builtins.int reuse_interval: Specifies the number of previous passwords that you can't reuse.
        """
        pulumi.set(__self__, "enable_password_policy", enable_password_policy)
        if complexity is not None:
            pulumi.set(__self__, "complexity", complexity)
        if disallow_username_substring is not None:
            pulumi.set(__self__, "disallow_username_substring", disallow_username_substring)
        if min_length is not None:
            pulumi.set(__self__, "min_length", min_length)
        if password_change_interval is not None:
            pulumi.set(__self__, "password_change_interval", password_change_interval)
        if reuse_interval is not None:
            pulumi.set(__self__, "reuse_interval", reuse_interval)

    @_builtins.property
    @pulumi.getter(name="enablePasswordPolicy")
    def enable_password_policy(self) -> _builtins.bool:
        """
        Enables or disable the password validation policy.
        """
        return pulumi.get(self, "enable_password_policy")

    @_builtins.property
    @pulumi.getter
    def complexity(self) -> Optional[_builtins.str]:
        """
        Checks if the password is a combination of lowercase, uppercase, numeric, and non-alphanumeric characters.
        """
        return pulumi.get(self, "complexity")

    @_builtins.property
    @pulumi.getter(name="disallowUsernameSubstring")
    def disallow_username_substring(self) -> Optional[_builtins.bool]:
        """
        Prevents the use of the username in the password.
        """
        return pulumi.get(self, "disallow_username_substring")

    @_builtins.property
    @pulumi.getter(name="minLength")
    def min_length(self) -> Optional[_builtins.int]:
        """
        Specifies the minimum number of characters that the password must have.
        """
        return pulumi.get(self, "min_length")

    @_builtins.property
    @pulumi.getter(name="passwordChangeInterval")
    def password_change_interval(self) -> Optional[_builtins.str]:
        """
        Specifies the minimum duration after which you can change the password.
        """
        return pulumi.get(self, "password_change_interval")

    @_builtins.property
    @pulumi.getter(name="reuseInterval")
    def reuse_interval(self) -> Optional[_builtins.int]:
        """
        Specifies the number of previous passwords that you can't reuse.
        """
        return pulumi.get(self, "reuse_interval")


@pulumi.output_type
class DatabaseInstanceSettingsSqlServerAuditConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionInterval":
            suggest = "retention_interval"
        elif key == "uploadInterval":
            suggest = "upload_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsSqlServerAuditConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsSqlServerAuditConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsSqlServerAuditConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: Optional[_builtins.str] = None,
                 retention_interval: Optional[_builtins.str] = None,
                 upload_interval: Optional[_builtins.str] = None):
        """
        :param _builtins.str bucket: The name of the destination bucket (e.g., gs://mybucket).
        :param _builtins.str retention_interval: How long to keep generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param _builtins.str upload_interval: How often to upload generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if retention_interval is not None:
            pulumi.set(__self__, "retention_interval", retention_interval)
        if upload_interval is not None:
            pulumi.set(__self__, "upload_interval", upload_interval)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[_builtins.str]:
        """
        The name of the destination bucket (e.g., gs://mybucket).
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="retentionInterval")
    def retention_interval(self) -> Optional[_builtins.str]:
        """
        How long to keep generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "retention_interval")

    @_builtins.property
    @pulumi.getter(name="uploadInterval")
    def upload_interval(self) -> Optional[_builtins.str]:
        """
        How often to upload generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "upload_interval")


@pulumi.output_type
class UserPasswordPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedFailedAttempts":
            suggest = "allowed_failed_attempts"
        elif key == "enableFailedAttemptsCheck":
            suggest = "enable_failed_attempts_check"
        elif key == "enablePasswordVerification":
            suggest = "enable_password_verification"
        elif key == "passwordExpirationDuration":
            suggest = "password_expiration_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPasswordPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPasswordPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPasswordPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_failed_attempts: Optional[_builtins.int] = None,
                 enable_failed_attempts_check: Optional[_builtins.bool] = None,
                 enable_password_verification: Optional[_builtins.bool] = None,
                 password_expiration_duration: Optional[_builtins.str] = None,
                 statuses: Optional[Sequence['outputs.UserPasswordPolicyStatus']] = None):
        """
        :param _builtins.int allowed_failed_attempts: Number of failed attempts allowed before the user get locked.
        :param _builtins.bool enable_failed_attempts_check: If true, the check that will lock user after too many failed login attempts will be enabled.
        :param _builtins.bool enable_password_verification: If true, the user must specify the current password before changing the password. This flag is supported only for MySQL.
        :param _builtins.str password_expiration_duration: Password expiration duration with one week grace period.
        """
        if allowed_failed_attempts is not None:
            pulumi.set(__self__, "allowed_failed_attempts", allowed_failed_attempts)
        if enable_failed_attempts_check is not None:
            pulumi.set(__self__, "enable_failed_attempts_check", enable_failed_attempts_check)
        if enable_password_verification is not None:
            pulumi.set(__self__, "enable_password_verification", enable_password_verification)
        if password_expiration_duration is not None:
            pulumi.set(__self__, "password_expiration_duration", password_expiration_duration)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)

    @_builtins.property
    @pulumi.getter(name="allowedFailedAttempts")
    def allowed_failed_attempts(self) -> Optional[_builtins.int]:
        """
        Number of failed attempts allowed before the user get locked.
        """
        return pulumi.get(self, "allowed_failed_attempts")

    @_builtins.property
    @pulumi.getter(name="enableFailedAttemptsCheck")
    def enable_failed_attempts_check(self) -> Optional[_builtins.bool]:
        """
        If true, the check that will lock user after too many failed login attempts will be enabled.
        """
        return pulumi.get(self, "enable_failed_attempts_check")

    @_builtins.property
    @pulumi.getter(name="enablePasswordVerification")
    def enable_password_verification(self) -> Optional[_builtins.bool]:
        """
        If true, the user must specify the current password before changing the password. This flag is supported only for MySQL.
        """
        return pulumi.get(self, "enable_password_verification")

    @_builtins.property
    @pulumi.getter(name="passwordExpirationDuration")
    def password_expiration_duration(self) -> Optional[_builtins.str]:
        """
        Password expiration duration with one week grace period.
        """
        return pulumi.get(self, "password_expiration_duration")

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence['outputs.UserPasswordPolicyStatus']]:
        return pulumi.get(self, "statuses")


@pulumi.output_type
class UserPasswordPolicyStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordExpirationTime":
            suggest = "password_expiration_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPasswordPolicyStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPasswordPolicyStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPasswordPolicyStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 locked: Optional[_builtins.bool] = None,
                 password_expiration_time: Optional[_builtins.str] = None):
        """
        :param _builtins.bool locked: If true, user does not have login privileges.
        :param _builtins.str password_expiration_time: Password expiration duration with one week grace period.
        """
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if password_expiration_time is not None:
            pulumi.set(__self__, "password_expiration_time", password_expiration_time)

    @_builtins.property
    @pulumi.getter
    def locked(self) -> Optional[_builtins.bool]:
        """
        If true, user does not have login privileges.
        """
        return pulumi.get(self, "locked")

    @_builtins.property
    @pulumi.getter(name="passwordExpirationTime")
    def password_expiration_time(self) -> Optional[_builtins.str]:
        """
        Password expiration duration with one week grace period.
        """
        return pulumi.get(self, "password_expiration_time")


@pulumi.output_type
class UserSqlServerUserDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverRoles":
            suggest = "server_roles"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserSqlServerUserDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserSqlServerUserDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserSqlServerUserDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disabled: Optional[_builtins.bool] = None,
                 server_roles: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.bool disabled: If the user has been disabled.
        :param Sequence[_builtins.str] server_roles: The server roles for this user in the database.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if server_roles is not None:
            pulumi.set(__self__, "server_roles", server_roles)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[_builtins.bool]:
        """
        If the user has been disabled.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter(name="serverRoles")
    def server_roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        The server roles for this user in the database.
        """
        return pulumi.get(self, "server_roles")


@pulumi.output_type
class GetCaCertsCertResult(dict):
    def __init__(__self__, *,
                 cert: _builtins.str,
                 common_name: _builtins.str,
                 create_time: _builtins.str,
                 expiration_time: _builtins.str,
                 sha1_fingerprint: _builtins.str):
        """
        :param _builtins.str cert: The CA certificate used to connect to the SQL instance via SSL.
        :param _builtins.str common_name: The CN valid for the CA cert.
        :param _builtins.str create_time: Creation time of the CA cert.
        :param _builtins.str expiration_time: Expiration time of the CA cert.
        :param _builtins.str sha1_fingerprint: SHA1 fingerprint of the CA cert.
        """
        pulumi.set(__self__, "cert", cert)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @_builtins.property
    @pulumi.getter
    def cert(self) -> _builtins.str:
        """
        The CA certificate used to connect to the SQL instance via SSL.
        """
        return pulumi.get(self, "cert")

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> _builtins.str:
        """
        The CN valid for the CA cert.
        """
        return pulumi.get(self, "common_name")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        Creation time of the CA cert.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> _builtins.str:
        """
        Expiration time of the CA cert.
        """
        return pulumi.get(self, "expiration_time")

    @_builtins.property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> _builtins.str:
        """
        SHA1 fingerprint of the CA cert.
        """
        return pulumi.get(self, "sha1_fingerprint")


@pulumi.output_type
class GetDatabaseInstanceCloneResult(dict):
    def __init__(__self__, *,
                 allocated_ip_range: _builtins.str,
                 database_names: Sequence[_builtins.str],
                 point_in_time: _builtins.str,
                 preferred_zone: _builtins.str,
                 source_instance_name: _builtins.str):
        """
        :param _builtins.str allocated_ip_range: The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        :param Sequence[_builtins.str] database_names: (SQL Server only, use with point_in_time) clone only the specified databases from the source instance. Clone all databases if empty.
        :param _builtins.str point_in_time: The timestamp of the point in time that should be restored.
        :param _builtins.str preferred_zone: (Point-in-time recovery for PostgreSQL only) Clone to an instance in the specified zone. If no zone is specified, clone to the same zone as the source instance.
        :param _builtins.str source_instance_name: The name of the instance from which the point in time should be restored.
        """
        pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        pulumi.set(__self__, "database_names", database_names)
        pulumi.set(__self__, "point_in_time", point_in_time)
        pulumi.set(__self__, "preferred_zone", preferred_zone)
        pulumi.set(__self__, "source_instance_name", source_instance_name)

    @_builtins.property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> _builtins.str:
        """
        The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        """
        return pulumi.get(self, "allocated_ip_range")

    @_builtins.property
    @pulumi.getter(name="databaseNames")
    def database_names(self) -> Sequence[_builtins.str]:
        """
        (SQL Server only, use with point_in_time) clone only the specified databases from the source instance. Clone all databases if empty.
        """
        return pulumi.get(self, "database_names")

    @_builtins.property
    @pulumi.getter(name="pointInTime")
    def point_in_time(self) -> _builtins.str:
        """
        The timestamp of the point in time that should be restored.
        """
        return pulumi.get(self, "point_in_time")

    @_builtins.property
    @pulumi.getter(name="preferredZone")
    def preferred_zone(self) -> _builtins.str:
        """
        (Point-in-time recovery for PostgreSQL only) Clone to an instance in the specified zone. If no zone is specified, clone to the same zone as the source instance.
        """
        return pulumi.get(self, "preferred_zone")

    @_builtins.property
    @pulumi.getter(name="sourceInstanceName")
    def source_instance_name(self) -> _builtins.str:
        """
        The name of the instance from which the point in time should be restored.
        """
        return pulumi.get(self, "source_instance_name")


@pulumi.output_type
class GetDatabaseInstanceDnsNameResult(dict):
    def __init__(__self__, *,
                 connection_type: _builtins.str,
                 dns_scope: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str name: The name of the instance.
        """
        pulumi.set(__self__, "connection_type", connection_type)
        pulumi.set(__self__, "dns_scope", dns_scope)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> _builtins.str:
        return pulumi.get(self, "connection_type")

    @_builtins.property
    @pulumi.getter(name="dnsScope")
    def dns_scope(self) -> _builtins.str:
        return pulumi.get(self, "dns_scope")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the instance.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetDatabaseInstanceIpAddressResult(dict):
    def __init__(__self__, *,
                 ip_address: _builtins.str,
                 time_to_retire: _builtins.str,
                 type: _builtins.str):
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "time_to_retire", time_to_retire)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="timeToRetire")
    def time_to_retire(self) -> _builtins.str:
        return pulumi.get(self, "time_to_retire")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDatabaseInstanceReplicaConfigurationResult(dict):
    def __init__(__self__, *,
                 ca_certificate: _builtins.str,
                 cascadable_replica: _builtins.bool,
                 client_certificate: _builtins.str,
                 client_key: _builtins.str,
                 connect_retry_interval: _builtins.int,
                 dump_file_path: _builtins.str,
                 failover_target: _builtins.bool,
                 master_heartbeat_period: _builtins.int,
                 password: _builtins.str,
                 ssl_cipher: _builtins.str,
                 username: _builtins.str,
                 verify_server_certificate: _builtins.bool):
        """
        :param _builtins.str ca_certificate: PEM representation of the trusted CA's x509 certificate.
        :param _builtins.bool cascadable_replica: Specifies if a SQL Server replica is a cascadable replica. A cascadable replica is a SQL Server cross region replica that supports replica(s) under it.
        :param _builtins.str client_certificate: PEM representation of the replica's x509 certificate.
        :param _builtins.str client_key: PEM representation of the replica's private key. The corresponding public key in encoded in the client_certificate.
        :param _builtins.int connect_retry_interval: The number of seconds between connect retries. MySQL's default is 60 seconds.
        :param _builtins.str dump_file_path: Path to a SQL file in Google Cloud Storage from which replica instances are created. Format is gs://bucket/filename.
        :param _builtins.bool failover_target: Specifies if the replica is the failover target. If the field is set to true the replica will be designated as a failover replica. If the master instance fails, the replica instance will be promoted as the new master instance. Not supported for Postgres
        :param _builtins.int master_heartbeat_period: Time in ms between replication heartbeats.
        :param _builtins.str password: Password for the replication connection.
        :param _builtins.str ssl_cipher: Permissible ciphers for use in SSL encryption.
        :param _builtins.str username: Username for replication connection.
        :param _builtins.bool verify_server_certificate: True if the master's common name value is checked during the SSL handshake.
        """
        pulumi.set(__self__, "ca_certificate", ca_certificate)
        pulumi.set(__self__, "cascadable_replica", cascadable_replica)
        pulumi.set(__self__, "client_certificate", client_certificate)
        pulumi.set(__self__, "client_key", client_key)
        pulumi.set(__self__, "connect_retry_interval", connect_retry_interval)
        pulumi.set(__self__, "dump_file_path", dump_file_path)
        pulumi.set(__self__, "failover_target", failover_target)
        pulumi.set(__self__, "master_heartbeat_period", master_heartbeat_period)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "ssl_cipher", ssl_cipher)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "verify_server_certificate", verify_server_certificate)

    @_builtins.property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> _builtins.str:
        """
        PEM representation of the trusted CA's x509 certificate.
        """
        return pulumi.get(self, "ca_certificate")

    @_builtins.property
    @pulumi.getter(name="cascadableReplica")
    def cascadable_replica(self) -> _builtins.bool:
        """
        Specifies if a SQL Server replica is a cascadable replica. A cascadable replica is a SQL Server cross region replica that supports replica(s) under it.
        """
        return pulumi.get(self, "cascadable_replica")

    @_builtins.property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> _builtins.str:
        """
        PEM representation of the replica's x509 certificate.
        """
        return pulumi.get(self, "client_certificate")

    @_builtins.property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> _builtins.str:
        """
        PEM representation of the replica's private key. The corresponding public key in encoded in the client_certificate.
        """
        return pulumi.get(self, "client_key")

    @_builtins.property
    @pulumi.getter(name="connectRetryInterval")
    def connect_retry_interval(self) -> _builtins.int:
        """
        The number of seconds between connect retries. MySQL's default is 60 seconds.
        """
        return pulumi.get(self, "connect_retry_interval")

    @_builtins.property
    @pulumi.getter(name="dumpFilePath")
    def dump_file_path(self) -> _builtins.str:
        """
        Path to a SQL file in Google Cloud Storage from which replica instances are created. Format is gs://bucket/filename.
        """
        return pulumi.get(self, "dump_file_path")

    @_builtins.property
    @pulumi.getter(name="failoverTarget")
    def failover_target(self) -> _builtins.bool:
        """
        Specifies if the replica is the failover target. If the field is set to true the replica will be designated as a failover replica. If the master instance fails, the replica instance will be promoted as the new master instance. Not supported for Postgres
        """
        return pulumi.get(self, "failover_target")

    @_builtins.property
    @pulumi.getter(name="masterHeartbeatPeriod")
    def master_heartbeat_period(self) -> _builtins.int:
        """
        Time in ms between replication heartbeats.
        """
        return pulumi.get(self, "master_heartbeat_period")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        Password for the replication connection.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="sslCipher")
    def ssl_cipher(self) -> _builtins.str:
        """
        Permissible ciphers for use in SSL encryption.
        """
        return pulumi.get(self, "ssl_cipher")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        Username for replication connection.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="verifyServerCertificate")
    def verify_server_certificate(self) -> _builtins.bool:
        """
        True if the master's common name value is checked during the SSL handshake.
        """
        return pulumi.get(self, "verify_server_certificate")


@pulumi.output_type
class GetDatabaseInstanceReplicationClusterResult(dict):
    def __init__(__self__, *,
                 dr_replica: _builtins.bool,
                 failover_dr_replica_name: _builtins.str,
                 psa_write_endpoint: _builtins.str):
        """
        :param _builtins.bool dr_replica: Read-only field that indicates whether the replica is a DR replica.
        :param _builtins.str failover_dr_replica_name: If the instance is a primary instance, then this field identifies the disaster recovery (DR) replica. The standard format of this field is "your-project:your-instance". You can also set this field to "your-instance", but cloud SQL backend will convert it to the aforementioned standard format.
        :param _builtins.str psa_write_endpoint: If set, this field indicates this instance has a private service access (PSA) DNS endpoint that is pointing to the primary instance of the cluster. If this instance is the primary, then the DNS endpoint points to this instance. After a switchover or replica failover operation, this DNS endpoint points to the promoted instance. This is a read-only field, returned to the user as information. This field can exist even if a standalone instance doesn't have a DR replica yet or the DR replica is deleted.
        """
        pulumi.set(__self__, "dr_replica", dr_replica)
        pulumi.set(__self__, "failover_dr_replica_name", failover_dr_replica_name)
        pulumi.set(__self__, "psa_write_endpoint", psa_write_endpoint)

    @_builtins.property
    @pulumi.getter(name="drReplica")
    def dr_replica(self) -> _builtins.bool:
        """
        Read-only field that indicates whether the replica is a DR replica.
        """
        return pulumi.get(self, "dr_replica")

    @_builtins.property
    @pulumi.getter(name="failoverDrReplicaName")
    def failover_dr_replica_name(self) -> _builtins.str:
        """
        If the instance is a primary instance, then this field identifies the disaster recovery (DR) replica. The standard format of this field is "your-project:your-instance". You can also set this field to "your-instance", but cloud SQL backend will convert it to the aforementioned standard format.
        """
        return pulumi.get(self, "failover_dr_replica_name")

    @_builtins.property
    @pulumi.getter(name="psaWriteEndpoint")
    def psa_write_endpoint(self) -> _builtins.str:
        """
        If set, this field indicates this instance has a private service access (PSA) DNS endpoint that is pointing to the primary instance of the cluster. If this instance is the primary, then the DNS endpoint points to this instance. After a switchover or replica failover operation, this DNS endpoint points to the promoted instance. This is a read-only field, returned to the user as information. This field can exist even if a standalone instance doesn't have a DR replica yet or the DR replica is deleted.
        """
        return pulumi.get(self, "psa_write_endpoint")


@pulumi.output_type
class GetDatabaseInstanceRestoreBackupContextResult(dict):
    def __init__(__self__, *,
                 backup_run_id: _builtins.int,
                 instance_id: _builtins.str,
                 project: _builtins.str):
        """
        :param _builtins.int backup_run_id: The ID of the backup run to restore from.
        :param _builtins.str instance_id: The ID of the instance that the backup was taken from.
        :param _builtins.str project: The ID of the project in which the resource belongs.
        """
        pulumi.set(__self__, "backup_run_id", backup_run_id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="backupRunId")
    def backup_run_id(self) -> _builtins.int:
        """
        The ID of the backup run to restore from.
        """
        return pulumi.get(self, "backup_run_id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The ID of the instance that the backup was taken from.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The ID of the project in which the resource belongs.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class GetDatabaseInstanceServerCaCertResult(dict):
    def __init__(__self__, *,
                 cert: _builtins.str,
                 common_name: _builtins.str,
                 create_time: _builtins.str,
                 expiration_time: _builtins.str,
                 sha1_fingerprint: _builtins.str):
        """
        :param _builtins.str cert: The CA Certificate used to connect to the SQL Instance via SSL.
        :param _builtins.str common_name: The CN valid for the CA Cert.
        :param _builtins.str create_time: Creation time of the CA Cert.
        :param _builtins.str expiration_time: Expiration time of the CA Cert.
        :param _builtins.str sha1_fingerprint: SHA Fingerprint of the CA Cert.
        """
        pulumi.set(__self__, "cert", cert)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @_builtins.property
    @pulumi.getter
    def cert(self) -> _builtins.str:
        """
        The CA Certificate used to connect to the SQL Instance via SSL.
        """
        return pulumi.get(self, "cert")

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> _builtins.str:
        """
        The CN valid for the CA Cert.
        """
        return pulumi.get(self, "common_name")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        Creation time of the CA Cert.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> _builtins.str:
        """
        Expiration time of the CA Cert.
        """
        return pulumi.get(self, "expiration_time")

    @_builtins.property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> _builtins.str:
        """
        SHA Fingerprint of the CA Cert.
        """
        return pulumi.get(self, "sha1_fingerprint")


@pulumi.output_type
class GetDatabaseInstanceSettingResult(dict):
    def __init__(__self__, *,
                 activation_policy: _builtins.str,
                 active_directory_configs: Sequence['outputs.GetDatabaseInstanceSettingActiveDirectoryConfigResult'],
                 advanced_machine_features: Sequence['outputs.GetDatabaseInstanceSettingAdvancedMachineFeatureResult'],
                 availability_type: _builtins.str,
                 backup_configurations: Sequence['outputs.GetDatabaseInstanceSettingBackupConfigurationResult'],
                 collation: _builtins.str,
                 connection_pool_configs: Sequence['outputs.GetDatabaseInstanceSettingConnectionPoolConfigResult'],
                 connector_enforcement: _builtins.str,
                 data_cache_configs: Sequence['outputs.GetDatabaseInstanceSettingDataCacheConfigResult'],
                 data_disk_provisioned_iops: _builtins.int,
                 data_disk_provisioned_throughput: _builtins.int,
                 database_flags: Sequence['outputs.GetDatabaseInstanceSettingDatabaseFlagResult'],
                 deletion_protection_enabled: _builtins.bool,
                 deny_maintenance_periods: Sequence['outputs.GetDatabaseInstanceSettingDenyMaintenancePeriodResult'],
                 disk_autoresize: _builtins.bool,
                 disk_autoresize_limit: _builtins.int,
                 disk_size: _builtins.int,
                 disk_type: _builtins.str,
                 edition: _builtins.str,
                 effective_availability_type: _builtins.str,
                 enable_dataplex_integration: _builtins.bool,
                 enable_google_ml_integration: _builtins.bool,
                 final_backup_configs: Sequence['outputs.GetDatabaseInstanceSettingFinalBackupConfigResult'],
                 insights_configs: Sequence['outputs.GetDatabaseInstanceSettingInsightsConfigResult'],
                 ip_configurations: Sequence['outputs.GetDatabaseInstanceSettingIpConfigurationResult'],
                 location_preferences: Sequence['outputs.GetDatabaseInstanceSettingLocationPreferenceResult'],
                 maintenance_windows: Sequence['outputs.GetDatabaseInstanceSettingMaintenanceWindowResult'],
                 password_validation_policies: Sequence['outputs.GetDatabaseInstanceSettingPasswordValidationPolicyResult'],
                 pricing_plan: _builtins.str,
                 retain_backups_on_delete: _builtins.bool,
                 sql_server_audit_configs: Sequence['outputs.GetDatabaseInstanceSettingSqlServerAuditConfigResult'],
                 tier: _builtins.str,
                 time_zone: _builtins.str,
                 user_labels: Mapping[str, _builtins.str],
                 version: _builtins.int):
        """
        :param _builtins.str activation_policy: This specifies when the instance should be active. Can be either ALWAYS, NEVER or ON_DEMAND.
        :param _builtins.str availability_type: The availability type of the Cloud SQL instance, high availability
               (REGIONAL) or single zone (ZONAL). For all instances, ensure that
               settings.backup_configuration.enabled is set to true.
               For MySQL instances, ensure that settings.backup_configuration.binary_log_enabled is set to true.
               For Postgres instances, ensure that settings.backup_configuration.point_in_time_recovery_enabled
               is set to true. Defaults to ZONAL.
               For read pool instances, this field is read-only. The availability type is changed by specifying
               the number of nodes (node_count).
        :param _builtins.str collation: The name of server instance collation.
        :param Sequence['GetDatabaseInstanceSettingConnectionPoolConfigArgs'] connection_pool_configs: The managed connection pool setting for a Cloud SQL instance.
        :param _builtins.str connector_enforcement: Enables the enforcement of Cloud SQL Auth Proxy or Cloud SQL connectors for all the connections. If enabled, all the direct connections are rejected.
        :param Sequence['GetDatabaseInstanceSettingDataCacheConfigArgs'] data_cache_configs: Data cache configurations.
        :param _builtins.int data_disk_provisioned_iops: Provisioned number of I/O operations per second for the data disk. This field is only used for HYPERDISK_BALANCED disk types.
        :param _builtins.int data_disk_provisioned_throughput: Provisioned throughput measured in MiB per second for the data disk. This field is only used for HYPERDISK_BALANCED disk types.
        :param _builtins.bool deletion_protection_enabled: Configuration to protect against accidental instance deletion.
        :param _builtins.bool disk_autoresize: Enables auto-resizing of the storage size. Defaults to true.
        :param _builtins.int disk_autoresize_limit: The maximum size, in GB, to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        :param _builtins.int disk_size: The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased. The minimum value is 10GB for PD_SSD, PD_HDD and 20GB for HYPERDISK_BALANCED.
        :param _builtins.str disk_type: The type of supported data disk is tier dependent and can be PD_SSD or PD_HDD or HYPERDISK_BALANCED.
        :param _builtins.str edition: The edition of the instance, can be ENTERPRISE or ENTERPRISE_PLUS.
        :param _builtins.str effective_availability_type: The availability type of the Cloud SQL instance, high availability
               (REGIONAL) or single zone (ZONAL). This field always contains the value that is reported by the
               API (for read pools, effective_availability_type may differ from availability_type).
        :param _builtins.bool enable_dataplex_integration: Enables Dataplex Integration.
        :param _builtins.bool enable_google_ml_integration: Enables Vertex AI Integration.
        :param Sequence['GetDatabaseInstanceSettingFinalBackupConfigArgs'] final_backup_configs: Config used to determine the final backup settings for the instance
        :param Sequence['GetDatabaseInstanceSettingInsightsConfigArgs'] insights_configs: Configuration of Query Insights.
        :param Sequence['GetDatabaseInstanceSettingMaintenanceWindowArgs'] maintenance_windows: Declares a one-hour maintenance window when an Instance can automatically restart to apply updates. The maintenance window is specified in UTC time.
        :param _builtins.str pricing_plan: Pricing plan for this instance, can only be PER_USE.
        :param _builtins.bool retain_backups_on_delete: When this parameter is set to true, Cloud SQL retains backups of the instance even after the instance is deleted. The ON_DEMAND backup will be retained until customer deletes the backup or the project. The AUTOMATED backup will be retained based on the backups retention setting.
        :param _builtins.str tier: The machine type to use. See tiers for more details and supported versions. Postgres supports only shared-core machine types, and custom machine types such as db-custom-2-13312. See the Custom Machine Type Documentation to learn about specifying custom machine types.
        :param _builtins.str time_zone: The time_zone to be used by the database engine (supported only for SQL Server), in SQL Server timezone format.
        :param Mapping[str, _builtins.str] user_labels: A set of key/value user label pairs to assign to the instance.
        :param _builtins.int version: Used to make sure changes to the settings block are atomic.
        """
        pulumi.set(__self__, "activation_policy", activation_policy)
        pulumi.set(__self__, "active_directory_configs", active_directory_configs)
        pulumi.set(__self__, "advanced_machine_features", advanced_machine_features)
        pulumi.set(__self__, "availability_type", availability_type)
        pulumi.set(__self__, "backup_configurations", backup_configurations)
        pulumi.set(__self__, "collation", collation)
        pulumi.set(__self__, "connection_pool_configs", connection_pool_configs)
        pulumi.set(__self__, "connector_enforcement", connector_enforcement)
        pulumi.set(__self__, "data_cache_configs", data_cache_configs)
        pulumi.set(__self__, "data_disk_provisioned_iops", data_disk_provisioned_iops)
        pulumi.set(__self__, "data_disk_provisioned_throughput", data_disk_provisioned_throughput)
        pulumi.set(__self__, "database_flags", database_flags)
        pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        pulumi.set(__self__, "deny_maintenance_periods", deny_maintenance_periods)
        pulumi.set(__self__, "disk_autoresize", disk_autoresize)
        pulumi.set(__self__, "disk_autoresize_limit", disk_autoresize_limit)
        pulumi.set(__self__, "disk_size", disk_size)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "edition", edition)
        pulumi.set(__self__, "effective_availability_type", effective_availability_type)
        pulumi.set(__self__, "enable_dataplex_integration", enable_dataplex_integration)
        pulumi.set(__self__, "enable_google_ml_integration", enable_google_ml_integration)
        pulumi.set(__self__, "final_backup_configs", final_backup_configs)
        pulumi.set(__self__, "insights_configs", insights_configs)
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        pulumi.set(__self__, "location_preferences", location_preferences)
        pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        pulumi.set(__self__, "password_validation_policies", password_validation_policies)
        pulumi.set(__self__, "pricing_plan", pricing_plan)
        pulumi.set(__self__, "retain_backups_on_delete", retain_backups_on_delete)
        pulumi.set(__self__, "sql_server_audit_configs", sql_server_audit_configs)
        pulumi.set(__self__, "tier", tier)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "user_labels", user_labels)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="activationPolicy")
    def activation_policy(self) -> _builtins.str:
        """
        This specifies when the instance should be active. Can be either ALWAYS, NEVER or ON_DEMAND.
        """
        return pulumi.get(self, "activation_policy")

    @_builtins.property
    @pulumi.getter(name="activeDirectoryConfigs")
    def active_directory_configs(self) -> Sequence['outputs.GetDatabaseInstanceSettingActiveDirectoryConfigResult']:
        return pulumi.get(self, "active_directory_configs")

    @_builtins.property
    @pulumi.getter(name="advancedMachineFeatures")
    def advanced_machine_features(self) -> Sequence['outputs.GetDatabaseInstanceSettingAdvancedMachineFeatureResult']:
        return pulumi.get(self, "advanced_machine_features")

    @_builtins.property
    @pulumi.getter(name="availabilityType")
    def availability_type(self) -> _builtins.str:
        """
        The availability type of the Cloud SQL instance, high availability
        (REGIONAL) or single zone (ZONAL). For all instances, ensure that
        settings.backup_configuration.enabled is set to true.
        For MySQL instances, ensure that settings.backup_configuration.binary_log_enabled is set to true.
        For Postgres instances, ensure that settings.backup_configuration.point_in_time_recovery_enabled
        is set to true. Defaults to ZONAL.
        For read pool instances, this field is read-only. The availability type is changed by specifying
        the number of nodes (node_count).
        """
        return pulumi.get(self, "availability_type")

    @_builtins.property
    @pulumi.getter(name="backupConfigurations")
    def backup_configurations(self) -> Sequence['outputs.GetDatabaseInstanceSettingBackupConfigurationResult']:
        return pulumi.get(self, "backup_configurations")

    @_builtins.property
    @pulumi.getter
    def collation(self) -> _builtins.str:
        """
        The name of server instance collation.
        """
        return pulumi.get(self, "collation")

    @_builtins.property
    @pulumi.getter(name="connectionPoolConfigs")
    def connection_pool_configs(self) -> Sequence['outputs.GetDatabaseInstanceSettingConnectionPoolConfigResult']:
        """
        The managed connection pool setting for a Cloud SQL instance.
        """
        return pulumi.get(self, "connection_pool_configs")

    @_builtins.property
    @pulumi.getter(name="connectorEnforcement")
    def connector_enforcement(self) -> _builtins.str:
        """
        Enables the enforcement of Cloud SQL Auth Proxy or Cloud SQL connectors for all the connections. If enabled, all the direct connections are rejected.
        """
        return pulumi.get(self, "connector_enforcement")

    @_builtins.property
    @pulumi.getter(name="dataCacheConfigs")
    def data_cache_configs(self) -> Sequence['outputs.GetDatabaseInstanceSettingDataCacheConfigResult']:
        """
        Data cache configurations.
        """
        return pulumi.get(self, "data_cache_configs")

    @_builtins.property
    @pulumi.getter(name="dataDiskProvisionedIops")
    def data_disk_provisioned_iops(self) -> _builtins.int:
        """
        Provisioned number of I/O operations per second for the data disk. This field is only used for HYPERDISK_BALANCED disk types.
        """
        return pulumi.get(self, "data_disk_provisioned_iops")

    @_builtins.property
    @pulumi.getter(name="dataDiskProvisionedThroughput")
    def data_disk_provisioned_throughput(self) -> _builtins.int:
        """
        Provisioned throughput measured in MiB per second for the data disk. This field is only used for HYPERDISK_BALANCED disk types.
        """
        return pulumi.get(self, "data_disk_provisioned_throughput")

    @_builtins.property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Sequence['outputs.GetDatabaseInstanceSettingDatabaseFlagResult']:
        return pulumi.get(self, "database_flags")

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> _builtins.bool:
        """
        Configuration to protect against accidental instance deletion.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @_builtins.property
    @pulumi.getter(name="denyMaintenancePeriods")
    def deny_maintenance_periods(self) -> Sequence['outputs.GetDatabaseInstanceSettingDenyMaintenancePeriodResult']:
        return pulumi.get(self, "deny_maintenance_periods")

    @_builtins.property
    @pulumi.getter(name="diskAutoresize")
    def disk_autoresize(self) -> _builtins.bool:
        """
        Enables auto-resizing of the storage size. Defaults to true.
        """
        return pulumi.get(self, "disk_autoresize")

    @_builtins.property
    @pulumi.getter(name="diskAutoresizeLimit")
    def disk_autoresize_limit(self) -> _builtins.int:
        """
        The maximum size, in GB, to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        """
        return pulumi.get(self, "disk_autoresize_limit")

    @_builtins.property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> _builtins.int:
        """
        The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased. The minimum value is 10GB for PD_SSD, PD_HDD and 20GB for HYPERDISK_BALANCED.
        """
        return pulumi.get(self, "disk_size")

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> _builtins.str:
        """
        The type of supported data disk is tier dependent and can be PD_SSD or PD_HDD or HYPERDISK_BALANCED.
        """
        return pulumi.get(self, "disk_type")

    @_builtins.property
    @pulumi.getter
    def edition(self) -> _builtins.str:
        """
        The edition of the instance, can be ENTERPRISE or ENTERPRISE_PLUS.
        """
        return pulumi.get(self, "edition")

    @_builtins.property
    @pulumi.getter(name="effectiveAvailabilityType")
    def effective_availability_type(self) -> _builtins.str:
        """
        The availability type of the Cloud SQL instance, high availability
        (REGIONAL) or single zone (ZONAL). This field always contains the value that is reported by the
        API (for read pools, effective_availability_type may differ from availability_type).
        """
        return pulumi.get(self, "effective_availability_type")

    @_builtins.property
    @pulumi.getter(name="enableDataplexIntegration")
    def enable_dataplex_integration(self) -> _builtins.bool:
        """
        Enables Dataplex Integration.
        """
        return pulumi.get(self, "enable_dataplex_integration")

    @_builtins.property
    @pulumi.getter(name="enableGoogleMlIntegration")
    def enable_google_ml_integration(self) -> _builtins.bool:
        """
        Enables Vertex AI Integration.
        """
        return pulumi.get(self, "enable_google_ml_integration")

    @_builtins.property
    @pulumi.getter(name="finalBackupConfigs")
    def final_backup_configs(self) -> Sequence['outputs.GetDatabaseInstanceSettingFinalBackupConfigResult']:
        """
        Config used to determine the final backup settings for the instance
        """
        return pulumi.get(self, "final_backup_configs")

    @_builtins.property
    @pulumi.getter(name="insightsConfigs")
    def insights_configs(self) -> Sequence['outputs.GetDatabaseInstanceSettingInsightsConfigResult']:
        """
        Configuration of Query Insights.
        """
        return pulumi.get(self, "insights_configs")

    @_builtins.property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Sequence['outputs.GetDatabaseInstanceSettingIpConfigurationResult']:
        return pulumi.get(self, "ip_configurations")

    @_builtins.property
    @pulumi.getter(name="locationPreferences")
    def location_preferences(self) -> Sequence['outputs.GetDatabaseInstanceSettingLocationPreferenceResult']:
        return pulumi.get(self, "location_preferences")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Sequence['outputs.GetDatabaseInstanceSettingMaintenanceWindowResult']:
        """
        Declares a one-hour maintenance window when an Instance can automatically restart to apply updates. The maintenance window is specified in UTC time.
        """
        return pulumi.get(self, "maintenance_windows")

    @_builtins.property
    @pulumi.getter(name="passwordValidationPolicies")
    def password_validation_policies(self) -> Sequence['outputs.GetDatabaseInstanceSettingPasswordValidationPolicyResult']:
        return pulumi.get(self, "password_validation_policies")

    @_builtins.property
    @pulumi.getter(name="pricingPlan")
    def pricing_plan(self) -> _builtins.str:
        """
        Pricing plan for this instance, can only be PER_USE.
        """
        return pulumi.get(self, "pricing_plan")

    @_builtins.property
    @pulumi.getter(name="retainBackupsOnDelete")
    def retain_backups_on_delete(self) -> _builtins.bool:
        """
        When this parameter is set to true, Cloud SQL retains backups of the instance even after the instance is deleted. The ON_DEMAND backup will be retained until customer deletes the backup or the project. The AUTOMATED backup will be retained based on the backups retention setting.
        """
        return pulumi.get(self, "retain_backups_on_delete")

    @_builtins.property
    @pulumi.getter(name="sqlServerAuditConfigs")
    def sql_server_audit_configs(self) -> Sequence['outputs.GetDatabaseInstanceSettingSqlServerAuditConfigResult']:
        return pulumi.get(self, "sql_server_audit_configs")

    @_builtins.property
    @pulumi.getter
    def tier(self) -> _builtins.str:
        """
        The machine type to use. See tiers for more details and supported versions. Postgres supports only shared-core machine types, and custom machine types such as db-custom-2-13312. See the Custom Machine Type Documentation to learn about specifying custom machine types.
        """
        return pulumi.get(self, "tier")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> _builtins.str:
        """
        The time_zone to be used by the database engine (supported only for SQL Server), in SQL Server timezone format.
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Mapping[str, _builtins.str]:
        """
        A set of key/value user label pairs to assign to the instance.
        """
        return pulumi.get(self, "user_labels")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.int:
        """
        Used to make sure changes to the settings block are atomic.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetDatabaseInstanceSettingActiveDirectoryConfigResult(dict):
    def __init__(__self__, *,
                 domain: _builtins.str):
        """
        :param _builtins.str domain: Domain name of the Active Directory for SQL Server (e.g., mydomain.com).
        """
        pulumi.set(__self__, "domain", domain)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        Domain name of the Active Directory for SQL Server (e.g., mydomain.com).
        """
        return pulumi.get(self, "domain")


@pulumi.output_type
class GetDatabaseInstanceSettingAdvancedMachineFeatureResult(dict):
    def __init__(__self__, *,
                 threads_per_core: _builtins.int):
        """
        :param _builtins.int threads_per_core: The number of threads per physical core. Can be 1 or 2.
        """
        pulumi.set(__self__, "threads_per_core", threads_per_core)

    @_builtins.property
    @pulumi.getter(name="threadsPerCore")
    def threads_per_core(self) -> _builtins.int:
        """
        The number of threads per physical core. Can be 1 or 2.
        """
        return pulumi.get(self, "threads_per_core")


@pulumi.output_type
class GetDatabaseInstanceSettingBackupConfigurationResult(dict):
    def __init__(__self__, *,
                 backup_retention_settings: Sequence['outputs.GetDatabaseInstanceSettingBackupConfigurationBackupRetentionSettingResult'],
                 binary_log_enabled: _builtins.bool,
                 enabled: _builtins.bool,
                 location: _builtins.str,
                 point_in_time_recovery_enabled: _builtins.bool,
                 start_time: _builtins.str,
                 transaction_log_retention_days: _builtins.int):
        """
        :param _builtins.bool binary_log_enabled: True if binary logging is enabled. If settings.backup_configuration.enabled is false, this must be as well. Can only be used with MySQL.
        :param _builtins.bool enabled: True if backup configuration is enabled.
        :param _builtins.str location: Location of the backup configuration.
        :param _builtins.bool point_in_time_recovery_enabled: True if Point-in-time recovery is enabled.
        :param _builtins.str start_time: HH:MM format time indicating when backup configuration starts.
        :param _builtins.int transaction_log_retention_days: The number of days of transaction logs we retain for point in time restore, from 1-7. (For PostgreSQL Enterprise Plus instances, from 1 to 35.)
        """
        pulumi.set(__self__, "backup_retention_settings", backup_retention_settings)
        pulumi.set(__self__, "binary_log_enabled", binary_log_enabled)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "point_in_time_recovery_enabled", point_in_time_recovery_enabled)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "transaction_log_retention_days", transaction_log_retention_days)

    @_builtins.property
    @pulumi.getter(name="backupRetentionSettings")
    def backup_retention_settings(self) -> Sequence['outputs.GetDatabaseInstanceSettingBackupConfigurationBackupRetentionSettingResult']:
        return pulumi.get(self, "backup_retention_settings")

    @_builtins.property
    @pulumi.getter(name="binaryLogEnabled")
    def binary_log_enabled(self) -> _builtins.bool:
        """
        True if binary logging is enabled. If settings.backup_configuration.enabled is false, this must be as well. Can only be used with MySQL.
        """
        return pulumi.get(self, "binary_log_enabled")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        True if backup configuration is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        Location of the backup configuration.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="pointInTimeRecoveryEnabled")
    def point_in_time_recovery_enabled(self) -> _builtins.bool:
        """
        True if Point-in-time recovery is enabled.
        """
        return pulumi.get(self, "point_in_time_recovery_enabled")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.str:
        """
        HH:MM format time indicating when backup configuration starts.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter(name="transactionLogRetentionDays")
    def transaction_log_retention_days(self) -> _builtins.int:
        """
        The number of days of transaction logs we retain for point in time restore, from 1-7. (For PostgreSQL Enterprise Plus instances, from 1 to 35.)
        """
        return pulumi.get(self, "transaction_log_retention_days")


@pulumi.output_type
class GetDatabaseInstanceSettingBackupConfigurationBackupRetentionSettingResult(dict):
    def __init__(__self__, *,
                 retained_backups: _builtins.int,
                 retention_unit: _builtins.str):
        """
        :param _builtins.int retained_backups: Number of backups to retain.
        :param _builtins.str retention_unit: The unit that 'retainedBackups' represents. Defaults to COUNT
        """
        pulumi.set(__self__, "retained_backups", retained_backups)
        pulumi.set(__self__, "retention_unit", retention_unit)

    @_builtins.property
    @pulumi.getter(name="retainedBackups")
    def retained_backups(self) -> _builtins.int:
        """
        Number of backups to retain.
        """
        return pulumi.get(self, "retained_backups")

    @_builtins.property
    @pulumi.getter(name="retentionUnit")
    def retention_unit(self) -> _builtins.str:
        """
        The unit that 'retainedBackups' represents. Defaults to COUNT
        """
        return pulumi.get(self, "retention_unit")


@pulumi.output_type
class GetDatabaseInstanceSettingConnectionPoolConfigResult(dict):
    def __init__(__self__, *,
                 connection_pooling_enabled: _builtins.bool,
                 flags: Sequence['outputs.GetDatabaseInstanceSettingConnectionPoolConfigFlagResult']):
        """
        :param _builtins.bool connection_pooling_enabled: Whether Managed Connection Pool is enabled for this instance.
        :param Sequence['GetDatabaseInstanceSettingConnectionPoolConfigFlagArgs'] flags: List of connection pool configuration flags
        """
        pulumi.set(__self__, "connection_pooling_enabled", connection_pooling_enabled)
        pulumi.set(__self__, "flags", flags)

    @_builtins.property
    @pulumi.getter(name="connectionPoolingEnabled")
    def connection_pooling_enabled(self) -> _builtins.bool:
        """
        Whether Managed Connection Pool is enabled for this instance.
        """
        return pulumi.get(self, "connection_pooling_enabled")

    @_builtins.property
    @pulumi.getter
    def flags(self) -> Sequence['outputs.GetDatabaseInstanceSettingConnectionPoolConfigFlagResult']:
        """
        List of connection pool configuration flags
        """
        return pulumi.get(self, "flags")


@pulumi.output_type
class GetDatabaseInstanceSettingConnectionPoolConfigFlagResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The name of the instance.
        :param _builtins.str value: Value of the flag.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the flag.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDatabaseInstanceSettingDataCacheConfigResult(dict):
    def __init__(__self__, *,
                 data_cache_enabled: _builtins.bool):
        """
        :param _builtins.bool data_cache_enabled: Whether data cache is enabled for the instance.
        """
        pulumi.set(__self__, "data_cache_enabled", data_cache_enabled)

    @_builtins.property
    @pulumi.getter(name="dataCacheEnabled")
    def data_cache_enabled(self) -> _builtins.bool:
        """
        Whether data cache is enabled for the instance.
        """
        return pulumi.get(self, "data_cache_enabled")


@pulumi.output_type
class GetDatabaseInstanceSettingDatabaseFlagResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The name of the instance.
        :param _builtins.str value: Value of the flag.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the flag.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDatabaseInstanceSettingDenyMaintenancePeriodResult(dict):
    def __init__(__self__, *,
                 end_date: _builtins.str,
                 start_date: _builtins.str,
                 time: _builtins.str):
        """
        :param _builtins.str end_date: End date before which maintenance will not take place. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        :param _builtins.str start_date: Start date after which maintenance will not take place. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        :param _builtins.str time: Time in UTC when the "deny maintenance period" starts on start_date and ends on end_date. The time is in format: HH:mm:SS, i.e., 00:00:00
        """
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "start_date", start_date)
        pulumi.set(__self__, "time", time)

    @_builtins.property
    @pulumi.getter(name="endDate")
    def end_date(self) -> _builtins.str:
        """
        End date before which maintenance will not take place. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        """
        return pulumi.get(self, "end_date")

    @_builtins.property
    @pulumi.getter(name="startDate")
    def start_date(self) -> _builtins.str:
        """
        Start date after which maintenance will not take place. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        """
        return pulumi.get(self, "start_date")

    @_builtins.property
    @pulumi.getter
    def time(self) -> _builtins.str:
        """
        Time in UTC when the "deny maintenance period" starts on start_date and ends on end_date. The time is in format: HH:mm:SS, i.e., 00:00:00
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class GetDatabaseInstanceSettingFinalBackupConfigResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 retention_days: _builtins.int):
        """
        :param _builtins.bool enabled: When this parameter is set to true, the final backup is enabled for the instance
        :param _builtins.int retention_days: The number of days to retain the final backup after the instance deletion. The valid range is between 1 and 365. For instances managed by BackupDR, the valid range is between 1 day and 99 years. The final backup will be purged at (time_of_instance_deletion + retention_days).
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "retention_days", retention_days)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        When this parameter is set to true, the final backup is enabled for the instance
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> _builtins.int:
        """
        The number of days to retain the final backup after the instance deletion. The valid range is between 1 and 365. For instances managed by BackupDR, the valid range is between 1 day and 99 years. The final backup will be purged at (time_of_instance_deletion + retention_days).
        """
        return pulumi.get(self, "retention_days")


@pulumi.output_type
class GetDatabaseInstanceSettingInsightsConfigResult(dict):
    def __init__(__self__, *,
                 query_insights_enabled: _builtins.bool,
                 query_plans_per_minute: _builtins.int,
                 query_string_length: _builtins.int,
                 record_application_tags: _builtins.bool,
                 record_client_address: _builtins.bool):
        """
        :param _builtins.bool query_insights_enabled: True if Query Insights feature is enabled.
        :param _builtins.int query_plans_per_minute: Number of query execution plans captured by Insights per minute for all queries combined. Between 0 and 20. Default to 5. For Enterprise Plus instances, from 0 to 200.
        :param _builtins.int query_string_length: Maximum query length stored in bytes. Between 256 and 4500. Default to 1024. For Enterprise Plus instances, from 1 to 1048576.
        :param _builtins.bool record_application_tags: True if Query Insights will record application tags from query when enabled.
        :param _builtins.bool record_client_address: True if Query Insights will record client address when enabled.
        """
        pulumi.set(__self__, "query_insights_enabled", query_insights_enabled)
        pulumi.set(__self__, "query_plans_per_minute", query_plans_per_minute)
        pulumi.set(__self__, "query_string_length", query_string_length)
        pulumi.set(__self__, "record_application_tags", record_application_tags)
        pulumi.set(__self__, "record_client_address", record_client_address)

    @_builtins.property
    @pulumi.getter(name="queryInsightsEnabled")
    def query_insights_enabled(self) -> _builtins.bool:
        """
        True if Query Insights feature is enabled.
        """
        return pulumi.get(self, "query_insights_enabled")

    @_builtins.property
    @pulumi.getter(name="queryPlansPerMinute")
    def query_plans_per_minute(self) -> _builtins.int:
        """
        Number of query execution plans captured by Insights per minute for all queries combined. Between 0 and 20. Default to 5. For Enterprise Plus instances, from 0 to 200.
        """
        return pulumi.get(self, "query_plans_per_minute")

    @_builtins.property
    @pulumi.getter(name="queryStringLength")
    def query_string_length(self) -> _builtins.int:
        """
        Maximum query length stored in bytes. Between 256 and 4500. Default to 1024. For Enterprise Plus instances, from 1 to 1048576.
        """
        return pulumi.get(self, "query_string_length")

    @_builtins.property
    @pulumi.getter(name="recordApplicationTags")
    def record_application_tags(self) -> _builtins.bool:
        """
        True if Query Insights will record application tags from query when enabled.
        """
        return pulumi.get(self, "record_application_tags")

    @_builtins.property
    @pulumi.getter(name="recordClientAddress")
    def record_client_address(self) -> _builtins.bool:
        """
        True if Query Insights will record client address when enabled.
        """
        return pulumi.get(self, "record_client_address")


@pulumi.output_type
class GetDatabaseInstanceSettingIpConfigurationResult(dict):
    def __init__(__self__, *,
                 allocated_ip_range: _builtins.str,
                 authorized_networks: Sequence['outputs.GetDatabaseInstanceSettingIpConfigurationAuthorizedNetworkResult'],
                 custom_subject_alternative_names: Sequence[_builtins.str],
                 enable_private_path_for_google_cloud_services: _builtins.bool,
                 ipv4_enabled: _builtins.bool,
                 private_network: _builtins.str,
                 psc_configs: Sequence['outputs.GetDatabaseInstanceSettingIpConfigurationPscConfigResult'],
                 server_ca_mode: _builtins.str,
                 server_ca_pool: _builtins.str,
                 ssl_mode: _builtins.str):
        """
        :param _builtins.str allocated_ip_range: The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the instance ip will be created in the allocated range. The range name must comply with RFC 1035. Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        :param Sequence[_builtins.str] custom_subject_alternative_names: The custom subject alternative names for an instance with "CUSTOMER_MANAGED_CAS_CA" as the "server_ca_mode".
        :param _builtins.bool enable_private_path_for_google_cloud_services: Whether Google Cloud services such as BigQuery are allowed to access data in this Cloud SQL instance over a private IP connection. SQLSERVER database type is not supported.
        :param _builtins.bool ipv4_enabled: Whether this Cloud SQL instance should be assigned a public IPV4 address. At least ipv4_enabled must be enabled or a private_network must be configured.
        :param _builtins.str private_network: The VPC network from which the Cloud SQL instance is accessible for private IP. For example, projects/myProject/global/networks/default. Specifying a network enables private IP. At least ipv4_enabled must be enabled or a private_network must be configured. This setting can be updated, but it cannot be removed after it is set.
        :param Sequence['GetDatabaseInstanceSettingIpConfigurationPscConfigArgs'] psc_configs: PSC settings for a Cloud SQL instance.
        :param _builtins.str server_ca_mode: Specify how the server certificate's Certificate Authority is hosted.
        :param _builtins.str server_ca_pool: The resource name of the server CA pool for an instance with "CUSTOMER_MANAGED_CAS_CA" as the "server_ca_mode".
        :param _builtins.str ssl_mode: Specify how SSL connection should be enforced in DB connections.
        """
        pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        pulumi.set(__self__, "authorized_networks", authorized_networks)
        pulumi.set(__self__, "custom_subject_alternative_names", custom_subject_alternative_names)
        pulumi.set(__self__, "enable_private_path_for_google_cloud_services", enable_private_path_for_google_cloud_services)
        pulumi.set(__self__, "ipv4_enabled", ipv4_enabled)
        pulumi.set(__self__, "private_network", private_network)
        pulumi.set(__self__, "psc_configs", psc_configs)
        pulumi.set(__self__, "server_ca_mode", server_ca_mode)
        pulumi.set(__self__, "server_ca_pool", server_ca_pool)
        pulumi.set(__self__, "ssl_mode", ssl_mode)

    @_builtins.property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> _builtins.str:
        """
        The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the instance ip will be created in the allocated range. The range name must comply with RFC 1035. Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        """
        return pulumi.get(self, "allocated_ip_range")

    @_builtins.property
    @pulumi.getter(name="authorizedNetworks")
    def authorized_networks(self) -> Sequence['outputs.GetDatabaseInstanceSettingIpConfigurationAuthorizedNetworkResult']:
        return pulumi.get(self, "authorized_networks")

    @_builtins.property
    @pulumi.getter(name="customSubjectAlternativeNames")
    def custom_subject_alternative_names(self) -> Sequence[_builtins.str]:
        """
        The custom subject alternative names for an instance with "CUSTOMER_MANAGED_CAS_CA" as the "server_ca_mode".
        """
        return pulumi.get(self, "custom_subject_alternative_names")

    @_builtins.property
    @pulumi.getter(name="enablePrivatePathForGoogleCloudServices")
    def enable_private_path_for_google_cloud_services(self) -> _builtins.bool:
        """
        Whether Google Cloud services such as BigQuery are allowed to access data in this Cloud SQL instance over a private IP connection. SQLSERVER database type is not supported.
        """
        return pulumi.get(self, "enable_private_path_for_google_cloud_services")

    @_builtins.property
    @pulumi.getter(name="ipv4Enabled")
    def ipv4_enabled(self) -> _builtins.bool:
        """
        Whether this Cloud SQL instance should be assigned a public IPV4 address. At least ipv4_enabled must be enabled or a private_network must be configured.
        """
        return pulumi.get(self, "ipv4_enabled")

    @_builtins.property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> _builtins.str:
        """
        The VPC network from which the Cloud SQL instance is accessible for private IP. For example, projects/myProject/global/networks/default. Specifying a network enables private IP. At least ipv4_enabled must be enabled or a private_network must be configured. This setting can be updated, but it cannot be removed after it is set.
        """
        return pulumi.get(self, "private_network")

    @_builtins.property
    @pulumi.getter(name="pscConfigs")
    def psc_configs(self) -> Sequence['outputs.GetDatabaseInstanceSettingIpConfigurationPscConfigResult']:
        """
        PSC settings for a Cloud SQL instance.
        """
        return pulumi.get(self, "psc_configs")

    @_builtins.property
    @pulumi.getter(name="serverCaMode")
    def server_ca_mode(self) -> _builtins.str:
        """
        Specify how the server certificate's Certificate Authority is hosted.
        """
        return pulumi.get(self, "server_ca_mode")

    @_builtins.property
    @pulumi.getter(name="serverCaPool")
    def server_ca_pool(self) -> _builtins.str:
        """
        The resource name of the server CA pool for an instance with "CUSTOMER_MANAGED_CAS_CA" as the "server_ca_mode".
        """
        return pulumi.get(self, "server_ca_pool")

    @_builtins.property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> _builtins.str:
        """
        Specify how SSL connection should be enforced in DB connections.
        """
        return pulumi.get(self, "ssl_mode")


@pulumi.output_type
class GetDatabaseInstanceSettingIpConfigurationAuthorizedNetworkResult(dict):
    def __init__(__self__, *,
                 expiration_time: _builtins.str,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The name of the instance.
        """
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> _builtins.str:
        return pulumi.get(self, "expiration_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDatabaseInstanceSettingIpConfigurationPscConfigResult(dict):
    def __init__(__self__, *,
                 allowed_consumer_projects: Sequence[_builtins.str],
                 network_attachment_uri: _builtins.str,
                 psc_auto_connections: Sequence['outputs.GetDatabaseInstanceSettingIpConfigurationPscConfigPscAutoConnectionResult'],
                 psc_enabled: _builtins.bool):
        """
        :param Sequence[_builtins.str] allowed_consumer_projects: List of consumer projects that are allow-listed for PSC connections to this instance. This instance can be connected to with PSC from any network in these projects. Each consumer project in this list may be represented by a project number (numeric) or by a project id (alphanumeric).
        :param _builtins.str network_attachment_uri: Name of network attachment resource used to authorize a producer service to connect a PSC interface to the consumer's VPC. For example: "projects/myProject/regions/myRegion/networkAttachments/myNetworkAttachment". This is required to enable outbound connection on a PSC instance.
        :param Sequence['GetDatabaseInstanceSettingIpConfigurationPscConfigPscAutoConnectionArgs'] psc_auto_connections: A comma-separated list of networks or a comma-separated list of network-project pairs. Each project in this list is represented by a project number (numeric) or by a project ID (alphanumeric). This allows Private Service Connect connections to be created automatically for the specified networks.
        :param _builtins.bool psc_enabled: Whether PSC connectivity is enabled for this instance.
        """
        pulumi.set(__self__, "allowed_consumer_projects", allowed_consumer_projects)
        pulumi.set(__self__, "network_attachment_uri", network_attachment_uri)
        pulumi.set(__self__, "psc_auto_connections", psc_auto_connections)
        pulumi.set(__self__, "psc_enabled", psc_enabled)

    @_builtins.property
    @pulumi.getter(name="allowedConsumerProjects")
    def allowed_consumer_projects(self) -> Sequence[_builtins.str]:
        """
        List of consumer projects that are allow-listed for PSC connections to this instance. This instance can be connected to with PSC from any network in these projects. Each consumer project in this list may be represented by a project number (numeric) or by a project id (alphanumeric).
        """
        return pulumi.get(self, "allowed_consumer_projects")

    @_builtins.property
    @pulumi.getter(name="networkAttachmentUri")
    def network_attachment_uri(self) -> _builtins.str:
        """
        Name of network attachment resource used to authorize a producer service to connect a PSC interface to the consumer's VPC. For example: "projects/myProject/regions/myRegion/networkAttachments/myNetworkAttachment". This is required to enable outbound connection on a PSC instance.
        """
        return pulumi.get(self, "network_attachment_uri")

    @_builtins.property
    @pulumi.getter(name="pscAutoConnections")
    def psc_auto_connections(self) -> Sequence['outputs.GetDatabaseInstanceSettingIpConfigurationPscConfigPscAutoConnectionResult']:
        """
        A comma-separated list of networks or a comma-separated list of network-project pairs. Each project in this list is represented by a project number (numeric) or by a project ID (alphanumeric). This allows Private Service Connect connections to be created automatically for the specified networks.
        """
        return pulumi.get(self, "psc_auto_connections")

    @_builtins.property
    @pulumi.getter(name="pscEnabled")
    def psc_enabled(self) -> _builtins.bool:
        """
        Whether PSC connectivity is enabled for this instance.
        """
        return pulumi.get(self, "psc_enabled")


@pulumi.output_type
class GetDatabaseInstanceSettingIpConfigurationPscConfigPscAutoConnectionResult(dict):
    def __init__(__self__, *,
                 consumer_network: _builtins.str,
                 consumer_network_status: _builtins.str,
                 consumer_service_project_id: _builtins.str,
                 ip_address: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str consumer_network: The consumer network of this consumer endpoint. This must be a resource path that includes both the host project and the network name. The consumer host project of this network might be different from the consumer service project.
        :param _builtins.str consumer_network_status: The connection policy status of the consumer network.
        :param _builtins.str consumer_service_project_id: The project ID of consumer service project of this consumer endpoint.
        :param _builtins.str ip_address: The IP address of the consumer endpoint.
        :param _builtins.str status: The connection status of the consumer endpoint.
        """
        pulumi.set(__self__, "consumer_network", consumer_network)
        pulumi.set(__self__, "consumer_network_status", consumer_network_status)
        pulumi.set(__self__, "consumer_service_project_id", consumer_service_project_id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="consumerNetwork")
    def consumer_network(self) -> _builtins.str:
        """
        The consumer network of this consumer endpoint. This must be a resource path that includes both the host project and the network name. The consumer host project of this network might be different from the consumer service project.
        """
        return pulumi.get(self, "consumer_network")

    @_builtins.property
    @pulumi.getter(name="consumerNetworkStatus")
    def consumer_network_status(self) -> _builtins.str:
        """
        The connection policy status of the consumer network.
        """
        return pulumi.get(self, "consumer_network_status")

    @_builtins.property
    @pulumi.getter(name="consumerServiceProjectId")
    def consumer_service_project_id(self) -> _builtins.str:
        """
        The project ID of consumer service project of this consumer endpoint.
        """
        return pulumi.get(self, "consumer_service_project_id")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The IP address of the consumer endpoint.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The connection status of the consumer endpoint.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetDatabaseInstanceSettingLocationPreferenceResult(dict):
    def __init__(__self__, *,
                 follow_gae_application: _builtins.str,
                 secondary_zone: _builtins.str,
                 zone: _builtins.str):
        """
        :param _builtins.str follow_gae_application: A Google App Engine application whose zone to remain in. Must be in the same region as this instance.
        :param _builtins.str secondary_zone: The preferred Compute Engine zone for the secondary/failover
        :param _builtins.str zone: The preferred compute engine zone.
        """
        pulumi.set(__self__, "follow_gae_application", follow_gae_application)
        pulumi.set(__self__, "secondary_zone", secondary_zone)
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="followGaeApplication")
    def follow_gae_application(self) -> _builtins.str:
        """
        A Google App Engine application whose zone to remain in. Must be in the same region as this instance.
        """
        return pulumi.get(self, "follow_gae_application")

    @_builtins.property
    @pulumi.getter(name="secondaryZone")
    def secondary_zone(self) -> _builtins.str:
        """
        The preferred Compute Engine zone for the secondary/failover
        """
        return pulumi.get(self, "secondary_zone")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> _builtins.str:
        """
        The preferred compute engine zone.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetDatabaseInstanceSettingMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 day: _builtins.int,
                 hour: _builtins.int,
                 update_track: _builtins.str):
        """
        :param _builtins.int day: Day of week (1-7), starting on Monday
        :param _builtins.int hour: Hour of day (0-23), ignored if day not set
        :param _builtins.str update_track: Receive updates after one week (canary) or after two weeks (stable) or after five weeks (week5) of notification.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "hour", hour)
        pulumi.set(__self__, "update_track", update_track)

    @_builtins.property
    @pulumi.getter
    def day(self) -> _builtins.int:
        """
        Day of week (1-7), starting on Monday
        """
        return pulumi.get(self, "day")

    @_builtins.property
    @pulumi.getter
    def hour(self) -> _builtins.int:
        """
        Hour of day (0-23), ignored if day not set
        """
        return pulumi.get(self, "hour")

    @_builtins.property
    @pulumi.getter(name="updateTrack")
    def update_track(self) -> _builtins.str:
        """
        Receive updates after one week (canary) or after two weeks (stable) or after five weeks (week5) of notification.
        """
        return pulumi.get(self, "update_track")


@pulumi.output_type
class GetDatabaseInstanceSettingPasswordValidationPolicyResult(dict):
    def __init__(__self__, *,
                 complexity: _builtins.str,
                 disallow_username_substring: _builtins.bool,
                 enable_password_policy: _builtins.bool,
                 min_length: _builtins.int,
                 password_change_interval: _builtins.str,
                 reuse_interval: _builtins.int):
        """
        :param _builtins.str complexity: Password complexity.
        :param _builtins.bool disallow_username_substring: Disallow username as a part of the password.
        :param _builtins.bool enable_password_policy: Whether the password policy is enabled or not.
        :param _builtins.int min_length: Minimum number of characters allowed.
        :param _builtins.str password_change_interval: Minimum interval after which the password can be changed. This flag is only supported for PostgresSQL.
        :param _builtins.int reuse_interval: Number of previous passwords that cannot be reused.
        """
        pulumi.set(__self__, "complexity", complexity)
        pulumi.set(__self__, "disallow_username_substring", disallow_username_substring)
        pulumi.set(__self__, "enable_password_policy", enable_password_policy)
        pulumi.set(__self__, "min_length", min_length)
        pulumi.set(__self__, "password_change_interval", password_change_interval)
        pulumi.set(__self__, "reuse_interval", reuse_interval)

    @_builtins.property
    @pulumi.getter
    def complexity(self) -> _builtins.str:
        """
        Password complexity.
        """
        return pulumi.get(self, "complexity")

    @_builtins.property
    @pulumi.getter(name="disallowUsernameSubstring")
    def disallow_username_substring(self) -> _builtins.bool:
        """
        Disallow username as a part of the password.
        """
        return pulumi.get(self, "disallow_username_substring")

    @_builtins.property
    @pulumi.getter(name="enablePasswordPolicy")
    def enable_password_policy(self) -> _builtins.bool:
        """
        Whether the password policy is enabled or not.
        """
        return pulumi.get(self, "enable_password_policy")

    @_builtins.property
    @pulumi.getter(name="minLength")
    def min_length(self) -> _builtins.int:
        """
        Minimum number of characters allowed.
        """
        return pulumi.get(self, "min_length")

    @_builtins.property
    @pulumi.getter(name="passwordChangeInterval")
    def password_change_interval(self) -> _builtins.str:
        """
        Minimum interval after which the password can be changed. This flag is only supported for PostgresSQL.
        """
        return pulumi.get(self, "password_change_interval")

    @_builtins.property
    @pulumi.getter(name="reuseInterval")
    def reuse_interval(self) -> _builtins.int:
        """
        Number of previous passwords that cannot be reused.
        """
        return pulumi.get(self, "reuse_interval")


@pulumi.output_type
class GetDatabaseInstanceSettingSqlServerAuditConfigResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 retention_interval: _builtins.str,
                 upload_interval: _builtins.str):
        """
        :param _builtins.str bucket: The name of the destination bucket (e.g., gs://mybucket).
        :param _builtins.str retention_interval: How long to keep generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s"..
        :param _builtins.str upload_interval: How often to upload generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "retention_interval", retention_interval)
        pulumi.set(__self__, "upload_interval", upload_interval)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The name of the destination bucket (e.g., gs://mybucket).
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="retentionInterval")
    def retention_interval(self) -> _builtins.str:
        """
        How long to keep generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s"..
        """
        return pulumi.get(self, "retention_interval")

    @_builtins.property
    @pulumi.getter(name="uploadInterval")
    def upload_interval(self) -> _builtins.str:
        """
        How often to upload generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "upload_interval")


@pulumi.output_type
class GetDatabaseInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 available_maintenance_versions: Sequence[_builtins.str],
                 backupdr_backup: _builtins.str,
                 clones: Sequence['outputs.GetDatabaseInstancesInstanceCloneResult'],
                 connection_name: _builtins.str,
                 database_version: _builtins.str,
                 deletion_protection: _builtins.bool,
                 dns_name: _builtins.str,
                 dns_names: Sequence['outputs.GetDatabaseInstancesInstanceDnsNameResult'],
                 encryption_key_name: _builtins.str,
                 final_backup_description: _builtins.str,
                 first_ip_address: _builtins.str,
                 instance_type: _builtins.str,
                 ip_addresses: Sequence['outputs.GetDatabaseInstancesInstanceIpAddressResult'],
                 maintenance_version: _builtins.str,
                 master_instance_name: _builtins.str,
                 name: _builtins.str,
                 node_count: _builtins.int,
                 private_ip_address: _builtins.str,
                 project: _builtins.str,
                 psc_service_attachment_link: _builtins.str,
                 public_ip_address: _builtins.str,
                 region: _builtins.str,
                 replica_configurations: Sequence['outputs.GetDatabaseInstancesInstanceReplicaConfigurationResult'],
                 replica_names: Sequence[_builtins.str],
                 replication_clusters: Sequence['outputs.GetDatabaseInstancesInstanceReplicationClusterResult'],
                 restore_backup_contexts: Sequence['outputs.GetDatabaseInstancesInstanceRestoreBackupContextResult'],
                 root_password: _builtins.str,
                 self_link: _builtins.str,
                 server_ca_certs: Sequence['outputs.GetDatabaseInstancesInstanceServerCaCertResult'],
                 service_account_email_address: _builtins.str,
                 settings: Sequence['outputs.GetDatabaseInstancesInstanceSettingResult']):
        """
        :param Sequence[_builtins.str] available_maintenance_versions: Available Maintenance versions.
        :param _builtins.str backupdr_backup: The name of the BackupDR backup to restore from.
        :param Sequence['GetDatabaseInstancesInstanceCloneArgs'] clones: Configuration for creating a new instance as a clone of another instance.
        :param _builtins.str connection_name: The connection name of the instance to be used in connection strings. For example, when connecting with Cloud SQL Proxy.
        :param _builtins.str database_version: To filter out the Cloud SQL instances which are of the specified database version.
        :param _builtins.str dns_name: The instance-level dns name of the instance for PSC instances or public IP CAS instances.
        :param Sequence['GetDatabaseInstancesInstanceDnsNameArgs'] dns_names: The list of DNS names used by this instance. Different connection types for an instance may have different DNS names. DNS names can apply to an individual instance or a cluster of instances.
        :param _builtins.str final_backup_description: The description of final backup if instance enable create final backup during instance deletion.
        :param _builtins.str instance_type: The type of the instance. See https://cloud.google.com/sql/docs/mysql/admin-api/rest/v1/instances#SqlInstanceType for supported values.
        :param _builtins.str maintenance_version: Maintenance version.
        :param _builtins.str master_instance_name: The name of the instance that will act as the master in the replication setup. Note, this requires the master to have binary_log_enabled set, as well as existing backups.
        :param _builtins.int node_count: For a read pool instance, the number of nodes in the read pool.
        :param _builtins.str project: The ID of the project in which the resources belong. If it is not provided, the provider project is used.
        :param _builtins.str psc_service_attachment_link: The link to service attachment of PSC instance.
        :param _builtins.str region: To filter out the Cloud SQL instances which are located in the specified region.
        :param Sequence['GetDatabaseInstancesInstanceReplicaConfigurationArgs'] replica_configurations: The configuration for replication.
        :param Sequence[_builtins.str] replica_names: The replicas of the instance.
        :param Sequence['GetDatabaseInstancesInstanceReplicationClusterArgs'] replication_clusters: A primary instance and disaster recovery replica pair. Applicable to MySQL and PostgreSQL. This field can be set only after both the primary and replica are created.
        :param _builtins.str root_password: Initial root password. Required for MS SQL Server.
        :param _builtins.str self_link: The URI of the created resource.
        :param _builtins.str service_account_email_address: The service account email address assigned to the instance.
        :param Sequence['GetDatabaseInstancesInstanceSettingArgs'] settings: The settings to use for the database. The configuration is detailed below.
        """
        pulumi.set(__self__, "available_maintenance_versions", available_maintenance_versions)
        pulumi.set(__self__, "backupdr_backup", backupdr_backup)
        pulumi.set(__self__, "clones", clones)
        pulumi.set(__self__, "connection_name", connection_name)
        pulumi.set(__self__, "database_version", database_version)
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        pulumi.set(__self__, "dns_name", dns_name)
        pulumi.set(__self__, "dns_names", dns_names)
        pulumi.set(__self__, "encryption_key_name", encryption_key_name)
        pulumi.set(__self__, "final_backup_description", final_backup_description)
        pulumi.set(__self__, "first_ip_address", first_ip_address)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "maintenance_version", maintenance_version)
        pulumi.set(__self__, "master_instance_name", master_instance_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "psc_service_attachment_link", psc_service_attachment_link)
        pulumi.set(__self__, "public_ip_address", public_ip_address)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "replica_configurations", replica_configurations)
        pulumi.set(__self__, "replica_names", replica_names)
        pulumi.set(__self__, "replication_clusters", replication_clusters)
        pulumi.set(__self__, "restore_backup_contexts", restore_backup_contexts)
        pulumi.set(__self__, "root_password", root_password)
        pulumi.set(__self__, "self_link", self_link)
        pulumi.set(__self__, "server_ca_certs", server_ca_certs)
        pulumi.set(__self__, "service_account_email_address", service_account_email_address)
        pulumi.set(__self__, "settings", settings)

    @_builtins.property
    @pulumi.getter(name="availableMaintenanceVersions")
    def available_maintenance_versions(self) -> Sequence[_builtins.str]:
        """
        Available Maintenance versions.
        """
        return pulumi.get(self, "available_maintenance_versions")

    @_builtins.property
    @pulumi.getter(name="backupdrBackup")
    def backupdr_backup(self) -> _builtins.str:
        """
        The name of the BackupDR backup to restore from.
        """
        return pulumi.get(self, "backupdr_backup")

    @_builtins.property
    @pulumi.getter
    def clones(self) -> Sequence['outputs.GetDatabaseInstancesInstanceCloneResult']:
        """
        Configuration for creating a new instance as a clone of another instance.
        """
        return pulumi.get(self, "clones")

    @_builtins.property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> _builtins.str:
        """
        The connection name of the instance to be used in connection strings. For example, when connecting with Cloud SQL Proxy.
        """
        return pulumi.get(self, "connection_name")

    @_builtins.property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> _builtins.str:
        """
        To filter out the Cloud SQL instances which are of the specified database version.
        """
        return pulumi.get(self, "database_version")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> _builtins.bool:
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> _builtins.str:
        """
        The instance-level dns name of the instance for PSC instances or public IP CAS instances.
        """
        return pulumi.get(self, "dns_name")

    @_builtins.property
    @pulumi.getter(name="dnsNames")
    def dns_names(self) -> Sequence['outputs.GetDatabaseInstancesInstanceDnsNameResult']:
        """
        The list of DNS names used by this instance. Different connection types for an instance may have different DNS names. DNS names can apply to an individual instance or a cluster of instances.
        """
        return pulumi.get(self, "dns_names")

    @_builtins.property
    @pulumi.getter(name="encryptionKeyName")
    def encryption_key_name(self) -> _builtins.str:
        return pulumi.get(self, "encryption_key_name")

    @_builtins.property
    @pulumi.getter(name="finalBackupDescription")
    def final_backup_description(self) -> _builtins.str:
        """
        The description of final backup if instance enable create final backup during instance deletion.
        """
        return pulumi.get(self, "final_backup_description")

    @_builtins.property
    @pulumi.getter(name="firstIpAddress")
    def first_ip_address(self) -> _builtins.str:
        return pulumi.get(self, "first_ip_address")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> _builtins.str:
        """
        The type of the instance. See https://cloud.google.com/sql/docs/mysql/admin-api/rest/v1/instances#SqlInstanceType for supported values.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence['outputs.GetDatabaseInstancesInstanceIpAddressResult']:
        return pulumi.get(self, "ip_addresses")

    @_builtins.property
    @pulumi.getter(name="maintenanceVersion")
    def maintenance_version(self) -> _builtins.str:
        """
        Maintenance version.
        """
        return pulumi.get(self, "maintenance_version")

    @_builtins.property
    @pulumi.getter(name="masterInstanceName")
    def master_instance_name(self) -> _builtins.str:
        """
        The name of the instance that will act as the master in the replication setup. Note, this requires the master to have binary_log_enabled set, as well as existing backups.
        """
        return pulumi.get(self, "master_instance_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> _builtins.int:
        """
        For a read pool instance, the number of nodes in the read pool.
        """
        return pulumi.get(self, "node_count")

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> _builtins.str:
        return pulumi.get(self, "private_ip_address")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The ID of the project in which the resources belong. If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pscServiceAttachmentLink")
    def psc_service_attachment_link(self) -> _builtins.str:
        """
        The link to service attachment of PSC instance.
        """
        return pulumi.get(self, "psc_service_attachment_link")

    @_builtins.property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> _builtins.str:
        return pulumi.get(self, "public_ip_address")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        To filter out the Cloud SQL instances which are located in the specified region.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="replicaConfigurations")
    def replica_configurations(self) -> Sequence['outputs.GetDatabaseInstancesInstanceReplicaConfigurationResult']:
        """
        The configuration for replication.
        """
        return pulumi.get(self, "replica_configurations")

    @_builtins.property
    @pulumi.getter(name="replicaNames")
    def replica_names(self) -> Sequence[_builtins.str]:
        """
        The replicas of the instance.
        """
        return pulumi.get(self, "replica_names")

    @_builtins.property
    @pulumi.getter(name="replicationClusters")
    def replication_clusters(self) -> Sequence['outputs.GetDatabaseInstancesInstanceReplicationClusterResult']:
        """
        A primary instance and disaster recovery replica pair. Applicable to MySQL and PostgreSQL. This field can be set only after both the primary and replica are created.
        """
        return pulumi.get(self, "replication_clusters")

    @_builtins.property
    @pulumi.getter(name="restoreBackupContexts")
    def restore_backup_contexts(self) -> Sequence['outputs.GetDatabaseInstancesInstanceRestoreBackupContextResult']:
        return pulumi.get(self, "restore_backup_contexts")

    @_builtins.property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> _builtins.str:
        """
        Initial root password. Required for MS SQL Server.
        """
        return pulumi.get(self, "root_password")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> _builtins.str:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter(name="serverCaCerts")
    def server_ca_certs(self) -> Sequence['outputs.GetDatabaseInstancesInstanceServerCaCertResult']:
        return pulumi.get(self, "server_ca_certs")

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmailAddress")
    def service_account_email_address(self) -> _builtins.str:
        """
        The service account email address assigned to the instance.
        """
        return pulumi.get(self, "service_account_email_address")

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingResult']:
        """
        The settings to use for the database. The configuration is detailed below.
        """
        return pulumi.get(self, "settings")


@pulumi.output_type
class GetDatabaseInstancesInstanceCloneResult(dict):
    def __init__(__self__, *,
                 allocated_ip_range: _builtins.str,
                 database_names: Sequence[_builtins.str],
                 point_in_time: _builtins.str,
                 preferred_zone: _builtins.str,
                 source_instance_name: _builtins.str):
        """
        :param _builtins.str allocated_ip_range: The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        :param Sequence[_builtins.str] database_names: (SQL Server only, use with point_in_time) clone only the specified databases from the source instance. Clone all databases if empty.
        :param _builtins.str point_in_time: The timestamp of the point in time that should be restored.
        :param _builtins.str preferred_zone: (Point-in-time recovery for PostgreSQL only) Clone to an instance in the specified zone. If no zone is specified, clone to the same zone as the source instance.
        :param _builtins.str source_instance_name: The name of the instance from which the point in time should be restored.
        """
        pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        pulumi.set(__self__, "database_names", database_names)
        pulumi.set(__self__, "point_in_time", point_in_time)
        pulumi.set(__self__, "preferred_zone", preferred_zone)
        pulumi.set(__self__, "source_instance_name", source_instance_name)

    @_builtins.property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> _builtins.str:
        """
        The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        """
        return pulumi.get(self, "allocated_ip_range")

    @_builtins.property
    @pulumi.getter(name="databaseNames")
    def database_names(self) -> Sequence[_builtins.str]:
        """
        (SQL Server only, use with point_in_time) clone only the specified databases from the source instance. Clone all databases if empty.
        """
        return pulumi.get(self, "database_names")

    @_builtins.property
    @pulumi.getter(name="pointInTime")
    def point_in_time(self) -> _builtins.str:
        """
        The timestamp of the point in time that should be restored.
        """
        return pulumi.get(self, "point_in_time")

    @_builtins.property
    @pulumi.getter(name="preferredZone")
    def preferred_zone(self) -> _builtins.str:
        """
        (Point-in-time recovery for PostgreSQL only) Clone to an instance in the specified zone. If no zone is specified, clone to the same zone as the source instance.
        """
        return pulumi.get(self, "preferred_zone")

    @_builtins.property
    @pulumi.getter(name="sourceInstanceName")
    def source_instance_name(self) -> _builtins.str:
        """
        The name of the instance from which the point in time should be restored.
        """
        return pulumi.get(self, "source_instance_name")


@pulumi.output_type
class GetDatabaseInstancesInstanceDnsNameResult(dict):
    def __init__(__self__, *,
                 connection_type: _builtins.str,
                 dns_scope: _builtins.str,
                 name: _builtins.str):
        pulumi.set(__self__, "connection_type", connection_type)
        pulumi.set(__self__, "dns_scope", dns_scope)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> _builtins.str:
        return pulumi.get(self, "connection_type")

    @_builtins.property
    @pulumi.getter(name="dnsScope")
    def dns_scope(self) -> _builtins.str:
        return pulumi.get(self, "dns_scope")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetDatabaseInstancesInstanceIpAddressResult(dict):
    def __init__(__self__, *,
                 ip_address: _builtins.str,
                 time_to_retire: _builtins.str,
                 type: _builtins.str):
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "time_to_retire", time_to_retire)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="timeToRetire")
    def time_to_retire(self) -> _builtins.str:
        return pulumi.get(self, "time_to_retire")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDatabaseInstancesInstanceReplicaConfigurationResult(dict):
    def __init__(__self__, *,
                 ca_certificate: _builtins.str,
                 cascadable_replica: _builtins.bool,
                 client_certificate: _builtins.str,
                 client_key: _builtins.str,
                 connect_retry_interval: _builtins.int,
                 dump_file_path: _builtins.str,
                 failover_target: _builtins.bool,
                 master_heartbeat_period: _builtins.int,
                 password: _builtins.str,
                 ssl_cipher: _builtins.str,
                 username: _builtins.str,
                 verify_server_certificate: _builtins.bool):
        """
        :param _builtins.str ca_certificate: PEM representation of the trusted CA's x509 certificate.
        :param _builtins.bool cascadable_replica: Specifies if a SQL Server replica is a cascadable replica. A cascadable replica is a SQL Server cross region replica that supports replica(s) under it.
        :param _builtins.str client_certificate: PEM representation of the replica's x509 certificate.
        :param _builtins.str client_key: PEM representation of the replica's private key. The corresponding public key in encoded in the client_certificate.
        :param _builtins.int connect_retry_interval: The number of seconds between connect retries. MySQL's default is 60 seconds.
        :param _builtins.str dump_file_path: Path to a SQL file in Google Cloud Storage from which replica instances are created. Format is gs://bucket/filename.
        :param _builtins.bool failover_target: Specifies if the replica is the failover target. If the field is set to true the replica will be designated as a failover replica. If the master instance fails, the replica instance will be promoted as the new master instance. Not supported for Postgres
        :param _builtins.int master_heartbeat_period: Time in ms between replication heartbeats.
        :param _builtins.str password: Password for the replication connection.
        :param _builtins.str ssl_cipher: Permissible ciphers for use in SSL encryption.
        :param _builtins.str username: Username for replication connection.
        :param _builtins.bool verify_server_certificate: True if the master's common name value is checked during the SSL handshake.
        """
        pulumi.set(__self__, "ca_certificate", ca_certificate)
        pulumi.set(__self__, "cascadable_replica", cascadable_replica)
        pulumi.set(__self__, "client_certificate", client_certificate)
        pulumi.set(__self__, "client_key", client_key)
        pulumi.set(__self__, "connect_retry_interval", connect_retry_interval)
        pulumi.set(__self__, "dump_file_path", dump_file_path)
        pulumi.set(__self__, "failover_target", failover_target)
        pulumi.set(__self__, "master_heartbeat_period", master_heartbeat_period)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "ssl_cipher", ssl_cipher)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "verify_server_certificate", verify_server_certificate)

    @_builtins.property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> _builtins.str:
        """
        PEM representation of the trusted CA's x509 certificate.
        """
        return pulumi.get(self, "ca_certificate")

    @_builtins.property
    @pulumi.getter(name="cascadableReplica")
    def cascadable_replica(self) -> _builtins.bool:
        """
        Specifies if a SQL Server replica is a cascadable replica. A cascadable replica is a SQL Server cross region replica that supports replica(s) under it.
        """
        return pulumi.get(self, "cascadable_replica")

    @_builtins.property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> _builtins.str:
        """
        PEM representation of the replica's x509 certificate.
        """
        return pulumi.get(self, "client_certificate")

    @_builtins.property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> _builtins.str:
        """
        PEM representation of the replica's private key. The corresponding public key in encoded in the client_certificate.
        """
        return pulumi.get(self, "client_key")

    @_builtins.property
    @pulumi.getter(name="connectRetryInterval")
    def connect_retry_interval(self) -> _builtins.int:
        """
        The number of seconds between connect retries. MySQL's default is 60 seconds.
        """
        return pulumi.get(self, "connect_retry_interval")

    @_builtins.property
    @pulumi.getter(name="dumpFilePath")
    def dump_file_path(self) -> _builtins.str:
        """
        Path to a SQL file in Google Cloud Storage from which replica instances are created. Format is gs://bucket/filename.
        """
        return pulumi.get(self, "dump_file_path")

    @_builtins.property
    @pulumi.getter(name="failoverTarget")
    def failover_target(self) -> _builtins.bool:
        """
        Specifies if the replica is the failover target. If the field is set to true the replica will be designated as a failover replica. If the master instance fails, the replica instance will be promoted as the new master instance. Not supported for Postgres
        """
        return pulumi.get(self, "failover_target")

    @_builtins.property
    @pulumi.getter(name="masterHeartbeatPeriod")
    def master_heartbeat_period(self) -> _builtins.int:
        """
        Time in ms between replication heartbeats.
        """
        return pulumi.get(self, "master_heartbeat_period")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        Password for the replication connection.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="sslCipher")
    def ssl_cipher(self) -> _builtins.str:
        """
        Permissible ciphers for use in SSL encryption.
        """
        return pulumi.get(self, "ssl_cipher")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        Username for replication connection.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="verifyServerCertificate")
    def verify_server_certificate(self) -> _builtins.bool:
        """
        True if the master's common name value is checked during the SSL handshake.
        """
        return pulumi.get(self, "verify_server_certificate")


@pulumi.output_type
class GetDatabaseInstancesInstanceReplicationClusterResult(dict):
    def __init__(__self__, *,
                 dr_replica: _builtins.bool,
                 failover_dr_replica_name: _builtins.str,
                 psa_write_endpoint: _builtins.str):
        """
        :param _builtins.bool dr_replica: Read-only field that indicates whether the replica is a DR replica.
        :param _builtins.str failover_dr_replica_name: If the instance is a primary instance, then this field identifies the disaster recovery (DR) replica. The standard format of this field is "your-project:your-instance". You can also set this field to "your-instance", but cloud SQL backend will convert it to the aforementioned standard format.
        :param _builtins.str psa_write_endpoint: If set, this field indicates this instance has a private service access (PSA) DNS endpoint that is pointing to the primary instance of the cluster. If this instance is the primary, then the DNS endpoint points to this instance. After a switchover or replica failover operation, this DNS endpoint points to the promoted instance. This is a read-only field, returned to the user as information. This field can exist even if a standalone instance doesn't have a DR replica yet or the DR replica is deleted.
        """
        pulumi.set(__self__, "dr_replica", dr_replica)
        pulumi.set(__self__, "failover_dr_replica_name", failover_dr_replica_name)
        pulumi.set(__self__, "psa_write_endpoint", psa_write_endpoint)

    @_builtins.property
    @pulumi.getter(name="drReplica")
    def dr_replica(self) -> _builtins.bool:
        """
        Read-only field that indicates whether the replica is a DR replica.
        """
        return pulumi.get(self, "dr_replica")

    @_builtins.property
    @pulumi.getter(name="failoverDrReplicaName")
    def failover_dr_replica_name(self) -> _builtins.str:
        """
        If the instance is a primary instance, then this field identifies the disaster recovery (DR) replica. The standard format of this field is "your-project:your-instance". You can also set this field to "your-instance", but cloud SQL backend will convert it to the aforementioned standard format.
        """
        return pulumi.get(self, "failover_dr_replica_name")

    @_builtins.property
    @pulumi.getter(name="psaWriteEndpoint")
    def psa_write_endpoint(self) -> _builtins.str:
        """
        If set, this field indicates this instance has a private service access (PSA) DNS endpoint that is pointing to the primary instance of the cluster. If this instance is the primary, then the DNS endpoint points to this instance. After a switchover or replica failover operation, this DNS endpoint points to the promoted instance. This is a read-only field, returned to the user as information. This field can exist even if a standalone instance doesn't have a DR replica yet or the DR replica is deleted.
        """
        return pulumi.get(self, "psa_write_endpoint")


@pulumi.output_type
class GetDatabaseInstancesInstanceRestoreBackupContextResult(dict):
    def __init__(__self__, *,
                 backup_run_id: _builtins.int,
                 instance_id: _builtins.str,
                 project: _builtins.str):
        """
        :param _builtins.int backup_run_id: The ID of the backup run to restore from.
        :param _builtins.str instance_id: The ID of the instance that the backup was taken from.
        :param _builtins.str project: The ID of the project in which the resources belong. If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "backup_run_id", backup_run_id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="backupRunId")
    def backup_run_id(self) -> _builtins.int:
        """
        The ID of the backup run to restore from.
        """
        return pulumi.get(self, "backup_run_id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The ID of the instance that the backup was taken from.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The ID of the project in which the resources belong. If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class GetDatabaseInstancesInstanceServerCaCertResult(dict):
    def __init__(__self__, *,
                 cert: _builtins.str,
                 common_name: _builtins.str,
                 create_time: _builtins.str,
                 expiration_time: _builtins.str,
                 sha1_fingerprint: _builtins.str):
        """
        :param _builtins.str cert: The CA Certificate used to connect to the SQL Instance via SSL.
        :param _builtins.str common_name: The CN valid for the CA Cert.
        :param _builtins.str create_time: Creation time of the CA Cert.
        :param _builtins.str expiration_time: Expiration time of the CA Cert.
        :param _builtins.str sha1_fingerprint: SHA Fingerprint of the CA Cert.
        """
        pulumi.set(__self__, "cert", cert)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @_builtins.property
    @pulumi.getter
    def cert(self) -> _builtins.str:
        """
        The CA Certificate used to connect to the SQL Instance via SSL.
        """
        return pulumi.get(self, "cert")

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> _builtins.str:
        """
        The CN valid for the CA Cert.
        """
        return pulumi.get(self, "common_name")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        Creation time of the CA Cert.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> _builtins.str:
        """
        Expiration time of the CA Cert.
        """
        return pulumi.get(self, "expiration_time")

    @_builtins.property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> _builtins.str:
        """
        SHA Fingerprint of the CA Cert.
        """
        return pulumi.get(self, "sha1_fingerprint")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingResult(dict):
    def __init__(__self__, *,
                 activation_policy: _builtins.str,
                 active_directory_configs: Sequence['outputs.GetDatabaseInstancesInstanceSettingActiveDirectoryConfigResult'],
                 advanced_machine_features: Sequence['outputs.GetDatabaseInstancesInstanceSettingAdvancedMachineFeatureResult'],
                 availability_type: _builtins.str,
                 backup_configurations: Sequence['outputs.GetDatabaseInstancesInstanceSettingBackupConfigurationResult'],
                 collation: _builtins.str,
                 connection_pool_configs: Sequence['outputs.GetDatabaseInstancesInstanceSettingConnectionPoolConfigResult'],
                 connector_enforcement: _builtins.str,
                 data_cache_configs: Sequence['outputs.GetDatabaseInstancesInstanceSettingDataCacheConfigResult'],
                 data_disk_provisioned_iops: _builtins.int,
                 data_disk_provisioned_throughput: _builtins.int,
                 database_flags: Sequence['outputs.GetDatabaseInstancesInstanceSettingDatabaseFlagResult'],
                 deletion_protection_enabled: _builtins.bool,
                 deny_maintenance_periods: Sequence['outputs.GetDatabaseInstancesInstanceSettingDenyMaintenancePeriodResult'],
                 disk_autoresize: _builtins.bool,
                 disk_autoresize_limit: _builtins.int,
                 disk_size: _builtins.int,
                 disk_type: _builtins.str,
                 edition: _builtins.str,
                 effective_availability_type: _builtins.str,
                 enable_dataplex_integration: _builtins.bool,
                 enable_google_ml_integration: _builtins.bool,
                 final_backup_configs: Sequence['outputs.GetDatabaseInstancesInstanceSettingFinalBackupConfigResult'],
                 insights_configs: Sequence['outputs.GetDatabaseInstancesInstanceSettingInsightsConfigResult'],
                 ip_configurations: Sequence['outputs.GetDatabaseInstancesInstanceSettingIpConfigurationResult'],
                 location_preferences: Sequence['outputs.GetDatabaseInstancesInstanceSettingLocationPreferenceResult'],
                 maintenance_windows: Sequence['outputs.GetDatabaseInstancesInstanceSettingMaintenanceWindowResult'],
                 password_validation_policies: Sequence['outputs.GetDatabaseInstancesInstanceSettingPasswordValidationPolicyResult'],
                 pricing_plan: _builtins.str,
                 retain_backups_on_delete: _builtins.bool,
                 sql_server_audit_configs: Sequence['outputs.GetDatabaseInstancesInstanceSettingSqlServerAuditConfigResult'],
                 tier: _builtins.str,
                 time_zone: _builtins.str,
                 user_labels: Mapping[str, _builtins.str],
                 version: _builtins.int):
        """
        :param _builtins.str activation_policy: This specifies when the instance should be active. Can be either ALWAYS, NEVER or ON_DEMAND.
        :param _builtins.str availability_type: The availability type of the Cloud SQL instance, high availability
               (REGIONAL) or single zone (ZONAL). For all instances, ensure that
               settings.backup_configuration.enabled is set to true.
               For MySQL instances, ensure that settings.backup_configuration.binary_log_enabled is set to true.
               For Postgres instances, ensure that settings.backup_configuration.point_in_time_recovery_enabled
               is set to true. Defaults to ZONAL.
               For read pool instances, this field is read-only. The availability type is changed by specifying
               the number of nodes (node_count).
        :param _builtins.str collation: The name of server instance collation.
        :param Sequence['GetDatabaseInstancesInstanceSettingConnectionPoolConfigArgs'] connection_pool_configs: The managed connection pool setting for a Cloud SQL instance.
        :param _builtins.str connector_enforcement: Enables the enforcement of Cloud SQL Auth Proxy or Cloud SQL connectors for all the connections. If enabled, all the direct connections are rejected.
        :param Sequence['GetDatabaseInstancesInstanceSettingDataCacheConfigArgs'] data_cache_configs: Data cache configurations.
        :param _builtins.int data_disk_provisioned_iops: Provisioned number of I/O operations per second for the data disk. This field is only used for HYPERDISK_BALANCED disk types.
        :param _builtins.int data_disk_provisioned_throughput: Provisioned throughput measured in MiB per second for the data disk. This field is only used for HYPERDISK_BALANCED disk types.
        :param _builtins.bool deletion_protection_enabled: Configuration to protect against accidental instance deletion.
        :param _builtins.bool disk_autoresize: Enables auto-resizing of the storage size. Defaults to true.
        :param _builtins.int disk_autoresize_limit: The maximum size, in GB, to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        :param _builtins.int disk_size: The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased. The minimum value is 10GB for PD_SSD, PD_HDD and 20GB for HYPERDISK_BALANCED.
        :param _builtins.str disk_type: The type of supported data disk is tier dependent and can be PD_SSD or PD_HDD or HYPERDISK_BALANCED.
        :param _builtins.str edition: The edition of the instance, can be ENTERPRISE or ENTERPRISE_PLUS.
        :param _builtins.str effective_availability_type: The availability type of the Cloud SQL instance, high availability
               (REGIONAL) or single zone (ZONAL). This field always contains the value that is reported by the
               API (for read pools, effective_availability_type may differ from availability_type).
        :param _builtins.bool enable_dataplex_integration: Enables Dataplex Integration.
        :param _builtins.bool enable_google_ml_integration: Enables Vertex AI Integration.
        :param Sequence['GetDatabaseInstancesInstanceSettingFinalBackupConfigArgs'] final_backup_configs: Config used to determine the final backup settings for the instance
        :param Sequence['GetDatabaseInstancesInstanceSettingInsightsConfigArgs'] insights_configs: Configuration of Query Insights.
        :param Sequence['GetDatabaseInstancesInstanceSettingMaintenanceWindowArgs'] maintenance_windows: Declares a one-hour maintenance window when an Instance can automatically restart to apply updates. The maintenance window is specified in UTC time.
        :param _builtins.str pricing_plan: Pricing plan for this instance, can only be PER_USE.
        :param _builtins.bool retain_backups_on_delete: When this parameter is set to true, Cloud SQL retains backups of the instance even after the instance is deleted. The ON_DEMAND backup will be retained until customer deletes the backup or the project. The AUTOMATED backup will be retained based on the backups retention setting.
        :param _builtins.str tier: To filter out the Cloud SQL instances based on the tier(or machine type) of the database instances.
        :param _builtins.str time_zone: The time_zone to be used by the database engine (supported only for SQL Server), in SQL Server timezone format.
        :param Mapping[str, _builtins.str] user_labels: A set of key/value user label pairs to assign to the instance.
        :param _builtins.int version: Used to make sure changes to the settings block are atomic.
        """
        pulumi.set(__self__, "activation_policy", activation_policy)
        pulumi.set(__self__, "active_directory_configs", active_directory_configs)
        pulumi.set(__self__, "advanced_machine_features", advanced_machine_features)
        pulumi.set(__self__, "availability_type", availability_type)
        pulumi.set(__self__, "backup_configurations", backup_configurations)
        pulumi.set(__self__, "collation", collation)
        pulumi.set(__self__, "connection_pool_configs", connection_pool_configs)
        pulumi.set(__self__, "connector_enforcement", connector_enforcement)
        pulumi.set(__self__, "data_cache_configs", data_cache_configs)
        pulumi.set(__self__, "data_disk_provisioned_iops", data_disk_provisioned_iops)
        pulumi.set(__self__, "data_disk_provisioned_throughput", data_disk_provisioned_throughput)
        pulumi.set(__self__, "database_flags", database_flags)
        pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        pulumi.set(__self__, "deny_maintenance_periods", deny_maintenance_periods)
        pulumi.set(__self__, "disk_autoresize", disk_autoresize)
        pulumi.set(__self__, "disk_autoresize_limit", disk_autoresize_limit)
        pulumi.set(__self__, "disk_size", disk_size)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "edition", edition)
        pulumi.set(__self__, "effective_availability_type", effective_availability_type)
        pulumi.set(__self__, "enable_dataplex_integration", enable_dataplex_integration)
        pulumi.set(__self__, "enable_google_ml_integration", enable_google_ml_integration)
        pulumi.set(__self__, "final_backup_configs", final_backup_configs)
        pulumi.set(__self__, "insights_configs", insights_configs)
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        pulumi.set(__self__, "location_preferences", location_preferences)
        pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        pulumi.set(__self__, "password_validation_policies", password_validation_policies)
        pulumi.set(__self__, "pricing_plan", pricing_plan)
        pulumi.set(__self__, "retain_backups_on_delete", retain_backups_on_delete)
        pulumi.set(__self__, "sql_server_audit_configs", sql_server_audit_configs)
        pulumi.set(__self__, "tier", tier)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "user_labels", user_labels)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="activationPolicy")
    def activation_policy(self) -> _builtins.str:
        """
        This specifies when the instance should be active. Can be either ALWAYS, NEVER or ON_DEMAND.
        """
        return pulumi.get(self, "activation_policy")

    @_builtins.property
    @pulumi.getter(name="activeDirectoryConfigs")
    def active_directory_configs(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingActiveDirectoryConfigResult']:
        return pulumi.get(self, "active_directory_configs")

    @_builtins.property
    @pulumi.getter(name="advancedMachineFeatures")
    def advanced_machine_features(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingAdvancedMachineFeatureResult']:
        return pulumi.get(self, "advanced_machine_features")

    @_builtins.property
    @pulumi.getter(name="availabilityType")
    def availability_type(self) -> _builtins.str:
        """
        The availability type of the Cloud SQL instance, high availability
        (REGIONAL) or single zone (ZONAL). For all instances, ensure that
        settings.backup_configuration.enabled is set to true.
        For MySQL instances, ensure that settings.backup_configuration.binary_log_enabled is set to true.
        For Postgres instances, ensure that settings.backup_configuration.point_in_time_recovery_enabled
        is set to true. Defaults to ZONAL.
        For read pool instances, this field is read-only. The availability type is changed by specifying
        the number of nodes (node_count).
        """
        return pulumi.get(self, "availability_type")

    @_builtins.property
    @pulumi.getter(name="backupConfigurations")
    def backup_configurations(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingBackupConfigurationResult']:
        return pulumi.get(self, "backup_configurations")

    @_builtins.property
    @pulumi.getter
    def collation(self) -> _builtins.str:
        """
        The name of server instance collation.
        """
        return pulumi.get(self, "collation")

    @_builtins.property
    @pulumi.getter(name="connectionPoolConfigs")
    def connection_pool_configs(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingConnectionPoolConfigResult']:
        """
        The managed connection pool setting for a Cloud SQL instance.
        """
        return pulumi.get(self, "connection_pool_configs")

    @_builtins.property
    @pulumi.getter(name="connectorEnforcement")
    def connector_enforcement(self) -> _builtins.str:
        """
        Enables the enforcement of Cloud SQL Auth Proxy or Cloud SQL connectors for all the connections. If enabled, all the direct connections are rejected.
        """
        return pulumi.get(self, "connector_enforcement")

    @_builtins.property
    @pulumi.getter(name="dataCacheConfigs")
    def data_cache_configs(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingDataCacheConfigResult']:
        """
        Data cache configurations.
        """
        return pulumi.get(self, "data_cache_configs")

    @_builtins.property
    @pulumi.getter(name="dataDiskProvisionedIops")
    def data_disk_provisioned_iops(self) -> _builtins.int:
        """
        Provisioned number of I/O operations per second for the data disk. This field is only used for HYPERDISK_BALANCED disk types.
        """
        return pulumi.get(self, "data_disk_provisioned_iops")

    @_builtins.property
    @pulumi.getter(name="dataDiskProvisionedThroughput")
    def data_disk_provisioned_throughput(self) -> _builtins.int:
        """
        Provisioned throughput measured in MiB per second for the data disk. This field is only used for HYPERDISK_BALANCED disk types.
        """
        return pulumi.get(self, "data_disk_provisioned_throughput")

    @_builtins.property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingDatabaseFlagResult']:
        return pulumi.get(self, "database_flags")

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> _builtins.bool:
        """
        Configuration to protect against accidental instance deletion.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @_builtins.property
    @pulumi.getter(name="denyMaintenancePeriods")
    def deny_maintenance_periods(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingDenyMaintenancePeriodResult']:
        return pulumi.get(self, "deny_maintenance_periods")

    @_builtins.property
    @pulumi.getter(name="diskAutoresize")
    def disk_autoresize(self) -> _builtins.bool:
        """
        Enables auto-resizing of the storage size. Defaults to true.
        """
        return pulumi.get(self, "disk_autoresize")

    @_builtins.property
    @pulumi.getter(name="diskAutoresizeLimit")
    def disk_autoresize_limit(self) -> _builtins.int:
        """
        The maximum size, in GB, to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        """
        return pulumi.get(self, "disk_autoresize_limit")

    @_builtins.property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> _builtins.int:
        """
        The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased. The minimum value is 10GB for PD_SSD, PD_HDD and 20GB for HYPERDISK_BALANCED.
        """
        return pulumi.get(self, "disk_size")

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> _builtins.str:
        """
        The type of supported data disk is tier dependent and can be PD_SSD or PD_HDD or HYPERDISK_BALANCED.
        """
        return pulumi.get(self, "disk_type")

    @_builtins.property
    @pulumi.getter
    def edition(self) -> _builtins.str:
        """
        The edition of the instance, can be ENTERPRISE or ENTERPRISE_PLUS.
        """
        return pulumi.get(self, "edition")

    @_builtins.property
    @pulumi.getter(name="effectiveAvailabilityType")
    def effective_availability_type(self) -> _builtins.str:
        """
        The availability type of the Cloud SQL instance, high availability
        (REGIONAL) or single zone (ZONAL). This field always contains the value that is reported by the
        API (for read pools, effective_availability_type may differ from availability_type).
        """
        return pulumi.get(self, "effective_availability_type")

    @_builtins.property
    @pulumi.getter(name="enableDataplexIntegration")
    def enable_dataplex_integration(self) -> _builtins.bool:
        """
        Enables Dataplex Integration.
        """
        return pulumi.get(self, "enable_dataplex_integration")

    @_builtins.property
    @pulumi.getter(name="enableGoogleMlIntegration")
    def enable_google_ml_integration(self) -> _builtins.bool:
        """
        Enables Vertex AI Integration.
        """
        return pulumi.get(self, "enable_google_ml_integration")

    @_builtins.property
    @pulumi.getter(name="finalBackupConfigs")
    def final_backup_configs(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingFinalBackupConfigResult']:
        """
        Config used to determine the final backup settings for the instance
        """
        return pulumi.get(self, "final_backup_configs")

    @_builtins.property
    @pulumi.getter(name="insightsConfigs")
    def insights_configs(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingInsightsConfigResult']:
        """
        Configuration of Query Insights.
        """
        return pulumi.get(self, "insights_configs")

    @_builtins.property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingIpConfigurationResult']:
        return pulumi.get(self, "ip_configurations")

    @_builtins.property
    @pulumi.getter(name="locationPreferences")
    def location_preferences(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingLocationPreferenceResult']:
        return pulumi.get(self, "location_preferences")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingMaintenanceWindowResult']:
        """
        Declares a one-hour maintenance window when an Instance can automatically restart to apply updates. The maintenance window is specified in UTC time.
        """
        return pulumi.get(self, "maintenance_windows")

    @_builtins.property
    @pulumi.getter(name="passwordValidationPolicies")
    def password_validation_policies(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingPasswordValidationPolicyResult']:
        return pulumi.get(self, "password_validation_policies")

    @_builtins.property
    @pulumi.getter(name="pricingPlan")
    def pricing_plan(self) -> _builtins.str:
        """
        Pricing plan for this instance, can only be PER_USE.
        """
        return pulumi.get(self, "pricing_plan")

    @_builtins.property
    @pulumi.getter(name="retainBackupsOnDelete")
    def retain_backups_on_delete(self) -> _builtins.bool:
        """
        When this parameter is set to true, Cloud SQL retains backups of the instance even after the instance is deleted. The ON_DEMAND backup will be retained until customer deletes the backup or the project. The AUTOMATED backup will be retained based on the backups retention setting.
        """
        return pulumi.get(self, "retain_backups_on_delete")

    @_builtins.property
    @pulumi.getter(name="sqlServerAuditConfigs")
    def sql_server_audit_configs(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingSqlServerAuditConfigResult']:
        return pulumi.get(self, "sql_server_audit_configs")

    @_builtins.property
    @pulumi.getter
    def tier(self) -> _builtins.str:
        """
        To filter out the Cloud SQL instances based on the tier(or machine type) of the database instances.
        """
        return pulumi.get(self, "tier")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> _builtins.str:
        """
        The time_zone to be used by the database engine (supported only for SQL Server), in SQL Server timezone format.
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Mapping[str, _builtins.str]:
        """
        A set of key/value user label pairs to assign to the instance.
        """
        return pulumi.get(self, "user_labels")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.int:
        """
        Used to make sure changes to the settings block are atomic.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingActiveDirectoryConfigResult(dict):
    def __init__(__self__, *,
                 domain: _builtins.str):
        """
        :param _builtins.str domain: Domain name of the Active Directory for SQL Server (e.g., mydomain.com).
        """
        pulumi.set(__self__, "domain", domain)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        Domain name of the Active Directory for SQL Server (e.g., mydomain.com).
        """
        return pulumi.get(self, "domain")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingAdvancedMachineFeatureResult(dict):
    def __init__(__self__, *,
                 threads_per_core: _builtins.int):
        """
        :param _builtins.int threads_per_core: The number of threads per physical core. Can be 1 or 2.
        """
        pulumi.set(__self__, "threads_per_core", threads_per_core)

    @_builtins.property
    @pulumi.getter(name="threadsPerCore")
    def threads_per_core(self) -> _builtins.int:
        """
        The number of threads per physical core. Can be 1 or 2.
        """
        return pulumi.get(self, "threads_per_core")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingBackupConfigurationResult(dict):
    def __init__(__self__, *,
                 backup_retention_settings: Sequence['outputs.GetDatabaseInstancesInstanceSettingBackupConfigurationBackupRetentionSettingResult'],
                 binary_log_enabled: _builtins.bool,
                 enabled: _builtins.bool,
                 location: _builtins.str,
                 point_in_time_recovery_enabled: _builtins.bool,
                 start_time: _builtins.str,
                 transaction_log_retention_days: _builtins.int):
        """
        :param _builtins.bool binary_log_enabled: True if binary logging is enabled. If settings.backup_configuration.enabled is false, this must be as well. Can only be used with MySQL.
        :param _builtins.bool enabled: True if backup configuration is enabled.
        :param _builtins.str location: Location of the backup configuration.
        :param _builtins.bool point_in_time_recovery_enabled: True if Point-in-time recovery is enabled.
        :param _builtins.str start_time: HH:MM format time indicating when backup configuration starts.
        :param _builtins.int transaction_log_retention_days: The number of days of transaction logs we retain for point in time restore, from 1-7. (For PostgreSQL Enterprise Plus instances, from 1 to 35.)
        """
        pulumi.set(__self__, "backup_retention_settings", backup_retention_settings)
        pulumi.set(__self__, "binary_log_enabled", binary_log_enabled)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "point_in_time_recovery_enabled", point_in_time_recovery_enabled)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "transaction_log_retention_days", transaction_log_retention_days)

    @_builtins.property
    @pulumi.getter(name="backupRetentionSettings")
    def backup_retention_settings(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingBackupConfigurationBackupRetentionSettingResult']:
        return pulumi.get(self, "backup_retention_settings")

    @_builtins.property
    @pulumi.getter(name="binaryLogEnabled")
    def binary_log_enabled(self) -> _builtins.bool:
        """
        True if binary logging is enabled. If settings.backup_configuration.enabled is false, this must be as well. Can only be used with MySQL.
        """
        return pulumi.get(self, "binary_log_enabled")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        True if backup configuration is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        Location of the backup configuration.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="pointInTimeRecoveryEnabled")
    def point_in_time_recovery_enabled(self) -> _builtins.bool:
        """
        True if Point-in-time recovery is enabled.
        """
        return pulumi.get(self, "point_in_time_recovery_enabled")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.str:
        """
        HH:MM format time indicating when backup configuration starts.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter(name="transactionLogRetentionDays")
    def transaction_log_retention_days(self) -> _builtins.int:
        """
        The number of days of transaction logs we retain for point in time restore, from 1-7. (For PostgreSQL Enterprise Plus instances, from 1 to 35.)
        """
        return pulumi.get(self, "transaction_log_retention_days")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingBackupConfigurationBackupRetentionSettingResult(dict):
    def __init__(__self__, *,
                 retained_backups: _builtins.int,
                 retention_unit: _builtins.str):
        """
        :param _builtins.int retained_backups: Number of backups to retain.
        :param _builtins.str retention_unit: The unit that 'retainedBackups' represents. Defaults to COUNT
        """
        pulumi.set(__self__, "retained_backups", retained_backups)
        pulumi.set(__self__, "retention_unit", retention_unit)

    @_builtins.property
    @pulumi.getter(name="retainedBackups")
    def retained_backups(self) -> _builtins.int:
        """
        Number of backups to retain.
        """
        return pulumi.get(self, "retained_backups")

    @_builtins.property
    @pulumi.getter(name="retentionUnit")
    def retention_unit(self) -> _builtins.str:
        """
        The unit that 'retainedBackups' represents. Defaults to COUNT
        """
        return pulumi.get(self, "retention_unit")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingConnectionPoolConfigResult(dict):
    def __init__(__self__, *,
                 connection_pooling_enabled: _builtins.bool,
                 flags: Sequence['outputs.GetDatabaseInstancesInstanceSettingConnectionPoolConfigFlagResult']):
        """
        :param _builtins.bool connection_pooling_enabled: Whether Managed Connection Pool is enabled for this instance.
        :param Sequence['GetDatabaseInstancesInstanceSettingConnectionPoolConfigFlagArgs'] flags: List of connection pool configuration flags
        """
        pulumi.set(__self__, "connection_pooling_enabled", connection_pooling_enabled)
        pulumi.set(__self__, "flags", flags)

    @_builtins.property
    @pulumi.getter(name="connectionPoolingEnabled")
    def connection_pooling_enabled(self) -> _builtins.bool:
        """
        Whether Managed Connection Pool is enabled for this instance.
        """
        return pulumi.get(self, "connection_pooling_enabled")

    @_builtins.property
    @pulumi.getter
    def flags(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingConnectionPoolConfigFlagResult']:
        """
        List of connection pool configuration flags
        """
        return pulumi.get(self, "flags")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingConnectionPoolConfigFlagResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: Name of the flag.
        :param _builtins.str value: Value of the flag.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the flag.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the flag.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingDataCacheConfigResult(dict):
    def __init__(__self__, *,
                 data_cache_enabled: _builtins.bool):
        """
        :param _builtins.bool data_cache_enabled: Whether data cache is enabled for the instance.
        """
        pulumi.set(__self__, "data_cache_enabled", data_cache_enabled)

    @_builtins.property
    @pulumi.getter(name="dataCacheEnabled")
    def data_cache_enabled(self) -> _builtins.bool:
        """
        Whether data cache is enabled for the instance.
        """
        return pulumi.get(self, "data_cache_enabled")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingDatabaseFlagResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: Name of the flag.
        :param _builtins.str value: Value of the flag.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the flag.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the flag.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingDenyMaintenancePeriodResult(dict):
    def __init__(__self__, *,
                 end_date: _builtins.str,
                 start_date: _builtins.str,
                 time: _builtins.str):
        """
        :param _builtins.str end_date: End date before which maintenance will not take place. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        :param _builtins.str start_date: Start date after which maintenance will not take place. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        :param _builtins.str time: Time in UTC when the "deny maintenance period" starts on start_date and ends on end_date. The time is in format: HH:mm:SS, i.e., 00:00:00
        """
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "start_date", start_date)
        pulumi.set(__self__, "time", time)

    @_builtins.property
    @pulumi.getter(name="endDate")
    def end_date(self) -> _builtins.str:
        """
        End date before which maintenance will not take place. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        """
        return pulumi.get(self, "end_date")

    @_builtins.property
    @pulumi.getter(name="startDate")
    def start_date(self) -> _builtins.str:
        """
        Start date after which maintenance will not take place. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        """
        return pulumi.get(self, "start_date")

    @_builtins.property
    @pulumi.getter
    def time(self) -> _builtins.str:
        """
        Time in UTC when the "deny maintenance period" starts on start_date and ends on end_date. The time is in format: HH:mm:SS, i.e., 00:00:00
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingFinalBackupConfigResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 retention_days: _builtins.int):
        """
        :param _builtins.bool enabled: When this parameter is set to true, the final backup is enabled for the instance
        :param _builtins.int retention_days: The number of days to retain the final backup after the instance deletion. The valid range is between 1 and 365. For instances managed by BackupDR, the valid range is between 1 day and 99 years. The final backup will be purged at (time_of_instance_deletion + retention_days).
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "retention_days", retention_days)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        When this parameter is set to true, the final backup is enabled for the instance
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> _builtins.int:
        """
        The number of days to retain the final backup after the instance deletion. The valid range is between 1 and 365. For instances managed by BackupDR, the valid range is between 1 day and 99 years. The final backup will be purged at (time_of_instance_deletion + retention_days).
        """
        return pulumi.get(self, "retention_days")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingInsightsConfigResult(dict):
    def __init__(__self__, *,
                 query_insights_enabled: _builtins.bool,
                 query_plans_per_minute: _builtins.int,
                 query_string_length: _builtins.int,
                 record_application_tags: _builtins.bool,
                 record_client_address: _builtins.bool):
        """
        :param _builtins.bool query_insights_enabled: True if Query Insights feature is enabled.
        :param _builtins.int query_plans_per_minute: Number of query execution plans captured by Insights per minute for all queries combined. Between 0 and 20. Default to 5. For Enterprise Plus instances, from 0 to 200.
        :param _builtins.int query_string_length: Maximum query length stored in bytes. Between 256 and 4500. Default to 1024. For Enterprise Plus instances, from 1 to 1048576.
        :param _builtins.bool record_application_tags: True if Query Insights will record application tags from query when enabled.
        :param _builtins.bool record_client_address: True if Query Insights will record client address when enabled.
        """
        pulumi.set(__self__, "query_insights_enabled", query_insights_enabled)
        pulumi.set(__self__, "query_plans_per_minute", query_plans_per_minute)
        pulumi.set(__self__, "query_string_length", query_string_length)
        pulumi.set(__self__, "record_application_tags", record_application_tags)
        pulumi.set(__self__, "record_client_address", record_client_address)

    @_builtins.property
    @pulumi.getter(name="queryInsightsEnabled")
    def query_insights_enabled(self) -> _builtins.bool:
        """
        True if Query Insights feature is enabled.
        """
        return pulumi.get(self, "query_insights_enabled")

    @_builtins.property
    @pulumi.getter(name="queryPlansPerMinute")
    def query_plans_per_minute(self) -> _builtins.int:
        """
        Number of query execution plans captured by Insights per minute for all queries combined. Between 0 and 20. Default to 5. For Enterprise Plus instances, from 0 to 200.
        """
        return pulumi.get(self, "query_plans_per_minute")

    @_builtins.property
    @pulumi.getter(name="queryStringLength")
    def query_string_length(self) -> _builtins.int:
        """
        Maximum query length stored in bytes. Between 256 and 4500. Default to 1024. For Enterprise Plus instances, from 1 to 1048576.
        """
        return pulumi.get(self, "query_string_length")

    @_builtins.property
    @pulumi.getter(name="recordApplicationTags")
    def record_application_tags(self) -> _builtins.bool:
        """
        True if Query Insights will record application tags from query when enabled.
        """
        return pulumi.get(self, "record_application_tags")

    @_builtins.property
    @pulumi.getter(name="recordClientAddress")
    def record_client_address(self) -> _builtins.bool:
        """
        True if Query Insights will record client address when enabled.
        """
        return pulumi.get(self, "record_client_address")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingIpConfigurationResult(dict):
    def __init__(__self__, *,
                 allocated_ip_range: _builtins.str,
                 authorized_networks: Sequence['outputs.GetDatabaseInstancesInstanceSettingIpConfigurationAuthorizedNetworkResult'],
                 custom_subject_alternative_names: Sequence[_builtins.str],
                 enable_private_path_for_google_cloud_services: _builtins.bool,
                 ipv4_enabled: _builtins.bool,
                 private_network: _builtins.str,
                 psc_configs: Sequence['outputs.GetDatabaseInstancesInstanceSettingIpConfigurationPscConfigResult'],
                 server_ca_mode: _builtins.str,
                 server_ca_pool: _builtins.str,
                 ssl_mode: _builtins.str):
        """
        :param _builtins.str allocated_ip_range: The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the instance ip will be created in the allocated range. The range name must comply with RFC 1035. Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        :param Sequence[_builtins.str] custom_subject_alternative_names: The custom subject alternative names for an instance with "CUSTOMER_MANAGED_CAS_CA" as the "server_ca_mode".
        :param _builtins.bool enable_private_path_for_google_cloud_services: Whether Google Cloud services such as BigQuery are allowed to access data in this Cloud SQL instance over a private IP connection. SQLSERVER database type is not supported.
        :param _builtins.bool ipv4_enabled: Whether this Cloud SQL instance should be assigned a public IPV4 address. At least ipv4_enabled must be enabled or a private_network must be configured.
        :param _builtins.str private_network: The VPC network from which the Cloud SQL instance is accessible for private IP. For example, projects/myProject/global/networks/default. Specifying a network enables private IP. At least ipv4_enabled must be enabled or a private_network must be configured. This setting can be updated, but it cannot be removed after it is set.
        :param Sequence['GetDatabaseInstancesInstanceSettingIpConfigurationPscConfigArgs'] psc_configs: PSC settings for a Cloud SQL instance.
        :param _builtins.str server_ca_mode: Specify how the server certificate's Certificate Authority is hosted.
        :param _builtins.str server_ca_pool: The resource name of the server CA pool for an instance with "CUSTOMER_MANAGED_CAS_CA" as the "server_ca_mode".
        :param _builtins.str ssl_mode: Specify how SSL connection should be enforced in DB connections.
        """
        pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        pulumi.set(__self__, "authorized_networks", authorized_networks)
        pulumi.set(__self__, "custom_subject_alternative_names", custom_subject_alternative_names)
        pulumi.set(__self__, "enable_private_path_for_google_cloud_services", enable_private_path_for_google_cloud_services)
        pulumi.set(__self__, "ipv4_enabled", ipv4_enabled)
        pulumi.set(__self__, "private_network", private_network)
        pulumi.set(__self__, "psc_configs", psc_configs)
        pulumi.set(__self__, "server_ca_mode", server_ca_mode)
        pulumi.set(__self__, "server_ca_pool", server_ca_pool)
        pulumi.set(__self__, "ssl_mode", ssl_mode)

    @_builtins.property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> _builtins.str:
        """
        The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the instance ip will be created in the allocated range. The range name must comply with RFC 1035. Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        """
        return pulumi.get(self, "allocated_ip_range")

    @_builtins.property
    @pulumi.getter(name="authorizedNetworks")
    def authorized_networks(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingIpConfigurationAuthorizedNetworkResult']:
        return pulumi.get(self, "authorized_networks")

    @_builtins.property
    @pulumi.getter(name="customSubjectAlternativeNames")
    def custom_subject_alternative_names(self) -> Sequence[_builtins.str]:
        """
        The custom subject alternative names for an instance with "CUSTOMER_MANAGED_CAS_CA" as the "server_ca_mode".
        """
        return pulumi.get(self, "custom_subject_alternative_names")

    @_builtins.property
    @pulumi.getter(name="enablePrivatePathForGoogleCloudServices")
    def enable_private_path_for_google_cloud_services(self) -> _builtins.bool:
        """
        Whether Google Cloud services such as BigQuery are allowed to access data in this Cloud SQL instance over a private IP connection. SQLSERVER database type is not supported.
        """
        return pulumi.get(self, "enable_private_path_for_google_cloud_services")

    @_builtins.property
    @pulumi.getter(name="ipv4Enabled")
    def ipv4_enabled(self) -> _builtins.bool:
        """
        Whether this Cloud SQL instance should be assigned a public IPV4 address. At least ipv4_enabled must be enabled or a private_network must be configured.
        """
        return pulumi.get(self, "ipv4_enabled")

    @_builtins.property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> _builtins.str:
        """
        The VPC network from which the Cloud SQL instance is accessible for private IP. For example, projects/myProject/global/networks/default. Specifying a network enables private IP. At least ipv4_enabled must be enabled or a private_network must be configured. This setting can be updated, but it cannot be removed after it is set.
        """
        return pulumi.get(self, "private_network")

    @_builtins.property
    @pulumi.getter(name="pscConfigs")
    def psc_configs(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingIpConfigurationPscConfigResult']:
        """
        PSC settings for a Cloud SQL instance.
        """
        return pulumi.get(self, "psc_configs")

    @_builtins.property
    @pulumi.getter(name="serverCaMode")
    def server_ca_mode(self) -> _builtins.str:
        """
        Specify how the server certificate's Certificate Authority is hosted.
        """
        return pulumi.get(self, "server_ca_mode")

    @_builtins.property
    @pulumi.getter(name="serverCaPool")
    def server_ca_pool(self) -> _builtins.str:
        """
        The resource name of the server CA pool for an instance with "CUSTOMER_MANAGED_CAS_CA" as the "server_ca_mode".
        """
        return pulumi.get(self, "server_ca_pool")

    @_builtins.property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> _builtins.str:
        """
        Specify how SSL connection should be enforced in DB connections.
        """
        return pulumi.get(self, "ssl_mode")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingIpConfigurationAuthorizedNetworkResult(dict):
    def __init__(__self__, *,
                 expiration_time: _builtins.str,
                 name: _builtins.str,
                 value: _builtins.str):
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> _builtins.str:
        return pulumi.get(self, "expiration_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingIpConfigurationPscConfigResult(dict):
    def __init__(__self__, *,
                 allowed_consumer_projects: Sequence[_builtins.str],
                 network_attachment_uri: _builtins.str,
                 psc_auto_connections: Sequence['outputs.GetDatabaseInstancesInstanceSettingIpConfigurationPscConfigPscAutoConnectionResult'],
                 psc_enabled: _builtins.bool):
        """
        :param Sequence[_builtins.str] allowed_consumer_projects: List of consumer projects that are allow-listed for PSC connections to this instance. This instance can be connected to with PSC from any network in these projects. Each consumer project in this list may be represented by a project number (numeric) or by a project id (alphanumeric).
        :param _builtins.str network_attachment_uri: Name of network attachment resource used to authorize a producer service to connect a PSC interface to the consumer's VPC. For example: "projects/myProject/regions/myRegion/networkAttachments/myNetworkAttachment". This is required to enable outbound connection on a PSC instance.
        :param Sequence['GetDatabaseInstancesInstanceSettingIpConfigurationPscConfigPscAutoConnectionArgs'] psc_auto_connections: A comma-separated list of networks or a comma-separated list of network-project pairs. Each project in this list is represented by a project number (numeric) or by a project ID (alphanumeric). This allows Private Service Connect connections to be created automatically for the specified networks.
        :param _builtins.bool psc_enabled: Whether PSC connectivity is enabled for this instance.
        """
        pulumi.set(__self__, "allowed_consumer_projects", allowed_consumer_projects)
        pulumi.set(__self__, "network_attachment_uri", network_attachment_uri)
        pulumi.set(__self__, "psc_auto_connections", psc_auto_connections)
        pulumi.set(__self__, "psc_enabled", psc_enabled)

    @_builtins.property
    @pulumi.getter(name="allowedConsumerProjects")
    def allowed_consumer_projects(self) -> Sequence[_builtins.str]:
        """
        List of consumer projects that are allow-listed for PSC connections to this instance. This instance can be connected to with PSC from any network in these projects. Each consumer project in this list may be represented by a project number (numeric) or by a project id (alphanumeric).
        """
        return pulumi.get(self, "allowed_consumer_projects")

    @_builtins.property
    @pulumi.getter(name="networkAttachmentUri")
    def network_attachment_uri(self) -> _builtins.str:
        """
        Name of network attachment resource used to authorize a producer service to connect a PSC interface to the consumer's VPC. For example: "projects/myProject/regions/myRegion/networkAttachments/myNetworkAttachment". This is required to enable outbound connection on a PSC instance.
        """
        return pulumi.get(self, "network_attachment_uri")

    @_builtins.property
    @pulumi.getter(name="pscAutoConnections")
    def psc_auto_connections(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingIpConfigurationPscConfigPscAutoConnectionResult']:
        """
        A comma-separated list of networks or a comma-separated list of network-project pairs. Each project in this list is represented by a project number (numeric) or by a project ID (alphanumeric). This allows Private Service Connect connections to be created automatically for the specified networks.
        """
        return pulumi.get(self, "psc_auto_connections")

    @_builtins.property
    @pulumi.getter(name="pscEnabled")
    def psc_enabled(self) -> _builtins.bool:
        """
        Whether PSC connectivity is enabled for this instance.
        """
        return pulumi.get(self, "psc_enabled")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingIpConfigurationPscConfigPscAutoConnectionResult(dict):
    def __init__(__self__, *,
                 consumer_network: _builtins.str,
                 consumer_network_status: _builtins.str,
                 consumer_service_project_id: _builtins.str,
                 ip_address: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str consumer_network: The consumer network of this consumer endpoint. This must be a resource path that includes both the host project and the network name. The consumer host project of this network might be different from the consumer service project.
        :param _builtins.str consumer_network_status: The connection policy status of the consumer network.
        :param _builtins.str consumer_service_project_id: The project ID of consumer service project of this consumer endpoint.
        :param _builtins.str ip_address: The IP address of the consumer endpoint.
        :param _builtins.str status: The connection status of the consumer endpoint.
        """
        pulumi.set(__self__, "consumer_network", consumer_network)
        pulumi.set(__self__, "consumer_network_status", consumer_network_status)
        pulumi.set(__self__, "consumer_service_project_id", consumer_service_project_id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="consumerNetwork")
    def consumer_network(self) -> _builtins.str:
        """
        The consumer network of this consumer endpoint. This must be a resource path that includes both the host project and the network name. The consumer host project of this network might be different from the consumer service project.
        """
        return pulumi.get(self, "consumer_network")

    @_builtins.property
    @pulumi.getter(name="consumerNetworkStatus")
    def consumer_network_status(self) -> _builtins.str:
        """
        The connection policy status of the consumer network.
        """
        return pulumi.get(self, "consumer_network_status")

    @_builtins.property
    @pulumi.getter(name="consumerServiceProjectId")
    def consumer_service_project_id(self) -> _builtins.str:
        """
        The project ID of consumer service project of this consumer endpoint.
        """
        return pulumi.get(self, "consumer_service_project_id")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The IP address of the consumer endpoint.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The connection status of the consumer endpoint.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingLocationPreferenceResult(dict):
    def __init__(__self__, *,
                 follow_gae_application: _builtins.str,
                 secondary_zone: _builtins.str,
                 zone: _builtins.str):
        """
        :param _builtins.str follow_gae_application: A Google App Engine application whose zone to remain in. Must be in the same region as this instance.
        :param _builtins.str secondary_zone: The preferred Compute Engine zone for the secondary/failover
        :param _builtins.str zone: To filter out the Cloud SQL instances which are located in the specified zone. This zone refers to the Compute Engine zone that the instance is currently serving from.
        """
        pulumi.set(__self__, "follow_gae_application", follow_gae_application)
        pulumi.set(__self__, "secondary_zone", secondary_zone)
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="followGaeApplication")
    def follow_gae_application(self) -> _builtins.str:
        """
        A Google App Engine application whose zone to remain in. Must be in the same region as this instance.
        """
        return pulumi.get(self, "follow_gae_application")

    @_builtins.property
    @pulumi.getter(name="secondaryZone")
    def secondary_zone(self) -> _builtins.str:
        """
        The preferred Compute Engine zone for the secondary/failover
        """
        return pulumi.get(self, "secondary_zone")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> _builtins.str:
        """
        To filter out the Cloud SQL instances which are located in the specified zone. This zone refers to the Compute Engine zone that the instance is currently serving from.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 day: _builtins.int,
                 hour: _builtins.int,
                 update_track: _builtins.str):
        """
        :param _builtins.int day: Day of week (1-7), starting on Monday
        :param _builtins.int hour: Hour of day (0-23), ignored if day not set
        :param _builtins.str update_track: Receive updates after one week (canary) or after two weeks (stable) or after five weeks (week5) of notification.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "hour", hour)
        pulumi.set(__self__, "update_track", update_track)

    @_builtins.property
    @pulumi.getter
    def day(self) -> _builtins.int:
        """
        Day of week (1-7), starting on Monday
        """
        return pulumi.get(self, "day")

    @_builtins.property
    @pulumi.getter
    def hour(self) -> _builtins.int:
        """
        Hour of day (0-23), ignored if day not set
        """
        return pulumi.get(self, "hour")

    @_builtins.property
    @pulumi.getter(name="updateTrack")
    def update_track(self) -> _builtins.str:
        """
        Receive updates after one week (canary) or after two weeks (stable) or after five weeks (week5) of notification.
        """
        return pulumi.get(self, "update_track")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingPasswordValidationPolicyResult(dict):
    def __init__(__self__, *,
                 complexity: _builtins.str,
                 disallow_username_substring: _builtins.bool,
                 enable_password_policy: _builtins.bool,
                 min_length: _builtins.int,
                 password_change_interval: _builtins.str,
                 reuse_interval: _builtins.int):
        """
        :param _builtins.str complexity: Password complexity.
        :param _builtins.bool disallow_username_substring: Disallow username as a part of the password.
        :param _builtins.bool enable_password_policy: Whether the password policy is enabled or not.
        :param _builtins.int min_length: Minimum number of characters allowed.
        :param _builtins.str password_change_interval: Minimum interval after which the password can be changed. This flag is only supported for PostgresSQL.
        :param _builtins.int reuse_interval: Number of previous passwords that cannot be reused.
        """
        pulumi.set(__self__, "complexity", complexity)
        pulumi.set(__self__, "disallow_username_substring", disallow_username_substring)
        pulumi.set(__self__, "enable_password_policy", enable_password_policy)
        pulumi.set(__self__, "min_length", min_length)
        pulumi.set(__self__, "password_change_interval", password_change_interval)
        pulumi.set(__self__, "reuse_interval", reuse_interval)

    @_builtins.property
    @pulumi.getter
    def complexity(self) -> _builtins.str:
        """
        Password complexity.
        """
        return pulumi.get(self, "complexity")

    @_builtins.property
    @pulumi.getter(name="disallowUsernameSubstring")
    def disallow_username_substring(self) -> _builtins.bool:
        """
        Disallow username as a part of the password.
        """
        return pulumi.get(self, "disallow_username_substring")

    @_builtins.property
    @pulumi.getter(name="enablePasswordPolicy")
    def enable_password_policy(self) -> _builtins.bool:
        """
        Whether the password policy is enabled or not.
        """
        return pulumi.get(self, "enable_password_policy")

    @_builtins.property
    @pulumi.getter(name="minLength")
    def min_length(self) -> _builtins.int:
        """
        Minimum number of characters allowed.
        """
        return pulumi.get(self, "min_length")

    @_builtins.property
    @pulumi.getter(name="passwordChangeInterval")
    def password_change_interval(self) -> _builtins.str:
        """
        Minimum interval after which the password can be changed. This flag is only supported for PostgresSQL.
        """
        return pulumi.get(self, "password_change_interval")

    @_builtins.property
    @pulumi.getter(name="reuseInterval")
    def reuse_interval(self) -> _builtins.int:
        """
        Number of previous passwords that cannot be reused.
        """
        return pulumi.get(self, "reuse_interval")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingSqlServerAuditConfigResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 retention_interval: _builtins.str,
                 upload_interval: _builtins.str):
        """
        :param _builtins.str bucket: The name of the destination bucket (e.g., gs://mybucket).
        :param _builtins.str retention_interval: How long to keep generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s"..
        :param _builtins.str upload_interval: How often to upload generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "retention_interval", retention_interval)
        pulumi.set(__self__, "upload_interval", upload_interval)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The name of the destination bucket (e.g., gs://mybucket).
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="retentionInterval")
    def retention_interval(self) -> _builtins.str:
        """
        How long to keep generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s"..
        """
        return pulumi.get(self, "retention_interval")

    @_builtins.property
    @pulumi.getter(name="uploadInterval")
    def upload_interval(self) -> _builtins.str:
        """
        How often to upload generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "upload_interval")


@pulumi.output_type
class GetDatabasesDatabaseResult(dict):
    def __init__(__self__, *,
                 charset: _builtins.str,
                 collation: _builtins.str,
                 deletion_policy: _builtins.str,
                 instance: _builtins.str,
                 name: _builtins.str,
                 project: _builtins.str,
                 self_link: _builtins.str):
        """
        :param _builtins.str charset: The charset value. See MySQL's
               [Supported Character Sets and Collations](https://dev.mysql.com/doc/refman/5.7/en/charset-charsets.html)
               and Postgres' [Character Set Support](https://www.postgresql.org/docs/9.6/static/multibyte.html)
               for more details and supported values. Postgres databases only support
               a value of 'UTF8' at creation time.
        :param _builtins.str collation: The collation value. See MySQL's
               [Supported Character Sets and Collations](https://dev.mysql.com/doc/refman/5.7/en/charset-charsets.html)
               and Postgres' [Collation Support](https://www.postgresql.org/docs/9.6/static/collation.html)
               for more details and supported values. Postgres databases only support
               a value of 'en_US.UTF8' at creation time.
        :param _builtins.str deletion_policy: The deletion policy for the database. Setting ABANDON allows the resource
               to be abandoned rather than deleted. This is useful for Postgres, where databases cannot be
               deleted from the API if there are users other than cloudsqlsuperuser with access. Possible
               values are: "ABANDON", "DELETE". Defaults to "DELETE".
        :param _builtins.str instance: The name of the Cloud SQL database instance in which the database belongs.
        :param _builtins.str name: The name of the database in the Cloud SQL instance.
               This does not include the project ID or instance name.
        :param _builtins.str project: The ID of the project in which the instance belongs.
               
               > **Note** This datasource performs client-side sorting to provide consistent ordering of the databases.
        """
        pulumi.set(__self__, "charset", charset)
        pulumi.set(__self__, "collation", collation)
        pulumi.set(__self__, "deletion_policy", deletion_policy)
        pulumi.set(__self__, "instance", instance)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "self_link", self_link)

    @_builtins.property
    @pulumi.getter
    def charset(self) -> _builtins.str:
        """
        The charset value. See MySQL's
        [Supported Character Sets and Collations](https://dev.mysql.com/doc/refman/5.7/en/charset-charsets.html)
        and Postgres' [Character Set Support](https://www.postgresql.org/docs/9.6/static/multibyte.html)
        for more details and supported values. Postgres databases only support
        a value of 'UTF8' at creation time.
        """
        return pulumi.get(self, "charset")

    @_builtins.property
    @pulumi.getter
    def collation(self) -> _builtins.str:
        """
        The collation value. See MySQL's
        [Supported Character Sets and Collations](https://dev.mysql.com/doc/refman/5.7/en/charset-charsets.html)
        and Postgres' [Collation Support](https://www.postgresql.org/docs/9.6/static/collation.html)
        for more details and supported values. Postgres databases only support
        a value of 'en_US.UTF8' at creation time.
        """
        return pulumi.get(self, "collation")

    @_builtins.property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> _builtins.str:
        """
        The deletion policy for the database. Setting ABANDON allows the resource
        to be abandoned rather than deleted. This is useful for Postgres, where databases cannot be
        deleted from the API if there are users other than cloudsqlsuperuser with access. Possible
        values are: "ABANDON", "DELETE". Defaults to "DELETE".
        """
        return pulumi.get(self, "deletion_policy")

    @_builtins.property
    @pulumi.getter
    def instance(self) -> _builtins.str:
        """
        The name of the Cloud SQL database instance in which the database belongs.
        """
        return pulumi.get(self, "instance")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the database in the Cloud SQL instance.
        This does not include the project ID or instance name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The ID of the project in which the instance belongs.

        > **Note** This datasource performs client-side sorting to provide consistent ordering of the databases.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> _builtins.str:
        return pulumi.get(self, "self_link")


@pulumi.output_type
class GetTiersTierResult(dict):
    def __init__(__self__, *,
                 disk_quota: _builtins.int,
                 ram: _builtins.int,
                 regions: Sequence[_builtins.str],
                 tier: _builtins.str):
        """
        :param _builtins.int disk_quota: The maximum disk size of this tier in bytes.
        :param _builtins.int ram: The maximum ram usage of this tier in bytes.
        :param Sequence[_builtins.str] regions: The applicable regions for this tier.
        :param _builtins.str tier: An identifier for the machine type, for example, db-custom-1-3840.
        """
        pulumi.set(__self__, "disk_quota", disk_quota)
        pulumi.set(__self__, "ram", ram)
        pulumi.set(__self__, "regions", regions)
        pulumi.set(__self__, "tier", tier)

    @_builtins.property
    @pulumi.getter(name="diskQuota")
    def disk_quota(self) -> _builtins.int:
        """
        The maximum disk size of this tier in bytes.
        """
        return pulumi.get(self, "disk_quota")

    @_builtins.property
    @pulumi.getter
    def ram(self) -> _builtins.int:
        """
        The maximum ram usage of this tier in bytes.
        """
        return pulumi.get(self, "ram")

    @_builtins.property
    @pulumi.getter
    def regions(self) -> Sequence[_builtins.str]:
        """
        The applicable regions for this tier.
        """
        return pulumi.get(self, "regions")

    @_builtins.property
    @pulumi.getter
    def tier(self) -> _builtins.str:
        """
        An identifier for the machine type, for example, db-custom-1-3840.
        """
        return pulumi.get(self, "tier")


