# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetObjectSignedUrlResult',
    'AwaitableGetObjectSignedUrlResult',
    'get_object_signed_url',
    'get_object_signed_url_output',
]

@pulumi.output_type
class GetObjectSignedUrlResult:
    """
    A collection of values returned by getObjectSignedUrl.
    """
    def __init__(__self__, bucket=None, content_md5=None, content_type=None, credentials=None, duration=None, extension_headers=None, http_method=None, id=None, path=None, signed_url=None):
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if content_md5 and not isinstance(content_md5, str):
            raise TypeError("Expected argument 'content_md5' to be a str")
        pulumi.set(__self__, "content_md5", content_md5)
        if content_type and not isinstance(content_type, str):
            raise TypeError("Expected argument 'content_type' to be a str")
        pulumi.set(__self__, "content_type", content_type)
        if credentials and not isinstance(credentials, str):
            raise TypeError("Expected argument 'credentials' to be a str")
        pulumi.set(__self__, "credentials", credentials)
        if duration and not isinstance(duration, str):
            raise TypeError("Expected argument 'duration' to be a str")
        pulumi.set(__self__, "duration", duration)
        if extension_headers and not isinstance(extension_headers, dict):
            raise TypeError("Expected argument 'extension_headers' to be a dict")
        pulumi.set(__self__, "extension_headers", extension_headers)
        if http_method and not isinstance(http_method, str):
            raise TypeError("Expected argument 'http_method' to be a str")
        pulumi.set(__self__, "http_method", http_method)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if path and not isinstance(path, str):
            raise TypeError("Expected argument 'path' to be a str")
        pulumi.set(__self__, "path", path)
        if signed_url and not isinstance(signed_url, str):
            raise TypeError("Expected argument 'signed_url' to be a str")
        pulumi.set(__self__, "signed_url", signed_url)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "content_md5")

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "credentials")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="extensionHeaders")
    def extension_headers(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "extension_headers")

    @_builtins.property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "http_method")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="signedUrl")
    def signed_url(self) -> _builtins.str:
        """
        The signed URL that can be used to access the storage object without authentication.
        """
        return pulumi.get(self, "signed_url")


class AwaitableGetObjectSignedUrlResult(GetObjectSignedUrlResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetObjectSignedUrlResult(
            bucket=self.bucket,
            content_md5=self.content_md5,
            content_type=self.content_type,
            credentials=self.credentials,
            duration=self.duration,
            extension_headers=self.extension_headers,
            http_method=self.http_method,
            id=self.id,
            path=self.path,
            signed_url=self.signed_url)


def get_object_signed_url(bucket: Optional[_builtins.str] = None,
                          content_md5: Optional[_builtins.str] = None,
                          content_type: Optional[_builtins.str] = None,
                          credentials: Optional[_builtins.str] = None,
                          duration: Optional[_builtins.str] = None,
                          extension_headers: Optional[Mapping[str, _builtins.str]] = None,
                          http_method: Optional[_builtins.str] = None,
                          path: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetObjectSignedUrlResult:
    """
    The Google Cloud storage signed URL data source generates a signed URL for a given storage object. Signed URLs provide a way to give time-limited read or write access to anyone in possession of the URL, regardless of whether they have a Google account.

    For more info about signed URL's is available [here](https://cloud.google.com/storage/docs/access-control/signed-urls).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    artifact = gcp.storage.get_object_signed_url(bucket="install_binaries",
        path="path/to/install_file.bin")
    vm = gcp.compute.Instance("vm", name="vm")
    ```

    ## Full Example

    ```python
    import pulumi
    import pulumi_gcp as gcp
    import pulumi_std as std

    get_url = gcp.storage.get_object_signed_url(bucket="fried_chicken",
        path="path/to/file",
        content_md5="pRviqwS4c4OTJRTe03FD1w==",
        content_type="text/plain",
        duration="2d",
        credentials=std.file(input="path/to/credentials.json").result,
        extension_headers={
            "x-goog-if-generation-match": "1",
        })
    ```


    :param _builtins.str bucket: The name of the bucket to read the object from
    :param _builtins.str content_md5: The [MD5 digest](https://cloud.google.com/storage/docs/hashes-etags#_MD5) value in Base64.
           Typically retrieved from `google_storage_bucket_object.object.md5hash` attribute.
           If you provide this in the datasource, the client (e.g. browser, curl) must provide the `Content-MD5` HTTP header with this same value in its request.
    :param _builtins.str content_type: If you specify this in the datasource, the client must provide the `Content-Type` HTTP header with the same value in its request.
    :param _builtins.str credentials: What Google service account credentials json should be used to sign the URL.
           This data source checks the following locations for credentials, in order of preference: data source `credentials` attribute, provider `credentials` attribute and finally the GOOGLE_APPLICATION_CREDENTIALS environment variable.
           
           > **NOTE** the default google credentials configured by `gcloud` sdk or the service account associated with a compute instance cannot be used, because these do not include the private key required to sign the URL. A valid `json` service account credentials key file must be used, as generated via Google cloud console.
    :param _builtins.str duration: For how long shall the signed URL be valid (defaults to 1 hour - i.e. `1h`).
           See [here](https://golang.org/pkg/time/#ParseDuration) for info on valid duration formats.
    :param Mapping[str, _builtins.str] extension_headers: As needed. The server checks to make sure that the client provides matching values in requests using the signed URL.
           Any header starting with `x-goog-` is accepted but see the [Google Docs](https://cloud.google.com/storage/docs/xml-api/reference-headers) for list of headers that are supported by Google.
    :param _builtins.str http_method: What HTTP Method will the signed URL allow (defaults to `GET`)
    :param _builtins.str path: The full path to the object inside the bucket
    """
    __args__ = dict()
    __args__['bucket'] = bucket
    __args__['contentMd5'] = content_md5
    __args__['contentType'] = content_type
    __args__['credentials'] = credentials
    __args__['duration'] = duration
    __args__['extensionHeaders'] = extension_headers
    __args__['httpMethod'] = http_method
    __args__['path'] = path
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:storage/getObjectSignedUrl:getObjectSignedUrl', __args__, opts=opts, typ=GetObjectSignedUrlResult).value

    return AwaitableGetObjectSignedUrlResult(
        bucket=pulumi.get(__ret__, 'bucket'),
        content_md5=pulumi.get(__ret__, 'content_md5'),
        content_type=pulumi.get(__ret__, 'content_type'),
        credentials=pulumi.get(__ret__, 'credentials'),
        duration=pulumi.get(__ret__, 'duration'),
        extension_headers=pulumi.get(__ret__, 'extension_headers'),
        http_method=pulumi.get(__ret__, 'http_method'),
        id=pulumi.get(__ret__, 'id'),
        path=pulumi.get(__ret__, 'path'),
        signed_url=pulumi.get(__ret__, 'signed_url'))
def get_object_signed_url_output(bucket: Optional[pulumi.Input[_builtins.str]] = None,
                                 content_md5: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 content_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 credentials: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 duration: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 extension_headers: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                                 http_method: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 path: Optional[pulumi.Input[_builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetObjectSignedUrlResult]:
    """
    The Google Cloud storage signed URL data source generates a signed URL for a given storage object. Signed URLs provide a way to give time-limited read or write access to anyone in possession of the URL, regardless of whether they have a Google account.

    For more info about signed URL's is available [here](https://cloud.google.com/storage/docs/access-control/signed-urls).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    artifact = gcp.storage.get_object_signed_url(bucket="install_binaries",
        path="path/to/install_file.bin")
    vm = gcp.compute.Instance("vm", name="vm")
    ```

    ## Full Example

    ```python
    import pulumi
    import pulumi_gcp as gcp
    import pulumi_std as std

    get_url = gcp.storage.get_object_signed_url(bucket="fried_chicken",
        path="path/to/file",
        content_md5="pRviqwS4c4OTJRTe03FD1w==",
        content_type="text/plain",
        duration="2d",
        credentials=std.file(input="path/to/credentials.json").result,
        extension_headers={
            "x-goog-if-generation-match": "1",
        })
    ```


    :param _builtins.str bucket: The name of the bucket to read the object from
    :param _builtins.str content_md5: The [MD5 digest](https://cloud.google.com/storage/docs/hashes-etags#_MD5) value in Base64.
           Typically retrieved from `google_storage_bucket_object.object.md5hash` attribute.
           If you provide this in the datasource, the client (e.g. browser, curl) must provide the `Content-MD5` HTTP header with this same value in its request.
    :param _builtins.str content_type: If you specify this in the datasource, the client must provide the `Content-Type` HTTP header with the same value in its request.
    :param _builtins.str credentials: What Google service account credentials json should be used to sign the URL.
           This data source checks the following locations for credentials, in order of preference: data source `credentials` attribute, provider `credentials` attribute and finally the GOOGLE_APPLICATION_CREDENTIALS environment variable.
           
           > **NOTE** the default google credentials configured by `gcloud` sdk or the service account associated with a compute instance cannot be used, because these do not include the private key required to sign the URL. A valid `json` service account credentials key file must be used, as generated via Google cloud console.
    :param _builtins.str duration: For how long shall the signed URL be valid (defaults to 1 hour - i.e. `1h`).
           See [here](https://golang.org/pkg/time/#ParseDuration) for info on valid duration formats.
    :param Mapping[str, _builtins.str] extension_headers: As needed. The server checks to make sure that the client provides matching values in requests using the signed URL.
           Any header starting with `x-goog-` is accepted but see the [Google Docs](https://cloud.google.com/storage/docs/xml-api/reference-headers) for list of headers that are supported by Google.
    :param _builtins.str http_method: What HTTP Method will the signed URL allow (defaults to `GET`)
    :param _builtins.str path: The full path to the object inside the bucket
    """
    __args__ = dict()
    __args__['bucket'] = bucket
    __args__['contentMd5'] = content_md5
    __args__['contentType'] = content_type
    __args__['credentials'] = credentials
    __args__['duration'] = duration
    __args__['extensionHeaders'] = extension_headers
    __args__['httpMethod'] = http_method
    __args__['path'] = path
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:storage/getObjectSignedUrl:getObjectSignedUrl', __args__, opts=opts, typ=GetObjectSignedUrlResult)
    return __ret__.apply(lambda __response__: GetObjectSignedUrlResult(
        bucket=pulumi.get(__response__, 'bucket'),
        content_md5=pulumi.get(__response__, 'content_md5'),
        content_type=pulumi.get(__response__, 'content_type'),
        credentials=pulumi.get(__response__, 'credentials'),
        duration=pulumi.get(__response__, 'duration'),
        extension_headers=pulumi.get(__response__, 'extension_headers'),
        http_method=pulumi.get(__response__, 'http_method'),
        id=pulumi.get(__response__, 'id'),
        path=pulumi.get(__response__, 'path'),
        signed_url=pulumi.get(__response__, 'signed_url')))
